<!DOCTYPE html>
<html lang="en" xmlns:og="http://ogp.me/ns#">

  <head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Branding, Marketing, Printing & Websites">
    <meta name="keywords" content="Branding, Marketing, Printing & Websites">
    <meta name="author" content="Custom Assist Inc.">
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,300,400,500,700,900" rel="stylesheet">

    <title>Custom Assist Inc. &copy;</title>

    <!-- Favicon  -->
    <link rel="icon" href="images/logo-white.png">


    <meta name="facebook-domain-verification" content="6gj5jwk8q7l6acs7dqvneq64pl5la7" />


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://customassistinc.com/images/logo-bg.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="Custom Assist Inc. &copy;">

    <meta property="og:url" content="https://customassistinc.com/">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="Branding & Marketing">

    <meta property="og:site_name" content="Custom Assist Inc. &copy;">
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://customassistinc.com/">

    <meta name="twitter:title" content="Custom Assist Inc. &copy;">

    <meta name="twitter:description" content="Branding & Marketing">

    <meta name="twitter:image" content="https://customassistinc.com/images/logo-bg.png">

    <meta name="twitter:site" content="@CustomAssist">

    <meta name="twitter:creator" content="@CustomAssist">

    <!-- Core Style CSS -->
    <link rel="stylesheet" href="css/core-style.css">
    <link rel="stylesheet" href="css/animate.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/font-awesome.css">
    <link rel="stylesheet" href="css/jquery-ui.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/nouslider.css">
    <link rel="stylesheet" href="css/owl.carousel.css">
    <link rel="stylesheet" href="css/themify-icons.css">

    <link rel="stylesheet" href="css/bootstrap.min.css">
     <link rel="stylesheet" href="css/font-awesome.min.css">
     <link rel="stylesheet" href="css/aos.css">
     <link rel="stylesheet" href="css/owl.carousel.min.css">
     <link rel="stylesheet" href="css/owl.carousel1.min.css">
     <link rel="stylesheet" href="css/owl.theme.default.min.css">
     <link rel="stylesheet" href="css/style.css">

    <!-- Responsive CSS -->
    <link href="css/responsive.css" rel="stylesheet">


    <!-- Additional CSS Files -->
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.css">

    <link rel="stylesheet" href="assets/css/customassist.css">

    <link rel="stylesheet" href="assets/css/items.css">

    <link rel="stylesheet" href="assets/css/flex-slider.css">
    
    <link rel="stylesheet prefetch" href="https://cdnjs.cloudflare.com/ajax/libs/meyer-reset/2.0/reset.min.css">
    
    <link rel="stylesheet prefetch" href="https://fonts.googleapis.com/css?family=Open+Sans:400,300,700&amp;subset=latin,cyrillic">


    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="css/Attention/blink.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/bounce.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/flicker.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/jello.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/pulsate.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/shake.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/vibrate.css">
    <link rel="stylesheet" type="text/css" href="css/Attention/wobble.css">
    <link rel="stylesheet" type="text/css" href="css/Background/background.css">
    <link rel="stylesheet" type="text/css" href="css/Bounce/bounce.css">
    <link rel="stylesheet" type="text/css" href="css/Text/blur-out.css">
    <link rel="stylesheet" type="text/css" href="css/Text/flicker-glow.css">
    <link rel="stylesheet" type="text/css" href="css/Text/focus-in.css">
    <link rel="stylesheet" type="text/css" href="css/Text/tracking-in.css">
    <link rel="stylesheet" type="text/css" href="css/Text/tracking-out.css">
    
    <!--Icons-->
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    
    <script src="https://kit.fontawesome.com/yourcode.js" crossorigin="anonymous"></script>



    <!-- Global site tag (gtag.js) - Google Analytics --> 

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-VVPMJ4GE7K"></script>

    <script> window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', 'G-VVPMJ4GE7K'); </script>







    <style type="text/css">
        .custom {
          font-family:'Roboto';
          text-transform: uppercase;
            font-weight: bold;
            font-size: 20px;
            color: dodgerblue;
            margin-left: 40px;
  background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5);
   background-size: 400% 400%;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
    -webkit-animation: gradient 8s ease infinite;
            animation: gradient 8s ease infinite;
        }

        .slogan {
          text-align: center;
           font-size: 12px;
           margin-left: 30px;
        }




/* If the screen size is 600px wide or less */
@media screen and (max-width: 600px) {
  .custom {
    float: left;
            margin-left: 0;
        }
 }


/* 
---------------------------------------------
header
--------------------------------------------- 
*/
.header-area {
  position: fixed;
  top: 30px;
  left: 0px;
  right: 0px;
  z-index: 100;
  height: 100px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.header-area .main-nav {
  box-shadow: 0px 0px 15px rgba(0,0,0,0.1);
  border-radius: 40px;
  min-height: 60px;
  background: #fff;
}

.header-area .main-nav .logo {
  float: left;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.header-area .main-nav .logo img {
  margin-top: -5px;
  margin-left: -14px;
  width: 60px;
  height: 60px;
  padding: 2px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.header-area .main-nav .nav {
  float: right;
  margin-top: 27px;
  margin-left: 0px;
  margin-right: 30px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
  position: relative;
  z-index: 999;
}

.header-area .main-nav .nav li {
  padding-left: 20px;
  padding-right: 20px;
}

.header-area .main-nav .nav li:last-child {
  padding-right: 0px;
}

.header-area .main-nav .nav li a {
  display: block;
  font-weight: 500;
  font-size: 13px;
  color: #fff;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
  height: 40px;
  line-height: 40px;
  border: transparent;
  letter-spacing: 1px;
}

.header-area .main-nav .nav li a:hover {
  color: purple;
}

.header-area .main-nav .menu-trigger {
  cursor: pointer;
  display: block;
  position: absolute;
  top: 14px;
  width: 32px;
  height: 40px;
  text-indent: -9999em;
  z-index: 99;
  right: 30px;
  display: none;
}

.header-area .main-nav .menu-trigger span,
.header-area .main-nav .menu-trigger span:before,
.header-area .main-nav .menu-trigger span:after {
  -moz-transition: all 0.4s;
  -o-transition: all 0.4s;
  -webkit-transition: all 0.4s;
  transition: all 0.4s;
  background-color: #3B566E;
  display: block;
  position: absolute;
  width: 30px;
  height: 2px;
  left: 0;
}

.header-area .main-nav .menu-trigger span:before,
.header-area .main-nav .menu-trigger span:after {
  -moz-transition: all 0.4s;
  -o-transition: all 0.4s;
  -webkit-transition: all 0.4s;
  transition: all 0.4s;
  background-color: #3B566E;
  display: block;
  position: absolute;
  width: 30px;
  height: 2px;
  left: 0;
  width: 75%;
}

.header-area .main-nav .menu-trigger span:before,
.header-area .main-nav .menu-trigger span:after {
  content: "";
}

.header-area .main-nav .menu-trigger span {
  top: 16px;
}

.header-area .main-nav .menu-trigger span:before {
  -moz-transform-origin: 33% 100%;
  -ms-transform-origin: 33% 100%;
  -webkit-transform-origin: 33% 100%;
  transform-origin: 33% 100%;
  top: -10px;
  z-index: 10;
}

.header-area .main-nav .menu-trigger span:after {
  -moz-transform-origin: 33% 0;
  -ms-transform-origin: 33% 0;
  -webkit-transform-origin: 33% 0;
  transform-origin: 33% 0;
  top: 10px;
}

.header-area .main-nav .menu-trigger.active span,
.header-area .main-nav .menu-trigger.active span:before,
.header-area .main-nav .menu-trigger.active span:after {
  background-color: transparent;
  width: 100%;
}

.header-area .main-nav .menu-trigger.active span:before {
  -moz-transform: translateY(6px) translateX(1px) rotate(45deg);
  -ms-transform: translateY(6px) translateX(1px) rotate(45deg);
  -webkit-transform: translateY(6px) translateX(1px) rotate(45deg);
  transform: translateY(6px) translateX(1px) rotate(45deg);
  background-color: #3B566E;
}

.header-area .main-nav .menu-trigger.active span:after {
  -moz-transform: translateY(-6px) translateX(1px) rotate(-45deg);
  -ms-transform: translateY(-6px) translateX(1px) rotate(-45deg);
  -webkit-transform: translateY(-6px) translateX(1px) rotate(-45deg);
  transform: translateY(-6px) translateX(1px) rotate(-45deg);
  background-color: #3B566E;
}

.header-area.header-sticky {
  min-height: 80px;
}

.header-area.header-sticky .logo {
  margin-top: 5px;
  margin-left: 15px;
}

.header-area.header-sticky .nav {
  margin-top: 20px !important;
}

.header-area.header-sticky .nav li a {
  color: #1e1e1e;
}

.header-area.header-sticky .nav li a.active {
  color: #ff589e;
}

@media (max-width: 1200px) {
  .header-area .main-nav .nav li {
    padding-left: 12px;
    padding-right: 12px;
  }
  .header-area .main-nav:before {
    display: none;
  }
}

@media (max-width: 991px) {
  .header-area {
    padding: 0px 15px;
    height: 80px;
    box-shadow: none;
    text-align: center;
  }
  .header-area .container {
    padding: 0px;
  }
  .header-area .logo {
    margin-top: 5px !important;
    margin-left: 15px;
  }
  .header-area .menu-trigger {
    display: block !important;
  }
  .header-area .main-nav {
    overflow: hidden;
  }
  .header-area .main-nav .nav {
    float: none;
    width: 100%;
    margin-top: 80px !important;
    display: none;
    -webkit-transition: all 0s ease 0s;
    -moz-transition: all 0s ease 0s;
    -o-transition: all 0s ease 0s;
    transition: all 0s ease 0s;
    margin-left: 0px;
  }
  .header-area .main-nav .nav li:first-child {
    border-top: 1px solid #eee;
  }
  .header-area .main-nav .nav li {
    width: 100%;
    background: #fff;
    border-bottom: 1px solid #eee;
    padding-left: 0px !important;
    padding-right: 0px !important;
  }
  .header-area .main-nav .nav li a {
    height: 50px !important;
    line-height: 50px !important;
    padding: 0px !important;
    border: none !important;
    background: #fff !important;
    color: #3B566E !important;
  }
  .header-area .main-nav .nav li a:hover {
    background: #eee !important;
  }
}

@media (min-width: 992px) {
  .header-area .main-nav .nav {
    display: flex !important;
  }
}


/** Slogan slider section **/
.slider_section {
    font-weight: bold;
    font-size: 12px;
    text-align: center;
    width: 100%;
     color: black;
     height: 30px;
}

.carousel-inner {
    width: 100%;
    text-align: center;
}

.carousel-item {
    position: relative;
    display: none;
    text-align: center;
     -ms-flex-align: center;
    align-items: center;
    transition: -webkit-transform .6s ease;
    transition: transform .6s ease;
    transition: transform .6s ease,-webkit-transform .6s ease;
    -webkit-backface-visibility: hidden;
    backface-visibility: hidden;
    -webkit-perspective: 1000px;
    perspective: 1000px;
}

.carousel-item.text {
  margin-left: 18px;
}


/* If the screen size is 600px wide or less */
@media screen and (max-width: 600px) {
.carousel-item.text {
  margin-left: 0;
}

 }
 
 .vert .carousel-item-next.carousel-item-left, .vert .carousel-item-prev.carousel-item-right {
     -webkit-transform: translate3d(0, 0, 0);
     transform: translate3d(0, 0, 0);
}
 .vert .carousel-item-next, .vert .active.carousel-item-right {
     -webkit-transform: translate3d(0, 100%, 0);
     transform: translate3d(0, 100% 0);
}
 .vert .carousel-item-prev, .vert .active.carousel-item-left {
     -webkit-transform: translate3d(0,-100%, 0);
     transform: translate3d(0,-100%, 0);
}


.carousel-item:last-child {
  color: purple;
}


/*Slogan*/

#container {

}


#slogan {
  font-family:'Roboto';
  float: left;
  font-size: 8px;
  padding: 3px;
  color:white;
  text-transform: uppercase;
  font-weight:bold;
  margin-left: 55px;
  background: linear-gradient(14deg, red, purple, blue);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
   
}



/* If the screen size is 600px wide or less */
@media screen and (max-width: 600px) {
#slogan {
  margin-left: 15px;
}

 }

#flip {
  float: left;
  font-size: 15px;
  height: 23px;
  overflow:hidden;
  color:white;
  margin-left: 2px;
  text-transform: uppercase;
  font-weight: bold;
}

#flip > div > div {
  color:#fff;
  height: 45px;
  margin-bottom:45px;
  
  display:inline-block;
}

#flip div:first-child {
  animation: show 5s linear infinite;
}

#flip div div {
  color:dodgerblue;
}
#flip div:first-child div {
  background: linear-gradient(42deg, black, gray, black);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
#flip div:last-child div {
   background: linear-gradient(42deg, purple, skyblue, dodgerblue);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  
}

@keyframes show {
  0% {margin-top:-270px;}
  5% {margin-top:-180px;}
  33% {margin-top:-180px;}
  38% {margin-top:-90px;}
  66% {margin-top:-90px;}
  71% {margin-top:0px;}
  99.99% {margin-top:0px;}
  100% {margin-top:-270px;}
}


/*Plans*/

.lm-underline {

            position: relative;

        }
        
        .lm-underline:after {
            position: absolute;
            content: ' ';
            right: 5%;
            left: 5%;
            bottom: 0;
            height: 1px;
            background-image: -webkit-linear-gradient(left, transparent, #fff, transparent);
            background-image: linear-gradient(90deg, transparent, #fff, transparent);
        }
        
        .lm-tabel {
            font-family: 'Open Sans';
            max-width: 1000px;
            width: 100%;
            padding-top: 10px;
            margin: 0 auto;
            margin-top: 150px;
            z-index: 9;
        }
        
        .lm-item-1 .lm-item-bottom,
        .lm-item-1 .lm-item-top {
            background-color: #341b37;
            background-image: -webkit-linear-gradient(135deg, #85468c, #241326);
            background-image: linear-gradient(-45deg, #85468c, #241326);
        }
        
        .lm-item-2 .lm-item-bottom,
        .lm-item-2 .lm-item-top {
            background-color: #e30a51;
            background-image: -webkit-linear-gradient(135deg, #f6266b, #7e052d);
            background-image: linear-gradient(-45deg, #f6266b, #7e052d);
        }
        
        .lm-item-3 .lm-item-bottom,
        .lm-item-3 .lm-item-top {
            background-color: #286caa;
            background-image: -webkit-linear-gradient(135deg, #4d93d5, #1a466f);
            background-image: linear-gradient(-45deg, #4d93d5, #1a466f);
        }
        
        .lm-item {
            -webkit-transform: scale(0.9);
            transform: scale(0.9);
            vertical-align: top;
            width: 33%;
            float: left;
            display: inline-block;
            position: relative;
            -webkit-transition: -webkit-transform 0.3s ease-out, -webkit-filter 0.3s;
            transition: -webkit-transform 0.3s ease-out, -webkit-filter 0.3s;
            transition: transform 0.3s ease-out, filter 0.3s;
            transition: transform 0.3s ease-out, filter 0.3s, -webkit-transform 0.3s ease-out, -webkit-filter 0.3s;
        }
        
        .lm-item:hover {
            -webkit-transform: scale(1);
            transform: scale(1);
        }
        
        .lm-item:not(:hover).blur {
            -webkit-filter: blur(3px);
            filter: blur(3px);
        }
        
        .lm-item:after,
        .lm-item:before {
            z-index: -1;
            content: ' ';
            position: absolute;
            left: 10px;
            top: 80%;
            bottom: 18px;
            right: 10px;
            -webkit-transform-origin: bottom center;
            transform-origin: bottom center;
            box-shadow: 0px 25px 10px -8px rgba(0, 0, 0, 0.4);
        }
        
        .lm-item:after {
            -webkit-transform: rotate(6deg) translate3d(15px, 0, 0);
            transform: rotate(6deg) translate3d(15px, 0, 0);
        }
        
        .lm-item:before {
            -webkit-transform: rotate(-6deg) translate3d(-15px, 0, 0);
            transform: rotate(-6deg) translate3d(-15px, 0, 0);
        }
        
        .lm-item-top {
            padding-top: 10px;
            text-transform: uppercase;
            border-top-left-radius: 7px;
            border-top-right-radius: 7px;
            text-align: center;
        }
        
        .lm-item-title {
            color: #e3dfe2;
            font: 12px 'Open Sans';
        }
        
        .lm-item-price {
            background: rgba(255, 255, 255, 0.05);
            margin-top: 10px;
            font-size: 20px;
            line-height: 50px;
            color: #fff;
        }
        
        .lm-item-price b {
            font-size: 8px;
        }
        
        .lm-item-body {
            padding: 15px;
            background: #fff;
        }
        
        .lm-item-desc {
            text-align: center;
            margin-top: -15px;
        }
        
        .lm-item-desc strong {
            color: orange;
            font: 400 6px 'Open Sans';
        }
        
        
        .lm-item-list {
            margin: 0;
            
            list-style: none;
        }
        
        .lm-item-list li {
            color: black;
            margin-bottom: 2px;
            margin-top: 2px;
            font-weight: bold;
            font-size: 8px;
            text-transform: uppercase;
            text-align: center;
        }
        
        .lm-item-list li:nth-child(2n+1) {
            background-color: #fbfbfb;
        }
        
        .lm-item-list .icon-cancel,
        .lm-item-list .icon-ok {
            float: right;
        }
        
        .lm-item-list .icon-ok {
            color: #75bc9a;
        }
        
        .lm-item-list .icon-cancel {
            color: #bf7375;
        }
        
        .lm-item-link {
            text-align: center;
            margin-top: 15px;
            margin-left: 15%;
        }
        
        .lm-item-link a {
            text-decoration: none;
            
        }
        
        .lm-item-link display inline-block {
            height: 25px;
        }
        
        .lm-item-link display inline-block:hover {
            -webkit-transition: -webkit-transform 0.3s;
            transition: -webkit-transform 0.3s;
            transition: transform 0.3s;
            transition: transform 0.3s, -webkit-transform 0.3s;
            -webkit-transform: translate3d(0, -3px, 0);
            transform: translate3d(0, -3px, 0);
        }
        
        .lm-item-link display inline-block:active {
            -webkit-transition: -webkit-transform 0.1s;
            transition: -webkit-transform 0.1s;
            transition: transform 0.1s;
            transition: transform 0.1s, -webkit-transform 0.1s;
            -webkit-transform: translate3d(0, 0, 0);
            transform: translate3d(0, 0, 0);
        }
        
        .lm-item-link text {
            font-size: 10px;
            font-weight: 700;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        
        .lm-item-bottom {
            font-size: 8px;
            text-align: center;
            border-bottom-left-radius: 7px;
            border-bottom-right-radius: 7px;
            height: 30px;
            color: rgba(255, 255, 255, 0.5);
            font-weight: 100;
            min-height: 20px;
            margin-top: -20px;
        }
        
        .lm-item-bottom span {
            margin-top: 5px;
            color: #fff;
            font-weight: 400;
            font-size: 8px;
            
            -webkit-transform: skewX(-10deg);
            transform: skewX(-10deg);
            display: inline-block;
        }


/*Auto slideshow*/
.slideshow-container img{
    width: 100%;
    min-height: 200px;
    border-radius: 10px;
}

.slideshow-container {
    position: relative;
    margin-top: 3%;
    width: 100%;
    min-height: 200px;
}


.mySlides {
  display: none;
  width: 80%;
  min-height: 200px;
  border: solid 0px black;
     
}

.prev,
.next {
    cursor: pointer;
    position: absolute;
    top: 40%;
    width: auto;
    padding: 16px;
    color: #222428;
    font-weight: bold;
    font-size: 30px;
    transition: .6s ease;
    border: 0px solid;
    border-radius: 50px;
}

.next {
    right: 0;
}

.prev {
    left: 0;
}

.prev:hover,
.next:hover {
    color: dodgerblue;
    
}
  
  .dot {
    cursor: pointer;
    height: 10px;
    width: 10px;   
    background-color: #bbb;
    border-radius: 50%;
    display: inline-block;
    transition: background-color .6s ease;
}

.activ  {
  width: 8px;
  height: 8px;
    border-radius: 50px;
    background-color: purple;
  -webkit-animation: bounce-top 0.9s both;
          animation: bounce-top 0.9s both;
}
    



/*Quick order overlay*/
.item button {
   background: black;
   transition: 1s;
}

.item button:hover {
  color: black;
   background: grey;
}

.openBtn {
  background: black;
  border: none;
  padding: 10px 15px;
  font-size: 20px;
  cursor: pointer;
}

.openBtn:hover {
  background: #bbb;
}

.overlay {
  height: 80%;
  width:100%;
  display: none;
  top: 20%;
  left: 0;
  position: fixed;
  z-index: 1000;
  overflow-y: auto;
  background-color: rgb(0,0,0);
  background-color: rgba(0,0,0, 0.9);
}

.overlay-content {
  position: relative;
  top: 5%;
  text-align: center;
  width: 80%;
  margin-top: 30px;
  margin: auto;
}

.item .overlay h5 {
  margin-top: 20px;
  font-size: 30px;
  cursor: pointer;
  color: white;
  padding: 5px;
  border-bottom: 1px solid #8261ee;
  z-index: 9;
}

.overlay h3 {
  margin-top: -20px;
  font-weight: normal;
  font-size: 16px;
  cursor: pointer;
  color: #8261ee;
  z-index: 9;
}

.overlay .closebtn {
  position: absolute;
  top: 10px;
  right: 35px;
  font-size: 30px;
  cursor: pointer;
  color: white;
  z-index: 9;
}

.overlay .closebtn:hover {
  color: red;
}

.overlay input[type=text] {
  color: #777;
  font-size: 14px;
  border: 1px solid #8261ee;
  width: 100%;
  height: 50px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-radius: 25px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 15px;
}

.overlay input[type=text]:hover {
  border: 0px solid;
  box-shadow: 0px 0px 6px 1px #8261ee;
}

.overlay input.invalid {
  background-color: #ffdddd;
}

.overlay input[type=number] {
  color: #777;
  font-size: 14px;
  border: 1px solid #8261ee;
  width: 100%;
  height: 50px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-top-left-radius: 25px;
  border-bottom-left-radius: 25px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 15px;
}

.overlay input[type=number]:hover {
  border: 0px solid;
  box-shadow: 0px 0px 6px 1px #8261ee;
}

#car {
  margin-bottom: 15px;
}

.overlay input[type=submit] {
  outline: none;
  border: none;
  cursor: pointer;
  font-weight: bold;
  font-size: 16px;
  width: 40%;
  border-radius: 14px;
  
  margin-top: 10px;
  background-color: #8261ee;
  color: #fff;
  letter-spacing: 0.25px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.overlay input[type=submit]:hover {
  background: #ff589e;
  opacity: 1;
}

.client {
  font-weight: bold;
  color: white;
  margin-top: 10px;
  border-top: 1px solid white;
  padding: 10px;
}



/*Quick Order*/

.item h5 {
  color: black;
}


/*Order form*/
        #regForm {
  font-family: Raleway;
  font-weight: bold;
  background-color: #ffffff;
  color: #8261ee;
  padding: 40px;
  width: 100%;
  min-width: 300px;
  border-radius: 20px;
  box-shadow: 0 2px 48px 0 rgba(0, 0, 0, 0.10);
}

.section-title {
  color: purple;
  text-align: center;  
}

.tab {
    text-align: center;
}

input {
  color: #777;
  font-size: 14px;
  border: 1px solid #8261ee;
  width: 100%;
  height: 50px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-radius: 25px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 5px;
}

input:hover {
    border: 0px solid;
    box-shadow: 0px 0px 6px 1px #8261ee;
}

/* Mark input boxes that gets an error on validation: */
input.invalid {
  background-color: #ffdddd;
}

/* Hide all steps by default: */
.tab {
  display: none;
}

button {
  outline: none;
  border: none;
  cursor: pointer;
  font-weight: bold;
  font-size: 13px;
  border-radius: 14px;
  padding: 6px 20px;
  background-color: #8261ee;
  text-transform: uppercase;
  color: #fff;
  letter-spacing: 0.25px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

button:hover {
  outline: none;
  opacity: 0.8;
}

#prevBtn {
  background-color: #bbbbbb;
}

#prevBtn:hover {
  background-color: #8261ee;
  opacity: 1;
}

/* Make circles that indicate the steps of the form: */
.step {
  height: 15px;
  width: 15px;
  margin: 0 2px;
  background-color: #8261ee;
  border: none;  
  border-radius: 50%;
  display: inline-block;
  opacity: 0.5;
}

.step.active {
  opacity: 1;
}

/* Mark the steps that are finished and valid: */
.step.finish {
  background-color: #8261ee;
}

#statusMessage {
  color: purple;
}

/*Pop Up Order*/
.dropbtn {
  font-size: 13px;
  border-radius: 20px;
  padding: 12px 20px;
  background-color: #8261ee;
  text-transform: uppercase;
  color: #fff;
  outline: none;
  letter-spacing: 0.25px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.dropbtn:hover {
  background-color: #ff589e;
}

.dropdown {
  position: relative;
  display: inline-block;
  outline: none;
}

.dropdown-content {
  display: none;
  position: absolute;
  top: -250px;
  left: -100px;
  width: 250%;
  height: 250px;
  background-color: white;
  z-index: 1;
}

.dropdown-content input {
  color: #777;
  font-size: 14px;
  border: 1px solid #8261ee;
  width: 90%;
  height: 40px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-radius: 25px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 5px;
}

.dropdown-content input:hover {
    border: 0px solid;
    box-shadow: 0px 0px 6px 1px #8261ee;
}

/* Mark input boxes that gets an error on validation: */
.dropdown-content input.invalid {
  background-color: #ffdddd;
}

.dropdown-content textarea {
  color: #777;
  font-size: 14px;
  border: 1px solid #8261ee;
  width: 90%;
  height: 120px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-radius: 25px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 5px;
}

.dropdown-content textarea:hover {
  box-shadow: 0px 0px 6px 1px #8261ee;
}

.dropdown-content input[type=submit] {
  outline: none;
  border: none;
  cursor: pointer;
  font-size: 13px;
  width: 50%;
  border-radius: 14px;
  padding: 6px 20px;
  background-color: purple;
  text-transform: uppercase;
  color: #fff;
  letter-spacing: 0.25px;
  -webkit-transition: all 0.3s ease 0s;
  -moz-transition: all 0.3s ease 0s;
  -o-transition: all 0.3s ease 0s;
  transition: all 0.3s ease 0s;
}

.dropdown-content input[type=submit]:hover {
  outline: none;
  background: #ff589e;
}

.dropdown:hover .dropdown-content {display: block;}


/*Sticky Button*/
.sticky {
  position: fixed;
  bottom: 3%;
  right: 10px;
  font-size: 20px;
  width: 45px;
  height: 45px;
  background-image: url('assets/images/work-process-bg.png');
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center; 
  border: 1px solid;
  border-radius: 50px;
  box-shadow: 0px 0px 5px 1px purple;
  outline: none;
  z-index: 888;
}

.sticky:hover {
  opacity: 1;
  box-shadow: 0px 0px 5px 3px #8261ee;
}


#sticky .overlay {
  display: none;
  position: fixed;
  top: 20%;
  left: 10%;
  height: 70%;
  width:80%;
  border-radius: 10px;
  z-index: 999;
  background-color: rgb(0,0,0);
  background-color: rgba(0,0,0, 0.9);
}

#sticky .overlay-content {
  position: relative;
  top: 5%;
  text-align: center;
  width: 80%;
  margin: auto;
}

#sticky .overlay h5 {
  font-weight: bold;
  text-align: center;
  margin-top: 20px;
  margin-bottom: 20px;
  font-size: 30px;
  border-bottom: 1px solid dodgerblue;
  cursor: pointer;
  color: dodgerblue;
  z-index: 9;
}

#sticky .overlay h3 {
  text-align: center;
  margin-top: -20px;
  font-weight: bold;
  font-size: 16px;
  cursor: pointer;
  color: white;
  z-index: 9;
}

#sticky .close {
  position: absolute;
  top: 270px;
  right: 48%;
  font-size: 30px;
  font-weight: normal;
  text-align: center;
  cursor: pointer;
  color: red;
  outline: none;
  opacity: 1;
  z-index: 9;
}

#sticky .close:hover {
  color: red;
}

#sticky .close i{
  color: red;
}

#sticky i {
  font-weight: normal;
  color: dodgerblue;
}

/*Packages*/
.packages {
  text-align: center;
  color: dodgerblue;
  cursor: progress;
}

.packages i{
  font-size: 20px;
}


#Packages .overlay {
  display: none;
  position: fixed;
  top: 20%;
  left: 10%;
  height: 70%;
  width:80%;
  border-radius: 10px;
  z-index: 999;
  background-color: rgb(0,0,0);
  background-color: rgba(0,0,0, 0.9);
}

#Packages .overlay-content {
  position: relative;
  top: 5%;
  text-align: center;
  width: 80%;
  margin: auto;
}

#Packages h5 {
  font-weight: bold;
  text-align: center;
  margin-top: 20px;
  margin-bottom: 20px;
  font-size: 16px;
  border-bottom: 1px solid dodgerblue;
  cursor: pointer;
  color: dodgerblue;
  z-index: 9;
}

#Packages .overlay h3 {
  text-align: center;
  margin-top: 20px;
  font-weight: bold;
  font-size: 16px;
  cursor: pointer;
  color: white;
  z-index: 9;
}


#Packages .closebtn i {
  font-weight: normal;
  color: red;
  font-size: 20px;
}


#Packages .closebtn {
  position: absolute;
  top: 5px;
  right: 25px;
  font-weight: normal;
  cursor: pointer;
  color: red;
  outline: none;
  opacity: 1;
  z-index: 9;
}

#Packages .closebtn:hover {
  color: red;
}

.single_gallery_item {
    margin-bottom: 100px;
    width: 100%;
    overflow: hidden
}


#wrapper {
    position: relative;
    background-color: #fff;
    left: 0;
    top: 0;
    -webkit-transition: all linear 500ms;
    transition: all linear 500ms;
    box-shadow: 0 0 50px rgba(0, 0, 0, 0.2);
}

.product-img {
    position: relative;
    text-align: center;
    margin-left: 2%;
    width: 100%;
    max-height: 400px;
    min-height: 250px;
    border-radius: 10px;
    z-index: 1;
    overflow: hidden;
}

.product-img > img {
    width: 100%;
    height: 100%;
    -webkit-transition-duration: 500ms;
    transition-duration: 500ms;
}

.single_gallery_item:hover .product-img > img {
    -webkit-transform: scale(1.15);
    transform: scale(1.15);
}

.product-img .product-quicview {
    position: absolute;
    width: 100%;
    height: 100%;
    z-index: 1;
    top: 0;
    left: 0; 
    background-color: rgba(23, 24, 24, 0.6);
    opacity: 1;
    -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
    -webkit-transition-duration: 500ms;
    transition-duration: 500ms;
}

.product-img:hover .product-quicview {
    opacity: 1;
    -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=100)";
}

.product-img .product-quicview > a {
    float: left;
    margin-left: 7%;
    margin-top: 7%;
    width: 72px;
    height: 72px;
    border: 2px solid rgba(255, 255, 255, 0.8);
    border-radius: 50%;
    text-align: center;
    color: rgba(255, 255, 255, 0.8);
    font-size: 12px;
    line-height: 72px;
}

.product-img .product-quicview > a:hover {
    border: 2px solid rgba(255, 255, 255, 1);
    color: rgba(255, 255, 255, 1);
}

.product-description {
    margin-top: 20px;
}

.product-description h4 {
    font-weight: 400;
    color: #9f9f9f;
    margin-bottom: 5px;
    display: block;
}

.product-description p {
    font-size: 15px;
    margin: 0;
}

.product-description .add-to-cart-btn {
    margin-top: 50px;
    font-size: 12px;
    font-weight: 700;
    color: #ff084e;
    display: block;
}

.product-description .add-to-cart-btn:hover {
    color: #2a2a2a;
}



 

  .client-info img {
    width: 100px;
    margin-right: 1em;
}


.multi {
  position: absolute;
  top: 120px;
  left: 0;
  color: dodgerblue;
}

.multi i{
  font-size: 20px;
}

.account {
  position: absolute;
  top: 120px;
  right: 0;
  color: dodgerblue;
}

.account i{
  font-size: 20px;
}





/*---------------------------------------
     PROJECT              
  -----------------------------------------*/

  .project {
    background: var(--project-bg);
  }

  .project-wrapper {
    position: relative;
    border-radius: var(--border-radius-small);
  }

  .project-wrapper img {
    border-radius: var(--border-radius-small);
  }

  .project-info {
    background: var(--white-color);
    width: 100%;
    margin: 20px 0 -40px 0;
  }

  .project-info small {
    font-family: Plain-Bold;
    color: var(--gray-color);
    position: relative;
    top: 2px;
  }

  .project-info a {
    color: var(--primary-color);
  }

  .project-info .project-icon {
    background: var(--primary-color);
  }

  .project-icon {
    position: absolute;
    right: 30px;
    top: 40px;
    background: var(--dark-color);
    border-radius: var(--border-radius-large);
    color: var(--white-color);
    font-size: var(--h2-font-size);
    width: 40px;
    height: 40px;
    line-height: 40px;
    text-align: center;
    padding-left: 5px;
  }

  .owl-theme .owl-dots .owl-dot {
    outline: none;
  }

  .owl-theme .owl-dots .owl-dot span {
    background: gray;
    width: 10px;
    height: 10px;
    border-radius: 50px;
    margin:  35px 5px;
    
}
  }

 .owl-theme .owl-dots .owl-dot.active span, 
  .owl-theme .owl-dots .owl-dot:hover span {
    background: dodgerblue;
  }

  .list-detail {
    margin-left: 1em;
    padding-left: 1em;
    position: relative;
  }

  .list-detail li {
    display: block;
    list-style: none;
    margin: 0.6em 0 0 0.8em;
  }

  .list-detail li::before {
    content: "";
    width: 0;
    height: 0;
    border-width: 0 16px 16px 0;
    border-color: transparent var(--secondary-color) transparent transparent;
    border-style: solid;
    position: absolute;
    left: 0;
  }

  .list-detail span {
    position: relative;
    bottom: 5px;
  }



  /*---------------------------------------
      ABOUT            
  -----------------------------------------*/

  .about {
    position: relative;
    overflow: hidden;
  }

  .about-image img {
    display: block;
    margin: 0 auto;
  }





/* 
---------------------------------------------
contact
--------------------------------------------- 
*/

#contact-us {
  padding: 160px 0px;
}

#contact-us h5 {
  font-weight: 500;
  font-size: 18px;
  color: #1e1e1e;
  letter-spacing: 0.25px;
  line-height: 26px;
}

.contact-text {
  font-weight: 400;
  font-size: 14px;
  color: #6F8BA4;
  letter-spacing: 0.6px;
  line-height: 26px;
}

.contact-text p {
  margin-bottom: 28px;
}

.contact input {
  color: #777;
  font-size: 14px;
  border: 0px solid #8261ee;
  width: 100%;
  height: 50px;
  outline: none;
  padding-left: 20px;
  padding-right: 20px;
  border-radius: 10px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  margin-bottom: 30px;
  background: none;
  box-shadow: 0 0 6px 0 #8261ee;
}

.contact input;hover {
  border: none;
  box-shadow: 0 0 2px 0;
}

.contact textarea {
  width: 100%;
  height: 150px;
  padding: 20px;
  border: 0px solid #8261ee;
  border-radius: 10px;
  margin-bottom: 30px;
  background: none;
  box-shadow: 0 0 6px 0 #8261ee;
  outline: none;
}

.contact button {
  padding: 15px;
  border-radius: 15px;
  background: linear-gradient(45deg, #ee7752, #e73c7e, #23a6d5);
   background-size: 400% 400%;
    -webkit-animation: gradient 15s ease infinite;
            animation: gradient 15s ease infinite;
}


footer .terms a {
  font-size: 12px;
  color: white;
  margin-left: 10px;
  margin-right: 10px;
  z-index: 999;
}

footer .terms a:hover {
  color: orange;
}

/*Floating Image*/

.floating-bae {
  margin-top: 40px;
  border-radius: 10px;
  background: linear-gradient(45deg, #ee7752, #e73c7e, #23a6d5);
   background-size: 400% 400%;
    -webkit-animation: gradient 15s ease infinite;
            animation: gradient 15s ease infinite;
}


.quote h2 {
  font-style: italic;
  color: white;
  margin-top: 10px;
  font-size: 16px;
}


/* If the screen size is 601px wide or more */
@media screen and (min-width: 601px) {
  .quote h2 {
  margin-top: 30px;
  font-size: 16px;
}

 }



/*Top Slider*/

.site-section {
  width: 100%;
  margin-top: 20px;
}
.media-29101 {
  border-radius: 10px;
  background: white;
}

.media-29101 img {
  border-radius: 10px 10px 0 0;
  margin-bottom: 20px;
}

.media-29101 video {
  width: 100%;
  border-bottom: 1px solid purple;
  border-radius: 10px 10px 0 0;
  margin-bottom: 20px;
}

.media-29101 h3 {
  margin: -10px 0 0 0 !important;
  padding: 0 0 20px 0;

}

  .media-29101 h3 a {
  font-size: 15px;
  font-weight: 600 !important;
  color: white;
    background: linear-gradient(-45deg, #e73c7e, #23a6d5);
   background-size: 400% 400%;
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
    -webkit-animation: gradient 8s ease infinite;
            animation: gradient 8s ease infinite;
}

.owl-2-style .owl-nav {
  display: none; }

.owl-2-style .owl-dots {
  text-align: center;
  position: relative;
  bottom: -30px; }
  .owl-2-style .owl-dots .owl-dot {
    display: inline-block; }
    .owl-2-style .owl-dots .owl-dot span {
      display: inline-block;
      width: 15px;
      height: 3px;
      border-radius: 0px;
      background: #cccccc;
      -webkit-transition: 0.3s all cubic-bezier(0.32, 0.71, 0.53, 0.53);
      -o-transition: 0.3s all cubic-bezier(0.32, 0.71, 0.53, 0.53);
      transition: 0.3s all cubic-bezier(0.32, 0.71, 0.53, 0.53);
      margin: 3px; }
    .owl-2-style .owl-dots .owl-dot.active span {
      background: linear-gradient(-45deg, #23a6d5, skyblue);
   background-size: 400% 400%;
    -webkit-animation: gradient 8s ease infinite;
            animation: gradient 8s ease infinite;
       }
    .owl-2-style .owl-dots .owl-dot:active, .owl-2-style .owl-dots .owl-dot:focus {
      outline: none; }

/* If the screen size is 600px wide or less */
@media screen and (max-width: 600px) {


 }

    </style>

    </head>
    
    <!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/62813e00b0d10b6f3e724f54/1g34dkdtk';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
    
    
    <body>
    

<!-- ***** Header Area Start ***** -->
    <header class="header-area header-sticky">
        <div class="container">
            <div class="row">
                <div class="col-12">
                  <nav class="main-nav">
                  <!-- ***** Logo Start ***** -->
                      
                        <a href="index.php" class="logo text-focus-in">
                            <img src="images/logo-white.png">
                          </a>
                         
                        <a href="index.php" class="logo text-focus-in">

                           <span class="custom">Custom Assist</span> 
                           
                           
                         <div class="slider_section">
                      <div id="main_slider" class="carousel vert slide" data-ride="carousel" data-interval="5000">
                            <div class="carousel-inner">

                                <!-- Slide -->
                                <div class="carousel-item active">
                                    
                                                <div id="slogan">Improvin</div>

  <div id="flip">   
    <div><div>Schools</div></div>
    <div><div>Fashion</div></div>
    <div><div>Business</div></div>
  </div>

                                        </div>

                                        
                                    
                                <!-- Slide -->
                                <div class="carousel-item text text-focus-in">
                                    
                                We live to assist you
                                            
                                        </div>

                                <!-- Slide -->
                                <div class="carousel-item text focus-in-expand">
                                    
                                                Digitalize Your World
                                            
                                        </div>

                                <!-- Slide -->
                                <div class="carousel-item text bounce-top">
                                    
                                                Website Development
                                            
                                        </div>

                                <!-- Slide -->
                                <div class="carousel-item text bounce-in-fwd">
                                    
                                 Social Media Management 
                                            
                                        </div>


                                 <!-- Slide -->
                                <div class="carousel-item text bounce-in-bck">
                                    
                                               Content Creation
                                            
                                        </div>
                  
                        </div>
                    </div> </div>

                         </a>
                      
                         <!-- Start slider section -->

            

    <!-- End slider section -->
             
                       
                        <!-- ***** Logo End ***** -->
                    
                        

                        <!-- ***** Menu Start ***** -->
                        <ul class="nav">
                            <li><a href="https://monitor.customassistinc.com" class="flicker-5"><i class="fa fa-television" style="font-weight:bold;font-size:20px;color:purple;background:linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5);-webkit-background-clip: text;-webkit-text-fill-color: transparent;"></i></a></li>
                            <li><a href="#features">Customize</a></li>
                            <li><a href="#work-process">Sectors</a></li>
                            <li><a href="#blog">Go Digital</a></li>
                            <li><a href="#pricing-plans">Websites</a></li>
                            <li><a href="#testimonials">Tools</a></li>
                            <li><a href="#contact-us">Contact Us</a></li>
                        </ul>

                        <a class='menu-trigger'>
                            <span>Menu</span>
                        </a>
                        <!-- ***** Menu End ***** -->
                    </nav>
                </div>
            </div>
        </div>
    </header>
    <!-- ***** Header Area End ***** -->
    

    <!-- ***** Welcome Area Start ***** -->
    <div class="welcome-area" id="welcome">
      

        <!-- ***** Header Text Start ***** -->
        <div class="header-text">
            <div class="container">
                <div class="row">

                  <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <div class="site-section mb-5">
      <div class="container owl-2-style">

        <div class="owl-carousel owl-2">

          <div class="media-29101">
            <a href="#">
              <video autoplay loop muted>
                
                <source src="images/motion/top/1.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="#">Business</a></h3>
          </div>

          <div class="media-29101">
            <a href="#">
              <video autoplay loop muted>
                
                <source src="images/motion/top/3.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="#">Fashion</a></h3>
          </div>

          <div class="media-29101">
            <a href="#">
              <video autoplay loop muted>
                
                <source src="images/motion/top/5.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="#">Schools</a></h3>
          </div>

          <div class="media-29101">
            <a href="#">
              <video autoplay loop muted>
                
                <source src="images/motion/top/8.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="#">Digital Marketing</a></h3>
          </div>

          <div class="media-29101">
            <a href="https://webs.customassistinc.com">
              <video autoplay loop muted>
                
                <source src="images/motion/top/9.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="https://webs.customassistinc.com">Websites</a></h3>
          </div>

          <div class="media-29101">
            <a href="https://monitor.customassistinc.com">
              <video autoplay loop muted>
                
                <source src="images/motion/top/11.mp4" type="video/mp4">

              </video>
            </a>
            <h3><a href="https://monitor.customassistinc.com">Live Demos</a></h3>
          </div>

        </div>

      </div>
    </div>

 </div>


                    <div class="offset-xl-3 col-xl-6 offset-lg-2 col-lg-8 col-md-12 col-sm-12">

<!--Plans-->

<div class="quote">


<h2>"Marketing is not about the stuff you make but the stories you tell."</h2>

                                 

        <!-- ***** Header Text End ***** -->


        
    </div>
    <script src="https://code.jquery.com/jquery-2.1.4.min.js"></script>
    

 </div>
 
  </div>

</div>
            </div>

        </div>

    <!-- ***** Welcome Area End ***** -->
    
    
    
    
    

    
    
    
    
    
    
            <!--Carousel Start-->


<!--Autoslides-->
<div class="slideshow-container" align="center">
<div class="slideshow-inner">
  <div class="mySlides fad">

    <img  src="images/stock/1.jpg" alt="Custom Assist Business"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/2.jpg" alt="Custom Assist Fashion"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/3.jpg" alt="Custom Assist Home"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/4.jpg" alt="Custom Assist School"/>
  </div>
  
  <div class="mySlides fad">

    <img  src="images/stock/5.jpg" alt="Custom Assist Business"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/6.jpg" alt="Custom Assist Fashion"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/7.jpg" alt="Custom Assist Home"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/8.jpg" alt="Custom Assist School"/>
  </div>
  
  <div class="mySlides fad">

    <img  src="images/stock/9.jpg" alt="Custom Assist Business"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/10.jpg" alt="Custom Assist Fashion"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/11.jpg" alt="Custom Assist Home"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/12.jpg" alt="Custom Assist School"/>
  </div>
  
  <div class="mySlides fad">

    <img  src="images/stock/13.jpg" alt="Custom Assist Business"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/14.jpg" alt="Custom Assist Fashion"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/15.jpg" alt="Custom Assist Home"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/16.jpg" alt="Custom Assist School"/>
  </div>
  
  <div class="mySlides fad">

    <img  src="images/stock/17.jpg" alt="Custom Assist Home"/>
  </div>

  <div class="mySlides fad">

    <img  src="images/stock/18.jpg" alt="Custom Assist School"/>
  </div>
  
  </div>


  <a class="prev" onclick='plusSlides(-1)'>&#10094;</a>
  <a class="next" onclick='plusSlides(1)'>&#10095;</a>
</div>
<br/>


<div style='text-align: center;'>
  <span class="dot" onclick='currentSlide(1)'></span>
  <span class="dot" onclick='currentSlide(2)'></span>
  <span class="dot" onclick='currentSlide(3)'></span>
  <span class="dot" onclick='currentSlide(4)'></span>
  <span class="dot" onclick='currentSlide(5)'></span>
  <span class="dot" onclick='currentSlide(6)'></span>
  <span class="dot" onclick='currentSlide(7)'></span>
  <span class="dot" onclick='currentSlide(8)'></span>
  <span class="dot" onclick='currentSlide(9)'></span>
  <span class="dot" onclick='currentSlide(10)'></span>
  <span class="dot" onclick='currentSlide(11)'></span>
  <span class="dot" onclick='currentSlide(12)'></span>
  <span class="dot" onclick='currentSlide(13)'></span>
  <span class="dot" onclick='currentSlide(14)'></span>
  <span class="dot" onclick='currentSlide(15)'></span>
  <span class="dot" onclick='currentSlide(16)'></span>
  <span class="dot" onclick='currentSlide(17)'></span>
  <span class="dot" onclick='currentSlide(18)'></span>
</div>

</div>


<script type="text/javascript">
  var slideIndex = 1;

var myTimer;

var slideshowContainer;

window.addEventListener("load",function() {
    showSlides(slideIndex);
    myTimer = setInterval(function(){plusSlides(1)}, 4000);
  
    //COMMENT OUT THE LINE BELOW TO KEEP ARROWS PART OF MOUSEENTER PAUSE/RESUME
    slideshowContainer = document.getElementsByClassName('slideshow-inner')[0];
  
    //UNCOMMENT OUT THE LINE BELOW TO KEEP ARROWS PART OF MOUSEENTER PAUSE/RESUME
    // slideshowContainer = document.getElementsByClassName('slideshow-container')[0];
  
    slideshowContainer.addEventListener('mouseenter', pause)
    slideshowContainer.addEventListener('mouseleave', resume)
})

// NEXT AND PREVIOUS CONTROL
function plusSlides(n){
  clearInterval(myTimer);
  if (n < 0){
    showSlides(slideIndex -= 1);
  } else {
   showSlides(slideIndex += 1); 
  }
  
  //COMMENT OUT THE LINES BELOW TO KEEP ARROWS PART OF MOUSEENTER PAUSE/RESUME
  
  if (n === -1){
    myTimer = setInterval(function(){plusSlides(n + 2)}, 4000);
  } else {
    myTimer = setInterval(function(){plusSlides(n + 1)}, 4000);
  }
}

//Controls the current slide and resets interval if needed
function currentSlide(n){
  clearInterval(myTimer);
  myTimer = setInterval(function(){plusSlides(n + 1)}, 4000);
  showSlides(slideIndex = n);
}

function showSlides(n){
  var i;
  var slides = document.getElementsByClassName("mySlides");
  var dots = document.getElementsByClassName("dot");
  if (n > slides.length) {slideIndex = 1}
  if (n < 1) {slideIndex = slides.length}
  for (i = 0; i < slides.length; i++) {
      slides[i].style.display = "none";
  }
  for (i = 0; i < dots.length; i++) {
      dots[i].className = dots[i].className.replace("activ", "");
  }
  slides[slideIndex-1].style.display = "block";
  dots[slideIndex-1].className += " activ";
}

pause = () => {
  clearInterval(myTimer);
}

resume = () =>{
  clearInterval(myTimer);
  myTimer = setInterval(function(){plusSlides(slideIndex)}, 4000);
}
</script>



<!-- PROJECT -->
     <section class="project section-padding" id="project">
          <div class="container-fluid">
               <div class="row">

                    <div class="col-lg-12 col-12">

                        <h2 class="mb-5 text-center" data-aos="fade-up">
                            Some of our
                            <strong>featured services</strong>
                        </h2>

                         <div class="owl-carousel owl-theme" id="project-slide">
                              <div class="item project-wrapper" data-aos="fade-up" data-aos-delay="100">
                                   <img src="images/stock/services/1.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Customization</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">

                                    <img src="images/stock/services/12.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">

                                        <h5> <span>Branding</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/2.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Designing</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/16.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                         <h5> <span>Packaging</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/10.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Printing</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/5.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span> Digital Marketing</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/4.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Social Media</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/13.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Content Creation</span> </h5>
                                   </div>
                              </div>

                              <div class="item project-wrapper" data-aos="fade-up">
                                   
                                    <img src="images/stock/services/15.png" class="img-fluid" alt="Custom Assist">

                                   <div class="project-info">
                                        
                                        <h5> <span>Websites</span> </h5>
                                   </div>
                              </div>

                              
                         </div>
                    </div>

               </div>
          </div>
     </section>
                
                <!--Order Carousel End-->
<br> <br> <br> <br> <br>

    <!-- ***** Features Small Start ***** -->
    <section class="section home-feature">
      <p align="center" style="color:purple;margin-bottom:20px;font-weight: bold;">QUICK ORDER</p>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">

                        <!-- ***** Features Small Item Start ***** -->

                        <!--Business-->
                        <div class="col-lg-4 col-md-6 col-sm-6 col-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.2s">

                          <div class="item" style="background-image: url('images/business.jpg');background-position: center;background-size: cover;">                              
                                <h5 style="color: white">Business</h5>

                                <!--Logos-->
       <button onclick="openLogo()">Logo</button>

<div id="logos" class="overlay">
<h5>LOGOS</h5>
  <span class="closebtn" onclick="closeLogo()" title="Close Overlay">×</span>
  <h3>  Fill in this form to order for a Branded logo</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Logo" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of logo" list="logo" name="type"> 
    <datalist id="logo">
        <option value="Text">
        <option value="2D">
        <option value="3D">
        <option value="Motion">
    </datalist>

<input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">

      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


                    <!--Cards-->
    <button onclick="openCards()">Cards</button>

<div id="cards" class="overlay">
<h5>Business Cards</h5>
  <span class="closebtn" onclick="closeCards()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded business cards</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Business cards" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of cards" list="card" name="type"> <br>
    <datalist id="card">
        <option value="One side">
        <option value="Front & Back">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--Posters-->
  <button onclick="openPosters()">Posters</button>

<div id="posters" class="overlay">
<h5>Posters</h5>
  <span class="closebtn" onclick="closePosters()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Posters</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Posters" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Posters" list="poster" name="type">
    <datalist id="poster">
        <option value="A1">
        <option value="A2">
        <option value="A3">
        <option value="A4">
        <option value="A5">
        <option value="A6">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Stickers-->
  <button onclick="openStickers()">Stickers</button>

<div id="stickers" class="overlay">
<h5>Stickers</h5>
  <span class="closebtn" onclick="closeStickers()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Stickers</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Stickers" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Stickers" list="sticker" name="type">
    <datalist id="sticker">
        <option value="A1">
        <option value="A2">
        <option value="A3">
        <option value="A4">
        <option value="A5">
        <option value="A6">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

                                
<!--Flyers-->
  <button onclick="openFlyers()">Flyers</button>

<div id="flyers" class="overlay">
<h5>Flyers</h5>
  <span class="closebtn" onclick="closeFlyers()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Flyers</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Flyers" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of flyers" list="flyer" name="type">
    <datalist id="flyer">
        <option value="One Page">
        <option value="Double Page">
        <option value="Trifold">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>




<!--Brochures-->
  <button onclick="openBrochures()">Brochures</button>

<div id="brochures" class="overlay">
<h5>Brochures</h5>
  <span class="closebtn" onclick="closeBrochures()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Brochures</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Brochures" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Brochures" list="brochure" name="type">
    <datalist id="brochure">
        <option value="One Page">
        <option value="Double Page">
        <option value="Trifold">
          <option value="Booklet">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--Banners-->
  <button onclick="openBanners()">Banners</button>

<div id="banners" class="overlay">
<h5>Banners</h5>
  <span class="closebtn" onclick="closeBanners()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Banners</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Banners" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Banners" list="banner" name="type">
    <datalist id="banner">
        <option value="Fabric">
        <option value="Hard Paper">
        <option value="Water Drop">
          <option value="Sticker">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Sign Post-->
  <button onclick="openSignPost()">Sign Post</button>

<div id="signpost" class="overlay">
<h5>Sign Post</h5>
  <span class="closebtn" onclick="closeSignPost()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Sign Post</h3>
  <div class="overlay-content">
    <form action="order/business/index.php" method="post">
      <input type="hidden" value="Business" name="category">
      <input type="hidden" value="Sign Post" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Sign Post" list="sign" name="type">
    <datalist id="sign">
        <option value="Back Drop">
        <option value="Light Box">
        <option value="Metallic">
          <option value="3D">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

<!--Status Message-->
<div id="statusMessage" align="center"> 
                        <?php
                        if (! empty($message1)) {
                            ?>
                            <p class='<?php echo $type1; ?>Message1'><?php echo $message1; ?></p>
                        <?php
                        }
                        ?>
                    </div>

                            </div>
                        </div>
                        <!-- ***** Features Small Item End ***** -->


<!--Business Overlay JavaScript-->
<script>
function openLogo() {
  document.getElementById("logos").style.display = "block";
}

function closeLogo() {
  document.getElementById("logos").style.display = "none";
}
</script>

<script>
function openCards() {
  document.getElementById("cards").style.display = "block";
}

function closeCards() {
  document.getElementById("cards").style.display = "none";
}
</script>

<script>
function openFlyers() {
  document.getElementById("flyers").style.display = "block";
}

function closeFlyers() {
  document.getElementById("flyers").style.display = "none";
}
</script>

<script>
function openPosters() {
  document.getElementById("posters").style.display = "block";
}

function closePosters() {
  document.getElementById("posters").style.display = "none";
}
</script>

<script>
function openStickers() {
  document.getElementById("stickers").style.display = "block";
}

function closeStickers() {
  document.getElementById("stickers").style.display = "none";
}
</script>

<script>
function openBrochures() {
  document.getElementById("brochures").style.display = "block";
}

function closeBrochures() {
  document.getElementById("brochures").style.display = "none";
}
</script>

<script>
function openBanners() {
  document.getElementById("banners").style.display = "block";
}

function closeBanners() {
  document.getElementById("banners").style.display = "none";
}
</script>

<script>
function openSignPost() {
  document.getElementById("signpost").style.display = "block";
}

function closeSignPost() {
  document.getElementById("signpost").style.display = "none";
}
</script>




                        <!-- ***** Features Small Item Start ***** -->                           

                                <!--Fashion-->
                        <div class="col-lg-4 col-md-6 col-sm-6 col-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.4s">

                          <div class="item" style="background-image: url('images/fashion.jpg');background-position: center;background-size: cover;">                              
                                <h5>Fashion</h5>

                                <!--Caps-->
       <button onclick="openCap()">Caps</button>

<div id="Caps" class="overlay">
<h5>Caps</h5>
  <span class="closebtn" onclick="closeCap()" title="Close Overlay">×</span>
  <h3>  Fill in this form to order for a Branded Cap</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Caps" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Cap" list="Cap" name="type"> 
    <datalist id="Cap">
        <option value="Normal">
        <option value="Baseball">
        <option value="Hood">
        <option value="Head Wrap">
    </datalist>

<input type="text" name="brandarea" placeholder="Where to brand">

<input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">

      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


                    <!--Vests-->
    <button onclick="openVests()">Vests</button>

<div id="Vests" class="overlay">
<h5>Vests</h5>
  <span class="closebtn" onclick="closeVests()" title="Close Overlay">×</span>
  <h3>  Fill in this form to order for a Branded Vest</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Vests" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Vests" list="Vest" name="type"> <br>
    <datalist id="Vest">
        <option value="Normal">
        <option value="Tang Top">
        <option value="Stylish">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--T-Shirts-->
  <button onclick="openTShirts()">T-Shirts</button>

<div id="TShirts" class="overlay">
<h5>T-Shirts</h5>
  <span class="closebtn" onclick="closeTShirts()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded T-Shirts</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="T-Shirts" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of T-Shirts" list="T-Shirt" name="type">
    <datalist id="T-Shirt">
        <option value="RoundNeck">
        <option value="V-Neck">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Shirts-->
  <button onclick="openShirts()">Shirts</button>

<div id="Shirts" class="overlay">
<h5>Shirts</h5>
  <span class="closebtn" onclick="closeShirts()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Shirts</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Shirts" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Shirts" list="Shirt" name="type">
    <datalist id="Shirt">
        <option value="Collar">
        <option value="Buttoned">
        <option value="Collarless">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

                                
<!--Jumpers-->
  <button onclick="openJumpers()">Jumpers</button>

<div id="Jumpers" class="overlay">
<h5>Jumpers</h5>
  <span class="closebtn" onclick="closeJumpers()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Jumpers</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Jumpers" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Jumpers" list="Jumper" name="type">
    <datalist id="Jumper">
        <option value="Sweater">
        <option value="Hoodless">
        <option value="Hoodie">
    </datalist>
    
    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>




<!--Shorts-->
  <button onclick="openShorts()">Shorts</button>

<div id="Shorts" class="overlay">
<h5>Shorts</h5>
  <span class="closebtn" onclick="closeShorts()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Shorts</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Shorts" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Shorts" list="Short" name="type">
    <datalist id="Short">
        <option value="Sweat Shorts">
        <option value="Stylish Shorts">
        <option value="Kaki">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--Pants-->
  <button onclick="openPants()">Pants</button>

<div id="Pants" class="overlay">
<h5>Pants</h5>
  <span class="closebtn" onclick="closePants()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Pants</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Pants" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Pants" list="Pant" name="type">
    <datalist id="Pant">
        <option value="Sweat Pants">
        <option value="Gentle Pants">
        <option value="Stylish Pants">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Socks-->
  <button onclick="openSocks()">Socks</button>

<div id="Socks" class="overlay">
<h5>Socks</h5>
  <span class="closebtn" onclick="closeSocks()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Socks</h3>
  <div class="overlay-content">
    <form action="order/fashion/index.php" method="post">
      <input type="hidden" value="Fashion" name="category">
      <input type="hidden" value="Socks" name="item">
      <input type="text" placeholder="Brand Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Socks" list="sock" name="type">
    <datalist id="sock">
        <option value="Ankle">
        <option value="Long">
    </datalist>

    <input type="text" name="brandarea" placeholder="Where to brand">

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

<!--Status Message-->
<div id="statusMessage" align="center"> 
                        <?php
                        if (! empty($message2)) {
                            ?>
                            <p class='<?php echo $type2; ?>Message2'><?php echo $message2; ?></p>
                        <?php
                        }
                        ?>
                    </div>

                            </div>
                        </div>
                        <!-- ***** Features Small Item End ***** -->




                        <!--Fashion Overlay JavaScript-->
<script>
function openCap() {
  document.getElementById("Caps").style.display = "block";
}

function closeCap() {
  document.getElementById("Caps").style.display = "none";
}
</script>

<script>
function openVests() {
  document.getElementById("Vests").style.display = "block";
}

function closeVests() {
  document.getElementById("Vests").style.display = "none";
}
</script>

<script>
function openTShirts() {
  document.getElementById("TShirts").style.display = "block";
}

function closeTShirts() {
  document.getElementById("TShirts").style.display = "none";
}
</script>

<script>
function openShirts() {
  document.getElementById("Shirts").style.display = "block";
}

function closeShirts() {
  document.getElementById("Shirts").style.display = "none";
}
</script>

<script>
function openJumpers() {
  document.getElementById("Jumpers").style.display = "block";
}

function closeJumpers() {
  document.getElementById("Jumpers").style.display = "none";
}
</script>

<script>
function openShorts() {
  document.getElementById("Shorts").style.display = "block";
}

function closeShorts() {
  document.getElementById("Shorts").style.display = "none";
}
</script>

<script>
function openPants() {
  document.getElementById("Pants").style.display = "block";
}

function closePants() {
  document.getElementById("Pants").style.display = "none";
}
</script>

<script>
function openSocks() {
  document.getElementById("Socks").style.display = "block";
}

function closeSocks() {
  document.getElementById("Socks").style.display = "none";
}
</script>


                    <!-- ***** Features Small Item Start ***** -->                           

                                <!--Schools-->
                    <div class="col-lg-4 col-md-6 col-sm-6 col-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.6s">

       <div class="item" style="background-image: url('images/school.jpg');background-position: center;background-size: cover;">                              
               
               <h5>Schools</h5>

                                <!--Uniforms-->
       <button onclick="openUniform()">Uniforms</button>

<div id="Uniforms" class="overlay">
<h5>Uniforms</h5>
  <span class="closebtn" onclick="closeUniform()" title="Close Overlay">×</span>
  <h3>  Fill in this form to order for a Branded Uniform</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Uniforms" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Uniform" list="Uniform" name="type"> 
    <datalist id="Uniform">
        <option value="Shirts">
        <option value="Shorts">
        <option value="Shirts & Shorts">
        <option value="Socks">
        <option value="Full">
    </datalist>

<input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">

      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


                    <!--Sportswears-->
    <button onclick="openSportswears()">Sportswear</button>

<div id="Sportswears" class="overlay">
<h5>Sportswear</h5>
  <span class="closebtn" onclick="closeSportswears()" title="Close Overlay">×</span>
  <h3>  Fill in this form to order for a Branded Sportswear</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Sportswear" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Sportswears" list="Sportswear" name="type"> <br>
    <datalist id="Sportswear">
        <option value="T-Shirts">
        <option value="Shorts">
        <option value="Both">
    </datalist>
 
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--Calendars-->
  <button onclick="openCalendars()">Calendars</button>

<div id="Calendars" class="overlay">
<h5>Calendars</h5>
  <span class="closebtn" onclick="closeCalendars()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Calendars</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Calendars" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Calendars" list="Calendar" name="type">
    <datalist id="Calendar">
        <option value="Table Top">
        <option value="Hanging">
        <option value="One Page">
        <option value="Double Sided">
        <option value="Monthly Pages">
    </datalist>

    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Tags-->
  <button onclick="openTags()">Tags</button>

<div id="Tags" class="overlay">
<h5>Tags</h5>
  <span class="closebtn" onclick="closeTags()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Tags</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Tags" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Tags" list="Tag" name="type">
    <datalist id="Tag">
        <option value="Rectangular">
        <option value="Round">
        <option value="Office">
    </datalist>
 
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

                                
<!--Pens-->
  <button onclick="openPens()">Pens</button>

<div id="Pens" class="overlay">
<h5>Pens</h5>
  <span class="closebtn" onclick="closePens()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Pens</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Pens" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Pens" list="Pen" name="type">
    <datalist id="Pen">
        <option value="Ball Point">
        <option value="Fountain">
    </datalist>
     
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>




<!--Posters-->
  <button onclick="openPosters()">Posters</button>

<div id="Posters" class="overlay">
<h5>Posters</h5>
  <span class="closebtn" onclick="closePosters()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Posters</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Posters" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Posters" list="Poster" name="type">
    <datalist id="Poster">
        <option value="A1">
        <option value="A2">
        <option value="A3">
        <option value="A4">
        <option value="A5">
        <option value="A6">
    </datalist>
 
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>



<!--Stickers-->
  <button onclick="openStickers()">Stickers</button>

<div id="Stickers" class="overlay">
<h5>Stickers</h5>
  <span class="closebtn" onclick="closeStickers()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Stickers</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Stickers" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Stickers" list="Sticker" name="type">
    <datalist id="Sticker">
        <option value="A1">
        <option value="A2">
        <option value="A3">
        <option value="A4">
        <option value="A5">
        <option value="A6">
    </datalist>
 
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>


<!--Sign Posts-->
  <button onclick="openSignPosts()">Sign Posts</button>

<div id="Sign Posts" class="overlay">
<h5>Sign Posts</h5>
  <span class="closebtn" onclick="closeSignPosts()" title="Close Overlay">×</span>
  <h3> Fill in this form to order for Branded Sign Posts</h3>
  <div class="overlay-content">
    <form action="order/schools/index.php" method="post">
      <input type="hidden" value="Schools" name="category">
      <input type="hidden" value="Sign Posts" name="item">
      <input type="text" placeholder="School Name.." name="coname"> <br>
      <input type="text" placeholder="Preferred Colors" name="colors"> <br>
      <input type="text" placeholder="Description" name="description"> <br>
      <input id="car" placeholder="Type of Sign Posts" list="sign" name="type">
    <datalist id="sign">
        <option value="Back Drop">
        <option value="Light Box">
        <option value="Metallic">
          <option value="3D">
    </datalist>
 
    <input type="number" name="quantity" placeholder="Quantity"> 

<div class="client">Contact Information</div>

<input type="text" name="clientname" placeholder="Full Names">

<input type="text" name="clientnumber" placeholder="Phone Number">

<input type="email" name="clientemail" placeholder="Email Address">
      <input type="submit" name="submit" value="Order">
    </form>
  </div>
</div>

<!--Status Message-->
<div id="statusMessage" align="center"> 
                        <?php
                        if (! empty($message3)) {
                            ?>
                            <p class='<?php echo $type3; ?>Message3'><?php echo $message3; ?></p>
                        <?php
                        }
                        ?>
                    </div>

                            </div>
                        </div>
                        <!-- ***** Features Small Item End ***** -->




                        <!--Schools Overlay JavaScript-->
<script>
function openUniform() {
  document.getElementById("Uniforms").style.display = "block";
}

function closeUniform() {
  document.getElementById("Uniforms").style.display = "none";
}
</script>

<script>
function openSportswears() {
  document.getElementById("Sportswears").style.display = "block";
}

function closeSportswears() {
  document.getElementById("Sportswears").style.display = "none";
}
</script>

<script>
function openCalendars() {
  document.getElementById("Calendars").style.display = "block";
}

function closeCalendars() {
  document.getElementById("Calendars").style.display = "none";
}
</script>

<script>
function openTags() {
  document.getElementById("Tags").style.display = "block";
}

function closeTags() {
  document.getElementById("Tags").style.display = "none";
}
</script>

<script>
function openPens() {
  document.getElementById("Pens").style.display = "block";
}

function closePens() {
  document.getElementById("Pens").style.display = "none";
}
</script>

<script>
function openPosters() {
  document.getElementById("Posters").style.display = "block";
}

function closePosters() {
  document.getElementById("Posters").style.display = "none";
}
</script>

<script>
function openStickers() {
  document.getElementById("Stickers").style.display = "block";
}

function closeStickers() {
  document.getElementById("Stickers").style.display = "none";
}
</script>

<script>
function openSignPosts() {
  document.getElementById("Sign Posts").style.display = "block";
}

function closeSignPosts() {
  document.getElementById("Sign Posts").style.display = "none";
}
</script>
    

</div> </div> </div> </div> </section>


<!-- ***** Counter Parallax Start ***** -->
    <section class="counter">
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="count-item decoration-bottom">
                            <strong>126</strong>
                            <span>Completed Projects</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="count-item decoration-top">
                            <strong>63</strong>
                            <span>Happy Clients</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="count-item decoration-bottom">
                            <strong>28</strong>
                            <span>Companies & Institutes</span>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 col-sm-12">
                        <div class="count-item">
                            <strong>18</strong>
                            <span>Countries</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ***** Counter Parallax End ***** -->   



    <!-- ***** Features Big Item Start ***** -->
    <section class="section padding-top-70 padding-bottom-0" id="features">

      <p align="center" style="color:#8261ee;margin-bottom:40px;font-weight: bold;" data-scroll-reveal="enter top move 30px over 0.6s after 0.4s">Order <span style="color:dodgerblue;">Anything!</span></p>

        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-12 col-sm-12 align-self-center floating-bae" data-scroll-reveal="enter left move 30px over 0.6s after 0.4s">
                    <img src="images/bae.png" class="rounded img-fluid d-block mx-auto float-bounce" alt="App">
                </div>
   
                <div class="col-lg-6 col-md-12 col-sm-12 align-self-center mobile-top-fix">
                    

                    <div class="left-text">

                        <h2 class="section-title" align="center">Fill in to order</h2>

                        <form id="regForm" action="assist.php" method="post">

                          <input type="hidden" name="category" value="General">
  
  <div class="tab">Your Order:
    <p><input type="text" placeholder="Item(s)..." oninput="this.className = ''" name="item"></p>
    <p><input type="text" placeholder="Specify Style/Design/Color..." oninput="this.className = ''" name="specification"></p>
    <p><input type="number" placeholder="Quantity..." oninput="this.className = ''" name="quantity"></p>
  </div>
  <div class="tab">Contact Info:
    <p><input type="text" placeholder="Your Name..." oninput="this.className = ''" name="name"></p>
    <p><input type="email" placeholder="E-mail..." oninput="this.className = ''" name="email"></p>
    <p><input type="number" placeholder="Phone..." oninput="this.className = ''" name="phone"></p>
  </div>
  <div class="tab">Delivery:
    <p><input type="time" placeholder="Time" oninput="this.className = ''" name="etime"></p>
    <p><input type="date" placeholder="Date" oninput="this.className = ''" name="edate"></p>
    <p><input type="location" placeholder="Location" oninput="this.className = ''" name="location"></p>
  </div>
  <div class="tab">Payment:
    <p><input id="car" placeholder="Options Below " oninput="this.className = ''" list="pay" name="payment"></p>
    <datalist id="pay">
        <option value="Cash">
        <option value="Mobile Money">
        <option value="Bank">
    </datalist>
    
  </div>
  <div style="overflow:auto;">
    <div style="float:right;">
      <button type="button" id="prevBtn" onclick="nextPrev(-1)">Previous</button>
      <button type="button" id="nextBtn" onclick="nextPrev(1)">Next</button>
    </div>
  </div>
  <!-- Circles which indicates the steps of the form: -->
  <div style="text-align:center;margin-top:40px;">
    <span class="step"></span>
    <span class="step"></span>
    <span class="step"></span>
    <span class="step"></span>
  </div>

</form>

<!--Status Message-->
<div id="statusMessage" align="center"> 
                        <?php
                        if (! empty($message)) {
                            ?>
                            <p class='<?php echo $type; ?>Message'><?php echo $message; ?></p>
                        <?php
                        }
                        ?>
                    </div>

<script>
var currentTab = 0; // Current tab is set to be the first tab (0)
showTab(currentTab); // Display the current tab

function showTab(n) {
  // This function will display the specified tab of the form...
  var x = document.getElementsByClassName("tab");
  x[n].style.display = "block";
  //... and fix the Previous/Next buttons:
  if (n == 0) {
    document.getElementById("prevBtn").style.display = "none";
  } else {
    document.getElementById("prevBtn").style.display = "inline";
  }
  if (n == (x.length - 1)) {
    document.getElementById("nextBtn").innerHTML = "Submit";
  } else {
    document.getElementById("nextBtn").innerHTML = "Next";
  }
  //... and run a function that will display the correct step indicator:
  fixStepIndicator(n)
}

function nextPrev(n) {
  // This function will figure out which tab to display
  var x = document.getElementsByClassName("tab");
  // Exit the function if any field in the current tab is invalid:
  if (n == 1 && !validateForm()) return false;
  // Hide the current tab:
  x[currentTab].style.display = "none";
  // Increase or decrease the current tab by 1:
  currentTab = currentTab + n;
  // if you have reached the end of the form...
  if (currentTab >= x.length) {
    // ... the form gets submitted:
    document.getElementById("regForm").submit();
    return false;
  }
  // Otherwise, display the correct tab:
  showTab(currentTab);
}

function validateForm() {
  // This function deals with validation of the form fields
  var x, y, i, valid = true;
  x = document.getElementsByClassName("tab");
  y = x[currentTab].getElementsByTagName("input");
  // A loop that checks every input field in the current tab:
  for (i = 0; i < y.length; i++) {
    // If a field is empty...
    if (y[i].value == "") {
      // add an "invalid" class to the field:
      y[i].className += " invalid";
      // and set the current valid status to false
      valid = false;
    }
  }
  // If the valid status is true, mark the step as finished and valid:
  if (valid) {
    document.getElementsByClassName("step")[currentTab].className += " finish";
  }
  return valid; // return the valid status
}

function fixStepIndicator(n) {
  // This function removes the "active" class of all steps...
  var i, x = document.getElementsByClassName("step");
  for (i = 0; i < x.length; i++) {
    x[i].className = x[i].className.replace(" active", "");
  }
  //... and adds the "active" class on the current step:
  x[n].className += " active";
}
</script>
                    </div>

                </div>
            </div>



            <div class="row">
                <div class="col-lg-12">
                    <div class="hr"></div>
                </div>
            </div>
        </div>
    </section>
    <!-- ***** Features Big Item End ***** -->

    <!-- ***** Features Big Item Start ***** -->
    <section class="section padding-bottom-100" style="background: white;">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 align-self-center mobile-bottom-fix">
                    <div class="left-heading">
                        <h2 class="section-title"><b style="background: linear-gradient(42deg, black, gray, black); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">BUILD YOUR BRAND WITH US</b></h2>
                    </div>
                    <div class="left-text">
                        <b style="background: linear-gradient(42deg, black, gray, black); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">WE ARE BRAND STRATEGISTS, MARKETERS & BUSINESS CONSULTANTS </b>
                        <p style="font-size: 16px;font-weight: bold;color: dodgerblue;margin-top: 20px;">We believe your brand defines your business..</p>
                        <p style="font-size:15px;">We develope and produce creatively customized content with a belief that each business is unique, we do everything with a primary aim to show our clients at their best. <br> <br>
                        We exist to allow the beauty in others to shine, we base our work on content, honesty and trust.</p>

                      
                    </div>
                </div>
                <div class="col-lg-1"></div>
                <div class="col-lg-5 col-md-12 col-sm-12 align-self-center mobile-bottom-fix-big" data-scroll-reveal="enter right move 30px over 0.6s after 0.4s">
                  <video class="rounded img-fluid d-block mx-auto"  autoplay loop muted>
                
                <source src="images/motion/top/10.mp4" type="video/mp4">

              </video>

                </div>
            </div>
        </div>
    </section>
    <!-- ***** Features Big Item End ***** -->


    


    <!-- ***** Testimonials Start ***** -->
    <section class="section" id="testimonials">
        <div class="container">

            <div class="row">

                              <div class="col-lg-12">
                    <div class="center-heading">
                        <h2 class="section-title"> <b style="background: linear-gradient(-45deg, #ee7752, #e73c7e, #23a6d5);background-size: 400% 400%;-webkit-background-clip: text;-webkit-text-fill-color: transparent;-webkit-animation: gradient 8s ease infinite;animation: gradient 8s ease infinite;">GROW YOUR BUSINESS WITH;</b></h2>
                    </div>
                </div>

                <!-- ***** Testimonials Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.2s">
                    <div class="features-small-item">
                        <div class="team-content">
                            <div class="icon">
                                    <i><img src="assets/images/1.png" alt=""></i>
                                </div>
                            <div class="team-info">
                                <h3 class="user-name">Modern Branding</h3>
                            </div> <br>
                            <p> Take advantage of our modern tools and own a unique brand for your Business and Fashion </p>
                            <div class="user-image">
                                <img src="http://placehold.it/60x60" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ***** Testimonials Item End ***** -->

                <!-- ***** Testimonials Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.4s">
                    <div class="features-small-item">
                        <div class="team-content">
                            <div class="icon">
                                    <i><img src="assets/images/2.png" alt=""></i>
                                </div>
                            <div class="team-info">
                                <h3 class="user-name">Ultimate Marketing</h3>
                            </div> <br>
                                <p>Create Marketing Content With Us And Market Your Business Brand With Our Modern Tools</p>
                            <div class="user-image">
                                <img src="http://placehold.it/60x60" alt="">
                            </div>
                        </div>
                    </div>
                </div>
                <!-- ***** Testimonials Item End ***** -->
                
                <!-- ***** Testimonials Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.6s">
                    <div class="features-small-item">
                        <div class="team-content">
                            <div class="icon">
                                   <i><img src="assets/images/3.png" alt=""></i>
                                </div>
                            <div class="team-info">
                                <h3 class="user-name">Modern Websites</h3> 
                            </div> <br>
                                <p>Let's Create For You A Modern and Responsive Website in Less Than A Month At The Best Prices</p>
                            <div class="user-image">
                                <img src="http://placehold.it/60x60" alt="">
                            </div>
                            
                        </div>
                    </div>
                </div>
                <!-- ***** Testimonials Item End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Testimonials End ***** -->





    <!-- ***** Home Parallax Start ***** -->
    <section class="mini" id="work-process">
        <div class="mini-content">
            <div class="container">
                <div class="row">
                    <div class="offset-lg-3 col-lg-6">
                        <div class="info">
                            <h1>Our Sectors</h1>
                        </div>
                    </div>
                </div>

                <!-- ***** Mini Box Start ***** -->
                <div class="row">
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/1.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Business</strong>
                            
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/2.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Fashion</strong>
                            
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/4.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Schools</strong>
                            
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/5.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Homes</strong>
                            
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/6.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Digital Marketing</strong>
                            
                        </a>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6 col-6">
                        <a href="#" class="mini-box">
                            <i>
                              <video autoplay loop muted width="100%">
                                <source src="images/motion/7.mp4" type="video/mp4">
                              </video>
                            </i>
                            <strong>Websites</strong>
                            
                        </a>
                    </div>
                </div>
                <!-- ***** Mini Box End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Home Parallax End ***** -->


<!-- ***** Blog Start ***** -->
    <section class="section" id="blog">
        <div class="container">
            <!-- ***** Section Title Start ***** -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-heading">
                        <h2 class="section-title">Digital Marketing</h2>
                    </div>
                </div>
                <div class="offset-lg-3 col-lg-6">
                    <div class="center-text">
                        <p>Here's some of our best digital marketing deals.</p>
                    </div>
                </div>
            </div>
            <!-- ***** Section Title End ***** -->

            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="blog-post-thumb">
                        <div class="img">
                            <img src="assets/images/blog-item-01.png" alt="">
                        </div>
                        <div class="blog-content">
                            <h3>
                                <a href="#">Social Media Boosting</a>
                            </h3>
                            <div class="text">
                               Boost your social media platforms and content with our modern tools and techniques to increase your following and viewership by 70%.
                            </div>
                            <a href="#" class="main-button">Order Now</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="blog-post-thumb">
                        <div class="img">
                            <img src="assets/images/blog-item-02.png" alt="">
                        </div>
                        <div class="blog-content">
                            <h3>
                                <a href="#">Search Engine Optimization</a>
                            </h3>
                            <div class="text">
                                Let's help you optimize your website and business platforms to get easily discovered by search engines through related searches.
                            </div>
                            <a href="#" class="main-button">Order Now</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-12">
                    <div class="blog-post-thumb">
                        <div class="img">
                            <img src="assets/images/blog-item-03.png" alt="">
                        </div>
                        <div class="blog-content">
                            <h3>
                                <a href="#">Content Creation & Management</a>
                            </h3>
                            <div class="text">
                                We handle website & social media content through creating modern & attractive graphics designs to be displayed for advertising.
                            </div>
                            <a href="#" class="main-button">Order Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ***** Blog End ***** -->



    <!-- ***** Pricing Plans Start ***** -->
    <section class="section colored" id="pricing-plans">
        <div class="container">
            <!-- ***** Section Title Start ***** -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-heading">
                        <h2 class="section-title">Website Pricing Plans</h2>
                    </div>
                </div>
                <div class="offset-lg-3 col-lg-6">
                    <div class="center-text">
                        <p>Please have a quick look and choose your best plan</p>
                    </div>
                </div>
            </div>
            <!-- ***** Section Title End ***** -->

            <div class="row">
                <!-- ***** Pricing Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.2s">
                    <div class="pricing-item">
                        <div class="pricing-header">
                            <h3 class="pricing-title">Frontend</h3>
                        </div>
                        <div class="pricing-body">
                            <div class="price-wrapper">
                                <span class="currency">$</span>
                                <span class="price">200.00</span>
                                <span class="period">Package</span>
                            </div>
                            <ul class="list">
                                <li class="active">Responsive</li>
                                <li class="active">Domain Emails</li>
                                <li class="active">Navigation Links</li>
                                <li>Simple Database</li>
                                <li>Web Hosting</li>
                                <li>Web Security</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            
<div class="dropdown">
  <button class="dropbtn"><a href="webs/order" style="text-decoration: none;color: white;"> Order Now </a></button>
  
</div>

                        </div>
                    </div>
                </div>
                <!-- ***** Pricing Item End ***** -->

                <!-- ***** Pricing Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.4s">
                    <div class="pricing-item active">
                        <div class="pricing-header">
                            <h3 class="pricing-title">Backend</h3>
                        </div>
                        <div class="pricing-body">
                            <div class="price-wrapper">
                                <span class="currency">$</span>
                                <span class="price">500.00</span>
                                <span class="period">Package</span>
                            </div>
                            <ul class="list">
                                <li class="active">Responsive</li>
                                <li class="active">Domain emails</li>
                                <li class="active">Front End</li>
                                <li class="active">Back End</li>
                                <li class="active" >Web hosting</li>
                                <li class="active">Web Security</li>
                                <li>Content Management System</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            
<div class="dropdown">
  <button class="dropbtn"><a href="webs/order" style="text-decoration: none;color: white;"> Order Now </a></button>
  
</div>

                        </div>
                    </div>
                </div>
                <!-- ***** Pricing Item End ***** -->

                <!-- ***** Pricing Item Start ***** -->
                <div class="col-lg-4 col-md-6 col-sm-12" data-scroll-reveal="enter bottom move 50px over 0.6s after 0.6s">
                    <div class="pricing-item">
                        <div class="pricing-header">
                            <h3 class="pricing-title">Real Time | Live</h3>
                        </div>
                        <div class="pricing-body">
                            <div class="price-wrapper">
                                <span class="currency">$</span>
                                <span class="price">3000.00</span>
                                <span class="period"> Package</span>
                            </div>
                            <ul class="list">
                                <li class="active">Real time tracking</li>
                                <li class="active">Domain emails</li>
                                <li class="active">Front End</li>
                                <li class="active">Back End</li>
                                <li class="active">Web hosting</li>
                                <li class="active">Web Security</li>
                                <li class="active">Content Management System</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            
<div class="dropdown">
  <button class="dropbtn"> <a href="webs/order" style="text-decoration: none;color: white;"> Order Now </a></button>
   
</div>

                        </div>
                    </div>
                </div>
                <!-- ***** Pricing Item End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Pricing Plans End ***** -->



    <!--- Endless Slider --->

<div class="slider">
  <div class="slide-track">

    <?php 

     //including the database connection file
include_once("admin/CApanel/webs/db/config.php");

//fetching data in descending order (lastest entry first)
//$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT * FROM web_clients WHERE approve=1"); // using mysqli_query instead

    //while($res = mysql_fetch_array($result)) { // mysql_fetch_array is deprecated, we need to use mysqli_fetch_array 
    while($row = mysqli_fetch_array($result)) {

    echo "<div class='slide'>";
      echo "<a href='https://monitor.customassistinc.com/clients/$row[link]'><img src='admin/CApanel/webs/images/".$row['image']."' alt='$row[title]' style='border-radius: 10px; width: 80%;'></a>";
    echo "</div>";


   }
    ?>  

  </div>
</div>


    <!-- ***** Contact Us Start ***** -->
    <section class="section colored" id="contact-us">
        <div class="container">
            <!-- ***** Section Title Start ***** -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-heading">
                        <h2 class="section-title">Talk To Us</h2>
                    </div>
                </div>
                <div class="offset-lg-3 col-lg-6" align="center">
                    <div class="center-text">
                        <p>Send us a message and our team will contact you in a short while.</p>
                    </div>
                </div>
            </div>
            <!-- ***** Section Title End ***** -->

            <div class="row">

                <!-- ***** Contact Form Start ***** -->
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="contact">
                        <form action="contact/index.php" method="post">
               
               <input name="sector" type="hidden" value="Custom Assist Inc."> 
               
               <div class="row">
                            <div class="col-lg-6 col-md-12 col-sm-12">
                              
                                <input name="name" type="text" placeholder="Full Name" required="">
                              
                            </div>
                            <div class="col-lg-6 col-md-12 col-sm-12">
                              
                                <input name="phone" type="number" placeholder="Phone Number" required="">
                              
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12">
                              
                                <input name="email" type="email" placeholder="Email Address" required="">
                              
                            </div>
                            <div class="col-lg-12">
                              
                                <textarea name="description" rows="6" id="message" placeholder="Your Message" required=""></textarea>
                              
                            </div>
                            <div class="col-lg-12" align="center">
                              
                                <button name="submit" type="submit">Send Message</button>
                              
                            </div>
                          </div>
                        </form>
                    </div>
                </div>
                <!-- ***** Contact Form End ***** -->
            </div>
        </div>
    </section>
    <!-- ***** Contact Us End ***** -->
    
    <!-- ***** Footer Start ***** -->
    <footer>
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <ul class="social">
                        <li><a href="https://www.facebook.com/customassist"><i class="fa fa-facebook"></i></a></li>
                        <li><a href="https://twitter.com/customassist"><i class="fa fa-twitter"></i></a></li>
                        <li><a href="https://www.instagram.com/customassistug"><i class="fa fa-instagram"></i></a></li>
                        <li><a href="https://wa.me/message/E6ATX65IPYJHK1"><i class="fa fa-whatsapp"></i></a></li>
                        <li><a href="https://pinterest.com/customassist"><i class="fa fa-pinterest"></i></a></li>
                    </ul>
                </div>
            </div>

            <div class="row">

                <div class="col-lg-12">
                    <p class="copyright"></p>
                </div>

                <p class="terms text-focus-in" style="text-align: center;width: 100%;color: orange;font-size: 14px;margin-top: -20px;margin-bottom: 10px;">
                  <a href="info">About Us</a> |
                  <a href="terms/terms">Terms</a> |
                  <a href="terms/privacy">Privacy</a> |
                  <a href="terms/payment">Payments</a> |
                  <a href="terms/delivery">Delivery</a>
                </p>

            </div>

            <div class="row">
                <div class="col-lg-12">
                    <p class="copyright">Copyright &copy; <script>document.write(new Date().getFullYear());</script> Custom Assist</p>
                </div>
                <p style="text-align: center;width: 100%;color: orange;font-size: 12px;margin-top: -20px;margin-bottom: 20px;">Powered by <a href="https://wa.me/message/E6ATX65IPYJHK1" class="flicker-5" style="color: white;">Custom Webs</a></p>
            </div>
        </div>
    </footer>
    
    <!-- jQuery -->
    <script src="assets/js/jquery-2.1.0.min.js"></script>

    <!-- Bootstrap -->
    <script src="assets/js/popper.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>

    <!-- Plugins -->
    <script src="assets/js/scrollreveal.min.js"></script>
    <script src="assets/js/waypoints.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/imgfix.min.js"></script> 
    
    <!-- Global Init -->
    <script src="assets/js/custom.js"></script>

    <!-- jQuery (Necessary for All JavaScript Plugins) -->
    <script src="js/jquery/jquery-2.2.4.min.js"></script>
    <!-- Popper js -->
    <script src="js/popper.min.js"></script>
    <!-- Bootstrap js -->
    <script src="js/bootstrap.min.js"></script>
    <!-- Plugins js -->
    <script src="js/plugins.js"></script>
    <!-- Active js -->
    <script src="js/active.js"></script>

    <script src="js/jquery.min.js"></script>
     <script src="js/bootstrap.min.js"></script>
     <script src="js/aos.js"></script>
     <script src="js/owl.carousel.min.js"></script>
     <script src="js/smoothscroll.js"></script>
     <script src="js/custom.js"></script>

     <script src="js/js/jquery-3.3.1.min.js"></script>
    <script src="js/js/popper.min.js"></script>
    <script src="js/js/bootstrap.min.js"></script>
    <script src="js/js/owl.carousel.min.js"></script>
    <script src="js/js/main.js"></script>



  </body>
</html>