<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <meta http-equiv="X-UA-Compatible" content="IE=edge">

  <meta name="copyright" content="https://customassistinc.com">
  
   <meta name="description" content="A Custom Assist Corporation">

   <meta property="og:description" content="Websites Beyond Ordinary">
   
    <meta name="author" content="Custom Assist">
    
    <link href="https://fonts.googleapis.com/css?family=Poppins:100,200,300,400,500,600,700,800,900&display=swap" rel="stylesheet">

    <!-- Favicon  -->
  <link rel="icon" href="https://monitor.customassistinc.com/assets/logos/logo-white.png">

  <title>Custom Webs &copy;</title>

  <link rel="stylesheet" href="assets/vendor/animate/animate.css">

  <link rel="stylesheet" href="assets/css/bootstrap.css">

  <link rel="stylesheet" href="assets/css/maicons.css">

  <link rel="stylesheet" href="assets/vendor/owl-carousel/css/owl.carousel.css">

  <link rel="stylesheet" href="assets/css/theme.css">

</head>
<body>

  <!-- Back to top button -->
  <div class="back-to-top"></div>

  <header>
    <nav class="navbar navbar-expand-lg navbar-light navbar-float">
      <div class="container">
        <a href="index.html" class="navbar-brand">Custom <span class="text-primary">Webs</span>
        <p style="font-size:7px;text-align:center;text-transform:uppercase;color:white;padding:2px;border-radius:50px;background:#6C55F9;">A Custom Assist Corporation</p> </a>
        

        <button class="navbar-toggler" data-toggle="collapse" data-target="#navbarContent" aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>

        <div class="navbar-collapse collapse" id="navbarContent">
          <ul class="navbar-nav ml-lg-4 pt-3 pt-lg-0">
            <li class="nav-item active">
              <a href="https://monitor.customassistinc.com" class="nav-link">Website Monitor</a>
            </li>
            <li class="nav-item">
              <a href="#websites" class="nav-link">Website Plans</a>
            </li>
            <li class="nav-item">
              <a href="#hosting" class="nav-link">Hosting Plans</a>
            </li>
            <li class="nav-item">
              <a href="https://monitor.customassistinc.com/#demos" class="nav-link">Our Templates</a>
            </li>
            <li class="nav-item">
              <a href="../index.php" class="nav-link">Custom Assist</a>
            </li>
          </ul>

          <div class="ml-auto">
            <a href="../info" class="btn btn-outline rounded-pill">Get a Quote</a>
          </div>
        </div>
      </div>
    </nav>

    <div class="page-banner home-banner">
      <div class="container h-100">
        <div class="row align-items-center h-100">
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h1 class="mb-4">Modern companies are built on great online visuals</h1>
            <p class="text-lg mb-5">Ignite the most powerfull growth engine you have ever built for your company</p>

            <a href="https://monitor.customassistinc.com" class="btn btn-primary btn-split ml-2">View Monitor <div class="fab"><span class="mai-eye"></span></div></a>
          </div>
          <div class="col-lg-6 py-3 wow zoomIn">
            <div class="img-place">
              <img src="assets/img/bg_image_1.png" alt="">
            </div>
          </div>
        </div>
      </div>
    </div>
  </header>

  <main>
    <div class="page-section features">
      <div class="container">
        <div class="row justify-content-center">
          
          <div class="col-md-6 col-lg-4 py-3 wow fadeInUp">
            <div class="d-flex flex-row">
              <div class="img-fluid mr-3">
                <img src="assets/img/icon_pattern.svg" alt="">
              </div>
              <div>
                <h5>Website Development</h5>
                <p>Frontend & Backend Responsive Websites</p>
              </div>
            </div>
          </div>

          <div class="col-md-6 col-lg-4 py-3 wow fadeInUp">
            <div class="d-flex flex-row">
              <div class="img-fluid mr-3">
                <img src="assets/img/icon_pattern.svg" alt="">
              </div>
              <div>
                <h5>Website Hosting Services</h5>
                <p>Domain Hosting (Names, Emails, SSL Certificate).</p>
              </div>
            </div>
          </div>
  
          <div class="col-md-6 col-lg-4 py-3 wow fadeInUp">
            <div class="d-flex flex-row">
              <div class="img-fluid mr-3">
                <img src="assets/img/icon_pattern.svg" alt="">
              </div>
              <div>
                <h5>Search Engine Optimization</h5>
                <p>Keyword Search, Search Suggestions, Related Searches.</p>
              </div>
            </div>
          </div>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 py-3 wow zoomIn">
            <div class="img-place text-center">
              <img src="assets/img/bg_image_2.png" alt="">
            </div>
          </div>
          <div class="col-lg-6 py-3 wow fadeInRight">
            <h2 class="title-section">We're A <span class="marked">Dynamic</span> Team of <span class="marked">Creative</span> Individuals</h2>
            <div class="divider"></div>
            <p>Our team enforces modern responsive websites running top notch user friendly features bringing out the best of User Interface (UI) & User Experience (UX).</p>
            
            <a href="#" class="btn btn-primary">View Pricing</a>
          </div>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section counter-section">
      <div class="container">
        <div class="row align-items-center text-center">
          <div class="col-lg-4">
            <p>Happy Clients</p>
            <h2><span class="number" data-number="34"></span></h2>
          </div>
          <div class="col-lg-4">
            <p>New Entries</p>
            <h2><span class="number" data-number="20"></span></h2>
          </div>
          <div class="col-lg-4">
            <p>Growth Rate</p>
            <h2><span class="number" data-number="73"></span>%</h2>
          </div>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section">
      <div class="container">
        <div class="row">
          <div class="col-lg-6 py-3 wow fadeInLeft">
            <h2 class="title-section">Are you <span class="marked">ready to</span> meet your business <span class="marked">objectives</span></h2>
            <div class="divider"></div>
            <p class="mb-5">We provide marketing services to startups & established businesses looking forward to push their digital visuals to lead generation & communication.</p>
            <a href="#" class="btn btn-primary">More Details</a>
            <a href="#" class="btn btn-outline ml-2">See pricing</a>
          </div>
          <div class="col-lg-6 py-3 wow zoomIn">
            <div class="img-place text-center">
              <img src="assets/img/bg_image_3.png" alt="">
            </div>
          </div>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section">
      <div class="container">
        <div class="text-center wow fadeInUp">
          <div class="subhead">Why Choose Us</div>
          <h2 class="title-section"><span class="marked">Creativity</span> is Our <span class="marked">Priority</span></h2>
          <div class="divider mx-auto"></div>
        </div>
  
        <div class="row mt-5 text-center">
          <div class="col-lg-4 py-3 wow fadeInUp">
            <div class="display-3"><span class="mai-shapes"></span></div>
            <h5>High Performance</h5>
            <p>Websites developed to process requests at a high speed rate to perform at a high standard.</p>
          </div>
          <div class="col-lg-4 py-3 wow fadeInUp">
            <div class="display-3"><span class="mai-shapes"></span></div>
            <h5>User Friendly</h5>
            <p>Easy to navigate through pages and features with no difficulties in understanding functionality.</p>
          </div>
          <div class="col-lg-4 py-3 wow fadeInUp">
            <div class="display-3"><span class="mai-shapes"></span></div>
            <h5>Friendly Prices</h5>
            <p>Choose through different plans that suit your needs at unbeatable prices.</p>
          </div>
        </div>
      </div> <!-- .container -->
    </div> 



    <!-- .page-section -->
  <div id="websites" class="page-section border-top">
      <div class="container">
        <div class="text-center wow fadeInUp">
          <h2 class="title-section">Pricing Plans</h2>
          <div class="divider mx-auto"></div>
        </div>
  
        <div class="row justify-content-center">
          <div class="col-12 col-lg-auto py-3 wow fadeInLeft">
            <div class="card-pricing">
              <div class="header">
                <div class="price-icon"><span class="mai-business"></span></div>
                <div class="price-title">Frontend</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">210</h2><b>/</b>
                  <span>UGX 750,000</span>
                </div>
                <div class="price-info">
                  <p>User Interface & Experience</p>
                </div>
              </div>
              <div class="footer">
                <a  onclick="openPop1()" class="btn btn-outline rounded-pill">Place Order</a>
              </div>
            </div>
          </div>
  
          <div class="col-12 col-lg-auto py-3 wow fadeInUp">
            <div class="card-pricing active">
              <div class="header">
                <div class="price-labled">Promo</div>
                <div class="price-icon"><span class="mai-people"></span></div>
                <div class="price-title">Backend</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">300</h2><b>/</b>
                  <span>UGX 1,000,000</span>
                </div>
                <div class="price-info">
                  <p>User & Management Experience</p>
                </div>
              </div>
              <div class="footer">
                <a  onclick="openPop2()" class="btn btn-outline rounded-pill">Place Order</a>
              </div>
            </div>
          </div>
  
          <div class="col-12 col-lg-auto py-3 wow fadeInRight">
            <div class="card-pricing">
              <div class="header">
                <div class="price-icon"><span class="mai-rocket-outline"></span></div>
                <div class="price-title">E-commerce</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">700</h2><b>/</b>
                  <span>UGX 2,500,000</span>
                </div>
                <div class="price-info">
                  <p>Online Store & Payments</p>
                </div>
              </div>
              <div class="footer">
                <a  onclick="openPop3()" class="btn btn-outline rounded-pill">Place Order</a>
              </div>
            </div>
          </div>
          
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->




    <div id="pop1" class="overlay">
  
  <div class="overlay-content overlay-background-overlay-white">

    
        <div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop1()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Front End</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs">

              <input type="hidden" name="webtype" value="Front End Website">
              
              </div>
              <div class="py-2">
                <input type="text" name="title" class="form-control" placeholder="Title of Website">
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <div class="py-2">
                <textarea rows="6" name="description" class="form-control" placeholder="Describe your desired website.."></textarea>
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>
      
 
  </div>
</div>


<script>
function openPop1() {
  document.getElementById("pop1").style.display = "block";
}

function closePop1() {
  document.getElementById("pop1").style.display = "none";
}
</script>




<div id="pop2" class="overlay">
  <div class="overlay-content overlay-background-overlay-white">

    <div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop2()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Back End</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs">

              <input type="hidden" name="webtype" value="Back End Website">
              
              </div>
              <div class="py-2">
                <input type="text" name="title" class="form-control" placeholder="Title of Website">
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <div class="py-2">
                <textarea rows="6" name="description" class="form-control" placeholder="Describe your desired website.."></textarea>
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>

  </div>
</div>

<script>
function openPop2() {
  document.getElementById("pop2").style.display = "block";
}

function closePop2() {
  document.getElementById("pop2").style.display = "none";
}
</script>




<div id="pop3" class="overlay">
  
  <div class="overlay-content overlay-background-overlay-white">
  

<div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop3()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">E-commerce</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs">

              <input type="hidden" name="webtype" value="E-commerce Website">
              
              </div>
              <div class="py-2">
                <input type="text" name="title" class="form-control" placeholder="Title of Website">
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <div class="py-2">
                <textarea rows="6" name="description" class="form-control" placeholder="Describe your desired website.."></textarea>
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>

  </div>
</div>

<script>
function openPop3() {
  document.getElementById("pop3").style.display = "block";
}

function closePop3() {
  document.getElementById("pop3").style.display = "none";
}
</script>







    <!-- .hosting-section -->
  <div id="hosting" class="page-section border-top">
      <div class="container">
        <div class="text-center wow fadeInUp">
          <h2 class="title-section">Hosting Plans</h2>
          <div class="divider mx-auto"></div>
        </div>
  
        <div class="row justify-content-center">
          <div class="col-12 col-lg-auto py-3 wow fadeInLeft">
            <div class="card-pricing">
              <div class="header">
                <div class="price-icon"><span class="mai-people"></span></div>
                <div class="price-title">Basic</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">50</h2>
                  <span class="period">/ UGX 180,000</span>
                </div>
                <div class="price-tag price-tag-renew">
                  <b>Renews at</b> 
                  <span class="currency">$</span>
                  <h2 class="display-4">35</h2>
                  <span class="period">/ year</span>
                </div>
                <div class="price-info">
                  <p>Domain Name</p>
                  <p>3 Email Accounts</p>
                </div>
              </div>
              <div class="footer">
                <a onclick="openPop4()" class="btn btn-outline rounded-pill">Choose Plan</a>
              </div>
            </div>
          </div>
  
          <div class="col-12 col-lg-auto py-3 wow fadeInUp">
            <div class="card-pricing active">
              <div class="header">
                <div class="price-labled">Promo</div>
                <div class="price-icon"><span class="mai-business"></span></div>
                <div class="price-title">Standard</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">80</h2>
                  <span class="period">/ UGX 280,000</span>
                </div>
                <div class="price-tag price-tag-renew">
                  <b>Renews at</b> 
                  <span class="currency">$</span>
                  <h2 class="display-4">50</h2>
                  <span class="period">/ year</span>
                </div>
                <div class="price-info">
                  <p>Domain Name</p>
                  <p>10 Email Accounts</p>
                </div>
              </div>
              <div class="footer">
                <a onclick="openPop5()" class="btn btn-outline rounded-pill">Choose Plan</a>
              </div>
            </div>
          </div>
  
          <div class="col-12 col-lg-auto py-3 wow fadeInRight">
            <div class="card-pricing">
              <div class="header">
                <div class="price-icon"><span class="mai-rocket-outline"></span></div>
                <div class="price-title">Premium</div>
              </div>
              <div class="body py-3">
                <div class="price-tag">
                  <span class="currency">$</span>
                  <h2 class="display-4">112</h2>
                  <span class="period">/ UGX 400,000</span>
                </div>
                <div class="price-tag price-tag-renew">
                  <b>Renews at</b> 
                  <span class="currency">$</span>
                  <h2 class="display-4">90</h2>
                  <span class="period">/ year</span>
                </div>
                <div class="price-info">
                  <p>Domain Name</p>
                  <p>20 Email Accounts</p>
                </div>
              </div>
              <div class="footer">
                <a onclick="openPop6()" class="btn btn-outline rounded-pill">Choose Plan</a>
              </div>
            </div>
          </div>
          
        </div>
      </div> <!-- .container -->
    </div> <!-- .hosting-section -->


    <div id="pop4" class="overlay">
  
  <div class="overlay-content overlay-background-overlay-white">

    
        <div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop4()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Basic</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs Hosting">

              <input type="hidden" name="webtype" value="Basic">

              <input type="hidden" name="title" class="form-control" value="Null">

              <input type="hidden" name="description" class="form-control" value="Null">
              
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>
      
 
  </div>
</div>


<script>
function openPop4() {
  document.getElementById("pop4").style.display = "block";
}

function closePop4() {
  document.getElementById("pop4").style.display = "none";
}
</script>




<div id="pop5" class="overlay">
  <div class="overlay-content overlay-background-overlay-white">

    <div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop5()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Standard</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs Hosting">

              <input type="hidden" name="webtype" value="Standard">

              <input type="hidden" name="title" class="form-control" value="Null">

              <input type="hidden" name="description" class="form-control" value="Null">
              
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>

  </div>
</div>

<script>
function openPop5() {
  document.getElementById("pop5").style.display = "block";
}

function closePop5() {
  document.getElementById("pop5").style.display = "none";
}
</script>




<div id="pop6" class="overlay">
  
  <div class="overlay-content overlay-background-overlay-white">
  

<div class="align-items-center" align="center">

          <span class="closebtn" onclick="closePop6()" title="Close Overlay">×</span>
         
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Premium</h2>
            <div class="divider"></div>
            
            <form action="order/insert.php" method="post">
              <div class="py-2">
              
              <input type="hidden" name="sector" value="Custom Webs Hosting">

              <input type="hidden" name="webtype" value="Premium">

              <input type="hidden" name="title" class="form-control" value="Null">

              <input type="hidden" name="description" class="form-control" value="Null">
              
              </div>
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Your Names">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email">
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Place Order</button>
            </form> <br>

        <p>By <b>placing order</b>, you agree to our <a href="pages/terms">Terms And Conditions</a>. Please read carefully, Thank You!</p>
          </div>
        </div>

  </div>
</div>

<script>
function openPop6() {
  document.getElementById("pop6").style.display = "block";
}

function closePop6() {
  document.getElementById("pop6").style.display = "none";
}
</script>




  
    <div class="page-section bg-light">
      <div class="container">
        
        <div class="owl-carousel wow fadeInUp" id="testimonials">
          <div class="item">
            <div class="row align-items-center">
              <div class="col-md-6 py-3">
                <div class="testi-image">
                  <img src="assets/img/person/person_1.jpg" alt="">
                </div>
              </div>
              <div class="col-md-6 py-3">
                <div class="testi-content">
                  <p>It is a distinct pleasure for me to recommend Custom Webs to any and all interested parties. They have been professional, comprehensive and competent throughout the process of our working together. We feel that we have established a relationship with them for years to come. The reaction to our new web site has been overwhelmingly positive; as one commented the site is “FANTASTIC.” The same can be said for our view of Custom Webs' work for us.</p>
                  <div class="entry-footer">
                    <strong>Melvin Platje</strong> &mdash; <span class="text-grey">CEO Slurin Group</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
  
          <div class="item">
            <div class="row align-items-center">
              <div class="col-md-6 py-3">
                <div class="testi-image">
                  <img src="assets/img/person/person_2.jpg" alt="">
                </div>
              </div>
              <div class="col-md-6 py-3">
                <div class="testi-content">
                  <p>I would highly recommend Custom Webs. They are great to work with. The traffic to our website has increased thanks to their SEO program.</p>
                  <div class="entry-footer">
                    <strong>George Burke</strong> &mdash; <span class="text-grey">CEO Letro</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
  
        </div>
      </div> <!-- .container -->
    </div>


     <!-- .page-section -->
  
    <div class="page-section">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6 py-3 wow fadeInUp">
            <h2 class="title-section">Get in Touch</h2>
            <div class="divider"></div>
            <p> Custom Webs is a Custom Assist company.</p>
  
            <ul class="contact-list">
              <li>
                <div class="icon"><span class="mai-map"></span></div>
                <div class="content">Kampala, Munyonyo</div>
              </li>
              <li>
                <div class="icon"><span class="mai-mail"></span></div>
                <div class="content"><a href="mailto:webs@customassistinc.com">webs@customassistinc.com</a></div>
              </li>
              <li>
                <div class="icon"><span class="mai-phone-portrait"></span></div>
                <div class="content"><a href="tel:256785196012">+256 785 196 012</a></div>
              </li>
            </ul>
          </div>
          <div class="col-lg-6 py-3 wow fadeInUp">
            <div class="subhead">Contact Us</div>
            <h2 class="title-section">Drop Us a Line</h2>
            <div class="divider"></div>
            
            <form action="contact/index.php" method="post">
            
            <input type="hidden" name="sector" value="Custom Webs">
              
              <div class="py-2">
                <input type="text" name="name" class="form-control" placeholder="Full name">
              </div>
              <div class="py-2">
                <input type="number" name="phone" class="form-control" placeholder="Phone Number">
              </div>
              <div class="py-2">
                <input type="email" name="email" class="form-control" placeholder="Email Address">
              </div>
              <div class="py-2">
                <textarea rows="6" name="description" class="form-control" placeholder="Enter message"></textarea>
              </div>
              <button type="submit" name="submit" class="btn btn-primary rounded-pill mt-4">Send Message</button>
            </form>
          </div>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section border-top">
      <div class="container">
        <div class="text-center wow fadeInUp">
          <div class="subhead">Our Dictionary</div>
          <h2 class="title-section">Read about our <span class="marked">Terms</span></h2>
          <div class="divider mx-auto"></div>
        </div>
        <div class="row my-5 card-blog-row">

          <div class="col-md-6 col-lg-3 py-3 wow fadeInUp">
            <div class="card-blog">
              <div class="header">
                <div class="entry-footer">
                  <div class="post-author"></div>
                </div>
              </div>
              <div class="body">
                <div class="post-title"><a href="#">Front-end</a></div>
                <div class="post-excerpt" style="color: white;">The front-end of a website is the part that users interact with. Also known as the User Interface (UI). Everything that you see when you're navigating around the Internet, from fonts and colors to dropdown menus and sliders, is a combo of HTML, CSS & JavaScript.</div>
              </div>
              
            </div>
          </div>

          <div class="col-md-6 col-lg-3 py-3 wow fadeInUp">
            <div class="card-blog">
              <div class="header">
                <div class="entry-footer">
                  <div class="post-author"></div>
                </div>
              </div>
              <div class="body">
                <div class="post-title"><a href="#">Back-end</a></div>
                <div class="post-excerpt">The back-end of a website is everything that goes on behind the screens, from servers to databases & much more. In a nutshell it is everything that the user doesn't see, it is the beating heart / the churning engine of a website, responding to requests made by the user by sending information from the back end to the front end to be displayed. <br>
                The back-end of a website comprises of things like servers, databases, operating systems, APIs and much more, all to ensure that the user is served with correct information as quickly as possible.</div>
              </div>
              
            </div>
          </div>

          <div class="col-md-6 col-lg-3 py-3 wow fadeInUp">
            <div class="card-blog">
              <div class="header">
                <div class="entry-footer">
                  <div class="post-author"></div>
                </div>
              </div>
              <div class="body">
                <div class="post-title"><a href="#">E-commerce</a></div>
                <div class="post-excerpt">A website that allows people to buy & sell physical goods, services & digital products over the internet rather than at a brick-and-motor location. Through an e-commerce website, a business can process orders, accept payments, manage shipping & logistics, & provide customer service. <br>
                The term "e-commerce" simply means the sale of goods & services on the internet. In its most basic form it involves electronically transferring funds & data between 2 or more parties.</div>
              </div>
              
            </div>
          </div>

          <div class="col-md-6 col-lg-3 py-3 wow fadeInUp">
            <div class="card-blog">
              <div class="header">
                
                <div class="entry-footer">
                  <div class="post-author"></div>
                </div>
              </div>
              <div class="body">
                <div class="post-title"><a href="blog-single.html">Responsive Web Design (R.W.D)</a></div>
                <div class="post-excerpt">Responsive web design is a web development approach that creates dynamic changes to the appearance of a website, depending on the screen size & orientation of the device being used to view it. RWD is one approach to the problem of designing for the multitude of devices available to customers, ranging from tiny phones to huge desktop monitors.</div>
              </div>
              
            </div>
          </div>
        </div>
  
        <div class="text-center">
          <a href="dictionary" class="btn btn-outline-primary rounded-pill">Discover More</a>
        </div>
      </div> <!-- .container -->
    </div> <!-- .page-section -->
  
    <div class="page-section client-section">
      <div class="container-fluid">
        <div class="row row-cols-2 row-cols-md-3 row-cols-lg-5 justify-content-center">

<?php 

     //including the database connection file
include_once("admin/webs/db/config.php");

//fetching data in descending order (lastest entry first)
//$result = mysql_query("SELECT * FROM users ORDER BY id DESC"); // mysql_query is deprecated
$result = mysqli_query($mysqli, "SELECT * FROM web_clients WHERE approve=1"); // using mysqli_query instead

    //while($res = mysql_fetch_array($result)) { // mysql_fetch_array is deprecated, we need to use mysqli_fetch_array 
    while($row = mysqli_fetch_array($result)) {

          echo "<div class='item wow bounceIn'>";
            echo "<a href='https://monitor.customassistinc.com/clients/$row[link]'><img src='admin/webs/images/".$row['image']."' alt='$row[title]' style='border-radius: 10px; width: 80%;'></a>";
          echo "</div>";

               
   }
    ?>  

        </div>
      </div> <!-- .container-fluid -->
    </div> <!-- .page-section -->
  </main>

  <footer class="page-footer">
    <div class="container">
      <div class="row justify-content-center mb-5">
        <div class="col-lg-3 py-3">
          <h3>Custom <span class="text-primary">Webs</span></h3>

          <p><a href="mailto:webs@customassistinc.com">webs@customassistinc.com</a></p>
          <p><a href="tel:+256785196012">+256 785 196 012</a> <br> <a href="tel:+256701539540">+256 701 539 540</a> <br> <a href="tel:+256726159964">+256 726 159 964</a></p>
        </div>
        
        <div class="col-lg-3 py-3">
          <h5>About</h5>
          <ul class="footer-menu">
            <li><a href="about">About Us</a></li>
            <li><a href="terms">Terms & Conditions</a></li>
            <li><a href="https://customassistinc.com/terms/privacy">Privacy Policies</a></li>
          </ul>
        </div>
        <div class="col-lg-3 py-3">
          <h5>Drop A Review</h5>
          <form action="contact/review">
            <input type="text" class="form-control" placeholder="Type Review Here..">
          </form>

          <div class="sosmed-button mt-4">
            <a href="https://www.facebook.com/customassist"><span class="mai-logo-facebook-f"></span></a>
            <a href="https://twitter.com/customassist"><span class="mai-logo-twitter"></span></a>
            <a href="https://www.instagram.com/customassistug"><span class="mai-logo-instagram"></span></a>
            <a href="https://pinterest.com/customassist"><span class="mai-logo-pinterest"></span></a>
            <a href="https://wa.me/message/E6ATX65IPYJHK1"><span class="mai-logo-whatsapp"></span></a>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-sm-6 py-2">
          
          <p style="text-align: center;width: 100%;font-size: 12px;margin-top: -20px;margin-bottom: 20px;"> &copy; <script>document.write(new Date().getFullYear());</script> Custom Assist Inc. All rights reserved</p>

          <p style="text-align: center;width: 100%;color: orange;font-size: 12px;margin-top: -20px;margin-bottom: 20px;">Powered by <a href="https://wa.me/message/E6ATX65IPYJHK1" class="flicker-5" style="color: black;">Custom Webs</a></p>
        </div>
        
      </div>
    </div> <!-- .container -->
  </footer> <!-- .page-footer -->


  <script src="assets/js/jquery-3.5.1.min.js"></script>

  <script src="assets/js/bootstrap.bundle.min.js"></script>

  <script src="assets/vendor/wow/wow.min.js"></script>

  <script src="assets/vendor/owl-carousel/js/owl.carousel.min.js"></script>

  <script src="assets/vendor/waypoints/jquery.waypoints.min.js"></script>

  <script src="assets/vendor/animateNumber/jquery.animateNumber.min.js"></script>

  <script src="assets/js/google-maps.js"></script>

  <script src="assets/js/theme.js"></script>






    <!--Auto Popup Script-->
    <script type="text/javascript">
window.addEventListener("load", function(){
    setTimeout(
        function open(event){
            document.querySelector(".popup").style.display = "block";
        },
        100000
    )
});


document.querySelector("#close").addEventListener("click", function(){
    document.querySelector(".popup").style.display = "none";
});
    </script>






</body>
</html>