<?php
  session_start();
?>

<html>
<head>	
	<title>Admin Suite | Monitor &copy;</title>


  <!-- Favicon  -->
    <link rel="icon" href="../../../images/logo-white.png">

  <!--Boxicons-->
	<link href="assets/boxicon.min.css" rel="stylesheet">


  <!--CSS-->
  <link rel="stylesheet" type="text/css" href="assets/css/bootstrap/bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="assets/datatable/dataTable.bootstrap.min.css">



<style type="text/css">


body {
  background: white;
}

img.logo {
  width: 200px;
}

.top-btns {
  padding: 20px;
}


/**Image**/

 .upload-wrapper {
    margin-bottom: 40px;
    width: 80%;
    height: 100px;
    border-radius: 10px;
}

.upload-btn-wrapper input[type=file] {
  font-size: 100px;
  position: absolute;
  width: 40%;
  height: 140px;
  left: 240px;
  top: -5px;
  opacity: 0;
  z-index: 9;
}

.upload-btn-wrapper .btn img {
    width: 40%;
    border-radius: 10px;
}

#output_image1 {
    margin-top: -120px;
  width: 40%;
  height: 120px;
    border-radius: 10px;
}

img#output_image1{
  width: 40%;
  height: 120px;
  object-fit: cover;
}





h1 {
    text-transform: uppercase;
    font-weight: bold;
    font-size: 50px;
    color: black;
    text-align: center;
}


h2 {
    font-weight: bold;
    font-size: 25px;
    color: dodgerblue;
    text-align: center;
}


.sec-pad{
  padding: 20px 20px 20px 20px;
}


/*Industry*/

.industry-section {
    margin-bottom: 20px;
    border-radius: 10px;
    box-shadow: 0 0 4px 0 dodgerblue;
}



.industry-section h3 {
    font-weight: bold;
    font-size: 20px;
    color: dodgerblue;
    text-align: center;
}




.industry-section .bx-trash {
	color: red;
}


.industry-section .bx-edit {
	color: dodgerblue;
}


.industry-section h6{
    font-weight: bold;
    font-size: 16px;
    text-transform: uppercase;
    text-align: center;
    color: dodgerblue;
    margin-top: 10px;
    margin-bottom: 10px;
}

.industry-section .id{
  margin: 5px;
  text-align: center;
  font-size: 12px;
  color: #FEFAFA;
  width: 35px;
  height: 35px;
  padding: 10px;
  border-radius: 50px;
  background: dodgerblue;
  box-shadow: 1px 1px 2px 0 rgba(0, 0, 0, 0.2);
}


.industry-section img{
    width: 100%;
	margin-bottom: 10px;
}

.industry-section b {
  font-size: 14px;
	color: dodgerblue;
  margin-left: 2px;
	padding: 5px 10px;
}


.industry-section b:nth-child(1) {
	border-top-right-radius: 0;
	border-bottom-right-radius: 0;
}


.industry-section b:nth-child(2) {
	border-top-left-radius: 0;
	border-bottom-left-radius: 0;
}


.industry-section .price {
	font-weight: bold;
	font-size: 20px;
	text-align: center;
	color: dodgerblue;
	margin-top: 20px;
	margin-bottom: 20px;
}



.count {
  text-align: center;
  font-weight: bold;
  color: grey;
  text-decoration: underline;
}

.links a {
  margin: 0 20px 0 0;
  font-size: 20px;
}

.approve-links {
  margin: 30px 20px 5px 20px;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  background: gray;
}

.approve-links a {
  color: white !important;
  font-size: 12px;
  margin: 5px;
}


.filter-links {
  margin: 0 20px 20px 20px;
  color: white;
  border: none;
  border-radius: 5px;
  padding: 10px 20px;
  background: gray;
}

.filter-links a {
  display: inline-block;
  color: white !important;
  font-size: 16px;
  margin: 5px 2px;
  padding: 5px 10px 5px 10px;
  border-radius: 20px;
  background: rgba(0, 0, 0, 0.2);
}



.search {
  margin: 30px 20px 50px 20px;
}

.search form input[type=text] {
padding: 5px;
border: 0;
border-bottom: 1px solid dodgerblue;
background: none;
transition: 1s;
}

.search form input[type=text]:hover {
  width: 40%;
border-bottom: 1px solid dodgerblue;
}

.search form button {
  color: dodgerblue;
padding: 5px;
border: 0;
background: none;
}

.search form button i:hover {
  width: 30%;
}


      
.progress {
  width: 70%;
  max-width: 160px;
  height: 6px;
  background: #e1e4e8;
  border-radius: 3px;
  overflow: hidden;
}
.progress .progress-bar {
  display: block;
  height: 100%;
  background: linear-gradient(90deg, #ffd33d, #ea4aaa 17%, #b34bff 34%, #01feff 51%, #ffd33d 68%, #ea4aaa 85%, #b34bff);
  background-size: 300% 100%;
  -webkit-animation: progress-animation 2s linear infinite;
          animation: progress-animation 2s linear infinite;
}

@-webkit-keyframes progress-animation {
  0% {
    background-position: 100%;
  }
  100% <span>Complete</span>{
    background-position: 0;
  }
}

@keyframes progress-animation {
  0% {
    background-position: 100%;
  }
  100% <span>Complete</span>{
    background-position: 0;
  }
}



</style>

</head>

<body>

  <div align="center">
  <img src="../../../images/logo-white.png" class="logo text-center">
  </div>
  
      <?php
        if(isset($_SESSION['error'])){
          echo
          "
          <div class='alert alert-danger text-center'>
            <button class='close'>&times;</button>
            ".$_SESSION['error']."
          </div>
          ";
          unset($_SESSION['error']);
        }
        if(isset($_SESSION['success'])){
          echo
          "
          <div class='alert alert-success text-center'>
            <button class='close'>&times;</button>
            ".$_SESSION['success']."
          </div>
          ";
          unset($_SESSION['success']);
        }
      ?>
      
      <div class="top-btns">
        <a href="#addnew" data-toggle="modal" class="btn btn-primary" style="background: dodgerblue;border: none;position: fixed;z-index: 9;"><span class="glyphicon glyphicon-plus"></span> New</a>
        <a href="categories" class="btn btn-success pull-right" style="background: dodgerblue;border: none;"><span class="bx bx-category" style="font-size: 25px;"></span></a>
      </div>


<br> <br>

<div class="count">

      <?php 

 include_once('db/count_db.php');

// of college_data table 

$sql = "SELECT count(*) FROM web_clients"; 

$result = $conn->query($sql); 

  
// Display data on web page 

while($row = mysqli_fetch_array($result)) { 

    echo $row['count(*)']. " websites in the Custom Assist Database"; 

    echo "<br />"; 
} 

   
// Close the connection 

$conn->close(); 

  
?>

</div>



<!--Search-->


<div class="search" align="center">
  
  <form action="search.php" method="post">
    
    <input type="text" name="valueToSearch" placeholder="Search Database" required>

    <button name="search"><i class="bx-fw bx bx-search"></i></button>

  </form>

</div>


     


     <!--Start Websites-->
      
 <section class="sec-pad" align="center">
    

       <h2>Websites</h2>

                <div class="row">


            <?php
              include_once('db/connection.php');
              $sql = "SELECT * FROM web_clients";

              //use for MySQLi-OOP
              $query = $conn->query($sql);
              while($row = $query->fetch_assoc()){

        echo "<div class='col-12 col-sm-12 col-md-6 col-lg-4'>";

        echo "<div class='industry-section wow fadeInUpBig' data-wow-delay='0.2s'>";

        echo "<div class='id'>".$row['id']."</div>";

                echo "<img src='images/".$row['image']."'>";

                echo "<div class='details' align='center'>";

            echo "<h3>".$row['title']."</h3>";

            echo "<p>".$row['slogan']."</p>";

         echo "</div> <br>";

         echo "<div align='center' class='progress-item' style='font-weight: bold;'>";
                            echo "<div class='progress' align='center'>";
  echo "<span class='progress-bar' style='width: $row[progress]%'></span>";
                            echo "</div>";
                            echo "<div>";
                            echo "<b>".$row['progress']."%</b>";
                            if ($row['action']=="") { echo "<span>Not Defined</span>"; } elseif ($row['action']==1) { echo "<span>Pending</span>"; } elseif ($row['action']==2) { echo "<span>Complete</span>"; } elseif ($row['action']==3) { echo "<span>On Hold</span>"; } elseif ($row['action']==4) { echo "<span>Canceled</span>"; }

                            echo "</div>";

                            echo "</div> <br>";


         echo "<div align='center'>";


            echo "<div class='links'>";
            
            echo "<a href='https://monitor.customassistinc.com/clients/$row[link]' style='font-size: 12px;text-align: center;'>https://monitor.customassistinc.com/clients/$row[link]</a>";

            echo "</div>";

            echo "<br>";

            echo "<div class='links'>";

             echo "<a href='https://www.facebook.com/$row[facebook]'><i class='bx bxl-facebook'></i></a>";

             echo "<a href='https://twitter.com/$row[twitter]'><i class='bx bxl-twitter'></i></a>";

             echo "<a href='https://www.instagram.com/$row[instagram]'><i class='bx bxl-instagram'></i></a>";

             echo "<a href='$row[linkedin]'><i class='bx bxl-linkedin'></i></a>";

             echo "<a href='https://wa.me/message/$row[whatsapp]'><i class='bx bxl-whatsapp'></i></a>";

             echo "</div>";
            
         echo "</div>";

             echo "<div class='price'>Ush"." ".number_format ($row['fee'])."</div>";    

            echo "<div align='center'><b>".date("jS M, Y", strtotime($row['start_date']))." - ".date("jS M, Y", strtotime($row['end_date']))."</b></div>";

             echo "<hr style='color: dodgerblue;'>";

                     echo "<div align='center'>";

          echo "<div class='approve-links'>";

          if ($row['action']=="Select") { echo "<a href=\"action/pending.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is still pending?')\">Pending</a> | <a href=\"action/complete.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is complete?')\">Complete</a> | <a href=\"action/hold.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to put this website on hold?')\">On Hold</a> | <a href=\"action/cancel.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to cancel this website?')\">Canceled</a>"; }

        elseif ($row['action']=="") { echo "<a href=\"action/pending.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is still pending?')\">Pending</a> | <a href=\"action/complete.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is complete?')\">Complete</a> | <a href=\"action/hold.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to put this website on hold?')\">On Hold</a> | <a href=\"action/cancel.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to cancel this website?')\">Canceled</a>"; }

          elseif ($row['action']==1) { echo "<a><i class='bx-fw bx bxs-check-circle'></i>Pending</a> | <a href=\"action/complete.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is complete?')\">Complete</a> | <a href=\"action/hold.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to put this website on hold?')\">On Hold</a> | <a href=\"action/cancel.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to cancel this website?')\">Canceled</a>"; } 

          elseif ($row['action']==2) { echo "<a href=\"action/pending.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is still pending?')\">Pending</a> | <a><i class='bx-fw bx bxs-check-circle'></i>Complete</a> | <a href=\"action/hold.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to put this website on hold?')\">On Hold</a> | <a href=\"action/cancel.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to cancel this website?')\">Canceled</a>"; }

          elseif ($row['action']==3) { echo "<a href=\"action/pending.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is still pending?')\">Pending</a> | <a href=\"action/complete.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is complete?')\">Complete</a> | <a><i class='bx-fw bx bxs-check-circle'></i>On Hold</a> | <a href=\"action/cancel.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to cancel this website?')\">Canceled</a>"; } 

          elseif ($row['action']==4) { echo "<a href=\"action/pending.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is still pending?')\">Pending</a> | <a href=\"action/complete.php?id=$row[id]\" onClick=\"return confirm('Are you sure this website is complete?')\">Complete</a> | <a href=\"action/hold.php?id=$row[id]\" onClick=\"return confirm('Are you sure you want to put this website on hold?')\">On Hold</a> | <a><i class='bx-fw bx bxs-check-circle'></i>Canceled</a>"; }
    
        echo "</div> <br> <br>";



        echo "<a href='#edit_".$row['id']."' data-toggle='modal'><i class='bx-fw bx bx-edit'></i></a> | <a href='#delete_".$row['id']."' data-toggle='modal'><i class='bx-fw bx bx-trash'></i></a>";

         echo "</div>";




 

      echo "<br>";  

    echo "</div>";
    
    echo "</div>";

     include('edit_delete_modal.php');

     }
  ?>

    </div>

</section>


     <!--End Websites-->

     



     <?php include('add_modal.php') ?>

<script src="assets/js/jquery/jquery.min.js"></script>
<script src="assets/js/bootstrap.min.js"></script>
<script src="assets/js/datatable/jquery.dataTables.min.js"></script>
<script src="assets/js/datatable/dataTable.bootstrap.min.js"></script>

<!-- Upload Image JS -->
<script src="assets/js/upload_img_script.js"></script>


<!-- generate datatable on our table -->
<script>
$(document).ready(function(){
  //inialize datatable
    $('#myTable').DataTable();

    //hide alert
    $(document).on('click', '.close', function(){
      $('.alert').hide();
    })
});
</script>


</body>
</html>