<?php
/**
 * ShipmentServiceOptionsNotification
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentServiceOptionsNotification Class Doc Comment
 *
 * @category Class
 * @description Container for the Quantum View Notification (QVN) is valid for all shipments including Return service, Import Control and Returns Flexible Access.  Valid return service types are: ERL, PRL, PNM, RS1, or RS3.   The shipment level notification is valid for forward and return international shipments as well as for domestic shipments (for US and PR).
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentServiceOptionsNotification implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentServiceOptions_Notification';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'notification_code' => 'string',
        'e_mail' => '\UPS\Shipping\Shipping\NotificationEMail',
        'voice_message' => '\UPS\Shipping\Shipping\NotificationVoiceMessage',
        'text_message' => '\UPS\Shipping\Shipping\NotificationTextMessage',
        'locale' => '\UPS\Shipping\Shipping\NotificationLocale'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'notification_code' => null,
        'e_mail' => null,
        'voice_message' => null,
        'text_message' => null,
        'locale' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'notification_code' => 'NotificationCode',
        'e_mail' => 'EMail',
        'voice_message' => 'VoiceMessage',
        'text_message' => 'TextMessage',
        'locale' => 'Locale'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'notification_code' => 'setNotificationCode',
        'e_mail' => 'setEMail',
        'voice_message' => 'setVoiceMessage',
        'text_message' => 'setTextMessage',
        'locale' => 'setLocale'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'notification_code' => 'getNotificationCode',
        'e_mail' => 'getEMail',
        'voice_message' => 'getVoiceMessage',
        'text_message' => 'getTextMessage',
        'locale' => 'getLocale'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['notification_code'] = isset($data['notification_code']) ? $data['notification_code'] : null;
        $this->container['e_mail'] = isset($data['e_mail']) ? $data['e_mail'] : null;
        $this->container['voice_message'] = isset($data['voice_message']) ? $data['voice_message'] : null;
        $this->container['text_message'] = isset($data['text_message']) ? $data['text_message'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['notification_code'] === null) {
            $invalidProperties[] = "'notification_code' can't be null";
        }
        if ($this->container['e_mail'] === null) {
            $invalidProperties[] = "'e_mail' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets notification_code
     *
     * @return string
     */
    public function getNotificationCode()
    {
        return $this->container['notification_code'];
    }

    /**
     * Sets notification_code
     *
     * @param string $notification_code The type of notification requested.  Note: - QVN Exception notification and return notification are not applicable to GFP. - QV In-transit and Return Notifications are only valid for ImportControl and Return shipment. - QV In-transit Notification is allowed for return shipments only. - QV Ship Notification is allowed for forward moving shipments only.  Valid values: - 5 - QV In-transit Notification - 6 - QV Ship Notification - 7 - QV Exception Notification - 8 - QV Delivery Notification - 2 - Return Notification or Label Creation Notification - 012 - Alternate Delivery Location Notification - 013 - UAP Shipper Notification.
     *
     * @return $this
     */
    public function setNotificationCode($notification_code)
    {
        $this->container['notification_code'] = $notification_code;

        return $this;
    }

    /**
     * Gets e_mail
     *
     * @return \UPS\Shipping\Shipping\NotificationEMail
     */
    public function getEMail()
    {
        return $this->container['e_mail'];
    }

    /**
     * Sets e_mail
     *
     * @param \UPS\Shipping\Shipping\NotificationEMail $e_mail e_mail
     *
     * @return $this
     */
    public function setEMail($e_mail)
    {
        $this->container['e_mail'] = $e_mail;

        return $this;
    }

    /**
     * Gets voice_message
     *
     * @return \UPS\Shipping\Shipping\NotificationVoiceMessage
     */
    public function getVoiceMessage()
    {
        return $this->container['voice_message'];
    }

    /**
     * Sets voice_message
     *
     * @param \UPS\Shipping\Shipping\NotificationVoiceMessage $voice_message voice_message
     *
     * @return $this
     */
    public function setVoiceMessage($voice_message)
    {
        $this->container['voice_message'] = $voice_message;

        return $this;
    }

    /**
     * Gets text_message
     *
     * @return \UPS\Shipping\Shipping\NotificationTextMessage
     */
    public function getTextMessage()
    {
        return $this->container['text_message'];
    }

    /**
     * Sets text_message
     *
     * @param \UPS\Shipping\Shipping\NotificationTextMessage $text_message text_message
     *
     * @return $this
     */
    public function setTextMessage($text_message)
    {
        $this->container['text_message'] = $text_message;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return \UPS\Shipping\Shipping\NotificationLocale
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param \UPS\Shipping\Shipping\NotificationLocale $locale locale
     *
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
