<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Sync\V1\Service;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class SyncListOptions
{
    /**
     * @param string  $uniqueName The unique_name
     * @param integer $ttl        The ttl
     *
     * @return CreateSyncListOptions Options builder
     */
    public static function create($uniqueName = Values::NONE, $ttl = Values::NONE)
    {
        return new CreateSyncListOptions($uniqueName, $ttl);
    }

    /**
     * @param integer $ttl The ttl
     *
     * @return UpdateSyncListOptions Options builder
     */
    public static function update($ttl = Values::NONE)
    {
        return new UpdateSyncListOptions($ttl);
    }
}

class CreateSyncListOptions extends Options
{
    /**
     * @param string  $uniqueName The unique_name
     * @param integer $ttl        The ttl
     */
    public function __construct($uniqueName = Values::NONE, $ttl = Values::NONE)
    {
        $this->options['uniqueName'] = $uniqueName;
        $this->options['ttl'] = $ttl;
    }

    /**
     * The unique_name
     *
     * @param string $uniqueName The unique_name
     *
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName)
    {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * The ttl
     *
     * @param integer $ttl The ttl
     *
     * @return $this Fluent Builder
     */
    public function setTtl($ttl)
    {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Sync.V1.CreateSyncListOptions '.implode(' ', $options).']';
    }
}

class UpdateSyncListOptions extends Options
{
    /**
     * @param integer $ttl The ttl
     */
    public function __construct($ttl = Values::NONE)
    {
        $this->options['ttl'] = $ttl;
    }

    /**
     * The ttl
     *
     * @param integer $ttl The ttl
     *
     * @return $this Fluent Builder
     */
    public function setTtl($ttl)
    {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Sync.V1.UpdateSyncListOptions '.implode(' ', $options).']';
    }
}