<?php
/**
 * LabelRecoveryRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * LabelRecoveryRequest Class Doc Comment
 *
 * @category Class
 * @description Request for obtaining the Label for the return shipment.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LabelRecoveryRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'LabelRecoveryRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'request' => '\UPS\Shipping\Shipping\LabelRecoveryRequestRequest',
        'label_specification' => '\UPS\Shipping\Shipping\LabelRecoveryRequestLabelSpecification',
        'translate' => '\UPS\Shipping\Shipping\LabelRecoveryRequestTranslate',
        'label_delivery' => '\UPS\Shipping\Shipping\LabelRecoveryRequestLabelDelivery',
        'tracking_number' => 'string',
        'mail_innovations_tracking_number' => 'string',
        'reference_values' => '\UPS\Shipping\Shipping\LabelRecoveryRequestReferenceValues',
        'locale' => 'string',
        'ups_premium_care_form' => '\UPS\Shipping\Shipping\LabelRecoveryRequestUPSPremiumCareForm'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'request' => null,
        'label_specification' => null,
        'translate' => null,
        'label_delivery' => null,
        'tracking_number' => null,
        'mail_innovations_tracking_number' => null,
        'reference_values' => null,
        'locale' => null,
        'ups_premium_care_form' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'request' => 'Request',
        'label_specification' => 'LabelSpecification',
        'translate' => 'Translate',
        'label_delivery' => 'LabelDelivery',
        'tracking_number' => 'TrackingNumber',
        'mail_innovations_tracking_number' => 'MailInnovationsTrackingNumber',
        'reference_values' => 'ReferenceValues',
        'locale' => 'Locale',
        'ups_premium_care_form' => 'UPSPremiumCareForm'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'request' => 'setRequest',
        'label_specification' => 'setLabelSpecification',
        'translate' => 'setTranslate',
        'label_delivery' => 'setLabelDelivery',
        'tracking_number' => 'setTrackingNumber',
        'mail_innovations_tracking_number' => 'setMailInnovationsTrackingNumber',
        'reference_values' => 'setReferenceValues',
        'locale' => 'setLocale',
        'ups_premium_care_form' => 'setUpsPremiumCareForm'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'request' => 'getRequest',
        'label_specification' => 'getLabelSpecification',
        'translate' => 'getTranslate',
        'label_delivery' => 'getLabelDelivery',
        'tracking_number' => 'getTrackingNumber',
        'mail_innovations_tracking_number' => 'getMailInnovationsTrackingNumber',
        'reference_values' => 'getReferenceValues',
        'locale' => 'getLocale',
        'ups_premium_care_form' => 'getUpsPremiumCareForm'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['request'] = isset($data['request']) ? $data['request'] : null;
        $this->container['label_specification'] = isset($data['label_specification']) ? $data['label_specification'] : null;
        $this->container['translate'] = isset($data['translate']) ? $data['translate'] : null;
        $this->container['label_delivery'] = isset($data['label_delivery']) ? $data['label_delivery'] : null;
        $this->container['tracking_number'] = isset($data['tracking_number']) ? $data['tracking_number'] : null;
        $this->container['mail_innovations_tracking_number'] = isset($data['mail_innovations_tracking_number']) ? $data['mail_innovations_tracking_number'] : null;
        $this->container['reference_values'] = isset($data['reference_values']) ? $data['reference_values'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['ups_premium_care_form'] = isset($data['ups_premium_care_form']) ? $data['ups_premium_care_form'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['request'] === null) {
            $invalidProperties[] = "'request' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets request
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestRequest
     */
    public function getRequest()
    {
        return $this->container['request'];
    }

    /**
     * Sets request
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestRequest $request request
     *
     * @return $this
     */
    public function setRequest($request)
    {
        $this->container['request'] = $request;

        return $this;
    }

    /**
     * Gets label_specification
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestLabelSpecification
     */
    public function getLabelSpecification()
    {
        return $this->container['label_specification'];
    }

    /**
     * Sets label_specification
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestLabelSpecification $label_specification label_specification
     *
     * @return $this
     */
    public function setLabelSpecification($label_specification)
    {
        $this->container['label_specification'] = $label_specification;

        return $this;
    }

    /**
     * Gets translate
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestTranslate
     */
    public function getTranslate()
    {
        return $this->container['translate'];
    }

    /**
     * Sets translate
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestTranslate $translate translate
     *
     * @return $this
     */
    public function setTranslate($translate)
    {
        $this->container['translate'] = $translate;

        return $this;
    }

    /**
     * Gets label_delivery
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestLabelDelivery
     */
    public function getLabelDelivery()
    {
        return $this->container['label_delivery'];
    }

    /**
     * Sets label_delivery
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestLabelDelivery $label_delivery label_delivery
     *
     * @return $this
     */
    public function setLabelDelivery($label_delivery)
    {
        $this->container['label_delivery'] = $label_delivery;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string $tracking_number Small Package Tracking Number. Required if Mail Innovations Tracking Number or ReferenceNumber/Value and ShipperNumber is not provided.  If only TrackingNumber is provided, the request will be treated as Small Package Shipment. Label Recovery will return label for Small Package Tracking Number. If both, TrackingNumber and MailInnovationsTrackingNumber are provided, the request will be treated as Dual Mail Innovations Return Shipment. Label Recovery will return two labels one each for - Small Package Tracking Number and Mail Innovations Return Tracking Number.
     *
     * @return $this
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets mail_innovations_tracking_number
     *
     * @return string
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->container['mail_innovations_tracking_number'];
    }

    /**
     * Sets mail_innovations_tracking_number
     *
     * @param string $mail_innovations_tracking_number Mail Innovations Tracking Number.  Required if Tracking Number or ReferenceNumber/Value is not populated.  If only MailInnovationsTrackingNumber is provided, the request will be treated as Single Mail Innovations Return Shipment. Label Recovery will return label for Mail Innovations Return Tracking Number. If both, TrackingNumber and MailInnovationsTrackingNumber are provided, the request will be treated as Dual Mail Innovations Return Shipment. Label Recovery will return two labels one each for - Small Package Tracking Number and Mail Innovations Return Tracking Number.
     *
     * @return $this
     */
    public function setMailInnovationsTrackingNumber($mail_innovations_tracking_number)
    {
        $this->container['mail_innovations_tracking_number'] = $mail_innovations_tracking_number;

        return $this;
    }

    /**
     * Gets reference_values
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestReferenceValues
     */
    public function getReferenceValues()
    {
        return $this->container['reference_values'];
    }

    /**
     * Sets reference_values
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestReferenceValues $reference_values reference_values
     *
     * @return $this
     */
    public function setReferenceValues($reference_values)
    {
        $this->container['reference_values'] = $reference_values;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string $locale Represents 5 character ISO Locale that allows the user to request Reference Number Code on Label, Label instructions, Receipt instructions (if available for given tracking number) and High Value Report (if available for given tracking number) in desired language.  Locale is specified by the combination of language code and country or territory code - 2 character language code and 2 character country code seperated by an underscore ('_') character. Example - de_DE. Please refer to Appendix for supported values for Locale.  Either Translate container or Locale element can be present in a given request. Both can't be requested together in same request.
     *
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets ups_premium_care_form
     *
     * @return \UPS\Shipping\Shipping\LabelRecoveryRequestUPSPremiumCareForm
     */
    public function getUpsPremiumCareForm()
    {
        return $this->container['ups_premium_care_form'];
    }

    /**
     * Sets ups_premium_care_form
     *
     * @param \UPS\Shipping\Shipping\LabelRecoveryRequestUPSPremiumCareForm $ups_premium_care_form ups_premium_care_form
     *
     * @return $this
     */
    public function setUpsPremiumCareForm($ups_premium_care_form)
    {
        $this->container['ups_premium_care_form'] = $ups_premium_care_form;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
