<?php
/**
 * ShipmentResultsShipmentCharges
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentResultsShipmentCharges Class Doc Comment
 *
 * @category Class
 * @description Shipment charges Container. Shipment charges info.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentResultsShipmentCharges implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentResults_ShipmentCharges';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'rate_chart' => 'string',
        'base_service_charge' => '\UPS\Shipping\Shipping\ShipmentChargesBaseServiceCharge',
        'transportation_charges' => '\UPS\Shipping\Shipping\ShipmentChargesTransportationCharges',
        'itemized_charges' => '\UPS\Shipping\Shipping\ShipmentChargesItemizedCharges[]',
        'service_options_charges' => '\UPS\Shipping\Shipping\ShipmentChargesServiceOptionsCharges',
        'tax_charges' => '\UPS\Shipping\Shipping\ShipmentChargesTaxCharges[]',
        'total_charges' => '\UPS\Shipping\Shipping\ShipmentChargesTotalCharges',
        'total_charges_with_taxes' => '\UPS\Shipping\Shipping\ShipmentChargesTotalChargesWithTaxes'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'rate_chart' => null,
        'base_service_charge' => null,
        'transportation_charges' => null,
        'itemized_charges' => null,
        'service_options_charges' => null,
        'tax_charges' => null,
        'total_charges' => null,
        'total_charges_with_taxes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rate_chart' => 'RateChart',
        'base_service_charge' => 'BaseServiceCharge',
        'transportation_charges' => 'TransportationCharges',
        'itemized_charges' => 'ItemizedCharges',
        'service_options_charges' => 'ServiceOptionsCharges',
        'tax_charges' => 'TaxCharges',
        'total_charges' => 'TotalCharges',
        'total_charges_with_taxes' => 'TotalChargesWithTaxes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'rate_chart' => 'setRateChart',
        'base_service_charge' => 'setBaseServiceCharge',
        'transportation_charges' => 'setTransportationCharges',
        'itemized_charges' => 'setItemizedCharges',
        'service_options_charges' => 'setServiceOptionsCharges',
        'tax_charges' => 'setTaxCharges',
        'total_charges' => 'setTotalCharges',
        'total_charges_with_taxes' => 'setTotalChargesWithTaxes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'rate_chart' => 'getRateChart',
        'base_service_charge' => 'getBaseServiceCharge',
        'transportation_charges' => 'getTransportationCharges',
        'itemized_charges' => 'getItemizedCharges',
        'service_options_charges' => 'getServiceOptionsCharges',
        'tax_charges' => 'getTaxCharges',
        'total_charges' => 'getTotalCharges',
        'total_charges_with_taxes' => 'getTotalChargesWithTaxes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['rate_chart'] = isset($data['rate_chart']) ? $data['rate_chart'] : null;
        $this->container['base_service_charge'] = isset($data['base_service_charge']) ? $data['base_service_charge'] : null;
        $this->container['transportation_charges'] = isset($data['transportation_charges']) ? $data['transportation_charges'] : null;
        $this->container['itemized_charges'] = isset($data['itemized_charges']) ? $data['itemized_charges'] : null;
        $this->container['service_options_charges'] = isset($data['service_options_charges']) ? $data['service_options_charges'] : null;
        $this->container['tax_charges'] = isset($data['tax_charges']) ? $data['tax_charges'] : null;
        $this->container['total_charges'] = isset($data['total_charges']) ? $data['total_charges'] : null;
        $this->container['total_charges_with_taxes'] = isset($data['total_charges_with_taxes']) ? $data['total_charges_with_taxes'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['transportation_charges'] === null) {
            $invalidProperties[] = "'transportation_charges' can't be null";
        }
        if ($this->container['service_options_charges'] === null) {
            $invalidProperties[] = "'service_options_charges' can't be null";
        }
        if ($this->container['total_charges'] === null) {
            $invalidProperties[] = "'total_charges' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets rate_chart
     *
     * @return string
     */
    public function getRateChart()
    {
        return $this->container['rate_chart'];
    }

    /**
     * Sets rate_chart
     *
     * @param string $rate_chart Rate Type with which Shipment is rated. Possible RateChart values for different regions will be: US 48 origin: - 1 – Daily Rates - 3 – Standard List Rates - 4 – Retail Rates.  Alaska/Hawaii origin: - 1 – Daily Rates - 3 – Standard List Rates - 4 – Retail Rates.  All Other origins: - 1 – Rates - 5 - Regional Rates - 6 - General List Rates.  3 and 4 do not apply.
     *
     * @return $this
     */
    public function setRateChart($rate_chart)
    {
        $this->container['rate_chart'] = $rate_chart;

        return $this;
    }

    /**
     * Gets base_service_charge
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesBaseServiceCharge
     */
    public function getBaseServiceCharge()
    {
        return $this->container['base_service_charge'];
    }

    /**
     * Sets base_service_charge
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesBaseServiceCharge $base_service_charge base_service_charge
     *
     * @return $this
     */
    public function setBaseServiceCharge($base_service_charge)
    {
        $this->container['base_service_charge'] = $base_service_charge;

        return $this;
    }

    /**
     * Gets transportation_charges
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesTransportationCharges
     */
    public function getTransportationCharges()
    {
        return $this->container['transportation_charges'];
    }

    /**
     * Sets transportation_charges
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesTransportationCharges $transportation_charges transportation_charges
     *
     * @return $this
     */
    public function setTransportationCharges($transportation_charges)
    {
        $this->container['transportation_charges'] = $transportation_charges;

        return $this;
    }

    /**
     * Gets itemized_charges
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesItemizedCharges[]
     */
    public function getItemizedCharges()
    {
        return $this->container['itemized_charges'];
    }

    /**
     * Sets itemized_charges
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesItemizedCharges[] $itemized_charges Itemized Charges are returned only when the Subversion element is present and greater than or equal to 1601.  **NOTE:** For versions >= v2403, this element will always be returned as an array. For requests using versions < v2403, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setItemizedCharges($itemized_charges)
    {
        $this->container['itemized_charges'] = $itemized_charges;

        return $this;
    }

    /**
     * Gets service_options_charges
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesServiceOptionsCharges
     */
    public function getServiceOptionsCharges()
    {
        return $this->container['service_options_charges'];
    }

    /**
     * Sets service_options_charges
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesServiceOptionsCharges $service_options_charges service_options_charges
     *
     * @return $this
     */
    public function setServiceOptionsCharges($service_options_charges)
    {
        $this->container['service_options_charges'] = $service_options_charges;

        return $this;
    }

    /**
     * Gets tax_charges
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesTaxCharges[]
     */
    public function getTaxCharges()
    {
        return $this->container['tax_charges'];
    }

    /**
     * Sets tax_charges
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesTaxCharges[] $tax_charges TaxCharges container are returned only when TaxInformationIndicator is present in request and when Negotiated Rates are not applicable. TaxCharges container contains Tax information for a given shipment.  **NOTE:** For versions >= v2403, this element will always be returned as an array. For requests using versions < v2403, this element will be returned as an array if there is more than one object and a single object if there is only 1.
     *
     * @return $this
     */
    public function setTaxCharges($tax_charges)
    {
        $this->container['tax_charges'] = $tax_charges;

        return $this;
    }

    /**
     * Gets total_charges
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesTotalCharges
     */
    public function getTotalCharges()
    {
        return $this->container['total_charges'];
    }

    /**
     * Sets total_charges
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesTotalCharges $total_charges total_charges
     *
     * @return $this
     */
    public function setTotalCharges($total_charges)
    {
        $this->container['total_charges'] = $total_charges;

        return $this;
    }

    /**
     * Gets total_charges_with_taxes
     *
     * @return \UPS\Shipping\Shipping\ShipmentChargesTotalChargesWithTaxes
     */
    public function getTotalChargesWithTaxes()
    {
        return $this->container['total_charges_with_taxes'];
    }

    /**
     * Sets total_charges_with_taxes
     *
     * @param \UPS\Shipping\Shipping\ShipmentChargesTotalChargesWithTaxes $total_charges_with_taxes total_charges_with_taxes
     *
     * @return $this
     */
    public function setTotalChargesWithTaxes($total_charges_with_taxes)
    {
        $this->container['total_charges_with_taxes'] = $total_charges_with_taxes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
