<?php
/**
 * ShipmentShipmentServiceOptions
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentShipmentServiceOptions Class Doc Comment
 *
 * @category Class
 * @description Container for Shipment Service Options.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentShipmentServiceOptions implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'Shipment_ShipmentServiceOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'saturday_delivery_indicator' => 'string',
        'saturday_pickup_indicator' => 'string',
        'cod' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsCOD',
        'access_point_cod' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsAccessPointCOD',
        'deliver_to_addressee_only_indicator' => 'string',
        'direct_delivery_only_indicator' => 'string',
        'notification' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsNotification[]',
        'label_delivery' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsLabelDelivery',
        'international_forms' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsInternationalForms',
        'delivery_confirmation' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsDeliveryConfirmation',
        'return_of_document_indicator' => 'string',
        'import_control_indicator' => 'string',
        'label_method' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsLabelMethod',
        'commercial_invoice_removal_indicator' => 'string',
        'up_scarbonneutral_indicator' => 'string',
        'pre_alert_notification' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsPreAlertNotification[]',
        'exchange_forward_indicator' => 'string',
        'hold_for_pickup_indicator' => 'string',
        'dropoff_at_ups_facility_indicator' => 'string',
        'lift_gate_for_pick_up_indicator' => 'string',
        'lift_gate_for_delivery_indicator' => 'string',
        'sdl_shipment_indicator' => 'string',
        'epra_release_code' => 'string',
        'restricted_articles' => '\UPS\Shipping\Shipping\ShipmentServiceOptionsRestrictedArticles',
        'inside_delivery' => 'string',
        'item_disposal' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'saturday_delivery_indicator' => null,
        'saturday_pickup_indicator' => null,
        'cod' => null,
        'access_point_cod' => null,
        'deliver_to_addressee_only_indicator' => null,
        'direct_delivery_only_indicator' => null,
        'notification' => null,
        'label_delivery' => null,
        'international_forms' => null,
        'delivery_confirmation' => null,
        'return_of_document_indicator' => null,
        'import_control_indicator' => null,
        'label_method' => null,
        'commercial_invoice_removal_indicator' => null,
        'up_scarbonneutral_indicator' => null,
        'pre_alert_notification' => null,
        'exchange_forward_indicator' => null,
        'hold_for_pickup_indicator' => null,
        'dropoff_at_ups_facility_indicator' => null,
        'lift_gate_for_pick_up_indicator' => null,
        'lift_gate_for_delivery_indicator' => null,
        'sdl_shipment_indicator' => null,
        'epra_release_code' => null,
        'restricted_articles' => null,
        'inside_delivery' => null,
        'item_disposal' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'saturday_delivery_indicator' => 'SaturdayDeliveryIndicator',
        'saturday_pickup_indicator' => 'SaturdayPickupIndicator',
        'cod' => 'COD',
        'access_point_cod' => 'AccessPointCOD',
        'deliver_to_addressee_only_indicator' => 'DeliverToAddresseeOnlyIndicator',
        'direct_delivery_only_indicator' => 'DirectDeliveryOnlyIndicator',
        'notification' => 'Notification',
        'label_delivery' => 'LabelDelivery',
        'international_forms' => 'InternationalForms',
        'delivery_confirmation' => 'DeliveryConfirmation',
        'return_of_document_indicator' => 'ReturnOfDocumentIndicator',
        'import_control_indicator' => 'ImportControlIndicator',
        'label_method' => 'LabelMethod',
        'commercial_invoice_removal_indicator' => 'CommercialInvoiceRemovalIndicator',
        'up_scarbonneutral_indicator' => 'UPScarbonneutralIndicator',
        'pre_alert_notification' => 'PreAlertNotification',
        'exchange_forward_indicator' => 'ExchangeForwardIndicator',
        'hold_for_pickup_indicator' => 'HoldForPickupIndicator',
        'dropoff_at_ups_facility_indicator' => 'DropoffAtUPSFacilityIndicator',
        'lift_gate_for_pick_up_indicator' => 'LiftGateForPickUpIndicator',
        'lift_gate_for_delivery_indicator' => 'LiftGateForDeliveryIndicator',
        'sdl_shipment_indicator' => 'SDLShipmentIndicator',
        'epra_release_code' => 'EPRAReleaseCode',
        'restricted_articles' => 'RestrictedArticles',
        'inside_delivery' => 'InsideDelivery',
        'item_disposal' => 'ItemDisposal'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'saturday_delivery_indicator' => 'setSaturdayDeliveryIndicator',
        'saturday_pickup_indicator' => 'setSaturdayPickupIndicator',
        'cod' => 'setCod',
        'access_point_cod' => 'setAccessPointCod',
        'deliver_to_addressee_only_indicator' => 'setDeliverToAddresseeOnlyIndicator',
        'direct_delivery_only_indicator' => 'setDirectDeliveryOnlyIndicator',
        'notification' => 'setNotification',
        'label_delivery' => 'setLabelDelivery',
        'international_forms' => 'setInternationalForms',
        'delivery_confirmation' => 'setDeliveryConfirmation',
        'return_of_document_indicator' => 'setReturnOfDocumentIndicator',
        'import_control_indicator' => 'setImportControlIndicator',
        'label_method' => 'setLabelMethod',
        'commercial_invoice_removal_indicator' => 'setCommercialInvoiceRemovalIndicator',
        'up_scarbonneutral_indicator' => 'setUpScarbonneutralIndicator',
        'pre_alert_notification' => 'setPreAlertNotification',
        'exchange_forward_indicator' => 'setExchangeForwardIndicator',
        'hold_for_pickup_indicator' => 'setHoldForPickupIndicator',
        'dropoff_at_ups_facility_indicator' => 'setDropoffAtUpsFacilityIndicator',
        'lift_gate_for_pick_up_indicator' => 'setLiftGateForPickUpIndicator',
        'lift_gate_for_delivery_indicator' => 'setLiftGateForDeliveryIndicator',
        'sdl_shipment_indicator' => 'setSdlShipmentIndicator',
        'epra_release_code' => 'setEpraReleaseCode',
        'restricted_articles' => 'setRestrictedArticles',
        'inside_delivery' => 'setInsideDelivery',
        'item_disposal' => 'setItemDisposal'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'saturday_delivery_indicator' => 'getSaturdayDeliveryIndicator',
        'saturday_pickup_indicator' => 'getSaturdayPickupIndicator',
        'cod' => 'getCod',
        'access_point_cod' => 'getAccessPointCod',
        'deliver_to_addressee_only_indicator' => 'getDeliverToAddresseeOnlyIndicator',
        'direct_delivery_only_indicator' => 'getDirectDeliveryOnlyIndicator',
        'notification' => 'getNotification',
        'label_delivery' => 'getLabelDelivery',
        'international_forms' => 'getInternationalForms',
        'delivery_confirmation' => 'getDeliveryConfirmation',
        'return_of_document_indicator' => 'getReturnOfDocumentIndicator',
        'import_control_indicator' => 'getImportControlIndicator',
        'label_method' => 'getLabelMethod',
        'commercial_invoice_removal_indicator' => 'getCommercialInvoiceRemovalIndicator',
        'up_scarbonneutral_indicator' => 'getUpScarbonneutralIndicator',
        'pre_alert_notification' => 'getPreAlertNotification',
        'exchange_forward_indicator' => 'getExchangeForwardIndicator',
        'hold_for_pickup_indicator' => 'getHoldForPickupIndicator',
        'dropoff_at_ups_facility_indicator' => 'getDropoffAtUpsFacilityIndicator',
        'lift_gate_for_pick_up_indicator' => 'getLiftGateForPickUpIndicator',
        'lift_gate_for_delivery_indicator' => 'getLiftGateForDeliveryIndicator',
        'sdl_shipment_indicator' => 'getSdlShipmentIndicator',
        'epra_release_code' => 'getEpraReleaseCode',
        'restricted_articles' => 'getRestrictedArticles',
        'inside_delivery' => 'getInsideDelivery',
        'item_disposal' => 'getItemDisposal'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['saturday_delivery_indicator'] = isset($data['saturday_delivery_indicator']) ? $data['saturday_delivery_indicator'] : null;
        $this->container['saturday_pickup_indicator'] = isset($data['saturday_pickup_indicator']) ? $data['saturday_pickup_indicator'] : null;
        $this->container['cod'] = isset($data['cod']) ? $data['cod'] : null;
        $this->container['access_point_cod'] = isset($data['access_point_cod']) ? $data['access_point_cod'] : null;
        $this->container['deliver_to_addressee_only_indicator'] = isset($data['deliver_to_addressee_only_indicator']) ? $data['deliver_to_addressee_only_indicator'] : null;
        $this->container['direct_delivery_only_indicator'] = isset($data['direct_delivery_only_indicator']) ? $data['direct_delivery_only_indicator'] : null;
        $this->container['notification'] = isset($data['notification']) ? $data['notification'] : null;
        $this->container['label_delivery'] = isset($data['label_delivery']) ? $data['label_delivery'] : null;
        $this->container['international_forms'] = isset($data['international_forms']) ? $data['international_forms'] : null;
        $this->container['delivery_confirmation'] = isset($data['delivery_confirmation']) ? $data['delivery_confirmation'] : null;
        $this->container['return_of_document_indicator'] = isset($data['return_of_document_indicator']) ? $data['return_of_document_indicator'] : null;
        $this->container['import_control_indicator'] = isset($data['import_control_indicator']) ? $data['import_control_indicator'] : null;
        $this->container['label_method'] = isset($data['label_method']) ? $data['label_method'] : null;
        $this->container['commercial_invoice_removal_indicator'] = isset($data['commercial_invoice_removal_indicator']) ? $data['commercial_invoice_removal_indicator'] : null;
        $this->container['up_scarbonneutral_indicator'] = isset($data['up_scarbonneutral_indicator']) ? $data['up_scarbonneutral_indicator'] : null;
        $this->container['pre_alert_notification'] = isset($data['pre_alert_notification']) ? $data['pre_alert_notification'] : null;
        $this->container['exchange_forward_indicator'] = isset($data['exchange_forward_indicator']) ? $data['exchange_forward_indicator'] : null;
        $this->container['hold_for_pickup_indicator'] = isset($data['hold_for_pickup_indicator']) ? $data['hold_for_pickup_indicator'] : null;
        $this->container['dropoff_at_ups_facility_indicator'] = isset($data['dropoff_at_ups_facility_indicator']) ? $data['dropoff_at_ups_facility_indicator'] : null;
        $this->container['lift_gate_for_pick_up_indicator'] = isset($data['lift_gate_for_pick_up_indicator']) ? $data['lift_gate_for_pick_up_indicator'] : null;
        $this->container['lift_gate_for_delivery_indicator'] = isset($data['lift_gate_for_delivery_indicator']) ? $data['lift_gate_for_delivery_indicator'] : null;
        $this->container['sdl_shipment_indicator'] = isset($data['sdl_shipment_indicator']) ? $data['sdl_shipment_indicator'] : null;
        $this->container['epra_release_code'] = isset($data['epra_release_code']) ? $data['epra_release_code'] : null;
        $this->container['restricted_articles'] = isset($data['restricted_articles']) ? $data['restricted_articles'] : null;
        $this->container['inside_delivery'] = isset($data['inside_delivery']) ? $data['inside_delivery'] : null;
        $this->container['item_disposal'] = isset($data['item_disposal']) ? $data['item_disposal'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets saturday_delivery_indicator
     *
     * @return string
     */
    public function getSaturdayDeliveryIndicator()
    {
        return $this->container['saturday_delivery_indicator'];
    }

    /**
     * Sets saturday_delivery_indicator
     *
     * @param string $saturday_delivery_indicator Saturday delivery indicator. The presence indicates Saturday delivery is requested and the absence indicates Saturday delivery is not requested.  This is an empty tag, any value inside is ignored.
     *
     * @return $this
     */
    public function setSaturdayDeliveryIndicator($saturday_delivery_indicator)
    {
        $this->container['saturday_delivery_indicator'] = $saturday_delivery_indicator;

        return $this;
    }

    /**
     * Gets saturday_pickup_indicator
     *
     * @return string
     */
    public function getSaturdayPickupIndicator()
    {
        return $this->container['saturday_pickup_indicator'];
    }

    /**
     * Sets saturday_pickup_indicator
     *
     * @param string $saturday_pickup_indicator Saturday pickup indicator. The presence indicates Saturday pickup is requested and the absence indicates Saturday pickup is not requested.  This is an empty tag, any value inside is ignored.
     *
     * @return $this
     */
    public function setSaturdayPickupIndicator($saturday_pickup_indicator)
    {
        $this->container['saturday_pickup_indicator'] = $saturday_pickup_indicator;

        return $this;
    }

    /**
     * Gets cod
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsCOD
     */
    public function getCod()
    {
        return $this->container['cod'];
    }

    /**
     * Sets cod
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsCOD $cod cod
     *
     * @return $this
     */
    public function setCod($cod)
    {
        $this->container['cod'] = $cod;

        return $this;
    }

    /**
     * Gets access_point_cod
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsAccessPointCOD
     */
    public function getAccessPointCod()
    {
        return $this->container['access_point_cod'];
    }

    /**
     * Sets access_point_cod
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsAccessPointCOD $access_point_cod access_point_cod
     *
     * @return $this
     */
    public function setAccessPointCod($access_point_cod)
    {
        $this->container['access_point_cod'] = $access_point_cod;

        return $this;
    }

    /**
     * Gets deliver_to_addressee_only_indicator
     *
     * @return string
     */
    public function getDeliverToAddresseeOnlyIndicator()
    {
        return $this->container['deliver_to_addressee_only_indicator'];
    }

    /**
     * Sets deliver_to_addressee_only_indicator
     *
     * @param string $deliver_to_addressee_only_indicator Presence/Absence Indicator. Any value inside is ignored. DeliverToAddresseeOnlyIndicator is shipper specified restriction that requires the addressee to be the one who takes final delivery of the \"Hold For PickUp at UPS Access Point\" package. Presence of indicator means shipper restriction will apply to the shipment.  Only valid for Shipment Indication type \"01 - Hold For PickUp at UPS Access Point\".
     *
     * @return $this
     */
    public function setDeliverToAddresseeOnlyIndicator($deliver_to_addressee_only_indicator)
    {
        $this->container['deliver_to_addressee_only_indicator'] = $deliver_to_addressee_only_indicator;

        return $this;
    }

    /**
     * Gets direct_delivery_only_indicator
     *
     * @return string
     */
    public function getDirectDeliveryOnlyIndicator()
    {
        return $this->container['direct_delivery_only_indicator'];
    }

    /**
     * Sets direct_delivery_only_indicator
     *
     * @param string $direct_delivery_only_indicator Presence/Absence Indicator. Any value inside is ignored. Direct Delivery Only (DDO) accessorial in a request would ensure that delivery is made only to the ship to address on the shipping label. This accessorial is not valid with Shipment Indication Type \"01 - Hold For Pickup At UPS Access Point\" and \"02 - UPS Access Point™ Delivery\".
     *
     * @return $this
     */
    public function setDirectDeliveryOnlyIndicator($direct_delivery_only_indicator)
    {
        $this->container['direct_delivery_only_indicator'] = $direct_delivery_only_indicator;

        return $this;
    }

    /**
     * Gets notification
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsNotification[]
     */
    public function getNotification()
    {
        return $this->container['notification'];
    }

    /**
     * Sets notification
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsNotification[] $notification notification
     *
     * @return $this
     */
    public function setNotification($notification)
    {
        $this->container['notification'] = $notification;

        return $this;
    }

    /**
     * Gets label_delivery
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsLabelDelivery
     */
    public function getLabelDelivery()
    {
        return $this->container['label_delivery'];
    }

    /**
     * Sets label_delivery
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsLabelDelivery $label_delivery label_delivery
     *
     * @return $this
     */
    public function setLabelDelivery($label_delivery)
    {
        $this->container['label_delivery'] = $label_delivery;

        return $this;
    }

    /**
     * Gets international_forms
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsInternationalForms
     */
    public function getInternationalForms()
    {
        return $this->container['international_forms'];
    }

    /**
     * Sets international_forms
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsInternationalForms $international_forms international_forms
     *
     * @return $this
     */
    public function setInternationalForms($international_forms)
    {
        $this->container['international_forms'] = $international_forms;

        return $this;
    }

    /**
     * Gets delivery_confirmation
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsDeliveryConfirmation
     */
    public function getDeliveryConfirmation()
    {
        return $this->container['delivery_confirmation'];
    }

    /**
     * Sets delivery_confirmation
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsDeliveryConfirmation $delivery_confirmation delivery_confirmation
     *
     * @return $this
     */
    public function setDeliveryConfirmation($delivery_confirmation)
    {
        $this->container['delivery_confirmation'] = $delivery_confirmation;

        return $this;
    }

    /**
     * Gets return_of_document_indicator
     *
     * @return string
     */
    public function getReturnOfDocumentIndicator()
    {
        return $this->container['return_of_document_indicator'];
    }

    /**
     * Sets return_of_document_indicator
     *
     * @param string $return_of_document_indicator The flag indicates the ReturnOfDocument accessorial has been requested.  Valid for Poland to Poland forward shipment only.
     *
     * @return $this
     */
    public function setReturnOfDocumentIndicator($return_of_document_indicator)
    {
        $this->container['return_of_document_indicator'] = $return_of_document_indicator;

        return $this;
    }

    /**
     * Gets import_control_indicator
     *
     * @return string
     */
    public function getImportControlIndicator()
    {
        return $this->container['import_control_indicator'];
    }

    /**
     * Sets import_control_indicator
     *
     * @param string $import_control_indicator Indicates that the Shipment is an ImportControl shipment.
     *
     * @return $this
     */
    public function setImportControlIndicator($import_control_indicator)
    {
        $this->container['import_control_indicator'] = $import_control_indicator;

        return $this;
    }

    /**
     * Gets label_method
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsLabelMethod
     */
    public function getLabelMethod()
    {
        return $this->container['label_method'];
    }

    /**
     * Sets label_method
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsLabelMethod $label_method label_method
     *
     * @return $this
     */
    public function setLabelMethod($label_method)
    {
        $this->container['label_method'] = $label_method;

        return $this;
    }

    /**
     * Gets commercial_invoice_removal_indicator
     *
     * @return string
     */
    public function getCommercialInvoiceRemovalIndicator()
    {
        return $this->container['commercial_invoice_removal_indicator'];
    }

    /**
     * Sets commercial_invoice_removal_indicator
     *
     * @param string $commercial_invoice_removal_indicator CommercialInvoiceRemovalIndicator allows a shipper to dictate UPS to remove the Commercial Invoice from the user's shipment before the shipment is delivered to the ultimate consignee.
     *
     * @return $this
     */
    public function setCommercialInvoiceRemovalIndicator($commercial_invoice_removal_indicator)
    {
        $this->container['commercial_invoice_removal_indicator'] = $commercial_invoice_removal_indicator;

        return $this;
    }

    /**
     * Gets up_scarbonneutral_indicator
     *
     * @return string
     */
    public function getUpScarbonneutralIndicator()
    {
        return $this->container['up_scarbonneutral_indicator'];
    }

    /**
     * Sets up_scarbonneutral_indicator
     *
     * @param string $up_scarbonneutral_indicator UPS carbon neutral indicator presence at shipment level is required to create carbon neutral Shipments.
     *
     * @return $this
     */
    public function setUpScarbonneutralIndicator($up_scarbonneutral_indicator)
    {
        $this->container['up_scarbonneutral_indicator'] = $up_scarbonneutral_indicator;

        return $this;
    }

    /**
     * Gets pre_alert_notification
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsPreAlertNotification[]
     */
    public function getPreAlertNotification()
    {
        return $this->container['pre_alert_notification'];
    }

    /**
     * Sets pre_alert_notification
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsPreAlertNotification[] $pre_alert_notification pre_alert_notification
     *
     * @return $this
     */
    public function setPreAlertNotification($pre_alert_notification)
    {
        $this->container['pre_alert_notification'] = $pre_alert_notification;

        return $this;
    }

    /**
     * Gets exchange_forward_indicator
     *
     * @return string
     */
    public function getExchangeForwardIndicator()
    {
        return $this->container['exchange_forward_indicator'];
    }

    /**
     * Sets exchange_forward_indicator
     *
     * @param string $exchange_forward_indicator Exchange forward indicator presence at shipment level is required to create exchange forward Shipments.  In the label routing Instruction text will be defaulted to \"EXCHANGE-LIKE ITEM ONLY\".
     *
     * @return $this
     */
    public function setExchangeForwardIndicator($exchange_forward_indicator)
    {
        $this->container['exchange_forward_indicator'] = $exchange_forward_indicator;

        return $this;
    }

    /**
     * Gets hold_for_pickup_indicator
     *
     * @return string
     */
    public function getHoldForPickupIndicator()
    {
        return $this->container['hold_for_pickup_indicator'];
    }

    /**
     * Sets hold_for_pickup_indicator
     *
     * @param string $hold_for_pickup_indicator Hold For Pickup indicator. The empty tag means indicator is present.  This accessorial is only valid for UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday Shipment.
     *
     * @return $this
     */
    public function setHoldForPickupIndicator($hold_for_pickup_indicator)
    {
        $this->container['hold_for_pickup_indicator'] = $hold_for_pickup_indicator;

        return $this;
    }

    /**
     * Gets dropoff_at_ups_facility_indicator
     *
     * @return string
     */
    public function getDropoffAtUpsFacilityIndicator()
    {
        return $this->container['dropoff_at_ups_facility_indicator'];
    }

    /**
     * Sets dropoff_at_ups_facility_indicator
     *
     * @param string $dropoff_at_ups_facility_indicator Drop off At UPS Facility indicator. The empty tag means indicator is present.  This accessorial is only valid for UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday Shipment.
     *
     * @return $this
     */
    public function setDropoffAtUpsFacilityIndicator($dropoff_at_ups_facility_indicator)
    {
        $this->container['dropoff_at_ups_facility_indicator'] = $dropoff_at_ups_facility_indicator;

        return $this;
    }

    /**
     * Gets lift_gate_for_pick_up_indicator
     *
     * @return string
     */
    public function getLiftGateForPickUpIndicator()
    {
        return $this->container['lift_gate_for_pick_up_indicator'];
    }

    /**
     * Sets lift_gate_for_pick_up_indicator
     *
     * @param string $lift_gate_for_pick_up_indicator Lift Gate For Pick Up indicator. The empty tag means indicator is present.  Lift Gate for Pickup is not allowed with Drop Off At UPS Facility for a UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday shipment.   When both Hold for Pickup and Drop Off At Facility are selected, neither of the Lift Gate accessorial (Pick Up or Delivery) are allowed for a UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday shipment.   This accessorial is only valid for UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday Shipment.
     *
     * @return $this
     */
    public function setLiftGateForPickUpIndicator($lift_gate_for_pick_up_indicator)
    {
        $this->container['lift_gate_for_pick_up_indicator'] = $lift_gate_for_pick_up_indicator;

        return $this;
    }

    /**
     * Gets lift_gate_for_delivery_indicator
     *
     * @return string
     */
    public function getLiftGateForDeliveryIndicator()
    {
        return $this->container['lift_gate_for_delivery_indicator'];
    }

    /**
     * Sets lift_gate_for_delivery_indicator
     *
     * @param string $lift_gate_for_delivery_indicator Lift Gate For Delivery indicator. The empty tag means indicator is present.  Lift Gate for Delivery is not allowed with Hold For Pickup for a UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday shipment.   When both Hold for Pickup and Drop Off At UPS Facility are selected, neither of the Lift Gate accessorial (Pick Up or Delivery) are allowed for a UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday shipment.   This accessorial is only valid for UPS Worldwide Express Freight and UPS Worldwide Express Freight Midday Shipment.
     *
     * @return $this
     */
    public function setLiftGateForDeliveryIndicator($lift_gate_for_delivery_indicator)
    {
        $this->container['lift_gate_for_delivery_indicator'] = $lift_gate_for_delivery_indicator;

        return $this;
    }

    /**
     * Gets sdl_shipment_indicator
     *
     * @return string
     */
    public function getSdlShipmentIndicator()
    {
        return $this->container['sdl_shipment_indicator'];
    }

    /**
     * Sets sdl_shipment_indicator
     *
     * @param string $sdl_shipment_indicator The presence of the tag SDLShipmentIndicator indicates Shipment is SDL. SDLShipmentIndicator presence means EEI form/ EEI Filing option required.
     *
     * @return $this
     */
    public function setSdlShipmentIndicator($sdl_shipment_indicator)
    {
        $this->container['sdl_shipment_indicator'] = $sdl_shipment_indicator;

        return $this;
    }

    /**
     * Gets epra_release_code
     *
     * @return string
     */
    public function getEpraReleaseCode()
    {
        return $this->container['epra_release_code'];
    }

    /**
     * Sets epra_release_code
     *
     * @param string $epra_release_code Package Release code allows the consignee or claimant to pick-up a package at a UPS Access Point™. The shipper must provide the Package Release Code to the consignee so that they can provide the code to the UPS Access Point personnel as another item for authentication before the package is released to them. Package Release Code is only valid with ShipmentIndicationType 01 - Hold for Pickup at UPS Access Point™.  The release code must be between length 4 and 6 and only contain numbers.
     *
     * @return $this
     */
    public function setEpraReleaseCode($epra_release_code)
    {
        $this->container['epra_release_code'] = $epra_release_code;

        return $this;
    }

    /**
     * Gets restricted_articles
     *
     * @return \UPS\Shipping\Shipping\ShipmentServiceOptionsRestrictedArticles
     */
    public function getRestrictedArticles()
    {
        return $this->container['restricted_articles'];
    }

    /**
     * Sets restricted_articles
     *
     * @param \UPS\Shipping\Shipping\ShipmentServiceOptionsRestrictedArticles $restricted_articles restricted_articles
     *
     * @return $this
     */
    public function setRestrictedArticles($restricted_articles)
    {
        $this->container['restricted_articles'] = $restricted_articles;

        return $this;
    }

    /**
     * Gets inside_delivery
     *
     * @return string
     */
    public function getInsideDelivery()
    {
        return $this->container['inside_delivery'];
    }

    /**
     * Sets inside_delivery
     *
     * @param string $inside_delivery Inside delivery accessory. Valid values: 01 - White Glove, 02 - Room of Choice, 03 - Installation, 04 - Over Threshold Fee. Default is Room of Choice.  Shippers account needs to have a valid contract for Heavy Goods Service.
     *
     * @return $this
     */
    public function setInsideDelivery($inside_delivery)
    {
        $this->container['inside_delivery'] = $inside_delivery;

        return $this;
    }

    /**
     * Gets item_disposal
     *
     * @return string
     */
    public function getItemDisposal()
    {
        return $this->container['item_disposal'];
    }

    /**
     * Sets item_disposal
     *
     * @param string $item_disposal Presence/Absence indicator. True if present; false otherwise. Any value is ignored. If present, indicates that the customer would like items disposed.  Shippers account needs to have a valid contract for Heavy Goods Service.
     *
     * @return $this
     */
    public function setItemDisposal($item_disposal)
    {
        $this->container['item_disposal'] = $item_disposal;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
