<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Api\V2010\Account;

use Twilio\Options;
use Twilio\Values;

abstract class RecordingOptions
{
    /**
     * @param string $dateCreatedBefore Filter by date created
     * @param string $dateCreated       Filter by date created
     * @param string $dateCreatedAfter  Filter by date created
     * @param string $callSid           Filter by call_sid
     * @param string $conferenceSid     The conference_sid
     *
     * @return ReadRecordingOptions Options builder
     */
    public static function read($dateCreatedBefore = Values::NONE, $dateCreated = Values::NONE, $dateCreatedAfter = Values::NONE, $callSid = Values::NONE, $conferenceSid = Values::NONE)
    {
        return new ReadRecordingOptions($dateCreatedBefore, $dateCreated, $dateCreatedAfter, $callSid, $conferenceSid);
    }
}

class ReadRecordingOptions extends Options
{
    /**
     * @param string $dateCreatedBefore Filter by date created
     * @param string $dateCreated       Filter by date created
     * @param string $dateCreatedAfter  Filter by date created
     * @param string $callSid           Filter by call_sid
     * @param string $conferenceSid     The conference_sid
     */
    public function __construct($dateCreatedBefore = Values::NONE, $dateCreated = Values::NONE, $dateCreatedAfter = Values::NONE, $callSid = Values::NONE, $conferenceSid = Values::NONE)
    {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        $this->options['dateCreated'] = $dateCreated;
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        $this->options['callSid'] = $callSid;
        $this->options['conferenceSid'] = $conferenceSid;
    }

    /**
     * Only show recordings on the given date. Should be formatted as YYYY-MM-DD. You can also specify inequalities
     *
     * @param string $dateCreatedBefore Filter by date created
     *
     * @return $this Fluent Builder
     */
    public function setDateCreatedBefore($dateCreatedBefore)
    {
        $this->options['dateCreatedBefore'] = $dateCreatedBefore;
        return $this;
    }

    /**
     * Only show recordings on the given date. Should be formatted as YYYY-MM-DD. You can also specify inequalities
     *
     * @param string $dateCreated Filter by date created
     *
     * @return $this Fluent Builder
     */
    public function setDateCreated($dateCreated)
    {
        $this->options['dateCreated'] = $dateCreated;
        return $this;
    }

    /**
     * Only show recordings on the given date. Should be formatted as YYYY-MM-DD. You can also specify inequalities
     *
     * @param string $dateCreatedAfter Filter by date created
     *
     * @return $this Fluent Builder
     */
    public function setDateCreatedAfter($dateCreatedAfter)
    {
        $this->options['dateCreatedAfter'] = $dateCreatedAfter;
        return $this;
    }

    /**
     * Only show recordings made during the call given by the indicated sid
     *
     * @param string $callSid Filter by call_sid
     *
     * @return $this Fluent Builder
     */
    public function setCallSid($callSid)
    {
        $this->options['callSid'] = $callSid;
        return $this;
    }

    /**
     * The conference_sid
     *
     * @param string $conferenceSid The conference_sid
     *
     * @return $this Fluent Builder
     */
    public function setConferenceSid($conferenceSid)
    {
        $this->options['conferenceSid'] = $conferenceSid;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Api.V2010.ReadRecordingOptions '.implode(' ', $options).']';
    }
}