DROP TABLE IF EXISTS `ac_addresses_enc`;
CREATE TABLE `ac_addresses_enc` (
  `address_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `company` text COLLATE utf8_bin NOT NULL,
  `firstname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `address_1` text COLLATE utf8_bin NOT NULL,
  `address_2` text COLLATE utf8_bin NOT NULL,
  `postcode` text COLLATE utf8_bin NOT NULL,
  `city` text COLLATE utf8_bin NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `zone_id` int(11) NOT NULL DEFAULT '0',
  `key_id` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`address_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;
CREATE INDEX `ac_addresses_enc_idx` ON `ac_addresses_enc` ( `customer_id`, `country_id`, `zone_id`  );

DROP TABLE IF EXISTS `ac_orders_enc`;
CREATE TABLE `ac_orders_enc` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL DEFAULT '0',
  `invoice_prefix` varchar(10) COLLATE utf8_bin NOT NULL,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `store_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `store_url` varchar(255) COLLATE utf8_bin NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) NOT NULL DEFAULT '0',
  `firstname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_bin NOT NULL,
  `telephone` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `fax` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `email` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_firstname` varchar(32) COLLATE utf8_bin NOT NULL,
  `shipping_lastname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_company` text COLLATE utf8_bin NOT NULL,
  `shipping_address_1` text COLLATE utf8_bin NOT NULL,
  `shipping_address_2` text COLLATE utf8_bin NOT NULL,
  `shipping_city` text COLLATE utf8_bin NOT NULL,
  `shipping_postcode` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_zone` varchar(128) COLLATE utf8_bin NOT NULL,
  `shipping_zone_id` int(11) NOT NULL,
  `shipping_country` text COLLATE utf8_bin NOT NULL,
  `shipping_country_id` int(11) NOT NULL,
  `shipping_address_format` text COLLATE utf8_bin NOT NULL,
  `shipping_method` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT '',
  `shipping_method_key` varchar(128) NOT NULL DEFAULT '',
  `payment_firstname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `payment_lastname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `payment_company` text COLLATE utf8_bin NOT NULL,
  `payment_address_1` text COLLATE utf8_bin NOT NULL,
  `payment_address_2` text COLLATE utf8_bin NOT NULL,
  `payment_city` text COLLATE utf8_bin NOT NULL,
  `payment_postcode` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `payment_zone` varchar(128) COLLATE utf8_bin NOT NULL,
  `payment_zone_id` int(11) NOT NULL,
  `payment_country` text COLLATE utf8_bin NOT NULL,
  `payment_country_id` int(11) NOT NULL,
  `payment_address_format` text COLLATE utf8_bin NOT NULL,
  `payment_method` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT '',
  `payment_method_key` varchar(128) NOT NULL DEFAULT '',
  `comment` text COLLATE utf8_bin NOT NULL,
  `total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `order_status_id` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `currency` varchar(3) COLLATE utf8_bin NOT NULL,
  `value` decimal(15,8) NOT NULL,
  `coupon_id` int(11) NOT NULL,
  `date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '',
  `payment_method_data` text COLLATE utf8_bin NOT NULL,
  `key_id` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `ac_customers_enc`;
CREATE TABLE `ac_customers_enc` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL DEFAULT '0',
  `firstname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `lastname` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `loginname` varchar(96) COLLATE utf8_bin NOT NULL DEFAULT '',
  `email` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `telephone` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `fax` text COLLATE utf8_bin NOT NULL DEFAULT '',
  `sms` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'mobile phone number',
  `salt` varchar(8) COLLATE utf8_bin NOT NULL DEFAULT '',
  `password` varchar(40) COLLATE utf8_bin NOT NULL DEFAULT '',
  `cart` LONGTEXT COLLATE utf8_bin,
  `wishlist` LONGTEXT COLLATE utf8_bin,
  `newsletter` int(1) NOT NULL DEFAULT '0',
  `address_id` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL,
  `approved` int(1) NOT NULL DEFAULT '0',
  `customer_group_id` int(11) NOT NULL,
  `ip` varchar(50) COLLATE utf8_bin NOT NULL DEFAULT '0',
  `data` text DEFAULT null,
  `date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `last_login` timestamp DEFAULT '0000-00-00 00:00:00',
  `key_id` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `customers_loginname` (`loginname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1;

CREATE INDEX `ac_customers_enc_idx` ON `ac_customers_enc` ( `store_id`, `address_id`, `customer_group_id` );
CREATE FULLTEXT INDEX `ac_customers_name_enc_idx` ON `ac_customers_enc` (`firstname`, `lastname`);
