<?php
/**
 * AddressValidationApi
 * PHP version 5
 *
 * @category Class
 * @package  UPS\AddressValidation
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Address Validation - Street Level
 *
 * The Address Validation Street Level API can be used to. check addresses against the United States Postal Service database of valid addresses in the U.S. and Puerto Rico. # Reference - <a href=\"https://developer.ups.com/api/reference/addressvalidation/appendix\" target=\"_blank\" rel=\"noopener\">Appendix</a> - <a href=\"https://developer.ups.com/api/reference/addressvalidation/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/addressvalidation/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/addressvalidation/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-f2cd7176-bd05-48ea-bb72-b359a11cff09?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-f2cd7176-bd05-48ea-bb72-b359a11cff09%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\AddressValidation\Request;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use UPS\AddressValidation\ApiException;
use UPS\AddressValidation\Configuration;
use UPS\AddressValidation\HeaderSelector;
use UPS\AddressValidation\ObjectSerializer;

/**
 * AddressValidationApi Class Doc Comment
 *
 * @category Class
 * @package  UPS\AddressValidation
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AddressValidationApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addressValidation
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $version Identifies the version of the API.  Valid  values: - v2 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \UPS\AddressValidation\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\AddressValidation\AddressValidation\XAVResponseWrapper
     */
    public function addressValidation($body, $requestoption, $version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        list($response) = $this->addressValidationWithHttpInfo($body, $requestoption, $version, $regionalrequestindicator, $maximumcandidatelistsize);
        return $response;
    }

    /**
     * Operation addressValidationWithHttpInfo
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $version Identifies the version of the API.  Valid  values: - v2 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \UPS\AddressValidation\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\AddressValidation\AddressValidation\XAVResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function addressValidationWithHttpInfo($body, $requestoption, $version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        $returnType = '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper';
        $request = $this->addressValidationRequest($body, $requestoption, $version, $regionalrequestindicator, $maximumcandidatelistsize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addressValidationAsync
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $version Identifies the version of the API.  Valid  values: - v2 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addressValidationAsync($body, $requestoption, $version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        return $this->addressValidationAsyncWithHttpInfo($body, $requestoption, $version, $regionalrequestindicator, $maximumcandidatelistsize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addressValidationAsyncWithHttpInfo
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $version Identifies the version of the API.  Valid  values: - v2 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addressValidationAsyncWithHttpInfo($body, $requestoption, $version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        $returnType = '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper';
        $request = $this->addressValidationRequest($body, $requestoption, $version, $regionalrequestindicator, $maximumcandidatelistsize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addressValidation'
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values: - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $version Identifies the version of the API.  Valid  values: - v2 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function addressValidationRequest($body, $requestoption, $version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling addressValidation'
            );
        }
        // verify the required parameter 'requestoption' is set
        if ($requestoption === null || (is_array($requestoption) && count($requestoption) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $requestoption when calling addressValidation'
            );
        }
        // verify the required parameter 'version' is set
        if ($version === null || (is_array($version) && count($version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $version when calling addressValidation'
            );
        }

        $resourcePath = '/addressvalidation/{version}/{requestoption}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($regionalrequestindicator !== null) {
            $queryParams['regionalrequestindicator'] = ObjectSerializer::toQueryValue($regionalrequestindicator, null);
        }
        // query params
        if ($maximumcandidatelistsize !== null) {
            $queryParams['maximumcandidatelistsize'] = ObjectSerializer::toQueryValue($maximumcandidatelistsize, null);
        }

        // path params
        if ($requestoption !== null) {
            $resourcePath = str_replace(
                '{' . 'requestoption' . '}',
                ObjectSerializer::toPathValue($requestoption),
                $resourcePath
            );
        }
        // path params
        if ($version !== null) {
            $resourcePath = str_replace(
                '{' . 'version' . '}',
                ObjectSerializer::toPathValue($version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deprecatedAddressValidation
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $deprecated_version Identifies the version of the API.  Valid  values: - v1 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \UPS\AddressValidation\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \UPS\AddressValidation\AddressValidation\XAVResponseWrapper
     */
    public function deprecatedAddressValidation($body, $requestoption, $deprecated_version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        list($response) = $this->deprecatedAddressValidationWithHttpInfo($body, $requestoption, $deprecated_version, $regionalrequestindicator, $maximumcandidatelistsize);
        return $response;
    }

    /**
     * Operation deprecatedAddressValidationWithHttpInfo
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $deprecated_version Identifies the version of the API.  Valid  values: - v1 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \UPS\AddressValidation\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \UPS\AddressValidation\AddressValidation\XAVResponseWrapper, HTTP status code, HTTP response headers (array of strings)
     */
    public function deprecatedAddressValidationWithHttpInfo($body, $requestoption, $deprecated_version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        $returnType = '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper';
        $request = $this->deprecatedAddressValidationRequest($body, $requestoption, $deprecated_version, $regionalrequestindicator, $maximumcandidatelistsize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\UPS\AddressValidation\AddressValidation\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deprecatedAddressValidationAsync
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $deprecated_version Identifies the version of the API.  Valid  values: - v1 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedAddressValidationAsync($body, $requestoption, $deprecated_version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        return $this->deprecatedAddressValidationAsyncWithHttpInfo($body, $requestoption, $deprecated_version, $regionalrequestindicator, $maximumcandidatelistsize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deprecatedAddressValidationAsyncWithHttpInfo
     *
     * Address Validation
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $deprecated_version Identifies the version of the API.  Valid  values: - v1 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deprecatedAddressValidationAsyncWithHttpInfo($body, $requestoption, $deprecated_version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        $returnType = '\UPS\AddressValidation\AddressValidation\XAVResponseWrapper';
        $request = $this->deprecatedAddressValidationRequest($body, $requestoption, $deprecated_version, $regionalrequestindicator, $maximumcandidatelistsize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deprecatedAddressValidation'
     *
     * @param  \UPS\AddressValidation\AddressValidation\XAVRequestWrapper $body Generate sample code for popular API requests by selecting an example below. To view a full sample request and response, first click \&quot;Authorize\&quot; and enter your application credentials, then populate the required parameters above and click \&quot;Try it out\&quot;. (required)
     * @param  int $requestoption Identifies the optional processing to be performed. If not present or invalid value then an error will be sent back.  Valid values:  - 1 - Address Validation - 2 - Address Classification - 3 - Address Validation and Address Classification.  For a list of valid values, refer to Address Validation API Supported Countries or Territories in the Appendix. (required)
     * @param  string $deprecated_version Identifies the version of the API.  Valid  values: - v1 (required)
     * @param  string $regionalrequestindicator Valid values: True or False.  If True, either the region element or any  combination of Political Division 1,  Political Division 2, PostcodePrimaryLow and the PostcodeExtendedLow fields will  be recognized for validation in addition to  the urbanization element. If False or no  indicator, street level address validation  is provided (optional)
     * @param  int $maximumcandidatelistsize Valid values: 0 – 50 The maximum number of Candidates to  return for this request. If not provided,  the default size of 15 is returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deprecatedAddressValidationRequest($body, $requestoption, $deprecated_version, $regionalrequestindicator = null, $maximumcandidatelistsize = null)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling deprecatedAddressValidation'
            );
        }
        // verify the required parameter 'requestoption' is set
        if ($requestoption === null || (is_array($requestoption) && count($requestoption) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $requestoption when calling deprecatedAddressValidation'
            );
        }
        // verify the required parameter 'deprecated_version' is set
        if ($deprecated_version === null || (is_array($deprecated_version) && count($deprecated_version) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deprecated_version when calling deprecatedAddressValidation'
            );
        }

        $resourcePath = '/addressvalidation/{deprecatedVersion}/{requestoption}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($regionalrequestindicator !== null) {
            $queryParams['regionalrequestindicator'] = ObjectSerializer::toQueryValue($regionalrequestindicator, null);
        }
        // query params
        if ($maximumcandidatelistsize !== null) {
            $queryParams['maximumcandidatelistsize'] = ObjectSerializer::toQueryValue($maximumcandidatelistsize, null);
        }

        // path params
        if ($requestoption !== null) {
            $resourcePath = str_replace(
                '{' . 'requestoption' . '}',
                ObjectSerializer::toPathValue($requestoption),
                $resourcePath
            );
        }
        // path params
        if ($deprecated_version !== null) {
            $resourcePath = str_replace(
                '{' . 'deprecatedVersion' . '}',
                ObjectSerializer::toPathValue($deprecated_version),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
