<?php
/**
 * LabelRecoveryResponseLabelResults
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * LabelRecoveryResponseLabelResults Class Doc Comment
 *
 * @category Class
 * @description Container that stores the label results. Information containing the results of the user&#x27;s Label Recovery Request.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class LabelRecoveryResponseLabelResults implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'LabelRecoveryResponse_LabelResults';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'tracking_number' => 'string',
        'label_image' => '\UPS\Shipping\Shipping\LabelResultsLabelImage',
        'mail_innovations_tracking_number' => 'string',
        'mail_innovations_label_image' => '\UPS\Shipping\Shipping\LabelResultsMailInnovationsLabelImage',
        'receipt' => '\UPS\Shipping\Shipping\LabelResultsReceipt',
        'form' => '\UPS\Shipping\Shipping\LabelResultsForm'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'tracking_number' => null,
        'label_image' => null,
        'mail_innovations_tracking_number' => null,
        'mail_innovations_label_image' => null,
        'receipt' => null,
        'form' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tracking_number' => 'TrackingNumber',
        'label_image' => 'LabelImage',
        'mail_innovations_tracking_number' => 'MailInnovationsTrackingNumber',
        'mail_innovations_label_image' => 'MailInnovationsLabelImage',
        'receipt' => 'Receipt',
        'form' => 'Form'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tracking_number' => 'setTrackingNumber',
        'label_image' => 'setLabelImage',
        'mail_innovations_tracking_number' => 'setMailInnovationsTrackingNumber',
        'mail_innovations_label_image' => 'setMailInnovationsLabelImage',
        'receipt' => 'setReceipt',
        'form' => 'setForm'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tracking_number' => 'getTrackingNumber',
        'label_image' => 'getLabelImage',
        'mail_innovations_tracking_number' => 'getMailInnovationsTrackingNumber',
        'mail_innovations_label_image' => 'getMailInnovationsLabelImage',
        'receipt' => 'getReceipt',
        'form' => 'getForm'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_number'] = isset($data['tracking_number']) ? $data['tracking_number'] : null;
        $this->container['label_image'] = isset($data['label_image']) ? $data['label_image'] : null;
        $this->container['mail_innovations_tracking_number'] = isset($data['mail_innovations_tracking_number']) ? $data['mail_innovations_tracking_number'] : null;
        $this->container['mail_innovations_label_image'] = isset($data['mail_innovations_label_image']) ? $data['mail_innovations_label_image'] : null;
        $this->container['receipt'] = isset($data['receipt']) ? $data['receipt'] : null;
        $this->container['form'] = isset($data['form']) ? $data['form'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tracking_number
     *
     * @return string
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string $tracking_number Package Tracking number.  Package 1Z number. Returned only if TrackingNumber or Combination of Reference Number and Shipper Number present in request.
     *
     * @return $this
     */
    public function setTrackingNumber($tracking_number)
    {
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets label_image
     *
     * @return \UPS\Shipping\Shipping\LabelResultsLabelImage
     */
    public function getLabelImage()
    {
        return $this->container['label_image'];
    }

    /**
     * Sets label_image
     *
     * @param \UPS\Shipping\Shipping\LabelResultsLabelImage $label_image label_image
     *
     * @return $this
     */
    public function setLabelImage($label_image)
    {
        $this->container['label_image'] = $label_image;

        return $this;
    }

    /**
     * Gets mail_innovations_tracking_number
     *
     * @return string
     */
    public function getMailInnovationsTrackingNumber()
    {
        return $this->container['mail_innovations_tracking_number'];
    }

    /**
     * Sets mail_innovations_tracking_number
     *
     * @param string $mail_innovations_tracking_number Mail Innovations Tracking Number.  Applicable for Single Mail Innovations Returns and Dual Mail Innovations Returns shipment. Returned only if MailInnovationsTrackingNumber is provided in request.
     *
     * @return $this
     */
    public function setMailInnovationsTrackingNumber($mail_innovations_tracking_number)
    {
        $this->container['mail_innovations_tracking_number'] = $mail_innovations_tracking_number;

        return $this;
    }

    /**
     * Gets mail_innovations_label_image
     *
     * @return \UPS\Shipping\Shipping\LabelResultsMailInnovationsLabelImage
     */
    public function getMailInnovationsLabelImage()
    {
        return $this->container['mail_innovations_label_image'];
    }

    /**
     * Sets mail_innovations_label_image
     *
     * @param \UPS\Shipping\Shipping\LabelResultsMailInnovationsLabelImage $mail_innovations_label_image mail_innovations_label_image
     *
     * @return $this
     */
    public function setMailInnovationsLabelImage($mail_innovations_label_image)
    {
        $this->container['mail_innovations_label_image'] = $mail_innovations_label_image;

        return $this;
    }

    /**
     * Gets receipt
     *
     * @return \UPS\Shipping\Shipping\LabelResultsReceipt
     */
    public function getReceipt()
    {
        return $this->container['receipt'];
    }

    /**
     * Sets receipt
     *
     * @param \UPS\Shipping\Shipping\LabelResultsReceipt $receipt receipt
     *
     * @return $this
     */
    public function setReceipt($receipt)
    {
        $this->container['receipt'] = $receipt;

        return $this;
    }

    /**
     * Gets form
     *
     * @return \UPS\Shipping\Shipping\LabelResultsForm
     */
    public function getForm()
    {
        return $this->container['form'];
    }

    /**
     * Sets form
     *
     * @param \UPS\Shipping\Shipping\LabelResultsForm $form form
     *
     * @return $this
     */
    public function setForm($form)
    {
        $this->container['form'] = $form;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
