<?php
/**
 * ShipmentServiceOptionsInternationalForms
 *
 * PHP version 5
 *
 * @category Class
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Ship
 *
 * The Shipping Package API gives the application many ways to manage the shipment of packages to their destination. # Reference - <a href=\"https://developer.ups.com/api/reference/shipping/business-rules\" target=\"_blank\" rel=\"noopener\">Business Rules</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix1\" target=\"_blank\" rel=\"noopener\">Appendix 1</a> - <a href=\"https://developer.ups.com/api/reference/shipping/appendix2\" target=\"_blank\" rel=\"noopener\">Appendix 2</a> - <a href=\"https://developer.ups.com/api/reference/shipping/errors\" target=\"_blank\" rel=\"noopener\">Errors</a> - <a href=\"https://developer.ups.com/api/reference/shipping/faq\" target=\"_blank\" rel=\"noopener\">FAQ</a> - <a href=\"https://developer.ups.com/api/reference/shipping/best-practices\" target=\"_blank\" rel=\"noopener noreferrer\"> Best Practices</a>  <br/><p>Try out UPS APIs with example requests using Postman. Explore API documentation and sample applications through GitHub.</p>  <a href=\"https://god.gw.postman.com/run-collection/29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc?action=collection%2Ffork&source=rip_markdown&collection-url=entityId%3D29542085-af2f70b3-405b-4aee-af8d-1eb715e4cebc%26entityType%3Dcollection%26workspaceId%3D7e7595f0-4829-4f9a-aee1-75c126b9d417\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://run.pstmn.io/button.svg\" alt=\"Run In Postman\" style=\"width: 128px; height: 32px;\"></a> <a href=\"https://github.com/UPS-API\" target=\"_blank\" rel=\"noopener noreferrer\">   <img src=\"https://www.ups.com/assets/resources/webcontent/images/gitHubButton.svg\" alt=\"Open in GitHub \" style=\"width: 128px; height: 32px;\"> </a>
 *
 * 
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.71
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace UPS\Shipping\Shipping;

use \ArrayAccess;
use \UPS\Shipping\ObjectSerializer;

/**
 * ShipmentServiceOptionsInternationalForms Class Doc Comment
 *
 * @category Class
 * @description International Forms information.
 * @package  UPS\Shipping
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ShipmentServiceOptionsInternationalForms implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ShipmentServiceOptions_InternationalForms';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'form_type' => 'string[]',
        'user_created_form' => '\UPS\Shipping\Shipping\InternationalFormsUserCreatedForm',
        'ups_premium_care_form' => '\UPS\Shipping\Shipping\InternationalFormsUPSPremiumCareForm',
        'cn22_form' => '\UPS\Shipping\Shipping\InternationalFormsCN22Form',
        'additional_document_indicator' => 'string',
        'form_group_id_name' => 'string',
        'eei_filing_option' => '\UPS\Shipping\Shipping\InternationalFormsEEIFilingOption',
        'contacts' => '\UPS\Shipping\Shipping\InternationalFormsContacts',
        'product' => '\UPS\Shipping\Shipping\InternationalFormsProduct[]',
        'invoice_number' => 'string',
        'invoice_date' => 'string',
        'purchase_order_number' => 'string',
        'terms_of_shipment' => 'string',
        'reason_for_export' => 'string',
        'comments' => 'string',
        'declaration_statement' => 'string',
        'discount' => '\UPS\Shipping\Shipping\InternationalFormsDiscount',
        'freight_charges' => '\UPS\Shipping\Shipping\InternationalFormsFreightCharges',
        'insurance_charges' => '\UPS\Shipping\Shipping\InternationalFormsInsuranceCharges',
        'other_charges' => '\UPS\Shipping\Shipping\InternationalFormsOtherCharges',
        'currency_code' => 'string',
        'blanket_period' => '\UPS\Shipping\Shipping\InternationalFormsBlanketPeriod',
        'export_date' => 'string',
        'exporting_carrier' => 'string',
        'carrier_id' => 'string',
        'in_bond_code' => 'string',
        'entry_number' => 'string',
        'point_of_origin' => 'string',
        'point_of_origin_type' => 'string',
        'mode_of_transport' => 'string',
        'port_of_export' => 'string',
        'port_of_unloading' => 'string',
        'loading_pier' => 'string',
        'parties_to_transaction' => 'string',
        'routed_export_transaction_indicator' => 'string',
        'containerized_indicator' => 'string',
        'override_paperless_indicator' => 'string',
        'shipper_memo' => 'string',
        'hazardous_materials_indicator' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'form_type' => null,
        'user_created_form' => null,
        'ups_premium_care_form' => null,
        'cn22_form' => null,
        'additional_document_indicator' => null,
        'form_group_id_name' => null,
        'eei_filing_option' => null,
        'contacts' => null,
        'product' => null,
        'invoice_number' => null,
        'invoice_date' => null,
        'purchase_order_number' => null,
        'terms_of_shipment' => null,
        'reason_for_export' => null,
        'comments' => null,
        'declaration_statement' => null,
        'discount' => null,
        'freight_charges' => null,
        'insurance_charges' => null,
        'other_charges' => null,
        'currency_code' => null,
        'blanket_period' => null,
        'export_date' => null,
        'exporting_carrier' => null,
        'carrier_id' => null,
        'in_bond_code' => null,
        'entry_number' => null,
        'point_of_origin' => null,
        'point_of_origin_type' => null,
        'mode_of_transport' => null,
        'port_of_export' => null,
        'port_of_unloading' => null,
        'loading_pier' => null,
        'parties_to_transaction' => null,
        'routed_export_transaction_indicator' => null,
        'containerized_indicator' => null,
        'override_paperless_indicator' => null,
        'shipper_memo' => null,
        'hazardous_materials_indicator' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'form_type' => 'FormType',
        'user_created_form' => 'UserCreatedForm',
        'ups_premium_care_form' => 'UPSPremiumCareForm',
        'cn22_form' => 'CN22Form',
        'additional_document_indicator' => 'AdditionalDocumentIndicator',
        'form_group_id_name' => 'FormGroupIdName',
        'eei_filing_option' => 'EEIFilingOption',
        'contacts' => 'Contacts',
        'product' => 'Product',
        'invoice_number' => 'InvoiceNumber',
        'invoice_date' => 'InvoiceDate',
        'purchase_order_number' => 'PurchaseOrderNumber',
        'terms_of_shipment' => 'TermsOfShipment',
        'reason_for_export' => 'ReasonForExport',
        'comments' => 'Comments',
        'declaration_statement' => 'DeclarationStatement',
        'discount' => 'Discount',
        'freight_charges' => 'FreightCharges',
        'insurance_charges' => 'InsuranceCharges',
        'other_charges' => 'OtherCharges',
        'currency_code' => 'CurrencyCode',
        'blanket_period' => 'BlanketPeriod',
        'export_date' => 'ExportDate',
        'exporting_carrier' => 'ExportingCarrier',
        'carrier_id' => 'CarrierID',
        'in_bond_code' => 'InBondCode',
        'entry_number' => 'EntryNumber',
        'point_of_origin' => 'PointOfOrigin',
        'point_of_origin_type' => 'PointOfOriginType',
        'mode_of_transport' => 'ModeOfTransport',
        'port_of_export' => 'PortOfExport',
        'port_of_unloading' => 'PortOfUnloading',
        'loading_pier' => 'LoadingPier',
        'parties_to_transaction' => 'PartiesToTransaction',
        'routed_export_transaction_indicator' => 'RoutedExportTransactionIndicator',
        'containerized_indicator' => 'ContainerizedIndicator',
        'override_paperless_indicator' => 'OverridePaperlessIndicator',
        'shipper_memo' => 'ShipperMemo',
        'hazardous_materials_indicator' => 'HazardousMaterialsIndicator'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'form_type' => 'setFormType',
        'user_created_form' => 'setUserCreatedForm',
        'ups_premium_care_form' => 'setUpsPremiumCareForm',
        'cn22_form' => 'setCn22Form',
        'additional_document_indicator' => 'setAdditionalDocumentIndicator',
        'form_group_id_name' => 'setFormGroupIdName',
        'eei_filing_option' => 'setEeiFilingOption',
        'contacts' => 'setContacts',
        'product' => 'setProduct',
        'invoice_number' => 'setInvoiceNumber',
        'invoice_date' => 'setInvoiceDate',
        'purchase_order_number' => 'setPurchaseOrderNumber',
        'terms_of_shipment' => 'setTermsOfShipment',
        'reason_for_export' => 'setReasonForExport',
        'comments' => 'setComments',
        'declaration_statement' => 'setDeclarationStatement',
        'discount' => 'setDiscount',
        'freight_charges' => 'setFreightCharges',
        'insurance_charges' => 'setInsuranceCharges',
        'other_charges' => 'setOtherCharges',
        'currency_code' => 'setCurrencyCode',
        'blanket_period' => 'setBlanketPeriod',
        'export_date' => 'setExportDate',
        'exporting_carrier' => 'setExportingCarrier',
        'carrier_id' => 'setCarrierId',
        'in_bond_code' => 'setInBondCode',
        'entry_number' => 'setEntryNumber',
        'point_of_origin' => 'setPointOfOrigin',
        'point_of_origin_type' => 'setPointOfOriginType',
        'mode_of_transport' => 'setModeOfTransport',
        'port_of_export' => 'setPortOfExport',
        'port_of_unloading' => 'setPortOfUnloading',
        'loading_pier' => 'setLoadingPier',
        'parties_to_transaction' => 'setPartiesToTransaction',
        'routed_export_transaction_indicator' => 'setRoutedExportTransactionIndicator',
        'containerized_indicator' => 'setContainerizedIndicator',
        'override_paperless_indicator' => 'setOverridePaperlessIndicator',
        'shipper_memo' => 'setShipperMemo',
        'hazardous_materials_indicator' => 'setHazardousMaterialsIndicator'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'form_type' => 'getFormType',
        'user_created_form' => 'getUserCreatedForm',
        'ups_premium_care_form' => 'getUpsPremiumCareForm',
        'cn22_form' => 'getCn22Form',
        'additional_document_indicator' => 'getAdditionalDocumentIndicator',
        'form_group_id_name' => 'getFormGroupIdName',
        'eei_filing_option' => 'getEeiFilingOption',
        'contacts' => 'getContacts',
        'product' => 'getProduct',
        'invoice_number' => 'getInvoiceNumber',
        'invoice_date' => 'getInvoiceDate',
        'purchase_order_number' => 'getPurchaseOrderNumber',
        'terms_of_shipment' => 'getTermsOfShipment',
        'reason_for_export' => 'getReasonForExport',
        'comments' => 'getComments',
        'declaration_statement' => 'getDeclarationStatement',
        'discount' => 'getDiscount',
        'freight_charges' => 'getFreightCharges',
        'insurance_charges' => 'getInsuranceCharges',
        'other_charges' => 'getOtherCharges',
        'currency_code' => 'getCurrencyCode',
        'blanket_period' => 'getBlanketPeriod',
        'export_date' => 'getExportDate',
        'exporting_carrier' => 'getExportingCarrier',
        'carrier_id' => 'getCarrierId',
        'in_bond_code' => 'getInBondCode',
        'entry_number' => 'getEntryNumber',
        'point_of_origin' => 'getPointOfOrigin',
        'point_of_origin_type' => 'getPointOfOriginType',
        'mode_of_transport' => 'getModeOfTransport',
        'port_of_export' => 'getPortOfExport',
        'port_of_unloading' => 'getPortOfUnloading',
        'loading_pier' => 'getLoadingPier',
        'parties_to_transaction' => 'getPartiesToTransaction',
        'routed_export_transaction_indicator' => 'getRoutedExportTransactionIndicator',
        'containerized_indicator' => 'getContainerizedIndicator',
        'override_paperless_indicator' => 'getOverridePaperlessIndicator',
        'shipper_memo' => 'getShipperMemo',
        'hazardous_materials_indicator' => 'getHazardousMaterialsIndicator'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }



    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['form_type'] = isset($data['form_type']) ? $data['form_type'] : null;
        $this->container['user_created_form'] = isset($data['user_created_form']) ? $data['user_created_form'] : null;
        $this->container['ups_premium_care_form'] = isset($data['ups_premium_care_form']) ? $data['ups_premium_care_form'] : null;
        $this->container['cn22_form'] = isset($data['cn22_form']) ? $data['cn22_form'] : null;
        $this->container['additional_document_indicator'] = isset($data['additional_document_indicator']) ? $data['additional_document_indicator'] : null;
        $this->container['form_group_id_name'] = isset($data['form_group_id_name']) ? $data['form_group_id_name'] : null;
        $this->container['eei_filing_option'] = isset($data['eei_filing_option']) ? $data['eei_filing_option'] : null;
        $this->container['contacts'] = isset($data['contacts']) ? $data['contacts'] : null;
        $this->container['product'] = isset($data['product']) ? $data['product'] : null;
        $this->container['invoice_number'] = isset($data['invoice_number']) ? $data['invoice_number'] : null;
        $this->container['invoice_date'] = isset($data['invoice_date']) ? $data['invoice_date'] : null;
        $this->container['purchase_order_number'] = isset($data['purchase_order_number']) ? $data['purchase_order_number'] : null;
        $this->container['terms_of_shipment'] = isset($data['terms_of_shipment']) ? $data['terms_of_shipment'] : null;
        $this->container['reason_for_export'] = isset($data['reason_for_export']) ? $data['reason_for_export'] : null;
        $this->container['comments'] = isset($data['comments']) ? $data['comments'] : null;
        $this->container['declaration_statement'] = isset($data['declaration_statement']) ? $data['declaration_statement'] : null;
        $this->container['discount'] = isset($data['discount']) ? $data['discount'] : null;
        $this->container['freight_charges'] = isset($data['freight_charges']) ? $data['freight_charges'] : null;
        $this->container['insurance_charges'] = isset($data['insurance_charges']) ? $data['insurance_charges'] : null;
        $this->container['other_charges'] = isset($data['other_charges']) ? $data['other_charges'] : null;
        $this->container['currency_code'] = isset($data['currency_code']) ? $data['currency_code'] : null;
        $this->container['blanket_period'] = isset($data['blanket_period']) ? $data['blanket_period'] : null;
        $this->container['export_date'] = isset($data['export_date']) ? $data['export_date'] : null;
        $this->container['exporting_carrier'] = isset($data['exporting_carrier']) ? $data['exporting_carrier'] : null;
        $this->container['carrier_id'] = isset($data['carrier_id']) ? $data['carrier_id'] : null;
        $this->container['in_bond_code'] = isset($data['in_bond_code']) ? $data['in_bond_code'] : null;
        $this->container['entry_number'] = isset($data['entry_number']) ? $data['entry_number'] : null;
        $this->container['point_of_origin'] = isset($data['point_of_origin']) ? $data['point_of_origin'] : null;
        $this->container['point_of_origin_type'] = isset($data['point_of_origin_type']) ? $data['point_of_origin_type'] : null;
        $this->container['mode_of_transport'] = isset($data['mode_of_transport']) ? $data['mode_of_transport'] : null;
        $this->container['port_of_export'] = isset($data['port_of_export']) ? $data['port_of_export'] : null;
        $this->container['port_of_unloading'] = isset($data['port_of_unloading']) ? $data['port_of_unloading'] : null;
        $this->container['loading_pier'] = isset($data['loading_pier']) ? $data['loading_pier'] : null;
        $this->container['parties_to_transaction'] = isset($data['parties_to_transaction']) ? $data['parties_to_transaction'] : null;
        $this->container['routed_export_transaction_indicator'] = isset($data['routed_export_transaction_indicator']) ? $data['routed_export_transaction_indicator'] : null;
        $this->container['containerized_indicator'] = isset($data['containerized_indicator']) ? $data['containerized_indicator'] : null;
        $this->container['override_paperless_indicator'] = isset($data['override_paperless_indicator']) ? $data['override_paperless_indicator'] : null;
        $this->container['shipper_memo'] = isset($data['shipper_memo']) ? $data['shipper_memo'] : null;
        $this->container['hazardous_materials_indicator'] = isset($data['hazardous_materials_indicator']) ? $data['hazardous_materials_indicator'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['form_type'] === null) {
            $invalidProperties[] = "'form_type' can't be null";
        }
        if ($this->container['product'] === null) {
            $invalidProperties[] = "'product' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets form_type
     *
     * @return string[]
     */
    public function getFormType()
    {
        return $this->container['form_type'];
    }

    /**
     * Sets form_type
     *
     * @param string[] $form_type Indicates the name of the International Form requested.  Valid values: - 01 - Invoice - 03 - CO - 04 - NAFTA CO - 05 - Partial Invoice - 06 - Packinglist - 07 - Customer Generated Forms - 08 – Air Freight Packing List - 09 - CN22 Form - 10 – UPS Premium Care Form - 11 - EEI  For shipment with return service, 05 or 10 are the only valid values.  Note: 01 and 05 are mutually exclusive and 05 are only valid for return shipments only.
     *
     * @return $this
     */
    public function setFormType($form_type)
    {
        $this->container['form_type'] = $form_type;

        return $this;
    }

    /**
     * Gets user_created_form
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsUserCreatedForm
     */
    public function getUserCreatedForm()
    {
        return $this->container['user_created_form'];
    }

    /**
     * Sets user_created_form
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsUserCreatedForm $user_created_form user_created_form
     *
     * @return $this
     */
    public function setUserCreatedForm($user_created_form)
    {
        $this->container['user_created_form'] = $user_created_form;

        return $this;
    }

    /**
     * Gets ups_premium_care_form
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsUPSPremiumCareForm
     */
    public function getUpsPremiumCareForm()
    {
        return $this->container['ups_premium_care_form'];
    }

    /**
     * Sets ups_premium_care_form
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsUPSPremiumCareForm $ups_premium_care_form ups_premium_care_form
     *
     * @return $this
     */
    public function setUpsPremiumCareForm($ups_premium_care_form)
    {
        $this->container['ups_premium_care_form'] = $ups_premium_care_form;

        return $this;
    }

    /**
     * Gets cn22_form
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsCN22Form
     */
    public function getCn22Form()
    {
        return $this->container['cn22_form'];
    }

    /**
     * Sets cn22_form
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsCN22Form $cn22_form cn22_form
     *
     * @return $this
     */
    public function setCn22Form($cn22_form)
    {
        $this->container['cn22_form'] = $cn22_form;

        return $this;
    }

    /**
     * Gets additional_document_indicator
     *
     * @return string
     */
    public function getAdditionalDocumentIndicator()
    {
        return $this->container['additional_document_indicator'];
    }

    /**
     * Sets additional_document_indicator
     *
     * @param string $additional_document_indicator Presence of the indicator means user will supply additional document, such as EEI, NAFTA_CO or CO.  This indicator should be set when the shipper intends to utilize UPS paperless invoice functionality AND the shipper has SELF-PREPARED other International Forms (EEI, CO, NAFTACO) to accompany the shipment.  It is evaluated only when:  1. Account is paperless enabled.  2. Movement requires an invoice. 3. Destination country or territory accepts paperless invoice.  4. Invoice data is supplied by the client and the data passes validation.
     *
     * @return $this
     */
    public function setAdditionalDocumentIndicator($additional_document_indicator)
    {
        $this->container['additional_document_indicator'] = $additional_document_indicator;

        return $this;
    }

    /**
     * Gets form_group_id_name
     *
     * @return string
     */
    public function getFormGroupIdName()
    {
        return $this->container['form_group_id_name'];
    }

    /**
     * Sets form_group_id_name
     *
     * @param string $form_group_id_name Contains description text which identifies the group of International forms. This element does not appear on the forms.
     *
     * @return $this
     */
    public function setFormGroupIdName($form_group_id_name)
    {
        $this->container['form_group_id_name'] = $form_group_id_name;

        return $this;
    }

    /**
     * Gets eei_filing_option
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsEEIFilingOption
     */
    public function getEeiFilingOption()
    {
        return $this->container['eei_filing_option'];
    }

    /**
     * Sets eei_filing_option
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsEEIFilingOption $eei_filing_option eei_filing_option
     *
     * @return $this
     */
    public function setEeiFilingOption($eei_filing_option)
    {
        $this->container['eei_filing_option'] = $eei_filing_option;

        return $this;
    }

    /**
     * Gets contacts
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsContacts
     */
    public function getContacts()
    {
        return $this->container['contacts'];
    }

    /**
     * Sets contacts
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsContacts $contacts contacts
     *
     * @return $this
     */
    public function setContacts($contacts)
    {
        $this->container['contacts'] = $contacts;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsProduct[]
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsProduct[] $product product
     *
     * @return $this
     */
    public function setProduct($product)
    {
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string $invoice_number Commercial Invoice number assigned by the exporter.  Applies to Invoice and Partial Invoice forms only. Required for Invoice forms and optional for Partial Invoice.
     *
     * @return $this
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets invoice_date
     *
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->container['invoice_date'];
    }

    /**
     * Sets invoice_date
     *
     * @param string $invoice_date Date when the Invoice is created. Ideally this is the same as the ship date.  Applies to Invoice and Partial Invoice forms only. Required for Invoice forms and optional for Partial Invoice. Required for Invoice form for forward shipments. For shipment with return service, the user input will be ignored, and the field will be blank on the invoice. Format is yyyyMMdd.
     *
     * @return $this
     */
    public function setInvoiceDate($invoice_date)
    {
        $this->container['invoice_date'] = $invoice_date;

        return $this;
    }

    /**
     * Gets purchase_order_number
     *
     * @return string
     */
    public function getPurchaseOrderNumber()
    {
        return $this->container['purchase_order_number'];
    }

    /**
     * Sets purchase_order_number
     *
     * @param string $purchase_order_number The customer's order reference number.  Applies to Invoice and Partial Invoice forms only.
     *
     * @return $this
     */
    public function setPurchaseOrderNumber($purchase_order_number)
    {
        $this->container['purchase_order_number'] = $purchase_order_number;

        return $this;
    }

    /**
     * Gets terms_of_shipment
     *
     * @return string
     */
    public function getTermsOfShipment()
    {
        return $this->container['terms_of_shipment'];
    }

    /**
     * Sets terms_of_shipment
     *
     * @param string $terms_of_shipment Indicates the rights to the seller from the buyer. Also, it refers to Terms of Sale.  Applies to Invoice and Partial Invoice forms only.   Valid values:  CFR: Cost and Freight  CIF: Cost Insurance and Freight  CIP: Carriage and Insurance Paid  CPT: Carriage Paid To  DAF: Delivered at Frontier  DDP: Delivery Duty Paid  DDU: Delivery Duty Unpaid  DEQ: Delivered Ex Quay  DES: Delivered Ex Ship  EXW: Ex Works  FAS: Free Alongside Ship  FCA: Free Carrier  FOB: Free On Board
     *
     * @return $this
     */
    public function setTermsOfShipment($terms_of_shipment)
    {
        $this->container['terms_of_shipment'] = $terms_of_shipment;

        return $this;
    }

    /**
     * Gets reason_for_export
     *
     * @return string
     */
    public function getReasonForExport()
    {
        return $this->container['reason_for_export'];
    }

    /**
     * Sets reason_for_export
     *
     * @param string $reason_for_export A reason to export the current international shipment. Valid values: SALE, GIFT, SAMPLE, RETURN, REPAIR, INTERCOMPANYDATA, Any other reason.  Applies to Invoice and Partial Invoice forms only. Required for Invoice forms and Optional for Partial Invoice. No validation.
     *
     * @return $this
     */
    public function setReasonForExport($reason_for_export)
    {
        $this->container['reason_for_export'] = $reason_for_export;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string $comments Any extra information about the current shipment.  Applies to Invoice and Partial Invoice forms only.
     *
     * @return $this
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets declaration_statement
     *
     * @return string
     */
    public function getDeclarationStatement()
    {
        return $this->container['declaration_statement'];
    }

    /**
     * Sets declaration_statement
     *
     * @param string $declaration_statement This is the legal explanation, used by Customs, for the delivering of this shipment. It must be identical to the set of declarations actually used by Customs. Examples of declarations that might be entered in this field are: I hereby certify that the goods covered by this shipment qualify as originating goods for purposes of preferential tariff treatment under the NAFTA. I hereby certify that the information on this invoice is true and correct and the contents and value of this shipment is as stated above.  EEA statement:  The exporter of the products covered by this document declares that except where otherwise clearly indicated these products are of EEA preferential origin.  Applies to Invoice and Partial Invoice forms only. On the invoice for return shipment, the verbiage is as follows (user input is ignored): The exporter of the products covered by this document declares that except where otherwise clearly indicated these products are of EEA preferential origin
     *
     * @return $this
     */
    public function setDeclarationStatement($declaration_statement)
    {
        $this->container['declaration_statement'] = $declaration_statement;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsDiscount
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsDiscount $discount discount
     *
     * @return $this
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets freight_charges
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsFreightCharges
     */
    public function getFreightCharges()
    {
        return $this->container['freight_charges'];
    }

    /**
     * Sets freight_charges
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsFreightCharges $freight_charges freight_charges
     *
     * @return $this
     */
    public function setFreightCharges($freight_charges)
    {
        $this->container['freight_charges'] = $freight_charges;

        return $this;
    }

    /**
     * Gets insurance_charges
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsInsuranceCharges
     */
    public function getInsuranceCharges()
    {
        return $this->container['insurance_charges'];
    }

    /**
     * Sets insurance_charges
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsInsuranceCharges $insurance_charges insurance_charges
     *
     * @return $this
     */
    public function setInsuranceCharges($insurance_charges)
    {
        $this->container['insurance_charges'] = $insurance_charges;

        return $this;
    }

    /**
     * Gets other_charges
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsOtherCharges
     */
    public function getOtherCharges()
    {
        return $this->container['other_charges'];
    }

    /**
     * Sets other_charges
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsOtherCharges $other_charges other_charges
     *
     * @return $this
     */
    public function setOtherCharges($other_charges)
    {
        $this->container['other_charges'] = $other_charges;

        return $this;
    }

    /**
     * Gets currency_code
     *
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param string $currency_code Currency code for all the monetary values of the Invoice form.  Applies to Invoice and Partial Invoice forms only.
     *
     * @return $this
     */
    public function setCurrencyCode($currency_code)
    {
        $this->container['currency_code'] = $currency_code;

        return $this;
    }

    /**
     * Gets blanket_period
     *
     * @return \UPS\Shipping\Shipping\InternationalFormsBlanketPeriod
     */
    public function getBlanketPeriod()
    {
        return $this->container['blanket_period'];
    }

    /**
     * Sets blanket_period
     *
     * @param \UPS\Shipping\Shipping\InternationalFormsBlanketPeriod $blanket_period blanket_period
     *
     * @return $this
     */
    public function setBlanketPeriod($blanket_period)
    {
        $this->container['blanket_period'] = $blanket_period;

        return $this;
    }

    /**
     * Gets export_date
     *
     * @return string
     */
    public function getExportDate()
    {
        return $this->container['export_date'];
    }

    /**
     * Sets export_date
     *
     * @param string $export_date The date the goods will be exiting the country or territory.  Applies to CO and EEI forms only. Required for CO and EEI forms. Format is yyyyMMdd.
     *
     * @return $this
     */
    public function setExportDate($export_date)
    {
        $this->container['export_date'] = $export_date;

        return $this;
    }

    /**
     * Gets exporting_carrier
     *
     * @return string
     */
    public function getExportingCarrier()
    {
        return $this->container['exporting_carrier'];
    }

    /**
     * Sets exporting_carrier
     *
     * @param string $exporting_carrier The name of the carrier that is exporting the shipment. The vessels flag number should also be entered, if the carrier is a vessel.  If value is empty, it will be set to default value as 'UPS' for EEI forms.  Applies to CO and EEI forms only. Required for CO forms.
     *
     * @return $this
     */
    public function setExportingCarrier($exporting_carrier)
    {
        $this->container['exporting_carrier'] = $exporting_carrier;

        return $this;
    }

    /**
     * Gets carrier_id
     *
     * @return string
     */
    public function getCarrierId()
    {
        return $this->container['carrier_id'];
    }

    /**
     * Sets carrier_id
     *
     * @param string $carrier_id The four-character Standard Carrier Alpha Code (SCAC) for vessel, rail, and truck shipments. For air shipment, enter the two or three character International Air Transport Association (IATA) code.  Applies to EEI forms only. No Validations.
     *
     * @return $this
     */
    public function setCarrierId($carrier_id)
    {
        $this->container['carrier_id'] = $carrier_id;

        return $this;
    }

    /**
     * Gets in_bond_code
     *
     * @return string
     */
    public function getInBondCode()
    {
        return $this->container['in_bond_code'];
    }

    /**
     * Sets in_bond_code
     *
     * @param string $in_bond_code The two-character In Bond Code.  Applies to EEI forms only. Required for EEI forms. Valid values for EEI are: 70: Not in bond; 67: IE from a FTZ; 68: T&E from a FTZ.
     *
     * @return $this
     */
    public function setInBondCode($in_bond_code)
    {
        $this->container['in_bond_code'] = $in_bond_code;

        return $this;
    }

    /**
     * Gets entry_number
     *
     * @return string
     */
    public function getEntryNumber()
    {
        return $this->container['entry_number'];
    }

    /**
     * Sets entry_number
     *
     * @param string $entry_number The Import Entry Number when the export transaction is used as proof of export for import transactions (examples: In Bond, Temporary Import Bond or Drawbacks).  Applies to EEI forms only. Conditionally Required for EEI forms when In bond code value is other than 70 (Not In Bond)
     *
     * @return $this
     */
    public function setEntryNumber($entry_number)
    {
        $this->container['entry_number'] = $entry_number;

        return $this;
    }

    /**
     * Gets point_of_origin
     *
     * @return string
     */
    public function getPointOfOrigin()
    {
        return $this->container['point_of_origin'];
    }

    /**
     * Sets point_of_origin
     *
     * @param string $point_of_origin Contains one of the following:  The two-digit U.S. Postal Service abbreviation for the state from which the goods were shipped to the port of export. The state that is the source for the good with the highest value. The state of consolidation. The Foreign Trade Zone number of the zone from where the exports are leaving.  If the goods were shipped from Puerto Rico, enter PR.  Applies to EEI forms only. Required for EEI.
     *
     * @return $this
     */
    public function setPointOfOrigin($point_of_origin)
    {
        $this->container['point_of_origin'] = $point_of_origin;

        return $this;
    }

    /**
     * Gets point_of_origin_type
     *
     * @return string
     */
    public function getPointOfOriginType()
    {
        return $this->container['point_of_origin_type'];
    }

    /**
     * Sets point_of_origin_type
     *
     * @param string $point_of_origin_type Valid values are : S (for state postal code abbreviation) , F : FTZ Identifier  Applies EEI forms only. Required for EEI form.
     *
     * @return $this
     */
    public function setPointOfOriginType($point_of_origin_type)
    {
        $this->container['point_of_origin_type'] = $point_of_origin_type;

        return $this;
    }

    /**
     * Gets mode_of_transport
     *
     * @return string
     */
    public function getModeOfTransport()
    {
        return $this->container['mode_of_transport'];
    }

    /**
     * Sets mode_of_transport
     *
     * @param string $mode_of_transport Mode of transport by which the goods are exported. Valid values: Air, AirContainerized, Auto, FixedTransportInstallations, Mail, PassengerHandcarried, Pedestrian, Rail, Rail, Containerized, RoadOther, SeaBarge, SeaContainerized, SeaNoncontainerized, Truck, TruckContainerized.  Applies to EEI forms only.  Required for EEI.  Only allowed values can be entered. Only 10 Characters can appear on the form. Anything greater than 10 characters will be truncated on the form.
     *
     * @return $this
     */
    public function setModeOfTransport($mode_of_transport)
    {
        $this->container['mode_of_transport'] = $mode_of_transport;

        return $this;
    }

    /**
     * Gets port_of_export
     *
     * @return string
     */
    public function getPortOfExport()
    {
        return $this->container['port_of_export'];
    }

    /**
     * Sets port_of_export
     *
     * @param string $port_of_export Should be one of the following-Overland: The U.S. Customs port where the carrier crosses the U.S. border, Vessel and Air: The U.S. Customs port where the goods are loaded on the carrier to be exported from the U.S., Postal: The U.S. Postal Office from where the goods are mailed.  Applies to EEI forms only. No validation is performed.
     *
     * @return $this
     */
    public function setPortOfExport($port_of_export)
    {
        $this->container['port_of_export'] = $port_of_export;

        return $this;
    }

    /**
     * Gets port_of_unloading
     *
     * @return string
     */
    public function getPortOfUnloading()
    {
        return $this->container['port_of_unloading'];
    }

    /**
     * Sets port_of_unloading
     *
     * @param string $port_of_unloading The country or territory and the port where the goods will be unloaded from the exporting carrier. For vessel and air shipments only.  Applies to EEI forms only. No validation is performed.
     *
     * @return $this
     */
    public function setPortOfUnloading($port_of_unloading)
    {
        $this->container['port_of_unloading'] = $port_of_unloading;

        return $this;
    }

    /**
     * Gets loading_pier
     *
     * @return string
     */
    public function getLoadingPier()
    {
        return $this->container['loading_pier'];
    }

    /**
     * Sets loading_pier
     *
     * @param string $loading_pier Pier where goods are loaded. For vessel shipments only.  Applies to EEI forms only. No validation is performed.
     *
     * @return $this
     */
    public function setLoadingPier($loading_pier)
    {
        $this->container['loading_pier'] = $loading_pier;

        return $this;
    }

    /**
     * Gets parties_to_transaction
     *
     * @return string
     */
    public function getPartiesToTransaction()
    {
        return $this->container['parties_to_transaction'];
    }

    /**
     * Sets parties_to_transaction
     *
     * @param string $parties_to_transaction Information about parties to transaction. Use Related, if the parties to the transaction are related. A related party is an export from a U.S. businessperson or business to a foreign business or from a U.S. business to a foreign person or business where the person has at least 10 percent of the voting shares of the business during the fiscal year. If unincorporated, then an equivalent interest in the business.  Applies to EEI forms only.  Valid values: - R - Related - N - Non-related.  Parties to transaction is required if EEIFilingOption Code is 3 and if valid UPSFiled POA Code present in request.  Default will be set to N - Non-related if invalid code present with length of one.
     *
     * @return $this
     */
    public function setPartiesToTransaction($parties_to_transaction)
    {
        $this->container['parties_to_transaction'] = $parties_to_transaction;

        return $this;
    }

    /**
     * Gets routed_export_transaction_indicator
     *
     * @return string
     */
    public function getRoutedExportTransactionIndicator()
    {
        return $this->container['routed_export_transaction_indicator'];
    }

    /**
     * Sets routed_export_transaction_indicator
     *
     * @param string $routed_export_transaction_indicator If Present, indicates that it is a routed export transaction. A routed export transaction is one, where the foreign principal party in interest authorizes a U.S. forwarding (or other) agent to export the merchandise outside the U.S.  Applies to EEI forms only.
     *
     * @return $this
     */
    public function setRoutedExportTransactionIndicator($routed_export_transaction_indicator)
    {
        $this->container['routed_export_transaction_indicator'] = $routed_export_transaction_indicator;

        return $this;
    }

    /**
     * Gets containerized_indicator
     *
     * @return string
     */
    public function getContainerizedIndicator()
    {
        return $this->container['containerized_indicator'];
    }

    /**
     * Sets containerized_indicator
     *
     * @param string $containerized_indicator If present indicates that the goods are containerized. This applies to vessel shipments only.  Applies to EEI forms only.
     *
     * @return $this
     */
    public function setContainerizedIndicator($containerized_indicator)
    {
        $this->container['containerized_indicator'] = $containerized_indicator;

        return $this;
    }

    /**
     * Gets override_paperless_indicator
     *
     * @return string
     */
    public function getOverridePaperlessIndicator()
    {
        return $this->container['override_paperless_indicator'];
    }

    /**
     * Sets override_paperless_indicator
     *
     * @param string $override_paperless_indicator The application will automatically provide a copy of the invoice or NAFTA/CO with each response regardless of whether the user has enabled Paperless account. The user now has the option to print or ignore the copy provided.
     *
     * @return $this
     */
    public function setOverridePaperlessIndicator($override_paperless_indicator)
    {
        $this->container['override_paperless_indicator'] = $override_paperless_indicator;

        return $this;
    }

    /**
     * Gets shipper_memo
     *
     * @return string
     */
    public function getShipperMemo()
    {
        return $this->container['shipper_memo'];
    }

    /**
     * Sets shipper_memo
     *
     * @param string $shipper_memo Text for the shipper to add additional information.  Forward shipment only.
     *
     * @return $this
     */
    public function setShipperMemo($shipper_memo)
    {
        $this->container['shipper_memo'] = $shipper_memo;

        return $this;
    }

    /**
     * Gets hazardous_materials_indicator
     *
     * @return string
     */
    public function getHazardousMaterialsIndicator()
    {
        return $this->container['hazardous_materials_indicator'];
    }

    /**
     * Sets hazardous_materials_indicator
     *
     * @param string $hazardous_materials_indicator This is an empty tag. Presence of the indicator for EEI form means shipment contains hazardous material.
     *
     * @return $this
     */
    public function setHazardousMaterialsIndicator($hazardous_materials_indicator)
    {
        $this->container['hazardous_materials_indicator'] = $hazardous_materials_indicator;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
