<?php
/**
 ***********************************************************************************************
 * Redirect to chosen url
 *
 * @copyright The Admidio Team
 * @see https://www.admidio.org/
 * @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2.0 only
 ***********************************************************************************************
 */

/******************************************************************************
 * Parameters:
 *
 * url - url that should be redirected
 *
 *****************************************************************************/

use Admidio\UI\Presenter\PagePresenter;

try {
    require_once(__DIR__ . '/common.php');

    // Initialize and check the parameters
    $getUrl = admFuncVariableIsValid($_GET, 'url', 'url', array('requireValue' => true));

    if (filter_var($getUrl, FILTER_VALIDATE_URL) === false) {
        throw new \Admidio\Infrastructure\Exception('SYS_REDIRECT_URL_INVALID');
    }

    // create an HTML page object
    $page = PagePresenter::withHtmlIDAndHeadline('admidio-redirect', $gL10n->get('SYS_REDIRECT'));

    // add special header for automatic redirection after x seconds
    $page->addHeader('<meta http-equiv="refresh" content="' . $gSettingsManager->getInt('weblinks_redirect_seconds') . '; url=' . $getUrl . '">');

    // Counter zählt die sekunden bis zur Weiterleitung runter
    $page->addJavascript(
        '
        /**
         * @param {bool} init
         */
        function countDown(init) {
            if (init || --document.getElementById("counter").firstChild.nodeValue > 0) {
                window.setTimeout("countDown()", 1000);
            }
        };
        countDown(true);'
    );

    // Html des Modules ausgeben
    $page->addHtml(
        '<p class="lead">' .
        $gL10n->get(
            'SYS_REDIRECT_DESC',
            array($gCurrentOrganization->getValue('org_longname'),
                '<span id="counter">' . $gSettingsManager->getInt('weblinks_redirect_seconds') . '</span>',
                '<strong>' . $getUrl . '</strong>',
                '<a href="' . $getUrl . '" target="_self">',
                '</a>')
        ) .
        '</p>'
    );

    // show HTML of complete page
    $page->show();
} catch (Throwable $e) {
    handleException($e);
}
