
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `admidio503`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_announcements`
--

CREATE TABLE `[[dbprefix]]_announcements` (
  `ann_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ann_cat_id` int(10) unsigned NOT NULL,
  `ann_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `ann_headline` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `ann_description` text COLLATE utf8_unicode_ci,
  `ann_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ann_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ann_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ann_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ann_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ann_uuid` (`ann_uuid`),
  KEY `[[dbprefix]]_fk_ann_cat` (`ann_cat_id`),
  KEY `[[dbprefix]]_fk_ann_usr_create` (`ann_usr_id_create`),
  KEY `[[dbprefix]]_fk_ann_usr_change` (`ann_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_auto_login`
--

CREATE TABLE `[[dbprefix]]_auto_login` (
  `atl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `atl_auto_login_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `atl_session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `atl_org_id` int(10) unsigned NOT NULL,
  `atl_usr_id` int(10) unsigned NOT NULL,
  `atl_last_login` timestamp NULL DEFAULT NULL,
  `atl_number_invalid` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`atl_id`),
  KEY `[[dbprefix]]_fk_atl_usr` (`atl_usr_id`),
  KEY `[[dbprefix]]_fk_atl_org` (`atl_org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_categories`
--

CREATE TABLE `[[dbprefix]]_categories` (
  `cat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cat_org_id` int(10) unsigned DEFAULT NULL,
  `cat_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `cat_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `cat_name_intern` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `cat_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `cat_system` tinyint(1) NOT NULL DEFAULT '0',
  `cat_default` tinyint(1) NOT NULL DEFAULT '0',
  `cat_sequence` smallint(6) NOT NULL,
  `cat_usr_id_create` int(10) unsigned DEFAULT NULL,
  `cat_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `cat_usr_id_change` int(10) unsigned DEFAULT NULL,
  `cat_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `[[dbprefix]]_idx_cat_uuid` (`cat_uuid`),
  KEY `[[dbprefix]]_fk_cat_org` (`cat_org_id`),
  KEY `[[dbprefix]]_fk_cat_usr_create` (`cat_usr_id_create`),
  KEY `[[dbprefix]]_fk_cat_usr_change` (`cat_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=18 ;

--
-- Dumping data for table `[[dbprefix]]_categories`
--

INSERT INTO `[[dbprefix]]_categories` VALUES
(1, NULL, '7321b0d2-6b3b-474b-99f7-15d4f2e96e9b', 'USF', 'BASIC_DATA', 'SYS_BASIC_DATA', 1, 0, 1, 1, '[[regtime]]', NULL, NULL),
(2, NULL, '8b5dbd08-48a8-4dfe-aa89-d5ac5b3c9502', 'USF', 'SOCIAL_NETWORKS', 'SYS_SOCIAL_NETWORKS', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(3, NULL, '7da19b2b-8609-4626-af77-5cf1fb32a428', 'USF', 'ADDIDIONAL_DATA', 'INS_ADDIDIONAL_DATA', 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, 1, '955ca173-bc90-4141-83f9-37dc050b83f6', 'ROL', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(5, 1, '0f4f40cd-4d1b-418f-bd7b-34cf15554aa7', 'ROL', 'GROUPS', 'INS_GROUPS', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(6, 1, '9ab5525d-7bf7-4c82-87b2-7e192fe61bd2', 'ROL', 'COURSES', 'INS_COURSES', 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(7, 1, 'e479a4eb-2f1b-4ecd-b039-6cede427cc3e', 'ROL', 'TEAMS', 'INS_TEAMS', 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(8, 1, '4b218bb9-b95a-41f9-93c7-bb54d0fd6607', 'ROL', 'EVENTS', 'SYS_EVENTS_CONFIRMATION_OF_PARTICIPATION', 1, 0, 5, 1, '[[regtime]]', NULL, NULL),
(9, 1, '199cf0f5-ad02-46fa-86a1-d8ba59933584', 'LNK', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(10, 1, '4cda7969-8705-4295-a84f-df61f3d7a991', 'LNK', 'INTERN', 'INS_INTERN', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(11, 1, '7a823461-3279-4f11-91fa-414f978144b4', 'ANN', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(12, 1, '1f6ba5a0-ec05-4479-a478-bec411d7e090', 'ANN', 'IMPORTANT', 'SYS_IMPORTANT', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(13, 1, '9d571b01-586b-4d6d-bd5e-dc286bffc1c2', 'FOT', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(14, 1, '61e08c1d-bd14-4b33-9d0a-25a326dc9b3d', 'EVT', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL),
(15, 1, 'd1a0688d-e6d4-472b-b8e4-97600897eafb', 'EVT', 'TRAINING', 'INS_TRAINING', 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(16, 1, '1ae43e92-7ca0-4130-b369-bee7a7ff8873', 'EVT', 'COURSES', 'INS_COURSES', 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(17, 1, '401fa834-e4fc-4c08-988a-bae8b2177b97', 'IVT', 'COMMON', 'SYS_COMMON', 0, 1, 1, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_category_report`
--

CREATE TABLE `[[dbprefix]]_category_report` (
  `crt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `crt_org_id` int(10) unsigned DEFAULT NULL,
  `crt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `crt_col_fields` text COLLATE utf8_unicode_ci,
  `crt_selection_role` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crt_selection_cat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `crt_number_col` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`crt_id`),
  KEY `[[dbprefix]]_fk_crt_org` (`crt_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_category_report`
--

INSERT INTO `[[dbprefix]]_category_report` VALUES
(1, 1, 'General role assignment', 'p2,p1,p3,p5,r1,r3,r2', NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_components`
--

CREATE TABLE `[[dbprefix]]_components` (
  `com_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `com_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `com_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `com_name_intern` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `com_version` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `com_beta` smallint(6) NOT NULL DEFAULT '0',
  `com_update_step` int(11) NOT NULL DEFAULT '0',
  `com_update_completed` tinyint(1) NOT NULL DEFAULT '1',
  `com_timestamp_installed` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`com_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]_components`
--

INSERT INTO `[[dbprefix]]_components` VALUES
(1, 'SYSTEM', 'Admidio Core', 'CORE', '5.0.3', 0, 1860, 1, '[[regtime]]'),
(2, 'MODULE', 'SYS_ANNOUNCEMENTS', 'ANNOUNCEMENTS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(3, 'MODULE', 'SYS_CATEGORIES', 'CATEGORIES', '5.0.3', 0, 0, 1, '[[regtime]]'),
(4, 'MODULE', 'SYS_CATEGORY_REPORT', 'CATEGORY-REPORT', '5.0.3', 0, 0, 1, '[[regtime]]'),
(5, 'MODULE', 'SYS_EVENTS', 'EVENTS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(6, 'MODULE', 'SYS_DOCUMENTS_FILES', 'DOCUMENTS-FILES', '5.0.3', 0, 0, 1, '[[regtime]]'),
(7, 'MODULE', 'SYS_INVENTORY', 'INVENTORY', '5.0.3', 0, 0, 1, '[[regtime]]'),
(8, 'MODULE', 'SYS_FORUM', 'FORUM', '5.0.3', 0, 0, 1, '[[regtime]]'),
(9, 'MODULE', 'SYS_WEBLINKS', 'LINKS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(10, 'MODULE', 'SYS_GROUPS_ROLES', 'GROUPS-ROLES', '5.0.3', 0, 0, 1, '[[regtime]]'),
(11, 'MODULE', 'SYS_CONTACTS', 'CONTACTS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(12, 'MODULE', 'SYS_MESSAGES', 'MESSAGES', '5.0.3', 0, 0, 1, '[[regtime]]'),
(13, 'MODULE', 'SYS_MENU', 'MENU', '5.0.3', 0, 0, 1, '[[regtime]]'),
(14, 'MODULE', 'SYS_ORGANIZATION', 'ORGANIZATIONS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(15, 'MODULE', 'SYS_PHOTOS', 'PHOTOS', '5.0.3', 0, 0, 1, '[[regtime]]'),
(16, 'MODULE', 'SYS_SETTINGS', 'PREFERENCES', '5.0.3', 0, 0, 1, '[[regtime]]'),
(17, 'MODULE', 'SYS_PROFILE', 'PROFILE', '5.0.3', 0, 0, 1, '[[regtime]]'),
(18, 'MODULE', 'SYS_REGISTRATION', 'REGISTRATION', '5.0.3', 0, 0, 1, '[[regtime]]'),
(19, 'MODULE', 'SYS_ROOM_MANAGEMENT', 'ROOMS', '5.0.3', 0, 0, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_events`
--

CREATE TABLE `[[dbprefix]]_events` (
  `dat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dat_cat_id` int(10) unsigned NOT NULL,
  `dat_rol_id` int(10) unsigned DEFAULT NULL,
  `dat_room_id` int(10) unsigned DEFAULT NULL,
  `dat_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `dat_begin` timestamp NULL DEFAULT NULL,
  `dat_end` timestamp NULL DEFAULT NULL,
  `dat_all_day` tinyint(1) NOT NULL DEFAULT '0',
  `dat_headline` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `dat_description` text COLLATE utf8_unicode_ci,
  `dat_highlight` tinyint(1) NOT NULL DEFAULT '0',
  `dat_location` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dat_country` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dat_deadline` timestamp NULL DEFAULT NULL,
  `dat_max_members` int(11) NOT NULL DEFAULT '0',
  `dat_usr_id_create` int(10) unsigned DEFAULT NULL,
  `dat_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `dat_usr_id_change` int(10) unsigned DEFAULT NULL,
  `dat_timestamp_change` timestamp NULL DEFAULT NULL,
  `dat_allow_comments` tinyint(1) NOT NULL DEFAULT '0',
  `dat_additional_guests` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dat_id`),
  UNIQUE KEY `[[dbprefix]]_idx_dat_uuid` (`dat_uuid`),
  KEY `[[dbprefix]]_fk_dat_cat` (`dat_cat_id`),
  KEY `[[dbprefix]]_fk_dat_rol` (`dat_rol_id`),
  KEY `[[dbprefix]]_fk_dat_room` (`dat_room_id`),
  KEY `[[dbprefix]]_fk_dat_usr_create` (`dat_usr_id_create`),
  KEY `[[dbprefix]]_fk_dat_usr_change` (`dat_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_files`
--

CREATE TABLE `[[dbprefix]]_files` (
  `fil_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fil_fol_id` int(10) unsigned NOT NULL,
  `fil_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fil_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fil_description` text COLLATE utf8_unicode_ci,
  `fil_locked` tinyint(1) NOT NULL DEFAULT '0',
  `fil_counter` int(11) DEFAULT NULL,
  `fil_usr_id` int(10) unsigned DEFAULT NULL,
  `fil_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`fil_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fil_uuid` (`fil_uuid`),
  KEY `[[dbprefix]]_fk_fil_fol` (`fil_fol_id`),
  KEY `[[dbprefix]]_fk_fil_usr` (`fil_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_folders`
--

CREATE TABLE `[[dbprefix]]_folders` (
  `fol_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fol_org_id` int(10) unsigned NOT NULL,
  `fol_fol_id_parent` int(10) unsigned DEFAULT NULL,
  `fol_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fol_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `fol_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fol_description` text COLLATE utf8_unicode_ci,
  `fol_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fol_locked` tinyint(1) NOT NULL DEFAULT '0',
  `fol_public` tinyint(1) NOT NULL DEFAULT '0',
  `fol_usr_id` int(10) unsigned DEFAULT NULL,
  `fol_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`fol_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fol_uuid` (`fol_uuid`),
  KEY `[[dbprefix]]_fk_fol_org` (`fol_org_id`),
  KEY `[[dbprefix]]_fk_fol_fol_parent` (`fol_fol_id_parent`),
  KEY `[[dbprefix]]_fk_fol_usr` (`fol_usr_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_folders`
--

INSERT INTO `[[dbprefix]]_folders` VALUES
(1, 1, NULL, '3bfbe34f-9691-46de-840a-90929a4d04f4', 'DOCUMENTS', 'documents_[[lower_short_site_name]]', NULL, '/adm_my_files', 0, 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_forum_posts`
--

CREATE TABLE `[[dbprefix]]_forum_posts` (
  `fop_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fop_fot_id` int(10) unsigned NOT NULL,
  `fop_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fop_text` text COLLATE utf8_unicode_ci NOT NULL,
  `fop_usr_id_create` int(10) unsigned DEFAULT NULL,
  `fop_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `fop_usr_id_change` int(10) unsigned DEFAULT NULL,
  `fop_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`fop_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fop_uuid` (`fop_uuid`),
  KEY `[[dbprefix]]_fk_fop_fot` (`fop_fot_id`),
  KEY `[[dbprefix]]_fk_fop_usr_create` (`fop_usr_id_create`),
  KEY `[[dbprefix]]_fk_fop_usr_change` (`fop_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_forum_topics`
--

CREATE TABLE `[[dbprefix]]_forum_topics` (
  `fot_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fot_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `fot_cat_id` int(10) unsigned NOT NULL,
  `fot_fop_id_first_post` int(10) unsigned DEFAULT NULL,
  `fot_title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `fot_views` int(10) unsigned NOT NULL DEFAULT '0',
  `fot_usr_id_create` int(10) unsigned DEFAULT NULL,
  `fot_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`fot_id`),
  UNIQUE KEY `[[dbprefix]]_idx_fot_uuid` (`fot_uuid`),
  KEY `[[dbprefix]]_fk_fot_cat` (`fot_cat_id`),
  KEY `[[dbprefix]]_fk_fot_first_fop` (`fot_fop_id_first_post`),
  KEY `[[dbprefix]]_fk_fot_usr_create` (`fot_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ids`
--

CREATE TABLE `[[dbprefix]]_ids` (
  `ids_usr_id` int(10) unsigned NOT NULL,
  `ids_reference_id` int(10) unsigned NOT NULL,
  KEY `[[dbprefix]]_fk_ids_usr_id` (`ids_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_inventory_fields`
--

CREATE TABLE `[[dbprefix]]_inventory_fields` (
  `inf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `inf_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `inf_org_id` int(10) unsigned NOT NULL,
  `inf_type` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `inf_name_intern` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `inf_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `inf_description` text COLLATE utf8_unicode_ci,
  `inf_system` tinyint(1) NOT NULL DEFAULT '0',
  `inf_required_input` smallint(6) NOT NULL DEFAULT '0',
  `inf_sequence` smallint(6) NOT NULL,
  `inf_inf_uuid_connected` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inf_usr_id_create` int(10) unsigned DEFAULT NULL,
  `inf_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `inf_usr_id_change` int(10) unsigned DEFAULT NULL,
  `inf_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`inf_id`),
  UNIQUE KEY `[[dbprefix]]_idx_inf_name_intern` (`inf_org_id`,`inf_name_intern`),
  UNIQUE KEY `[[dbprefix]]_idx_inf_uuid` (`inf_uuid`),
  KEY `[[dbprefix]]_fk_inf_usr_create` (`inf_usr_id_create`),
  KEY `[[dbprefix]]_fk_inf_usr_change` (`inf_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]_inventory_fields`
--

INSERT INTO `[[dbprefix]]_inventory_fields` VALUES
(1, 'c928dd4c-cbf9-40e2-8517-633d39e6fa0c', 1, 'TEXT', 'ITEMNAME', 'SYS_INVENTORY_ITEMNAME', 'SYS_INVENTORY_ITEMNAME_DESC', 1, 1, 0, NULL, 1, '[[regtime]]', NULL, NULL),
(2, 'a8858acd-3075-499a-ab62-0e83a752a034', 1, 'CATEGORY', 'CATEGORY', 'SYS_CATEGORY', 'SYS_INVENTORY_CATEGORY_DESC', 1, 1, 1, NULL, 1, '[[regtime]]', NULL, NULL),
(3, '918a4905-2300-4e67-a495-0e87876bec34', 1, 'DROPDOWN', 'STATUS', 'SYS_INVENTORY_STATUS', 'SYS_INVENTORY_STATUS_DESC', 1, 1, 2, NULL, 1, '[[regtime]]', NULL, NULL),
(4, '1212afe7-672d-451f-9269-dbecfabf320b', 1, 'TEXT', 'KEEPER', 'SYS_INVENTORY_KEEPER', 'SYS_INVENTORY_KEEPER_DESC', 1, 0, 3, NULL, 1, '[[regtime]]', NULL, NULL),
(5, 'f0cfcbe5-e18c-40df-92a6-6433fbaaf3c8', 1, 'TEXT', 'LAST_RECEIVER', 'SYS_INVENTORY_LAST_RECEIVER', 'SYS_INVENTORY_LAST_RECEIVER_DESC', 1, 0, 4, NULL, 1, '[[regtime]]', NULL, NULL),
(6, 'cc3b6e22-b57f-478b-bd89-109ff6c041f1', 1, 'DATE', 'BORROW_DATE', 'SYS_INVENTORY_BORROW_DATE', 'SYS_INVENTORY_BORROW_DATE_DESC', 1, 0, 5, NULL, 1, '[[regtime]]', NULL, NULL),
(7, 'b271ecfc-8511-4982-9331-eb0cc0abe944', 1, 'DATE', 'RETURN_DATE', 'SYS_INVENTORY_RETURN_DATE', 'SYS_INVENTORY_RETURN_DATE_DESC', 1, 0, 6, NULL, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_inventory_field_select_options`
--

CREATE TABLE `[[dbprefix]]_inventory_field_select_options` (
  `ifo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ifo_inf_id` int(10) unsigned NOT NULL,
  `ifo_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ifo_system` tinyint(1) NOT NULL DEFAULT '0',
  `ifo_sequence` smallint(6) NOT NULL,
  `ifo_obsolete` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ifo_id`),
  KEY `[[dbprefix]]_fk_ifo_inf` (`ifo_inf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_inventory_field_select_options`
--

INSERT INTO `[[dbprefix]]_inventory_field_select_options` VALUES
(1, 3, 'SYS_INVENTORY_FILTER_IN_USE_ITEMS', 1, 1, 0),
(2, 3, 'SYS_INVENTORY_FILTER_RETIRED_ITEMS', 1, 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_inventory_items`
--

CREATE TABLE `[[dbprefix]]_inventory_items` (
  `ini_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ini_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `ini_cat_id` int(10) unsigned NOT NULL,
  `ini_org_id` int(10) unsigned NOT NULL,
  `ini_status` int(10) unsigned NOT NULL,
  `ini_picture` blob,
  `ini_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ini_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ini_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ini_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ini_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ini_uuid` (`ini_uuid`),
  KEY `[[dbprefix]]_fk_ini_cat` (`ini_cat_id`),
  KEY `[[dbprefix]]_fk_ini_status` (`ini_status`),
  KEY `[[dbprefix]]_fk_ini_usr_create` (`ini_usr_id_create`),
  KEY `[[dbprefix]]_fk_ini_usr_change` (`ini_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_inventory_item_borrow_data`
--

CREATE TABLE `[[dbprefix]]_inventory_item_borrow_data` (
  `inb_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `inb_ini_id` int(10) unsigned NOT NULL,
  `inb_last_receiver` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inb_borrow_date` timestamp NULL DEFAULT NULL,
  `inb_return_date` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`inb_id`),
  UNIQUE KEY `[[dbprefix]]_idx_inb_ini_id` (`inb_ini_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_inventory_item_data`
--

CREATE TABLE `[[dbprefix]]_inventory_item_data` (
  `ind_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ind_inf_id` int(10) unsigned NOT NULL,
  `ind_ini_id` int(10) unsigned NOT NULL,
  `ind_value` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ind_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ind_inf_ini_id` (`ind_inf_id`,`ind_ini_id`),
  KEY `[[dbprefix]]_fk_ind_ini` (`ind_ini_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_links`
--

CREATE TABLE `[[dbprefix]]_links` (
  `lnk_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lnk_cat_id` int(10) unsigned NOT NULL,
  `lnk_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_description` text COLLATE utf8_unicode_ci,
  `lnk_url` varchar(2000) COLLATE utf8_unicode_ci NOT NULL,
  `lnk_counter` int(11) NOT NULL DEFAULT '0',
  `lnk_sequence` smallint(6) NOT NULL,
  `lnk_usr_id_create` int(10) unsigned DEFAULT NULL,
  `lnk_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lnk_usr_id_change` int(10) unsigned DEFAULT NULL,
  `lnk_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`lnk_id`),
  UNIQUE KEY `[[dbprefix]]_idx_lnk_uuid` (`lnk_uuid`),
  KEY `[[dbprefix]]_fk_lnk_cat` (`lnk_cat_id`),
  KEY `[[dbprefix]]_fk_lnk_usr_create` (`lnk_usr_id_create`),
  KEY `[[dbprefix]]_fk_lnk_usr_change` (`lnk_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_lists`
--

CREATE TABLE `[[dbprefix]]_lists` (
  `lst_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lst_org_id` int(10) unsigned NOT NULL,
  `lst_usr_id` int(10) unsigned NOT NULL,
  `lst_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `lst_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lst_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lst_global` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lst_id`),
  UNIQUE KEY `[[dbprefix]]_idx_lst_uuid` (`lst_uuid`),
  KEY `[[dbprefix]]_fk_lst_usr` (`lst_usr_id`),
  KEY `[[dbprefix]]_fk_lst_org` (`lst_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]_lists`
--

INSERT INTO `[[dbprefix]]_lists` VALUES
(1, 1, 1, 'abba714c-7df0-4e81-85be-4c1e7a76070a', 'Address list', '[[regtime]]', 1),
(2, 1, 1, '600689dc-c999-4e7b-b55d-b8cf2629fb4f', 'Phone list', '[[regtime]]', 1),
(3, 1, 1, '0776eed7-ddf2-4b12-968d-aa1745cab1d0', 'Contact information', '[[regtime]]', 1),
(4, 1, 1, '39431828-9ba9-4f71-925a-09d1689b9a31', 'Membership', '[[regtime]]', 1),
(5, 1, 1, '4ba6412d-877c-43ff-b824-b80b5b7f1402', 'Members', '[[regtime]]', 1),
(6, 1, 1, 'da09f180-edba-4e75-96d0-2ebbd7950a08', 'Contacts', '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_list_columns`
--

CREATE TABLE `[[dbprefix]]_list_columns` (
  `lsc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lsc_lst_id` int(10) unsigned NOT NULL,
  `lsc_number` smallint(6) NOT NULL,
  `lsc_usf_id` int(10) unsigned DEFAULT NULL,
  `lsc_special_field` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lsc_sort` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lsc_filter` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lsc_id`),
  KEY `[[dbprefix]]_fk_lsc_lst` (`lsc_lst_id`),
  KEY `[[dbprefix]]_fk_lsc_usf` (`lsc_usf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=38 ;

--
-- Dumping data for table `[[dbprefix]]_list_columns`
--

INSERT INTO `[[dbprefix]]_list_columns` VALUES
(1, 1, 1, 1, NULL, 'ASC', NULL),
(2, 1, 2, 2, NULL, 'ASC', NULL),
(3, 1, 3, 9, NULL, NULL, NULL),
(4, 1, 4, 3, NULL, NULL, NULL),
(5, 1, 5, 4, NULL, NULL, NULL),
(6, 1, 6, 5, NULL, NULL, NULL),
(7, 2, 1, 1, NULL, 'ASC', NULL),
(8, 2, 2, 2, NULL, 'ASC', NULL),
(9, 2, 3, 7, NULL, NULL, NULL),
(10, 2, 4, 8, NULL, NULL, NULL),
(11, 2, 5, 11, NULL, NULL, NULL),
(12, 3, 1, 1, NULL, 'ASC', NULL),
(13, 3, 2, 2, NULL, 'ASC', NULL),
(14, 3, 3, 9, NULL, NULL, NULL),
(15, 3, 4, 3, NULL, NULL, NULL),
(16, 3, 5, 4, NULL, NULL, NULL),
(17, 3, 6, 5, NULL, NULL, NULL),
(18, 3, 7, 7, NULL, NULL, NULL),
(19, 3, 8, 8, NULL, NULL, NULL),
(20, 3, 9, 11, NULL, NULL, NULL),
(21, 4, 1, 1, NULL, 'ASC', NULL),
(22, 4, 2, 2, NULL, 'ASC', NULL),
(23, 4, 3, 9, NULL, NULL, NULL),
(24, 4, 4, NULL, 'mem_begin', NULL, NULL),
(25, 4, 5, NULL, 'mem_end', NULL, NULL),
(26, 5, 1, 1, NULL, 'ASC', NULL),
(27, 5, 2, 2, NULL, 'ASC', NULL),
(28, 5, 3, NULL, 'mem_approved', NULL, NULL),
(29, 5, 4, NULL, 'mem_comment', NULL, NULL),
(30, 5, 5, NULL, 'mem_count_guests', NULL, NULL),
(31, 6, 1, 1, NULL, 'ASC', NULL),
(32, 6, 2, 2, NULL, 'ASC', NULL),
(33, 6, 3, NULL, 'usr_login_name', NULL, NULL),
(34, 6, 4, 10, NULL, NULL, NULL),
(35, 6, 5, 9, NULL, NULL, NULL),
(36, 6, 6, 5, NULL, NULL, NULL),
(37, 6, 7, NULL, 'usr_timestamp_change', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_log_changes`
--

CREATE TABLE `[[dbprefix]]_log_changes` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `log_table` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `log_record_id` int(10) unsigned NOT NULL,
  `log_record_uuid` varchar(36) COLLATE utf8_unicode_ci DEFAULT NULL,
  `log_record_name` text COLLATE utf8_unicode_ci,
  `log_record_linkid` text COLLATE utf8_unicode_ci,
  `log_related_id` text COLLATE utf8_unicode_ci,
  `log_related_name` text COLLATE utf8_unicode_ci,
  `log_field` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `log_field_name` text COLLATE utf8_unicode_ci,
  `log_action` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `log_value_old` text COLLATE utf8_unicode_ci,
  `log_value_new` text COLLATE utf8_unicode_ci,
  `log_usr_id_create` int(10) unsigned DEFAULT NULL,
  `log_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `log_comment` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`log_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- Table structure for table `[[dbprefix]]_members`
--

CREATE TABLE `[[dbprefix]]_members` (
  `mem_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mem_rol_id` int(10) unsigned NOT NULL,
  `mem_usr_id` int(10) unsigned NOT NULL,
  `mem_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `mem_begin` date NOT NULL,
  `mem_end` date NOT NULL DEFAULT '9999-12-31',
  `mem_leader` tinyint(1) NOT NULL DEFAULT '0',
  `mem_usr_id_create` int(10) unsigned DEFAULT NULL,
  `mem_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `mem_usr_id_change` int(10) unsigned DEFAULT NULL,
  `mem_timestamp_change` timestamp NULL DEFAULT NULL,
  `mem_approved` int(10) unsigned DEFAULT NULL,
  `mem_comment` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mem_count_guests` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mem_id`),
  UNIQUE KEY `[[dbprefix]]_idx_mem_uuid` (`mem_uuid`),
  KEY `[[dbprefix]]_idx_mem_rol_usr_id` (`mem_rol_id`,`mem_usr_id`),
  KEY `[[dbprefix]]_fk_mem_usr` (`mem_usr_id`),
  KEY `[[dbprefix]]_fk_mem_usr_create` (`mem_usr_id_create`),
  KEY `[[dbprefix]]_fk_mem_usr_change` (`mem_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_members`
--

INSERT INTO `[[dbprefix]]_members` VALUES
(1, 1, 2, 'f2a2f19f-ceba-4397-99d2-d2b6f5533c86', '[[date]]', '9999-12-31', 0, 1, '[[regtime]]', NULL, NULL, NULL, NULL, 0),
(2, 2, 2, 'd9b438d7-b95a-4bfc-b030-e026718e6d4c', '[[date]]', '9999-12-31', 0, 1, '[[regtime]]', NULL, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_menu`
--

CREATE TABLE `[[dbprefix]]_menu` (
  `men_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `men_men_id_parent` int(10) unsigned DEFAULT NULL,
  `men_com_id` int(10) unsigned DEFAULT NULL,
  `men_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `men_name_intern` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_node` tinyint(1) NOT NULL DEFAULT '0',
  `men_order` int(10) unsigned DEFAULT NULL,
  `men_standard` tinyint(1) NOT NULL DEFAULT '0',
  `men_url` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `men_icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`men_id`),
  UNIQUE KEY `[[dbprefix]]_idx_men_uuid` (`men_uuid`),
  KEY `[[dbprefix]]_idx_men_men_id_parent` (`men_men_id_parent`),
  KEY `[[dbprefix]]_fk_men_com_id` (`men_com_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]_menu`
--

INSERT INTO `[[dbprefix]]_menu` VALUES
(1, NULL, NULL, '8cd84590-da21-404b-a4d7-0fd9eb5b3643', 'modules', 'SYS_MODULES', '', 1, 1, 1, NULL, ''),
(2, NULL, NULL, '651a012b-8f48-4651-a756-2cb8caf1430b', 'administration', 'SYS_ADMINISTRATION', '', 1, 2, 1, NULL, ''),
(3, NULL, NULL, '24c71611-3581-4cbb-a10d-b3f9d87f4f73', 'extensions', 'SYS_EXTENSIONS', '', 1, 3, 1, NULL, ''),
(4, 1, NULL, '7ed4820e-42a4-4302-b0c6-40b8db95c5df', 'overview', 'SYS_OVERVIEW', '', 0, 1, 1, '/modules/overview.php', 'bi-house-door-fill'),
(5, 1, 2, '6a6f0804-7208-481b-ba41-16b68ab1e52e', 'announcements', 'SYS_ANNOUNCEMENTS', 'SYS_ANNOUNCEMENTS_DESC', 0, 2, 1, '/modules/announcements.php', 'newspaper'),
(6, 1, 5, '8fe125eb-330a-45b9-835f-6d47dfddd66f', 'events', 'SYS_EVENTS', 'SYS_EVENTS_DESC', 0, 3, 1, '/modules/events/events.php', 'calendar-week-fill'),
(7, 1, 12, 'cad30615-f56a-4d98-a135-0af3fd31f609', 'messages', 'SYS_MESSAGES', 'SYS_MESSAGES_DESC', 0, 4, 1, '/modules/messages/messages.php', 'envelope-fill'),
(8, 1, 10, 'a6ec8dc0-a9a8-4ed7-a2c1-d255de16069c', 'groups-roles', 'SYS_GROUPS_ROLES', 'SYS_GROUPS_ROLES_DESC', 0, 5, 1, '/modules/groups-roles/groups_roles.php', 'people-fill'),
(9, 1, 11, '7b6a1b23-586a-408e-afa0-434291234ad7', 'contacts', 'SYS_CONTACTS', 'SYS_CONTACTS_DESC', 0, 6, 1, '/modules/contacts/contacts.php', 'person-vcard-fill'),
(10, 1, 6, '5bdd8f11-9a6f-4cef-b962-ac4b60d61e43', 'documents-files', 'SYS_DOCUMENTS_FILES', 'SYS_DOCUMENTS_FILES_DESC', 0, 7, 1, '/modules/documents-files.php', 'file-earmark-arrow-down-fill'),
(11, 1, 7, '4a2ff59d-d16c-44c7-a10a-ff7d70b29a73', 'inventory', 'SYS_INVENTORY', 'SYS_INVENTORY_DESC', 0, 8, 1, '/modules/inventory.php', 'box-seam-fill'),
(12, 1, 15, '5a14d1b4-ae29-4526-aba7-dbfe772dd138', 'photo', 'SYS_PHOTOS', 'SYS_PHOTOS_DESC', 0, 9, 1, '/modules/photos/photos.php', 'image-fill'),
(13, 1, 4, 'fd5f222b-24c4-419a-87ab-bf5e2f677401', 'category-report', 'SYS_CATEGORY_REPORT', 'SYS_CATEGORY_REPORT_DESC', 0, 10, 1, '/modules/category-report/category_report.php', 'list-stars'),
(14, 1, 9, '63d82447-e61e-40d3-a00e-052d9d797cca', 'weblinks', 'SYS_WEBLINKS', 'SYS_WEBLINKS_DESC', 0, 11, 1, '/modules/links/links.php', 'link-45deg'),
(15, 1, 8, '137708c2-2de0-4840-9051-2d29693147ce', 'forum', 'SYS_FORUM', 'SYS_FORUM_DESC', 0, 12, 1, '/modules/forum.php', 'chat-dots-fill'),
(16, 2, 16, '7cc0b1c9-9994-485a-a8d1-6ac92f4b4965', 'orgprop', 'SYS_SETTINGS', 'ORG_ORGANIZATION_PROPERTIES_DESC', 0, 1, 1, '/modules/preferences.php', 'gear-fill'),
(17, 2, 18, '4876e7e4-1f50-43f3-8aa5-e90ca1c07384', 'registration', 'SYS_REGISTRATIONS', 'SYS_MANAGE_NEW_REGISTRATIONS_DESC', 0, 2, 1, '/modules/registration.php', 'card-checklist'),
(18, 2, 13, '7e7887ad-3f95-490b-8427-1c481a19edc8', 'menu', 'SYS_MENU', 'SYS_MENU_DESC', 0, 3, 1, '/modules/menu.php', 'menu-button-wide-fill'),
(19, 2, 14, '72a918ae-3752-4bf2-bcf7-e474daba174d', 'organization', 'SYS_ORGANIZATION', 'SYS_ORGANIZATION_DESC', 0, 4, 1, '/modules/organizations.php', 'diagram-3-fill');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages`
--

CREATE TABLE `[[dbprefix]]_messages` (
  `msg_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msg_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `msg_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `msg_subject` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `msg_usr_id_sender` int(10) unsigned NOT NULL,
  `msg_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `msg_read` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  UNIQUE KEY `[[dbprefix]]_idx_msg_uuid` (`msg_uuid`),
  KEY `[[dbprefix]]_fk_msg_usr_sender` (`msg_usr_id_sender`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_attachments`
--

CREATE TABLE `[[dbprefix]]_messages_attachments` (
  `msa_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msa_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `msa_msg_id` int(10) unsigned NOT NULL,
  `msa_file_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `msa_original_file_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`msa_id`),
  UNIQUE KEY `[[dbprefix]]_idx_msa_uuid` (`msa_uuid`),
  KEY `[[dbprefix]]_fk_msa_msg_id` (`msa_msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_content`
--

CREATE TABLE `[[dbprefix]]_messages_content` (
  `msc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msc_msg_id` int(10) unsigned NOT NULL,
  `msc_usr_id` int(10) unsigned DEFAULT NULL,
  `msc_message` text COLLATE utf8_unicode_ci NOT NULL,
  `msc_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`msc_id`),
  KEY `[[dbprefix]]_fk_msc_msg_id` (`msc_msg_id`),
  KEY `[[dbprefix]]_fk_msc_usr_id` (`msc_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages_recipients`
--

CREATE TABLE `[[dbprefix]]_messages_recipients` (
  `msr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `msr_msg_id` int(10) unsigned NOT NULL,
  `msr_rol_id` int(10) unsigned DEFAULT NULL,
  `msr_usr_id` int(10) unsigned DEFAULT NULL,
  `msr_role_mode` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`msr_id`),
  KEY `[[dbprefix]]_fk_msr_msg_id` (`msr_msg_id`),
  KEY `[[dbprefix]]_fk_msr_rol_id` (`msr_rol_id`),
  KEY `[[dbprefix]]_fk_msr_usr_id` (`msr_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_oidc_access_tokens`
--

CREATE TABLE `[[dbprefix]]_oidc_access_tokens` (
  `oat_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `oat_usr_id` int(10) unsigned NOT NULL,
  `oat_ocl_id` int(10) unsigned NOT NULL,
  `oat_token` text COLLATE utf8_unicode_ci,
  `oat_scope` text COLLATE utf8_unicode_ci,
  `oat_expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `oat_revoked` tinyint(1) DEFAULT '0',
  `oat_usr_id_create` int(10) unsigned DEFAULT NULL,
  `oat_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`oat_id`),
  KEY `[[dbprefix]]_fk_oat_usr_id` (`oat_usr_id`),
  KEY `[[dbprefix]]_fk_oat_ocl_id` (`oat_ocl_id`),
  KEY `[[dbprefix]]_fk_oat_usr_create` (`oat_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_oidc_auth_codes`
--

CREATE TABLE `[[dbprefix]]_oidc_auth_codes` (
  `oac_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `oac_usr_id` int(10) unsigned NOT NULL,
  `oac_ocl_id` int(10) unsigned NOT NULL,
  `oac_token` text COLLATE utf8_unicode_ci,
  `oac_scope` text COLLATE utf8_unicode_ci,
  `oac_nonce` varchar(2550) COLLATE utf8_unicode_ci DEFAULT NULL,
  `oac_expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `oac_revoked` tinyint(1) DEFAULT '0',
  `oac_redirect_uri` text COLLATE utf8_unicode_ci NOT NULL,
  `oac_used` tinyint(1) DEFAULT '0',
  `oac_usr_id_create` int(10) unsigned DEFAULT NULL,
  `oac_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`oac_id`),
  KEY `[[dbprefix]]_fk_oac_usr_id` (`oac_usr_id`),
  KEY `[[dbprefix]]_fk_oac_ocl_id` (`oac_ocl_id`),
  KEY `[[dbprefix]]_fk_oac_usr_create` (`oac_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_oidc_clients`
--

CREATE TABLE `[[dbprefix]]_oidc_clients` (
  `ocl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ocl_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `ocl_client_id` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `ocl_client_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ocl_enabled` tinyint(1) DEFAULT '1',
  `ocl_client_secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ocl_redirect_uri` text COLLATE utf8_unicode_ci NOT NULL,
  `ocl_grant_types` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ocl_scope` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ocl_userid_field` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'usr_id',
  `ocl_field_mapping` text COLLATE utf8_unicode_ci,
  `ocl_role_mapping` text COLLATE utf8_unicode_ci,
  `ocl_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ocl_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ocl_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ocl_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ocl_id`),
  KEY `[[dbprefix]]_fk_ocl_usr_create` (`ocl_usr_id_create`),
  KEY `[[dbprefix]]_fk_ocl_usr_change` (`ocl_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_oidc_refresh_tokens`
--

CREATE TABLE `[[dbprefix]]_oidc_refresh_tokens` (
  `ort_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ort_ocl_id` int(10) unsigned NOT NULL,
  `ort_usr_id` int(10) unsigned DEFAULT NULL,
  `ort_token` text COLLATE utf8_unicode_ci,
  `ort_scope` text COLLATE utf8_unicode_ci,
  `ort_expires_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ort_revoked` tinyint(1) DEFAULT '0',
  `ort_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ort_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ort_id`),
  KEY `[[dbprefix]]_fk_ort_usr_id` (`ort_usr_id`),
  KEY `[[dbprefix]]_fk_ort_ocl_id` (`ort_ocl_id`),
  KEY `[[dbprefix]]_fk_ort_usr_create` (`ort_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_organizations`
--

CREATE TABLE `[[dbprefix]]_organizations` (
  `org_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `org_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `org_shortname` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `org_longname` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `org_org_id_parent` int(10) unsigned DEFAULT NULL,
  `org_homepage` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `org_email_administrator` varchar(254) COLLATE utf8_unicode_ci NOT NULL,
  `org_show_org_select` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`org_id`),
  UNIQUE KEY `[[dbprefix]]_idx_org_shortname` (`org_shortname`),
  UNIQUE KEY `[[dbprefix]]_idx_org_uuid` (`org_uuid`),
  KEY `[[dbprefix]]_fk_org_org_parent` (`org_org_id_parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_organizations`
--

INSERT INTO `[[dbprefix]]_organizations` VALUES
(1, '46b938b9-3db5-40de-ad31-03546dc2b8a5', '[[short_site_name]]', '[[site_name]]', NULL, '[[softurl]]', '[[site_email]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_photos`
--

CREATE TABLE `[[dbprefix]]_photos` (
  `pho_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pho_org_id` int(10) unsigned NOT NULL,
  `pho_pho_id_parent` int(10) unsigned DEFAULT NULL,
  `pho_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `pho_quantity` int(10) unsigned NOT NULL DEFAULT '0',
  `pho_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `pho_begin` date NOT NULL,
  `pho_end` date NOT NULL,
  `pho_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pho_photographers` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pho_locked` tinyint(1) NOT NULL DEFAULT '0',
  `pho_usr_id_create` int(10) unsigned DEFAULT NULL,
  `pho_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pho_usr_id_change` int(10) unsigned DEFAULT NULL,
  `pho_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`pho_id`),
  UNIQUE KEY `[[dbprefix]]_idx_pho_uuid` (`pho_uuid`),
  KEY `[[dbprefix]]_fk_pho_pho_parent` (`pho_pho_id_parent`),
  KEY `[[dbprefix]]_fk_pho_org` (`pho_org_id`),
  KEY `[[dbprefix]]_fk_pho_usr_create` (`pho_usr_id_create`),
  KEY `[[dbprefix]]_fk_pho_usr_change` (`pho_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_preferences`
--

CREATE TABLE `[[dbprefix]]_preferences` (
  `prf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prf_org_id` int(10) unsigned NOT NULL,
  `prf_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `prf_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`prf_id`),
  UNIQUE KEY `[[dbprefix]]_idx_prf_org_id_name` (`prf_org_id`,`prf_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=203 ;

--
-- Dumping data for table `[[dbprefix]]_preferences`
--

INSERT INTO `[[dbprefix]]_preferences` VALUES
(1, 1, 'enable_rss', '1'),
(2, 1, 'enable_auto_login', '1'),
(3, 1, 'security_login_email_address_enabled', '0'),
(4, 1, 'default_country', 'DEU'),
(5, 1, 'logout_minutes', '20'),
(6, 1, 'homepage_logout', 'modules/overview.php'),
(7, 1, 'homepage_login', 'modules/overview.php'),
(8, 1, 'enable_password_recovery', '1'),
(9, 1, 'two_factor_authentication_enabled', '0'),
(10, 1, 'system_browser_update_check', '0'),
(11, 1, 'system_cookie_note', '1'),
(12, 1, 'system_currency', '€'),
(13, 1, 'system_date', 'd.m.Y'),
(14, 1, 'system_hashing_cost', '12'),
(15, 1, 'system_js_editor_enabled', '1'),
(16, 1, 'system_language', 'en'),
(17, 1, 'system_search_similar', '1'),
(18, 1, 'system_show_create_edit', '1'),
(19, 1, 'system_time', 'H:i'),
(20, 1, 'system_url_imprint', ''),
(21, 1, 'system_url_data_protection', ''),
(22, 1, 'password_min_strength', '1'),
(23, 1, 'theme', 'simple'),
(24, 1, 'theme_fallback', 'simple'),
(25, 1, 'color_primary', '#349aaa'),
(26, 1, 'color_secondary', '#263340'),
(27, 1, 'logo_file', ''),
(28, 1, 'logo_file_max_height', '60'),
(29, 1, 'admidio_headline', 'SYS_ONLINE_MEMBERSHIP_ADMINISTRATION'),
(30, 1, 'favicon_file', ''),
(31, 1, 'additional_styles_file', ''),
(32, 1, 'registration_adopt_all_data', '1'),
(33, 1, 'registration_enable_captcha', '1'),
(34, 1, 'registration_module_enabled', '1'),
(35, 1, 'registration_manual_approval', '1'),
(36, 1, 'registration_send_notification_email', '1'),
(37, 1, 'changelog_module_enabled', '1'),
(38, 1, 'changelog_table_user_data', '1'),
(39, 1, 'changelog_table_users', '1'),
(40, 1, 'changelog_table_members', '1'),
(41, 1, 'changelog_table_user_fields', '0'),
(42, 1, 'changelog_table_user_field_select_options', '0'),
(43, 1, 'changelog_table_announcements', '0'),
(44, 1, 'changelog_table_events', '0'),
(45, 1, 'changelog_table_rooms', '0'),
(46, 1, 'changelog_table_roles', '0'),
(47, 1, 'changelog_table_role_dependencies', '0'),
(48, 1, 'changelog_table_roles_rights', '0'),
(49, 1, 'changelog_table_roles_rights_data', '0'),
(50, 1, 'changelog_table_categories', '0'),
(51, 1, 'changelog_table_category_report', '0'),
(52, 1, 'changelog_table_links', '0'),
(53, 1, 'changelog_table_folders', '0'),
(54, 1, 'changelog_table_files', '0'),
(55, 1, 'changelog_table_organizations', '0'),
(56, 1, 'changelog_table_menu', '0'),
(57, 1, 'changelog_table_user_relation_types', '0'),
(58, 1, 'changelog_table_user_relations', '1'),
(59, 1, 'changelog_table_photos', '0'),
(60, 1, 'changelog_table_lists', '0'),
(61, 1, 'changelog_table_list_columns', '0'),
(62, 1, 'changelog_table_preferences', '0'),
(63, 1, 'changelog_table_texts', '0'),
(64, 1, 'changelog_table_forum_topics', '0'),
(65, 1, 'changelog_table_forum_posts', '0'),
(66, 1, 'changelog_table_inventory_fields', '0'),
(67, 1, 'changelog_table_inventory_field_select_options', '0'),
(68, 1, 'changelog_table_inventory_items', '0'),
(69, 1, 'changelog_table_inventory_item_data', '0'),
(70, 1, 'changelog_table_inventory_item_borrow_data', '0'),
(71, 1, 'changelog_table_saml_clients', '0'),
(72, 1, 'changelog_table_oidc_clients', '0'),
(73, 1, 'changelog_table_others', '0'),
(74, 1, 'mail_send_method', 'phpmail'),
(75, 1, 'mail_sending_mode', '0'),
(76, 1, 'mail_recipients_with_roles', '1'),
(77, 1, 'mail_number_recipients', '50'),
(78, 1, 'mail_into_to', '0'),
(79, 1, 'mail_character_encoding', 'utf-8'),
(80, 1, 'mail_smtp_host', ''),
(81, 1, 'mail_smtp_auth', '1'),
(82, 1, 'mail_smtp_port', '587'),
(83, 1, 'mail_smtp_secure', 'tls'),
(84, 1, 'mail_smtp_authentication_type', ''),
(85, 1, 'mail_smtp_user', ''),
(86, 1, 'mail_smtp_password', ''),
(87, 1, 'system_notifications_enabled', '1'),
(88, 1, 'system_notifications_role', '41d9f06d-a1f4-469d-8749-010ac3858052'),
(89, 1, 'system_notifications_new_entries', '0'),
(90, 1, 'system_notifications_profile_changes', '0'),
(91, 1, 'system_notifications_inventory_changes', '0'),
(92, 1, 'captcha_type', 'pic'),
(93, 1, 'captcha_fonts', 'AHGBold.ttf'),
(94, 1, 'captcha_width', '215'),
(95, 1, 'captcha_lines_numbers', '5'),
(96, 1, 'captcha_perturbation', '0.75'),
(97, 1, 'captcha_background_image', ''),
(98, 1, 'captcha_background_color', '#B6D6DB'),
(99, 1, 'captcha_text_color', '#707070'),
(100, 1, 'captcha_line_color', '#707070'),
(101, 1, 'captcha_charset', '23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxy'),
(102, 1, 'captcha_signature', 'Powered by Admidio.org'),
(103, 1, 'announcements_module_enabled', '1'),
(104, 1, 'announcements_per_page', '10'),
(105, 1, 'announcements_clamp_text_lines', '0'),
(106, 1, 'category_report_module_enabled', '1'),
(107, 1, 'category_report_default_configuration', '1'),
(108, 1, 'contacts_field_history_days', '365'),
(109, 1, 'contacts_list_configuration', '6'),
(110, 1, 'contacts_per_page', '25'),
(111, 1, 'contacts_show_all', '1'),
(112, 1, 'contacts_user_relations_enabled', '1'),
(113, 1, 'documents_files_module_enabled', '1'),
(114, 1, 'documents_files_max_upload_size', '3'),
(115, 1, 'inventory_module_enabled', '2'),
(116, 1, 'inventory_visible_for', ''),
(117, 1, 'inventory_items_per_page', '25'),
(118, 1, 'inventory_field_history_days', '365'),
(119, 1, 'inventory_item_picture_enabled', '1'),
(120, 1, 'inventory_item_picture_storage', '0'),
(121, 1, 'inventory_item_picture_width', '130'),
(122, 1, 'inventory_item_picture_height', '170'),
(123, 1, 'inventory_show_obsolete_select_field_options', '1'),
(124, 1, 'inventory_system_field_names_editable', '0'),
(125, 1, 'inventory_allow_keeper_edit', '0'),
(126, 1, 'inventory_allowed_keeper_edit_fields', 'LAST_RECEIVER,BORROW_DATE,RETURN_DATE'),
(127, 1, 'inventory_current_user_default_keeper', '0'),
(128, 1, 'inventory_allow_negative_numbers', '1'),
(129, 1, 'inventory_decimal_places', '1'),
(130, 1, 'inventory_field_date_time_format', 'date'),
(131, 1, 'inventory_items_disable_borrowing', '0'),
(132, 1, 'inventory_profile_view_enabled', '1'),
(133, 1, 'inventory_profile_view', 'LAST_RECEIVER'),
(134, 1, 'inventory_export_filename', 'SYS_INVENTORY'),
(135, 1, 'inventory_add_date', '0'),
(136, 1, 'events_list_configuration', '5'),
(137, 1, 'events_ical_export_enabled', '1'),
(138, 1, 'events_may_take_part', '0'),
(139, 1, 'events_module_enabled', '1'),
(140, 1, 'events_per_page', '10'),
(141, 1, 'events_clamp_text_lines', '0'),
(142, 1, 'events_rooms_enabled', '0'),
(143, 1, 'events_save_cancellations', '1'),
(144, 1, 'events_show_map_link', '1'),
(145, 1, 'events_view', 'detail'),
(146, 1, 'forum_module_enabled', '1'),
(147, 1, 'forum_posts_per_page', '15'),
(148, 1, 'forum_topics_per_page', '10'),
(149, 1, 'forum_view', 'cards'),
(150, 1, 'groups_roles_default_configuration', '1'),
(151, 1, 'groups_roles_module_enabled', '1'),
(152, 1, 'groups_roles_export', '1'),
(153, 1, 'groups_roles_edit_lists', '1'),
(154, 1, 'groups_roles_members_per_page', '25'),
(155, 1, 'groups_roles_show_former_members', '2'),
(156, 1, 'mail_module_enabled', '1'),
(157, 1, 'pm_module_enabled', '1'),
(158, 1, 'mail_captcha_enabled', '1'),
(159, 1, 'mail_delivery_confirmation', '0'),
(160, 1, 'mail_html_registered_users', '1'),
(161, 1, 'mail_max_receiver', '10'),
(162, 1, 'mail_save_attachments', '1'),
(163, 1, 'mail_send_to_all_addresses', '1'),
(164, 1, 'mail_sendmail_address', ''),
(165, 1, 'mail_sendmail_name', ''),
(166, 1, 'mail_show_former', '1'),
(167, 1, 'mail_template', 'default.html'),
(168, 1, 'max_email_attachment_size', '1'),
(169, 1, 'photo_albums_per_page', '24'),
(170, 1, 'photo_download_enabled', '0'),
(171, 1, 'photo_ecard_enabled', '1'),
(172, 1, 'photo_ecard_scale', '500'),
(173, 1, 'photo_ecard_template', 'postcard.tpl'),
(174, 1, 'photo_image_text', '© [[domhost]]'),
(175, 1, 'photo_image_text_size', '40'),
(176, 1, 'photo_keep_original', '0'),
(177, 1, 'photo_module_enabled', '1'),
(178, 1, 'photo_show_width', '1200'),
(179, 1, 'photo_show_height', '1200'),
(180, 1, 'photo_show_mode', '1'),
(181, 1, 'photo_thumbs_page', '24'),
(182, 1, 'photo_thumbs_scale', '500'),
(183, 1, 'profile_show_obsolete_select_field_options', '1'),
(184, 1, 'profile_show_map_link', '0'),
(185, 1, 'profile_show_empty_fields', '1'),
(186, 1, 'profile_show_roles', '1'),
(187, 1, 'profile_show_former_roles', '1'),
(188, 1, 'profile_show_extern_roles', '1'),
(189, 1, 'profile_photo_storage', '0'),
(190, 1, 'sso_saml_enabled', '0'),
(191, 1, 'sso_saml_entity_id', '[[softurl]]'),
(192, 1, 'sso_saml_want_requests_signed', '1'),
(193, 1, 'sso_saml_signing_key', '0'),
(194, 1, 'sso_saml_encryption_key', '0'),
(195, 1, 'sso_oidc_enabled', '0'),
(196, 1, 'sso_oidc_issuer_url', '[[softurl]]/modules/sso/index.php'),
(197, 1, 'sso_oidc_signing_key', '0'),
(198, 1, 'sso_oidc_encryption_key', ''),
(199, 1, 'weblinks_module_enabled', '1'),
(200, 1, 'weblinks_per_page', '0'),
(201, 1, 'weblinks_redirect_seconds', '10'),
(202, 1, 'weblinks_target', '_blank');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_registrations`
--

CREATE TABLE `[[dbprefix]]_registrations` (
  `reg_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reg_org_id` int(10) unsigned NOT NULL,
  `reg_usr_id` int(10) unsigned NOT NULL,
  `reg_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reg_validation_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`reg_id`),
  KEY `[[dbprefix]]_fk_reg_org` (`reg_org_id`),
  KEY `[[dbprefix]]_fk_reg_usr` (`reg_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles`
--

CREATE TABLE `[[dbprefix]]_roles` (
  `rol_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rol_cat_id` int(10) unsigned NOT NULL,
  `rol_lst_id` int(10) unsigned DEFAULT NULL,
  `rol_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `rol_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `rol_description` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rol_assign_roles` tinyint(1) NOT NULL DEFAULT '0',
  `rol_approve_users` tinyint(1) NOT NULL DEFAULT '0',
  `rol_announcements` tinyint(1) NOT NULL DEFAULT '0',
  `rol_events` tinyint(1) NOT NULL DEFAULT '0',
  `rol_documents_files` tinyint(1) NOT NULL DEFAULT '0',
  `rol_inventory_admin` tinyint(1) NOT NULL DEFAULT '0',
  `rol_edit_user` tinyint(1) NOT NULL DEFAULT '0',
  `rol_forum_admin` tinyint(1) NOT NULL DEFAULT '0',
  `rol_mail_to_all` tinyint(1) NOT NULL DEFAULT '0',
  `rol_mail_this_role` smallint(6) NOT NULL DEFAULT '0',
  `rol_photo` tinyint(1) NOT NULL DEFAULT '0',
  `rol_profile` tinyint(1) NOT NULL DEFAULT '0',
  `rol_weblinks` tinyint(1) NOT NULL DEFAULT '0',
  `rol_all_lists_view` tinyint(1) NOT NULL DEFAULT '0',
  `rol_default_registration` tinyint(1) NOT NULL DEFAULT '0',
  `rol_leader_rights` smallint(6) NOT NULL DEFAULT '0',
  `rol_view_memberships` smallint(6) NOT NULL DEFAULT '0',
  `rol_view_members_profiles` smallint(6) NOT NULL DEFAULT '0',
  `rol_start_date` date DEFAULT NULL,
  `rol_start_time` time DEFAULT NULL,
  `rol_end_date` date DEFAULT NULL,
  `rol_end_time` time DEFAULT NULL,
  `rol_weekday` smallint(6) DEFAULT NULL,
  `rol_location` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rol_max_members` int(11) DEFAULT NULL,
  `rol_cost` float DEFAULT NULL,
  `rol_cost_period` smallint(6) DEFAULT NULL,
  `rol_usr_id_create` int(10) unsigned DEFAULT NULL,
  `rol_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rol_usr_id_change` int(10) unsigned DEFAULT NULL,
  `rol_timestamp_change` timestamp NULL DEFAULT NULL,
  `rol_valid` tinyint(1) NOT NULL DEFAULT '1',
  `rol_system` tinyint(1) NOT NULL DEFAULT '0',
  `rol_administrator` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rol_id`),
  UNIQUE KEY `[[dbprefix]]_idx_rol_uuid` (`rol_uuid`),
  KEY `[[dbprefix]]_fk_rol_cat` (`rol_cat_id`),
  KEY `[[dbprefix]]_fk_rol_lst_id` (`rol_lst_id`),
  KEY `[[dbprefix]]_fk_rol_usr_create` (`rol_usr_id_create`),
  KEY `[[dbprefix]]_fk_rol_usr_change` (`rol_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]_roles`
--

INSERT INTO `[[dbprefix]]_roles` VALUES
(1, 4, NULL, '41d9f06d-a1f4-469d-8749-010ac3858052', 'Administrator', 'Group of system administrators', 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 0, 0, 2, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 1),
(2, 4, NULL, 'ed4d3903-bacd-42b1-891d-3d2a498dce5c', 'Member', 'All organization members', 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 0),
(3, 4, NULL, 'ea81da89-2afb-47bc-a27d-5ea10123528f', 'Association’s board', 'Administrative board of association', 0, 0, 1, 1, 0, 0, 1, 0, 1, 2, 0, 1, 1, 1, 0, 0, 2, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles_rights`
--

CREATE TABLE `[[dbprefix]]_roles_rights` (
  `ror_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ror_name_intern` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `ror_table` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `ror_ror_id_parent` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ror_id`),
  KEY `[[dbprefix]]_fk_ror_ror_parent` (`ror_ror_id_parent`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]_roles_rights`
--

INSERT INTO `[[dbprefix]]_roles_rights` VALUES
(1, 'folder_view', '[[dbprefix]]_folders', NULL),
(2, 'folder_upload', '[[dbprefix]]_folders', NULL),
(3, 'category_view', '[[dbprefix]]_categories', NULL),
(4, 'event_participation', '[[dbprefix]]_categories', NULL),
(5, 'menu_view', '[[dbprefix]]_menu', NULL),
(6, 'sso_saml_access', '[[dbprefix]]_saml_clients', NULL),
(7, 'sso_oidc_access', '[[dbprefix]]_oidc_clients', NULL),
(8, 'category_edit', '[[dbprefix]]_categories', 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_roles_rights_data`
--

CREATE TABLE `[[dbprefix]]_roles_rights_data` (
  `rrd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rrd_ror_id` int(10) unsigned NOT NULL,
  `rrd_rol_id` int(10) unsigned NOT NULL,
  `rrd_object_id` int(10) unsigned NOT NULL,
  `rrd_usr_id_create` int(10) unsigned DEFAULT NULL,
  `rrd_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`rrd_id`),
  UNIQUE KEY `[[dbprefix]]_idx_rrd_ror_rol_object_id` (`rrd_ror_id`,`rrd_rol_id`,`rrd_object_id`),
  KEY `[[dbprefix]]_fk_rrd_rol` (`rrd_rol_id`),
  KEY `[[dbprefix]]_fk_rrd_usr_create` (`rrd_usr_id_create`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_roles_rights_data`
--

INSERT INTO `[[dbprefix]]_roles_rights_data` VALUES
(1, 8, 2, 13, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_role_dependencies`
--

CREATE TABLE `[[dbprefix]]_role_dependencies` (
  `rld_rol_id_parent` int(10) unsigned NOT NULL,
  `rld_rol_id_child` int(10) unsigned NOT NULL,
  `rld_comment` text COLLATE utf8_unicode_ci,
  `rld_usr_id` int(10) unsigned DEFAULT NULL,
  `rld_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`rld_rol_id_parent`,`rld_rol_id_child`),
  KEY `[[dbprefix]]_fk_rld_rol_child` (`rld_rol_id_child`),
  KEY `[[dbprefix]]_fk_rld_usr` (`rld_usr_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rooms`
--

CREATE TABLE `[[dbprefix]]_rooms` (
  `room_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `room_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `room_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `room_description` text COLLATE utf8_unicode_ci,
  `room_capacity` int(11) NOT NULL,
  `room_overhang` int(11) DEFAULT NULL,
  `room_usr_id_create` int(10) unsigned DEFAULT NULL,
  `room_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `room_usr_id_change` int(10) unsigned DEFAULT NULL,
  `room_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`room_id`),
  UNIQUE KEY `[[dbprefix]]_idx_room_uuid` (`room_uuid`),
  KEY `[[dbprefix]]_fk_room_usr_create` (`room_usr_id_create`),
  KEY `[[dbprefix]]_fk_room_usr_change` (`room_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_rooms`
--

INSERT INTO `[[dbprefix]]_rooms` VALUES
(1, 'd9d0f22e-1ec3-4401-bb01-2dcb54c8ef41', 'Conference room', 'Meetings can take place here.', 15, NULL, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_saml_clients`
--

CREATE TABLE `[[dbprefix]]_saml_clients` (
  `smc_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `smc_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `smc_org_id` int(10) unsigned NOT NULL,
  `smc_client_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `smc_client_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `smc_enabled` tinyint(1) DEFAULT '1',
  `smc_metadata_url` text COLLATE utf8_unicode_ci,
  `smc_acs_url` text COLLATE utf8_unicode_ci NOT NULL,
  `smc_slo_url` text COLLATE utf8_unicode_ci,
  `smc_x509_certificate` text COLLATE utf8_unicode_ci NOT NULL,
  `smc_userid_field` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'usr_id',
  `smc_field_mapping` text COLLATE utf8_unicode_ci,
  `smc_role_mapping` text COLLATE utf8_unicode_ci,
  `smc_allowed_clock_skew` int(10) unsigned DEFAULT NULL,
  `smc_assertion_lifetime` int(10) unsigned DEFAULT NULL,
  `smc_sign_assertions` tinyint(1) DEFAULT '1',
  `smc_encrypt_assertions` tinyint(1) DEFAULT '0',
  `smc_require_auth_signed` tinyint(1) DEFAULT '0',
  `smc_validate_signatures` tinyint(1) DEFAULT '1',
  `smc_usr_id_create` int(10) unsigned DEFAULT NULL,
  `smc_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `smc_usr_id_change` int(10) unsigned DEFAULT NULL,
  `smc_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`smc_id`),
  UNIQUE KEY `smc_client_id` (`smc_client_id`),
  KEY `[[dbprefix]]_fk_smc_usr_create` (`smc_usr_id_create`),
  KEY `[[dbprefix]]_fk_smc_usr_change` (`smc_usr_id_change`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_sessions`
--

CREATE TABLE `[[dbprefix]]_sessions` (
  `ses_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ses_usr_id` int(10) unsigned DEFAULT NULL,
  `ses_org_id` int(10) unsigned NOT NULL,
  `ses_session_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ses_begin` timestamp NULL DEFAULT NULL,
  `ses_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ses_ip_address` varchar(39) COLLATE utf8_unicode_ci NOT NULL,
  `ses_binary` blob,
  `ses_reload` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ses_id`),
  KEY `[[dbprefix]]_idx_session_id` (`ses_session_id`),
  KEY `[[dbprefix]]_fk_ses_org` (`ses_org_id`),
  KEY `[[dbprefix]]_fk_ses_usr` (`ses_usr_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_sso_keys`
--

CREATE TABLE `[[dbprefix]]_sso_keys` (
  `key_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `key_org_id` int(10) unsigned NOT NULL,
  `key_name` text COLLATE utf8_unicode_ci NOT NULL,
  `key_algorithm` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'RSA',
  `key_private` text COLLATE utf8_unicode_ci NOT NULL,
  `key_public` text COLLATE utf8_unicode_ci NOT NULL,
  `key_certificate` text COLLATE utf8_unicode_ci,
  `key_expires_at` date DEFAULT NULL,
  `key_is_active` tinyint(1) NOT NULL DEFAULT '1',
  `key_usr_id_create` int(10) unsigned DEFAULT NULL,
  `key_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `key_usr_id_change` int(10) unsigned DEFAULT NULL,
  `key_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `[[dbprefix]]_fk_key_org` (`key_org_id`),
  KEY `[[dbprefix]]_fk_key_usr_change` (`key_usr_id_change`),
  KEY `[[dbprefix]]_fk_key_usr_create` (`key_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_texts`
--

CREATE TABLE `[[dbprefix]]_texts` (
  `txt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `txt_org_id` int(10) unsigned NOT NULL,
  `txt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `txt_text` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`txt_id`),
  KEY `[[dbprefix]]_fk_txt_org` (`txt_org_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]_texts`
--

INSERT INTO `[[dbprefix]]_texts` VALUES
(1, 1, 'SYSMAIL_REGISTRATION_CONFIRMATION', '#subject# Your registration at #organization_long_name#\r\n#content# Hello #user_first_name#,\r\nwe are very glad that you have registered on our website #organization_homepage#.\r\n\r\nTo complete your registration, please click on the following link: #variable1#. By clicking on the link you will be automatically redirected to our website and your registration will be confirmed.\r\n\r\nOnce you have confirmed your registration, we will check it. You will receive a reply within a few hours whether your registration has been accepted and you can log in with your credentials or whether your registration has been rejected.\r\n\r\nBest regards\r\nThe team of #organization_long_name#'),
(2, 1, 'SYSMAIL_REGISTRATION_NEW', '#subject# New registration at #organization_long_name# website\r\n#content# A new user has registered on #organization_homepage#.\r\n\r\nSurname: #user_last_name#\r\nFirst Name: #user_first_name#\r\nE-Mail: #user_email#\r\n\r\n\r\nThis message was generated automatically.'),
(3, 1, 'SYSMAIL_REGISTRATION_APPROVED', '#subject# Registration at #organization_long_name# confirmed\r\n#content# Hello #user_first_name#,\r\n\r\nyour registration on #organization_homepage# has been confirmed.\r\n\r\nYou can now log in to the homepage with your username #user_login_name# and your password.\r\n\r\nIf you have any questions, write an email to #administrator_email#.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(4, 1, 'SYSMAIL_REGISTRATION_REFUSED', '#subject# in registration at #organization_long_name# rejected.\r\n#content#Hello #user_first_name#,\r\n\r\nyour registration at #organization_homepage# was rejected.\r\n\r\nRegistrations are accepted in general by our users. If you are a member and your registration was still rejected, it may be because you were not identified as member.\r\nTo clarify the reasons for the rejection please contact the administrator #administrator_email# from #organization_homepage#.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(5, 1, 'SYSMAIL_LOGIN_INFORMATION', '#subject# Login data for #organization_long_name#\r\n#content# Hello #user_first_name#,\r\n\r\nYou receive your login data for the website #organization_homepage#.\r\nUsername: #user_login_name#\r\nPassword: #variable1#\r\n\r\nThe password was generated automatically,\r\nYou should change it after logging in to #organization_homepage# in your profile.\r\n\r\nRegards,\r\nThe team of #organization_long_name#'),
(6, 1, 'SYSMAIL_PASSWORD_RESET', '#subject# Reset password for #organization_long_name#\r\n#content# Hello #user_first_name#,\r\n\r\nWe have received a request to reset your password on #organization_homepage#.\r\n\r\nIf the request came from you, you can use the following link to reset your password and set a new one: \r\n#variable1#\r\n\r\nRegards,\r\nThe team of #organization_long_name#');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_users`
--

CREATE TABLE `[[dbprefix]]_users` (
  `usr_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usr_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `usr_login_name` varchar(254) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_tfa_secret` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_photo` blob,
  `usr_text` text COLLATE utf8_unicode_ci,
  `usr_pw_reset_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usr_pw_reset_timestamp` timestamp NULL DEFAULT NULL,
  `usr_last_login` timestamp NULL DEFAULT NULL,
  `usr_actual_login` timestamp NULL DEFAULT NULL,
  `usr_number_login` int(11) NOT NULL DEFAULT '0',
  `usr_date_invalid` timestamp NULL DEFAULT NULL,
  `usr_number_invalid` smallint(6) NOT NULL DEFAULT '0',
  `usr_usr_id_create` int(10) unsigned DEFAULT NULL,
  `usr_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usr_usr_id_change` int(10) unsigned DEFAULT NULL,
  `usr_timestamp_change` timestamp NULL DEFAULT NULL,
  `usr_valid` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`usr_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usr_uuid` (`usr_uuid`),
  UNIQUE KEY `[[dbprefix]]_idx_usr_login_name` (`usr_login_name`),
  KEY `[[dbprefix]]_fk_usr_usr_create` (`usr_usr_id_create`),
  KEY `[[dbprefix]]_fk_usr_usr_change` (`usr_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_users`
--

INSERT INTO `[[dbprefix]]_users` VALUES
(1, '40a65037-7a0c-456d-9817-306a7057c01a', 'System', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, '[[regtime]]', NULL, NULL, 0),
(2, 'c5000153-38b2-47f5-b2ce-cb37e5b015fc', '[[admin_username]]', '[[admin_pass]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, 1, '[[regtime]]', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_data`
--

CREATE TABLE `[[dbprefix]]_user_data` (
  `usd_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usd_usr_id` int(10) unsigned NOT NULL,
  `usd_usf_id` int(10) unsigned NOT NULL,
  `usd_value` varchar(4000) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`usd_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usd_usr_usf_id` (`usd_usr_id`,`usd_usf_id`),
  KEY `[[dbprefix]]_fk_usd_usf` (`usd_usf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]_user_data`
--

INSERT INTO `[[dbprefix]]_user_data` VALUES
(1, 2, 1, '[[admin_lname]]'),
(2, 2, 2, '[[admin_fname]]'),
(3, 2, 11, '[[admin_email]]'),
(4, 1, 1, 'System');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_fields`
--

CREATE TABLE `[[dbprefix]]_user_fields` (
  `usf_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `usf_cat_id` int(10) unsigned NOT NULL,
  `usf_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `usf_type` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `usf_name_intern` varchar(110) COLLATE utf8_unicode_ci NOT NULL,
  `usf_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `usf_description` text COLLATE utf8_unicode_ci,
  `usf_default_value` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_regex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_icon` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_url` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `usf_system` tinyint(1) NOT NULL DEFAULT '0',
  `usf_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `usf_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `usf_registration` tinyint(1) NOT NULL DEFAULT '0',
  `usf_required_input` smallint(6) NOT NULL DEFAULT '0',
  `usf_sequence` smallint(6) NOT NULL,
  `usf_usr_id_create` int(10) unsigned DEFAULT NULL,
  `usf_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `usf_usr_id_change` int(10) unsigned DEFAULT NULL,
  `usf_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`usf_id`),
  UNIQUE KEY `[[dbprefix]]_idx_usf_name_intern` (`usf_name_intern`),
  UNIQUE KEY `[[dbprefix]]_idx_usf_uuid` (`usf_uuid`),
  KEY `[[dbprefix]]_fk_usf_cat` (`usf_cat_id`),
  KEY `[[dbprefix]]_fk_usf_usr_create` (`usf_usr_id_create`),
  KEY `[[dbprefix]]_fk_usf_usr_change` (`usf_usr_id_change`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=19 ;

--
-- Dumping data for table `[[dbprefix]]_user_fields`
--

INSERT INTO `[[dbprefix]]_user_fields` VALUES
(1, 1, '1e253166-a35c-48d7-a24b-a384ba932996', 'TEXT', 'LAST_NAME', 'SYS_LASTNAME', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, 1, 1, 1, 1, '[[regtime]]', NULL, NULL),
(2, 1, '5a030f28-3b82-44f2-8ad4-085f42d3a018', 'TEXT', 'FIRST_NAME', 'SYS_FIRSTNAME', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, 1, 1, 2, 1, '[[regtime]]', NULL, NULL),
(3, 1, 'a829fb0f-500b-48e3-940e-b0f35320b9bd', 'TEXT', 'STREET', 'SYS_STREET', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, 1, '30f6656b-700a-4e18-be99-06506a78364d', 'TEXT', 'POSTCODE', 'SYS_POSTCODE', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(5, 1, '06472cfc-15b4-472b-9da3-7e8f2a51a280', 'TEXT', 'CITY', 'SYS_CITY', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 5, 1, '[[regtime]]', NULL, NULL),
(6, 1, '29b2136d-12a8-479b-9286-9679cb870211', 'TEXT', 'COUNTRY', 'SYS_COUNTRY', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 6, 1, '[[regtime]]', NULL, NULL),
(7, 1, 'cc1ec3fa-181b-4060-ab5e-45dc8e84a697', 'PHONE', 'PHONE', 'SYS_PHONE', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 7, 1, '[[regtime]]', NULL, NULL),
(8, 1, 'c38b50a8-598b-4bed-8e41-f2597356b003', 'PHONE', 'MOBILE', 'SYS_MOBILE', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 8, 1, '[[regtime]]', NULL, NULL),
(9, 1, '06c4f029-2b8d-4961-8998-42a3c88e9487', 'DATE', 'BIRTHDAY', 'SYS_BIRTHDAY', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 10, 1, '[[regtime]]', NULL, NULL),
(10, 1, '57e46397-a771-4eeb-a26b-9aeceac17d76', 'RADIO_BUTTON', 'GENDER', 'SYS_GENDER', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 11, 1, '[[regtime]]', NULL, NULL),
(11, 1, '3a80b933-8a96-4349-8f89-f5fd1e58de9c', 'EMAIL', 'EMAIL', 'SYS_EMAIL', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, 1, 2, 12, 1, '[[regtime]]', NULL, NULL),
(12, 1, '4548b2a9-008e-4849-aea8-d193ae2a4252', 'URL', 'WEBSITE', 'SYS_WEBSITE', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 13, 1, '[[regtime]]', NULL, NULL),
(13, 3, 'a7a88edc-bbec-4938-83d7-feaafc01e8d8', 'CHECKBOX', 'DATA_PROTECTION_PERMISSION', 'SYS_DATA_PROTECTION_PERMISSION', 'I have read the information provided by the organization. As far as the personal data provided by me are not necessary data for the fulfillment of the contract, I declare my consent to the processing of these data. My data will be stored exclusively for the purposes of the organization and treated confidentially.', NULL, NULL, NULL, NULL, 0, 0, 0, 0, 2, 14, 1, '[[regtime]]', NULL, NULL),
(14, 2, 'a77226fb-776c-43bc-b54b-119468ace3bf', 'TEXT', 'FACEBOOK', 'SYS_FACEBOOK', 'Would you like to set a link to your profile of this social network? Your login name is required. Log in to your account of the social network and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your profile directly.', NULL, NULL, 'facebook', 'https://www.facebook.com/#user_content#', 0, 0, 0, 0, 0, 1, 1, '[[regtime]]', NULL, NULL),
(15, 2, '3d1a813d-d801-412c-a6c4-3a9ef6b7ee9c', 'TEXT', 'INSTAGRAM', 'SYS_INSTAGRAM', 'Would you like to set a link to your profile of this social network? Your login name is required. Log in to your account of the social network and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your profile directly.', NULL, NULL, 'instagram', 'https://www.instagram.com/#user_content#', 0, 0, 0, 0, 0, 2, 1, '[[regtime]]', NULL, NULL),
(16, 2, '3bc1e4ef-33e1-4139-ab6e-91add4d1af9f', 'TEXT', 'LINKEDIN', 'SYS_LINKEDIN', 'Would you like to set a link to your profile of this social network? Your login name is required. Log in to your account of the social network and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your profile directly.', NULL, NULL, 'linkedin', 'https://www.linkedin.com/in/#user_content#', 0, 0, 0, 0, 0, 3, 1, '[[regtime]]', NULL, NULL),
(17, 2, '2603ca2a-6a19-4b5f-818d-207b2c928319', 'TEXT', 'MASTODON', 'SYS_MASTODON', 'Would you like to set a link to your profile of this social network? Your login name is required. Log in to your account of the social network and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your profile directly.', NULL, NULL, 'mastodon', 'https://mastodon.social/#user_content#', 0, 0, 0, 0, 0, 4, 1, '[[regtime]]', NULL, NULL),
(18, 2, '5b47d065-4c3b-4afd-a362-933294403912', 'TEXT', 'XING', 'SYS_XING', 'Would you like to set a link to your profile of this social network? Your login name is required. Log in to your account of the social network and go to your profile. Now copy the URL in this field and save your profile here. Visitors of your profile are now able to open your profile directly.', NULL, NULL, NULL, 'https://www.xing.com/profile/#user_content#', 0, 0, 0, 0, 0, 7, 1, '[[regtime]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_field_select_options`
--

CREATE TABLE `[[dbprefix]]_user_field_select_options` (
  `ufo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ufo_usf_id` int(10) unsigned NOT NULL,
  `ufo_value` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ufo_system` tinyint(1) NOT NULL DEFAULT '0',
  `ufo_sequence` smallint(6) NOT NULL,
  `ufo_obsolete` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ufo_id`),
  KEY `[[dbprefix]]_fk_ufo_usf` (`ufo_usf_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]_user_field_select_options`
--

INSERT INTO `[[dbprefix]]_user_field_select_options` VALUES
(1, 10, 'gender-male|SYS_MALE', 0, 1, 0),
(2, 10, 'gender-female|SYS_FEMALE', 0, 2, 0),
(3, 10, 'gender-trans|SYS_DIVERSE', 0, 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_relations`
--

CREATE TABLE `[[dbprefix]]_user_relations` (
  `ure_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ure_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `ure_urt_id` int(10) unsigned NOT NULL,
  `ure_usr_id1` int(10) unsigned NOT NULL,
  `ure_usr_id2` int(10) unsigned NOT NULL,
  `ure_usr_id_create` int(10) unsigned DEFAULT NULL,
  `ure_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ure_usr_id_change` int(10) unsigned DEFAULT NULL,
  `ure_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ure_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ure_urt_usr` (`ure_urt_id`,`ure_usr_id1`,`ure_usr_id2`),
  UNIQUE KEY `[[dbprefix]]_idx_ure_uuid` (`ure_uuid`),
  KEY `[[dbprefix]]_fk_ure_usr1` (`ure_usr_id1`),
  KEY `[[dbprefix]]_fk_ure_usr2` (`ure_usr_id2`),
  KEY `[[dbprefix]]_fk_ure_usr_change` (`ure_usr_id_change`),
  KEY `[[dbprefix]]_fk_ure_usr_create` (`ure_usr_id_create`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_user_relation_types`
--

CREATE TABLE `[[dbprefix]]_user_relation_types` (
  `urt_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `urt_uuid` varchar(36) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name_male` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_name_female` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `urt_edit_user` tinyint(1) NOT NULL DEFAULT '0',
  `urt_id_inverse` int(10) unsigned DEFAULT NULL,
  `urt_usr_id_create` int(10) unsigned DEFAULT NULL,
  `urt_timestamp_create` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `urt_usr_id_change` int(10) unsigned DEFAULT NULL,
  `urt_timestamp_change` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`urt_id`),
  UNIQUE KEY `[[dbprefix]]_idx_ure_urt_name` (`urt_name`),
  UNIQUE KEY `[[dbprefix]]_idx_urt_uuid` (`urt_uuid`),
  KEY `[[dbprefix]]_fk_urt_id_inverse` (`urt_id_inverse`),
  KEY `[[dbprefix]]_fk_urt_usr_change` (`urt_usr_id_change`),
  KEY `[[dbprefix]]_fk_urt_usr_create` (`urt_usr_id_create`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]_user_relation_types`
--

INSERT INTO `[[dbprefix]]_user_relation_types` VALUES
(1, '4f956823-bb62-4f3d-9a3c-c744993151ca', 'SYS_PARENT', 'SYS_FATHER', 'SYS_MOTHER', 0, 2, 1, '[[regtime]]', NULL, NULL),
(2, '23c2a8d6-102c-4991-ab4a-f0f4fee2433b', 'SYS_CHILD', 'SYS_SON', 'SYS_DAUGHTER', 0, 1, 1, '[[regtime]]', NULL, NULL),
(3, '8def859b-21c8-46e9-bce0-bf929ecc4c31', 'SYS_SIBLING', 'SYS_BROTHER', 'SYS_SISTER', 0, 3, 1, '[[regtime]]', NULL, NULL),
(4, '9e61efd2-69c8-451a-92e7-96cd7d79bc9f', 'SYS_SPOUSE', 'SYS_HUSBAND', 'SYS_WIFE', 0, 4, 1, '[[regtime]]', NULL, NULL),
(5, 'ab6bf9e3-4846-4336-aeea-ced4df94dfb9', 'SYS_COHABITANT', 'SYS_COHABITANT_MALE', 'SYS_COHABITANT_FEMALE', 0, 5, 1, '[[regtime]]', NULL, NULL),
(6, '4d609fd4-aa76-4cc1-8f70-4c3af6e7cd9d', 'SYS_COMPANION', 'SYS_BOYFRIEND', 'SYS_GIRLFRIEND', 0, 6, 1, '[[regtime]]', NULL, NULL),
(7, 'eda1aa69-d7d1-4164-b5e9-5337918472e1', 'SYS_SUPERIOR', 'SYS_SUPERIOR_MALE', 'SYS_SUPERIOR_FEMALE', 0, 8, 1, '[[regtime]]', NULL, NULL),
(8, '055f2035-6a50-4309-b5d0-1db173fcd7b7', 'SYS_SUBORDINATE', 'SYS_SUBORDINATE_MALE', 'SYS_SUBORDINATE_FEMALE', 0, 7, 1, '[[regtime]]', NULL, NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]_announcements`
--
ALTER TABLE `[[dbprefix]]_announcements`
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_cat` FOREIGN KEY (`ann_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_usr_change` FOREIGN KEY (`ann_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ann_usr_create` FOREIGN KEY (`ann_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_auto_login`
--
ALTER TABLE `[[dbprefix]]_auto_login`
  ADD CONSTRAINT `[[dbprefix]]_fk_atl_org` FOREIGN KEY (`atl_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_atl_usr` FOREIGN KEY (`atl_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_categories`
--
ALTER TABLE `[[dbprefix]]_categories`
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_org` FOREIGN KEY (`cat_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_usr_change` FOREIGN KEY (`cat_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_cat_usr_create` FOREIGN KEY (`cat_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_category_report`
--
ALTER TABLE `[[dbprefix]]_category_report`
  ADD CONSTRAINT `[[dbprefix]]_fk_crt_org` FOREIGN KEY (`crt_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_events`
--
ALTER TABLE `[[dbprefix]]_events`
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_cat` FOREIGN KEY (`dat_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_rol` FOREIGN KEY (`dat_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_room` FOREIGN KEY (`dat_room_id`) REFERENCES `[[dbprefix]]_rooms` (`room_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_usr_change` FOREIGN KEY (`dat_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_dat_usr_create` FOREIGN KEY (`dat_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_files`
--
ALTER TABLE `[[dbprefix]]_files`
  ADD CONSTRAINT `[[dbprefix]]_fk_fil_fol` FOREIGN KEY (`fil_fol_id`) REFERENCES `[[dbprefix]]_folders` (`fol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fil_usr` FOREIGN KEY (`fil_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_folders`
--
ALTER TABLE `[[dbprefix]]_folders`
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_fol_parent` FOREIGN KEY (`fol_fol_id_parent`) REFERENCES `[[dbprefix]]_folders` (`fol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_org` FOREIGN KEY (`fol_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fol_usr` FOREIGN KEY (`fol_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_forum_posts`
--
ALTER TABLE `[[dbprefix]]_forum_posts`
  ADD CONSTRAINT `[[dbprefix]]_fk_fop_fot` FOREIGN KEY (`fop_fot_id`) REFERENCES `[[dbprefix]]_forum_topics` (`fot_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fop_usr_change` FOREIGN KEY (`fop_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_fop_usr_create` FOREIGN KEY (`fop_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_forum_topics`
--
ALTER TABLE `[[dbprefix]]_forum_topics`
  ADD CONSTRAINT `[[dbprefix]]_fk_fot_cat` FOREIGN KEY (`fot_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fot_first_fop` FOREIGN KEY (`fot_fop_id_first_post`) REFERENCES `[[dbprefix]]_forum_posts` (`fop_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_fot_usr_create` FOREIGN KEY (`fot_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_ids`
--
ALTER TABLE `[[dbprefix]]_ids`
  ADD CONSTRAINT `[[dbprefix]]_fk_ids_usr_id` FOREIGN KEY (`ids_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_inventory_fields`
--
ALTER TABLE `[[dbprefix]]_inventory_fields`
  ADD CONSTRAINT `[[dbprefix]]_fk_inf_org` FOREIGN KEY (`inf_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_inf_usr_change` FOREIGN KEY (`inf_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_inf_usr_create` FOREIGN KEY (`inf_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_inventory_field_select_options`
--
ALTER TABLE `[[dbprefix]]_inventory_field_select_options`
  ADD CONSTRAINT `[[dbprefix]]_fk_ifo_inf` FOREIGN KEY (`ifo_inf_id`) REFERENCES `[[dbprefix]]_inventory_fields` (`inf_id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]_inventory_items`
--
ALTER TABLE `[[dbprefix]]_inventory_items`
  ADD CONSTRAINT `[[dbprefix]]_fk_ini_cat` FOREIGN KEY (`ini_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ini_status` FOREIGN KEY (`ini_status`) REFERENCES `[[dbprefix]]_inventory_field_select_options` (`ifo_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ini_usr_change` FOREIGN KEY (`ini_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ini_usr_create` FOREIGN KEY (`ini_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_inventory_item_borrow_data`
--
ALTER TABLE `[[dbprefix]]_inventory_item_borrow_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_inb_ini` FOREIGN KEY (`inb_ini_id`) REFERENCES `[[dbprefix]]_inventory_items` (`ini_id`);

--
-- Constraints for table `[[dbprefix]]_inventory_item_data`
--
ALTER TABLE `[[dbprefix]]_inventory_item_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_ind_inf` FOREIGN KEY (`ind_inf_id`) REFERENCES `[[dbprefix]]_inventory_fields` (`inf_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ind_ini` FOREIGN KEY (`ind_ini_id`) REFERENCES `[[dbprefix]]_inventory_items` (`ini_id`);

--
-- Constraints for table `[[dbprefix]]_links`
--
ALTER TABLE `[[dbprefix]]_links`
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_cat` FOREIGN KEY (`lnk_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_usr_change` FOREIGN KEY (`lnk_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_lnk_usr_create` FOREIGN KEY (`lnk_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_lists`
--
ALTER TABLE `[[dbprefix]]_lists`
  ADD CONSTRAINT `[[dbprefix]]_fk_lst_org` FOREIGN KEY (`lst_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lst_usr` FOREIGN KEY (`lst_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_list_columns`
--
ALTER TABLE `[[dbprefix]]_list_columns`
  ADD CONSTRAINT `[[dbprefix]]_fk_lsc_lst` FOREIGN KEY (`lsc_lst_id`) REFERENCES `[[dbprefix]]_lists` (`lst_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_lsc_usf` FOREIGN KEY (`lsc_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`);

--
-- Constraints for table `[[dbprefix]]_members`
--
ALTER TABLE `[[dbprefix]]_members`
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_rol` FOREIGN KEY (`mem_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr` FOREIGN KEY (`mem_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr_change` FOREIGN KEY (`mem_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_mem_usr_create` FOREIGN KEY (`mem_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_menu`
--
ALTER TABLE `[[dbprefix]]_menu`
  ADD CONSTRAINT `[[dbprefix]]_fk_men_com_id` FOREIGN KEY (`men_com_id`) REFERENCES `[[dbprefix]]_components` (`com_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_men_men_parent` FOREIGN KEY (`men_men_id_parent`) REFERENCES `[[dbprefix]]_menu` (`men_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_messages`
--
ALTER TABLE `[[dbprefix]]_messages`
  ADD CONSTRAINT `[[dbprefix]]_fk_msg_usr_sender` FOREIGN KEY (`msg_usr_id_sender`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_messages_attachments`
--
ALTER TABLE `[[dbprefix]]_messages_attachments`
  ADD CONSTRAINT `[[dbprefix]]_fk_msa_msg_id` FOREIGN KEY (`msa_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`);

--
-- Constraints for table `[[dbprefix]]_messages_content`
--
ALTER TABLE `[[dbprefix]]_messages_content`
  ADD CONSTRAINT `[[dbprefix]]_fk_msc_msg_id` FOREIGN KEY (`msc_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_msc_usr_id` FOREIGN KEY (`msc_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_messages_recipients`
--
ALTER TABLE `[[dbprefix]]_messages_recipients`
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_msg_id` FOREIGN KEY (`msr_msg_id`) REFERENCES `[[dbprefix]]_messages` (`msg_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_rol_id` FOREIGN KEY (`msr_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_msr_usr_id` FOREIGN KEY (`msr_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_oidc_access_tokens`
--
ALTER TABLE `[[dbprefix]]_oidc_access_tokens`
  ADD CONSTRAINT `[[dbprefix]]_fk_oat_ocl_id` FOREIGN KEY (`oat_ocl_id`) REFERENCES `[[dbprefix]]_oidc_clients` (`ocl_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_oat_usr_create` FOREIGN KEY (`oat_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_oat_usr_id` FOREIGN KEY (`oat_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]_oidc_auth_codes`
--
ALTER TABLE `[[dbprefix]]_oidc_auth_codes`
  ADD CONSTRAINT `[[dbprefix]]_fk_oac_ocl_id` FOREIGN KEY (`oac_ocl_id`) REFERENCES `[[dbprefix]]_oidc_clients` (`ocl_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_oac_usr_create` FOREIGN KEY (`oac_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_oac_usr_id` FOREIGN KEY (`oac_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]_oidc_clients`
--
ALTER TABLE `[[dbprefix]]_oidc_clients`
  ADD CONSTRAINT `[[dbprefix]]_fk_ocl_usr_change` FOREIGN KEY (`ocl_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ocl_usr_create` FOREIGN KEY (`ocl_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_oidc_refresh_tokens`
--
ALTER TABLE `[[dbprefix]]_oidc_refresh_tokens`
  ADD CONSTRAINT `[[dbprefix]]_fk_ort_ocl_id` FOREIGN KEY (`ort_ocl_id`) REFERENCES `[[dbprefix]]_oidc_clients` (`ocl_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ort_usr_create` FOREIGN KEY (`ort_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ort_usr_id` FOREIGN KEY (`ort_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]]_organizations`
--
ALTER TABLE `[[dbprefix]]_organizations`
  ADD CONSTRAINT `[[dbprefix]]_fk_org_org_parent` FOREIGN KEY (`org_org_id_parent`) REFERENCES `[[dbprefix]]_organizations` (`org_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_photos`
--
ALTER TABLE `[[dbprefix]]_photos`
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_org` FOREIGN KEY (`pho_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_pho_parent` FOREIGN KEY (`pho_pho_id_parent`) REFERENCES `[[dbprefix]]_photos` (`pho_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_usr_change` FOREIGN KEY (`pho_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_pho_usr_create` FOREIGN KEY (`pho_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_preferences`
--
ALTER TABLE `[[dbprefix]]_preferences`
  ADD CONSTRAINT `[[dbprefix]]_fk_prf_org` FOREIGN KEY (`prf_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_registrations`
--
ALTER TABLE `[[dbprefix]]_registrations`
  ADD CONSTRAINT `[[dbprefix]]_fk_reg_org` FOREIGN KEY (`reg_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_reg_usr` FOREIGN KEY (`reg_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_roles`
--
ALTER TABLE `[[dbprefix]]_roles`
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_cat` FOREIGN KEY (`rol_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_lst_id` FOREIGN KEY (`rol_lst_id`) REFERENCES `[[dbprefix]]_lists` (`lst_id`) ON DELETE SET NULL ON UPDATE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_usr_change` FOREIGN KEY (`rol_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_rol_usr_create` FOREIGN KEY (`rol_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_roles_rights`
--
ALTER TABLE `[[dbprefix]]_roles_rights`
  ADD CONSTRAINT `[[dbprefix]]_fk_ror_ror_parent` FOREIGN KEY (`ror_ror_id_parent`) REFERENCES `[[dbprefix]]_roles_rights` (`ror_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_roles_rights_data`
--
ALTER TABLE `[[dbprefix]]_roles_rights_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_rol` FOREIGN KEY (`rrd_rol_id`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_ror` FOREIGN KEY (`rrd_ror_id`) REFERENCES `[[dbprefix]]_roles_rights` (`ror_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rrd_usr_create` FOREIGN KEY (`rrd_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_role_dependencies`
--
ALTER TABLE `[[dbprefix]]_role_dependencies`
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_rol_child` FOREIGN KEY (`rld_rol_id_child`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_rol_parent` FOREIGN KEY (`rld_rol_id_parent`) REFERENCES `[[dbprefix]]_roles` (`rol_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_rld_usr` FOREIGN KEY (`rld_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_rooms`
--
ALTER TABLE `[[dbprefix]]_rooms`
  ADD CONSTRAINT `[[dbprefix]]_fk_room_usr_change` FOREIGN KEY (`room_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_room_usr_create` FOREIGN KEY (`room_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_saml_clients`
--
ALTER TABLE `[[dbprefix]]_saml_clients`
  ADD CONSTRAINT `[[dbprefix]]_fk_smc_usr_change` FOREIGN KEY (`smc_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_smc_usr_create` FOREIGN KEY (`smc_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_sessions`
--
ALTER TABLE `[[dbprefix]]_sessions`
  ADD CONSTRAINT `[[dbprefix]]_fk_ses_org` FOREIGN KEY (`ses_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_ses_usr` FOREIGN KEY (`ses_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_sso_keys`
--
ALTER TABLE `[[dbprefix]]_sso_keys`
  ADD CONSTRAINT `[[dbprefix]]_fk_key_org` FOREIGN KEY (`key_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_key_usr_change` FOREIGN KEY (`key_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_key_usr_create` FOREIGN KEY (`key_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_texts`
--
ALTER TABLE `[[dbprefix]]_texts`
  ADD CONSTRAINT `[[dbprefix]]_fk_txt_org` FOREIGN KEY (`txt_org_id`) REFERENCES `[[dbprefix]]_organizations` (`org_id`);

--
-- Constraints for table `[[dbprefix]]_users`
--
ALTER TABLE `[[dbprefix]]_users`
  ADD CONSTRAINT `[[dbprefix]]_fk_usr_usr_change` FOREIGN KEY (`usr_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_usr_usr_create` FOREIGN KEY (`usr_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_data`
--
ALTER TABLE `[[dbprefix]]_user_data`
  ADD CONSTRAINT `[[dbprefix]]_fk_usd_usf` FOREIGN KEY (`usd_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_usd_usr` FOREIGN KEY (`usd_usr_id`) REFERENCES `[[dbprefix]]_users` (`usr_id`);

--
-- Constraints for table `[[dbprefix]]_user_fields`
--
ALTER TABLE `[[dbprefix]]_user_fields`
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_cat` FOREIGN KEY (`usf_cat_id`) REFERENCES `[[dbprefix]]_categories` (`cat_id`),
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_usr_change` FOREIGN KEY (`usf_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_usf_usr_create` FOREIGN KEY (`usf_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_field_select_options`
--
ALTER TABLE `[[dbprefix]]_user_field_select_options`
  ADD CONSTRAINT `[[dbprefix]]_fk_ufo_usf` FOREIGN KEY (`ufo_usf_id`) REFERENCES `[[dbprefix]]_user_fields` (`usf_id`);

--
-- Constraints for table `[[dbprefix]]_user_relations`
--
ALTER TABLE `[[dbprefix]]_user_relations`
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_urt` FOREIGN KEY (`ure_urt_id`) REFERENCES `[[dbprefix]]_user_relation_types` (`urt_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr1` FOREIGN KEY (`ure_usr_id1`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr2` FOREIGN KEY (`ure_usr_id2`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr_change` FOREIGN KEY (`ure_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_ure_usr_create` FOREIGN KEY (`ure_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

--
-- Constraints for table `[[dbprefix]]_user_relation_types`
--
ALTER TABLE `[[dbprefix]]_user_relation_types`
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_id_inverse` FOREIGN KEY (`urt_id_inverse`) REFERENCES `[[dbprefix]]_user_relation_types` (`urt_id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_usr_change` FOREIGN KEY (`urt_usr_id_change`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]_fk_urt_usr_create` FOREIGN KEY (`urt_usr_id_create`) REFERENCES `[[dbprefix]]_users` (`usr_id`) ON DELETE SET NULL;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
