<?php

session_start();

    include_once('../db/saucerer.php');
 
// Define variables and initialize with empty values
$id = $name = $token = $access = "";
$id_err = $name_err = $token_err = $access_err = "";


// Generating a random number
date_default_timezone_set('Africa/Kampala');
$today = date("His-dmY",time());

$code1 = rand(1,9); 
$code2 = rand(1,9);
$code3 = $code1 * $code2; 
$tokens = "$code3-$today";


// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["failed"]) || $_SESSION["failed"] != true){

  $failed = "";
    
} elseif(!isset($_SESSION["failed"]) || $_SESSION["failed"] == true){

  $failed = $_SESSION['failed'];
 
}

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){

    $fname = trim($_POST["fname"]);
    $lname = trim($_POST["lname"]);
    $token = trim($_POST["token"]);
    $access = trim($_POST["access"]);
 
    // Validate code
    if(empty(trim($_POST["access"]))){
        $access_err = "Invalid access code!";
    } else{
        // Prepare a select statement
        $sql = "SELECT id FROM access WHERE code = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_access);
            
            // Set parameters
            $param_access = trim($_POST["access"]);
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                /* store result */
                mysqli_stmt_store_result($stmt);
                    
                    if(mysqli_stmt_num_rows($stmt) == 0){

                    $action = "Login";
                    $attempt = "Failed";
                    $access_err = "Invalid access code!";

                    // Prepare an insert statement
                    $sql = "INSERT INTO secure (fname, lname, token, access, attempt, action) VALUES (?, ?, ?, ?, ?, ?)";

                    if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "ssssss", $param_fname, $param_lname, $param_token, $param_access, $param_attempt, $param_action);
            
            // Set parameters
            $param_fname = $fname;
            $param_lname = $lname;
            $param_token = $token;
            $param_access = $access;
            $param_action = $action;
            $param_attempt = $attempt;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                            
                            // Store data in session variables
                            $_SESSION["failed"] = true;
                            $_SESSION["fname"] = $fname;  
                            $_SESSION["lname"] = $lname;   
                
            }

        }

                    }
                
            } else{
               $_SESSION['error'] = "Oops! Something went wrong. Please try again later.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Check input errors before inserting in database
    if(empty($name_err) && empty($token_err) && empty($access_err)){

        
        $action = "Login";
        $attempt = "Succesful";

        // Prepare an insert statement
        $sql = "INSERT INTO secure (fname, lname, token, access, attempt, action) VALUES (?, ?, ?, ?, ?, ?)";
         
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "ssssss", $param_fname, $param_lname, $param_token, $param_access, $param_attempt, $param_action);
            
            // Set parameters
            $param_fname = $fname;
            $param_lname = $lname;
            $param_token = $token;
            $param_access = $access;
            $param_action = $action;
            $param_attempt = $attempt;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){

                            session_start();
                            
                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["fname"] = $fname;
                            $_SESSION["lname"] = $lname;
                            $_SESSION["token"] = $token;
                            $_SESSION["access"] = $access;

                // Redirect to login page
                header("location: ../");
            } else{
                $_SESSION['error'] = "Something went wrong. Please try again.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Close connection
    mysqli_close($link);

}
?>

<!doctype html>
<html lang="en" class="no-js">
<head>
	<title>Secure | Africa Golf Confederation</title>

	<meta charset="utf-8">

	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

    <!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="../../images/favicon.png" type="image/x-icon">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://agcgolf.news/images/card/1.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="Admin | Africa Golf Confederation &copy;">

    <meta property="og:url" content="https://agcgolf.news/admin/secure">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="Golf News & Articles">

    <meta property="og:site_name" content="Admin | Africa Golf Confederation &copy;">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://agcgolf.news/admin/secure">

    <meta name="twitter:title" content="Admin | Africa Golf Confederation &copy;">

    <meta name="twitter:description" content="Golf News & Articles">

    <meta name="twitter:image" content="https://agcgolf.news/images/card/1.png">

    <meta name="twitter:site" content="@africa_golf_cofederation">

    <meta name="twitter:creator" content="@iann_thecreator">


	<link href='http://fonts.googleapis.com/css?family=Lato:300,400,700,900,400italic' rel='stylesheet' type='text/css'>
	<link href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">
	
	<link rel="stylesheet" type="text/css" href="../../css/bootstrap.min.css" media="screen">	
	<link rel="stylesheet" type="text/css" href="../../css/jquery.bxslider.css" media="screen">
	<link rel="stylesheet" type="text/css" href="../../css/font-awesome.css" media="screen">
	<link rel="stylesheet" type="text/css" href="../../css/magnific-popup.css" media="screen">	
	<link rel="stylesheet" type="text/css" href="../../css/owl.carousel.css" media="screen">
    <link rel="stylesheet" type="text/css" href="../../css/owl.theme.css" media="screen">
	<link rel="stylesheet" type="text/css" href="../../css/ticker-style.css"/>
	<link rel="stylesheet" type="text/css" href="../../css/style.css" media="screen">

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="../../css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="../../css/fontawesome/css/all.css" rel="stylesheet">

  <link rel="stylesheet" type="text/css" href="../../css/datatable/dataTable.bootstrap.min.css">

</head>
<body class="boxed">

	<!-- Container -->
	<div id="container">

		<!-- Header
		    ================================================== -->
		<header class="clearfix second-style">
			<!-- Bootstrap navbar -->
			<nav class="navbar navbar-default navbar-static-top" role="navigation">

				<!-- Top line -->
				<div class="top-line">
					<div class="container">
						<div class="row">
							<div class="col-md-9">
								<ul class="top-line-list">
									<li>
										<span class="city-weather"><i class="fa fa-map-marker"></i>&nbsp;&nbsp; Kampala, Uganda</span>
									</li>
									<li><span><i class="fa fa-calendar"></i></span>&nbsp; <span class="time-now" id="time"></span></li>
									<li><a href="../../about-us">About Us</a></li>
									<li><a href="../../contact-us">Contact Us</a></li>
								</ul>
							</div>	
							<div class="col-md-3">
								<ul class="social-icons">
									<li><a class="facebook" href="#"><i class="fab fa-facebook"></i></a></li>
									<li><a class="rss" href="#"><i class="fab fa-instagram"></i></a></li>
									<li><a class="twitter" href="#"><i class="fab fa-x-twitter"></i></a></li>
									<li><a class="google" href="#"><i class="fab fa-youtube"></i></a></li>
									<li><a class="linkedin" href="#"><i class="fab fa-linkedin"></i></a></li>
								</ul>
							</div>	
						</div>
					</div>
				</div>
				<!-- End Top line -->

				<!-- Logo & advertisement -->
				<div class="logo-advertisement">
					<div class="container">

						<!-- Brand and toggle get grouped for better mobile display -->
						<div class="navbar-header">
							<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1">
								<span class="sr-only">Toggle navigation</span>
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
								<span class="icon-bar"></span>
							</button>
							<a class="navbar-brand" href="../../"><img src="../../images/logo/2/2.png" alt="Logo" width="400px"></a>
						</div>

						<div class="advertisement">
							<div class="desktop-advert">
								<span>Advertisement</span>
								<img src="../../images/leaderboard/3.png" alt="">
							</div>
							<div class="tablet-advert">
								<span>Advertisement</span>
								<img src="../../upload/addsense/468x60-white.jpg" alt="">
							</div>
						</div>
					</div>
				</div>
				<!-- End Logo & advertisement -->

				<!-- navbar list container -->
				<div class="nav-list-container">
					<div class="container">
						<!-- Collect the nav links, forms, and other content for toggling -->
						<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
							<ul class="nav navbar-nav navbar-left">

								<li><a class="home" href="../../">Home</a></li>
								<li><a class="home active" href="../">Admin</a></li>
								<li><a class="home" href="../">Posts</a></li>
								<li><a class="home" href="../events">Events</a></li>
								<li><a class="home" href="../golf-courses">Golf Courses</a></li>
								<li><a class="home" href="#!" title="Coming Soon">Inquiries</a></li>

								
							</ul>
							<form class="navbar-form navbar-right" role="search">
								<input type="text" id="search" name="search" placeholder="Search here">
								<button type="submit" id="search-submit"><i class="fa fa-search"></i></button>
							</form>
						</div>
						<!-- /.navbar-collapse -->
					</div>
				</div>
				<!-- End navbar list container -->

			</nav>
			<!-- End Bootstrap navbar -->

		</header>
		<!-- End Header -->

		

		<!-- block-wrapper-section
			================================================== -->
		<section class="block-wrapper">
			<div class="container">
				<div class="row">
					<div class="col-sm-12">

						<!-- block content -->
						<div class="block-content">


							<!-- grid box -->
							<div class="grid-box">
								<div class="title-section">
									<h1><span class="world">Secure Validator</span></h1>
								</div>

									
							<!-- contact form box -->
							<div class="contact-form-box">

								<form id="contact-form" method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" enctype="multipart/form-data">
									<div class="row">

									<div class="col-md-12">
										<div class="col-md-4 <?php echo (!empty($fname_err)) ? 'has-error' : ''; ?>">

                <?php 

                if ($failed == true) {
                     echo '<input class="form-control" type="text" name="fname" value="'.$_SESSION["fname"].'" required>';
                     echo '<span class="help-block">'.$fname_err.'</span>';
                } elseif ($failed != true) {
                    echo '<input class="form-control" type="text" name="fname" placeholder="First Name" required>';
                }

                ?>
                  		

										</div>
									</div>

									<div class="col-md-12">
										<div class="col-md-4 <?php echo (!empty($lname_err)) ? 'has-error' : ''; ?>">

                <?php 

                if ($failed == true) {
                     echo '<input class="form-control" type="text" name="lname" value="'.$_SESSION["lname"].'" required>';
                     echo '<span class="help-block">'.$lname_err.'</span>';
                } elseif ($failed != true) {
                    echo '<input class="form-control" type="text" name="lname" placeholder="Last Name" required>';
                }

                ?>

										</div>
									</div>

									<div class="col-md-12">
										<div class="col-md-4 <?php echo (!empty($access_err)) ? 'has-error' : ''; ?>">

											<input class="form-control" type="text" name="access" placeholder="Access Code">
                  		<span class="help-block"><?php echo $access_err; ?></span>

										</div>
									</div>

                  <input class="form-control" type="hidden" name="token" value="<?php echo $tokens; ?>">

									<div class="col-md-12">
										<div class="col-md-4">
										<button type="submit" name="submit"><i class="fa fa-paper-plane"></i> Validate</button>
										</div>
									</div>

									</div>

								</form>

							</div>
							<!-- End contact form box -->
  



							</div>
							<!-- End grid box -->
							

						</div>
						<!-- End block content -->

					</div>


				</div>

			</div>
		</section>
		<!-- End block-wrapper-section -->

		<!-- footer 
			================================================== -->
		<footer>
			<div class="container">
				<div class="footer-widgets-part">
					<div class="row">
						<div class="col-md-3">
							<div class="widget text-widget">
								<h1>Overview</h1>
								<p>The Africa Golf Confederation (AGC) is responsible for organizing, encouraging, promoting, and developing golf throughout the continent. It comprises 42 affiliated golfing nations and aims to further and advance African golf. </p>
							</div>
							<div class="widget social-widget">
								<h1>Stay Connected</h1>
								<ul class="social-icons">
									<li><a href="https://facebook.com" target="_blank" class="facebook"><i class="fab fa-facebook"></i></a></li>
									<li><a href="https://instagram.com" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a></li>
									<li><a href="https://x.com" target="_blank" class="twitter"><i class="fab fa-x-twitter"></i></a></li>
									<li><a href="https://youtube.com" target="_blank" class="youtube"><i class="fab fa-youtube"></i></a></li>
									<li><a href="https://linkedin.com" target="_blank" class="linkedin"><i class="fab fa-linkedin"></i></a></li>
								</ul>
							</div>
						</div>

						<div class="col-md-3">
							<div class="widget posts-widget">
								<h1>Recent Posts</h1>
								<ul class="list-posts">
									
											
						
        <?php

          $sql = "SELECT * FROM articles WHERE deleted='' ORDER BY id DESC LIMIT 3";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){

										echo '<li>';

											if ($row['image1']) {
													echo '<img src="../../admin/images/'.$row["image1"].'" alt='.$row["title"].' style="height: 70px;object-fit: cover;">'; 
												} elseif ($row['image1']=="") { echo '<img src="../../admin/images/default.png" style="height: 70px;object-fit: cover;">';
											}
											
										echo '<div class="post-content">';

											echo '<a href="../../categories/'.$row["category"].'">'.$row["category"].'</a>';

												echo '<h2><a href="../../story/?q='.$row["url"].'">';
												if (strlen($row['title'])>40) {
													echo ''.substr($row['title'], 0, 40).'..';
												} else {
												echo ''.substr($row['title'], 0, 40).'';
												}
												echo '</a></h2>';

											echo '<ul class="post-tags">';
												echo '<li><i class="fa fa-calendar"></i>'.date("jS M, Y", strtotime($row["timestamp"])).'</li>';
											echo '</ul>';

										echo '</div>';
									echo '</li>';


								}

				?>

								</ul>
							</div>
						</div>

						<div class="col-md-3">
							<div class="widget categories-widget">
								<h1>Hot Categories</h1>

								<ul class="category-list">
																			
        <?php

          $sql = "SELECT DISTINCT(category) FROM articles WHERE deleted='' ORDER BY id DESC";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){

          				echo '<li><a href="../../categories/'.$row["category"].'">'.$row["category"].' <span><i class="fa fa-angle-right"></i></span></a></li>';
           		}
        ?>

        					<li><a href="../../golf-blogs">Articles <span><i class="fa fa-angle-right"></i></span></a></li>


								</ul>
							</div>
						</div>
						<div class="col-md-3">
							<div class="widget flickr-widget">
								<h1>Gallery</h1>
								<ul class="flickr-list">
									
																			
        <?php

          $sql = "SELECT * FROM articles WHERE image2!='' AND deleted='' ORDER BY rand() DESC LIMIT 9";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){

          				echo '<li><a href="../../story/?q='.$row["url"].'"><img src="../../admin/images/'.$row["image2"].'" alt='.$row["title"].' style="width: 100px;height: 75px;object-fit: cover;"></a></li>';
           		}
        ?>

								</ul>
								<a href="../../golf-stories" class="text-underline">View featured posts.<span class="flash">.</span></a>
							</div>
						</div>
					</div>
				</div>
				<div class="footer-last-line">
					<div class="row">
						<div class="col-md-6">
							<p>Africa Golf Confederation &copy; <script>document.write(new Date().getFullYear());</script></p>
						</div>
						<div class="col-md-6">
							<nav class="footer-nav">
								<ul>
									<li><span style="font-size: 8px;">Powered by</span> <a href="https://wa.me/256785196012" style="font-size: 10px;">Custom Assist Inc<span class="flash">.</span></a></li>
								</ul>
							</nav>
						</div>
					</div>
				</div>
			</div>
		</footer>
		<!-- End footer -->

	</div>
	<!-- End Container -->






<!--Session Pop Up Start-->

<div style="position: fixed;top: 80px;left: 5px;z-index: 999;">

    <?php

        if(isset($_SESSION['error'])){
          echo
          "
          <div class='alert' style='color: #fff;border-radius: 4px !important;padding: 5px 15px;background: #158141;'>
            <button class='close' style='color: #fff;opacity: 1;margin-left: 30px;font-weight: normal;'>&times;</button>
            ".$_SESSION['error']."
              </div>
          ";
          unset($_SESSION['error']);
        }
        if(isset($_SESSION['success'])){
          echo
          "
          <div class='alert' style='color: #fff;border-radius: 4px !important;padding: 5px 15px;background: #158141;'>
            <button class='close' style='color: #fff;opacity: 1;margin-left: 30px;font-weight: normal;'>&times;</button>
            ".$_SESSION['success']."
              </div>
          ";
          unset($_SESSION['success']);
        }
  ?>

  </div>

<!--Session Pop Up End-->


	<!-- Live Date and Time -->
	<script>
        function updateTime() {
            const date = new Date();
            const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
            const time = date.toLocaleTimeString();
            const day = date.toLocaleDateString(undefined, options);
            document.getElementById('time').innerHTML =
                `${day} | ${time}`;
        }

        setInterval(updateTime, 1000);
        updateTime();
    </script>
	
	<script type="text/javascript" src="../../js/jquery.min.js"></script>
	<script type="text/javascript" src="../../js/jquery.migrate.js"></script>
	<script type="text/javascript" src="../../js/jquery.bxslider.min.js"></script>
	<script type="text/javascript" src="../../js/jquery.magnific-popup.min.js"></script>
	<script type="text/javascript" src="../../js/bootstrap.min.js"></script>
	<script type="text/javascript" src="../../js/jquery.ticker.js"></script>
	<script type="text/javascript" src="../../js/jquery.imagesloaded.min.js"></script>
  	<script type="text/javascript" src="../../js/jquery.isotope.min.js"></script>
	<script type="text/javascript" src="../../js/owl.carousel.min.js"></script>
	<script type="text/javascript" src="../../js/retina-1.1.0.min.js"></script>
	<script type="text/javascript" src="../../js/script.js"></script>


<script src="../../js/datatable/jquery.dataTables.min.js"></script>
<script src="../../js/datatable/dataTable.bootstrap.min.js"></script>
<!-- generate datatable on our table -->

<!-- Upload Image JS -->
<script src="../../js/upload_img_script.js"></script>

<script>
$(document).ready(function(){
  //inialize datatable
    $('#myTable').DataTable();

    //hide alert
    $(document).on('click', '.close', function(){
      $('.alert').hide();
    })
});
</script>

</body>
</html>