Backdrop is a full-featured content management system that allows non-technical
users to manage a wide variety of content. It can be used to create all kinds of
websites including blogs, image galleries, social networks, intranets, and more.

Backdrop aims to provide:
- A CMS that can be used out-of-the-box.
- Code that can be learned quickly.
- Extensible APIs.

Requirements
------------
- PHP 7.1.0 or higher. Even if Backdrop can run on older versions of PHP, we
  strongly recommend that you use a
  [supported version of PHP](https://secure.php.net/supported-versions.php).
- MySQL 5.5.0 or higher with PDO enabled
- Apache (recommended) or Nginx web server
- 50 MB of disk space (recommended), 15 MB (minimum)

Installation
------------

1. Create a new database, username, and password for Backdrop to use in MySQL.

2. Point your browser at the URL of your Backdrop installation. You will be
   redirected to the install screen. If you're not redirected, visit the install
   URL. If Backdrop was installed at http://example.com/backdrop, the install
   URL would be http://example.com/backdrop/core/install.php.

3. Follow the instructions provided by the installer.

Bug Reports and Feature Requests
--------------------------------
Please use the GitHub
[issue tracker](https://github.com/backdrop/backdrop-issues/issues) for
reporting all bugs and features. We use a separate issue tracker that is not
part of the main Backdrop code repository because of GitHub's restrictions on
the use of labels and issue management.

Security Issues
---------------
If you have discovered a security issue with Backdrop CMS or any of its
[contributed modules](https://github.com/backdrop-contrib/), please contact the
Backdrop Security Team directly at
[security@backdropcms.org](mailto:security@backdropcms.org).
We manage security issues separately in a private repository until the issue has
been resolved. Even if you're not sure if it's a security problem, please
contact the security team before filing an issue.

Developers
----------
Backdrop is a fork of Drupal. It preserves the legacy audience of developers who
value ease of use and speed of learning over architectural flexibility. You can
join Backdrop's developer community by
[forking Backdrop](https://github.com/backdrop/backdrop) on GitHub.

You can submit changes to Backdrop by creating a pull request that references an
issue in the [issue tracker](https://github.com/backdrop/backdrop-issues/issues).
Details about how to do this are in the
[Contribute to Backdrop Core](https://docs.backdropcms.org/documentation/contribute-to-backdrop-core)
documentation.

Thanks to the following companies for providing sponsorship through services and
products which may be used by Backdrop contributors to build and improve the
project:

- [BrowserStack](https://www.browserstack.com) for interface testing across
  desktop and mobile browsers. *(Contact info@backdropcms.org for access
  information.)*
- [JetBrains](https://www.jetbrains.com/phpstorm) for use of the PHPStorm IDE
  for development. *(Contact info@backdropcms.org for a license.)*
- [Fastly](https://fastly.com) for CDN services for all backdropcms.org properties.
- [GitHub](https://github.com) for collaboration and code management tools.
- [Tugboat](https://www.tugboat.qa) for powering our [demo site sandboxes](https://backdropcms.org/demo).
- [ZenCI](https://zen.ci) for continuous automated testing and sandbox testing.
- [Linode](https://linode.com) for web hosting.
- [1Password](https://1password.com) for keeping our passwords safe.
- [SendGrid](https://sendgrid.com) for getting our emails into your inboxes.

User Guide
----------
Please see the [Backdrop Handbook](https://docs.backdropcms.org/documentation/getting-started).

Developer Documentation
-----------------------
Please see the [Backdrop API Documentation](https://docs.backdropcms.org/api/backdrop/groups).

Code of Conduct
---------------
A primary goal of the Backdrop CMS community is to be inclusive to the largest
number of contributors, with the most varied and diverse backgrounds possible.
As such, we are committed to providing a friendly, safe and welcoming
environment for all, regardless of ability, ethnicity, gender, sexual
orientation, sexual preferences, socioeconomic status, geographic location, or
religion (or lack thereof).

Our
[code of conduct](https://github.com/backdrop-ops/conduct/blob/main/code_of_conduct.md)
outlines our expectations for all those who participate in our community, as
well as the consequences for unacceptable behavior.

We invite all those who participate in the Backdrop CMS community to help us
create safe and positive experiences for everyone.

License
-------
Backdrop is [GPL v2](http://www.gnu.org/licenses/gpl-2.0.html) (or higher)
software. See the LICENSE.txt file for complete text. Distributions of this
software may relicense it as any later version of the GPL.

All Backdrop code is Copyright 2001 - 2025 by the original authors.

Backdrop also includes works under different copyright notices that are
distributed according to the terms of the GNU General Public License or a
compatible license. These individual works may have specific copyright
information noted within their source code files or directories.
