(function ($) {

Backdrop.behaviors.menuFieldsetSummaries = {
  attach: function (context) {
    var $context = $(context);
    $context.find('fieldset.menu-link-form').backdropSetSummary(function () {
      if ($context.find('.form-item-menu-enabled input').is(':checked')) {
        return Backdrop.checkPlain($context.find('.form-item-menu-link-title input').val());
      }
      else {
        return Backdrop.t('Not in menu');
      }
    });
  }
};

/**
 * Automatically fill in a menu link title, if possible.
 */
Backdrop.behaviors.menuLinkAutomaticTitle = {
  attach: function (context) {
    $(context).find('fieldset.menu-link-form').each(function () {
      // Try to find menu settings widget elements as well as a 'title' field in
      // the form, but play nicely with user permissions and form alterations.
      var $checkbox = $('.form-item-menu-enabled input', this);
      var $link_title = $('.form-item-menu-link-title input', context);
      var $title = $(this).closest('form').find('.form-item-title input');
      // Bail out if we do not have all required fields.
      if (!($checkbox.length && $link_title.length && $title.length)) {
        return;
      }
      // If there is a link title already, mark it as overridden. The user expects
      // that toggling the checkbox twice will take over the node's title.
      if ($checkbox.is(':checked') && $link_title.val().length) {
        $link_title.data('menuLinkAutomaticTitleOverridden', true);
      }
      // Whenever the value is changed manually, disable this behavior.
      $link_title.on('keyup', function () {
        $link_title.data('menuLinkAutomaticTitleOverridden', true);
      });
      // Global trigger on checkbox (do not fill-in a value when disabled).
      $checkbox.on('change', function () {
        if ($checkbox.is(':checked')) {
          if (!$link_title.data('menuLinkAutomaticTitleOverridden')) {
            $link_title.val($title.val());
          }
        }
        else {
          $link_title.val('');
          $link_title.removeData('menuLinkAutomaticTitleOverridden');
        }
        $checkbox.closest('fieldset.vertical-tabs-pane').trigger('summaryUpdated');
        $checkbox.trigger('formUpdated');
      });
      // Take over any title change.
      $title.on('keyup', function () {
        if (!$link_title.data('menuLinkAutomaticTitleOverridden') && $checkbox.is(':checked')) {
          $link_title.val($title.val());
          $link_title.val($title.val()).trigger('formUpdated');
        }
      });
    });
  }
};

})(jQuery);
