<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Adres e-mail',
            'forget-password-link'   => 'Zapomniałeś hasła?',
            'password'               => 'Hasło',
            'powered-by-description' => 'Napędzane przez :bagisto, projekt open-source autorstwa :webkul.',
            'submit-btn'             => 'Zaloguj się',
            'title'                  => 'Zaloguj się',
        ],

        'forget-password' => [
            'create'    => [
                'email'                  => 'Zarejestrowany adres e-mail',
                'email-not-exist'        => 'E-mail nie istnieje',
                'page-title'             => 'Zapomniałem hasła',
                'powered-by-description' => 'Napędzane przez :bagisto, projekt open-source autorstwa :webkul.',
                'reset-link-sent'        => 'Link do resetowania hasła wysłany',
                'sign-in-link'           => 'Powrót do logowania?',
                'submit-btn'             => 'Resetuj',
                'title'                  => 'Odzyskaj hasło',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Powrót do logowania?',
            'confirm-password'       => 'Potwierdź hasło',
            'email'                  => 'Zarejestrowany adres e-mail',
            'password'               => 'Hasło',
            'powered-by-description' => 'Napędzane przez :bagisto, projekt open-source autorstwa :webkul.',
            'submit-btn'             => 'Zresetuj hasło',
            'title'                  => 'Zresetuj hasło',
        ],
    ],

    'notifications' => [
        'description-text' => 'Wypisz wszystkie powiadomienia',
        'marked-success'   => 'Wszystkie powiadomienia zostały oznaczone jako przeczytane',
        'no-record'        => 'Brak dostępnych powiadomień',
        'of'               => 'z',
        'per-page'         => 'na stronę',
        'read-all'         => 'Oznacz jako przeczytane',
        'title'            => 'Powiadomienia',
        'view-all'         => 'Zobacz wszystkie',

        'order-status-messages' => [
            'all'             => 'Wszystko',
            'canceled'        => 'Zamówienie anulowane',
            'closed'          => 'Zamówienie zamknięte',
            'completed'       => 'Zamówienie zakończone',
            'pending'         => 'Zamówienie w trakcie',
            'pending-payment' => 'Oczekuje na płatność',
            'processing'      => 'Zamówienie w trakcie realizacji',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Powrót',
            'change-password'   => 'Zmień hasło',
            'confirm-password'  => 'Potwierdź hasło',
            'current-password'  => 'Aktualne hasło',
            'email'             => 'Email',
            'general'           => 'Ogólne',
            'invalid-password'  => 'Wprowadzone aktualne hasło jest nieprawidłowe.',
            'name'              => 'Imię',
            'password'          => 'Hasło',
            'profile-image'     => 'Zdjęcie profilowe',
            'save-btn'          => 'Zapisz konto',
            'title'             => 'Moje konto',
            'update-success'    => 'Konto zaktualizowane pomyślnie',
            'upload-image-info' => 'Załaduj zdjęcie profilowe (110px X 110px) w formacie PNG lub JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Dodaj Klienta',
            'add-product'                 => 'Dodaj Produkt',
            'all-channels'                => 'Wszystkie Kanały',
            'attribute-code'              => 'Kod Atrybutu',
            'average-sale'                => 'Średnia Wartość Zamówienia',
            'color'                       => 'Kolor',
            'customer-info'               => 'Nie znaleziono Klienta z Największą Liczbą Zamówień',
            'customer-with-most-sales'    => 'Klient z Największą Liczbą Zamówień',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Próg Pustki',
            'empty-threshold-description' => 'Brak dostępnych produktów',
            'end-date'                    => 'Data Zakończenia',
            'from'                        => 'Od',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Więcej Produktów',
            'order'                       => ':total_orders Zamówienia',
            'order-count'                 => ':count Zamówienia',
            'order-id'                    => '#:id',
            'overall-details'             => 'Ogólne Informacje',
            'pay-by'                      => 'Płatność Przez - :method',
            'product-count'               => ':count Produkty',
            'product-image'               => 'Zdjęcie Produktu',
            'product-info'                => 'Dodaj powiązane produkty w locie.',
            'product-number'              => 'Produkt - :product_number',
            'revenue'                     => 'Dochód :total',
            'sale-count'                  => ':count Sprzedaże',
            'sales'                       => 'Sprzedaże',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Data Rozpoczęcia',
            'stock-threshold'             => 'Próg Stanu Magazynowego',
            'store-stats'                 => 'Statystyki Sklepu',
            'title'                       => 'Panel Sterowania',
            'to'                          => 'Do',
            'today-customers'             => 'Klienci Dziś',
            'today-details'               => 'Szczegóły Dziś',
            'today-orders'                => 'Zamówienia Dziś',
            'today-sales'                 => 'Sprzedaż Dziś',
            'top-performing-categories'   => 'Najlepiej Sprzedające się Kategorie',
            'top-selling-products'        => 'Najlepiej Sprzedające się Produkty',
            'total-customers'             => 'Łącznie Klienci',
            'total-orders'                => 'Łącznie Zamówienia',
            'total-sales'                 => 'Łącznie Sprzedaż',
            'total-stock'                 => ':total_stock Stan Magazynowy',
            'total-unpaid-invoices'       => 'Łącznie Nierozliczone Faktury',
            'unique-visitors'             => ':count Unikalny',
            'user-info'                   => 'Szybkie przeglądanie, co dzieje się w Twoim sklepie',
            'user-name'                   => 'Cześć! :user_name',
            'visitors'                    => 'Gość',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Utwórz Zamówienie',
                'title'      => 'Zamówienia',

                'search-customer' => [
                    'create-btn'  => 'Utwórz Klienta',
                    'empty-info'  => 'Brak dostępnych klientów dla podanego terminu wyszukiwania.',
                    'empty-title' => 'Nie znaleziono klientów',
                    'search-by'   => 'Wyszukaj po adresie e-mail lub imieniu',
                    'title'       => 'Wybierz Klienta',
                ],

                'datagrid' => [
                    'canceled'        => 'Anulowane',
                    'channel-name'    => 'Kanał',
                    'closed'          => 'Zamknięte',
                    'completed'       => 'Zakończone',
                    'customer'        => 'Klient',
                    'date'            => 'Data',
                    'email'           => 'Email',
                    'fraud'           => 'Oszustwo',
                    'grand-total'     => 'Suma Ogólna',
                    'id'              => '#:id',
                    'items'           => 'Produkty',
                    'location'        => 'Lokalizacja',
                    'order-id'        => 'ID Zamówienia',
                    'pay-by'          => 'Płać Przez - :method',
                    'pay-via'         => 'Płać Via',
                    'pending-payment' => 'Oczekująca Płatność',
                    'pending'         => 'Oczekujące',
                    'processing'      => 'W trakcie realizacji',
                    'product-count'   => ':count + Więcej produktów',
                    'status'          => 'Status',
                    'success'         => 'Sukces',
                    'view'            => 'Podgląd',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Dodaj do koszyka',
                'back-btn'                => 'Powrót',
                'check-billing-address'   => 'Brakuje adresu rozliczeniowego.',
                'check-shipping-address'  => 'Brakuje adresu dostawy.',
                'configuration'           => 'Konfiguracja',
                'coupon-already-applied'  => 'Kod kuponu został już zastosowany.',
                'coupon-applied'          => 'Kod kuponu został pomyślnie zastosowany.',
                'coupon-error'            => 'Nie można zastosować kodu kuponu.',
                'coupon-not-found'        => 'Nie znaleziono kodu kuponu',
                'coupon-remove'           => 'Kod kuponu został pomyślnie usunięty.',
                'error'                   => 'Wystąpił błąd',
                'minimum-order-error'     => 'Minimalna wartość zamówienia nie została osiągnięta.',
                'order-placed-success'    => 'Zamówienie zostało pomyślnie złożone.',
                'payment-not-supported'   => 'Ta metoda płatności nie jest obsługiwana',
                'save-btn'                => 'Utwórz zamówienie',
                'specify-payment-method'  => 'Brakuje metody płatności.',
                'specify-shipping-method' => 'Brakuje metody dostawy.',
                'title'                   => 'Utwórz zamówienie dla :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Brak',
                        'total-amount' => 'Całkowita kwota',
                    ],

                    'configurable' => [
                        'select-options' => 'Proszę wybrać opcję',
                    ],

                    'bundle' => [
                        'none'         => 'Brak',
                        'total-amount' => 'Całkowita kwota',
                    ],

                    'grouped' => [
                        'name' => 'Nazwa',
                    ],

                    'downloadable' => [
                        'title' => 'Linki',
                    ],

                    'virtual' => [
                        'none'         => 'Brak',
                        'total-amount' => 'Całkowita kwota',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Produkt został pomyślnie dodany do koszyka',
                    'success-remove'      => 'Element został pomyślnie usunięty z koszyka',
                    'success-update'      => 'Element koszyka został pomyślnie zaktualizowany',

                    'items' => [
                        'add-product'       => 'Dodaj produkt',
                        'amount-per-unit'   => ':amount za jednostkę x :qty ilość',
                        'delete'            => 'Usuń',
                        'empty-description' => 'Brak produktów w koszyku.',
                        'empty-title'       => 'Pusty koszyk',
                        'excl-tax'          => 'Bez podatku VAT',
                        'move-to-wishlist'  => 'Przenieś do listy życzeń',
                        'see-details'       => 'Zobacz szczegóły',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Suma częściowa - :sub_total',
                        'title'             => 'Produkty w koszyku',

                        'search' => [
                            'add-to-cart'   => 'Dodaj do koszyka',
                            'available-qty' => ':qty dostępne',
                            'empty-info'    => 'Brak produktów dostępnych dla podanego terminu wyszukiwania.',
                            'empty-title'   => 'Nie znaleziono produktów',
                            'product-image' => 'Obraz produktu',
                            'qty'           => 'Ilość',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Wyszukiwanie produktów',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Dodaj adres',
                        'add-new'          => 'Dodaj nowy adres',
                        'add-new-address'  => 'Dodaj nowy adres',
                        'addresses'        => 'Adresy',
                        'back'             => 'Powrót',
                        'billing-address'  => 'Adres rozliczeniowy',
                        'city'             => 'Miasto',
                        'company-name'     => 'Nazwa firmy',
                        'confirm'          => 'Potwierdź',
                        'country'          => 'Kraj',
                        'edit-btn'         => 'Edytuj adres',
                        'email'            => 'Email',
                        'first-name'       => 'Imię',
                        'last-name'        => 'Nazwisko',
                        'postcode'         => 'Kod pocztowy',
                        'proceed'          => 'Przejdź dalej',
                        'same-as-billing'  => 'Czy użyć tego samego adresu dla dostawy?',
                        'save'             => 'Zapisz',
                        'save-address'     => 'Zapisz ten adres w książce adresowej',
                        'select-country'   => 'Wybierz kraj',
                        'select-state'     => 'Wybierz stan',
                        'shipping-address' => 'Adres dostawy',
                        'state'            => 'Stan',
                        'street-address'   => 'Adres ulicy',
                        'telephone'        => 'Telefon',
                        'title'            => 'Adres',
                        'vat-id'           => 'NIP',
                    ],

                    'payment' => [
                        'title' => 'Płatność',
                    ],

                    'shipping' => [
                        'title' => 'Dostawa',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Zastosuj kupon',
                        'discount-amount'          => 'Kwota rabatu',
                        'enter-your-code'          => 'Wprowadź swój kod',
                        'grand-total'              => 'Suma ogólna',
                        'place-order'              => 'Złóż zamówienie',
                        'processing'               => 'Przetwarzanie',
                        'shipping-amount-excl-tax' => 'Kwota wysyłki (bez podatku)',
                        'shipping-amount-incl-tax' => 'Kwota wysyłki (z podatkiem)',
                        'shipping-amount'          => 'Kwota wysyłki',
                        'sub-total-excl-tax'       => 'Suma częściowa (bez podatku)',
                        'sub-total-incl-tax'       => 'Suma częściowa (z podatkiem)',
                        'sub-total'                => 'Suma częściowa',
                        'tax'                      => 'Podatek',
                        'title'                    => 'Podsumowanie zamówienia',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Dodaj do koszyka',
                    'delete'            => 'Usuń',
                    'empty-description' => 'Brak produktów w koszyku.',
                    'empty-title'       => 'Pusty koszyk',
                    'excl-tax'          => 'Bez podatku VAT: ',
                    'see-details'       => 'Zobacz szczegóły',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Produkty w koszyku',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Dodaj do koszyka',
                    'empty-description' => 'Brak produktów w twoich ostatnich zamówieniach.',
                    'empty-title'       => 'Puste zamówienia',
                    'see-details'       => 'Zobacz szczegóły',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Produkty z ostatnich zamówień',
                    'view'              => 'Podgląd',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Dodaj do koszyka',
                    'delete'            => 'Usuń',
                    'empty-description' => 'Brak produktów na Twojej liście życzeń.',
                    'empty-title'       => 'Puste elementy na liście życzeń',
                    'see-details'       => 'Zobacz szczegóły',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementy na liście życzeń',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Dodaj do koszyka',
                    'delete'            => 'Usuń',
                    'empty-description' => 'Brak produktów na Twojej liście porównawczej.',
                    'empty-title'       => 'Puste elementy na liście porównawczej',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementy na liście porównawczej',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount na jednostkę x :qty Ilość',
                'billing-address'                => 'Adres rozliczeniowy',
                'cancel'                         => 'Anuluj',
                'cancel-msg'                     => 'Czy na pewno chcesz anulować to zamówienie',
                'cancel-success'                 => 'Zamówienie zostało pomyślnie anulowane',
                'canceled'                       => 'Anulowane',
                'channel'                        => 'Kanał',
                'closed'                         => 'Zamknięte',
                'comment-success'                => 'Komentarz został pomyślnie dodany.',
                'comments'                       => 'Komentarze',
                'completed'                      => 'Zakończone',
                'contact'                        => 'Kontakt',
                'create-success'                 => 'Zamówienie zostało pomyślnie utworzone',
                'currency'                       => 'Waluta',
                'customer'                       => 'Klient',
                'customer-group'                 => 'Grupa klientów',
                'customer-not-notified'          => ':date | Klient <b>Niepowiadomiony</b>',
                'customer-notified'              => ':date | Klient <b>Powiadomiony</b>',
                'discount'                       => 'Rabat - :discount',
                'download-pdf'                   => 'Pobierz PDF',
                'fraud'                          => 'Oszustwo',
                'grand-total'                    => 'Suma - :grand_total',
                'invoice-id'                     => 'Faktura #:invoice',
                'invoices'                       => 'Faktury',
                'item-canceled'                  => 'Anulowane (:qty_canceled)',
                'item-invoice'                   => 'Faktury (:qty_invoiced)',
                'item-ordered'                   => 'Zamówione (:qty_ordered)',
                'item-refunded'                  => 'Zwrócone (:qty_refunded)',
                'item-shipped'                   => 'Wysłane (:qty_shipped)',
                'name'                           => 'Nazwa',
                'no-invoice-found'               => 'Nie znaleziono faktury',
                'no-refund-found'                => 'Nie znaleziono zwrotu',
                'no-shipment-found'              => 'Nie znaleziono przesyłki',
                'notify-customer'                => 'Powiadom klienta',
                'order-date'                     => 'Data zamówienia',
                'order-information'              => 'Informacje o zamówieniu',
                'order-status'                   => 'Status zamówienia',
                'payment-and-shipping'           => 'Płatność i dostawa',
                'payment-method'                 => 'Metoda płatności',
                'pending'                        => 'Oczekujące',
                'pending_payment'                => 'Oczekująca płatność',
                'per-unit'                       => 'Na jednostkę',
                'price'                          => 'Cena - :price',
                'price-excl-tax'                 => 'Cena (bez podatku) - :price',
                'price-incl-tax'                 => 'Cena (z podatkiem) - :price',
                'processing'                     => 'Przetwarzanie',
                'quantity'                       => 'Ilość',
                'refund'                         => 'Zwrot',
                'refund-id'                      => 'Zwrot #:refund',
                'refunded'                       => 'Zwrócone',
                'reorder'                        => 'Zamów ponownie',
                'ship'                           => 'Wysyłka',
                'shipment'                       => 'Przesyłka #:shipment',
                'shipments'                      => 'Przesyłki',
                'shipping-address'               => 'Adres dostawy',
                'shipping-and-handling'          => 'Dostawa i obsługa',
                'shipping-and-handling-excl-tax' => 'Dostawa i obsługa (bez podatku)',
                'shipping-and-handling-incl-tax' => 'Dostawa i obsługa (z podatkiem)',
                'shipping-method'                => 'Metoda dostawy',
                'shipping-price'                 => 'Cena dostawy',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Status',
                'sub-total'                      => 'Suma częściowa - :sub_total',
                'sub-total-excl-tax'             => 'Suma częściowa (bez podatku) - :sub_total',
                'sub-total-incl-tax'             => 'Suma częściowa (z podatkiem) - :sub_total',
                'submit-comment'                 => 'Dodaj komentarz',
                'summary-discount'               => 'Rabat',
                'summary-grand-total'            => 'Suma',
                'summary-sub-total'              => 'Suma częściowa',
                'summary-sub-total-excl-tax'     => 'Suma częściowa (bez podatku)',
                'summary-sub-total-incl-tax'     => 'Suma częściowa (z podatkiem)',
                'summary-tax'                    => 'Podatek',
                'tax'                            => 'Podatek (:percent) - :tax',
                'title'                          => 'Zamówienie #:order_id',
                'total-due'                      => 'Suma należności',
                'total-paid'                     => 'Suma opłacona',
                'total-refund'                   => 'Suma zwrotu',
                'view'                           => 'Wyświetl',
                'write-your-comment'             => 'Napisz swój komentarz',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Wysyłki',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Źródło inwentarza',
                    'order-date'       => 'Data zamówienia',
                    'order-id'         => 'ID zamówienia',
                    'shipment-date'    => 'Data wysyłki',
                    'shipment-to'      => 'Wysyłka do',
                    'total-qty'        => 'Ilość łącznie',
                    'view'             => 'Zobacz',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount Za jednostkę x :qty Ilość',
                'cancel-error'     => 'Nie można anulować zamówienia',
                'carrier-name'     => 'Nazwa przewoźnika',
                'create-btn'       => 'Utwórz przesyłkę',
                'creation-error'   => 'Błąd podczas tworzenia przesyłki',
                'item-canceled'    => 'Anulowane (:qty_canceled)',
                'item-invoice'     => 'Fakturowane (:qty_invoiced)',
                'item-ordered'     => 'Zamówione (:qty_ordered)',
                'item-refunded'    => 'Zwrócone (:qty_refunded)',
                'item-shipped'     => 'Wysłane (:qty_shipped)',
                'order-error'      => 'Przesyłka jest nieprawidłowa',
                'per-unit'         => 'Za jednostkę',
                'qty-available'    => 'Ilość dostępna',
                'qty-to-ship'      => 'Ilość do wysłania',
                'quantity-invalid' => 'Ilość jest nieprawidłowa',
                'sku'              => 'SKU - :sku',
                'source'           => 'Źródło',
                'success'          => 'Przesyłka utworzona pomyślnie',
                'title'            => 'Utwórz nową przesyłkę',
                'tracking-number'  => 'Numer śledzenia',
            ],

            'view' => [
                'billing-address'      => 'Adres rozliczeniowy',
                'carrier-title'        => 'Tytuł przewoźnika',
                'channel'              => 'Kanał',
                'currency'             => 'Waluta',
                'customer'             => 'Klient',
                'email'                => 'Email - :email',
                'inventory-source'     => 'Źródło inwentarza',
                'order-date'           => 'Data zamówienia',
                'order-id'             => 'ID zamówienia',
                'order-information'    => 'Informacje o zamówieniu',
                'order-status'         => 'Status zamówienia',
                'ordered-items'        => 'Zamówione przedmioty',
                'payment-and-shipping' => 'Płatność i dostawa',
                'payment-method'       => 'Metoda płatności',
                'product-image'        => 'Zdjęcie produktu',
                'qty'                  => 'Ilość - :qty',
                'shipping-address'     => 'Adres dostawy',
                'shipping-method'      => 'Metoda dostawy',
                'shipping-price'       => 'Koszt dostawy',
                'sku'                  => 'SKU - :sku ',
                'title'                => 'Przesyłka #:shipment_id',
                'tracking-number'      => 'Numer śledzenia',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Zwroty',

                'datagrid' => [
                    'billed-to'       => 'Rozliczenie na',
                    'id'              => 'ID',
                    'order-id'        => 'ID zamówienia',
                    'refund-date'     => 'Data zwrotu',
                    'refunded-amount' => 'Kwota Zwrócona',
                    'view'            => 'Zobacz',
                ],
            ],

            'view' => [
                'account-information'        => 'Informacje o koncie',
                'adjustment-fee'             => 'Opłata za dostosowanie',
                'adjustment-refund'          => 'Zwrot dostosowania',
                'base-discounted-amount'     => 'Kwota zniżki podstawowej - :base_discounted_amount',
                'billing-address'            => 'Adres rozliczeniowy',
                'currency'                   => 'Waluta',
                'sub-total-amount-excl-tax'  => 'Suma częściowa (bez podatku) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Suma częściowa (z podatkiem) - :discounted_amount',
                'sub-total-amount'           => 'Suma częściowa - :discounted_amount',
                'grand-total'                => 'Suma ogólna',
                'order-channel'              => 'Kanał zamówienia',
                'order-date'                 => 'Data zamówienia',
                'order-id'                   => 'ID zamówienia',
                'order-information'          => 'Informacje o zamówieniu',
                'order-status'               => 'Status zamówienia',
                'payment-information'        => 'Informacje o płatności',
                'payment-method'             => 'Metoda płatności',
                'price-excl-tax'             => 'Cena (bez podatku) - :price',
                'price-incl-tax'             => 'Cena (z podatkiem) - :price',
                'price'                      => 'Cena - :price',
                'product-image'              => 'Zdjęcie produktu',
                'product-ordered'            => 'Zamówione produkty',
                'qty'                        => 'Ilość - :qty',
                'refund'                     => 'Zwrot',
                'shipping-address'           => 'Adres dostawy',
                'shipping-handling-excl-tax' => 'Koszt wysyłki i obsługi (bez podatku)',
                'shipping-handling-incl-tax' => 'Koszt wysyłki i obsługi (z podatkiem)',
                'shipping-handling'          => 'Koszt wysyłki i obsługi',
                'shipping-method'            => 'Metoda dostawy',
                'shipping-price'             => 'Koszt wysyłki',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Suma częściowa (bez podatku)',
                'sub-total-incl-tax'         => 'Suma częściowa (z podatkiem)',
                'sub-total'                  => 'Suma częściowa',
                'tax'                        => 'Podatek',
                'tax-amount'                 => 'Kwota podatku - :tax_amount',
                'title'                      => 'Zwrot #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Opłata za korektę',
                'adjustment-refund'           => 'Korekta zwrotu',
                'amount-per-unit'             => ':amount na jednostkę x :qty Ilość',
                'create-success'              => 'Zwrot został pomyślnie utworzony',
                'creation-error'              => 'Tworzenie zwrotów nie jest dozwolone.',
                'discount-amount'             => 'Kwota zniżki',
                'grand-total'                 => 'Suma ogólna',
                'invalid-qty'                 => 'Znaleziono nieprawidłową ilość przedmiotów do fakturacji.',
                'invalid-refund-amount-error' => 'Kwota zwrotu powinna wynosić co najmniej zero.',
                'item-canceled'               => 'Anulowano (:qty_canceled)',
                'item-invoice'                => 'Fakturacja (:qty_invoiced)',
                'item-ordered'                => 'Zamówiono (:qty_ordered)',
                'item-refunded'               => 'Zwrócono (:qty_refunded)',
                'item-shipped'                => 'Wysłano (:qty_shipped)',
                'per-unit'                    => 'Na jednostkę',
                'price'                       => 'Cena',
                'qty-to-refund'               => 'Ilość do zwrotu',
                'refund-btn'                  => 'Zwrot',
                'refund-limit-error'          => 'Nie można przetworzyć zwrotu w kwocie :amount.',
                'refund-shipping'             => 'Zwrot kosztów dostawy',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Suma częściowa',
                'tax-amount'                  => 'Kwota podatku',
                'title'                       => 'Utwórz zwrot',
                'update-totals-btn'           => 'Aktualizuj sumy',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Faktury',

                'datagrid' => [
                    'action'              => 'Akcje',
                    'days-left'           => 'Pozostało :count dzień/dni',
                    'days-overdue'        => ':count dzień/dni opóźnienia',
                    'grand-total'         => 'Razem',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Data faktury',
                    'mass-update-success' => 'Wybrane faktury zostały pomyślnie zaktualizowane.',
                    'order-id'            => 'ID zamówienia',
                    'overdue'             => 'Zaległe',
                    'overdue-by'          => 'Spóźnione o :count dzień/dni',
                    'paid'                => 'Opłacone',
                    'pending'             => 'Oczekujące',
                    'status'              => 'Status',
                    'update-status'       => 'Zaktualizuj status',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Na Jednostkę x :qty Ilość',
                'channel'                        => 'Kanał',
                'customer-email'                 => 'Email - :email',
                'customer'                       => 'Klient',
                'discount'                       => 'Kwota Zniżki - :discount',
                'email'                          => 'Email',
                'grand-total'                    => 'Suma Ogólna',
                'invoice-items'                  => 'Pozycje Faktury',
                'invoice-sent'                   => 'Faktura wysłana pomyślnie',
                'invoice-status'                 => 'Status Faktury',
                'order-date'                     => 'Data Zamówienia',
                'order-id'                       => 'ID Zamówienia',
                'order-information'              => 'Informacje o Zamówieniu',
                'order-status'                   => 'Status Zamówienia',
                'price-excl-tax'                 => 'Cena (Bez Podatku) - :price',
                'price-incl-tax'                 => 'Cena (Z Podatkiem) - :price',
                'price'                          => 'Cena - :price',
                'print'                          => 'Drukuj',
                'product-image'                  => 'Zdjęcie Produktu',
                'qty'                            => 'Ilość - :qty',
                'send-btn'                       => 'Wyślij',
                'send-duplicate-invoice'         => 'Wyślij Duplikat Faktury',
                'send'                           => 'Wyślij',
                'shipping-and-handling-excl-tax' => 'Koszty Wysyłki i Obsługi (Bez Podatku)',
                'shipping-and-handling-incl-tax' => 'Koszty Wysyłki i Obsługi (Z Podatkiem)',
                'shipping-and-handling'          => 'Koszty Wysyłki i Obsługi',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Suma Częściowa (Bez Podatku) - :sub_total',
                'sub-total-incl-tax'             => 'Suma Częściowa (Z Podatkiem) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Suma Częściowa (Bez Podatku)',
                'sub-total-summary-incl-tax'     => 'Suma Częściowa (Z Podatkiem)',
                'sub-total-summary'              => 'Suma Częściowa',
                'sub-total'                      => 'Suma Częściowa - :sub_total',
                'summary-discount'               => 'Kwota Zniżki',
                'summary-tax'                    => 'Kwota Podatku',
                'tax'                            => 'Kwota Podatku - :tax',
                'title'                          => 'Faktura #:invoice_id',
            ],

            'create'   => [
                'amount-per-unit'    => ':amount Za Jednostkę x :qty Ilość',
                'create-invoice'     => 'Utwórz Fakturę',
                'create-success'     => 'Faktura została pomyślnie utworzona',
                'create-transaction' => 'Utwórz Transakcję',
                'creation-error'     => 'Tworzenie faktury zamówienia jest niedozwolone.',
                'invalid-qty'        => 'Znaleziono nieprawidłową ilość do fakturowania przedmiotów.',
                'invoice'            => 'Faktura',
                'new-invoice'        => 'Nowa Faktura',
                'product-error'      => 'Nie można utworzyć faktury bez produktów.',
                'product-image'      => 'Zdjęcie Produktu',
                'qty-to-invoiced'    => 'Ilość do faktury',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Dane bankowe',
                'bill-to'                    => 'Faktura do',
                'contact-number'             => 'Numer kontaktowy',
                'contact'                    => 'Kontakt',
                'date'                       => 'Data faktury',
                'discount'                   => 'Rabat',
                'excl-tax'                   => 'Bez podatku:',
                'grand-total'                => 'Suma ogólna',
                'invoice-id'                 => 'ID faktury',
                'invoice'                    => 'Faktura',
                'order-date'                 => 'Data zamówienia',
                'order-id'                   => 'ID zamówienia',
                'payment-method'             => 'Metoda płatności',
                'payment-terms'              => 'Warunki płatności',
                'price'                      => 'Cena',
                'product-name'               => 'Nazwa produktu',
                'qty'                        => 'Ilość',
                'ship-to'                    => 'Wysyłka do',
                'shipping-handling-excl-tax' => 'Koszty wysyłki i obsługi (bez podatku)',
                'shipping-handling-incl-tax' => 'Koszty wysyłki i obsługi (z podatkiem)',
                'shipping-handling'          => 'Koszty wysyłki i obsługi',
                'shipping-method'            => 'Metoda wysyłki',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
                'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
                'subtotal'                   => 'Suma częściowa',
                'tax-amount'                 => 'Kwota podatku',
                'tax'                        => 'Podatek',
                'vat-number'                 => 'Numer VAT',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Data transakcji',
            'transaction-id'   => 'ID transakcji',
            'view'             => 'Widok',
        ],

        'transactions' => [
            'index' => [
                'create-btn'  => 'Utwórz transakcję',
                'title'       => 'Transakcje',

                'datagrid' => [
                    'completed'          => 'Ukończone',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID faktury',
                    'order-id'           => 'ID zamówienia',
                    'paid'               => 'Zapłacone',
                    'pending'            => 'Oczekujący',
                    'status'             => 'Status',
                    'transaction-amount' => 'Kwota',
                    'transaction-date'   => 'Data',
                    'transaction-id'     => 'ID transakcji',
                    'view'               => 'Zobacz',
                ],

                'create' => [
                    'already-paid'               => 'Już zapłacone',
                    'amount'                     => 'Kwota',
                    'create-transaction'         => 'Utwórz transakcję',
                    'invoice-id'                 => 'Numer faktury',
                    'invoice-missing'            => 'Brak faktury',
                    'payment-method'             => 'Metoda płatności',
                    'save-transaction'           => 'Zapisz transakcję',
                    'transaction-amount-exceeds' => 'Kwota transakcji przekracza',
                    'transaction-amount-zero'    => 'Kwota transakcji wynosi zero',
                    'transaction-saved'          => 'Transakcja została pomyślnie zapisana.',
                ],

                'view' => [
                    'amount'           => 'Kwota',
                    'created-at'       => 'Utworzono',
                    'invoice-id'       => 'ID Faktury',
                    'order-id'         => 'ID Zamówienia',
                    'payment-details'  => 'Szczegóły Płatności',
                    'payment-method'   => 'Metoda Płatności',
                    'status'           => 'Status',
                    'title'            => 'Szczegóły Transakcji',
                    'transaction-id'   => 'ID Transakcji',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Data utworzenia',
                    'from'         => 'Od',
                    'id'           => 'ID',
                    'order-id'     => 'ID zamówienia',
                    'qty'          => 'Ilość',
                    'to'           => 'Do',
                    'view'         => 'Zobacz',
                ],

                'title'    => 'Rezerwacje',
            ],

            'calendar' => [
                'booking-date'     => 'Data rezerwacji',
                'booking-details'  => 'Szczegóły rezerwacji',
                'canceled'         => 'Anulowane',
                'closed'           => 'Zamknięte',
                'done'             => 'Zakończone',
                'order-id'         => 'ID zamówienia',
                'pending'          => 'Oczekujące',
                'price'            => 'Cena',
                'status'           => 'Status',
                'time-slot'        => 'Przedział czasowy:',
                'view-details'     => 'Zobacz szczegóły',
            ],

            'title' => 'Produkty rezerwacyjne',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => ':name został już zajęty.',
                'create-btn'    => 'Utwórz produkt',
                'title'         => 'Produkty',

                'create' => [
                    'back-btn'                => 'Wróć',
                    'configurable-attributes' => 'Atrybuty konfigurowalne',
                    'create-btn'              => 'Utwórz produkt',
                    'family'                  => 'Rodzina',
                    'save-btn'                => 'Zapisz produkt',
                    'sku'                     => 'SKU',
                    'title'                   => 'Utwórz nowy produkt',
                    'type'                    => 'Typ',
                ],

                'datagrid' => [
                    'active'                 => 'Aktywny',
                    'attribute-family'       => 'Rodzina atrybutów',
                    'attribute-family-value' => 'Rodzina atrybutów - :attribute_family',
                    'category'               => 'Kategoria',
                    'channel'                => 'Kanał',
                    'copy-of'                => 'Kopia :value',
                    'copy-of-slug'           => 'kopia-:value',
                    'delete'                 => 'Usuń',
                    'disable'                => 'Wyłącz',
                    'id'                     => 'Identyfikator',
                    'id-value'               => 'Identyfikator - :id',
                    'image'                  => 'Obraz',
                    'mass-delete-success'    => 'Wybrane produkty usunięte pomyślnie',
                    'mass-update-success'    => 'Wybrane produkty zaktualizowane pomyślnie',
                    'name'                   => 'Nazwa',
                    'out-of-stock'           => 'Brak w magazynie',
                    'price'                  => 'Cena',
                    'product-image'          => 'Obraz produktu',
                    'qty'                    => 'Ilość',
                    'qty-value'              => ':qty dostępny',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Status',
                    'type'                   => 'Typ',
                    'update-status'          => 'Zaktualizuj status',
                ],
            ],

            'edit' => [
                'preview'  => 'Podgląd',
                'remove'   => 'Usuń',
                'save-btn' => 'Zapisz produkt',
                'title'    => 'Edytuj produkt',

                'channels' => [
                    'title' => 'Kanały',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Dodaj cenę dla grupy',
                        'all-groups'                => 'Wszystkie grupy',
                        'create-btn'                => 'Dodaj nową',
                        'discount-group-price-info' => 'Dla ilości :qty w cenie obniżonej o :price',
                        'edit-btn'                  => 'Edytuj',
                        'empty-info'                => 'Specjalne ceny dla klientów należących do określonej grupy.',
                        'fixed-group-price-info'    => 'Dla :qty sztuk w stałej cenie :price',
                        'title'                     => 'Cena dla grupy klientów',

                        'create' => [
                            'all-groups'     => 'Wszystkie grupy',
                            'create-title'   => 'Utwórz cenę dla grupy klientów',
                            'customer-group' => 'Grupa klientów',
                            'delete-btn'     => 'Usuń',
                            'discount'       => 'Rabat',
                            'fixed'          => 'Stała',
                            'price'          => 'Cena',
                            'price-type'     => 'Typ ceny',
                            'qty'            => 'Minimalna ilość',
                            'save-btn'       => 'Zapisz',
                            'update-title'   => 'Aktualizuj cenę dla grupy klientów',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Oczekująca ilość zamówiona: :qty',
                    'pending-ordered-qty-info' => 'Oczekująca ilość zamówienia zostanie odjęta z odpowiedniego źródła magazynu po wysyłce. W przypadku anulowania zamówienia oczekująca ilość będzie dostępna do sprzedaży.',
                    'title'                    => 'Zasoby magazynowe',
                ],

                'categories' => [
                    'title' => 'Kategorie',
                ],

                'images' => [
                    'error' => 'Błąd: :attribute nie może być większy niż :max kilobajtów. Proszę wybrać mniejszy plik.',
                    'info'  => 'A resolução da imagem deve ser de cerca de 560px X 609px',
                    'title' => 'Obrazy',
                ],

                'videos' => [
                    'title' => 'Filmy',
                    'info'  => 'Maksymalny rozmiar filmu powinien wynosić około :size',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Dodaj powiązane produkty w locie.',
                        'info'       => 'Oprócz produktu, który ogląda klient, prezentowane są mu powiązane produkty.',
                        'title'      => 'Powiązane produkty',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Dodaj produkty do sprzedaży w locie.',
                        'info'       => 'Klientowi prezentowane są produkty do sprzedaży krzyżowej, które stanowią alternatywę o wyższej jakości lub jakości premium w stosunku do produktu, który aktualnie ogląda.',
                        'title'      => 'Produkty do sprzedaży krzyżowej',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Dodaj produkty cross-sell w locie.',
                        'info'       => 'Obok koszyka zakupów znajdziesz te produkty typu "impuls zakupowy", które są pozycjonowane jako produkty do sprzedaży krzyżowej, aby uzupełnić towary już dodane do koszyka.',
                        'title'      => 'Produkty do sprzedaży krzyżowej',
                    ],

                    'add-btn'           => 'Dodaj produkt',
                    'delete'            => 'Usuń',
                    'empty-info'        => 'Aby dodać produkty :type, wystarczy to zrobić.',
                    'empty-title'       => 'Dodaj produkt',
                    'image-placeholder' => 'Obraz produktu',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Dodaj opcję',
                            'empty-info'        => 'Aby szybko utworzyć opcje konfigurowalne.',
                            'empty-title'       => 'Dodaj opcję',
                            'info'              => 'To dostosuje prosty produkt.',
                            'title'             => 'Element konfigurowalny',

                            'update-create' => [
                                'is-required'               => 'Wymagane',
                                'max-characters'            => 'Maksymalna liczba znaków',
                                'name'                      => 'Tytuł',
                                'no'                        => 'Nie',
                                'price'                     => 'Cena',
                                'save-btn'                  => 'Zapisz',
                                'supported-file-extensions' => 'Obsługiwane rozszerzenia plików',
                                'title'                     => 'Opcja',
                                'type'                      => 'Typ',
                                'yes'                       => 'Tak',
                            ],

                            'option' => [
                                'add-btn'     => 'Dodaj opcję',
                                'delete'      => 'Usuń',
                                'delete-btn'  => 'Usuń',
                                'edit-btn'    => 'Edytuj',
                                'empty-info'  => 'Aby szybko utworzyć różne kombinacje produktów.',
                                'empty-title' => 'Dodaj opcję',

                                'types' => [
                                    'text' => [
                                        'title' => 'Tekst',
                                    ],

                                    'textarea' => [
                                        'title' => 'Obszar tekstu',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Pole wyboru',
                                    ],

                                    'radio' => [
                                        'title' => 'Radio',
                                    ],

                                    'select' => [
                                        'title' => 'Wybierz',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Wielokrotny wybór',
                                    ],

                                    'date' => [
                                        'title' => 'Data',
                                    ],

                                    'datetime' => [
                                        'title' => 'Data i czas',
                                    ],

                                    'time' => [
                                        'title' => 'Czas',
                                    ],

                                    'file' => [
                                        'title' => 'Plik',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Etykieta',
                                        'price'    => 'Cena',
                                        'save-btn' => 'Zapisz',
                                        'title'    => 'Opcja',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'Produkt jest już powiązany z produktem konfigurowalnym, zgrupowanym lub zestawem.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Dodaj wariant',
                        'delete-btn'        => 'Usuń',
                        'edit-btn'          => 'Edytuj',
                        'empty-info'        => 'Aby tworzyć różne kombinacje produktów, wystarczy to zrobić.',
                        'empty-title'       => 'Dodaj wariant',
                        'image-placeholder' => 'Obraz produktu',
                        'info'              => 'Produkty wariantowe zależą od wszystkich możliwych kombinacji atrybutów.',
                        'qty'               => ':qty szt.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Warianty',

                        'create' => [
                            'description'            => 'Opis',
                            'name'                   => 'Nazwa',
                            'save-btn'               => 'Dodaj',
                            'title'                  => 'Dodaj wariant',
                            'variant-already-exists' => 'Ten wariant już istnieje',
                        ],

                        'edit' => [
                            'disabled'        => 'Wyłączony',
                            'edit-info'       => 'Jeśli chcesz zaktualizować szczegółowe informacje o produkcie, przejdź do',
                            'edit-link-title' => 'Strona szczegółów produktu',
                            'enabled'         => 'Włączony',
                            'images'          => 'Zdjęcia',
                            'name'            => 'Nazwa',
                            'price'           => 'Cena',
                            'quantities'      => 'Ilość',
                            'save-btn'        => 'Zapisz',
                            'sku'             => 'SKU',
                            'status'          => 'Status',
                            'title'           => 'Produkt',
                            'weight'          => 'Waga',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Dodaj obrazy',
                            'apply-to-all-btn'    => 'Zastosuj do wszystkich',
                            'apply-to-all-name'   => 'Zastosuj nazwę do wszystkich wariantów.',
                            'apply-to-all-sku'    => 'Zastosuj cenę do wszystkich SKU.',
                            'apply-to-all-status' => 'Zastosuj status do wszystkich wariantów.',
                            'apply-to-all-weight' => 'Zastosuj wagę do wszystkich wariantów.',
                            'edit-inventories'    => 'Edytuj inwentarze',
                            'edit-names'          => 'Edytuj nazwy',
                            'edit-prices'         => 'Edytuj ceny',
                            'edit-sku'            => 'Edytuj SKU',
                            'edit-status'         => 'Edytuj status',
                            'edit-weight'         => 'Edytuj wagę',
                            'name'                => 'Imię',
                            'price'               => 'Cena',
                            'remove-images'       => 'Usuń obrazy',
                            'remove-variants'     => 'Usuń warianty',
                            'select-action'       => 'Wybierz działanie',
                            'select-variants'     => 'Wybierz warianty',
                            'status'              => 'Status',
                            'variant-name'        => 'Nazwa wariantu',
                            'variant-sku'         => 'SKU wariantu',
                            'weight'              => 'Waga',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Dodaj produkt',
                        'default-qty'       => 'Domyślna ilość',
                        'delete'            => 'Usuń',
                        'empty-info'        => 'Aby tworzyć różne kombinacje produktów, wystarczy to zrobić.',
                        'empty-title'       => 'Dodaj produkt',
                        'image-placeholder' => 'Obraz produktu',
                        'info'              => 'Produkt grupowy składa się z samodzielnych pozycji prezentowanych jako zestaw, umożliwiający zmiany lub koordynację ze względu na sezon lub motyw. Każdy produkt można kupić indywidualnie lub jako część grupy.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Produkty grupowe',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Dodaj opcję',
                        'empty-info'        => 'Aby tworzyć opcje pakietu, wystarczy to zrobić.',
                        'empty-title'       => 'Dodaj opcję',
                        'image-placeholder' => 'Obraz produktu',
                        'info'              => 'Produkt wiązany to zestaw wielu produktów lub usług sprzedawanych razem w specjalnej cenie, zapewniający wartość i wygodę klientom.',
                        'title'             => 'Pozycje pakietu',

                        'update-create' => [
                            'checkbox'    => 'Pole wyboru',
                            'is-required' => 'Wymagane',
                            'multiselect' => 'Wielokrotny wybór',
                            'name'        => 'Tytuł',
                            'no'          => 'Nie',
                            'radio'       => 'Przycisk wyboru',
                            'save-btn'    => 'Zapisz',
                            'select'      => 'Wybór',
                            'title'       => 'Opcja',
                            'type'        => 'Typ',
                            'yes'         => 'Tak',
                        ],

                        'option' => [
                            'add-btn'     => 'Dodaj produkt',
                            'default-qty' => 'Domyślna ilość',
                            'delete'      => 'Usuń',
                            'delete-btn'  => 'Usuń',
                            'edit-btn'    => 'Edytuj',
                            'empty-info'  => 'Aby tworzyć różne kombinacje produktów, wystarczy to zrobić.',
                            'empty-title' => 'Dodaj produkt',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Ustaw domyślny produkt za pomocą pola wyboru',
                                    'title' => 'Pole wyboru',
                                ],

                                'multiselect' => [
                                    'info'  => 'Ustaw domyślny produkt za pomocą przycisku wyboru wielokrotnego',
                                    'title' => 'Wielokrotny wybór',
                                ],

                                'radio' => [
                                    'info'  => 'Ustaw domyślny produkt za pomocą przycisku wyboru',
                                    'title' => 'Przycisk wyboru',
                                ],

                                'select' => [
                                    'info'  => 'Ustaw domyślny produkt za pomocą przycisku wyboru',
                                    'title' => 'Wybór',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Dostępne od',
                        'available-to'   => 'Dostępne do',
                        'location'       => 'Lokalizacja',
                        'qty'            => 'Ilość',
                        'title'          => 'Typ rezerwacji',

                        'available-every-week' => [
                            'no'    => 'Nie',
                            'title' => 'Dostępne co tydzień',
                            'yes'   => 'Tak',
                        ],

                        'appointment' => [
                            'break-duration' => 'Czas przerwy między slotami (minuty)',
                            'slot-duration'  => 'Czas trwania slotu (minuty)',

                            'same-slot-for-all-days' => [
                                'no'    => 'Nie',
                                'title' => 'Ten sam slot na wszystkie dni',
                                'yes'   => 'Tak',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Dodaj',
                            'break-duration'   => 'Czas przerwy między slotami (minuty)',
                            'close'            => 'Zamknij',
                            'description'      => 'Informacje o rezerwacji',
                            'description-info' => 'Czas trwania zostanie utworzony i wyświetlony zgodnie ze slotami. Będzie unikalny dla wszystkich slotów i widoczny na witrynie sklepowej',
                            'edit'             => 'Edytuj',
                            'many'             => 'Wiele rezerwacji na jeden dzień',
                            'one'              => 'Jedna rezerwacja na wiele dni',
                            'open'             => 'Otwórz',
                            'slot-add'         => 'Dodaj sloty',
                            'slot-duration'    => 'Czas trwania slotu (minuty)',
                            'slot-title'       => 'Czas trwania slotów',
                            'title'            => 'Domyślny',
                            'unavailable'      => 'Niedostępne',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Dodaj sloty',
                                    'close'      => 'Zamknij',
                                    'day'        => 'Dzień',
                                    'edit-title' => 'Edytuj sloty',
                                    'friday'     => 'Piątek',
                                    'from'       => 'Od',
                                    'from-day'   => 'Od dnia',
                                    'from-time'  => 'Od godziny',
                                    'monday'     => 'Poniedziałek',
                                    'open'       => 'Otwórz',
                                    'saturday'   => 'Sobota',
                                    'save'       => 'Zapisz',
                                    'select'     => 'Wybierz',
                                    'status'     => 'Status',
                                    'sunday'     => 'Niedziela',
                                    'thursday'   => 'Czwartek',
                                    'to'         => 'Do',
                                    'to-day'     => 'Do dnia',
                                    'to-time'    => 'Do godziny',
                                    'tuesday'    => 'Wtorek',
                                    'wednesday'  => 'Środa',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Dodaj bilety',
                            'delete'             => 'Usuń',
                            'description'        => 'Opis',
                            'description-info'   => 'Brak dostępnych biletów.',
                            'edit'               => 'Edytuj',
                            'name'               => 'Nazwa',
                            'price'              => 'Cena',
                            'qty'                => 'Ilość',
                            'special-price'      => 'Cena specjalna',
                            'special-price-from' => 'Cena specjalna od',
                            'special-price-to'   => 'Cena specjalna do',
                            'title'              => 'Bilety',
                            'valid-from'         => 'Ważne od',
                            'valid-until'        => 'Ważne do',

                            'modal'              => [
                                'edit' => 'Edytuj bilety',
                                'save' => 'Zapisz',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Dodaj bilety',
                            ],

                            'slots'   => [
                                'add'         => 'Dodaj sloty',
                                'description' => 'Dostępne sloty z czasem trwania.',
                            ],
                        ],

                        'rental' => [
                            'daily'                  => 'Na dzień',
                            'daily-hourly'           => 'Oba (na dzień i na godzinę)',
                            'daily-price'            => 'Cena dzienna',
                            'hourly'                 => 'Na godzinę',
                            'hourly-price'           => 'Cena godzinowa',
                            'title'                  => 'Typ wynajmu',

                            'same-slot-for-all-days' => [
                                'no'    => 'Nie',
                                'title' => 'Ten sam slot na wszystkie dni',
                                'yes'   => 'Tak',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Dodaj sloty',
                            'description-info' => 'Czas trwania zostanie utworzony i wyświetlony zgodnie ze slotami. Będzie unikalny dla wszystkich slotów i widoczny na witrynie sklepowej',
                            'save'             => 'Zapisz',
                            'title'            => 'Czas trwania slotów',
                            'unavailable'      => 'Niedostępne',

                            'action'           => [
                                'add' => 'Dodaj',
                            ],

                            'modal'            => [
                                'slot' => [
                                    'friday'     => 'Piątek',
                                    'from'       => 'Od',
                                    'monday'     => 'Poniedziałek',
                                    'saturday'   => 'Sobota',
                                    'sunday'     => 'Niedziela',
                                    'thursday'   => 'Czwartek',
                                    'to'         => 'Do',
                                    'tuesday'    => 'Wtorek',
                                    'wednesday'  => 'Środa',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Czas przerwy między slotami (minuty)',
                            'guest-capacity'            => 'Pojemność gości',
                            'guest-limit'               => 'Limit gości na stół',
                            'prevent-scheduling-before' => 'Zapobiegaj planowaniu przed',
                            'slot-duration'             => 'Czas trwania slotu (minuty)',

                            'charged-per'               => [
                                'guest'  => 'Gość',
                                'table'  => 'Stół',
                                'title'  => 'Opłata za',
                            ],

                            'same-slot-for-all-days'    => [
                                'no'    => 'Nie',
                                'title' => 'Ten sam slot na wszystkie dni',
                                'yes'   => 'Tak',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Rezerwacja wizyty',
                            'default'     => 'Domyślna rezerwacja',
                            'event'       => 'Rezerwacja wydarzenia',
                            'many'        => 'Wiele',
                            'one'         => 'Jedna',
                            'rental'      => 'Rezerwacja wynajmu',
                            'table'       => 'Rezerwacja stołu',
                            'title'       => 'Typ',
                        ],

                        'validations' => [
                            'type-mismatch'      => 'Nie można zmienić typu rezerwacji.',
                            'time-validation'    => 'Czas rozpoczęcia musi być wcześniejszy niż czas zakończenia.',
                            'overlap-validation' => 'Przedział czasowy nakłada się na istniejący przedział.',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Dodaj odnośnik',
                            'delete-btn'  => 'Usuń',
                            'edit-btn'    => 'Edytuj',
                            'empty-info'  => 'Aby utworzyć odnośnik w locie.',
                            'empty-title' => 'Dodaj odnośnik',
                            'file'        => 'Plik: ',
                            'info'        => 'Typ produktu do pobrania umożliwia sprzedaż produktów cyfrowych, takich jak e-booki, aplikacje komputerowe, muzyka, gry itp.',
                            'sample-file' => 'Plik próbki: ',
                            'sample-url'  => 'Adres URL próbki: ',
                            'title'       => 'Odnośniki do pobrania',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'downloads'   => 'Dozwolone pobieranie',
                                'file'        => 'Plik',
                                'file-type'   => 'Typ pliku',
                                'name'        => 'Tytuł',
                                'price'       => 'Cena',
                                'sample'      => 'Próbka',
                                'sample-type' => 'Typ próbki',
                                'save-btn'    => 'Zapisz',
                                'title'       => 'Odnośnik',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Dodaj próbkę',
                            'delete-btn'  => 'Usuń',
                            'edit-btn'    => 'Edytuj',
                            'empty-info'  => 'Aby utworzyć próbkę w locie.',
                            'empty-title' => 'Dodaj próbkę',
                            'file'        => 'Plik: ',
                            'info'        => 'Typ produktu do pobrania umożliwia sprzedaż produktów cyfrowych, takich jak e-booki, aplikacje komputerowe, muzyka, gry itp.',
                            'title'       => 'Próbki do pobrania',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'file'        => 'Plik',
                                'file-type'   => 'Typ pliku',
                                'name'        => 'Tytuł',
                                'save-btn'    => 'Zapisz',
                                'title'       => 'Odnośnik',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Produkt został pomyślnie utworzony',
            'delete-failed'           => 'Nie udało się usunąć produktu',
            'delete-success'          => 'Produkt został pomyślnie usunięty',
            'product-copied'          => 'Produkt został pomyślnie skopiowany',
            'saved-inventory-message' => 'Produkt został pomyślnie zapisany',
            'update-success'          => 'Produkt został pomyślnie zaktualizowany',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Utwórz Atrybuty',
                'title'      => 'Atrybuty',

                'datagrid' => [
                    'boolean'             => 'Boolean',
                    'channel-based'       => 'Channel Based',
                    'checkbox'            => 'Checkbox',
                    'code'                => 'Code',
                    'created-at'          => 'Created At',
                    'date'                => 'Date',
                    'date-time'           => 'Date Time',
                    'delete'              => 'Delete',
                    'edit'                => 'Edit',
                    'false'               => 'Fałsz',
                    'file'                => 'File',
                    'id'                  => 'ID',
                    'image'               => 'Image',
                    'locale-based'        => 'Locale Based',
                    'mass-delete-success' => 'Selected Attribute Deleted Successfully',
                    'multiselect'         => 'Multiselect',
                    'name'                => 'Name',
                    'price'               => 'Price',
                    'required'            => 'Required',
                    'select'              => 'Select',
                    'text'                => 'Text',
                    'textarea'            => 'Textarea',
                    'true'                => 'Prawda',
                    'type'                => 'Type',
                    'unique'              => 'Unique',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Dodaj Opcje Atrybutu',
                'add-option'            => 'Dodaj Opcję',
                'add-options-info'      => 'Aby tworzyć różne kombinacje opcji atrybutów.',
                'add-row'               => 'Dodaj Wiersz',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nazwa Admina',
                'back-btn'              => 'Powrót',
                'boolean'               => 'Boolean',
                'checkbox'              => 'Pole Wyboru (Checkbox)',
                'code'                  => 'Kod Atrybutu',
                'color'                 => 'Kolor',
                'configuration'         => 'Konfiguracja',
                'create-empty-option'   => 'Utwórz domyślną pustą opcję',
                'date'                  => 'Data',
                'datetime'              => 'Data i Godzina',
                'decimal'               => 'Liczba Ułamkowa',
                'default-value'         => 'Wartość domyślna',
                'email'                 => 'Adres Email',
                'enable-wysiwyg'        => 'Włącz Edytor WYSIWYG',
                'file'                  => 'Plik',
                'general'               => 'Ogólne',
                'image'                 => 'Obraz',
                'input-options'         => 'Opcje Wejścia',
                'input-validation'      => 'Walidacja Wejścia',
                'is-comparable'         => 'Atrybut Porównywalny',
                'is-configurable'       => 'Użyj do Tworzenia Produktu Konfigurowalnego',
                'is-filterable'         => 'Użyj w Nawigacji Warstwowej',
                'is-required'           => 'Wymagane',
                'is-unique'             => 'Unikalny',
                'is-visible-on-front'   => 'Widoczny na Stronie Produktu na Front-endzie',
                'label'                 => 'Etykieta',
                'multiselect'           => 'Wielokrotny Wybór',
                'no'                    => 'Nie',
                'numeric'               => 'Liczba',
                'option-deleted'        => 'Opcja usunięta pomyślnie',
                'options'               => 'Opcje',
                'position'              => 'Pozycja',
                'price'                 => 'Cena',
                'regex'                 => 'Wyrażenie Regularne',
                'regex-info'            => 'Wyrażenie powinno być w podwójnych cudzysłowach.',
                'save-btn'              => 'Zapisz Atrybut',
                'select'                => 'Wybór',
                'select-type'           => 'Wybierz Typ Atrybutu',
                'swatch'                => 'Próbka Kolorów',
                'text'                  => 'Tekst',
                'textarea'              => 'Pole Tekstowe',
                'title'                 => 'Dodaj Atrybut',
                'type'                  => 'Typ Atrybutu',
                'url'                   => 'URL',
                'use-in-flat'           => 'Utwórz w Tabeli Produktów Płaskich',
                'validations'           => 'Walidacje',
                'value-per-channel'     => 'Wartość Na Kanał',
                'value-per-locale'      => 'Wartość Na Lokalizację',
                'yes'                   => 'Tak',

                'option' => [
                    'color'    => 'Próbka Kolorów',
                    'dropdown' => 'Rozwijane Menu',
                    'image'    => 'Próbka Obrazu',
                    'save-btn' => 'Zapisz Opcję',
                    'text'     => 'Tekstowa Próbka Kolorów',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Dodaj Opcje Atrybutu',
                'add-option'            => 'Dodaj Opcję',
                'add-options-info'      => 'Aby tworzyć różne kombinacje Opcji Atrybutu na raz.',
                'add-row'               => 'Dodaj Wiersz',
                'admin'                 => 'Administrator',
                'admin-name'            => 'Nazwa Administratora',
                'back-btn'              => 'Powrót',
                'boolean'               => 'Boolean',
                'checkbox'              => 'Pole Wyboru',
                'code'                  => 'Kod Atrybutu',
                'color'                 => 'Kolor',
                'configuration'         => 'Konfiguracja',
                'create-empty-option'   => 'Utwórz domyślną pustą opcję',
                'date'                  => 'Data',
                'datetime'              => 'Data i Czas',
                'decimal'               => 'Liczba Zmiennoprzecinkowa',
                'default-value'         => 'Wartość domyślna',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Włącz Edytor WYSIWYG',
                'file'                  => 'Plik',
                'general'               => 'Ogólne',
                'image'                 => 'Obraz',
                'input-options'         => 'Opcje Wejścia',
                'input-validation'      => 'Walidacja Wejścia',
                'is-comparable'         => 'Atrybut jest porównywalny',
                'is-configurable'       => 'Użyj do Tworzenia Produktów Konfigurowalnych',
                'is-filterable'         => 'Użyj w Nawigacji Warstwowej',
                'is-required'           => 'Wymagane',
                'is-unique'             => 'Unikalny',
                'is-visible-on-front'   => 'Widoczny na Stronie Produktu na Stronie Front-end',
                'label'                 => 'Etykieta',
                'multiselect'           => 'Wielokrotny Wybór',
                'no'                    => 'Nie',
                'numeric'               => 'Liczba',
                'option-deleted'        => 'Opcja usunięta pomyślnie',
                'options'               => 'Opcje',
                'position'              => 'Pozycja',
                'price'                 => 'Cena',
                'regex'                 => 'Wyrażenie Regularne',
                'regex-info'            => 'Wyrażenie powinno być w podwójnych cudzysłowach.',
                'save-btn'              => 'Zapisz Atrybut',
                'select'                => 'Wybierz',
                'select-type'           => 'Wybierz Rodzaj Atrybutu',
                'swatch'                => 'Swatch',
                'text'                  => 'Tekst',
                'textarea'              => 'Pole Tekstowe',
                'title'                 => 'Edycja Atrybutu',
                'type'                  => 'Rodzaj Atrybutu',
                'url'                   => 'URL',
                'use-in-flat'           => 'Utwórz w Tabeli Produktów',
                'validations'           => 'Walidacje',
                'value-per-channel'     => 'Wartość na Kanał',
                'value-per-locale'      => 'Wartość na Lokalizację',
                'yes'                   => 'Tak',

                'option' => [
                    'color'    => 'Kolor Swatch',
                    'dropdown' => 'Rozwijane Menu',
                    'image'    => 'Obraz Swatch',
                    'save-btn' => 'Zapisz Opcję',
                    'text'     => 'Tekst Swatch',
                ],
            ],

            'create-success'    => 'Atrybut Utworzony Pomyślnie',
            'delete-failed'     => 'Usuwanie Atrybutu Nie Powiodło Się',
            'delete-success'    => 'Atrybut Usunięty Pomyślnie',
            'update-success'    => 'Atrybut Zaktualizowany Pomyślnie',
            'user-define-error' => 'Nie można usunąć Atrybutu Systemowego',
        ],

        'categories'  => [
            'index' => [
                'add-btn' => 'Utwórz Kategorię',
                'title'   => 'Kategorie',

                'datagrid' => [
                    'active'         => 'Aktywna',
                    'delete'         => 'Usuń',
                    'delete-success' => 'Wybrane :resource zostały pomyślnie usunięte',
                    'edit'           => 'Edytuj',
                    'id'             => 'ID',
                    'inactive'       => 'Nieaktywna',
                    'name'           => 'Nazwa',
                    'no-of-products' => 'Liczba Produktów',
                    'position'       => 'Pozycja',
                    'status'         => 'Widoczne w menu',
                    'update-status'  => 'Aktualizuj Status',
                ],
            ],

            'create' => [
                'add-banner'               => 'Dodaj Baner',
                'add-logo'                 => 'Dodaj Logo',
                'back-btn'                 => 'Powrót',
                'banner'                   => 'Baner',
                'banner-size'              => 'Proporcje banera (1320px X 300px)',
                'description'              => 'Opis',
                'description-and-images'   => 'Opis i Obrazy',
                'description-only'         => 'Tylko Opis',
                'display-mode'             => 'Tryb Wyświetlania',
                'enter-position'           => 'Wprowadź Pozycję',
                'filterable-attributes'    => 'Atrybuty Filtrujące',
                'general'                  => 'Ogólne',
                'logo'                     => 'Logo',
                'logo-size'                => 'Rozdzielczość loga powinna wynosić (110px X 110px)',
                'meta-description'         => 'Meta Opis',
                'meta-keywords'            => 'Meta Słowa Kluczowe',
                'meta-title'               => 'Meta Tytuł',
                'name'                     => 'Nazwa',
                'parent-category'          => 'Kategoria Nadrzędna',
                'position'                 => 'Pozycja',
                'products-and-description' => 'Produkty i Opis',
                'products-only'            => 'Tylko Produkty',
                'save-btn'                 => 'Zapisz Kategorię',
                'select-display-mode'      => 'Wybierz Tryb Wyświetlania',
                'seo-details'              => 'Szczegóły SEO',
                'settings'                 => 'Ustawienia',
                'slug'                     => 'Przyjazny URL',
                'title'                    => 'Dodaj Nową Kategorię',
                'visible-in-menu'          => 'Widoczna w Menu',
            ],

            'edit' => [
                'add-banner'               => 'Dodaj Baner',
                'add-logo'                 => 'Dodaj Logo',
                'back-btn'                 => 'Powrót',
                'banner'                   => 'Baner',
                'banner-size'              => 'Proporcje banera (1320px X 300px)',
                'description'              => 'Opis',
                'description-and-images'   => 'Opis i Obrazy',
                'description-only'         => 'Tylko Opis',
                'display-mode'             => 'Tryb Wyświetlania',
                'enter-position'           => 'Wprowadź Pozycję',
                'filterable-attributes'    => 'Atrybuty Filtrujące',
                'general'                  => 'Ogólne',
                'logo'                     => 'Logo',
                'logo-size'                => 'Rozdzielczość loga powinna wynosić (110px X 110px)',
                'meta-description'         => 'Meta Opis',
                'meta-keywords'            => 'Meta Słowa Kluczowe',
                'meta-title'               => 'Meta Tytuł',
                'name'                     => 'Nazwa',
                'position'                 => 'Pozycja*',
                'products-and-description' => 'Produkty i Opis',
                'products-only'            => 'Tylko Produkty',
                'save-btn'                 => 'Zapisz Kategorię',
                'select-display-mode'      => 'Wybierz Tryb Wyświetlania',
                'select-parent-category'   => 'Wybierz Kategorię Nadrzędną*',
                'seo-details'              => 'Szczegóły SEO',
                'settings'                 => 'Ustawienia',
                'slug'                     => 'Przyjazny URL',
                'title'                    => 'Edytuj Kategorię',
                'visible-in-menu'          => 'Widoczna w Menu',
            ],

            'category'             => 'Kategoria',
            'create-success'       => 'Kategoria została pomyślnie utworzona.',
            'delete-category-root' => 'Kategoria główna nie może zostać usunięta.',
            'delete-failed'        => 'Wystąpił błąd podczas usuwania kategorii',
            'delete-success'       => 'Kategoria została pomyślnie usunięta.',
            'update-success'       => 'Kategoria została pomyślnie zaktualizowana.',
        ],

        'families' => [
            'index' => [
                'add'   => 'Utwórz Rodzinę Atrybutów',
                'title' => 'Rodziny Atrybutów',

                'datagrid' => [
                    'code'           => 'Kod',
                    'delete'         => 'Usuń',
                    'delete-success' => 'Wybrane :resource zostały pomyślnie usunięte',
                    'edit'           => 'Edytuj',
                    'id'             => 'ID',
                    'method-error'   => 'Błąd! Wykryto niepoprawną metodę, proszę sprawdzić konfigurację masowych działań',
                    'name'           => 'Nazwa',
                    'no-resource'    => 'Zasób dostarczony jest niewystarczający dla danej operacji',
                    'partial-action' => 'Niektóre akcje nie zostały wykonane z powodu ograniczeń systemowych dotyczących :resource',
                    'update-success' => 'Wybrane :resource zostały pomyślnie zaktualizowane',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Dodaj Grupę',
                'add-group-title'                  => 'Dodaj Nową Grupę',
                'back-btn'                         => 'Powrót',
                'code'                             => 'Kod',
                'column'                           => 'Kolumna',
                'delete-group-btn'                 => 'Usuń Grupę',
                'edit-group-info'                  => 'Podwójne kliknięcie, aby edytować Grupę',
                'enter-code'                       => 'Wprowadź Kod',
                'enter-name'                       => 'Wprowadź Nazwę',
                'general'                          => 'Ogólne',
                'group-code-already-exists'        => 'Kod grupy atrybutów już istnieje.',
                'group-contains-system-attributes' => 'Ta grupa zawiera atrybuty systemowe. Przenieś najpierw atrybuty systemowe do innej grupy i spróbuj ponownie.',
                'group-name-already-exists'        => 'Nazwa grupy atrybutów już istnieje.',
                'groups'                           => 'Grupy',
                'groups-info'                      => 'Zarządzaj grupami rodziny atrybutów',
                'main-column'                      => 'Kolumna Główna',
                'name'                             => 'Nazwa',
                'removal-not-possible'             => 'Nie możesz usunąć atrybutów systemowych z rodziny atrybutów.',
                'right-column'                     => 'Prawa Kolumna',
                'save-btn'                         => 'Zapisz Rodzinę Atrybutów',
                'select-group'                     => 'Proszę wybrać grupę atrybutów.',
                'title'                            => 'Utwórz Rodzinę Atrybutów',
                'unassigned-attributes'            => 'Niezprypisane Atrybuty',
                'unassigned-attributes-info'       => 'Przeciągnij te atrybuty, aby dodać je do kolumn lub grup.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Dodaj Grupę',
                'add-group-title'                  => 'Dodaj Nową Grupę',
                'back-btn'                         => 'Powrót',
                'code'                             => 'Kod',
                'column'                           => 'Kolumna',
                'delete-group-btn'                 => 'Usuń Grupę',
                'edit-group-info'                  => 'Podwójne kliknięcie, aby edytować Grupę',
                'enter-code'                       => 'Wprowadź Kod',
                'enter-name'                       => 'Wprowadź Nazwę',
                'general'                          => 'Ogólne',
                'group-code-already-exists'        => 'Kod grupy atrybutów już istnieje.',
                'group-contains-system-attributes' => 'Ta grupa zawiera atrybuty systemowe. Przenieś najpierw atrybuty systemowe do innej grupy i spróbuj ponownie.',
                'group-name-already-exists'        => 'Nazwa grupy atrybutów już istnieje.',
                'groups'                           => 'Grupy',
                'groups-info'                      => 'Zarządzaj grupami rodziny atrybutów',
                'main-column'                      => 'Kolumna Główna',
                'name'                             => 'Nazwa',
                'removal-not-possible'             => 'Nie możesz usunąć atrybutów systemowych z rodziny atrybutów.',
                'right-column'                     => 'Prawa Kolumna',
                'save-btn'                         => 'Zapisz Rodzinę Atrybutów',
                'select-group'                     => 'Proszę wybrać grupę atrybutów.',
                'title'                            => 'Edytuj Rodzinę Atrybutów',
                'unassigned-attributes'            => 'Niezprypisane Atrybuty',
                'unassigned-attributes-info'       => 'Przeciągnij te atrybuty, aby dodać je do kolumn lub grup.',
            ],

            'attribute-family'        => 'Rodzina Atrybutów',
            'attribute-product-error' => 'Rodzina atrybutów jest używana w produktach.',
            'create-success'          => 'Rodzina Atrybutów została pomyślnie utworzona.',
            'delete-failed'           => 'Wystąpił błąd podczas usuwania Rodziny Atrybutów.',
            'delete-success'          => 'Rodzina Atrybutów została pomyślnie usunięta.',
            'family'                  => 'Rodzina Atrybutów',
            'last-delete-error'       => 'Wymagana jest co najmniej jedna rodzina atrybutów.',
            'update-success'          => 'Rodzina Atrybutów została pomyślnie zaktualizowana.',
            'user-define-error'       => 'Nie można usunąć Rodziny Atrybutów systemowych.',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Klienci',
                'login-message' => 'Zalogowano jako: :customer_name',

                'datagrid' => [
                    'active'         => 'Aktywny',
                    'address'        => ':address Adres(y)',
                    'address-count'  => 'Liczba adresów',
                    'channel'        => 'Kanał',
                    'delete'         => 'Usuń',
                    'delete-success' => 'Wybrane dane zostały pomyślnie usunięte',
                    'email'          => 'E-mail',
                    'gender'         => 'Płeć',
                    'group'          => 'Grupa',
                    'id'             => 'ID klienta',
                    'id-value'       => 'Identyfikator - :id',
                    'inactive'       => 'Nieaktywny',
                    'method-error'   => 'Błąd! Wykryto błędną metodę, sprawdź konfigurację masowej akcji',
                    'name'           => 'Nazwa klienta',
                    'no-resource'    => 'Dostarczone zasoby są niewystarczające dla tej akcji',
                    'order'          => ':order Zamówienie(a)',
                    'order-count'    => 'Liczba zamówień',
                    'order-pending'  => 'Klient ma oczekujące zamówienie',
                    'partial-action' => 'Niektóre akcje nie zostały wykonane ze względu na ograniczenia systemowe dotyczące :resource',
                    'phone'          => 'Numer kontaktowy',
                    'revenue'        => 'Dochód',
                    'status'         => 'Status',
                    'suspended'      => 'Zawieszony',
                    'update-status'  => 'Aktualizuj status',
                    'update-success' => 'Wybrane dane klientów zostały pomyślnie zaktualizowane',
                ],

                'create' => [
                    'contact-number'        => 'Numer kontaktowy',
                    'create-btn'            => 'Utwórz klienta',
                    'create-success'        => 'Klient został pomyślnie utworzony',
                    'customer-group'        => 'Grupa klienta',
                    'date-of-birth'         => 'Data urodzenia',
                    'email'                 => 'E-mail',
                    'female'                => 'Kobieta',
                    'first-name'            => 'Imię',
                    'gender'                => 'Płeć',
                    'last-name'             => 'Nazwisko',
                    'male'                  => 'Mężczyzna',
                    'other'                 => 'Inna',
                    'save-btn'              => 'Zapisz klienta',
                    'select-customer-group' => 'Wybierz grupę klienta',
                    'select-gender'         => 'Wybierz płeć',
                    'title'                 => 'Utwórz nowego klienta',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Czy na pewno chcesz usunąć to konto?',
                'active'                      => 'Aktywny',
                'address-delete-confirmation' => 'Czy na pewno chcesz usunąć ten adres?',
                'back-btn'                    => 'Powrót',
                'create-order'                => 'Utwórz zamówienie',
                'customer'                    => 'Klient',
                'date-of-birth'               => 'Data urodzenia - :dob',
                'default-address'             => 'Domyślny adres',
                'delete-account'              => 'Usuń konto',
                'delete'                      => 'Usuń',
                'email'                       => 'E-mail - :email',
                'empty-description'           => 'Utwórz nowe adresy dla klienta',
                'empty-title'                 => 'Dodaj adres klienta',
                'gender'                      => 'Płeć - :gender',
                'group'                       => 'Grupa - :group_code',
                'inactive'                    => 'Nieaktywny',
                'login-as-customer'           => 'Zaloguj się jako klient',
                'note-created-success'        => 'Notatka utworzona pomyślnie',
                'order-create-confirmation'   => 'Czy na pewno chcesz utworzyć zamówienie dla tego klienta?',
                'phone'                       => 'Telefon - :phone',
                'set-as-default'              => 'Ustaw jako domyślny',
                'suspended'                   => 'Zawieszony',
                'title'                       => 'Widok klienta',

                'address' => [
                    'count' => 'Adresy (:count)',

                    'create' => [
                        'city'               => 'Miasto',
                        'company-name'       => 'Nazwa firmy',
                        'country'            => 'Kraj',
                        'create-btn'         => 'Utwórz',
                        'create-address-btn' => 'Dodaj nowy adres',
                        'default-address'    => 'Domyślny adres',
                        'email'              => 'E-mail',
                        'first-name'         => 'Imię',
                        'last-name'          => 'Nazwisko',
                        'phone'              => 'Telefon',
                        'post-code'          => 'Kod pocztowy',
                        'save-btn-title'     => 'Zapisz adres',
                        'select-country'     => 'Wybierz kraj',
                        'state'              => 'Stan',
                        'street-address'     => 'Adres ulicy',
                        'title'              => 'Utwórz adres',
                        'vat-id'             => 'VAT ID',
                    ],

                    'edit' => [
                        'city'            => 'Miasto',
                        'company-name'    => 'Nazwa firmy',
                        'country'         => 'Kraj',
                        'default-address' => 'Domyślny adres',
                        'edit-btn'        => 'Edytuj',
                        'email'           => 'E-mail',
                        'first-name'      => 'Imię',
                        'last-name'       => 'Nazwisko',
                        'phone'           => 'Telefon',
                        'post-code'       => 'Kod pocztowy',
                        'save-btn-title'  => 'Zapisz adres',
                        'select-country'  => 'Wybierz kraj',
                        'state'           => 'Stan',
                        'street-address'  => 'Adres ulicy',
                        'title'           => 'Edytuj adres',
                        'vat-id'          => 'VAT ID',
                    ],

                    'address-delete-success' => 'Adres pomyślnie usunięty',
                    'create-success'         => 'Adres pomyślnie utworzony',
                    'set-default-success'    => 'Domyślny adres zaktualizowany pomyślnie',
                    'success-mass-delete'    => 'Masowe usunięcie adresów pomyślnie zakończone',
                    'update-success'         => 'Adres pomyślnie zaktualizowany',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Brak recenzji',
                        'increment-id'   => 'ID faktury',
                        'invoice-amount' => 'Kwota faktury',
                        'invoice-date'   => 'Data faktury',
                        'order-id'       => 'ID zamówienia',
                        'view'           => 'Podgląd',
                    ],

                    'orders' => [
                        'canceled'        => 'Anulowane',
                        'channel-name'    => 'Nazwa kanału',
                        'closed'          => 'Zamknięte',
                        'completed'       => 'Zakończone',
                        'customer-name'   => 'Imię klienta',
                        'date'            => 'Data',
                        'empty-order'     => 'Brak dostępnych zamówień',
                        'email'           => 'E-mail',
                        'fraud'           => 'Oszustwo',
                        'grand-total'     => 'Suma całkowita',
                        'location'        => 'Lokalizacja',
                        'order-id'        => 'ID zamówienia',
                        'pay-via'         => 'Płatność przez',
                        'pending'         => 'Oczekujące',
                        'pending-payment' => 'Oczekująca płatność',
                        'processing'      => 'W trakcie przetwarzania',
                        'status'          => 'Status',
                        'view'            => 'Podgląd',
                    ],

                    'reviews' => [
                        'approved'      => 'Zatwierdzone',
                        'comment'       => 'Komentarz',
                        'created-at'    => 'Utworzono',
                        'disapproved'   => 'Odrzucone',
                        'empty-reviews' => 'Brak dostępnych faktur',
                        'id'            => 'ID',
                        'invoice-date'  => 'Data faktury',
                        'pending'       => 'Oczekujące',
                        'product-id'    => 'ID produktu',
                        'product-name'  => 'Nazwa produktu',
                        'rating'        => 'Ocena',
                        'status'        => 'Status',
                        'title'         => 'Tytuł',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Numer kontaktowy',
                    'customer-group'        => 'Grupa klienta',
                    'date-of-birth'         => 'Data urodzenia',
                    'edit-btn'              => 'Edytuj',
                    'email'                 => 'E-mail',
                    'female'                => 'Kobieta',
                    'first-name'            => 'Imię',
                    'gender'                => 'Płeć',
                    'last-name'             => 'Nazwisko',
                    'male'                  => 'Mężczyzna',
                    'other'                 => 'Inna',
                    'save-btn'              => 'Zapisz klienta',
                    'select-customer-group' => 'Wybierz grupę klienta',
                    'select-gender'         => 'Wybierz płeć',
                    'status'                => 'Status',
                    'suspended'             => 'Zawieszony',
                    'title'                 => 'Edytuj klienta',
                ],

                'invoices' => [
                    'count'        => 'Faktury (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Dodaj notatkę',
                    'customer-not-notified' => ':date | Klient <b>Nie poinformowany</b>',
                    'customer-notified'     => ':date | Klient <b>Poinformowany</b>',
                    'note'                  => 'Notatka',
                    'note-placeholder'      => 'Napisz swoją notatkę tutaj',
                    'notify-customer'       => 'Powiadom klienta',
                    'submit-btn-title'      => 'Prześlij notatkę',
                ],

                'orders' => [
                    'count'         => 'Zamówienia (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Całkowity dochód - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Recenzje (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Pomyślnie usunięto przedmiot z koszyka.',
                ],

                'wishlist' => [
                    'delete-success' => 'Pomyślnie usunięto przedmiot z listy życzeń.',
                ],

                'compare' => [
                    'delete-success' => 'Pomyślnie usunięto przedmiot z porównywarki.',
                ],
            ],

            'delete-failed'  => 'Usunięcie klienta nie powiodło się',
            'delete-success' => 'Klient został pomyślnie usunięty',
            'order-pending'  => 'Zamówienia są w trakcie oczekiwania',
            'update-success' => 'Klient został pomyślnie zaktualizowany',
        ],

        'groups' => [
            'customer-associate' => 'Ta grupa ma powiązanych klientów i nie może zostać usunięta.',

            'index' => [
                'title' => 'Grupy',

                'create' => [
                    'code'       => 'Kod',
                    'create-btn' => 'Utwórz Grupę',
                    'name'       => 'Nazwa',
                    'save-btn'   => 'Zapisz Grupę',
                    'success'    => 'Grupa została pomyślnie utworzona',
                    'title'      => 'Utwórz nową Grupę',
                ],

                'edit' => [
                    'delete-failed'  => 'Nie udało się usunąć Grupy',
                    'delete-success' => 'Grupa została pomyślnie usunięta',
                    'group-default'  => 'Domyślna Grupa nie może być usunięta',
                    'success'        => 'Grupa została pomyślnie zaktualizowana',
                    'title'          => 'Edytuj Grupę',
                ],

                'datagrid' => [
                    'code'   => 'Kod',
                    'delete' => 'Usuń',
                    'edit'   => 'Edytuj',
                    'id'     => 'ID',
                    'name'   => 'Nazwa',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Żądanie GDPR',

                'datagrid' => [
                    'completed'     => 'Zakończone',
                    'created-at'    => 'Utworzono',
                    'customer-name' => 'Nazwa klienta',
                    'declined'      => 'Odrzucone',
                    'delete'        => 'Usuń',
                    'edit'          => 'Edytuj',
                    'id'            => 'ID',
                    'message'       => 'Wiadomość',
                    'pending'       => 'Oczekujące',
                    'processing'    => 'Przetwarzanie',
                    'revoked'       => 'Cofnięty',
                    'status'        => 'Status',
                    'type'          => 'Typ',
                ],

                'modal' => [
                    'completed'     => 'Zakończone',
                    'declined'      => 'Odrzucone',
                    'message'       => 'Wiadomość',
                    'pending'       => 'Oczekujące',
                    'processing'    => 'Przetwarzanie',
                    'revoked'       => 'Cofnięty',
                    'save-btn'      => 'Zapisz',
                    'status'        => 'Status',
                    'title'         => 'Edytuj żądanie danych GDPR',
                    'type'          => 'Typ',
                ],

                'update-success'              => 'Żądanie danych zostało pomyślnie zaktualizowane i wysłano e-mail do klienta.',
                'delete-success'              => 'Żądanie danych zostało pomyślnie usunięte.',
                'attribute-reason-error'      => 'Nie można usunąć.',
                'update-success-unsent-email' => 'Żądanie danych zostało pomyślnie zaktualizowane, ale e-mail nie został wysłany do klienta.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Data',
                'description' => 'Opis',
                'id'          => 'ID',
                'name'        => 'Nazwa',
                'product'     => 'Produkt',
                'rating'      => 'Ocena',
                'status'      => 'Status',
                'title'       => 'Recenzje',

                'edit' => [
                    'approved'       => 'Zatwierdzona',
                    'customer'       => 'Klient',
                    'date'           => 'Data',
                    'disapproved'    => 'Odrzucona',
                    'id'             => 'ID',
                    'images'         => 'Zdjęcia',
                    'pending'        => 'Oczekująca',
                    'product'        => 'Produkt',
                    'rating'         => 'Ocena',
                    'review-comment' => 'Komentarz',
                    'review-title'   => 'Tytuł',
                    'save-btn'       => 'Zapisz',
                    'status'         => 'Status',
                    'title'          => 'Edytuj Recenzję',
                    'update-success' => 'Zaktualizowano pomyślnie',
                ],

                'datagrid' => [
                    'approved'            => 'Zatwierdzona',
                    'comment'             => 'Komentarz',
                    'customer-names'      => 'Nazwa',
                    'date'                => 'Data',
                    'delete'              => 'Usuń',
                    'delete-success'      => 'Recenzja została pomyślnie usunięta',
                    'disapproved'         => 'Odrzucona',
                    'edit'                => 'Edytuj',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Coś poszło nie tak',
                    'mass-delete-success' => 'Wybrane recenzje zostały pomyślnie usunięte',
                    'mass-update-success' => 'Wybrane recenzje zostały pomyślnie zaktualizowane',
                    'pending'             => 'Oczekująca',
                    'product'             => 'Produkt',
                    'rating'              => 'Ocena',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Status',
                    'title'               => 'Tytuł',
                    'update-status'       => 'Aktualizuj Status',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Utwórz Szablon',
                    'title'      => 'Szablony Emaili',

                    'datagrid' => [
                        'active'   => 'Aktywny',
                        'draft'    => 'Wersja robocza',
                        'id'       => 'ID',
                        'inactive' => 'Nieaktywny',
                        'name'     => 'Nazwa',
                        'status'   => 'Status',
                    ],
                ],

                'create' => [
                    'active'         => 'Aktywny',
                    'back-btn'       => 'Powrót',
                    'content'        => 'Treść',
                    'create-success' => 'Utworzono szablon emaila pomyślnie.',
                    'draft'          => 'Wersja robocza',
                    'general'        => 'Ogólne',
                    'inactive'       => 'Nieaktywny',
                    'name'           => 'Nazwa',
                    'save-btn'       => 'Zapisz Szablon',
                    'select-status'  => 'Wybierz Status',
                    'status'         => 'Status',
                    'title'          => 'Utwórz Szablon',
                ],

                'edit' => [
                    'active'         => 'Aktywny',
                    'back-btn'       => 'Powrót',
                    'content'        => 'Treść*',
                    'draft'          => 'Wersja robocza',
                    'general'        => 'Ogólne',
                    'inactive'       => 'Nieaktywny',
                    'name'           => 'Nazwa',
                    'save-btn'       => 'Zapisz Szablon',
                    'status'         => 'Status',
                    'title'          => 'Edytuj Szablon',
                    'update-success' => 'Zaktualizowano pomyślnie',
                ],

                'delete-failed'  => ':name Usunięcie nie powiodło się',
                'delete-success' => 'Szablon usunięty pomyślnie',
                'email-template' => 'Szablon Emaila',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Utwórz Kampanię',
                    'title'      => 'Kampanie',

                    'datagrid' => [
                        'active'   => 'Aktywna',
                        'delete'   => 'Usuń',
                        'edit'     => 'Edytuj',
                        'id'       => 'ID',
                        'inactive' => 'Nieaktywna',
                        'name'     => 'Nazwa',
                        'status'   => 'Status',
                        'subject'  => 'Temat',
                    ],
                ],

                'create' => [
                    'active'          => 'Aktywna',
                    'back-btn'        => 'Powrót',
                    'channel'         => 'Kanał',
                    'customer-group'  => 'Grupa Klientów',
                    'email-template'  => 'Szablon Emaila',
                    'event'           => 'Zdarzenie',
                    'general'         => 'Ogólne',
                    'inactive'        => 'Nieaktywna',
                    'name'            => 'Nazwa',
                    'save-btn'        => 'Zapisz Kampanię',
                    'select-channel'  => 'Wybierz kanał',
                    'select-event'    => 'Wybierz Zdarzenie',
                    'select-group'    => 'Wybierz grupę',
                    'select-status'   => 'Wybierz Status',
                    'select-template' => 'Wybierz Szablon',
                    'setting'         => 'Ustawienia',
                    'status'          => 'Status',
                    'subject'         => 'Temat',
                    'title'           => 'Utwórz Kampanię',
                ],

                'edit' => [
                    'active'          => 'Aktywna',
                    'audience'        => 'Audience',
                    'back-btn'        => 'Powrót',
                    'channel'         => 'Kanał',
                    'customer-group'  => 'Grupa Klientów',
                    'email-template'  => 'Szablon Emaila',
                    'event'           => 'Zdarzenie',
                    'general'         => 'Ogólne',
                    'inactive'        => 'Nieaktywna',
                    'name'            => 'Nazwa',
                    'save-btn'        => 'Zapisz Kampanię',
                    'select-event'    => 'Wybierz Zdarzenie',
                    'select-status'   => 'Wybierz Status',
                    'select-template' => 'Wybierz Szablon',
                    'status'          => 'Status',
                    'subject'         => 'Temat',
                    'title'           => 'Edytuj Kampanię',
                ],

                'create-success' => 'Kampania została pomyślnie utworzona.',
                'delete-failed'  => ':name Usunięcie nie powiodło się',
                'delete-success' => 'Kampania została pomyślnie usunięta',
                'email-campaign' => 'Kampania Emailowa',
                'update-success' => 'Kampania została pomyślnie zaktualizowana.',
            ],

            'events' => [
                'index'  => [
                    'create-btn' => 'Utwórz Wydarzenie',
                    'event'      => 'Wydarzenie',
                    'title'      => 'Wydarzenia',

                    'datagrid' => [
                        'actions' => 'Akcje',
                        'date'    => 'Data',
                        'delete'  => 'Usuń',
                        'edit'    => 'Edytuj',
                        'id'      => 'ID',
                        'name'    => 'Nazwa',
                    ],

                    'create' => [
                        'date'           => 'Data',
                        'delete-warning' => 'Czy na pewno chcesz wykonać tę akcję?',
                        'description'    => 'Opis',
                        'general'        => 'Ogólne',
                        'name'           => 'Nazwa',
                        'save-btn'       => 'Zapisz Wydarzenie',
                        'success'        => 'Wydarzenia utworzone pomyślnie',
                        'title'          => 'Utwórz Wydarzenia',
                    ],

                    'edit' => [
                        'success' => 'Wydarzenia zaktualizowane pomyślnie',
                        'title'   => 'Edytuj Wydarzenia',
                    ],
                ],

                'delete-failed'  => 'Usuwanie :name nie powiodło się',
                'delete-success' => 'Wydarzenia usunięte pomyślnie',
                'edit-error'     => 'Nie można edytować wydarzenia',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Subskrypcje Newslettera',

                    'datagrid' => [
                        'actions'    => 'Akcje',
                        'delete'     => 'Usuń',
                        'edit'       => 'Edytuj',
                        'email'      => 'Email',
                        'false'      => 'Nie',
                        'id'         => 'ID',
                        'subscribed' => 'Subskrybowane',
                        'true'       => 'Tak',
                    ],

                    'edit' => [
                        'back-btn'      => 'Powrót',
                        'email'         => 'Email',
                        'false'         => 'Nie',
                        'save-btn'      => 'Zapisz Subskrybenta',
                        'subscribed'    => 'Subskrybowane',
                        'success'       => 'Aktualizacja Subskrypcji Newslettera powiodła się',
                        'title'         => 'Edytuj Subskrybenta Newslettera',
                        'true'          => 'Tak',
                        'update-failed' => 'Aktualizacja Subskrypcji Newslettera nie powiodła się',
                    ],
                ],

                'delete-failed'  => 'Usuwanie subskrybenta nie powiodło się',
                'delete-success' => 'Subskrybent został pomyślnie usunięty',
                'delete-warning' => 'Czy na pewno chcesz wykonać tę akcję?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Zasady Koszyka',
                'catalog-rule-title' => 'Zasady Katalogowe',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Utwórz Zasadę Koszyka',
                    'title'      => 'Zasady Koszyka',

                    'datagrid' => [
                        'active'      => 'Aktywny',
                        'copy'        => 'Kopiuj',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Kod kuponu',
                        'delete'      => 'Usuń',
                        'draft'       => 'Szkic',
                        'edit'        => 'Edytuj',
                        'end'         => 'Zakończenie',
                        'id'          => 'ID',
                        'inactive'    => 'Nieaktywny',
                        'name'        => 'Nazwa',
                        'priority'    => 'Priorytet',
                        'start'       => 'Rozpoczęcie',
                        'status'      => 'Status',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Typ Akcji',
                    'actions'                                   => 'Akcje',
                    'add-condition'                             => 'Dodaj Warunek',
                    'additional'                                => 'Dodatkowe',
                    'all-conditions-true'                       => 'Wszystkie Warunki Są Prawdziwe',
                    'any-conditions-true'                       => 'Jakiekolwiek Warunki Są Prawdziwe',
                    'apply-to-shipping'                         => 'Zastosuj do Dostawy',
                    'attribute-family'                          => 'Rodzina Atrybutów',
                    'attribute-name-children-only'              => ':attribute_name (Tylko Dzieci)',
                    'attribute-name-parent-only'                => ':attribute_name (Tylko Rodzice)',
                    'auto-generate-coupon'                      => 'Automatycznie Generowany Kupon',
                    'back-btn'                                  => 'Powrót',
                    'buy-x-get-y-free'                          => 'Kup X, Zdobądź Y za Darmo',
                    'buy-x-quantity'                            => 'Kup X Ilość',
                    'cart-attribute'                            => 'Atrybut Koszyka',
                    'cart-item-attribute'                       => 'Atrybut Pozycji Koszyka',
                    'categories'                                => 'Kategorie',
                    'channels'                                  => 'Kanały',
                    'children-categories'                       => 'Kategorie (Tylko Dzieci)',
                    'choose-condition-to-add'                   => 'Wybierz warunek do dodania',
                    'condition-type'                            => 'Typ Warunku',
                    'conditions'                                => 'Warunki',
                    'contain'                                   => 'Zawiera',
                    'contains'                                  => 'Zawiera',
                    'coupon-code'                               => 'Kod Kuponu',
                    'coupon-type'                               => 'Typ Kuponu',
                    'create-success'                            => 'Zasada koszyka utworzona pomyślnie',
                    'customer-groups'                           => 'Grupy Klientów',
                    'description'                               => 'Opis',
                    'discount-amount'                           => 'Kwota Rabatu',
                    'does-not-contain'                          => 'Nie Zawiera',
                    'end-of-other-rules'                        => 'Koniec Innych Zasad',
                    'equals-or-greater-than'                    => 'Równa się lub Jest Większe Niż',
                    'equals-or-less-than'                       => 'Równa się lub Jest Mniejsze Niż',
                    'fixed-amount'                              => 'Stała Kwota',
                    'fixed-amount-whole-cart'                   => 'Stała Kwota Całego Koszyka',
                    'free-shipping'                             => 'Darmowa Dostawa',
                    'from'                                      => 'Od',
                    'general'                                   => 'Ogólne',
                    'greater-than'                              => 'Większe Niż',
                    'is-equal-to'                               => 'Równa się',
                    'is-not-equal-to'                           => 'Nie Równa się',
                    'less-than'                                 => 'Mniejsze Niż',
                    'marketing-time'                            => 'Czas Marketingowy',
                    'maximum-quantity-allowed-to-be-discounted' => 'Maksymalna Ilość, Która Może Uzyskać Rabat',
                    'name'                                      => 'Nazwa',
                    'no'                                        => 'Nie',
                    'no-coupon'                                 => 'Brak Kuponu',
                    'parent-categories'                         => 'Kategorie (Tylko Rodzice)',
                    'payment-method'                            => 'Metoda Płatności',
                    'percentage-product-price'                  => 'Procentowa Cena Produktu',
                    'price-in-cart'                             => 'Cena w Koszyku',
                    'priority'                                  => 'Priorytet',
                    'product-attribute'                         => 'Atrybut Produktu',
                    'qty-in-cart'                               => 'Ilość w Koszyku',
                    'save-btn'                                  => 'Zapisz Zasadę Koszyka',
                    'settings'                                  => 'Ustawienia',
                    'shipping-country'                          => 'Kraj Dostawy',
                    'shipping-method'                           => 'Metoda Dostawy',
                    'shipping-postcode'                         => 'Kod Pocztowy Dostawy',
                    'shipping-state'                            => 'Stan Dostawy',
                    'specific-coupon'                           => 'Konkretny Kupon',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Suma Częściowa',
                    'title'                                     => 'Utwórz Zasadę Koszyka',
                    'to'                                        => 'Do',
                    'total-items-qty'                           => 'Całkowita Ilość Pozycji',
                    'total-weight'                              => 'Całkowita Waga',
                    'uses-per-coupon'                           => 'Liczba Użyć na Kupon',
                    'uses-per-customer'                         => 'Liczba Użyć na Klienta',
                    'uses-per-customer-control-info'            => 'Będzie używane tylko dla zalogowanych klientów.',
                    'yes'                                       => 'Tak',
                ],

                'edit' => [
                    'action-type'                               => 'Typ Akcji',
                    'actions'                                   => 'Akcje',
                    'add-condition'                             => 'Dodaj Warunek',
                    'additional'                                => 'Dodatkowe',
                    'all-conditions-true'                       => 'Wszystkie Warunki Są Prawdziwe',
                    'alphabetical'                              => 'Alfabetyczny',
                    'alphanumeric'                              => 'Alfanumeryczny',
                    'any-conditions-true'                       => 'Jakiekolwiek Warunki Są Prawdziwe',
                    'apply-to-shipping'                         => 'Zastosuj do Dostawy',
                    'attribute-family'                          => 'Rodzina Atrybutów',
                    'attribute-name-children-only'              => ':attribute_name (Tylko Dzieci)',
                    'attribute-name-parent-only'                => ':attribute_name (Tylko Rodzice)',
                    'auto-generate-coupon'                      => 'Automatycznie Generowany Kupon',
                    'back-btn'                                  => 'Powrót',
                    'buy-x-get-y-free'                          => 'Kup X, Zdobądź Y za Darmo',
                    'buy-x-quantity'                            => 'Kup X Ilość',
                    'cart-attribute'                            => 'Atrybut Koszyka',
                    'cart-item-attribute'                       => 'Atrybut Pozycji Koszyka',
                    'categories'                                => 'Kategorie',
                    'channels'                                  => 'Kanały',
                    'children-categories'                       => 'Kategorie Dzieci',
                    'choose-condition-to-add'                   => 'Wybierz warunek do dodania',
                    'code-format'                               => 'Format Kodu',
                    'code-prefix'                               => 'Przedrostek Kodu',
                    'code-suffix'                               => 'Przyrostek Kodu',
                    'condition-type'                            => 'Typ Warunku',
                    'conditions'                                => 'Warunki',
                    'contain'                                   => 'Zawiera',
                    'contains'                                  => 'Zawiera',
                    'coupon-code'                               => 'Kod Kuponu',
                    'coupon-length'                             => 'Długość Kuponu',
                    'coupon-qty'                                => 'Ilość Kuponów',
                    'coupon-type'                               => 'Typ Kuponu',
                    'customer-group'                            => 'Grupa Klientów',
                    'customer-groups'                           => 'Grupy Klientów',
                    'description'                               => 'Opis',
                    'discount-amount'                           => 'Kwota Rabatu',
                    'does-not-contain'                          => 'Nie Zawiera',
                    'end-of-other-rules'                        => 'Koniec Innych Zasad',
                    'equals-or-greater-than'                    => 'Równa się lub Jest Większe Niż',
                    'equals-or-less-than'                       => 'Równa się lub Jest Mniejsze Niż',
                    'fixed-amount'                              => 'Stała Kwota',
                    'fixed-amount-whole-cart'                   => 'Stała Kwota Całego Koszyka',
                    'free-shipping'                             => 'Darmowa Dostawa',
                    'from'                                      => 'Od',
                    'general'                                   => 'Ogólne',
                    'generate'                                  => 'Generuj',
                    'greater-than'                              => 'Większe Niż',
                    'is-equal-to'                               => 'Równa się',
                    'is-not-equal-to'                           => 'Nie Równa się',
                    'less-than'                                 => 'Mniejsze Niż',
                    'marketing-time'                            => 'Czas Marketingowy',
                    'maximum-quantity-allowed-to-be-discounted' => 'Maksymalna Ilość, Która Może Uzyskać Rabat',
                    'name'                                      => 'Nazwa',
                    'no'                                        => 'Nie',
                    'no-coupon'                                 => 'Brak Kuponu',
                    'numeric'                                   => 'Numeryczny',
                    'parent-categories'                         => 'Kategorie Rodziców',
                    'payment-method'                            => 'Metoda Płatności',
                    'percentage-product-price'                  => 'Procentowa Cena Produktu',
                    'price-in-cart'                             => 'Cena w Koszyku',
                    'priority'                                  => 'Priorytet',
                    'product-attribute'                         => 'Atrybut Produktu',
                    'qty-in-cart'                               => 'Ilość w Koszyku',
                    'save-btn'                                  => 'Zapisz Zasadę Koszyka',
                    'settings'                                  => 'Ustawienia',
                    'shipping-country'                          => 'Kraj Dostawy',
                    'shipping-method'                           => 'Metoda Dostawy',
                    'shipping-postcode'                         => 'Kod Pocztowy Dostawy',
                    'shipping-state'                            => 'Stan Dostawy',
                    'specific-coupon'                           => 'Konkretny Kupon',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Suma Częściowa',
                    'title'                                     => 'Edytuj Zasadę Koszyka',
                    'to'                                        => 'Do',
                    'total-items-qty'                           => 'Całkowita Ilość Pozycji',
                    'total-weight'                              => 'Całkowita Waga',
                    'update-success'                            => 'Zasada koszyka zaktualizowana pomyślnie',
                    'uses-per-coupon'                           => 'Liczba Użyć na Kupon',
                    'uses-per-customer'                         => 'Liczba Użyć na Klienta',
                    'uses-per-customer-control-info'            => 'Będzie używane tylko dla zalogowanych klientów.',
                    'yes'                                       => 'Tak',
                ],

                'delete-failed'  => 'Usunięcie zasady koszyka nie powiodło się',
                'delete-success' => 'Zasada koszyka usunięta pomyślnie',

                'catalog-rules' => [
                    'index' => [
                        'create-btn' => 'Utwórz Zasadę Katalogu',
                        'title'      => 'Zasady Katalogu',

                        'datagrid' => [
                            'active'   => 'Aktywna',
                            'delete'   => 'Usuń',
                            'edit'     => 'Edytuj',
                            'end'      => 'Koniec',
                            'id'       => 'ID',
                            'inactive' => 'Nieaktywna',
                            'name'     => 'Nazwa',
                            'priority' => 'Priorytet',
                            'start'    => 'Początek',
                            'status'   => 'Status',
                        ],
                    ],

                    'create' => [
                        'action-type'              => 'Typ Akcji',
                        'actions'                  => 'Akcje',
                        'add-condition'            => 'Dodaj Warunek',
                        'all-conditions-true'      => 'Wszystkie Warunki są prawdziwe',
                        'any-conditions-true'      => 'Jakiekolwiek Warunki są prawdziwe',
                        'attribute-family'         => 'Rodzina Atrybutów',
                        'back-btn'                 => 'Powrót',
                        'categories'               => 'Kategorie',
                        'channels'                 => 'Kanały',
                        'choose-condition-to-add'  => 'Wybierz Warunek Do Dodania',
                        'condition-type'           => 'Typ Warunku',
                        'conditions'               => 'Warunki',
                        'contain'                  => 'Zawiera',
                        'contains'                 => 'Zawiera',
                        'customer-groups'          => 'Grupy Klientów',
                        'description'              => 'Opis',
                        'discount-amount'          => 'Kwota Rabatu',
                        'does-not-contain'         => 'Nie Zawiera',
                        'end-other-rules'          => 'Zakończ inne zasady',
                        'equals-or-greater-than'   => 'Równa się lub Jest Większe Niż',
                        'equals-or-less-than'      => 'Równa się lub Jest Mniejsze Niż',
                        'fixed-amount'             => 'Stała Kwota',
                        'from'                     => 'Od',
                        'general'                  => 'Ogólne',
                        'greater-than'             => 'Większe Niż',
                        'is-equal-to'              => 'Równa się',
                        'is-not-equal-to'          => 'Nie Równa się',
                        'less-than'                => 'Mniejsze Niż',
                        'marketing-time'           => 'Czas Marketingowy',
                        'name'                     => 'Nazwa',
                        'no'                       => 'Nie',
                        'percentage-product-price' => 'Procent Ceny Produktu',
                        'priority'                 => 'Priorytet',
                        'product-attribute'        => 'Atrybut Produktu',
                        'save-btn'                 => 'Zapisz Zasadę Katalogu',
                        'settings'                 => 'Ustawienia',
                        'status'                   => 'Status',
                        'title'                    => 'Utwórz Zasadę Katalogu',
                        'to'                       => 'Do',
                        'yes'                      => 'Tak',
                    ],

                    'edit' => [
                        'action-type'              => 'Typ Akcji',
                        'actions'                  => 'Akcje',
                        'add-condition'            => 'Dodaj Warunek',
                        'all-conditions-true'      => 'Wszystkie Warunki są prawdziwe',
                        'any-conditions-true'      => 'Jakiekolwiek Warunki są prawdziwe',
                        'back-btn'                 => 'Powrót',
                        'categories'               => 'Kategorie',
                        'channels'                 => 'Kanały',
                        'choose-condition-to-add'  => 'Wybierz Warunek Do Dodania',
                        'condition-type'           => 'Typ Warunku',
                        'conditions'               => 'Warunki',
                        'contain'                  => 'Zawiera',
                        'contains'                 => 'Zawiera',
                        'customer-groups'          => 'Grupy Klientów',
                        'description'              => 'Opis',
                        'discount-amount'          => 'Kwota Rabatu',
                        'does-not-contain'         => 'Nie Zawiera',
                        'end-other-rules'          => 'Zakończ inne zasady',
                        'equals-or-greater-than'   => 'Równa się lub Jest Większe Niż',
                        'equals-or-less-than'      => 'Równa się lub Jest Mniejsze Niż',
                        'fixed-amount'             => 'Stała Kwota',
                        'from'                     => 'Od',
                        'general'                  => 'Ogólne',
                        'greater-than'             => 'Większe Niż',
                        'is-equal-to'              => 'Równa się',
                        'is-not-equal-to'          => 'Nie Równa się',
                        'less-than'                => 'Mniejsze Niż',
                        'marketing-time'           => 'Czas Marketingowy',
                        'name'                     => 'Nazwa',
                        'no'                       => 'Nie',
                        'percentage-product-price' => 'Procent Ceny Produktu',
                        'priority'                 => 'Priorytet',
                        'product-attribute'        => 'Atrybut Produktu',
                        'save-btn'                 => 'Zapisz Zasadę Katalogu',
                        'settings'                 => 'Ustawienia',
                        'status'                   => 'Status',
                        'title'                    => 'Edytuj Zasadę Katalogu',
                        'to'                       => 'Do',
                        'yes'                      => 'Tak',
                    ],

                    'create-success' => 'Zasada katalogu utworzona pomyślnie',
                    'delete-success' => 'Zasada katalogu usunięta pomyślnie',
                    'update-success' => 'Zasada katalogu zaktualizowana pomyślnie',
                ],

                'cart-rules-coupons' => [
                    'cart-rule-not-defined-error' => 'Nie można usunąć zasady koszyka',
                    'delete-success'              => 'Kupon zasady koszyka został pomyślnie usunięty',
                    'mass-delete-success'         => 'Wybrane elementy zostały pomyślnie usunięte',
                    'success'                     => ':name zostało pomyślnie utworzone',

                    'datagrid' => [
                        'coupon-code'     => 'Kod kuponu',
                        'created-date'    => 'Data utworzenia',
                        'delete'          => 'Usuń',
                        'expiration-date' => 'Data wygaśnięcia',
                        'id'              => 'ID',
                        'times-used'      => 'Liczba użyć',
                    ],
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Utwórz nowe słowo kluczowe wyszukiwania',
                    'title'      => 'Słowa kluczowe wyszukiwania',

                    'datagrid' => [
                        'actions'             => 'Akcje',
                        'channel'             => 'Kanał',
                        'delete'              => 'Usuń',
                        'edit'                => 'Edytuj',
                        'id'                  => 'ID',
                        'locale'              => 'Ustawienia regionalne',
                        'mass-delete-success' => 'Wybrane słowa kluczowe wyszukiwania zostały pomyślnie usunięte',
                        'redirect-url'        => 'Adres URL przekierowania',
                        'results'             => 'Wyniki',
                        'search-query'        => 'Wyszukiwanie słów kluczowych',
                        'uses'                => 'Zastosowania',
                    ],

                    'create' => [
                        'channel'        => 'Kanał',
                        'delete-warning' => 'Czy na pewno chcesz wykonać tę akcję?',
                        'locale'         => 'Ustawienia regionalne',
                        'redirect-url'   => 'Adres URL przekierowania',
                        'results'        => 'Wyniki',
                        'save-btn'       => 'Zapisz słowo kluczowe wyszukiwania',
                        'search-query'   => 'Wyszukiwanie słów kluczowych',
                        'success'        => 'Słowo kluczowe wyszukiwania zostało pomyślnie utworzone',
                        'title'          => 'Utwórz nowe słowo kluczowe wyszukiwania',
                        'uses'           => 'Zastosowania',
                    ],

                    'edit' => [
                        'delete-success' => 'Słowo kluczowe wyszukiwania zostało pomyślnie usunięte',
                        'success'        => 'Słowo kluczowe wyszukiwania zostało pomyślnie zaktualizowane',
                        'title'          => 'Edytuj słowo kluczowe wyszukiwania',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Utwórz Synonim Wyszukiwania',
                    'title'      => 'Synonimy wyszukiwania',

                    'datagrid' => [
                        'actions'             => 'Akcje',
                        'delete'              => 'Usuń',
                        'edit'                => 'Edytuj',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Wybrane Synonimy Wyszukiwania Pomyślnie Usunięte',
                        'name'                => 'Nazwa',
                        'terms'               => 'Terminy',
                    ],

                    'create' => [
                        'delete-warning' => 'Czy na pewno chcesz wykonać tę akcję?',
                        'name'           => 'Nazwa',
                        'save-btn'       => 'Zapisz Synonim Wyszukiwania',
                        'success'        => 'Synonim Wyszukiwania utworzony pomyślnie',
                        'terms'          => 'Terminy',
                        'terms-info'     => 'Wprowadź synonimy jako listę oddzieloną przecinkami, na przykład "buty, obuwie." To rozszerza wyszukiwanie, aby obejmować wszystkie terminy.',
                        'title'          => 'Utwórz Synonim Wyszukiwania',
                    ],

                    'edit' => [
                        'delete-success' => 'Synonim Wyszukiwania pomyślnie usunięty',
                        'success'        => 'Synonim Wyszukiwania pomyślnie zaktualizowany',
                        'title'          => 'Edytuj Synonim Wyszukiwania',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Utwórz mapę witryny',
                    'sitemap'    => 'Mapa witryny',
                    'title'      => 'Mapy witryny',

                    'datagrid' => [
                        'actions'         => 'Akcje',
                        'delete'          => 'Usuń',
                        'edit'            => 'Edytuj',
                        'file-name'       => 'Nazwa pliku',
                        'id'              => 'ID',
                        'link-for-google' => 'Link do Google',
                        'path'            => 'Ścieżka',
                    ],

                    'create' => [
                        'delete-warning' => 'Czy na pewno chcesz wykonać tę akcję?',
                        'file-name'      => 'Nazwa pliku',
                        'file-name-info' => 'Przykład: sitemap.xml',
                        'path'           => 'Ścieżka',
                        'path-info'      => 'Przykład: "/sitemap/" lub "/" dla ścieżki podstawowej',
                        'save-btn'       => 'Zapisz mapę witryny',
                        'success'        => 'Mapa witryny została pomyślnie utworzona',
                        'title'          => 'Utwórz mapę witryny',
                    ],

                    'edit' => [
                        'delete-success' => 'Mapa witryny została pomyślnie usunięta',
                        'success'        => 'Mapa witryny została pomyślnie zaktualizowana',
                        'title'          => 'Edytuj mapę witryny',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Powrót',
                    'file-name'      => 'Nazwa pliku',
                    'file-name-info' => 'Przykład: sitemap.xml',
                    'general'        => 'Ogólne',
                    'path'           => 'Ścieżka',
                    'path-info'      => 'Przykład: "/sitemap/" lub "/" dla ścieżki podstawowej',
                    'save-btn'       => 'Zapisz mapę witryny',
                ],

                'delete-failed' => ':name Usunięcie nie powiodło się',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Utwórz nowy zapis URL',
                    'title'      => 'Zapis URL',

                    'datagrid' => [
                        'actions'             => 'Akcje',
                        'category'            => 'Kategoria',
                        'cms-page'            => 'Strona CMS',
                        'delete'              => 'Usuń',
                        'edit'                => 'Edytuj',
                        'for'                 => 'Dla',
                        'id'                  => 'ID',
                        'locale'              => 'Język',
                        'mass-delete-success' => 'Wybrane zapisy URL zostały pomyślnie usunięte.',
                        'permanent-redirect'  => 'Przejście stałe (301)',
                        'product'             => 'Produkt',
                        'redirect-type'       => 'Typ przekierowania',
                        'request-path'        => 'Ścieżka żądania',
                        'target-path'         => 'Ścieżka docelowa',
                        'temporary-redirect'  => 'Przejście tymczasowe (302)',
                    ],

                    'create' => [
                        'category'           => 'Kategoria',
                        'cms-page'           => 'Strona CMS',
                        'delete-warning'     => 'Czy na pewno chcesz wykonać tę akcję?',
                        'for'                => 'Dla',
                        'locale'             => 'Język',
                        'permanent-redirect' => 'Przejście stałe (301)',
                        'product'            => 'Produkt',
                        'redirect-type'      => 'Typ przekierowania',
                        'request-path'       => 'Ścieżka żądania',
                        'save-btn'           => 'Utwórz nowy zapis URL',
                        'success'            => 'Zapis URL został pomyślnie utworzony.',
                        'target-path'        => 'Ścieżka docelowa',
                        'temporary-redirect' => 'Przejście tymczasowe (302)',
                        'title'              => 'Utwórz nowy zapis URL',
                    ],

                    'edit' => [
                        'delete-success' => 'Zapis URL został pomyślnie usunięty.',
                        'success'        => 'Zapis URL został pomyślnie zaktualizowany.',
                        'title'          => 'Edytuj zapis URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'Strona o nazwie :name już istnieje.',
            'channel'       => 'Kanał',
            'create-btn'    => 'Utwórz stronę',
            'language'      => 'Język',
            'title'         => 'Strony',

            'datagrid' => [
                'channel'             => 'Kanał',
                'delete'              => 'Usuń',
                'edit'                => 'Edytuj',
                'id'                  => 'ID',
                'mass-delete-success' => 'Wybrane dane zostały pomyślnie usunięte',
                'page-title'          => 'Tytuł strony',
                'url-key'             => 'Klucz URL',
                'view'                => 'Wyświetl',
            ],
        ],

        'create' => [
            'channels'         => 'Kanały',
            'content'          => 'Zawartość',
            'description'      => 'Opis',
            'general'          => 'Ogólne',
            'meta-description' => 'Opis Meta',
            'meta-keywords'    => 'Słowa kluczowe Meta',
            'meta-title'       => 'Tytuł Meta',
            'page-title'       => 'Tytuł',
            'save-btn'         => 'Zapisz stronę',
            'seo'              => 'SEO',
            'title'            => 'Utwórz stronę',
            'url-key'          => 'Klucz URL',
        ],

        'edit' => [
            'back-btn'         => 'Powrót',
            'channels'         => 'Kanały',
            'content'          => 'Zawartość',
            'description'      => 'Opis',
            'general'          => 'Ogólne',
            'meta-description' => 'Opis Meta',
            'meta-keywords'    => 'Słowa kluczowe Meta',
            'meta-title'       => 'Tytuł Meta',
            'page-title'       => 'Tytuł strony',
            'preview-btn'      => 'Podgląd strony',
            'save-btn'         => 'Zapisz stronę',
            'seo'              => 'SEO',
            'title'            => 'Edytuj stronę',
            'url-key'          => 'Klucz URL',
        ],

        'create-success' => 'CMS został pomyślnie utworzony.',
        'delete-success' => 'CMS został pomyślnie usunięty.',
        'no-resource'    => 'Zasób nie istnieje.',
        'update-success' => 'CMS został pomyślnie zaktualizowany.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Utwórz Lokalizację',
                'locale'     => 'Lokalizacja',
                'logo-size'  => 'Rozdzielczość obrazu powinna być jak 24px x 16px',
                'title'      => 'Lokalizacje',

                'datagrid' => [
                    'actions'   => 'Akcje',
                    'code'      => 'Kod',
                    'delete'    => 'Usuń',
                    'direction' => 'Kierunek',
                    'edit'      => 'Edytuj',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nazwa',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Kod',
                    'direction'        => 'Kierunek',
                    'locale-logo'      => 'Logo Lokalizacji',
                    'name'             => 'Nazwa',
                    'save-btn'         => 'Zapisz Lokalizację',
                    'select-direction' => 'Wybierz kierunek',
                    'title'            => 'Utwórz Lokalizację',
                ],

                'edit' => [
                    'title' => 'Edytuj Lokalizacje',
                ],

                'create-success'    => 'Lokalizacja została pomyślnie utworzona.',
                'delete-failed'     => 'Usuwanie Lokalizacji nie powiodło się',
                'delete-success'    => 'Lokalizacja została pomyślnie usunięta.',
                'delete-warning'    => 'Czy na pewno chcesz wykonać tę operację?',
                'last-delete-error' => 'Wymagana jest co najmniej jedna Lokalizacja.',
                'update-success'    => 'Lokalizacja została pomyślnie zaktualizowana.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Utwórz Walutę',
                'currency'   => 'Waluta',
                'title'      => 'Waluty',

                'datagrid' => [
                    'actions'        => 'Akcje',
                    'code'           => 'Kod',
                    'delete'         => 'Usuń',
                    'edit'           => 'Edytuj',
                    'id'             => 'ID',
                    'method-error'   => 'Błąd! Wykryto niewłaściwą metodę, proszę sprawdzić konfigurację masowej akcji',
                    'name'           => 'Nazwa',
                    'no-resource'    => 'Zasób dostarczony jest niewystarczający dla danej akcji',
                    'partial-action' => 'Niektóre akcje nie zostały wykonane ze względu na ograniczenia systemowe w zasobie :resource',
                    'update-success' => 'Wybrane :resource zostały pomyślnie zaktualizowane',
                ],

                'create' => [
                    'code'                   => 'Kod',
                    'create-btn'             => 'Utwórz Walutę',
                    'currency-position'      => 'Pozycja Waluty',
                    'decimal'                => 'Miejsca dziesiętne',
                    'decimal-separator'      => 'Separator liczb dziesiętnych',
                    'decimal-separator-note' => 'Pole :attribute może akceptować tylko operatory przecinka (,) i kropki (.)',
                    'delete-warning'         => 'Czy na pewno chcesz wykonać tę operację?',
                    'general'                => 'Ogólne',
                    'group-separator'        => 'Separator Grup',
                    'group-separator-note'   => 'Pole :attribute może zawierać tylko znaki przecinek (,), kropka (.), apostrof (\') i spacja ( ).',
                    'name'                   => 'Nazwa',
                    'save-btn'               => 'Zapisz Walutę',
                    'symbol'                 => 'Symbol',
                    'title'                  => 'Utwórz nową Walutę',
                ],

                'edit' => [
                    'title' => 'Edytuj Walutę',
                ],

                'create-success'    => 'Waluta została pomyślnie utworzona.',
                'delete-failed'     => 'Usunięcie Waluty nie powiodło się',
                'delete-success'    => 'Waluta została pomyślnie usunięta.',
                'last-delete-error' => 'Wymagana jest co najmniej jedna Waluta.',
                'update-success'    => 'Waluta została pomyślnie zaktualizowana.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Akcja',
                    'allowed-errors'      => 'Dozwolone błędy',
                    'back-btn'            => 'Wstecz',
                    'create-update'       => 'Utwórz/Zaktualizuj',
                    'delete'              => 'Usuń',
                    'download-sample'     => 'Pobierz przykład',
                    'field-separator'     => 'Separator pól',
                    'file-info-example'   => 'Na przykład, jeśli to produkt-obrazy, pliki powinny być umieszczone w folderze /project-root/storage/app/import/product-images.',
                    'file-info'           => 'Użyj ścieżki względnej do /project-root/storage/app/import, np. product-images, import-images.',
                    'file'                => 'Plik',
                    'general'             => 'Ogólne',
                    'images-directory'    => 'Ścieżka katalogu obrazów',
                    'process-in-queue'    => 'Przetwarzanie w kolejce',
                    'results'             => 'Wyniki',
                    'save-btn'            => 'Zapisz import',
                    'settings'            => 'Ustawienia',
                    'skip-errors'         => 'Pomiń błędy',
                    'stop-on-errors'      => 'Zatrzymaj przy błędach',
                    'title'               => 'Utwórz import',
                    'type'                => 'Typ',
                    'validation-strategy' => 'Strategia walidacji',
                ],

                'edit' => [
                    'action'              => 'Akcja',
                    'allowed-errors'      => 'Dozwolone błędy',
                    'back-btn'            => 'Powrót',
                    'create-update'       => 'Utwórz/Aktualizuj',
                    'current-file'        => 'Aktualnie przesłany plik',
                    'delete'              => 'Usuń',
                    'download-sample'     => 'Pobierz Przykład',
                    'field-separator'     => 'Separator pól',
                    'file-info-example'   => 'Na przykład, w przypadku obrazów produktów, pliki powinny być umieszczone w folderze /project-root/storage/app/import/product-images.',
                    'file-info'           => 'Użyj ścieżki względnej do /project-root/storage/app/import, np. product-images, import-images.',
                    'file'                => 'Plik',
                    'general'             => 'Ogólne',
                    'images-directory'    => 'Ścieżka do katalogu obrazów',
                    'process-in-queue'    => 'Przetwarzanie w kolejce',
                    'results'             => 'Wyniki',
                    'save-btn'            => 'Zapisz Import',
                    'settings'            => 'Ustawienia',
                    'skip-errors'         => 'Pomiń błędy',
                    'stop-on-errors'      => 'Zatrzymaj na błędach',
                    'title'               => 'Edytuj Import',
                    'type'                => 'Typ',
                    'validation-strategy' => 'Strategia walidacji',
                ],

                'index' => [
                    'button-title' => 'Utwórz Import',
                    'title'        => 'Importy',

                    'datagrid' => [
                        'actions'       => 'Akcje',
                        'completed-at'  => 'Zakończono o',
                        'created'       => 'Utworzono',
                        'delete'        => 'Usuń',
                        'deleted'       => 'Usunięto',
                        'edit'          => 'Edytuj',
                        'error-file'    => 'Plik błędu',
                        'id'            => 'ID',
                        'started-at'    => 'Rozpoczęto o',
                        'state'         => 'Stan',
                        'summary'       => 'Podsumowanie',
                        'updated'       => 'Zaktualizowano',
                        'uploaded-file' => 'Załadowany plik',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Powrót',
                    'completed-batches'       => 'Łączna liczba zakończonych partii:',
                    'download-error-report'   => 'Pobierz Pełne Sprawozdanie',
                    'edit-btn'                => 'Edytuj',
                    'imported-info'           => 'Gratulacje! Import został pomyślnie zakończony.',
                    'importing-info'          => 'Trwa proces importu',
                    'indexing-info'           => 'Trwa indeksowanie zasobów (cennik, stan magazynowy i Elastic Search)',
                    'linking-info'            => 'Trwa łączenie zasobów',
                    'progress'                => 'Postęp:',
                    'title'                   => 'Import',
                    'total-batches'           => 'Łączna liczba partii:',
                    'total-created'           => 'Łączna liczba utworzonych rekordów:',
                    'total-deleted'           => 'Łączna liczba usuniętych rekordów:',
                    'total-errors'            => 'Łączna liczba błędów:',
                    'total-invalid-rows'      => 'Łączna liczba nieprawidłowych wierszy:',
                    'total-rows-processed'    => 'Łączna liczba przetworzonych wierszy:',
                    'total-updated'           => 'Łączna liczba zaktualizowanych rekordów:',
                    'validate-info'           => 'Kliknij Aby sprawdzić dane importu.',
                    'validate'                => 'Sprawdź',
                    'validating-info'         => 'Dane rozpoczęto odczytywanie i sprawdzanie',
                    'validation-failed-info'  => 'Twoje import jest nieprawidłowy. Proszę popraw następujące błędy i spróbuj ponownie.',
                    'validation-success-info' => 'Twoje import jest poprawny. Kliknij Aby rozpocząć proces importu.',
                ],

                'create-success'    => 'Import pomyślnie utworzony.',
                'delete-failed'     => 'Usunięcie importu nie powiodło się nieoczekiwanie.',
                'delete-success'    => 'Import pomyślnie usunięty.',
                'not-valid'         => 'Import jest nieprawidłowy',
                'nothing-to-import' => 'Nie ma zasobów do zaimportowania.',
                'setup-queue-error' => 'Zmień sterownik koleki na "baza danych" lub "redis", aby rozpząć proces importu.',
                'update-success'    => 'Import pomyślnie zaktualizowany.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Utwórz Kurs Walutowy',
                'exchange-rate' => 'Kurs Walutowy',
                'title'         => 'Kursy Walut',
                'update-rates'  => 'Aktualizuj Kurs Walutowy',

                'create' => [
                    'delete-warning'         => 'Czy na pewno chcesz wykonać tę operację?',
                    'rate'                   => 'Kurs',
                    'save-btn'               => 'Zapisz Kurs Walutowy',
                    'select-target-currency' => 'Wybierz docelową walutę',
                    'source-currency'        => 'Waluta Źródłowa',
                    'target-currency'        => 'Waluta Docelowa',
                    'title'                  => 'Utwórz Kurs Walutowy',
                ],

                'edit' => [
                    'title'   => 'Edytuj Kurs Walutowy',
                ],

                'datagrid' => [
                    'actions'       => 'Akcje',
                    'currency-name' => 'Nazwa Waluty',
                    'delete'        => 'Usuń',
                    'edit'          => 'Edytuj',
                    'exchange-rate' => 'Kurs Walutowy',
                    'id'            => 'ID',
                ],

                'create-success' => 'Kurs Walutowy został pomyślnie utworzony',
                'delete-error'   => 'Błąd usuwania Kursu Walutowego',
                'delete-success' => 'Kurs Walutowy został pomyślnie usunięty',
                'update-success' => 'Kurs Walutowy został pomyślnie zaktualizowany',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => 'Utwórz źródło inwentarza',
                'title'      => 'Źródła Inwentarza',

                'datagrid' => [
                    'active'   => 'Aktywne',
                    'code'     => 'Kod',
                    'delete'   => 'Usuń',
                    'edit'     => 'Edytuj',
                    'id'       => 'ID',
                    'inactive' => 'Nieaktywne',
                    'name'     => 'Nazwa',
                    'priority' => 'Priorytet',
                    'status'   => 'Status',
                ],
            ],

            'create' => [
                'add-title'      => 'Dodaj Źródło Inwentarza',
                'address'        => 'Adres źródła',
                'back-btn'       => 'Wróć',
                'city'           => 'Miasto',
                'code'           => 'Kod',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informacje kontaktowe',
                'contact-name'   => 'Imię',
                'contact-number' => 'Numer kontaktowy',
                'country'        => 'Kraj',
                'description'    => 'Opis',
                'general'        => 'Ogólne',
                'latitude'       => 'Szerokość geograficzna',
                'longitude'      => 'Długość geograficzna',
                'name'           => 'Nazwa',
                'postcode'       => 'Kod pocztowy',
                'priority'       => 'Priorytet',
                'save-btn'       => 'Zapisz Źródło Inwentarza',
                'select-country' => 'Wybierz kraj',
                'select-state'   => 'Wybierz stan',
                'settings'       => 'Ustawienia',
                'state'          => 'Stan',
                'status'         => 'Status',
                'street'         => 'Ulica',
                'title'          => 'Źródła Inwentarza',
            ],

            'edit' => [
                'back-btn'       => 'Wróć',
                'city'           => 'Miasto',
                'code'           => 'Kod',
                'contact-email'  => 'E-mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Informacje kontaktowe',
                'contact-name'   => 'Imię',
                'contact-number' => 'Numer kontaktowy',
                'country'        => 'Kraj',
                'description'    => 'Opis',
                'general'        => 'Ogólne',
                'latitude'       => 'Szerokość geograficzna',
                'longitude'      => 'Długość geograficzna',
                'name'           => 'Nazwa',
                'postcode'       => 'Kod pocztowy',
                'priority'       => 'Priorytet',
                'save-btn'       => 'Zapisz Źródło Inwentarza',
                'select-country' => 'Wybierz kraj',
                'select-state'   => 'Wybierz stan',
                'settings'       => 'Ustawienia',
                'source-address' => 'Adres źródła',
                'state'          => 'Stan',
                'status'         => 'Status',
                'street'         => 'Ulica',
                'title'          => 'Edytuj Źródła Inwentarza',
            ],

            'create-success'    => 'Źródło Inwentarza utworzone pomyślnie',
            'delete-failed'     => 'Usuwanie Źródła Inwentarza nie powiodło się',
            'delete-success'    => 'Źródło Inwentarza usunięte pomyślnie',
            'last-delete-error' => 'Ostatnie Źródło Inwentarza nie może być usunięte',
            'update-success'    => 'Źródła Inwentarza zaktualizowane pomyślnie',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Czy na pewno chcesz usunąć?',
                    'tax-category'   => 'Kategoria Podatków',
                    'title'          => 'Kategorie Podatków',

                    'datagrid' => [
                        'actions' => 'Akcje',
                        'code'    => 'Kod',
                        'delete'  => 'Usuń',
                        'edit'    => 'Edytuj',
                        'id'      => 'ID',
                        'name'    => 'Nazwa',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Dodaj Stawki Podatków',
                        'code'          => 'Kod',
                        'description'   => 'Opis',
                        'empty-text'    => 'Stawki Podatków nie są dostępne, proszę utworzyć nowe Stawki Podatków.',
                        'general'       => 'Kategoria Podatków',
                        'name'          => 'Nazwa',
                        'save-btn'      => 'Zapisz Kategorię Podatków',
                        'select'        => 'Wybierz',
                        'tax-rates'     => 'Stawki Podatków',
                        'title'         => 'Utwórz Kategorię Podatków',
                    ],

                    'edit' => [
                        'title' => 'Edytuj Kategorie Podatków',
                    ],

                    'can-not-delete' => 'Nie można usunąć kategorii przypisanych do stawek podatkowych.',
                    'create-success' => 'Nowa Kategoria Podatków utworzona',
                    'delete-failed'  => 'Usuwanie Kategorii Podatków nie powiodło się',
                    'delete-success' => 'Kategoria Podatków usunięta pomyślnie',
                    'update-success' => 'Kategoria Podatków pomyślnie zaktualizowana',
                ],
            ],

            'rates'   => [
                'index' => [
                    'button-title' => 'Utwórz stawkę podatku',
                    'tax-rate'     => 'Stawka Podatku',
                    'title'        => 'Stawki Podatków',

                    'datagrid' => [
                        'country'    => 'Kraj',
                        'delete'     => 'Usuń',
                        'edit'       => 'Edytuj',
                        'id'         => 'ID',
                        'identifier' => 'Identyfikator',
                        'state'      => 'Stan',
                        'tax-rate'   => 'Stawka Podatku',
                        'zip-code'   => 'Kod Pocztowy',
                        'zip-from'   => 'Kod Pocztowy Od',
                        'zip-to'     => 'Kod Pocztowy Do',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Wróć',
                    'country'        => 'Kraj',
                    'general'        => 'Ogólne',
                    'identifier'     => 'Identyfikator',
                    'is-zip'         => 'Włącz Zakres Kodów Pocztowych',
                    'save-btn'       => 'Zapisz Stawkę Podatku',
                    'select-country' => 'Wybierz Kraj',
                    'select-state'   => 'Wybierz Stan',
                    'settings'       => 'Ustawienia',
                    'state'          => 'Stan',
                    'tax-rate'       => 'Stawka',
                    'title'          => 'Utwórz Stawkę Podatku',
                    'zip-code'       => 'Kod Pocztowy',
                    'zip-from'       => 'Kod Pocztowy Od',
                    'zip-to'         => 'Kod Pocztowy Do',
                ],

                'edit' => [
                    'back-btn'       => 'Wróć',
                    'country'        => 'Kraj',
                    'identifier'     => 'Identyfikator',
                    'save-btn'       => 'Zapisz Stawkę Podatku',
                    'select-country' => 'Wybierz Kraj',
                    'select-state'   => 'Wybierz Stan',
                    'settings'       => 'Ustawienia',
                    'state'          => 'Stan',
                    'tax-rate'       => 'Stawka',
                    'title'          => 'Edytuj Stawkę Podatku',
                    'zip-code'       => 'Kod Pocztowy',
                    'zip-from'       => 'Kod Pocztowy Od',
                    'zip-to'         => 'Kod Pocztowy Do',
                ],

                'create-success' => 'Stawka Podatku utworzona pomyślnie',
                'delete-failed'  => 'Usuwanie Stawki Podatku nie powiodło się',
                'delete-success' => 'Stawka Podatku usunięta pomyślnie',
                'update-success' => 'Stawka Podatku zaktualizowana pomyślnie',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Utwórz Kanał',
                'delete-failed'     => 'Usunięcie Kanał nie powiodło się',
                'delete-success'    => 'Kanał pomyślnie usunięty.',
                'last-delete-error' => 'Ostatni kanał nie może zostać usunięty.',
                'title'             => 'Kanały',

                'datagrid' => [
                    'code'      => 'Kod',
                    'delete'    => 'Usuń',
                    'edit'      => 'Edytuj',
                    'host-name' => 'Nazwa Hosta',
                    'id'        => 'ID',
                    'name'      => 'Nazwa',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'Dozwolone adresy IP',
                'cancel'                  => 'Wróć',
                'code'                    => 'Kod',
                'create-success'          => 'Kanał utworzony pomyślnie.',
                'currencies'              => 'Waluty',
                'currencies-and-locales'  => 'Waluty i Lokalizacje',
                'default-currency'        => 'Domyślna Waluta',
                'default-locale'          => 'Domyślna Lokalizacja',
                'description'             => 'Opis',
                'design'                  => 'Projekt',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'Rozmiar obrazu powinien wynosić 16px na 16px',
                'general'                 => 'Ogólne',
                'hostname'                => 'Nazwa Hosta',
                'hostname-placeholder'    => 'https://www.przykład.pl (Nie dodawaj ukośnika na końcu.)',
                'inventory-sources'       => 'Źródła Inwentarza',
                'last-delete-error'       => 'Co najmniej jeden kanał jest wymagany.',
                'locales'                 => 'Lokalizacje',
                'logo'                    => 'Logo',
                'logo-size'               => 'Rozmiar obrazu powinien wynosić 192px na 50px',
                'maintenance-mode-text'   => 'Wiadomość',
                'name'                    => 'Nazwa',
                'root-category'           => 'Kategoria Główna',
                'save-btn'                => 'Zapisz Kanał',
                'select-default-currency' => 'Wybierz domyślną walutę',
                'select-default-locale'   => 'Wybierz domyślny język',
                'select-root-category'    => 'Wybierz kategorię główną',
                'select-theme'            => 'Wybierz motyw',
                'seo'                     => 'SEO na stronie głównej',
                'seo-description'         => 'Meta Opis',
                'seo-keywords'            => 'Meta Słowa Kluczowe',
                'seo-title'               => 'Meta Tytuł',
                'settings'                => 'Ustawienia',
                'status'                  => 'Status',
                'theme'                   => 'Motyw',
                'title'                   => 'Utwórz Kanał',
            ],

            'edit' => [
                'allowed-ips'            => 'Dozwolone adresy IP',
                'back-btn'               => 'Wróć',
                'code'                   => 'Kod',
                'currencies'             => 'Waluty',
                'currencies-and-locales' => 'Waluty i Lokalizacje',
                'default-currency'       => 'Domyślna Waluta',
                'default-locale'         => 'Domyślna Lokalizacja',
                'description'            => 'Opis',
                'design'                 => 'Projekt',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'Rozmiar obrazu powinien wynosić 16px na 16px',
                'general'                => 'Ogólne',
                'hostname'               => 'Nazwa Hosta',
                'hostname-placeholder'   => 'https://www.przykład.pl (Nie dodawaj ukośnika na końcu.)',
                'inventory-sources'      => 'Źródła Inwentarza',
                'last-delete-error'      => 'Co najmniej jeden kanał jest wymagany.',
                'locales'                => 'Lokalizacje',
                'logo'                   => 'Logo',
                'logo-size'              => 'Rozmiar obrazu powinien wynosić 192px na 50px',
                'maintenance-mode'       => 'Tryb konserwacji',
                'maintenance-mode-text'  => 'Wiadomość',
                'name'                   => 'Nazwa',
                'root-category'          => 'Kategoria Główna',
                'save-btn'               => 'Zapisz Kanał',
                'seo'                    => 'SEO na stronie głównej',
                'seo-description'        => 'Meta Opis',
                'seo-keywords'           => 'Meta Słowa Kluczowe',
                'seo-title'              => 'Meta Tytuł',
                'status'                 => 'Status',
                'theme'                  => 'Motyw',
                'title'                  => 'Edytuj Kanał',
                'update-success'         => 'Aktualizacja Kanału pomyślnie zakończona',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Admin',
                'title' => 'Użytkownicy',
                'user'  => 'Użytkownik',

                'create' => [
                    'confirm-password'  => 'Potwierdź Hasło',
                    'email'             => 'Email',
                    'name'              => 'Imię',
                    'password'          => 'Hasło',
                    'role'              => 'Rola',
                    'save-btn'          => 'Zapisz Użytkownika',
                    'status'            => 'Status',
                    'title'             => 'Utwórz Użytkownika',
                    'upload-image-info' => 'Wgraj zdjęcie profilowe (110px X 110px) w formacie PNG lub JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Akcje',
                    'active'   => 'Aktywny',
                    'delete'   => 'Usuń',
                    'edit'     => 'Edytuj',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Nieaktywny',
                    'name'     => 'Imię',
                    'role'     => 'Rola',
                    'status'   => 'Status',
                ],

                'edit' => [
                    'title'    => 'Edytuj Użytkownika',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Wróć',
                'confirm-password' => 'Potwierdź Hasło',
                'email'            => 'Email',
                'general'          => 'Ogólne',
                'name'             => 'Imię',
                'password'         => 'Hasło',
                'role'             => 'Rola',
                'save-btn'         => 'Zapisz Użytkownika',
                'status'           => 'Status',
                'title'            => 'Edytuj Użytkownika',
            ],

            'activate-warning'   => 'Twoje konto nie zostało jeszcze aktywowane, skontaktuj się z administratorem.',
            'cannot-change'      => 'Nie można zmienić użytkownika.',
            'create-success'     => 'Użytkownik został pomyślnie utworzony.',
            'delete-failed'      => 'Usuwanie użytkownika nie powiodło się.',
            'delete-self-error'  => 'Nie możesz usunąć własnego konta.',
            'delete-success'     => 'Użytkownik został pomyślnie usunięty.',
            'delete-warning'     => 'Czy na pewno chcesz wykonać tę akcję?',
            'incorrect-password' => 'Niepoprawne hasło',
            'last-delete-error'  => 'Usuwanie ostatniego użytkownika nie powiodło się.',
            'login-error'        => 'Sprawdź swoje dane logowania i spróbuj ponownie.',
            'update-success'     => 'Użytkownik został pomyślnie zaktualizowany.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Utwórz Rolę',
                'title'      => 'Role',

                'datagrid' => [
                    'custom'          => 'Niestandardowe',
                    'all'             => 'Wszystkie',
                    'permission-type' => 'Typ Uprawnienia',
                    'name'            => 'Nazwa',
                    'id'              => 'Id',
                    'edit'            => 'Edytuj',
                    'delete'          => 'Usuń',
                ],
            ],

            'create' => [
                'access-control' => 'Kontrola Dostępu',
                'all'            => 'Wszystkie',
                'back-btn'       => 'Wróć',
                'custom'         => 'Niestandardowe',
                'description'    => 'Opis',
                'general'        => 'Ogólne',
                'name'           => 'Nazwa',
                'permissions'    => 'Uprawnienia',
                'save-btn'       => 'Zapisz Rolę',
                'title'          => 'Utwórz Rolę',
            ],

            'edit' => [
                'access-control' => 'Kontrola Dostępu',
                'all'            => 'Wszystkie',
                'back-btn'       => 'Wróć',
                'custom'         => 'Niestandardowe',
                'description'    => 'Opis',
                'general'        => 'Ogólne',
                'name'           => 'Nazwa',
                'permissions'    => 'Uprawnienia',
                'save-btn'       => 'Zapisz Rolę',
                'title'          => 'Edytuj Rolę',
            ],

            'being-used'        => 'Rola jest już używana przez Administratora',
            'create-success'    => 'Rola utworzona pomyślnie',
            'delete-failed'     => 'Usunięcie roli nie powiodło się',
            'delete-success'    => 'Rola usunięta pomyślnie',
            'last-delete-error' => 'Ostatnia rola nie może być usunięta',
            'update-success'    => 'Rola zaktualizowana pomyślnie',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Utwórz motyw',
                'title'      => 'Motywy',

                'datagrid' => [
                    'active'        => 'Aktywny',
                    'channel_name'  => 'Nazwa kanału',
                    'change-status' => 'Zmień status',
                    'delete'        => 'Usuń',
                    'id'            => 'ID',
                    'inactive'      => 'Nieaktywny',
                    'name'          => 'Nazwa',
                    'sort-order'    => 'Kolejność sortowania',
                    'status'        => 'Status',
                    'theme'         => 'Temat',
                    'type'          => 'Typ',
                    'view'          => 'Widok',
                ],
            ],

            'create' => [
                'name'       => 'Nazwa',
                'save-btn'   => 'Zapisz motyw',
                'sort-order' => 'Kolejność sortowania',
                'themes'     => 'Motywy',
                'title'      => 'Utwórz motyw',

                'type' => [
                    'category-carousel' => 'Karuzela kategorii',
                    'footer-links'      => 'Linki stopki',
                    'image-carousel'    => 'Karuzela obrazów',
                    'product-carousel'  => 'Karuzela produktów',
                    'services-content'  => 'Treść usług',
                    'static-content'    => 'Treść statyczna',
                    'title'             => 'Typ',
                ],
            ],

            'edit' => [
                'active'                        => 'Aktywny',
                'add-filter-btn'                => 'Dodaj filtr',
                'add-footer-link-btn'           => 'Dodaj link stopki',
                'add-image-btn'                 => 'Dodaj obraz',
                'add-link'                      => 'Dodaj link',
                'asc'                           => 'rosnąco',
                'back'                          => 'Powrót',
                'category-carousel'             => 'Karuzela kategorii',
                'category-carousel-description' => 'Wyświetl dynamiczne kategorie w atrakcyjny sposób za pomocą responsywnej karuzeli kategorii.',
                'channels'                      => 'Kanały',
                'column'                        => 'Kolumna',
                'create-filter'                 => 'Utwórz filtr',
                'css'                           => 'CSS',
                'delete'                        => 'Usuń',
                'desc'                          => 'malejąco',
                'edit'                          => 'Edytuj',
                'featured'                      => 'Wyróżnione',
                'filter-title'                  => 'Tytuł',
                'filters'                       => 'Filtry',
                'footer-link'                   => 'Linki stopki',
                'footer-link-description'       => 'Nawiguj za pomocą linków stopki, aby swobodnie przeglądać witrynę i uzyskiwać informacje.',
                'footer-link-form-title'        => 'Link stopki',
                'footer-title'                  => 'Tytuł',
                'general'                       => 'Ogólne',
                'html'                          => 'HTML',
                'image'                         => 'Obraz',
                'image-size'                    => 'Rozmiar obrazu powinien wynosić (1920px X 700px)',
                'image-title'                   => 'Tytuł obrazu',
                'image-upload-message'          => 'Dozwolone są tylko obrazy (.jpeg, .jpg, .png, .webp, ..).',
                'inactive'                      => 'Nieaktywny',
                'key'                           => 'Klucz: :key',
                'key-input'                     => 'Klucz',
                'limit'                         => 'Limit',
                'link'                          => 'Link',
                'name'                          => 'Nazwa',
                'new'                           => 'Nowy',
                'no'                            => 'Nie',
                'parent-id'                     => 'Identyfikator nadrzędny',
                'parent-id-hint'                => 'Możesz wprowadzić wiele identyfikatorów nadrzędnych jako wartości oddzielone przecinkami (np. 12,15,34)',
                'category-id'                   => 'ID kategorii',
                'preview'                       => 'Podgląd',
                'product-carousel'              => 'Karuzela produktów',
                'product-carousel-description'  => 'Elegancko prezentuj produkty za pomocą dynamicznej i responsywnej karuzeli produktów.',
                'save-btn'                      => 'Zapisz',
                'select'                        => 'Wybierz',
                'slider'                        => 'Suwak',
                'slider-add-btn'                => 'Dodaj suwak',
                'slider-description'            => 'Dostosowania związane z motywem dotyczące suwaka.',
                'slider-image'                  => 'Obraz suwaka',
                'slider-required'               => 'Pole suwaka jest wymagane.',
                'sort'                          => 'Sortuj',
                'sort-order'                    => 'Kolejność sortowania',
                'static-content'                => 'Treść statyczna',
                'static-content-description'    => 'Zwiększ zaangażowanie za pomocą zwięzłej, informacyjnej treści statycznej dla swojej publiczności.',
                'status'                        => 'Status',
                'themes'                        => 'Motywy',
                'title'                         => 'Edytuj motyw',
                'update-slider'                 => 'Aktualizuj suwak',
                'url'                           => 'URL',
                'value'                         => 'Wartość: :value',
                'value-input'                   => 'Wartość',

                'services-content' => [
                    'add-btn'            => 'Dodaj usługi',
                    'channels'           => 'Kanały',
                    'delete'             => 'Usuń',
                    'description'        => 'Opis',
                    'general'            => 'Ogólne',
                    'name'               => 'Nazwa',
                    'save-btn'           => 'Zapisz',
                    'service-icon'       => 'Ikona usługi',
                    'service-icon-class' => 'Klasa ikony usługi',
                    'service-info'       => 'Dostosowanie motywów związanych z usługą.',
                    'services'           => 'Usługi',
                    'sort-order'         => 'Kolejność sortowania',
                    'status'             => 'Status',
                    'title'              => 'Tytuł',
                    'update-service'     => 'Aktualizuj usługi',
                ],
                'yes'                           => 'Tak',
            ],

            'create-success' => 'Motyw został pomyślnie utworzony',
            'delete-success' => 'Motyw został pomyślnie usunięty',
            'update-success' => 'Motyw został pomyślnie zaktualizowany',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Porzucone koszyki',
                'abandoned-products'            => 'Porzucone produkty',
                'abandoned-rate'                => 'Wskaźnik porzucenia',
                'abandoned-revenue'             => 'Przychód z porzuceń',
                'added-to-cart'                 => 'Dodane do koszyka',
                'added-to-cart-info'            => 'Tylko :progress odwiedzających dodało produkty do koszyka',
                'all-channels'                  => 'Wszystkie kanały',
                'average-order-value-over-time' => 'Średnia wartość zamówienia w czasie',
                'average-sales'                 => 'Średnia wartość zamówienia',
                'count'                         => 'Liczba',
                'end-date'                      => 'Data zakończenia',
                'id'                            => 'ID',
                'interval'                      => 'Okres',
                'name'                          => 'Nazwa',
                'orders'                        => 'Zamówienia',
                'orders-over-time'              => 'Zamówienia w czasie',
                'payment-method'                => 'Metoda płatności',
                'product-views'                 => 'Wyświetlenia produktów',
                'product-views-info'            => 'Tylko :progress odwiedzających przegląda produkty',
                'purchase-funnel'               => 'Lejek zakupowy',
                'purchased'                     => 'Kupione',
                'purchased-info'                => 'Tylko :progress odwiedzających dokonało zakupów',
                'refunds'                       => 'Zwroty',
                'refunds-over-time'             => 'Zwroty w czasie',
                'sales-over-time'               => 'Sprzedaż w czasie',
                'shipping-collected'            => 'Opłaty za dostawę',
                'shipping-collected-over-time'  => 'Opłaty za dostawę w czasie',
                'start-date'                    => 'Data rozpoczęcia',
                'tax-collected'                 => 'Opłaty podatkowe',
                'tax-collected-over-time'       => 'Opłaty podatkowe w czasie',
                'title'                         => 'Sprzedaż',
                'top-payment-methods'           => 'Najpopularniejsze metody płatności',
                'top-shipping-methods'          => 'Najpopularniejsze metody dostawy',
                'top-tax-categories'            => 'Najpopularniejsze kategorie podatkowe',
                'total'                         => 'Razem',
                'total-orders'                  => 'Łącznie zamówień',
                'total-sales'                   => 'Łącznie sprzedaży',
                'total-visits'                  => 'Liczba odwiedzin',
                'total-visits-info'             => 'Liczba odwiedzających w sklepie',
                'view-details'                  => 'Zobacz szczegóły',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Wszystkie kanały',
                'count'                       => 'Liczba',
                'customers'                   => 'Klienci',
                'customers-over-time'         => 'Klienci w czasie',
                'customers-traffic'           => 'Ruch klientów',
                'customers-with-most-orders'  => 'Klienci z największą liczbą zamówień',
                'customers-with-most-reviews' => 'Klienci z największą liczbą opinii',
                'customers-with-most-sales'   => 'Klienci z największą liczbą sprzedaży',
                'email'                       => 'E-mail',
                'end-date'                    => 'Data zakończenia',
                'id'                          => 'ID',
                'interval'                    => 'Okres',
                'name'                        => 'Nazwa',
                'orders'                      => 'Zamówienia',
                'reviews'                     => 'Opinie',
                'start-date'                  => 'Data rozpoczęcia',
                'title'                       => 'Klienci',
                'top-customer-groups'         => 'Najpopularniejsze grupy klientów',
                'total'                       => 'Razem',
                'total-customers'             => 'Łącznie klientów',
                'total-visitors'              => 'Liczba odwiedzających',
                'traffic-over-week'           => 'Ruch przez tydzień',
                'unique-visitors'             => 'Unikalni odwiedzający',
                'view-details'                => 'Zobacz szczegóły',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Wszystkie kanały',
                'channel'                          => 'Kanał',
                'end-date'                         => 'Data zakończenia',
                'id'                               => 'ID',
                'interval'                         => 'Okres',
                'last-search-terms'                => 'Ostatnio wyszukiwane słowa',
                'locale'                           => 'Lokalizacja',
                'name'                             => 'Nazwa',
                'orders'                           => 'Zamówienia',
                'price'                            => 'Cena',
                'products-added-over-time'         => 'Produkty dodane w czasie',
                'products-with-most-reviews'       => 'Produkty z największą liczbą opinii',
                'products-with-most-visits'        => 'Produkty z największą liczbą odwiedzin',
                'quantities'                       => 'Ilości',
                'quantities-sold-over-time'        => 'Ilości sprzedane w czasie',
                'results'                          => 'Wyniki',
                'revenue'                          => 'Przychód',
                'reviews'                          => 'Opinie',
                'search-term'                      => 'Słowo kluczowe',
                'start-date'                       => 'Data rozpoczęcia',
                'title'                            => 'Produkty',
                'top-search-terms'                 => 'Najczęściej wyszukiwane słowa',
                'top-selling-products-by-quantity' => 'Najpopularniejsze produkty pod względem ilości',
                'top-selling-products-by-revenue'  => 'Najpopularniejsze produkty pod względem przychodu',
                'total'                            => 'Razem',
                'total-products-added-to-wishlist' => 'Produkty dodane do listy życzeń',
                'total-sold-quantities'            => 'Łączna liczba sprzedanych produktów',
                'uses'                             => 'Zastosowania',
                'view-details'                     => 'Zobacz szczegóły',
                'visits'                           => 'Odwiedzania',
            ],
        ],

        'view' => [
            'all-channels'  => 'Wszystkie kanały',
            'back-btn'      => 'Wstecz',
            'day'           => 'Dzień',
            'end-date'      => 'Data zakończenia',
            'export-csv'    => 'Eksportuj do formatu CSV',
            'export-xls'    => 'Eksportuj do formatu XLS',
            'month'         => 'Miesiąc',
            'not-available' => 'Brak dostępnych rekordów.',
            'start-date'    => 'Data rozpoczęcia',
            'year'          => 'Rok',
        ],

        'empty' => [
            'info'  => 'Brak danych dla wybranego okresu',
            'title' => 'Brak dostępnych danych',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Powrót',
            'delete'                       => 'Usuń',
            'enable-at-least-one-payment'  => 'Włącz co najmniej jedną metodę płatności.',
            'enable-at-least-one-shipping' => 'Włącz co najmniej jedną metodę wysyłki.',
            'no-result-found'              => 'Nie znaleziono wyników',
            'save-btn'                     => 'Zapisz konfigurację',
            'save-message'                 => 'Konfiguracja zapisana pomyślnie',
            'search'                       => 'Szukaj',
            'select-country'               => 'Wybierz kraj',
            'select-state'                 => 'Wybierz stan',
            'title'                        => 'Konfiguracja',

            'general' => [
                'info'  => 'Ustaw opcje jednostek.',
                'title' => 'Ogólne',

                'general' => [
                    'info'  => 'Skonfiguruj ustawienia jednostek oraz włącz lub wyłącz opcje ścieżki nawigacyjnej i odwiedzających.',
                    'title' => 'Ogólne',

                    'unit-options' => [
                        'info'        => 'Ustaw opcje jednostek.',
                        'title'       => 'Opcje jednostek',
                        'title-info'  => 'Skonfiguruj wagę w funtach (lbs) lub kilogramach (kg).',
                        'weight-unit' => 'Jednostka wagi',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Ścieżka nawigacyjna sklepu',
                        'title'      => 'Ścieżka nawigacyjna',
                        'title-info' => 'Włącz lub wyłącz nawigację ścieżki nawigacyjnej w sklepie.',
                    ],

                    'visitor-options' => [
                        'enable'     => 'Włącz opcje odwiedzających',
                        'title'      => 'Opcje odwiedzających',
                        'title-info' => 'Pozwala kontrolować witrynę w celu śledzenia i liczenia liczby wizyt, pomagając monitorować ogólną aktywność i zaangażowanie odwiedzających.',
                    ],
                ],

                'content' => [
                    'info'  => 'Ustaw tytuł oferty w nagłówku i niestandardowe skrypty.',
                    'title' => 'Zawartość',

                    'header-offer' => [
                        'title'             => 'Tytuł oferty w nagłówku',
                        'title-info'        => 'Skonfiguruj tytuł oferty w nagłówku z tytułem oferty, tytułem przekierowania i linkiem przekierowania.',
                        'offer-title'       => 'Tytuł oferty',
                        'redirection-title' => 'Tytuł przekierowania',
                        'redirection-link'  => 'Link przekierowania',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Włącz reguły spekulacji',
                        'info'               => 'Skonfiguruj ustawienia włączania lub wyłączania automatycznej logiki spekulacji.',
                        'title'              => 'Reguły spekulacji',

                        'prerender' => [
                            'conservative'           => 'Konserwatywny',
                            'eager'                  => 'Chętny',
                            'eagerness'              => 'Poziom chęci prerenderowania',
                            'eagerness-info'         => 'Kontroluje, jak agresywnie stosowane są reguły spekulacji. Opcje: chętny (maksymalny), umiarkowany (domyślny), konserwatywny (niski).',
                            'enabled'                => 'Włącz reguły spekulacji prerender',
                            'ignore-url-params'      => 'Ignoruj parametry URL prerender',
                            'ignore-url-params-info' => 'Określ parametry URL do ignorowania w regułach spekulacji. Użyj znaku pipe (|) do oddzielenia wielu parametrów.',
                            'ignore-urls'            => 'Ignoruj URL prerender',
                            'ignore-urls-info'       => 'Wprowadź adresy URL do wykluczenia z logiki spekulacji. Oddziel wiele adresów pipe\'em (|).',
                            'info'                   => 'Ustaw status reguł spekulacji.',
                            'moderate'               => 'Umiarkowany',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Konserwatywny',
                            'eager'                  => 'Chętny',
                            'eagerness'              => 'Poziom chęci prefetch',
                            'eagerness-info'         => 'Kontroluje, jak agresywnie stosowane są reguły spekulacji. Opcje: chętny (maksymalny), umiarkowany (domyślny), konserwatywny (niski).',
                            'enabled'                => 'Włącz reguły spekulacji prefetch',
                            'ignore-url-params'      => 'Ignoruj parametry URL prefetch',
                            'ignore-url-params-info' => 'Określ parametry URL do ignorowania w regułach spekulacji. Użyj znaku pipe (|) do oddzielenia wielu parametrów.',
                            'ignore-urls'            => 'Ignoruj URL prefetch',
                            'ignore-urls-info'       => 'Wprowadź adresy URL do wykluczenia z logiki spekulacji. Oddziel wiele adresów pipe\'em (|).',
                            'info'                   => 'Ustaw status reguł spekulacji.',
                            'moderate'               => 'Umiarkowany',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'Niestandardowy CSS',
                        'custom-javascript' => 'Niestandardowy JavaScript',
                        'title'             => 'Niestandardowe skrypty',
                        'title-info'        => 'Niestandardowe skrypty to spersonalizowane fragmenty kodu stworzone w celu dodania określonych funkcji lub cech do oprogramowania, zwiększając jego możliwości w unikalny sposób.',
                    ],
                ],

                'design' => [
                    'info'  => 'Ustaw logo i ikonę favicon dla panelu administratora.',
                    'title' => 'Projektowanie',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Obraz logo',
                        'title'      => 'Logo administratora',
                        'title-info' => 'Skonfiguruj obrazy logo i favicon dla front-endu Twojej witryny, aby poprawić rozpoznawalność i branding.',
                    ],

                    'menu-category' => [
                        'default'         => 'Domyślne menu',
                        'info'            => 'To ustawienie kontroluje widoczność kategorii w menu nagłówka. Możesz wybrać wyświetlanie tylko kategorii nadrzędnych lub wszystkich zagnieżdżonych kategorii.',
                        'preview-default' => 'Podgląd domyślnego menu',
                        'preview-sidebar' => 'Podgląd menu bocznego',
                        'sidebar'         => 'Menu boczne',
                        'title'           => 'Widok kategorii menu',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Ustaw opcje Magic AI i zezwól na niektóre opcje automatyzacji tworzenia treści.',
                    'title' => 'Magiczna AI',

                    'settings' => [
                        'api-key'        => 'Klucz API',
                        'enabled'        => 'Włączone',
                        'llm-api-domain' => 'Domena LLM API',
                        'organization'   => 'Organizacja',
                        'title'          => 'Ustawienia ogólne',
                        'title-info'     => 'Ulepsz swoje doświadczenie z funkcją Magic AI, wprowadzając swój wyłączny klucz API i wskazując odpowiednią organizację dla łatwej integracji. Opanuj swoje poświadczenia OpenAI i dostosuj ustawienia według swoich konkretnych potrzeb.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Podpowiedź opisu kategorii',
                        'cms-page-content-prompt'          => 'Podpowiedź treści strony CMS',
                        'enabled'                          => 'Włączone',
                        'product-description-prompt'       => 'Podpowiedź opisu produktu',
                        'product-short-description-prompt' => 'Podpowiedź krótkiego opisu produktu',
                        'title'                            => 'Generowanie treści',
                        'title-info'                       => 'Ta funkcja umożliwi włączenie Magic AI dla każdego edytora WYSIWYG, w którym chcesz zarządzać treścią za pomocą sztucznej inteligencji.<br/><br/>Po włączeniu przejdź do dowolnego edytora, aby wygenerować treść.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Włączone',
                        'title'      => 'Generowanie obrazów',
                        'title-info' => 'Ta funkcja umożliwi włączenie Magic AI dla każdego przesyłania obrazu, w którym chcesz generować obrazy za pomocą DALL-E.<br/><br/>Po włączeniu przejdź do dowolnego przesyłania obrazu, aby wygenerować obraz.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Włączone',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Model',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Tłumaczenie recenzji',
                        'title-info'          => 'Zapewnij klientowi lub odwiedzającemu opcję przetłumaczenia recenzji klienta na język angielski.<br/><br/>Po włączeniu przejdź do recenzji i znajdziesz przycisk „Przetłumacz na angielski”, jeśli recenzja jest w innym języku niż angielski.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Włączone',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Model',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Podpowiedź',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Spersonalizowana wiadomość przy kasie',
                        'title-info'          => 'Stwórz spersonalizowaną wiadomość przy kasie dla klientów na stronie podziękowania, dostosowując treść do indywidualnych preferencji i poprawiając ogólne doświadczenie po zakupie.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Ustawienia zgodności z GDPR',

                    'settings' => [
                        'title'   => 'Ustawienia zgodności z GDPR',
                        'info'    => 'Zarządzaj ustawieniami zgodności z GDPR, w tym polityką prywatności. Włącz lub wyłącz funkcje GDPR w razie potrzeby.',
                        'enabled' => 'Włącz GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Zgoda GDPR',
                        'info'           => 'Zarządzaj zgodą klientów zgodnie z przepisami GDPR. Włącz obowiązkową zgodę na zbieranie i przetwarzanie danych.',
                        'enable'         => 'Włącz zgodę klienta',
                        'checkbox-label' => 'Etykieta pola zgody',
                        'content'        => 'Treść zgody',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'Lewy dolny róg',
                        'bottom-right' => 'Prawy dolny róg',
                        'center'       => 'Centrum',
                        'description'  => 'Opis',
                        'enable'       => 'Włącz powiadomienie o plikach cookie',
                        'identifier'   => 'ID bloku statycznego',
                        'info'         => 'Skonfiguruj ustawienia zgody na pliki cookie, aby informować użytkowników o zbieraniu danych i zgodności z polityką prywatności.',
                        'position'     => 'Pozycja bloku cookie',
                        'title'        => 'Ustawienia powiadomień o plikach cookie',
                        'top-left'     => 'Lewy górny róg',
                        'top-right'    => 'Prawy górny róg',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Zarządzaj ustawieniami plików cookie',
                        'info'                   => 'Wybierz preferowane ustawienia plików cookie, aby zarządzać wykorzystaniem danych. Skonfiguruj zgody na różne rodzaje plików cookie.',
                        'strictly-necessary'     => 'Ściśle niezbędne',
                        'basic-interaction'      => 'Podstawowa interakcja i funkcjonalność',
                        'experience-enhancement' => 'Poprawa doświadczenia',
                        'measurement'            => 'Pomiar',
                        'targeting-advertising'  => 'Targetowanie i reklamy',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Ustaw opcje mapy witryny.',
                    'title' => 'Mapa witryny',

                    'settings' => [
                        'enabled' => 'Włączone',
                        'info'    => 'Włącz lub wyłącz mapę witryny dla swojej strony internetowej, aby poprawić optymalizację wyszukiwarek i poprawić doświadczenia użytkowników.',
                        'title'   => 'Ustawienia',
                    ],

                    'file-limits' => [
                        'info'             => 'Ustaw opcje limitów plików.',
                        'max-file-size'    => 'Maksymalny rozmiar pliku',
                        'max-url-per-file' => 'Maksymalna liczba URL na plik',
                        'title'            => 'Limity plików',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Katalog',
                'title' => 'Katalog',

                'products' => [
                    'info'  => 'Strona widoku produktu, strona widoku koszyka, strona główna sklepu, recenzja i społecznościowe udostępnianie atrybutów.',
                    'title' => 'Produkty',

                    'settings' => [
                        'compare-options'     => 'Opcje porównywania',
                        'image-search-option' => 'Opcja wyszukiwania obrazem',
                        'title'               => 'Ustawienia',
                        'title-info'          => 'Ustawienia odnoszą się do konfigurowalnych wyborów, które kontrolują zachowanie systemu, aplikacji lub urządzenia, dostosowane do preferencji i wymagań użytkownika.',
                        'wishlist-options'    => 'Opcje listy życzeń',
                    ],

                    'search' => [
                        'admin-mode'            => 'Tryb wyszukiwania w panelu administratora',
                        'admin-mode-info'       => 'Wyszukiwanie w trybie mega, siatki danych i inne funkcje wyszukiwania w panelu administratora będą oparte na wybranym silniku wyszukiwania.',
                        'database'              => 'Baza danych',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Maksymalna długość zapytania',
                        'max-query-length-info' => 'Ustaw maksymalną długość zapytania dla zapytań wyszukiwania.',
                        'min-query-length'      => 'Minimalna długość zapytania',
                        'min-query-length-info' => 'Ustaw minimalną długość zapytania dla zapytań wyszukiwania.',
                        'search-engine'         => 'Silnik wyszukiwania',
                        'storefront-mode'       => 'Tryb wyszukiwania w witrynie sklepu',
                        'storefront-mode-info'  => 'Funkcja wyszukiwania na stronie sklepu będzie oparta na wybranym silniku wyszukiwania, w tym na stronie kategorii, stronie wyszukiwania i innych funkcjach wyszukiwania.',
                        'title'                 => 'Wyszukiwanie',
                        'title-info'            => 'Aby skonfigurować silnik wyszukiwania dla wyszukiwania produktów, możesz wybrać między bazą danych a Elasticsearch w zależności od swoich wymagań. Jeśli masz dużą liczbę produktów, zaleca się Elasticsearch.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Zezwalaj na zamówienia gości',
                        'allow-guest-checkout-hint' => 'Wskazówka: Jeśli jest włączone, tę opcję można skonfigurować dla każdego produktu.',
                        'title'                     => 'Zamówienie gościa',
                        'title-info'                => 'Zamówienie gościa umożliwia klientom zakup produktów bez tworzenia konta, upraszczając proces zakupu dla wygody i szybszych transakcji.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Dozwolona liczba powiązanych produktów',
                        'allow-no-of-up-sells-products' => 'Dozwolona liczba produktów Up-Sell',
                        'title'                         => 'Konfiguracja strony widoku produktu',
                        'title-info'                    => 'Konfiguracja strony widoku produktu polega na dostosowaniu układu i elementów na stronie wyświetlania produktu, poprawiając doświadczenie użytkownika i prezentację informacji.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Dozwolona liczba produktów Cross-Sell',
                        'title'                            => 'Konfiguracja strony widoku koszyka',
                        'title-info'                       => 'Konfiguracja strony widoku koszyka polega na rozmieszczeniu przedmiotów, szczegółów i opcji na stronie koszyka, poprawiając interakcję użytkownika i proces zakupu.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Zezwalaj klientom na bezpośrednie zakupowanie produktów',
                        'cheapest-first'         => 'Najtańsze najpierw',
                        'comma-separated'        => 'Oddzielone przecinkami',
                        'default-list-mode'      => 'Domyślny tryb listy',
                        'expensive-first'        => 'Najdroższe najpierw',
                        'from-a-z'               => 'Od A do Z',
                        'from-z-a'               => 'Od Z do A',
                        'grid'                   => 'Siatka',
                        'latest-first'           => 'Najnowsze najpierw',
                        'list'                   => 'Lista',
                        'oldest-first'           => 'Najstarsze najpierw',
                        'products-per-page'      => 'Produkty na stronę',
                        'sort-by'                => 'Sortuj według',
                        'title'                  => 'Witryna sklepu',
                        'title-info'             => 'Witryna sklepu to interfejs skierowany do klienta sklepu internetowego, prezentujący produkty, kategorie i nawigację dla płynnego doświadczenia zakupowego.',
                    ],

                    'small-image' => [
                        'height'      => 'Wysokość',
                        'placeholder' => 'Miejsce na mały obraz',
                        'title'       => 'Mały obraz',
                        'title-info'  => 'Witryna sklepu to interfejs skierowany do klienta sklepu internetowego, prezentujący produkty, kategorie i nawigację dla płynnego doświadczenia zakupowego.',
                        'width'       => 'Szerokość',
                    ],

                    'medium-image' => [
                        'height'      => 'Wysokość',
                        'placeholder' => 'Miejsce na średni obraz',
                        'title'       => 'Średni obraz',
                        'title-info'  => 'Średni obraz odnosi się do obrazu o umiarkowanym rozmiarze, który oferuje równowagę między szczegółami a przestrzenią na ekranie, często używany do wizualizacji.',
                        'width'       => 'Szerokość',
                    ],

                    'large-image' => [
                        'height'      => 'Wysokość',
                        'placeholder' => 'Miejsce na duży obraz',
                        'title'       => 'Duży obraz',
                        'title-info'  => 'Duży obraz przedstawia obraz o wysokiej rozdzielczości, zapewniający lepsze szczegóły i efekt wizualny, często używany do prezentacji produktów lub grafik.',
                        'width'       => 'Szerokość',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Zezwalaj na recenzje klientów',
                        'allow-guest-review'      => 'Zezwalaj na recenzje gości',
                        'censoring-reviewer-name' => 'Cenzurowanie Nazwy Recenzenta',
                        'display-review-count'    => 'Wyświetl liczbę recenzji dla ocen.',
                        'display-star-count'      => 'Wyświetl liczbę gwiazdek w ocenach.',
                        'summary'                 => 'Streszczenie',
                        'title'                   => 'Recenzja',
                        'title-info'              => 'Ocena lub ocena czegoś, często obejmująca opinie i informacje zwrotne.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Dozwolony rozmiar przesyłanego pliku (w Kb)',
                        'image-upload-size' => 'Dozwolony rozmiar przesyłanego obrazu (w Kb)',
                        'title'             => 'Atrybut',
                        'title-info'        => 'Cecha lub właściwość definiująca obiekt, wpływająca na jego zachowanie, wygląd lub funkcję.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Skonfiguruj ustawienia udostępniania społecznościowego, aby umożliwić udostępnianie produktów na Instagramie, Twitterze, WhatsApp, Facebooku, Pinterest, LinkedIn i za pośrednictwem poczty elektronicznej.',
                        'title'                       => 'Udostępnianie społecznościowe',
                        'share-message'               => 'Wiadomość udostępniania',
                        'share'                       => 'Udostępnij',
                        'enable-social-share'         => 'Włącz udostępnianie społecznościowe?',
                        'enable-share-whatsapp-info'  => 'Link do udostępniania w aplikacji WhatsApp pojawi się tylko na urządzeniach mobilnych.',
                        'enable-share-whatsapp'       => 'Włącz udostępnianie w aplikacji WhatsApp?',
                        'enable-share-twitter'        => 'Włącz udostępnianie na Twitterze?',
                        'enable-share-pinterest'      => 'Włącz udostępnianie na Pinterest?',
                        'enable-share-linkedin'       => 'Włącz udostępnianie na LinkedIn?',
                        'enable-share-facebook'       => 'Włącz udostępnianie na Facebooku?',
                        'enable-share-email'          => 'Włącz udostępnianie w wiadomości e-mail?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Ustawienia dotyczące produktów i kategorii.',
                    'title' => 'Bogate fragmenty',

                    'products' => [
                        'enable'          => 'Włącz',
                        'show-categories' => 'Pokaż kategorie',
                        'show-images'     => 'Pokaż obrazy',
                        'show-offers'     => 'Pokaż oferty',
                        'show-ratings'    => 'Pokaż oceny',
                        'show-reviews'    => 'Pokaż recenzje',
                        'show-sku'        => 'Pokaż SKU',
                        'show-weight'     => 'Pokaż wagę',
                        'title'           => 'Produkty',
                        'title-info'      => 'Skonfiguruj ustawienia produktu, w tym SKU, wagę, kategorie, obrazy, recenzje, oceny, oferty itp.',
                    ],

                    'categories' => [
                        'enable'                  => 'Włącz',
                        'show-search-input-field' => 'Pokaż pole wyszukiwania',
                        'title'                   => 'Kategorie',
                        'title-info'              => '"Kategorie" odnoszą się do grup lub klasyfikacji, które pomagają zorganizować i grupować podobne produkty lub przedmioty dla łatwiejszego przeglądania i nawigacji.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Stan magazynu',
                    'title-info' => 'Skonfiguruj ustawienia zapasów, aby umożliwić zamówienia z oczekiwaniem i zdefiniować próg braku towaru.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Zezwalaj na zamówienia z oczekiwaniem',
                        'max-qty-allowed-in-cart' => 'Maksymalna ilość dozwolona w koszyku',
                        'min-qty-allowed-in-cart' => 'Minimalna ilość dozwolona w koszyku',
                        'out-of-stock-threshold'  => 'Próg braku towaru',
                        'title'                   => 'Opcja zapasów produktów',
                        'info'                    => 'Skonfiguruj opcje zapasów produktu, aby umożliwić zamówienia wsteczne, ustawić minimalne i maksymalne ilości w koszyku oraz zdefiniować progi braku towaru.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Klient',
                'title' => 'Klient',

                'address' => [
                    'info'  => 'Ustaw kraj, stan, kod pocztowy i linie w adresie ulicy.',
                    'title' => 'Adres',

                    'requirements' => [
                        'city'       => 'Miasto',
                        'country'    => 'Kraj',
                        'state'      => 'Stan',
                        'title'      => 'Wymagania',
                        'title-info' => 'Wymagania to warunki, cechy lub specyfikacje niezbędne do spełnienia, osiągnięcia lub pomyślnego spełnienia czegoś.',
                        'zip'        => 'Kod pocztowy',
                    ],

                    'information' => [
                        'street-lines' => 'Linie w adresie ulicy',
                        'title'        => 'Informacje',
                        'title-info'   => '"Linie w adresie ulicy" odnoszą się do poszczególnych segmentów adresu, często oddzielonych przecinkami, dostarczających informacje o lokalizacji, takie jak numer domu, ulica, miasto i inne.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Ustaw klucz witryny, klucz tajny i status.',
                    'title' => 'Google Captcha',

                    'credentials' => [
                        'secret-key' => 'Klucz tajny',
                        'site-key'   => 'Klucz witryny',
                        'status'     => 'Status',
                        'title'      => 'Dane uwierzytelniające',
                        'title-info' => '"Mapa witryny: Mapa układu witryny dla wyszukiwarek. Klucz tajny: Bezpieczny kod do szyfrowania danych, uwierzytelniania lub ochrony dostępu do interfejsu API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Coś poszło nie tak! Spróbuj ponownie.',
                        'required' => 'Proszę wybrać CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Ustaw listę życzeń, przekierowanie logowania, subskrypcje newslettera, opcję domyślnej grupy, weryfikację e-maili i logowanie społecznościowe.',
                    'title'         => 'Ustawienia',

                    'login-as-customer' => [
                        'allow-option' => 'Zezwól na logowanie jako klient',
                        'title'        => 'Logowanie jako klient',
                        'title-info'   => 'Włącz funkcję "Logowanie jako klient".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Zezwól na opcję listy życzeń',
                        'title'        => 'Lista życzeń',
                        'title-info'   => 'Włącz lub wyłącz opcję listy życzeń.',
                    ],

                    'login-options' => [
                        'account'          => 'Konto',
                        'home'             => 'Strona główna',
                        'redirect-to-page' => 'Przekieruj klienta do wybranej strony',
                        'title'            => 'Opcje logowania',
                        'title-info'       => 'Skonfiguruj opcje logowania, aby określić stronę przekierowania dla klientów po zalogowaniu.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Zezwól na newsletter',
                        'news-letter-info' => 'Włącz opcję subskrypcji newslettera na stronie rejestracji.',
                        'title'            => 'Opcje tworzenia nowego konta',
                        'title-info'       => 'Ustaw opcje dla nowych kont, w tym przypisanie domyślnej grupy klientów i włączenie opcji subskrypcji newslettera podczas rejestracji.',

                        'default-group' => [
                            'general'    => 'Ogólne',
                            'guest'      => 'Gość',
                            'title'      => 'Domyślna grupa',
                            'title-info' => 'Przypisz określoną grupę klientów jako domyślną dla nowych klientów.',
                            'wholesale'  => 'Hurtownia',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Zezwól na subskrypcję newslettera',
                        'title'        => 'Subskrypcja newslettera',
                        'title-info'   => '"Informacje o newsletterze" zawierają aktualizacje, oferty lub treści regularnie udostępniane subskrybentom za pośrednictwem wiadomości e-mail, informując ich i angażując.',
                    ],

                    'email' => [
                        'email-verification' => 'Zezwól na weryfikację emaili',
                        'title'              => 'Weryfikacja emaili',
                        'title-info'         => '"Weryfikacja emaili" potwierdza autentyczność adresu e-mail, często poprzez wysłanie linku potwierdzającego, zwiększając bezpieczeństwo konta i niezawodność komunikacji.',
                    ],

                    'social-login' => [
                        'title' => 'Logowanie Społecznościowe',
                        'info'  => '"Logowanie społecznościowe" umożliwia użytkownikom dostęp do witryny za pomocą kont mediów społecznościowych, upraszczając proces rejestracji i logowania.',

                        'google' => [
                            'enable-google' => 'Włącz Google',

                            'client-id' => [
                                'title'      => 'ID klienta',
                                'title-info' => 'Unikalny identyfikator przyznany przez Google podczas tworzenia aplikacji OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Sekret klienta',
                                'title-info' => 'Tajny klucz powiązany z klientem OAuth Google. Zachowaj go w tajemnicy.',
                            ],

                            'redirect' => [
                                'title'      => 'URL przekierowania',
                                'title-info' => 'Adres URL przekierowania, na który użytkownicy są wysyłani po uwierzytelnieniu przez Google. Musi być zgodny z adresem skonfigurowanym w konsoli Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Włącz Facebook',

                            'client-id' => [
                                'title'      => 'ID klienta',
                                'title-info' => 'ID aplikacji przyznane przez Facebook podczas tworzenia aplikacji w konsoli deweloperskiej Facebooka.',
                            ],

                            'client-secret' => [
                                'title'      => 'Sekret klienta',
                                'title-info' => 'Tajny klucz powiązany z aplikacją Facebook. Zachowaj go w bezpieczeństwie i prywatności.',
                            ],

                            'redirect' => [
                                'title'      => 'URL przekierowania',
                                'title-info' => 'Adres URL przekierowania po uwierzytelnieniu przez Facebook. Musi być zgodny z adresem skonfigurowanym w ustawieniach aplikacji Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Włącz GitHub',

                            'client-id' => [
                                'title'      => 'ID klienta',
                                'title-info' => 'Unikalny identyfikator przyznany przez GitHub podczas tworzenia aplikacji OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Sekret klienta',
                                'title-info' => 'Tajny klucz powiązany z klientem OAuth GitHub. Zachowaj go w tajemnicy.',
                            ],

                            'redirect' => [
                                'title'      => 'URL przekierowania',
                                'title-info' => 'Adres URL przekierowania po uwierzytelnieniu przez GitHub. Musi być zgodny z adresem skonfigurowanym w konsoli GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Włącz LinkedIn',

                            'client-id' => [
                                'title'      => 'ID klienta',
                                'title-info' => 'Unikalny identyfikator przyznany przez LinkedIn podczas tworzenia aplikacji OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Sekret klienta',
                                'title-info' => 'Tajny klucz powiązany z klientem OAuth LinkedIn. Zachowaj go w tajemnicy.',
                            ],

                            'redirect' => [
                                'title'      => 'URL przekierowania',
                                'title-info' => 'Adres URL przekierowania po uwierzytelnieniu przez LinkedIn. Musi być zgodny z adresem skonfigurowanym w konsoli LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Włącz Twitter',

                            'client-id' => [
                                'title'      => 'ID klienta',
                                'title-info' => 'Unikalny identyfikator przyznany przez Twitter podczas tworzenia aplikacji OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Sekret klienta',
                                'title-info' => 'Tajny klucz powiązany z klientem OAuth Twitter. Zachowaj go w tajemnicy.',
                            ],

                            'redirect' => [
                                'title'      => 'URL przekierowania',
                                'title-info' => 'Adres URL przekierowania po uwierzytelnieniu przez Twitter. Musi być zgodny z adresem skonfigurowanym w konsoli Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'E-mail',
                'title' => 'E-mail',

                'email-settings' => [
                    'admin-email'           => 'E-mail administratora',
                    'admin-email-tip'       => 'Adres e-mail administratora tego kanału, na który będą wysyłane wiadomości e-mail',
                    'admin-name'            => 'Nazwa administratora',
                    'admin-name-tip'        => 'Ta nazwa będzie wyświetlana we wszystkich wiadomościach e-mail administratora',
                    'admin-page-limit'      => 'Domyślna liczba elementów na stronę (administrator)',
                    'contact-email'         => 'E-mail kontaktowy',
                    'contact-email-tip'     => 'Adres e-mail, który będzie wyświetlany na dole Twoich wiadomości e-mail',
                    'contact-name'          => 'Nazwa kontaktowa',
                    'contact-name-tip'      => 'Ta nazwa będzie wyświetlana na dole Twoich wiadomości e-mail',
                    'email-sender-name'     => 'Nazwa nadawcy e-mail',
                    'email-sender-name-tip' => 'Ta nazwa będzie wyświetlana w skrzynce odbiorczej klientów',
                    'info'                  => 'Ustaw nazwę nadawcy e-mail, adres e-mail sklepu, nazwę administratora i adres e-mail administratora.',
                    'shop-email-from'       => 'Adres e-mail sklepu',
                    'shop-email-from-tip'   => 'Adres e-mail tego kanału, na który będą wysyłane wiadomości e-mail do Twoich klientów',
                    'title'                 => 'Ustawienia e-mail',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Wyślij powiadomienie do klienta po anulowaniu zamówienia',
                    'cancel-order-mail-to-admin'                       => 'Wyślij powiadomienie e-mail do administratora po anulowaniu zamówienia',
                    'customer'                                         => 'Wyślij dane konta klienta po rejestracji',
                    'customer-registration-confirmation-mail-to-admin' => 'Wyślij e-mail potwierdzający do administratora po rejestracji klienta',
                    'info'                                             => 'Skonfiguruj odbieranie wiadomości e-mail w celu weryfikacji konta, potwierdzenia zamówień, aktualizacji faktur, zwrotów, wysyłek i anulowania zamówień.',
                    'new-inventory-source'                             => 'Wyślij e-mail powiadomienia do źródła zapasów po utworzeniu wysyłki',
                    'new-invoice'                                      => 'Wyślij e-mail powiadomienia do klienta po utworzeniu nowej faktury',
                    'new-invoice-mail-to-admin'                        => 'Wyślij e-mail powiadomienia do administratora po utworzeniu nowej faktury',
                    'new-order'                                        => 'Wyślij e-mail potwierdzający do klienta po złożeniu nowego zamówienia',
                    'new-order-mail-to-admin'                          => 'Wyślij e-mail potwierdzający do administratora po złożeniu nowego zamówienia',
                    'new-refund'                                       => 'Wyślij e-mail powiadomienia do klienta po utworzeniu zwrotu',
                    'new-refund-mail-to-admin'                         => 'Wyślij e-mail powiadomienia do administratora po utworzeniu nowego zwrotu',
                    'new-shipment'                                     => 'Wyślij e-mail powiadomienia do klienta po utworzeniu wysyłki',
                    'new-shipment-mail-to-admin'                       => 'Wyślij e-mail powiadomienia do administratora po utworzeniu nowej wysyłki',
                    'registration'                                     => 'Wyślij e-mail potwierdzający po rejestracji klienta',
                    'title'                                            => 'Powiadomienia',
                    'verification'                                     => 'Wyślij e-mail weryfikacyjny po rejestracji klienta',
                ],
            ],

            'sales' => [
                'info'  => 'Sprzedaż',
                'title' => 'Sprzedaż',

                'shipping-setting' => [
                    'info'  => 'Skonfiguruj ustawienia wysyłki, w tym kraj, stan, miasto, adres ulicy, kod pocztowy, nazwę sklepu, numer VAT, numer kontaktowy i dane bankowe.',
                    'title' => 'Ustawienia wysyłki',

                    'origin' => [
                        'bank-details'   => 'Dane bankowe',
                        'city'           => 'Miasto',
                        'contact-number' => 'Numer kontaktowy',
                        'country'        => 'Kraj',
                        'state'          => 'Stan',
                        'store-name'     => 'Nazwa sklepu',
                        'street-address' => 'Adres ulicy',
                        'title'          => 'Pochodzenie',
                        'title-info'     => 'Pochodzenie wysyłki odnosi się do miejsca, z którego towary lub produkty pochodzą przed ich transportem do miejsca docelowego.',
                        'vat-number'     => 'Numer VAT',
                        'zip'            => 'Kod pocztowy',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Skonfiguruj metody wysyłki, w tym Darmowa wysyłka, Stała stawka i dodatkowe opcje według potrzeb.',
                    'title' => 'Metody wysyłki',

                    'free-shipping' => [
                        'description' => 'Opis',
                        'page-title'  => 'Darmowa wysyłka',
                        'status'      => 'Status',
                        'title'       => 'Tytuł',
                        'title-info'  => '"Darmowa wysyłka" odnosi się do metody wysyłki, w której koszt wysyłki jest zwolniony, a sprzedawca pokrywa koszty wysyłki dla dostarczenia towarów do kupującego.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Opis',
                        'page-title'  => 'Wysyłka z stałą stawką',
                        'rate'        => 'Stawka',
                        'status'      => 'Status',
                        'title'       => 'Tytuł',
                        'title-info'  => 'Wysyłka z stałą stawką to metoda wysyłki, w której pobierana jest stała opłata za wysyłkę, niezależnie od wagi, rozmiaru lub odległości paczki. Uproszcza to koszty wysyłki i może być korzystne zarówno dla kupujących, jak i sprzedawców.',
                        'type'        => [
                            'per-order' => 'Na zamówienie',
                            'per-unit'  => 'Na jednostkę',
                            'title'     => 'Typ',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Akceptowane waluty',
                    'accepted-currencies-info'       => 'Dodaj kody walut oddzielone przecinkami, np. USD, INR, ...',
                    'business-account'               => 'Konto biznesowe',
                    'cash-on-delivery'               => 'Płatność przy odbiorze',
                    'cash-on-delivery-info'          => 'Metoda płatności, w której klienci płacą gotówką po otrzymaniu towarów lub usług pod drzwiami.',
                    'client-id'                      => 'ID klienta',
                    'client-id-info'                 => 'Użyj "sb" do testowania.',
                    'client-secret'                  => 'Sekret klienta',
                    'client-secret-info'             => 'Dodaj tutaj swój klucz tajny',
                    'description'                    => 'Opis',
                    'generate-invoice'               => 'Automatycznie generuj fakturę po złożeniu zamówienia',
                    'generate-invoice-applicable'    => 'Dotyczy, jeśli włączono automatyczne generowanie faktury',
                    'info'                           => 'Ustaw informacje o metodach płatności',
                    'instructions'                   => 'Instrukcje',
                    'logo'                           => 'Logo',
                    'logo-information'               => 'Rozdzielczość obrazu powinna wynosić 55px X 45px',
                    'mailing-address'                => 'Wyślij czek na adres',
                    'money-transfer'                 => 'Przelew pieniężny',
                    'money-transfer-info'            => 'Przelew środków z jednej osoby lub konta na drugie, często za pośrednictwem transakcji elektronicznych, w celu różnych celów, takich jak transakcje lub przekazy pieniężne.',
                    'page-title'                     => 'Metody płatności',
                    'paid'                           => 'Opłacone',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'Przycisk PayPal Smart: Ułatwia płatności online za pomocą dostosowywalnych przycisków do bezpiecznych transakcji wielometodowych na stronach internetowych i aplikacjach.',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standard to podstawowa opcja płatności PayPal dla firm internetowych, umożliwiająca klientom płacenie za pomocą kont PayPal lub kart kredytowych/debetowych.',
                    'pending'                        => 'Oczekujące',
                    'pending-payment'                => 'Oczekująca płatność',
                    'processing'                     => 'Przetwarzanie',
                    'sandbox'                        => 'Piaskownica',
                    'set-invoice-status'             => 'Ustaw status faktury po utworzeniu faktury na',
                    'set-order-status'               => 'Ustaw status zamówienia po utworzeniu faktury na',
                    'sort-order'                     => 'Kolejność sortowania',
                    'status'                         => 'Status',
                    'title'                          => 'Tytuł',
                ],

                'order-settings' => [
                    'info'               => 'Ustaw numery zamówień, minimalne zamówienia i zamówienia oczekujące.',
                    'title'              => 'Ustawienia zamówienia',

                    'order-number' => [
                        'generator'   => 'Generator numerów zamówień',
                        'info'        => 'Unikalny identyfikator przypisany do konkretnego zamówienia klienta, ułatwiający śledzenie, komunikację i odniesienie w całym procesie zakupowym.',
                        'length'      => 'Długość numeru zamówienia',
                        'prefix'      => 'Prefiks numeru zamówienia',
                        'suffix'      => 'Sufiks numeru zamówienia',
                        'title'       => 'Ustawienia numeru zamówienia',
                    ],

                    'minimum-order' => [
                        'description'             => 'Opis',
                        'enable'                  => 'Włącz',
                        'include-discount-amount' => 'Uwzględnij kwotę rabatu',
                        'include-tax-amount'      => 'Uwzględnij podatek w kwocie',
                        'info'                    => 'Skonfigurowane kryteria określające minimalną wymaganą ilość lub wartość zamówienia, aby mogło być przetworzone lub kwalifikować się do korzyści.',
                        'minimum-order-amount'    => 'Minimalna kwota zamówienia',
                        'title'                   => 'Ustawienia minimalnego zamówienia',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Ponowne zamówienie przez administratora',
                        'admin-reorder-info' => 'Włącz lub wyłącz funkcję ponownego zamawiania dla użytkowników administratora.',
                        'info'               => 'Włącz lub wyłącz funkcję ponownego zamawiania dla użytkowników administratora.',
                        'shop-reorder'       => 'Ponowne zamówienie przez sklep',
                        'shop-reorder-info'  => 'Włącz lub wyłącz funkcję ponownego zamawiania dla użytkowników sklepu.',
                        'title'              => 'Zezwól na ponowne zamawianie',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Zezwalaj na zamówienia oczekujące',
                        'info'              => 'Opcje akcji to kontrakty inwestycyjne, które przyznają prawo do kupna lub sprzedaży akcji spółki po określonej cenie, wpływając na potencjalne zyski.',
                        'title'             => 'Opcje akcji',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Ustaw numer faktury, warunki płatności, projekt faktury i przypomnienia o fakturze.',
                    'title' => 'Ustawienia faktury',

                    'invoice-number' => [
                        'generator'  => 'Generator numerów faktur',
                        'info'       => 'Konfiguracja reguł lub parametrów generowania i przypisywania unikalnych numerów identyfikacyjnych do faktur w celach organizacyjnych i śledzenia.',
                        'length'     => 'Długość numeru faktury',
                        'prefix'     => 'Prefiks numeru faktury',
                        'suffix'     => 'Sufiks numeru faktury',
                        'title'      => 'Ustawienia numeru faktury',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Czas na zapłatę',
                        'due-duration-day'  => ':due-duration dzień',
                        'due-duration-days' => ':due-duration dni',
                        'info'              => 'Ustalone warunki określające, kiedy i w jaki sposób płatność za towary lub usługi powinna być dokonana przez kupującego na rzecz sprzedawcy.',
                        'title'             => 'Warunki płatności',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Tekst stopki',
                        'footer-text-info' => 'Wprowadź tekst, który pojawi się w stopce pliku PDF.',
                        'info'             => 'Skonfiguruj wydruki PDF, aby wyświetlały identyfikator faktury, identyfikator zamówienia w nagłówku i zawierały logo faktury.',
                        'invoice-id-info'  => 'Skonfiguruj wyświetlanie identyfikatora faktury w nagłówku faktury.',
                        'invoice-id-title' => 'Wyświetl identyfikator faktury w nagłówku',
                        'logo'             => 'Logo',
                        'logo-info'        => 'Rozdzielczość obrazu powinna wynosić 131px x 30px.',
                        'order-id-info'    => 'Skonfiguruj wyświetlanie identyfikatora zamówienia w nagłówku faktury.',
                        'order-id-title'   => 'Wyświetl identyfikator zamówienia w nagłówku',
                        'title'            => 'Wydruki PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Automatyczne powiadomienia lub komunikaty wysyłane do klientów, aby przypomnieć im o nadchodzących lub zaległych płatnościach za faktury.',
                        'interval-between-reminders' => 'Odstęp między przypomnieniami',
                        'maximum-limit-of-reminders' => 'Maksymalny limit przypomnień',
                        'title'                      => 'Przypomnienia o fakturze',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Podatki',
                    'title-info' => 'Podatki to obowiązkowe opłaty nakładane przez rządy na towary, usługi lub transakcje, pobierane przez sprzedawców i przekazywane władzom.',

                    'categories' => [
                        'title'      => 'Kategorie podatków',
                        'title-info' => 'Kategorie podatków to klasyfikacje różnych rodzajów podatków, takich jak podatek od sprzedaży, podatek od wartości dodanej lub podatek akcyzowy, używane do kategoryzacji i stosowania stawek podatkowych do produktów lub usług.',
                        'product'    => 'Domyślna kategoria podatków dla produktów',
                        'shipping'   => 'Kategoria podatków dla wysyłki',
                        'none'       => 'Brak',
                    ],

                    'calculation' => [
                        'title'            => 'Ustawienia obliczeń',
                        'title-info'       => 'Szczegóły dotyczące kosztów towarów lub usług, w tym ceny podstawowej, rabatów, podatków i dodatkowych opłat.',
                        'based-on'         => 'Obliczenia na podstawie',
                        'shipping-address' => 'Adres wysyłki',
                        'billing-address'  => 'Adres rozliczeniowy',
                        'shipping-origin'  => 'Pochodzenie wysyłki',
                        'product-prices'   => 'Ceny produktów',
                        'shipping-prices'  => 'Ceny wysyłki',
                        'excluding-tax'    => 'Bez podatku',
                        'including-tax'    => 'Z podatkiem',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'Domyślny kraj',
                        'default-post-code' => 'Domyślny kod pocztowy',
                        'default-state'     => 'Domyślny stan',
                        'title'             => 'Domyślne obliczenia dla miejsca docelowego',
                        'title-info'        => 'Automatyczne określanie standardowego lub początkowego miejsca docelowego na podstawie predefiniowanych czynników lub ustawień.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Ustawienia wyświetlania koszyka',
                        'title-info'              => 'Ustaw wyświetlanie podatków w koszyku',
                        'display-prices'          => 'Wyświetl ceny',
                        'display-subtotal'        => 'Wyświetl sumę częściową',
                        'display-shipping-amount' => 'Wyświetl kwotę wysyłki',
                        'excluding-tax'           => 'Bez podatku',
                        'including-tax'           => 'Z podatkiem',
                        'both'                    => 'Bez podatku i z podatkiem',
                    ],

                    'sales' => [
                        'title'                   => 'Ustawienia wyświetlania zamówień, faktur i zwrotów',
                        'title-info'              => 'Ustaw wyświetlanie podatków w zamówieniach, fakturach i zwrotach',
                        'display-prices'          => 'Wyświetl ceny',
                        'display-subtotal'        => 'Wyświetl sumę częściową',
                        'display-shipping-amount' => 'Wyświetl kwotę wysyłki',
                        'excluding-tax'           => 'Bez podatku',
                        'including-tax'           => 'Z podatkiem',
                        'both'                    => 'Bez podatku i z podatkiem',
                    ],
                ],

                'checkout' => [
                    'title' => 'Kasa',
                    'info'  => 'Ustaw finalizację transakcji bez rejestracji, włącz lub wyłącz mini koszyk, podsumowanie koszyka.',

                    'shopping-cart' => [
                        'cart-page'              => 'Strona koszyka',
                        'cart-page-info'         => 'Kontroluj widoczność strony koszyka, aby poprawić wygodę użytkowników podczas zakupów.',
                        'cross-sell'             => 'Sprzedawaj produkty powiązane',
                        'cross-sell-info'        => 'Włącz sprzedaż krzyżową produktów, aby zwiększyć możliwości dodatkowej sprzedaży.',
                        'estimate-shipping'      => 'Szacowana wysyłka',
                        'estimate-shipping-info' => 'Włącz szacowaną wysyłkę, aby podać koszty wysyłki z góry.',
                        'guest-checkout'         => 'Zezwalaj na zakupy gościom',
                        'guest-checkout-info'    => 'Włącz zakupy gościom, aby przyspieszyć i uprościć proces zakupów.',
                        'info'                   => 'Włącz zakupy gościom, stronę koszyka, sprzedaż krzyżową produktów i szacowaną wysyłkę, aby zwiększyć wygodę użytkowników i usprawnić proces zakupów w celu zwiększenia sprzedaży.',
                        'title'                  => 'Koszyk',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Wyświetl ilości przedmiotów',
                        'display-number-in-cart'  => 'Wyświetl liczbę przedmiotów w koszyku',
                        'info'                    => 'Włącz ustawienia dla Mój Koszyk, aby pokazać podsumowanie ilości przedmiotów i wyświetlić całkowitą liczbę przedmiotów w koszyku dla łatwego śledzenia.',
                        'summary'                 => 'Podsumowanie',
                        'title'                   => 'Mój Koszyk',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Wyświetl Mini Koszyk',
                        'info'                 => 'Włącz ustawienia dla Mini Koszyka, aby wyświetlać mini koszyk i pokazywać informacje o ofertach Mini Koszyka dla szybkiego dostępu do szczegółów koszyka i promocji.',
                        'mini-cart-offer-info' => 'Informacje o ofercie Mini Koszyka',
                        'title'                => 'Mini Koszyk',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Konto',
                'app-version'   => 'Wersja : :version',
                'logout'        => 'Wyloguj',
                'my-account'    => 'Moje Konto',
                'notifications' => 'Powiadomienia',
                'visit-shop'    => 'Odwiedź Sklep',

                'mega-search' => [
                    'categories'                      => 'Kategorie',
                    'customers'                       => 'Klienci',
                    'explore-all-categories'          => 'Przeglądaj wszystkie kategorie',
                    'explore-all-customers'           => 'Przeglądaj wszystkich klientów',
                    'explore-all-matching-categories' => 'Przeglądaj wszystkie kategorie pasujące do \":query\" (:count)',
                    'explore-all-matching-customers'  => 'Przeglądaj wszystkich klientów pasujących do \":query\" (:count)',
                    'explore-all-matching-orders'     => 'Przeglądaj wszystkie zamówienia pasujące do \":query\" (:count)',
                    'explore-all-matching-products'   => 'Przeglądaj wszystkie produkty pasujące do \":query\" (:count)',
                    'explore-all-orders'              => 'Przeglądaj wszystkie zamówienia',
                    'explore-all-products'            => 'Przeglądaj wszystkie produkty',
                    'orders'                          => 'Zamówienia',
                    'products'                        => 'Produkty',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => 'Mega Wyszukiwarka',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Rodziny atrybutów',
                'attributes'               => 'Atrybuty',
                'booking-product'          => 'Rezerwacje',
                'campaigns'                => 'Kampanie',
                'catalog'                  => 'Katalog',
                'categories'               => 'Kategorie',
                'channels'                 => 'Kanały',
                'cms'                      => 'CMS',
                'collapse'                 => 'Zwiń',
                'communications'           => 'Komunikacja',
                'configure'                => 'Konfiguruj',
                'currencies'               => 'Waluty',
                'customers'                => 'Klienci',
                'dashboard'                => 'Pulpit',
                'data-transfer'            => 'Transfer danych',
                'discount'                 => 'Rabat',
                'email-templates'          => 'Szablony e-maili',
                'events'                   => 'Wydarzenia',
                'exchange-rates'           => 'Kursy wymiany',
                'gdpr-data-requests'       => 'Żądania danych GDPR',
                'groups'                   => 'Grupy',
                'imports'                  => 'Import',
                'inventory-sources'        => 'Źródła inwentarza',
                'invoices'                 => 'Faktury',
                'locales'                  => 'Lokalizacje',
                'marketing'                => 'Marketing',
                'mode'                     => 'Tryb ciemny',
                'newsletter-subscriptions' => 'Subskrypcje newslettera',
                'orders'                   => 'Zamówienia',
                'products'                 => 'Produkty',
                'promotions'               => 'Promocje',
                'refunds'                  => 'Zwroty',
                'reporting'                => 'Raportowanie',
                'reviews'                  => 'Recenzje',
                'roles'                    => 'Role',
                'sales'                    => 'Sprzedaż',
                'search-seo'               => 'Wyszukiwanie i SEO',
                'search-synonyms'          => 'Synonimy wyszukiwania',
                'search-terms'             => 'Słowa kluczowe',
                'settings'                 => 'Ustawienia',
                'shipments'                => 'Wysyłki',
                'sitemaps'                 => 'Mapy witryny',
                'tax-categories'           => 'Kategorie podatków',
                'tax-rates'                => 'Stawki podatków',
                'taxes'                    => 'Podatki',
                'themes'                   => 'Motywy',
                'transactions'             => 'Transakcje',
                'url-rewrites'             => 'Przekierowania URL',
                'users'                    => 'Użytkownicy',
            ],

            'powered-by' => [
                'description' => 'Napędzane przez :bagisto, projekt open-source autorstwa :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'Nie wybrano żadnych rekordów.',
                'must-select-a-mass-action-option' => 'Musisz wybrać opcję akcji masowej.',
                'must-select-a-mass-action'        => 'Musisz wybrać akcję masową.',
            ],

            'toolbar' => [
                'length-of' => ':length z',
                'of'        => 'z',
                'per-page'  => 'Na stronę',
                'results'   => ':total Wyniki',
                'selected'  => ':total Wybrane',

                'mass-actions' => [
                    'select-action' => 'Wybierz Akcję',
                    'select-option' => 'Wybierz Opcję',
                    'submit'        => 'Zatwierdź',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Zastosuj filtry',
                    'back-btn'          => 'Wstecz',
                    'create-new-filter' => 'Criar novo filtro',
                    'custom-filters'    => 'Filtros personalizados',
                    'delete-error'      => 'Coś poszło nie tak podczas usuwania filtra, spróbuj ponownie.',
                    'delete-success'    => 'O filtro foi excluído com sucesso.',
                    'empty-description' => 'Não há filtros selecionados disponíveis para salvar. Por favor, selecione filtros para salvar.',
                    'empty-title'       => 'Adicionar filtros para salvar',
                    'name'              => 'Nome',
                    'quick-filters'     => 'Filtros rápidos',
                    'save-btn'          => 'Salvar',
                    'save-filter'       => 'Salvar filtro',
                    'saved-success'     => 'O filtro foi salvo com sucesso.',
                    'selected-filters'  => 'Filtros selecionados',
                    'title'             => 'Filtro',
                    'update'            => 'Aktualizuj',
                    'update-filter'     => 'Zaktualizuj filtr',
                    'updated-success'   => 'Filtr został pomyślnie zaktualizowany.',
                ],

                'search' => [
                    'title' => 'Szukaj',
                ],
            ],

            'filters' => [
                'select' => 'Wybierz.',
                'title'  => 'Filtrowanie',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Wprowadź co najmniej 2 znaki...',
                        'no-results'        => 'Nie znaleziono wyników...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Wyczyść Wszystko',
                    'title'     => 'Niestandardowe Filtry',
                ],

                'boolean-options' => [
                    'false' => 'Fałsz',
                    'true'  => 'Prawda',
                ],

                'date-options' => [
                    'last-month'        => 'Ostatni Miesiąc',
                    'last-six-months'   => 'Ostatnie 6 Miesięcy',
                    'last-three-months' => 'Ostatnie 3 Miesiące',
                    'this-month'        => 'Bieżący Miesiąc',
                    'this-week'         => 'Bieżący Tydzień',
                    'this-year'         => 'Bieżący Rok',
                    'today'             => 'Dziś',
                    'yesterday'         => 'Wczoraj',
                ],
            ],

            'table' => [
                'actions'              => 'Akcje',
                'no-records-available' => 'Brak Dostępnych Rekordów.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Zgadzam się',
                'disagree-btn' => 'Nie zgadzam się',
                'message'      => 'Czy na pewno chcesz wykonać tę czynność?',
                'title'        => 'Jesteś pewny?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Dodaj wybrany produkt',
                'empty-info'    => 'Brak dostępnych produktów dla danego terminu wyszukiwania.',
                'empty-title'   => 'Nie znaleziono produktów',
                'product-image' => 'Zdjęcie produktu',
                'qty'           => ':qty dostępne',
                'sku'           => 'SKU - :sku',
                'title'         => 'Wybierz produkty',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Dodaj obraz',
                'ai-add-image-btn'  => 'Magia AI',
                'ai-btn-info'       => 'Generuj obraz',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Dozwolone są tylko pliki graficzne (.jpeg, .jpg, .png, ..).',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Zastosuj',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Generuj',
                    'generating'       => 'Generowanie...',
                    'hd'               => 'HD',
                    'model'            => 'Model',
                    'number-of-images' => 'Liczba obrazów',
                    'prompt'           => 'Podpowiedź',
                    'quality'          => 'Jakość',
                    'regenerate'       => 'Regeneruj',
                    'regenerating'     => 'Regenerowanie...',
                    'size'             => 'Rozmiar',
                    'standard'         => 'Standard',
                    'title'            => 'Generacja Obrazów z Wykorzystaniem AI',
                ],

                'placeholders'  => [
                    'front'     => 'Przód',
                    'next'      => 'Następny',
                    'size'      => 'Rozmiar',
                    'use-cases' => 'Zastosowanie',
                    'zoom'      => 'Powiększenie',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Dodaj film',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Dozwolone są tylko pliki wideo (.mp4, .mov, .ogg ..).',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magia AI',

            'ai-generation' => [
                'apply'                    => 'Zastosuj',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Włączone',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Generuj',
                'generated-content'        => 'Wygenerowana Treść',
                'generated-content-info'   => 'Treść generowana przez AI może być myląca. Proszę przejrzeć wygenerowaną treść przed jej zastosowaniem.',
                'generating'               => 'Generowanie...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Model',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Podpowiedź',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'Asystent AI',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],

            'errors' => [
                'file-extension-mismatch'        => 'Rozszerzenie pliku nie pasuje do typu pliku.',
                'file-upload-failed'             => 'Przesyłanie pliku nie powiodło się.',
                'http-error'                     => 'Błąd HTTP.',
                'invalid-file-type'              => 'Nieprawidłowy typ pliku. Dozwolone typy: JPEG, PNG, GIF, WebP, SVG',
                'invalid-json'                   => 'Nieprawidłowy JSON.',
                'no-file-uploaded'               => 'Nie przesłano pliku.',
                'upload-failed'                  => 'Przesyłanie obrazu nie powiodło się z powodu błędu transportu XHR.',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Adresy',
        'attribute-families'       => 'Rodziny Atrybutów',
        'attributes'               => 'Atrybuty',
        'campaigns'                => 'Kampanie',
        'cancel'                   => 'Anuluj',
        'cart-rules'               => 'Reguły Koszyka',
        'catalog-rules'            => 'Reguły Katalogu',
        'catalog'                  => 'Katalog',
        'categories'               => 'Kategorie',
        'channels'                 => 'Kanały',
        'cms'                      => 'CMS',
        'communications'           => 'Komunikaty',
        'configure'                => 'Konfiguruj',
        'copy'                     => 'Kopiuj',
        'create'                   => 'Tworzyć',
        'currencies'               => 'Waluty',
        'customers'                => 'Klienci',
        'dashboard'                => 'Pulpit',
        'data-transfer'            => 'Transfer danych',
        'delete'                   => 'Usuń',
        'edit'                     => 'Edytuj',
        'email-templates'          => 'Szablony Emaili',
        'events'                   => 'Zdarzenia',
        'exchange-rates'           => 'Kursy Walut',
        'gdpr'                     => 'RODO',
        'groups'                   => 'Grupy',
        'import'                   => 'Import',
        'imports'                  => 'Import',
        'inventory-sources'        => 'Źródła Magazynu',
        'invoices'                 => 'Faktury',
        'locales'                  => 'Lokalizacje',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Subskrypcje Newslettera',
        'note'                     => 'Notatka',
        'orders'                   => 'Zamówienia',
        'products'                 => 'Produkty',
        'promotions'               => 'Promocje',
        'refunds'                  => 'Zwroty',
        'reporting'                => 'Raportowanie',
        'reviews'                  => 'Recenzje',
        'roles'                    => 'Role',
        'sales'                    => 'Sprzedaż',
        'search-seo'               => 'Wyszukiwanie i SEO',
        'search-synonyms'          => 'Synonimy wyszukiwania',
        'search-terms'             => 'Słowa kluczowe',
        'settings'                 => 'Ustawienia',
        'shipments'                => 'Wysyłki',
        'sitemaps'                 => 'Mapy Strony',
        'subscribers'              => 'Subskrybenci Newslettera',
        'tax-categories'           => 'Kategorie Podatków',
        'tax-rates'                => 'Stawki Podatkowe',
        'taxes'                    => 'Podatki',
        'themes'                   => 'Motywy',
        'transactions'             => 'Transakcje',
        'url-rewrites'             => 'Przekierowania URL',
        'users'                    => 'Użytkownicy',
        'view'                     => 'Pokaż',
    ],

    'errors' => [
        'dashboard' => 'Panel główny',
        'go-back'   => 'Wróć',
        'support'   => 'Jeśli problem nadal występuje, skontaktuj się z nami pod adresem <a href=":link" class=":class">:email</a> w celu uzyskania pomocy.',

        '404' => [
            'description' => 'Ups! Strona, którą próbujesz odwiedzić, jest na wakacjach. Wygląda na to, że nie możemy znaleźć tego, czego szukasz.',
            'title'       => '404 Strona nie znaleziona',
        ],

        '401' => [
            'description' => 'Ups! Wygląda na to, że nie masz uprawnień do dostępu do tej strony. Wydaje się, że brakuje Ci odpowiednich danych uwierzytelniających.',
            'title'       => '401 Brak autoryzacji',
        ],

        '403' => [
            'description' => 'Ups! Ta strona jest dostępna tylko dla uprawnionych użytkowników. Wygląda na to, że nie masz wymaganych uprawnień do wyświetlenia tego zasobu.',
            'title'       => '403 Dostęp zabroniony',
        ],

        '500' => [
            'description' => 'Ups! Coś poszło nie tak. Wydaje się, że mamy problem z załadowaniem strony, której szukasz.',
            'title'       => '500 Wewnętrzny błąd serwera',
        ],

        '503' => [
            'description' => 'Ups! Wygląda na to, że jesteśmy tymczasowo niedostępni z powodu prac konserwacyjnych. Proszę wrócić za chwilę.',
            'title'       => '503 Usługa niedostępna',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Pobierz',
        'export'     => 'Eksport',
        'no-records' => 'Nic do wyeksportowania',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Ten slug jest używany w kategoriach lub produktach.',
        'slug-reserved'   => 'Ten slug jest zarezerwowany.',
    ],

    'footer' => [
        'copy-right' => 'Napędzane przez <a href="https://bagisto.com/" target="_blank">Bagisto</a>, Projekt społecznościowy <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Szanowny(a) :admin_name',
        'thanks' => 'Jeśli potrzebujesz pomocy, skontaktuj się z nami pod adresem <a href=":link" style=":style">:email</a>.<br/>Dziękujemy!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Otrzymujesz ten e-mail, ponieważ otrzymaliśmy prośbę o zresetowanie hasła dla Twojego konta.',
                'greeting'       => 'Zapomniałeś hasła!',
                'reset-password' => 'Resetuj hasło',
                'subject'        => 'E-mail resetowania hasła',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Nowe konto klienta zostało pomyślnie utworzone. Mogą teraz logować się przy użyciu adresu e-mail i hasła. Po zalogowaniu będą mieli dostęp do różnych usług, w tym możliwość przeglądania poprzednich zamówień, zarządzania listami życzeń i aktualizowania informacji o swoim koncie.',
                'greeting'    => 'Serdecznie witamy nowego klienta, :customer_name, który właśnie się u nas zarejestrował!',
                'subject'     => 'Rejestracja nowego klienta',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nowe żądanie usunięcia danych',
                'new-update-request' => 'Nowe żądanie aktualizacji danych',

                'new-request' => [
                    'customer-name'  => 'Nazwa klienta : ',
                    'delete-summary' => 'Podsumowanie żądania usunięcia',
                    'message'        => 'Wiadomość : ',
                    'request-status' => 'Status żądania : ',
                    'request-type'   => 'Typ żądania : ',
                    'update-summary' => 'Podsumowanie żądania aktualizacji',
                ],

                'status-update' => [
                    'subject'        => 'Żądanie GDPR zostało zaktualizowane',
                    'summary'        => 'Status żądania GDPR został zaktualizowany',
                    'request-status' => 'Status żądania:',
                    'request-type'   => 'Typ żądania:',
                    'message'        => 'Wiadomość:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Masz nowe zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie nowego zamówienia',
                'summary'  => 'Podsumowanie zamówienia',
                'title'    => 'Potwierdzenie zamówienia!',
            ],

            'invoiced' => [
                'greeting' => 'Twoja faktura #:invoice_id za zamówienie :order_id została utworzona :created_at',
                'subject'  => 'Potwierdzenie nowej faktury',
                'summary'  => 'Podsumowanie faktury',
                'title'    => 'Potwierdzenie faktury!',
            ],

            'shipped' => [
                'greeting' => 'Wysłałeś zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie wysłania zamówienia',
                'summary'  => 'Podsumowanie wysyłki',
                'title'    => 'Zamówienie wysłane!',
            ],

            'inventory-source' => [
                'greeting' => 'Wysłałeś zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie nowej wysyłki',
                'summary'  => 'Podsumowanie wysyłki',
                'title'    => 'Zamówienie wysłane!',
            ],

            'refunded' => [
                'greeting' => 'Zwróciłeś zamówienie :order_id złożone :created_at',
                'subject'  => 'Potwierdzenie nowego zwrotu',
                'summary'  => 'Podsumowanie zwrotu',
                'title'    => 'Zamówienie zwrócone!',
            ],

            'canceled' => [
                'greeting' => 'Anulowałeś zamówienie :order_id złożone :created_at',
                'subject'  => 'Anulowanie nowego zamówienia',
                'summary'  => 'Podsumowanie zamówienia',
                'title'    => 'Zamówienie anulowane!',
            ],

            'billing-address'            => 'Adres rozliczeniowy',
            'carrier'                    => 'Przewoźnik',
            'contact'                    => 'Kontakt',
            'discount'                   => 'Rabat',
            'excl-tax'                   => 'Bez podatku: ',
            'grand-total'                => 'Suma ogólna',
            'name'                       => 'Nazwa',
            'payment'                    => 'Płatność',
            'price'                      => 'Cena',
            'qty'                        => 'Ilość',
            'shipping-address'           => 'Adres dostawy',
            'shipping-handling-excl-tax' => 'Obsługa wysyłki (bez podatku)',
            'shipping-handling-incl-tax' => 'Obsługa wysyłki (z podatkiem)',
            'shipping-handling'          => 'Obsługa wysyłki',
            'shipping'                   => 'Wysyłka',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Suma częściowa (bez podatku)',
            'subtotal-incl-tax'          => 'Suma częściowa (z podatkiem)',
            'subtotal'                   => 'Suma częściowa',
            'tax'                        => 'Podatek',
            'tracking-number'            => 'Numer śledzenia: :tracking_number',
        ],
    ],
];
