
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `blab2512`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ban`
--

CREATE TABLE `[[dbprefix]]_ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `initstamp` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `ulevel` smallint(6) NOT NULL,
  `ban` smallint(6) NOT NULL,
  `aname` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `breason` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bbox`
--

CREATE TABLE `[[dbprefix]]_bbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fgc` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bgc` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blingkey` char(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` smallint(6) NOT NULL,
  `inlist` smallint(6) NOT NULL,
  `blingsuper` smallint(6) NOT NULL,
  `timesec` int(11) NOT NULL,
  `bgcolor` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sound` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `blingcode` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `blingcss` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bflog`
--

CREATE TABLE `[[dbprefix]]_bflog` (
  `id` int(11) NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_fmedia`
--

CREATE TABLE `[[dbprefix]]_fmedia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file2hdd` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filetype` int(11) NOT NULL,
  `sourcetxt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_gbox`
--

CREATE TABLE `[[dbprefix]]_gbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) NOT NULL,
  `roomid` int(11) NOT NULL,
  `ugroup` int(11) NOT NULL,
  `pagesize` int(11) NOT NULL,
  `glocale` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_geoloc`
--

CREATE TABLE `[[dbprefix]]_geoloc` (
  `id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `geolat` float NOT NULL,
  `geolon` float NOT NULL,
  `timestamp` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_gifs`
--

CREATE TABLE `[[dbprefix]]_gifs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idgbox` int(11) NOT NULL,
  `seen` int(11) NOT NULL,
  `ggif` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gmp4` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_gpt`
--

CREATE TABLE `[[dbprefix]]_gpt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `gid` int(11) NOT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `rplmsg` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sysmsg` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_groups`
--

CREATE TABLE `[[dbprefix]]_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `welcome` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` int(11) NOT NULL,
  `vlnk` int(11) NOT NULL,
  `color` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pa` smallint(6) NOT NULL,
  `pb` smallint(6) NOT NULL,
  `pc` smallint(6) NOT NULL,
  `pd` smallint(6) NOT NULL,
  `pe` smallint(6) NOT NULL,
  `pf` smallint(6) NOT NULL,
  `pg` smallint(6) NOT NULL,
  `ph` smallint(6) NOT NULL,
  `pi` smallint(6) NOT NULL,
  `pj` smallint(6) NOT NULL,
  `pk` smallint(6) NOT NULL,
  `pl` smallint(6) NOT NULL,
  `pm` smallint(6) NOT NULL,
  `pn` smallint(6) NOT NULL,
  `po` smallint(6) NOT NULL,
  `pp` smallint(6) NOT NULL,
  `pq` smallint(6) NOT NULL,
  `pr` smallint(6) NOT NULL,
  `ps` smallint(6) NOT NULL,
  `pt` smallint(6) NOT NULL,
  `pu` smallint(6) NOT NULL,
  `pv` smallint(6) NOT NULL,
  `pw` smallint(6) NOT NULL,
  `px` smallint(6) NOT NULL,
  `py` smallint(6) NOT NULL,
  `pz` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_groups`
--

INSERT INTO `[[dbprefix]]_groups` VALUES
(1, 'DEFAULT', '', 0, 0, 'F44336', 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_grules`
--

CREATE TABLE `[[dbprefix]]_grules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scenario` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ugroup` int(11) NOT NULL,
  `zorder` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ipc`
--

CREATE TABLE `[[dbprefix]]_ipc` (
  `ipslice` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_iplog`
--

CREATE TABLE `[[dbprefix]]_iplog` (
  `id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `country` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_jbox`
--

CREATE TABLE `[[dbprefix]]_jbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) NOT NULL,
  `roomid` int(11) NOT NULL,
  `ugroup` int(11) NOT NULL,
  `infinite` int(11) NOT NULL,
  `shuffle` int(11) NOT NULL,
  `gap` int(11) NOT NULL,
  `delay` int(11) NOT NULL,
  `cookielength` int(11) NOT NULL,
  `hremember` int(11) NOT NULL,
  `elements` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `template` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_messages`
--

CREATE TABLE `[[dbprefix]]_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `roomid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `usergroup` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `touserid` int(11) NOT NULL,
  `tousername` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `line` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` smallint(6) NOT NULL,
  `attach` smallint(6) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `mhash` char(12) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_messages`
--

INSERT INTO `[[dbprefix]]_messages` VALUES
(1, 0, 0, 0, 'system', 0, '', 'Installed successfully...', 0, 0, [[timestamp]], '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_offmsg`
--

CREATE TABLE `[[dbprefix]]_offmsg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ugroup` int(11) NOT NULL,
  `touserid` int(11) NOT NULL,
  `offmessage` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `msgread` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_online`
--

CREATE TABLE `[[dbprefix]]_online` (
  `id` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ugroup` smallint(6) NOT NULL,
  `ipaddr` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `status` smallint(6) NOT NULL,
  `avatar` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinfo` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_paintings`
--

CREATE TABLE `[[dbprefix]]_paintings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `srx` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sry` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `src` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `bgc` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bgid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_pcache`
--

CREATE TABLE `[[dbprefix]]_pcache` (
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `proxy` smallint(6) NOT NULL,
  `timestamp` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_polls`
--

CREATE TABLE `[[dbprefix]]_polls` (
  `id` int(11) NOT NULL,
  `vote` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_qcats`
--

CREATE TABLE `[[dbprefix]]_qcats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enbl` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_qcats`
--

INSERT INTO `[[dbprefix]]_qcats` VALUES
(1, 'History Europe', 1),
(2, 'Geography', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_qdata`
--

CREATE TABLE `[[dbprefix]]_qdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `aa` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ab` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ac` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ad` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `correct` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=41 ;

--
-- Dumping data for table `[[dbprefix]]_qdata`
--

INSERT INTO `[[dbprefix]]_qdata` VALUES
(1, 1, 'Who was the first monarch of Great Britain?', 'Queen Anne', 'Alfred The Great', 'William the Conqueror', '', 'A'),
(2, 1, 'Which sultan conquered Constantinople in 1453?', 'Suleiman the Magnificent', 'Osman I', 'Mehmed II', '', 'C'),
(3, 1, 'Which king united England and France?', 'Henry V', 'Richard I', 'None', '', 'C'),
(4, 1, 'Who was the first Holy Roman Emperor?', 'Julius Caesar', 'Charlemagne', 'Augustus', '', 'B'),
(5, 1, 'Who was the longest reigning Roman emperor?', 'Vespasian', 'Augustus', 'Tiberius', '', 'B'),
(6, 1, 'Which was the first country to adopt Christianity as a state religion?', 'The Roman Empire', 'The Byzantine Empire', 'The Kingdom of Armenia', '', 'C'),
(7, 1, 'What was the largest city in Europe in the 10th century?', 'Constantinople', 'Rome', 'London', '', 'A'),
(8, 1, 'Who said -The die is cast-?', 'Napoleon', 'Julius Caesar', 'Hitler', '', 'B'),
(9, 1, 'Where is set Shakespeare''s Romeo and Juliet?', 'Verona', 'Rome', 'Venice', '', 'A'),
(10, 1, 'Who''s the god of war in the Greek mythology?', 'Apollo', 'Ares', 'Hermes', '', 'B'),
(11, 1, 'Which king of France signed the The Edict of Nantes?', 'Louis XIV', 'François I', 'Henry IV', '', 'C'),
(12, 1, 'Where did the battle of Waterloo take place?', 'England', 'Netherlands', 'France', '', 'B'),
(13, 1, 'Who was known as the Iron Chancellor?', 'Margaret Thatcher', 'Hermann Goering', 'Otto von Bismarck', '', 'C'),
(14, 1, 'Which legendary general is said to have sworn undying enmity against Rome?', 'Vercingetorix', 'Hannibal', 'Attila', '', 'B'),
(15, 1, 'Which officer was the first field marshal in history to be captured?', 'Friedrich Paulus', 'Erwin Rommel', 'Erich von Manstein', '', 'A'),
(16, 1, 'Which campaign was led by Philip II of France, Richard I of England and Frederick I.', 'Albigensian Crusade', 'Fourth Crusade', 'Third Crusade', '', 'C'),
(17, 1, 'What Merovingian became king in the fifth century A.D.?', 'Arpad', 'Clovis', 'Ethelred', '', 'B'),
(18, 1, 'In Ancient Rome, who were the Lares?', 'Household spirits of dead ancestors', 'The elite corps of the Roman army', 'The Muses', '', 'A'),
(19, 1, 'Who was the faithful wife of Odysseus who waited 20 years for his return from the Trojan War?', 'Penelope', 'Aspasia', 'Telemachus', '', 'A'),
(20, 1, 'Who started the movement of Protestant Reformation in Europe?', 'Martin Luther', 'John Calvin', 'Erasmus', '', 'A'),
(21, 2, 'Which of these seas is largest?', 'Bering', 'Arabian Sea', 'Mediterranean', 'Gulf of Mexico', 'C'),
(22, 2, 'The tallest mountain peak in the US is Mount McKinley. The second tallest is:', 'Mount Saint Elias', 'Glacier Peak', 'Mount Washington', 'Gannett Peak', 'A'),
(23, 2, 'Which EU member is divided into a Greek and a Turkish part?', 'Greece', 'Slovenia', 'Cyprus', 'Bulgaria', 'C'),
(24, 2, 'Which EU member has a significant part of its territory below sea level?', 'Belgium', 'The Netherlands', 'Poland', 'Estonia', 'B'),
(25, 2, 'Which of the following countries and states shares its name with its capital city?', 'New York', 'Malta', 'Luxembourg', 'Oklahoma', 'C'),
(26, 2, 'Which one of these is not a Greek Mediterranean island?', 'Minorca', 'Lemnos', 'Crete', 'Santorini', 'A'),
(27, 2, 'Riga is the capital of which Baltic country?', 'Estonia', 'Lithuania', 'Belarus', 'Latvia', 'D'),
(28, 2, 'What famous square is located in Vatican City, the papal enclave within Rome?', 'Campo dei Fiori', 'St. Pauls Square', 'St. Peters Square', 'Piazza San Marco', 'C'),
(29, 2, 'What is the name of the island shared by Haiti and the Dominican Republic?', 'Haiti', 'Hispaniola', 'Isla Dominica', 'Carib Island', 'B'),
(30, 2, 'What portion of the Earth’s surface do oceans cover?', 'More than two thirds', 'One third', 'Half of it', 'One fourth', 'A'),
(31, 2, 'Montgomery is the capital city of this US state, and its largest city is Birmingham.', 'Arizona', 'Alaska', 'Arkansas', 'Alabama', 'D'),
(32, 2, 'The Himalayan range, part of which is Mount Everest, stretches across five different countries in Asia. Which of the following countries is not among them?', 'Israel', 'Bhutan', 'Pakistan', 'India', 'A'),
(33, 2, 'What river that flows through Spain and Portugal is the longest river on the Iberian Peninsula?', 'Guadiana', 'Duero', 'Guadalquivir', 'Tagus', 'D'),
(34, 2, 'Maryland derives its name from its Catholic founders, who named the state after which historic person?', 'Mary, Queen of Scots', 'Mary Magdalene', 'The Virgin Mary', 'Queen Henrietta Maria of France', 'D'),
(35, 2, 'Which country, Slovakia or Slovenia, used to be part of Yugoslavia?', 'Slovenia', 'Both', 'Slovakia', 'None of them', 'A'),
(36, 2, 'What sea borders Egypt to the east?', 'Black Sea', 'Yellow Sea', 'Mediterranean Sea', 'Red Sea', 'D'),
(37, 2, 'The Ottoman Empire used to rule over North Africa, the Middle East and south-eastern Europe. Which modern day country is the successor of the empire?', 'Israel', 'Saudi Arabia', 'Turkey', 'Egypt', 'C'),
(38, 2, 'The capital city of what country is called Quito?', 'Bolivia', 'Macedonia', 'Ecuador', 'Yemen', 'C'),
(39, 2, 'What is the name of the capital city of the U.S. state of Wyoming.', 'Boise', 'Des Moines', 'Salt Lake City', 'Cheyenne', 'D'),
(40, 2, 'Which of these European countries shares a land border with Sweden?', 'Switzerland', 'Denmark', 'Lithuania', 'Norway', 'D');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_qres`
--

CREATE TABLE `[[dbprefix]]_qres` (
  `id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `res` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rbox`
--

CREATE TABLE `[[dbprefix]]_rbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) NOT NULL,
  `pm` int(11) NOT NULL,
  `roomid` int(11) NOT NULL,
  `ugroup` int(11) NOT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answers` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rooms`
--

CREATE TABLE `[[dbprefix]]_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` char(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zorder` int(11) NOT NULL,
  `hidden` smallint(6) NOT NULL,
  `groupids` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]_rooms`
--

INSERT INTO `[[dbprefix]]_rooms` VALUES
(1, 'PanDEMONiuM', 'Everybody''s Very Welcome!', '3B7AB5', 0, 0, ''),
(2, 'Mediterranean Dish', 'What to Eat, and How to Cook It!', 'FFD93F', 1002, 0, ''),
(3, 'Vivian''s Bedroom', 'Don''t Come In, I''m Naked!', 'D90048', 1003, 0, ''),
(4, 'Honky-Tonk Corner', 'WARNING! 85+ Only!', '8BC34A', 1004, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_scache`
--

CREATE TABLE `[[dbprefix]]_scache` (
  `id` varchar(16) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]_scache`
--

INSERT INTO `[[dbprefix]]_scache` VALUES
('sticache1', ''),
('sticache2', ''),
('avt_cache', ''),
('svgcache1', ''),
('svgcache2', ''),
('svgcache3', ''),
('svgcache4', ''),
('svgcache5', ''),
('svgcache6', ''),
('sound1', ''),
('sound2', ''),
('sound3', ''),
('sound4', ''),
('sound5', ''),
('sound6', ''),
('sound7', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_settings`
--

CREATE TABLE `[[dbprefix]]_settings` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]_settings`
--

INSERT INTO `[[dbprefix]]_settings` VALUES
('default_lang', '0'),
('default_ampm', '2'),
('colors', 'F44336|E91E63|9C27B0|673AB7|3F51B5|2196F3|03A9F4|00BCD4|009688|4CAF50|8BC34A|CDDC39|FFEB3B|FFC107|FF9800|FF5722|795548|607D8B|E53935|D81B60|8E24AA|5E35B1|3949AB|1E88E5|039BE5|00ACC1|00897B|43A047|7CB342|C0CA33|FDD835|FFB300|FB8C00|F4511E|6D4C41|546E7A'),
('default_sound', '1'),
('html_title', 'Our Chat!'),
('allow_guest', '1'),
('cookie_salt', '[[cookie_salt]]'),
('random_salt', '[[random_salt]]'),
('allow_reg', '1'),
('userperhour', '5'),
('wrongperhour', '5'),
('dimonblur', '0'),
('notes', ''),
('ban_period', '86400'),
('mute_period', '300'),
('show_thumbs', '0'),
('keepiplg', '7776000'),
('ctab_display', '0'),
('ctab_default', '0'),
('ctab_icon', 'svg_star'),
('ctab_title', ''),
('ctab_content', ''),
('avatar_msize', '102400'),
('file_msize', '512000'),
('uploads_user', '10'),
('paintings_user', '10'),
('style_template', 'body,td,p,div,input,select,textarea{font-size:[1]px;font-family:[2]}\r\n.x_global{[3]}\r\n.x_blab{[17]}\r\ninput,select{color:#[4]}\r\n.x_overal{color:#[4];background-color:#[5]}\r\n.x_accent_bg{color:#[0];background-color:#[6]}\r\n.x_accent_fg{color:#[6];background-color:transparent}\r\n.x_accent_bb{border-bottom:1px solid #[6]}\r\n.x_input_blabws{color:#[7];background-color:#[8]}\r\n.x_bcolor_x{color:#[9];background-color:#[10]}\r\n.x_bcolor_y{color:#[11];background-color:#[12]}\r\n.x_bcolor_z{color:#[13];background-color:#[14]}\r\n.x_left_rounded{border-radius:[15]px 0 0 [15]px}\r\n.x_right_rounded{border-radius: 0 [15]px [15]px 0}\r\n.x_bottom_rounded{border-radius: 0 0 [15]px [15]px}\r\n.x_top_rounded{border-radius: [15]px [15]px 0 0}\r\n.x_all_rounded{border-radius: [15]px [15]px [15]px [15]px}\r\n.x_circle{border-radius:[16]%}'),
('style_delivery', 'body,td,p,div,input,select,textarea{font-size:14px;font-family:sans-serif}\r\n.x_global{}\r\n.x_blab{}\r\ninput,select{color:#FFFFFF}\r\n.x_overal{color:#FFFFFF;background-color:#222222}\r\n.x_accent_bg{color:#000;background-color:#F44336}\r\n.x_accent_fg{color:#F44336;background-color:transparent}\r\n.x_accent_bb{border-bottom:1px solid #F44336}\r\n.x_input_blabws{color:#000000;background-color:#FFFFFF}\r\n.x_bcolor_x{color:#FFFFFF;background-color:#111111}\r\n.x_bcolor_y{color:#FFFFFF;background-color:#111111}\r\n.x_bcolor_z{color:#FFFFFF;background-color:#000000}\r\n.x_left_rounded{border-radius:5px 0 0 5px}\r\n.x_right_rounded{border-radius: 0 5px 5px 0}\r\n.x_bottom_rounded{border-radius: 0 0 5px 5px}\r\n.x_top_rounded{border-radius: 5px 5px 0 0}\r\n.x_all_rounded{border-radius: 5px 5px 5px 5px}\r\n.x_circle{border-radius:100%}'),
('webkit_css', ''),
('post_interval', '2'),
('acp_css', '0d.css'),
('token_validity', '20'),
('acp_offset', '0'),
('server_url', '[[domhost]]'),
('server_key', ''),
('server_port', '9001'),
('server_wss', 'ws'),
('server_pps', ''),
('intg_bbcms', 'blabws'),
('intg_cookie', ''),
('intg_prefix', ''),
('intg_nolog', '../'),
('intg_logout', '../'),
('intg_pflink', ''),
('msg_style', '.msg{margin-bottom:20px;min-width:200px;display:flex;clear:both} .avt{float:left;width:50px;height:50px;margin-right:10px}'),
('msg_template', '<div class="msg"><img class="avt x_circle" src="{AVATAR}" alt=""><div style="text-align:left"><span class="chat_area_user g{GROUP}">{NAME}</span> <span class="chat_area_time">{TIME}</span><br><span class="tt{COLOR}" style="word-break:break-word">{TEXT}</span></div></div>'),
('announce', ''),
('version', '25.12'),
('forcereload', 'Alexandria'),
('drag2scroll', '1'),
('whee2scroll', '1'),
('group_g', '1'),
('group_r', '1'),
('group_f', '1'),
('gifs_key', ''),
('gifs_num', '15'),
('stimoji_fts', '0'),
('stimoji_num', '10'),
('stimoji_dir', ''),
('gifs_rnd', 'summer, mountain, beach'),
('svgtstamp', '0'),
('badge_bgc', ''),
('badge_txt', ''),
('showroombg', '1'),
('roombgf', 'serif'),
('roombgt', '10'),
('roombgc', '123456'),
('roombgs', '90'),
('roombgl', '8'),
('upd_cache', '[[timestamp]]'),
('logio_msg', '1'),
('multi_links', ''),
('msg2db', '1'),
('ban_order', '1'),
('welcome_msg', '<b>Welcome to our chat!</b><div style="margin:10px"><div class="help_allp help_esck">The ESC key is your friend. Use it!</div><div class="help_allp help_cycl">Cycle through rooms with Ctrl+Shift+L/R Arrows.</div><div class="help_allp help_ctrl">Change rooms with Ctrl+Shift+1 Ctrl+Shift+2 ...</div><div class="help_allp help_drag">Drag-to-scroll or scroll with the arrow keys.</div><div class="help_allp help_dblc">A double-click swaps scroll &amp; select.</div><div class="help_allp help_swip">A swipe from the left edge opens the menu.</div></div>'),
('mottos', 'Acta Non Verba|Audentes Fortuna Iuvat|Alea Iacta Est|Ars Longa, Vita Brevis|Ave, Morituri Te Salutant|Credo Quia Absurdum|Dulce Bellum Inexpertis|Dum Excusare Credis, Accusas|Fabas Indulcet Fames|Fortis Fortuna Adiuvat|In Vino Veritas|Non Ducor Duco|Oderint Dum Metuat|Quis Custodiet Ipsos Custodes?|Semper Ad Meliora|Semper Inops Quicumque Cupit|Si Vis Amari, Ama|Si Vis Pacem, Para Bellum|Sic Transit Gloria Mundi|Transit Umbra, Lux Permanet|Una Hirundo Non Facit Ver|Veni, Vidi, Vici|Vestis Virum Reddit|Vir Sapit Qui Pauca Loquitur|Vires Acquirit Eundo|Vitam Regit Fortuna, Non Sapientia'),
('vvm_on', '1'),
('vvm_sz', '1000000'),
('vvm_la', '30'),
('vvm_lv', '10'),
('vvm_ba', '1'),
('vvm_bv', '1'),
('vvm_rs', '1'),
('vvm_us', '5'),
('rmb_unsent', '1'),
('fb_appid', ''),
('fb_token', ''),
('fb_r_url', ''),
('fb_t_frm', 'index.php'),
('crn_o', '0'),
('crn_g', '0'),
('crn_m', '20'),
('crn_p', '20'),
('crn_d', '20'),
('crn_u', '20'),
('crn_q', '20'),
('crn_k', '[[crn_k]]'),
('badwords', ''),
('badrepls', ''),
('blingon', '1'),
('blingint', '20'),
('pholders', ''),
('defaultsnip', 'Hello!'),
('rqhints', ''),
('multiavatar', '0'),
('stopwords', '/me,/whois,/topic,/kick'),
('profile_templt', '<div class="x_bcolor_z x_top_rounded" style="padding:10px;text-align:left;color:#fff;border-bottom:8px solid rgba(0,0,0,.2);background-image:url(%COVER%);background-size:cover"> <div style="padding:10px;background-color:rgba(0,0,0,.5)"><img src="%IMAGE%" alt="" style="float:left;width:120px;height:120px;margin-right:10px"> <b style="font-size:120%">%NAME%</b><br><small>%GROUP%<br>%AGE% %GENDER% %LOCATION%</small><br style="clear:both"></div></div> <div class="x_bcolor_y x_bottom_rounded" style="font-size:90%;padding:15px;text-align:left;height:160px;overflow:auto">%EDUCATION% %OCCUPATION% %INTERESTS%<br>%ABOUT%</div>'),
('profile_covers', 'backgrounds/cover01.jpg\r\nbackgrounds/cover02.jpg\r\nbackgrounds/cover03.jpg\r\nbackgrounds/cover04.jpg\r\nbackgrounds/cover05.jpg\r\nbackgrounds/cover06.jpg\r\nbackgrounds/cover07.jpg\r\nbackgrounds/cover08.jpg\r\nbackgrounds/cover09.jpg\r\nbackgrounds/cover10.jpg\r\nbackgrounds/cover11.jpg\r\nbackgrounds/cover12.jpg\r\nbackgrounds/cover13.jpg\r\nbackgrounds/cover14.jpg\r\nbackgrounds/cover15.jpg\r\nbackgrounds/cover16.jpg\r\nbackgrounds/cover17.jpg\r\nbackgrounds/cover18.jpg\r\nbackgrounds/cover19.jpg\r\nbackgrounds/cover20.jpg\r\nbackgrounds/cover21.jpg\r\nbackgrounds/cover22.jpg\r\nbackgrounds/cover23.jpg\r\nbackgrounds/cover24.jpg\r\nbackgrounds/cover25.jpg\r\nbackgrounds/cover26.jpg\r\nbackgrounds/cover27.jpg\r\nbackgrounds/cover28.jpg\r\nbackgrounds/cover29.jpg\r\nbackgrounds/cover30.jpg\r\nbackgrounds/cover31.jpg\r\nbackgrounds/cover32.jpg\r\nbackgrounds/cover33.jpg\r\nbackgrounds/cover34.jpg\r\nbackgrounds/cover35.jpg\r\nbackgrounds/cover36.jpg\r\nbackgrounds/cover37.jpg\r\nbackgrounds/cover38.jpg\r\nbackgrounds/cover39.jpg\r\nbackgrounds/cover40.jpg\r\nbackgrounds/cover41.jpg\r\nbackgrounds/cover42.jpg\r\nbackgrounds/cover43.jpg\r\nbackgrounds/cover44.jpg\r\n'),
('utf8_set', 'Arabic,Armenian,Bengali,Bopomofo,Braille,Buhid,Canadian_Aboriginal,Cherokee,Cyrillic,Devanagari,Ethiopic,Georgian,Greek,Gujarati,Gurmukhi,Han,Hangul,Hanunoo,Hebrew,Hiragana,Inherited,Kannada,Katakana,Khmer,Lao,Latin,Limbu,Malayalam,Mongolian,Myanmar,Ogham,Oriya,Runic,Sinhala,Syriac,Tagalog,Tagbanwa,TaiLe,Tamil,Telugu,Thaana,Thai,Tibetan,Yi'),
('utf8_run', '0'),
('utf8_msg', 'Please choose another name! Numeric-only names and and names containing letters of different alphabets are not allowed.'),
('avsize', '250'),
('chaton', '1'),
('chatoff', 'Our chat is closed now...'),
('rbox_sender', '8000001:1:GodFather'),
('gbox_sender', '8000003:1:GIFMaster'),
('ptop', ''),
('pmlog_stop', '86400'),
('tns_length', '200'),
('tns_lowprv', '0'),
('meta_ref', 'same-origin'),
('abox_key', '[[abox_key]]'),
('abox_sender', '8000004:1:AuntHedwig'),
('abox_count', '0'),
('abox_dtt', '0'),
('geo_period', '3600'),
('geo_timeout', '5'),
('geo_center', '35,33'),
('geo_zoom_i', '3'),
('geo_zoom_m', '13'),
('geo_error', '5'),
('geo_grey', '0'),
('geo_max', '50'),
('ip2c', ''),
('ip2hash', '1'),
('iplocate_key', ''),
('dfg_on', '1'),
('dfg_desc', ''),
('pg_on', '0'),
('pg_api_src', 'pg_iphub'),
('pg_api_key', ''),
('pg_timeout', '5'),
('pg_tcache', '86400'),
('pg_wlist', ''),
('pg_failmsg', 'Please turn off your VPN and refresh.'),
('tips_login', ''),
('tips_reg', ''),
('tips_pass', ''),
('acpreadonly', '1'),
('genderlist', 'Male,Female'),
('genderedit', '1'),
('force_av', '1'),
('offmsg_del', '1'),
('helpdesk_usr', ''),
('helpdesk_desc', ''),
('landing_header', ''),
('landing_footer', ''),
('unl_timeout', '0'),
('seo_page', ''),
('stripe_apikey', ''),
('webhook_secret', '[[wsecretkey]]'),
('shuffle_items', '1'),
('vipshop_info', 'Welcome to VIPSHOP! You can purchase VIP codes here. Select one and click BUY. A purchased VIP code can be applied only once.'),
('vipshop_title', 'VIPSHOP'),
('vipshop_theme', 'default'),
('success_msg', 'We appreciate your business. Your VIP code will be displayed very soon. There is no need to reload this page.'),
('cancel_msg', 'We are sorry but we cannot confirm your order.'),
('missing_msg', 'We are sorry but we cannot find your order. Please contact us.'),
('vote_seeres', '1'),
('vote_change', '1'),
('vote_ipaddr', '0'),
('vote_colors', '000,ba443e,c17d51,cca851,22865e,ad1457,0d47a1,74554d,6a1b9a,086269'),
('w_ofile', '/tmp/online'),
('w_cache', '120'),
('w_cross', '1'),
('w_onlu', '1'),
('w_onla', '1'),
('w_stat', '0'),
('w_tten', '0'),
('w_last', '0'),
('customhlrp', ''),
('customhchat', ''),
('globalfont', ''),
('dnmode', '1'),
('rsz_emoji', '160'),
('tinting_c', '#333'),
('tinting_o', '#444'),
('customjs', ''),
('bottomjs', ''),
('splash', ''),
('p2p_global', '1'),
('stun_svs', '{iceServers:[{urls:"turn:openrelay.metered.ca:80",username:"openrelayproject",credential:"openrelayproject",}, {urls:"turn:openrelay.metered.ca:443",username:"openrelayproject",credential:"openrelayproject",},],}'),
('ask_av', '0'),
('pingws', '0'),
('p2p_level', '1'),
('uf_order', '1'),
('min_qstat', '1'),
('qui_limit', '120'),
('qui_icons', '?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,⭐,?,?,?,?,?,?'),
('verify', '0'),
('verify_subj', '{LANG}'),
('verify_mssg', '{LANG}'),
('preset_subj', '{LANG}'),
('preset_mssg', '{LANG}'),
('vpm_smtp_host', ''),
('vpm_smtp_user', ''),
('vpm_smtp_pass', ''),
('vpm_smtp_from', ''),
('vpm_smtp_auth', 'true'),
('vpm_smtp_secu', 'tls'),
('vpm_smtp_port', '587'),
('vpm_smtp_mail', '0'),
('vpm_smtp_more', ''),
('vpm_blacklist', ''),
('vpm_passreset', '0'),
('vcs_cs_usr', ''),
('vcs_cs_key', ''),
('vcs_sender', 'VerifySMS'),
('vcs_whitelist', ''),
('vcs_blacklist', ''),
('clearscreen', ''),
('mailchange', '0'),
('vip_signs', ''),
('openai_token', ''),
('openai_model', 'gpt-5-nano'),
('openai_router', 'google/gemma-3-12b-it'),
('openai_temperature', '0.2'),
('openai_max_tokens', '500'),
('openai_trigger', 'TGF,TheGodFather,GodFather'),
('openai_min_length', '5'),
('openai_max_length', '350'),
('openai_timeout', '15'),
('openai_randoms', 'I am still here. Lurking in background...\nFor some reason I find some people moderately funny to hang out with.\nI usually do my utmost not to be angered or annoyed ? ? when I really feel angry and annoyed.\nChanging the topic... I know next to nothing about science or politics, but I do know a bit about ? British history ?. Test me, okay?\nPlease hold on, I just saw my mate ride off to choir practice on the back of that ? bike.'),
('openai_defmod', 'Keep it short and add a bit of sarcasm.\nMake your answer short and overly serious so that it sounds funny.');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_social`
--

CREATE TABLE `[[dbprefix]]_social` (
  `id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `userid` int(11) NOT NULL,
  `social` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sA` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sB` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sC` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sD` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_stimoji`
--

CREATE TABLE `[[dbprefix]]_stimoji` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `keytags` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  FULLTEXT KEY `keytags` (`keytags`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_style`
--

CREATE TABLE `[[dbprefix]]_style` (
  `id` int(11) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]_style`
--

INSERT INTO `[[dbprefix]]_style` VALUES
(1, '14'),
(2, 'sans-serif'),
(3, ''),
(4, 'FFFFFF'),
(5, '222222'),
(6, 'F44336'),
(7, '000000'),
(8, 'FFFFFF'),
(9, 'FFFFFF'),
(10, '111111'),
(11, 'FFFFFF'),
(12, '111111'),
(13, 'FFFFFF'),
(14, '000000'),
(15, '5'),
(16, '100'),
(17, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ufake`
--

CREATE TABLE `[[dbprefix]]_ufake` (
  `id` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `hour_begin` smallint(6) NOT NULL,
  `hour_end` smallint(6) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_users`
--

CREATE TABLE `[[dbprefix]]_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ugroup` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salt` char(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `question` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `vcode` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_users`
--

INSERT INTO `[[dbprefix]]_users` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '', '[[salt]]', '[[clientip]]', '[[ques]]', '[[eansw]]', [[timestamp]], '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_uxtra`
--

CREATE TABLE `[[dbprefix]]_uxtra` (
  `id` int(11) NOT NULL,
  `image` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `motto` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` smallint(6) NOT NULL,
  `location` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `education` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `occupation` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `interests` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `about` text COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_vip`
--

CREATE TABLE `[[dbprefix]]_vip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vsign` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salt` char(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_vipusr`
--

CREATE TABLE `[[dbprefix]]_vipusr` (
  `userid` int(11) NOT NULL,
  `username` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vip` int(11) NOT NULL,
  `timestamp` int(11) NOT NULL,
  `expirestamp` int(11) NOT NULL,
  `token` char(10) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_vorders`
--

CREATE TABLE `[[dbprefix]]_vorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `productid` int(11) NOT NULL,
  `pintent` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pstatus` int(11) NOT NULL,
  `viptoken` char(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vipcode` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bmail` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ipaddr` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_vproducts`
--

CREATE TABLE `[[dbprefix]]_vproducts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vipid` int(11) NOT NULL,
  `name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vdesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `vlength` int(11) NOT NULL,
  `stripepriceid` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `infoprice` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zorder` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
