<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class MandateImportEntriesIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\MandateImportEntry(array());
        $this->assertNotNull($obj);
    }
    
    public function testMandateImportEntriesCreate()
    {
        $fixture = $this->loadJsonFixture('mandate_import_entries')->create;
        $this->stub_request($fixture);

        $service = $this->client->mandateImportEntries();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_import_entries;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImportEntry', $response);

        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->record_identifier, $response->record_identifier);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testMandateImportEntriesList()
    {
        $fixture = $this->loadJsonFixture('mandate_import_entries')->list;
        $this->stub_request($fixture);

        $service = $this->client->mandateImportEntries();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->mandate_import_entries;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\MandateImportEntry', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->created_at, $record->created_at);
            $this->assertEquals($body[$num]->links, $record->links);
            $this->assertEquals($body[$num]->record_identifier, $record->record_identifier);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
