<?php
/**
 * LicenseServiceApi
 * PHP version 5
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\License
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * License
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0-beta
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.0.3
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Openprovider\Api\Rest\Client\License\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Openprovider\Api\Rest\Client\Base\ApiException;
use Openprovider\Api\Rest\Client\Base\Configuration;
use Openprovider\Api\Rest\Client\Base\HeaderSelector;
use Openprovider\Api\Rest\Client\Base\ObjectSerializer;

/**
 * LicenseServiceApi Class Doc Comment
 *
 * @category Class
 * @package  Openprovider\Api\Rest\Client\License
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LicenseServiceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createPleskLicense
     *
     * Create plesk license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function createPleskLicense($body)
    {
        list($response) = $this->createPleskLicenseWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createPleskLicenseWithHttpInfo
     *
     * Create plesk license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPleskLicenseWithHttpInfo($body)
    {
        $request = $this->createPleskLicenseRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createPleskLicenseAsync
     *
     * Create plesk license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPleskLicenseAsync($body)
    {
        return $this->createPleskLicenseAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createPleskLicenseAsyncWithHttpInfo
     *
     * Create plesk license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPleskLicenseAsyncWithHttpInfo($body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseResponse';
        $request = $this->createPleskLicenseRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPleskLicense'
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createPleskLicenseRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createPleskLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/plesk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createVirtuozzoLicense
     *
     * Create virtuozzo license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function createVirtuozzoLicense($body)
    {
        list($response) = $this->createVirtuozzoLicenseWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation createVirtuozzoLicenseWithHttpInfo
     *
     * Create virtuozzo license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function createVirtuozzoLicenseWithHttpInfo($body)
    {
        $request = $this->createVirtuozzoLicenseRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createVirtuozzoLicenseAsync
     *
     * Create virtuozzo license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createVirtuozzoLicenseAsync($body)
    {
        return $this->createVirtuozzoLicenseAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createVirtuozzoLicenseAsyncWithHttpInfo
     *
     * Create virtuozzo license
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createVirtuozzoLicenseAsyncWithHttpInfo($body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseResponse';
        $request = $this->createVirtuozzoLicenseRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createVirtuozzoLicense'
     *
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseCreateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createVirtuozzoLicenseRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createVirtuozzoLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/virtuozzo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePleskLicense
     *
     * Delete plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function deletePleskLicense($key_id)
    {
        list($response) = $this->deletePleskLicenseWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation deletePleskLicenseWithHttpInfo
     *
     * Delete plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePleskLicenseWithHttpInfo($key_id)
    {
        $request = $this->deletePleskLicenseRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deletePleskLicenseAsync
     *
     * Delete plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePleskLicenseAsync($key_id)
    {
        return $this->deletePleskLicenseAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePleskLicenseAsyncWithHttpInfo
     *
     * Delete plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePleskLicenseAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse';
        $request = $this->deletePleskLicenseRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePleskLicense'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deletePleskLicenseRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling deletePleskLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/plesk/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteVirtuozzoLicense
     *
     * Delete virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function deleteVirtuozzoLicense($key_id)
    {
        list($response) = $this->deleteVirtuozzoLicenseWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation deleteVirtuozzoLicenseWithHttpInfo
     *
     * Delete virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVirtuozzoLicenseWithHttpInfo($key_id)
    {
        $request = $this->deleteVirtuozzoLicenseRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteVirtuozzoLicenseAsync
     *
     * Delete virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVirtuozzoLicenseAsync($key_id)
    {
        return $this->deleteVirtuozzoLicenseAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteVirtuozzoLicenseAsyncWithHttpInfo
     *
     * Delete virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVirtuozzoLicenseAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseDeleteLicenseResponse';
        $request = $this->deleteVirtuozzoLicenseRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteVirtuozzoLicense'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteVirtuozzoLicenseRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling deleteVirtuozzoLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/virtuozzo/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPleskKey
     *
     * Get plesk key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function getPleskKey($key_id)
    {
        list($response) = $this->getPleskKeyWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation getPleskKeyWithHttpInfo
     *
     * Get plesk key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPleskKeyWithHttpInfo($key_id)
    {
        $request = $this->getPleskKeyRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPleskKeyAsync
     *
     * Get plesk key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPleskKeyAsync($key_id)
    {
        return $this->getPleskKeyAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPleskKeyAsyncWithHttpInfo
     *
     * Get plesk key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPleskKeyAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse';
        $request = $this->getPleskKeyRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPleskKey'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getPleskKeyRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling getPleskKey'
            );
        }

        $resourcePath = '/v1beta/licenses/plesk/key/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPleskLicense
     *
     * Get plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function getPleskLicense($key_id)
    {
        list($response) = $this->getPleskLicenseWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation getPleskLicenseWithHttpInfo
     *
     * Get plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPleskLicenseWithHttpInfo($key_id)
    {
        $request = $this->getPleskLicenseRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPleskLicenseAsync
     *
     * Get plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPleskLicenseAsync($key_id)
    {
        return $this->getPleskLicenseAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPleskLicenseAsyncWithHttpInfo
     *
     * Get plesk license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPleskLicenseAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse';
        $request = $this->getPleskLicenseRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPleskLicense'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getPleskLicenseRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling getPleskLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/plesk/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVirtuozzoKey
     *
     * Get virtuozzo key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function getVirtuozzoKey($key_id)
    {
        list($response) = $this->getVirtuozzoKeyWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation getVirtuozzoKeyWithHttpInfo
     *
     * Get virtuozzo key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVirtuozzoKeyWithHttpInfo($key_id)
    {
        $request = $this->getVirtuozzoKeyRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVirtuozzoKeyAsync
     *
     * Get virtuozzo key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVirtuozzoKeyAsync($key_id)
    {
        return $this->getVirtuozzoKeyAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVirtuozzoKeyAsyncWithHttpInfo
     *
     * Get virtuozzo key
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVirtuozzoKeyAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseKeyResponse';
        $request = $this->getVirtuozzoKeyRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVirtuozzoKey'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getVirtuozzoKeyRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling getVirtuozzoKey'
            );
        }

        $resourcePath = '/v1beta/licenses/virtuozzo/{key_id}/key';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVirtuozzoLicense
     *
     * Get virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function getVirtuozzoLicense($key_id)
    {
        list($response) = $this->getVirtuozzoLicenseWithHttpInfo($key_id);
        return $response;
    }

    /**
     * Operation getVirtuozzoLicenseWithHttpInfo
     *
     * Get virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVirtuozzoLicenseWithHttpInfo($key_id)
    {
        $request = $this->getVirtuozzoLicenseRequest($key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVirtuozzoLicenseAsync
     *
     * Get virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVirtuozzoLicenseAsync($key_id)
    {
        return $this->getVirtuozzoLicenseAsyncWithHttpInfo($key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVirtuozzoLicenseAsyncWithHttpInfo
     *
     * Get virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVirtuozzoLicenseAsyncWithHttpInfo($key_id)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseGetLicenseResponse';
        $request = $this->getVirtuozzoLicenseRequest($key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVirtuozzoLicense'
     *
     * @param  int $key_id License key ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getVirtuozzoLicenseRequest($key_id)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling getVirtuozzoLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/virtuozzo/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listItems
     *
     * List items
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function listItems($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null)
    {
        list($response) = $this->listItemsWithHttpInfo($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product);
        return $response;
    }

    /**
     * Operation listItemsWithHttpInfo
     *
     * List items
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listItemsWithHttpInfo($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null)
    {
        $request = $this->listItemsRequest($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listItemsAsync
     *
     * List items
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listItemsAsync($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null)
    {
        return $this->listItemsAsyncWithHttpInfo($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listItemsAsyncWithHttpInfo
     *
     * List items
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listItemsAsyncWithHttpInfo($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListItemsResponse';
        $request = $this->listItemsRequest($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listItems'
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listItemsRequest($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null)
    {

        $resourcePath = '/v1beta/licenses/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order_by_id !== null) {
            $queryParams['order_by.id'] = ObjectSerializer::toQueryValue($order_by_id);
        }
        // query params
        if ($order_by_key_id !== null) {
            $queryParams['order_by.key_id'] = ObjectSerializer::toQueryValue($order_by_key_id);
        }
        // query params
        if ($order_by_title !== null) {
            $queryParams['order_by.title'] = ObjectSerializer::toQueryValue($order_by_title);
        }
        // query params
        if ($order_by_product !== null) {
            $queryParams['order_by.product'] = ObjectSerializer::toQueryValue($order_by_product);
        }
        // query params
        if ($order_by_status !== null) {
            $queryParams['order_by.status'] = ObjectSerializer::toQueryValue($order_by_status);
        }
        // query params
        if ($order_by_key_number !== null) {
            $queryParams['order_by.key_number'] = ObjectSerializer::toQueryValue($order_by_key_number);
        }
        // query params
        if ($order_by_expiration_date !== null) {
            $queryParams['order_by.expiration_date'] = ObjectSerializer::toQueryValue($order_by_expiration_date);
        }
        // query params
        if ($product !== null) {
            $queryParams['product'] = ObjectSerializer::toQueryValue($product);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listLicensesWithPriceVersion
     *
     * List licenses with price version
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be sued. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     * @param  string $status License status. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function listLicensesWithPriceVersion($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null, $status = null)
    {
        list($response) = $this->listLicensesWithPriceVersionWithHttpInfo($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product, $key_number, $title_pattern, $key_number_pattern, $parent_key_id, $status);
        return $response;
    }

    /**
     * Operation listLicensesWithPriceVersionWithHttpInfo
     *
     * List licenses with price version
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be sued. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     * @param  string $status License status. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listLicensesWithPriceVersionWithHttpInfo($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null, $status = null)
    {
        $request = $this->listLicensesWithPriceVersionRequest($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product, $key_number, $title_pattern, $key_number_pattern, $parent_key_id, $status);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listLicensesWithPriceVersionAsync
     *
     * List licenses with price version
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be sued. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     * @param  string $status License status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listLicensesWithPriceVersionAsync($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null, $status = null)
    {
        return $this->listLicensesWithPriceVersionAsyncWithHttpInfo($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product, $key_number, $title_pattern, $key_number_pattern, $parent_key_id, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listLicensesWithPriceVersionAsyncWithHttpInfo
     *
     * List licenses with price version
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be sued. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     * @param  string $status License status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listLicensesWithPriceVersionAsyncWithHttpInfo($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null, $status = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesWithPriceVersionResponse';
        $request = $this->listLicensesWithPriceVersionRequest($limit, $offset, $order_by_id, $order_by_key_id, $order_by_title, $order_by_product, $order_by_status, $order_by_key_number, $order_by_expiration_date, $product, $key_number, $title_pattern, $key_number_pattern, $parent_key_id, $status);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listLicensesWithPriceVersion'
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  string $order_by_id Object ID. (optional)
     * @param  string $order_by_key_id License key ID. (optional)
     * @param  string $order_by_title Custom license title. (optional)
     * @param  string $order_by_product Product type (only Plesk is available). (optional)
     * @param  string $order_by_status License status. (optional)
     * @param  string $order_by_key_number License key number. (optional)
     * @param  string $order_by_expiration_date License expiration date. (optional)
     * @param  string $product Product type (only Plesk is available). (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be sued. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     * @param  string $status License status. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listLicensesWithPriceVersionRequest($limit = null, $offset = null, $order_by_id = null, $order_by_key_id = null, $order_by_title = null, $order_by_product = null, $order_by_status = null, $order_by_key_number = null, $order_by_expiration_date = null, $product = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null, $status = null)
    {

        $resourcePath = '/v1beta/licenses';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($order_by_id !== null) {
            $queryParams['order_by.id'] = ObjectSerializer::toQueryValue($order_by_id);
        }
        // query params
        if ($order_by_key_id !== null) {
            $queryParams['order_by.key_id'] = ObjectSerializer::toQueryValue($order_by_key_id);
        }
        // query params
        if ($order_by_title !== null) {
            $queryParams['order_by.title'] = ObjectSerializer::toQueryValue($order_by_title);
        }
        // query params
        if ($order_by_product !== null) {
            $queryParams['order_by.product'] = ObjectSerializer::toQueryValue($order_by_product);
        }
        // query params
        if ($order_by_status !== null) {
            $queryParams['order_by.status'] = ObjectSerializer::toQueryValue($order_by_status);
        }
        // query params
        if ($order_by_key_number !== null) {
            $queryParams['order_by.key_number'] = ObjectSerializer::toQueryValue($order_by_key_number);
        }
        // query params
        if ($order_by_expiration_date !== null) {
            $queryParams['order_by.expiration_date'] = ObjectSerializer::toQueryValue($order_by_expiration_date);
        }
        // query params
        if ($product !== null) {
            $queryParams['product'] = ObjectSerializer::toQueryValue($product);
        }
        // query params
        if ($key_number !== null) {
            $queryParams['key_number'] = ObjectSerializer::toQueryValue($key_number);
        }
        // query params
        if ($title_pattern !== null) {
            $queryParams['title_pattern'] = ObjectSerializer::toQueryValue($title_pattern);
        }
        // query params
        if ($key_number_pattern !== null) {
            $queryParams['key_number_pattern'] = ObjectSerializer::toQueryValue($key_number_pattern);
        }
        // query params
        if ($parent_key_id !== null) {
            $queryParams['parent_key_id'] = ObjectSerializer::toQueryValue($parent_key_id);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toQueryValue($status);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listPleskLicenses
     *
     * List plesk licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function listPleskLicenses($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        list($response) = $this->listPleskLicensesWithHttpInfo($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);
        return $response;
    }

    /**
     * Operation listPleskLicensesWithHttpInfo
     *
     * List plesk licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPleskLicensesWithHttpInfo($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        $request = $this->listPleskLicensesRequest($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listPleskLicensesAsync
     *
     * List plesk licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listPleskLicensesAsync($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        return $this->listPleskLicensesAsyncWithHttpInfo($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listPleskLicensesAsyncWithHttpInfo
     *
     * List plesk licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listPleskLicensesAsyncWithHttpInfo($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse';
        $request = $this->listPleskLicensesRequest($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listPleskLicenses'
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listPleskLicensesRequest($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {

        $resourcePath = '/v1beta/licenses/plesk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($key_id !== null) {
            $queryParams['key_id'] = ObjectSerializer::toQueryValue($key_id);
        }
        // query params
        if ($key_number !== null) {
            $queryParams['key_number'] = ObjectSerializer::toQueryValue($key_number);
        }
        // query params
        if ($title_pattern !== null) {
            $queryParams['title_pattern'] = ObjectSerializer::toQueryValue($title_pattern);
        }
        // query params
        if ($key_number_pattern !== null) {
            $queryParams['key_number_pattern'] = ObjectSerializer::toQueryValue($key_number_pattern);
        }
        // query params
        if ($parent_key_id !== null) {
            $queryParams['parent_key_id'] = ObjectSerializer::toQueryValue($parent_key_id);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listVirtuozzoLicenses
     *
     * List virtuozzo licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function listVirtuozzoLicenses($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        list($response) = $this->listVirtuozzoLicensesWithHttpInfo($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);
        return $response;
    }

    /**
     * Operation listVirtuozzoLicensesWithHttpInfo
     *
     * List virtuozzo licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function listVirtuozzoLicensesWithHttpInfo($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        $request = $this->listVirtuozzoLicensesRequest($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listVirtuozzoLicensesAsync
     *
     * List virtuozzo licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listVirtuozzoLicensesAsync($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        return $this->listVirtuozzoLicensesAsyncWithHttpInfo($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listVirtuozzoLicensesAsyncWithHttpInfo
     *
     * List virtuozzo licenses
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listVirtuozzoLicensesAsyncWithHttpInfo($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseListLicensesResponse';
        $request = $this->listVirtuozzoLicensesRequest($limit, $offset, $key_id, $key_number, $title_pattern, $key_number_pattern, $parent_key_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listVirtuozzoLicenses'
     *
     * @param  int $limit Output limit. (optional)
     * @param  int $offset Output offset. (optional)
     * @param  int $key_id License key ID. (optional)
     * @param  string $key_number License key number. (optional)
     * @param  string $title_pattern Custom title pattern. Wildcard (*) can be used. (optional)
     * @param  string $key_number_pattern License key number pattern. Wildcard (*) can be used. (optional)
     * @param  int $parent_key_id Key ID of the partent license. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function listVirtuozzoLicensesRequest($limit = null, $offset = null, $key_id = null, $key_number = null, $title_pattern = null, $key_number_pattern = null, $parent_key_id = null)
    {

        $resourcePath = '/v1beta/licenses/virtuozzo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($key_id !== null) {
            $queryParams['key_id'] = ObjectSerializer::toQueryValue($key_id);
        }
        // query params
        if ($key_number !== null) {
            $queryParams['key_number'] = ObjectSerializer::toQueryValue($key_number);
        }
        // query params
        if ($title_pattern !== null) {
            $queryParams['title_pattern'] = ObjectSerializer::toQueryValue($title_pattern);
        }
        // query params
        if ($key_number_pattern !== null) {
            $queryParams['key_number_pattern'] = ObjectSerializer::toQueryValue($key_number_pattern);
        }
        // query params
        if ($parent_key_id !== null) {
            $queryParams['parent_key_id'] = ObjectSerializer::toQueryValue($parent_key_id);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation resetHwid
     *
     * Reset hwid
     *
     * @param  string $product Product type (only Plesk is available) (required)
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function resetHwid($product, $key_id, $body)
    {
        list($response) = $this->resetHwidWithHttpInfo($product, $key_id, $body);
        return $response;
    }

    /**
     * Operation resetHwidWithHttpInfo
     *
     * Reset hwid
     *
     * @param  string $product Product type (only Plesk is available) (required)
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function resetHwidWithHttpInfo($product, $key_id, $body)
    {
        $request = $this->resetHwidRequest($product, $key_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation resetHwidAsync
     *
     * Reset hwid
     *
     * @param  string $product Product type (only Plesk is available) (required)
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetHwidAsync($product, $key_id, $body)
    {
        return $this->resetHwidAsyncWithHttpInfo($product, $key_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation resetHwidAsyncWithHttpInfo
     *
     * Reset hwid
     *
     * @param  string $product Product type (only Plesk is available) (required)
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function resetHwidAsyncWithHttpInfo($product, $key_id, $body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidResponse';
        $request = $this->resetHwidRequest($product, $key_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'resetHwid'
     *
     * @param  string $product Product type (only Plesk is available) (required)
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseResetHwidRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function resetHwidRequest($product, $key_id, $body)
    {
        // verify the required parameter 'product' is set
        if ($product === null || (is_array($product) && count($product) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product when calling resetHwid'
            );
        }
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling resetHwid'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling resetHwid'
            );
        }

        $resourcePath = '/v1beta/licenses/hwids/reset/{product}/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($product !== null) {
            $resourcePath = str_replace(
                '{' . 'product' . '}',
                ObjectSerializer::toPathValue($product),
                $resourcePath
            );
        }
        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePleskLicense
     *
     * Update plesk license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdatePleskLicenseRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function updatePleskLicense($key_id, $body)
    {
        list($response) = $this->updatePleskLicenseWithHttpInfo($key_id, $body);
        return $response;
    }

    /**
     * Operation updatePleskLicenseWithHttpInfo
     *
     * Update plesk license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdatePleskLicenseRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePleskLicenseWithHttpInfo($key_id, $body)
    {
        $request = $this->updatePleskLicenseRequest($key_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updatePleskLicenseAsync
     *
     * Update plesk license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePleskLicenseAsync($key_id, $body)
    {
        return $this->updatePleskLicenseAsyncWithHttpInfo($key_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updatePleskLicenseAsyncWithHttpInfo
     *
     * Update plesk license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePleskLicenseAsyncWithHttpInfo($key_id, $body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse';
        $request = $this->updatePleskLicenseRequest($key_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePleskLicense'
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdatePleskLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updatePleskLicenseRequest($key_id, $body)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling updatePleskLicense'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updatePleskLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/plesk/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateVirtuozzoLicense
     *
     * Update virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateVirtuozzoLicenseRequest $body body (required)
     *
     * @throws \Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError
     */
    public function updateVirtuozzoLicense($key_id, $body)
    {
        list($response) = $this->updateVirtuozzoLicenseWithHttpInfo($key_id, $body);
        return $response;
    }

    /**
     * Operation updateVirtuozzoLicenseWithHttpInfo
     *
     * Update virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateVirtuozzoLicenseRequest $body (required)
     *
     * @throws Openprovider\Api\Rest\Client\Base\ApiException; on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse|\Openprovider\Api\Rest\Client\License\Model\ErrorError, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateVirtuozzoLicenseWithHttpInfo($key_id, $body)
    {
        $request = $this->updateVirtuozzoLicenseRequest($key_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Openprovider\Api\Rest\Client\License\Model\ErrorError' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Openprovider\Api\Rest\Client\License\Model\ErrorError', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openprovider\Api\Rest\Client\License\Model\ErrorError',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateVirtuozzoLicenseAsync
     *
     * Update virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateVirtuozzoLicenseAsync($key_id, $body)
    {
        return $this->updateVirtuozzoLicenseAsyncWithHttpInfo($key_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateVirtuozzoLicenseAsyncWithHttpInfo
     *
     * Update virtuozzo license
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateVirtuozzoLicenseAsyncWithHttpInfo($key_id, $body)
    {
        $returnType = '\Openprovider\Api\Rest\Client\License\Model\LicenseUpdateLicenseResponse';
        $request = $this->updateVirtuozzoLicenseRequest($key_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateVirtuozzoLicense'
     *
     * @param  int $key_id License key ID (required)
     * @param  \Openprovider\Api\Rest\Client\License\Model\LicenseUpdateVirtuozzoLicenseRequest $body (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateVirtuozzoLicenseRequest($key_id, $body)
    {
        // verify the required parameter 'key_id' is set
        if ($key_id === null || (is_array($key_id) && count($key_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $key_id when calling updateVirtuozzoLicense'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling updateVirtuozzoLicense'
            );
        }

        $resourcePath = '/v1beta/licenses/virtuozzo/{key_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($key_id !== null) {
            $resourcePath = str_replace(
                '{' . 'key_id' . '}',
                ObjectSerializer::toPathValue($key_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
