<?php

session_start();

    include_once('../db/saucerer.php');
 
// Define variables and initialize with empty values
$id = $name = $token = $access = "";
$id_err = $name_err = $token_err = $access_err = "";


// Generating a random number
date_default_timezone_set('Africa/Kampala');
$today = date("His-dmY",time());

$code1 = rand(1,9); 
$code2 = rand(1,9);
$code3 = $code1 * $code2; 
$tokens = "$code3-$today";


// Check if the user is logged in, if not then redirect him to login page
if(!isset($_SESSION["failed"]) || $_SESSION["failed"] != true){

  $failed = "";
    
} elseif(!isset($_SESSION["failed"]) || $_SESSION["failed"] == true){

  $failed = $_SESSION['failed'];
 
}

// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){

    $name = trim($_POST["name"]);
    $token = trim($_POST["token"]);
    $access = trim($_POST["access"]);
 
    // Validate code
    if(empty(trim($_POST["access"]))){
        $access_err = "Invalid access code!";
    } else{
        // Prepare a select statement
        $sql = "SELECT id FROM access WHERE code = ?";
        
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_access);
            
            // Set parameters
            $param_access = trim($_POST["access"]);
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                /* store result */
                mysqli_stmt_store_result($stmt);
                    
                    if(mysqli_stmt_num_rows($stmt) == 0){

                    $action = "Login";
                    $attempt = "Failed";
                    $access_err = "Invalid access code!";

                    // Prepare an insert statement
                    $sql = "INSERT INTO secure (name, token, access, attempt, action) VALUES (?, ?, ?, ?, ?)";

                    if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "sssss", $param_name, $param_token, $param_access, $param_attempt, $param_action);
            
            // Set parameters
            $param_name = $name;
            $param_token = $token;
            $param_access = $access;
            $param_action = $action;
            $param_attempt = $attempt;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                            
                            // Store data in session variables
                            $_SESSION["failed"] = true;
                            $_SESSION["name"] = $name;   
                
            }

        }

                    }
                
            } else{
               $_SESSION['error'] = "Oops! Something went wrong. Please try again later.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Check input errors before inserting in database
    if(empty($name_err) && empty($token_err) && empty($access_err)){

        
        $action = "Login";
        $attempt = "Succesful";

        // Prepare an insert statement
        $sql = "INSERT INTO secure (name, token, access, attempt, action) VALUES (?, ?, ?, ?, ?)";
         
        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "sssss", $param_name, $param_token, $param_access, $param_attempt, $param_action);
            
            // Set parameters
            $param_name = $name;
            $param_token = $token;
            $param_access = $access;
            $param_action = $action;
            $param_attempt = $attempt;
            
            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){

                            session_start();
                            
                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["name"] = $name;
                            $_SESSION["token"] = $token;
                            $_SESSION["access"] = $access;

                // Redirect to login page
                header("location: ../");
            } else{
                $_SESSION['error'] = "Something went wrong. Please try again.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    
    // Close connection
    mysqli_close($link);

}
?>


<!DOCTYPE html>
<html>
<head>
<title>Secure | Business Edge &copy;</title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<meta name="description" content="News You Can Use">

<!-- Favicon  -->
<link rel="shortcut icon" href="../../images/favicon.png">
<link rel="apple-touch-icon" href="../../images/apple-touch-icon.png">



 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://businessedge.news/images/social-card/1.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="Secure | Business Edge Magazine &copy;">

    <meta property="og:url" content="https://businessedge.news/admin/secure">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="News You Can Use">

    <meta property="og:site_name" content="Business Edge Magazine &copy;">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://businessedge.news/admin/secure">

    <meta name="twitter:title" content="Secure | Business Edge Magazine &copy;">

    <meta name="twitter:description" content="News You Can Use">

    <meta name="twitter:image" content="https://businessedge.news/images/social-card/1.png">

    <meta name="twitter:site" content="@BusinessEdge">

    <meta name="twitter:creator" content="@iann_thecreator">

<link rel="stylesheet" type="text/css" href="../../assets/css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="../../assets/css/font-awesome.min.css">
<link rel="stylesheet" type="text/css" href="../../assets/css/animate.css">
<link rel="stylesheet" type="text/css" href="../../assets/css/slick.css">
<link rel="stylesheet" type="text/css" href="../../assets/css/theme.css">
<link rel="stylesheet" type="text/css" href="../../assets/css/style.css">

  <!--Fontawesome 6-->
  <link href="../../assets/fontawesome/css/all.css" rel="stylesheet">    

  <!--Animations-->
  <link rel="stylesheet" type="text/css" href="../../assets/css/animations/style.css"> 

  <link rel="stylesheet" type="text/css" href="../../assets/datatable/dataTable.bootstrap.min.css">

<!--[if lt IE 9]>
<script src="../../assets/js/html5shiv.min.js"></script>
<script src="../../assets/js/respond.min.js"></script>
<![endif]-->


</head>
<body>
<a class="scrollToTop" href="#"><i class="fa fa-angle-up"></i></a>
<div class="container">
  <header id="header">
    <div class="row">
      <div class="col-lg-12 col-md-12">
        <div class="header_top">
          <div class="header_top_left">
            <ul class="top_nav">
              <li><a href="https://facebook.com/BusinessEdge"><i class="fab fa-facebook"></i></a></li>
              <li><a href="https://x.com/BusinessEdge"><i class="fab fa-x-twitter"></i></a></li>
              <li><a href="https://instagram.com/BusinessEdge"><i class="fab fa-instagram"></i></a></li>
              <li><a href="https://linkedin.com/BusinessEdge"><i class="fab fa-linkedin"></i></a></li>
              <li><a href="https://tiktok.com/BusinessEdge"><i class="fab fa-tiktok"></i></a></li>
              <li><a href="https://wa.me/256785196012?text=https://demos.customassistinc.com/clients/BusinessEdge *Business Edge Support* %0D%0A  %0D%0A Hello, what do you wish to talk about? %0D%0A  %0D%0A"><i class="fab fa-whatsapp"></i></a></li>
            </ul>
          </div>
          <div class="header_top_center">
            <ul class="top_nav slick_slider5">
              <li><a>News You Can Use!</a></li>
              <li><a>Top business stories across the nation</a></li>
              <li><a>Amazing blogs & articles.<span class="flash">.</span></a></li>
            </ul>
          </div>
          <div class="header_top_right">
            <form class="search_form">
              <input type="text" name="Search_Main" id="Search_Main" placeholder="Text to Search">
              <input type="submit" name="main_search" id="main_search" value="">
            </form>
          </div>
        </div>
        <div class="header_bottom">
          <div class="header_bottom_left"><a class="logo" href="../../" style="color: red;"><img src="../../images/logo/1.png" width="100%" alt="Business Edge"></a></div>
          <div class="header_bottom_right"><a href="#"><img src="../../images/banners/1.png" alt="" width="100%"></a></div>
        </div>
      </div>
    </div>
  </header>
  
  <!-- ==========  Search wrapper ========== -->
        <div id="main_search_box"></div>
  <!-- ==========  Search wrapper ========== -->
  
  
  <div id="navarea">
    <nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid">
        <div class="navbar-header">
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar"> <span class="sr-only">Toggle navigation</span> <span class="icon-bar"></span> <span class="icon-bar"></span> <span class="icon-bar"></span> </button>
        </div>
        <div class="header_top_center one">
            <ul class="top_nav slick_slider5">
              <li><a>News You Can Use!</a></li>
              <li><a>Top business stories across the nation</a></li>
              <li><a>Amazing blogs & articles.<span class="flash">.</span></a></li>
            </ul>
          </div>
        <div id="navbar" class="navbar-collapse collapse">
          <ul class="nav navbar-nav custom_nav">
            <li><a href="../../">Home</a></li>
            <li class="dropdown"> <a href="#" class="" data-toggle="dropdown" role="button" aria-expanded="false">News <i class="fa fa-caret-down"></i></a>
              <ul class="dropdown-menu" role="menu">
  <?php
          $sql = "SELECT * FROM categories WHERE action='' ORDER BY count DESC";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){

        echo '<li><a href="../../News/'.$row["title"].'">'.$row["title"].'</a></li>';
      }
    ?>
              </ul>
            </li>
            <li class="dropdown"> <a href="#" class="" data-toggle="dropdown" role="button" aria-expanded="false">Features <i class="fa fa-caret-down"></i></a>
              <ul class="dropdown-menu" role="menu">
                <li><a href="../../Features/Top Stories">Top Stories</a></li>
                <li><a href="../../Features/Latest">Latest</a></li>
                <li><a href="../../Features/Special Report">Special Report</a></li>
                <li><a href="../../Features/Popular">Popular</a></li>
                <li><a href="../../Features/Trending">Trending</a></li>
                <li><a href="../../Features/Hot">Hot 🔥</a></li>
              </ul>
            </li>
            <li><a href="../../Columns">Columns</a></li>
            <li><a href="../../OPED">OpEd</a></li>
            <li><a href="../../Blogs">Blogs</a></li>
            <li><a href="../../Contact Us">Contact Us</a></li>
            <li><a href="../../About Us">About Us</a></li>
          </ul>
        </div>
      </div>
    </nav>
  </div>
    <section id="ContactContent">
      <div class="row">
        <div class="col-lg-12 col-md-12 col-sm-12">
          <div class="contact_area">
            <ol class="breadcrumb">
              <li><a href="../../">Home</a></li>
              <li class="active">Secure</li>
            </ol>
            <h1>Secure</h1>
            
            <div class="contact_bottom">
              <div class="contact_us wow fadeInRightBig">
                <h2>Smart Validator</h2>
                <form class="contact_form" method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" enctype="multipart/form-data">
                
                <div class="form_item <?php echo (!empty($name_err)) ? 'has-error' : ''; ?>">
                <?php 

                if ($failed == true) {
                     echo '<input class="form-control" type="text" name="name" value="'.$_SESSION["name"].'">';
                } elseif ($failed != true) {
                    echo '<input class="form-control" type="text" name="name" placeholder="Full Names">';
                }

                ?>
                  <span class="help-block"><?php echo $name_err; ?></span>
                </div>
                
                <div class="form_item <?php echo (!empty($access_err)) ? 'has-error' : ''; ?>">
                  <input class="form-control" type="text" name="access" placeholder="Access Code">
                  <span class="help-block"><?php echo $access_err; ?></span>
                </div>

                  <input class="form-control" type="hidden" name="token" value="<?php echo $tokens; ?>">

                  <input type="submit" name="submit" value="Access Panel">

                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
</div>
<footer id="footer">
  <div class="footer_top">
    <div class="container">
      <div class="row">
        <div class="col-lg-4 col-md-4 col-sm-4">
          <div class="single_footer_top wow fadeInLeft">
            <h2>Trending Images</h2>
            <ul class="flicker_nav">

      <?php

          $sql = "SELECT * FROM articles WHERE category != 'OpEd' ORDER BY id DESC LIMIT 8";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){
          echo '<li><a href="../../Story/?story='.$row["url"].'" class="slick_slider3">';
          echo '<img src="../../admin/images/'.$row["image1"].'" alt='.$row["title"].'>';
            if ($row['image2']) {
              echo '<img src="../../admin/images/'.$row["image2"].'" alt='.$row["title"].'>';
            }
            if ($row['image3']) {
              echo '<img src="../../admin/images/'.$row["image3"].'" alt='.$row["title"].'>';
            }
            if ($row['image4']) {
              echo '<img src="../../admin/images/'.$row["image4"].'" alt='.$row["title"].'>';
            }
            if ($row['image5']) {
              echo '<img src="../../admin/images/'.$row["image5"].'" alt='.$row["title"].'>';
            }
        
          echo '</a></li>';
        
      }

    ?>
            </ul>
          </div>
        </div>
        <div class="col-lg-4 col-md-4 col-sm-4">
          <div class="single_footer_top wow fadeInDown">
            <h2>Stories</h2>
            <ul class="labels_nav">

        <?php

          $sql = "SELECT * FROM categories WHERE action = '' ORDER BY id";

          //use for MySQLi-OOP
          $query = $conn->query($sql);

              while($row = $query->fetch_assoc()){
              echo '<li><a href="../../News/'.$row["title"].'">'.$row["title"].'</a></li>';
          }

        ?>

        <li><a href="../../News">See All</a></li>

            </ul>
          </div>
        </div>
        <div class="col-lg-4 col-md-4 col-sm-4">
          <div class="single_footer_top wow fadeInRight">
            <h2>Overview</h2>
            <p><b>Business Edge</b> is a business based magazine that brings you the <b>News You Can Use</b> with the latest news, appealing stories & impactful blogs.</p>
            <ul class="labels_nav">
              <li><a href="../../About Us">About Us</a></li>
              <li><a href="../../Contact Us">Contact Us</a></li>
              <li><a href="../../FAQs">FAQs</a></li>
              <li><a href="../../Terms">T&Cs</a></li>
            </ul> <br>
            <ul class="bottom_socials">
              <li><a href="https://facebook.com/BusinessEdge"><i class="fab fa-facebook"></i></a></li>
              <li><a href="https://x.com/BusinessEdge"><i class="fab fa-x-twitter"></i></a></li>
              <li><a href="https://instagram.com/BusinessEdge"><i class="fab fa-instagram"></i></a></li>
              <li><a href="https://linkedin.com/BusinessEdge"><i class="fab fa-linkedin"></i></a></li>
              <li><a href="https://tiktok.com/BusinessEdge"><i class="fab fa-tiktok"></i></a></li>
              <li><a href="https://wa.me/256785196012?text=https://demos.customassistinc.com/clients/BusinessEdge *Business Edge Support* %0D%0A  %0D%0A Hello, what do you wish to talk about? %0D%0A  %0D%0A"><i class="fab fa-whatsapp"></i></a></li>
            </ul>
          </p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="footer_bottom">
    <div class="container">
      <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
          <div class="footer_bottom_left">
            <p>Copyright &copy; <script>document.write(new Date().getFullYear());</script>, <a href="#!">Business Edge Magazine</a></p>
          </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
          <div class="footer_bottom_right">
            <p>Powered by <a href="https://customassistinc.com">Custom Assist Inc<span class="flash">.</span></a></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</footer>



<script src="../../assets/js/jquery.min.js"></script> 
<script src="../../assets/js/bootstrap.min.js"></script> 
<script src="../../assets/js/wow.min.js"></script> 
<script src="../../assets/js/slick.min.js"></script> 
<script src="../../assets/js/custom.js"></script>

<!-- Upload Image JS -->
<script src="../../assets/js/upload_img_script.js"></script>



<script>
$(document).ready(function() {
  var delay = 500;
  $('#submit').click(function(e){
    e.preventDefault();
    
    var username = $('#username').val();
    
    var name = $('#name').val();
    if(name == ''){
      $('#message_box').html(
      '<span style="color:#E42028; font-weight:bold; font-size: 12px;">Please enter your name first!</span>'
      );
      $('#name').focus();
            return false;
     }
    
    var phone = $('#phone').val();
    if(phone == ''){
      $('#message_box').html(
      '<span style="color:#E42028; font-weight:bold; font-size: 12px;">Please enter your active phone number!</span>'
      );
      $('#phone').focus();
            return false;
     }

    var email = $('#email').val();
    if(email == ''){
      $('#message_box').html(
      '<span style="color:#E42028; font-weight:bold; font-size: 12px;">Please enter your email address!</span>'
      );
      $('#email').focus();
            return false;
    }
    if( $("#email").val()!='' ){
      if( !isValidEmailAddress( $("#email").val() ) ){
      $('#message_box').html(
      '<span style="color:#E42028; font-weight:bold; font-size: 12px;">Provided email address is incorrect!</span>'
      );
      $('#email').focus();
      return false;
      }
    }
    
    var message = $('#message').val();
    if(message == ''){
      $('#message_box').html(
      '<span style="color:#E42028; font-weight:bold; font-size: 12px;">Please enter a message!</span>'
      );
      $('#message').focus();
            return false;
     }

    var submit = $('#submit').val();

      $.ajax
      ({
             type: "POST",
       url: "contact/index.php",
             data: "name="+name+"&email="+email+"&phone="+phone+"&username="+username+"&message="+message+"&submit="+submit,
       beforeSend: function() {
       $('#message_box').html(
       '<div align="center"><img src="../../images/ajax-loader.gif" width="25" height="25"/></div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('#message_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

//Email validation Function 
function isValidEmailAddress(emailAddress) {
    var pattern = /^([a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+(\.[a-z\d!#$%&'*+\-\/=?^_`{|}~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+)*|"((([ \t]*\r\n)?[ \t]+)?([\x01-\x08\x0b\x0c\x0e-\x1f\x7f\x21\x23-\x5b\x5d-\x7e\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|\\[\x01-\x09\x0b\x0c\x0d-\x7f\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))*(([ \t]*\r\n)?[ \t]+)?")@(([a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\d\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.)+([a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]|[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF][a-z\d\-._~\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]*[a-z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])\.?$/i;
    return pattern.test(emailAddress);
};


</script>


<script>

//Main Search

$(document).ready(function() {
  var delay = 500;
  $('#main_search').click(function(e){
    e.preventDefault();
    
    var Search_Main = $('#Search_Main').val();

    var main_search = $('#main_search').val();
          
      $.ajax
      ({
             type: "POST",
       url: "../../Search/two/index.php",
             data: "Search_Main="+Search_Main+"&main_search="+main_search,
       beforeSend: function() {
       $('#main_search_box').html(
       '<div id="ajax-status">&nbsp;</div>'
       );
       },    
             success: function(data)
       {
         setTimeout(function() {
                    $('#main_search_box').html(data);
                }, delay);
      
             }
       });
  });
      
});

</script>



</body>
</html>