<?php

/**
 * @copyright  2025 Ad Aures
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html AGPL3
 * @link       https://castopod.org/
 */

/* Autogenerated from https://raw.githubusercontent.com/Podcastindex-org/podcast-namespace/main/taxonomy-fr.json on 2025-12-20T19:00:26+00:00 */

return [
  'persons' => [
    'creative_direction' => [
      'label' => 'Direction de Création',
      'roles' => [
        'director' => [
          'label' => 'Réalisat·eur·rice',
          'description' => 'Le directeur est à la tête de toute la production créative, des détails créatifs à la logistique. Il n\'y a généralement qu\'un seul réalisateur pour une production. Ce rôle est principalement vu dans les podcasts de fiction.',
          'example' => 'Jenna Knorr pour « Bienvenue à Tinsel Town »',
        ],
        'assistant_director' => [
          'label' => 'Réalisat·eur·rice-Assistant·e',
          'description' => 'Le directeur adjoint est une liaison entre le réalisateur et le reste de la production, coordonnant souvent la logistique quotidienne de la production. Il peut y avoir plusieurs directeurs adjoints sur un projet. Ce rôle est principalement vu dans les podcasts de fiction.',
          'example' => 'William Wright pour « Inn Between »',
        ],
        'executive_producer' => [
          'label' => 'Product·eur·rice exécut·if·ive',
          'description' => 'Le producteur exécutif est le producteur principal d\'une production. Le rôle peut varier en termes de contrôle créatif, certains « EP » détenant la direction créative d\'un podcast (en fait en assumant le rôle de réalisateur), tandis que d\'autres peuvent adopter une approche plus pratique. Le producteur exécutif a peut-être collecté des fonds pour financer la production, mais ce n\'est pas une responsabilité nécessaire du rôle.',
          'example' => 'Jane Rotonda pour « The Larry Meiller Show »',
        ],
        'senior_producer' => [
          'label' => 'Premi·er·ère Réalisat·eur·rice',
          'description' => 'Le producteur principal est le deuxième producteur le plus ancien de la production (deuxième après le producteur exécutif). Ils supervisent les producteurs et la direction générale et la logistique de l\'ensemble de la production.',
          'example' => 'Dr. Jeremy Weisz de « INspired INsider »',
        ],
        'producer' => [
          'label' => 'Product·eur·rice',
          'description' => 'Le producteur coordonne et exécute la production du podcast. Ces tâches peuvent inclure l\'aide à l\'élaboration de la direction créative d\'un projet, la budgétisation, la recherche, la planification et la supervision de l\'édition et de la production finale.',
          'example' => '',
        ],
        'associate_producer' => [
          'label' => 'Product·eur·rice Délégué·e',
          'description' => 'Le producteur associé remplit une ou plusieurs fonctions de producteur qui lui sont déléguées par un producteur.',
          'example' => 'Alex Baumhardt pour « APM Reports »',
        ],
        'development_producer' => [
          'label' => 'Product·eur·rice au Développement',
          'description' => 'Le producteur de développement coordonne et exécute la direction de création de pré-production d\'un podcast. Leurs responsabilités consistent à trouver de nouvelles idées d\'épisodes et de séries et à travailler avec des écrivains et des chercheurs pour préparer le concept pour la production.',
          'example' => '',
        ],
        'creative_director' => [
          'label' => 'Direct·eur·rice de la Création',
          'description' => 'Le directeur de la création est responsable de la stratégie créative et de l\'exécution de toute une série. Souvent, ce rôle dépasse le contenu pour affecter les œuvres d\'art, la musique, les campagnes marketing, etc.',
          'example' => 'Neil Druckmann sur « The Official The Last of Us »',
        ],
      ],
    ],
    'cast' => [
      'label' => 'Distribution',
      'roles' => [
        'host' => [
          'label' => 'Présentat·eur·rice',
          'description' => 'L\'hôte est le maître des cérémonies à l\'antenne du podcast et une présence constante sur chaque épisode (à l\'exception des hôtes invités et des épisodes alternatifs). Les tâches de l\'hôte peuvent inclure la réalisation d\'entrevues, l\'introduction d\'histoires et de segments, la narration, etc. Il peut y avoir plus d\'un hôte par podcast ou épisode.',
          'example' => 'Joe Rogan pour « The Joe Rogan Experience »',
        ],
        'co_host' => [
          'label' => 'Co-Présentat·eur·rice',
          'description' => 'Le co-animateur remplit bon nombre des mêmes tâches que l\'hôte, tout en prenant une présence secondaire sur le podcast.',
          'example' => 'Dax Shepard pour « Armchair Expert »',
        ],
        'guest_host' => [
          'label' => 'Présentat·eur·rice Exceptionnel·le',
          'description' => 'L\'hôte invité remplit toutes les fonctions du rôle d\'hôte traditionnel, mais le fait à titre temporaire. Souvent en une seule apparition ou en une courte période d\'épisodes.',
          'example' => 'Erica Kelly sur « Let\'s Taco \'Bout Women and True Crime »',
        ],
        'guest' => [
          'label' => 'Invité·e',
          'description' => 'L\'invité est une partie extérieure qui fait une apparition à l\'antenne sur un épisode, souvent en tant que participant à un panel ou sujet de l\'interview.',
          'example' => 'Lewis Brindley pour « Triforce!"',
        ],
        'voice_actor' => [
          'label' => 'Comédien·ne Voix',
          'description' => 'The Voice Actor donne une performance dans laquelle ils prêtent leur voix au rôle d\'un personnage dans un épisode de podcast. Alors que la majorité des rôles de doublage seront fictifs, le rôle de doubleur peut également couvrir des reconstitutions de conversations et de personnes réelles.',
          'example' => 'Venk Potula pour « Masala Jones »',
        ],
        'narrator' => [
          'label' => 'Narrat·eur·rice',
          'description' => 'The Narrator donne une performance dans laquelle racontent l\'exposition d\'une histoire fictive ou non fictive, souvent de manière scénarisée. Le narrateur peut également interpréter des voix de personnages dans l\'histoire, à condition qu\'ils conservent toujours le rôle de conteur d\'exposition ou de « voix de Dieu ».',
          'example' => 'James Harvey Freetly pour « Lakeshore & Limbo »',
        ],
        'announcer' => [
          'label' => 'Annonc·eur·euse',
          'description' => 'L\'annonceur donne de courtes performances vocales pour l\'introduction du podcast, des sujets d\'épisode, des segments, des invités, des prix, etc. L\'annonceur est secondaire par rapport à l\'hôte du podcast et effectue souvent ses introductions d\'une manière scénarisée et produite.',
          'example' => 'Lydia Kapp pour « World Builders Anonymous »',
        ],
        'reporter' => [
          'label' => 'Journaliste',
          'description' => 'Le journaliste trouve et étudie des nouvelles ou des histoires pour le podcast, interviewant souvent des sujets et menant des recherches. Le journaliste peut également être un poste à l\'antenne, car il transmet les idées de son enquête.',
          'example' => '',
        ],
      ],
    ],
    'writing' => [
      'label' => 'Écriture',
      'roles' => [
        'author' => [
          'label' => 'Aut·eur·rice',
          'description' => 'L\'auteur a écrit de la prose ou de la poésie initialement destinée à un texte qui est maintenant lu textuellement à l\'antenne.',
          'example' => 'Heiko Martens pour « The Sigmund Freud Files »',
        ],
        'editorial_director' => [
          'label' => 'Direct·eur·rice de la Rédaction',
          'description' => 'Le directeur de la rédaction dirige tous les départements de l\'organisation derrière le podcast et est responsable de la délégation des tâches aux membres du personnel et de leur gestion. Ils sont l\'éditeur le plus haut placé et sont responsables de la direction, de l\'exactitude et des décisions derrière le contenu de podcast.',
          'example' => 'Christopher Twarowski pour « News Beat »',
        ],
        'co_writer' => [
          'label' => 'Co-rédact·eur·rice',
          'description' => 'Le co-scénariste a écrit un podcast en partenariat avec 1 ou 2 autres écrivains, partageant ainsi le mérite de l\'arc créatif, du dialogue et de la narration.',
          'example' => 'Max Eggers dans « THE LIGHTHOUSE »',
        ],
        'writer' => [
          'label' => 'Rédact·eur·rice',
          'description' => 'The Writer a écrit l\'histoire ou le dialogue d\'un podcast. L\'écrivain est souvent impliqué dans l\'arc créatif d\'une production, mais ce n\'est pas une condition nécessaire. Les écrivains peuvent travailler dans des podcasts fictifs ou non fictifs.',
          'example' => '',
        ],
        'songwriter' => [
          'label' => 'Aut·eur·rice Composit·eur·rice',
          'description' => 'L\'auteur-compositeur a écrit les paroles et / ou la musique d\'accompagnement d\'une chanson originale créée pour le podcast et jouée sur un épisode.',
          'example' => 'Ben Lapidus pour « Gay Future »',
        ],
        'guest_writer' => [
          'label' => 'Rédact·eur·rice Invité·e',
          'description' => 'L\'écrivain invité remplit les fonctions d\'écrivain à titre temporaire, souvent sous la forme d\'un épisode unique ou d\'une courte période d\'épisodes. La distinction entre écrivain et écrivain invité dépend de la décision du podcast lui-même.',
          'example' => 'Beth Crane pour « The Unseen Hour »',
        ],
        'story_editor' => [
          'label' => 'Rédact·eur·rice en Chef ',
          'description' => 'L\'éditeur d\'histoire est responsable de la direction générale de l\'arc de l\'histoire et du développement des personnages d\'un podcast. Souvent vu dans les podcasts de fiction et documentaires.',
          'example' => 'Gabrielle Loux pour « The NoSleep Podcast »',
        ],
        'managing_editor' => [
          'label' => 'Direct·eur·rice de la Publication',
          'description' => 'Le rédacteur en chef supervise et coordonne les activités éditoriales des podcasts, en fournissant à la fois une édition détaillée et la gestion d\'une équipe de rédacteurs et d\'éditeurs pour s\'assurer que les délais et les budgets sont respectés.',
          'example' => 'Flora Lichtman pour « Every Little Thing »',
        ],
        'script_editor' => [
          'label' => 'Chef·fe-Scénariste',
          'description' => 'L\'éditeur de script fournit des notes et des modifications au script d\'enregistrement dans un rôle très pratique. L\'éditeur de script est principalement utilisé dans la fiction, les documentaires et les publicités où les enregistrements scénarisés sont répandus.',
          'example' => 'Alex Rioux pour « Bienvenue à Tinsel Town: A Christmas Adventure »',
        ],
        'script_coordinator' => [
          'label' => 'Coordinat·eur·rice de scénario',
          'description' => 'Le coordinateur du scénario emballe le script final avec des annotations qui reflètent une logistique spécifique et des indices créatifs pour l\'enregistrement et la production.',
          'example' => 'Alex Rioux pour « Bienvenue à Tinsel Town: A Christmas Adventure »',
        ],
        'researcher' => [
          'label' => 'Enquêt·eur·rice',
          'description' => 'Le chercheur coordonne la recherche et la vérification des informations qui peuvent ensuite être utilisées pour le contenu d\'un épisode de podcast, informant souvent la direction d\'une histoire en fonction de nouvelles informations découvertes.',
          'example' => 'Dave Grave pour « The Zero Brain Podcast »',
        ],
        'editor' => [
          'label' => 'Édit·eur·rice',
          'description' => 'L\'éditeur examine et prépare des scripts pour transmettre des informations de manière créative, précise et engageante.',
          'example' => '',
        ],
        'fact_checker' => [
          'label' => 'Contrôl·eur·euse Qualité',
          'description' => 'Le vérificateur de faits examine le contenu d\'un podcast pour vérifier l\'exactitude des faits et vérifie que l\'attribution des citations est correcte. Ils utilisent une variété d\'outils, y compris la recherche de tiers et la sensibilisation individuelle. Souvent, le vérificateur de faits fournira également des notes sur la façon dont la production peut éviter la confusion dans la livraison des informations dans l\'épisode.',
          'example' => '',
        ],
        'translator' => [
          'label' => 'Traduct·eur·rice',
          'description' => 'Le traducteur convertit le contenu d\'une langue à une autre pour le podcast. Cela peut être des interviews, des dialogues, des documents texte, etc. Le travail du traducteur peut être utilisé à l\'antenne ou en coulisses pendant le processus de production / recherche.',
          'example' => '',
        ],
        'transcriber' => [
          'label' => 'Transcript·eur·rice',
          'description' => 'Le transcripteur transforme les dialogues et les signaux audio en texte, qui peut être utilisé en interne pour les processus de production ou affiché publiquement pour les auditeurs.',
          'example' => '',
        ],
        'logger' => [
          'label' => 'Archiviste',
          'description' => 'The Logger examine et documente le contenu et les horodatages de l\'audio brut au service des producteurs et des éditeurs dans le processus de production.',
          'example' => '',
        ],
      ],
    ],
    'audio_production' => [
      'label' => 'Production Audio',
      'roles' => [
        'studio_coordinator' => [
          'label' => 'Coordinat·eur·rice de Studio',
          'description' => 'Le coordonnateur de studio gère le studio d\'enregistrement et les techniciens audio travaillant dans le studio au moment de l\'enregistrement.',
          'example' => '',
        ],
        'technical_director' => [
          'label' => 'Direct·eur·rice Technique',
          'description' => 'Le directeur technique supervise l\'enregistrement et la production du podcast car il est impliqué dans les technologies audio, y compris le matériel et les logiciels, et la gestion des rôles impliqués dans ces domaines.',
          'example' => 'Adam Raymonda sur « Celebuzz\'d »',
        ],
        'technical_manager' => [
          'label' => 'Responsable Technique',
          'description' => 'Le directeur technique coordonne une équipe d\'ingénieurs du son et de personnel de studio, dans l\'enregistrement et la production car il est impliqué dans les technologies audio, y compris le matériel et les logiciels.',
          'example' => '',
        ],
        'audio_engineer' => [
          'label' => 'Ingénieur·e du Son',
          'description' => 'L\'ingénieur audio aide à enregistrer et à produire de l\'audio en configurant des environnements d\'enregistrement, en surveillant le recodage et en apportant des ajustements techniques tout au long. L\'ingénieur audio est présent pendant le processus d\'enregistrement, effectuant le plus souvent des ajustements en temps réel. L\'ingénieur du son peut travailler avec des conversations, de la musique, des chansons ou tout autre type d\'audio.',
          'example' => 'Peter Leonard de « Startup Podcast »',
        ],
        'remote_recording_engineer' => [
          'label' => 'Pren·eur·euse de Son sur Site',
          'description' => 'L\'ingénieur d\'enregistrement à distance assure l\'enregistrement correct des conversations ayant lieu à plusieurs endroits sur une ligne téléphonique ou une connexion Internet. L\'ingénieur d\'enregistrement à distance évalue les différentes configurations d\'enregistrement et tente de les réconcilier en un son cohérent, tout en surveillant également le processus d\'enregistrement pour capturer le meilleur son possible.',
          'example' => '',
        ],
        'post_production_engineer' => [
          'label' => 'Ingénieur·e Post-Production',
          'description' => 'L\'ingénieur postproduction évalue les technologies audio et leur application en ce qui concerne les étapes finales de production et de publication.',
          'example' => 'Dick Wound pour « Queens Next Door »',
        ],
      ],
    ],
    'audio_post_production' => [
      'label' => 'Post-Production Audio',
      'roles' => [
        'audio_editor' => [
          'label' => 'Mont·eur·euse Son',
          'description' => 'L\'éditeur audio coupe et réorganise l\'audio à des fins de clarté et de narration. L\'éditeur audio peut également effectuer un traitement et un mastering audio généraux.',
          'example' => '',
        ],
        'sound_designer' => [
          'label' => 'Concept·eur·rice Sonore',
          'description' => 'Le Sound Designer crée et compose une variété d\'éléments audio. Ces éléments sont pour la plupart secondaires à la parole, mais un Sound Designer peut éditer / produire des éléments de discours de manière créative d\'une manière artistique.',
          'example' => '',
        ],
        'foley_artist' => [
          'label' => 'Illustrat·eur·rice Sonore',
          'description' => 'Les effets sonores de l\'artiste Foley pour un podcast et peuvent le faire à la fois via un enregistrement physique et un traitement numérique, ou une combinaison des deux.',
          'example' => '',
        ],
        'composer' => [
          'label' => 'Composit·eur·rice',
          'description' => 'Le compositeur écrit une pièce musicale originale (ou plusieurs) qui est jouée sur l\'épisode publié. Le compositeur sera également souvent l\'interprète de ladite pièce musicale.',
          'example' => 'Marcus Thorne Bagala de « This American Life »',
        ],
        'theme_music' => [
          'label' => 'Musique de Générique',
          'description' => 'Theme Music est une pièce musicale qui accompagne le podcast à travers plusieurs épisodes, le plus souvent au début d\'un épisode. Le thème Musique est utilisé pour présenter le podcast en tant que marque. Ce rôle est pour le créateur de la musique du thème.',
          'example' => 'Mark Philips de « Startup Podcast »',
        ],
        'music_production' => [
          'label' => 'Production Musicale',
          'description' => 'Le rôle de production musicale aide à créer de manière créative de la musique dans un rôle distinct de l\'écriture de ladite musique. La production musicale implique souvent des décisions créatives en fonction de la méthode d\'enregistrement de la musique, de l\'arrangement des instruments, de l\'utilisation d\'effets, etc.',
          'example' => 'Storm Duper pour « Faking Star Wars Radio »',
        ],
        'music_contributor' => [
          'label' => 'Contribution Musicale',
          'description' => 'The Music Contributor est le créateur de la musique qui a été utilisée pour le podcast mais pas nécessairement produite spécifiquement pour le podcast. Souvent, un podcast utilisera une pièce musicale existante et créditera le créateur original.',
          'example' => 'Bobby Lord de « Startup Podcast »',
        ],
      ],
    ],
    'administration' => [
      'label' => 'Gestion',
      'roles' => [
        'production_coordinator' => [
          'label' => 'Coordinat·eur·rice de Production',
          'description' => 'Le coordonnateur de la production est responsable de la gestion de la logistique du processus de production de l\'enregistrement à la publication, y compris l\'obtention des autorisations et des permis requis, la connexion des différentes équipes de production et d\'enregistrement, la coordination de la création des métadonnées de post-production, la budgétisation, etc.',
          'example' => 'Taneya Boyde sur « Prêt pour le changement ? »',
        ],
        'booking_coordinator' => [
          'label' => 'Programmat·eur·rice',
          'description' => 'Le coordonnateur des réservations est chargé de faire venir de nouveaux invités pour les entrevues, y compris la recherche des invités, la planification des entrevues, le matériel d\'accueil et les processus post-publication.',
          'example' => 'Meryl Klemow pour « Campfire Sht Show »',
        ],
        'production_assistant' => [
          'label' => 'Assistant·e de Production',
          'description' => 'L\'assistant de production aide à soutenir un membre de la direction d\'un podcast (souvent un réalisateur ou un producteur), en aidant à les préparer de diverses manières, y compris la planification, la logistique, les communications, etc.',
          'example' => 'Wallace Mack pour « The Nod »',
        ],
        'content_manager' => [
          'label' => 'Responsable des Contenus',
          'description' => 'Le gestionnaire de contenu est responsable de la distribution du contenu d\'un podcast à l\'intérieur et à l\'extérieur de l\'épisode, y compris, mais sans s\'y limiter, les clips, les newsletters, les images, les promotions croisées, etc.',
          'example' => 'Kenneth Lee Johnson II pour « Malice Corp Smack Talk »',
        ],
        'marketing_manager' => [
          'label' => 'Responsable Marketing',
          'description' => 'Le directeur du marketing est responsable de la promotion du contenu d\'un podcast par le biais de diverses stratégies de sensibilisation telles que des campagnes sur les médias sociaux, le développement d\'une présence sur le Web, la gestion des relations publiques et des stratégies de communication et d\'autres techniques créatives pour acquérir et fidéliser les auditeurs.',
          'example' => '',
        ],
        'sales_representative' => [
          'label' => 'Commercial·e',
          'description' => 'Le représentant des ventes est responsable de la monétisation du contenu des balados en gérant et en vendant l\'inventaire publicitaire.',
          'example' => '',
        ],
        'sales_manager' => [
          'label' => 'Direct·eur·rice Commercial·e',
          'description' => 'Le directeur des ventes est responsable de tous les aspects de la monétisation des podcasts, tels que la supervision des représentants des ventes, la gestion de l\'inventaire publicitaire et la conception de stratégies de monétisation via des canaux tels que les partenariats d\'affiliation, la marchandise, les événements en direct et d\'autres stratégies de revenus.',
          'example' => '',
        ],
      ],
    ],
    'visuals' => [
      'label' => 'Illustrations',
      'roles' => [
        'graphic_designer' => [
          'label' => 'Infographiste',
          'description' => 'Le graphiste est quelqu\'un qui a créé des visuels personnalisés pour accompagner le podcast de différentes manières.',
          'example' => 'Sky Knight pour « The XP Billionaires »',
        ],
        'cover_art_designer' => [
          'label' => 'Concept·eur·rice de la Couverture',
          'description' => 'Le Cover Art Designer crée la pochette affichée d\'un podcast ou d\'un épisode. Pour plus de clarté, la pochette est l\'image principale (presque toujours carrée) accompagnant le podcast dans les répertoires, tandis que la pochette d\'épisode est affichée de la même manière au niveau de l\'épisode. Ce rôle peut être un concepteur numérique, un artiste, un photographe ou tout autre créatif visuel.',
          'example' => '',
        ],
      ],
    ],
    'community' => [
      'label' => 'Communauté',
      'roles' => [
        'social_media_manager' => [
          'label' => 'Responsable Réseaux Sociaux',
          'description' => 'Le gestionnaire de médias sociaux gère les comptes de médias sociaux du podcast, y compris, mais sans s\'y limiter, la création de contenu, la publication, les réponses, la surveillance, etc.',
          'example' => 'Tom Joshi-Cale pour « World on a String »',
        ],
      ],
    ],
    'misc' => [
      'label' => 'Divers',
      'roles' => [
        'consultant' => [
          'label' => 'Consultant',
          'description' => 'Un consultant est un poste de tiers où une personne extérieure à l\'organisation travaille sur un projet, offrant souvent une expertise spécifique. Il s\'agit d\'un rôle de modificateur et peut être appliqué à n\'importe quelle zone de travail.',
          'example' => 'Ross Wilcock pour «Being Kenzie-Feature Long Immersive Horror»',
        ],
        'intern' => [
          'label' => 'Stagiaire',
          'description' => 'Un stagiaire est un poste d\'apprenti où quelqu\'un travaille pendant un temps limité au sein d\'une organisation pour acquérir une expérience de travail dans un domaine spécifique. Il s\'agit d\'un rôle de modificateur et peut être appliqué à n\'importe quelle zone de travail.',
          'example' => '',
        ],
      ],
    ],
    'video_production' => [
      'label' => 'Production Vidéo',
      'roles' => [
        'camera_operator' => [
          'label' => 'Cadr·eur·euse',
          'description' => 'Un caméraman est chargé de capturer et d\'enregistrer tous les aspects d\'une scène pour le cinéma et la télévision. Ils doivent comprendre les aspects techniques du fonctionnement d\'une caméra, cadrer une photo appropriée en ce qui concerne l\'éclairage et la mise en scène, mettre au point l\'objectif et avoir un œil visuel pour obtenir un look spécifique.',
          'example' => '',
        ],
        'lighting_designer' => [
          'label' => 'Concept·eur·rice Lumières',
          'description' => 'Un concepteur d\'éclairage travaille avec le DP et le directeur pour créer un aspect et une sensation spécifiques d\'une scène en utilisant diverses techniques d\'éclairage. Ils doivent être capables d\'interpréter la direction créative et de lui donner vie.',
          'example' => '',
        ],
        'camera_grip' => [
          'label' => 'Machiniste',
          'description' => 'Une poignée d\'appareil photo est responsable de la construction et de l\'entretien de toutes les pièces d\'un appareil photo et de ses accessoires tels que les trépieds, les grues, les chariots, etc.',
          'example' => '',
        ],
        'assistant_camera' => [
          'label' => 'Cadr·eur·euse Assistant·e',
          'description' => '1st AC est responsable de l\'équipement de la caméra, de la construction des caméras avant le début de chaque journée, de l\'organisation de toutes les pièces et des divers accessoires, du remplacement des objectifs si nécessaire et également de la mise au point pour les opérateurs DP et caméra. Le CA terminera également chaque journée en nettoyant les appareils photo, en écrivant des notes sur l\'appareil photo, en marquant les cartes multimédias et en les remettant au DIT.',
          'example' => '',
        ],
      ],
    ],
    'video_post_production' => [
      'label' => 'Post-Production Vidéo',
      'roles' => [
        'editor' => [
          'label' => 'Rédact·eur·rice en Chef·fe',
          'description' => 'Les éditeurs de télévision sont chargés de prendre les séquences et les clips et de les mélanger pour créer la vision et la narration du réalisateur.',
          'example' => '',
        ],
        'assistant_editor' => [
          'label' => 'Rédact·eur·rice en Chef·fe Adjoint·e',
          'description' => 'L\'assistant de montage est chargé de prendre les médias de l\'ensemble, de les intégrer dans le logiciel de montage désigné et d\'organiser les images de manière efficace pour l\'éditeur. Ils doivent également faire très attention pour s\'assurer que l\'audio et la vidéo sont synchronisés et que toutes les séquences du plateau sont correctement ingérées.',
          'example' => '',
        ],
      ],
    ],
  ],
];
