<?php

declare(strict_types=1);

/**
 * @copyright  2020 Ad Aures
 * @license    https://www.gnu.org/licenses/agpl-3.0.en.html AGPL3
 * @link       https://castopod.org/
 */

return [
    'all_podcasts' => 'Todos los podcasts',
    'no_podcast' => 'No se encontró el podcast!',
    'create' => 'Crear podcasts',
    'import' => 'Importar un podcast',
    'all_imports' => 'Podcast imports',
    'new_episode' => 'Nuevo episodio',
    'view' => 'Ver Podcast',
    'edit' => 'Editar el Podcast',
    'publish' => 'Publicar podcast',
    'publish_edit' => 'Editar la publicación',
    'delete' => 'Eliminar podcast',
    'see_episodes' => 'Ver episodios',
    'see_contributors' => 'Ver colaboradores',
    'monetization_other' => 'Other monetization',
    'go_to_page' => 'Ir a la página',
    'latest_episodes' => 'Últimos Episodios',
    'see_all_episodes' => 'Mostrar todos los episodios',
    'draft' => 'Borrador',
    'messages' => [
        'createSuccess' => '¡El Podcast ha sido creado con éxito!',
        'editSuccess' => 'El Podcast se ha actualizado correctamente!',
        'importSuccess' => 'El Podcast se ha importado correctamente!',
        'deleteSuccess' => '¡El Podcast @{podcast_handle} ha sido eliminado con éxito!',
        'deletePodcastMediaError' => 'No se ha podido eliminar {type, select,
            cover {la portada}
            banner {el cartel}
            other {el material}
        } del podcast.',
        'deleteEpisodeMediaError' => 'No se ha podido elminar {type, select,
            transcript {la transcripción}
            chapters {los episodios}
            image {la portada}
            audio {el audio}
            other {el material}
        } del episodio {episode_slug}.',
        'deletePodcastMediaFolderError' => 'No se pudo eliminar la carpeta del material del podcast {folder_path}. Puedes eliminarla manualmente del disco.',
        'podcastFeedUpdateSuccess' => '¡Actualización exitosa: {number_of_new_episodes, plural,
            one {se ha añadido un episodio}
            other {se han añadido # episodios}
        } al podcast!',
        'podcastFeedUpToDate' => 'El Podcast ya está actualizado.',
        'publishError' => 'Este podcast ya ha sido publicado o está programado para su publicación.',
        'publishEditError' => 'Este podcast no está programado para ser publicado.',
        'publishCancelSuccess' => '¡La publicación del podcast ha sido cancelada con éxito!',
        'scheduleDateError' => '¡Se debe definir una fecha de publicación!',
    ],
    'form' => [
        'identity_section_title' => 'Identidad de Podcast',
        'identity_section_subtitle' => 'Estos campos le permiten recibir un aviso.',
        'fediverse_section_title' => 'Fediverse identity',

        'cover' => 'Portada de Podcast',
        'cover_size_hint' => 'La portada debe ser cuadrada y con al menos 1400 px de ancho y alto.',
        'banner' => 'Cartel del Podcast',
        'banner_size_hint' => 'El cartel debe tener una relación de 3:1 con al menos 1500 px de ancho.',
        'banner_delete' => 'Borrar el cartel del podcast',
        'title' => 'Título',
        'handle' => 'Alias',
        'handle_hint' =>
            'Se utiliza para identificar el podcast. Se aceptan mayúsculas, minúsculas, números y guiones bajos.',
        'type' => [
            'label' => 'Tipo',
            'episodic' => 'Por episodios',
            'episodic_hint' => 'Si los episodios están destinados a ser consumidos sin ningún orden específico. Los episodios más nuevos serán presentados primero.',
            'serial' => 'Serial',
            'serial_hint' => 'If episodes are intended to be consumed in sequential order. Episodes will be presented in numeric order.',
        ],
        'medium' => [
            'label' => 'Medium',
            'hint' => 'Medium as represented by podcast:medium tag in RSS. Changing this may change how players present your feed.',
            'podcast' => 'Podcast',
            'podcast_hint' => 'Describes a feed for a podcast show.',
            'music' => 'Music',
            'music_hint' => 'A feed of music organized into an "album" with each item a song within the album.',
            'audiobook' => 'Audiobook',
            'audiobook_hint' => 'Specific types of audio with one item per feed, or where items represent chapters within the book.',
        ],
        'description' => 'Descripción',
        'classification_section_title' => 'Clasificación',
        'classification_section_subtitle' =>
            'Estos campos impactarán a su audiencia y competencia.',
        'language' => 'Idioma',
        'category' => 'Categoría',
        'category_placeholder' => 'Selecciona una categoría…',
        'other_categories' => 'Otras categorías',
        'parental_advisory' => [
            'label' => 'Aviso parental',
            'hint' => '¿Contiene contenido explícito?',
            'undefined' => 'indefinido',
            'clean' => 'Limpio',
            'explicit' => 'Explícito',
        ],
        'author_section_title' => 'Autor',
        'author_section_subtitle' => '¿Quién está gestionando el podcast?',
        'owner_name' => 'Nombre del propietario',
        'owner_name_hint' =>
            'Para uso administrativo solamente. Visible en la fuente pública RSS.',
        'owner_email' => 'Email del propietario',
        'owner_email_hint' =>
            'Será utilizado por la mayoría de las plataformas para verificar la propiedad del podcast. Visible en el feed RSS público.',
        'is_owner_email_removed_from_feed' => 'Remove the owner email from the public RSS feed',
        'is_owner_email_removed_from_feed_hint' => 'You may need to temporarily unhide the email so that a directory can verify your podcast ownership.',
        'publisher' => 'Publicador',
        'publisher_hint' =>
            'El grupo responsable de la creación del espectáculo. A menudo se refiere a la empresa matriz o red de un podcast. Este campo a veces se etiqueta como \'Autor\'.',
        'copyright' => 'Derechos de autor',
        'location_section_title' => 'Ubicación',
        'location_section_subtitle' => '¿De qué lugar trata este podcast?',
        'location_name' => 'Nombre o dirección de ubicación',
        'location_name_hint' => 'Este puede ser un lugar real o ficticio',
        'monetization_section_title' => 'Monetización',
        'monetization_section_subtitle' =>
            'Gana dinero gracias a tu audiencia.',
        'premium' => 'Premium',
        'premium_by_default' => 'Los episodios deben establecerse como premium por defecto',
        'premium_by_default_hint' => 'Los episodios Podcast se marcarán como premium de forma predeterminada. Todavía puedes elegir establecer algunos episodios, trailers o bonificaciones como públicos.',
        'op3' => 'Open Podcast Prefix Project (OP3)',
        'op3_link' => 'Visit your OP3 dashboard (external link)',
        'op3_hint' => 'Analiza tus datos de estadísticas con OP3, un servicio de analíticas fiable y de código abierto. Comparte, valida y compara tus estadísticas con el ecosistema de podcasting abierto.',
        'op3_enable' => 'Activa el servicio de estadísticas OP3',
        'op3_enable_hint' => 'Por motivos de seguridad, las estadísticas de los episodios premium no serán compartidas con OP3.',
        'payment_pointer' => 'Puntero de pago para Monetización web',
        'payment_pointer_hint' =>
            'Aquí es donde usted recibirá dinero gracias a la Monetización Web',
        'advanced_section_title' => 'Parámetros Avanzados',
        'advanced_section_subtitle' =>
            'Si necesita etiquetas RSS que Castopod no maneja, póngalas aquí.',
        'custom_rss' => 'Etiquetas RSS personalizadas para el podcast',
        'custom_rss_hint' => 'Esto se inyectará dentro de la etiqueta de canal.',
        'verify_txt' => 'Ownership verification TXT',
        'verify_txt_hint' => 'Rather than relying on email, certain third-party services may confirm your podcast ownership by requesting you to embed a verification text within your feed.',
        'verify_txt_helper' => 'This text is injected into a <podcast:txt purpose="verify"> tag.',
        'new_feed_url' => 'Nueva URL de feed',
        'new_feed_url_hint' => 'Utilice este campo cuando se mueva a otro dominio o plataforma de alojamiento podcast. De forma predeterminada, el valor se establece en la URL actual de RSS si el podcast es importado.',
        'old_feed_url' => 'Antigua URL del feed RSS',
        'partnership' => 'Asociación',
        'partner_id' => 'ID',
        'partner_link_url' => 'URL del enlace',
        'partner_image_url' => 'URL de la imágen',
        'partner_id_hint' => 'Su propio ID de socio',
        'partner_link_url_hint' => 'La dirección genérica de enlace de socio',
        'partner_image_url_hint' => 'La dirección de imagen genérica del socio',
        'block' => 'El podcast debe ocultarse a los catálogos públicos',
        'block_hint' =>
            'El estado de visibilidad del podcast: al activar esto se impide que este podcast al completo aparezca en Apple Podcasts, Google Podcasts y cualquier aplicación de terceros que extraiga episodios de estos directorios. (no está garantizado al 100%)',
        'complete' => 'El Podcast no tendrá nuevos episodios',
        'lock' => 'Evitar que el podcast sea copiado',
        'lock_hint' =>
            'El propósito es decirle a otras plataformas de podcast si se les permite importar este feed. Un valor de sí significa que cualquier intento de importar este feed en una nueva plataforma debe ser rechazado.',
        'submit_create' => 'Crear podcasts',
        'submit_edit' => 'Guardar podcast',
    ],
    'category_options' => [
        'uncategorized' => 'sin categoría',
        'arts' => 'Artes',
        'business' => 'Negocios',
        'comedy' => 'Comedia',
        'education' => 'Educación',
        'fiction' => 'Ficción',
        'government' => 'Gubernamental',
        'health_and_fitness' => 'Salud &amp Bienestar',
        'history' => 'Historia',
        'kids_and_family' => 'Niños y Familia',
        'leisure' => 'Ocio',
        'music' => 'Música',
        'news' => 'Noticias',
        'religion_and_spirituality' => 'Religión y espiritualidad',
        'science' => 'Ciencias',
        'society_and_culture' => 'Sociedad y cultura',
        'sports' => 'Deportes',
        'technology' => 'Tecnología',
        'true_crime' => 'Crimen verdadero',
        'tv_and_film' => 'TV &amp Cine',
        'books' => 'Libros',
        'design' => 'Diseño',
        'fashion_and_beauty' => 'Moda &amp Belleza',
        'food' => 'Alimentos',
        'performing_arts' => 'Artes Escénicas',
        'visual_arts' => 'Artes visuales',
        'careers' => 'Empleos',
        'entrepreneurship' => 'Emprendimiento',
        'investing' => 'Inversiones',
        'management' => 'Administración',
        'marketing' => 'Marketing',
        'non_profit' => 'Sin fines de lucro',
        'comedy_interviews' => 'Entrevistas de comedia',
        'improv' => 'Improvisación',
        'stand_up' => 'Stand-Up',
        'courses' => 'Cursos',
        'how_to' => 'Como hacer',
        'language_learning' => 'Aprendizaje de idiomas',
        'self_improvement' => 'Crecimiento personal',
        'comedy_fiction' => 'Comedia de Ficción',
        'drama' => 'Drama',
        'science_fiction' => 'Ciencia Ficción',
        'alternative_health' => 'Salud alternativa',
        'fitness' => 'Fitness',
        'medicine' => 'Medicina',
        'mental_health' => 'Salud mental',
        'nutrition' => 'Nutrición',
        'sexuality' => 'Sexualidad',
        'education_for_kids' => 'Educación para Niños',
        'parenting' => 'Paternidad',
        'pets_and_animals' => 'Mascotas y animales',
        'stories_for_kids' => 'Historias para niños',
        'animation_and_manga' => 'Animación y Manga',
        'automotive' => 'Automotor',
        'aviation' => 'Aviación',
        'crafts' => 'Creaciones',
        'games' => 'Juegos',
        'hobbies' => 'Pasatiempos',
        'home_and_garden' => 'Hogar y jardín',
        'video_games' => 'Video Juegos',
        'music_commentary' => 'Comentario de música',
        'music_history' => 'Historia de Música',
        'music_interviews' => 'Entrevistas de Música',
        'business_news' => 'Noticias de negocios',
        'daily_news' => 'Noticias diarias',
        'entertainment_news' => 'Noticias de Entretenimiento',
        'news_commentary' => 'Comentario de Noticias',
        'politics' => 'Política',
        'sports_news' => 'Noticias deportivas',
        'tech_news' => 'Noticias de Tecnología',
        'buddhism' => 'Budismo',
        'christianity' => 'Cristianismo',
        'hinduism' => 'Hinduismo',
        'islam' => 'Islam',
        'judaism' => 'Judaismo',
        'religion' => 'Religión',
        'spirituality' => 'Espiritualidad',
        'astronomy' => 'Astronomía',
        'chemistry' => 'Química',
        'earth_sciences' => 'Ciencias de la Tierra',
        'life_sciences' => 'Ciencias Biológicas',
        'mathematics' => 'Matemáticas',
        'natural_sciences' => 'Ciencias Naturales',
        'nature' => 'Naturaleza',
        'physics' => 'Física',
        'social_sciences' => 'Ciencias Sociales',
        'documentary' => 'Documentales',
        'personal_journals' => 'Diario personal',
        'philosophy' => 'Filosofía',
        'places_and_travel' => 'Lugares &amp Viajes',
        'relationships' => 'Relaciones',
        'baseball' => 'Beisbol',
        'basketball' => 'Baloncesto',
        'cricket' => 'Críquet',
        'fantasy_sports' => 'Deportes Fantásticos',
        'football' => 'Fútbol',
        'golf' => 'Golf',
        'hockey' => 'Hockey',
        'rugby' => 'Rugby',
        'running' => 'Correr',
        'soccer' => 'Fútbol',
        'swimming' => 'Natación',
        'tennis' => 'Tenis',
        'volleyball' => 'Voleibol',
        'wilderness' => 'Desierto',
        'wrestling' => 'Lucha Libre',
        'after_shows' => 'Después de los espectáculos',
        'film_history' => 'Historia del cine',
        'film_interviews' => 'Entrevistas de cine',
        'film_reviews' => 'Reseñas de cine',
        'tv_reviews' => 'Reseñas de TV',
    ],
    'publish_form' => [
        'back_to_podcast_dashboard' => 'Regresar al panel de control del podcast',
        'post' => 'Tu publicación de anuncio',
        'post_hint' =>
            "Escribe un mensaje para anunciar la publicación de tu podcast. El mensaje aparecerá destacado en la página principal del podcast.",
        'message_placeholder' => 'Redacta tu mensaje…',
        'submit' => 'Publicar',
        'publication_date' => 'Fecha de publicación',
        'publication_method' => [
            'now' => 'Ahora',
            'schedule' => 'Programación',
        ],
        'scheduled_publication_date' => 'Fecha de publicación programada',
        'scheduled_publication_date_hint' =>
            'Puede programar el lanzamiento del podcast definiendo una fecha de publicación futura. Este campo debe ser formateado así YYYY-MM-DD HH:mm',
        'submit_edit' => 'Editar publicación',
        'cancel_publication' => 'Cancelar publicación',
        'message_warning' => '¡No has escrito un mensaje para el anuncio tu publicación!',
        'message_warning_hint' => 'Incluir un mensaje aumenta el interés en las redes sociales, resultando en una mayor visibilidad de tu podcast.',
        'message_warning_submit' => 'Publicar de todos modos',
    ],
    'publication_status_banner' => [
        'draft_mode' => 'modo borrador',
        'not_published' => 'Este podcast aún no ha sido publicado.',
        'scheduled' => 'Este podcast está programado para su publicación el {publication_date}.',
    ],
    'delete_form' => [
        'disclaimer' =>
            "Al eliminar el podcast, se eliminarán todos los episodios, archivos multimedia, mensajes y estadísticas asociados a él. Esta acción es irreversible, no podrá recuperarlos después de la eliminación.",
        'understand' => 'Entiendo, quiero que el podcast sea eliminado permanentemente',
        'submit' => 'Eliminar',
    ],
    'by' => 'Por {publisher}',
    'season' => 'Temporada {seasonNumber}',
    'list_of_episodes_year' => '{year} episodios ({episodeCount})',
    'list_of_episodes_season' =>
        'Temporada {seasonNumber} episodios ({episodeCount})',
    'no_episode' => '¡No se encontró el episodio!',
    'follow' => 'Seguir',
    'followers' => '{numberOfFollowers, plural,
        one {Un seguidor}
        other {# seguidores}
    }',
    'posts' => '{numberOfPosts, plural,
        one {Una publicación}
        other {# publicaciones}
    }',
    'activity' => 'Actividad',
    'episodes' => 'Episodios',
    'sponsor' => 'Patrocinador',
    'funding_links' => 'Enlaces de financiación para {podcastTitle}',
    'find_on' => 'Buscar {podcastTitle} en',
    'listen_on' => 'Escuchar en',
];
