
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `castopod1138`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `duration` decimal(15,3) unsigned NOT NULL,
  `bandwidth` bigint(20) unsigned NOT NULL,
  `unique_listeners` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_country`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_country` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `country_code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ISO 3166-1 code.',
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`country_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_episode`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_episode` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `episode_id` int(10) unsigned NOT NULL,
  `age` int(10) unsigned NOT NULL COMMENT 'Days since episode publication date',
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`episode_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_hour`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_hour` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `hour` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`hour`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_player`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_player` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `service` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `app` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `device` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `os` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_bot` tinyint(1) NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`service`,`app`,`device`,`os`,`is_bot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_region`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_region` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `country_code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ISO 3166-1 code.',
  `region_code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ISO 3166-2 code.',
  `latitude` decimal(8,6) DEFAULT NULL,
  `longitude` decimal(9,6) DEFAULT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`country_code`,`region_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_podcasts_by_subscription`
--

CREATE TABLE `[[dbprefix]]analytics_podcasts_by_subscription` (
  `podcast_id` int(10) unsigned NOT NULL,
  `episode_id` int(10) unsigned NOT NULL,
  `subscription_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`episode_id`,`subscription_id`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_unknown_useragents`
--

CREATE TABLE `[[dbprefix]]analytics_unknown_useragents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `useragent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `useragent` (`useragent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_website_by_browser`
--

CREATE TABLE `[[dbprefix]]analytics_website_by_browser` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `browser` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`browser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_website_by_entry_page`
--

CREATE TABLE `[[dbprefix]]analytics_website_by_entry_page` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `entry_page_url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`entry_page_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_website_by_referer`
--

CREATE TABLE `[[dbprefix]]analytics_website_by_referer` (
  `podcast_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `referer_url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(384) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`podcast_id`,`date`,`referer_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_groups_users`
--

CREATE TABLE `[[dbprefix]]auth_groups_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]auth_groups_users_user_id_foreign` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]auth_groups_users`
--

INSERT INTO `[[dbprefix]]auth_groups_users` VALUES
(1, 1, 'superadmin', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_identities`
--

CREATE TABLE `[[dbprefix]]auth_identities` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `secret` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret2` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires` datetime DEFAULT NULL,
  `extra` text COLLATE utf8mb4_unicode_ci,
  `force_reset` tinyint(1) NOT NULL DEFAULT '0',
  `last_used_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_secret` (`type`,`secret`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]auth_identities`
--

INSERT INTO `[[dbprefix]]auth_identities` VALUES
(1, 1, 'email_password', NULL, '[[admin_email]]', '[[admin_pass]]', NULL, NULL, 0, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_logins`
--

CREATE TABLE `[[dbprefix]]auth_logins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `date` datetime NOT NULL,
  `success` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_type_identifier` (`id_type`,`identifier`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_permissions_users`
--

CREATE TABLE `[[dbprefix]]auth_permissions_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `permission` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]auth_permissions_users_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_remember_tokens`
--

CREATE TABLE `[[dbprefix]]auth_remember_tokens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `selector` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hashedValidator` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `expires` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `selector` (`selector`),
  KEY `[[dbprefix]]auth_remember_tokens_user_id_foreign` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]auth_token_logins`
--

CREATE TABLE `[[dbprefix]]auth_token_logins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `identifier` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `date` datetime NOT NULL,
  `success` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_type_identifier` (`id_type`,`identifier`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apple_category` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_category` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `[[dbprefix]]categories_parent_id_foreign` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, NULL, 'arts', 'Arts', 'Arts'),
(2, NULL, 'business', 'Business', 'Business'),
(3, NULL, 'comedy', 'Comedy', 'Comedy'),
(4, NULL, 'education', 'Education', 'Education'),
(5, NULL, 'fiction', 'Fiction', ''),
(6, NULL, 'government', 'Government', 'Government & Organizations'),
(7, NULL, 'health_and_fitness', 'Health & Fitness', 'Health'),
(8, NULL, 'history', 'History', ''),
(9, NULL, 'kids_and_family', 'Kids & Family', 'Kids & Family'),
(10, NULL, 'leisure', 'Leisure', 'Games & Hobbies'),
(11, NULL, 'music', 'Music', 'Music'),
(12, NULL, 'news', 'News', 'News & Politics'),
(13, NULL, 'religion_and_spirituality', 'Religion & Spirituality', 'Religion & Spirituality'),
(14, NULL, 'science', 'Science', 'Science & Medicine'),
(15, NULL, 'society_and_culture', 'Society & Culture', 'Society & Culture'),
(16, NULL, 'sports', 'Sports', 'Sports & Recreation'),
(17, NULL, 'technology', 'Technology', 'Technology'),
(18, NULL, 'true_crime', 'True Crime', ''),
(19, NULL, 'tv_and_film', 'TV & Film', 'TV & Film'),
(20, 1, 'books', 'Books', ''),
(21, 1, 'design', 'Design', ''),
(22, 1, 'fashion_and_beauty', 'Fashion & Beauty', ''),
(23, 1, 'food', 'Food', ''),
(24, 1, 'performing_arts', 'Performing Arts', ''),
(25, 1, 'visual_arts', 'Visual Arts', ''),
(26, 2, 'careers', 'Careers', ''),
(27, 2, 'entrepreneurship', 'Entrepreneurship', ''),
(28, 2, 'investing', 'Investing', ''),
(29, 2, 'management', 'Management', ''),
(30, 2, 'marketing', 'Marketing', ''),
(31, 2, 'non_profit', 'Non-Profit', ''),
(32, 3, 'comedy_interviews', 'Comedy Interviews', ''),
(33, 3, 'improv', 'Improv', ''),
(34, 3, 'stand_up', 'Stand-Up', ''),
(35, 4, 'courses', 'Courses', ''),
(36, 4, 'how_to', 'How To', ''),
(37, 4, 'language_learning', 'Language Learning', ''),
(38, 4, 'self_improvement', 'Self-Improvement', ''),
(39, 5, 'comedy_fiction', 'Comedy Fiction', ''),
(40, 5, 'drama', 'Drama', ''),
(41, 5, 'science_fiction', 'Science Fiction', ''),
(42, 7, 'alternative_health', 'Alternative Health', ''),
(43, 7, 'fitness', 'Fitness', ''),
(44, 7, 'medicine', 'Medicine', ''),
(45, 7, 'mental_health', 'Mental Health', ''),
(46, 7, 'nutrition', 'Nutrition', ''),
(47, 7, 'sexuality', 'Sexuality', ''),
(48, 9, 'education_for_kids', 'Education for Kids', ''),
(49, 9, 'parenting', 'Parenting', ''),
(50, 9, 'pets_and_animals', 'Pets & Animals', ''),
(51, 9, 'stories_for_kids', 'Stories for Kids', ''),
(52, 10, 'animation_and_manga', 'Animation & Manga', ''),
(53, 10, 'automotive', 'Automotive', ''),
(54, 10, 'aviation', 'Aviation', ''),
(55, 10, 'crafts', 'Crafts', ''),
(56, 10, 'games', 'Games', ''),
(57, 10, 'hobbies', 'Hobbies', ''),
(58, 10, 'home_and_garden', 'Home & Garden', ''),
(59, 10, 'video_games', 'Video Games', ''),
(60, 11, 'music_commentary', 'Music Commentary', ''),
(61, 11, 'music_history', 'Music History', ''),
(62, 11, 'music_interviews', 'Music Interviews', ''),
(63, 12, 'business_news', 'Business News', ''),
(64, 12, 'daily_news', 'Daily News', ''),
(65, 12, 'entertainment_news', 'Entertainment News', ''),
(66, 12, 'news_commentary', 'News Commentary', ''),
(67, 12, 'politics', 'Politics', ''),
(68, 12, 'sports_news', 'Sports News', ''),
(69, 12, 'tech_news', 'Tech News', ''),
(70, 13, 'buddhism', 'Buddhism', ''),
(71, 13, 'christianity', 'Christianity', ''),
(72, 13, 'hinduism', 'Hinduism', ''),
(73, 13, 'islam', 'Islam', ''),
(74, 13, 'judaism', 'Judaism', ''),
(75, 13, 'religion', 'Religion', ''),
(76, 13, 'spirituality', 'Spirituality', ''),
(77, 14, 'astronomy', 'Astronomy', ''),
(78, 14, 'chemistry', 'Chemistry', ''),
(79, 14, 'earth_sciences', 'Earth Sciences', ''),
(80, 14, 'life_sciences', 'Life Sciences', ''),
(81, 14, 'mathematics', 'Mathematics', ''),
(82, 14, 'natural_sciences', 'Natural Sciences', ''),
(83, 14, 'nature', 'Nature', ''),
(84, 14, 'physics', 'Physics', ''),
(85, 14, 'social_sciences', 'Social Sciences', ''),
(86, 15, 'documentary', 'Documentary', ''),
(87, 15, 'personal_journals', 'Personal Journals', ''),
(88, 15, 'philosophy', 'Philosophy', ''),
(89, 15, 'places_and_travel', 'Places & Travel', ''),
(90, 15, 'relationships', 'Relationships', ''),
(91, 16, 'baseball', 'Baseball', ''),
(92, 16, 'basketball', 'Basketball', ''),
(93, 16, 'cricket', 'Cricket', ''),
(94, 16, 'fantasy_sports', 'Fantasy Sports', ''),
(95, 16, 'football', 'Football', ''),
(96, 16, 'golf', 'Golf', ''),
(97, 16, 'hockey', 'Hockey', ''),
(98, 16, 'rugby', 'Rugby', ''),
(99, 16, 'running', 'Running', ''),
(100, 16, 'soccer', 'Soccer', ''),
(101, 16, 'swimming', 'Swimming', ''),
(102, 16, 'tennis', 'Tennis', ''),
(103, 16, 'volleyball', 'Volleyball', ''),
(104, 16, 'wilderness', 'Wilderness', ''),
(105, 16, 'wrestling', 'Wrestling', ''),
(106, 19, 'after_shows', 'After Shows', ''),
(107, 19, 'film_history', 'Film History', ''),
(108, 19, 'film_interviews', 'Film Interviews', ''),
(109, 19, 'film_reviews', 'Film Reviews', ''),
(110, 19, 'tv_reviews', 'TV Reviews', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]clips`
--

CREATE TABLE `[[dbprefix]]clips` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `episode_id` int(10) unsigned NOT NULL,
  `start_time` decimal(8,3) unsigned NOT NULL,
  `duration` decimal(7,3) unsigned NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('audio','video') COLLATE utf8mb4_unicode_ci NOT NULL,
  `media_id` int(10) unsigned DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `status` enum('queued','pending','running','passed','failed') COLLATE utf8mb4_unicode_ci NOT NULL,
  `logs` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned NOT NULL,
  `job_started_at` datetime DEFAULT NULL,
  `job_ended_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]clips_podcast_id_foreign` (`podcast_id`),
  KEY `[[dbprefix]]clips_episode_id_foreign` (`episode_id`),
  KEY `[[dbprefix]]clips_media_id_foreign` (`media_id`),
  KEY `[[dbprefix]]clips_created_by_foreign` (`created_by`),
  KEY `[[dbprefix]]clips_updated_by_foreign` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Stand-in structure for view `[[dbprefix]]credits`
--
CREATE TABLE `[[dbprefix]]credits` (
`person_group` varchar(32)
,`person_id` int(11) unsigned
,`full_name` varchar(192)
,`person_role` varchar(32)
,`podcast_id` int(11) unsigned
,`episode_id` int(11)
);
-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]episodes`
--

CREATE TABLE `[[dbprefix]]episodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `preview_id` binary(16) DEFAULT NULL,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `audio_id` int(10) unsigned NOT NULL,
  `description_markdown` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover_id` int(10) unsigned DEFAULT NULL,
  `transcript_id` int(10) unsigned DEFAULT NULL,
  `transcript_remote_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chapters_id` int(10) unsigned DEFAULT NULL,
  `chapters_remote_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parental_advisory` enum('clean','explicit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `number` int(10) unsigned DEFAULT NULL,
  `season_number` int(10) unsigned DEFAULT NULL,
  `type` enum('trailer','full','bonus') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `is_blocked` tinyint(1) NOT NULL DEFAULT '0',
  `location_name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_geo` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_osm` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_rss` json DEFAULT NULL,
  `is_published_on_hubs` tinyint(1) NOT NULL DEFAULT '0',
  `downloads_count` int(10) unsigned DEFAULT '0',
  `posts_count` int(10) unsigned NOT NULL DEFAULT '0',
  `comments_count` int(10) unsigned NOT NULL DEFAULT '0',
  `is_premium` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned NOT NULL,
  `published_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `podcast_id_slug` (`podcast_id`,`slug`),
  UNIQUE KEY `preview_id` (`preview_id`),
  KEY `[[dbprefix]]episodes_audio_id_foreign` (`audio_id`),
  KEY `[[dbprefix]]episodes_cover_id_foreign` (`cover_id`),
  KEY `[[dbprefix]]episodes_transcript_id_foreign` (`transcript_id`),
  KEY `[[dbprefix]]episodes_chapters_id_foreign` (`chapters_id`),
  KEY `[[dbprefix]]episodes_created_by_foreign` (`created_by`),
  KEY `[[dbprefix]]episodes_updated_by_foreign` (`updated_by`),
  FULLTEXT KEY `episodes_search` (`title`,`description_markdown`,`slug`,`location_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]episodes_persons`
--

CREATE TABLE `[[dbprefix]]episodes_persons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `episode_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_group` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_role` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `podcast_id_episode_id_person_id_person_group_person_role` (`podcast_id`,`episode_id`,`person_id`,`person_group`,`person_role`),
  KEY `[[dbprefix]]episodes_persons_episode_id_foreign` (`episode_id`),
  KEY `[[dbprefix]]episodes_persons_person_id_foreign` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]episode_comments`
--

CREATE TABLE `[[dbprefix]]episode_comments` (
  `id` binary(16) NOT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `episode_id` int(10) unsigned NOT NULL,
  `actor_id` int(10) unsigned NOT NULL,
  `in_reply_to_id` binary(16) DEFAULT NULL,
  `message` varchar(5000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message_html` varchar(6000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `likes_count` int(10) unsigned NOT NULL,
  `replies_count` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]episode_comments_episode_id_foreign` (`episode_id`),
  KEY `[[dbprefix]]episode_comments_actor_id_foreign` (`actor_id`),
  KEY `[[dbprefix]]episode_comments_created_by_foreign` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_activities`
--

CREATE TABLE `[[dbprefix]]fediverse_activities` (
  `id` binary(16) NOT NULL,
  `actor_id` int(10) unsigned NOT NULL,
  `target_actor_id` int(10) unsigned DEFAULT NULL,
  `post_id` binary(16) DEFAULT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` json NOT NULL,
  `status` enum('queued','delivered') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fediverse_activities_actor_id_foreign` (`actor_id`),
  KEY `[[dbprefix]]fediverse_activities_target_actor_id_foreign` (`target_actor_id`),
  KEY `[[dbprefix]]fediverse_activities_post_id_foreign` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_actors`
--

CREATE TABLE `[[dbprefix]]fediverse_actors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `private_key` text COLLATE utf8mb4_unicode_ci,
  `public_key` text COLLATE utf8mb4_unicode_ci,
  `display_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci,
  `avatar_image_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_image_mimetype` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_image_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_image_mimetype` varchar(13) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbox_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `outbox_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `followers_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `followers_count` int(10) unsigned NOT NULL DEFAULT '0',
  `posts_count` int(10) unsigned NOT NULL DEFAULT '0',
  `is_blocked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uri` (`uri`),
  UNIQUE KEY `username_domain` (`username`,`domain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_blocked_domains`
--

CREATE TABLE `[[dbprefix]]fediverse_blocked_domains` (
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_favourites`
--

CREATE TABLE `[[dbprefix]]fediverse_favourites` (
  `actor_id` int(10) unsigned NOT NULL,
  `post_id` binary(16) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`,`post_id`),
  KEY `[[dbprefix]]fediverse_favourites_post_id_foreign` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_follows`
--

CREATE TABLE `[[dbprefix]]fediverse_follows` (
  `actor_id` int(10) unsigned NOT NULL COMMENT 'Actor that is following',
  `target_actor_id` int(10) unsigned NOT NULL COMMENT 'Actor that is followed',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`,`target_actor_id`),
  KEY `[[dbprefix]]fediverse_follows_target_actor_id_foreign` (`target_actor_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_notifications`
--

CREATE TABLE `[[dbprefix]]fediverse_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `actor_id` int(10) unsigned NOT NULL,
  `target_actor_id` int(10) unsigned NOT NULL,
  `post_id` binary(16) DEFAULT NULL,
  `activity_id` binary(16) NOT NULL,
  `type` enum('like','follow','share','reply') COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]fediverse_notifications_actor_id_foreign` (`actor_id`),
  KEY `[[dbprefix]]fediverse_notifications_target_actor_id_foreign` (`target_actor_id`),
  KEY `[[dbprefix]]fediverse_notifications_post_id_foreign` (`post_id`),
  KEY `[[dbprefix]]fediverse_notifications_activity_id_foreign` (`activity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_posts`
--

CREATE TABLE `[[dbprefix]]fediverse_posts` (
  `id` binary(16) NOT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `actor_id` int(10) unsigned NOT NULL,
  `in_reply_to_id` binary(16) DEFAULT NULL,
  `reblog_of_id` binary(16) DEFAULT NULL,
  `message` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_html` varchar(600) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_private` tinyint(1) DEFAULT '0',
  `favourites_count` int(10) unsigned NOT NULL DEFAULT '0',
  `reblogs_count` int(10) unsigned NOT NULL DEFAULT '0',
  `replies_count` int(10) unsigned NOT NULL DEFAULT '0',
  `episode_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `published_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uri` (`uri`),
  KEY `[[dbprefix]]fediverse_posts_actor_id_foreign` (`actor_id`),
  KEY `[[dbprefix]]fediverse_posts_in_reply_to_id_foreign` (`in_reply_to_id`),
  KEY `[[dbprefix]]fediverse_posts_reblog_of_id_foreign` (`reblog_of_id`),
  KEY `[[dbprefix]]fediverse_posts_episode_id_foreign` (`episode_id`),
  KEY `[[dbprefix]]fediverse_posts_created_by_foreign` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_posts_preview_cards`
--

CREATE TABLE `[[dbprefix]]fediverse_posts_preview_cards` (
  `post_id` binary(16) NOT NULL,
  `preview_card_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`post_id`,`preview_card_id`),
  KEY `[[dbprefix]]fediverse_posts_preview_cards_preview_card_id_foreign` (`preview_card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]fediverse_preview_cards`
--

CREATE TABLE `[[dbprefix]]fediverse_preview_cards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('link','video','image','rich') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link',
  `author_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `code` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ISO 639-1 language code',
  `native_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
('aa', 'Afaraf'),
('ab', 'аҧсуа бызшәа, аҧсшәа'),
('ae', 'Avesta'),
('af', 'Afrikaans'),
('ak', 'Akan'),
('am', 'አማርኛ'),
('an', 'Aragonés'),
('ar', 'العربية'),
('as', 'অসমীয়া'),
('av', 'авар мацӀ, магӀарул мацӀ'),
('ay', 'Aymar aru'),
('az', 'azərbaycan dili'),
('ba', 'башҡорт теле'),
('be', 'беларуская мова'),
('bg', 'български език'),
('bh', 'भोजपुरी'),
('bi', 'Bislama'),
('bm', 'Bamanankan'),
('bn', 'বাংলা'),
('bo', 'བོད་ཡིག'),
('br', 'Brezhoneg'),
('bs', 'Bosanski jezik'),
('ca', 'Català, valencià'),
('ce', 'нохчийн мотт'),
('ch', 'Chamoru'),
('co', 'Corsu, lingua corsa'),
('cr', 'ᓀᐦᐃᔭᐍᐏᐣ'),
('cs', 'čeština, český jazyk'),
('cu', 'ѩзыкъ словѣньскъ'),
('cv', 'чӑваш чӗлхи'),
('cy', 'Cymraeg'),
('da', 'Dansk'),
('de', 'Deutsch'),
('dv', 'ދިވެހި'),
('dz', 'རྫོང་ཁ'),
('ee', 'Eʋegbe'),
('el', 'ελληνικά'),
('en', 'English'),
('eo', 'Esperanto'),
('es', 'Español'),
('et', 'eesti, eesti keel'),
('eu', 'Euskara, euskera'),
('fa', 'فارسی'),
('ff', 'Fulfulde, Pulaar, Pular'),
('fi', 'Suomi, suomen kieli'),
('fj', 'Vosa Vakaviti'),
('fo', 'Føroyskt'),
('fr', 'Français, langue française'),
('fy', 'Frysk'),
('ga', 'Gaeilge'),
('gd', 'Gàidhlig'),
('gl', 'Galego'),
('gn', 'Avañe''ẽ'),
('gu', 'ગુજરાતી'),
('gv', 'Gaelg, Gailck'),
('ha', '(Hausa) هَوُسَ'),
('he', 'עברית'),
('hi', 'हिन्दी, हिंदी'),
('ho', 'Hiri Motu'),
('hr', 'Hrvatski jezik'),
('ht', 'Kreyòl ayisyen'),
('hu', 'Magyar'),
('hy', 'Հայերեն'),
('hz', 'Otjiherero'),
('ia', 'Interlingua'),
('id', 'Bahasa Indonesia'),
('ie', 'Interlingue, formerly Occidental'),
('ig', 'Asụsụ Igbo'),
('ii', 'ꆈꌠ꒿ Nuosuhxop'),
('ik', 'Iñupiaq, Iñupiatun'),
('io', 'Ido'),
('is', 'Íslenska'),
('it', 'Italiano'),
('iu', 'ᐃᓄᒃᑎᑐᑦ'),
('ja', '日本語 (にほんご)'),
('jv', 'ꦧꦱꦗꦮ, Basa Jawa'),
('ka', 'ქართული'),
('kg', 'Kikongo'),
('ki', 'Gĩkũyũ'),
('kj', 'Kuanyama'),
('kk', 'қазақ тілі'),
('kl', 'Kalaallisut, kalaallit oqaasii'),
('km', 'ខ្មែរ, ខេមរភាសា, ភាសាខ្មែរ'),
('kn', 'ಕನ್ನಡ'),
('ko', '한국어'),
('kr', 'Kanuri'),
('ks', 'कश्मीरी, كشميري‎'),
('ku', 'Kurdî, کوردی‎'),
('kv', 'коми кыв'),
('kw', 'Kernewek'),
('ky', 'Кыргызча, Кыргыз тили'),
('la', 'Latine, lingua latina'),
('lb', 'Lëtzebuergesch'),
('lg', 'Luganda'),
('li', 'Limburgs'),
('ln', 'Lingála'),
('lo', 'ພາສາລາວ'),
('lt', 'Lietuvių kalba'),
('lu', 'Kiluba'),
('lv', 'Latviešu valoda'),
('mg', 'Fiteny malagasy'),
('mh', 'Kajin M̧ajeļ'),
('mi', 'Te reo Māori'),
('mk', 'македонски јазик'),
('ml', 'മലയാളം'),
('mn', 'Монгол хэл'),
('mr', 'मराठी'),
('ms', 'Bahasa Melayu, بهاس ملايو‎'),
('mt', 'Malti'),
('my', 'ဗမာစာ'),
('na', 'Dorerin Naoero'),
('nb', 'Norsk Bokmål'),
('nd', 'isiNdebele'),
('ne', 'नेपाली'),
('ng', 'Owambo'),
('nl', 'Nederlands, Vlaams'),
('nn', 'Norsk Nynorsk'),
('no', 'Norsk'),
('nr', 'isiNdebele'),
('nv', 'Diné bizaad'),
('ny', 'Chicheŵa, chinyanja'),
('oc', 'Occitan, lenga d’òc'),
('oj', 'ᐊᓂᔑᓈᐯᒧᐎᓐ'),
('om', 'Afaan Oromoo'),
('or', 'ଓଡ଼ିଆ'),
('os', 'ирон æвзаг'),
('pa', 'ਪੰਜਾਬੀ, پنجابی‎'),
('pi', 'पालि, पाळि'),
('pl', 'język polski, polszczyzna'),
('ps', 'پښتو'),
('pt', 'Português'),
('qu', 'Runa Simi, Kichwa'),
('rm', 'Rumantsch Grischun'),
('rn', 'Ikirundi'),
('ro', 'Română'),
('ru', 'Pусский'),
('rw', 'Ikinyarwanda'),
('sa', 'संस्कृतम्'),
('sc', 'Sardu'),
('sd', 'सिन्धी, سنڌي، سندھی‎'),
('se', 'Davvisámegiella'),
('sg', 'Yângâ tî sängö'),
('si', 'සිංහල'),
('sk', 'Slovenčina, Slovenský Jazyk'),
('sl', 'Slovenski Jezik, Slovenščina'),
('sm', 'Gagana fa''a Samoa'),
('sn', 'chiShona'),
('so', 'Soomaaliga, af Soomaali'),
('sq', 'Shqip'),
('sr', 'српски језик'),
('ss', 'SiSwati'),
('st', 'Sesotho'),
('su', 'Basa Sunda'),
('sv', 'Svenska'),
('sw', 'Kiswahili'),
('ta', 'தமிழ்'),
('te', 'తెలుగు'),
('tg', 'тоҷикӣ, toçikī, تاجیکی‎'),
('th', 'ไทย'),
('ti', 'ትግርኛ'),
('tk', 'Türkmen, Түркмен'),
('tl', 'Wikang Tagalog'),
('tn', 'Setswana'),
('to', 'Faka Tonga'),
('tr', 'Türkçe'),
('ts', 'Xitsonga'),
('tt', 'татар теле, tatar tele'),
('tw', 'Twi'),
('ty', 'Reo Tahiti'),
('ug', 'ئۇيغۇرچە‎, Uyghurche'),
('uk', 'Українська'),
('ur', 'اردو'),
('uz', 'Oʻzbek, Ўзбек, أۇزبېك‎'),
('ve', 'Tshivenḓa'),
('vi', 'Tiếng Việt'),
('vo', 'Volapük'),
('wa', 'Walon'),
('wo', 'Wollof'),
('xh', 'isiXhosa'),
('yi', 'ייִדיש'),
('yo', 'Yorùbá'),
('za', 'Saɯ cueŋƅ, Saw cuengh'),
('zh', '中文 (Zhōngwén), 汉语, 漢語'),
('zu', 'isiZulu');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]likes`
--

CREATE TABLE `[[dbprefix]]likes` (
  `actor_id` int(10) unsigned NOT NULL,
  `comment_id` binary(16) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`actor_id`,`comment_id`),
  KEY `[[dbprefix]]likes_comment_id_foreign` (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media`
--

CREATE TABLE `[[dbprefix]]media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_size` int(10) unsigned NOT NULL COMMENT 'File size in bytes',
  `file_mimetype` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_metadata` json DEFAULT NULL,
  `type` enum('image','audio','video','transcript','chapters','document') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'document',
  `description` text COLLATE utf8mb4_unicode_ci,
  `language_code` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uploaded_by` int(11) unsigned NOT NULL,
  `updated_by` int(11) unsigned NOT NULL,
  `uploaded_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_path` (`file_key`),
  KEY `[[dbprefix]]media_uploaded_by_foreign` (`uploaded_by`),
  KEY `[[dbprefix]]media_updated_by_foreign` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `namespace` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(11) NOT NULL,
  `batch` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=62 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, '2017-12-01-000000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcasts', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(2, '2017-12-01-010000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsByEpisode', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(3, '2017-12-01-020000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsByHour', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(4, '2017-12-01-030000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsByPlayer', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(5, '2017-12-01-040000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsByCountry', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(6, '2017-12-01-050000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsByRegion', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(7, '2017-12-01-060000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsWebsiteByBrowser', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(8, '2017-12-01-070000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsWebsiteByReferer', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(9, '2017-12-01-080000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsWebsiteByEntryPage', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(10, '2017-12-01-090000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsUnknownUseragents', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(11, '2017-12-01-100000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsBySubscription', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(12, '2017-12-01-210000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsPodcastsProcedure', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(13, '2017-12-01-210000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsUnknownUseragentsProcedure', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(14, '2017-12-01-210000', 'Modules\\Analytics\\Database\\Migrations\\AddAnalyticsWebsiteProcedure', 'default', 'Modules\\Analytics', [[timestamp]], 1),
(15, '2018-01-01-010000', 'Modules\\Fediverse\\Database\\Migrations\\AddActors', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(16, '2018-01-01-020000', 'Modules\\Fediverse\\Database\\Migrations\\AddPosts', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(17, '2018-01-01-100000', 'Modules\\Fediverse\\Database\\Migrations\\AddActivities', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(18, '2018-01-01-100000', 'Modules\\Fediverse\\Database\\Migrations\\AddFavourites', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(19, '2018-01-01-100000', 'Modules\\Fediverse\\Database\\Migrations\\AddFollowers', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(20, '2018-01-01-100000', 'Modules\\Fediverse\\Database\\Migrations\\AddPreviewCards', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(21, '2018-01-01-110000', 'Modules\\Fediverse\\Database\\Migrations\\AddPostsPreviewCards', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(22, '2018-01-01-120000', 'Modules\\Fediverse\\Database\\Migrations\\AddBlockedDomains', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(23, '2018-01-01-130000', 'App\\Database\\Migrations\\AddNotifications', 'default', 'Modules\\Fediverse', [[timestamp]], 1),
(24, '2020-12-28-223112', 'CodeIgniter\\Shield\\Database\\Migrations\\CreateAuthTables', 'default', 'CodeIgniter\\Shield', [[timestamp]], 1),
(25, '2020-12-29-100000', 'App\\Database\\Migrations\\AddIsOwnerToUsers', 'default', 'Modules\\Auth', [[timestamp]], 1),
(26, '2021-05-29-120000', 'Media\\Database\\Migrations\\AddMedia', 'default', 'Modules\\Media', [[timestamp]], 1),
(27, '2021-05-29-152000', 'App\\Database\\Migrations\\AddCategories', 'default', 'App', [[timestamp]], 1),
(28, '2021-05-30-101000', 'App\\Database\\Migrations\\AddLanguages', 'default', 'App', [[timestamp]], 1),
(29, '2021-05-30-101500', 'App\\Database\\Migrations\\AddPodcasts', 'default', 'App', [[timestamp]], 1),
(30, '2021-06-05-170000', 'App\\Database\\Migrations\\AddEpisodes', 'default', 'App', [[timestamp]], 1),
(31, '2021-06-05-190000', 'App\\Database\\Migrations\\AddPlatforms', 'default', 'App', [[timestamp]], 1),
(32, '2021-06-05-200000', 'App\\Database\\Migrations\\AddPodcastsPlatforms', 'default', 'App', [[timestamp]], 1),
(33, '2021-07-04-041948', 'CodeIgniter\\Settings\\Database\\Migrations\\CreateSettingsTable', 'default', 'CodeIgniter\\Settings', [[timestamp]], 1),
(34, '2021-08-12-150000', 'App\\Database\\Migrations\\AddEpisodeComments', 'default', 'App', [[timestamp]], 1),
(35, '2021-08-12-160000', 'App\\Database\\Migrations\\AddLikes', 'default', 'App', [[timestamp]], 1),
(36, '2021-08-17-150000', 'App\\Database\\Migrations\\AddPages', 'default', 'App', [[timestamp]], 1),
(37, '2021-09-29-150000', 'App\\Database\\Migrations\\AddPodcastsCategories', 'default', 'App', [[timestamp]], 1),
(38, '2021-11-14-143905', 'CodeIgniter\\Settings\\Database\\Migrations\\AddContextColumn', 'default', 'CodeIgniter\\Settings', [[timestamp]], 1),
(39, '2021-12-09-130000', 'App\\Database\\Migrations\\AddClips', 'default', 'App', [[timestamp]], 1),
(40, '2021-12-25-120000', 'App\\Database\\Migrations\\AddPersons', 'default', 'App', [[timestamp]], 1),
(41, '2021-12-25-130000', 'App\\Database\\Migrations\\AddPodcastsPersons', 'default', 'App', [[timestamp]], 1),
(42, '2021-12-25-140000', 'App\\Database\\Migrations\\AddEpisodesPersons', 'default', 'App', [[timestamp]], 1),
(43, '2021-12-25-150000', 'App\\Database\\Migrations\\AddCreditsView', 'default', 'App', [[timestamp]], 1),
(44, '2022-02-23-100000', 'App\\Database\\Migrations\\AddEpisodeIdToPosts', 'default', 'App', [[timestamp]], 1),
(45, '2022-03-07-180000', 'Modules\\WebSub\\Database\\Migrations\\AddIsPublishedOnHubsToPodcasts', 'default', 'Modules\\WebSub', [[timestamp]], 1),
(46, '2022-03-07-181500', 'Modules\\WebSub\\Database\\Migrations\\AddIsPublishedOnHubsToEpisodes', 'default', 'Modules\\WebSub', [[timestamp]], 1),
(47, '2022-03-09-113000', 'App\\Database\\Migrations\\AddCreatedByToPosts', 'default', 'App', [[timestamp]], 1),
(48, '2022-07-07-120000', 'Modules\\PremiumPodcasts\\Database\\Migrations\\AddSubscriptions', 'default', 'Modules\\PremiumPodcasts', [[timestamp]], 1),
(49, '2022-30-12-180000', 'Media\\Database\\Migrations\\RenameMediafileKey', 'default', 'Modules\\Media', [[timestamp]], 1),
(50, '2023-06-12-010000', 'App\\Database\\Migrations\\AddFullTextSearchIndexes', 'default', 'App', [[timestamp]], 1),
(51, '2023-08-22-120000', 'App\\Database\\Migrations\\AddEpisodePreviewId', 'default', 'App', [[timestamp]], 1),
(52, '2023-10-12-112040', 'CodeIgniter\\Queue\\Database\\Migrations\\AddQueueTables', 'default', 'CodeIgniter\\Queue', [[timestamp]], 1),
(53, '2023-11-05-064053', 'CodeIgniter\\Queue\\Database\\Migrations\\AddPriorityField', 'default', 'CodeIgniter\\Queue', [[timestamp]], 1),
(54, '2023-12-29-150000', 'App\\Database\\Migrations\\AddPodcastsOwnerEmailRemovedFromFeed', 'default', 'App', [[timestamp]], 1),
(55, '2024-02-05-160000', 'App\\Database\\Migrations\\AddPodcastsMediumField', 'default', 'App', [[timestamp]], 1),
(56, '2024-04-18-160000', 'App\\Database\\Migrations\\AddPodcastsVerifyTxtField', 'default', 'App', [[timestamp]], 1),
(57, '2024-04-18-180000', 'App\\Database\\Migrations\\RefactorPlatforms', 'default', 'App', [[timestamp]], 1),
(58, '2024-04-26-100000', 'App\\Database\\Migrations\\ClearImportQueue', 'default', 'App', [[timestamp]], 1),
(59, '2024-05-29-100000', 'App\\Database\\Migrations\\AddEpisodeDownloadsCount', 'default', 'App', [[timestamp]], 1),
(60, '2024-12-27-110712', 'CodeIgniter\\Queue\\Database\\Migrations\\ChangePayloadFieldTypeInSqlsrv', 'default', 'CodeIgniter\\Queue', [[timestamp]], 1),
(61, '2025-07-31-120000', 'Modules\\Fediverse\\Migrations\\AddIsPrivateToPosts', 'default', 'Modules\\Fediverse', [[timestamp]], 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_markdown` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]persons`
--

CREATE TABLE `[[dbprefix]]persons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `full_name` varchar(192) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'This is the full name or alias of the person.',
  `unique_name` varchar(192) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'This is the slug name or alias of the person.',
  `information_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The url to a relevant resource of information about the person, such as a homepage or third-party profile platform.',
  `avatar_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_name` (`unique_name`),
  KEY `[[dbprefix]]persons_avatar_id_foreign` (`avatar_id`),
  KEY `[[dbprefix]]persons_created_by_foreign` (`created_by`),
  KEY `[[dbprefix]]persons_updated_by_foreign` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]platforms`
--

CREATE TABLE `[[dbprefix]]platforms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `type` enum('podcasting','social','funding') COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_url` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_visible` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `podcast_id_type_slug` (`podcast_id`,`type`,`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]podcasts`
--

CREATE TABLE `[[dbprefix]]podcasts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `guid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `actor_id` int(10) unsigned NOT NULL,
  `handle` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description_markdown` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description_html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover_id` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned DEFAULT NULL,
  `language_code` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parental_advisory` enum('clean','explicit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `owner_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner_email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_owner_email_removed_from_feed` tinyint(1) NOT NULL DEFAULT '0',
  `publisher` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('episodic','serial') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'episodic',
  `medium` enum('podcast','music','audiobook') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'podcast',
  `copyright` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `episode_description_footer_markdown` text COLLATE utf8mb4_unicode_ci,
  `episode_description_footer_html` text COLLATE utf8mb4_unicode_ci,
  `is_blocked` tinyint(1) NOT NULL DEFAULT '0',
  `is_completed` tinyint(1) NOT NULL DEFAULT '0',
  `is_locked` tinyint(1) NOT NULL DEFAULT '1',
  `imported_feed_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The RSS feed URL if this podcast was imported, NULL otherwise.',
  `new_feed_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'The RSS new feed URL if this podcast is moving out, NULL otherwise.',
  `payment_pointer` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Wallet address for Web Monetization payments',
  `location_name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_geo` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_osm` varchar(12) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verify_txt` text COLLATE utf8mb4_unicode_ci,
  `custom_rss` json DEFAULT NULL,
  `is_published_on_hubs` tinyint(1) NOT NULL DEFAULT '0',
  `partner_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `partner_link_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `partner_image_url` varchar(512) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_premium_by_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned NOT NULL,
  `published_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `handle` (`handle`),
  UNIQUE KEY `guid` (`guid`),
  UNIQUE KEY `actor_id` (`actor_id`),
  KEY `[[dbprefix]]podcasts_cover_id_foreign` (`cover_id`),
  KEY `[[dbprefix]]podcasts_banner_id_foreign` (`banner_id`),
  KEY `[[dbprefix]]podcasts_category_id_foreign` (`category_id`),
  KEY `[[dbprefix]]podcasts_language_code_foreign` (`language_code`),
  KEY `[[dbprefix]]podcasts_created_by_foreign` (`created_by`),
  KEY `[[dbprefix]]podcasts_updated_by_foreign` (`updated_by`),
  FULLTEXT KEY `podcasts_search` (`title`,`description_markdown`,`handle`,`location_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]podcasts_categories`
--

CREATE TABLE `[[dbprefix]]podcasts_categories` (
  `podcast_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`podcast_id`,`category_id`),
  KEY `[[dbprefix]]podcasts_categories_category_id_foreign` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]podcasts_persons`
--

CREATE TABLE `[[dbprefix]]podcasts_persons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `person_group` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_role` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `podcast_id_person_id_person_group_person_role` (`podcast_id`,`person_id`,`person_group`,`person_role`),
  KEY `[[dbprefix]]podcasts_persons_person_id_foreign` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_jobs`
--

CREATE TABLE `[[dbprefix]]queue_jobs` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `attempts` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `queue_priority_status_available_at` (`queue`,`priority`,`status`,`available_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_jobs_failed`
--

CREATE TABLE `[[dbprefix]]queue_jobs_failed` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `connection` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `exception` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `queue` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'string',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscriptions`
--

CREATE TABLE `[[dbprefix]]subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `podcast_id` int(10) unsigned NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','suspended') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `status_message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `updated_by` int(10) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `podcast_id_email` (`podcast_id`,`email`),
  UNIQUE KEY `token` (`token`),
  KEY `[[dbprefix]]subscriptions_created_by_foreign` (`created_by`),
  KEY `[[dbprefix]]subscriptions_updated_by_foreign` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `last_active` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `is_owner` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', NULL, NULL, 0, NULL, '[[regtime]]', '[[regtime]]', NULL, 1);

-- --------------------------------------------------------

--
-- Structure for view `[[dbprefix]]credits`
--
DROP TABLE IF EXISTS `[[dbprefix]]credits`;

CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `[[dbprefix]]credits` AS select `[[dbprefix]]podcasts_persons`.`person_group` AS `person_group`,`[[dbprefix]]podcasts_persons`.`person_id` AS `person_id`,`[[dbprefix]]persons`.`full_name` AS `full_name`,`[[dbprefix]]podcasts_persons`.`person_role` AS `person_role`,`[[dbprefix]]podcasts_persons`.`podcast_id` AS `podcast_id`,NULL AS `episode_id` from (`[[dbprefix]]podcasts_persons` join `[[dbprefix]]persons` on((`[[dbprefix]]podcasts_persons`.`person_id` = `[[dbprefix]]persons`.`id`))) union select `[[dbprefix]]episodes_persons`.`person_group` AS `person_group`,`[[dbprefix]]episodes_persons`.`person_id` AS `person_id`,`[[dbprefix]]persons`.`full_name` AS `full_name`,`[[dbprefix]]episodes_persons`.`person_role` AS `person_role`,`[[dbprefix]]episodes_persons`.`podcast_id` AS `podcast_id`,`[[dbprefix]]episodes_persons`.`episode_id` AS `episode_id` from ((`[[dbprefix]]episodes_persons` join `[[dbprefix]]persons` on((`[[dbprefix]]episodes_persons`.`person_id` = `[[dbprefix]]persons`.`id`))) join `[[dbprefix]]episodes` on((`[[dbprefix]]episodes_persons`.`episode_id` = `[[dbprefix]]episodes`.`id`))) where (`[[dbprefix]]episodes`.`published_at` <= utc_timestamp()) order by `person_group`,`full_name`,`person_role`,`podcast_id`,`episode_id`;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]auth_groups_users`
--
ALTER TABLE `[[dbprefix]]auth_groups_users`
  ADD CONSTRAINT `[[dbprefix]]auth_groups_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]auth_identities`
--
ALTER TABLE `[[dbprefix]]auth_identities`
  ADD CONSTRAINT `[[dbprefix]]auth_identities_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]auth_permissions_users`
--
ALTER TABLE `[[dbprefix]]auth_permissions_users`
  ADD CONSTRAINT `[[dbprefix]]auth_permissions_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]auth_remember_tokens`
--
ALTER TABLE `[[dbprefix]]auth_remember_tokens`
  ADD CONSTRAINT `[[dbprefix]]auth_remember_tokens_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]categories`
--
ALTER TABLE `[[dbprefix]]categories`
  ADD CONSTRAINT `[[dbprefix]]categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `[[dbprefix]]categories` (`id`);

--
-- Constraints for table `[[dbprefix]]clips`
--
ALTER TABLE `[[dbprefix]]clips`
  ADD CONSTRAINT `[[dbprefix]]clips_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]clips_episode_id_foreign` FOREIGN KEY (`episode_id`) REFERENCES `[[dbprefix]]episodes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]clips_media_id_foreign` FOREIGN KEY (`media_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]clips_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]clips_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`);

--
-- Constraints for table `[[dbprefix]]episodes`
--
ALTER TABLE `[[dbprefix]]episodes`
  ADD CONSTRAINT `[[dbprefix]]episodes_audio_id_foreign` FOREIGN KEY (`audio_id`) REFERENCES `[[dbprefix]]media` (`id`),
  ADD CONSTRAINT `[[dbprefix]]episodes_chapters_id_foreign` FOREIGN KEY (`chapters_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]episodes_cover_id_foreign` FOREIGN KEY (`cover_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]episodes_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]episodes_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]episodes_transcript_id_foreign` FOREIGN KEY (`transcript_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]episodes_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`);

--
-- Constraints for table `[[dbprefix]]episodes_persons`
--
ALTER TABLE `[[dbprefix]]episodes_persons`
  ADD CONSTRAINT `[[dbprefix]]episodes_persons_episode_id_foreign` FOREIGN KEY (`episode_id`) REFERENCES `[[dbprefix]]episodes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]episodes_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `[[dbprefix]]persons` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]episodes_persons_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]episode_comments`
--
ALTER TABLE `[[dbprefix]]episode_comments`
  ADD CONSTRAINT `[[dbprefix]]episode_comments_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]episode_comments_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]episode_comments_episode_id_foreign` FOREIGN KEY (`episode_id`) REFERENCES `[[dbprefix]]episodes` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_activities`
--
ALTER TABLE `[[dbprefix]]fediverse_activities`
  ADD CONSTRAINT `[[dbprefix]]fediverse_activities_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_activities_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_activities_target_actor_id_foreign` FOREIGN KEY (`target_actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_favourites`
--
ALTER TABLE `[[dbprefix]]fediverse_favourites`
  ADD CONSTRAINT `[[dbprefix]]fediverse_favourites_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_favourites_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_follows`
--
ALTER TABLE `[[dbprefix]]fediverse_follows`
  ADD CONSTRAINT `[[dbprefix]]fediverse_follows_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_follows_target_actor_id_foreign` FOREIGN KEY (`target_actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_notifications`
--
ALTER TABLE `[[dbprefix]]fediverse_notifications`
  ADD CONSTRAINT `[[dbprefix]]fediverse_notifications_activity_id_foreign` FOREIGN KEY (`activity_id`) REFERENCES `[[dbprefix]]fediverse_activities` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_notifications_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_notifications_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_notifications_target_actor_id_foreign` FOREIGN KEY (`target_actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_posts`
--
ALTER TABLE `[[dbprefix]]fediverse_posts`
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_episode_id_foreign` FOREIGN KEY (`episode_id`) REFERENCES `[[dbprefix]]episodes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_in_reply_to_id_foreign` FOREIGN KEY (`in_reply_to_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_reblog_of_id_foreign` FOREIGN KEY (`reblog_of_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]fediverse_posts_preview_cards`
--
ALTER TABLE `[[dbprefix]]fediverse_posts_preview_cards`
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_preview_cards_post_id_foreign` FOREIGN KEY (`post_id`) REFERENCES `[[dbprefix]]fediverse_posts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]fediverse_posts_preview_cards_preview_card_id_foreign` FOREIGN KEY (`preview_card_id`) REFERENCES `[[dbprefix]]fediverse_preview_cards` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]likes`
--
ALTER TABLE `[[dbprefix]]likes`
  ADD CONSTRAINT `[[dbprefix]]likes_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]likes_comment_id_foreign` FOREIGN KEY (`comment_id`) REFERENCES `[[dbprefix]]episode_comments` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]media`
--
ALTER TABLE `[[dbprefix]]media`
  ADD CONSTRAINT `[[dbprefix]]media_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]media_uploaded_by_foreign` FOREIGN KEY (`uploaded_by`) REFERENCES `[[dbprefix]]users` (`id`);

--
-- Constraints for table `[[dbprefix]]persons`
--
ALTER TABLE `[[dbprefix]]persons`
  ADD CONSTRAINT `[[dbprefix]]persons_avatar_id_foreign` FOREIGN KEY (`avatar_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]persons_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]persons_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`);

--
-- Constraints for table `[[dbprefix]]platforms`
--
ALTER TABLE `[[dbprefix]]platforms`
  ADD CONSTRAINT `platforms_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]podcasts`
--
ALTER TABLE `[[dbprefix]]podcasts`
  ADD CONSTRAINT `[[dbprefix]]podcasts_actor_id_foreign` FOREIGN KEY (`actor_id`) REFERENCES `[[dbprefix]]fediverse_actors` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]podcasts_banner_id_foreign` FOREIGN KEY (`banner_id`) REFERENCES `[[dbprefix]]media` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `[[dbprefix]]podcasts_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`),
  ADD CONSTRAINT `[[dbprefix]]podcasts_cover_id_foreign` FOREIGN KEY (`cover_id`) REFERENCES `[[dbprefix]]media` (`id`),
  ADD CONSTRAINT `[[dbprefix]]podcasts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]podcasts_language_code_foreign` FOREIGN KEY (`language_code`) REFERENCES `[[dbprefix]]languages` (`code`),
  ADD CONSTRAINT `[[dbprefix]]podcasts_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`);

--
-- Constraints for table `[[dbprefix]]podcasts_categories`
--
ALTER TABLE `[[dbprefix]]podcasts_categories`
  ADD CONSTRAINT `[[dbprefix]]podcasts_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `[[dbprefix]]categories` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]podcasts_categories_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]podcasts_persons`
--
ALTER TABLE `[[dbprefix]]podcasts_persons`
  ADD CONSTRAINT `[[dbprefix]]podcasts_persons_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `[[dbprefix]]persons` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]podcasts_persons_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]subscriptions`
--
ALTER TABLE `[[dbprefix]]subscriptions`
  ADD CONSTRAINT `[[dbprefix]]subscriptions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `[[dbprefix]]users` (`id`),
  ADD CONSTRAINT `[[dbprefix]]subscriptions_podcast_id_foreign` FOREIGN KEY (`podcast_id`) REFERENCES `[[dbprefix]]podcasts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]subscriptions_updated_by_foreign` FOREIGN KEY (`updated_by`) REFERENCES `[[dbprefix]]users` (`id`);

DELIMITER $$
--
-- Procedures
--
CREATE PROCEDURE `[[dbprefix]]analytics_podcasts`(
    IN `p_podcast_id` INT UNSIGNED,
    IN `p_episode_id` INT UNSIGNED,
    IN `p_country_code` VARCHAR(3),
    IN `p_region_code` VARCHAR(3),
    IN `p_latitude` DECIMAL(8,6),
    IN `p_longitude` DECIMAL(9,6),
    IN `p_service` VARCHAR(128),
    IN `p_app` VARCHAR(128),
    IN `p_device` VARCHAR(32),
    IN `p_os` VARCHAR(32),
    IN `p_bot` TINYINT(1) UNSIGNED,
    IN `p_filesize` INT UNSIGNED,
    IN `p_duration` DECIMAL(8,3) UNSIGNED,
    IN `p_age` INT UNSIGNED,
    IN `p_new_listener` TINYINT(1) UNSIGNED,
    IN `p_subscription_id` INT UNSIGNED
    )
    MODIFIES SQL DATA
    DETERMINISTIC
    SQL SECURITY INVOKER
    COMMENT 'Add one hit in podcast logs tables.'
BEGIN

SET @current_datetime = UTC_TIMESTAMP();
SET @current_date = DATE(@current_datetime);
SET @current_hour = HOUR(@current_datetime);

IF NOT `p_bot` THEN
    INSERT INTO `[[dbprefix]]analytics_podcasts`(`podcast_id`, `date`, `duration`, `bandwidth`)
        VALUES (p_podcast_id, @current_date, `p_duration`, `p_filesize`)
        ON DUPLICATE KEY UPDATE
            `duration`=`duration`+`p_duration`,
            `bandwidth`=`bandwidth`+`p_filesize`,
            `hits`=`hits`+1,
            `unique_listeners`=`unique_listeners`+`p_new_listener`;
    INSERT INTO `[[dbprefix]]analytics_podcasts_by_hour`(`podcast_id`, `date`, `hour`)
        VALUES (p_podcast_id, @current_date, @current_hour)
        ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
    INSERT INTO `[[dbprefix]]analytics_podcasts_by_episode`(`podcast_id`, `episode_id`, `date`, `age`)
        VALUES (p_podcast_id, p_episode_id, @current_date, p_age)
        ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
    INSERT INTO `[[dbprefix]]analytics_podcasts_by_country`(`podcast_id`, `country_code`, `date`)
        VALUES (p_podcast_id, p_country_code, @current_date)
        ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
    INSERT INTO `[[dbprefix]]analytics_podcasts_by_region`(`podcast_id`, `country_code`, `region_code`, `latitude`, `longitude`, `date`)
        VALUES (p_podcast_id, p_country_code, p_region_code, p_latitude, p_longitude, @current_date)
        ON DUPLICATE KEY UPDATE `hits`=`hits`+1;

    IF `p_subscription_id` THEN
        INSERT INTO `[[dbprefix]]analytics_podcasts_by_subscription`(`podcast_id`, `episode_id`, `subscription_id`, `date`)
        VALUES (p_podcast_id, p_episode_id, p_subscription_id, @current_date)
        ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
    END IF;
END IF;
INSERT INTO `[[dbprefix]]analytics_podcasts_by_player`(`podcast_id`, `service`, `app`, `device`, `os`, `is_bot`, `date`)
    VALUES (p_podcast_id, p_service, p_app, p_device, p_os, p_bot, @current_date)
    ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
END$$

CREATE PROCEDURE `[[dbprefix]]analytics_unknown_useragents`(IN `p_useragent` VARCHAR(191))
    MODIFIES SQL DATA
    DETERMINISTIC
    SQL SECURITY INVOKER
    COMMENT 'Add an unknown useragent to table [[dbprefix]]analytics_unknown_useragents.'
INSERT INTO `[[dbprefix]]analytics_unknown_useragents`(`useragent`)
VALUES (p_useragent)
ON DUPLICATE KEY UPDATE `hits`=`hits`+1$$

CREATE PROCEDURE `[[dbprefix]]analytics_website`(
    IN `p_podcast_id` INT UNSIGNED,
    IN `p_browser` VARCHAR(191),
    IN `p_entry_page` VARCHAR(512),
    IN `p_referer_url` VARCHAR(512),
    IN `p_domain` VARCHAR(128),
    IN `p_keywords` VARCHAR(384)
)
    MODIFIES SQL DATA
    DETERMINISTIC
    SQL SECURITY INVOKER
    COMMENT 'Add one hit in website logs tables.'
BEGIN

SET @current_date = DATE(UTC_TIMESTAMP());

INSERT INTO [[dbprefix]]analytics_website_by_browser(`podcast_id`, `browser`, `date`)
    VALUES (p_podcast_id, p_browser, @current_date)
    ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
INSERT INTO [[dbprefix]]analytics_website_by_referer(`podcast_id`, `referer_url`, `domain`, `keywords`, `date`)
    VALUES (p_podcast_id, p_referer_url, p_domain, p_keywords, @current_date)
    ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
INSERT INTO [[dbprefix]]analytics_website_by_entry_page(`podcast_id`, `entry_page_url`, `date`)
    VALUES (p_podcast_id, p_entry_page, @current_date)
    ON DUPLICATE KEY UPDATE `hits`=`hits`+1;
END$$

DELIMITER ;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
