<?php

/*
 * This file is part of the PHPExifTool package.
 *
 * (c) Alchemy <support@alchemy.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace PHPExiftool\Driver\Tag\Photoshop;

use JMS\Serializer\Annotation\ExclusionPolicy;
use PHPExiftool\Driver\AbstractTag;

/**
 * @ExclusionPolicy("all")
 */
class CopyrightFlag extends AbstractTag
{

    protected $Id = 1034;

    protected $Name = 'CopyrightFlag';

    protected $FullName = 'Photoshop::Main';

    protected $GroupName = 'Photoshop';

    protected $g0 = 'Photoshop';

    protected $g1 = 'Photoshop';

    protected $g2 = 'Image';

    protected $Type = 'int8u';

    protected $Writable = true;

    protected $Description = 'Copyright Flag';

    protected $local_g2 = 'Author';

    protected $Values = array(
        0 => array(
            'Id' => 0,
            'Label' => false,
        ),
        1 => array(
            'Id' => 1,
            'Label' => true,
        ),
    );

}
