<?php

/*
 * This file is part of Chevere.
 *
 * (c) Rodolfo Berrios <rodolfo@chevere.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Chevere\Router\Interfaces;

use Psr\Http\Message\ServerRequestInterface;

/**
 * Describes the component in charge of dispatch router.
 */
interface DispatcherInterface
{
    /**
     * Dispatches against the provided HTTP method verb and URI.
     */
    public function dispatch(ServerRequestInterface $request): DispatchInterface;
}
