<?php

// disable the mock by default

namespace
{
    $mockProcOpen = false;
}

// same namespace as SUT

namespace PHPExif\Adapter
{

    // stub the function
    use PHPExif\Reader\PhpExifReaderException;

    function proc_open($cmd, array $descriptorspec, &$pipes = array())
    {
        global $mockProcOpen;
        if (isset($mockProcOpen) && !$mockProcOpen) {
            return \proc_open(
                $cmd,
                $descriptorspec,
                $pipes
            );
        }
        return false;
    }

    class ExiftoolProcOpenTest extends \PHPUnit\Framework\TestCase
    {
        /**
         * @var Exiftool
         */
        protected Exiftool $adapter;

        public function setUp(): void
        {
            global $mockProcOpen;
            $mockProcOpen = true;
            $this->adapter = new Exiftool();
        }

        public function tearDown(): void
        {
            global $mockProcOpen;
            $mockProcOpen = false;
        }

        /**
         * @group exiftool
         */
        public function testGetCliOutput()
        {
            $this->expectException(PhpExifReaderException::class);
            $reflMethod = new \ReflectionMethod(Exiftool::class, 'getCliOutput');
            $reflMethod->setAccessible(true);

            $result = $reflMethod->invoke(
                $this->adapter,
                sprintf(
                    '%1$s',
                    'pwd'
                )
            );
        }
    }
}
