<?php

use ChurchCRM\Authentication\AuthenticationManager;
use ChurchCRM\dto\SystemURLs;

require SystemURLs::getDocumentRoot() . '/Include/Header.php';

?>
<div class="card">
    <div class="card-header with-border">
        <h3 class="card-title"><?= gettext('Email Functions') ?></h3>
    </div>
    <div class="card-body">
        <div class="text-center">
            <a href="<?= SystemURLs::getRootPath()?>/email/MemberEmailExport.php" class="btn btn-app bg-info"><i class="fa-solid fa-table fa-3x"></i><br><?= gettext('Email Export') ?></a>
            <a href="<?= SystemURLs::getRootPath()?>/v2/email/duplicate" class="btn btn-app bg-warning"><i class="fa-solid fa-exclamation-triangle fa-3x"></i><br><?= gettext('Find Duplicate Emails') ?></a>
            <a href="<?= SystemURLs::getRootPath()?>/v2/email/missing" class="btn btn-app bg-danger"><i class="fa-solid fa-bell-slash fa-3x"></i><br><?= gettext('Families Without Emails') ?></a>
            <?php if (AuthenticationManager::getCurrentUser()->isAdmin()) { ?>
            <a href="<?= SystemURLs::getRootPath()?>/admin/system/debug/email" class="btn btn-app bg-secondary"><i class="fa-solid fa-stethoscope fa-3x"></i><br><?= gettext('Debug') ?></a>
            <?php } ?>
        </div>
    </div>
</div>

<?php if ($isMailChimpActive) { ?>
    <div class="row">
        <?php foreach ($mailChimpLists as $list) {
            ?>
            <div class="col-lg-4 col-md-2 col-sm-2">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><?= gettext('List') ?>: <?= $list['name'] ?></h3>
                    </div>
                    <div class="card-body">
                        <table width='300px'>
                            <tr>
                                <td><b><?= gettext('Members:') ?></b></td>
                                <td><?= $list['stats']['member_count'] ?></td>
                            </tr>
                            <tr>
                                <td><b><?= gettext('Campaigns:') ?></b></td>
                                <td><?= $list['stats']['campaign_count'] ?></td>
                            </tr>
                            <tr>
                                <td><b><?= gettext('Unsubscribed count:') ?></b></td>
                                <td><?= $list['stats']['unsubscribe_count'] ?></td>
                            </tr>
                            <tr>
                                <td><b><?= gettext('Unsubscribed count since last send:') ?></b></td>
                                <td><?= $list['stats']['unsubscribe_count_since_send'] ?></td>
                            </tr>
                            <tr>
                                <td><b><?= gettext('Cleaned count:') ?></b></td>
                                <td><?= $list['stats']['cleaned_count'] ?></td>
                            </tr>
                            <tr>
                                <td><b><?= gettext('Cleaned count since last send:') ?></b></td>
                                <td><?= $list['stats']['cleaned_count_since_send'] ?></td>
                            </tr>
                        </table>
                        <hr>
                        <p>
                            <strong><?= gettext("List maintenance")?>:</strong>
                        <ul>
                            <li><a href="<?= SystemURLs::getRootPath()?>/v2/email/mailchimp/<?= $list['id']?>/unsubscribed"> <?= gettext("People not in list")?></a></li>
                            <li><a href="<?= SystemURLs::getRootPath()?>/v2/email/mailchimp/<?= $list['id']?>/missing"> <?= gettext("Audience not in the CRM")?></a></li>
                        </ul>
                        </p>
                    </div>
                </div>
            </div>
            <?php
        } ?>
    </div>
    <?php
} else {
    ?>
    <div class="row">
        <div class="col-lg-12 col-md-7 col-sm-3">
            <div class="card card-body">
                <div class="alert alert-warning">
                    <h4><i class="fa-solid fa-ban"></i> <?= gettext('MailChimp is not configured') ?></h4>
                    <?= gettext('Please update the MailChimp API key in:') ?> <a
                        href="<?= SystemURLs::getRootPath() ?>/SystemSettings.php#Integration"><?= gettext('Integration') ?></a>
                </div>
            </div>
        </div>
    </div>
    <?php
}

require SystemURLs::getDocumentRoot() . '/Include/Footer.php';
