<?php
/**
 *
 * @copyright 2008 - https://www.clicshopping.org
 * @Brand : ClicShoppingAI(TM) at Inpi all right Reserved
 * @Licence GPL 2 & MIT
 * @Info : https://www.clicshopping.org/forum/trademark/
 *
 */

namespace ClicShopping\OM;

interface ActionToolsInterface
{
  /**
   * Retourne le nom technique de l'outil pour la classification (ex: 'sales_report').
   */
  public function getName(): string;

  /**
   * Fournit une description pour le LLM afin qu'il sache quand utiliser l'outil.
   */
  public function getDescription(): string;

  /**
   * Retourne un schéma JSON des paramètres attendus par la méthode execute (OpenAI-like schema).
   */
  public function getParametersSchema(): array;

  /**
   * Get the Properties schema.
   */
  public function getProperties(): array;

  /**
   * Names of the required properties.
   *
   * @return array<string>
   */
  public function getRequiredProperties(): array;

  /**
   * Define the code to be executed.
   */
  public function setCallable(callable $callback): ActionToolsInterface;

  /**
   * Get the input arguments of the function call.
   */
  public function getInputs(): array;

  /**
   * Get the input arguments of the function call.
   */
  public function setInputs(array $inputs): ActionToolsInterface;

  /**
   * The call identifier generated by the LLM.
   */
  public function getCallId(): ?string;


  public function setCallId(string $callId): ActionToolsInterface;


  public function getResult(): string;

  /**
   * Define the maximum number of calls for the tool in a single agent session.
   */
  public function getMaxTries(): ?int;

  public function setMaxTries(int $tries): ActionToolsInterface;

  /**
   * Exécute la logique métier de l'outil (requêtes SQL, appels d'API, etc.).
   * @param array $params Les paramètres extraits par le LLM (ex: ['period' => '3_months']).
   * @return array Les données brutes (PHP array) du résultat.
   */
  public function execute(array $params): array;
}