<?php
/**
 *
 * @copyright 2008 - https://www.clicshopping.org
 * @Brand : ClicShoppingAI(TM) at Inpi all right Reserved
 * @Licence GPL 2 & MIT
 * @Info : https://www.clicshopping.org/forum/trademark/
 *
 */

namespace ClicShopping\Apps\Configuration\ProductsLength\Classes\ClicShoppingAdmin;

use ClicShopping\OM\Registry;
use function is_null;

class ProductsLengthAdmin extends \ClicShopping\Apps\Configuration\ProductsLength\Classes\Shop\ProductsLength
{
  protected $products_length_classes = [];
  protected $precision = 2;

  /**
   * Constructor method to initialize the object with a precision value.
   *
   * @param mixed|null $precision The optional precision value to configure the instance. Can be null.
   * @return void
   */
  public function __construct(mixed $precision = null)
  {
  }

  /**
   * Retrieves the title based on the provided ID and optional language ID.
   *
   * @param int|string $id The identifier for which the title should be retrieved.
   * @param int|null $language_id Optional language ID to specify the language context.
   * @return string The title associated with the given ID and language context.
   */
  public static function getTitle(mixed  $id, ?int $language_id = null)
  {
    return parent::getTitle($id, $language_id);
  }

  /**
   * Retrieves the classes from the parent implementation.
   *
   * @return mixed The result of the parent's getClasses method.
   */
  public static function getClasses()
  {
    return parent::getClasses();
  }

  /**
   * Renders the display output by delegating to the parent class display method.
   *
   * @param mixed $value The value to be displayed.
   * @param mixed $class The class related to the display method.
   *
   * @return mixed The output generated by the parent class display method.
   */
  public function display($value, $class)
  {
    return parent::display($value, $class);
  }

  /**
   * Retrieves a list of product length classes for use in a dropdown or pulldown menu.
   *
   * @return array An array of associative arrays, where each element contains 'id' as the product length class ID
   *               and 'text' as the product length class title, ordered by title.
   */
  public static function getClassesPullDown(): array
  {
    $CLICSHOPPING_Language = Registry::get('Language');
    $CLICSHOPPING_Db = Registry::get('Db');

    $Qclasses = $CLICSHOPPING_Db->prepare('select products_length_class_id, 
                                                    products_length_class_title 
                                              from :table_products_length_classes 
                                              where language_id = :language_id 
                                              order by products_length_class_title
                                            ');
    $Qclasses->bindInt(':language_id', $CLICSHOPPING_Language->getID());
    $Qclasses->execute();

    $classes = [];

    while ($Qclasses->fetch() !== false) {
      $classes[] = [
        'id' => $Qclasses->valueInt('products_length_class_id'),
        'text' => $Qclasses->value('products_length_class_title')
      ];
    }

    return $classes;
  }

  /**
   * Retrieves the title of a product's length class by its ID.
   *
   * @param int|null $id The ID of the product's length class. If null, no title is retrieved.
   * @return string The title of the product's length class.
   */
  public static function getLengthProductsTitle(int $id = null): string
  {
    $CLICSHOPPING_Db = Registry::get('Db');
    $CLICSHOPPING_Language = Registry::get('Language');

    if (!is_null($id)) {
      $Qlength = $CLICSHOPPING_Db->prepare('select products_length_class_title
                                               from :table_products_length_classes
                                               where products_length_class_id = :products_length_class_id
                                               and language_id = :language_id
                                               ');
      $Qlength->bindInt(':products_length_class_id', $id);
      $Qlength->bindInt(':language_id', $CLICSHOPPING_Language->getID());

      $Qlength->execute();

      $result = $Qlength->value('products_length_class_title');

      return $result;
    }
  }
}