# Dispute

### Description

Represents a dispute a cardholder initiated with their bank.

## Properties
Name | Getter | Setter | Type | Description | Notes
------------ | ------------- | ------------- | ------------- | ------------- | -------------
**dispute_id** | getDisputeId() | setDisputeId($value) | **string** | Unique ID for this &#x60;Dispute&#x60;, generated by Square. | [optional] 
**amount_money** | getAmountMoney() | setAmountMoney($value) | [**\SquareConnect\Model\Money**](Money.md) | The disputed amount. The amount can be less than the entire transaction amount. For example, a cardholder purchased multiple items, however initiated dispute only for some of the items. | [optional] 
**reason** | getReason() | setReason($value) | **string** | The dispute reason why cardholder initiated dispute with their bank. See [DisputeReason](#type-disputereason) for possible values | [optional] 
**state** | getState() | setState($value) | **string** | The current state of this dispute. See [DisputeState](#type-disputestate) for possible values | [optional] 
**due_at** | getDueAt() | setDueAt($value) | **string** | The time when the next action is due, in RFC 3339 format. | [optional] 
**disputed_payment** | getDisputedPayment() | setDisputedPayment($value) | [**\SquareConnect\Model\DisputedPayment**](DisputedPayment.md) | The payment challenged in this dispute. | [optional] 
**evidence_ids** | getEvidenceIds() | setEvidenceIds($value) | **string[]** | The IDs of the evidence associated with the dispute. | [optional] 
**card_brand** | getCardBrand() | setCardBrand($value) | **string** | The card brand used in the disputed payment. See [CardBrand](#type-cardbrand) for possible values | [optional] 
**created_at** | getCreatedAt() | setCreatedAt($value) | **string** | Timestamp when the dispute was created, in RFC 3339 format. | [optional] 
**updated_at** | getUpdatedAt() | setUpdatedAt($value) | **string** | Timestamp when dispute was last updated, in RFC 3339 format. | [optional] 
**brand_dispute_id** | getBrandDisputeId() | setBrandDisputeId($value) | **string** | ID of the dispute in the card brand system, generated by the card brand. | [optional] 
**reported_date** | getReportedDate() | setReportedDate($value) | **string** | Timestamp when the dispute was reported, in RFC 3339 format. | [optional] 
**version** | getVersion() | setVersion($value) | **int** | The current version of the &#x60;Dispute&#x60;. | [optional] 
**location_id** | getLocationId() | setLocationId($value) | **string** | The ID of location where dispute originated. | [optional] 

Note: All properties are protected and only accessed via getters and setters.

[[Back to Model list]](../../README.md#documentation-for-models) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to README]](../../README.md)

