<?php
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SquareConnect\Model;

use \ArrayAccess;
/**
 * CatalogCustomAttributeDefinition Class Doc Comment
 *
 * @category Class
 * @package  SquareConnect
 * @author   Square Inc.
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://squareup.com/developers
 * Note: This endpoint is in beta.
 */
class CatalogCustomAttributeDefinition implements ArrayAccess
{
    /**
      * Array of property to type mappings. Used for (de)serialization 
      * @var string[]
      */
    static $swaggerTypes = array(
        'type' => 'string',
        'name' => 'string',
        'description' => 'string',
        'source_application' => '\SquareConnect\Model\SourceApplication',
        'allowed_object_types' => 'string[]',
        'seller_visibility' => 'string',
        'app_visibility' => 'string',
        'string_config' => '\SquareConnect\Model\CatalogCustomAttributeDefinitionStringConfig',
        'number_config' => '\SquareConnect\Model\CatalogCustomAttributeDefinitionNumberConfig',
        'selection_config' => '\SquareConnect\Model\CatalogCustomAttributeDefinitionSelectionConfig',
        'custom_attribute_usage_count' => 'int',
        'key' => 'string'
    );
  
    /** 
      * Array of attributes where the key is the local name, and the value is the original name
      * @var string[] 
      */
    static $attributeMap = array(
        'type' => 'type',
        'name' => 'name',
        'description' => 'description',
        'source_application' => 'source_application',
        'allowed_object_types' => 'allowed_object_types',
        'seller_visibility' => 'seller_visibility',
        'app_visibility' => 'app_visibility',
        'string_config' => 'string_config',
        'number_config' => 'number_config',
        'selection_config' => 'selection_config',
        'custom_attribute_usage_count' => 'custom_attribute_usage_count',
        'key' => 'key'
    );
  
    /**
      * Array of attributes to setter functions (for deserialization of responses)
      * @var string[]
      */
    static $setters = array(
        'type' => 'setType',
        'name' => 'setName',
        'description' => 'setDescription',
        'source_application' => 'setSourceApplication',
        'allowed_object_types' => 'setAllowedObjectTypes',
        'seller_visibility' => 'setSellerVisibility',
        'app_visibility' => 'setAppVisibility',
        'string_config' => 'setStringConfig',
        'number_config' => 'setNumberConfig',
        'selection_config' => 'setSelectionConfig',
        'custom_attribute_usage_count' => 'setCustomAttributeUsageCount',
        'key' => 'setKey'
    );
  
    /**
      * Array of attributes to getter functions (for serialization of requests)
      * @var string[]
      */
    static $getters = array(
        'type' => 'getType',
        'name' => 'getName',
        'description' => 'getDescription',
        'source_application' => 'getSourceApplication',
        'allowed_object_types' => 'getAllowedObjectTypes',
        'seller_visibility' => 'getSellerVisibility',
        'app_visibility' => 'getAppVisibility',
        'string_config' => 'getStringConfig',
        'number_config' => 'getNumberConfig',
        'selection_config' => 'getSelectionConfig',
        'custom_attribute_usage_count' => 'getCustomAttributeUsageCount',
        'key' => 'getKey'
    );
  
    /**
      * $type The type of this custom attribute. Cannot be modified after creation. Required. See [CatalogCustomAttributeDefinitionType](#type-catalogcustomattributedefinitiontype) for possible values
      * @var string
      */
    protected $type;
    /**
      * $name The name of this definition for API and seller-facing UI purposes. The name must be unique within the (merchant, application_id) pair. Required. May not be empty and may not exceed 255 characters. Can be modified after creation.
      * @var string
      */
    protected $name;
    /**
      * $description Seller-oriented description of the meaning of this Custom Attribute, any constraints that the seller should observe, etc. May be displayed as a tooltip in Square UIs.
      * @var string
      */
    protected $description;
    /**
      * $source_application __Read only.__ Contains information about the application that created this custom attribute definition.
      * @var \SquareConnect\Model\SourceApplication
      */
    protected $source_application;
    /**
      * $allowed_object_types The set of Catalog Object Types that this Custom Attribute may be applied to. Currently, only `ITEM` and `ITEM_VARIATION` are allowed. At least one type must be included. See [CatalogObjectType](#type-catalogobjecttype) for possible values
      * @var string[]
      */
    protected $allowed_object_types;
    /**
      * $seller_visibility The visibility of a custom attribute in seller-facing UIs (including Square Point of Sale applications and Square Dashboard). May be modified. See [CatalogCustomAttributeDefinitionSellerVisibility](#type-catalogcustomattributedefinitionsellervisibility) for possible values
      * @var string
      */
    protected $seller_visibility;
    /**
      * $app_visibility The visibility of a custom attribute to applications other than the application that created the attribute. See [CatalogCustomAttributeDefinitionAppVisibility](#type-catalogcustomattributedefinitionappvisibility) for possible values
      * @var string
      */
    protected $app_visibility;
    /**
      * $string_config Optionally, populated when `type` = `STRING`, unset otherwise.
      * @var \SquareConnect\Model\CatalogCustomAttributeDefinitionStringConfig
      */
    protected $string_config;
    /**
      * $number_config 
      * @var \SquareConnect\Model\CatalogCustomAttributeDefinitionNumberConfig
      */
    protected $number_config;
    /**
      * $selection_config Populated when `type` is set to `SELECTION`, unset otherwise.
      * @var \SquareConnect\Model\CatalogCustomAttributeDefinitionSelectionConfig
      */
    protected $selection_config;
    /**
      * $custom_attribute_usage_count __Read-only.__ The number of custom attributes that reference this custom attribute definition. Set by the server in response to a ListCatalog request with `include_counts` set to `true`.  If the actual count is greater than 100, `custom_attribute_usage_count` will be set to `100`.
      * @var int
      */
    protected $custom_attribute_usage_count;
    /**
      * $key The name of the desired custom attribute key that can be used to access the custom attribute value on catalog objects. Cannot be modified after the custom attribute definition has been created. Must be between 1 and 60 characters, and may only contain the characters [a-zA-Z0-9_-].
      * @var string
      */
    protected $key;

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initializing the model
     */
    public function __construct(array $data = null)
    {
        if ($data != null) {
            if (isset($data["type"])) {
              $this->type = $data["type"];
            } else {
              $this->type = null;
            }
            if (isset($data["name"])) {
              $this->name = $data["name"];
            } else {
              $this->name = null;
            }
            if (isset($data["description"])) {
              $this->description = $data["description"];
            } else {
              $this->description = null;
            }
            if (isset($data["source_application"])) {
              $this->source_application = $data["source_application"];
            } else {
              $this->source_application = null;
            }
            if (isset($data["allowed_object_types"])) {
              $this->allowed_object_types = $data["allowed_object_types"];
            } else {
              $this->allowed_object_types = null;
            }
            if (isset($data["seller_visibility"])) {
              $this->seller_visibility = $data["seller_visibility"];
            } else {
              $this->seller_visibility = null;
            }
            if (isset($data["app_visibility"])) {
              $this->app_visibility = $data["app_visibility"];
            } else {
              $this->app_visibility = null;
            }
            if (isset($data["string_config"])) {
              $this->string_config = $data["string_config"];
            } else {
              $this->string_config = null;
            }
            if (isset($data["number_config"])) {
              $this->number_config = $data["number_config"];
            } else {
              $this->number_config = null;
            }
            if (isset($data["selection_config"])) {
              $this->selection_config = $data["selection_config"];
            } else {
              $this->selection_config = null;
            }
            if (isset($data["custom_attribute_usage_count"])) {
              $this->custom_attribute_usage_count = $data["custom_attribute_usage_count"];
            } else {
              $this->custom_attribute_usage_count = null;
            }
            if (isset($data["key"])) {
              $this->key = $data["key"];
            } else {
              $this->key = null;
            }
        }
    }
    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
  
    /**
     * Sets type
     * @param string $type The type of this custom attribute. Cannot be modified after creation. Required. See [CatalogCustomAttributeDefinitionType](#type-catalogcustomattributedefinitiontype) for possible values
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
  
    /**
     * Sets name
     * @param string $name The name of this definition for API and seller-facing UI purposes. The name must be unique within the (merchant, application_id) pair. Required. May not be empty and may not exceed 255 characters. Can be modified after creation.
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
  
    /**
     * Sets description
     * @param string $description Seller-oriented description of the meaning of this Custom Attribute, any constraints that the seller should observe, etc. May be displayed as a tooltip in Square UIs.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Gets source_application
     * @return \SquareConnect\Model\SourceApplication
     */
    public function getSourceApplication()
    {
        return $this->source_application;
    }
  
    /**
     * Sets source_application
     * @param \SquareConnect\Model\SourceApplication $source_application __Read only.__ Contains information about the application that created this custom attribute definition.
     * @return $this
     */
    public function setSourceApplication($source_application)
    {
        $this->source_application = $source_application;
        return $this;
    }
    /**
     * Gets allowed_object_types
     * @return string[]
     */
    public function getAllowedObjectTypes()
    {
        return $this->allowed_object_types;
    }
  
    /**
     * Sets allowed_object_types
     * @param string[] $allowed_object_types The set of Catalog Object Types that this Custom Attribute may be applied to. Currently, only `ITEM` and `ITEM_VARIATION` are allowed. At least one type must be included. See [CatalogObjectType](#type-catalogobjecttype) for possible values
     * @return $this
     */
    public function setAllowedObjectTypes($allowed_object_types)
    {
        $this->allowed_object_types = $allowed_object_types;
        return $this;
    }
    /**
     * Gets seller_visibility
     * @return string
     */
    public function getSellerVisibility()
    {
        return $this->seller_visibility;
    }
  
    /**
     * Sets seller_visibility
     * @param string $seller_visibility The visibility of a custom attribute in seller-facing UIs (including Square Point of Sale applications and Square Dashboard). May be modified. See [CatalogCustomAttributeDefinitionSellerVisibility](#type-catalogcustomattributedefinitionsellervisibility) for possible values
     * @return $this
     */
    public function setSellerVisibility($seller_visibility)
    {
        $this->seller_visibility = $seller_visibility;
        return $this;
    }
    /**
     * Gets app_visibility
     * @return string
     */
    public function getAppVisibility()
    {
        return $this->app_visibility;
    }
  
    /**
     * Sets app_visibility
     * @param string $app_visibility The visibility of a custom attribute to applications other than the application that created the attribute. See [CatalogCustomAttributeDefinitionAppVisibility](#type-catalogcustomattributedefinitionappvisibility) for possible values
     * @return $this
     */
    public function setAppVisibility($app_visibility)
    {
        $this->app_visibility = $app_visibility;
        return $this;
    }
    /**
     * Gets string_config
     * @return \SquareConnect\Model\CatalogCustomAttributeDefinitionStringConfig
     */
    public function getStringConfig()
    {
        return $this->string_config;
    }
  
    /**
     * Sets string_config
     * @param \SquareConnect\Model\CatalogCustomAttributeDefinitionStringConfig $string_config Optionally, populated when `type` = `STRING`, unset otherwise.
     * @return $this
     */
    public function setStringConfig($string_config)
    {
        $this->string_config = $string_config;
        return $this;
    }
    /**
     * Gets number_config
     * @return \SquareConnect\Model\CatalogCustomAttributeDefinitionNumberConfig
     */
    public function getNumberConfig()
    {
        return $this->number_config;
    }
  
    /**
     * Sets number_config
     * @param \SquareConnect\Model\CatalogCustomAttributeDefinitionNumberConfig $number_config 
     * @return $this
     */
    public function setNumberConfig($number_config)
    {
        $this->number_config = $number_config;
        return $this;
    }
    /**
     * Gets selection_config
     * @return \SquareConnect\Model\CatalogCustomAttributeDefinitionSelectionConfig
     */
    public function getSelectionConfig()
    {
        return $this->selection_config;
    }
  
    /**
     * Sets selection_config
     * @param \SquareConnect\Model\CatalogCustomAttributeDefinitionSelectionConfig $selection_config Populated when `type` is set to `SELECTION`, unset otherwise.
     * @return $this
     */
    public function setSelectionConfig($selection_config)
    {
        $this->selection_config = $selection_config;
        return $this;
    }
    /**
     * Gets custom_attribute_usage_count
     * @return int
     */
    public function getCustomAttributeUsageCount()
    {
        return $this->custom_attribute_usage_count;
    }
  
    /**
     * Sets custom_attribute_usage_count
     * @param int $custom_attribute_usage_count __Read-only.__ The number of custom attributes that reference this custom attribute definition. Set by the server in response to a ListCatalog request with `include_counts` set to `true`.  If the actual count is greater than 100, `custom_attribute_usage_count` will be set to `100`.
     * @return $this
     */
    public function setCustomAttributeUsageCount($custom_attribute_usage_count)
    {
        $this->custom_attribute_usage_count = $custom_attribute_usage_count;
        return $this;
    }
    /**
     * Gets key
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }
  
    /**
     * Sets key
     * @param string $key The name of the desired custom attribute key that can be used to access the custom attribute value on catalog objects. Cannot be modified after the custom attribute definition has been created. Must be between 1 and 60 characters, and may only contain the characters [a-zA-Z0-9_-].
     * @return $this
     */
    public function setKey($key)
    {
        $this->key = $key;
        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset 
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->$offset);
    }
  
    /**
     * Gets offset.
     * @param  integer $offset Offset 
     * @return mixed 
     */
    public function offsetGet($offset)
    {
        return $this->$offset;
    }
  
    /**
     * Sets value based on offset.
     * @param  integer $offset Offset 
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        $this->$offset = $value;
    }
  
    /**
     * Unsets offset.
     * @param  integer $offset Offset 
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->$offset);
    }
  
    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        } else {
            return json_encode(\SquareConnect\ObjectSerializer::sanitizeForSerialization($this));
        }
    }
}
