<?php
require_once ('modules/admin/models/Package.php');
require_once ('modules/admin/models/PackageGateway.php');
include_once ('modules/admin/models/PackageTypeGateway.php');
require_once ('modules/admin/models/AddonGateway.php');
require_once ('modules/billing/models/BillingType.php');
require_once ('modules/billing/models/BillingTypeGateway.php');
require_once ('modules/billing/models/Coupon.php');
require_once ('modules/admin/models/CouponGateway.php');
require_once ('modules/billing/models/Currency.php');
require_once ('modules/billing/models/CurrencyGateway.php');
require_once ('modules/billing/models/Prices.php');
require_once ('modules/billing/models/BillingCycleGateway.php');

/**
 * Import_Currency_Prices Report Class
 *
 * @category Report
 * @package  ClientExec
 * @author   Juan Bolivar <juan@clientexec.com>
 * @license  ClientExec License
 * @version  1.0
 * @link     http://www.clientexec.com
 */
class Import_Currency_Prices extends Report
{
    protected $featureSet = 'billing';

    private $lang;

    var $showOptionsForOverdueTransactions = true;
    var $lastPaidInvoiceInfo = array();

    function __construct($user = null, $customer = null)
    {
        $this->lang = lang('Import Currency Prices');
        parent::__construct($user,$customer);
    }

    /**
     * Report Process Method
     *
     * @return null - direct output
     */
    function process()
    {
        // Set the report information
        $this->SetDescription($this->user->lang('A report to import prices from a currency to a different one.'));

        @set_time_limit(0);

        if(isset($_GET['data'])){
            $data = base64_decode($_GET['data']);
            $dataArray = explode('_', $data);
            $category = base64_decode($dataArray[0]);
            $items = base64_decode($dataArray[1]);
            $itemsArray = explode(',', $items);
            $fromCurrency = base64_decode($dataArray[2]);
            $toCurrency = base64_decode($dataArray[3]);
            $exchangeRate = (float)base64_decode($dataArray[4]);
        } else {
            $category = 'all';
            $itemsArray = array('all');
            $defaultCurrency = $this->settings->get('Default Currency');
            $fromCurrency = $defaultCurrency;
            $toCurrency = $defaultCurrency;
            $exchangeRate = (float)1;
        }

        echo "<div style='margin:20px;'><h3>" . $this->user->lang('Import prices from a currency to a different one') . "</h3>";
        echo "<div style='margin:20px;'>" . $this->user->lang('This will import all the pricing information of the selected items and currency, overwriting the pricing information of the other currency, and applying the exchange rate to the new prices.') . "<br>" . $this->user->lang('Please avoid using it for <b>Products</b> or <b>Addons</b> if the imported pricing does not include at least a similar pricing configuration as the ones configured for the second currency.') . "<br>" . $this->user->lang('For example, it should have the same billing cycles configured with prices and it can include some new ones. Otherwise, it could lead to existing products missing valid pricing to be charged, etc.') . "<br>" . $this->user->lang('It is strongly recommended to create a full database backup before trying to import prices.') . "<br><b>" . $this->user->lang('Super Admin is required.') . "</b><br><br><br>";

        echo "<table>";

        //Import all prices of: [Select: Products, Addons, Late Fee service plugin, Billing Types, Coupons]
        $categoryField =  "<tr><td>".$this->user->lang('Import all prices of').":&nbsp;&nbsp;</td><td><select name='category' id='category'style='display:none'>
            <option ".(($category == 'all')? "selected='selected'" : "")." value='all'>".$this->user->lang('All')."</option>
            <option ".(($category == 'products')? "selected='selected'" : "")." value='products'>".$this->user->lang('Products')."</option>
            <option ".(($category == 'addons')? "selected='selected'" : "")." value='addons'>".$this->user->lang('Addons')."</option>
            <option ".(($category == 'latefee')? "selected='selected'" : "")." value='latefee'>".$this->user->lang('Late Fee service plugin')."</option>
            <option ".(($category == 'billingtypes')? "selected='selected'" : "")." value='billingtypes'>".$this->user->lang('Billing Types')."</option>
            <option ".(($category == 'coupons')? "selected='selected'" : "")." value='coupons'>".$this->user->lang('Coupons')."</option>";
        $categoryField .= "</select></td></tr>";
        echo $categoryField;

        //Applies to items: [Multiselect: list of all the items under that category, including an ALL option in top to apply to all]
        //All
        $items_allField = "<span class='items all'><select multiple='multiple' name='items_all[]' id='items_all[]' style='display:none'>
            <option selected='selected' value='all'>".$this->user->lang('All')."</option>";
        $items_allField .= "</select></span>";

        //Products
        $packageGateway = new PackageGateway($this->user);
        $availablePackages = $packageGateway->getPackageList();
        $items_productsField = "<span class='items products'><select multiple='multiple' name='items_products[]' id='items_products[]' style='display:none'>
            <option ".((in_array('all', $itemsArray))? "selected='selected'" : "")." value='all'>".$this->user->lang('All')."</option>";

        foreach ($availablePackages["packages"] as $package) {
            $items_productsField .= "<option ".((in_array($package['packageId'], $itemsArray))? "selected='selected'" : "")." value='".$package['packageId']."'>".$package['packageName']."</option>";
        }

        $items_productsField .= "</select></span>";

        //Addons
        $addonGateway = new AddonGateway($this->user);
        $availableAddons = $addonGateway->getAllAddons();
        $items_addonsField = "<span class='items addons'><select multiple='multiple' name='items_addons[]' id='items_addons[]' style='display:none'>
            <option ".((in_array('all', $itemsArray))? "selected='selected'" : "")." value='all'>".$this->user->lang('All')."</option>";

        foreach ($availableAddons["addons"] as $addon) {
            $items_addonsField .= "<option ".((in_array($addon['id'], $itemsArray))? "selected='selected'" : "")." value='".$addon['id']."'>".$addon['name']."</option>";
        }

        $items_addonsField .= "</select></span>";

        //Late Fee service plugin
        $items_latefeeField = "<span class='items latefee'><select multiple='multiple' name='items_latefee[]' id='items_latefee[]' style='display:none'>
            <option selected='selected' value='all'>".$this->user->lang('All')."</option>";
        $items_latefeeField .= "</select></span>";

        //Billing Types
        $billingTypeGateway = new BillingTypeGateway();
        $availableBillingTypes = $billingTypeGateway->GetBillableBillingTypes(0, false, array('name', 'ASC'));
        $items_billingtypesField = "<span class='items billingtypes'><select multiple='multiple' name='items_billingtypes[]' id='items_billingtypes[]' style='display:none'>
            <option ".((in_array('all', $itemsArray))? "selected='selected'" : "")." value='all'>".$this->user->lang('All')."</option>";

        while ($billingType = $availableBillingTypes->fetch()) {
            $items_billingtypesField .= "<option ".((in_array($billingType->getId(), $itemsArray))? "selected='selected'" : "")." value='".$billingType->getId()."'>".$billingType->getName()."</option>";
        }

        $items_billingtypesField .= "</select></span>";

        //Coupons
        $couponGateway = new CouponGateway();
        $availableCoupons = $couponGateway->getCoupons(0, false, array('coupons_name', 'ASC'));
        $items_couponsField = "<span class='items coupons'><select multiple='multiple' name='items_coupons[]' id='items_coupons[]' style='display:none'>
            <option ".((in_array('all', $itemsArray))? "selected='selected'" : "")." value='all'>".$this->user->lang('All')."</option>";

        foreach ($availableCoupons["coupons"] as $coupon) {
            $items_couponsField .= "<option ".((in_array($coupon['id'], $itemsArray))? "selected='selected'" : "")." value='".$coupon['id']."'>".$coupon['name']."</option>";
        }

        $items_couponsField .= "</select></span>";

        $itemsField =  "<tr><td>".$this->user->lang('Applies to items').":&nbsp;&nbsp;</td><td>"
            .$items_allField
            .$items_productsField
            .$items_addonsField
            .$items_latefeeField
            .$items_billingtypesField
            .$items_couponsField
            ."</td></tr>";
        echo $itemsField;

        //From currency: [Select: enabled currency]
        $currency = new Currency($this->user);
        $fromCurrencyDropdown = $currency->ShowCurrencyDropDownList($fromCurrency, 'fromCurrency', true, "id='fromCurrency' style='display:none'");
        $fromCurrencyField =  "<tr><td>".$this->user->lang('From currency').":&nbsp;&nbsp;</td><td>"
            .$fromCurrencyDropdown
            ."</td></tr>";
        echo $fromCurrencyField;

        //To currency: [Select: enabled currency]
        $toCurrencyDropdown = $currency->ShowCurrencyDropDownList($toCurrency, 'toCurrency', true, "id='toCurrency' style='display:none'");
        $toCurrencyField =  "<tr><td>".$this->user->lang('To currency').":&nbsp;&nbsp;</td><td>"
            .$toCurrencyDropdown
            ."</td></tr>";
        echo $toCurrencyField;

        //With an exchange rate of: [Textfield: calculate the exchange rate between those 2 currencies, and display it, but allow to manually change it if needed]
        $exchangeRateField =  "<tr><td>".$this->user->lang('With an exchange rate of').":&nbsp;&nbsp;</td><td><input type='text' name='exchangeRate' id='exchangeRate' value='$exchangeRate' style='width:100px;' ></td></tr>";
        echo $exchangeRateField;

        echo "<tr><td></td><td></br>"."<button name='import' id='import' class='btn' type='button' data-loading-text='Loading...' onclick='importCurrencyPrices();'>"
            .$this->user->lang("Import Currency Prices") . "</button></td></tr>";

        echo "</table>";

        echo "</div>";

        echo "\n\n<script type='text/javascript'>
                $('#category').change(function() {
                    $('.items').hide();
                    $('.'+$(this).val()).show();
                });

                $('#category').trigger('change');

                $('#fromCurrency, #toCurrency').change(function() {
                    fromCurrencyRate = $('#fromCurrency').find('option:selected').data('rate');
                    toCurrencyrate = $('#toCurrency').find('option:selected').data('rate');

                    rate = 0;

                    if (fromCurrencyRate > 0) {
                        rate = toCurrencyrate / fromCurrencyRate;
                    }

                    $('#exchangeRate').val(rate);
                });

                function importCurrencyPrices () {
                    if (".(($this->user->isSuperAdmin())? "true" : "false").") {
                        document.getElementById(\"import\").disabled = true;

                        category = document.getElementById(\"category\").value;
                        items = document.getElementById(\"items_\"+category+\"[]\").selectedOptions;
                        fromCurrency = document.getElementById(\"fromCurrency\").value;
                        toCurrency = document.getElementById(\"toCurrency\").value;
                        exchangeRate = document.getElementById(\"exchangeRate\").value;

                        if (exchangeRate == '' || exchangeRate == 0) {
                            RichHTML.error(lang('Exchange Rate is required.'));
                            document.getElementById(\"import\").disabled = false;
                            return;
                        } else {
                            var countItemsSelected = items.length;

                            if (countItemsSelected == 0) {
                                RichHTML.error(lang('You must select at least one item.'));
                                document.getElementById(\"import\").disabled = false;
                                return;
                            } else {
                                var itemsSelected = '';
                                var firstItem = true;

                                for (x = 0; x < countItemsSelected; x ++) {
                                    if (firstItem) {
                                        firstItem = false;
                                    } else {
                                        itemsSelected += ',';
                                    }

                                    itemsSelected += items.item(x).value;
                                }

                                location.href='index.php?fuse=reports&view=viewreport&controller=index&report=Import+Currency+Prices&type=Diagnostics&import=1&data='+btoa(btoa(category)+'_'+btoa(itemsSelected)+'_'+btoa(fromCurrency)+'_'+btoa(toCurrency)+'_'+btoa(exchangeRate));
                            }
                        }
                    } else {
                        RichHTML.error(lang('You do not have permission to perform this action.'));
                        document.getElementById(\"import\").disabled = false;
                        return;
                    }
                }
            </script>";
        echo "\n\n";

        if(isset($_GET['import'])){
            if($this->user->isSuperAdmin()){
                $this->importCurrencyPrices($category, $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                echo "<div class='well'>".$this->user->lang('The import has finished.')."</div>";
            } else {
                echo "<div class='alert ce-alert ce-alert-error'><b>".$this->user->lang('You do not have permission to perform this action.')."</b></div>";
            }
        }
    }

    function importCurrencyPrices($category, $itemsArray, $fromCurrency, $toCurrency, $exchangeRate)
    {
        switch ($category) {
            case 'all':
                $this->importCurrencyPrices('products', $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                $this->importCurrencyPrices('addons', $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                $this->importCurrencyPrices('latefee', $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                $this->importCurrencyPrices('billingtypes', $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                $this->importCurrencyPrices('coupons', $itemsArray, $fromCurrency, $toCurrency, $exchangeRate);
                break;
            case 'products':
                if (in_array('all', $itemsArray)) {
                    //update all the products
                    $packageGateway = new PackageGateway($this->user);
                    $availablePackages = $packageGateway->getPackageList(false, false);

                    foreach ($availablePackages["packages"] as $package) {
                        $this->importCurrencyPricesProduct($package['packageId'], $fromCurrency, $toCurrency, $exchangeRate);
                    }

                    break;
                } else {
                    foreach ($itemsArray as $product) {
                        $productIdsArray = explode('_', $product);

                        if ($productIdsArray[1] === '0') {
                            //update all the products under product group with id $productIdsArray[0]
                            $packageGateway = new PackageGateway($this->user);
                            $availablePackages = $packageGateway->getGroupPackagesList($productIdsArray[0], false);

                            foreach ($availablePackages["packages"] as $package) {
                                $this->importCurrencyPricesProduct($package['packageId'], $fromCurrency, $toCurrency, $exchangeRate);
                            }
                        } else {
                            //update the product with id $productIdsArray[1]
                            $this->importCurrencyPricesProduct($productIdsArray[1], $fromCurrency, $toCurrency, $exchangeRate);
                        }
                    }
                }

                break;
            case 'addons':
                if (in_array('all', $itemsArray)) {
                    //update all the addons
                    $addonGateway = new AddonGateway($this->user);
                    $availableAddons = $addonGateway->getAllAddons();

                    foreach ($availableAddons["addons"] as $addon) {
                        $this->importCurrencyPricesAddon($addon['id'], $fromCurrency, $toCurrency, $exchangeRate);
                    }

                    break;
                } else {
                    foreach ($itemsArray as $addon) {
                        //update the addon with id $addon
                        $this->importCurrencyPricesAddon($addon, $fromCurrency, $toCurrency, $exchangeRate);
                    }
                }

                break;
            case 'latefee':
                //update the latefee
                $this->importCurrencyPricesLatefee($fromCurrency, $toCurrency, $exchangeRate);

                break;
            case 'billingtypes':
                if (in_array('all', $itemsArray)) {
                    //update all the billing types
                    $billingTypeGateway = new BillingTypeGateway();
                    $availableBillingTypes = $billingTypeGateway->GetBillableBillingTypes(0, false, array('name', 'ASC'));

                    while ($billingType = $availableBillingTypes->fetch()) {
                        $this->importCurrencyPricesBillingtype($billingType->getId(), $fromCurrency, $toCurrency, $exchangeRate);
                    }

                    break;
                } else {
                    foreach ($itemsArray as $billingtype) {
                        //update the billing type with id $billingtype
                        $this->importCurrencyPricesBillingtype($billingtype, $fromCurrency, $toCurrency, $exchangeRate);
                    }
                }

                break;
            case 'coupons':
                if (in_array('all', $itemsArray)) {
                    //update all the coupons
                    $couponGateway = new CouponGateway();
                    $availableCoupons = $couponGateway->getCoupons(0, false, array('coupons_name', 'ASC'));

                    foreach ($availableCoupons["coupons"] as $coupon) {
                        $this->importCurrencyPricesCoupon($coupon['id'], $fromCurrency, $toCurrency, $exchangeRate);
                    }

                    break;
                } else {
                    foreach ($itemsArray as $coupon) {
                        //update the coupon with id $coupon
                        $this->importCurrencyPricesCoupon($coupon, $fromCurrency, $toCurrency, $exchangeRate);
                    }
                }

                break;
        }
    }

    function importCurrencyPricesProduct($item, $fromCurrency, $toCurrency, $exchangeRate)
    {
        $defaultCurrency = $this->settings->get('Default Currency');

        $prices = new Prices();

        //Billing Cycles
        $billingcycles = array();
        $gateway = new BillingCycleGateway();
        $iterator = $gateway->getBillingCycles(array(), array('order_value', 'ASC'));

        while ($cycle = $iterator->fetch()) {
            $billingcycles[$cycle->id] = array(
                'name'      => $this->user->lang($cycle->name),
                'time_unit' => $cycle->time_unit
            );
        }
        //Billing Cycles

        $package = new Package($item);

        // Load the pricing information
        $package->getProductPricing();

        // Load the pricing information per currency
        $package->getProductPricingAllCurrencies();

        if (isset($package->pricingInformationCurrency[$fromCurrency])) {
            // Query for the group info
            $packageTypeGateway = new PackageTypeGateway();
            $packageType = $packageTypeGateway->getPackageTypesWithIds(array($package->planid));
            $productGroup = $packageType->fetch();

            // We need to decide what type of product we are loading in order to load the correct pricing information
            if ($productGroup->getType() == PACKAGE_TYPE_DOMAIN) {
                //Get pricing from $item for $fromCurrency
                $fromPricing = $package->pricingInformationCurrency[$fromCurrency];

                $packagePricing = $fromPricing;

                if (isset($packagePricing['pricedata'])) {
                    $keys = array_keys($packagePricing['pricedata']);
                } else {
                    $keys = array();
                }

                foreach ($billingcycles as $billingCycleId => $billingCycleData) {
                    if (($billingCycleId === 0 || $billingCycleData['time_unit'] == 'y') && (isset($packagePricing['pricedata'][$keys[0]][$billingCycleId]))) {
                        if (!in_array($fromPricing['pricedata'][$keys[0]][$billingCycleId]['price'], array('', '-1', -1), true)) {
                            //Multiply all values with $exchangeRate
                            $packagePricing['pricedata'][$keys[0]][$billingCycleId]['price']     = round((float)($fromPricing['pricedata'][$keys[0]][$billingCycleId]['price']) * $exchangeRate, 2);
                        }

                        if (!in_array($fromPricing['pricedata'][$keys[0]][$billingCycleId]['transfer'], array('', '-1', -1), true)) {
                            //Multiply all values with $exchangeRate
                            $packagePricing['pricedata'][$keys[0]][$billingCycleId]['transfer']  = round((float)($fromPricing['pricedata'][$keys[0]][$billingCycleId]['transfer']) * $exchangeRate, 2);
                        }

                        if (!in_array($fromPricing['pricedata'][$keys[0]][$billingCycleId]['renew'], array('', '-1', -1), true)) {
                            //Multiply all values with $exchangeRate
                            $packagePricing['pricedata'][$keys[0]][$billingCycleId]['renew']     = round((float)($fromPricing['pricedata'][$keys[0]][$billingCycleId]['renew']) * $exchangeRate, 2);
                        }
                    }
                }
            } else {
                //Get pricing from $item for $fromCurrency
                $fromPricing = $package->pricingInformationCurrency[$fromCurrency];

                $packagePricing = $fromPricing;

                foreach ($billingcycles as $billingCycleId => $billingCycleData) {
                    if (!in_array($fromPricing['price'.$billingCycleId], array('', '-1', -1), true)) {
                        //Multiply all values with $exchangeRate
                        $packagePricing['price'.$billingCycleId] = round((float)($fromPricing['price'.$billingCycleId]) * $exchangeRate, 2);
                    }

                    if ($billingCycleId != 0) {
                        if (!in_array($fromPricing['price'.$billingCycleId.'_setup'], array('', '-1', -1), true)) {
                            //Multiply all values with $exchangeRate
                            $packagePricing['price'.$billingCycleId.'_setup'] = round((float)($fromPricing['price'.$billingCycleId.'_setup']) * $exchangeRate, 2);
                        }
                    }
                }
            }

            if (!in_array($fromPricing['latefee'], array('', '-1', -1), true)) {
                //Multiply all values with $exchangeRate
                $packagePricing['latefee'] = round((float)($fromPricing['latefee']) * $exchangeRate, 2);
            }

            //Save pricing to $item for $toCurrency
            $prices->setPricing(PRODUCT_PRICE, $item, $toCurrency, serialize($packagePricing));

            //If $toCurrency is the default currency, also save it to the main item pricing
            if ($toCurrency == $defaultCurrency) {
                $package->pricing = serialize($packagePricing);
                $package->save();
            }
        } else {
            //Change nothing in the $toCurrency pricing.
            //Not sure if it should be deleting it as the $fromCurrency pricing does not exists.
        }
    }

    function importCurrencyPricesAddon($item, $fromCurrency, $toCurrency, $exchangeRate)
    {
        $defaultCurrency = $this->settings->get('Default Currency');

        $prices = new Prices();

        //Billing Cycles
        $billingcycles = array();
        $gateway = new BillingCycleGateway();
        $iterator = $gateway->getBillingCycles(array(), array('order_value', 'ASC'));

        while ($cycle = $iterator->fetch()) {
            $billingcycles[$cycle->id] = array(
                'name'      => $this->user->lang($cycle->name),
                'time_unit' => $cycle->time_unit
            );
        }
        //Billing Cycles

        $addon = new Addon($item);

        // Load the pricing information per currency
        $addonPricesAllCurrencies = $addon->getPricesAllCurrencies();

        if (isset($addonPricesAllCurrencies[$fromCurrency])) {
            //Get pricing from $item for $toCurrency
            if (isset($addonPricesAllCurrencies[$toCurrency])) {
                $toPricing = $addonPricesAllCurrencies[$toCurrency];
            } else {
                $toPricing = array();
            }

            //Get pricing from $item for $fromCurrency
            foreach ($addonPricesAllCurrencies[$fromCurrency] as $fromPricing) {
                $addonPricing = $fromPricing;

                foreach ($fromPricing as $priceKey => $priceValue) {
                    if (strpos($priceKey, 'price') === false) {
                        unset($addonPricing[$priceKey]);
                    }
                }

                foreach ($billingcycles as $billingCycleId => $billingCycleData) {
                    if (!in_array($fromPricing['price'.$billingCycleId], array('', '-1', -1), true)) {
                        //Multiply all values with $exchangeRate
                        $addonPricing['price'.$billingCycleId] = round((float)($fromPricing['price'.$billingCycleId]) * $exchangeRate, 2);
                    }
                }

                //Save pricing to $item for $toCurrency
                $prices->setPricing(ADDON_PRICE, $fromPricing['id'], $toCurrency, serialize($addonPricing));

                //If $toCurrency is the default currency, also save it to the main item pricing
                if ($toCurrency == $defaultCurrency) {
                    $query = "UPDATE `packageaddon_prices` SET `price` = ? WHERE `id` = ? ";
                    $result = $this->db->query($query, serialize($addonPricing), $fromPricing['id']);
                }

                //Need to update recurring fees
                if (isset($toPricing[$fromPricing['id']])) {
                    foreach ($addonPricing as $priceKey => $priceValue) {
                        //Only for price values
                        if (strpos($priceKey, 'price') !== false && strpos($priceKey, '_force') === false && isset($toPricing[$fromPricing['id']][$priceKey]) && !in_array($toPricing[$fromPricing['id']][$priceKey], array('', '-1', -1), true)) {
                            $cycle = str_replace('price', '', $priceKey);

                            //Update only addon recurring fees of clients using the selected currency
                            //This is also only updating the ones that were matching the old price, so if someone is using a different price, it is not changed.
                            $query = "UPDATE `recurringfee` SET "
                                ."`amount` = IF(`amount` = ".$toPricing[$fromPricing['id']][$priceKey].", ?, `amount`) "
                                ."WHERE `billingtypeid` = ".BILLINGTYPE_PACKAGE_ADDON." "
                                ."AND `packageaddon_prices_id` = ? "
                                ."AND `paymentterm` = ? "
                                ."AND `customerid` IN (SELECT u.`id` FROM `users` u WHERE u.`currency` = ? )";
                            $this->db->query($query, (($priceValue == -1) ? 0 : $priceValue), $fromPricing['id'], $cycle, $toCurrency);
                        }
                    }
                }
            }
        } else {
            //Change nothing in the $toCurrency pricing.
            //Not sure if it should be deleting it as the $fromCurrency pricing does not exists.
        }
    }

    function importCurrencyPricesLatefee($fromCurrency, $toCurrency, $exchangeRate)
    {
        $defaultCurrency = $this->settings->get('Default Currency');

        $prices = new Prices();

        $fromLateFee = '';
        $toLateFee = '';

        //Get pricing for $fromCurrency
        if (!is_null($this->settings->get('plugin_latefee_Default late fee charge'.' ('.$fromCurrency.')'))) {
            $fromLateFee = $this->settings->get('plugin_latefee_Default late fee charge'.' ('.$fromCurrency.')');
        } elseif ($fromCurrency === $defaultCurrency) {
            $fromLateFee = $this->settings->get('plugin_latefee_Default late fee charge');
        }

        //Multiply all values with $exchangeRate
        if (!in_array($fromLateFee, array('', '-1', -1), true)) {
            //Multiply all values with $exchangeRate
            $toLateFee = round((float)($fromLateFee) * $exchangeRate, 2);
        }

        //Save pricing for $toCurrency
        $this->settings->updateValue('plugin_latefee_Default late fee charge'.' ('.$toCurrency.')', $toLateFee, '', true);

        //If $toCurrency is the default currency, also save it to the main item pricing
        if ($toCurrency == $defaultCurrency) {
            $this->settings->updateValue('plugin_latefee_Default late fee charge', $toLateFee, '', true);
        }
    }

    function importCurrencyPricesBillingtype($item, $fromCurrency, $toCurrency, $exchangeRate)
    {
        $defaultCurrency = $this->settings->get('Default Currency');

        $prices = new Prices();

        $billingType = new BillingType($item);

        //Get pricing from $item for $fromCurrency
        $fromPricing = $billingType->getCurrencyPrice($fromCurrency);
        $toPricing = $fromPricing;

        if (!in_array($fromPricing, array('', '-1', -1), true)) {
            //Multiply all values with $exchangeRate
            $toPricing = round((float)($fromPricing) * $exchangeRate, 2);
        }

        //Save pricing to $item for $toCurrency
        $prices->setPricing(BILLING_TYPE_PRICE, $item, $toCurrency, $toPricing);

        //If $toCurrency is the default currency, also save it to the main item pricing
        if ($toCurrency == $defaultCurrency) {
            $billingType->setPrice($toPricing);
            $billingType->update();
        }
    }

    function importCurrencyPricesCoupon($item, $fromCurrency, $toCurrency, $exchangeRate)
    {
        $defaultCurrency = $this->settings->get('Default Currency');

        $prices = new Prices();

        $coupon = new Coupon($item);
        $couponType = ($coupon->type == 1) ? 'percentage' : 'amount';

        //Get pricing from $item for $fromCurrency
        $fromDiscount = $coupon->getCurrencyDiscount($fromCurrency);
        $toDiscount = $fromDiscount;

        if (!in_array($fromDiscount, array('', '-1', -1), true) && $couponType == 'amount') {
            //Multiply all values with $exchangeRate
            $toDiscount = round((float)($fromDiscount) * $exchangeRate, 2);
        }

        //Save pricing to $item for $toCurrency
        $prices->setPricing(COUPON_PRICE, $item, $toCurrency, $toDiscount);

        //If $toCurrency is the default currency, also save it to the main item pricing
        if ($toCurrency == $defaultCurrency) {
            $query = "UPDATE `coupons` SET `coupons_discount` = ? WHERE `coupons_id` = ?";
            $this->db->query($query, $toDiscount, $item);
        }
    }
}