<?php
/**
 * BackupsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * BackupsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BackupsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'backupWebsite' => [
            'application/json',
        ],
        'deleteAllWebsiteBackups' => [
            'application/json',
        ],
        'deleteWebsiteBackup' => [
            'application/json',
        ],
        'getWebsiteBackup' => [
            'application/json',
        ],
        'getWebsiteBackups' => [
            'application/json',
        ],
        'getWebsiteRestoreLog' => [
            'application/json',
        ],
        'getWebsiteRestoreStatus' => [
            'application/json',
        ],
        'listGlobalBackups' => [
            'application/json',
        ],
        'restoreHardDeletedBackup' => [
            'application/json',
        ],
        'restoreWebsite' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation backupWebsite
     *
     * Create a website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool|null $include_emails The boolean flag used to include emails in the backup. (optional, default to false)
     * @param  \OpenAPI\Client\Model\BackupOptions|null $backup_options backup_options (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backupWebsite'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Backup
     */
    public function backupWebsite($org_id, $website_id, $include_emails = false, $backup_options = null, string $contentType = self::contentTypes['backupWebsite'][0])
    {
        list($response) = $this->backupWebsiteWithHttpInfo($org_id, $website_id, $include_emails, $backup_options, $contentType);
        return $response;
    }

    /**
     * Operation backupWebsiteWithHttpInfo
     *
     * Create a website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool|null $include_emails The boolean flag used to include emails in the backup. (optional, default to false)
     * @param  \OpenAPI\Client\Model\BackupOptions|null $backup_options (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backupWebsite'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Backup, HTTP status code, HTTP response headers (array of strings)
     */
    public function backupWebsiteWithHttpInfo($org_id, $website_id, $include_emails = false, $backup_options = null, string $contentType = self::contentTypes['backupWebsite'][0])
    {
        $request = $this->backupWebsiteRequest($org_id, $website_id, $include_emails, $backup_options, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Backup',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Backup',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Backup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation backupWebsiteAsync
     *
     * Create a website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool|null $include_emails The boolean flag used to include emails in the backup. (optional, default to false)
     * @param  \OpenAPI\Client\Model\BackupOptions|null $backup_options (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backupWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function backupWebsiteAsync($org_id, $website_id, $include_emails = false, $backup_options = null, string $contentType = self::contentTypes['backupWebsite'][0])
    {
        return $this->backupWebsiteAsyncWithHttpInfo($org_id, $website_id, $include_emails, $backup_options, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation backupWebsiteAsyncWithHttpInfo
     *
     * Create a website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool|null $include_emails The boolean flag used to include emails in the backup. (optional, default to false)
     * @param  \OpenAPI\Client\Model\BackupOptions|null $backup_options (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backupWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function backupWebsiteAsyncWithHttpInfo($org_id, $website_id, $include_emails = false, $backup_options = null, string $contentType = self::contentTypes['backupWebsite'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Backup';
        $request = $this->backupWebsiteRequest($org_id, $website_id, $include_emails, $backup_options, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'backupWebsite'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  bool|null $include_emails The boolean flag used to include emails in the backup. (optional, default to false)
     * @param  \OpenAPI\Client\Model\BackupOptions|null $backup_options (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['backupWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function backupWebsiteRequest($org_id, $website_id, $include_emails = false, $backup_options = null, string $contentType = self::contentTypes['backupWebsite'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling backupWebsite'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling backupWebsite'
            );
        }




        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_emails,
            'includeEmails', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($backup_options)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($backup_options));
            } else {
                $httpBody = $backup_options;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAllWebsiteBackups
     *
     * Delete all backups for a website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAllWebsiteBackups($server_id, $website_id, string $contentType = self::contentTypes['deleteAllWebsiteBackups'][0])
    {
        $this->deleteAllWebsiteBackupsWithHttpInfo($server_id, $website_id, $contentType);
    }

    /**
     * Operation deleteAllWebsiteBackupsWithHttpInfo
     *
     * Delete all backups for a website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAllWebsiteBackupsWithHttpInfo($server_id, $website_id, string $contentType = self::contentTypes['deleteAllWebsiteBackups'][0])
    {
        $request = $this->deleteAllWebsiteBackupsRequest($server_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteAllWebsiteBackupsAsync
     *
     * Delete all backups for a website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllWebsiteBackupsAsync($server_id, $website_id, string $contentType = self::contentTypes['deleteAllWebsiteBackups'][0])
    {
        return $this->deleteAllWebsiteBackupsAsyncWithHttpInfo($server_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAllWebsiteBackupsAsyncWithHttpInfo
     *
     * Delete all backups for a website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAllWebsiteBackupsAsyncWithHttpInfo($server_id, $website_id, string $contentType = self::contentTypes['deleteAllWebsiteBackups'][0])
    {
        $returnType = '';
        $request = $this->deleteAllWebsiteBackupsRequest($server_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAllWebsiteBackups'
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAllWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAllWebsiteBackupsRequest($server_id, $website_id, string $contentType = self::contentTypes['deleteAllWebsiteBackups'][0])
    {

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling deleteAllWebsiteBackups'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteAllWebsiteBackups'
            );
        }


        $resourcePath = '/backups/{server_id}/{website_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteWebsiteBackup
     *
     * Delete a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteWebsiteBackup($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['deleteWebsiteBackup'][0])
    {
        $this->deleteWebsiteBackupWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $contentType);
    }

    /**
     * Operation deleteWebsiteBackupWithHttpInfo
     *
     * Delete a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWebsiteBackupWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['deleteWebsiteBackup'][0])
    {
        $request = $this->deleteWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteWebsiteBackupAsync
     *
     * Delete a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteBackupAsync($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['deleteWebsiteBackup'][0])
    {
        return $this->deleteWebsiteBackupAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteWebsiteBackupAsyncWithHttpInfo
     *
     * Delete a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteWebsiteBackupAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['deleteWebsiteBackup'][0])
    {
        $returnType = '';
        $request = $this->deleteWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteWebsiteBackup'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['deleteWebsiteBackup'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling deleteWebsiteBackup'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling deleteWebsiteBackup'
            );
        }

        // verify the required parameter 'backup_id' is set
        if ($backup_id === null || (is_array($backup_id) && count($backup_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $backup_id when calling deleteWebsiteBackup'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups/{backup_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $storage_kind,
            'storageKind', // param base name
            'BackupStorageKind', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($backup_id !== null) {
            $resourcePath = str_replace(
                '{' . 'backup_id' . '}',
                ObjectSerializer::toPathValue($backup_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteBackup
     *
     * Get detailed metadata of the website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\BackupDetailed
     */
    public function getWebsiteBackup($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['getWebsiteBackup'][0])
    {
        list($response) = $this->getWebsiteBackupWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteBackupWithHttpInfo
     *
     * Get detailed metadata of the website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\BackupDetailed, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteBackupWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['getWebsiteBackup'][0])
    {
        $request = $this->getWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\BackupDetailed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\BackupDetailed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\BackupDetailed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteBackupAsync
     *
     * Get detailed metadata of the website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteBackupAsync($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['getWebsiteBackup'][0])
    {
        return $this->getWebsiteBackupAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteBackupAsyncWithHttpInfo
     *
     * Get detailed metadata of the website backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteBackupAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['getWebsiteBackup'][0])
    {
        $returnType = '\OpenAPI\Client\Model\BackupDetailed';
        $request = $this->getWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteBackup'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteBackupRequest($org_id, $website_id, $backup_id, $storage_kind = null, string $contentType = self::contentTypes['getWebsiteBackup'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteBackup'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteBackup'
            );
        }

        // verify the required parameter 'backup_id' is set
        if ($backup_id === null || (is_array($backup_id) && count($backup_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $backup_id when calling getWebsiteBackup'
            );
        }



        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups/{backup_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $storage_kind,
            'storageKind', // param base name
            'BackupStorageKind', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($backup_id !== null) {
            $resourcePath = str_replace(
                '{' . 'backup_id' . '}',
                ObjectSerializer::toPathValue($backup_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteBackups
     *
     * Get all website backups metadata
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\BackupsFullListing
     */
    public function getWebsiteBackups($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteBackups'][0])
    {
        list($response) = $this->getWebsiteBackupsWithHttpInfo($org_id, $website_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteBackupsWithHttpInfo
     *
     * Get all website backups metadata
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\BackupsFullListing, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteBackupsWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteBackups'][0])
    {
        $request = $this->getWebsiteBackupsRequest($org_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\BackupsFullListing',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\BackupsFullListing',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\BackupsFullListing',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteBackupsAsync
     *
     * Get all website backups metadata
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteBackupsAsync($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteBackups'][0])
    {
        return $this->getWebsiteBackupsAsyncWithHttpInfo($org_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteBackupsAsyncWithHttpInfo
     *
     * Get all website backups metadata
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteBackupsAsyncWithHttpInfo($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteBackups'][0])
    {
        $returnType = '\OpenAPI\Client\Model\BackupsFullListing';
        $request = $this->getWebsiteBackupsRequest($org_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteBackups'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteBackupsRequest($org_id, $website_id, string $contentType = self::contentTypes['getWebsiteBackups'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteBackups'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteBackups'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteRestoreLog
     *
     * Get the log for an ongoing restore, will return 404 if the restore is already complete
     *
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getWebsiteRestoreLog($website_id, string $contentType = self::contentTypes['getWebsiteRestoreLog'][0])
    {
        list($response) = $this->getWebsiteRestoreLogWithHttpInfo($website_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteRestoreLogWithHttpInfo
     *
     * Get the log for an ongoing restore, will return 404 if the restore is already complete
     *
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreLog'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteRestoreLogWithHttpInfo($website_id, string $contentType = self::contentTypes['getWebsiteRestoreLog'][0])
    {
        $request = $this->getWebsiteRestoreLogRequest($website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string[]',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string[]',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteRestoreLogAsync
     *
     * Get the log for an ongoing restore, will return 404 if the restore is already complete
     *
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteRestoreLogAsync($website_id, string $contentType = self::contentTypes['getWebsiteRestoreLog'][0])
    {
        return $this->getWebsiteRestoreLogAsyncWithHttpInfo($website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteRestoreLogAsyncWithHttpInfo
     *
     * Get the log for an ongoing restore, will return 404 if the restore is already complete
     *
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteRestoreLogAsyncWithHttpInfo($website_id, string $contentType = self::contentTypes['getWebsiteRestoreLog'][0])
    {
        $returnType = 'string[]';
        $request = $this->getWebsiteRestoreLogRequest($website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteRestoreLog'
     *
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreLog'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteRestoreLogRequest($website_id, string $contentType = self::contentTypes['getWebsiteRestoreLog'][0])
    {

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteRestoreLog'
            );
        }


        $resourcePath = '/backups/{website_id}/restore/log';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteRestoreStatus
     *
     * Get the last detailed metadata of the restored website backup.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\RestoreDetailed
     */
    public function getWebsiteRestoreStatus($org_id, $website_id, $backup_id, string $contentType = self::contentTypes['getWebsiteRestoreStatus'][0])
    {
        list($response) = $this->getWebsiteRestoreStatusWithHttpInfo($org_id, $website_id, $backup_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteRestoreStatusWithHttpInfo
     *
     * Get the last detailed metadata of the restored website backup.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreStatus'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\RestoreDetailed, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteRestoreStatusWithHttpInfo($org_id, $website_id, $backup_id, string $contentType = self::contentTypes['getWebsiteRestoreStatus'][0])
    {
        $request = $this->getWebsiteRestoreStatusRequest($org_id, $website_id, $backup_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\RestoreDetailed',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\RestoreDetailed',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\RestoreDetailed',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteRestoreStatusAsync
     *
     * Get the last detailed metadata of the restored website backup.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteRestoreStatusAsync($org_id, $website_id, $backup_id, string $contentType = self::contentTypes['getWebsiteRestoreStatus'][0])
    {
        return $this->getWebsiteRestoreStatusAsyncWithHttpInfo($org_id, $website_id, $backup_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteRestoreStatusAsyncWithHttpInfo
     *
     * Get the last detailed metadata of the restored website backup.
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteRestoreStatusAsyncWithHttpInfo($org_id, $website_id, $backup_id, string $contentType = self::contentTypes['getWebsiteRestoreStatus'][0])
    {
        $returnType = '\OpenAPI\Client\Model\RestoreDetailed';
        $request = $this->getWebsiteRestoreStatusRequest($org_id, $website_id, $backup_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteRestoreStatus'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteRestoreStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteRestoreStatusRequest($org_id, $website_id, $backup_id, string $contentType = self::contentTypes['getWebsiteRestoreStatus'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getWebsiteRestoreStatus'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling getWebsiteRestoreStatus'
            );
        }

        // verify the required parameter 'backup_id' is set
        if ($backup_id === null || (is_array($backup_id) && count($backup_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $backup_id when calling getWebsiteRestoreStatus'
            );
        }


        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups/{backup_id}/restore_status';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($backup_id !== null) {
            $resourcePath = str_replace(
                '{' . 'backup_id' . '}',
                ObjectSerializer::toPathValue($backup_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listGlobalBackups
     *
     * List global website backups across all backup servers, by backup server ID
     *
     * @param  bool|null $show_existing Show global backups belonging to websites that already exist on the cluster (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGlobalBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>
     */
    public function listGlobalBackups($show_existing = null, string $contentType = self::contentTypes['listGlobalBackups'][0])
    {
        list($response) = $this->listGlobalBackupsWithHttpInfo($show_existing, $contentType);
        return $response;
    }

    /**
     * Operation listGlobalBackupsWithHttpInfo
     *
     * List global website backups across all backup servers, by backup server ID
     *
     * @param  bool|null $show_existing Show global backups belonging to websites that already exist on the cluster (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGlobalBackups'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGlobalBackupsWithHttpInfo($show_existing = null, string $contentType = self::contentTypes['listGlobalBackups'][0])
    {
        $request = $this->listGlobalBackupsRequest($show_existing, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation listGlobalBackupsAsync
     *
     * List global website backups across all backup servers, by backup server ID
     *
     * @param  bool|null $show_existing Show global backups belonging to websites that already exist on the cluster (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGlobalBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGlobalBackupsAsync($show_existing = null, string $contentType = self::contentTypes['listGlobalBackups'][0])
    {
        return $this->listGlobalBackupsAsyncWithHttpInfo($show_existing, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listGlobalBackupsAsyncWithHttpInfo
     *
     * List global website backups across all backup servers, by backup server ID
     *
     * @param  bool|null $show_existing Show global backups belonging to websites that already exist on the cluster (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGlobalBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGlobalBackupsAsyncWithHttpInfo($show_existing = null, string $contentType = self::contentTypes['listGlobalBackups'][0])
    {
        $returnType = 'array<string,\OpenAPI\Client\Model\GlobalWebsiteBackup[]>';
        $request = $this->listGlobalBackupsRequest($show_existing, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listGlobalBackups'
     *
     * @param  bool|null $show_existing Show global backups belonging to websites that already exist on the cluster (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGlobalBackups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listGlobalBackupsRequest($show_existing = null, string $contentType = self::contentTypes['listGlobalBackups'][0])
    {



        $resourcePath = '/backups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $show_existing,
            'showExisting', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation restoreHardDeletedBackup
     *
     * Restore a backup of a hard deleted website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreHardDeletedBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function restoreHardDeletedBackup($server_id, $website_id, string $contentType = self::contentTypes['restoreHardDeletedBackup'][0])
    {
        list($response) = $this->restoreHardDeletedBackupWithHttpInfo($server_id, $website_id, $contentType);
        return $response;
    }

    /**
     * Operation restoreHardDeletedBackupWithHttpInfo
     *
     * Restore a backup of a hard deleted website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreHardDeletedBackup'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function restoreHardDeletedBackupWithHttpInfo($server_id, $website_id, string $contentType = self::contentTypes['restoreHardDeletedBackup'][0])
    {
        $request = $this->restoreHardDeletedBackupRequest($server_id, $website_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'string',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'string',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation restoreHardDeletedBackupAsync
     *
     * Restore a backup of a hard deleted website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreHardDeletedBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreHardDeletedBackupAsync($server_id, $website_id, string $contentType = self::contentTypes['restoreHardDeletedBackup'][0])
    {
        return $this->restoreHardDeletedBackupAsyncWithHttpInfo($server_id, $website_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation restoreHardDeletedBackupAsyncWithHttpInfo
     *
     * Restore a backup of a hard deleted website
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreHardDeletedBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreHardDeletedBackupAsyncWithHttpInfo($server_id, $website_id, string $contentType = self::contentTypes['restoreHardDeletedBackup'][0])
    {
        $returnType = 'string';
        $request = $this->restoreHardDeletedBackupRequest($server_id, $website_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'restoreHardDeletedBackup'
     *
     * @param  string $server_id The UUID of the server (required)
     * @param  string $website_id The id of the website. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreHardDeletedBackup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function restoreHardDeletedBackupRequest($server_id, $website_id, string $contentType = self::contentTypes['restoreHardDeletedBackup'][0])
    {

        // verify the required parameter 'server_id' is set
        if ($server_id === null || (is_array($server_id) && count($server_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $server_id when calling restoreHardDeletedBackup'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling restoreHardDeletedBackup'
            );
        }


        $resourcePath = '/backups/{server_id}/{website_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($server_id !== null) {
            $resourcePath = str_replace(
                '{' . 'server_id' . '}',
                ObjectSerializer::toPathValue($server_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation restoreWebsite
     *
     * Restore website from a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  \OpenAPI\Client\Model\BackupRestoreOptions|null $backup_restore_options The options used to define what will be restored from the backup snapshot. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreWebsite'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function restoreWebsite($org_id, $website_id, $backup_id, $storage_kind = null, $backup_restore_options = null, string $contentType = self::contentTypes['restoreWebsite'][0])
    {
        $this->restoreWebsiteWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $backup_restore_options, $contentType);
    }

    /**
     * Operation restoreWebsiteWithHttpInfo
     *
     * Restore website from a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  \OpenAPI\Client\Model\BackupRestoreOptions|null $backup_restore_options The options used to define what will be restored from the backup snapshot. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreWebsite'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function restoreWebsiteWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, $backup_restore_options = null, string $contentType = self::contentTypes['restoreWebsite'][0])
    {
        $request = $this->restoreWebsiteRequest($org_id, $website_id, $backup_id, $storage_kind, $backup_restore_options, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation restoreWebsiteAsync
     *
     * Restore website from a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  \OpenAPI\Client\Model\BackupRestoreOptions|null $backup_restore_options The options used to define what will be restored from the backup snapshot. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreWebsiteAsync($org_id, $website_id, $backup_id, $storage_kind = null, $backup_restore_options = null, string $contentType = self::contentTypes['restoreWebsite'][0])
    {
        return $this->restoreWebsiteAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind, $backup_restore_options, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation restoreWebsiteAsyncWithHttpInfo
     *
     * Restore website from a backup
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  \OpenAPI\Client\Model\BackupRestoreOptions|null $backup_restore_options The options used to define what will be restored from the backup snapshot. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreWebsiteAsyncWithHttpInfo($org_id, $website_id, $backup_id, $storage_kind = null, $backup_restore_options = null, string $contentType = self::contentTypes['restoreWebsite'][0])
    {
        $returnType = '';
        $request = $this->restoreWebsiteRequest($org_id, $website_id, $backup_id, $storage_kind, $backup_restore_options, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'restoreWebsite'
     *
     * @param  string $org_id The id of the organization. (required)
     * @param  string $website_id The id of the website. (required)
     * @param  int $backup_id The id of the backup. (required)
     * @param  \OpenAPI\Client\Model\BackupStorageKind|null $storage_kind The storage kind of the requested backup. (optional)
     * @param  \OpenAPI\Client\Model\BackupRestoreOptions|null $backup_restore_options The options used to define what will be restored from the backup snapshot. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreWebsite'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function restoreWebsiteRequest($org_id, $website_id, $backup_id, $storage_kind = null, $backup_restore_options = null, string $contentType = self::contentTypes['restoreWebsite'][0])
    {

        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling restoreWebsite'
            );
        }

        // verify the required parameter 'website_id' is set
        if ($website_id === null || (is_array($website_id) && count($website_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $website_id when calling restoreWebsite'
            );
        }

        // verify the required parameter 'backup_id' is set
        if ($backup_id === null || (is_array($backup_id) && count($backup_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $backup_id when calling restoreWebsite'
            );
        }




        $resourcePath = '/orgs/{org_id}/websites/{website_id}/backups/{backup_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $storage_kind,
            'storageKind', // param base name
            'BackupStorageKind', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($org_id !== null) {
            $resourcePath = str_replace(
                '{' . 'org_id' . '}',
                ObjectSerializer::toPathValue($org_id),
                $resourcePath
            );
        }
        // path params
        if ($website_id !== null) {
            $resourcePath = str_replace(
                '{' . 'website_id' . '}',
                ObjectSerializer::toPathValue($website_id),
                $resourcePath
            );
        }
        // path params
        if ($backup_id !== null) {
            $resourcePath = str_replace(
                '{' . 'backup_id' . '}',
                ObjectSerializer::toPathValue($backup_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($backup_restore_options)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($backup_restore_options));
            } else {
                $httpBody = $backup_restore_options;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('id0');
        if ($apiKey !== null) {
            
        }
        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
