$(document).ready(function(){
    
    (function($) {
        "use strict";

    
    jQuery.validator.addMethod('answercheck', function (value, element) {
        return this.optional(element) || /^\bcat\b$/.test(value)
    }, "type the correct answer -_-");

    // validate contactForm form
    $(function() {
        $('#contactForm').validate({
            rules: {
                contact_name: {
                    required: true,
                    minlength: 2
                },
                contact_subject: {
                    required: true,
                    minlength: 4
                },
                contact_phone: {
                    required: true,
                    minlength: 5
                },
                contact_email: {
                    required: true,
                    email: true
                },
                contact_message: {
                    required: true
                }
            },
            messages: {
                contact_name: {
                    required: "Please fill in your names",
                    minlength: "Your name must consist of at least 2 characters"
                },
                contact_subject: {
                    required: "Please fill in a subject",
                    minlength: "Your subject must consist of at least 4 characters"
                },
                contact_phone: {
                    required: "Please fill in your phone number",
                    minlength: "Your Number must consist of at least 5 characters"
                },
                contact_email: {
                    required: "Please fill in your email address"
                },
                contact_message: {
                    required: "Uhm... You have to write something to send a message."
                }
            },
            submitHandler: function(form) {
                $(form).ajaxSubmit({
                    type:"POST",
                    data: $(form).serialize(),
                    url:"../Contact Us/contact/index.php",
                    success: function() {
                        $('#contactForm :input').attr('disabled', 'disabled');
                        $('#contactForm').fadeTo( "slow", 1, function() {
                            $(this).find(':input').attr('disabled', 'disabled');
                            $(this).find('label').css('cursor','default');
                            $('#success').fadeIn()
                            $('.modal').modal('hide');
		                	$('#success').modal('show');
                        })
                    },
                    error: function() {
                        $('#contactForm').fadeTo( "slow", 1, function() {
                            $('#error').fadeIn()
                            $('.modal').modal('hide');
		                	$('#error').modal('show');
                        })
                    }
                })
            }
        })
    })
        
 })(jQuery)
})