
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cszcms132`
--

-- --------------------------------------------------------

--
-- Table structure for table `actions_logs`
--

CREATE TABLE `actions_logs` (
  `actions_logs_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_login` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `note` text,
  `url` varchar(255) DEFAULT NULL,
  `actions` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`actions_logs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `article_db`
--

CREATE TABLE `article_db` (
  `article_db_id` int(11) NOT NULL AUTO_INCREMENT,
  `url_rewrite` varchar(255) DEFAULT NULL,
  `is_category` int(11) DEFAULT NULL,
  `category_name` varchar(255) DEFAULT NULL,
  `main_cat_id` int(11) DEFAULT NULL,
  `main_picture` varchar(255) DEFAULT NULL,
  `file_upload` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `short_desc` varchar(255) DEFAULT NULL,
  `content` text,
  `user_admin_id` int(11) DEFAULT NULL,
  `cat_id` int(11) DEFAULT NULL,
  `lang_iso` varchar(10) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `fb_comment_active` int(11) DEFAULT NULL,
  `fb_comment_limit` int(11) DEFAULT NULL,
  `fb_comment_sort` varchar(20) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `user_groups_idS` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`article_db_id`),
  KEY `url_rewrite` (`url_rewrite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `article_db_downloadstat`
--

CREATE TABLE `article_db_downloadstat` (
  `article_db_downloadstat_id` int(11) NOT NULL AUTO_INCREMENT,
  `article_db_id` int(11) DEFAULT NULL,
  `file_upload` varchar(255) DEFAULT NULL,
  `user_admin_id` int(11) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`article_db_downloadstat_id`),
  KEY `article_db_id` (`article_db_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `banner_mgt`
--

CREATE TABLE `banner_mgt` (
  `banner_mgt_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `img_path` varchar(255) DEFAULT NULL,
  `width` int(5) DEFAULT NULL,
  `height` int(5) DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `nofollow` int(11) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `note` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`banner_mgt_id`),
  KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `banner_statistic`
--

CREATE TABLE `banner_statistic` (
  `banner_statistic_id` int(11) NOT NULL AUTO_INCREMENT,
  `banner_mgt_id` int(11) DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`banner_statistic_id`),
  KEY `banner_mgt_id` (`banner_mgt_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `blacklist_ip`
--

CREATE TABLE `blacklist_ip` (
  `blacklist_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) DEFAULT NULL,
  `note` text,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`blacklist_ip_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `carousel_picture`
--

CREATE TABLE `carousel_picture` (
  `carousel_picture_id` int(11) NOT NULL AUTO_INCREMENT,
  `carousel_widget_id` int(11) DEFAULT NULL,
  `file_upload` varchar(255) DEFAULT NULL,
  `photo_url` varchar(512) DEFAULT NULL,
  `caption` varchar(255) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `carousel_type` varchar(255) DEFAULT NULL,
  `youtube_url` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`carousel_picture_id`),
  KEY `carousel_widget_id` (`carousel_widget_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `carousel_picture`
--

INSERT INTO `carousel_picture` VALUES
(1, 1, NULL, 'https://placehold.co/1900x540?text=Slide%20One', 'Caption One', 1, 'multiimages', NULL, '[[regtime]]', '[[regtime]]'),
(2, 1, NULL, 'https://placehold.co/1900x540?text=Slide%20Two', 'Caption Two', 2, 'multiimages', NULL, '[[regtime]]', '[[regtime]]'),
(3, 1, NULL, 'https://placehold.co/1900x540?text=Slide%20Three', 'Caption Three', 3, 'multiimages', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `carousel_widget`
--

CREATE TABLE `carousel_widget` (
  `carousel_widget_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `custom_temp_active` int(11) DEFAULT NULL,
  `custom_template` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`carousel_widget_id`),
  KEY `carousel_widget_id` (`carousel_widget_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `carousel_widget`
--

INSERT INTO `carousel_widget` VALUES
(1, 'Home', 1, 0, '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `ci_sessions`
--

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `timestamp` int(10) unsigned DEFAULT '0',
  `data` blob,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email_logs`
--

CREATE TABLE `email_logs` (
  `email_logs_id` int(11) NOT NULL AUTO_INCREMENT,
  `to_email` varchar(255) DEFAULT NULL,
  `from_email` varchar(255) DEFAULT NULL,
  `from_name` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `email_result` text,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`email_logs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `footer_social`
--

CREATE TABLE `footer_social` (
  `footer_social_id` int(11) NOT NULL AUTO_INCREMENT,
  `social_name` varchar(255) DEFAULT NULL,
  `social_url` varchar(255) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`footer_social_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `footer_social`
--

INSERT INTO `footer_social` VALUES
(1, 'twitter', '', 0, '2016-05-06 15:50:59'),
(2, 'facebook', '', 0, '2016-05-06 15:50:59'),
(3, 'linkedin', '', 0, '2016-05-06 15:50:59'),
(4, 'youtube', '', 0, '2016-05-06 15:50:59'),
(5, 'google', '', 0, '2016-05-06 15:50:59'),
(6, 'pinterest', '', 0, '2016-05-06 15:50:59'),
(7, 'foursquare', '', 0, '2016-05-06 15:50:59'),
(8, 'myspace', '', 0, '2016-05-06 15:50:59'),
(9, 'soundcloud', '', 0, '2016-05-06 15:50:59'),
(10, 'spotify', '', 0, '2016-05-06 15:50:59'),
(11, 'lastfm', '', 0, '2016-05-06 15:50:59'),
(12, 'vimeo', '', 0, '2016-05-06 15:50:59'),
(13, 'dailymotion', '', 0, '2016-05-06 15:50:59'),
(14, 'vine', '', 0, '2016-05-06 15:50:59'),
(15, 'flickr', '', 0, '2016-05-06 15:50:59'),
(16, 'instagram', '', 0, '2016-05-06 15:50:59'),
(17, 'tumblr', '', 0, '2016-05-06 15:50:59'),
(18, 'reddit', '', 0, '2016-05-06 15:50:59'),
(19, 'envato', '', 0, '2016-05-06 15:50:59'),
(20, 'github', '', 0, '2016-05-06 15:50:59'),
(21, 'tripadvisor', '', 0, '2016-05-06 15:50:59'),
(22, 'stackoverflow', '', 0, '2016-05-06 15:50:59'),
(23, 'persona', '', 0, '2016-05-06 15:50:59'),
(24, 'odnoklassniki', '', 0, '2016-05-06 15:50:59'),
(25, 'vk', '', 0, '2016-05-06 15:50:59'),
(26, 'gitlab', '', 0, '2016-05-06 15:50:59');

-- --------------------------------------------------------

--
-- Table structure for table `form_contactus_en`
--

CREATE TABLE `form_contactus_en` (
  `form_contactus_en_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `contact_type` varchar(255) DEFAULT NULL,
  `message` text,
  `ip_address` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`form_contactus_en_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `form_field`
--

CREATE TABLE `form_field` (
  `form_field_id` int(11) NOT NULL AUTO_INCREMENT,
  `form_main_id` int(11) DEFAULT NULL,
  `field_type` varchar(100) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_id` varchar(255) DEFAULT NULL,
  `field_class` varchar(255) DEFAULT NULL,
  `field_placeholder` varchar(255) DEFAULT NULL,
  `field_value` varchar(255) DEFAULT NULL,
  `field_label` varchar(255) DEFAULT NULL,
  `sel_option_val` text,
  `field_required` int(11) DEFAULT NULL,
  `field_div_class` varchar(255) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`form_field_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `form_field`
--

INSERT INTO `form_field` VALUES
(1, 1, 'text', 'name', 'name', 'form-control', '', '', 'Name', '', 1, NULL, 1, '2016-05-02 19:15:50', '2016-05-02 19:15:50'),
(2, 1, 'email', 'email', 'email', 'form-control', '', '', 'Email Address', '', 1, NULL, 2, '2016-05-02 19:15:50', '2016-05-02 19:15:50'),
(3, 1, 'selectbox', 'contact_type', 'contact_type', 'form-control', '-- Choose Type --', '', 'Contact Type', 'question=>Question, contact us=>Contact Us, service=>Service', 1, NULL, 3, '2016-05-02 19:15:50', '2016-05-02 19:15:50'),
(4, 1, 'textarea', 'message', 'message', 'form-control', '', '', 'Message', '', 1, NULL, 4, '2016-05-02 19:15:50', '2016-05-02 19:15:50'),
(5, 1, 'submit', 'submit', 'submit', 'btn btn-primary', '', 'Send now', '', '', 0, NULL, 5, '2016-05-02 19:15:50', '2016-05-02 19:15:50'),
(6, 1, 'reset', 'reset', 'reset', 'btn btn-default', '', 'Reset', '', '', 0, NULL, 6, '2016-05-02 19:15:50', '2016-05-02 19:15:50');

-- --------------------------------------------------------

--
-- Table structure for table `form_main`
--

CREATE TABLE `form_main` (
  `form_main_id` int(11) NOT NULL AUTO_INCREMENT,
  `form_name` varchar(255) DEFAULT NULL,
  `form_enctype` varchar(255) DEFAULT NULL,
  `form_method` varchar(255) DEFAULT NULL,
  `success_txt` varchar(255) DEFAULT NULL,
  `captchaerror_txt` varchar(255) DEFAULT NULL,
  `error_txt` varchar(255) DEFAULT NULL,
  `sendmail` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `send_to_visitor` int(11) DEFAULT NULL,
  `email_field_id` int(11) DEFAULT NULL,
  `visitor_subject` varchar(255) DEFAULT NULL,
  `visitor_body` text,
  `active` int(11) DEFAULT NULL,
  `captcha` int(11) DEFAULT NULL,
  `save_to_db` int(11) DEFAULT NULL,
  `dont_repeat_field` varchar(255) DEFAULT NULL,
  `repeat_txt` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`form_main_id`),
  KEY `form_name` (`form_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `form_main`
--

INSERT INTO `form_main` VALUES
(1, 'contactus_en', '', 'post', 'Successfully!', 'The Security Check was not input correctly. Please try again.', 'Error! Please try again.', 1, '', 'Contact us from the CSZ-CMS website', 0, 0, '', '', 1, 1, 1, '', 'Your data is duplicated in the system.', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `gallery_config`
--

CREATE TABLE `gallery_config` (
  `gallery_config_id` int(11) NOT NULL AUTO_INCREMENT,
  `gallery_sort` varchar(255) DEFAULT NULL,
  `user_admin_id` int(11) DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`gallery_config_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `gallery_config`
--

INSERT INTO `gallery_config` VALUES
(1, 'manually', 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `gallery_db`
--

CREATE TABLE `gallery_db` (
  `gallery_db_id` int(11) NOT NULL AUTO_INCREMENT,
  `album_name` varchar(255) DEFAULT NULL,
  `url_rewrite` varchar(255) DEFAULT NULL,
  `keyword` varchar(255) DEFAULT NULL,
  `short_desc` text,
  `lang_iso` varchar(10) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `user_groups_idS` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`gallery_db_id`),
  KEY `url_rewrite` (`url_rewrite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gallery_picture`
--

CREATE TABLE `gallery_picture` (
  `gallery_picture_id` int(11) NOT NULL AUTO_INCREMENT,
  `gallery_db_id` int(11) DEFAULT NULL,
  `file_upload` varchar(255) DEFAULT NULL,
  `caption` varchar(255) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `gallery_type` varchar(255) DEFAULT NULL,
  `youtube_url` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`gallery_picture_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `general_label`
--

CREATE TABLE `general_label` (
  `general_label_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `remark` text,
  `lang_en` text,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`general_label_id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=87 ;

--
-- Dumping data for table `general_label`
--

INSERT INTO `general_label` VALUES
(1, 'login_heading', 'For member login Header text', 'Member Login', '2016-07-04 11:43:18'),
(2, 'login_incorrect', 'For member login incorrect', 'Email address/Password is incorrect', '2016-07-04 11:44:09'),
(3, 'captcha_wrong', 'For member login when wrong captcha', 'The Security Check was not input correctly. Please try again.', '2016-07-04 11:44:39'),
(4, 'login_email', 'For email address label', 'Email Address', '2016-06-23 23:34:45'),
(5, 'login_password', 'For password label', 'Your Password', '2016-06-23 23:35:22'),
(6, 'login_signin', 'For member login button', 'Log in', '2016-06-23 23:35:53'),
(7, 'login_forgetpwd', 'For member forget password button', 'Forgot Password', '2016-06-23 23:37:02'),
(8, 'login_register', 'For member register label', 'Register', '2016-06-24 16:41:07'),
(9, 'member_firstname', 'For member firstname label', 'First Name', '2016-06-24 16:58:09'),
(10, 'member_lastname', 'For member lastname label', 'Last Name', '2016-06-24 16:58:09'),
(11, 'member_address', 'For member address label', 'Address', '2016-06-24 16:58:09'),
(12, 'confirm_password', 'For confirm password label', 'Confirm Password', '2016-06-24 16:58:09'),
(13, 'member_forgot_complete', 'For forget password is successfully', 'Successfully! Your password has been reset', '2016-06-24 16:58:09'),
(14, 'member_reset_btn', 'For reset button', 'Reset', '2016-06-24 17:48:32'),
(15, 'member_forget_chkmail', 'For reset text email to inbox', 'Please check your email inbox and click the link to continue the process.', '2016-06-24 17:48:32'),
(16, 'email_reset_subject', 'For email subject when member forget password', 'Reset your member password', '2016-06-26 15:43:39'),
(17, 'email_reset_message', 'For email message when member forget password', 'Please click the link within 30 minutes to reset your password.', '2016-06-26 15:43:39'),
(18, 'email_dear', 'For email header', 'Dear ', '2016-06-26 15:43:39'),
(19, 'email_footer', 'For email footer', 'Regards,', '2016-06-26 15:43:39'),
(20, 'email_check', 'For email does not exist text', 'This email address does not exist', '2016-06-26 15:47:01'),
(21, 'btn_cancel', 'For cancel button', 'Cancel', '2016-06-26 15:52:28'),
(22, 'btn_back', 'For back button', 'Back', '2016-06-26 15:53:59'),
(23, 'email_already', 'For email has already', 'This email address has already', '2016-06-26 21:31:20'),
(24, 'email_confirm_subject', 'For email confirm subject text', 'Confirm your member register', '2016-06-27 18:00:10'),
(25, 'email_confirm_message', 'For email confirm message', 'Please click the link within 30 minutes to confirm your member.', '2016-06-28 10:28:20'),
(26, 'log_out', 'For log out text', 'Log out', '2016-07-01 16:25:24'),
(27, 'backend_system', 'For back-end system text', 'Admin System', '2016-07-01 16:25:24'),
(28, 'edit_profile', 'For edit profile text', 'Edit Profile', '2016-07-01 16:25:24'),
(29, 'member_dashboard_text', 'For member dashboard text', 'Welcome to Member Dashboard!', '2016-07-01 16:25:24'),
(30, 'your_profile', 'For your profile text', 'Your Profile', '2016-07-01 16:29:30'),
(31, 'member_menu', 'For member menu text', 'Member Menu', '2016-07-01 16:37:37'),
(32, 'display_name', 'For display name text', 'Display Name', '2016-07-01 16:45:41'),
(33, 'email_address', 'For email address text', 'Email Address', '2016-07-01 16:45:41'),
(34, 'user_type', 'For permission type text', 'Permission Type', '2016-07-01 16:45:41'),
(35, 'first_name', 'For first name text', 'First Name', '2016-07-01 16:45:41'),
(36, 'last_name', 'For last name text', 'Last Name', '2016-07-01 16:45:41'),
(37, 'birthday', 'For birthday text', 'Birth Day', '2016-07-01 16:45:41'),
(38, 'gender', 'For gender text', 'Gender', '2016-07-01 16:45:41'),
(39, 'phone', 'For phone text', 'Phone', '2016-07-01 16:45:41'),
(40, 'address', 'For address text', 'Address', '2016-07-01 16:45:41'),
(41, 'new_password', 'For new password text', 'New Password', '2016-07-02 18:01:57'),
(42, 'change_password', 'For change password text', 'Change Password', '2016-07-02 18:04:49'),
(43, 'picture', 'For picture text', 'Picture', '2016-07-02 18:18:58'),
(44, 'save_btn', 'For save button text', 'Save', '2016-07-02 18:35:11'),
(45, 'cancel_btn', 'For cancel button text', 'Cancel', '2016-07-02 18:35:11'),
(46, 'article_index_header', 'For article index page', 'List of Article', '2016-07-12 17:08:16'),
(47, 'article_category_menu', 'For category of article text', 'Category', '2016-07-12 17:23:40'),
(48, 'article_readmore_text', 'For read more button of article text', 'Read More', '2016-07-12 17:23:40'),
(49, 'article_not_found', 'For article not found text', 'Article not found!', '2016-07-12 17:33:20'),
(50, 'article_cat_not_found', 'For category of article not found text', 'Category not found!', '2016-07-12 17:54:29'),
(51, 'article_postdate', 'For date time of article text', 'Posted date', '2016-07-13 13:56:02'),
(52, 'article_postby', 'For post by text', 'Posted by', '2016-07-13 13:56:02'),
(53, 'gallery_header', 'For gallery header text', 'Gallery', '2016-07-15 13:47:17'),
(54, 'gallery_albumlist', 'For album list text', 'List of Album', '2016-07-15 13:47:17'),
(55, 'total_txt', 'For total text', 'Total:', '2016-07-15 15:24:11'),
(56, 'records_txt', 'For records text', 'Records', '2016-07-15 15:23:54'),
(57, 'gallery_not_found', 'for gallery not found text', 'Gallery not found!', '2016-07-15 15:33:35'),
(58, 'picture_not_found', 'For picture not found text', 'Picture not found!', '2016-07-15 15:35:40'),
(59, 'gellery_view_btn', 'For gallery view button', 'View Gallery', '2016-07-15 15:41:19'),
(60, 'article_archive', 'For article archive text', 'Archive', '2016-07-21 10:39:19'),
(61, 'article_updatedate', 'For article updatetime text', 'Updated date', '2016-07-21 10:39:19'),
(62, 'article_search_txt', 'For article search text', 'Article Search', '2016-09-26 10:53:09'),
(63, 'pm_txt', 'For private message header text', 'Private Message', '2017-02-27 10:53:09'),
(64, 'pm_to_txt', 'For private message (To) text', 'To', '2017-02-27 10:53:09'),
(65, 'pm_from_txt', 'For private message (From) text', 'From', '2017-02-27 10:53:09'),
(66, 'pm_subject_txt', 'For private message subject text', 'Subject', '2017-02-27 10:53:09'),
(67, 'pm_msg_txt', 'For private message text', 'Message', '2017-02-27 10:53:09'),
(68, 'pm_send_txt', 'For private message send text', 'Send', '2017-02-27 10:53:09'),
(69, 'pm_delete_txt', 'For private message delete text', 'Delete', '2017-02-27 10:53:09'),
(70, 'pm_inbox_txt', 'For private message inbox text', 'Inbox', '2017-02-27 10:53:09'),
(71, 'pm_newmsg_txt', 'For private message new message text', 'New Message', '2017-02-27 10:53:09'),
(72, 'users_list_txt', 'For users list text', 'Users List', '2017-02-28 10:53:09'),
(73, 'pm_datetime_txt', 'For date time text', 'Date/Time', '2017-02-28 10:53:09'),
(74, 'not_permission_txt', 'For not have permission text', 'You might not have permission to access this section!', '2017-02-28 10:53:09'),
(75, 'success_txt', 'For success text', 'Successfully!', '2017-03-02 10:53:09'),
(76, 'error_txt', 'For error text', 'Data not found! / Error! Please try again.', '2017-03-02 10:53:09'),
(77, 'plugin_member_menu', 'For plugin member menu text', 'Plugins Menu', '2017-03-02 10:53:09'),
(78, 'article_filedownload_text', 'For file download label', 'File Download', '[[regtime]]'),
(79, 'article_download_link', 'For download label', 'Download', '[[regtime]]'),
(80, 'form_doublesubmit_alert', 'For form double submit alert text', 'The form is being submitted, please wait a moment...', '[[regtime]]'),
(81, 'form_submiting_btn', 'For form button been submitting text', 'Processing, Please wait...', '[[regtime]]'),
(82, 'site_error_404_title', 'For page not found error 404 title', 'Error 404, The requested page not Found!', '[[regtime]]'),
(83, 'site_error_404_text', 'For page not found error 404 text', 'Sorry! The page is broken or the page has been moved. Please back to home page.', '[[regtime]]'),
(84, 'site_maintenance_title', 'For site maintenance title', 'Maintenance!', '[[regtime]]'),
(85, 'site_maintenance_subtitle', 'For site maintenance sub title', 'We are undergoing a bit of scheduled maintenance.', '[[regtime]]'),
(86, 'site_maintenance_text', 'For site maintenance body text', 'Sorry for the inconvenience and will be back online shortly. Please check back soon.', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `lang_iso`
--

CREATE TABLE `lang_iso` (
  `lang_iso_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(255) DEFAULT NULL,
  `lang_iso` varchar(10) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `country_iso` varchar(10) DEFAULT NULL,
  `active` int(2) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`lang_iso_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Language ISO' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `lang_iso`
--

INSERT INTO `lang_iso` VALUES
(1, 'English', 'en', 'United Kingdom', 'gb', 1, 1, '2016-03-29 15:16:23', '2016-03-31 15:28:58');

-- --------------------------------------------------------

--
-- Table structure for table `link_statistic`
--

CREATE TABLE `link_statistic` (
  `link_statistic_id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(255) DEFAULT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`link_statistic_id`),
  KEY `link` (`link`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `link_stat_mgt`
--

CREATE TABLE `link_stat_mgt` (
  `link_stat_mgt_id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`link_stat_mgt_id`),
  KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `login_logs`
--

CREATE TABLE `login_logs` (
  `login_logs_id` int(11) NOT NULL AUTO_INCREMENT,
  `email_login` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `note` text,
  `result` varchar(255) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`login_logs_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `login_security_config`
--

CREATE TABLE `login_security_config` (
  `login_security_config_id` int(11) NOT NULL AUTO_INCREMENT,
  `bf_protect_period` int(11) DEFAULT NULL,
  `max_failure` int(11) DEFAULT NULL,
  `bf_private_key` varchar(255) DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`login_security_config_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `login_security_config`
--

INSERT INTO `login_security_config` VALUES
(1, 60, 20, '', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `pages_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(255) DEFAULT NULL,
  `page_url` varchar(255) DEFAULT NULL,
  `lang_iso` varchar(10) DEFAULT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `page_keywords` varchar(255) DEFAULT NULL,
  `page_desc` text,
  `content` text,
  `more_metatag` text,
  `custom_css` text,
  `custom_js` text,
  `user_groups_idS` text,
  `active` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `page_url` (`page_url`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES
(1, 'Home', 'home', 'en', 'CSZ Home', 'CMS, Contact Management System, HTML, CSS, JS, JavaScript, framework, bootstrap, web development, thai, english, homepage', 'CSKAZA Template for Bootstrap with CSZ-CMS', '<header>[?]{=carousel:1}[?]</header><!-- Start Jumbotron -->\r\n<div class="jumbotron">\r\n<div class="container">\r\n<h1>Hello, world!</h1>\r\n<p>This is a template for a simple marketing or informational website. It includes a large callout called a jumbotron and three supporting pieces of content. Use it as a starting point to create something more unique.</p>\r\n<p><a class="btn btn-primary btn-lg" href="#" role="button">Learn more »</a></p>\r\n</div>\r\n</div>\r\n<div class="container">\r\n<div class="row">\r\n<div class="col-md-4">\r\n<h2>Heading</h2>\r\n<p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.</p>\r\n<p><a class="btn btn-default" href="#" role="button">View details »</a></p>\r\n</div>\r\n<div class="col-md-4">\r\n<h2>Heading</h2>\r\n<p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.</p>\r\n<p><a class="btn btn-default" href="#" role="button">View details »</a></p>\r\n</div>\r\n<div class="col-md-4">\r\n<h2>Heading</h2>\r\n<p>Donec sed odio dui. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vestibulum id ligula porta felis euismod semper. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</p>\r\n<p><a class="btn btn-default" href="#" role="button">View details »</a></p>\r\n</div>\r\n</div>\r\n</div>\r\n', NULL, '', '', NULL, 1, '2016-03-08 10:12:56', '2016-05-09 11:00:51'),
(2, 'Abouts Us', 'abouts-us', 'en', 'CSZ-CMS About Us', 'CMS, Contact Management System, HTML, CSS, JS, JavaScript, framework, bootstrap, web development, thai, aboutus', 'CSKAZA Template for Bootstrap with CSZ-CMS', '<div class="jumbotron">\r\n<div class="container">\r\n<h1>About Us!</h1>\r\n<p>CSKAZA Template for Bootstrap with CSZ-CMS. CSZ-CMS build by CSKAZA.</p>\r\n<p><a class="btn btn-primary btn-lg" href="#" role="button">Learn more »</a></p>\r\n</div>\r\n</div>\r\n<div class="container">\r\n<div class="row">\r\n<div class="col-md-6">\r\n<div class="panel panel-default">\r\n<div class="panel-heading">Panel heading</div>\r\n<div class="panel-body">\r\n<p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="col-md-6">\r\n<div class="panel panel-default">\r\n<div class="panel-heading">Panel heading</div>\r\n<div class="panel-body">\r\n<p>Donec id elit non mi porta gravida at eget metus. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus. Etiam porta sem malesuada magna mollis euismod. Donec sed odio dui.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class="container"></div>\r\n<p></p>', NULL, '', '', NULL, 1, '2016-04-11 15:17:18', '2016-05-01 15:16:13'),
(3, 'Contact Us', 'contact-us', 'en', 'CSZ-CMS Contact us', 'CMS, Contact Management System, HTML, CSS, JS, JavaScript, framework, bootstrap, web development, thai, contact us', 'CSKAZA Template for Bootstrap with CSZ-CMS', '<div class="jumbotron">\r\n<div class="container">\r\n<h1>Contact us!</h1>\r\n<p>If you want to contact us please use this form below. Or send the email to <a href="mailto:info@cszcms.com">info[at]cszcms.com</a></p>\r\n</div>\r\n</div>\r\n<div class="container"></div>\r\n<div class="container">\r\n<div class="row">\r\n<div class="col-md-6">\r\n<h2>Google Map</h2>\r\n<p><iframe width="100%" height="315" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3952.168282092751!2d98.37285931425068!3d7.877454308128998!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0:0x0!2zN8KwNTInMzguOCJOIDk4wrAyMiczMC4yIkU!5e0!3m2!1sen!2sth!4v1462104596003" frameborder="0" allowfullscreen="allowfullscreen"></iframe></p>\r\n</div>\r\n<div class="col-md-6">\r\n<h2>Contact Form</h2>\r\n<p>If you have any question please send this from.</p>\r\n<p>[?]{=forms:contactus_en}[?]</p>\r\n</div>\r\n</div>\r\n</div>\r\n<p></p>\r\n<p></p>', NULL, '', '', NULL, 1, '2016-04-30 16:57:16', '2016-05-12 17:59:41');

-- --------------------------------------------------------

--
-- Table structure for table `page_menu`
--

CREATE TABLE `page_menu` (
  `page_menu_id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(255) DEFAULT NULL,
  `lang_iso` varchar(10) DEFAULT NULL,
  `pages_id` int(11) DEFAULT NULL,
  `other_link` varchar(512) DEFAULT NULL,
  `plugin_menu` varchar(255) DEFAULT NULL,
  `drop_menu` int(11) DEFAULT NULL,
  `drop_page_menu_id` int(11) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `new_windows` int(11) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `arrange` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`page_menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `page_menu`
--

INSERT INTO `page_menu` VALUES
(1, 'Home', 'en', 1, '', '', 0, 0, 0, 0, 1, 1, '2016-03-25 13:00:08', '2016-04-30 16:58:07'),
(2, 'Abouts Us', 'en', 2, '', '', 0, 0, 0, 0, 1, 2, '2016-04-11 15:01:03', '2016-04-30 16:58:07'),
(3, 'Contact Us', 'en', 3, '', '', 0, 0, 0, 0, 1, 3, '2016-04-30 16:58:02', '2016-04-30 16:58:07'),
(4, 'Drop Menu', 'en', 0, '', '', 1, 0, 0, 0, 1, 4, '2016-03-27 15:54:15', '2016-04-30 16:58:07'),
(5, 'CSZ CMS Website', 'en', 0, 'https://www.cszcms.com', '', 0, 4, 0, 1, 1, 1, '2016-03-28 15:22:12', '2016-04-30 16:58:07');

-- --------------------------------------------------------

--
-- Table structure for table `plugin_manager`
--

CREATE TABLE `plugin_manager` (
  `plugin_manager_id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_config_filename` varchar(255) DEFAULT NULL,
  `plugin_active` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`plugin_manager_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `plugin_manager`
--

INSERT INTO `plugin_manager` VALUES
(1, 'article', 1, '[[regtime]]', '[[regtime]]'),
(2, 'gallery', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `plugin_widget`
--

CREATE TABLE `plugin_widget` (
  `plugin_widget_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `plugin_filename` varchar(255) DEFAULT NULL,
  `sort_by` varchar(255) DEFAULT NULL,
  `order_by` varchar(10) DEFAULT NULL,
  `data_limit` int(11) DEFAULT NULL,
  `view_id` int(11) DEFAULT NULL,
  `template_code` text,
  `lang_iso` varchar(10) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`plugin_widget_id`),
  KEY `plugin_widget_id` (`plugin_widget_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `save_formdraft`
--

CREATE TABLE `save_formdraft` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_url` text,
  `submit_array` text,
  `user_admin_id` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `settings_id` int(11) NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) DEFAULT NULL,
  `site_logo` varchar(255) DEFAULT NULL,
  `og_image` varchar(255) DEFAULT NULL,
  `fbapp_id` varchar(255) DEFAULT NULL,
  `site_footer` text,
  `default_email` varchar(255) DEFAULT NULL,
  `keywords` text,
  `themes_config` varchar(255) DEFAULT NULL,
  `admin_lang` varchar(255) DEFAULT NULL,
  `additional_js` text,
  `additional_metatag` text,
  `googlecapt_active` int(11) DEFAULT NULL,
  `googlecapt_version` varchar(20) NOT NULL DEFAULT 'v2',
  `googlecapt_sitekey` varchar(255) DEFAULT NULL,
  `googlecapt_secretkey` varchar(255) DEFAULT NULL,
  `pagecache_time` int(3) DEFAULT NULL,
  `email_protocal` varchar(20) DEFAULT NULL,
  `smtp_host` varchar(255) DEFAULT NULL,
  `smtp_user` varchar(255) DEFAULT NULL,
  `smtp_pass` varchar(255) DEFAULT NULL,
  `smtp_port` varchar(5) DEFAULT NULL,
  `sendmail_path` varchar(255) DEFAULT NULL,
  `member_confirm_enable` int(11) DEFAULT NULL,
  `member_close_regist` int(11) DEFAULT NULL,
  `gmaps_key` varchar(255) DEFAULT NULL,
  `gmaps_lat` varchar(100) DEFAULT NULL,
  `gmaps_lng` varchar(100) DEFAULT NULL,
  `ga_client_id` varchar(255) DEFAULT NULL,
  `ga_view_id` varchar(255) DEFAULT NULL,
  `gsearch_active` int(11) DEFAULT NULL,
  `gsearch_cxid` varchar(255) DEFAULT NULL,
  `maintenance_active` int(11) DEFAULT NULL,
  `html_optimize_disable` int(11) DEFAULT NULL,
  `adobe_cc_apikey` varchar(255) DEFAULT NULL,
  `facebook_page_id` varchar(255) DEFAULT NULL,
  `assets_static_active` int(11) DEFAULT NULL,
  `assets_static_domain` varchar(255) DEFAULT NULL,
  `fb_messenger` int(11) DEFAULT NULL,
  `email_logs` int(11) DEFAULT NULL,
  `title_setting` int(11) DEFAULT NULL,
  `cookieinfo_active` int(11) DEFAULT NULL,
  `cookieinfo_bg` varchar(7) DEFAULT NULL,
  `cookieinfo_fg` varchar(7) DEFAULT NULL,
  `cookieinfo_link` varchar(7) DEFAULT NULL,
  `cookieinfo_msg` varchar(255) DEFAULT NULL,
  `cookieinfo_linkmsg` varchar(100) DEFAULT NULL,
  `cookieinfo_moreinfo` varchar(255) DEFAULT NULL,
  `cookieinfo_txtalign` varchar(30) DEFAULT NULL,
  `cookieinfo_close` varchar(100) DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`settings_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` VALUES
(1, 'CSZ CMS Starter', '', '', '', '&copy; %Y% CSZ CMS Starter', '[[admin_email]]', 'CMS, Contact Management System, HTML, CSS, JS, JavaScript, framework, bootstrap, web development, thai, english', 'cszdefault', 'english', '', '', 0, 'v2', '', '', 0, '', '', '', '', '', '', 0, 0, '', '', '', '', '', 0, '', 0, 1, NULL, NULL, NULL, NULL, NULL, 1, 2, 0, '#645862', '#FFFFFF', '#F1D600', 'This website uses cookies to improve your user experience. By continuing to browse our site you accepted and agreed on our ', 'Privacy Policy and terms.', 'https://www.cszcms.com/LICENSE.md', 'left', 'Got it!', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `upload_file`
--

CREATE TABLE `upload_file` (
  `upload_file_id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(10) DEFAULT NULL,
  `file_upload` varchar(255) DEFAULT NULL,
  `remark` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`upload_file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_admin`
--

CREATE TABLE `user_admin` (
  `user_admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `user_type` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `address` text,
  `phone` varchar(100) DEFAULT NULL,
  `picture` varchar(255) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `md5_hash` varchar(255) DEFAULT NULL,
  `md5_lasttime` datetime DEFAULT NULL,
  `pm_sendmail` int(11) DEFAULT NULL,
  `timestamp_login` datetime DEFAULT NULL,
  `pass_change` int(11) DEFAULT NULL,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`user_admin_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_admin`
--

INSERT INTO `user_admin` VALUES
(1, 'Admin User', '[[admin_email]]', '[[admin_pass]]', 'admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, '[[md5_hash]]', '[[regtime]]', 1, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `user_groups_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `definition` text,
  PRIMARY KEY (`user_groups_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `user_groups`
--

INSERT INTO `user_groups` VALUES
(1, 'Admin', 'Super Admin Group'),
(2, 'Editor', 'Editor Access Group'),
(3, 'Public', 'Public Access Group'),
(4, 'Guest', 'Guest Access Group');

-- --------------------------------------------------------

--
-- Table structure for table `user_perms`
--

CREATE TABLE `user_perms` (
  `user_perms_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `definition` text,
  `permstype` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`user_perms_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- Dumping data for table `user_perms`
--

INSERT INTO `user_perms` VALUES
(1, 'save', 'For save permission on backend', 'backend'),
(2, 'delete', 'For delete permission on backend', 'backend'),
(3, 'analytics', 'For analytics access permission on backend', 'backend'),
(4, 'forms builder', 'For forms builder access permission', 'backend'),
(5, 'plugin widget', 'For plugin widget access permission on backend', 'backend'),
(6, 'file upload', 'For file upload access permission on backend', 'backend'),
(7, 'pages content', 'For pages content access permission on backend', 'backend'),
(8, 'navigation', 'For navigation access permission on backend', 'backend'),
(9, 'linkstats', 'For statistic for links access permission on backend', 'backend'),
(10, 'language', 'For language access permission on backend', 'backend'),
(11, 'general label', 'For general label access permission on backend', 'backend'),
(12, 'site settings', 'For site settings access permission on backend', 'backend'),
(13, 'maintenance', 'For maintenance system access permission on backend', 'backend'),
(14, 'plugin manager', 'For plugin manager access permission on backend', 'backend'),
(15, 'admin users', 'For admin users access permission on backend', 'backend'),
(16, 'member users', 'For member users access permission on backend', 'backend'),
(17, 'user groups', 'For user groups access permission on backend', 'backend'),
(18, 'email logs', 'For email logs access permission on backend', 'backend'),
(19, 'login logs', 'For login logs access permission on backend', 'backend'),
(20, 'protection settings', 'For protection settings access permission on backend', 'backend'),
(21, 'gallery', 'For gallery plugin access permission on backend', 'backend'),
(22, 'article', 'For article plugin access permission on backend', 'backend'),
(23, 'social', 'For social settings access permission on backend', 'backend'),
(24, 'profile save', 'For user profile save permission on frontend', 'frontend'),
(25, 'pm', 'For private message access permission on frontend', 'frontend'),
(26, 'banner', 'For banner manager access permission on backend', 'backend'),
(27, 'file manager', 'For file manager access permission on backend', 'backend'),
(28, 'pages cssjs additional', 'For pages content css js metatag additional access permission on backend', 'backend'),
(29, 'export', 'For Import Export CSV access permission on backend', 'backend'),
(30, 'pm', 'For PM access permission on backend', 'backend'),
(31, 'carousel', 'For carousel access permission on backend', 'backend'),
(32, 'old plugin widget', 'For old plugin widget access permission on backend', 'backend'),
(33, 'server info', 'For server information access permission on backend', 'backend');

-- --------------------------------------------------------

--
-- Table structure for table `user_perm_to_group`
--

CREATE TABLE `user_perm_to_group` (
  `user_perms_id` int(11) NOT NULL,
  `user_groups_id` int(11) NOT NULL,
  PRIMARY KEY (`user_perms_id`,`user_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_perm_to_group`
--

INSERT INTO `user_perm_to_group` VALUES
(1, 2),
(3, 2),
(3, 4),
(4, 2),
(4, 4),
(5, 2),
(5, 4),
(6, 2),
(6, 4),
(7, 2),
(7, 4),
(8, 2),
(8, 4),
(9, 2),
(9, 4),
(10, 2),
(10, 4),
(11, 2),
(11, 4),
(12, 4),
(13, 2),
(13, 4),
(14, 4),
(21, 2),
(21, 4),
(22, 2),
(22, 4),
(23, 2),
(23, 4),
(24, 2),
(24, 3),
(25, 2),
(25, 3),
(25, 4),
(26, 2),
(26, 4),
(27, 2),
(30, 2),
(31, 2);

-- --------------------------------------------------------

--
-- Table structure for table `user_pms`
--

CREATE TABLE `user_pms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` int(11) DEFAULT NULL,
  `receiver_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `message` text,
  `date_sent` datetime DEFAULT NULL,
  `date_read` datetime DEFAULT NULL,
  `pm_deleted_sender` int(1) DEFAULT NULL,
  `pm_deleted_receiver` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `full_index` (`id`,`sender_id`,`receiver_id`,`date_read`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_to_group`
--

CREATE TABLE `user_to_group` (
  `user_admin_id` int(11) NOT NULL,
  `user_groups_id` int(11) NOT NULL,
  PRIMARY KEY (`user_admin_id`,`user_groups_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user_to_group`
--

INSERT INTO `user_to_group` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `whitelist_ip`
--

CREATE TABLE `whitelist_ip` (
  `whitelist_ip_id` int(11) NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(255) DEFAULT NULL,
  `note` text,
  `timestamp_create` datetime DEFAULT NULL,
  PRIMARY KEY (`whitelist_ip_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `widget_xml`
--

CREATE TABLE `widget_xml` (
  `widget_xml_id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_name` varchar(255) DEFAULT NULL,
  `xml_url` varchar(255) DEFAULT NULL,
  `limit_view` int(11) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `widget_open` text,
  `widget_content` text,
  `widget_seemore` text,
  `widget_close` text,
  `timestamp_create` datetime DEFAULT NULL,
  `timestamp_update` datetime DEFAULT NULL,
  PRIMARY KEY (`widget_xml_id`),
  KEY `widget_name` (`widget_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
