/*
@license

dhtmlxSuite v.9.2.7 GPL

This software is covered by GPL license.
To use it in non-GPL project, you need obtain Commercial or Enterprise license
Please contact sales@dhtmlx.com. Usage without proper license is prohibited.
(c) XB Software.

*/
if (window.dhx){ window.dhx_legacy = dhx; delete window.dhx; }(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dhx"] = factory();
	else
		root["dhx"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/codebase/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 120);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.getViewHeight = exports.setTheme = exports.awaitRedraw = exports.resizeHandler = exports.resizer = exports.disableHelp = exports.KEYED_LIST = exports.inject = exports.create = exports.view = exports.sv = exports.el = void 0;
var dom = __webpack_require__(133);
var html_1 = __webpack_require__(2);
exports.el = dom.defineElement;
exports.sv = dom.defineSvgElement;
exports.view = dom.defineView;
exports.create = dom.createView;
exports.inject = dom.injectView;
exports.KEYED_LIST = dom.KEYED_LIST;
function disableHelp() {
    dom.DEVMODE.mutations = false;
    dom.DEVMODE.warnings = false;
    dom.DEVMODE.verbose = false;
    dom.DEVMODE.UNKEYED_INPUT = false;
}
exports.disableHelp = disableHelp;
function resizer(handler) {
    var resize = window.ResizeObserver;
    var activeHandler = function (node) {
        var height = node.el.offsetHeight;
        var width = node.el.offsetWidth;
        handler(width, height);
    };
    if (resize) {
        return (0, exports.el)("div.dhx-resize-observer", {
            _hooks: {
                didInsert: function (node) {
                    new resize(function () { return activeHandler(node); }).observe(node.el);
                },
            },
        });
    }
    return (0, exports.el)("iframe.dhx-resize-observer", {
        _hooks: {
            didInsert: function (node) {
                node.el.contentWindow.onresize = function () { return activeHandler(node); };
                activeHandler(node);
            },
        },
    });
}
exports.resizer = resizer;
function resizeHandler(container, handler) {
    return (0, exports.create)({
        render: function () {
            return resizer(handler);
        },
    }).mount(container);
}
exports.resizeHandler = resizeHandler;
function awaitRedraw() {
    return new Promise(function (res) {
        requestAnimationFrame(function () {
            res();
        });
    });
}
exports.awaitRedraw = awaitRedraw;
function setTheme(theme, container) {
    if (theme === void 0) { theme = "light"; }
    var dhxAttr = "data-dhx-theme";
    if (!container) {
        var elements = document.querySelectorAll("[".concat(dhxAttr, "]"));
        elements.forEach(function (el) { return el.removeAttribute(dhxAttr); });
    }
    container = container || document.documentElement;
    (0, html_1.toNode)(container).setAttribute(dhxAttr, theme);
}
exports.setTheme = setTheme;
function getViewHeight(view, width) {
    var vm = (0, exports.create)({
        render: function () {
            return (0, exports.el)("div", {
                style: {
                    position: "absolute",
                    visibility: "hidden",
                    width: width,
                },
            }, [view]);
        },
    });
    vm.mount(document.body);
    var height = vm.node.el.offsetHeight;
    vm.unmount();
    return height;
}
exports.getViewHeight = getViewHeight;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(18)))

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTextLines = exports.getCloneObject = exports.rgbToHex = exports.getStringWidth = exports.getMinArrayNumber = exports.getMaxArrayNumber = exports.isEmptyObj = exports.isType = exports.compare = exports.debounce = exports.downloadFile = exports.isNumeric = exports.range = exports.isId = exports.isDefined = exports.wrapBox = exports.unwrapBox = exports.detectWidgetClick = exports.singleOuterClick = exports.isExistValue = exports.findIndex = exports.naturalSort = exports.copy = exports.extend = exports.extendComponent = exports.uid = void 0;
var html_1 = __webpack_require__(2);
var counter = new Date().valueOf();
function uid() {
    return "u" + counter++;
}
exports.uid = uid;
function bindFunctionality(target, source, key) {
    var srcObj = source[key];
    if (typeof srcObj === "function") {
        target[key] = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return source[key].apply(source, args);
        };
    }
    else {
        Object.defineProperty(target, key, {
            get: function () { return source[key]; },
            set: function (value) { return (source[key] = value); },
            enumerable: true,
            configurable: true,
        });
    }
}
function extendComponent(target, source) {
    if (!source)
        return target;
    for (var _i = 0, _a = Object.keys(source); _i < _a.length; _i++) {
        var key = _a[_i];
        bindFunctionality(target, source, key);
    }
    var proto = Object.getPrototypeOf(source);
    while (proto && proto !== Object.prototype) {
        for (var _b = 0, _c = Object.getOwnPropertyNames(proto); _b < _c.length; _b++) {
            var key = _c[_b];
            if (!target.hasOwnProperty(key)) {
                bindFunctionality(target, source, key);
            }
        }
        proto = Object.getPrototypeOf(proto);
    }
    return target;
}
exports.extendComponent = extendComponent;
function extend(target, source, deep) {
    if (deep === void 0) { deep = true; }
    if (source) {
        for (var key in source) {
            var sobj = source[key];
            var tobj = target[key];
            if (sobj === undefined) {
                delete target[key];
            }
            else if (deep &&
                typeof tobj === "object" &&
                !(tobj instanceof Date) &&
                !(tobj instanceof Array)) {
                extend(tobj, sobj);
            }
            else {
                target[key] = sobj;
            }
        }
    }
    return target;
}
exports.extend = extend;
function copy(source, withoutInner) {
    var result = {};
    for (var key in source) {
        if (!withoutInner || !key.startsWith("$")) {
            result[key] = source[key];
        }
    }
    return result;
}
exports.copy = copy;
function naturalSort(arr) {
    return arr.sort(function (a, b) {
        var nn = typeof a === "string" ? a.localeCompare(b) : a - b;
        return nn;
    });
}
exports.naturalSort = naturalSort;
function findIndex(arr, predicate) {
    var len = arr.length;
    for (var i = 0; i < len; i++) {
        if (predicate(arr[i])) {
            return i;
        }
    }
    return -1;
}
exports.findIndex = findIndex;
function isExistValue(target, value) {
    var str = value.toString();
    var text = target.toString();
    if (str.length > text.length)
        return false;
    return text.toLowerCase().includes(str.toLowerCase());
}
exports.isExistValue = isExistValue;
function singleOuterClick(fn) {
    var click = function (e) {
        if (fn(e)) {
            document.removeEventListener("click", click);
        }
    };
    document.addEventListener("click", click);
}
exports.singleOuterClick = singleOuterClick;
function detectWidgetClick(widgetId, cb) {
    var click = function (e) { return cb((0, html_1.locate)(e, "data-dhx-widget-id") === widgetId); };
    document.addEventListener("click", click);
    return function () { return document.removeEventListener("click", click); };
}
exports.detectWidgetClick = detectWidgetClick;
function unwrapBox(box) {
    if (Array.isArray(box)) {
        return box[0];
    }
    return box;
}
exports.unwrapBox = unwrapBox;
function wrapBox(unboxed) {
    if (Array.isArray(unboxed)) {
        return unboxed;
    }
    return [unboxed];
}
exports.wrapBox = wrapBox;
function isDefined(some) {
    return some !== null && some !== undefined;
}
exports.isDefined = isDefined;
function isId(some) {
    return typeof some === "number" || (typeof some === "string" && some !== "");
}
exports.isId = isId;
function range(from, to) {
    if (from > to) {
        return [];
    }
    var result = [];
    while (from <= to) {
        result.push(from++);
    }
    return result;
}
exports.range = range;
function isNumeric(val) {
    return !isNaN(val - parseFloat(val));
}
exports.isNumeric = isNumeric;
function downloadFile(data, filename, mimeType) {
    if (mimeType === void 0) { mimeType = "text/plain"; }
    var file = new Blob([data], { type: mimeType });
    if (window.navigator.msSaveOrOpenBlob) {
        // IE10+
        window.navigator.msSaveOrOpenBlob(file, filename);
    }
    else {
        var a_1 = document.createElement("a");
        var url_1 = URL.createObjectURL(file);
        a_1.href = url_1;
        a_1.download = filename;
        document.body.appendChild(a_1);
        a_1.click();
        setTimeout(function () {
            document.body.removeChild(a_1);
            window.URL.revokeObjectURL(url_1);
        }, 0);
    }
}
exports.downloadFile = downloadFile;
function debounce(func, wait, immediate) {
    var timeout;
    return function executedFunction() {
        var _this = this;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var later = function () {
            timeout = null;
            if (!immediate) {
                func.apply(_this, args);
            }
        };
        var callNow = immediate && !timeout;
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
        if (callNow) {
            func.apply(this, args);
        }
    };
}
exports.debounce = debounce;
function compare(obj1, obj2) {
    for (var p in obj1) {
        if (obj1.hasOwnProperty(p) !== obj2.hasOwnProperty(p)) {
            return false;
        }
        switch (typeof obj1[p]) {
            case "object":
                if (!compare(obj1[p], obj2[p])) {
                    return false;
                }
                break;
            case "function":
                if (typeof obj2[p] === "undefined" ||
                    (p !== "compare" && obj1[p].toString() !== obj2[p].toString())) {
                    return false;
                }
                break;
            default:
                if (obj1[p] !== obj2[p]) {
                    return false;
                }
        }
    }
    for (var p in obj2) {
        if (!obj1.hasOwnProperty(p)) {
            return false;
        }
    }
    return true;
}
exports.compare = compare;
var isType = function (value) {
    var regex = /^\[object (\S+?)\]$/;
    var matches = Object.prototype.toString.call(value).match(regex) || [];
    return (matches[1] || "undefined").toLowerCase();
};
exports.isType = isType;
var isEmptyObj = function (obj) {
    for (var key in obj) {
        return false;
    }
    return true;
};
exports.isEmptyObj = isEmptyObj;
var getMaxArrayNumber = function (array) {
    if (!array.length)
        return;
    var maxNumber = -Infinity;
    var index = 0;
    var length = array.length;
    for (index; index < length; index++) {
        if (array[index] > maxNumber)
            maxNumber = array[index];
    }
    return maxNumber;
};
exports.getMaxArrayNumber = getMaxArrayNumber;
var getMinArrayNumber = function (array) {
    if (!array.length)
        return;
    var minNumber = +Infinity;
    var index = 0;
    var length = array.length;
    for (index; index < length; index++) {
        if (array[index] < minNumber)
            minNumber = array[index];
    }
    return minNumber;
};
exports.getMinArrayNumber = getMinArrayNumber;
var getStringWidth = function (value, config) {
    config = __assign({ font: "normal 14px Roboto", lineHeight: 20 }, config);
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    if (config.font)
        ctx.font = config.font;
    var width = ctx.measureText(value).width;
    if (!(0, html_1.isIE)())
        canvas.remove();
    return width;
};
exports.getStringWidth = getStringWidth;
var rgbToHex = function (color) {
    if (color.substr(0, 1) === "#") {
        return color;
    }
    if (color.substr(0, 3) !== "rgb") {
        return;
    }
    var digits = /(.*?)rgb[a]?\((\d+), *(\d+), *(\d+),* *([\d+.]*)\)/.exec(color);
    var red = parseInt(digits[2], 10)
        .toString(16)
        .padStart(2, "0");
    var green = parseInt(digits[3], 10)
        .toString(16)
        .padStart(2, "0");
    var blue = parseInt(digits[4], 10)
        .toString(16)
        .padStart(2, "0");
    return "#".concat(red).concat(green).concat(blue);
};
exports.rgbToHex = rgbToHex;
function getCloneObject(obj) {
    if (!obj) {
        return obj;
    }
    var clone = Array.isArray(obj) ? [] : {};
    for (var key in obj) {
        var value = obj[key];
        if (value instanceof Date) {
            clone[key] = new Date(value);
            continue;
        }
        clone[key] = typeof value === "object" ? getCloneObject(value) : value;
    }
    return clone;
}
exports.getCloneObject = getCloneObject;
var getTextWidth = function (_a) {
    var text = _a.text, ctx = _a.ctx;
    var metrics = ctx.measureText(text);
    var width = metrics.width;
    return width;
};
var splitLongWord = function (_a) {
    var ctx = _a.ctx, word = _a.word, maxWidth = _a.maxWidth;
    var result = [];
    var part = "";
    for (var i = 0; i < word.length; i++) {
        part += word[i];
        if (getTextWidth({ text: part, ctx: ctx }) > maxWidth) {
            result.push(part.slice(0, -1));
            part = word[i];
        }
    }
    if (part)
        result.push(part);
    return result;
};
function getTextLines(_a) {
    var ctx = _a.ctx, text = _a.text, maxWidth = _a.maxWidth;
    var words = text.split(" ");
    var line = "";
    var testLine = "";
    var lineArray = [];
    for (var n = 0; n < words.length; n++) {
        var word = words[n];
        if (getTextWidth({ text: word, ctx: ctx }) > maxWidth) {
            var splitWords = splitLongWord({ word: word, ctx: ctx, maxWidth: maxWidth });
            for (var _i = 0, splitWords_1 = splitWords; _i < splitWords_1.length; _i++) {
                var splitWord = splitWords_1[_i];
                testLine += "".concat(splitWord, " ");
                var testWidth = getTextWidth({ text: testLine.trimEnd(), ctx: ctx });
                if (testWidth > maxWidth) {
                    lineArray.push(line.trimEnd());
                    line = "".concat(splitWord, " ");
                    testLine = "".concat(splitWord, " ");
                }
                else {
                    line += "".concat(splitWord, " ");
                }
            }
        }
        else {
            testLine += "".concat(word, " ");
            var testWidth = getTextWidth({ text: testLine.trimEnd(), ctx: ctx });
            if (testWidth > maxWidth && n > 0) {
                lineArray.push(line.trimEnd());
                line = "".concat(word, " ");
                testLine = "".concat(word, " ");
            }
            else {
                line += "".concat(word, " ");
            }
        }
        if (n === words.length - 1) {
            lineArray.push(line.trimEnd());
        }
    }
    return lineArray;
}
exports.getTextLines = getTextLines;


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNodeOffset = exports.getElementFromPoint = exports.getPageLinksCss = exports.getPageInlineCss = exports.getLabelStyle = exports.getPageCss = exports.fitPosition = exports.calculatePosition = exports.getRealPosition = exports.isFirefox = exports.isSafari = exports.isIE = exports.getScrollbarHeight = exports.getScrollbarWidth = exports.getBox = exports.locateNodeByClassName = exports.locate = exports.locateNode = exports.eventHandler = exports.toNode = void 0;
function toNode(node) {
    var _a;
    return typeof node === "string"
        ? document.getElementById(node) || document.querySelector("[data-cell-id=".concat(node, "]")) || document.querySelector(node) || ((_a = document.querySelector("[data-dhx-root-id=".concat(node, "]"))) === null || _a === void 0 ? void 0 : _a.parentElement) || document.body
        : node || document.body;
}
exports.toNode = toNode;
function eventHandler(prepare, hash, afterCall) {
    var keys = Object.keys(hash);
    return function (ev) {
        var data = prepare(ev);
        if (data !== undefined) {
            var node = ev.target;
            outer_block: while (node) {
                var cssstring = node.getAttribute ? node.getAttribute("class") || "" : "";
                if (cssstring.length) {
                    var css = cssstring.split(" ");
                    for (var j = 0; j < keys.length; j++) {
                        if (css.includes(keys[j])) {
                            if (hash[keys[j]](ev, data) === false || ev.cancelBubble)
                                return false;
                            else
                                break outer_block;
                        }
                    }
                }
                node = node.parentNode;
            }
        }
        if (typeof afterCall === "function")
            afterCall(ev);
        return true;
    };
}
exports.eventHandler = eventHandler;
function locateNode(target, attr, dir) {
    if (attr === void 0) { attr = "data-dhx-id"; }
    if (dir === void 0) { dir = "target"; }
    if (target instanceof Event) {
        target = target[dir];
    }
    while (target) {
        if (target.getAttribute && target.getAttribute(attr)) {
            return target;
        }
        target = target.parentNode;
    }
}
exports.locateNode = locateNode;
function locate(target, attr) {
    if (attr === void 0) { attr = "data-dhx-id"; }
    var node = locateNode(target, attr);
    return node ? node.getAttribute(attr) : "";
}
exports.locate = locate;
function locateNodeByClassName(target, className) {
    if (target instanceof Event) {
        target = target.target;
    }
    while (target) {
        if (className) {
            if (target.classList && target.classList.contains(className)) {
                return target;
            }
        }
        else if (target.getAttribute && target.getAttribute("data-dhx-id")) {
            return target;
        }
        target = target.parentNode;
    }
}
exports.locateNodeByClassName = locateNodeByClassName;
function getBox(elem) {
    var box = elem.getBoundingClientRect();
    var body = document.body;
    var scrollTop = window.pageYOffset || body.scrollTop;
    var scrollLeft = window.pageXOffset || body.scrollLeft;
    var top = box.top + scrollTop;
    var left = box.left + scrollLeft;
    var right = body.offsetWidth - box.right;
    var bottom = body.offsetHeight - box.bottom;
    var width = box.right - box.left;
    var height = box.bottom - box.top;
    return { top: top, left: left, right: right, bottom: bottom, width: width, height: height };
}
exports.getBox = getBox;
var scrollWidth = -1;
function getScrollbarWidth() {
    if (scrollWidth > -1) {
        return scrollWidth;
    }
    var scrollDiv = document.createElement("div");
    document.body.appendChild(scrollDiv);
    scrollDiv.style.cssText = "position: absolute;left: -99999px;overflow:scroll;width: 100px;height: 100px;";
    scrollWidth = scrollDiv.offsetWidth - scrollDiv.clientWidth;
    document.body.removeChild(scrollDiv);
    return scrollWidth;
}
exports.getScrollbarWidth = getScrollbarWidth;
var scrollHeight = -1;
function getScrollbarHeight() {
    if (scrollHeight > -1) {
        return scrollHeight;
    }
    var scrollDiv = document.createElement("div");
    document.body.appendChild(scrollDiv);
    scrollDiv.style.cssText = "position: absolute;left: -99999px;overflow:scroll;width: 100px;height: 100px;";
    scrollHeight = scrollDiv.offsetHeight - scrollDiv.clientHeight;
    document.body.removeChild(scrollDiv);
    return scrollHeight;
}
exports.getScrollbarHeight = getScrollbarHeight;
function isIE() {
    var ua = window.navigator.userAgent;
    return ua.includes("MSIE ") || ua.includes("Trident/");
}
exports.isIE = isIE;
function isSafari() {
    var check = function (str) { return str.test(window.navigator.userAgent); };
    var chrome = check(/Chrome/);
    var firefox = check(/Firefox/);
    return !chrome && !firefox && check(/Safari/);
}
exports.isSafari = isSafari;
function isFirefox() {
    var check = function (str) { return str.test(window.navigator.userAgent); };
    var chrome = check(/Chrome/);
    var safari = check(/Safari/);
    return !chrome && !safari && check(/Firefox/);
}
exports.isFirefox = isFirefox;
function getRealPosition(node) {
    var rects = node.getBoundingClientRect();
    return {
        left: rects.left + window.pageXOffset,
        right: rects.right + window.pageXOffset,
        top: rects.top + window.pageYOffset,
        bottom: rects.bottom + window.pageYOffset,
    };
}
exports.getRealPosition = getRealPosition;
function getWindowBorders() {
    return {
        rightBorder: window.pageXOffset + window.innerWidth,
        bottomBorder: window.pageYOffset + window.innerHeight,
    };
}
function horizontalCentering(pos, width, rightBorder) {
    var nodeWidth = pos.right - pos.left;
    var diff = (width - nodeWidth) / 2;
    var left = pos.left - diff;
    var right = pos.right + diff;
    if (left >= 0 && right <= rightBorder) {
        return left;
    }
    if (left < 0) {
        return 0;
    }
    return rightBorder - width;
}
function verticalCentering(pos, height, bottomBorder) {
    var nodeHeight = pos.bottom - pos.top;
    var diff = (height - nodeHeight) / 2;
    var top = pos.top - diff;
    var bottom = pos.bottom + diff;
    if (top >= 0 && bottom <= bottomBorder) {
        return top;
    }
    if (top < 0) {
        return 0;
    }
    return bottomBorder - height;
}
function placeBottomOrTop(pos, config) {
    var _a = getWindowBorders(), rightBorder = _a.rightBorder, bottomBorder = _a.bottomBorder;
    var left;
    var top;
    var bottomDiff = bottomBorder - pos.bottom - config.height;
    var topDiff = pos.top - config.height;
    if (config.mode === "bottom") {
        if (bottomDiff >= 0) {
            top = pos.bottom;
        }
        else if (topDiff >= 0) {
            top = topDiff;
        }
    }
    else {
        if (topDiff >= 0) {
            top = topDiff;
        }
        else if (bottomDiff >= 0) {
            top = pos.bottom;
        }
    }
    if (bottomDiff < 0 && topDiff < 0) {
        if (config.auto) {
            // eslint-disable-next-line @typescript-eslint/no-use-before-define
            return placeRightOrLeft(pos, __assign(__assign({}, config), { mode: "right", auto: false }));
        }
        top = bottomDiff > topDiff ? pos.bottom : topDiff;
    }
    if (config.centering) {
        left = horizontalCentering(pos, config.width, rightBorder);
    }
    else {
        var leftDiff = rightBorder - pos.left - config.width;
        var rightDiff = pos.right - config.width;
        if (leftDiff >= 0) {
            left = pos.left;
        }
        else if (rightDiff >= 0) {
            left = rightDiff;
        }
        else {
            left = rightDiff > leftDiff ? pos.left : rightDiff;
        }
    }
    return { left: left, top: top };
}
function placeRightOrLeft(pos, config) {
    var _a = getWindowBorders(), rightBorder = _a.rightBorder, bottomBorder = _a.bottomBorder;
    var left;
    var top;
    var rightDiff = rightBorder - pos.right - config.width;
    var leftDiff = pos.left - config.width;
    if (config.mode === "right") {
        if (rightDiff >= 0) {
            left = pos.right;
        }
        else if (leftDiff >= 0) {
            left = leftDiff;
        }
    }
    else {
        if (leftDiff >= 0) {
            left = leftDiff;
        }
        else if (rightDiff >= 0) {
            left = pos.right;
        }
    }
    if (leftDiff < 0 && rightDiff < 0) {
        if (config.auto) {
            return placeBottomOrTop(pos, __assign(__assign({}, config), { mode: "bottom", auto: false }));
        }
        left = leftDiff > rightDiff ? leftDiff : pos.right;
    }
    if (config.centering) {
        top = verticalCentering(pos, config.height, bottomBorder);
    }
    else {
        var bottomDiff = pos.bottom - config.height;
        var topDiff = bottomBorder - pos.top - config.height;
        if (topDiff >= 0) {
            top = pos.top;
        }
        else if (bottomDiff > 0) {
            top = bottomDiff;
        }
        else {
            top = bottomDiff > topDiff ? bottomDiff : pos.top;
        }
    }
    return { left: left, top: top };
}
function calculatePosition(pos, config) {
    var _a = config.mode === "bottom" || config.mode === "top"
        ? placeBottomOrTop(pos, config)
        : placeRightOrLeft(pos, config), left = _a.left, top = _a.top;
    return {
        left: Math.round(left) + "px",
        top: Math.round(top) + "px",
        minWidth: Math.round(config.width) + "px",
        position: "absolute",
    };
}
exports.calculatePosition = calculatePosition;
function fitPosition(node, config) {
    return calculatePosition(getRealPosition(node), config);
}
exports.fitPosition = fitPosition;
function getPageCss() {
    var css = [];
    for (var sheeti = 0; sheeti < document.styleSheets.length; sheeti++) {
        var sheet = document.styleSheets[sheeti];
        var rules = "cssRules" in sheet ? sheet.cssRules : sheet.rules;
        for (var rulei = 0; rulei < rules.length; rulei++) {
            var rule = rules[rulei];
            if ("cssText" in rule) {
                css.push(rule.cssText);
            }
            else {
                css.push("".concat(rule.selectorText, " {\n").concat(rule.style.cssText, "\n}\n"));
            }
        }
    }
    return css.join("\n");
}
exports.getPageCss = getPageCss;
function getLabelStyle(config) {
    var helpMessage = config.helpMessage, type = config.type, labelWidth = config.labelWidth, label = config.label;
    var isZero = labelWidth && labelWidth.toString().startsWith("0");
    var required = type !== "text" && config.required;
    if (!helpMessage && !required && (!label || (label && isZero)) && (!labelWidth || isZero)) {
        return false;
    }
    return {
        style: (label || labelWidth) && !isZero && { width: labelWidth, "max-width": "100%" },
        label: label && isZero ? null : label,
    };
}
exports.getLabelStyle = getLabelStyle;
var checkCrossLink = function (sheet) { return sheet.href && !sheet.href.startsWith(window.location.origin); };
function getPageInlineCss() {
    var css = [];
    for (var i = 0; i < document.styleSheets.length; i++) {
        var sheet = document.styleSheets[i];
        if (!checkCrossLink(sheet)) {
            var rules = "cssRules" in sheet && sheet.cssRules.length
                ? sheet.cssRules
                : sheet.rules;
            for (var j = 0; j < rules.length; j++) {
                var rule = rules[j];
                if ("cssText" in rule) {
                    css.push(rule.cssText);
                }
                else {
                    css.push("".concat(rule.selectorText, " {\n").concat(rule.style.cssText, "\n}\n"));
                }
            }
        }
    }
    return css.join("\n");
}
exports.getPageInlineCss = getPageInlineCss;
function getPageLinksCss(exportStyles) {
    var css = [];
    if (exportStyles) {
        exportStyles.forEach(function (link) { return css.push("<link href=\"".concat(link, "\" rel=\"stylesheet\"/>")); });
    }
    else {
        for (var i = 0; i < document.styleSheets.length; i++) {
            var sheet = document.styleSheets[i];
            if (checkCrossLink(sheet)) {
                css.push("<link href=\"".concat(sheet.href, "\" rel=\"stylesheet\"/>"));
            }
        }
    }
    return css.join("\n");
}
exports.getPageLinksCss = getPageLinksCss;
function getElementFromPoint(e) {
    var _a, _b;
    var clientX = e.targetTouches
        ? ((_a = e.targetTouches[0]) === null || _a === void 0 ? void 0 : _a.clientX) || 0
        : e.clientX;
    var clientY = e.targetTouches
        ? ((_b = e.targetTouches[0]) === null || _b === void 0 ? void 0 : _b.clientY) || 0
        : e.clientY;
    var el = document.elementFromPoint(clientX, clientY);
    return (el === null || el === void 0 ? void 0 : el.shadowRoot) ? el.shadowRoot.elementFromPoint(clientX, clientY) : el;
}
exports.getElementFromPoint = getElementFromPoint;
function getNodeOffset(node1, node2) {
    var rect1 = node1.getBoundingClientRect();
    var rect2 = node2.getBoundingClientRect();
    return { left: rect1.left - rect2.left, top: rect1.top - rect2.top };
}
exports.getNodeOffset = getNodeOffset;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsMixin = exports.EventSystem = void 0;
var EventSystem = /** @class */ (function () {
    function EventSystem(context) {
        this.events = {};
        this.context = context || this;
    }
    EventSystem.prototype.on = function (name, callback, context) {
        var event = name.toLowerCase();
        this.events[event] = this.events[event] || [];
        this.events[event].push({ callback: callback, context: context || this.context });
    };
    EventSystem.prototype.detach = function (name, context) {
        var event = name.toLowerCase();
        var eStack = this.events[event];
        if (context && eStack && eStack.length) {
            for (var i = eStack.length - 1; i >= 0; i--) {
                if (eStack[i].context === context) {
                    eStack.splice(i, 1);
                }
            }
        }
        else {
            this.events[event] = [];
        }
    };
    EventSystem.prototype.fire = function (name, args) {
        if (typeof args === "undefined") {
            args = [];
        }
        var event = name.toLowerCase();
        if (this.events[event]) {
            var res = this.events[event].map(function (e) { return e.callback.apply(e.context, args); });
            return !res.includes(false);
        }
        return true;
    };
    EventSystem.prototype.clear = function () {
        this.events = {};
    };
    return EventSystem;
}());
exports.EventSystem = EventSystem;
function EventsMixin(obj) {
    obj = obj || {};
    var eventSystem = new EventSystem(obj);
    obj.detachEvent = eventSystem.detach.bind(eventSystem);
    obj.attachEvent = eventSystem.on.bind(eventSystem);
    obj.callEvent = eventSystem.fire.bind(eventSystem);
}
exports.EventsMixin = EventsMixin;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(25), exports);
__exportStar(__webpack_require__(64), exports);
__exportStar(__webpack_require__(69), exports);
__exportStar(__webpack_require__(138), exports);
__exportStar(__webpack_require__(28), exports);
__exportStar(__webpack_require__(140), exports);
__exportStar(__webpack_require__(21), exports);
__exportStar(__webpack_require__(45), exports);
__exportStar(__webpack_require__(66), exports);
__exportStar(__webpack_require__(141), exports);
__exportStar(__webpack_require__(65), exports);
__exportStar(__webpack_require__(44), exports);
__exportStar(__webpack_require__(68), exports);


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Split = exports.HeaderFilterEvent = exports.GridSystemEvents = exports.GridEvents = void 0;
var GridEvents;
(function (GridEvents) {
    GridEvents["scroll"] = "scroll";
    GridEvents["expand"] = "expand";
    GridEvents["filterChange"] = "filterChange";
    GridEvents["beforeFilter"] = "beforeFilter";
    GridEvents["beforeResizeStart"] = "beforeResizeStart";
    GridEvents["resize"] = "resize";
    GridEvents["afterResizeEnd"] = "afterResizeEnd";
    GridEvents["cellClick"] = "cellClick";
    GridEvents["cellRightClick"] = "cellRightClick";
    GridEvents["cellMouseOver"] = "cellMouseOver";
    GridEvents["cellMouseDown"] = "cellMouseDown";
    GridEvents["cellDblClick"] = "cellDblClick";
    GridEvents["headerCellClick"] = "headerCellClick";
    GridEvents["footerCellClick"] = "footerCellClick";
    GridEvents["headerCellMouseOver"] = "headerCellMouseOver";
    GridEvents["footerCellMouseOver"] = "footerCellMouseOver";
    GridEvents["headerCellMouseDown"] = "headerCellMouseDown";
    GridEvents["footerCellMouseDown"] = "footerCellMouseDown";
    GridEvents["headerCellDblClick"] = "headerCellDblClick";
    GridEvents["footerCellDblClick"] = "footerCellDblClick";
    GridEvents["headerCellRightClick"] = "headerCellRightClick";
    GridEvents["footerCellRightClick"] = "footerCellRightClick";
    GridEvents["beforeEditStart"] = "beforeEditStart";
    GridEvents["afterEditStart"] = "afterEditStart";
    GridEvents["beforeEditEnd"] = "beforeEditEnd";
    GridEvents["afterEditEnd"] = "afterEditEnd";
    GridEvents["beforeKeyDown"] = "beforeKeyDown";
    GridEvents["afterKeyDown"] = "afterKeyDown";
    GridEvents["beforeColumnHide"] = "beforeColumnHide";
    GridEvents["afterColumnHide"] = "afterColumnHide";
    GridEvents["beforeColumnShow"] = "beforeColumnShow";
    GridEvents["afterColumnShow"] = "afterColumnShow";
    GridEvents["beforeRowHide"] = "beforeRowHide";
    GridEvents["afterRowHide"] = "afterRowHide";
    GridEvents["beforeRowShow"] = "beforeRowShow";
    GridEvents["afterRowShow"] = "afterRowShow";
    GridEvents["beforeCollapse"] = "beforeCollapse";
    GridEvents["afterCollapse"] = "afterCollapse";
    GridEvents["beforeExpand"] = "beforeExpand";
    GridEvents["afterExpand"] = "afterExpand";
    GridEvents["beforeRowDrag"] = "beforeRowDrag";
    GridEvents["dragRowStart"] = "dragRowStart";
    GridEvents["dragRowOut"] = "dragRowOut";
    GridEvents["dragRowIn"] = "dragRowIn";
    GridEvents["canRowDrop"] = "canRowDrop";
    GridEvents["cancelRowDrop"] = "cancelRowDrop";
    GridEvents["beforeRowDrop"] = "beforeRowDrop";
    GridEvents["afterRowDrop"] = "afterRowDrop";
    GridEvents["afterRowDrag"] = "afterRowDrag";
    GridEvents["beforeColumnDrag"] = "beforeColumnDrag";
    GridEvents["dragColumnStart"] = "dragColumnStart";
    GridEvents["dragColumnOut"] = "dragColumnOut";
    GridEvents["dragColumnIn"] = "dragColumnIn";
    GridEvents["canColumnDrop"] = "canColumnDrop";
    GridEvents["cancelColumnDrop"] = "cancelColumnDrop";
    GridEvents["beforeColumnDrop"] = "beforeColumnDrop";
    GridEvents["afterColumnDrop"] = "afterColumnDrop";
    GridEvents["afterColumnDrag"] = "afterColumnDrag";
    GridEvents["beforeRowResize"] = "beforeRowResize";
    GridEvents["afterRowResize"] = "afterRowResize";
    GridEvents["beforeSort"] = "beforeSort";
    GridEvents["afterSort"] = "afterSort";
    GridEvents["groupPanelItemClick"] = "groupPanelItemClick";
    GridEvents["groupPanelItemMouseDown"] = "groupPanelItemMouseDown";
    GridEvents["dragPanelItemClick"] = "dragPanelItemClick";
    GridEvents["dragPanelItemMouseDown"] = "dragPanelItemMouseDown";
})(GridEvents || (exports.GridEvents = GridEvents = {}));
var GridSystemEvents;
(function (GridSystemEvents) {
    GridSystemEvents["cellTouchMove"] = "cellTouchMove";
    GridSystemEvents["cellTouchEnd"] = "cellTouchEnd";
    GridSystemEvents["headerCellTouchMove"] = "headerCellTouchMove";
    GridSystemEvents["headerCellTouchEnd"] = "headerCellTouchEnd";
    GridSystemEvents["groupPanelItemTouchMove"] = "groupPanelItemTouchMove";
    GridSystemEvents["groupPanelItemItemTouchEnd"] = "groupPanelItemItemTouchEnd";
})(GridSystemEvents || (exports.GridSystemEvents = GridSystemEvents = {}));
var HeaderFilterEvent;
(function (HeaderFilterEvent) {
    HeaderFilterEvent["change"] = "change";
})(HeaderFilterEvent || (exports.HeaderFilterEvent = HeaderFilterEvent = {}));
var Split;
(function (Split) {
    Split["left"] = "leftSplit";
    Split["right"] = "rightSplit";
    Split["top"] = "topSplit";
    Split["bottom"] = "bottomSplit";
})(Split || (exports.Split = Split = {}));


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemEvent = exports.ValidationStatus = exports.FormEvents = exports.ClearMethod = void 0;
var ClearMethod;
(function (ClearMethod) {
    ClearMethod["value"] = "value";
    ClearMethod["validation"] = "validation";
})(ClearMethod || (exports.ClearMethod = ClearMethod = {}));
var FormEvents;
(function (FormEvents) {
    FormEvents["beforeChange"] = "beforeChange";
    FormEvents["change"] = "change";
    FormEvents["click"] = "click";
    FormEvents["focus"] = "focus";
    FormEvents["blur"] = "blur";
    FormEvents["keydown"] = "keydown";
    FormEvents["beforeShow"] = "beforeShow";
    FormEvents["afterShow"] = "afterShow";
    FormEvents["beforeHide"] = "beforeHide";
    FormEvents["afterHide"] = "afterHide";
    FormEvents["afterValidate"] = "afterValidate";
    FormEvents["beforeValidate"] = "beforeValidate";
    FormEvents["beforeChangeProperties"] = "beforeChangeProperties";
    FormEvents["afterChangeProperties"] = "afterChangeProperties";
    FormEvents["beforeSend"] = "beforesend";
    FormEvents["afterSend"] = "aftersend";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    FormEvents["buttonClick"] = "buttonClick";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    FormEvents["validationFail"] = "validationfail";
})(FormEvents || (exports.FormEvents = FormEvents = {}));
var ValidationStatus;
(function (ValidationStatus) {
    ValidationStatus[ValidationStatus["pre"] = 0] = "pre";
    ValidationStatus[ValidationStatus["error"] = 1] = "error";
    ValidationStatus[ValidationStatus["success"] = 2] = "success";
})(ValidationStatus || (exports.ValidationStatus = ValidationStatus = {}));
var ItemEvent;
(function (ItemEvent) {
    ItemEvent["click"] = "click";
    ItemEvent["beforeChange"] = "beforeChange";
    ItemEvent["change"] = "change";
    ItemEvent["input"] = "input";
    ItemEvent["focus"] = "focus";
    ItemEvent["blur"] = "blur";
    ItemEvent["keydown"] = "keydown";
    ItemEvent["beforeChangeOptions"] = "beforeChangeOptions";
    ItemEvent["changeOptions"] = "changeOptions";
    ItemEvent["beforeShow"] = "beforeShow";
    ItemEvent["afterShow"] = "afterShow";
    ItemEvent["beforeHide"] = "beforeHide";
    ItemEvent["afterHide"] = "afterHide";
    ItemEvent["beforeValidate"] = "beforeValidate";
    ItemEvent["afterValidate"] = "afterValidate";
    ItemEvent["beforeUploadFile"] = "beforeUploadFile";
    ItemEvent["uploadFile"] = "uploadfile";
    ItemEvent["uploadBegin"] = "uploadBegin";
    ItemEvent["uploadComplete"] = "uploadComplete";
    ItemEvent["uploadFail"] = "uploadFail";
    ItemEvent["uploadProgress"] = "uploadProgress";
    ItemEvent["beforeChangeProperties"] = "beforeChangeProperties";
    ItemEvent["afterChangeProperties"] = "afterChangeProperties";
})(ItemEvent || (exports.ItemEvent = ItemEvent = {}));


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkPositions = exports.superposition = exports.getSizesSVGText = exports.getScales = exports.getClassesForRotateScale = exports.calcPointRef = exports.verticalBottomText = exports.verticalTopText = exports.verticalCenteredText = exports.roundToTwoNumAfterPoint = exports.euclideanDistance = exports.getRadialGradient = exports.linearGradient = exports.getFontStyle = exports.getColorShade = exports.getTextWidth = exports.log10 = exports.locator = exports.getDefaultColor = void 0;
var dom_1 = __webpack_require__(0);
var defaultColors = [
    "#2A9D8F",
    "#78586F",
    "#E76F51",
    "#E5A910",
    "#11A3D0",
    "#985F99",
    "#217B70",
    "#BD9391",
    "#9C89B8",
    "#734B5E",
    "#D66BA0",
    "#5C5D8D",
];
var defaultColorsTreeMap = ["#237396", "#2780A8", "#3892A3", "#4DA3A0", "#67BF99"];
function getDefaultColor(index, isTreeMapRange) {
    if (index === void 0) { index = 0; }
    return isTreeMapRange ? defaultColorsTreeMap[index] : defaultColors[index];
}
exports.getDefaultColor = getDefaultColor;
function locator(value) {
    if (!value) {
        return function () { return ""; };
    }
    if (typeof value === "string") {
        return function (obj) { return obj[value]; };
    }
    else {
        return value;
    }
}
exports.locator = locator;
function log10(x) {
    return Math.log(x) / Math.LN10;
}
exports.log10 = log10;
function anyArgsMemo(fn) {
    var cached = {};
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var mem = cached;
        for (var i = 0; i < args.length - 1; i++) {
            mem[args[i]] = mem[args[i]] || {};
            mem = mem[args[i]];
        }
        var last = args.length - 1;
        if (mem[last]) {
            return mem[last];
        }
        return (mem[last] = fn.apply(void 0, args));
    };
}
exports.getTextWidth = anyArgsMemo(function (text, font) {
    if (font === void 0) { font = ""; }
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    if (font) {
        ctx.font = font;
    }
    return ctx.measureText(text).width;
});
function memo(fn) {
    var cached = {};
    return function (arg) {
        if (cached[arg]) {
            return cached[arg];
        }
        return (cached[arg] = fn(arg));
    };
}
function getRgbaFromColor(color) {
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d");
    ctx.fillStyle = color;
    ctx.fillRect(0, 0, 2, 2);
    var rgba = ctx.getImageData(1, 1, 1, 1).data;
    return [rgba[0], rgba[1], rgba[2]];
}
var memoizedColorFromRgba = memo(getRgbaFromColor);
function getColorShade(color, light) {
    var _a = memoizedColorFromRgba(color).map(function (value) {
        return Math.floor(value * light + 255 * (1 - light));
    }), r = _a[0], g = _a[1], b = _a[2];
    return "rgb(".concat(r, ",").concat(g, ",").concat(b, ")");
}
exports.getColorShade = getColorShade;
exports.getFontStyle = memo(function (className) {
    var chart = document.createElementNS("http://www.w3.org/2000/svg", "svg");
    chart.setAttribute("class", "dhx_chart");
    var text = document.createElementNS("http://www.w3.org/2000/svg", "text");
    text.setAttribute("class", className);
    chart.setAttribute("visibility", "hidden");
    text.textContent = "test";
    chart.appendChild(text);
    document.body.appendChild(chart);
    var style = getComputedStyle(text);
    var font = "".concat(style.fontSize, " ").concat(style.fontFamily);
    document.body.removeChild(chart);
    return font;
});
function linearGradient(grad, id) {
    var stops = grad.stops;
    var colors = stops.map(function (item) {
        return (0, dom_1.sv)("stop", {
            offset: "".concat(item.offset * 100, "%"),
            "stop-color": item.color,
            "stop-opacity": item.opacity || 1,
        });
    });
    var gradient = (0, dom_1.sv)("linearGradient", {
        id: id,
        gradientTransform: "rotate(90)",
    }, colors);
    return gradient;
}
exports.linearGradient = linearGradient;
function getRadialGradient(opts, stops, id) {
    var colors = stops.map(function (item) {
        return (0, dom_1.sv)("stop", {
            offset: item.offset,
            "stop-color": item.color,
            "stop-opacity": item.opacity || 1,
        });
    });
    var gradient = (0, dom_1.sv)("radialGradient", __assign({ id: id, cx: 0, cy: 0, gradientUnits: "userSpaceOnUse" }, opts), colors);
    return gradient;
}
exports.getRadialGradient = getRadialGradient;
function euclideanDistance(x1, y1, x2, y2) {
    return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
}
exports.euclideanDistance = euclideanDistance;
function roundToTwoNumAfterPoint(p) {
    return Math.round((p * 100 + Number.EPSILON) * 100) / 100;
}
exports.roundToTwoNumAfterPoint = roundToTwoNumAfterPoint;
function verticalCenteredText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "0.5ex",
        style: {
            pointerEvents: "none",
        },
    }, text);
}
exports.verticalCenteredText = verticalCenteredText;
function verticalTopText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "-0.5ex",
    }, text);
}
exports.verticalTopText = verticalTopText;
function verticalBottomText(text) {
    return (0, dom_1.sv)("tspan", {
        dy: "1.5ex",
    }, text);
}
exports.verticalBottomText = verticalBottomText;
function calcPointRef(pointId, serieId) {
    return pointId + "_" + serieId;
}
exports.calcPointRef = calcPointRef;
function getClassesForRotateScale(position, angle) {
    var className = "";
    var classList = [];
    if (position === "left" || position === "top") {
        classList.push("start-text", "end-text");
    }
    else if (position === "right" || position === "bottom") {
        classList.push("end-text", "start-text");
    }
    switch (position) {
        case "left":
        case "right":
            if (angle === 0) {
                className = classList[1];
            }
            else if (angle > 0) {
                if (angle === 180) {
                    className = classList[0];
                }
                else if (angle > 180) {
                    if (angle < 270) {
                        className = classList[0];
                    }
                    else if (angle > 270) {
                        className = classList[1];
                    }
                }
                else if (angle < 180) {
                    if (angle > 90) {
                        className = classList[0];
                    }
                    else if (angle < 90) {
                        className = classList[1];
                    }
                }
            }
            else if (angle < 0) {
                if (angle === -180) {
                    className = classList[0];
                }
                else if (angle < -180) {
                    if (angle > -270) {
                        className = classList[0];
                    }
                    else if (angle < -270) {
                        className = classList[1];
                    }
                }
                else if (angle > -180) {
                    if (angle < -90) {
                        className = classList[0];
                    }
                    else if (angle > -90) {
                        className = classList[1];
                    }
                }
            }
            break;
        case "top":
        case "bottom":
            if (angle > 0) {
                if (angle > 180) {
                    className = classList[0];
                }
                else if (angle < 180) {
                    className = classList[1];
                }
            }
            else if (angle < 0) {
                if (angle > -180) {
                    className = classList[0];
                }
                else if (angle < -180) {
                    className = classList[1];
                }
            }
            break;
    }
    return className;
}
exports.getClassesForRotateScale = getClassesForRotateScale;
function getScales(config) {
    var scales = [];
    for (var scaleName in config) {
        var scale = config[scaleName];
        if (scale.min || scale.max || scale.maxTicks || scale.text || scale.value) {
            scales.push(scaleName);
        }
    }
    return scales;
}
exports.getScales = getScales;
function getSizesSVGText(text, config) {
    var sizes = [];
    config = __assign({ font: "normal 14px Roboto", lineHeight: 18 }, config);
    sizes.push((0, exports.getTextWidth)(text, config.font));
    sizes.push(config.lineHeight);
    return sizes;
}
exports.getSizesSVGText = getSizesSVGText;
function superposition(objA, objB) {
    if (objA.x < objB.x + objB.width &&
        objA.x + objA.width > objB.x &&
        objA.y < objB.y + objB.height &&
        objA.y + objA.height > objB.y) {
        return true;
    }
    else
        return false;
}
exports.superposition = superposition;
function checkPositions(current, previos, radiusX, radiusY, obj) {
    if (superposition(current, previos)) {
        var dY = obj.right
            ? previos.y - current.y + current.height
            : previos.y - previos.height - current.y;
        var newY = obj.text1.y + dY;
        if (Math.abs(newY) + obj.dy > radiusY) {
            newY = newY > 0 ? radiusY + obj.dy : -radiusY + obj.dy;
            obj.changeSector = !obj.changeSector;
        }
        var newX = Math.sqrt(Math.pow(radiusX, 2) - Math.pow(((newY - obj.dy) * radiusX) / radiusY, 2));
        newX = obj.right ? newX : -newX;
        if (obj.changeSector) {
            newX *= -1;
            obj.line *= -1;
            current.class = obj.right ? "pie-value end-text" : "pie-value start-text";
        }
        obj.text1.x = newX;
        obj.text1.y = newY;
        obj.text2.x = newX;
        obj.text2.y = newY + 16;
    }
}
exports.checkPositions = checkPositions;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCellWidth = exports.setAttacments = exports.widgetConfig = exports.baseProps = exports.isVerify = exports.isTimeFormat = exports.baseInputValidate = exports.validateInput = exports.isBlock = exports.validateTemplate = exports.getValidationMessage = exports.getFormItemCss = void 0;
/* eslint-disable no-useless-escape */
var types_1 = __webpack_require__(6);
var input_1 = __webpack_require__(40);
var core_1 = __webpack_require__(1);
function getFormItemCss(item, validate, focus) {
    var _a;
    if (focus === void 0) { focus = false; }
    var labelPosition = item.labelPosition, required = item.required, disabled = item.disabled, hiddenLabel = item.hiddenLabel, $validationStatus = item.$validationStatus;
    var cssStatus = (_a = {},
        _a[types_1.ValidationStatus.pre] = "",
        _a[types_1.ValidationStatus.error] = " dhx_form-group--state_error",
        _a[types_1.ValidationStatus.success] = " dhx_form-group--state_success",
        _a)[$validationStatus] || "";
    var labelPositionCss = labelPosition === "left" ? " dhx_form-group--inline" : "";
    var requiredCss = required ? " dhx_form-group--required" : "";
    var disabledCss = disabled ? " dhx_form-group--disabled" : "";
    var labelSrCss = hiddenLabel ? " dhx_form-group--label_sr" : "";
    var focusStatus = focus ? "" : cssStatus;
    if (validate) {
        return labelPositionCss + focusStatus + requiredCss + disabledCss + labelSrCss;
    }
    return labelPositionCss + disabledCss + labelSrCss;
}
exports.getFormItemCss = getFormItemCss;
var validators = (_a = {},
    _a[input_1.Validation.validAlphaNumeric] = /^[a-zA-Z0-9_]+$/,
    _a[input_1.Validation.validEmail] = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
    _a[input_1.Validation.validInteger] = /^-?\d+$/,
    _a[input_1.Validation.validIPv4] = /\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\.|$)){4}\b/,
    _a[input_1.Validation.validNumeric] = /^-?\d+(\.\d+)?$/,
    _a);
function getValidationMessage(item) {
    var _a;
    var validationMessage = (_a = {
            undefined: item.preMessage
        },
        _a[types_1.ValidationStatus.pre] = item.preMessage,
        _a[types_1.ValidationStatus.error] = item.errorMessage,
        _a[types_1.ValidationStatus.success] = item.successMessage,
        _a)[item.$validationStatus] || "";
    return validationMessage;
}
exports.getValidationMessage = getValidationMessage;
function validateTemplate(template, str) {
    return validators[template] ? validators[template].test(str) : true;
}
exports.validateTemplate = validateTemplate;
function isBlock(config) {
    return config.type !== "fieldset" && (Boolean(config.rows) || Boolean(config.cols));
}
exports.isBlock = isBlock;
function validateInput(value, validation) {
    var isValid = true;
    if (typeof validation === "function") {
        isValid = validation(value);
    }
    else {
        var regExp = validators[validation];
        if (regExp) {
            isValid = regExp.test(value.toString());
        }
    }
    return isValid;
}
exports.validateInput = validateInput;
function baseInputValidate(value, config) {
    var val = value !== null && value !== void 0 ? value : "";
    if (!config.required) {
        if (val === "")
            return true;
    }
    else if (!String(val).trim()) {
        return false;
    }
    var validate = function (num, min, max) {
        var isMin = (0, core_1.isDefined)(min);
        var isMax = (0, core_1.isDefined)(max);
        if (isMin && isMax) {
            return Number(min) <= Number(max) && Number(min) <= num && Number(max) >= num;
        }
        else if (isMin) {
            return Number(min) <= num;
        }
        else if (isMax) {
            return Number(max) >= num;
        }
        else {
            return true;
        }
    };
    return config.inputType === "number"
        ? validate(Number(val), config.min, config.max)
        : validate(String(val).length, config.minlength, config.maxlength);
}
exports.baseInputValidate = baseInputValidate;
function isTimeFormat(value, timeFormat) {
    if (timeFormat === 12) {
        return /(^0?([1-9][0-2]?):[0-5][0-9]?([AP][M]?)$)/i.test(value);
    }
    return /(^(0[0-9]|1[0-9]|2[0-3]|[0-9]):[0-5][0-9]$)/i.test(value);
}
exports.isTimeFormat = isTimeFormat;
function isVerify(config) {
    var validationProp = ["required", "validation", "minlength", "maxlength", "min", "max"];
    return validationProp.some(function (prop) {
        switch (prop) {
            case "required":
                return !!config[prop];
            case "validation":
                return (typeof config[prop] === "function" ||
                    config[prop] === "email" ||
                    config[prop] === "integer" ||
                    config[prop] === "numeric" ||
                    config[prop] === "alphanumeric" ||
                    config[prop] === "IPv4");
            case "minlength":
            case "maxlength":
                return typeof config[prop] === "number" || typeof config[prop] === "string";
            case "min":
            case "max":
                return ((typeof config[prop] === "number" || typeof config[prop] === "string") &&
                    config.inputType === "number");
        }
    });
}
exports.isVerify = isVerify;
exports.baseProps = ["width", "height", "padding", "css"];
var widgetConfig = function (_a) {
    var width = _a.width, type = _a.type, id = _a.id, name = _a.name, hidden = _a.hidden, editable = _a.editable, css = _a.css, required = _a.required, helpMessage = _a.helpMessage, preMessage = _a.preMessage, successMessage = _a.successMessage, errorMessage = _a.errorMessage, label = _a.label, labelWidth = _a.labelWidth, labelPosition = _a.labelPosition, hiddenLabel = _a.hiddenLabel, validation = _a.validation, icon = _a.icon, res = __rest(_a, ["width", "type", "id", "name", "hidden", "editable", "css", "required", "helpMessage", "preMessage", "successMessage", "errorMessage", "label", "labelWidth", "labelPosition", "hiddenLabel", "validation", "icon"]);
    return res;
};
exports.widgetConfig = widgetConfig;
function getFlatAttacments(arr, attachments, parent) {
    if (arr === void 0) { arr = []; }
    var items = [];
    for (var index = 0; index < arr.length; index++) {
        var conf = arr[index];
        if (conf.type) {
            attachments[conf.name].parent = parent;
            items.push(attachments[conf.name]);
        }
        if (isBlock(conf)) {
            items.push.apply(items, getFlatAttacments(conf.rows || conf.cols, attachments, parent));
        }
    }
    return items;
}
function setAttacments(attachments, layout) {
    var _a;
    for (var name_1 in attachments) {
        var item = attachments[name_1];
        if (item.config.type === "fieldset") {
            item.setAttachments(getFlatAttacments(item.config.rows || item.config.cols, attachments, item));
            item.setCell(layout.getCell(name_1));
        }
        else {
            (_a = layout.getCell(name_1)) === null || _a === void 0 ? void 0 : _a.attach(item);
        }
    }
}
exports.setAttacments = setAttacments;
function getCellWidth(element, width) {
    if (width !== "content")
        return width;
    return [
        "avatar",
        "colorpicker",
        "combo",
        "datepicker",
        "fieldset",
        "input",
        "select",
        "simplevault",
        "text",
        "textarea",
    ].includes(element)
        ? undefined
        : width;
}
exports.getCellWidth = getCellWidth;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.toViewLike = exports.View = void 0;
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(2);
var View = /** @class */ (function () {
    function View(_container, config) {
        var _a;
        this.config = config || {};
        this._uid = (_a = this.config.rootId) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
    }
    View.prototype.mount = function (container, vnode) {
        if (vnode) {
            this._view = vnode;
        }
        if (container && this._view && this._view.mount) {
            // init view inside of HTML container
            this._container = (0, html_1.toNode)(container);
            if (this._container.tagName) {
                this._view.mount(this._container);
            }
            else if (this._container.attach) {
                this._container.attach(this);
            }
        }
    };
    View.prototype.unmount = function () {
        var rootView = this.getRootView();
        if (rootView && rootView.node) {
            if (this.getRootNode())
                rootView.unmount();
            this._view = null;
        }
    };
    View.prototype.getRootView = function () {
        return this._view;
    };
    View.prototype.getRootNode = function () {
        return this._view && this._view.node && this._view.node.el;
    };
    View.prototype.paint = function () {
        if (this._view && // was mounted
            (this._view.node || // already rendered node
                this._container)) {
            // not rendered, but has container
            this._doNotRepaint = false;
            this._view.redraw();
        }
    };
    return View;
}());
exports.View = View;
function toViewLike(view) {
    return {
        getRootView: function () { return view; },
        paint: function () { return view.node && view.redraw(); },
        mount: function (container) { return view.mount(container); },
    };
}
exports.toViewLike = toViewLike;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getClosestBottom = exports.getClosestTop = exports.getLastChild = exports.isWasmSupported = exports.scrollFixedColsAndRows = exports.getTotalHeight = exports.getTotalWidth = exports.isHtmlEnable = exports.isTooltip = exports.getTooltipConfig = exports.isContentTooltip = exports.showTooltip = exports.isAutoWidth = exports.isSortable = exports.isRowEmpty = exports.isCssSupport = exports.removeHTMLTags = exports.getStyleByClass = exports.transpose = void 0;
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(2);
var ts_message_1 = __webpack_require__(14);
var data_1 = __webpack_require__(11);
function transpose(arr, transform) {
    var columns = [];
    for (var i = 0; i < arr.length; i++) {
        var row = arr[i];
        for (var cellInd = 0; cellInd < row.length; cellInd++) {
            columns[cellInd] = columns[cellInd] || [];
            var cell = transform ? transform(row[cellInd]) : row[cellInd];
            columns[cellInd].push(cell);
        }
    }
    return columns;
}
exports.transpose = transpose;
function insert(node, newone) {
    if (typeof newone === "string") {
        node.insertAdjacentHTML("beforeend", newone);
        return node.lastChild;
    }
    else {
        node.appendChild(newone);
        return newone;
    }
}
function getStyleByClass(cssClass, targetClass, def, container) {
    if (container === void 0) { container = document.body; }
    var cont = container.querySelector("." + targetClass.trim().replace(/\s/g, "."));
    var testDiv = insert(cont, "<div class=\"".concat(cssClass, "\"></div>"));
    var styles = window.getComputedStyle(testDiv);
    var TRANSPARENT = "rgba(0, 0, 0, 0)";
    var background;
    if (styles.backgroundColor === TRANSPARENT) {
        var contStyles = window.getComputedStyle(cont);
        background =
            contStyles.backgroundColor === TRANSPARENT
                ? def.background
                : (0, core_1.rgbToHex)(contStyles.backgroundColor);
    }
    else {
        background = (0, core_1.rgbToHex)(styles.backgroundColor);
    }
    var result = {
        color: styles.color === "rgb(0, 0, 0)" ? def.color : (0, core_1.rgbToHex)(styles.color),
        background: background,
        fontSize: Math.round(parseFloat(styles.fontSize)),
        bold: ["bold", "700", "600", "500"].includes(styles.fontWeight),
    };
    cont.removeChild(testDiv);
    if ((0, core_1.compare)(result, def))
        return null;
    return result;
}
exports.getStyleByClass = getStyleByClass;
function removeHTMLTags(str) {
    if (typeof str !== "string" && typeof str !== "number" && typeof str !== "boolean") {
        return "";
    }
    return str
        .toString()
        .replace(/<[^>]*>/g, "")
        .trim();
}
exports.removeHTMLTags = removeHTMLTags;
function isCssSupport(property, value) {
    try {
        return CSS.supports(property, value);
    }
    catch (err) {
        var el = document.createElement("div");
        el.style[property] = value;
        return el.style[property] === value;
    }
}
exports.isCssSupport = isCssSupport;
function isRowEmpty(row) {
    if (!row) {
        return;
    }
    return Object.keys(row).reduce(function (acc, col) {
        if (col === "id" || col.startsWith("$")) {
            return acc;
        }
        if (acc && row[col] !== undefined && row[col] !== "") {
            return;
        }
        return acc;
    }, true);
}
exports.isRowEmpty = isRowEmpty;
function isSortable(config, col) {
    return (col.sortable !== false && config.sortable) || col.sortable;
}
exports.isSortable = isSortable;
function isAutoWidth(config, col) {
    if (col) {
        return (col.autoWidth !== false && config.autoWidth) || col.autoWidth;
    }
    var check = false;
    config.columns.map(function (col) {
        if ((col.autoWidth !== false && config.autoWidth) || col.autoWidth) {
            check = true;
            return;
        }
    });
    return check;
}
exports.isAutoWidth = isAutoWidth;
function showTooltip(value, config) {
    if (!config.node)
        return;
    (0, ts_message_1.tooltip)(value.toString(), __assign(__assign({}, config), { css: "dhx_grid_tooltip " + (config.css || "") }));
}
exports.showTooltip = showTooltip;
function isContentTooltip(config, col, cell, type) {
    var isEnable = false;
    var cellProp = type === "header" ? config.headerTooltip : config.footerTooltip;
    var prop = [config.tooltip, cellProp, col.tooltip, cell === null || cell === void 0 ? void 0 : cell.tooltip];
    for (var index = 0; index < prop.length; index++) {
        if (prop[index] || typeof prop[index] === "boolean") {
            isEnable = !!prop[index];
        }
    }
    return isEnable;
}
exports.isContentTooltip = isContentTooltip;
function getTooltipConfig(config, col, cell, type) {
    return ([
        cell === null || cell === void 0 ? void 0 : cell.tooltip,
        col === null || col === void 0 ? void 0 : col.tooltip,
        type && (type === "header" ? config.headerTooltip : config.footerTooltip),
        config.tooltip,
    ].find(function (tooltip) { return tooltip instanceof Object; }) || {});
}
exports.getTooltipConfig = getTooltipConfig;
function isTooltip(config, element) {
    return (element.tooltip !== false && config.tooltip) || element.tooltip;
}
exports.isTooltip = isTooltip;
function isHtmlEnable(config, col, content) {
    var _a, _b;
    return !!((_b = (_a = content === null || content === void 0 ? void 0 : content.htmlEnable) !== null && _a !== void 0 ? _a : col.htmlEnable) !== null && _b !== void 0 ? _b : config.htmlEnable);
}
exports.isHtmlEnable = isHtmlEnable;
function getTotalWidth(columns) {
    return columns.reduce(function (total, col) { return total + (col.$width || 0); }, 0);
}
exports.getTotalWidth = getTotalWidth;
function getTotalHeight(rows) {
    return rows.reduce(function (total, row) { return total + (0, data_1.getTotalRowHeight)(row); }, 0);
}
exports.getTotalHeight = getTotalHeight;
function scrollFixedColsAndRows(e) {
    var grid = (0, html_1.locateNode)(e, "data-dhx-widget-id");
    var gridBody = grid.querySelector(".dhx_grid-body");
    var delta = e.deltaY;
    var position = e.shiftKey ? [delta, 0] : [0, delta];
    gridBody === null || gridBody === void 0 ? void 0 : gridBody.scrollBy.apply(gridBody, position);
}
exports.scrollFixedColsAndRows = scrollFixedColsAndRows;
function isWasmSupported() {
    try {
        if (typeof WebAssembly === "object" && typeof WebAssembly.instantiate === "function") {
            var module_1 = new WebAssembly.Module(Uint8Array.of(0x0, 0x61, 0x73, 0x6d, 0x01, 0x00, 0x00, 0x00));
            if (module_1 instanceof WebAssembly.Module) {
                return new WebAssembly.Instance(module_1) instanceof WebAssembly.Instance;
            }
        }
    }
    catch (e) {
        return false;
    }
    return false;
}
exports.isWasmSupported = isWasmSupported;
function getLastChild(id, data, deep) {
    if (deep === void 0) { deep = true; }
    var item = data.getItem(id);
    while (item && item.$opened && data.haveItems(id)) {
        var items = data.getItems(id);
        id = items[items.length - 1].id;
        if (!deep)
            break;
        item = data.getItem(id);
    }
    return item ? id : null;
}
exports.getLastChild = getLastChild;
function getClosestTop(id, data) {
    var index = data.getIndex(id);
    var parent = data.getParent(id);
    if (index > 0) {
        var children = data.getItems(parent);
        var current = children[index - 1];
        if (!data.haveItems(current.id) || !current.$opened) {
            return current.id;
        }
        while (data.haveItems(current.id) && current.$opened) {
            var allChildren = data.getItems(current.id);
            current = allChildren[allChildren.length - 1];
        }
        return current.id;
    }
    else {
        if (parent === data.getRoot()) {
            return null;
        }
        return parent;
    }
}
exports.getClosestTop = getClosestTop;
function getClosestBottom(id, data, ignore) {
    if (ignore === void 0) { ignore = false; }
    var item = data.getItem(id);
    var haveItems = data.haveItems(id);
    if (haveItems && item.$opened && !ignore) {
        return data.getItems(id)[0].id;
    }
    else {
        var parent_1 = data.getParent(id);
        var children = data.getItems(parent_1);
        var index = children.findIndex(function (child) { return child.id === id; });
        var len = children.length;
        if (index + 1 < len) {
            return children[index + 1].id;
        }
        else {
            if (parent_1 === data.getRoot()) {
                return null;
            }
            return getClosestBottom(parent_1, data, true);
        }
    }
}
exports.getClosestBottom = getClosestBottom;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReverseScrollState = exports.getEditorValue = exports.getComboEditorValue = exports.getValueForNumberColumn = exports.getOptionValue = exports.getEditorOptions = exports.applyPattern = exports.getMaxColsWidth = exports.getTreeCellWidthOffset = exports.getCalculatedRowHeight = exports.getMaxRowHeight = exports.getNormalizeFilterData = exports.calculateVisibleRange = exports.countColumns = exports.measureTextHeight = exports.normalizeArray = exports.getTotalRowHeight = void 0;
var core_1 = __webpack_require__(1);
var types_1 = __webpack_require__(5);
var main_1 = __webpack_require__(10);
var date_1 = __webpack_require__(19);
var input_1 = __webpack_require__(33);
var common_1 = __webpack_require__(17);
function getTotalRowHeight(row) {
    return (row === null || row === void 0 ? void 0 : row.$height) + (((row === null || row === void 0 ? void 0 : row.$opened) && (row === null || row === void 0 ? void 0 : row.$subRowHeight)) || 0) || 0;
}
exports.getTotalRowHeight = getTotalRowHeight;
function normalizeArray(obj, name) {
    if (!obj[name]) {
        return;
    }
    if (typeof obj[name] === "string") {
        obj[name] = [
            {
                text: "".concat(obj[name]),
            },
        ];
    }
    else {
        obj[name] = obj[name].map(function (el) {
            if (typeof el === "string") {
                el = { text: el };
            }
            return el;
        });
    }
}
exports.normalizeArray = normalizeArray;
function measureTextHeight(_a) {
    var _b = _a.text, text = _b === void 0 ? "" : _b, _c = _a.width, width = _c === void 0 ? 0 : _c, _d = _a.lineHeight, lineHeight = _d === void 0 ? 20 : _d, _e = _a.font, font = _e === void 0 ? "14.4px Arial" : _e, _f = _a.htmlEnable, htmlEnable = _f === void 0 ? false : _f;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = font;
    var defaultLineBreak = [];
    var mathLineBreak = [];
    if (htmlEnable)
        text = (0, main_1.removeHTMLTags)(text);
    var lineBreak = Math.ceil(ctx.measureText(text).width / width);
    if (lineBreak > 1)
        lineBreak = (0, core_1.getTextLines)({ ctx: ctx, text: text, maxWidth: width }).length;
    mathLineBreak.push(lineBreak);
    defaultLineBreak.push(text.split("\n").length);
    var maxRows = Math.max((0, core_1.getMaxArrayNumber)(defaultLineBreak), (0, core_1.getMaxArrayNumber)(mathLineBreak));
    canvas.remove();
    return maxRows * lineHeight;
}
exports.measureTextHeight = measureTextHeight;
function countColumns(config, columns) {
    var headerRowsCount = 0;
    var footerRowsCount = 0;
    var totalWidth = 0;
    var colspans = false;
    var rowsHeadersCount = 0;
    var footer = false;
    columns.forEach(function (col) {
        headerRowsCount = Math.max(headerRowsCount, col.header.length);
        totalWidth += col.$width;
        if (col.footer) {
            footerRowsCount = Math.max(footerRowsCount, col.footer.length);
            if (!footer) {
                footer = true;
            }
        }
        if (!colspans) {
            for (var _i = 0, _a = col.header; _i < _a.length; _i++) {
                var head = _a[_i];
                if (head.colspan) {
                    colspans = true;
                    return;
                }
            }
        }
    });
    // fill missing cells
    columns.forEach(function (col) {
        if (footer) {
            col.footer = col.footer || [];
        }
        if (col.header.length < headerRowsCount) {
            for (var i = 0; i < headerRowsCount; i++) {
                col.header[i] = col.header[i] || { text: "" };
            }
        }
        if (col.footer) {
            if (col.footer.length < footerRowsCount) {
                for (var i = 0; i < footerRowsCount; i++) {
                    col.footer[i] = col.footer[i] || { text: "" };
                }
            }
            for (var i = 0; i < col.footer.length; i++) {
                if (!col.footer[i].id)
                    col.footer[i].id = (0, core_1.uid)();
            }
        }
        col.header = col.header.map(function (head) {
            if (typeof head !== "object") {
                head = { text: head };
            }
            head.css = head.css || "";
            if (!head.text && !head.css.includes("dhx_cell-empty")) {
                head.css += " dhx_cell-empty";
            }
            if (!head.id)
                head.id = (0, core_1.uid)();
            return head;
        });
        // find header columns indexes
        if (col.header[0].text === "") {
            rowsHeadersCount++;
        }
    });
    config.$totalWidth = totalWidth;
    config.$colspans = colspans;
    config.$footer = footer;
    return rowsHeadersCount;
}
exports.countColumns = countColumns;
function getVisibleRange(viewportSize, scrollPosition, items, sizeProperty) {
    if (items === void 0) { items = []; }
    var start = -1;
    var end = -1;
    var accumulatedSize = 0;
    var currentIndex = 0;
    for (var index = 0; index < items.length; index++) {
        if (items[index].hidden)
            continue;
        var size = sizeProperty === "$width" ? items[index][sizeProperty] : getTotalRowHeight(items[index]);
        if (accumulatedSize + size >= scrollPosition && start === -1) {
            start = currentIndex;
        }
        if (accumulatedSize >= scrollPosition + viewportSize) {
            end = currentIndex;
            break;
        }
        accumulatedSize += size;
        currentIndex++;
    }
    if (start === -1)
        start = 0;
    if (end === -1)
        end = currentIndex;
    return { start: start, end: end };
}
function calculateVisibleRange(viewPortSize, scroll, config, data) {
    var leftFixedCols = (0, common_1.getCurrFixedCols)(config, types_1.Split.left);
    var rightFixedCols = (0, common_1.getCurrFixedCols)(config, types_1.Split.right);
    var topFixedRows = data.slice(0, config.topSplit || 0);
    var bottomFixedRows = config.bottomSplit ? data.slice(-config.bottomSplit) : [];
    var adjustedViewportHeight = viewPortSize.height -
        (config.$headerHeight || 0) -
        (config.$footerHeight || 0) -
        (0, main_1.getTotalHeight)(__spreadArray(__spreadArray([], topFixedRows, true), bottomFixedRows, true));
    var adjustedViewportWidth = viewPortSize.width - (0, main_1.getTotalWidth)(__spreadArray(__spreadArray([], leftFixedCols, true), rightFixedCols, true));
    var viewportRows = config.topSplit || config.bottomSplit
        ? data.slice(topFixedRows.length, -config.bottomSplit || data.length)
        : data;
    var viewportCols = config.leftSplit || config.rightSplit
        ? config.columns.slice(config.leftSplit || 0, -config.rightSplit || config.columns.length)
        : config.columns;
    var yPosition = getVisibleRange(adjustedViewportHeight, scroll.top, viewportRows, "$height");
    var xPosition = getVisibleRange(adjustedViewportWidth, scroll.left, viewportCols, "$width");
    return {
        xStart: xPosition.start + leftFixedCols.length,
        xEnd: xPosition.end + leftFixedCols.length,
        yStart: yPosition.start + topFixedRows.length,
        yEnd: yPosition.end + topFixedRows.length,
    };
}
exports.calculateVisibleRange = calculateVisibleRange;
function getNormalizeFilterData(arr, name, multiselection, editorType) {
    var allItems = arr.map(function (item) { return item[name]; });
    if (multiselection && editorType === "multiselect") {
        allItems.forEach(function (item, index) {
            if (typeof item === "string" && item.includes(", ")) {
                item.split(", ").forEach(function (i) { return allItems.push(i); });
                delete allItems[index];
            }
        });
    }
    return allItems
        .filter(function (item, i, array) { return array.indexOf(item) === i && (0, core_1.isDefined)(item); })
        .sort(function (a, b) {
        var numA = parseFloat(a);
        var numB = parseFloat(b);
        if (!isNaN(numA) && !isNaN(numB)) {
            return numA === numB ? a.toString().localeCompare(b.toString()) : numA - numB;
        }
        a = typeof a === "boolean" ? a.toString() : a;
        b = typeof b === "boolean" ? b.toString() : b;
        if (isNaN(a) && isNaN(b))
            return a.localeCompare(b);
        return a === "" ? -1 : b === "" ? 1 : isNaN(a) ? 1 : -1;
    });
}
exports.getNormalizeFilterData = getNormalizeFilterData;
var getMaxRowHeight = function (_a) {
    var _b, _c;
    var cols = _a.cols, row = _a.row, _d = _a.config, config = _d === void 0 ? { font: "14.4px Arial", lineHeight: 20 } : _d;
    var HORIZONTAL_OFFSET = 24 + common_1.BORDERS;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = config.font;
    var definedColumns = {};
    var colLength = cols.length;
    for (var index = 0; index < colLength; index++) {
        definedColumns[cols[index].id] = {
            width: cols[index].$width - HORIZONTAL_OFFSET || 0,
            col: cols[index],
        };
    }
    var defaultLineBreak = [];
    var mathLineBreak = [];
    // eslint-disable-next-line prefer-const
    for (var _i = 0, _e = Object.entries(row); _i < _e.length; _i++) {
        var _f = _e[_i], key = _f[0], value = _f[1];
        var column = (_b = definedColumns[key]) === null || _b === void 0 ? void 0 : _b.col;
        if (column &&
            key !== "height" &&
            !key.startsWith("$") &&
            (typeof value === "string" ||
                typeof value === "number" ||
                value instanceof Date ||
                Array.isArray(value))) {
            value =
                column.editorType === "combobox" || column.editorType === "multiselect"
                    ? getComboEditorValue(value, column, row)
                    : applyPattern(value, column);
            var currentValue = "";
            if (typeof column.template === "function") {
                var templateValue = column.template(value, row, definedColumns[key].col);
                currentValue = column.htmlEnable ? (0, main_1.removeHTMLTags)(templateValue) : templateValue.toString();
            }
            else if (typeof value === "string") {
                if (column.htmlEnable) {
                    currentValue = (0, main_1.removeHTMLTags)(value);
                }
                else {
                    currentValue = value;
                }
            }
            else {
                currentValue = value.toString();
            }
            var lineBreak = Math.ceil(ctx.measureText(currentValue).width / definedColumns[key].width);
            if (lineBreak > 1) {
                lineBreak = (0, core_1.getTextLines)({
                    ctx: ctx,
                    text: currentValue,
                    maxWidth: (_c = definedColumns[key]) === null || _c === void 0 ? void 0 : _c.width,
                }).length;
            }
            mathLineBreak.push(lineBreak);
            defaultLineBreak.push(currentValue.split("\n").length);
        }
    }
    var maxRows = Math.max((0, core_1.getMaxArrayNumber)(defaultLineBreak), (0, core_1.getMaxArrayNumber)(mathLineBreak));
    canvas.remove();
    return maxRows * config.lineHeight;
};
exports.getMaxRowHeight = getMaxRowHeight;
var getCalculatedRowHeight = function (height, config) {
    config = __assign({ rowHeight: 40, verticalOffset: 10 }, config);
    var calculateHeight = config.rowHeight < 40 ? height : height + config.verticalOffset * 2;
    return height < config.rowHeight ? config.rowHeight : calculateHeight;
};
exports.getCalculatedRowHeight = getCalculatedRowHeight;
var getTreeCellWidthOffset = function (row, toArrow) {
    if (toArrow === void 0) { toArrow = false; }
    return 20 + row.$level * 20 - (toArrow && row.$items ? 20 : 0);
};
exports.getTreeCellWidthOffset = getTreeCellWidthOffset;
var getMaxColsWidth = function (rows, cols, config, target) {
    var _a;
    if (config === void 0) { config = {
        font: "normal 14.4px Arial",
    }; }
    if (!rows.length || !cols.length) {
        return {};
    }
    var definedColumns = {};
    var colLength = cols.length;
    var rowsLength = rows.length;
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = config.font;
    for (var index = 0; index < colLength; index++) {
        definedColumns[cols[index].id] = {
            width: 20,
            col: cols[index],
        };
    }
    for (var index = 0; index < rowsLength; index++) {
        // eslint-disable-next-line prefer-const
        for (var _i = 0, _b = Object.entries(rows[index]); _i < _b.length; _i++) {
            var _c = _b[_i], key = _c[0], value = _c[1];
            var column = (_a = definedColumns[key]) === null || _a === void 0 ? void 0 : _a.col;
            if (column &&
                key !== "height" &&
                !key.startsWith("$") &&
                (typeof value === "string" ||
                    typeof value === "number" ||
                    value instanceof Date ||
                    Array.isArray(value))) {
                value =
                    column.editorType === "combobox" || column.editorType === "multiselect"
                        ? getComboEditorValue(value, column, rows[index])
                        : value;
                if (target !== "header") {
                    value = applyPattern(value, column);
                }
                var currentValue = void 0;
                if (typeof (column === null || column === void 0 ? void 0 : column.template) === "function" && target === "data") {
                    var templateValue = column.template(value, rows[index], column);
                    currentValue = column.htmlEnable ? (0, main_1.removeHTMLTags)(templateValue) : templateValue;
                }
                else {
                    currentValue = column.htmlEnable ? (0, main_1.removeHTMLTags)(value) : value.toString();
                }
                var width = ctx.measureText(currentValue).width;
                if (width > definedColumns[key].width)
                    definedColumns[key].width = width;
            }
        }
    }
    canvas.remove();
    var totalColumns = {};
    for (var _d = 0, _e = Object.entries(definedColumns); _d < _e.length; _d++) {
        var _f = _e[_d], key = _f[0], value = _f[1];
        totalColumns[key] = Math.ceil(value.width);
    }
    return totalColumns;
};
exports.getMaxColsWidth = getMaxColsWidth;
function applyPattern(value, col) {
    if (!(0, core_1.isDefined)(value) || typeof value === "boolean" || value === "") {
        return value;
    }
    if (col.type === "date") {
        var dateFormat = col.dateFormat || "%M %d %Y";
        if (typeof value === "string") {
            if (!(0, date_1.stringToDate)(value, dateFormat, true)) {
                var date = new Date(value);
                if (date === null || date === void 0 ? void 0 : date.valueOf()) {
                    value = (0, date_1.getFormattedDate)(dateFormat, date);
                }
            }
        }
        else if (typeof value === "object") {
            value = (0, date_1.getFormattedDate)(dateFormat, value);
        }
        return value;
    }
    if (col.type === "number" || col.numberMask) {
        value = parseFloat(value);
        if (isNaN(value)) {
            return value;
        }
    }
    if (col.numberMask) {
        var maxDecLength = col.numberMask.maxDecLength;
        if ((0, core_1.isDefined)(maxDecLength)) {
            value = +value.toFixed(maxDecLength);
        }
        return (0, input_1.numberMask)(value, __assign(__assign({}, col.numberMask), { onlyView: true }));
    }
    if (col.patternMask) {
        return (0, input_1.patternMask)(value, col.patternMask);
    }
    return value;
}
exports.applyPattern = applyPattern;
function getEditorOptions(col, row) {
    return __spreadArray(__spreadArray([], ((typeof col.options === "function" ? col.options(col, row) : col.options) || []), true), (col.$customOptions || []), true);
}
exports.getEditorOptions = getEditorOptions;
function getOptionValue(value, column) {
    var option = getEditorOptions(column).find(function (option) {
        return typeof option === "string" ? option === value : option.id.toString() === value;
    });
    return (option === null || option === void 0 ? void 0 : option.value) || value;
}
exports.getOptionValue = getOptionValue;
function getValueForNumberColumn(col, value) {
    if (!(0, core_1.isDefined)(value) ||
        value === "" ||
        typeof value === "number" ||
        ["select", "combobox", "multiselect"].includes(col.editorType)) {
        return value;
    }
    else if (typeof value === "string") {
        return parseFloat(value);
    }
    else {
        return NaN;
    }
}
exports.getValueForNumberColumn = getValueForNumberColumn;
function getComboEditorValue(value, col, row) {
    var options = getEditorOptions(col, row);
    return col.editorType === "multiselect" && typeof value === "string"
        ? value
            .split(",")
            .map(function (val) { return getEditorValue(val.trim(), options); })
            .join(", ")
        : getEditorValue(value, options);
}
exports.getComboEditorValue = getComboEditorValue;
function getEditorValue(value, options) {
    var option = options.find(function (option) { return option instanceof Object && option.id == value; });
    return option ? option.value : value;
}
exports.getEditorValue = getEditorValue;
function getReverseScrollState(grid) {
    var _a;
    var scrollState = grid.getScrollState();
    var scrollBarWidth = (0, common_1.calcScrollBarWidth)(grid.config, !!((_a = grid.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable));
    var totalScrollX = grid.config.$totalWidth - grid.config.$width + common_1.BORDERS + scrollBarWidth.y;
    var totalScrollY = grid.config.$totalHeight -
        grid.config.$height +
        grid.config.$headerHeight +
        grid.config.$footerHeight +
        common_1.BORDERS +
        scrollBarWidth.x;
    return {
        x: totalScrollX > 0 ? totalScrollX - scrollState.x : 0,
        y: totalScrollY > 0 ? totalScrollY - scrollState.y : 0,
    };
}
exports.getReverseScrollState = getReverseScrollState;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Label = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(2);
var view_1 = __webpack_require__(9);
var ts_popup_1 = __webpack_require__(15);
var types_1 = __webpack_require__(6);
var Label = /** @class */ (function (_super) {
    __extends(Label, _super);
    function Label(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, container, config) || this;
        _this._handlers = __assign({ showHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            }, hideHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.hide();
            } }, _this._getHandlers());
        var render = function () { return _this.config && _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Label.prototype.setValidationStatus = function (state) {
        if (state === void 0) { state = "pre"; }
        this.config.$validationStatus = types_1.ValidationStatus[state];
    };
    Label.prototype._destructor = function () {
        this._helper && this._helper.destructor();
        this.config = this._handlers = this._helper = null;
        this.unmount();
    };
    Label.prototype._getHandlers = function () {
        return {};
    };
    Label.prototype._init = function () {
        return;
    };
    Label.prototype._draw = function () {
        return this._drawLabel();
    };
    Label.prototype._drawLabel = function () {
        var _a = this.config, id = _a.id, helpMessage = _a.helpMessage, required = _a.required;
        if (this.config.helpMessage) {
            if (this._helper) {
                this._helper.attachHTML(this.config.helpMessage);
            }
            else {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
        }
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        return (labelStyle &&
            (0, dom_1.el)("".concat(this.config.type.includes("group") ? "legend" : "label", ".dhx_label"), {
                for: id || this._uid,
                class: helpMessage ? "dhx_label--with-help" : "",
                style: labelStyle.style,
            }, helpMessage
                ? [
                    (labelStyle.label || required) && (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                    (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                        tabindex: "0",
                        role: "button",
                        onclick: this._handlers.showHelper,
                        onfocus: this._handlers.showHelper,
                        onblur: this._handlers.hideHelper,
                        id: "dhx_label__help_".concat(id || this._uid),
                    }),
                ]
                : labelStyle.label));
    };
    return Label;
}(view_1.View));
exports.Label = Label;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(46), exports);
__exportStar(__webpack_require__(144), exports);
__exportStar(__webpack_require__(47), exports);


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(145), exports);
__exportStar(__webpack_require__(146), exports);
__exportStar(__webpack_require__(147), exports);
__exportStar(__webpack_require__(73), exports);
__exportStar(__webpack_require__(48), exports);


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(163), exports);
__exportStar(__webpack_require__(75), exports);


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.KeyManager = void 0;
var FocusManager_1 = __webpack_require__(20);
var html_1 = __webpack_require__(2);
function getHotKeyCode(code) {
    var matches = code.toLowerCase().match(/\w+/g);
    var comp = 0;
    var key = "";
    for (var i = 0; i < matches.length; i++) {
        var check = matches[i];
        if (check === "ctrl") {
            comp += 4;
        }
        else if (check === "shift") {
            comp += 2;
        }
        else if (check === "alt") {
            comp += 1;
        }
        else {
            key = check;
        }
    }
    return comp + key;
}
var ie_key_map = {
    Up: "arrowUp",
    Down: "arrowDown",
    Right: "arrowRight",
    Left: "arrowLeft",
    Esc: "escape",
    Spacebar: "space",
};
var KeyManager = /** @class */ (function () {
    function KeyManager(beforeCall) {
        var _this = this;
        this._keysStorage = {};
        this._initHandler = function (e) {
            var key;
            if ((e.which >= 48 && e.which <= 57) || (e.which >= 65 && e.which <= 90)) {
                key = String.fromCharCode(e.which);
            }
            else {
                var keyName = e.which === 32 ? e.code : e.key;
                key = (0, html_1.isIE)() ? ie_key_map[keyName] || keyName : keyName;
            }
            var actions = _this._keysStorage[(e.ctrlKey || e.metaKey ? 4 : 0) +
                (e.shiftKey ? 2 : 0) +
                (e.altKey ? 1 : 0) +
                (key && key.toLowerCase())];
            if (actions) {
                for (var i = 0; i < actions.length; i++) {
                    if (_this._beforeCall && _this._beforeCall(e, FocusManager_1.focusManager.getFocusId()) === false) {
                        return;
                    }
                    actions[i].handler(e);
                }
            }
        };
        if (beforeCall) {
            this._beforeCall = beforeCall;
        }
        document.addEventListener("keydown", this._initHandler);
    }
    KeyManager.prototype.destructor = function () {
        document.removeEventListener("keydown", this._initHandler);
        this.removeHotKey();
    };
    KeyManager.prototype.addHotKey = function (key, handler) {
        var code = getHotKeyCode(key);
        if (!this._keysStorage[code]) {
            this._keysStorage[code] = [];
        }
        this._keysStorage[code].push({ handler: handler });
    };
    KeyManager.prototype.removeHotKey = function (key, handler) {
        var _this = this;
        if (key) {
            if (key && handler) {
                var code_1 = getHotKeyCode(key);
                var functionToString_1 = function (fun) {
                    return fun
                        .toString()
                        .replace(/\n/g, "")
                        .replace(/\s/g, "");
                };
                this._keysStorage[code_1].forEach(function (existHotKey, i) {
                    if (functionToString_1(existHotKey.handler) === functionToString_1(handler)) {
                        delete _this._keysStorage[code_1][i];
                        _this._keysStorage[code_1] = _this._keysStorage[code_1].filter(function (el) { return el; });
                    }
                });
            }
            else {
                var code = getHotKeyCode(key);
                delete this._keysStorage[code];
            }
        }
        else {
            this._keysStorage = {};
        }
    };
    KeyManager.prototype.exist = function (key) {
        var code = getHotKeyCode(key);
        return !!this._keysStorage[code];
    };
    KeyManager.prototype.getKeyStorageLength = function () {
        return Object.keys(this._keysStorage).length;
    };
    return KeyManager;
}());
exports.KeyManager = KeyManager;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrFixedCols = exports.calcScrollBarWidth = exports.BORDERS = void 0;
var html_1 = __webpack_require__(2);
var types_1 = __webpack_require__(5);
exports.BORDERS = 2;
function calcScrollBarWidth(config, customScroll, sizes) {
    var _a, _b;
    if (customScroll === void 0) { customScroll = false; }
    var yState = config.$totalHeight + config.$headerHeight + config.$footerHeight + exports.BORDERS >
        ((_a = sizes === null || sizes === void 0 ? void 0 : sizes.height) !== null && _a !== void 0 ? _a : config.$height);
    var scrollbarY = !yState || customScroll ? 0 : (0, html_1.getScrollbarWidth)();
    var xState = config.$totalWidth + exports.BORDERS + scrollbarY > ((_b = sizes === null || sizes === void 0 ? void 0 : sizes.width) !== null && _b !== void 0 ? _b : config.$width);
    var scrollbarX = !xState || customScroll ? 0 : (0, html_1.getScrollbarWidth)();
    return { x: scrollbarX, y: scrollbarY, xState: xState, yState: yState };
}
exports.calcScrollBarWidth = calcScrollBarWidth;
function getCurrFixedCols(config, split) {
    if (!config[split])
        return [];
    return (split === types_1.Split.left
        ? config.columns.slice(0, config.leftSplit)
        : config.columns.slice(-config.rightSplit)).filter(function (col) { return !col.hidden; });
}
exports.getCurrFixedCols = getCurrFixedCols;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, setImmediate) {(function () {
  global = typeof window !== 'undefined' ? window : this

  var queueId = 1
  var queue = {}
  var isRunningTask = false

  if (!global.setImmediate)
    global.addEventListener('message', function (e) {
      if (e.source == global){
        if (isRunningTask)
          nextTick(queue[e.data])
        else {
          isRunningTask = true
          try {
            queue[e.data]()
          } catch (e) {}

          delete queue[e.data]
          isRunningTask = false
        }
      }
    })

  function nextTick(fn) {
    if (global.setImmediate) setImmediate(fn)
    // if inside of web worker
    else if (global.importScripts) setTimeout(fn)
    else {
      queueId++
      queue[queueId] = fn
      global.postMessage(queueId, '*')
    }
  }

  Deferred.resolve = function (value) {
    if (!(this._d == 1))
      throw TypeError()

    if (value instanceof Deferred)
      return value

    return new Deferred(function (resolve) {
        resolve(value)
    })
  }

  Deferred.reject = function (value) {
    if (!(this._d == 1))
      throw TypeError()

    return new Deferred(function (resolve, reject) {
        reject(value)
    })
  }

  Deferred.all = function (arr) {
    if (!(this._d == 1))
      throw TypeError()

    if (!(arr instanceof Array))
      return Deferred.reject(TypeError())

    var d = new Deferred()

    function done(e, v) {
      if (v)
        return d.resolve(v)

      if (e)
        return d.reject(e)

      var unresolved = arr.reduce(function (cnt, v) {
        if (v && v.then)
          return cnt + 1
        return cnt
      }, 0)

      if(unresolved == 0)
        d.resolve(arr)

      arr.map(function (v, i) {
        if (v && v.then)
          v.then(function (r) {
            arr[i] = r
            done()
            return r
          }, done)
      })
    }

    done()

    return d
  }

  Deferred.race = function (arr) {
    if (!(this._d == 1))
      throw TypeError()

    if (!(arr instanceof Array))
      return Deferred.reject(TypeError())

    if (arr.length == 0)
      return new Deferred()

    var d = new Deferred()

    function done(e, v) {
      if (v)
        return d.resolve(v)

      if (e)
        return d.reject(e)

      var unresolved = arr.reduce(function (cnt, v) {
        if (v && v.then)
          return cnt + 1
        return cnt
      }, 0)

      if(unresolved == 0)
        d.resolve(arr)

      arr.map(function (v, i) {
        if (v && v.then)
          v.then(function (r) {
            done(null, r)
          }, done)
      })
    }

    done()

    return d
  }

  Deferred._d = 1


  /**
   * @constructor
   */
  function Deferred(resolver) {
    'use strict'
    if (typeof resolver != 'function' && resolver != undefined)
      throw TypeError()

    if (typeof this != 'object' || (this && this.then))
      throw TypeError()

    // states
    // 0: pending
    // 1: resolving
    // 2: rejecting
    // 3: resolved
    // 4: rejected
    var self = this,
      state = 0,
      val = 0,
      next = [],
      fn, er;

    self['promise'] = self

    self['resolve'] = function (v) {
      fn = self.fn
      er = self.er
      if (!state) {
        val = v
        state = 1

        nextTick(fire)
      }
      return self
    }

    self['reject'] = function (v) {
      fn = self.fn
      er = self.er
      if (!state) {
        val = v
        state = 2

        nextTick(fire)

      }
      return self
    }

    self['_d'] = 1

    self['then'] = function (_fn, _er) {
      if (!(this._d == 1))
        throw TypeError()

      var d = new Deferred()

      d.fn = _fn
      d.er = _er
      if (state == 3) {
        d.resolve(val)
      }
      else if (state == 4) {
        d.reject(val)
      }
      else {
        next.push(d)
      }

      return d
    }

    self['catch'] = function (_er) {
      return self['then'](null, _er)
    }

    var finish = function (type) {
      state = type || 4
      next.map(function (p) {
        state == 3 && p.resolve(val) || p.reject(val)
      })
    }

    try {
      if (typeof resolver == 'function')
        resolver(self['resolve'], self['reject'])
    } catch (e) {
      self['reject'](e)
    }

    return self

    // ref : reference to 'then' function
    // cb, ec, cn : successCallback, failureCallback, notThennableCallback
    function thennable (ref, cb, ec, cn) {
      // Promises can be rejected with other promises, which should pass through
      if (state == 2) {
        return cn()
      }
      if ((typeof val == 'object' || typeof val == 'function') && typeof ref == 'function') {
        try {

          // cnt protects against abuse calls from spec checker
          var cnt = 0
          ref.call(val, function (v) {
            if (cnt++) return
            val = v
            cb()
          }, function (v) {
            if (cnt++) return
            val = v
            ec()
          })
        } catch (e) {
          val = e
          ec()
        }
      } else {
        cn()
      }
    };

    function fire() {

      // check if it's a thenable
      var ref;
      try {
        ref = val && val.then
      } catch (e) {
        val = e
        state = 2
        return fire()
      }

      thennable(ref, function () {
        state = 1
        fire()
      }, function () {
        state = 2
        fire()
      }, function () {
        try {
          if (state == 1 && typeof fn == 'function') {
            val = fn(val)
          }

          else if (state == 2 && typeof er == 'function') {
            val = er(val)
            state = 1
          }
        } catch (e) {
          val = e
          return finish()
        }

        if (val == self) {
          val = TypeError()
          finish()
        } else thennable(ref, function () {
            finish(3)
          }, finish, function () {
            finish(state == 1 && 3)
          })

      })
    }


  }

  // Export our library object, either for node.js or as a globally scoped variable
  if (true) {
    module['exports'] = Deferred
  } else {}
})()

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(43), __webpack_require__(127).setImmediate))

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DateHelper = exports.stringToDate = exports.getExcelDate = exports.getFormattedDate = exports.locale = void 0;
var core_1 = __webpack_require__(1);
var core_2 = __webpack_require__(1);
exports.locale = {
    monthsShort: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    months: [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December",
    ],
    daysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Monday"],
    cancel: "Cancel",
};
/*
    %d	day as a number with leading zero, 01..31
    %j	day as a number, 1..31
    %D	short name of the day, Su Mo Tu...
    %l	full name of the day, Sunday Monday Tuesday...
    %m	month as a number with leading zero, 01..12
    %n	month as a number, 1..12
    %M	short name of the month, Jan Feb Mar...
    %F	full name of the month, January February March...
    %y	year as a number, 2 digits
    %Y	year as a number, 4 digits
    %h	hours 12-format with leading zero, 01..12)
    %g	hours 12-format, 1..12)
    %H	hours 24-format with leading zero, 01..24
    %G	hours 24-format, 1..24
    %i	minutes with leading zero, 01..59
    %s	seconds with leading zero, 01..59
    %a	am or pm
    %A	AM or PM
    %u	milliseconds
*/
var formatters = {
    "%d": function (date) {
        var day = date.getDate();
        return day < 10 ? "0" + day : day;
    },
    "%j": function (date) { return date.getDate(); },
    "%l": function (date) {
        return exports.locale.days[date.getDay()];
    },
    "%D": function (date) {
        return exports.locale.daysShort[date.getDay()];
    },
    "%m": function (date) {
        var month = date.getMonth() + 1;
        return month < 10 ? "0" + month : month;
    },
    "%n": function (date) { return date.getMonth() + 1; },
    "%M": function (date) { return exports.locale.monthsShort[date.getMonth()]; },
    "%F": function (date) { return exports.locale.months[date.getMonth()]; },
    "%y": function (date) {
        return date
            .getFullYear()
            .toString()
            .slice(2);
    },
    "%Y": function (date) { return date.getFullYear(); },
    "%h": function (date) {
        var hours = date.getHours() % 12;
        if (hours === 0) {
            hours = 12;
        }
        return hours < 10 ? "0" + hours : hours;
    },
    "%g": function (date) {
        var hours = date.getHours() % 12;
        if (hours === 0) {
            hours = 12;
        }
        return hours;
    },
    "%H": function (date) {
        var hours = date.getHours();
        return hours < 10 ? "0" + hours : hours;
    },
    "%G": function (date) { return date.getHours(); },
    "%i": function (date) {
        var minutes = date.getMinutes();
        return minutes < 10 ? "0" + minutes : minutes;
    },
    "%s": function (date) {
        var seconds = date.getSeconds();
        return seconds < 10 ? "0" + seconds : seconds;
    },
    "%a": function (date) {
        return date.getHours() >= 12 ? "pm" : "am";
    },
    "%A": function (date) {
        return date.getHours() >= 12 ? "PM" : "AM";
    },
    "%u": function (date) { return date.getMilliseconds(); },
};
var setFormatters = {
    "%d": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setDate(Number(value)) : date.setDate(Number(1));
    },
    "%j": function (date, value, _format, validate) {
        var check = /(^([0-9]?[0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setDate(Number(value)) : date.setDate(Number(1));
    },
    "%m": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMonth(Number(value) - 1) : date.setMonth(Number(0));
        if (check && date.getMonth() !== Number(value) - 1)
            date.setMonth(Number(value) - 1);
    },
    "%n": function (date, value, _format, validate) {
        var check = /(^([0-9]?[0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMonth(Number(value) - 1) : date.setMonth(Number(0));
        if (check && date.getMonth() !== Number(value) - 1)
            date.setMonth(Number(value) - 1);
    },
    "%M": function (date, value, _format, validate) {
        var index = (0, core_2.findIndex)(exports.locale.monthsShort, function (v) { return v === value; });
        if (validate) {
            return index !== -1;
        }
        index === -1 ? date.setMonth(0) : date.setMonth(index);
        if (index !== -1 && date.getMonth() !== index)
            date.setMonth(index);
    },
    "%F": function (date, value, _format, validate) {
        var index = (0, core_2.findIndex)(exports.locale.months, function (v) { return v === value; });
        if (validate) {
            return index !== -1;
        }
        index === -1 ? date.setMonth(0) : date.setMonth(index);
        if (index !== -1 && date.getMonth() !== index)
            date.setMonth(index);
    },
    "%y": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setFullYear(Number("20" + value)) : date.setFullYear(Number("2000"));
    },
    "%Y": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9][0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setFullYear(Number(value)) : date.setFullYear(Number("2000"));
    },
    "%h": function (date, value, dateFormat, validate) {
        var check = /(^0[1-9]|1[0-2]$)/i.test(value);
        if (validate) {
            return check;
        }
        (check && (dateFormat === "am" || dateFormat === "pm")) || dateFormat === "AM" || dateFormat === "PM"
            ? date.setHours(Number(value))
            : date.setHours(Number(0));
    },
    "%g": function (date, value, dateFormat, validate) {
        var check = /(^[1-9]$)|(^0[1-9]|1[0-2]$)/i.test(value);
        if (validate) {
            return check;
        }
        (check && (dateFormat === "am" || dateFormat === "pm")) || dateFormat === "AM" || dateFormat === "PM"
            ? date.setHours(Number(value))
            : date.setHours(Number(0));
    },
    "%H": function (date, value, _format, validate) {
        var check = /(^[0-2][0-9]$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setHours(Number(value)) : date.setHours(Number(0));
    },
    "%G": function (date, value, _format, validate) {
        var check = /(^[1-9][0-9]?$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setHours(Number(value)) : date.setHours(Number(0));
    },
    "%i": function (date, value, _format, validate) {
        var check = /(^([0-5][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMinutes(Number(value)) : date.setMinutes(Number(0));
    },
    "%s": function (date, value, _format, validate) {
        var check = /(^([0-5][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setSeconds(Number(value)) : date.setSeconds(Number(0));
    },
    "%u": function (date, value, _format, validate) {
        var check = /(^([0-9][0-9][0-9])$)/i.test(value);
        if (validate) {
            return check;
        }
        check ? date.setMilliseconds(Number(value)) : date.setMilliseconds(Number(0));
    },
    "%a": function (date, value, _format, validate) {
        if (validate) {
            return value === "pm" || value === "am";
        }
        value === "pm" && date.setHours(date.getHours() + 12);
    },
    "%A": function (date, value, _format, validate) {
        if (validate) {
            return value === "PM" || value === "AM";
        }
        value === "PM" && date.setHours(date.getHours() + 12);
    },
};
var TokenType;
(function (TokenType) {
    TokenType[TokenType["separator"] = 0] = "separator";
    TokenType[TokenType["datePart"] = 1] = "datePart";
})(TokenType || (TokenType = {}));
function tokenizeFormat(format) {
    var tokens = [];
    var currentSeparator = "";
    for (var i = 0; i < format.length; i++) {
        if (format[i] === "%") {
            if (currentSeparator.length > 0) {
                tokens.push({
                    type: TokenType.separator,
                    value: currentSeparator,
                });
                currentSeparator = "";
            }
            tokens.push({
                type: TokenType.datePart,
                value: format[i] + format[i + 1],
            });
            i++;
        }
        else {
            currentSeparator += format[i];
        }
    }
    if (currentSeparator.length > 0) {
        tokens.push({
            type: TokenType.separator,
            value: currentSeparator,
        });
    }
    return tokens;
}
function getFormattedDate(format, date) {
    return tokenizeFormat(format).reduce(function (res, token) {
        if (token.type === TokenType.separator) {
            return res + token.value;
        }
        else {
            if (!formatters[token.value]) {
                return res;
            }
            return res + formatters[token.value](date);
        }
    }, "");
}
exports.getFormattedDate = getFormattedDate;
function getExcelDate(date) {
    if (!date)
        return null;
    var returnDateTime = 25569 + (date.getTime() - date.getTimezoneOffset() * 60000) / (86400 * 1000);
    return returnDateTime;
}
exports.getExcelDate = getExcelDate;
var datePartQueue = { "%Y": 1, "%y": 1, "%M": 2, "%F": 2, "%m": 2, "%n": 2 };
function stringToDate(str, format, validate) {
    if (typeof str !== "string") {
        return;
    }
    format = format.replace(/([a-z])(%a)/i, function () {
        var match = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            match[_i] = arguments[_i];
        }
        str = str.replace(/(am|pm)/i, " $&");
        return match[1] + " " + match[2];
    });
    var tokens = tokenizeFormat(format);
    var dateParts = new Array(2);
    var index = 0;
    var formatter = null;
    var dateFormat;
    var message = "Incorrect date, see docs: https://docs.dhtmlx.com/suite/calendar__api__calendar_dateformat_config.html";
    var addDatePart = function (part) {
        var queue = datePartQueue[part.formatter];
        if (queue) {
            dateParts[queue - 1] = part;
            return;
        }
        if (part.formatter === "%A" || part.formatter === "%a") {
            dateFormat = part.value;
        }
        dateParts.push(part);
    };
    for (var i = 0; i < tokens.length; i++) {
        if (tokens[i].type === TokenType.separator) {
            var separatorIndex = str.indexOf(tokens[i].value, index);
            if (separatorIndex === -1) {
                if (validate) {
                    return false;
                }
                throw new Error(message);
            }
            if (formatter) {
                addDatePart({
                    formatter: formatter,
                    value: str.slice(index, separatorIndex),
                });
                formatter = null;
            }
            index = separatorIndex + tokens[i].value.length;
        }
        else if (tokens[i].type === TokenType.datePart) {
            if (tokens[i + 1] && tokens[i + 1].type !== TokenType.separator) {
                if (validate) {
                    return false;
                }
                throw new Error(message);
            }
            else {
                formatter = tokens[i].value;
            }
        }
    }
    if (formatter) {
        addDatePart({
            formatter: formatter,
            value: str.slice(index),
        });
    }
    var date = new Date(0);
    for (var _i = 0, dateParts_1 = dateParts; _i < dateParts_1.length; _i++) {
        var datePart = dateParts_1[_i];
        if (!datePart)
            continue;
        if (setFormatters[datePart.formatter]) {
            if (validate && !setFormatters[datePart.formatter](date, datePart.value, dateFormat, validate)) {
                return false;
            }
            setFormatters[datePart.formatter](date, datePart.value, dateFormat);
        }
    }
    return validate ? true : date;
}
exports.stringToDate = stringToDate;
var DateHelper = exports.DateHelper = /** @class */ (function () {
    function DateHelper() {
    }
    DateHelper.copy = function (d) {
        return new Date(d);
    };
    DateHelper.fromYear = function (year) {
        return new Date(year, 0, 1);
    };
    DateHelper.fromYearAndMonth = function (year, month) {
        return new Date(year, month, 1);
    };
    DateHelper.weekStart = function (d, firstWeekday) {
        var diff = (d.getDay() + 7 - firstWeekday) % 7;
        return new Date(d.getFullYear(), d.getMonth(), d.getDate() - diff);
    };
    DateHelper.monthStart = function (d) {
        return new Date(d.getFullYear(), d.getMonth(), 1);
    };
    DateHelper.yearStart = function (d) {
        return new Date(d.getFullYear(), 0, 1);
    };
    DateHelper.dayStart = function (d) {
        return new Date(d.getFullYear(), d.getMonth(), d.getDate());
    };
    DateHelper.addDay = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear(), d.getMonth(), d.getDate() + count);
    };
    DateHelper.addMonth = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear(), d.getMonth() + count);
    };
    DateHelper.addYear = function (d, count) {
        if (count === void 0) { count = 1; }
        return new Date(d.getFullYear() + count, d.getMonth());
    };
    DateHelper.withHoursAndMinutes = function (d, hours, minutes, dateFormat) {
        if (dateFormat === undefined || (!dateFormat && hours === 12) || (dateFormat && hours !== 12)) {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), hours, minutes);
        }
        else if (dateFormat && hours === 12) {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), 0, minutes);
        }
        else {
            return new Date(d.getFullYear(), d.getMonth(), d.getDate(), hours + 12, minutes);
        }
    };
    DateHelper.setMonth = function (d, month) {
        d.setMonth(month);
    };
    DateHelper.setYear = function (d, year) {
        d.setFullYear(year);
    };
    DateHelper.mergeHoursAndMinutes = function (source, target) {
        return new Date(source.getFullYear(), source.getMonth(), source.getDate(), target.getHours(), target.getMinutes());
    };
    DateHelper.isWeekEnd = function (d) {
        return d.getDay() === 0 || d.getDay() === 6;
    };
    DateHelper.getTwelweYears = function (d) {
        var y = d.getFullYear();
        var firstYear = y - (y % 12);
        return (0, core_1.range)(firstYear, firstYear + 11);
    };
    DateHelper.getDayOrdinal = function (d) {
        var dayMS = 24 * 60 * 60 * 1000;
        return (d.valueOf() - DateHelper.yearStart(d).valueOf()) / dayMS;
    };
    DateHelper.getWeekNumber = function (d) {
        var currThursday = d.getDay() === 4 ? d : DateHelper.addDay(d, 4 - d.getDay());
        var ordinal = DateHelper.getDayOrdinal(currThursday);
        return Math.trunc(ordinal / 7) + 1;
    };
    DateHelper.isSameDay = function (d1, d2) {
        return (d1.getFullYear() === d2.getFullYear() &&
            d1.getMonth() === d2.getMonth() &&
            d1.getDate() === d2.getDate());
    };
    DateHelper.toDateObject = function (date, dateFormat) {
        if (typeof date === "string") {
            return stringToDate(date, dateFormat);
        }
        else {
            return new Date(date);
        }
    };
    DateHelper.nullTimestampDate = new Date(0);
    return DateHelper;
}());


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.focusManager = void 0;
var html_1 = __webpack_require__(2);
var FocusManager = /** @class */ (function () {
    function FocusManager() {
        var _this = this;
        this._initHandler = function (e) { return (_this._activeWidgetId = (0, html_1.locate)(e, "data-dhx-widget-id")); };
        this._removeFocusClass = function (e) {
            var classList = document.body.classList;
            if (classList.contains("utilityfocus"))
                classList.remove("utilityfocus");
        };
        this._addFocusClass = function (e) {
            var classList = document.body.classList;
            if (e.code === "Tab") {
                if (!classList.contains("utilityfocus"))
                    classList.add("utilityfocus");
            }
            else {
                if (classList.contains("utilityfocus"))
                    classList.remove("utilityfocus");
            }
        };
        document.addEventListener("focusin", this._initHandler);
        document.addEventListener("pointerdown", this._initHandler);
        document.addEventListener("mousedown", this._removeFocusClass);
        document.addEventListener("keydown", this._addFocusClass);
    }
    FocusManager.prototype.getFocusId = function () {
        return this._activeWidgetId;
    };
    FocusManager.prototype.setFocusId = function (id) {
        this._activeWidgetId = id;
    };
    return FocusManager;
}());
exports.focusManager = new FocusManager();


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.splitCsv = exports.throwMoveWarning = exports.isOnlyPermanentFilters = exports.hasJsonOrArrayStructure = exports.isTreeCollection = exports.copyWithoutInner = exports.toDataDriver = exports.toProxy = exports.dhxError = exports.dhxWarning = exports.isDebug = exports.findByConf = exports.naturalCompare = exports.isEqualObj = void 0;
var core_1 = __webpack_require__(1);
var dataproxy_1 = __webpack_require__(28);
var drivers_1 = __webpack_require__(65);
function isEqualObj(a, b) {
    for (var key in a) {
        if (a[key] !== b[key] || Array.isArray(a[key])) {
            return false;
        }
    }
    return true;
}
exports.isEqualObj = isEqualObj;
function naturalCompare(a, b) {
    if (isNaN(a) || isNaN(b)) {
        var ax_1 = [];
        var bx_1 = [];
        a.replace(/(\d+)|(\D+)/g, function (_, $1, $2) {
            ax_1.push([$1 || Infinity, $2 || ""]);
        });
        b.replace(/(\d+)|(\D+)/g, function (_, $1, $2) {
            bx_1.push([$1 || Infinity, $2 || ""]);
        });
        while (ax_1.length && bx_1.length) {
            var an = ax_1.shift();
            var bn = bx_1.shift();
            var nn = an[0] - bn[0] || an[1].localeCompare(bn[1]);
            if (nn) {
                return nn;
            }
        }
        return ax_1.length - bx_1.length;
    }
    return a - b;
}
exports.naturalCompare = naturalCompare;
function findByConf(item, conf, index, array) {
    if (typeof conf === "function") {
        if (conf.call(this, item, index, array)) {
            return item;
        }
    }
    else if (conf.by && conf.match) {
        if (item[conf.by] === conf.match) {
            return item;
        }
    }
}
exports.findByConf = findByConf;
function isDebug() {
    var dhx = window.dhx;
    if (typeof dhx !== "undefined") {
        return typeof dhx.debug !== "undefined" && dhx.debug;
    }
    // return typeof DHX_DEBUG_MODE !== "undefined" && DHX_DEBUG_MODE;
}
exports.isDebug = isDebug;
function dhxWarning(msg) {
    // tslint:disable-next-line:no-console
    console.warn(msg);
}
exports.dhxWarning = dhxWarning;
function dhxError(msg) {
    throw new Error(msg);
}
exports.dhxError = dhxError;
function toProxy(proxy) {
    var type = typeof proxy;
    if (type === "string") {
        return new dataproxy_1.DataProxy(proxy);
    }
    else if (type === "object") {
        return proxy;
    }
}
exports.toProxy = toProxy;
function toDataDriver(driver) {
    if (typeof driver === "string") {
        var dhx = window.dhx;
        var drivers = (dhx && dhx.dataDrivers) || drivers_1.dataDrivers;
        if (drivers[driver]) {
            return new drivers[driver]();
        }
        else {
            // tslint:disable-next-line:no-console
            console.warn("Incorrect data driver type:", driver);
            // tslint:disable-next-line:no-console
            console.warn("Available types:", JSON.stringify(Object.keys(drivers)));
        }
    }
    else if (typeof driver === "object") {
        return driver;
    }
}
exports.toDataDriver = toDataDriver;
function copyWithoutInner(obj, forbidden) {
    var result = {};
    for (var key in obj) {
        if (!key.startsWith("$") && (!forbidden || !forbidden[key])) {
            result[key] = obj[key];
        }
    }
    return result;
}
exports.copyWithoutInner = copyWithoutInner;
function isTreeCollection(obj) {
    // eslint-disable-next-line @typescript-eslint/unbound-method
    return Boolean(obj.getRoot);
}
exports.isTreeCollection = isTreeCollection;
function hasJsonOrArrayStructure(str) {
    if (typeof str === "object") {
        return true;
    }
    if (typeof str !== "string") {
        return false;
    }
    try {
        var result = JSON.parse(str);
        return Object.prototype.toString.call(result) === "[object Object]" || Array.isArray(result);
    }
    catch (err) {
        return false;
    }
}
exports.hasJsonOrArrayStructure = hasJsonOrArrayStructure;
function isOnlyPermanentFilters(filters) {
    if (!filters || (0, core_1.isEmptyObj)(filters))
        return false;
    return Object.keys(filters).every(function (key) {
        var _a;
        return (_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent;
    });
}
exports.isOnlyPermanentFilters = isOnlyPermanentFilters;
function throwMoveWarning(id, exists) {
    if (exists === void 0) { exists = true; }
    dhxWarning("item with ID ".concat(id, " not ").concat(exists ? "moved" : "found"));
    return null;
}
exports.throwMoveWarning = throwMoveWarning;
function splitCsv(csv, delimiter) {
    return csv.trim().split(new RegExp("".concat(delimiter, "(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")));
}
exports.splitCsv = splitCsv;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ScrollView = exports.scrollViewConfig = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(2);
exports.scrollViewConfig = {
    enable: false,
    autoHide: true,
    timeout: 1000,
    scrollHandler: function () { },
};
var ScrollView = /** @class */ (function () {
    function ScrollView(getRootView, config) {
        var _a;
        if (config === void 0) { config = {}; }
        var _this = this;
        this.config = (0, core_1.extend)({
            enable: exports.scrollViewConfig.enable,
            autoHide: exports.scrollViewConfig.autoHide,
            timeout: exports.scrollViewConfig.timeout,
            scrollHandler: exports.scrollViewConfig.scrollHandler,
        }, config);
        this._wheelName = (0, html_1.isIE)() ? "onmousewheel" : "onwheel";
        this._getRootView = getRootView;
        this._scrollYTop = this._scrollXLeft = this._runnerYTop = this._runnerXLeft = this._runnerHeight = this._runnerWidth = 0;
        this._visibleYArea = this._visibleXArea = 1;
        this._scrollWidth = (0, html_1.getScrollbarWidth)();
        this._scrollHeight = (0, html_1.getScrollbarHeight)();
        this._handlers = (_a = {
                onscroll: function (e) {
                    _this.config.scrollHandler(e);
                    _this.update();
                }
            },
            _a[this._wheelName] = function (e) {
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                e.preventDefault();
                var sign = (e.deltaY || -e.wheelDelta) > 0 ? 1 : -1;
                var delta = sign * 40;
                var area = _this._getRefs().area;
                if (isY) {
                    var maxBottom = area.scrollHeight - _this._runnerHeight;
                    var newScrollTop = _this._scrollYTop + delta;
                    if (newScrollTop < 0) {
                        area.scrollTop = 0;
                    }
                    else if (newScrollTop > maxBottom) {
                        area.scrollTop = maxBottom;
                    }
                    else {
                        area.scrollTop = newScrollTop;
                    }
                }
                else {
                    var maxRight = area.scrollWidth - _this._runnerWidth;
                    var newScrollLeft = _this._scrollXLeft + delta;
                    if (newScrollLeft < 0) {
                        area.scrollLeft = 0;
                    }
                    else if (newScrollLeft > maxRight) {
                        area.scrollLeft = maxRight;
                    }
                    else {
                        area.scrollLeft = newScrollLeft;
                    }
                }
                _this.update();
            },
            _a.onmousedownRunner = function (mouseDownEv) {
                mouseDownEv.preventDefault();
                var isY = !!(0, html_1.locateNodeByClassName)(mouseDownEv.target, "y-scroll");
                var _a = _this._getRefs(), area = _a.area, runnerY = _a.runnerY, runnerX = _a.runnerX;
                var rect = area.getBoundingClientRect();
                var top = rect.top + window.pageYOffset;
                var bottom = rect.bottom + window.pageYOffset;
                var maxBottom = area.scrollHeight - _this._runnerHeight;
                var deltaY = mouseDownEv.pageY - runnerY.getBoundingClientRect().top - window.pageYOffset;
                var left = rect.left + window.pageXOffset;
                var right = rect.right + window.pageXOffset;
                var maxRight = area.scrollWidth - _this._runnerWidth;
                var deltaX = mouseDownEv.pageX - runnerX.getBoundingClientRect().left - window.pageXOffset;
                var mouseMove = function (e) {
                    if (isY) {
                        var y = e.pageY - deltaY;
                        if (y <= top) {
                            area.scrollTop = 0;
                        }
                        else if (y > bottom) {
                            area.scrollTop = maxBottom;
                        }
                        else {
                            area.scrollTop = (y - top) / _this._visibleYArea;
                        }
                    }
                    else {
                        var x = e.pageX - deltaX;
                        if (x <= left) {
                            area.scrollLeft = 0;
                        }
                        else if (x > right) {
                            area.scrollLeft = maxRight;
                        }
                        else {
                            area.scrollLeft = (x - left) / _this._visibleXArea;
                        }
                    }
                    _this.update();
                };
                var mouseUp = function () {
                    document.removeEventListener("mousemove", mouseMove);
                    document.removeEventListener("mouseup", mouseUp);
                    document.body.classList.remove("dhx-no-select");
                };
                document.body.classList.add("dhx-no-select");
                document.addEventListener("mousemove", mouseMove);
                document.addEventListener("mouseup", mouseUp);
            },
            _a.onmousedownArea = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                e.preventDefault();
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var _a = _this._getRefs(), area = _a.area, runnerY = _a.runnerY, runnerX = _a.runnerX;
                if (isY) {
                    area.scrollTop += (e.pageY - runnerY.getBoundingClientRect().top) / _this._visibleYArea;
                }
                else {
                    area.scrollLeft += (e.pageX - runnerX.getBoundingClientRect().left) / _this._visibleXArea;
                }
                _this.update();
            },
            _a.onmouseenter = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                var refs = _this._getRefs();
                if (!refs) {
                    return;
                }
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var areaX = refs.areaX, areaY = refs.areaY;
                if (isY && _this._runnerHeight > 0) {
                    areaY.style.background = "#eee";
                }
                else if (!isY && _this._runnerWidth > 0) {
                    areaX.style.background = "#eee";
                }
            },
            _a.onmouseleave = function (e) {
                if ((0, html_1.locateNodeByClassName)(e, "scroll-runner"))
                    return;
                var refs = _this._getRefs();
                if (!refs) {
                    return;
                }
                var isY = !!(0, html_1.locateNodeByClassName)(e.target, "y-scroll");
                var areaX = refs.areaX, areaY = refs.areaY;
                if (isY && _this._runnerHeight > 0) {
                    areaY.style.background = "transparent";
                }
                else if (!isY && _this._runnerWidth > 0) {
                    areaX.style.background = "transparent";
                }
            },
            _a);
    }
    ScrollView.prototype.enable = function () {
        this.config.enable = true;
        this._getRootView().redraw();
    };
    ScrollView.prototype.disable = function () {
        this.config.enable = false;
        this._getRootView().redraw();
    };
    ScrollView.prototype.render = function (element, uid) {
        var _a, _b;
        var _this = this;
        if (uid === void 0) { uid = ""; }
        if (!this.config.enable || !element.length) {
            return element;
        }
        if (uid)
            this._uid = uid;
        var scrollView = this.config.enable
            ? [
                (0, dom_1.el)(".y-scroll", (_a = {},
                    _a[this._wheelName] = this._handlers[this._wheelName],
                    _a._ref = uid ? "scroll-y-area-".concat(uid) : "scroll-y-area",
                    _a.onmousedown = this._handlers.onmousedownArea,
                    _a.onmouseenter = this._handlers.onmouseenter,
                    _a.onmouseleave = this._handlers.onmouseleave,
                    _a.style = {
                        width: "6px",
                        height: "100%",
                        right: 0,
                        top: 0,
                        position: "absolute",
                    },
                    _a), [
                    (0, dom_1.el)(".scroll-runner", {
                        _ref: uid ? "scroll-y-runner-".concat(uid) : "scroll-y-runner",
                        onmousedown: this._handlers.onmousedownRunner,
                        style: {
                            height: this._runnerHeight + "px",
                            top: this._runnerYTop,
                        },
                    }),
                ]),
                (0, dom_1.el)(".x-scroll", (_b = {},
                    _b[this._wheelName] = this._handlers[this._wheelName],
                    _b._ref = uid ? "scroll-x-area-".concat(uid) : "scroll-x-area",
                    _b.onmousedown = this._handlers.onmousedownArea,
                    _b.onmouseenter = this._handlers.onmouseenter,
                    _b.onmouseleave = this._handlers.onmouseleave,
                    _b.style = {
                        width: "100%",
                        height: "6px",
                        left: 0,
                        bottom: 0,
                        position: "absolute",
                    },
                    _b), [
                    (0, dom_1.el)(".scroll-runner", {
                        _ref: uid ? "scroll-x-runner-".concat(uid) : "scroll-x-runner",
                        onmousedown: this._handlers.onmousedownRunner,
                        style: {
                            width: this._runnerWidth + "px",
                            left: this._runnerXLeft,
                        },
                    }),
                ]),
            ]
            : null;
        return (0, dom_1.el)(".scroll-view-wrapper", [
            (0, dom_1.el)(".scroll-view", {
                class: (!this._scrollWidth && "scroll-view--overlay") || "",
                onscroll: this._handlers.onscroll,
                _ref: uid ? "scroll-view-".concat(uid) : "scroll-view",
                _hooks: {
                    didInsert: function () {
                        _this.update();
                    },
                    didRecycle: function () {
                        _this.update();
                    },
                },
                style: {
                    width: "calc(100% + ".concat(this._scrollWidth, "px)"),
                    height: "calc(100% + ".concat(this._scrollHeight, "px)"),
                    "margin-bottom": "-".concat(this._scrollHeight, "px"),
                },
            }, element),
        ].concat(scrollView));
    };
    ScrollView.prototype.update = function () {
        var refs = this._getRefs();
        if (!refs) {
            return;
        }
        var area = refs.area, areaX = refs.areaX, areaY = refs.areaY, runnerY = refs.runnerY, runnerX = refs.runnerX;
        this._visibleYArea = area.clientHeight / area.scrollHeight;
        this._visibleXArea = area.clientWidth / area.scrollWidth;
        this._scrollYTop = area.scrollTop;
        this._scrollXLeft = area.scrollLeft;
        this._runnerYTop = this._scrollYTop * this._visibleYArea;
        this._runnerXLeft = this._scrollXLeft * this._visibleXArea;
        this._runnerHeight = this._visibleYArea < 1 ? area.clientHeight * this._visibleYArea : 0;
        this._runnerWidth = this._visibleXArea < 1 ? area.clientWidth * this._visibleXArea : 0;
        var initialTop = runnerY.style.top;
        var initialLeft = runnerX.style.left;
        // update dom
        runnerY.style.opacity = 1;
        runnerY.style.top = this._runnerYTop + "px";
        runnerY.style.height = this._runnerHeight + "px";
        runnerX.style.opacity = 1;
        runnerX.style.left = this._runnerXLeft + "px";
        runnerX.style.width = this._runnerWidth + "px";
        if (initialTop !== runnerY.style.top) {
            areaY.style.opacity = 0.9;
            areaY.style.width = "10px";
        }
        if (initialLeft !== runnerX.style.left) {
            areaX.style.opacity = 0.9;
            areaX.style.height = "10px";
        }
        if (this.config.autoHide) {
            !this._autoHideFunc &&
                (this._autoHideFunc = (0, core_1.debounce)(function () {
                    runnerY.style.opacity = 0;
                    areaY.style.width = "6px";
                    runnerX.style.opacity = 0;
                    areaX.style.height = "6px";
                }, this.config.timeout));
        }
        else {
            this._autoHideFunc = (0, core_1.debounce)(function () {
                areaY.style.width = "6px";
                areaX.style.height = "6px";
            }, this.config.timeout);
        }
        this._autoHideFunc();
    };
    ScrollView.prototype._getRefs = function () {
        var rootView = this._getRootView();
        var refsCheck = !!(rootView.refs["scroll-view"] &&
            (rootView.refs["scroll-x-runner"] || rootView.refs["scroll-y-runner"]));
        var refsIdCheck = !!(this._uid &&
            rootView.refs["scroll-view-".concat(this._uid)] &&
            (rootView.refs["scroll-x-runner-".concat(this._uid)] || rootView.refs["scroll-y-runner-".concat(this._uid)]));
        if (rootView.refs) {
            if (refsCheck) {
                return {
                    area: rootView.refs["scroll-view"].el,
                    areaY: rootView.refs["scroll-y-area"].el,
                    areaX: rootView.refs["scroll-x-area"].el,
                    runnerY: rootView.refs["scroll-y-runner"].el,
                    runnerX: rootView.refs["scroll-x-runner"].el,
                };
            }
            else if (refsIdCheck) {
                return {
                    area: rootView.refs["scroll-view-".concat(this._uid)].el,
                    areaY: rootView.refs["scroll-y-area-".concat(this._uid)].el,
                    areaX: rootView.refs["scroll-x-area-".concat(this._uid)].el,
                    runnerY: rootView.refs["scroll-y-runner-".concat(this._uid)].el,
                    runnerX: rootView.refs["scroll-x-runner-".concat(this._uid)].el,
                };
            }
        }
    };
    return ScrollView;
}());
exports.ScrollView = ScrollView;


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(148), exports);
__exportStar(__webpack_require__(149), exports);
__exportStar(__webpack_require__(36), exports);


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatValue = exports.clearCells = exports.normalizeCell = exports.getReducedRowspan = exports.getReducedColspan = exports.getSpanHeight = exports.getWidth = void 0;
var date_1 = __webpack_require__(19);
function getWidth(columns, colspan, index) {
    return columns
        .slice(index, index + (colspan || 1))
        .filter(function (col) { return !col.hidden; })
        .reduce(function (width, col) { return width + col.$width; }, 0);
}
exports.getWidth = getWidth;
function getSpanHeight(rows, span) {
    var range = span.$rowsVisibility;
    return rows.slice(range[0], range[1] + 1).reduce(function (height, row) { return height + row.$height; }, 0);
}
exports.getSpanHeight = getSpanHeight;
function getReducedColspan(columns, colId, colspan) {
    var index = columns.findIndex(function (item) { return item.id === colId; });
    return columns.slice(index, index + (colspan || 1)).filter(function (col) { return !col.hidden; }).length;
}
exports.getReducedColspan = getReducedColspan;
function getReducedRowspan(initialRows, currRows, rowIndex, span) {
    var _a;
    var spanHeight = span.rowspan || 1;
    if (initialRows.length === currRows.length)
        return spanHeight;
    var initialRowIndex = (_a = initialRows === null || initialRows === void 0 ? void 0 : initialRows.findIndex(function (i) { return i.id === span.row; })) !== null && _a !== void 0 ? _a : -1;
    var rowCount = 0;
    if (initialRowIndex !== -1) {
        for (var i = 1; i < spanHeight; i++) {
            var curRow = currRows[rowIndex - rowCount + i];
            var initialRow = initialRows[initialRowIndex + i];
            if ((curRow === null || curRow === void 0 ? void 0 : curRow.id) !== (initialRow === null || initialRow === void 0 ? void 0 : initialRow.id)) {
                rowCount++;
            }
        }
    }
    return spanHeight - rowCount;
}
exports.getReducedRowspan = getReducedRowspan;
function normalizeCell(cell, grid) {
    if (!cell)
        return;
    var row = cell.row, column = cell.column;
    var span = grid.getSpan(row.id, column.id);
    if (!span)
        return cell;
    return {
        row: row.id === span.row ? row : grid.data.getItem(span.row),
        column: column.id === span.column ? column : grid.config.columns.find(function (col) { return col.id === span.column; }),
    };
}
exports.normalizeCell = normalizeCell;
function clearCells(grid, cells) {
    var rowMap = new Map(cells.map(function (_a) {
        var row = _a.row;
        return [row.id, row];
    }));
    var colSet = new Map(cells.map(function (_a) {
        var column = _a.column;
        return [column.id, column];
    }));
    var originalRows = [];
    var changedRows = [];
    var index = 0;
    rowMap.forEach(function (row) {
        var obj = {};
        colSet.forEach(function (column, colId) {
            if (column.editable !== false) {
                obj[colId] = "";
            }
        });
        originalRows.push(__assign({}, row));
        changedRows.push(__assign({ id: row.id }, obj));
        grid.data.update(row.id, obj, index < rowMap.size - 1);
        ++index;
    });
    if (grid.history) {
        grid.history.add({
            type: "change",
            batch: changedRows,
            inverse: {
                type: "change",
                batch: originalRows,
            },
        });
    }
    grid.paint();
}
exports.clearCells = clearCells;
function formatValue(value, cell) {
    var column = cell.column;
    var row = cell.row;
    var formattedValue = value;
    switch (column.type) {
        case "number": {
            var numValue = parseFloat(formattedValue === null || formattedValue === void 0 ? void 0 : formattedValue.toString().replace(/[^0-9.-]/g, ""));
            return isNaN(numValue) ? row[column.id] : numValue;
        }
        case "boolean": {
            if (typeof formattedValue === "boolean")
                return formattedValue;
            var strValue = formattedValue === null || formattedValue === void 0 ? void 0 : formattedValue.toString().toLowerCase();
            if (strValue === "true" || strValue === "1" || strValue === "yes")
                return true;
            if (strValue === "false" || strValue === "0" || strValue === "no")
                return false;
            return row[column.id];
        }
        case "date": {
            var dateFormat = column.dateFormat || "%M %d %Y";
            if (!(0, date_1.stringToDate)(formattedValue, dateFormat, true)) {
                var date = new Date(formattedValue);
                if (date === null || date === void 0 ? void 0 : date.valueOf()) {
                    formattedValue = (0, date_1.getFormattedDate)(dateFormat, date);
                }
                else {
                    formattedValue = row[column.id];
                }
            }
        }
    }
    return formattedValue;
}
exports.formatValue = formatValue;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataDriver = exports.DragEvents = exports.DataEvents = exports.TreeFilterType = void 0;
var TreeFilterType;
(function (TreeFilterType) {
    TreeFilterType["all"] = "all";
    TreeFilterType["level"] = "level";
    TreeFilterType["leafs"] = "leafs";
})(TreeFilterType || (exports.TreeFilterType = TreeFilterType = {}));
var DataEvents;
(function (DataEvents) {
    DataEvents["afterAdd"] = "afteradd";
    DataEvents["beforeAdd"] = "beforeadd";
    DataEvents["removeAll"] = "removeall";
    DataEvents["beforeRemove"] = "beforeremove";
    DataEvents["afterRemove"] = "afterremove";
    DataEvents["change"] = "change";
    DataEvents["filter"] = "filter";
    DataEvents["dataRequest"] = "dataRequest";
    DataEvents["load"] = "load";
    DataEvents["loadError"] = "loaderror";
    DataEvents["beforeLazyLoad"] = "beforelazyload";
    DataEvents["afterLazyLoad"] = "afterlazyload";
    DataEvents["beforeItemLoad"] = "beforeItemLoad";
    DataEvents["afterItemLoad"] = "afterItemLoad";
    DataEvents["beforeGroup"] = "beforeGroup";
    DataEvents["afterGroup"] = "afterGroup";
    DataEvents["beforeUnGroup"] = "beforeUnGroup";
    DataEvents["afterUnGroup"] = "afterUnGroup";
})(DataEvents || (exports.DataEvents = DataEvents = {}));
var DragEvents;
(function (DragEvents) {
    DragEvents["beforeDrag"] = "beforeDrag";
    DragEvents["dragStart"] = "dragStart";
    DragEvents["dragOut"] = "dragOut";
    DragEvents["dragIn"] = "dragIn";
    DragEvents["canDrop"] = "canDrop";
    DragEvents["cancelDrop"] = "cancelDrop";
    DragEvents["beforeDrop"] = "beforeDrop";
    DragEvents["afterDrop"] = "afterDrop";
    DragEvents["afterDrag"] = "afterDrag";
})(DragEvents || (exports.DragEvents = DragEvents = {}));
var DataDriver;
(function (DataDriver) {
    DataDriver["json"] = "json";
    DataDriver["csv"] = "csv";
    DataDriver["xml"] = "xml";
})(DataDriver || (exports.DataDriver = DataDriver = {}));


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartEvents = void 0;
var ChartEvents;
(function (ChartEvents) {
    ChartEvents["toggleSeries"] = "toggleSeries";
    ChartEvents["chartMouseMove"] = "chartMouseMove";
    ChartEvents["chartMouseLeave"] = "chartMouseLeave";
    ChartEvents["resize"] = "resize";
    ChartEvents["serieClick"] = "serieClick";
    // private
    ChartEvents["seriaMouseMove"] = "seriaMouseMove";
    ChartEvents["seriaMouseLeave"] = "seriaMouseLeave";
})(ChartEvents || (exports.ChartEvents = ChartEvents = {}));


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultHistoryConfig = exports.defaultDragPanelConfig = exports.defaultSubRowConfig = exports.getGroupDefaultConfig = void 0;
var en_1 = __webpack_require__(42);
var getGroupDefaultConfig = function (config) {
    if (typeof config === "boolean") {
        config = {};
    }
    return __assign(__assign({ type: "column", panel: true, panelHeight: 40, hideableColumns: true, showMissed: true }, config), { column: __assign({ id: typeof config.column === "string" ? config.column : null, header: [{ text: en_1.default.groupText }] }, (typeof config.column === "string" ? {} : config.column)) });
};
exports.getGroupDefaultConfig = getGroupDefaultConfig;
exports.defaultSubRowConfig = {
    height: 200,
    padding: 8,
    toggleIcon: true,
    expanded: false,
    preserve: false,
    fullWidth: false,
};
exports.defaultDragPanelConfig = {
    width: 26,
    icon: "dxi dxi-drag-vertical",
};
exports.defaultHistoryConfig = {
    limit: 15,
};


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataProxy = void 0;
var ajax_1 = __webpack_require__(44);
var DataProxy = /** @class */ (function () {
    function DataProxy(url, config) {
        if (config === void 0) { config = {}; }
        this.url = this._url = url;
        this.config = config;
    }
    DataProxy.prototype.updateUrl = function (url, params) {
        if (params === void 0) { params = {}; }
        this._url = this.url = url || this._url;
        this.url += this.url.includes("?") ? "&" : "?";
        for (var param in params) {
            this.config[param] = params[param];
            this.url += "".concat(param, "=").concat(encodeURIComponent(params[param]), "&");
        }
        this.url = this.url.slice(0, -1);
    };
    DataProxy.prototype.load = function () {
        return ajax_1.ajax.get(this.url, undefined, this.config);
    };
    DataProxy.prototype.save = function (data, mode) {
        switch (mode) {
            case "delete":
                return ajax_1.ajax.delete(this.url, data, this.config);
            case "update":
                return ajax_1.ajax.put(this.url, data, this.config);
            case "insert":
            default:
                return ajax_1.ajax.post(this.url, data, this.config);
        }
    };
    return DataProxy;
}());
exports.DataProxy = DataProxy;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectionEvents = void 0;
var SelectionEvents;
(function (SelectionEvents) {
    SelectionEvents["beforeUnSelect"] = "beforeunselect";
    SelectionEvents["afterUnSelect"] = "afterunselect";
    SelectionEvents["beforeSelect"] = "beforeselect";
    SelectionEvents["afterSelect"] = "afterselect";
})(SelectionEvents || (exports.SelectionEvents = SelectionEvents = {}));


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNavbarButtonCSS = exports.navbarComponentMixin = exports.getIcon = exports.getCount = void 0;
var dom_1 = __webpack_require__(0);
var core_1 = __webpack_require__(1);
function getCount(item, widgetClass, isLimited) {
    var countColor = {
        danger: " dhx_navbar-count--color_danger",
        secondary: " dhx_navbar-count--color_secondary",
        primary: " dhx_navbar-count--color_primary",
        success: " dhx_navbar-count--color_success",
    }[item.countColor] || " dhx_navbar-count--color_danger";
    return (0, dom_1.el)(".dhx_navbar-count", {
        class: widgetClass +
            countColor +
            (!isLimited && parseInt(item.count, 10) > 99 ? " dhx_navbar-count--overlimit" : ""),
    }, isLimited && parseInt(item.count, 10) > 99 ? "99+" : item.count);
}
exports.getCount = getCount;
function getIcon(iconName, type) {
    if (iconName === void 0) { iconName = ""; }
    if (iconName.startsWith("dxi")) {
        iconName = "dxi " + iconName;
    }
    return (0, dom_1.el)("span", {
        class: "dhx_".concat(type, "__icon ").concat(iconName),
        "aria-hidden": "true",
    });
}
exports.getIcon = getIcon;
var getNavbarItemClass = function (widgetName, item, asMenuItem) {
    var baseClassName = "";
    var resultClassName = "";
    if (asMenuItem) {
        baseClassName = "dhx_menu-item";
    }
    else {
        baseClassName = "dhx_" + widgetName + "__item";
    }
    resultClassName = baseClassName + (item.css ? " " + item.css : "");
    if (item.type === "spacer" || item.type === "separator") {
        resultClassName += " ".concat(baseClassName, "--").concat(item.type);
    }
    if (item.type === "button" && widgetName === "sidebar" && !item.icon) {
        resultClassName += " dhx_navbar-item--colapse_hidden";
    }
    return resultClassName;
};
function navbarComponentMixin(widgetName, item, asMenuItem, body) {
    var getAriaAttrs = function (type) {
        var attrs = {
            role: "none",
        };
        if (type === "separator") {
            attrs.role = "separator";
            attrs["aria-orientation"] = "vertical";
        }
        return attrs;
    };
    var itemClass = getNavbarItemClass(widgetName, item, asMenuItem);
    var hasRibbonSize = widgetName === "ribbon" && (item.type === "navItem" || item.type === "imageButton");
    return (0, dom_1.el)("li", __assign({ _key: item.id, class: itemClass +
            (item.icon && !item.value && hasRibbonSize ? " dhx_ribbon__item--icon" : "") +
            (item.src && !item.value && hasRibbonSize ? " dhx_ribbon__item--icon" : "") +
            (item.size && hasRibbonSize ? " dhx_ribbon__item--" + item.size : ""), ".innerHTML": item.type === "customHTML" ? item.html : undefined, "data-dhx-id": item.type === "customHTML" ? item.id : undefined }, getAriaAttrs(item.type)), item.type !== "customHTML" ? [body] : undefined);
}
exports.navbarComponentMixin = navbarComponentMixin;
function getNavbarButtonCSS(_a, widgetName) {
    var color = _a.color, size = _a.size, view = _a.view, full = _a.full, icon = _a.icon, circle = _a.circle, loading = _a.loading, value = _a.value, active = _a.active, count = _a.count;
    var colorsCss = {
        danger: " dhx_button--color_danger",
        secondary: " dhx_button--color_secondary",
        primary: " dhx_button--color_primary",
        success: " dhx_button--color_success",
    }[color] || " dhx_button--color_primary";
    var sizeCss = {
        small: " dhx_button--size_small",
        medium: " dhx_button--size_medium",
    }[size] || " dhx_button--size_medium";
    var viewCss = {
        flat: " dhx_button--view_flat",
        link: " dhx_button--view_link",
    }[view] || " dhx_button--view_flat";
    var fullCss = full ? " dhx_button--width_full" : "";
    var circleCss = circle ? " dhx_button--circle" : "";
    var loadingCss = loading ? " dhx_button--loading" : "";
    var iconViewCss = icon && !value ? " dhx_button--icon" : "";
    var activeCss = active ? " dhx_button--active" : "";
    var countCss = (0, core_1.isDefined)(count) ? " dhx_button--count" : "";
    return (colorsCss + sizeCss + viewCss + fullCss + circleCss + loadingCss + activeCss + iconViewCss + countCss);
}
exports.getNavbarButtonCSS = getNavbarButtonCSS;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.radarScale = exports.pieLikeHandlers = exports.shiftCoordinates = exports.getCoordinates = void 0;
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
function getCoordinates(percent, radiusX, radiusY, stroke) {
    if (stroke) {
        percent = percent + (2 * radiusX * Math.asin((0.5 * stroke) / radiusX)) / (2 * Math.PI * radiusX);
    }
    var x = Math.cos(2 * Math.PI * percent) * radiusX;
    var y = Math.sin(2 * Math.PI * percent) * radiusY;
    return [x, y];
}
exports.getCoordinates = getCoordinates;
function shiftCoordinates(item, dx, dy) {
    return [item[0] + dx, item[1] + dy];
}
exports.shiftCoordinates = shiftCoordinates;
function setTransform(elem, shiftX, shiftY) {
    elem.setAttribute("transform", "translate(".concat(shiftX, ", ").concat(shiftY, ") scale(1.05)"));
    elem.classList.add("dhx_pie-transform-delay");
}
function removeTransform(elem) {
    elem.setAttribute("transform", "translate(0, 0)");
    elem.classList.remove("dhx_pie-transform-delay");
}
exports.pieLikeHandlers = {
    onmouseover: function (shiftX, shiftY, _, node) {
        var id = node.parent.attrs.id;
        setTransform(node.el, shiftX, shiftY);
        node.parent.body.forEach(function (nodeEl) {
            if (nodeEl.attrs.id === "".concat(id, "-text") || nodeEl.attrs.id === "".concat(id, "-connector")) {
                setTransform(nodeEl.el, shiftX, shiftY);
            }
        });
    },
    onmouseout: function (_, node) {
        var id = node.parent.attrs.id;
        removeTransform(node.el);
        node.parent.body.forEach(function (nodeEl) {
            if (nodeEl.attrs.id === "".concat(id, "-text") || nodeEl.attrs.id === "".concat(id, "-connector")) {
                removeTransform(nodeEl.el);
            }
        });
    },
};
function checkMiss(v, r) {
    var miss = 0.000001;
    return v - miss < r && v + miss > r;
}
function drawBackgroundCircle(radius, color) {
    return (0, dom_1.sv)("circle", {
        cx: 0,
        cy: 0,
        r: radius,
        fill: color,
        stroke: "none",
        class: "background-circle",
    });
}
function arc(r, flag) {
    return "M".concat(-r, ",0A").concat(r, ",").concat(r, " 0 ").concat(flag ? 0 : 1, " 1 ").concat(r, ",0A").concat(r, ",").concat(r, " 0 ").concat(flag ? 0 : 1, " 1 ").concat(-r, ",0");
}
function radarScale(data, width, height) {
    var getScaleAriaAttrs = function (text) { return ({
        "aria-label": "x-axis".concat(text ? ", " + text : ""),
    }); };
    var radius;
    if (height > width) {
        radius = width / 2;
    }
    else {
        radius = height / 2;
    }
    var scalePercent = 1 / data.scales.length;
    var largeArcFlag = scalePercent > 0.5 ? 1 : 0;
    var svg = [];
    var background = drawBackgroundCircle(radius, "#fafafa");
    svg.push(background);
    var currentPercent = -0.25;
    var grid = [];
    var axis = data.axis;
    var gridClass = "radar-grid ".concat(data.zebra ? "zebra" : "");
    for (var i = 1; i < axis.length; i += 2) {
        var r1 = radius * axis[i - 1];
        var r2 = radius * axis[i];
        var d = "".concat(arc(r1, true), " ").concat(arc(r2, false));
        var arcs = (0, dom_1.sv)("path", {
            d: d,
            fill: "none",
            stroke: "black",
            class: gridClass,
        });
        grid.push(arcs);
    }
    svg.push(grid);
    data.scales.forEach(function (item) {
        var _a = getCoordinates(currentPercent, radius, radius), startX = _a[0], startY = _a[1];
        var nextPercent = currentPercent + scalePercent;
        var _b = getCoordinates(nextPercent, radius, radius), endX = _b[0], endY = _b[1];
        var d = "M ".concat(startX, " ").concat(startY, " A ").concat(radius, " ").concat(radius, " 0 ").concat(largeArcFlag, " 1 ").concat(endX, " ").concat(endY, " L 0 0");
        var path = (0, dom_1.sv)("path", {
            d: d,
            stroke: "black",
            fill: "none",
            class: "radar-scale",
        });
        svg.push(path);
        var _c = [8, 8], yTextPadding = _c[0], xTextPadding = _c[1];
        var dy = checkMiss(currentPercent, 0) || checkMiss(currentPercent, 0.5)
            ? 0
            : currentPercent < 0 || currentPercent > 0.5
                ? -yTextPadding
                : yTextPadding;
        var dx = checkMiss(currentPercent, -0.25) || checkMiss(currentPercent, 0.25)
            ? 0
            : currentPercent < -0.25 || currentPercent > 0.25
                ? -xTextPadding
                : xTextPadding;
        if (checkMiss(currentPercent, -0.25) || checkMiss(currentPercent, 0.25)) {
            var alignFn = checkMiss(currentPercent, -0.25) ? common_1.verticalTopText : common_1.verticalBottomText;
            var text = (0, dom_1.sv)("text", { x: startX + dx, y: startY + dy, class: "scale-text" }, [alignFn(item)]);
            svg.push(text);
        }
        else {
            var className = currentPercent >= -0.25 && currentPercent <= 0.25
                ? "start-text scale-text"
                : "end-text scale-text";
            var text = (0, dom_1.sv)("text", { x: startX + dx, y: startY + dy, class: className }, [
                (0, common_1.verticalCenteredText)(item),
            ]);
            svg.push(text);
        }
        currentPercent = nextPercent;
    });
    currentPercent = -0.25;
    if (data.realAxis) {
        var scaleText = data.realAxis.map(function (item, index) {
            var _a = getCoordinates(-0.25, radius * axis[index], radius * axis[index]), x = _a[0], y = _a[1];
            return (0, dom_1.sv)("text", { x: x, y: y, dx: -10, class: "radar-axis-text" }, [
                (0, common_1.verticalCenteredText)(item.toString()),
            ]);
        });
        svg.push(scaleText);
    }
    return (0, dom_1.sv)("g", __assign({ transform: "translate(".concat(width / 2, ", ").concat(height / 2, ")") }, getScaleAriaAttrs(data.attribute)), svg);
}
exports.radarScale = radarScale;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = __webpack_require__(1);
var types_1 = __webpack_require__(26);
var common_1 = __webpack_require__(7);
var line_1 = __webpack_require__(89);
var date_1 = __webpack_require__(19);
var BaseSeria = /** @class */ (function () {
    function BaseSeria(_data, config, other) {
        var _this = this;
        this._data = _data;
        this._handlers = {
            onclick: function (id, value) { return _this._events.fire(types_1.ChartEvents.serieClick, [id, value]); },
            onmousemove: function (id, value, e) {
                return _this._events.fire(types_1.ChartEvents.seriaMouseMove, [id, value, e]);
            },
            onmouseleave: function (id, value) {
                return _this._events.fire(types_1.ChartEvents.seriaMouseLeave, [id, value]);
            },
        };
        this.id = config.id = config.id || (0, core_1.uid)();
        this._events = other;
        this._points = [];
        this._setDefaults(config);
    }
    BaseSeria.prototype.toggle = function () {
        this.config.active = !this.config.active;
    };
    BaseSeria.prototype.getClosest = function (x, y) {
        var res = [Infinity, null, null, null];
        for (var _i = 0, _a = this._points; _i < _a.length; _i++) {
            var point = _a[_i];
            var dist = this._getClosestDist(x, y, point[0], point[1]);
            if (res[0] > dist) {
                res[0] = dist;
                res[1] = point[0];
                res[2] = point[1];
                res[3] = point[2];
            }
        }
        return res;
    };
    BaseSeria.prototype.getClosestVertical = function (x) {
        var res = [Infinity, null, null, null, null];
        for (var _i = 0, _a = this._points; _i < _a.length; _i++) {
            var point = _a[_i];
            var dist = Math.abs(point[0] - x);
            if (res[0] > dist) {
                res[0] = dist;
                res[1] = point[0];
                res[2] = point[1];
                res[3] = point[2];
                res[4] = point[4];
            }
        }
        return res;
    };
    BaseSeria.prototype.getTooltipType = function (_id) {
        return "top";
    };
    BaseSeria.prototype.getTooltipText = function (id) {
        if (!this._data.getItem(id) && this.config.type !== "calendarHeatMap") {
            return;
        }
        if (this.config.tooltip) {
            var p = void 0;
            var heatP = void 0;
            if (this.config.type === "calendarHeatMap") {
                heatP = this._points.find(function (i) { return i[2] === id.toString(); });
                if (heatP) {
                    var heatDate = new Date();
                    heatDate.setTime(heatP[0]);
                    heatP = [
                        (0, date_1.getFormattedDate)(this.config.dateFormat, heatDate),
                        heatP[1],
                    ];
                }
            }
            else {
                p = this._defaultLocator(this._data.getItem(id));
            }
            if (this.config.tooltipTemplate) {
                return this.config.tooltipTemplate(p || heatP);
            }
            return p ? p[0] : "".concat(heatP[1], ", <br>").concat(heatP[0]);
        }
    };
    BaseSeria.prototype.dataReady = function (prev) {
        return (this._points = []);
    };
    BaseSeria.prototype.paint = function (width, height) {
        return this._calckFinalPoints(width, height);
    };
    BaseSeria.prototype.getPoints = function () {
        return this._points;
    };
    BaseSeria.prototype.addScale = function (type, scale) {
        // do nothing
    };
    BaseSeria.prototype._getClosestDist = function (x, y, px, py) {
        return (0, common_1.euclideanDistance)(x, y, px, py);
    };
    BaseSeria.prototype._calckFinalPoints = function (_width, _height) {
        // do nothing
    };
    BaseSeria.prototype._setDefaults = function (config) {
        this.config = config;
    };
    BaseSeria.prototype._defaultLocator = function (_) {
        return [null, null];
    };
    BaseSeria.prototype._getPointType = function (form, color) {
        return (0, line_1.getShadeHelper)(form, color);
    };
    return BaseSeria;
}());
exports.default = BaseSeria;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removePatternMask = exports.patternMask = exports.removeNumberMask = exports.numberMask = void 0;
var core_1 = __webpack_require__(1);
function numberMask(value, options, input) {
    var _a, _b, _c;
    var prefix = options.prefix || "";
    var suffix = options.suffix || "";
    var maxIntLength = options.maxIntLength;
    var maxDecLength = options.maxDecLength;
    var minDecLength = options.minDecLength;
    var groupSeparator = (_a = options.groupSeparator) !== null && _a !== void 0 ? _a : ",";
    var decSeparator = typeof maxDecLength === "number" && !maxDecLength ? "" : (_b = options.decSeparator) !== null && _b !== void 0 ? _b : ".";
    var limit = false;
    var numericValue = value.toString();
    var isNegative = numericValue[0] === "-";
    if (isNegative && options.allowNegative === false) {
        numericValue = numericValue.slice(1);
        isNegative = false;
    }
    var parts = numericValue.split(".");
    if ((0, core_1.isDefined)(maxIntLength)) {
        var lengthLimit = maxIntLength + (isNegative ? 1 : 0);
        if (parts[0].length > lengthLimit) {
            parts[0] = parts[0].slice(0, lengthLimit);
            limit = true;
        }
    }
    if ((0, core_1.isDefined)(maxDecLength) && ((_c = parts[1]) === null || _c === void 0 ? void 0 : _c.length) > maxDecLength) {
        parts[1] = parts[1].slice(0, maxDecLength);
        limit = true;
    }
    if (options.onlyView && minDecLength && parts[0]) {
        if (!parts[1])
            parts[1] = "";
        while (parts[1].length < minDecLength) {
            parts[1] += "0";
        }
    }
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, groupSeparator);
    numericValue = parts.join(decSeparator);
    var maskedValue = prefix + numericValue + suffix;
    if (!numericValue.length)
        maskedValue = "";
    if (input) {
        var lastLength = input.value.length;
        var lastPosition = input.selectionStart;
        var changeInLength = maskedValue.length - lastLength;
        var position = lastPosition + changeInLength;
        var firstCharIndex = 0;
        if (isNegative && numericValue[firstCharIndex + 2] !== decSeparator)
            ++firstCharIndex;
        if (numericValue[firstCharIndex] === "0" && numericValue.length > 1 && numericValue[1] !== decSeparator) {
            maskedValue = prefix + "0" + suffix;
        }
        if (numericValue[firstCharIndex] === decSeparator) {
            if (isNegative) {
                maskedValue = prefix + "-0" + decSeparator + suffix;
            }
            else {
                maskedValue = prefix + "0" + decSeparator + suffix;
            }
            ++position;
        }
        if (position > maskedValue.length) {
            position = maskedValue.length;
        }
        else if (position < 0) {
            position = 0;
        }
        if (suffix && (maskedValue.length - suffix.length <= position)) {
            position = position - suffix.length + (maskedValue.length - position);
        }
        if (maskedValue[position - 1] === groupSeparator) {
            --position;
        }
        if (limit && changeInLength === -1) {
            position++;
            if (maskedValue[position - 1] === groupSeparator)
                position++;
        }
        input.value = maskedValue;
        input.setSelectionRange(position, position);
        input.focus();
    }
    return maskedValue;
}
exports.numberMask = numberMask;
function removeNumberMask(value, options) {
    var _a;
    var decSeparator = options.decSeparator || ".";
    var allowNegative = (_a = options.allowNegative) !== null && _a !== void 0 ? _a : true;
    if (options.prefix && value.startsWith(options.prefix)) {
        value = value.slice(options.prefix.length);
    }
    if (options.suffix && value.endsWith(options.suffix)) {
        value = value.slice(0, value.length - options.suffix.length);
    }
    var numericSign = (allowNegative && value[0] === "-") ? "-" : "";
    var _b = value.split(decSeparator), integer = _b[0], decimal = _b.slice(1);
    value = decimal.length ? integer + decSeparator + decimal.join("") : integer;
    var unmaskedValue = value
        .replace(new RegExp("[^0-9\\".concat(decSeparator, "]"), 'g'), '')
        .replace(new RegExp("\\".concat(decSeparator)), '.');
    if (options.lastCall) {
        if (unmaskedValue[unmaskedValue.length - 1] === '.') {
            if (+unmaskedValue === 0) {
                unmaskedValue = "";
            }
            else {
                unmaskedValue = unmaskedValue.slice(0, -1);
            }
        }
        if (isNaN(+unmaskedValue) || +unmaskedValue == 0)
            numericSign = "";
    }
    return numericSign + unmaskedValue;
}
exports.removeNumberMask = removeNumberMask;
var defaultChartFormat = {
    "0": /\d/,
    "a": /[A-Za-z]/,
    "#": /[A-Za-z0-9]/,
    "*": /./,
};
function applyMask(value, mask, charFormat) {
    if (charFormat === void 0) { charFormat = {}; }
    if (!value)
        return "";
    var maskedValue = "";
    var valueIndex = 0;
    var hasDynamicPattern = false;
    var hasDynamicChars = false;
    charFormat = __assign(__assign({}, defaultChartFormat), charFormat);
    for (var index = 0; index < mask.length; index++) {
        var maskChar = mask[index];
        var pattern = charFormat[maskChar];
        if (pattern) {
            while (valueIndex < value.length && !pattern.test(value[valueIndex])) {
                valueIndex++;
            }
            if (valueIndex < value.length) {
                maskedValue += value[valueIndex];
                valueIndex++;
                hasDynamicPattern = true;
            }
            else {
                break;
            }
        }
        else {
            if (valueIndex < value.length) {
                maskedValue += maskChar;
                if (value.length > 1 && value[valueIndex] === maskChar) {
                    valueIndex++;
                }
            }
        }
    }
    for (var index = maskedValue.length; index < mask.length; index++) {
        if (charFormat[mask[index]]) {
            hasDynamicChars = true;
            break;
        }
    }
    if (!hasDynamicChars) {
        for (var index = maskedValue.length; index < mask.length; index++) {
            var maskChar = mask[index];
            if (!charFormat[maskChar]) {
                maskedValue += maskChar;
            }
            else {
                break;
            }
        }
    }
    if (hasDynamicChars && maskedValue.length > 0 && !charFormat[mask[maskedValue.length - 1]]) {
        var lastStaticIndex = maskedValue.length - 1;
        while (lastStaticIndex >= 0 && !charFormat[mask[lastStaticIndex]]) {
            lastStaticIndex--;
        }
        maskedValue = maskedValue.substring(0, lastStaticIndex + 1);
    }
    if (!hasDynamicPattern)
        maskedValue = "";
    return maskedValue;
}
function patternMask(value, options, input) {
    var _a;
    var maskedValue = "";
    value = ((_a = input === null || input === void 0 ? void 0 : input.value) === null || _a === void 0 ? void 0 : _a.toString()) || value.toString();
    var mask = options;
    var charFormat = __assign({}, defaultChartFormat);
    if (typeof options === "object") {
        mask = typeof options.pattern === "function" ? options.pattern(value) : options.pattern;
        charFormat = __assign(__assign({}, charFormat), (options.charFormat || {}));
    }
    maskedValue = applyMask(value, mask, charFormat);
    if (input) {
        var unmaskedInputValue = removePatternMask(input.value, options);
        var unmaskedValue = removePatternMask(maskedValue, options);
        var position = input.selectionStart || 0;
        if (unmaskedInputValue.length === unmaskedValue.length) {
            if (unmaskedInputValue !== unmaskedValue) {
                while (position < mask.length && !charFormat[mask[position - 1]] || position === 0 && !charFormat[mask[position]]) {
                    position++;
                }
            }
            else {
                while (position > 0 && !charFormat[mask[position - 1]]) {
                    position--;
                }
            }
        }
        else {
            if (unmaskedInputValue.length < unmaskedValue.length) {
                while (position < mask.length && !charFormat[mask[position - 1]] || position === 0 && !charFormat[mask[position]]) {
                    position++;
                }
            }
        }
        if (position === 0)
            position = maskedValue.length;
        input.value = maskedValue;
        input.setSelectionRange(position, position);
        input.focus();
    }
    return maskedValue;
}
exports.patternMask = patternMask;
function removePatternMask(value, options) {
    var unmaskedValue = "";
    var mask = options;
    var charFormat = __assign({}, defaultChartFormat);
    if (typeof options === "object") {
        mask = typeof options.pattern === "function" ? options.pattern(value) : options.pattern;
        charFormat = __assign(__assign({}, charFormat), (options.charFormat || {}));
    }
    for (var i = 0; i < value.length; i++) {
        if (charFormat[mask[i]]) {
            unmaskedValue += value[i];
        }
    }
    return unmaskedValue;
}
exports.removePatternMask = removePatternMask;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.VaultMode = exports.ProgressBarEvents = exports.UploaderEvents = exports.FileStatus = void 0;
var ts_data_1 = __webpack_require__(4);
var FileStatus;
(function (FileStatus) {
    FileStatus["queue"] = "queue";
    FileStatus["uploaded"] = "uploaded";
    FileStatus["failed"] = "failed";
    FileStatus["inprogress"] = "inprogress";
})(FileStatus || (exports.FileStatus = FileStatus = {}));
var UploaderEvents;
(function (UploaderEvents) {
    UploaderEvents["uploadBegin"] = "uploadbegin";
    UploaderEvents["beforeUploadFile"] = "beforeuploadfile";
    UploaderEvents["uploadFile"] = "uploadfile";
    UploaderEvents["uploadFail"] = "uploadfail";
    UploaderEvents["uploadComplete"] = "uploadcomplete";
    UploaderEvents["uploadProgress"] = "uploadprogress";
})(UploaderEvents || (exports.UploaderEvents = UploaderEvents = {}));
var ProgressBarEvents;
(function (ProgressBarEvents) {
    ProgressBarEvents["cancel"] = "cancel";
})(ProgressBarEvents || (exports.ProgressBarEvents = ProgressBarEvents = {}));
var VaultMode;
(function (VaultMode) {
    VaultMode["grid"] = "grid";
    VaultMode["list"] = "list";
})(VaultMode || (exports.VaultMode = VaultMode = {}));


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(74), exports);
__exportStar(__webpack_require__(166), exports);


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.NavigationBarEvents = exports.DataEvents = void 0;
var ts_data_1 = __webpack_require__(4);
Object.defineProperty(exports, "DataEvents", { enumerable: true, get: function () { return ts_data_1.DataEvents; } });
var NavigationBarEvents;
(function (NavigationBarEvents) {
    NavigationBarEvents["inputCreated"] = "inputCreated";
    NavigationBarEvents["click"] = "click";
    NavigationBarEvents["openMenu"] = "openMenu";
    NavigationBarEvents["beforeHide"] = "beforeHide";
    NavigationBarEvents["afterHide"] = "afterHide";
    NavigationBarEvents["inputFocus"] = "inputFocus";
    NavigationBarEvents["inputBlur"] = "inputBlur";
    NavigationBarEvents["inputChange"] = "inputChange";
    NavigationBarEvents["input"] = "input";
    NavigationBarEvents["keydown"] = "keydown";
})(NavigationBarEvents || (exports.NavigationBarEvents = NavigationBarEvents = {}));


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(160), exports);
__exportStar(__webpack_require__(79), exports);


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(80), exports);
__exportStar(__webpack_require__(173), exports);
__exportStar(__webpack_require__(81), exports);
__exportStar(__webpack_require__(53), exports);


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(93), exports);
__exportStar(__webpack_require__(200), exports);
__exportStar(__webpack_require__(95), exports);


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = exports.Validation = void 0;
var dom_1 = __webpack_require__(0);
var core_1 = __webpack_require__(1);
var input_1 = __webpack_require__(33);
var helper_1 = __webpack_require__(8);
var label_1 = __webpack_require__(12);
var events_1 = __webpack_require__(3);
var types_1 = __webpack_require__(6);
var Validation;
(function (Validation) {
    Validation["empty"] = "";
    Validation["validEmail"] = "email";
    Validation["validInteger"] = "integer";
    Validation["validNumeric"] = "numeric";
    Validation["validAlphaNumeric"] = "alphanumeric";
    Validation["validIPv4"] = "IPv4";
})(Validation || (exports.Validation = Validation = {}));
var Input = /** @class */ (function (_super) {
    __extends(Input, _super);
    function Input(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, null, config) || this;
        _this.events = new events_1.EventSystem();
        _this._propsItem = [
            "inputType",
            "required",
            "validation",
            "icon",
            "placeholder",
            "autocomplete",
            "readOnly",
            "maxlength",
            "minlength",
            "min",
            "max",
            "step",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
            "numberMask",
            "patternMask",
        ];
        _this._props = __spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true);
        _this._initView(config);
        _this._initHandlers();
        return _this;
    }
    Input.prototype.destructor = function () {
        var _a;
        (_a = this._input) === null || _a === void 0 ? void 0 : _a.removeEventListener("compositionend", this._handlers.oninput);
        this.events && this.events.clear();
        this.unmount();
        _super.prototype._destructor.call(this);
        this.events = this._uid = this._propsItem = this._propsItem = this.config = this._handlers = null;
    };
    Input.prototype.setProperties = function (propertyConfig) {
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
            }
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    Input.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    Input.prototype.show = function () {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [value])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [value]);
    };
    Input.prototype.hide = function (init) {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [value, init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [value, init]);
    };
    Input.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    Input.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Input.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    Input.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    Input.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var value = args.length ? args[0] : this.getValue();
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var valid = this.config.validation
            ? (0, helper_1.validateInput)(value, this.config.validation)
            : (0, helper_1.baseInputValidate)(value, this.config);
        if (!silent) {
            this.setValidationStatus(valid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, valid]);
            !this.isFocused() && this.paint();
        }
        return valid;
    };
    Input.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    Input.prototype.clear = function () {
        if (this.config.value === "" || !this.events.fire(types_1.ItemEvent.beforeChange, [""])) {
            this._value = this.config.value;
            this.paint();
            return;
        }
        this.config.value = "";
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
    };
    Input.prototype.setValue = function (value) {
        if (typeof value === "undefined" ||
            this.config.value === value ||
            !this.events.fire(types_1.ItemEvent.beforeChange, [value])) {
            this._value = this.config.value;
            this.paint();
            return;
        }
        this.config.value = value;
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.validate();
    };
    Input.prototype.getValue = function () {
        var _a = this.config, inputType = _a.inputType, value = _a.value;
        if ((inputType === "number" && typeof value === "number") || value === null) {
            return value;
        }
        if (inputType === "number" && typeof value === "string") {
            return value.length ? Number(value) : "";
        }
        if (typeof value === "string") {
            return value.length ? value : "";
        }
        return typeof value === "undefined" ? "" : String(value);
    };
    Input.prototype.getText = function () {
        var _a, _b, _c, _d;
        return ((_d = (_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el) === null || _d === void 0 ? void 0 : _d.value) || this._applyValuePattern(this.config.value);
    };
    Input.prototype.isFocused = function () {
        var _a, _b, _c;
        return ((_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el) === document.activeElement;
    };
    Input.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.focus();
        });
    };
    Input.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.blur();
        });
    };
    Input.prototype._initView = function (config) {
        if ((0, core_1.isEmptyObj)(config)) {
            throw new Error("Check the configuration is correct");
        }
        this.config = {
            type: "input",
            id: config.id,
            name: config.name,
            value: "",
            disabled: false,
            hidden: false,
            inputType: "text",
            required: false,
            icon: "",
            placeholder: "",
            autocomplete: false,
            readOnly: false,
            label: "",
            labelWidth: "",
            labelPosition: "top",
            hiddenLabel: false,
            helpMessage: "",
            preMessage: "",
            successMessage: "",
            errorMessage: "",
            width: "content",
            height: "content",
            numberMask: false,
        };
        for (var key in config) {
            if (key !== "id" && key !== "type" && key !== "name") {
                this.config[key] = config[key];
            }
        }
        if (this.config.numberMask && this.config.inputType === "number") {
            var numberConfig = { maxIntLength: 16, maxDecLength: 2 };
            if (typeof this.config.numberMask === "boolean") {
                this.config.numberMask = numberConfig;
            }
            else {
                this.config.numberMask = __assign(__assign({}, numberConfig), this.config.numberMask);
            }
        }
        this._value = this.config.value;
        this.paint();
    };
    Input.prototype._initHandlers = function () {
        var _this = this;
        this.events.on(types_1.ItemEvent.change, function (value) {
            _this._value = value;
            _this.paint();
        });
    };
    Input.prototype._getHandlers = function () {
        var _this = this;
        return {
            oninput: function (e) {
                if (e.isComposing)
                    return;
                _this._value = _this._removeValuePattern(e.target.value);
                _this._applyValuePattern(_this._value, e.target);
                _this.events.fire(types_1.ItemEvent.input, [
                    _this.config.inputType === "number" ? Number(_this._value) : _this._value,
                ]);
            },
            onchange: function (e) {
                _this._value = _this._removeValuePattern(e.target.value, true);
                if (_this._value !== _this.config.value)
                    _this.setValue(_this._value);
            },
            onfocus: function () {
                _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]);
                _this.paint();
            },
            onblur: function () {
                if (!_this._uid)
                    return;
                _this.events.fire(types_1.ItemEvent.blur, [_this.getValue()]);
                if (_this._value !== _this.config.value)
                    _this.setValue(_this._value);
                (0, dom_1.awaitRedraw)().then(function () { return _this.paint(); });
            },
            onkeydown: function (event) {
                if (event.code === "Enter" && _this.config.type === "input")
                    event.preventDefault();
                _this.events.fire(types_1.ItemEvent.keydown, [event]);
            },
        };
    };
    Input.prototype._draw = function () {
        var _this = this;
        var _a = this.config, id = _a.id, disabled = _a.disabled, name = _a.name, icon = _a.icon, placeholder = _a.placeholder, required = _a.required, inputType = _a.inputType, hidden = _a.hidden, autocomplete = _a.autocomplete, readOnly = _a.readOnly, maxlength = _a.maxlength, minlength = _a.minlength, max = _a.max, min = _a.min, label = _a.label, helpMessage = _a.helpMessage, numberMask = _a.numberMask;
        var visibility = hidden ? " dhx_form-group--hidden" : "";
        var allowInputType = !numberMask && ["text", "number", "password"].includes(inputType) ? inputType : "text";
        var value = this._applyValuePattern(this._value, null, true);
        return (0, dom_1.el)("div.dhx_form-group", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config), this.isFocused()) + visibility,
        }, [
            this._drawLabel(),
            (0, dom_1.el)(".dhx_input__wrapper", {}, [
                (0, dom_1.el)("div.dhx_input__container", {}, [
                    this.config.icon
                        ? (0, dom_1.el)(".dhx_input__icon", {
                            class: this.config.icon,
                        })
                        : null,
                    (0, dom_1.el)("input.dhx_input", {
                        type: allowInputType,
                        "data-dhx-id": name || id,
                        id: id || this._uid,
                        _key: id || this._uid,
                        placeholder: placeholder || "",
                        value: value,
                        name: name || "",
                        disabled: disabled,
                        required: required,
                        readOnly: readOnly,
                        maxlength: maxlength,
                        minlength: minlength,
                        max: max,
                        min: min,
                        onblur: this._handlers.onblur,
                        oninput: this._handlers.oninput,
                        onchange: this._handlers.onchange,
                        onfocus: this._handlers.onfocus,
                        onkeydown: this._handlers.onkeydown,
                        class: icon ? "dhx_input--icon-padding" : "",
                        autocomplete: autocomplete ? "on" : "off",
                        _ref: "input",
                        "aria-label": label || helpMessage || "type ".concat(name || inputType || "text"),
                        "aria-describedby": helpMessage ? "dhx_label__help_".concat(id || this._uid) : null,
                        _hooks: {
                            didRecycle: function (_oldNode, newNode) {
                                if (_this.isFocused() && (0, core_1.isDefined)(_this._value)) {
                                    _this._applyValuePattern(_this._value, newNode.el, true);
                                }
                            },
                            didInsert: function (node) {
                                _this._input = node.el;
                                _this._input.addEventListener("compositionend", _this._handlers.oninput);
                            },
                        },
                    }),
                ]),
                (0, helper_1.getValidationMessage)(this.config) &&
                    (0, dom_1.el)("span.dhx_input__caption", (0, helper_1.getValidationMessage)(this.config)),
            ]),
        ]);
    };
    Input.prototype._applyValuePattern = function (value, input, onlyView) {
        if (onlyView === void 0) { onlyView = false; }
        if (this.config.numberMask) {
            return (0, input_1.numberMask)(value.toString(), __assign(__assign({}, this.config.numberMask), { onlyView: onlyView }), input);
        }
        if (this.config.patternMask) {
            return (0, input_1.patternMask)(value.toString(), this.config.patternMask, input);
        }
        return value;
    };
    Input.prototype._removeValuePattern = function (value, lastCall) {
        if (lastCall === void 0) { lastCall = false; }
        if (this.config.numberMask) {
            return (0, input_1.removeNumberMask)(value, __assign(__assign({}, this.config.numberMask), { lastCall: lastCall }));
        }
        if (this.config.patternMask) {
            return (0, input_1.removePatternMask)(value, this.config.patternMask);
        }
        return value;
    };
    return Input;
}(label_1.Label));
exports.Input = Input;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeSpan = exports.getShifts = exports.getSpans = exports.getCells = exports.getHandlers = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var cells_1 = __webpack_require__(24);
var main_1 = __webpack_require__(10);
var types_1 = __webpack_require__(5);
var editors_1 = __webpack_require__(226);
var html_1 = __webpack_require__(2);
var data_1 = __webpack_require__(11);
var common_1 = __webpack_require__(17);
function handleMouse(rowStart, colStart, conf, type, e) {
    colStart = (0, html_1.locateNodeByClassName)(e.target, "dhx_grid-fixed-cols-wrap") ? 0 : colStart;
    var target = (0, html_1.locateNodeByClassName)(e.target, "dhx_grid-cell");
    var targetSpan = (0, html_1.locateNodeByClassName)(e.target, "dhx_span-cell");
    if ((!target && !targetSpan) || !type) {
        return;
    }
    var rowNode = target ? target.parentNode : targetSpan;
    var colId = (target || targetSpan).getAttribute("data-dhx-col-id");
    var col = conf.filteredColumns.find(function (column) { return column.id === colId; });
    var rowId = rowNode.getAttribute("data-dhx-id");
    var row = (conf.$data || conf.data).find(function (r) { return r.id.toString() === rowId; });
    var systemEvent = type.toLocaleLowerCase().includes("touch");
    if (systemEvent) {
        conf._events.fire(type, [row, col, e]);
    }
    else {
        conf.events.fire(type, [row, col, e]);
    }
}
function getHandlers(row, column, conf) {
    return {
        onclick: [handleMouse, row, column, conf, types_1.GridEvents.cellClick],
        onmouseover: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseOver],
        onmousedown: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseDown],
        ondblclick: [handleMouse, row, column, conf, types_1.GridEvents.cellDblClick],
        oncontextmenu: [handleMouse, row, column, conf, types_1.GridEvents.cellRightClick],
        ontouchstart: [handleMouse, row, column, conf, types_1.GridEvents.cellMouseDown],
        ontouchmove: [handleMouse, row, column, conf, types_1.GridSystemEvents.cellTouchMove],
        ontouchend: [handleMouse, row, column, conf, types_1.GridSystemEvents.cellTouchEnd],
    };
}
exports.getHandlers = getHandlers;
function getTreeCell(content, row, col, conf, isToggleSubRow) {
    if (isToggleSubRow === void 0) { isToggleSubRow = false; }
    var getCellAriaAttrs = function (col, ind) { return ({
        role: "gridcell",
        "aria-colindex": ind,
    }); };
    var getToggleAriaAttrs = function (row) { return ({
        role: "button",
        "aria-label": row.$opened ? "Collapse group" : "Expand group",
    }); };
    var isEditable = conf.$editable && conf.$editable.row === row.id && conf.$editable.col === col.id;
    var isFilledCell = !conf.fixedColumns.left.length || conf.$renderFrom === "leftFixedCols";
    var cellAlign = col.align ? "dhx_align-".concat(col.align) : "dhx_align-left";
    var css = "";
    if (isFilledCell) {
        css = "dhx_tree-cell ".concat(col.$cellCss[row.id] || "", " ").concat(cellAlign);
        if (row.$items || isToggleSubRow)
            css += " dhx_grid-expand-cell";
        if (isEditable)
            css += " dhx_tree-editing-cell";
        if (conf.dragMode && !isEditable) {
            css += row.$draggable ? " dhx_grid-cell--draggable" : "";
        }
    }
    var parentPadding = (0, data_1.getTreeCellWidthOffset)(row, true);
    return (0, dom_1.el)(".dhx_grid-cell", __assign({ class: css, style: {
            width: col.$width,
            height: row.$height,
            padding: !row.$items ? "0 0 0 ".concat(parentPadding, "px") : 0,
        }, "data-dhx-col-id": col.id }, getCellAriaAttrs(col, 1)), isFilledCell
        ? [
            row.$items || isToggleSubRow
                ? (0, dom_1.el)(".dhx_grid-expand-cell-icon", __assign(__assign({ class: row.$opened ? "dxi dxi-chevron-down" : "dxi dxi-chevron-right", "data-dhx-id": row.id }, getToggleAriaAttrs(row)), { style: {
                        padding: row.$level ? "0 0 0 ".concat(4 + parentPadding, "px") : "0 0 0 4px",
                    } }))
                : null,
            (0, dom_1.el)(".dhx_tree-cell", {
                class: cellAlign + "".concat((conf.autoHeight && " dhx_tree-cell_auto-height") || ""),
            }, [content]),
        ]
        : null);
}
function getEditorCell(row, col, conf, span) {
    return (0, editors_1.getEditor)(row, col, conf, span);
}
function getCells(conf) {
    if (!conf.data || !conf.filteredColumns) {
        return [];
    }
    var getRowAriaAttrs = function (ind) { return ({
        role: "row",
        "aria-rowindex": ind,
    }); };
    var pos = conf.$positions;
    var isFixed = conf.$renderFrom !== "render";
    var data = (isFixed ? conf.data.slice(pos.yStart, pos.yEnd) : conf.currentRows) || [];
    var columns = conf.filteredColumns.slice(pos.xStart, pos.xEnd);
    var selectedCell = conf.selection.getCell();
    var isFirstTabindex = true;
    var filteredDragRows;
    var dragGhost = document.querySelector(".dhx_drag-ghost");
    if (dragGhost) {
        var dragRowIndexes = Array.from(dragGhost.querySelectorAll(".dhx_grid-row")).map(function (elem) {
            return Number(elem.getAttribute("aria-rowindex")) - 1;
        });
        if (dragRowIndexes.length) {
            filteredDragRows = dragRowIndexes
                .map(function (i) { return conf.data[i]; })
                .filter(function (item) { return item && !data.find(function (i) { return i.id === item.id; }); });
            data.push.apply(data, filteredDragRows);
        }
    }
    return data.map(function (row, index) {
        var _a;
        var isFilteredDragRow = filteredDragRows === null || filteredDragRows === void 0 ? void 0 : filteredDragRows.some(function (item) { return item.id === row.id; });
        var isLastRow = data.length - 1 === index;
        var subRow = (_a = conf.$subRowCells) === null || _a === void 0 ? void 0 : _a.get(row.id);
        var rowCss = "";
        if (conf.rowCss) {
            rowCss = conf.rowCss(row);
        }
        if (row.$css) {
            rowCss += row.$css;
        }
        var cells = columns.map(function (col, colIndex) {
            var _a;
            if (!col.hidden) {
                var initValue = row[col.id];
                var value = (0, core_1.isDefined)(initValue) && col.options
                    ? (0, data_1.getComboEditorValue)(initValue, col, row)
                    : (0, data_1.applyPattern)(initValue, col);
                var getTabIndex_1 = function (col, row) {
                    var attrs = {
                        tabindex: -1,
                    };
                    if (selectedCell) {
                        // is current cell selected?
                        if (selectedCell.row.id === row.id && selectedCell.column.id === col.id) {
                            attrs["tabindex"] = 0;
                        }
                    }
                    else if (isFirstTabindex) {
                        attrs["tabindex"] = 0;
                    }
                    return attrs;
                };
                var getEditBtnAriaAttrs = function () { return ({
                    role: "button",
                    "aria-label": "Edit content",
                }); };
                var getCellAriaAttrs = function (col, colIndex, rowIndex, isEditable) { return (__assign({ role: "gridcell", "aria-colindex": colIndex, "aria-readonly": isEditable ? "false" : "true" }, getTabIndex_1(col, row))); };
                var defaultTemplate = function (text) {
                    if (typeof text === "boolean" || col.type === "boolean") {
                        if (typeof text !== "string" && !row.$group) {
                            return "".concat(Boolean(text));
                        }
                    }
                    return text || text === 0 ? text : "";
                };
                var content = col.template
                    ? col.template((0, core_1.isDefined)(value) ? value : "", row, col)
                    : defaultTemplate(value);
                // content can be a domvm node or a string
                if (typeof content === "string") {
                    content = (0, main_1.isHtmlEnable)(conf, col)
                        ? (0, dom_1.el)("div.dhx_grid-cell__content", __assign({ ".innerHTML": content }, getEditBtnAriaAttrs()))
                        : content;
                }
                var css = "".concat((col.$cellCss && col.$cellCss[row.id]) || "", " dhx_").concat(col.type, "-cell").replace(/\s+/g, " ");
                var colWidth = col.$width;
                var isEditable = conf.$editable &&
                    conf.$editable.row === row.id &&
                    conf.$editable.col === col.id &&
                    !conf.$editable.isSpan;
                var leftSplit = conf.leftSplit, filteredColumns = conf.filteredColumns;
                if (isEditable ||
                    (col.type === "boolean" &&
                        ((conf.editable && ((_a = col.editable) !== null && _a !== void 0 ? _a : true)) || (!conf.editable && col.editable)) &&
                        !row.$group)) {
                    content = getEditorCell(row, col, conf).toHTML();
                    css += " dhx_grid-cell__editable";
                    if (leftSplit === filteredColumns.indexOf(col) + 1) {
                        colWidth -= 1;
                    }
                }
                var isToggleSubRow = conf.firstColId === col.id && (subRow === null || subRow === void 0 ? void 0 : subRow.toggleIcon) && !!(subRow === null || subRow === void 0 ? void 0 : subRow.height);
                if ((conf.type === "tree" && conf.firstColId === col.id) || isToggleSubRow) {
                    return getTreeCell(content, row, col, conf, isToggleSubRow);
                }
                if (conf.dragMode && !isEditable) {
                    css += row.$draggable ? " dhx_grid-cell--draggable" : "";
                }
                if (col.align) {
                    css += " dhx_align-".concat(col.align);
                }
                if ((0, main_1.isHtmlEnable)(conf, col)) {
                    css += " dhx_grid-cell__content_html-enable";
                }
                if (conf.autoHeight) {
                    css += " dhx_grid-cell__content_auto-height";
                }
                return (0, dom_1.el)(".dhx_grid-cell", __assign({ class: css, style: {
                        width: colWidth,
                        height: row.$height + "px",
                    }, _key: col.id, "data-dhx-col-id": col.id }, getCellAriaAttrs(col, pos.xStart + colIndex + 1, index, conf.editable)), [content]);
            }
        });
        var rowHeight = (0, data_1.getTotalRowHeight)(row);
        return (0, dom_1.el)(".dhx_grid-row", __assign({ style: {
                height: isLastRow ? rowHeight + 1 : rowHeight,
                display: isFilteredDragRow ? "none" : null,
            }, "data-dhx-id": row.id, class: rowCss, _key: row.id, _flags: dom_1.KEYED_LIST }, (isFilteredDragRow ? {} : getRowAriaAttrs(pos.yStart + index + 1))), cells);
    });
}
exports.getCells = getCells;
function getReverseScrollState(config) {
    var $scrollBarWidth = config.$scrollBarWidth;
    var totalScrollX = config.$totalWidth - config.$width + common_1.BORDERS + $scrollBarWidth.y;
    var totalScrollY = config.$totalHeight -
        config.$height +
        config.$headerHeight +
        config.$footerHeight +
        common_1.BORDERS +
        $scrollBarWidth.x;
    return {
        x: totalScrollX > 0 ? totalScrollX - config.scroll.left : 0,
        y: totalScrollY > 0 ? totalScrollY - config.scroll.top : 0,
    };
}
function getSpans(config, mode) {
    var _a, _b;
    var spanCells = [];
    var columns = config.columns, filteredColumns = config.filteredColumns, data = config.data, rSpans = config.currentSpans, _c = config.bottomSplit, bottomSplit = _c === void 0 ? 0 : _c;
    if (!filteredColumns.length || !rSpans)
        return null;
    var rightSplit = config.fixedColumns.right.length;
    var filteredSpans = rSpans.filter(function (span) { var _a; return (_a = span.$renderFrom) === null || _a === void 0 ? void 0 : _a.includes(config.$renderFrom); });
    var spans = filteredSpans.sort(function (a, b) {
        return typeof a.row === "string" && typeof b.row === "string"
            ? a.row.localeCompare(b.row)
            : a.row - b.row;
    });
    var _loop_1 = function (i) {
        var row = spans[i].row;
        var col = spans[i].column;
        var spanHeight = spans[i].$rowsVisibility[1] - spans[i].$rowsVisibility[0] + 1;
        var spanWidth = spans[i].$colsVisibility[1] - spans[i].$colsVisibility[0] + 1;
        var spanText = spans[i].text;
        var spanCss = spans[i].css;
        var isFixedColsByBottomSplit = mode === types_1.Split.bottom && config.$renderFrom.endsWith("FixedCols");
        var rows = isFixedColsByBottomSplit ? config.$data : data;
        var colIndex = filteredColumns === null || filteredColumns === void 0 ? void 0 : filteredColumns.findIndex(function (i) { return "".concat(i.id) === "".concat(col); });
        var rowIndex = rows === null || rows === void 0 ? void 0 : rows.findIndex(function (i) { return "".concat(i.id) === "".concat(row); });
        if (colIndex < 0 || rowIndex < 0) {
            return "continue";
        }
        if (isFixedColsByBottomSplit) {
            var item_1 = config.$data[rowIndex + spanHeight - 1];
            if (!data.find(function (i) { return i.id === (item_1 === null || item_1 === void 0 ? void 0 : item_1.id); }))
                return "continue";
        }
        var currCol = filteredColumns[colIndex];
        var currRow = rows[rowIndex];
        var cellCss = currCol.$cellCss[row];
        var spanType = (0, core_1.isDefined)(spans[i].text) ? "string" : currCol.type;
        if (currCol.hidden) {
            return "continue";
        }
        var content = void 0;
        if ((0, core_1.isDefined)(spanText)) {
            if (typeof spanText === "function") {
                var summary = __assign(__assign({}, config.commonSummary), config.colSummary[col]);
                if (typeof currCol.summary === "string" && currCol.summary !== "count") {
                    summary[currCol.summary] = (0, data_1.applyPattern)(summary[currCol.summary], currCol);
                }
                content = spanText(summary);
            }
            else {
                content = spanText.toString();
            }
        }
        else {
            content = currRow[col] === undefined ? "" : (0, data_1.applyPattern)(currRow[col], currCol);
        }
        if (typeof spanText !== "function") {
            var template = currCol.template || (function (text, _row, _col) { return (text || text === 0 ? text : ""); });
            content = template(content, currRow, currCol);
        }
        var htmlEnable = (0, main_1.isHtmlEnable)(config, currCol);
        content =
            typeof content === "string"
                ? (0, dom_1.el)("div.dhx_span-cell-content", {
                    class: config.autoHeight ? " dhx_grid-cell__content_auto-height" : "",
                    ".innerHTML": htmlEnable ? content : null,
                }, htmlEnable ? null : content)
                : content;
        var top_1 = void 0;
        if (config.$renderFrom === "bottomFixedRows" || isFixedColsByBottomSplit) {
            var rowIndexStartSplit = rows.length - bottomSplit;
            top_1 =
                rowIndex < rowIndexStartSplit
                    ? -(0, main_1.getTotalHeight)(rows.slice(rowIndex, rowIndexStartSplit))
                    : (0, main_1.getTotalHeight)(rows.slice(rowIndexStartSplit, rowIndex));
        }
        else {
            top_1 = (0, main_1.getTotalHeight)(rows.slice(0, rowIndex)) - (mode ? 0 : 1);
        }
        var left = 0;
        if (config.$renderFrom === "rightFixedCols") {
            var colIndexStartSplit = filteredColumns.length - config.fixedColumns.right.length;
            left =
                colIndex < colIndexStartSplit
                    ? -(0, main_1.getTotalWidth)(filteredColumns.slice(colIndex, colIndexStartSplit))
                    : (0, main_1.getTotalWidth)(filteredColumns.slice(colIndexStartSplit, colIndex));
        }
        else {
            for (var s = colIndex - 1; s >= 0; s--) {
                left += filteredColumns[s].$width;
            }
        }
        var isExpandingSpan = currRow.$items && colIndex === 0;
        var rowspanWithLastCol = colIndex === filteredColumns.length - 1;
        var colspanWithLastCol = colIndex + spanWidth === filteredColumns.length;
        var firstRightFixedCol = rightSplit && colIndex === filteredColumns.length - rightSplit;
        var allFixedSpanByBottomFixedRows = mode === types_1.Split.bottom && config.fixedRows.bottom.find(function (item) { return item.id === row; });
        var bottomFixedRowWithPartSpan = !!bottomSplit && rowIndex + spanHeight > rows.length - bottomSplit;
        var spanBeforeFixedCol = !!rightSplit && colIndex + spanWidth === filteredColumns.length - rightSplit;
        var css = currCol.header[0].text ? " dhx_span-cell" : " dhx_span-cell dhx_span-cell--title";
        css += isExpandingSpan ? " dhx_span-expand-cell" : "";
        css += cellCss ? " ".concat(cellCss) : "";
        css += spanCss ? " ".concat(spanCss) : "";
        css += rowIndex === 0 ? " dhx_span-first-row" : "";
        css += rowIndex + spanHeight === rows.length ? " dhx_grid__span_bottom--last-row" : "";
        css += colIndex === 0 || firstRightFixedCol ? " dhx_span-first-col" : "";
        css += rowspanWithLastCol || colspanWithLastCol ? " dhx_span-last-col" : "";
        css += spanWidth === 1 ? " dhx_span-".concat(currCol.type || "string", "-cell") : " dhx_span-string-cell";
        css += currCol.align ? " dhx_align-".concat(currCol.align) : " dhx_".concat(spanType, "-cell");
        css += allFixedSpanByBottomFixedRows ? " dhx_grid__span_bottom--all-fixed" : "";
        css += bottomFixedRowWithPartSpan ? " dhx_grid__span_bottom--part-fixed" : "";
        css += spanBeforeFixedCol ? " dhx_grid__span_right--before-fixed" : "";
        var width = void 0;
        if (spanWidth > 1) {
            var rColIndex = columns.findIndex(function (item) { return item.id === col; });
            width = (0, cells_1.getWidth)(columns, spans[i].colspan, rColIndex);
        }
        else {
            width = currCol.$width;
        }
        var height = void 0;
        if (spanHeight > 1) {
            height = (0, cells_1.getSpanHeight)(rows, spans[i]);
            if (mode === types_1.Split.top && config.$renderFrom.endsWith("FixedCols")) {
                var delta = rowIndex + spanHeight - rows.length;
                if (delta > 0) {
                    var i_1 = config.fixedRows.top.length;
                    height += (0, main_1.getTotalHeight)(config.$data.slice(i_1, i_1 + delta));
                }
            }
        }
        else {
            height = currRow.$height;
        }
        var zIndex = null;
        var isEditable = (((_a = config.$editable) === null || _a === void 0 ? void 0 : _a.isSpan) && config.$editable.row === row && config.$editable.col === col) ||
            (currCol.type === "boolean" &&
                ((config.editable && ((_b = currCol.editable) !== null && _b !== void 0 ? _b : true)) || (!config.editable && currCol.editable)));
        if (isEditable) {
            var _d = config.topSplit, topSplit = _d === void 0 ? 0 : _d;
            var leftSplit = config.fixedColumns.left.length;
            var allFixedByCol = (leftSplit && colIndex + spanWidth <= leftSplit) ||
                (rightSplit && colIndex >= filteredColumns.length - rightSplit);
            var fixedByRow = rowIndex < topSplit || rowIndex + spanHeight > rows.length - bottomSplit;
            var allFixedByRow = (topSplit && rowIndex + spanHeight <= topSplit) ||
                (bottomSplit && rowIndex >= rows.length - bottomSplit);
            var fixedByCol = colIndex < leftSplit || colIndex + spanWidth > filteredColumns.length - rightSplit;
            if (config.$renderFrom === "render" ||
                (allFixedByCol && !fixedByRow) ||
                (allFixedByRow && !fixedByCol)) {
                var $height = config.$height, $scrollBarWidth = config.$scrollBarWidth, scroll_1 = config.scroll, fixedRows = config.fixedRows, fixedColumns = config.fixedColumns;
                var text = spans[i].text;
                var gap = 0;
                content = getEditorCell(currRow, currCol, config, spans[i]).toHTML(text);
                css += " dhx_span__editable";
                if (!allFixedByRow) {
                    var topFixedHeight = (0, main_1.getTotalHeight)(fixedRows.top);
                    var bottomFixedHeight = (0, main_1.getTotalHeight)(fixedRows.bottom);
                    var bodyHeight = $scrollBarWidth.yState
                        ? $height - config.$headerHeight - config.$footerHeight - $scrollBarWidth.x - common_1.BORDERS
                        : config.$totalHeight;
                    var bottomByScroll = top_1 + height - scroll_1.top;
                    var isOutsideByTop = top_1 - topFixedHeight < scroll_1.top;
                    var isOutsideByBottom = bottomByScroll > bodyHeight - bottomFixedHeight;
                    if (isOutsideByTop && isOutsideByBottom && $scrollBarWidth.xState)
                        gap = 1;
                    top_1 = isOutsideByTop
                        ? scroll_1.top + topFixedHeight - (topFixedHeight && !allFixedByCol ? 1 : 0)
                        : top_1;
                    if (isOutsideByBottom) {
                        height = bodyHeight - top_1 - bottomFixedHeight + scroll_1.top - gap;
                    }
                    else {
                        height = isOutsideByTop ? bottomByScroll - topFixedHeight : height;
                    }
                }
                if (config.$renderFrom === "render") {
                    zIndex = 14;
                    if (fixedColumns.left.find(function (i) { return i.id === col; })) {
                        left = scroll_1.left + (0, main_1.getTotalWidth)(fixedColumns.left.slice(0, colIndex));
                        if (!allFixedByCol) {
                            var minWidth = (0, main_1.getTotalWidth)(fixedColumns.left.slice(colIndex, leftSplit));
                            width = width - scroll_1.left > minWidth ? width - scroll_1.left : minWidth;
                        }
                    }
                    if (fixedRows.top.find(function (i) { return i.id === row; })) {
                        top_1 = scroll_1.top + (0, main_1.getTotalHeight)(fixedRows.top.slice(0, rowIndex));
                        if (!allFixedByRow) {
                            var minHeight = (0, main_1.getTotalHeight)(config.fixedRows.top.slice(rowIndex, config.topSplit));
                            height = height > 0 ? minHeight + height - gap : minHeight;
                        }
                    }
                    if (fixedColumns.right.find(function (col) {
                        return col === filteredColumns[filteredColumns.indexOf(currCol) + spanWidth - 1];
                    })) {
                        var totalLength = filteredColumns.length;
                        var reverseScrollState = getReverseScrollState(config);
                        var i_2 = totalLength - filteredColumns.indexOf(currCol) - spanWidth;
                        var minWidth = i_2
                            ? (0, main_1.getTotalWidth)(fixedColumns.right.slice(0, -i_2))
                            : (0, main_1.getTotalWidth)(fixedColumns.right);
                        var widthBeforeFixed = (0, main_1.getTotalWidth)(filteredColumns.slice(colIndex, totalLength - rightSplit));
                        left =
                            reverseScrollState.x > widthBeforeFixed
                                ? left - reverseScrollState.x + widthBeforeFixed
                                : left;
                        if (!allFixedByCol) {
                            width =
                                reverseScrollState.x < widthBeforeFixed
                                    ? width - reverseScrollState.x - 1
                                    : minWidth - 1;
                        }
                    }
                    if (fixedRows.bottom.find(function (row) {
                        return row === rows[rows.indexOf(currRow) + spanHeight - 1];
                    })) {
                        var totalLength = rows.length;
                        var reverseScrollState = getReverseScrollState(config);
                        var i_3 = totalLength - rows.indexOf(currRow) - spanHeight;
                        var minHeight = i_3
                            ? (0, main_1.getTotalHeight)(fixedRows.bottom.slice(0, -i_3))
                            : (0, main_1.getTotalHeight)(config.fixedRows.bottom);
                        var heightBeforeFixed = (0, main_1.getTotalHeight)(rows.slice(rowIndex, totalLength - bottomSplit));
                        top_1 =
                            reverseScrollState.y > heightBeforeFixed
                                ? top_1 - reverseScrollState.y + heightBeforeFixed
                                : top_1;
                        if (!allFixedByRow) {
                            height =
                                reverseScrollState.y < heightBeforeFixed
                                    ? minHeight + height - gap - (i_3 ? -1 : gap ? 0 : 1)
                                    : minHeight - (i_3 ? -1 : 1);
                        }
                    }
                }
                if (leftSplit === colIndex + 1) {
                    width -= 1;
                }
                if (colIndex === filteredColumns.length - rightSplit) {
                    left += 1;
                    width -= 1;
                }
            }
        }
        spanCells.push((0, dom_1.el)("div", {
            class: css,
            style: {
                width: width,
                height: height,
                top: top_1,
                left: left,
                zIndex: zIndex,
            },
            "data-dhx-col-id": col,
            "data-dhx-id": row,
            "aria-instead": "true",
        }, [
            isExpandingSpan
                ? (0, dom_1.el)(".dhx_span-expand-cell-icon", {
                    class: currRow.$opened ? "dxi dxi-chevron-down" : "dxi dxi-chevron-right",
                    "data-dhx-id": currRow.id,
                    role: "button",
                    "aria-label": currRow.$opened ? "Collapse group" : "Expand group",
                    style: {
                        padding: "0 0 0 ".concat(4 + (0, data_1.getTreeCellWidthOffset)(currRow, true), "px"),
                    },
                })
                : null,
            content,
        ]));
    };
    for (var i = 0; i < spans.length; i++) {
        _loop_1(i);
    }
    return spanCells;
}
exports.getSpans = getSpans;
function getShifts(conf) {
    var columnsLeft = conf.filteredColumns.slice(0, conf.$positions.xStart);
    var rowsTop = conf.data.slice(0, conf.$positions.yStart);
    return {
        x: (0, main_1.getTotalWidth)(columnsLeft),
        y: (0, main_1.getTotalHeight)(rowsTop),
    };
}
exports.getShifts = getShifts;
function normalizeSpan(span, config, data) {
    var _a = config.topSplit, topSplit = _a === void 0 ? 0 : _a, _b = config.bottomSplit, bottomSplit = _b === void 0 ? 0 : _b, columns = config.columns;
    var column = span.column, row = span.row, colspan = span.colspan, rowspan = span.rowspan;
    var rows = data.getRawData(0, -1, null, 2);
    var filteredColumns = columns.filter(function (col) { return !col.hidden; });
    var colIndexStart = filteredColumns.findIndex(function (c) { return c.id == column; });
    var rowIndexStart = rows.findIndex(function (i) { return i.id == row; });
    var colIndexEnd = colIndexStart + (colspan ? (0, cells_1.getReducedColspan)(columns, column, colspan) - 1 : 0);
    var rowIndexEnd = rowIndexStart +
        (rowspan ? (0, cells_1.getReducedRowspan)(data.getInitialData(), rows, rowIndexStart, span) - 1 : 0);
    var colIndexVisibility = colIndexStart === -1 ? [] : [colIndexStart, colIndexEnd];
    var rowsIndexVisibility = rowIndexStart === -1 ? [] : [rowIndexStart, rowIndexEnd];
    var $renderFrom = [];
    if (colIndexStart !== -1 && rowIndexStart !== -1) {
        var leftSplit = (0, common_1.getCurrFixedCols)(config, types_1.Split.left).length;
        var rightSplit = (0, common_1.getCurrFixedCols)(config, types_1.Split.right).length;
        var fixedLeftByStart = colIndexStart < leftSplit;
        var fixedTopByStart = rowIndexStart < topSplit;
        var fixedRightByEnd = colIndexEnd >= filteredColumns.length - rightSplit;
        var fixedBottomByEnd = rowIndexEnd >= rows.length - bottomSplit;
        // if the span is not fully fixed
        if (colIndexEnd >= leftSplit &&
            rowIndexEnd >= topSplit &&
            colIndexStart < filteredColumns.length - rightSplit &&
            rowIndexStart < rows.length - bottomSplit) {
            $renderFrom.push("render");
        }
        // if the span is fixed left
        if (fixedLeftByStart) {
            $renderFrom.push("leftFixedCols");
        }
        // if the span is fixed right
        if (fixedRightByEnd) {
            $renderFrom.push("rightFixedCols");
        }
        // if the span isn't fixed left or right and fixed top
        if (fixedTopByStart && !fixedLeftByStart && !fixedRightByEnd) {
            $renderFrom.push("topFixedRows");
        }
        else if (fixedTopByStart && !$renderFrom.includes("render")) {
            $renderFrom.push("render");
        }
        // if the span isn't fixed left or right and fixed bottom
        if (fixedBottomByEnd && !fixedLeftByStart && !fixedRightByEnd) {
            $renderFrom.push("bottomFixedRows");
        }
        else if (fixedBottomByEnd && !$renderFrom.includes("render")) {
            $renderFrom.push("render");
        }
    }
    return __assign(__assign({}, span), { $renderFrom: $renderFrom, $rowsVisibility: rowsIndexVisibility, $colsVisibility: colIndexVisibility });
}
exports.normalizeSpan = normalizeSpan;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    total: "Total",
    groupText: "Group",
    dropAreaTitle: "Group by:",
    dropAreaPlaceholder: "Drag the column header here",
};
exports.default = locale;


/***/ }),
/* 43 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.ajax = void 0;
var types_1 = __webpack_require__(25);
var helpers_1 = __webpack_require__(21);
function toQueryString(data) {
    return Object.keys(data)
        .reduce(function (entries, key) {
        var value = typeof data[key] === "object" ? JSON.stringify(data[key]) : data[key];
        entries.push(key + "=" + encodeURIComponent(value));
        return entries;
    }, [])
        .join("&");
}
function inferResponseType(contentType) {
    if (!contentType) {
        return "text";
    }
    if (contentType.includes("json")) {
        return "json";
    }
    if (contentType.includes("xml")) {
        return "xml";
    }
    return "text";
}
function send(url, data, method, headers, responseType) {
    function parseResponse(responseText, genResponseType) {
        switch (genResponseType) {
            case "json": {
                return JSON.parse(responseText);
            }
            case "text": {
                return responseText;
            }
            case "xml": {
                var driver = (0, helpers_1.toDataDriver)(types_1.DataDriver.xml);
                if (driver) {
                    return driver.toJsonObject(responseText);
                }
                else {
                    return { parseError: "Incorrect data driver type: 'xml'" };
                }
            }
            default: {
                return responseText;
            }
        }
    }
    var allHeaders = headers || {};
    if (responseType) {
        allHeaders.Accept = "application/" + responseType;
    }
    if (method !== "GET") {
        allHeaders["Content-Type"] = allHeaders["Content-Type"] || "application/json";
    }
    if (method === "GET") {
        var urlData = data && typeof data === "object"
            ? toQueryString(data)
            : data && typeof data === "string"
                ? data
                : "";
        if (urlData) {
            url += !url.includes("?") ? "?" : "&";
            url += urlData;
        }
        data = null;
    }
    if (!window.fetch) {
        return new Promise(function (resolve, reject) {
            var xhr = new XMLHttpRequest();
            xhr.onload = function () {
                if (xhr.status >= 200 && xhr.status < 300) {
                    if (responseType === "raw") {
                        resolve({
                            url: xhr.responseURL,
                            headers: xhr
                                .getAllResponseHeaders()
                                .trim()
                                .split(/[\r\n]+/)
                                .reduce(function (acc, cur) {
                                var kv = cur.split(": ");
                                acc[kv[0]] = kv[1];
                                return acc;
                            }, {}),
                            body: xhr.response,
                        });
                    }
                    if (xhr.status === 204) {
                        resolve();
                    }
                    else {
                        resolve(parseResponse(xhr.responseText, responseType || inferResponseType(xhr.getResponseHeader("Content-Type"))));
                    }
                }
                else {
                    reject({
                        status: xhr.status,
                        statusText: xhr.statusText,
                    });
                }
            };
            xhr.onerror = function () {
                reject({
                    status: xhr.status,
                    statusText: xhr.statusText,
                    message: xhr.responseText,
                });
            };
            xhr.open(method, url);
            for (var headerKey in allHeaders) {
                xhr.setRequestHeader(headerKey, allHeaders[headerKey]);
            }
            switch (method) {
                case "POST":
                case "DELETE":
                case "PUT":
                    xhr.send(data !== undefined ? JSON.stringify(data) : "");
                    break;
                case "GET":
                    xhr.send();
                    break;
                default:
                    xhr.send();
                    break;
            }
        });
    }
    else {
        var isJson = allHeaders["Content-Type"] === "application/json";
        if (isJson && data && typeof data === "object") {
            data = JSON.stringify(data);
        }
        return window
            .fetch(url, {
            method: method,
            body: data || null,
            headers: allHeaders,
        })
            .then(function (response) {
            if (response.ok) {
                var genResponseType = responseType || inferResponseType(response.headers.get("Content-Type"));
                if (genResponseType === "raw") {
                    return {
                        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
                        // @ts-ignore
                        headers: Object.fromEntries(response.headers.entries()),
                        url: response.url,
                        body: response.body,
                    };
                }
                if (response.status !== 204) {
                    switch (genResponseType) {
                        case "json": {
                            return response.json();
                        }
                        case "xml": {
                            var driver_1 = (0, helpers_1.toDataDriver)(types_1.DataDriver.xml);
                            if (driver_1) {
                                return response.text().then(function (xmlData) { return driver_1.toJsonObject(xmlData); });
                            }
                            else {
                                return response.text();
                            }
                        }
                        default:
                            return response.text();
                    }
                }
            }
            else {
                return response.text().then(function (message) {
                    return Promise.reject({
                        status: response.status,
                        statusText: response.statusText,
                        message: message,
                    });
                });
            }
        });
    }
}
exports.ajax = {
    get: function (url, data, config) {
        return send(url, data, "GET", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    post: function (url, data, config) {
        return send(url, data, "POST", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    put: function (url, data, config) {
        return send(url, data, "PUT", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
    delete: function (url, data, config) {
        return send(url, data, "DELETE", config && config.headers, config !== undefined ? config.responseType : undefined);
    },
};

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(18)))

/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CsvDriver = void 0;
var helpers_1 = __webpack_require__(21);
var CsvDriver = /** @class */ (function () {
    function CsvDriver(config) {
        var initConfig = {
            skipHeader: 0,
            nameByHeader: false,
            rowDelimiter: "\n",
            columnDelimiter: ",",
        };
        this.config = __assign(__assign({}, initConfig), config);
        if (this.config.nameByHeader) {
            this.config.skipHeader = 1;
        }
    }
    CsvDriver.prototype.getFields = function (row, headers) {
        var parts = (0, helpers_1.splitCsv)(row, this.config.columnDelimiter).map(function (part) {
            return part.replace(/^"(.*)"$/s, "$1").replace(/""/g, '"');
        });
        var obj = {};
        for (var i = 0; i < parts.length; i++) {
            obj[headers ? headers[i] : i + 1] = isNaN(Number(parts[i])) ? parts[i] : parseFloat(parts[i]);
        }
        return obj;
    };
    CsvDriver.prototype.getRows = function (data) {
        return (0, helpers_1.splitCsv)(data, this.config.rowDelimiter);
    };
    CsvDriver.prototype.toJsonArray = function (data) {
        var _this = this;
        var rows = this.getRows(data);
        var names = this.config.names;
        if (this.config.skipHeader) {
            var top_1 = rows.splice(0, this.config.skipHeader);
            if (this.config.nameByHeader) {
                names = top_1[0].trim().split(this.config.columnDelimiter);
            }
        }
        return rows.map(function (row) { return _this.getFields(row, names); });
    };
    CsvDriver.prototype.serialize = function (data, withoutHeader) {
        var header = data[0]
            ? Object.keys(data[0])
                .filter(function (key) { return !key.startsWith("$"); })
                .join(this.config.columnDelimiter) + this.config.rowDelimiter
            : "";
        var readyData = this._serialize(data);
        if (withoutHeader) {
            return readyData;
        }
        return header + readyData;
    };
    CsvDriver.prototype._serialize = function (data) {
        var _this = this;
        return data.reduce(function (csv, row) {
            var keys = Object.keys(row);
            var cells = keys.reduce(function (total, key, i) {
                var _a, _b;
                if (key.startsWith("$") || key === "items") {
                    return total;
                }
                var value = (_b = (_a = row[key]) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "";
                var normalizedValue = new RegExp("[".concat(_this.config.columnDelimiter, "\"\n]")).test(value)
                    ? "\"".concat(value.replace(/"/g, '""').replace(/\n/g, "\\n"), "\"")
                    : value;
                var delimiter = i === keys.length - 1 || keys[i + 1].startsWith("$") ? "" : _this.config.columnDelimiter;
                return total + normalizedValue + delimiter;
            }, "");
            if (row.items) {
                return "".concat(csv).concat(csv ? "\n" : "").concat(cells).concat(_this._serialize(row.items));
            }
            return "".concat(csv).concat(csv ? _this.config.rowDelimiter : "").concat(cells);
        }, "");
    };
    return CsvDriver;
}());
exports.CsvDriver = CsvDriver;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Layout = void 0;
var types_1 = __webpack_require__(47);
var Cell_1 = __webpack_require__(70);
var dom_1 = __webpack_require__(0);
var Layout = /** @class */ (function (_super) {
    __extends(Layout, _super);
    function Layout(parent, config) {
        var _this = _super.call(this, parent, config) || this;
        // root layout
        _this._root = _this.config.parent || _this;
        _this._all = {};
        _this._parseConfig();
        _this._progress = false;
        if (_this.config.activeTab) {
            _this.config.activeView = _this.config.activeTab;
        }
        // Need replace to tabbar
        if (_this.config.views) {
            _this.config.activeView = _this.config.activeView || _this._cells[0].id;
            _this._isViewLayout = true;
        }
        if (!config.parent) {
            var view = (0, dom_1.create)({ render: function () { return _this._root && _this.toVDOM(); } }, _this);
            _this.mount(parent, view);
        }
        return _this;
    }
    Layout.prototype.destructor = function () {
        this.unmount();
        if (this.config) {
            for (var _i = 0, _a = this._cells; _i < _a.length; _i++) {
                var cell = _a[_i];
                cell === null || cell === void 0 ? void 0 : cell.destructor();
            }
            this.config = this._cells = this._root = this._xLayout = this._isViewLayout = null;
            this._all = {};
        }
    };
    Layout.prototype.toVDOM = function () {
        var _a;
        if (this._isViewLayout) {
            var roots = [this.getCell(this.config.activeView).toVDOM()];
            return _super.prototype.toVDOM.call(this, roots);
        }
        var nodes = [];
        this._inheritTypes();
        (_a = this._cells) === null || _a === void 0 ? void 0 : _a.forEach(function (cell) {
            var node = cell.toVDOM();
            if (Array.isArray(node)) {
                nodes = nodes.concat(node);
            }
            else {
                nodes.push(node);
            }
        });
        return _super.prototype.toVDOM.call(this, nodes);
    };
    Layout.prototype.removeCell = function (id) {
        if (!this.events.fire(types_1.LayoutEvents.beforeRemove, [id])) {
            return;
        }
        var root = this.config.parent || this;
        if (root !== this) {
            root.removeCell(id);
            return;
        }
        // this === root layout
        var view = this.getCell(id);
        if (view) {
            var parent_1 = view.getParent();
            delete this._all[id];
            parent_1._cells = parent_1._cells.filter(function (cell) { return cell.id != id; });
            parent_1.paint();
        }
        this.events.fire(types_1.LayoutEvents.afterRemove, [id]);
    };
    Layout.prototype.getId = function (index) {
        if (index < 0) {
            index = this._cells.length + index;
        }
        return this._cells[index] ? this._cells[index].id : undefined;
    };
    Layout.prototype.getRefs = function (name) {
        var _a;
        return (_a = this._root.getRootView().refs) === null || _a === void 0 ? void 0 : _a[name];
    };
    Layout.prototype.getCell = function (id) {
        var _a;
        return (_a = this._root) === null || _a === void 0 ? void 0 : _a._all[id];
    };
    Layout.prototype.forEach = function (callback, parent, level) {
        if (level === void 0) { level = Infinity; }
        if (!this._haveCells(parent) || level < 1) {
            return;
        }
        var array;
        if (parent) {
            array = this._root._all[parent]._cells;
        }
        else {
            array = this._root._cells;
        }
        for (var index = 0; index < array.length; index++) {
            var cell = array[index];
            callback.call(this, cell, index, array);
            if (this._haveCells(cell.id)) {
                cell.forEach(callback, cell.id, --level);
            }
        }
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Layout.prototype.cell = function (id) {
        return this.getCell(id);
    };
    Layout.prototype.progressShow = function () {
        this._progress = true;
        this.paint();
    };
    Layout.prototype.progressHide = function () {
        this._progress = false;
        this.paint();
    };
    Layout.prototype._addCell = function (config, index) {
        if (index === void 0) { index = -1; }
        if (!this.events.fire(types_1.LayoutEvents.beforeAdd, [config.id])) {
            return;
        }
        var view = this._createCell(config);
        if (index < 0) {
            index = this._cells.length + index + 1;
        }
        this._cells.splice(index, 0, view);
        this.paint();
        if (!this.events.fire(types_1.LayoutEvents.afterAdd, [config.id])) {
            return;
        }
    };
    Layout.prototype._getCss = function (content) {
        var layoutCss = this._xLayout ? "dhx_layout-columns" : "dhx_layout-rows";
        var directionCss = this.config.align ? " " + layoutCss + "--" + this.config.align : "";
        if (content) {
            return (layoutCss +
                " dhx_layout-cell" +
                (this.config.align ? " dhx_layout-cell--" + this.config.align : ""));
        }
        else {
            var cellCss = this.config.parent ? _super.prototype._getCss.call(this) : "dhx_widget dhx_layout";
            var fullModeCss = this.config.parent ? "" : " dhx_layout-cell";
            return cellCss + (this.config.full ? fullModeCss : " " + layoutCss) + directionCss;
        }
    };
    Layout.prototype._parseConfig = function () {
        var _this = this;
        var config = this.config;
        var cells = config.rows || config.cols || config.views || [];
        this._xLayout = !config.rows;
        this._cells = cells.map(function (a) { return _this._createCell(a); });
    };
    Layout.prototype._createCell = function (cell) {
        var view;
        if (cell.rows || cell.cols || cell.views) {
            cell.parent = this._root;
            view = new Layout(this, cell);
        }
        else {
            view = new Cell_1.Cell(this, cell);
        }
        // FIxME
        this._root._all[view.id] = view;
        if (cell.init) {
            cell.init(view, cell);
        }
        return view;
    };
    Layout.prototype._haveCells = function (id) {
        if (id) {
            var array = this._root._all[id];
            return array._cells && array._cells.length > 0;
        }
        return Object.keys(this._all).length > 0;
    };
    Layout.prototype._inheritTypes = function (obj) {
        var _this = this;
        if (obj === void 0) { obj = this._cells; }
        if (Array.isArray(obj)) {
            obj.forEach(function (cell) { return _this._inheritTypes(cell); });
        }
        else {
            var cellConfig = obj === null || obj === void 0 ? void 0 : obj.config;
            if ((cellConfig === null || cellConfig === void 0 ? void 0 : cellConfig.rows) || (cellConfig === null || cellConfig === void 0 ? void 0 : cellConfig.cols)) {
                var viewParent = obj.getParent();
                if (!cellConfig.type && viewParent) {
                    if (viewParent.config.type) {
                        cellConfig.type = viewParent.config.type;
                    }
                    else {
                        this._inheritTypes(viewParent);
                    }
                }
            }
        }
    };
    return Layout;
}(Cell_1.Cell));
exports.Layout = Layout;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LayoutEvents = void 0;
var LayoutEvents;
(function (LayoutEvents) {
    LayoutEvents["beforeShow"] = "beforeShow";
    LayoutEvents["afterShow"] = "afterShow";
    LayoutEvents["beforeHide"] = "beforeHide";
    LayoutEvents["afterHide"] = "afterHide";
    LayoutEvents["beforeResizeStart"] = "beforeResizeStart";
    LayoutEvents["resize"] = "resize";
    LayoutEvents["afterResizeEnd"] = "afterResizeEnd";
    LayoutEvents["beforeAdd"] = "beforeAdd";
    LayoutEvents["afterAdd"] = "afterAdd";
    LayoutEvents["beforeRemove"] = "beforeRemove";
    LayoutEvents["afterRemove"] = "afterRemove";
    LayoutEvents["beforeCollapse"] = "beforeCollapse";
    LayoutEvents["afterCollapse"] = "afterCollapse";
    LayoutEvents["beforeExpand"] = "beforeExpand";
    LayoutEvents["afterExpand"] = "afterExpand";
})(LayoutEvents || (exports.LayoutEvents = LayoutEvents = {}));


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageContainerPosition = exports.Position = exports.RealPosition = void 0;
var RealPosition;
(function (RealPosition) {
    RealPosition["left"] = "left";
    RealPosition["right"] = "right";
    RealPosition["top"] = "top";
    RealPosition["bottom"] = "bottom";
    RealPosition["center"] = "center";
})(RealPosition || (exports.RealPosition = RealPosition = {}));
var Position;
(function (Position) {
    Position["right"] = "right";
    Position["bottom"] = "bottom";
    Position["center"] = "center";
    Position["left"] = "left";
    Position["top"] = "top";
})(Position || (exports.Position = Position = {}));
var MessageContainerPosition;
(function (MessageContainerPosition) {
    MessageContainerPosition["topLeft"] = "top-left";
    MessageContainerPosition["topRight"] = "top-right";
    MessageContainerPosition["bottomLeft"] = "bottom-left";
    MessageContainerPosition["bottomRight"] = "bottom-right";
})(MessageContainerPosition || (exports.MessageContainerPosition = MessageContainerPosition = {}));


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    apply: "apply",
    reject: "reject",
};
exports.default = locale;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(161), exports);
__exportStar(__webpack_require__(78), exports);


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(162), exports);
__exportStar(__webpack_require__(76), exports);


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    dragAndDrop: "Drag & drop",
    or: "or",
    browse: "Browse files",
    filesOrFoldersHere: "files or folders here",
    cancel: "Cancel",
    clearAll: "Clear all",
    clear: "Clear",
    add: "Add",
    upload: "Upload",
    download: "Download",
    error: "error",
    byte: "B",
    kilobyte: "KB",
    megabyte: "MB",
    gigabyte: "GB",
};
exports.default = locale;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ListEvents = void 0;
var ListEvents;
(function (ListEvents) {
    ListEvents["click"] = "click";
    ListEvents["doubleClick"] = "doubleclick";
    ListEvents["focusChange"] = "focuschange";
    ListEvents["beforeEditStart"] = "beforeEditStart";
    ListEvents["afterEditStart"] = "afterEditStart";
    ListEvents["beforeEditEnd"] = "beforeEditEnd";
    ListEvents["afterEditEnd"] = "afterEditEnd";
    ListEvents["itemRightClick"] = "itemRightClick";
    ListEvents["itemMouseOver"] = "itemMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ListEvents["contextmenu"] = "contextmenu";
})(ListEvents || (exports.ListEvents = ListEvents = {}));


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.locale = void 0;
__exportStar(__webpack_require__(174), exports);
__exportStar(__webpack_require__(83), exports);
__exportStar(__webpack_require__(82), exports);
__exportStar(__webpack_require__(55), exports);
var en_1 = __webpack_require__(56);
Object.defineProperty(exports, "locale", { enumerable: true, get: function () { return en_1.default; } });


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getAlpha = exports.alphaToHex = exports.isHex = exports.HexToHSV = exports.RGBToHSV = exports.HexToRGB = exports.RGBToHex = exports.HSVtoRGB = void 0;
function HSVtoRGB(hsv) {
    var rgb = { r: 0, g: 0, b: 0 };
    var h = hsv.h / 60;
    var s = hsv.s;
    var v = hsv.v;
    var i = Math.floor(h) % 6;
    var f = h - Math.floor(h);
    var p = 255 * v * (1 - s);
    var q = 255 * v * (1 - s * f);
    var t = 255 * v * (1 - s * (1 - f));
    v *= 255;
    switch (i) {
        case 0:
            rgb.r = v;
            rgb.g = t;
            rgb.b = p;
            break;
        case 1:
            rgb.r = q;
            rgb.g = v;
            rgb.b = p;
            break;
        case 2:
            rgb.r = p;
            rgb.g = v;
            rgb.b = t;
            break;
        case 3:
            rgb.r = p;
            rgb.g = q;
            rgb.b = v;
            break;
        case 4:
            rgb.r = t;
            rgb.g = p;
            rgb.b = v;
            break;
        case 5:
            rgb.r = v;
            rgb.g = p;
            rgb.b = q;
            break;
    }
    for (var key in rgb) {
        rgb[key] = Math.round(rgb[key]);
    }
    return rgb;
}
exports.HSVtoRGB = HSVtoRGB;
function RGBToHex(rgb) {
    return Object.keys(rgb).reduce(function (hex, c) {
        var h = rgb[c].toString(16).toUpperCase();
        h = h.length === 1 ? "0" + h : h;
        return (hex += h);
    }, "#");
}
exports.RGBToHex = RGBToHex;
function HexToRGB(hex) {
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (_m, r, g, b) { return r + r + g + g + b + b; });
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result
        ? {
            r: parseInt(result[1], 16),
            g: parseInt(result[2], 16),
            b: parseInt(result[3], 16),
        }
        : null;
}
exports.HexToRGB = HexToRGB;
function RGBToHSV(rgb) {
    var h;
    var s;
    var r = rgb.r / 255;
    var g = rgb.g / 255;
    var b = rgb.b / 255;
    var v = Math.max(r, g, b);
    var diff = v - Math.min(r, g, b);
    var diffc = function (c) {
        return (v - c) / 6 / diff + 1 / 2;
    };
    if (diff === 0) {
        h = s = 0;
    }
    else {
        s = diff / v;
        var rdif = diffc(r);
        var gdif = diffc(g);
        var bdif = diffc(b);
        if (r === v) {
            h = bdif - gdif;
        }
        else if (g === v) {
            h = 1 / 3 + rdif - bdif;
        }
        else if (b === v) {
            h = 2 / 3 + gdif - rdif;
        }
        if (h < 0) {
            h += 1;
        }
        else if (h > 1) {
            h -= 1;
        }
    }
    return {
        h: h * 360,
        s: s,
        v: v,
    };
}
exports.RGBToHSV = RGBToHSV;
function HexToHSV(hex) {
    return RGBToHSV(HexToRGB(hex.length === 9 ? hex.slice(0, -2) : hex));
}
exports.HexToHSV = HexToHSV;
function isHex(hex) {
    return /(^#[0-9A-F]{8}$)|(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
}
exports.isHex = isHex;
function alphaToHex(alpha) {
    var hex = Math.round(alpha * 255)
        .toString(16)
        .toUpperCase();
    return hex.length === 1 ? "0" + hex : hex;
}
exports.alphaToHex = alphaToHex;
function getAlpha(hex) {
    return hex.length === 9 ? Number((parseInt(hex.slice(-2), 16) / 255).toFixed(2)) : 1;
}
exports.getAlpha = getAlpha;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var en = {
    cancel: "Cancel",
    select: "Select",
    rightClickToDelete: "Right click to delete",
    customColors: "Custom colors",
    addNewColor: "Add new color",
};
exports.default = en;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scale = void 0;
var AxisCreator_1 = __webpack_require__(183);
var SvgScales_1 = __webpack_require__(86);
var common_1 = __webpack_require__(7);
var renderScale = {
    left: SvgScales_1.left,
    right: SvgScales_1.right,
    bottom: SvgScales_1.bottom,
    top: SvgScales_1.top,
};
var renderGrid = {
    left: SvgScales_1.leftGrid,
    right: SvgScales_1.rightGrid,
    bottom: SvgScales_1.bottomGrid,
    top: SvgScales_1.topGrid,
};
var Scale = /** @class */ (function () {
    function Scale(_data, config, position) {
        this._data = _data;
        this._padding = false;
        this._charts = [];
        this._position = position;
        this._setDefaults(config);
        this._isXDirection = position === "bottom" || position === "top";
        if (position !== "radial") {
            if (position === "left" || position === "right") {
                this.config.size = this.config.size || 40 + (this.config.title ? 40 : 0);
            }
            else {
                this.config.size = this.config.size || 20 + (this.config.title ? 40 : 0);
            }
        }
    }
    Scale.prototype.addPadding = function () {
        this._padding = true;
    };
    Scale.prototype.getSize = function () {
        return this.config.size;
    };
    Scale.prototype.scaleReady = function (sizes) {
        var points = [];
        this._charts.forEach(function (chart) {
            chart.getPoints().forEach(function (item) { return points.push(item[1]); }); // y-value
        });
        this._axis = new AxisCreator_1.AxisCreator(points, this.config).getScale();
        var position = this._position;
        if (position !== "radial") {
            sizes[position] += this.config.size;
        }
    };
    Scale.prototype.point = function (pos) {
        if (this.config.log) {
            return this._logPoint(pos);
        }
        else {
            return this._isXDirection
                ? (pos - this._axis.min) / (this._axis.max - this._axis.min)
                : 1 - (pos - this._axis.min) / (this._axis.max - this._axis.min);
        }
    };
    Scale.prototype.add = function (val) {
        this._charts.push(val);
    };
    Scale.prototype.paint = function (width, height) {
        var _this = this;
        if (this.config.hidden) {
            return null;
        }
        var steps = this._axis.steps;
        var points = steps.map(function (item) { return [
            _this._isXDirection ? _this.point(item) * width : _this.point(item) * height,
            item,
        ]; });
        if (points.length === 0 && this._position === "left") {
            points = [[0, 0]];
        }
        return renderScale[this._position](points, this.config, width, height);
    };
    Scale.prototype.scaleGrid = function () {
        var _this = this;
        var getPoints = function (width, height) {
            return _this._axis.steps.map(function (item) { return [
                _this._isXDirection ? _this.point(item) * width : _this.point(item) * height,
                item,
            ]; });
        };
        var type = this._position;
        var grid = this.config.grid;
        var dashed = this.config.dashed;
        var hidden = this.config.hidden;
        var getSpecificLevel = function () { return _this._axis.steps.indexOf(_this.config.targetLine); };
        var getSpecificNumber = function () { return _this.point(_this.config.targetValue); };
        return {
            paint: function (width, height) {
                var targetLine = getSpecificLevel();
                var points = getPoints(width, height);
                var targetValue = getSpecificNumber();
                var config = {
                    targetLine: targetLine,
                    dashed: dashed,
                    grid: grid,
                    targetValue: targetValue,
                    hidden: hidden,
                };
                return renderGrid[type](points, width, height, config);
            },
        };
    };
    Scale.prototype._setDefaults = function (config) {
        var defaults = {
            scalePadding: 20,
            textPadding: 11,
            grid: true,
            targetLine: null,
            showText: true,
        };
        if (config.locator) {
            this.locator = (0, common_1.locator)(config.locator);
        }
        this.config = __assign(__assign({}, defaults), config);
    };
    Scale.prototype._logPoint = function (pos) {
        var logPos;
        var sign = Math.abs(pos) / pos;
        var steps = this._axis.steps;
        var count = steps.length - 1;
        var index = steps.indexOf(pos);
        if (index !== -1) {
            logPos = index / count;
        }
        else {
            var dx = this._axis.min < 0 ? steps.indexOf(0) : 0;
            var exp = sign * (0, common_1.log10)(Math.abs(pos));
            logPos = (dx + exp) / count;
        }
        return this._isXDirection ? logPos : 1 - logPos;
    };
    return Scale;
}());
exports.Scale = Scale;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__(7);
var BaseSeria_1 = __webpack_require__(32);
var ScaleSeria = /** @class */ (function (_super) {
    __extends(ScaleSeria, _super);
    function ScaleSeria() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ScaleSeria.prototype.addScale = function (type, scale) {
        if (type === "bottom" || type === "top") {
            this.xScale = scale;
            this._xLocator = scale.locator;
        }
        else {
            this.yScale = scale;
            this._yLocator = (0, common_1.locator)(this.config.value);
        }
    };
    ScaleSeria.prototype.paint = function (width, height) {
        _super.prototype.paint.call(this, width, height);
    };
    ScaleSeria.prototype.dataReady = function (prev) {
        var _this = this;
        if (!this.config.active) {
            return (this._points = []);
        }
        this._points = this._data.map(function (item, index) {
            // raw values
            var x = _this._xLocator(item);
            var y = _this._yLocator(item) || 0;
            var set = [x, y, item.id, x, y];
            if (prev) {
                set[1] += prev[index][1];
            }
            return set;
        });
        return this._points;
    };
    ScaleSeria.prototype._calckFinalPoints = function (width, height) {
        var _this = this;
        this._points.forEach(function (item, index) {
            // scaled values
            item[0] = _this.xScale.point(item[0]) * width || 0;
            var pointHeight = _this.yScale.point(item[1]) * height;
            item[1] = !isNaN(pointHeight) ? pointHeight : _this.config.type === "xbar" ? 0 : height;
        });
    };
    ScaleSeria.prototype._defaultLocator = function (v) {
        return [this._yLocator(v), this._xLocator(v)];
    };
    ScaleSeria.prototype._getCss = function () {
        return "chart ".concat(this.config.type, " ").concat(this.config.css || "", " ").concat(this.config.dashed ? "dash-line" : "");
    };
    return ScaleSeria;
}(BaseSeria_1.default));
exports.default = ScaleSeria;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var common_1 = __webpack_require__(7);
var BaseSeria_1 = __webpack_require__(32);
var NoScaleSeria = /** @class */ (function (_super) {
    __extends(NoScaleSeria, _super);
    function NoScaleSeria() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._center = [0, 0]; // (x, y)
        _this._tooltipData = []; // (x, y)
        return _this;
    }
    NoScaleSeria.prototype.scaleReady = function (sizes) {
        for (var key in sizes) {
            sizes[key] += this.config.paddings;
        }
        return sizes;
    };
    NoScaleSeria.prototype.dataReady = function () {
        var _this = this;
        var data = this._data;
        this._sum = data.reduce(function (sum, item) { return (item.$hidden ? sum : sum + parseFloat(_this._valueLocator(item))); }, 0);
        this._points = data.reduce(function (items, item, i) {
            if (item.$hidden) {
                return items;
            }
            var t = _this._textLocator(item);
            var v = _this._valueLocator(item);
            var x = v / _this._sum;
            var c = _this._colorLocator ? _this._colorLocator(item) : (0, common_1.getDefaultColor)(i);
            items.push([x, v, item.id, t, c]);
            return items;
        }, []);
        return this._points;
    };
    NoScaleSeria.prototype.toggle = function (id) {
        var item = this._data.getItem(id);
        if (!item) {
            return;
        }
        this._data.update(id, { $hidden: !item.$hidden });
    };
    NoScaleSeria.prototype.getClosest = function (x, y) {
        var percent = 1 - (Math.atan2(x - this._center[0], y - this._center[1]) + Math.PI) / Math.PI / 2;
        var points = this._points;
        for (var i = 0; i < points.length; i++) {
            if (points[i][0] >= percent) {
                return [0, this._tooltipData[i][0], this._tooltipData[i][1], points[i][2]];
            }
            percent -= points[i][0];
        }
        return [Infinity, null, null, null];
    };
    NoScaleSeria.prototype.getTooltipText = function (id) {
        if (this.config.tooltip) {
            var p = this._defaultLocator(this._data.getItem(id));
            if (this.config.tooltipTemplate) {
                return this.config.tooltipTemplate(p);
            }
            return p[0];
        }
    };
    NoScaleSeria.prototype.getTooltipType = function (_id) {
        return "simple";
    };
    NoScaleSeria.prototype._setDefaults = function (config) {
        var _this = this;
        var defaults = {
            subType: "basic",
            paddings: config.useLines ? 70 : 50,
        };
        this.config = __assign(__assign({}, defaults), config);
        this._drawPointType = this._getPointType("empty", "none");
        this._valueLocator = (0, common_1.locator)(config.value);
        this._textLocator = (0, common_1.locator)(config.text);
        if (config.color) {
            this._colorLocator = (0, common_1.locator)(config.color);
        }
        else if (config.monochrome) {
            this._colorLocator = function (item) { return (0, common_1.getColorShade)(config.monochrome, _this._getPercent(item) * 2); }; // 2 for more bright
        }
    };
    NoScaleSeria.prototype._defaultLocator = function (v) {
        return [this._valueLocator(v), this._textLocator(v)];
    };
    NoScaleSeria.prototype._getPercent = function (item) {
        return parseFloat(this._valueLocator(item)) / this._sum;
    };
    return NoScaleSeria;
}(BaseSeria_1.default));
exports.default = NoScaleSeria;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var ScaleSeria_1 = __webpack_require__(58);
var Line = /** @class */ (function (_super) {
    __extends(Line, _super);
    function Line() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Line.prototype.paint = function (width, height) {
        var _this = this;
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        var getPointAriaAttrs = function (key, points) {
            var point;
            if (key) {
                point = points.find(function (p) { return key.includes(p[2]); });
            }
            return {
                role: "graphics-symbol",
                "aria-roledescription": "point",
                "aria-label": point ? "point x=".concat(point[3], " y=").concat(point[4]) : "",
                tabindex: 0,
            };
        };
        var color = this.config.pointColor || this.config.color;
        var svg = [];
        if (this.config.strokeWidth) {
            svg.push(this._getForm(this._points, this.config, width, height));
        }
        if (this.config.pointType) {
            var point_1 = this._getPointType(this.config.pointType, color);
            svg = svg.concat(this._points
                .map(function (p) { return point_1(p[0], p[1], (0, common_1.calcPointRef)(p[2], _this.id)); })
                .map(function (node, index) {
                if (node && node.attrs) {
                    node.attrs = __assign(__assign({}, node.attrs), getPointAriaAttrs(node.key, _this._points));
                    if (_this.config.tooltip) {
                        node.attrs.onmousemove = [
                            _this._handlers.onmousemove,
                            _this._points[index][2],
                            _this.id,
                        ];
                        node.attrs.onmouseleave = [
                            _this._handlers.onmouseleave,
                            _this._points[index][2],
                            _this.id,
                        ];
                        node.attrs.onclick = [
                            _this._handlers.onmousemove,
                            _this._points[index][2],
                            _this.id,
                        ];
                    }
                }
                return node;
            }));
        }
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Line.prototype._getForm = function (points, config, width, height) {
        var d = points.map(function (item, index) { return (index ? "L" : "M") + "".concat(item[0], " ").concat(item[1]); }).join(" ");
        var path = (0, dom_1.sv)("path", {
            id: "seria" + config.id,
            d: d,
            stroke: config.color,
            class: this._getCss(),
            "stroke-width": this.config.strokeWidth,
            fill: "none",
        });
        return path;
    };
    Line.prototype._setDefaults = function (config) {
        var defaults = {
            alpha: 1,
            strokeWidth: 2,
            active: true,
            tooltip: true,
        };
        this.config = __assign(__assign({}, defaults), config);
    };
    return Line;
}(ScaleSeria_1.default));
exports.default = Line;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    notFound: "Not Found",
    selectAll: "Select All",
    unselectAll: "Unselect All",
    selectedItems: "selected items",
    createItem: "Create",
};


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(63), exports);
__exportStar(__webpack_require__(142), exports);
__exportStar(__webpack_require__(34), exports);


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.Uploader = void 0;
/* eslint-disable @typescript-eslint/unbound-method */
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(2);
var ts_data_1 = __webpack_require__(4);
var types_1 = __webpack_require__(34);
var Uploader = /** @class */ (function () {
    function Uploader(config, data, events) {
        if (config === void 0) { config = {}; }
        this.config = (0, core_1.extend)({
            autosend: true,
            updateFromResponse: true,
            fieldName: "file",
            accept: "",
        }, config);
        this.data = data || new ts_data_1.DataCollection();
        this.events = events || this.data.events;
        this.isActive = false;
        this._fileInput = document.createElement("input");
        this._fileInput.type = "file";
        this._fileInput.accept = this.config.accept;
        this._fileInput.multiple = true;
        this._initEvents();
        this._dropAreas = new Map();
    }
    Uploader.prototype.selectFile = function () {
        this._fileInput.click();
    };
    Uploader.prototype.linkDropArea = function (element) {
        var _this = this;
        var node = (0, html_1.toNode)(element);
        var dragover = function (e) { return e.preventDefault(); };
        var drop = function (e) {
            e.preventDefault();
            _this.parseFiles(e.dataTransfer);
        };
        node.addEventListener("dragover", dragover);
        node.addEventListener("drop", drop);
        this._dropAreas.set(node, {
            dragover: dragover,
            drop: drop,
        });
    };
    Uploader.prototype.unlinkDropArea = function (element) {
        var _this = this;
        if (!element) {
            this._dropAreas.forEach(function (_, node) {
                _this._unlinkDropArea(node);
            });
            this._dropAreas.clear();
        }
        else {
            var node = (0, html_1.toNode)(element);
            this._unlinkDropArea(node);
            this._dropAreas.delete(node);
        }
    };
    Uploader.prototype.parseFiles = function (dataTransfer) {
        if (!dataTransfer.items || !dataTransfer.items[0] || !dataTransfer.items[0].webkitGetAsEntry) {
            var files = dataTransfer.files;
            for (var i = 0; i < files.length; i++) {
                this._addFile(files[i]);
            }
            if (this.config.autosend) {
                this.send();
            }
        }
        else {
            this._parseAsWebkitEntry(dataTransfer.items);
        }
    };
    Uploader.prototype.send = function (params) {
        var _this = this;
        if (this._uploadInfo && this.isActive) {
            // cancel two active sends
            return;
        }
        var all = this.data.findAll(function (item) { return item.status === types_1.FileStatus.queue || item.status === types_1.FileStatus.failed; });
        var files = all.filter(function (file) { return _this.events.fire(types_1.UploaderEvents.beforeUploadFile, [file]); });
        if (!files.length) {
            return;
        }
        this.isActive = true;
        this._uploadInfo = {
            files: files,
            count: files.length,
            size: files.reduce(function (s, f) { return s + f.file.size; }, 0),
        };
        this.events.fire(types_1.UploaderEvents.uploadBegin, [files]);
        this.events.fire(types_1.UploaderEvents.uploadProgress, [0, 0, this._uploadInfo.size]);
        if (this.config.singleRequest) {
            this._xhrSend(files, params);
        }
        else {
            for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
                var fileWrapper = files_1[_i];
                this._xhrSend([fileWrapper], params);
            }
        }
    };
    Uploader.prototype.abort = function (id) {
        if (!id) {
            if (!this._uploadInfo || !this._uploadInfo.files) {
                return;
            }
            for (var _i = 0, _a = this._uploadInfo.files; _i < _a.length; _i++) {
                var fileWrapper = _a[_i];
                this.abort(fileWrapper.id);
            }
            return;
        }
        else {
            var item = this.data.getItem(id);
            if (!item || !item.request || item.request.readyState === 4) {
                return;
            }
            item.request.abort();
        }
    };
    Uploader.prototype._unlinkDropArea = function (node) {
        var handlers = this._dropAreas.get(node);
        if (!handlers) {
            return;
        }
        var dragover = handlers.dragover, drop = handlers.drop;
        node.removeEventListener("dragover", dragover);
        node.removeEventListener("drop", drop);
    };
    Uploader.prototype._initEvents = function () {
        var _this = this;
        this._fileInput.addEventListener("change", function () {
            var files = _this._fileInput.files;
            for (var i = 0; i < files.length; i++) {
                _this._addFile(files[i]);
            }
            if (_this.config.autosend) {
                _this.send();
            }
            _this._fileInput.value = null; // clear file input after get info about files
        });
    };
    Uploader.prototype._xhrSend = function (fileWrappers, params) {
        var _this = this;
        var formData = this._createFormData(fileWrappers, params);
        var request = new XMLHttpRequest();
        var headerParams = this.config.headerParams;
        for (var _i = 0, fileWrappers_1 = fileWrappers; _i < fileWrappers_1.length; _i++) {
            var fileWrapper = fileWrappers_1[_i];
            this.data.update(fileWrapper.id, {
                request: request,
                status: types_1.FileStatus.inprogress,
                progress: 0,
            });
        }
        request.open("POST", this.config.target);
        if (headerParams) {
            for (var headerItem in headerParams) {
                request.setRequestHeader(headerItem, headerParams[headerItem]);
            }
        }
        request.upload.onprogress = function (ev) {
            for (var _i = 0, fileWrappers_2 = fileWrappers; _i < fileWrappers_2.length; _i++) {
                var fileWrapper = fileWrappers_2[_i];
                _this.data.update(fileWrapper.id, {
                    progress: ev.loaded / ev.total,
                    status: types_1.FileStatus.inprogress,
                });
            }
            var current = _this._uploadInfo.files.reduce(function (tot, file) { return tot + file.size * file.progress; }, 0) || 0;
            var total = _this._uploadInfo.size;
            var progress = (current / _this._uploadInfo.size) * 100 || 0;
            _this.events.fire(types_1.UploaderEvents.uploadProgress, [progress, current, total]);
        };
        request.onloadend = function () {
            _this._uploadInfo.count = _this.config.singleRequest ? 0 : _this._uploadInfo.count - 1;
            var status = request.status === 200 ? types_1.FileStatus.uploaded : types_1.FileStatus.failed;
            var extra = request.status === 200 && request.response ? JSON.parse(request.response) : null;
            for (var _i = 0, fileWrappers_3 = fileWrappers; _i < fileWrappers_3.length; _i++) {
                var fileWrapper = fileWrappers_3[_i];
                _this.data.update(fileWrapper.id, { status: status });
                if (status === types_1.FileStatus.uploaded) {
                    if (_this.config.updateFromResponse && extra) {
                        if (_this.config.singleRequest && extra[fileWrapper.id]) {
                            _this.data.update(fileWrapper.id, extra[fileWrapper.id]);
                        }
                        else if (!_this.config.singleRequest) {
                            _this.data.update(fileWrapper.id, extra);
                        }
                    }
                    _this.events.fire(types_1.UploaderEvents.uploadFile, [fileWrapper, extra]);
                }
                else {
                    _this.events.fire(types_1.UploaderEvents.uploadFail, [fileWrapper]);
                }
            }
            if (_this._uploadInfo.count === 0) {
                _this.isActive = false;
                _this.events.fire(types_1.UploaderEvents.uploadComplete, [_this._uploadInfo.files]);
            }
        };
        request.send(formData);
    };
    Uploader.prototype._parseAsWebkitEntry = function (items) {
        var _this = this;
        var reads = [];
        for (var i = 0; i < items.length; i++) {
            var item = items[i].webkitGetAsEntry();
            reads.push(this._traverseFileTree(item));
        }
        Promise.all(reads).then(function () {
            if (_this.config.autosend) {
                _this.send();
            }
        });
    };
    Uploader.prototype._createFormData = function (fileWrappers, params) {
        var fieldName = this.config.fieldName;
        var formData = new FormData();
        var extraParams = this.config.params;
        if (params) {
            for (var key in params) {
                formData.append(key, params[key]);
            }
        }
        if (extraParams) {
            for (var key in extraParams) {
                formData.append(key, extraParams[key]);
            }
        }
        var brackets = fileWrappers.length > 1 ? "[]" : "";
        for (var _i = 0, fileWrappers_4 = fileWrappers; _i < fileWrappers_4.length; _i++) {
            var fileWrapper = fileWrappers_4[_i];
            formData.append(fieldName + brackets, fileWrapper.file, fileWrapper.file.name);
            formData.append(fieldName + "_fullname" + brackets, fileWrapper.path + fileWrapper.file.name);
            var id = typeof fileWrapper.id === "object" ? fileWrapper.id : fileWrapper.id.toString();
            formData.append(fieldName + "_id" + brackets, id);
        }
        return formData;
    };
    Uploader.prototype._addFile = function (file, path) {
        if (path === void 0) { path = ""; }
        var fileWrapper = {
            id: (0, core_1.uid)(),
            file: file,
            progress: 0,
            status: types_1.FileStatus.queue,
            src: null,
            path: path,
        };
        this.data.add(fileWrapper);
    };
    Uploader.prototype._traverseFileTree = function (item) {
        var _this = this;
        return new Promise(function (res) {
            var count = 0;
            var readDirectory = function (reader, path) {
                count++;
                reader.readEntries(function (entries) {
                    count--;
                    for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
                        var entry = entries_1[_i];
                        // eslint-disable-next-line @typescript-eslint/no-use-before-define
                        readEntry(entry, path);
                    }
                    if (count === 0) {
                        res();
                    }
                });
            };
            var readEntry = function (entry, path) {
                if (entry.isFile) {
                    count++;
                    entry.file(function (file) {
                        count--;
                        _this._addFile(file, path);
                        if (count === 0) {
                            res();
                        }
                    });
                }
                else if (entry.isDirectory) {
                    var reader = entry.createReader();
                    readDirectory(reader, path + entry.name + "/");
                }
            };
            readEntry(item, "");
        });
    };
    return Uploader;
}());
exports.Uploader = Uploader;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(18)))

/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataCollection = void 0;
var events_1 = __webpack_require__(3);
var loader_1 = __webpack_require__(134);
var sort_1 = __webpack_require__(136);
var dataproxy_1 = __webpack_require__(28);
var helpers_1 = __webpack_require__(21);
var types_1 = __webpack_require__(25);
var core_1 = __webpack_require__(1);
var group_1 = __webpack_require__(137);
var CsvDriver_1 = __webpack_require__(45);
var XMLDriver_1 = __webpack_require__(67);
var DataCollection = /** @class */ (function () {
    function DataCollection(config, events) {
        var _this = this;
        this._filters = {};
        this._sortingStates = [];
        this._changes = { order: [] };
        this.config = config || {};
        this._group = new group_1.Group();
        this._sort = new sort_1.Sort();
        this._loader = new loader_1.Loader(this, this._changes);
        this.events = events || new events_1.EventSystem(this);
        this.events.on(types_1.DataEvents.dataRequest, function (from, to) {
            var proxy = _this.dataProxy;
            if (proxy && proxy.updateUrl) {
                proxy.updateUrl(null, { from: from, limit: proxy.config.limit || to - from });
                _this.load(proxy);
            }
        });
        this.events.on(types_1.DataEvents.loadError, function (response) {
            setTimeout(function () {
                if (typeof response !== "string") {
                    (0, helpers_1.dhxError)(response);
                }
                else {
                    (0, helpers_1.dhxWarning)(response);
                }
            }, 0);
        });
        this._reset();
    }
    DataCollection.prototype._reset = function (config) {
        if (config === void 0) { config = {}; }
        if (!config.grouping)
            this.ungroup();
        this._order = [];
        this._pull = {};
        this._changes = { order: [] };
        this._initFilterOrder = this._initSortOrder = null;
        this._meta = new WeakMap();
        this._loaded = false;
    };
    DataCollection.prototype.group = function (order, config) {
        if (config === void 0) { config = {}; }
        if (!order) {
            (0, helpers_1.dhxError)("The group method has mandatory arguments");
        }
        if (!Array.isArray(order)) {
            (0, helpers_1.dhxError)("The group method expects an array as an argument");
        }
        if (!order.length) {
            (0, helpers_1.dhxError)("The array with the group method values cannot be empty");
        }
        if (this.isGrouped())
            this.ungroup();
        var groupConfig = this._group.getGroupConfig(config);
        if (!this.events.fire(types_1.DataEvents.beforeGroup, [groupConfig])) {
            return;
        }
        this._parse(this._group.group(order, (config === null || config === void 0 ? void 0 : config.data) || this._order, config), types_1.DataDriver.json, true);
        this.events.fire(types_1.DataEvents.afterGroup, [this._group.getGroupedFields(), groupConfig]);
    };
    DataCollection.prototype.ungroup = function () {
        if (!this.isGrouped()) {
            return;
        }
        var grouped = this._group.getGroupedFields();
        var groupConfig = this._group.getGroupConfig();
        if (!this.events.fire(types_1.DataEvents.beforeUnGroup, [grouped, groupConfig])) {
            return;
        }
        this._parse(this._group.ungroup(this._order));
        this.events.fire(types_1.DataEvents.afterUnGroup, [grouped, groupConfig]);
    };
    DataCollection.prototype.isGrouped = function () {
        return this._group.isGrouped();
    };
    DataCollection.prototype.add = function (newItem, index) {
        var _this = this;
        var out;
        if (Array.isArray(newItem)) {
            out = newItem.map(function (element, key) {
                if (key !== 0 && index >= 0) {
                    index = index + 1;
                }
                return _this._add({
                    newItem: (0, core_1.copy)(element),
                    batch: newItem,
                    index: index,
                    order: key,
                });
            });
        }
        else {
            out = this._add({
                newItem: (0, core_1.copy)(newItem),
                batch: [newItem],
                index: index,
            });
        }
        this._reapplyFilters();
        return out;
    };
    DataCollection.prototype.remove = function (id) {
        var _this = this;
        if (id instanceof Array) {
            __spreadArray([], id, true).forEach(function (elementId, index) {
                _this._remove(elementId, id, index);
            });
        }
        else if ((0, core_1.isId)(id)) {
            this._remove(id, [id]);
        }
    };
    DataCollection.prototype.removeAll = function () {
        this._reset();
        this.events.fire(types_1.DataEvents.removeAll);
        this.events.fire(types_1.DataEvents.change);
    };
    DataCollection.prototype.exists = function (id) {
        return !!this._pull[id];
    };
    DataCollection.prototype.getNearId = function (id) {
        var _a;
        var item = this._pull[id];
        if (!item) {
            return ((_a = this._order[0]) === null || _a === void 0 ? void 0 : _a.id) || "";
        }
    };
    DataCollection.prototype.getItem = function (id) {
        return this._pull[id];
    };
    DataCollection.prototype.update = function (id, newItem, silent) {
        var item = this.getItem(id);
        if (item) {
            if ((0, helpers_1.isEqualObj)(newItem, item)) {
                return;
            }
            if ((0, core_1.isId)(newItem.id) && id !== newItem.id) {
                (0, helpers_1.dhxWarning)("this method doesn't allow changing the id");
                if ((0, helpers_1.isDebug)()) {
                    // eslint-disable-next-line no-debugger
                    debugger;
                }
            }
            else {
                if (newItem.parent && item.parent && newItem.parent !== item.parent) {
                    this.move(id, -1, this, newItem.parent);
                }
                (0, core_1.extend)(this._pull[id], newItem, false);
                if (this.config.update) {
                    this.config.update(this._pull[id]);
                }
                if (!silent) {
                    this._onChange("update", id, this._pull[id]);
                }
            }
            this._reapplyFilters();
        }
        else {
            (0, helpers_1.dhxWarning)("item not found");
        }
    };
    DataCollection.prototype.getIndex = function (id) {
        if (!(0, core_1.isId)(id) || !(0, core_1.isDefined)(this._pull[id])) {
            return -1;
        }
        return this._order.findIndex(function (i) { return (i === null || i === void 0 ? void 0 : i.id) == id; });
    };
    DataCollection.prototype.getId = function (index) {
        if (!this._order[index]) {
            return;
        }
        return this._order[index].id;
    };
    DataCollection.prototype.getLength = function () {
        return this._order.length;
    };
    DataCollection.prototype.isDataLoaded = function (from, to) {
        if (from === void 0) { from = 0; }
        if (to === void 0) { to = this._order.length; }
        if ((0, core_1.isNumeric)(from) && (0, core_1.isNumeric)(to)) {
            return this._order.slice(from, to).filter(function (item) { return item && item.$empty; }).length === 0;
        }
        // if check succeeds once, collection can't go back to not-loaded state
        if (!this._loaded) {
            this._loaded = !this.find(function (item) { return item.$empty; });
        }
        return !!this._loaded;
    };
    DataCollection.prototype.filter = function (rule, config, silent) {
        var _a;
        if (config === null || config === void 0 ? void 0 : config.$restore) {
            rule = this._normalizeFilters(rule || this._filters);
        }
        if (!(config === null || config === void 0 ? void 0 : config.add)) {
            this._order = this._initFilterOrder || this._order;
            this._initFilterOrder = null;
            if (!(config === null || config === void 0 ? void 0 : config.$restore)) {
                for (var key in this._filters) {
                    var filter = this._filters[key];
                    if ((_a = filter.config) === null || _a === void 0 ? void 0 : _a.permanent) {
                        this._applyFilters(filter.rule);
                    }
                    else {
                        delete this._filters[key];
                    }
                }
            }
        }
        var id;
        if (rule && !(config === null || config === void 0 ? void 0 : config.$restore)) {
            id = (config === null || config === void 0 ? void 0 : config.id) || (0, core_1.uid)();
            this._filters[id] = { rule: rule, config: config || {} };
        }
        if (rule && typeof rule !== "function") {
            if ((0, core_1.isDefined)(rule.by)) {
                this._applyFilters(rule);
            }
            else {
                for (var key in rule) {
                    this._applyFilters(rule[key]);
                }
            }
        }
        else {
            this._applyFilters(rule);
        }
        if (!silent) {
            var filters = this._getPureFilters(this._filters);
            this.events.fire(types_1.DataEvents.filter, [(0, core_1.isEmptyObj)(filters) ? null : filters]);
        }
        return id;
    };
    DataCollection.prototype.resetFilter = function (config, silent) {
        var _a;
        var _b = config || {}, id = _b.id, permanent = _b.permanent;
        if ((0, core_1.isEmptyObj)(config)) {
            for (var key in this._filters) {
                if (!((_a = this._filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent)) {
                    delete this._filters[key];
                }
            }
        }
        else if (permanent) {
            this._filters = {};
        }
        else if (id) {
            delete this._filters[id];
        }
        this.filter(null, { $restore: true }, silent);
        return (0, core_1.isEmptyObj)(this._getPureFilters(this._filters));
    };
    DataCollection.prototype.getFilters = function (config) {
        var filters = this.getRawFilters(config);
        var pureFilters = filters ? this._getPureFilters(filters) : {};
        return (0, core_1.isEmptyObj)(pureFilters) ? null : pureFilters;
    };
    DataCollection.prototype.getRawFilters = function (config) {
        var filters = this._filters;
        if (config === null || config === void 0 ? void 0 : config.permanent) {
            filters = Object.keys(filters).reduce(function (obj, key) {
                var _a;
                if ((_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.permanent) {
                    obj[key] = filters[key];
                }
                return obj;
            }, {});
        }
        return (0, core_1.isEmptyObj)(filters) ? null : filters;
    };
    DataCollection.prototype.find = function (conf) {
        var data = this._initFilterOrder || this._order;
        for (var i = 0; i < data.length; i++) {
            var res = (0, helpers_1.findByConf)(data[i], conf, i, data);
            if (res) {
                return res;
            }
        }
        return null;
    };
    DataCollection.prototype.findAll = function (conf) {
        var data = this._initFilterOrder || this._order;
        var res = [];
        for (var i = 0; i < data.length; i++) {
            var item = (0, helpers_1.findByConf)(data[i], conf, i, data);
            if (item) {
                res.push(item);
            }
        }
        return res;
    };
    DataCollection.prototype.sort = function (rule, config, ignore) {
        var _a, _b;
        if (ignore === void 0) { ignore = false; }
        if (!this.isDataLoaded()) {
            (0, helpers_1.dhxWarning)("the method doesn't work with lazyLoad");
            return;
        }
        if (config === null || config === void 0 ? void 0 : config.smartSorting) {
            this._sorter = rule;
        }
        if (!ignore &&
            (!this._sortingStates.length ||
                (config === null || config === void 0 ? void 0 : config.smartSorting) ||
                (!((_a = this._sortingStates[0]) === null || _a === void 0 ? void 0 : _a.smartSorting) && !(config === null || config === void 0 ? void 0 : config.smartSorting)))) {
            this._sortingStates = [__assign(__assign({}, rule), config)];
        }
        if (rule) {
            if (!ignore) {
                this._initSortOrder = this._initSortOrder || __spreadArray([], (this._initFilterOrder || this._order), true);
                if (!(config === null || config === void 0 ? void 0 : config.smartSorting) && ((_b = this._sortingStates[0]) === null || _b === void 0 ? void 0 : _b.smartSorting)) {
                    var sortIndex = this._sortingStates.findIndex(function (i) { return i.by == rule.by; });
                    if (sortIndex !== -1) {
                        this._sortingStates[sortIndex].dir = rule.dir;
                    }
                    else {
                        this._sortingStates.push(rule);
                    }
                }
            }
            this._applySorters();
        }
        else if (this._initSortOrder) {
            this._sortingStates = [];
            this._order = this._initSortOrder;
            this._sorter = this._initSortOrder = null;
            if (this._initFilterOrder) {
                this._initFilterOrder = null;
                this.filter(null, { $restore: true }, true);
            }
        }
        if (!ignore) {
            this.events.fire(types_1.DataEvents.change, [undefined, "sort", rule]);
        }
    };
    DataCollection.prototype.getSortingStates = function () {
        return this._sortingStates;
    };
    DataCollection.prototype.copy = function (id, index, target, targetId) {
        var _this = this;
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._copy(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._copy(id, index, target, targetId);
        }
    };
    DataCollection.prototype.move = function (id, index, target, targetId, newId) {
        var _this = this;
        var _a;
        if (id instanceof Array) {
            var movedIds_1 = [];
            id.forEach(function (elementId, key) {
                if ((0, core_1.isId)(_this._move(elementId, index, target, targetId, key))) {
                    movedIds_1.push(elementId);
                }
                else {
                    (0, helpers_1.throwMoveWarning)(elementId, _this.exists(elementId));
                }
            });
            return movedIds_1;
        }
        else {
            return (_a = this._move(id, index, target, targetId, 0, newId)) !== null && _a !== void 0 ? _a : (0, helpers_1.throwMoveWarning)(id, this.exists(id));
        }
    };
    DataCollection.prototype.forEach = function (callback) {
        for (var i = 0; i < this._order.length; i++) {
            callback.call(this, this._order[i], i, this._order);
        }
    };
    DataCollection.prototype.load = function (url, driver) {
        if (typeof url === "string") {
            this.dataProxy = url = new dataproxy_1.DataProxy(url);
        }
        if (typeof driver === "string") {
            driver = driver.toLocaleLowerCase();
        }
        if (driver === "xml" ||
            driver === "csv" ||
            driver instanceof XMLDriver_1.XMLDriver ||
            driver instanceof CsvDriver_1.CsvDriver) {
            url.config.responseType = url.config.responseType || "text";
        }
        this.dataProxy = url;
        return this._loader.load(url, driver);
    };
    DataCollection.prototype.parse = function (data, driver) {
        return this._parse(data, driver);
    };
    DataCollection.prototype.$parse = function (data) {
        var apx = this.config.approximate;
        if (apx) {
            data = this._approximate(data, apx.value, apx.maxNum);
        }
        this._parse_data(data);
        this._reapplyFilters();
        this.events.fire(types_1.DataEvents.change, [undefined, "load"]);
        this.events.fire(types_1.DataEvents.load);
    };
    DataCollection.prototype.save = function (url) {
        if (typeof url === "string") {
            url = new dataproxy_1.DataProxy(url);
        }
        this._loader.save(url);
    };
    DataCollection.prototype.changeId = function (id, newId, silent) {
        if (newId === void 0) { newId = (0, core_1.uid)(); }
        if (id == newId)
            return;
        if (this.exists(newId)) {
            (0, helpers_1.dhxWarning)("item with ID ".concat(newId, " already exists"));
            return;
        }
        var item = this.getItem(id);
        if (!item) {
            (0, helpers_1.dhxWarning)("item not found");
        }
        else {
            item.id = newId;
            (0, core_1.extend)(this._pull[id], item);
            this._pull[newId] = this._pull[id];
            if (!silent) {
                this._onChange("update", newId, this._pull[newId]);
            }
            delete this._pull[id];
        }
    };
    // todo: loop through the array and check saved statuses
    DataCollection.prototype.isSaved = function () {
        return !this._changes.order.length; // todo: bad solution, errors and holded elments are missed...
    };
    DataCollection.prototype.map = function (callback) {
        var result = [];
        for (var i = 0; i < this._order.length; i++) {
            result.push(callback.call(this, this._order[i], i, this._order));
        }
        return result;
    };
    DataCollection.prototype.mapRange = function (from, to, callback) {
        if (from < 0)
            from = 0;
        if (to > this._order.length - 1)
            to = this._order.length - 1;
        var arr = this._order.slice(from, to + 1);
        var result = [];
        for (var i = from; i <= to; i++) {
            result.push(callback.call(this, this._order[i], i, arr));
        }
        return result;
    };
    DataCollection.prototype.reduce = function (callback, acc) {
        for (var i = 0; i < this._order.length; i++) {
            acc = callback.call(this, acc, this._order[i], i);
        }
        return acc;
    };
    DataCollection.prototype.serialize = function (driver) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        // remove $ attrs
        var data = [];
        var _loop_1 = function (index) {
            var item = __assign({}, this_1._order[index]);
            Object.keys(item).forEach(function (key) {
                if (key.startsWith("$")) {
                    delete item[key];
                }
            });
            if (!(0, core_1.isDefined)(item.parent))
                delete item.parent;
            data.push(item);
        };
        var this_1 = this;
        for (var index = 0; index < this._order.length; index++) {
            _loop_1(index);
        }
        var dataDriver = (0, helpers_1.toDataDriver)(driver);
        if (dataDriver) {
            return dataDriver.serialize(data);
        }
    };
    DataCollection.prototype.getInitialData = function () {
        return this._initFilterOrder;
    };
    DataCollection.prototype.setMeta = function (obj, key, value) {
        if (!obj)
            return;
        var map = this._meta.get(obj);
        if (!map) {
            map = {};
            this._meta.set(obj, map);
        }
        map[key] = value;
    };
    DataCollection.prototype.getMeta = function (obj, key) {
        var map = this._meta.get(obj);
        return map ? map[key] : null;
    };
    DataCollection.prototype.getMetaMap = function (obj) {
        return this._meta.get(obj);
    };
    DataCollection.prototype.setRange = function (from, to) {
        this._range = !to ? null : [from, to];
    };
    DataCollection.prototype.getRawData = function (from, to, order, mode) {
        order = order || this._order;
        if (mode === 1)
            return order;
        if (this._range) {
            from = this._range[0] + from;
            if (to === -1) {
                to = this._range[1];
            }
            else {
                var diff = Math.abs(to - from);
                to = from + diff > this._range[1] ? this._range[1] : from + diff;
            }
        }
        if (!to || (from === 0 && (to === -1 || to === order.length))) {
            return order;
        }
        if (from >= order.length)
            return [];
        if (to === -1 || to > order.length)
            to = order.length;
        var slice = order.slice(from, to);
        if (slice.filter(function (item) { return item.$empty; }).length !== 0) {
            this.events.fire(types_1.DataEvents.dataRequest, [from, to]);
        }
        return slice;
    };
    DataCollection.prototype._add = function (_a) {
        var newItem = _a.newItem, index = _a.index, _b = _a.order, order = _b === void 0 ? 0 : _b, batch = _a.batch;
        if (!this.events.fire(types_1.DataEvents.beforeAdd, [newItem, batch, order])) {
            return;
        }
        var id = this._addCore(newItem, index);
        this._onChange("add", newItem.id, newItem);
        this.events.fire(types_1.DataEvents.afterAdd, [newItem, batch, order]);
        return id;
    };
    DataCollection.prototype._remove = function (id, batch, index) {
        var _this = this;
        if (index === void 0) { index = 0; }
        var removedItem = this._pull[id];
        if (!removedItem)
            return;
        var removedItems = batch.map(function (i) { return _this._pull[i]; });
        if (!this.events.fire(types_1.DataEvents.beforeRemove, [removedItem, removedItems, index])) {
            return;
        }
        this._removeCore(removedItem.id);
        this._onChange("remove", id, removedItem);
        this.events.fire(types_1.DataEvents.afterRemove, [removedItem, removedItems, index]);
    };
    DataCollection.prototype._copy = function (id, index, target, targetId, key) {
        if (!this.exists(id)) {
            return null;
        }
        var newid = (0, core_1.uid)();
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target) {
            if (!(target instanceof DataCollection) && targetId) {
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                return;
            }
            if (target.exists(id)) {
                target.add(__assign(__assign({}, (0, helpers_1.copyWithoutInner)(this.getItem(id))), { id: newid }), index);
                return newid;
            }
            else {
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                return id;
            }
        }
        this.add(__assign(__assign({}, (0, helpers_1.copyWithoutInner)(this.getItem(id))), { id: newid }), index);
        return newid;
    };
    DataCollection.prototype._move = function (id, index, target, targetId, key, newId) {
        if (!this.exists(id)) {
            return null;
        }
        if (key && index < this.getIndex(id)) {
            index = index === -1 ? -1 : index + key;
        }
        if (target && target !== this && this.exists(id)) {
            var item = (0, core_1.copy)(this.getItem(id), true);
            if (newId)
                item.id = newId;
            if ((!newId && target.exists(id)) || target.exists(newId)) {
                item.id = (0, core_1.uid)();
            }
            if (targetId) {
                item.parent = targetId;
            }
            target.add(item, index);
            // remove data from original collection
            this.remove(id);
            return item.id;
        }
        if (this.getIndex(id) === index) {
            return null;
        }
        // move other elements
        var spliced = this._order.splice(this.getIndex(id), 1)[0];
        if (index === -1) {
            index = this._order.length;
        }
        this._order.splice(index, 0, spliced);
        this.events.fire(types_1.DataEvents.change, [id, "update", this.getItem(id)]);
        return id;
    };
    DataCollection.prototype._addCore = function (obj, index) {
        var _a;
        if (this.config.init) {
            obj = this.config.init(obj);
        }
        obj.id = (_a = obj.id) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
        if (this._pull[obj.id]) {
            (0, helpers_1.dhxError)("Item ".concat(obj.id, " already exist"));
        }
        // todo: not ideal solution
        if (this._initFilterOrder && !(0, helpers_1.isTreeCollection)(this)) {
            this._addToOrder(this._initFilterOrder, obj, index);
        }
        if (this._initSortOrder) {
            this._addToOrder(this._initSortOrder, obj, index);
        }
        this._addToOrder(this._order, obj, index);
        return obj.id;
    };
    DataCollection.prototype._removeCore = function (id) {
        if (this._pull[id]) {
            this._order = this._order.filter(function (el) { return el.id !== id; });
            if (this._initFilterOrder && this._initFilterOrder.length) {
                this._initFilterOrder = this._initFilterOrder.filter(function (el) { return el.id !== id; });
            }
            if (this._initSortOrder && this._initSortOrder.length) {
                this._initSortOrder = this._initSortOrder.filter(function (el) { return el.id !== id; });
            }
            delete this._pull[id];
        }
    };
    DataCollection.prototype._parse_data = function (data) {
        var index = this._order.length;
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var obj = data_1[_i];
            this._addCore(obj, index++);
        }
    };
    DataCollection.prototype._approximate = function (data, values, maxNum) {
        var len = data.length;
        var vlen = values.length;
        var rlen = Math.floor(len / maxNum);
        var newData = Array(Math.ceil(len / rlen));
        var index = 0;
        for (var i = 0; i < len; i += rlen) {
            var newItem = (0, core_1.copy)(data[i]);
            var end = Math.min(len, i + rlen);
            for (var j = 0; j < vlen; j++) {
                var sum = 0;
                for (var z = i; z < end; z++) {
                    sum += data[z][values[j]];
                }
                newItem[values[j]] = sum / (end - i);
            }
            newData[index++] = newItem;
        }
        return newData;
    };
    DataCollection.prototype._onChange = function (status, id, obj) {
        var itemCount = 0;
        var maxStack = 10;
        for (var _i = 0, _a = this._changes.order; _i < _a.length; _i++) {
            var item = _a[_i];
            // update pending item if previous state is "saving" or if item not saved yet
            var index = this._changes.order.indexOf(item);
            if (item.id === id && !item.saving) {
                itemCount += 1;
                if (index === this._changes.order.length - 1 || this._changes.order[index + 1].id !== id) {
                    // update item
                    if (item.error) {
                        item.error = false;
                    }
                    item = __assign(__assign({}, item), { obj: obj, status: status });
                    itemCount += 1;
                    if (itemCount > maxStack) {
                        this._changes.order.splice(index, itemCount - maxStack, item);
                    }
                    else {
                        this._changes.order.splice(index + 1, 0, item);
                    }
                    this._loader.updateChanges(this._changes);
                    if (status === "remove" && obj.$emptyRow)
                        return;
                    this.events.fire(types_1.DataEvents.change, [id, status, obj]);
                    return;
                }
            }
        }
        this._changes.order.push({ id: id, status: status, obj: __assign({}, obj), saving: false });
        this._loader.updateChanges(this._changes);
        this.events.fire(types_1.DataEvents.change, [id, status, obj]);
    };
    DataCollection.prototype._addToOrder = function (array, obj, index) {
        if (index >= 0 && array[index]) {
            this._pull[obj.id] = obj;
            array.splice(index, 0, obj);
        }
        else {
            this._pull[obj.id] = obj;
            array.push(obj);
        }
    };
    DataCollection.prototype._applySorters = function () {
        if (this._sortingStates.length > 0) {
            this._order = this._sort.sort(this._order, this._sortingStates);
            if (this._initFilterOrder && this._initFilterOrder.length) {
                this._sort.sort(this._initFilterOrder, this._sortingStates);
            }
        }
    };
    DataCollection.prototype._applyFilters = function (rule) {
        if (!rule)
            return;
        if (!this._checkFilterRule(rule)) {
            throw new Error("Invalid filter rule");
        }
        var filter = typeof rule !== "function" ? this._getRuleCallback(rule) : rule;
        var fOrder = this._order.filter(function (item) { return filter(item); });
        if (!this._initFilterOrder) {
            this._initFilterOrder = this._order;
        }
        this._order = fOrder;
    };
    DataCollection.prototype._reapplyFilters = function () {
        var permFilters = this.getFilters({ permanent: true });
        if (permFilters) {
            this.filter(permFilters, { $restore: true, add: true }, true);
        }
        if (this._sorter) {
            this._applySorters();
        }
    };
    DataCollection.prototype._getRuleCallback = function (rule) {
        if (!(0, core_1.isDefined)(rule.by) || !(0, core_1.isDefined)(rule.match))
            return;
        return rule.compare
            ? function (obj) { return rule.compare(obj[rule.by], rule.match, obj, rule.multi); }
            : function (obj) { return obj[rule.by] == rule.match; };
    };
    DataCollection.prototype._getPureFilters = function (filters) {
        return Object.keys(filters).reduce(function (obj, key) {
            var _a;
            if (!((_a = filters[key].config) === null || _a === void 0 ? void 0 : _a.$local)) {
                obj[key] = filters[key];
            }
            return obj;
        }, {});
    };
    DataCollection.prototype._normalizeFilters = function (filters) {
        var rules = [];
        for (var key in filters) {
            var rule = filters[key].rule;
            if (typeof rule !== "function") {
                if ((0, core_1.isDefined)(rule.by)) {
                    rules.push(this._getRuleCallback(rule));
                }
                else {
                    for (var key_1 in rule) {
                        rules.push(this._getRuleCallback(rule[key_1]));
                    }
                }
            }
            else {
                rules.push(rule);
            }
        }
        return __assign({}, rules);
    };
    DataCollection.prototype._checkFilterRule = function (rule) {
        return typeof rule === "function" || ((0, core_1.isDefined)(rule.by) && (0, core_1.isDefined)(rule.match));
    };
    DataCollection.prototype._parse = function (data, driver, grouping) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        if (grouping === void 0) { grouping = false; }
        this._reset({ grouping: grouping });
        return this._loader.parse(data, driver);
    };
    return DataCollection;
}());
exports.DataCollection = DataCollection;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dataDriversPro = exports.dataDrivers = void 0;
var JsonDriver_1 = __webpack_require__(66);
var CsvDriver_1 = __webpack_require__(45);
var XMLDriver_1 = __webpack_require__(67);
exports.dataDrivers = {
    json: JsonDriver_1.JsonDriver,
    csv: CsvDriver_1.CsvDriver,
};
exports.dataDriversPro = __assign(__assign({}, exports.dataDrivers), { xml: XMLDriver_1.XMLDriver });


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonDriver = void 0;
var JsonDriver = /** @class */ (function () {
    function JsonDriver() {
    }
    JsonDriver.prototype.toJsonArray = function (data) {
        return this.getRows(data);
    };
    JsonDriver.prototype.serialize = function (data) {
        return data;
    };
    JsonDriver.prototype.getFields = function (row) {
        return row;
    };
    JsonDriver.prototype.getRows = function (data) {
        return typeof data === "string" ? JSON.parse(data) : data;
    };
    return JsonDriver;
}());
exports.JsonDriver = JsonDriver;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.XMLDriver = void 0;
var xml_1 = __webpack_require__(135);
var ARRAY_NAME = "items";
var ITEM_NAME = "item";
// convert xml tag to js object, all subtags and attributes are mapped to the properties of result object
function tagToObject(tag, initialObj) {
    initialObj = initialObj || {};
    // map attributes
    var a = tag.attributes;
    if (a && a.length) {
        for (var i = 0; i < a.length; i++) {
            initialObj[a[i].name] = a[i].value;
        }
    }
    // map subtags
    var b = tag.childNodes;
    for (var i = 0; i < b.length; i++) {
        var node = b[i];
        if (node.nodeType === node.ELEMENT_NODE) {
            var name_1 = node.tagName;
            if (initialObj[name_1]) {
                if (typeof initialObj[name_1].push !== "function") {
                    initialObj[name_1] = [initialObj[name_1]];
                }
                initialObj[name_1].push(tagToObject(node, {}));
            }
            else {
                initialObj[name_1] = tagToObject(node, {}); // sub-object for complex subtags
            }
        }
    }
    return initialObj;
}
var XMLDriver = /** @class */ (function () {
    function XMLDriver() {
    }
    XMLDriver.prototype.toJsonArray = function (data) {
        return this.getRows(data);
    };
    XMLDriver.prototype.toJsonObject = function (data) {
        var doc;
        if (typeof data === "string") {
            doc = this._fromString(data);
        }
        return tagToObject(doc);
    };
    XMLDriver.prototype.serialize = function (data) {
        return (0, xml_1.jsonToXML)(data);
    };
    XMLDriver.prototype.getFields = function (row) {
        return row;
    };
    XMLDriver.prototype.getRows = function (data) {
        if (typeof data === "string") {
            data = this._fromString(data);
        }
        if (data) {
            var childNodes = data.childNodes && data.childNodes[0] && data.childNodes[0].childNodes;
            if (!childNodes || !childNodes.length) {
                return null;
            }
            return this._getRows(childNodes);
        }
        return [];
    };
    XMLDriver.prototype._getRows = function (nodes) {
        var result = [];
        for (var i = 0; i < nodes.length; i++) {
            if (nodes[i].tagName === ITEM_NAME) {
                result.push(this._nodeToJS(nodes[i]));
            }
        }
        return result;
    };
    XMLDriver.prototype._fromString = function (data) {
        try {
            return new DOMParser().parseFromString(data, "text/xml");
        }
        catch (_a) {
            return null;
        }
    };
    XMLDriver.prototype._nodeToJS = function (node) {
        var result = {};
        if (this._haveAttrs(node)) {
            var attrs = node.attributes;
            for (var i = 0; i < attrs.length; i++) {
                var _a = attrs[i], name_2 = _a.name, value = _a.value;
                result[name_2] = this._toType(value);
            }
        }
        if (node.nodeType === node.TEXT_NODE) {
            result.value = result.value || this._toType(node.textContent);
            return result;
        }
        var childNodes = node.childNodes;
        if (childNodes) {
            for (var i = 0; i < childNodes.length; i++) {
                var subNode = childNodes[i];
                var tag = subNode.tagName;
                if (!tag) {
                    continue;
                }
                if (tag === ARRAY_NAME && subNode.childNodes) {
                    result[tag] = this._getRows(subNode.childNodes);
                }
                else {
                    if (this._haveAttrs(subNode)) {
                        result[tag] = this._nodeToJS(subNode);
                    }
                    else {
                        result[tag] = this._toType(subNode.textContent);
                    }
                }
            }
        }
        return result;
    };
    XMLDriver.prototype._toType = function (val) {
        if (val === "false" || val === "true") {
            return val === "true";
        }
        return val;
    };
    XMLDriver.prototype._haveAttrs = function (node) {
        return node.attributes && node.attributes.length;
    };
    return XMLDriver;
}());
exports.XMLDriver = XMLDriver;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.methods = void 0;
var core_1 = __webpack_require__(1);
exports.methods = {
    sum: function (items, field) {
        return parseFloat(items.reduce(function (sum, item) { return sum + (+item[field] || 0); }, 0).toFixed(12));
    },
    avg: function (items, field) {
        return parseFloat((items.reduce(function (sum, item) { return sum + (+item[field] || 0); }, 0) / items.length).toFixed(12));
    },
    count: function (items, field) {
        if (items === void 0) { items = []; }
        return items.filter(function (item) { return (0, core_1.isDefined)(item[field]) && item[field] !== ""; }).length;
    },
    min: function (items, field) {
        return Math.min.apply(Math, items.map(function (item) { return +item[field]; }));
    },
    max: function (items, field) {
        return Math.max.apply(Math, items.map(function (item) { return +item[field]; }));
    },
};


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeCollection = exports.addToOrder = void 0;
var core_1 = __webpack_require__(1);
var datacollection_1 = __webpack_require__(64);
var dataproxy_1 = __webpack_require__(28);
var helpers_1 = __webpack_require__(21);
var types_1 = __webpack_require__(25);
function addToOrder(store, obj, parent, index) {
    if (index !== undefined && index !== -1 && store[parent] && store[parent][index]) {
        store[parent].splice(index, 0, obj);
    }
    else {
        if (!store[parent]) {
            store[parent] = [];
        }
        store[parent].push(obj);
    }
}
exports.addToOrder = addToOrder;
var TreeCollection = /** @class */ (function (_super) {
    __extends(TreeCollection, _super);
    function TreeCollection(config, events) {
        var _a;
        var _this = _super.call(this, config, events) || this;
        _this._children = {};
        var root = (_this._root = (config && config.rootId) || "_ROOT_" + (0, core_1.uid)());
        _this._children = (_a = {}, _a[root] = [], _a);
        _this._initChildren = null;
        return _this;
    }
    TreeCollection.prototype.add = function (newItem, index, parent) {
        var _this = this;
        if (index === void 0) { index = -1; }
        if (parent === void 0) { parent = this._root; }
        var out;
        if (Array.isArray(newItem)) {
            out = newItem.map(function (element, key) {
                return _this._add({
                    newItem: element,
                    batch: newItem,
                    index: index,
                    parent: parent,
                    order: key,
                });
            });
        }
        else {
            out = this._add({
                newItem: newItem,
                batch: [newItem],
                index: index,
                parent: parent,
            });
        }
        this._reapplyFilters();
        return out;
    };
    TreeCollection.prototype.getRoot = function () {
        return this._root;
    };
    TreeCollection.prototype.getParent = function (id, asObj) {
        if (asObj === void 0) { asObj = false; }
        if (!this._pull[id]) {
            return null;
        }
        var parent = this._pull[id].parent;
        return asObj ? this._pull[parent] : parent;
    };
    TreeCollection.prototype.getItems = function (id) {
        if (this._children && this._children[id]) {
            return this._children[id];
        }
        return [];
    };
    TreeCollection.prototype.getLength = function (id) {
        if (id === void 0) { id = this._root; }
        if (!this._children[id]) {
            return null;
        }
        return this._children[id].length;
    };
    TreeCollection.prototype.removeAll = function (id) {
        var _a;
        if (!(0, core_1.isId)(id)) {
            _super.prototype.removeAll.call(this);
            var root = this._root;
            this._initChildren = null;
            this._children = (_a = {}, _a[root] = [], _a);
        }
        else if (this._children[id]) {
            var children = __spreadArray([], this._children[id], true);
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                this.remove(child.id);
            }
        }
    };
    TreeCollection.prototype.update = function (id, newItem, silent) {
        var parent = newItem.parent;
        if ((0, core_1.isDefined)(parent) && !this.exists(parent) && parent !== this._root) {
            (0, helpers_1.dhxWarning)("Item parent doesn't exist");
            return;
        }
        _super.prototype.update.call(this, id, newItem, silent);
    };
    TreeCollection.prototype.getIndex = function (id) {
        var parent = this.getParent(id);
        if (!parent || !this._children[parent]) {
            return -1;
        }
        return this._children[parent].findIndex(function (i) { return (i === null || i === void 0 ? void 0 : i.id) == id; });
    };
    TreeCollection.prototype.sort = function (rule, config, ignore) {
        var _this = this;
        var _a, _b;
        if (ignore === void 0) { ignore = false; }
        if (config === null || config === void 0 ? void 0 : config.smartSorting) {
            this._sorter = rule;
        }
        if (!ignore &&
            (!this._sortingStates.length ||
                (config === null || config === void 0 ? void 0 : config.smartSorting) ||
                (!((_a = this._sortingStates[0]) === null || _a === void 0 ? void 0 : _a.smartSorting) && !(config === null || config === void 0 ? void 0 : config.smartSorting)))) {
            this._sortingStates = [__assign(__assign({}, rule), config)];
        }
        if (rule) {
            if (!ignore) {
                this._initSortOrder = this._initSortOrder || __spreadArray([], (this._initFilterOrder || this._order), true);
                if (!(config === null || config === void 0 ? void 0 : config.smartSorting) && ((_b = this._sortingStates[0]) === null || _b === void 0 ? void 0 : _b.smartSorting)) {
                    var sortIndex = this._sortingStates.findIndex(function (i) { return i.by == rule.by; });
                    if (sortIndex !== -1) {
                        this._sortingStates[sortIndex].dir = rule.dir;
                    }
                    else {
                        this._sortingStates.push(rule);
                    }
                }
            }
            this._applySorters();
        }
        else if (this._initSortOrder) {
            this._children = {};
            this._order = [];
            this._sortingStates = [];
            this._initSortOrder.forEach(function (item) { return _this._parseItem(item); });
            this._sorter = this._initSortOrder = this._initChildren = null;
            if (this._initFilterOrder) {
                this._initFilterOrder = null;
                this.filter(null, { $restore: true }, true);
            }
        }
        if (!ignore) {
            this._reapplyFilters();
            this.events.fire(types_1.DataEvents.change, [undefined, "sort", rule]);
        }
    };
    TreeCollection.prototype.filter = function (rule, config, silent) {
        if (config === null || config === void 0 ? void 0 : config.$restore) {
            rule = this._normalizeFilters(rule || this._filters);
        }
        if (!rule || !(config === null || config === void 0 ? void 0 : config.add)) {
            if (this._initChildren) {
                this._children = this._initChildren;
                this._initChildren = null;
            }
            if (!(config === null || config === void 0 ? void 0 : config.$restore)) {
                for (var key in this._filters) {
                    var _a = this._filters[key], rule_1 = _a.rule, conf = _a.config;
                    if (conf === null || conf === void 0 ? void 0 : conf.permanent) {
                        this._applyFilter(rule_1, conf);
                    }
                    else {
                        delete this._filters[key];
                    }
                }
            }
        }
        var id;
        if (rule && !(config === null || config === void 0 ? void 0 : config.$restore)) {
            id = (config === null || config === void 0 ? void 0 : config.id) || (0, core_1.uid)();
            if (!config)
                config = {};
            config.type = config.type || types_1.TreeFilterType.all;
            this._filters[id] = { rule: rule, config: config };
            this._applyFilter(rule, config);
        }
        else {
            for (var key in rule) {
                this._applyFilter(rule[key], this._filters[key].config);
            }
        }
        if (!silent) {
            var filters = this._getPureFilters(this._filters);
            this.events.fire(types_1.DataEvents.filter, [(0, core_1.isEmptyObj)(filters) ? null : filters]);
        }
        return id;
    };
    TreeCollection.prototype.restoreOrder = function () {
        this.resetFilter({ permanent: true }, true);
        this.sort();
    };
    TreeCollection.prototype.copy = function (id, index, target, targetId) {
        var _this = this;
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (id instanceof Array) {
            return id.map(function (elementId, key) {
                return _this._copy(elementId, index, target, targetId, key);
            });
        }
        else {
            return this._copy(id, index, target, targetId);
        }
    };
    TreeCollection.prototype.move = function (id, index, target, targetId) {
        var _this = this;
        var _a;
        if (targetId === void 0) { targetId = this._root; }
        target = target || this;
        if (id instanceof Array) {
            var movedIds_1 = [];
            id.forEach(function (elementId, key) {
                if ((0, core_1.isId)(_this._move(elementId, index, target, targetId, key))) {
                    movedIds_1.push(elementId);
                }
                else {
                    (0, helpers_1.throwMoveWarning)(elementId, _this.exists(elementId));
                }
            });
            return movedIds_1;
        }
        else {
            return (_a = this._move(id, index, target, targetId)) !== null && _a !== void 0 ? _a : (0, helpers_1.throwMoveWarning)(id, this.exists(id));
        }
    };
    TreeCollection.prototype.forEach = function (callback, parent, level) {
        if (parent === void 0) { parent = this._root; }
        if (level === void 0) { level = Infinity; }
        if (!this.haveItems(parent) || level < 1) {
            return;
        }
        var array = this._children[parent];
        for (var i = 0; i < array.length; i++) {
            callback.call(this, array[i], i, array);
            if (this.haveItems(array[i].id)) {
                this.forEach(callback, array[i].id, --level);
            }
        }
    };
    TreeCollection.prototype.eachChild = function (id, callback, direct, checkItem) {
        if (direct === void 0) { direct = true; }
        if (checkItem === void 0) { checkItem = function () { return true; }; }
        if (!this.haveItems(id)) {
            return;
        }
        for (var i = 0; i < this._children[id].length; i++) {
            callback.call(this, this._children[id][i], i);
            if (direct && checkItem(this._children[id][i])) {
                this.eachChild(this._children[id][i].id, callback, direct, checkItem);
            }
        }
    };
    TreeCollection.prototype.getNearId = function (id) {
        return id; // for selection
    };
    TreeCollection.prototype.loadItems = function (id, driver) {
        var _this = this;
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        if (!this.events.fire(types_1.DataEvents.beforeItemLoad, [id])) {
            return;
        }
        var urlPart = this.config.autoload.toString();
        var url = urlPart + (urlPart.includes("?") ? "&id=".concat(id) : "?id=".concat(id));
        var proxy = new dataproxy_1.DataProxy(url);
        proxy
            .load()
            .then(function (data) {
            driver = (0, helpers_1.toDataDriver)(driver);
            data = driver.toJsonArray(data);
            _this._parse_data(data, id);
            _this.events.fire(types_1.DataEvents.change);
            _this.events.fire(types_1.DataEvents.afterItemLoad, [id]);
        })
            .catch(function (error) {
            _this.events.fire(types_1.DataEvents.loadError, [error]);
        });
    };
    TreeCollection.prototype.refreshItems = function (id, driver) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        this.removeAll(id);
        this.loadItems(id, driver);
    };
    TreeCollection.prototype.eachParent = function (id, callback, self) {
        if (self === void 0) { self = false; }
        var item = this.getItem(id);
        if (!item) {
            return;
        }
        if (self) {
            callback.call(this, item);
        }
        if (item.parent === this._root) {
            return;
        }
        var parent = this.getItem(item.parent);
        callback.call(this, parent);
        this.eachParent(item.parent, callback);
    };
    TreeCollection.prototype.haveItems = function (id) {
        return id in this._children;
    };
    TreeCollection.prototype.canCopy = function (id, target) {
        if (id === target) {
            return false;
        }
        var canCopy = true;
        this.eachParent(target, function (item) { return (item.id === id ? (canCopy = false) : null); }); // locate return string
        return canCopy;
    };
    TreeCollection.prototype.serialize = function (driver, checkItem) {
        if (driver === void 0) { driver = types_1.DataDriver.json; }
        var data = this._serialize(this._root, checkItem);
        var dataDriver = (0, helpers_1.toDataDriver)(driver);
        if (dataDriver) {
            return dataDriver.serialize(data);
        }
    };
    TreeCollection.prototype.getId = function (index, parent) {
        if (parent === void 0) { parent = this._root; }
        if (!this._children[parent] || !this._children[parent][index]) {
            return;
        }
        return this._children[parent][index].id;
    };
    TreeCollection.prototype.map = function (callback, parent, direct) {
        if (parent === void 0) { parent = this._root; }
        if (direct === void 0) { direct = true; }
        var result = [];
        if (!this.haveItems(parent)) {
            return result;
        }
        for (var i = 0; i < this._children[parent].length; i++) {
            result.push(callback.call(this, this._children[parent][i], i, this._children));
            if (direct) {
                var childResult = this.map(callback, this._children[parent][i].id, direct);
                result = result.concat(childResult);
            }
        }
        return result;
    };
    TreeCollection.prototype.getRawData = function (from, to, order, mode, parent) {
        parent = parent !== null && parent !== void 0 ? parent : this._root;
        var out;
        if (!this._children[parent])
            return [];
        if (parent === this._root)
            out = _super.prototype.getRawData.call(this, from, to, this._children[parent]);
        else
            out = this._children[parent];
        if (mode === 2) {
            return this.flatten(out);
        }
        return out;
    };
    TreeCollection.prototype.flatten = function (input) {
        var _this = this;
        var out = [];
        input.forEach(function (a) {
            out.push(a);
            var kids = _this._children[a.id];
            if (kids && a.$opened) {
                out = out.concat(_this.flatten(kids));
            }
        });
        return out;
    };
    TreeCollection.prototype._add = function (_a) {
        var newItem = _a.newItem, _b = _a.index, index = _b === void 0 ? -1 : _b, _c = _a.parent, parent = _c === void 0 ? this._root : _c, _d = _a.order, order = _d === void 0 ? 0 : _d, batch = _a.batch;
        if (order > 0 && index !== -1) {
            index = index + 1;
        }
        if (!this.events.fire(types_1.DataEvents.beforeAdd, [newItem, batch, order])) {
            return;
        }
        this._setParent(newItem, parent);
        var id = this._addCore(newItem, index);
        this._onChange("add", newItem.id, newItem);
        this.events.fire(types_1.DataEvents.afterAdd, [newItem, batch, order]);
        if (Array.isArray(newItem.items)) {
            for (var _i = 0, _e = newItem.items; _i < _e.length; _i++) {
                var item = _e[_i];
                this.add(item, -1, newItem.id);
            }
        }
        return id;
    };
    TreeCollection.prototype._setParent = function (item, parent) {
        item.parent = item.parent ? item.parent.toString() : parent;
        var parentItem = this._pull[item.parent];
        if (parentItem && !parentItem.items) {
            parentItem.items = [];
        }
    };
    TreeCollection.prototype._copy = function (id, index, target, targetId, key) {
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (!this.exists(id)) {
            return null;
        }
        var currentChildren = this._children[id];
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target === this && !this.canCopy(id, targetId)) {
            return null;
        }
        var itemCopy = (0, helpers_1.copyWithoutInner)(this.getItem(id), { items: true });
        if (target.exists(id)) {
            itemCopy.id = (0, core_1.uid)();
        }
        if (!(0, helpers_1.isTreeCollection)(target)) {
            target.add(itemCopy, index);
            return;
        }
        if (this.exists(id)) {
            itemCopy.parent = targetId;
            if (target !== this && targetId === this._root) {
                itemCopy.parent = target.getRoot();
            }
            target.add(itemCopy, index);
            id = itemCopy.id;
        }
        if (currentChildren) {
            for (var _i = 0, currentChildren_1 = currentChildren; _i < currentChildren_1.length; _i++) {
                var child = currentChildren_1[_i];
                var childId = child.id;
                var childIndex = this.getIndex(childId);
                this.copy(childId, childIndex, target, id);
            }
        }
        return id;
    };
    TreeCollection.prototype._move = function (id, index, target, targetId, key) {
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (!this.exists(id)) {
            return null;
        }
        if (key && index < this.getIndex(id)) {
            index = index === -1 ? -1 : index + key;
        }
        if (target !== this) {
            if (!(0, helpers_1.isTreeCollection)(target)) {
                // move to datacollection
                target.add((0, helpers_1.copyWithoutInner)(this.getItem(id)), index);
                this.remove(id);
                return;
            }
            var returnId = this.copy(id, index, target, targetId);
            this.remove(id);
            return returnId;
        }
        // move inside
        if (!this.canCopy(id, targetId)) {
            return null;
        }
        this._moveItem(id, targetId, index);
        this.events.fire(types_1.DataEvents.change, [id, "update", this.getItem(id)]);
        return id;
    };
    TreeCollection.prototype._moveItem = function (id, targetId, index) {
        var parentId = this.getParent(id);
        var children = this._initChildren || this._children;
        [this._children, this._initChildren].forEach(function (store) {
            if (!store || !store[parentId])
                return;
            var i = store[parentId].findIndex(function (item) { return item.id === id; });
            if (i === -1)
                return;
            var item = store[parentId].splice(i, 1)[0];
            item.parent = targetId;
            addToOrder(store, item, targetId, index);
            if (!store[parentId].length)
                delete store[parentId];
        });
        if (parentId !== this._root && parentId !== targetId) {
            var parent_1 = this.getItem(parentId);
            if (children[parentId]) {
                parent_1.items = __spreadArray([], children[parentId], true);
            }
            else {
                delete parent_1.items;
            }
        }
        if (targetId !== this._root) {
            var target = this.getItem(targetId);
            target.items = __spreadArray([], (children[targetId] || []), true);
        }
    };
    TreeCollection.prototype._reset = function (config) {
        var _a;
        if ((0, core_1.isId)(config === null || config === void 0 ? void 0 : config.id)) {
            var children = __spreadArray([], this._children[config === null || config === void 0 ? void 0 : config.id], true);
            for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
                var child = children_2[_i];
                this.remove(child.id);
            }
        }
        else {
            _super.prototype._reset.call(this, config);
            var root = this._root;
            this._initChildren = null;
            this._children = (_a = {}, _a[root] = [], _a);
        }
    };
    TreeCollection.prototype._removeCore = function (id) {
        var _a;
        if (!this._pull[id]) {
            return;
        }
        var parentId = this.getParent(id);
        this._removeFromParentList(this._children, parentId, id);
        if (this._initChildren) {
            this._removeFromParentList(this._initChildren, parentId, id);
        }
        if ((_a = this._pull[parentId]) === null || _a === void 0 ? void 0 : _a.items) {
            var parent_2 = this._pull[parentId];
            parent_2.items = parent_2.items.filter(function (item) { return item.id !== id; });
        }
        var removedIds = new Set();
        this._removeChildren(this._children, id, removedIds);
        if (this._initChildren) {
            this._removeChildren(this._initChildren, id, removedIds);
        }
        this._removeFromOrders(removedIds);
    };
    TreeCollection.prototype._removeFromParentList = function (target, parentId, childId) {
        if (!target[parentId])
            return;
        target[parentId] = target[parentId].filter(function (item) { return item.id !== childId; });
        if (parentId !== this._root && target[parentId].length === 0) {
            delete target[parentId];
        }
    };
    TreeCollection.prototype._removeChildren = function (target, id, collectedIds) {
        if (this._pull[id]) {
            collectedIds.add(id);
            delete this._pull[id];
        }
        var children = target[id];
        if (children) {
            for (var i = 0; i < children.length; i++) {
                this._removeChildren(target, children[i].id, collectedIds);
            }
            delete target[id];
        }
    };
    TreeCollection.prototype._removeFromOrders = function (removedIds) {
        var _a, _b;
        if (removedIds.size === 0)
            return;
        var filterFn = function (i) { return !removedIds.has(i.id); };
        if (this._order) {
            this._order = this._order.filter(filterFn);
        }
        if ((_a = this._initFilterOrder) === null || _a === void 0 ? void 0 : _a.length) {
            this._initFilterOrder = this._initFilterOrder.filter(filterFn);
        }
        if ((_b = this._initSortOrder) === null || _b === void 0 ? void 0 : _b.length) {
            this._initSortOrder = this._initSortOrder.filter(filterFn);
        }
    };
    TreeCollection.prototype._addToOrder = function (_order, obj, index) {
        var children = this._children;
        var initChildren = this._initChildren;
        var parent = obj.parent;
        this._pull[obj.id] = obj;
        if (obj.parent &&
            this._pull[obj.parent] &&
            this._pull[obj.parent].items &&
            !this._pull[obj.parent].items.find(function (item) { return item.id === obj.id; })) {
            this._pull[obj.parent].items.push(obj);
        }
        _super.prototype._addToOrder.call(this, _order, obj, index);
        addToOrder(children, obj, parent, index);
        if (initChildren) {
            addToOrder(initChildren, obj, parent, index);
        }
    };
    TreeCollection.prototype._parse_data = function (data, parent) {
        var _a, _b, _c;
        if (parent === void 0) { parent = this._root; }
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var obj = data_1[_i];
            if (this.config.init) {
                obj = this.config.init(obj);
            }
            if (obj && typeof obj !== "object") {
                obj = {
                    value: obj,
                };
            }
            obj.id = (_a = obj.id) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
            obj.parent = obj.parent && !((_c = (_b = obj.parent) === null || _b === void 0 ? void 0 : _b.toString()) === null || _c === void 0 ? void 0 : _c.includes("_ROOT_")) ? obj.parent : parent;
            if (this._pull[obj.id]) {
                (0, helpers_1.dhxError)("Item ".concat(obj.id, " already exist"));
            }
            this._parseItem(obj);
            if (obj.items && obj.items instanceof Object) {
                this._parse_data(obj.items, obj.id);
            }
        }
    };
    TreeCollection.prototype._parseItem = function (item) {
        this._pull[item.id] = item;
        this._order[this._order.length] = item;
        if (!this._children[item.parent]) {
            this._children[item.parent] = [];
        }
        this._children[item.parent].push(item);
    };
    TreeCollection.prototype._recursiveFilter = function (rule, config, current, level, newChildren) {
        var _this = this;
        var children = this._children[current];
        if (!children) {
            return;
        }
        var condition = function (item) {
            switch (config.type) {
                case types_1.TreeFilterType.all: {
                    return true;
                }
                case types_1.TreeFilterType.level: {
                    return level === config.level;
                }
                case types_1.TreeFilterType.leafs: {
                    return !_this.haveItems(item.id);
                }
            }
        };
        if (typeof rule === "function") {
            var customRule = function (item) { return condition(item) && rule(item); };
            var filtered = children.filter(customRule);
            if (filtered.length) {
                newChildren[current] = filtered;
            }
            else if (current === this._root) {
                newChildren[current] = [];
            }
        }
        else {
            var customRule = function (item) {
                var _a;
                var responseOfRule = true;
                for (var compare in rule) {
                    if (rule[compare].by && rule[compare].match !== "") {
                        responseOfRule = rule[compare].compare
                            ? rule[compare].compare(item[rule[compare].by], rule[compare].match, item)
                            : ((_a = item[rule[compare].by]) === null || _a === void 0 ? void 0 : _a.toString().toLocaleLowerCase().indexOf(rule[compare].match.toString().toLowerCase())) !== -1;
                    }
                    if (!responseOfRule)
                        break;
                }
                return condition(item) && responseOfRule;
            };
            var filtered = children.filter(customRule);
            if (filtered.length) {
                newChildren[current] = filtered;
            }
            else if (current === this._root) {
                newChildren[current] = [];
            }
        }
        for (var _i = 0, children_3 = children; _i < children_3.length; _i++) {
            var child = children_3[_i];
            this._recursiveFilter(rule, config, child.id, level + 1, newChildren);
        }
    };
    TreeCollection.prototype._serialize = function (parent, fn) {
        var _this = this;
        if (parent === void 0) { parent = this._root; }
        return this.map(function (item) {
            var itemCopy = {};
            for (var key in item) {
                if (key === "parent" || key === "items" || key.startsWith("$")) {
                    continue;
                }
                itemCopy[key] = item[key];
            }
            if (fn) {
                itemCopy = fn(itemCopy);
            }
            if (_this.haveItems(item.id)) {
                itemCopy.items = _this._serialize(item.id, fn);
            }
            return itemCopy;
        }, parent, false);
    };
    TreeCollection.prototype._applyFilter = function (rule, config) {
        var _this = this;
        if (!rule || (typeof rule !== "function" && (0, core_1.isEmptyObj)(rule)))
            return;
        if (!this._checkFilterRule(rule)) {
            throw new Error("Invalid filter rule");
        }
        if (!this._initFilterOrder) {
            this._initFilterOrder = this._order;
        }
        if (!this._initChildren) {
            this._initChildren = this._children;
        }
        var filter;
        var newChildren = {};
        if (typeof rule !== "function") {
            filter = {};
            if ((0, core_1.isDefined)(rule.by)) {
                filter[rule.by] = rule;
            }
            else {
                for (var key in rule) {
                    filter[key] = rule[key];
                }
            }
        }
        else {
            filter = rule;
        }
        this._recursiveFilter(filter, config, this._root, 0, newChildren);
        Object.keys(newChildren).forEach(function (key) {
            var parentId = _this.getParent(key);
            var current = _this.getItem(key);
            while (parentId) {
                if (!newChildren[parentId]) {
                    newChildren[parentId] = [];
                }
                if (current && !newChildren[parentId].find(function (x) { return x.id === current.id; })) {
                    newChildren[parentId].push(current);
                }
                current = _this.getItem(parentId);
                parentId = _this.getParent(parentId);
            }
        });
        this._children = newChildren;
    };
    TreeCollection.prototype._normalizeFilters = function (filters) {
        var rules = {};
        for (var key in filters) {
            rules[key] = filters[key].rule;
        }
        return rules;
    };
    TreeCollection.prototype._checkFilterRule = function (rule) {
        var _this = this;
        return (_super.prototype._checkFilterRule.call(this, rule) ||
            Object.values(rule).every(function (value) { return typeof value !== "function" && _super.prototype._checkFilterRule.call(_this, value); }));
    };
    TreeCollection.prototype._applySorters = function () {
        for (var key in this._children) {
            this._sort.sort(this._children[key], this._sortingStates);
        }
        if (this._initChildren && Object.keys(this._initChildren).length) {
            for (var key in this._initChildren) {
                this._sort.sort(this._initChildren[key], this._sortingStates);
            }
        }
    };
    return TreeCollection;
}(datacollection_1.DataCollection));
exports.TreeCollection = TreeCollection;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cell = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var view_1 = __webpack_require__(9);
var types_1 = __webpack_require__(47);
var helpers_1 = __webpack_require__(143);
var events_1 = __webpack_require__(3);
var Layout_1 = __webpack_require__(46);
var Cell = /** @class */ (function (_super) {
    __extends(Cell, _super);
    function Cell(parent, config) {
        var _this = _super.call(this, parent, config) || this;
        _this._disabled = [];
        var p = parent;
        if (p && p.isVisible) {
            _this._parent = p;
        }
        if (_this._parent && _this._parent.events) {
            _this.events = _this._parent.events;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
        }
        _this.config.full =
            _this.config.full === undefined
                ? Boolean(_this.config.header ||
                    _this.config.collapsable ||
                    _this.config.headerHeight ||
                    _this.config.headerIcon ||
                    _this.config.headerImage)
                : _this.config.full;
        _this._afterWindowResized = _this._resizedWindow.bind(_this);
        _this.id = _this.config.id || (0, core_1.uid)();
        _this._initHandlers();
        _this._progress = !!_this.config.progressDefault;
        _this._stopProgressDefault = false;
        if (_this._isXDirection() && !config.width)
            config.$autoWidth = true;
        if (!_this._isXDirection() && !config.height)
            config.$autoHeight = true;
        return _this;
    }
    Cell.prototype.paint = function () {
        var _a;
        if (this.isVisible()) {
            var view = this.getRootView();
            if (view) {
                view.redraw();
            }
            else {
                (_a = this._parent) === null || _a === void 0 ? void 0 : _a.paint();
            }
        }
    };
    Cell.prototype.isVisible = function () {
        var _a;
        // top level node
        if (!this._parent) {
            if (this._container && this._container.tagName) {
                return true;
            }
            return Boolean(this.getRootNode());
        }
        // check active view in case of multiview
        var active = (_a = this._parent.config) === null || _a === void 0 ? void 0 : _a.activeView;
        if (active && active !== this.id) {
            return false;
        }
        // check that all parents of the cell are visible as well
        return !this.config.hidden && (!this._parent || this._parent.isVisible());
    };
    Cell.prototype.hide = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeHide, [this.id])) {
            return;
        }
        this.config.hidden = true;
        this._resetCellsSize();
        if (this._parent && this._parent.paint) {
            this._parent.paint();
        }
        this.events.fire(types_1.LayoutEvents.afterHide, [this.id]);
    };
    Cell.prototype.show = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeShow, [this.id])) {
            return;
        }
        if (this._parent && this._parent.config && this._parent.config.activeView !== undefined) {
            this._parent.config.activeView = this.id;
        }
        else {
            this.config.hidden = false;
        }
        if (this._parent && !this._parent.isVisible()) {
            this._parent.show();
        }
        this.paint();
        this.events.fire(types_1.LayoutEvents.afterShow, [this.id]);
    };
    Cell.prototype.expand = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeExpand, [this.id])) {
            return;
        }
        this.config.collapsed = false;
        this._checkNextSize() || this._checkNextSize(this._getAnyFlexCell());
        this.events.fire(types_1.LayoutEvents.afterExpand, [this.id]);
        this.paint();
    };
    Cell.prototype.collapse = function () {
        if (!this.events.fire(types_1.LayoutEvents.beforeCollapse, [this.id])) {
            return;
        }
        this.config.collapsed = true;
        this._checkNextSize() || this._checkNextSize(this._getAnyFlexCell());
        this.events.fire(types_1.LayoutEvents.afterCollapse, [this.id]);
        this.paint();
    };
    Cell.prototype.toggle = function () {
        if (this.config.collapsed) {
            this.expand();
        }
        else {
            this.collapse();
        }
    };
    Cell.prototype._checkNextSize = function (cell) {
        var nextCell = cell !== null && cell !== void 0 ? cell : this._getNextCell();
        if (!nextCell)
            return false;
        if (this._isXDirection() && nextCell.config.$autoWidth && nextCell.config.width) {
            nextCell.config.width = undefined;
            return true;
        }
        if (!this._isXDirection() && nextCell.config.$autoHeight && nextCell.config.height) {
            nextCell.config.height = undefined;
            return true;
        }
        return !cell ? nextCell._checkNextSize() : false;
    };
    Cell.prototype.getParent = function () {
        return this._parent;
    };
    Cell.prototype.destructor = function () {
        var _a;
        this.events && this.events.clear();
        window.removeEventListener("resize", this._afterWindowResized);
        if (this._ui && this._ui.config && typeof ((_a = this._ui) === null || _a === void 0 ? void 0 : _a.destructor) === "function") {
            this._ui.destructor();
        }
        this.config = this.events = this.id = this._parent = this._handlers = this._uid = this._disabled = this._resizerHandlers = null;
        this.unmount();
    };
    Cell.prototype.getWidget = function () {
        return this._ui;
    };
    Cell.prototype.getCellView = function () {
        return this._parent && this._parent.getRefs(this._uid);
    };
    Cell.prototype.attach = function (component, config) {
        this.config.html = null;
        if (typeof component === "object") {
            this._ui = component;
        }
        else if (typeof component === "string") {
            this._ui = new window.dhx[component](null, config);
        }
        else if (typeof component === "function") {
            if (component.prototype instanceof view_1.View) {
                this._ui = new component(null, config);
            }
            else {
                this._ui = {
                    getRootView: function () {
                        return component(config);
                    },
                };
            }
        }
        this.paint();
        return this._ui;
    };
    Cell.prototype.attachHTML = function (html) {
        this.config.html = html;
        this.paint();
    };
    Cell.prototype.detach = function () {
        this._stopProgressDefault = false;
        this._ui = this.config.html = null;
        this.paint();
    };
    Cell.prototype.progressShow = function () {
        if (this.config.progressDefault) {
            this._stopProgressDefault = false;
        }
        this._progress = true;
        this.paint();
    };
    Cell.prototype.progressHide = function () {
        if (this.config.progressDefault) {
            this._stopProgressDefault = true;
        }
        this._progress = false;
        this.paint();
    };
    Cell.prototype.isVisibleProgress = function () {
        return this._progress;
    };
    Cell.prototype.toVDOM = function (nodes) {
        var _a;
        var _b, _c;
        this._saveTheme();
        if (this.config === null) {
            this.config = {};
        }
        if (this.config.hidden) {
            return;
        }
        var isFieldset = this.config.$fieldset;
        var style = this._calculateStyle();
        var stylePadding = (0, core_1.isDefined)(this.config.padding)
            ? !isNaN(Number(this.config.padding))
                ? { padding: "".concat(this.config.padding, "px") }
                : { padding: this.config.padding }
            : "";
        var fullStyle = this.config.full || this.config.html ? style : __assign(__assign({}, style), stylePadding);
        var progressBar = this._checkProgress() ? this._getProgressBar() : null;
        var kids;
        if (!this.config.html) {
            if (this._ui) {
                var view = this._ui.getRootView();
                if (view.render) {
                    view = (0, dom_1.inject)(view);
                }
                kids = [view];
            }
            else {
                kids = nodes || null;
            }
        }
        var resizer = this.config.resizable && !this._isLastCell() && this._getNextCell() && !this.config.collapsed
            ? (0, dom_1.el)(".dhx_layout-resizer." +
                (this._isXDirection() ? "dhx_layout-resizer--x" : "dhx_layout-resizer--y"), __assign(__assign({}, this._resizerHandlers), { _ref: "resizer_" + this._uid, tabindex: 0 }), [
                (0, dom_1.el)("span.dhx_layout-resizer__icon", {
                    class: "dxi " +
                        (this._isXDirection() ? "dxi-dots-vertical" : "dxi-dots-horizontal"),
                }),
            ])
            : null;
        var handlers = {};
        if (this.config.on) {
            for (var key in this.config.on) {
                handlers["on" + key] = this.config.on[key];
            }
        }
        var typeClass = "";
        var isParent = this.config.cols || this.config.rows;
        if (this.config.type && isParent) {
            switch (this.config.type) {
                case "line":
                    typeClass = " dhx_layout-line";
                    break;
                case "wide":
                    typeClass = " dhx_layout-wide";
                    break;
                case "space":
                    typeClass = " dhx_layout-space";
                    break;
                default:
                    break;
            }
        }
        var cellContent = isFieldset
            ? (0, dom_1.el)("fieldset.dhx_form-fieldset", {
                class: (this.config.$disabled && " dhx_form-fieldset--disabled") || "",
                style: stylePadding,
                disabled: this.config.$disabled,
            }, [
                (0, dom_1.el)("legend.dhx_form-fieldset-legend", {
                    class: "dhx_form-fieldset-legend--".concat(this.config.labelAlignment || "left"),
                }, this.config.label),
                (0, dom_1.el)(".dhx_layout-cell-content", {
                    class: this._getCss(false),
                }, [].concat(kids)),
            ])
            : this.config.full
                ? [
                    (0, dom_1.el)("div", {
                        tabindex: this.config.collapsable ? "0" : "-1",
                        role: this.config.collapsable ? "button" : null,
                        "aria-label": this.config.collapsable
                            ? "click to ".concat(this.config.collapsed ? "expand" : "collapse")
                            : null,
                        class: "dhx_layout-cell-header" +
                            (this._isXDirection()
                                ? " dhx_layout-cell-header--col"
                                : " dhx_layout-cell-header--row") +
                            (this.config.collapsable ? " dhx_layout-cell-header--collapseble" : "") +
                            (this.config.collapsed ? " dhx_layout-cell-header--collapsed" : "") +
                            (((this.getParent() || {}).config || {}).isAccordion
                                ? " dhx_layout-cell-header--accordion"
                                : ""),
                        style: {
                            height: this.config.headerHeight,
                        },
                        onclick: this._handlers.toggle,
                        onkeydown: this._handlers.enterCollapse,
                    }, [
                        this.config.headerIcon &&
                            (0, dom_1.el)("span.dhx_layout-cell-header__icon", {
                                class: this.config.headerIcon,
                            }),
                        this.config.headerImage &&
                            (0, dom_1.el)(".dhx_layout-cell-header__image-wrapper", [
                                (0, dom_1.el)("img", {
                                    src: this.config.headerImage,
                                    class: "dhx_layout-cell-header__image",
                                }),
                            ]),
                        this.config.header && (0, dom_1.el)("h3.dhx_layout-cell-header__title", this.config.header),
                        this.config.collapsable
                            ? (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: this._getCollapseIcon(),
                            })
                            : (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: "dxi dxi-empty",
                            }),
                    ]),
                    !this.config.collapsed
                        ? (0, dom_1.el)("div", {
                            style: __assign(__assign({}, stylePadding), { height: "calc(100% - ".concat(this.config.headerHeight || 37, "px)") }),
                            class: this._getCss(true) +
                                " dhx_layout-cell-content" +
                                (this.config.type ? typeClass : ""),
                        }, this.config.html
                            ? [
                                (0, dom_1.el)("div", {
                                    ".innerHTML": this.config.html,
                                    class: "dhx_layout-cell dhx_layout-cell-inner_html",
                                }),
                            ]
                            : kids)
                        : null,
                ]
                : this.config.html &&
                    !(this.config.rows &&
                        this.config.cols &&
                        this.config.views)
                    ? [
                        !this.config.collapsed
                            ? (0, dom_1.el)(".dhx_layout-cell-content", { style: stylePadding }, [
                                (0, dom_1.el)(".dhx_layout-cell-inner_html", {
                                    ".innerHTML": this.config.html,
                                }),
                            ])
                            : null,
                    ]
                    : kids;
        var cell = (0, dom_1.el)("div", __assign(__assign((_a = { _key: this.config.id || this._uid, _ref: this._uid }, _a["aria-label"] = this.config.id ? "tab-content-" + this.config.id : null, _a["data-cell-id"] = (_b = this.config.id) !== null && _b !== void 0 ? _b : null, _a["data-dhx-theme"] = (_c = this._theme) !== null && _c !== void 0 ? _c : null, _a), handlers), { class: this._getCss(false) +
                (this.config.css ? " " + this.config.css : "") +
                (this.config.collapsed ? " dhx_layout-cell--collapsed" : "") +
                (this.config.resizable ? " dhx_layout-cell--resizable" : "") +
                (this.config.type && !this.config.full ? typeClass : ""), style: isFieldset ? style : fullStyle }), cellContent || progressBar ? [].concat(cellContent, progressBar) : null);
        return resizer ? [].concat(cell, resizer) : cell;
    };
    Cell.prototype._saveTheme = function () {
        var _a;
        var cellEl = (_a = this.getCellView()) === null || _a === void 0 ? void 0 : _a.el;
        if (cellEl) {
            this._theme = cellEl.getAttribute("data-dhx-theme");
        }
    };
    Cell.prototype._getProgressBar = function () {
        return (0, dom_1.el)("span", {
            class: "dhx_progress-bar",
        }, [
            (0, dom_1.sv)("svg", {
                viewBox: "25 25 50 50",
                class: "dhx_spinner",
            }, [
                (0, dom_1.sv)("circle", {
                    cx: "50",
                    cy: "50",
                    r: "20",
                    class: "path",
                }),
            ]),
        ]);
    };
    Cell.prototype._getCss = function (_content) {
        return "dhx_layout-cell";
    };
    Cell.prototype._initHandlers = function () {
        var _this = this;
        if (this.getParent() &&
            !(this.config.cols || this.config.rows)) {
            window.addEventListener("resize", this._afterWindowResized);
        }
        this._handlers = {
            enterCollapse: function (e) {
                if (e.keyCode === 13) {
                    _this._handlers.toggle();
                }
            },
            collapse: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.collapse();
            },
            expand: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.expand();
            },
            toggle: function () {
                if (!_this.config.collapsable) {
                    return;
                }
                _this.toggle();
            },
        };
        var blockOpts = {
            left: null,
            top: null,
            isActive: false,
            range: null,
            xLayout: null,
            nextCell: null,
            size: null,
            resizerLength: null,
            margin: null,
            collapsedSize: null,
        };
        var resizeMove = function (event, startCoords) {
            if (startCoords === void 0) { startCoords = { x: 0, y: 0 }; }
            if (!blockOpts.isActive) {
                return;
            }
            var xLayout = blockOpts.xLayout;
            var clientX = event.targetTouches
                ? event.targetTouches[0].clientX
                : event.clientX + startCoords.x;
            var clientY = event.targetTouches
                ? event.targetTouches[0].clientY
                : event.clientY + startCoords.y;
            var newValue = xLayout
                ? clientX - blockOpts.range.min + window.pageXOffset
                : clientY - blockOpts.range.min + window.pageYOffset;
            var prop = xLayout ? "width" : "height";
            if (newValue < 0) {
                newValue = blockOpts.resizerLength / 2;
            }
            else if (newValue > blockOpts.size) {
                newValue = blockOpts.size - blockOpts.resizerLength;
            }
            var getValue = function (key) { var _a; return parseInt((_a = _this.config[key]) === null || _a === void 0 ? void 0 : _a.toString()); };
            var maxSize = getValue(xLayout ? "maxWidth" : "maxHeight");
            var minSize = getValue(xLayout ? "minWidth" : "minHeight");
            if ((!maxSize || newValue < maxSize) && (!minSize || newValue > minSize)) {
                _this.config[prop] = newValue - blockOpts.resizerLength / 2 + "px";
                blockOpts.nextCell.config[prop] =
                    blockOpts.size - newValue - blockOpts.resizerLength / 2 + "px";
                if (blockOpts.nextCell._getAnyFlexCell())
                    blockOpts.nextCell._getAnyFlexCell().config[prop] = undefined;
                _this.paint();
                _this.events.fire(types_1.LayoutEvents.resize, [_this.id]);
            }
        };
        var iframesInfo = {};
        var resizeEnd = function (event) {
            blockOpts.isActive = false;
            document.body.classList.remove("dhx_no-select--resize");
            if (!event.targetTouches) {
                document.removeEventListener("mouseup", resizeEnd);
                document.removeEventListener("mousemove", resizeMove);
                for (var index in iframesInfo) {
                    iframesInfo[index].node.contentWindow.document.removeEventListener("mouseup", resizeEnd);
                    iframesInfo[index].node.contentWindow.document.removeEventListener("mousemove", iframesInfo[index].listener);
                }
            }
            else {
                document.removeEventListener("touchend", resizeEnd);
                document.removeEventListener("touchmove", resizeMove);
                for (var index in iframesInfo) {
                    iframesInfo[index].node.contentWindow.document.removeEventListener("touchend", resizeEnd);
                    iframesInfo[index].node.contentWindow.document.removeEventListener("touchmove", iframesInfo[index].listener);
                }
            }
            _this.events.fire(types_1.LayoutEvents.afterResizeEnd, [_this.id]);
        };
        var resizeStart = function (event) {
            event.targetTouches && event.preventDefault();
            if (event.which === 3) {
                return;
            }
            if (blockOpts.isActive) {
                resizeEnd(event);
            }
            if (!_this.events.fire(types_1.LayoutEvents.beforeResizeStart, [_this.id])) {
                return;
            }
            document.body.classList.add("dhx_no-select--resize");
            var block = _this.getCellView();
            var nextCell = _this._getNextCell();
            var nextBlock = nextCell.getCellView();
            var resizerBlock = _this._getResizerView();
            var blockOffsets = block.el.getBoundingClientRect();
            var resizerOffsets = resizerBlock.el.getBoundingClientRect();
            var nextBlockOffsets = nextBlock.el.getBoundingClientRect();
            blockOpts.xLayout = _this._isXDirection();
            blockOpts.left = blockOffsets.left + window.pageXOffset;
            blockOpts.top = blockOffsets.top + window.pageYOffset;
            blockOpts.collapsedSize = _this._getCollapsedSize(_this, nextCell);
            blockOpts.margin = (0, helpers_1.getMarginSize)(_this.getParent().config);
            blockOpts.range = (0, helpers_1.getBlockRange)(blockOffsets, nextBlockOffsets, blockOpts.xLayout);
            blockOpts.size =
                blockOpts.range.max - blockOpts.range.min - blockOpts.margin - blockOpts.collapsedSize;
            blockOpts.isActive = true;
            blockOpts.nextCell = nextCell;
            blockOpts.resizerLength = blockOpts.xLayout ? resizerOffsets.width : resizerOffsets.height;
        };
        this._resizerHandlers = {
            onmousedown: function (e) {
                resizeStart(e);
                document.addEventListener("mouseup", resizeEnd);
                document.addEventListener("mousemove", resizeMove);
                var iframes = document.querySelectorAll("iframe");
                if (iframes.length) {
                    iframes.forEach(function (iframe, index) {
                        var iframeCoords = {
                            x: iframe.getBoundingClientRect().x,
                            y: iframe.getBoundingClientRect().y,
                        };
                        iframesInfo[index] = {
                            node: iframe,
                            listener: function (event) { return resizeMove(event, iframeCoords); },
                        };
                    });
                    for (var index in iframesInfo) {
                        iframesInfo[index].node.contentWindow.document.addEventListener("mouseup", resizeEnd);
                        iframesInfo[index].node.contentWindow.document.addEventListener("mousemove", iframesInfo[index].listener);
                    }
                }
            },
            ontouchstart: function (e) {
                resizeStart(e);
                document.addEventListener("touchend", resizeEnd);
                document.addEventListener("touchmove", resizeMove);
                var iframes = document.querySelectorAll("iframe");
                if (iframes.length) {
                    iframes.forEach(function (iframe, index) {
                        var iframeCoords = {
                            x: iframe.getBoundingClientRect().x,
                            y: iframe.getBoundingClientRect().y,
                        };
                        iframesInfo[index] = {
                            node: iframe,
                            listener: function (event) { return resizeMove(event, iframeCoords); },
                        };
                    });
                    for (var index in iframesInfo) {
                        iframesInfo[index].node.contentWindow.document.addEventListener("touchend", resizeEnd);
                        iframesInfo[index].node.contentWindow.document.addEventListener("touchmove", iframesInfo[index].listener);
                    }
                }
            },
            ondragstart: function (e) { return e.preventDefault(); },
        };
    };
    Cell.prototype._getCollapsedSize = function (cell, nextCell) {
        var collapsedSize = 0;
        var parent = this._parent;
        var index = parent._cells.indexOf(cell);
        var nextIndex = parent._cells.indexOf(nextCell);
        if (nextIndex - index === 1)
            return collapsedSize;
        for (var i = index + 1; i < nextIndex; i++) {
            if (parent._cells[i].config.collapsed) {
                if (!this._isXDirection()) {
                    collapsedSize += Number(parent._cells[i].config.headerHeight) || 37;
                }
                else {
                    collapsedSize += 45;
                }
            }
        }
        return collapsedSize;
    };
    Cell.prototype._getCollapseIcon = function () {
        if (this._isXDirection() && this.config.collapsed) {
            return "dxi dxi-chevron-right";
        }
        if (this._isXDirection() && !this.config.collapsed) {
            return "dxi dxi-chevron-left";
        }
        if (!this._isXDirection() && this.config.collapsed) {
            return "dxi dxi-chevron-up";
        }
        if (!this._isXDirection() && !this.config.collapsed) {
            return "dxi dxi-chevron-down";
        }
    };
    Cell.prototype._isLastCell = function () {
        var parent = this._parent;
        return !parent || parent._cells.indexOf(this) === parent._cells.length - 1;
    };
    Cell.prototype._getNextCell = function () {
        if (this._isLastCell())
            return;
        var parent = this._parent;
        var index = parent._cells.indexOf(this);
        var nextCell = parent._cells[index + 1];
        if (nextCell.config.hidden || nextCell.config.collapsed) {
            return nextCell._getNextCell();
        }
        else
            return nextCell;
    };
    Cell.prototype._getAnyFlexCell = function (selfInclude) {
        var _this = this;
        var _a;
        if (selfInclude === void 0) { selfInclude = false; }
        var parent = this._parent;
        var prop = this._isXDirection() ? "$autoWidth" : "$autoHeight";
        var cells = (_a = parent === null || parent === void 0 ? void 0 : parent._cells) === null || _a === void 0 ? void 0 : _a.filter(function (cell) { return cell.config[prop] === true && (selfInclude ? true : cell.id !== _this.id); });
        return (cells === null || cells === void 0 ? void 0 : cells.length) ? cells[cells.length - 1] : false;
    };
    Cell.prototype._getResizerView = function () {
        return this._parent.getRefs("resizer_" + this._uid);
    };
    Cell.prototype._isXDirection = function () {
        return this._parent && this._parent._xLayout;
    };
    Cell.prototype._checkProgress = function () {
        if (this instanceof Layout_1.Layout) {
            return this.isVisibleProgress();
        }
        this._calculateProgressState();
        return ((this._progress || this._checkAutoProgress()) &&
            !this.config.collapsed &&
            !this.config.hidden &&
            !this._parent.isVisibleProgress());
    };
    Cell.prototype._checkAutoProgress = function () {
        if (this._stopProgressDefault)
            return false;
        var _a = this.config, html = _a.html, progressDefault = _a.progressDefault;
        return progressDefault && !this._ui && !html;
    };
    Cell.prototype._calculateProgressState = function () {
        if (this._stopProgressDefault)
            return;
        var _a = this.config, html = _a.html, progressDefault = _a.progressDefault;
        if (progressDefault && !this._ui && !html) {
            this._progress = true;
        }
        if (progressDefault && (this._ui || html)) {
            this._progress = false;
        }
    };
    Cell.prototype._calculateStyle = function () {
        var config = this.config;
        if (!config) {
            return;
        }
        var style = {};
        var autoWidth = false;
        var autoHeight = false;
        if (!isNaN(Number(config.width)))
            config.width = config.width + "px";
        if (!isNaN(Number(config.height)))
            config.height = config.height + "px";
        if (!isNaN(Number(config.minWidth)))
            config.minWidth = config.minWidth + "px";
        if (!isNaN(Number(config.minHeight)))
            config.minHeight = config.minHeight + "px";
        if (!isNaN(Number(config.maxWidth)))
            config.maxWidth = config.maxWidth + "px";
        if (!isNaN(Number(config.maxHeight)))
            config.maxHeight = config.maxHeight + "px";
        if (config.width === "content")
            autoWidth = true;
        if (config.height === "content")
            autoHeight = true;
        // if (this._isXDirection() && !config.width) config.$autoWidth = true;
        // if (!this._isXDirection() && !config.height) config.$autoHeight = true;
        var _a = config, width = _a.width, height = _a.height, cols = _a.cols, rows = _a.rows, minWidth = _a.minWidth, minHeight = _a.minHeight, maxWidth = _a.maxWidth, maxHeight = _a.maxHeight, gravity = _a.gravity, collapsed = _a.collapsed, $fixed = _a.$fixed;
        var gravityNumber = Math.sign(gravity) === -1 ? 0 : gravity;
        if (typeof gravity === "boolean") {
            gravityNumber = gravity ? 1 : 0;
        }
        var fixed = typeof gravity === "boolean" ? !gravity : Math.sign(gravity) === -1;
        if (this._isXDirection()) {
            if ($fixed || width || (gravity === undefined && (minWidth || maxWidth))) {
                fixed = true;
            }
        }
        else {
            if ($fixed || height || (gravity === undefined && (minHeight || maxHeight))) {
                fixed = true;
            }
        }
        var isFullSizeCell = this._checkFullSizeCell();
        var grow = fixed && !isFullSizeCell ? 0 : isFullSizeCell ? 1 : gravityNumber || 1;
        var fillSpace = this._isXDirection() ? "x" : "y";
        if (minWidth !== undefined && !collapsed)
            style.minWidth = minWidth;
        if (minHeight !== undefined && !collapsed)
            style.minHeight = minHeight;
        if (maxWidth !== undefined)
            style.maxWidth = maxWidth;
        if (maxHeight !== undefined)
            style.maxHeight = maxHeight;
        if (this._parent === undefined && !fillSpace !== undefined) {
            fillSpace = true;
        }
        if (!isFullSizeCell && width !== undefined && width !== "content") {
            style.width = width;
        }
        else {
            if (fillSpace === true) {
                style.width = "100%";
            }
            else if (fillSpace === "x") {
                if (autoWidth) {
                    style.flex = "0 0 auto";
                }
                else {
                    var isAuto = this._isXDirection() ? "1px" : "auto";
                    style.flex = "".concat(grow, " ").concat(cols || rows ? "0 ".concat(isAuto) : "1 auto");
                }
            }
        }
        if (!isFullSizeCell && height !== undefined && height !== "content") {
            style.height = height;
        }
        else {
            if (fillSpace === true) {
                style.height = "100%";
            }
            else if (fillSpace === "y") {
                if (autoHeight) {
                    style.flex = "0 0 auto";
                }
                else {
                    var isAuto = !this._isXDirection() ? "1px" : "auto";
                    style.flex = "".concat(grow, " ").concat(cols || rows ? "0 ".concat(isAuto) : "1 auto");
                }
            }
        }
        if (fillSpace === true && config.width === undefined && config.height === undefined) {
            style.flex = "".concat(grow, " 1 auto");
        }
        if (collapsed) {
            if (this._isXDirection()) {
                style.width = "auto";
            }
            else {
                style.height = "auto";
            }
            style.flex = "0 0 auto";
        }
        return style;
    };
    Cell.prototype._resizedWindow = function () {
        var _a;
        if (this._isLastFlexCell === undefined) {
            this._isLastFlexCell = ((_a = this._getAnyFlexCell(true)) === null || _a === void 0 ? void 0 : _a.id) === this.id;
        }
        else if (!this._isLastFlexCell) {
            window.removeEventListener("resize", this._afterWindowResized);
        }
        if (this._isLastFlexCell) {
            var prop = this._isXDirection() ? "width" : "height";
            this.config[prop] = undefined;
            this.paint();
        }
    };
    Cell.prototype._resetCellsSize = function () {
        var _this = this;
        var cells = this._parent._cells.filter(function (cell) {
            return cell !== _this && !cell.config.hidden && !cell.config.collapsed;
        });
        var direction = this._isXDirection();
        var autoSize = direction ? "$autoWidth" : "$autoHeight";
        var size = direction ? "width" : "height";
        cells.forEach(function (cell) {
            if (cell.config[autoSize]) {
                cell.config[size] = undefined;
            }
        });
    };
    Cell.prototype._checkFullSizeCell = function () {
        var _this = this;
        if (!this._parent)
            return false;
        var autoSize = this._isXDirection() ? "$autoWidth" : "$autoHeight";
        if (!this.config[autoSize])
            return false;
        var cells = this._parent._cells.filter(function (cell) {
            return cell !== _this && !cell.config.hidden;
        });
        return !!cells.length && cells.every(function (cell) { return cell.config.collapsed; });
    };
    return Cell;
}(view_1.View));
exports.Cell = Cell;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProCell = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var ScrollView_1 = __webpack_require__(22);
var Cell_1 = __webpack_require__(70);
var ProCell = /** @class */ (function (_super) {
    __extends(ProCell, _super);
    function ProCell(parent, config) {
        var _this = _super.call(this, parent, config) || this;
        _this.scrollView = new ScrollView_1.ScrollView(function () {
            return _this._getFirstRootView();
        });
        if (!parent) {
            var view = (0, dom_1.create)({ render: function () { return _this.toVDOM(); } }, _this);
            _this.mount(parent, view);
        }
        return _this;
    }
    ProCell.prototype._getFirstRootView = function (self) {
        if (self === void 0) { self = this; }
        return self.getParent() && self.getParent().getRootView()
            ? self.getParent().getRootView()
            : this._getFirstRootView(self.getParent());
    };
    ProCell.prototype.toVDOM = function (nodes) {
        var _a;
        var _b, _c;
        this._saveTheme();
        if (this.config === null) {
            this.config = {};
        }
        if (this.config.hidden) {
            return;
        }
        var isFieldset = this.config.$fieldset;
        var style = this._calculateStyle();
        var stylePadding = (0, core_1.isDefined)(this.config.padding)
            ? !isNaN(Number(this.config.padding))
                ? { padding: "".concat(this.config.padding, "px") }
                : { padding: this.config.padding }
            : "";
        var fullStyle = this.config.full || this.config.html ? style : __assign(__assign({}, style), stylePadding);
        var progressBar = this._checkProgress() ? this._getProgressBar() : null;
        var kids;
        if (!this.config.html) {
            if (this._ui) {
                var view = this._ui.getRootView();
                if (view.render) {
                    view = (0, dom_1.inject)(view);
                }
                // kids = [view];
                kids = view ? [this.scrollView.render(view)] : view || null;
            }
            else {
                // kids = nodes || null;
                kids = nodes ? this.scrollView.render([nodes]) : nodes || null;
            }
        }
        var resizer = this.config.resizable && !this._isLastCell() && this._getNextCell() && !this.config.collapsed
            ? (0, dom_1.el)(".dhx_layout-resizer." +
                (this._isXDirection() ? "dhx_layout-resizer--x" : "dhx_layout-resizer--y"), __assign(__assign({}, this._resizerHandlers), { _ref: "resizer_" + this._uid }), [
                (0, dom_1.el)("span.dhx_layout-resizer__icon", {
                    class: "dxi " +
                        (this._isXDirection() ? "dxi-dots-vertical" : "dxi-dots-horizontal"),
                }),
            ])
            : null;
        var handlers = {};
        if (this.config.on) {
            for (var key in this.config.on) {
                handlers["on" + key] = this.config.on[key];
            }
        }
        var typeClass = "";
        var isParent = this.config.cols || this.config.rows;
        if (this.config.type && isParent) {
            switch (this.config.type) {
                case "line":
                    typeClass = " dhx_layout-line";
                    break;
                case "wide":
                    typeClass = " dhx_layout-wide";
                    break;
                case "space":
                    typeClass = " dhx_layout-space";
                    break;
                default:
                    break;
            }
        }
        var htmlContent = (0, dom_1.el)(".dhx_layout-cell-content", {
            _key: "".concat(this._uid, "_html"),
            style: stylePadding,
        }, [
            (0, dom_1.el)(".dhx_layout-cell-inner_html", {
                ".innerHTML": this.config.html,
            }),
        ]);
        var cellContent = isFieldset
            ? (0, dom_1.el)("fieldset.dhx_form-fieldset", {
                class: (this.config.$disabled && " dhx_form-fieldset--disabled") || "",
                style: stylePadding,
                disabled: this.config.$disabled,
            }, [
                (0, dom_1.el)("legend.dhx_form-fieldset-legend", {
                    class: "dhx_form-fieldset-legend--".concat(this.config.labelAlignment || "left"),
                }, this.config.label),
                (0, dom_1.el)(".dhx_layout-cell-content", {
                    class: this._getCss(false),
                }, [].concat(kids)),
            ])
            : this.config.full
                ? [
                    (0, dom_1.el)("div", {
                        tabindex: this.config.collapsable ? "0" : "-1",
                        class: "dhx_layout-cell-header" +
                            (this._isXDirection()
                                ? " dhx_layout-cell-header--col"
                                : " dhx_layout-cell-header--row") +
                            (this.config.collapsable ? " dhx_layout-cell-header--collapseble" : "") +
                            (this.config.collapsed ? " dhx_layout-cell-header--collapsed" : "") +
                            (((this.getParent() || {}).config || {}).isAccordion
                                ? " dhx_layout-cell-header--accordion"
                                : ""),
                        style: {
                            height: this.config.headerHeight,
                        },
                        onclick: this._handlers.toggle,
                        onkeydown: this._handlers.enterCollapse,
                    }, [
                        this.config.headerIcon &&
                            (0, dom_1.el)("span.dhx_layout-cell-header__icon", {
                                class: this.config.headerIcon,
                            }),
                        this.config.headerImage &&
                            (0, dom_1.el)(".dhx_layout-cell-header__image-wrapper", [
                                (0, dom_1.el)("img", {
                                    src: this.config.headerImage,
                                    class: "dhx_layout-cell-header__image",
                                }),
                            ]),
                        this.config.header && (0, dom_1.el)("h3.dhx_layout-cell-header__title", this.config.header),
                        this.config.collapsable
                            ? (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: this._getCollapseIcon(),
                            })
                            : (0, dom_1.el)("div.dhx_layout-cell-header__collapse-icon", {
                                class: "dxi dxi-empty",
                            }),
                    ]),
                    !this.config.collapsed
                        ? (0, dom_1.el)("div", {
                            style: __assign(__assign({}, stylePadding), { height: "calc(100% - ".concat(this.config.headerHeight || 37, "px)") }),
                            class: this._getCss(true) +
                                " dhx_layout-cell-content" +
                                (this.config.type ? typeClass : ""),
                        }, this.config.html
                            ? [
                                (0, dom_1.el)("div", {
                                    ".innerHTML": this.config.html,
                                    class: "dhx_layout-cell dhx_layout-cell-inner_html",
                                }),
                            ]
                            : kids)
                        : null,
                ]
                : this.config.html &&
                    !(this.config.rows &&
                        this.config.cols &&
                        this.config.views)
                    ? [
                        !this.config.collapsed
                            ? this.scrollView && this.scrollView.config.enable && this.getParent()
                                ? this.scrollView.render([htmlContent], this._uid)
                                : htmlContent
                            : null,
                    ]
                    : kids;
        var cell = (0, dom_1.el)("div", __assign(__assign((_a = { _key: this.config.id || this._uid, _ref: this._uid }, _a["aria-label"] = this.config.id ? "tab-content-" + this.config.id : null, _a["data-cell-id"] = (_b = this.config.id) !== null && _b !== void 0 ? _b : null, _a["data-dhx-theme"] = (_c = this._theme) !== null && _c !== void 0 ? _c : null, _a), handlers), { class: this._getCss(false) +
                (this.config.css ? " " + this.config.css : "") +
                (this.config.collapsed ? " dhx_layout-cell--collapsed" : "") +
                (this.config.resizable ? " dhx_layout-cell--resizable" : "") +
                (this.config.type && !this.config.full ? typeClass : ""), style: isFieldset ? style : fullStyle }), cellContent || progressBar ? [].concat(cellContent, progressBar) : null);
        return resizer ? [].concat(cell, resizer) : cell;
    };
    return ProCell;
}(Cell_1.Cell));
exports.ProCell = ProCell;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.blockScreen = void 0;
function blockKeys(e) {
    var active = document.activeElement;
    if (active.classList.contains("dhx_alert__apply-button") && e.key === "Enter") {
        return;
    }
    if (!active.classList.contains("dhx_alert__confirm-reject") &&
        !active.classList.contains("dhx_alert__confirm-aply")) {
        e.preventDefault();
    }
}
function blockScreen(css) {
    var blocker = document.createElement("div");
    blocker.className = "dhx_alert__overlay " + (css || "");
    document.body.appendChild(blocker);
    document.addEventListener("keydown", blockKeys);
    return function () {
        document.body.removeChild(blocker);
        document.removeEventListener("keydown", blockKeys);
    };
}
exports.blockScreen = blockScreen;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.disableTooltip = exports.enableTooltip = exports.tooltip = exports.getZIndex = exports.findPosition = void 0;
var html_1 = __webpack_require__(2);
var types_1 = __webpack_require__(48);
var DEFAULT_SHOW_DELAY = 750;
var DEFAULT_HIDE_DELAY = 200;
function findPosition(targetRect, position, width, height, margin, recursion) {
    if (margin === void 0) { margin = 8; }
    if (recursion === void 0) { recursion = 0; }
    var pos;
    var left;
    var top;
    if (recursion > 1) {
        position = types_1.Position.center;
    }
    if (position !== "top" && position !== "bottom") {
        var topOffset = targetRect.top + (targetRect.height - height) / 2;
        var isShift = topOffset < 0 && window.pageYOffset + topOffset + height < scrollY + window.innerHeight;
        top = window.pageYOffset + (isShift ? 0 : topOffset);
    }
    switch (position) {
        case types_1.Position.center:
            left = targetRect.left + window.pageXOffset + (targetRect.width - width) / 2;
            if (left + margin < window.pageXOffset) {
                left = targetRect.left + window.pageXOffset;
            }
            pos = types_1.RealPosition.center;
            return { left: left, top: top, pos: pos };
        case types_1.Position.right:
            pos = types_1.RealPosition.right;
            left = targetRect.right + window.pageXOffset + margin;
            if (left + width > window.innerWidth + window.pageXOffset) {
                // // set left
                return findPosition(targetRect, types_1.Position.left, width, height, margin, ++recursion);
            }
            return { left: left, top: top, pos: pos };
        case types_1.Position.left:
            pos = types_1.RealPosition.left;
            left = window.pageXOffset + targetRect.left - width - margin;
            if (left < 0) {
                // // set right
                return findPosition(targetRect, types_1.Position.right, width, height, margin, ++recursion);
            }
            return { left: left, top: top, pos: pos };
        case types_1.Position.top:
            pos = types_1.RealPosition.top;
            left = window.pageXOffset + targetRect.left + (targetRect.width - width) / 2;
            if (left + width > window.innerWidth + window.pageXOffset) {
                left = window.innerWidth + window.pageXOffset - width;
            }
            else if (left < 0) {
                left = 0;
            }
            if (targetRect.top < height) {
                // // set bottom
                return findPosition(targetRect, types_1.Position.bottom, width, height, margin, ++recursion);
            }
            top = window.pageYOffset + targetRect.top - height - margin;
            return { left: left, top: top, pos: pos };
        case types_1.Position.bottom:
        default:
            left = window.pageXOffset + targetRect.left + (targetRect.width - width) / 2;
            if (left + width > window.innerWidth + window.pageXOffset) {
                left = window.innerWidth + window.pageXOffset - width;
            }
            else if (left < 0) {
                left = 0;
            }
            pos = types_1.RealPosition.bottom;
            top = window.pageYOffset + targetRect.bottom + margin;
            if (top + height > window.innerHeight + window.pageYOffset) {
                // // set top
                return findPosition(targetRect, types_1.Position.top, width, height, margin, ++recursion);
            }
            return { left: left, top: top, pos: pos };
    }
}
exports.findPosition = findPosition;
// tooltip init
var tooltipBox = document.createElement("div");
var tooltipText = document.createElement("span");
tooltipText.className = "dhx_tooltip__text";
tooltipBox.appendChild(tooltipText);
tooltipBox.setAttribute("role", "tooltip");
tooltipBox.style.position = "absolute";
var lastNode = null;
var isActive = false;
var hideTimeout = null;
var showTimeout = null;
var activeListenersDestructor;
function getZIndex(node) {
    if (node &&
        ((node.classList.contains("dhx_popup--window") &&
            node.classList.contains("dhx_popup--window_active")) ||
            node.classList.contains("dhx_popup--window_modal") ||
            node.classList.contains("dhx_popup"))) {
        return 10000000;
    }
    if (node === null || node === void 0 ? void 0 : node.classList.contains("dhx_popup--window")) {
        return 9999999;
    }
    if (node && node.offsetParent) {
        return getZIndex(node.offsetParent);
    }
    return null;
}
exports.getZIndex = getZIndex;
function showTooltip(node, text, position, css, force, margin, htmlEnable) {
    if (css === void 0) { css = ""; }
    if (force === void 0) { force = false; }
    if (margin === void 0) { margin = 8; }
    var rects = node.getBoundingClientRect();
    if (htmlEnable) {
        tooltipText.innerHTML = text;
    }
    else {
        tooltipText.textContent = text;
    }
    tooltipBox.style.left = null;
    tooltipBox.style.top = null;
    document.body.appendChild(tooltipBox);
    tooltipBox.className = "dhx_widget dhx_tooltip ".concat(force ? " dhx_tooltip--forced" : "", " ").concat(css);
    var _a = tooltipBox.getBoundingClientRect(), width = _a.width, height = _a.height;
    var _b = findPosition(rects, position, width, height, margin), left = _b.left, top = _b.top, pos = _b.pos;
    var zIndex = getZIndex(node);
    if (zIndex) {
        tooltipBox.style.zIndex = zIndex.toString();
    }
    switch (pos) {
        case types_1.RealPosition.bottom:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.top:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.left:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.right:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
        case types_1.RealPosition.center:
            tooltipBox.style.left = left + "px";
            tooltipBox.style.top = top + "px";
            break;
    }
    tooltipBox.className += " dhx_tooltip--".concat(pos);
    isActive = true;
    if (!force) {
        setTimeout(function () {
            tooltipBox.className += " dhx_tooltip--animate";
        });
    }
}
function hideTooltip(delay) {
    if (lastNode) {
        hideTimeout = setTimeout(function () {
            document.body.removeChild(tooltipBox);
            isActive = false;
            hideTimeout = null;
        }, delay || DEFAULT_HIDE_DELAY);
    }
}
function addListeners(node, text, config) {
    var force = config.force, showDelay = config.showDelay, hideDelay = config.hideDelay, position = config.position, css = config.css, htmlEnable = config.htmlEnable, margin = config.margin;
    if (!force) {
        showTimeout = setTimeout(function () {
            showTooltip(node, text, position || types_1.Position.bottom, css, false, margin, htmlEnable);
        }, showDelay || DEFAULT_SHOW_DELAY);
    }
    var hide = function () {
        if (isActive) {
            hideTooltip(hideDelay);
        }
        clearTimeout(showTimeout);
        node.removeEventListener("mouseleave", hide);
        node.removeEventListener("blur", hide);
        document.removeEventListener("mousedown", hide);
        lastNode = null;
        activeListenersDestructor = null;
    };
    if (force) {
        showTooltip(node, text, position, css, force, margin, htmlEnable);
    }
    node.addEventListener("mouseleave", hide);
    node.addEventListener("blur", hide);
    document.addEventListener("mousedown", hide);
    activeListenersDestructor = hide;
}
// default
function tooltip(text, config) {
    var node = (0, html_1.toNode)(config.node);
    if (node === lastNode) {
        return;
    }
    if (activeListenersDestructor) {
        activeListenersDestructor();
        activeListenersDestructor = null;
    }
    lastNode = node;
    if (hideTimeout) {
        clearTimeout(hideTimeout);
        hideTimeout = null;
        addListeners(node, text, __assign(__assign({}, config), { force: true }));
    }
    else {
        addListeners(node, text, config);
    }
}
exports.tooltip = tooltip;
function _mousemove(e) {
    var node = (0, html_1.locateNode)(e, "dhx_tooltip_text");
    if (!node) {
        return;
    }
    tooltip(node.getAttribute("dhx_tooltip_text"), {
        position: node.getAttribute("dhx_tooltip_position") || types_1.Position.bottom,
        node: node,
    });
}
function enableTooltip() {
    document.addEventListener("mousemove", _mousemove);
}
exports.enableTooltip = enableTooltip;
function disableTooltip() {
    document.removeEventListener("mousemove", _mousemove);
}
exports.disableTooltip = disableTooltip;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toolbar = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(2);
var ts_message_1 = __webpack_require__(14);
var ts_navbar_1 = __webpack_require__(23);
var Toolbar = /** @class */ (function (_super) {
    __extends(Toolbar, _super);
    function Toolbar(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            $name: "toolbar",
        }, config)) || this;
        _this._currentRoot = null;
        var render = function () { return _this._draw(element); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Toolbar.prototype.getState = function (id) {
        if ((0, core_1.isDefined)(id) && !this.data.getItem(id)) {
            return;
        }
        var state = {};
        this.data.eachChild(this.data.getRoot(), function (item) {
            if (item.twoState && !item.group) {
                state[item.id] = item.active;
            }
            else if (item.type === "input" ||
                item.type === "selectButton" ||
                item.type === "datePicker") {
                state[item.id] = item.value;
            }
        }, false);
        for (var key in this._groups) {
            if (this._groups[key].active) {
                state[key] = this._groups[key].active;
            }
        }
        if ((0, core_1.isId)(id)) {
            return state[id];
        }
        return state;
    };
    Toolbar.prototype.setState = function (state) {
        var _a;
        var _loop_1 = function (key) {
            if (this_1._groups && this_1._groups[key]) {
                if (this_1._groups[key].active) {
                    this_1.data.update(this_1._groups[key].active, { active: false });
                    this_1._groups[key].active = state[key];
                    this_1.data.update(state[key], { active: true });
                }
            }
            else {
                var item = this_1.data.getItem(key);
                switch (item.type) {
                    case "input":
                        this_1.data.update(key, { value: state[key] });
                        break;
                    case "selectButton":
                        {
                            var selected = (_a = item.items) === null || _a === void 0 ? void 0 : _a.find(function (option) { return option.value === state[key]; });
                            this_1.data.update(key, { value: state[key], icon: selected === null || selected === void 0 ? void 0 : selected.icon });
                        }
                        break;
                    case "datePicker":
                        if (item.$calendar) {
                            if (state[key]) {
                                item.$calendar.setValue(state[key]);
                            }
                            else {
                                item.$calendar.clear();
                            }
                        }
                        else {
                            this_1.data.update(key, { value: state[key] });
                        }
                        break;
                    default:
                        this_1.data.update(key, { active: state[key] });
                }
            }
        };
        var this_1 = this;
        for (var key in state) {
            _loop_1(key);
        }
    };
    Toolbar.prototype.setFocus = function (id) {
        if (!this.data.getItem(id) || this.data.getItem(id).type !== "input") {
            return;
        }
        var inputEl = this.getRootNode().querySelector("[data-dhx-id=\"".concat(id, "\"]"));
        if (!inputEl) {
            return;
        }
        inputEl.focus();
    };
    Toolbar.prototype._customHandlers = function () {
        var _this = this;
        return {
            input: function (e) {
                var id = (0, html_1.locate)(e);
                var item = _this.data.getItem(id);
                if (!item)
                    return;
                var value = e.target.value;
                _this.data.update(id, { value: value });
                if (item.type === "input") {
                    _this.events.fire(ts_navbar_1.NavigationBarEvents.input, [id, value]);
                }
            },
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item === null || item === void 0 ? void 0 : item.tooltip) {
                    (0, ts_message_1.tooltip)(item.tooltip, {
                        node: elem,
                        position: ts_message_1.Position.bottom,
                    });
                }
            },
        };
    };
    Toolbar.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "button",
                "imageButton",
                "selectButton",
                "navItem",
                "menuItem",
                "separator",
                "spacer",
                "title",
                "input",
                "customHTML",
                "datePicker",
                "customHTMLButton",
            ],
            widgetName: "toolbar",
        });
    };
    Toolbar.prototype._draw = function (element) {
        var _this = this;
        var getAriaAttrs = function (element) { return ({
            role: "toolbar",
            "aria-label": element || "", // to differ toolbars if there are 2 or more on page
        }); };
        var toolbarHeight = this.data.getLength()
            ? this.data.reduce(function (result, item) {
                switch (item.type) {
                    case "title":
                        return !result ? 20 : result;
                    case "button":
                        return item.size === "small" && (!result || result <= 28) ? 28 : result || 32;
                    default:
                        return 32;
                }
            }, 0) + 24
            : null;
        return (0, dom_1.el)("nav.dhx_widget.dhx_toolbar", {
            style: { height: toolbarHeight },
            class: this.config.css ? this.config.css : "",
        }, [
            (0, dom_1.el)("ul.dhx_navbar.dhx_navbar--horizontal", __assign(__assign({ "data-dhx-widget-id": this._uid, tabindex: 0 }, getAriaAttrs(element)), { onclick: this._handlers.onclick, onmousedown: this._handlers.onmousedown, oninput: this._handlers.input, onmouseover: this._handlers.tooltip, onkeydown: this._handlers.onkeydown, onmousemove: this._handlers.onmousemove, onmouseleave: this._handlers.onmouseleave, _hooks: {
                    didInsert: function (node) {
                        node.el.addEventListener("keyup", function (e) {
                            if (e.which !== 9) {
                                return;
                            }
                            var elem = (0, html_1.locateNode)(document.activeElement);
                            if (!elem) {
                                return;
                            }
                            var id = elem.getAttribute("data-dhx-id");
                            var item = _this.data.getItem(id);
                            if (item === null || item === void 0 ? void 0 : item.tooltip) {
                                (0, ts_message_1.tooltip)(item.tooltip, {
                                    node: elem,
                                    position: ts_message_1.Position.bottom,
                                    force: true,
                                });
                            }
                        }, true);
                    },
                } }), this.data.map(function (item) { return _this._factory(item); }, this.data.getRoot(), false)),
        ]);
    };
    Toolbar.prototype._getMode = function (item, root) {
        return item.id === root ? "bottom" : "right";
    };
    Toolbar.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Toolbar.prototype._setRoot = function (id) {
        if (this.data.getParent(id) === this.data.getRoot()) {
            this._currentRoot = id;
        }
    };
    return Toolbar;
}(ts_navbar_1.Navbar));
exports.Toolbar = Toolbar;


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.PopupEvents = void 0;
var PopupEvents;
(function (PopupEvents) {
    PopupEvents["beforeHide"] = "beforeHide";
    PopupEvents["beforeShow"] = "beforeShow";
    PopupEvents["afterHide"] = "afterHide";
    PopupEvents["afterShow"] = "afterShow";
    PopupEvents["click"] = "click";
})(PopupEvents || (exports.PopupEvents = PopupEvents = {}));


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SliderEvents = void 0;
var SliderEvents;
(function (SliderEvents) {
    SliderEvents["beforeChange"] = "beforeChange";
    SliderEvents["change"] = "change";
    SliderEvents["focus"] = "focus";
    SliderEvents["blur"] = "blur";
    SliderEvents["keydown"] = "keydown";
    SliderEvents["mousedown"] = "mousedown";
    SliderEvents["mouseup"] = "mouseup";
})(SliderEvents || (exports.SliderEvents = SliderEvents = {}));


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var locale = {
    hours: "Hours",
    minutes: "Minutes",
    save: "Save",
};
exports.default = locale;


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TimepickerEvents = void 0;
var TimepickerEvents;
(function (TimepickerEvents) {
    TimepickerEvents["beforeChange"] = "beforeChange";
    TimepickerEvents["change"] = "change";
    TimepickerEvents["beforeApply"] = "beforeApply";
    TimepickerEvents["afterApply"] = "afterApply";
    TimepickerEvents["beforeClose"] = "beforeClose";
    TimepickerEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["apply"] = "apply";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["close"] = "close";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TimepickerEvents["save"] = "save";
})(TimepickerEvents || (exports.TimepickerEvents = TimepickerEvents = {}));


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarEvents = void 0;
var CalendarEvents;
(function (CalendarEvents) {
    CalendarEvents["change"] = "change";
    CalendarEvents["beforeChange"] = "beforechange";
    CalendarEvents["modeChange"] = "modeChange";
    CalendarEvents["monthSelected"] = "monthSelected";
    CalendarEvents["yearSelected"] = "yearSelected";
    CalendarEvents["cancelClick"] = "cancelClick";
    CalendarEvents["dateMouseOver"] = "dateMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    CalendarEvents["dateHover"] = "dateHover";
})(CalendarEvents || (exports.CalendarEvents = CalendarEvents = {}));


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.List = exports.MOVE_DOWN = exports.MOVE_UP = void 0;
var core_1 = __webpack_require__(1);
var ts_data_1 = __webpack_require__(4);
var dom_1 = __webpack_require__(0);
var KeyManager_1 = __webpack_require__(16);
var types_1 = __webpack_require__(29);
var view_1 = __webpack_require__(9);
var Selection_1 = __webpack_require__(81);
var html_1 = __webpack_require__(2);
var types_2 = __webpack_require__(53);
var editors_1 = __webpack_require__(171);
exports.MOVE_UP = 1;
exports.MOVE_DOWN = 2;
var List = /** @class */ (function (_super) {
    __extends(List, _super);
    function List(node, config) {
        if (config === void 0) { config = {}; }
        var _this = this;
        var itemHeight = config.itemHeight || (config.virtual ? 37 : null);
        if (itemHeight && typeof itemHeight === "number") {
            itemHeight = itemHeight.toString() + "px";
        }
        _this = _super.call(this, node, (0, core_1.extend)({
            itemHeight: itemHeight,
            keyNavigation: true,
            editable: false,
            selection: true,
            htmlEnable: true,
        }, config)) || this;
        _this._destructed = false;
        _this._touch = {
            duration: 350,
            dblDuration: 300,
            timer: null,
            start: false,
            timeStamp: null,
        };
        // init data colleciton and link events between widget and data
        var data = _this.config.data;
        if (!(data instanceof ts_data_1.DataCollection)) {
            _this.data = new ts_data_1.DataCollection({});
            _this.events = _this.data.events;
            if (data)
                _this.data.parse(data);
        }
        else {
            // [TODO] deprecate in favor of raw data input
            _this.data = data;
            _this.events = data.events;
        }
        _this.selection = new Selection_1.Selection({
            disabled: !_this.config.selection,
            multiselection: _this.config.multiselection,
        }, _this.data, _this.events);
        if (_this.config.keyNavigation) {
            _this.keyManager = new KeyManager_1.KeyManager(function (e, focusId) {
                return focusId == _this._uid && (!_this._edited || (_this._edited && e.key !== "escape"));
            });
            _this._initHotKey();
        }
        _this.events.on(ts_data_1.DataEvents.change, function (_, status, item) {
            if (status === "setPage") {
                _this.scrollTo(_this.data.getId(item[0]));
            }
            _this.paint();
        });
        _this.events.on(ts_data_1.DataEvents.filter, function () {
            _this.paint();
        });
        _this.events.on(types_1.SelectionEvents.afterUnSelect, function () { return _this.paint(); });
        _this.events.on(types_1.SelectionEvents.afterSelect, function (id) {
            if ((0, core_1.isId)(id) && _this.config.selection)
                _this.setFocus(id);
            _this.paint();
        });
        _this.events.on(types_2.ListEvents.afterEditEnd, _this.editEnd.bind(_this));
        var drop = function (value) { return function (info) {
            _this.data.setMeta(_this.data.getItem(info.target), "drop", value);
            _this.paint();
        }; };
        _this.events.on(ts_data_1.DragEvents.canDrop, drop(true));
        _this.events.on(ts_data_1.DragEvents.cancelDrop, drop(false));
        var drag = function (value) { return function (info) {
            info.source.map(function (id) { return _this.data.setMeta(_this.data.getItem(id), "drag", value); });
            _this.paint();
        }; };
        _this.events.on(ts_data_1.DragEvents.dragStart, drag(true));
        _this.events.on(ts_data_1.DragEvents.afterDrag, drag(false));
        _this._handlers = {
            onmousedown: function (e) {
                _this._dragStart(e);
            },
            ontouchstart: function (e) {
                _this._touch.timer = setTimeout(function () {
                    _this._dragStart(e);
                }, _this._touch.duration);
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +e.timeStamp.toFixed();
                }
                else {
                    var dblTap = _this._touch.dblDuration >= _this._touch.timeStamp - +e.timeStamp.toFixed();
                    if (dblTap) {
                        e.preventDefault();
                        _this._dblClick(e);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            },
            ontouchmove: function (e) {
                _this._touch.start && e.preventDefault();
                _this._clearTouchTimer();
            },
            ontouchend: function () {
                _this._touch.start = false;
                _this._clearTouchTimer();
            },
            ondragstart: function () { return (_this.config.dragMode && !_this._edited ? false : null); },
            oncontextmenu: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                _this.events.fire(types_2.ListEvents.itemRightClick, [id, e]);
            },
            onclick: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                _this.selection.add(id, e.ctrlKey || e.metaKey, e.shiftKey);
                if (_this.config.selection) {
                    _this._focus = id;
                }
                _this.events.fire(types_2.ListEvents.click, [id, e]);
                _this.paint();
            },
            ondblclick: function (e) {
                _this._dblClick(e);
            },
            onscroll: function (e) {
                if (_this.config.virtual) {
                    _this._topOffset = e.target.scrollTop;
                    _this._visibleHeight = e.target.offsetHeight;
                    _this.paint();
                }
            },
            onmouseover: function (e) {
                var _a;
                var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                if (!(0, core_1.isId)(id)) {
                    return;
                }
                var prevId = (0, html_1.locate)(e.relatedTarget);
                if (id !== prevId)
                    _this.events.fire(types_2.ListEvents.itemMouseOver, [id, e]);
            },
        };
        var evs = _this.config.eventHandlers;
        if (evs) {
            for (var _i = 0, _a = Object.entries(evs); _i < _a.length; _i++) {
                var _b = _a[_i], event_name = _b[0], events = _b[1];
                _this._handlers[event_name] = (0, html_1.eventHandler)(function (e) { return (0, html_1.locate)(e); }, events, _this._handlers[event_name]);
            }
        }
        if (_this.config.dragMode) {
            ts_data_1.dragManager.setItem(_this._uid, _this);
        }
        // defaults for virtual rendering
        _this._topOffset = _this._visibleHeight = 0;
        var view = (0, dom_1.create)({
            render: function () {
                return _this._destructed ? (0, dom_1.el)("div") : _this._renderList();
            },
            hooks: {
                didMount: function (vm) {
                    if (_this.config.virtual)
                        _this._visibleHeight = vm.node.el.offsetHeight;
                },
                didRedraw: function (vm) { return _this._didRedraw(vm); },
            },
        });
        _this.mount(node, view);
        return _this;
    }
    List.prototype._didRedraw = function (vm) {
        // do nothing
    };
    List.prototype._dblClick = function (e) {
        var _a;
        var id = (0, html_1.locate)(e);
        if (!id) {
            return;
        }
        id = (_a = this.data.getItem(id)) === null || _a === void 0 ? void 0 : _a.id;
        if (this.config.editable) {
            this.editItem(id);
        }
        this.events.fire(types_2.ListEvents.doubleClick, [id, e]);
    };
    List.prototype._clearTouchTimer = function () {
        if (this._touch.timer) {
            clearTimeout(this._touch.timer);
            this._touch.timer = null;
        }
    };
    List.prototype._dragStart = function (event) {
        var _this = this;
        this._touch.start = true;
        var itemsForGhost = [];
        var item = (0, html_1.locateNode)(event, "data-dhx-id");
        var itemId = item && item.getAttribute("data-dhx-id");
        var selectionIds = this.selection.getId();
        if (this.config.multiselection && selectionIds instanceof Array) {
            selectionIds.map(function (id) {
                if (id !== itemId && _this.getRootView().refs[id]) {
                    itemsForGhost.push(_this.getRootView().refs[id].el);
                }
            });
            selectionIds = __spreadArray([], selectionIds, true);
        }
        if (typeof selectionIds === "string") {
            selectionIds = [selectionIds];
        }
        return this.config.dragMode && !this._edited
            ? ts_data_1.dragManager.onMouseDown({
                event: event,
                type: "row",
                source: selectionIds || [itemId],
                itemsForGhost: itemsForGhost,
            })
            : null;
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    List.prototype.disableSelection = function () {
        this.selection.disable();
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    List.prototype.enableSelection = function () {
        this.selection.enable();
    };
    List.prototype.editItem = function (id) {
        this._edited = id;
        if (!this.data.getItem(this._edited) || !this.events.fire(types_2.ListEvents.beforeEditStart, [id])) {
            this._edited = null;
            return;
        }
        this.paint();
        this.events.fire(types_2.ListEvents.afterEditStart, [id]);
    };
    // [TODO] maybe better name
    List.prototype.editEnd = function (value, id) {
        if (this._edited) {
            if (value !== null) {
                var item = this.data.getItem(id);
                this.data.update(id, __assign(__assign({}, item), { value: value }));
                this._changed = true;
            }
            this._edited = null;
            this.paint();
        }
    };
    /*
        Focus API allows to mark item as active one, but not selected yet
        Used by keyboard navigation
    */
    List.prototype.getFocusItem = function () {
        return this.data.getItem(this._focus);
    };
    List.prototype.setFocus = function (id) {
        if (this._focus != id && this.data.exists(id)) {
            this._focus = id;
            this.events.fire(types_2.ListEvents.focusChange, [this.data.getIndex(this._focus), this._focus]);
            this.scrollTo(id);
            this.paint();
        }
    };
    List.prototype.resetFocus = function () {
        this._focus = undefined;
        this.events.fire(types_2.ListEvents.focusChange);
        this.scrollTo(this.data.getId(0));
        this.paint();
    };
    List.prototype.getFocus = function () {
        return this._focus;
    };
    List.prototype.destructor = function () {
        this._destructed = true;
        this.events && this.events.clear();
        this.keyManager && this.keyManager.destructor();
        this.selection && this.selection.destructor();
        this.config = this.events = this.selection = this.keyManager = null;
        this._handlers = this._focus = this._edited = this._events = this._topOffset = this._visibleHeight = this._touch = null;
        this.unmount();
    };
    List.prototype.scrollTo = function (id) {
        var rootView = this.getRootView();
        if (!rootView || !rootView.node || !rootView.node.el || typeof id === "undefined") {
            return;
        }
        var listEl = this.getRootNode();
        this._scrollTo(id, listEl);
    };
    List.prototype._scrollTo = function (id, el) {
        if (!el)
            return;
        var index = this.data.getIndex(id);
        if (index === -1)
            return;
        var virtual = this.config.virtual;
        var currentPage = Math.floor(index / el.children.length) || 0;
        var item = el.children[index - el.children.length * currentPage];
        if (!virtual && !item)
            return;
        var height = virtual ? parseInt(this.config.itemHeight) : item.clientHeight;
        var top = virtual ? index * height : item.offsetTop;
        if (top >= el.scrollTop + el.clientHeight - height) {
            el.scrollTo(0, top - el.clientHeight + height);
        }
        else if (top < el.scrollTop) {
            el.scrollTo(0, top);
        }
    };
    List.prototype._renderItem = function (item, index) {
        var addEmpty = function (node) {
            node.class += " dhx_list-item--empty";
        };
        var itemHeight = this.config.itemHeight;
        if (item.$empty) {
            return (0, dom_1.el)("li", {
                class: "dhx_list-item",
                style: {
                    height: itemHeight,
                },
            });
        }
        var html = "";
        if (this.config.template)
            html = this.config.template(item);
        if (item.html)
            html = item.html;
        var focus = item.id == this._focus && this.config.keyNavigation;
        if (item.id == this._edited) {
            var editor = (0, editors_1.getEditor)(item, this);
            return editor.toHTML();
        }
        var mx = this.data.getMetaMap(item);
        var node = __assign(__assign(__assign(__assign({}, this._events), { class: "dhx_list-item" +
                (mx && mx.selected ? " dhx_list-item--selected" : "") +
                (focus ? " dhx_list-item--focus" : "") +
                (mx && mx.drop && !this._edited ? " dhx_list-item--drophere" : "") +
                (mx && mx.drag && !this._edited ? " dhx_list-item--dragtarget" : "") +
                (this.config.dragMode && !this._edited ? " dhx_list-item--drag" : "") +
                (item.css ? " " + item.css : ""), "data-dhx-id": item.id, _ref: item.id.toString(), style: {
                height: itemHeight,
            }, _key: item.id }), this.getItemAriaAttrs(this, item)), { tabindex: focus ? 0 : -1 });
        if (html) {
            if (html === item.html || this.config.htmlEnable) {
                node[".innerHTML"] = html;
                return (0, dom_1.el)("li", node);
            }
            else {
                return (0, dom_1.el)("li", node, html);
            }
        }
        else if (this.config.$template) {
            if (!item.value)
                addEmpty(node);
            return (0, dom_1.el)("li", node, [this.config.$template(item)]);
        }
        else {
            var value = item.text || item.value;
            if (!value)
                addEmpty(node);
            if (this.config.htmlEnable) {
                node[".innerHTML"] = value;
            }
            else
                node.class += " dhx_list-item--text";
            return this.config.htmlEnable ? (0, dom_1.el)("li", node) : (0, dom_1.el)("li", node, value);
        }
    };
    List.prototype._renderList = function () {
        var _this = this;
        var range = this._getRange();
        // mapRange
        var data = this.data.getRawData(range[0], range[1]);
        var kids = data.map(function (obj, index) { return _this._renderItem(obj, index); });
        if (this.config.virtual) {
            kids = __spreadArray(__spreadArray([
                (0, dom_1.el)(".div", { style: { height: range[2] + "px", _key: "start-key" } })
            ], kids, true), [
                (0, dom_1.el)(".div", { style: { height: range[3] + "px", _key: "end-key" } }),
            ], false);
        }
        return (0, dom_1.el)("ul.dhx_widget.dhx_list", __assign(__assign({ style: {
                "max-height": this.config.height,
                position: "relative",
            }, tabindex: 0, id: this._uid, class: (this.config.css ? this.config.css : "") +
                (this.config.multiselection && this.selection.getItem() ? " dhx_no-select--pointer" : ""), "data-dhx-widget-id": this._uid, "data-dhx-drop-area": "row" }, this._handlers), this._getListAriaAttrs(this.config, this.data.getLength())), kids);
    };
    List.prototype.moveFocus = function (mode, step) {
        var length = this.data.getLength();
        if (!length) {
            return;
        }
        var id = this._focus;
        var index = id ? this.data.getIndex(id) : -1;
        step = step || 1;
        if (mode === exports.MOVE_DOWN) {
            id = this.data.getId(Math.min(index + step, length - 1));
        }
        else if (mode === exports.MOVE_UP) {
            id = this.data.getId(Math.max(index - step, 0));
        }
        this.setFocus(id);
    };
    List.prototype._getRange = function () {
        if (this.config.virtual) {
            var overscanCount = 5;
            var visibleHeight = this._visibleHeight || parseInt(this.config.height);
            var itemHeight = parseInt(this.config.itemHeight) || 37;
            var total = this.data.getRawData(0, -1).length;
            var totalHeight = total * itemHeight;
            var position = this._topOffset;
            // correct value to be in [0, total-visible] range
            position = Math.max(0, Math.min(position, totalHeight - visibleHeight));
            var index = Math.floor(position / itemHeight);
            var count = Math.min(total - index, Math.floor(visibleHeight / itemHeight) + overscanCount);
            this._topOffset = position;
            return [index, count + index, index * itemHeight, totalHeight - itemHeight * (count + index)];
        }
        else {
            return [0, -1, 0, 0];
        }
    };
    List.prototype._getHotkeys = function () {
        var _this = this;
        return {
            arrowDown: function (e) {
                _this.moveFocus(exports.MOVE_DOWN);
                if (_this._changed)
                    _this._changed = false;
                e.preventDefault();
            },
            arrowUp: function (e) {
                _this.moveFocus(exports.MOVE_UP);
                if (_this._changed)
                    _this._changed = false;
                e.preventDefault();
            },
            escape: function () {
                _this.editEnd(null);
                if (_this._changed)
                    _this._changed = false;
            },
            enter: function (e) {
                var _a;
                if (_this._changed) {
                    _this._changed = false;
                    return;
                }
                var selected = _this.selection.getItem();
                var selectedId = selected instanceof Array ? (_a = selected[0]) === null || _a === void 0 ? void 0 : _a.id : selected === null || selected === void 0 ? void 0 : selected.id;
                if (_this.config.editable &&
                    !_this._edited &&
                    ((selected && selectedId === _this._focus) || !selected)) {
                    _this.editItem(_this._focus);
                }
                else
                    _this.selection.add(_this._focus);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "shift+enter": function (e) {
                _this.selection.add(_this._focus, false, true);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "ctrl+enter": function (e) {
                _this.selection.add(_this._focus, true, false);
                _this.events.fire(types_2.ListEvents.click, [_this._focus, e]);
            },
            "ctrl+a": function (e) {
                if (_this.config.multiselection) {
                    e.preventDefault();
                    _this.selection.remove();
                    var ids = _this.data.map(function (i) { return i.id; });
                    ids.forEach(function (id) {
                        if (_this.config.multiselection === "ctrlClick") {
                            _this.selection.add(id, true);
                        }
                        else {
                            _this.selection.add(id);
                        }
                    });
                }
            },
        };
    };
    List.prototype._initHotKey = function () {
        var handlers = this._getHotkeys();
        for (var key in handlers) {
            this.keyManager.addHotKey(key, handlers[key]);
        }
        for (var key in this.config.hotkeys) {
            this.keyManager.addHotKey(key, this.config.hotkeys[key]);
        }
    };
    List.prototype.getItemAriaAttrs = function (context, item) {
        var getAriaGrabbed = function (context, item) {
            return context.config.dragMode && !context._edited
                ? { "aria-grabbed": Boolean(item.$dragtarget && !context._edited).toString() }
                : {};
        };
        var getAriaRoleDescription = function (context) {
            return context.config.editable
                ? {
                    "aria-roledescription": "".concat(context._edited ? "Press Enter to stop editing" : "Double click to edit content"),
                }
                : {};
        };
        return __assign(__assign({ role: "option", "aria-selected": item.id === this._focus ? "true" : "false" }, getAriaGrabbed(context, item)), getAriaRoleDescription(context));
    };
    List.prototype._getListAriaAttrs = function (config, dataLength) {
        return {
            role: "listbox",
            "aria-label": "Listbox ".concat(config.title || "", ", count of options = ").concat(dataLength, ".").concat(config.editable ? " Content is editable." : ""),
            "aria-multiselectable": config.selection && config.multiselection ? "true" : "false",
            "aria-readonly": config.editable ? "false" : "true",
        };
    };
    return List;
}(view_1.View));
exports.List = List;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Selection = void 0;
var types_1 = __webpack_require__(29);
var ts_data_1 = __webpack_require__(4);
var core_1 = __webpack_require__(1);
var Selection = /** @class */ (function () {
    function Selection(config, data, events) {
        var _this = this;
        this.config = config;
        this.events = events;
        this._data = data;
        this._selected = [];
        this._data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._selected = [];
        });
        if (typeof this.config.multiselection === "string") {
            var types = ["click", "ctrlClick"];
            if (!types.includes(this.config.multiselection)) {
                this.config.multiselection = false;
            }
        }
        this._data.events.on(ts_data_1.DataEvents.beforeRemove, function (obj) {
            _this._nextSelection = null;
            if (_this._selected.length === 1) {
                var next = _this._data.getIndex(obj.id);
                var count = _this._data.getLength();
                if (count > 1) {
                    var lastIndex = count == next - 1 ? next - 1 : next + 1;
                    _this._nextSelection = _this._data.getId(lastIndex);
                }
            }
        });
        this._data.events.on(ts_data_1.DataEvents.afterRemove, function (obj) {
            var hasIndex = _this._selected.indexOf(obj.id);
            if (hasIndex !== -1) {
                _this._selected.splice(hasIndex, 1);
            }
            if ((0, core_1.isId)(_this._nextSelection)) {
                _this.add(_this._nextSelection);
                _this._nextSelection = null;
            }
        });
    }
    Selection.prototype.enable = function () {
        this.config.disabled = false;
    };
    Selection.prototype.disable = function () {
        this.remove();
        this.config.disabled = true;
    };
    Selection.prototype.getId = function () {
        if (this.config.multiselection) {
            return this._selected;
        }
        return this._selected[0];
    };
    Selection.prototype.getItem = function () {
        var _this = this;
        if (this.config.multiselection) {
            return this._selected.map(function (id) { return _this._data.getItem(id); });
        }
        return this._selected.length ? this._data.getItem(this._selected[0]) : null;
    };
    Selection.prototype.contains = function (id) {
        if ((0, core_1.isId)(id)) {
            return this._selected.includes(id);
        }
        return this._selected.length > 0;
    };
    Selection.prototype.remove = function (id, silent) {
        var _this = this;
        if ((0, core_1.isId)(id)) {
            this._unselectItem(id, silent);
        }
        else {
            this._selected.forEach(function (selectedId) { return _this._unselectItem(selectedId, silent); });
            this._selected = [];
        }
    };
    Selection.prototype.add = function (id, isCtrl, isShift, silent) {
        var _this = this;
        if (this.config.disabled) {
            return;
        }
        if (typeof id === "undefined") {
            var unSelected = this._data.serialize().filter(function (_a) {
                var id = _a.id;
                return !_this._selected.includes(id);
            });
            unSelected.forEach(function (_a) {
                var id = _a.id;
                _this._addMulti(id, silent);
            });
            return;
        }
        var multi = this.config.multiselection;
        if (isShift && this._selected.length && multi) {
            this._addMulti(id, silent);
        }
        else {
            this._addSingle(id, multi && (multi !== "ctrlClick" || isCtrl), silent);
        }
    };
    Selection.prototype.destructor = function () {
        var _this = this;
        this._selected.forEach(function (selectedId) { return _this._unselectItem(selectedId, true); });
    };
    Selection.prototype._addMulti = function (id, silent) {
        var _a;
        var last = this._selected[this._selected.length - 1];
        var i1 = this._data.getIndex(last);
        var i2 = this._data.getIndex(id);
        if (i1 > i2) {
            _a = [i2, i1], i1 = _a[0], i2 = _a[1];
        }
        for (i1; i1 <= i2; i1++) {
            var id_1 = this._data.getId(i1);
            this._selectItem(id_1, silent);
        }
    };
    Selection.prototype._addSingle = function (id, isCtrl, silent) {
        var _this = this;
        if (!isCtrl) {
            this._selected.forEach(function (selectedId) {
                if (selectedId != id)
                    _this._unselectItem(selectedId);
            });
        }
        if (isCtrl && this._selected.includes(id)) {
            this._unselectItem(id, silent);
        }
        else {
            this._selectItem(id, silent);
        }
    };
    Selection.prototype._selectItem = function (id, silent) {
        var item = this._data.getItem(id);
        if (!item || this._data.getMeta(item, "selected"))
            return;
        if (!silent && !this.events.fire(types_1.SelectionEvents.beforeSelect, [id]))
            return;
        this._selected.push(id);
        this._data.setMeta(item, "selected", true);
        if (!silent)
            this.events.fire(types_1.SelectionEvents.afterSelect, [id]);
    };
    Selection.prototype._unselectItem = function (id, silent) {
        if (!silent && !this.events.fire(types_1.SelectionEvents.beforeUnSelect, [id]))
            return;
        this._selected = this._selected.filter(function (selectedId) { return selectedId !== id; });
        this._data.setMeta(this._data.getItem(id), "selected", false);
        if (!silent)
            this.events.fire(types_1.SelectionEvents.afterUnSelect, [id]);
    };
    return Selection;
}());
exports.Selection = Selection;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.palette = exports.grayShades = void 0;
exports.grayShades = [
    "#000000",
    "#4C4C4C",
    "#666666",
    "#808080",
    "#999999",
    "#B3B3B3",
    "#CCCCCC",
    "#E6E6E6",
    "#F2F2F2",
    "#FFFFFF",
];
exports.palette = [
    ["#D4DAE4", "#B0B8CD", "#949DB1", "#727A8C", "#5E6677", "#3F4757", "#1D2534"],
    ["#FFCDD2", "#FE9998", "#F35C4E", "#E94633", "#D73C2D", "#CA3626", "#BB2B1A"],
    ["#F9E6AD", "#F4D679", "#EDB90F", "#EAA100", "#EA8F00", "#EA7E00", "#EA5D00"],
    ["#BCE4CE", "#90D2AF", "#33B579", "#36955F", "#247346", "#1D5B38", "#17492D"],
    ["#BDF0E9", "#92E7DC", "#02D7C5", "#11B3A5", "#018B80", "#026B60", "#024F43"],
    ["#B3E5FC", "#81D4FA", "#29B6F6", "#039BE5", "#0288D1", "#0277BD", "#01579B"],
    ["#AEC1FF", "#88A3F9", "#5874CD", "#2349AE", "#163FA2", "#083596", "#002381"],
    ["#C5C0DA", "#9F97C1", "#7E6BAD", "#584A8F", "#4F4083", "#473776", "#3A265F"],
    ["#D6BDCC", "#C492AC", "#A9537C", "#963A64", "#81355A", "#6E3051", "#4C2640"],
    ["#D2C5C1", "#B4A09A", "#826358", "#624339", "#5D4037", "#4E342E", "#3E2723"],
];


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ColorpickerEvents = void 0;
var ColorpickerEvents;
(function (ColorpickerEvents) {
    ColorpickerEvents["beforeChange"] = "beforeChange";
    ColorpickerEvents["change"] = "change";
    ColorpickerEvents["apply"] = "apply";
    ColorpickerEvents["cancelClick"] = "cancelClick";
    ColorpickerEvents["modeChange"] = "modeChange";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["selectClick"] = "selectClick";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["colorChange"] = "colorChange";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ColorpickerEvents["viewChange"] = "viewChange";
})(ColorpickerEvents || (exports.ColorpickerEvents = ColorpickerEvents = {}));


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chart = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var view_1 = __webpack_require__(9);
var ts_data_1 = __webpack_require__(4);
var ComposeLayer_1 = __webpack_require__(178);
var Legend_1 = __webpack_require__(85);
var types_1 = __webpack_require__(26);
var index_1 = __webpack_require__(181);
var index_2 = __webpack_require__(87);
var Stacker_1 = __webpack_require__(92);
var common_1 = __webpack_require__(7);
var Tooltip_1 = __webpack_require__(195);
var core_1 = __webpack_require__(1);
var Export_1 = __webpack_require__(196);
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart(node, config) {
        if (config === void 0) { config = {}; }
        var _this = this;
        var _a;
        _this = _super.call(this, null, config) || this;
        // using zero values ensure that widget will not attempt to render self in the hidden state
        _this._width = 0;
        _this._height = 0;
        _this._left = 0;
        _this._top = 0;
        var dataConfig = {};
        if (config.maxPoints) {
            dataConfig.approximate = {
                value: (_a = config.series) === null || _a === void 0 ? void 0 : _a.map(function (a) { return a.value; }),
                maxNum: config.maxPoints,
            };
        }
        if (Array.isArray(config.data)) {
            _this.events = new events_1.EventSystem(_this);
            _this.data =
                config.type === "treeMap"
                    ? new ts_data_1.TreeCollection(dataConfig, _this.events)
                    : new ts_data_1.DataCollection(dataConfig, _this.events);
            _this.data.parse(config.data);
        }
        else if (config.data && config.data.events) {
            _this.data = config.data;
            _this.events = _this.data.events;
            _this.events.context = _this;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
            _this.data =
                config.type === "treeMap"
                    ? new ts_data_1.TreeCollection(dataConfig, _this.events)
                    : new ts_data_1.DataCollection(dataConfig, _this.events);
        }
        _this._globalHTMLHandlers = {
            onmousemove: function (e) {
                var _a = _this._layers.getSizes(), left = _a.left, top = _a.top, bottom = _a.bottom, right = _a.right;
                var pageX = e.pageX, pageY = e.pageY;
                var rects = _this.getRootView().node.el.getBoundingClientRect();
                _this._left = rects.left + window.pageXOffset;
                _this._top = rects.top + window.pageYOffset;
                var x = pageX - left - _this._left;
                var y = pageY - top - _this._top;
                if (x >= 0 && x <= _this._width - right - left && y >= 0 && y <= _this._height - bottom - top) {
                    _this.events.fire(types_1.ChartEvents.chartMouseMove, [x, y, _this._left + left, _this._top + top]);
                }
                else {
                    _this.events.fire(types_1.ChartEvents.chartMouseLeave);
                }
            },
            onmouseleave: function () { return _this.events.fire(types_1.ChartEvents.chartMouseLeave); },
        };
        _this._layers = new ComposeLayer_1.ComposeLayer();
        _this.setConfig(config);
        _this._initEvents();
        _this._tooltip = new Tooltip_1.Tooltip(_this);
        var render = function () {
            if (!_this.data.getLength()) {
                return (0, dom_1.el)("div");
            }
            var getChartAriaLabel = function (config) {
                /*  Full example (without symbols of new line):
                    Type chart "Title". X/Y Scale Name: bottom axis from Min to Max. Scale Name: left axis Name from Min to Max.
                    Series: seria A, seria B, seria C, ...
                 */
                var scales = _this._scales;
                var series = config.series;
                var type = config.type;
                if (!type) {
                    // scatter chart
                    type = series && series.length && series[0] ? series[0].type || "" : "";
                }
                var label = "".concat(type || "", " chart.");
                var getAxisName = function (cfg) { return (cfg._isXDirection ? "X" : "Y"); };
                var getAxisTitle = function (cfg) { return cfg.title || cfg.text || cfg.value || ""; };
                var getAxisMin = function (cfg) { return (cfg.steps && cfg.steps.length ? cfg.steps[0] : cfg.min || 0); };
                var getAxisMax = function (cfg) {
                    return cfg.steps && cfg.steps.length
                        ? cfg.steps[cfg.steps.length - 1]
                        : cfg.max || cfg.maxPoints || "max";
                };
                var getRadialAxisValue = function (attr, point) { return point[attr]; };
                if (scales) {
                    Object.keys(scales).forEach(function (direction) {
                        var scale = scales[direction];
                        var cfg = scale._axis || scale.config;
                        if (direction === "radial") {
                            var xData = scale._data._order;
                            label += " X scale ".concat(getAxisTitle(scale.config), ": ").concat(direction, " axis from ").concat(getRadialAxisValue(scale.config.value, xData[0]), " to ").concat(getRadialAxisValue(scale.config.value, xData[xData.length - 1]), ".");
                            label += " ".concat(getAxisName(scale), " scale: axis from ").concat(getAxisMin(cfg), " to ").concat(getAxisMax(cfg), ".");
                        }
                        else {
                            label += " ".concat(getAxisName(scale), " scale ").concat(getAxisTitle(scale.config), ": ").concat(direction, " axis from ").concat(getAxisMin(cfg), " to ").concat(getAxisMax(cfg), ".");
                        }
                    });
                }
                if (series && series.length) {
                    label += " Series:";
                    series.forEach(function (seria, index) {
                        label += " ".concat(type === "pie" || type === "pie3D" || type === "donut" ? seria.text : seria.value);
                        label += index === series.length - 1 ? "." : ",";
                    });
                }
                return label;
            };
            var getChartAriaAttrs = function (config) { return ({
                "aria-label": getChartAriaLabel(config),
            }); };
            var content = [
                (0, dom_1.resizer)(function (x, y) {
                    _this._width = x;
                    _this._height = y || 400; // if height is not provided, use default value
                    var view = _this.getRootView();
                    if (view && view.node && view.node.el) {
                        var rects = view.node.el.getBoundingClientRect();
                        _this._left = rects.left + window.pageXOffset;
                        _this._top = rects.top + window.pageYOffset;
                    }
                    _this.events.fire(types_1.ChartEvents.resize, [_this._width, _this._height]);
                    _this.paint();
                    if (!document.querySelector(".dhx_widget.dhx_chart") && _this._tooltip) {
                        _this._tooltip.destructor();
                    }
                }),
            ];
            if (_this._width && _this._height) {
                content.push(_this._layers.toVDOM(_this._width, _this._height));
            }
            return (0, dom_1.el)(".dhx_widget.dhx_chart", __assign(__assign({ class: config.css ? config.css : "", onmousemove: _this._globalHTMLHandlers.onmousemove, onmouseleave: _this._globalHTMLHandlers.onmouseleave }, getChartAriaAttrs(config)), { tabIndex: 0 }), content);
        };
        var view = (0, dom_1.create)({
            render: render,
            hooks: {
                didMount: function (vm) {
                    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
                        _this._width = vm.node.parent.el.offsetWidth;
                        _this._height = vm.node.parent.el.offsetHeight || 400;
                        _this.paint();
                    }
                },
            },
        });
        _this.mount(node, view);
        _this.export = new Export_1.Exporter("chart", _this);
        return _this;
    }
    Chart.prototype.getSeries = function (key) {
        return this._series[key];
    };
    Chart.prototype.eachSeries = function (handler) {
        var result = [];
        for (var key in this._series) {
            result.push(handler.call(this, this._series[key]));
        }
        return result;
    };
    Chart.prototype.destructor = function () {
        this._tooltip.destructor();
        this.events.clear();
        this.unmount();
    };
    Chart.prototype.setConfig = function (config) {
        var _this = this;
        var _a;
        if (config.type === "calendarHeatMap") {
            throw new TypeError("The calendarHeatMap chart type is a pro functionality");
        }
        this.config = config;
        this._layers.clear();
        this._series = {};
        this._scales = {};
        var min;
        // let baseLine;
        if (config.scales) {
            for (var key in config.scales) {
                var scale = __assign({}, config.scales[key]);
                if (config.scales[key].min !== undefined) {
                    min = config.scales[key].min;
                }
                scale.type = scale.type || this._detectScaleType(scale, key);
                if (config.scales.radial && key !== "radial") {
                    scale.hidden = true;
                }
                this._setScale(scale, key);
            }
        }
        var stack = new Stacker_1.default();
        this._layers.add(stack);
        (_a = config.series) === null || _a === void 0 ? void 0 : _a.forEach(function (cfg, ind) {
            var _a, _b, _c, _d;
            if (cfg.baseLine !== undefined && cfg.baseLine < min) {
                cfg.baseLine = undefined;
            }
            var serieConfig = __assign({}, cfg);
            serieConfig.type = serieConfig.type || config.type;
            switch (serieConfig.type) {
                case "bar":
                case "xbar":
                case "area":
                case "splineArea":
                    if (!serieConfig.color)
                        serieConfig.color = serieConfig.fill || (0, common_1.getDefaultColor)(ind);
                    if (!serieConfig.fill)
                        serieConfig.fill = serieConfig.color || (0, common_1.getDefaultColor)(ind);
                    break;
                case "treeMap":
                    serieConfig.legendType = ((_a = config.legend) === null || _a === void 0 ? void 0 : _a.type) || "groupName";
                    (_c = (_b = config.legend) === null || _b === void 0 ? void 0 : _b.treeSeries) === null || _c === void 0 ? void 0 : _c.map(function (serie, index) {
                        var _a, _b;
                        serie.active = (_a = serie.active) !== null && _a !== void 0 ? _a : true;
                        serie.id = (_b = serie.id) !== null && _b !== void 0 ? _b : (0, core_1.uid)();
                        if (!serie.color)
                            serie.color = (0, common_1.getDefaultColor)(index, serieConfig.legendType === "range");
                    });
                    serieConfig.treeSeries = (_d = config.legend) === null || _d === void 0 ? void 0 : _d.treeSeries;
                    break;
                case "scatter":
                    if (!serieConfig.pointColor)
                        serieConfig.pointColor = serieConfig.color || (0, common_1.getDefaultColor)(ind);
                    break;
            }
            var chartFactory = index_2.default[serieConfig.type];
            if (serieConfig.barWidth || _this.config.barWidth) {
                serieConfig.barWidth = serieConfig.barWidth || _this.config.barWidth;
            }
            var chart = new chartFactory(_this.data, serieConfig, _this.events);
            var scales = (0, common_1.getScales)(config.scales);
            var chartScales = scales.length > 1 && scales[0] !== "radial"
                ? scales
                : scales[0] === "radial"
                    ? scales
                    : ["bottom", "left"];
            chartScales.forEach(function (type) {
                var scale = _this._scales[type];
                if (!scale) {
                    return;
                }
                chart.addScale(type, scale);
                if (!serieConfig.stacked) {
                    scale.add(chart);
                }
                else {
                    scale.add(stack);
                }
            });
            _this._series[chart.id] = chart;
            if (serieConfig.stacked) {
                stack.add(chart);
            }
            else {
                _this._layers.add(chart);
            }
        });
        if (config.legend) {
            var legendConfig = __assign({}, config.legend);
            if (legendConfig.series) {
                legendConfig.$seriesInfo = legendConfig.series.map(function (id) { return _this._series[id]; });
            }
            var legend = new Legend_1.Legend(this.data, legendConfig, this.events);
            this._layers.add(legend);
        }
        this.paint();
    };
    Chart.prototype._setScale = function (config, position) {
        if (!config.type)
            return;
        var scale = new index_1.default[config.type](this.data, config, position);
        if (scale.config.type !== "radial") {
            this._layers.add(scale.scaleGrid());
        }
        this._layers.add(scale);
        this._scales[position] = scale;
    };
    Chart.prototype._detectScaleType = function (config, key) {
        if (key === "radial") {
            return key;
        }
        if (config.text) {
            return "text";
        }
        return "numeric";
    };
    Chart.prototype._initEvents = function () {
        var _this = this;
        // hide/show series on legend click
        this.events.on(types_1.ChartEvents.toggleSeries, function (id, pieLike) {
            if (_this.config.type === "treeMap") {
                Object.values(_this._series)[0].toggle(id);
                _this.paint();
            }
            else if (pieLike) {
                var serie = _this._series[Object.keys(_this._series)[0]];
                if (serie) {
                    serie.toggle(id);
                    _this.paint();
                }
            }
            else if (_this._series[id]) {
                _this._series[id].toggle();
                _this.paint();
            }
        }, this);
        // repaint on data change
        this.events.on(ts_data_1.DataEvents.change, function () { return _this.paint(); });
        this.events.on(ts_data_1.DataEvents.filter, function () { return _this.paint(); });
    };
    return Chart;
}(view_1.View));
exports.Chart = Chart;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Legend = void 0;
var ts_data_1 = __webpack_require__(4);
var types_1 = __webpack_require__(26);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var legend_1 = __webpack_require__(180);
var core_1 = __webpack_require__(1);
function getDefaultMargin(halign, valign, isTreeMap, form) {
    switch (valign) {
        case "middle": {
            switch (halign) {
                case "right":
                    return isTreeMap ? 20 : 60;
                case "left":
                    return 120;
                case "center":
                    throw new Error("cant place legend on center, middle");
            }
        }
        // eslint-disable-next-line no-fallthrough
        case "top":
            return 20;
        case "bottom":
            return isTreeMap || form === "line" ? 20 : 60;
    }
}
var Legend = /** @class */ (function () {
    function Legend(_data, config, _events) {
        var _this = this;
        this._data = _data;
        this._events = _events;
        var defaults = {
            form: "rect",
            itemPadding: 20,
            halign: "right",
            valign: "top",
            direction: "row",
            type: "groupName",
        };
        this.config = __assign(__assign({}, defaults), config);
        this.config.margin =
            config.margin ||
                getDefaultMargin(this.config.halign, this.config.valign, (0, ts_data_1.isTreeCollection)(this._data), this.config.form);
        this._handlers = {
            onclick: function (id, pieLike) {
                return _this._events.fire(types_1.ChartEvents.toggleSeries, [id, pieLike]);
            },
            onkeyup: function (id, pieLike, event) {
                // FIXME: set handler correctly according app code style
                event.preventDefault();
                // enter or space
                if (event.key === "Enter" || event.key === " ") {
                    _this._events.fire(types_1.ChartEvents.toggleSeries, [id, pieLike]);
                }
            },
        };
    }
    Legend.prototype.scaleReady = function (sizes) {
        var isColumnInCorner = this.config.direction === "column" &&
            (this.config.halign === "left" || this.config.halign === "right");
        switch (this.config.valign) {
            case "middle":
                if (this.config.halign === "right") {
                    sizes.right += this.config.size >= 0 ? this.config.size : 200;
                }
                else if (this.config.halign === "left") {
                    sizes.left += this.config.size >= 0 ? this.config.size : 200;
                }
                break;
            case "top":
                if (isColumnInCorner) {
                    sizes[this.config.halign] += this.config.size >= 0 ? this.config.size : 200;
                }
                else {
                    sizes.top += this.config.size >= 0 ? this.config.size : 40;
                }
                break;
            case "bottom":
                if (isColumnInCorner) {
                    sizes[this.config.halign] += this.config.size >= 0 ? this.config.size : 200;
                }
                else {
                    sizes.bottom += this.config.size >= 0 ? this.config.size : 40;
                }
                break;
        }
    };
    Legend.prototype.paint = function (width, height) {
        var _this = this;
        var getLegendAriaAttrs = function (item) { return ({
            role: "button",
            "aria-label": item.active ? "Hide chart ".concat(item.text) : "Show chart ".concat(item.text),
        }); };
        var data = this._getData();
        var config = this.config;
        config.$sizes = {
            width: 0,
            height: 0,
        };
        var positionX;
        var positionY;
        var font = (0, common_1.getFontStyle)("legend-text");
        var figureWidth = 10; // get Figure width from config ??
        var lineWidth = 500; // get Figure width from config ??
        var margin = config.margin, itemPadding = config.itemPadding;
        var svg = [];
        var isMid = config.valign === "middle";
        var xPadding = 0;
        var yPadding = 0;
        var xPaddingMax = 0;
        var yPaddingMax = 0;
        data.forEach(function (item, index) {
            if (!isMid && config.direction === "row") {
                var textWidth = (0, common_1.getTextWidth)(item.text, font);
                if (xPadding + textWidth + figureWidth * 1.5 > width && index !== 0) {
                    xPadding = 0;
                    yPadding += itemPadding + 2;
                }
            }
            svg.push((0, dom_1.sv)("g", __assign(__assign({ transform: "translate(".concat(xPadding, ",").concat(yPadding, ")"), onclick: [_this._handlers.onclick, item.id, _this.config.values], onkeyup: [_this._handlers.onkeyup, item.id, _this.config.values], class: "legend-item ".concat(!item.active ? "not-active" : "") }, getLegendAriaAttrs(item)), { tabindex: 0 }), [
                (0, dom_1.sv)("text", {
                    x: item.maxValue ? 0 : figureWidth / 2 + 5,
                    y: 0,
                    class: "start-text legend-text",
                }, [(0, common_1.verticalCenteredText)(item.text)]),
                [
                    (0, legend_1.legendShape)(config.form, item),
                    !isNaN(item.maxValue) && !isNaN(item.minValue) && (0, legend_1.legendTicks)(config.form, item),
                ],
            ]));
            var itemWidth = config.form !== "line" ? figureWidth * 1.5 + (0, common_1.getTextWidth)(item.text, font) : 0;
            if (!isMid && config.direction === "row") {
                xPadding += itemWidth + itemPadding;
                xPaddingMax = xPaddingMax > xPadding ? xPaddingMax : xPadding;
            }
            else {
                xPadding = 0;
                xPaddingMax = xPaddingMax > itemWidth ? xPaddingMax : itemWidth;
                yPadding += itemPadding + 2;
                yPaddingMax = yPaddingMax > yPadding ? yPaddingMax : yPadding;
            }
        });
        switch (config.valign) {
            case "top":
                if (config.direction === "row") {
                    positionY = -margin - yPadding - figureWidth / 2 - (config.form === "line" ? 15 : 0);
                }
                else {
                    positionY =
                        config.halign === "center"
                            ? -yPaddingMax + figureWidth / 2
                            : margin + figureWidth / 2;
                }
                break;
            case "middle":
                positionY = (height - yPaddingMax) / 2 + itemPadding / 2;
                break;
            case "bottom":
                if (config.direction === "row") {
                    positionY = height + (config.form !== "line" ? margin : 10);
                }
                else {
                    positionY =
                        height + figureWidth - (config.halign === "center" ? 0 : margin + yPaddingMax);
                }
                break;
        }
        switch (config.halign) {
            case "left":
                positionX = isMid
                    ? -xPaddingMax
                    : figureWidth / 2 - (config.direction === "row" ? 0 : config.size || 200);
                break;
            case "center":
                positionX = (width - xPaddingMax - (config.form === "line" ? lineWidth : 0)) / 2;
                break;
            case "right":
                if (isMid) {
                    positionX = width + margin + figureWidth / 2;
                }
                else if (config.direction === "row") {
                    positionX =
                        width -
                            xPaddingMax +
                            itemPadding +
                            (config.form === "line" ? -lineWidth - margin : figureWidth / 2);
                }
                else {
                    positionX = width + margin + figureWidth / 2;
                }
                break;
        }
        return (0, dom_1.sv)("g", {
            transform: "translate(".concat(positionX > 0 ? positionX : 0, ", ").concat(positionY, ")"),
            "aria-label": "Legend",
            tabindex: 0,
        }, svg);
    };
    Legend.prototype._getData = function () {
        var drawData = [];
        if (this.config.type === "scale") {
            var _a = this.config.values, color = _a.color, positiveColor = _a.positiveColor, negativeColor = _a.negativeColor, text = _a.text, minValue = _a.minValue, maxValue = _a.maxValue, tick = _a.tick, majorTick = _a.majorTick, step = _a.step, tickTemplate = _a.tickTemplate;
            var _b = this.setCriticals(), minValueCalc = _b[0], maxValueCalc = _b[1];
            drawData.push({
                id: (0, core_1.uid)(),
                text: text,
                alpha: 1,
                fill: color,
                minValue: minValue !== null && minValue !== void 0 ? minValue : minValueCalc,
                maxValue: maxValue !== null && maxValue !== void 0 ? maxValue : maxValueCalc,
                positiveColor: positiveColor,
                negativeColor: negativeColor,
                active: true,
                tick: tick,
                majorTick: majorTick,
                step: step,
                tickTemplate: tickTemplate,
            });
        }
        else if (this.config.values) {
            var text_1 = (0, common_1.locator)(this.config.values.text);
            var fill_1 = (0, common_1.locator)(this.config.values.color);
            this._data.map(function (item, index) {
                drawData.push({
                    id: item.id,
                    text: text_1(item).toString(),
                    alpha: 1,
                    fill: fill_1(item).toString() || (0, common_1.getDefaultColor)(index),
                    active: !item.$hidden,
                });
            });
        }
        else if (this.config.treeSeries) {
            var series = this.config.treeSeries;
            if (this.config.type === "groupName") {
                series.forEach(function (serie) {
                    drawData.push({
                        id: serie.id,
                        text: serie.name || serie.id,
                        alpha: 1,
                        fill: serie.color,
                        active: serie.active,
                    });
                });
            }
            else {
                var getText_1 = function (serie) {
                    if (serie.from && serie.to)
                        return "".concat(serie.from, " - ").concat(serie.to);
                    if (serie.less)
                        return "<= ".concat(serie.less);
                    if (serie.greater)
                        return ">= ".concat(serie.greater);
                };
                series.forEach(function (serie) {
                    drawData.push({
                        id: serie.id,
                        text: getText_1(serie),
                        alpha: 1,
                        fill: serie.color,
                        active: serie.active,
                    });
                });
            }
        }
        else {
            var series = this.config.$seriesInfo;
            for (var _i = 0, _c = series; _i < _c.length; _i++) {
                var serie = _c[_i];
                var _d = serie.config, fill = _d.fill, color = _d.color, id = _d.id, alpha = _d.alpha, active = _d.active, label = _d.label, value = _d.value;
                var useColor = fill && color;
                var text = label && typeof label === "function" ? label(serie.config) : label || value;
                drawData.push({
                    id: id,
                    text: text,
                    fill: fill || color,
                    color: useColor && color,
                    active: active,
                    alpha: alpha,
                });
            }
        }
        return drawData;
    };
    Legend.prototype.setCriticals = function () {
        var value = this.config.values.value;
        var min;
        var max;
        this._data.forEach(function (item) {
            if (item[value]) {
                min = !min || item[value] < min ? item[value] : min;
                max = !max || item[value] > max ? item[value] : max;
            }
        });
        max = Math.ceil(max / 10) * 10;
        min = Math.floor(min / 10) * 10;
        if (min === max)
            min -= 10;
        return [min, max];
    };
    return Legend;
}());
exports.Legend = Legend;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rightGrid = exports.right = exports.leftGrid = exports.left = exports.topGrid = exports.top = exports.bottomGrid = exports.bottom = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var defaultTextTemplate = function (item) { return item.toString(); };
var getScaleAriaAttrs = function (axis, text) { return ({
    role: "graphics-object",
    "aria-label": "".concat(axis, "-axis").concat(text ? ", " + text : ""),
}); };
function bottom(points, config, width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        extraTittlePadding = textPadding;
        var canRotate_1 = scaleRotate && !isNaN(scaleRotate);
        var y_1 = height + textPadding;
        text = points.map(function (p) {
            var x = p[0];
            var transform = canRotate_1 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y_1, ")") : "";
            var classList = ["scale-text", "top-text"];
            if (canRotate_1) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("bottom", angle));
            }
            return (0, dom_1.sv)("text", { x: x, y: y_1, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(template(p[1])),
            ]);
        });
    }
    var id = (0, core_1.uid)();
    var svTitle = null;
    var mainLine = (0, dom_1.sv)("path", {
        class: "main-scale",
        d: "M0 ".concat(height, " H").concat(width - 0.5),
        id: id,
    });
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: width / 2, dy: scalePadding + extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title " }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("x", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.bottom = bottom;
function bottomGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine, targetValue = config.targetValue;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "", " ").concat(!grid ? "hidden-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === 0 && !config.hidden) {
            continue;
        }
        if (i === targetLine) {
            var d_1 = "M".concat(points[i][0], " 0 V ").concat(height);
            var path_1 = (0, dom_1.sv)("path", { d: d_1, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path_1);
            continue;
        }
        var d = "M".concat(points[i][0], " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: className, _ref: "line" + Math.round(points[i][0]) });
        gridLines.push(path);
        if (i === len - 1 && points[i][0] !== width) {
            var additionD = "M".concat(width, " 0 V ").concat(height);
            var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
            gridLines.push(additionPath);
        }
    }
    if (targetValue) {
        var d = "M".concat(targetValue * width, " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
        gridLines.push(path);
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.bottomGrid = bottomGrid;
function top(points, config, width, _height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        extraTittlePadding = textPadding;
        var canRotate_2 = scaleRotate && !isNaN(scaleRotate);
        var y_2 = -textPadding;
        text = points.map(function (p) {
            var classList = ["scale-text"];
            var x = p[0];
            var transform = canRotate_2 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y_2, ")") : "";
            if (canRotate_2) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("top", angle));
            }
            return (0, dom_1.sv)("text", { x: x, y: y_2, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(template(p[1])),
            ]);
        });
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", { d: "M0 0 H".concat(width), class: "main-scale", id: id });
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: width / 2, dy: -scalePadding - extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("x", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.top = top;
function topGrid(points, _width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "", " ").concat(!grid ? "hidden-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === 0 && !config.hidden) {
            continue;
        }
        if (i === targetLine) {
            var d_2 = "M".concat(points[i][0], " 0 V ").concat(height);
            var path_2 = (0, dom_1.sv)("path", { d: d_2, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path_2);
            continue;
        }
        var d = "M".concat(points[i][0], " 0 V ").concat(height);
        var path = (0, dom_1.sv)("path", { d: d, class: className, _ref: "line" + Math.round(points[i][0]) });
        gridLines.push(path);
        if (i === len - 1 && points[i][0] !== 0) {
            var additionD = "M0 0 V ".concat(height);
            var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
            gridLines.push(additionPath);
        }
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.topGrid = topGrid;
function left(points, config, _width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        var style_1 = (0, common_1.getFontStyle)("scale-text");
        var maxTextWidth_1 = 0;
        var canRotate_3 = scaleRotate && !isNaN(scaleRotate);
        text = points.map(function (p) {
            var y = p[0];
            var x = -textPadding;
            var transform = canRotate_3 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y, ")") : "";
            var classList = ["scale-text"];
            var scaleText = template(p[1]);
            if (title) {
                var textWidth = (0, common_1.getTextWidth)(scaleText, style_1);
                if (maxTextWidth_1 < textWidth) {
                    maxTextWidth_1 = textWidth;
                }
            }
            if (canRotate_3) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("left", angle));
            }
            else {
                classList.push("end-text");
            }
            return (0, dom_1.sv)("text", { x: x, y: y, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(scaleText),
            ]);
        });
        extraTittlePadding = maxTextWidth_1 + textPadding;
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", {
        class: "main-scale",
        d: "M0 ".concat(height, " V 0.5"),
        id: id,
        _ref: points.length ? "line0" : null,
    }); // 0.5 instead of 0, coz stroke-linecap: square and dirrent stroke size
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: height / 2, dy: -scalePadding - extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("y", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.left = left;
function leftGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine, targetValue = config.targetValue;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === height && !config.hidden) {
            continue;
        }
        if (targetLine === i) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path);
            continue;
        }
        if (grid) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: className });
            gridLines.push(path);
            if (i === len - 1 && points[i][0] !== width) {
                var additionD = "M0 0 H".concat(width);
                var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
                gridLines.push(additionPath);
            }
        }
    }
    if (targetValue) {
        var d = "M0 ".concat(targetValue * height, " H ").concat(width);
        var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
        gridLines.push(path);
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.leftGrid = leftGrid;
function right(points, config, width, height) {
    var title = config.title, textPadding = config.textPadding, scalePadding = config.scalePadding, textTemplate = config.textTemplate, showText = config.showText, scaleRotate = config.scaleRotate;
    var template = textTemplate || defaultTextTemplate;
    var text = [];
    var extraTittlePadding = 0;
    if (showText) {
        var style_2 = (0, common_1.getFontStyle)("scale-text");
        var maxTextWidth_2 = 0;
        var canRotate_4 = scaleRotate && !isNaN(scaleRotate);
        text = points.map(function (p) {
            var scaleText = template(p[1]);
            var y = p[0];
            var x = width + textPadding;
            var transform = canRotate_4 ? "rotate(".concat(scaleRotate, " ").concat(x, " ").concat(y, ")") : "";
            var classList = ["scale-text"];
            if (title) {
                var textWidth = (0, common_1.getTextWidth)(scaleText, style_2);
                if (maxTextWidth_2 < textWidth) {
                    maxTextWidth_2 = textWidth;
                }
            }
            if (canRotate_4) {
                var angle = scaleRotate % 360;
                classList.push((0, common_1.getClassesForRotateScale)("right", angle));
            }
            else {
                classList.push("start-text");
            }
            return (0, dom_1.sv)("text", { x: x, y: y, class: classList.join(" "), transform: transform }, [
                (0, common_1.verticalCenteredText)(scaleText),
            ]);
        });
        extraTittlePadding = textPadding + maxTextWidth_2;
    }
    var id = (0, core_1.uid)();
    var mainLine = (0, dom_1.sv)("path", {
        d: "M".concat(width, " ").concat(height, " V 0"),
        class: "main-scale",
        id: id,
        _ref: points.length ? "line0" : null,
    });
    var svTitle = null;
    if (title) {
        svTitle = (0, dom_1.sv)("text", { dx: height / 2, dy: scalePadding + extraTittlePadding }, [
            (0, dom_1.sv)("textPath", { href: "#".concat(id), class: "scale-title" }, title),
        ]);
    }
    return (0, dom_1.sv)("g", __assign({}, getScaleAriaAttrs("y", title || config.text)), [mainLine, svTitle].concat(text));
}
exports.right = right;
function rightGrid(points, width, height, config) {
    var dashed = config.dashed, grid = config.grid, targetLine = config.targetLine;
    var len = points.length;
    var gridLines = [];
    var className = "grid-line ".concat(dashed ? "dash-line" : "");
    for (var i = 0; i < len; i++) {
        if (i === 0 && points[i][0] === height && !config.hidden) {
            continue;
        }
        if (targetLine === i) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: "".concat(className, " spec-grid-line") });
            gridLines.push(path);
            continue;
        }
        if (grid) {
            var d = "M0 ".concat(points[i][0], " H ").concat(width);
            var path = (0, dom_1.sv)("path", { d: d, class: className });
            gridLines.push(path);
            if (i === len - 1 && points[i][0] !== width) {
                var additionD = "M0 0 H".concat(width);
                var additionPath = (0, dom_1.sv)("path", { d: additionD, class: className });
                gridLines.push(additionPath);
            }
        }
    }
    return (0, dom_1.sv)("g", gridLines);
}
exports.rightGrid = rightGrid;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Area_1 = __webpack_require__(88);
var Bar_1 = __webpack_require__(90);
var BarX_1 = __webpack_require__(185);
var Donut_1 = __webpack_require__(186);
var Line_1 = __webpack_require__(60);
var Pie_1 = __webpack_require__(187);
var Pie3D_1 = __webpack_require__(188);
var Radar_1 = __webpack_require__(189);
var Scatter_1 = __webpack_require__(190);
var Spline_1 = __webpack_require__(191);
var SplineArea_1 = __webpack_require__(192);
var TreeMap_1 = __webpack_require__(193);
var CalendarHeatMap_1 = __webpack_require__(194);
var seriesTypes = {
    line: Line_1.default,
    spline: Spline_1.default,
    area: Area_1.default,
    splineArea: SplineArea_1.default,
    scatter: Scatter_1.default,
    pie: Pie_1.default,
    pie3D: Pie3D_1.default,
    donut: Donut_1.default,
    radar: Radar_1.default,
    bar: Bar_1.default,
    xbar: BarX_1.default,
    treeMap: TreeMap_1.default,
    calendarHeatMap: CalendarHeatMap_1.default,
};
exports.default = seriesTypes;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var ScaleSeria_1 = __webpack_require__(58);
var Area = /** @class */ (function (_super) {
    __extends(Area, _super);
    function Area() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Area.prototype.paint = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        var svg = [];
        this._form(width, height, svg, prev);
        this._markers(svg);
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Area.prototype.paintformAndMarkers = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var svg = [];
        var markers = [];
        this._form(width, height, svg, prev);
        this._markers(markers);
        return [
            (0, dom_1.sv)("g", { class: "seria", _key: this.id }, svg),
            (0, dom_1.sv)("g", { class: "seria_markers", _key: this.id + "_markers" }, markers),
        ];
    };
    Area.prototype._markers = function (svg) {
        var _this = this;
        if (this.config.pointType) {
            var color = this.config.pointColor || this.config.color;
            var point_1 = this._getPointType(this.config.pointType, color);
            svg.push.apply(svg, this._points.map(function (p) { return point_1(p[0], p[1], (0, common_1.calcPointRef)(p[2], _this.id)); }));
        }
    };
    Area.prototype._form = function (width, height, svg, prev) {
        var _a = this.config, id = _a.id, fill = _a.fill, alpha = _a.alpha, color = _a.color, strokeWidth = _a.strokeWidth;
        var points = this._points;
        var last = points[points.length - 1];
        var d = "";
        if (prev) {
            // bottom line in stacked area
            for (var i = prev.length - 1; i >= 0; i--) {
                var item = prev[i];
                d += i === points.length - 1 ? "M".concat(item[0], " ").concat(item[1], " ") : "L".concat(item[0], " ").concat(item[1], " ");
            }
            // top line in stacked area
            d +=
                points.map(function (item, index) { return (!index ? "V ".concat(item[1]) : "L ".concat(item[0], " ").concat(item[1])); }).join(" ") +
                    "Z";
        }
        else {
            d +=
                points
                    .map(function (item, index) {
                    return index ? "L".concat(item[0], " ").concat(item[1]) : "M0 ".concat(height, " L0 ").concat(item[1], " L").concat(item[0], " ").concat(item[1]);
                })
                    .join(" ") + "L".concat(width, " ").concat(last[1], " V ").concat(height);
        }
        if (strokeWidth) {
            var len_1 = points.length - 1;
            var strokePadding_1 = function (index) { return (index === len_1 ? -0.5 : index ? 0 : 0.5); };
            var line = points
                .map(function (item, index) {
                return index
                    ? "L".concat(item[0] + strokePadding_1(index), " ").concat(item[1])
                    : "M0 ".concat(item[1], " L0 ").concat(item[1] + strokePadding_1(index), " L").concat(item[0] +
                        strokePadding_1(index), " ").concat(item[1]);
            })
                .join(" ") + "L".concat(width, " ").concat(last[1]);
            var linePath = (0, dom_1.sv)("path", {
                d: line,
                "stroke-width": strokeWidth,
                stroke: color,
                fill: "none",
                class: this._getCss(),
            });
            svg.push(linePath);
        }
        var path = (0, dom_1.sv)("path", {
            id: "seria" + id,
            d: d,
            class: this._getCss(),
            fill: fill,
            _ref: id,
            "fill-opacity": alpha,
            stroke: "none",
        });
        svg.push(path);
        return svg;
    };
    Area.prototype._setDefaults = function (config) {
        var defaults = {
            alpha: 0.3,
            strokeWidth: 2,
            fill: config.color || "#5E83BA",
            color: "#5E83BA",
            active: true,
            tooltip: true,
            pointType: "empty",
        };
        this.config = __assign(__assign({}, defaults), config);
        var point = this.config.pointType;
        var color = this.config.pointColor || this.config.color;
        if (point) {
            this._drawPointType = this._getPointType(point, color);
        }
    };
    return Area;
}(ScaleSeria_1.default));
exports.default = Area;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getShadeHTMLHelper = exports.getShadeHelper = exports.getHTMLHelper = exports.getHelper = void 0;
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var forms = {
    circle: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            cx: x,
            cy: y,
            r: 4,
            class: "figure point-circle",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("circle", config);
    },
    rect: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            x: x - 4,
            y: y - 4,
            width: 8,
            height: 8,
            class: "figure point-rect",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("rect", config);
    },
    rhombus: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            points: "".concat(x - 5, ",").concat(y, " ").concat(x, ",").concat(y + 5, " ").concat(x + 5, ",").concat(y, " ").concat(x, ",").concat(y - 5),
            class: "figure point-rhombus",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("polygon", config);
    },
    triangle: function (color, fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            points: "".concat(x, ",").concat(y - 5, " ").concat(x + 5, ",").concat(y + 5, " ").concat(x - 5, ",").concat(y + 5),
            class: "figure point-triangle",
            fill: fill,
            stroke: color,
            "stroke-width": 2,
        };
        return (0, dom_1.sv)("polygon", config);
    },
    simpleCircle: function (color, _fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            cx: x,
            cy: y,
            r: 3,
            class: "figure point-simple-circle",
            fill: color,
        };
        return (0, dom_1.sv)("circle", config);
    },
    simpleRect: function (color, _fill, _alpha, x, y, id) {
        var config = {
            _ref: id,
            x: x - 3,
            y: y - 3,
            width: 6,
            height: 6,
            class: "figure point-simple-rect",
            fill: color,
        };
        return (0, dom_1.sv)("rect", config);
    },
    empty: function () {
        return null;
    },
};
var formsHTML = {
    circle: function (color, fill, _alpha, x, y, id) {
        return "<circle class=\"figure point-circle\" _ref=\"".concat(id, "\" cx=\"").concat(x, "\" cy=\"").concat(y, "\" r=\"4\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    rect: function (color, fill, _alpha, x, y, id) {
        return "<rect _ref=\"".concat(id, "\" x=\"").concat(x - 4, "\" y=\"").concat(y -
            4, "\" width=\"8\" height=\"8\" class=\"figure point-rect\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    rhombus: function (color, fill, _alpha, x, y, id) {
        return "<polygon _ref=\"".concat(id, "\" points=\"").concat(x - 5, ",").concat(y, " ").concat(x, ",").concat(y + 5, " ").concat(x + 5, ",").concat(y, " ").concat(x, ",").concat(y -
            5, "\" class=\"figure point-rhombus\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    triangle: function (color, fill, _alpha, x, y, id) {
        return "<polygon _ref=\"".concat(id, "\" points=\"").concat(x, ",").concat(y - 5, " ").concat(x + 5, ",").concat(y + 5, " ").concat(x - 5, ",").concat(y +
            5, "\" class=\"figure point-triangle\" fill=\"").concat(fill, "\" stroke=\"").concat(color, "\" stroke-width=\"2\"/>");
    },
    simpleCircle: function (color, _fill, _alpha, x, y, id) {
        return "<circle _ref=\"".concat(id, "\" cx=\"").concat(x, "\" cy=\"").concat(y, "\" r=\"3\" class=\"figure point-simple-circle\" fill=\"").concat(color, "\"/>");
    },
    simpleRect: function (color, _fill, _alpha, x, y, id) {
        return "<rect _ref=\"id\" x=\"".concat(x - 3, "\" y=\"").concat(y -
            3, "\" width=\"6\" height=\"6\" class=\"figure point-simple-rect\" fill=\"").concat(color, "\"/>");
    },
    empty: function () {
        return null;
    },
};
function getHelper(type) {
    var helper = forms[type.toString()];
    if (!helper) {
        throw new Error("unknown point type");
    }
    return helper;
}
exports.getHelper = getHelper;
function getHTMLHelper(type) {
    var helper = formsHTML[type.toString()];
    if (!helper) {
        throw new Error("unknown point type");
    }
    return helper;
}
exports.getHTMLHelper = getHTMLHelper;
function getShadeHelper(type, color) {
    var helper = getHelper(type);
    color = color || "none";
    var shade = (0, common_1.getColorShade)(color, 0.2);
    return function (x, y, id) {
        return helper(color, shade, "", x, y, id);
    };
}
exports.getShadeHelper = getShadeHelper;
function getShadeHTMLHelper(type, color) {
    var helper = getHTMLHelper(type);
    color = color || "none";
    var shade = (0, common_1.getColorShade)(color, 0.2);
    return function (x, y, id) {
        return helper(color, shade, "", x, y, id);
    };
}
exports.getShadeHTMLHelper = getShadeHTMLHelper;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var common_1 = __webpack_require__(7);
var ScaleSeria_1 = __webpack_require__(58);
var Bar = /** @class */ (function (_super) {
    __extends(Bar, _super);
    function Bar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._shift = 0;
        return _this;
    }
    Bar.prototype.addScale = function (type, scale) {
        _super.prototype.addScale.call(this, type, scale);
        scale.addPadding();
    };
    Bar.prototype.seriesShift = function (shift) {
        this._shift = shift;
        return this.config.barWidth;
    };
    Bar.prototype.paint = function (width, height, prev) {
        _super.prototype.paint.call(this, width, height);
        var getChartAriaAttrs = function (cfg) { return ({
            "aria-label": "chart ".concat(cfg.value || ""),
        }); };
        if (!this.config.active) {
            return null;
        }
        var svg = [];
        if (this._gradient) {
            svg.push((0, dom_1.sv)("defs", [this._gradient()]));
        }
        var form = this._getForm(this._points, width, height, prev);
        svg = svg.concat(form);
        return (0, dom_1.sv)("g", __assign(__assign({ class: "seria", _key: this.id }, getChartAriaAttrs(this.config)), { tabindex: 0 }), svg);
    };
    Bar.prototype.getTooltipType = function (_id, _x, y) {
        if (this.config.baseLine !== undefined && this._baseLinePosition < y) {
            return "bot";
        }
        return "top";
    };
    Bar.prototype._getClosestDist = function (x, y, px, py) {
        if (this.config.stacked && y < py) {
            return Infinity;
        }
        return Math.abs(x - px);
    };
    Bar.prototype._path = function (item, prev) {
        item[0] += this._shift;
        return "\nM ".concat(item[0] - this.config.barWidth / 2, " ").concat(prev, "\nV ").concat(item[1], "\nh ").concat(this.config.barWidth, "\nV ").concat(prev);
    };
    Bar.prototype._base = function (height) {
        var baseLine = this.config.baseLine;
        return (this._baseLinePosition =
            baseLine !== undefined ? this.yScale.point(baseLine) * height : height - 1);
    };
    Bar.prototype._text = function (item, prev, rotate) {
        var x = item[0];
        var y = (prev + item[1]) / 2;
        var canRotate = rotate && !isNaN(rotate);
        return {
            x: x,
            y: y,
            class: "bar-text",
            transform: canRotate ? "rotate(".concat(rotate, " ").concat(x, " ").concat(y, ")") : "",
        };
    };
    Bar.prototype._getForm = function (points, _width, height, prev) {
        var _this = this;
        var getPointAriaLabel = function (barType, item, baseLine) {
            if (baseLine === void 0) { baseLine = 0; }
            var x = item[3];
            var yStart = baseLine;
            var yEnd = item[4];
            if (baseLine > yEnd) {
                yStart = yEnd;
                yEnd = baseLine;
            }
            return barType === "xbar"
                ? "bar y=".concat(x, ", x from ").concat(yStart, " to ").concat(yEnd)
                : "bar x=".concat(x, ", y from ").concat(yStart, " to ").concat(yEnd);
        };
        var getPointAriaAttrs = function (barType, item, baseLine) { return ({
            role: "graphics-symbol",
            "aria-roledescription": "bar",
            "aria-label": getPointAriaLabel(barType, item, baseLine),
        }); };
        var _a = this.config, baseLine = _a.baseLine, fill = _a.fill, alpha = _a.alpha, showText = _a.showText, showTextTemplate = _a.showTextTemplate, showTextRotate = _a.showTextRotate;
        var svg = [];
        var base = this._base(height);
        var getPrev = function (index) { return (!prev ? base : prev[index][1]); };
        var series = points.map(function (item, index) {
            return (0, dom_1.sv)("path", __assign(__assign({ _key: "seria" + _this.config.id + index, _ref: (0, common_1.calcPointRef)(item[2], _this.config.id), d: _this._path(item, getPrev(index)), class: _this._getCss(), fill: fill, onclick: [_this._handlers.onclick, item[2], _this.config.value], onmousemove: [_this._handlers.onmousemove, item[2], _this.config.id], onmouseleave: [_this._handlers.onmouseleave, item[2], _this.config.id], "fill-opacity": alpha }, getPointAriaAttrs(_this.config.type, item, baseLine)), { tabindex: 0 }));
        });
        svg.push.apply(svg, series);
        if ((showText || showTextTemplate || showTextRotate) && showText !== false) {
            var isWrite_1 = function (item, index) { return Math.abs(getPrev(index) - item[1]) > 16; }; // hide text, where height < 16
            var text = points.map(function (item, index) {
                var value = _this._getText(item);
                return isWrite_1(item, index)
                    ? (0, dom_1.sv)("text", __assign(__assign({}, _this._text(item, getPrev(index), showTextRotate)), { "aria-hidden": "true" }), [
                        showTextTemplate
                            ? (0, common_1.verticalCenteredText)(showTextTemplate(value))
                            : (0, common_1.verticalCenteredText)(value),
                    ])
                    : null;
            });
            svg.push.apply(svg, text);
        }
        return svg;
    };
    Bar.prototype._getText = function (item) {
        return item[4].toString();
    };
    Bar.prototype._setDefaults = function (config) {
        var defaults = {
            barWidth: 30,
            alpha: 1,
            active: true,
            tooltip: true,
            pointType: "empty",
        };
        this.config = __assign(__assign({}, defaults), config);
        var point = this.config.pointType;
        var color = this.config.pointColor || this.config.color;
        if (point) {
            this.config.pointType = point;
            this._drawPointType = this._getPointType(point, color);
        }
        if (this.config.gradient) {
            var id_1 = "gradient" + (0, core_1.uid)();
            var gradient_1 = this.config.gradient(this.config.fill);
            this._gradient = function () { return (0, common_1.linearGradient)(gradient_1, id_1); };
            this.config.fill = "url(#".concat(id_1, ")");
        }
    };
    return Bar;
}(ScaleSeria_1.default));
exports.default = Bar;


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
function spline(initPoints, link) {
    var len = initPoints.length;
    var points;
    if (len < 3) {
        points = initPoints;
    }
    else {
        var p0 = initPoints[0];
        var p1 = initPoints[0];
        var p2 = initPoints[1];
        var p3 = initPoints[2];
        points = [initPoints[0].slice(0, 2)];
        for (var i = 1; i < len; i++) {
            points.push([
                (-p0[0] + 6 * p1[0] + p2[0]) / 6,
                (-p0[1] + 6 * p1[1] + p2[1]) / 6,
                (p1[0] + 6 * p2[0] - p3[0]) / 6,
                (p1[1] + 6 * p2[1] - p3[1]) / 6,
                p2[0],
                p2[1],
            ]);
            p0 = p1;
            p1 = p2;
            p2 = p3;
            p3 = initPoints[i + 2] || p3;
        }
    }
    var d = "";
    for (var i = 0; i < points.length; i++) {
        var point = points[i];
        var n = point.length;
        if (!i) {
            d += link ? "L" : "M";
            d += n === 5 ? "".concat(point[0], " ").concat(point[1]) : "".concat(point[n - 2], " ").concat(point[n - 1]);
        }
        else if (n > 5) {
            d += "C".concat(point[0], " ").concat(point[1], "\n\t\t\t\t").concat(point[2], " ").concat(point[3], "\n\t\t\t\t").concat(point[4], " ").concat(point[5]);
        }
        else if (n === 5) {
            d += "L".concat(point[0], " ").concat(point[1]);
        }
        else {
            d += "S".concat(point[0], " ").concat(point[1], "\n\t\t\t\t").concat(point[2], " ").concat(point[3]);
        }
    }
    return d;
}
exports.default = spline;


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var dom_1 = __webpack_require__(0);
var Stacker = /** @class */ (function () {
    function Stacker() {
        this._series = [];
    }
    Stacker.prototype.add = function (seria) {
        this._series.push(seria);
    };
    Stacker.prototype.dataReady = function (prev) {
        this._toPaint = this._series.filter(function (serie) {
            var next = serie.dataReady(prev);
            if (next.length) {
                prev = next;
                return true;
            }
            return false;
        });
        return prev || [];
    };
    Stacker.prototype.getPoints = function () {
        if (this._toPaint.length) {
            return this._toPaint[0].getPoints().concat(this._toPaint[this._toPaint.length - 1].getPoints());
        }
        return [];
    };
    Stacker.prototype.paint = function (width, height, prev) {
        var svg = [];
        var markers = [];
        this._toPaint.forEach(function (seria) {
            if (seria.paintformAndMarkers) {
                var _a = seria.paintformAndMarkers(width, height, prev), content = _a[0], seriesMarkers = _a[1];
                svg.push(content);
                markers.push(seriesMarkers);
            }
            else {
                var content = seria.paint(width, height, prev);
                svg.push(content);
            }
            prev = seria.getPoints();
        });
        return (0, dom_1.sv)("g", svg.concat(markers));
    };
    return Stacker;
}());
exports.default = Stacker;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Combobox = exports.$template = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var html_1 = __webpack_require__(2);
var keycodes_1 = __webpack_require__(198);
var view_1 = __webpack_require__(9);
var ts_data_1 = __webpack_require__(4);
var ts_layout_1 = __webpack_require__(13);
var ts_list_1 = __webpack_require__(38);
var ts_popup_1 = __webpack_require__(15);
var keyListener_1 = __webpack_require__(199);
var en_1 = __webpack_require__(61);
var types_1 = __webpack_require__(29);
var helper_1 = __webpack_require__(94);
var types_2 = __webpack_require__(95);
function itemsCountTemplate(count, templateFN) {
    if (typeof templateFN === "function") {
        return templateFN(count);
    }
    else {
        return count + " " + en_1.default.selectedItems;
    }
}
var $template = function (item) {
    if (item.icon) {
        return (0, dom_1.el)("div.dhx_combobox-options-wrapper", [
            (0, dom_1.el)("span", { class: "".concat(item.icon, " dhx_combobox-options__icon") }),
            (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value),
        ]);
    }
    if (item.src) {
        return (0, dom_1.el)("div.dhx_combobox-options-wrapper", [
            (0, dom_1.el)("img", { class: "dhx_combobox-options__image", alt: item.value, src: item.src }),
            (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value),
        ]);
    }
    return (0, dom_1.el)("span", { class: "dhx_combobox-options__value" }, item.value);
};
exports.$template = $template;
var Combobox = /** @class */ (function (_super) {
    __extends(Combobox, _super);
    function Combobox(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            listHeight: 224,
            disabled: false,
            readOnly: false,
            newOptions: false,
            htmlEnable: true,
        }, config)) || this;
        _this.config.itemsCount = _this.config.itemsCount || _this.config.showItemsCount; // TODO: remove suite_7.0
        _this.config.helpMessage = _this.config.helpMessage || _this.config.help; // TODO: remove suite_7.0
        if (_this.config.cellHeight && _this.config.itemHeight === 36) {
            _this.config.itemHeight = _this.config.cellHeight; // TODO: remove suite_7.0
        }
        if (_this.config.labelInline) {
            _this.config.labelPosition = "left"; // TODO: remove suite_7.0
        }
        if (Array.isArray(_this.config.data)) {
            _this.events = new events_1.EventSystem(_this);
            _this.data = new ts_data_1.DataCollection({});
            _this.data.parse(_this.config.data);
        }
        else if (_this.config.data) {
            _this.data = _this.config.data;
            _this.events = new events_1.EventSystem(_this);
            _this.events.context = _this;
        }
        else {
            _this.events = new events_1.EventSystem(_this);
            _this.data = new ts_data_1.DataCollection({});
        }
        _this.popup = new ts_popup_1.Popup();
        _this.popup.events.on(ts_popup_1.PopupEvents.afterShow, function () {
            _this.paint();
        });
        _this.popup.events.on(ts_popup_1.PopupEvents.afterHide, function () {
            if (_this.config.multiselection) {
                _this._state.value = "";
            }
            _this.paint();
        });
        _this.popup.events.on(ts_popup_1.PopupEvents.beforeHide, function (fromOuterClick) {
            fromOuterClick && _this._hideOptions();
        });
        if (_this.config.readonly || _this.config.readOnly) {
            _this.config.readOnly = _this.config.readOnly || _this.config.readonly;
            _this._keyListener = new keyListener_1.KeyListener();
        }
        _this._state = {
            value: "",
            ignoreNext: false,
            canDelete: false,
            unselectActive: false,
            currentState: types_2.ComboState.default,
            creatingState: false,
        };
        _this._initHandlers();
        _this._createLayout();
        if (_this.config.value && _this.data.getLength()) {
            _this._setValue(_this.config.value, true);
            _this.config.value = "";
        }
        _this._initEvents();
        var vnode = (0, dom_1.create)({
            render: function () { return _this._draw(); },
            hooks: {
                didRedraw: function () {
                    if (_this.popup.isVisible()) {
                        _this.focus();
                        _this._configurePopup();
                    }
                },
            },
        });
        // const container = toNode(element);
        _this.mount(element, vnode);
        return _this;
    }
    Combobox.prototype.focus = function () {
        if (this.config.disabled)
            return false;
        var rootView = this.getRootView();
        rootView.refs.input.el.focus();
    };
    Combobox.prototype.blur = function () {
        if (this.config.disabled)
            return false;
        var rootView = this.getRootView();
        rootView.refs.input.el.blur();
        this.popup.hide();
    };
    Combobox.prototype.enable = function () {
        this.config.disabled = false;
        this.paint();
    };
    Combobox.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Combobox.prototype.isDisabled = function () {
        return this.config.disabled;
    };
    Combobox.prototype.clear = function () {
        this.list.selection.remove();
        this._state.value = "";
        this._filter();
        this.paint();
    };
    Combobox.prototype.getValue = function (asArray) {
        var ids = this.list.selection.getId();
        if (asArray) {
            return (0, core_1.wrapBox)(ids);
        }
        return Array.isArray(ids) ? ids.join(",") : ids;
    };
    Combobox.prototype.setValue = function (ids, silent) {
        return this._setValue(ids, silent);
    };
    Combobox.prototype.addOption = function (value, join) {
        if (join === void 0) { join = true; }
        if (!value)
            return;
        var id;
        if (typeof value === "string") {
            id = this.data.add({ value: value });
        }
        else if (typeof value === "object") {
            id = this.data.add(value);
        }
        var options = this.config.multiselection && join ? __spreadArray(__spreadArray([], this.list.selection.getId(), true), [id], false) : id;
        this.setValue(options);
    };
    Combobox.prototype.destructor = function () {
        this.popup && this.popup.destructor();
        this.events && this.events.clear();
        this.list && this.list.destructor();
        this._helper && this._helper.destructor();
        this._layout && this._layout.destructor();
        this._keyListener && this._keyListener.destructor();
        this.config = this.events = this.list = this.popup = null;
        this._helper = this._keyListener = this._handlers = this._state = this._uid = this._isPopupConfiqureted = null;
        this.unmount();
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Combobox.prototype.setState = function (state) {
        switch (state) {
            case "success":
                this._state.currentState = types_2.ComboState.success;
                break;
            case "error":
                this._state.currentState = types_2.ComboState.error;
                break;
            default:
                this._state.currentState = types_2.ComboState.default;
                break;
        }
        this.paint();
    };
    Combobox.prototype._setValue = function (ids, silent) {
        var _this = this;
        if (silent === void 0) { silent = false; }
        if (!this._exsistId(ids)) {
            return false;
        }
        this._filter();
        this.list.selection.remove(null, silent);
        if (this.config.multiselection) {
            if (typeof ids === "string") {
                ids = ids.split(",");
            }
            if (typeof ids === "number") {
                ids = [ids];
            }
            ids.forEach(function (id) {
                _this.list.selection.add(id, false, false, silent);
            });
        }
        else {
            var id = (0, core_1.unwrapBox)(ids);
            this.list.selection.add(id, false, false, silent);
            var item = this.data.getItem(id);
            if (item) {
                this._state.value = this._getItemText(item);
            }
        }
        this.paint();
    };
    Combobox.prototype._createLayout = function () {
        var list = (this.list = new ts_list_1.List(null, {
            $template: exports.$template,
            template: this.config.template,
            htmlEnable: this.config.htmlEnable,
            virtual: this.config.virtual,
            keyNavigation: true,
            multiselection: this.config.multiselection,
            itemHeight: this.config.itemHeight,
            height: this.config.listHeight,
            data: this.data,
            eventHandlers: this.config.eventHandlers,
        }));
        var layout = (this._layout = new ts_layout_1.Layout(this.popup.getContainer(), {
            css: "dhx_combobox-options dhx_combobox__options",
            rows: [
                {
                    id: "select-unselect-all",
                    hidden: !this.config.multiselection || !this.config.selectAllButton,
                },
                { id: "list", height: "content" },
                {
                    id: "not-found",
                    hidden: true,
                },
            ],
            on: {
                click: {
                    ".dhx_combobox__action-select-all": this._handlers.selectAll,
                    ".dhx_combobox-options__action-create-option": this._handlers.addOption,
                },
            },
        }));
        layout.getCell("list").attach(list);
        if (this.config.multiselection && this.config.selectAllButton) {
            layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
        }
    };
    Combobox.prototype._initHandlers = function () {
        var _this = this;
        if (this.config.helpMessage) {
            this._helper = new ts_popup_1.Popup({
                css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
            });
            this._helper.attachHTML(this.config.helpMessage);
        }
        this._handlers = {
            addOption: function () { return _this.addOption(_this._state.value); },
            showHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            },
            selectAll: function () {
                if (_this._state.unselectActive) {
                    _this.list.selection.remove();
                    if (_this.config.selectAllButton) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                        _this._state.unselectActive = false;
                    }
                }
                else {
                    _this.data.filter();
                    _this.list.selection.add();
                    if (_this.config.selectAllButton) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.unselectAllView);
                        _this._state.unselectActive = true;
                    }
                }
                _this._changePopupPosition();
                _this.paint();
            },
            onkeydown: function (e) {
                if (e.key === "Tab" && _this.popup.isVisible()) {
                    _this._hideOptions();
                }
                else {
                    if (!_this.popup.isVisible() && e.which === keycodes_1.KEY_CODES.DOWN_ARROW) {
                        _this._showOptions();
                    }
                    if (_this.popup.isVisible()) {
                        if (e.which === keycodes_1.KEY_CODES.RIGHT_ARROW) {
                            if (_this.config.readOnly && !_this.config.multiselection) {
                                _this.list.moveFocus(ts_list_1.MOVE_DOWN);
                                e.preventDefault();
                            }
                        }
                        if (e.which === keycodes_1.KEY_CODES.LEFT_ARROW) {
                            if (_this.config.readOnly && !_this.config.multiselection) {
                                _this.list.moveFocus(ts_list_1.MOVE_UP);
                                e.preventDefault();
                            }
                        }
                        if (e.which === keycodes_1.KEY_CODES.DOWN_ARROW) {
                            _this.list.moveFocus(ts_list_1.MOVE_DOWN);
                            e.preventDefault();
                        }
                        if (e.which === keycodes_1.KEY_CODES.UP_ARROW) {
                            _this.list.moveFocus(ts_list_1.MOVE_UP);
                            e.preventDefault();
                        }
                        if (e.which === keycodes_1.KEY_CODES.ESC) {
                            _this._hideOptions();
                        }
                        if (e.which === keycodes_1.KEY_CODES.ENTER) {
                            if (_this.data.getLength()) {
                                var id = _this.list.getFocus();
                                var value = _this.config.multiselection
                                    ? __spreadArray(__spreadArray([], _this.list.selection.getId(), true), [id], false) : id;
                                _this.setValue(value);
                            }
                            else if (_this.config.newOptions) {
                                _this.addOption(_this._state.value, true);
                            }
                            if (_this.config.multiselection) {
                                _this._updatePopup();
                            }
                            else if (_this.data.getLength()) {
                                _this._hideOptions();
                            }
                        }
                    }
                }
                _this.events.fire(types_2.ComboboxEvents.keydown, [e, _this.list.getFocus()]);
            },
            onkeyup: function (e) {
                if (!_this.config.multiselection || _this.config.itemsCount) {
                    return;
                }
                if (_this._state.ignoreNext) {
                    _this._state.ignoreNext = false;
                    return;
                }
                if (e.which === keycodes_1.KEY_CODES.BACKSPACE &&
                    !_this._state.value &&
                    _this.config.multiselection &&
                    _this.list.selection.getId().length) {
                    var selected = _this.list.selection.getId();
                    var id = selected[selected.length - 1];
                    _this.list.selection.remove(id);
                    _this._changePopupPosition();
                    _this.paint();
                }
            },
            oninput: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                var input = e.target;
                var value = input.value;
                _this.events.fire(types_2.ComboboxEvents.input, [value]);
                _this._state.value = value;
                if (!value.length) {
                    _this._state.ignoreNext = true;
                    _this._state.canDelete = true;
                }
                else {
                    _this._state.canDelete = false;
                }
                if (!_this.config.multiselection) {
                    _this.list.selection.remove();
                }
                _this._filter(true);
                if (!_this.popup.isVisible()) {
                    _this._showOptions();
                }
                _this._updatePopup();
            },
            oninputclick: function (e) {
                var _a;
                if (_this.config.disabled) {
                    return;
                }
                _this.focus();
                if (e.target.classList.contains("dhx_combobox__action-remove")) {
                    var id = (_a = _this.data.getItem((0, html_1.locate)(e))) === null || _a === void 0 ? void 0 : _a.id;
                    if (!(0, core_1.isId)(id)) {
                        return;
                    }
                    _this.list.selection.remove(id);
                    _this._changePopupPosition();
                    _this.paint();
                    return;
                }
                if (e.target.classList.contains("dhx_combobox__action-clear-all")) {
                    _this.list.selection.getId().forEach(function (id) { return _this.list.selection.remove(id); });
                    if (_this.config.selectAllButton && _this._state.unselectActive) {
                        _this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                        _this._state.unselectActive = false;
                    }
                    _this.paint();
                    return;
                }
                e.preventDefault();
                if (!_this.popup.isVisible()) {
                    _this._showOptions();
                    return;
                }
                _this.focus();
            },
            toggleIcon: function () {
                _this.focus();
                if (_this.popup.isVisible()) {
                    _this._hideOptions();
                }
                else {
                    _this._showOptions();
                }
            },
            onfocus: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_2.ComboboxEvents.focus, []); },
            onblur: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_2.ComboboxEvents.blur, []); },
        };
    };
    Combobox.prototype._initEvents = function () {
        var _this = this;
        this.data.events.on(ts_data_1.DataEvents.load, function () {
            if (_this.config.value) {
                _this._setValue(_this.config.value, true);
                _this.config.value = "";
            }
            if (_this.popup.isVisible()) {
                _this._filter();
            }
        });
        this.data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._state.value = "";
            _this.paint();
        });
        this.data.events.on(ts_data_1.DataEvents.afterAdd, function () {
            if (!_this.popup.isVisible())
                return;
            if (!_this.config.multiselection) {
                _this._hideOptions();
            }
            else {
                _this._changePopupPosition();
            }
        });
        this.list.events.on(ts_list_1.ListEvents.click, function () {
            if (!_this.config.multiselection) {
                _this._hideOptions();
            }
            _this._changePopupPosition();
        });
        this.list.selection.events.on(types_1.SelectionEvents.beforeSelect, function (id) {
            var value = _this.config.multiselection
                ? __spreadArray(__spreadArray([], _this.getValue(_this.config.multiselection), true), [id], false) : id;
            return _this.events.fire(types_2.ComboboxEvents.beforeChange, [value]);
        });
        this.list.selection.events.on(types_1.SelectionEvents.afterSelect, function () {
            var value = _this.getValue(_this.config.multiselection);
            _this.events.fire(types_2.ComboboxEvents.change, [value]);
            _this._updateSelectedItem(value);
        });
        this.list.selection.events.on(types_1.SelectionEvents.beforeUnSelect, function (id) {
            var value = _this.config.multiselection
                ? _this.getValue(_this.config.multiselection).filter(function (i) { return i != id; })
                : id;
            return _this.events.fire(types_2.ComboboxEvents.beforeChange, [value]);
        });
        this.list.selection.events.on(types_1.SelectionEvents.afterUnSelect, function () {
            var multi = _this.config.multiselection;
            var value = _this.getValue(multi);
            _this.events.fire(types_2.ComboboxEvents.change, [value]);
            if (multi)
                _this._updateSelectedItem(value);
        });
        this.popup.events.on(ts_popup_1.PopupEvents.beforeShow, function () {
            if (!_this.popup.isVisible() && !_this._isPopupConfiqureted) {
                _this._configurePopup();
                return false;
            }
        });
        this.popup.events.on(ts_popup_1.PopupEvents.afterShow, function () {
            var _a;
            if ((_a = _this.list.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable) {
                _this.list.scrollView.update();
            }
            if (_this.config.readOnly) {
                if (_this._state.value) {
                    var id = _this.list.selection.getId();
                    _this.list.setFocus(id);
                }
                else {
                    _this.list.resetFocus();
                }
                _this._keyListener.startNewListen(function (val) { return _this._findBest(val); });
            }
            _this.list.scrollTo(_this.list.getFocus());
        });
    };
    Combobox.prototype._showOptions = function () {
        if (!this.events.fire(types_2.ComboboxEvents.beforeOpen)) {
            return;
        }
        if (this._state.value.length) {
            this._state.canDelete = true;
        }
        this._filter();
        if (this._configurePopup()) {
            this.events.fire(types_2.ComboboxEvents.open);
            this.events.fire(types_2.ComboboxEvents.afterOpen);
        }
    };
    Combobox.prototype._configurePopup = function () {
        this._isPopupConfiqureted = true;
        var rootView = this.getRootView();
        if (!rootView || !rootView.refs || !rootView.refs.holder) {
            return false;
        }
        if (!this.popup.isVisible()) {
            this._updatePopup();
        }
        return true;
    };
    Combobox.prototype._hideOptions = function () {
        var _this = this;
        if (!this.events.fire(types_2.ComboboxEvents.beforeClose)) {
            return;
        }
        if (this.config.readOnly) {
            this._keyListener.endListen();
        }
        if (!this.config.multiselection && !this.config.readOnly && !this.list.selection.contains()) {
            this._state.value = "";
        }
        (0, dom_1.awaitRedraw)().then(function () { return _this.popup.isVisible() && _this.popup.hide(); });
        this.events.fire(types_2.ComboboxEvents.afterClose);
        this.events.fire(types_2.ComboboxEvents.close); // TODO: remove suite_7.0
        this.data.resetFilter();
        this._filter();
        this.paint();
    };
    Combobox.prototype._filter = function (baseFilter) {
        var _this = this;
        if (baseFilter === void 0) { baseFilter = false; }
        if (this.config.readOnly) {
            return;
        }
        if (this.config.filter) {
            this.data.filter(function (item) { return _this.config.filter(item, _this._state.value); });
        }
        else if (baseFilter) {
            this.data.filter(function (item) { return (0, core_1.isExistValue)(_this._getItemText(item) || "", _this._state.value); });
        }
        var selectedItemId = this.list.selection.getId();
        if (!selectedItemId || this.config.multiselection) {
            this.list.resetFocus();
        }
        else {
            this.list.setFocus(selectedItemId);
        }
        var listCell = this._layout.getCell("list");
        var notFoundCell = this._layout.getCell("not-found");
        if (this.data.getLength() === 0) {
            if (this.config.multiselection && this.config.selectAllButton) {
                this._layout.getCell("select-unselect-all").hide();
            }
            listCell.hide();
            this._state.creatingState = true;
            var notFoundContent = this.config.newOptions ? this._state.value : "";
            notFoundCell.height = (0, helper_1.emptyListHeight)(notFoundContent, this.getRootView().refs.holder.el.offsetWidth);
            notFoundCell.attach(helper_1.emptyListView, notFoundContent);
            notFoundCell.show();
        }
        else {
            if (this.config.multiselection && this.config.selectAllButton) {
                this._layout.getCell("select-unselect-all").show();
            }
            var sameItem = this._state.value && this.data.find(function (item) { return item.value === _this._state.value; });
            if (!sameItem && this._state.value) {
                this._state.creatingState = this.config.newOptions;
                listCell.show();
                if (this.config.newOptions) {
                    var notFoundContent = this._state.value;
                    notFoundCell.height = (0, helper_1.emptyListHeight)(notFoundContent, this.getRootView().refs.holder.el.offsetWidth);
                    notFoundCell.attach(helper_1.emptyListView, notFoundContent);
                    notFoundCell.show();
                }
                else
                    notFoundCell.hide();
            }
            else {
                this._state.creatingState = false;
                if (notFoundCell.isVisible()) {
                    listCell.show();
                    notFoundCell.hide();
                }
            }
        }
    };
    Combobox.prototype._findBest = function (value) {
        var _this = this;
        var best = this.data.find(function (item) { return (0, core_1.isExistValue)(_this._getItemText(item) || "", value); });
        if (!best) {
            return;
        }
        if (this.list.selection.getId() === best.id) {
            return;
        }
        this.list.setFocus(best.id);
        this.paint();
    };
    Combobox.prototype._exsistId = function (id) {
        var _this = this;
        if (id instanceof Array) {
            return id.every(function (i) { return _this.data.exists(i); });
        }
        return this.data.exists(id);
    };
    Combobox.prototype._draw = function () {
        var _a;
        if (!this.config) {
            return (0, dom_1.el)("div");
        }
        var _b = this.config, multiselection = _b.multiselection, labelPosition = _b.labelPosition, hiddenLabel = _b.hiddenLabel, required = _b.required, disabled = _b.disabled, css = _b.css, helpMessage = _b.helpMessage, readOnly = _b.readOnly, placeholder = _b.placeholder;
        var item = multiselection ? null : this.data.getItem(this.list.selection.getId());
        var showPlaceholder = !this.list.selection.getId() ||
            (typeof this.list.selection.getId() === "object" &&
                this.list.selection.getId().length === 0);
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        var canTemplate = !this.config.multiselection && (this.config.readOnly || !this.popup.isVisible());
        var isInputTemplate = canTemplate && this.config.htmlEnable && this.config.template;
        var isInputImageOrIcon = canTemplate && ((item === null || item === void 0 ? void 0 : item.icon) || (item === null || item === void 0 ? void 0 : item.src)) && !this.config.template;
        return (0, dom_1.el)("div", {
            "data-dhx-widget-id": this._uid,
            onkeydown: this._handlers.onkeydown,
            onkeyup: this._handlers.onkeyup,
            class: "dhx_widget dhx_combobox" +
                (labelPosition === "left" ? " dhx_combobox--label-inline" : "") +
                (hiddenLabel ? " dhx_combobox--sr_only" : "") +
                (required ? " dhx_combobox--required" : "") +
                (disabled ? " dhx_combobox--disabled" : "") +
                (css ? " ".concat(css) : ""),
        }, [
            labelStyle
                ? (0, dom_1.el)("label.dhx_label.dhx_combobox__label", {
                    style: labelStyle.style,
                    class: helpMessage ? "dhx_label--with-help" : "",
                    onclick: this._handlers.oninputclick,
                }, helpMessage
                    ? [
                        (labelStyle.label || required) &&
                            (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                        (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                            tabindex: "0",
                            role: "button",
                            onclick: this._handlers.showHelper,
                            id: "dhx_label__help_".concat(this._uid),
                        }),
                    ]
                    : labelStyle.label)
                : null,
            (0, dom_1.el)("div.dhx_combobox-input-box" +
                // (this.popup.isVisible() ? ".dhx_combobox-input-box" : "") +
                (disabled ? ".dhx_combobox-input-box--disabled" : "") +
                (readOnly ? ".dhx_combobox-input-box--readonly" : "") +
                (this._state.currentState === types_2.ComboState.error
                    ? ".dhx_combobox-input-box--state_error"
                    : "") +
                (this._state.currentState === types_2.ComboState.success
                    ? ".dhx_combobox-input-box--state_success"
                    : ""), {
                _ref: "holder",
            }, [
                (0, dom_1.el)("div.dhx_combobox-input__icon", {
                    onclick: this._handlers.toggleIcon,
                }, [
                    (0, dom_1.el)("span" +
                        (this.popup.isVisible() ? ".dxi.dxi-menu-up" : ".dxi.dxi-menu-down")),
                ]),
                (0, dom_1.el)("div.dhx_combobox-input-list-wrapper", {
                    onclick: this._handlers.oninputclick,
                }, [
                    (0, dom_1.el)("ul.dhx_combobox-input-list", __spreadArray(__spreadArray([], this._drawSelectedItems(), true), [
                        (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-input-list__item--input", [
                            (isInputTemplate || isInputImageOrIcon) && item
                                ? (0, dom_1.el)("div.dhx_combobox-input__template", {
                                    ".innerHTML": isInputTemplate
                                        ? this.config.template(item)
                                        : null,
                                }, isInputImageOrIcon ? [(0, exports.$template)(item)] : null)
                                : null,
                            (0, dom_1.el)("input.dhx_combobox-input", {
                                oninput: this._handlers.oninput,
                                onfocus: this._handlers.onfocus,
                                onblur: this._handlers.onblur,
                                _ref: "input",
                                _key: this._uid,
                                type: "text",
                                placeHolder: showPlaceholder && placeholder ? placeholder : undefined,
                                value: readOnly && item
                                    ? this._getItemText(item)
                                    : this._state.value,
                                readOnly: readOnly || disabled,
                                required: required,
                                role: "combobox",
                                "aria-label": readOnly
                                    ? "Select value"
                                    : "Type or select value",
                                "aria-describedby": helpMessage
                                    ? "dhx_label__help_".concat(this._uid)
                                    : null,
                                "aria-expanded": this.popup.isVisible().toString(),
                                "aria-controls": (_a = this.list.getRootView().node) === null || _a === void 0 ? void 0 : _a.attrs.id,
                            }),
                        ]),
                    ], false)),
                ]),
            ]),
        ]);
    };
    Combobox.prototype._drawSelectedItems = function () {
        var _this = this;
        if (!this.config.multiselection) {
            return [];
        }
        if (this.config.itemsCount) {
            var count = this.list.selection.getId().length;
            return count
                ? [
                    (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-tag", [
                        (0, dom_1.el)("span.dhx_combobox-tag__value", itemsCountTemplate(count, this.config.itemsCount)),
                        (0, dom_1.el)("button.dhx_button.dhx_combobox-tag__action.dhx_combobox__action-clear-all", { "aria-label": "clear all" }, [(0, dom_1.el)("span.dhx_button__icon.dxi.dxi-close-circle")]),
                    ]),
                ]
                : [];
        }
        return this.list.selection.getId().map(function (id) {
            var item = _this.data.getItem(id);
            if (!item) {
                return null;
            }
            var imageOrIcon = _this._drawImageOrIcon(item);
            return (0, dom_1.el)("li.dhx_combobox-input-list__item.dhx_combobox-tag", { "data-dhx-id": id }, __spreadArray(__spreadArray([], (imageOrIcon || !_this.config.template
                ? [imageOrIcon, (0, dom_1.el)("span.dhx_combobox-tag__value", _this._getItemText(item))]
                : [
                    (0, dom_1.el)("span.dhx_combobox-tag__template", {
                        ".innerHTML": _this.config.template(item),
                    }),
                ]), true), [
                (0, dom_1.el)("button.dhx_button.dhx_button--icon.dhx_combobox-tag__action.dhx_combobox__action-remove", {
                    type: "button",
                    "aria-label": "remove",
                }, [(0, dom_1.el)("span.dhx_button__icon.dxi.dxi-close-circle")]),
            ], false));
        });
    };
    Combobox.prototype._drawImageOrIcon = function (item) {
        if (item.src) {
            return (0, dom_1.el)("img.dhx_combobox-tag__image", { src: item.src, alt: "" });
        }
        else if (item.icon) {
            return (0, dom_1.el)("span.dhx_combobox-tag__icon", { class: item.icon });
        }
        return null;
    };
    Combobox.prototype._getItemText = function (item) {
        if (!item) {
            return null;
        }
        return item.value;
    };
    Combobox.prototype._updateSelectedItem = function (id) {
        var _a;
        if (this.config.multiselection) {
            if (this.config.selectAllButton &&
                !this._state.unselectActive &&
                this.data.getLength() === id.length) {
                this._layout.getCell("select-unselect-all").attach(helper_1.unselectAllView);
                this._state.unselectActive = true;
            }
            else if (this.config.selectAllButton && this._state.unselectActive) {
                this._layout.getCell("select-unselect-all").attach(helper_1.selectAllView);
                this._state.unselectActive = false;
            }
            if (this._state.value) {
                this._state.value = "";
                this._state.canDelete = id.length === 0;
                this.data.resetFilter();
                this._filter();
            }
        }
        else {
            this._state.value = (_a = this._getItemText(this.data.getItem(id))) !== null && _a !== void 0 ? _a : "";
        }
        this.paint();
    };
    Combobox.prototype._changePopupPosition = function () {
        var _this = this;
        if (this.config.multiselection) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this._updatePopup();
            });
        }
    };
    Combobox.prototype._updatePopup = function () {
        var popupNode = this.popup.getContainer();
        var holderNode = this.getRootView().refs.holder.el;
        popupNode.style.width = holderNode.offsetWidth + "px";
        var listHeight = parseInt(this.config.listHeight);
        if (this.data.getLength() <= 10) {
            listHeight = (0, dom_1.getViewHeight)(this.list._renderList(), holderNode.offsetWidth);
        }
        var selectAllCellHeight = this._layout.getCell("select-unselect-all").isVisible() ? 33 : 0;
        var notFoundCellHeight = this._state.creatingState ? this._layout.getCell("not-found").height : 0;
        popupNode.style.height = listHeight + selectAllCellHeight + notFoundCellHeight + "px";
        this.popup.show(holderNode, {
            mode: "bottom",
            theme: this.getRootNode(),
        });
    };
    return Combobox;
}(view_1.View));
exports.Combobox = Combobox;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.emptyListHeight = exports.emptyListView = exports.unselectAllView = exports.selectAllView = void 0;
var dom_1 = __webpack_require__(0);
var en_1 = __webpack_require__(61);
function selectAllView() {
    return (0, dom_1.el)(".dhx_list-item.dhx_combobox-options__item.dhx_combobox-options__item--select-all.dhx_combobox__action-select-all", en_1.default.selectAll);
}
exports.selectAllView = selectAllView;
function unselectAllView() {
    return (0, dom_1.el)(".dhx_list-item.dhx_combobox-options__item.dhx_combobox-options__item--select-all.dhx_combobox__action-select-all", en_1.default.unselectAll);
}
exports.unselectAllView = unselectAllView;
function emptyListView(value) {
    return (0, dom_1.el)("ul.dhx_list", [
        (0, dom_1.el)("li.dhx_list-item.dhx_combobox-options__item".concat(value ? ".dhx_combobox-options__action-create-option" : ""), {}, value ? "".concat(en_1.default.createItem, " \"").concat(value, "\"") : en_1.default.notFound),
    ]);
}
exports.emptyListView = emptyListView;
function emptyListHeight(value, width) {
    var canvas = document.createElement("canvas");
    var ctx = canvas.getContext("2d", {
        alpha: false,
    });
    ctx.font = "normal 14px Roboto";
    var sumValue = value ? "".concat(en_1.default.createItem, " \"").concat(value, "\"") : en_1.default.notFound;
    return 13 + 20 * Math.ceil(ctx.measureText(sumValue).width / (width - 16));
}
exports.emptyListHeight = emptyListHeight;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ComboState = exports.ComboboxEvents = void 0;
var ComboboxEvents;
(function (ComboboxEvents) {
    ComboboxEvents["beforeChange"] = "beforeChange";
    ComboboxEvents["change"] = "change";
    ComboboxEvents["focus"] = "focus";
    ComboboxEvents["blur"] = "blur";
    ComboboxEvents["keydown"] = "keydown";
    ComboboxEvents["input"] = "input";
    ComboboxEvents["beforeOpen"] = "beforeOpen";
    ComboboxEvents["afterOpen"] = "afterOpen";
    ComboboxEvents["beforeClose"] = "beforeClose";
    ComboboxEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ComboboxEvents["open"] = "open";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    ComboboxEvents["close"] = "close";
})(ComboboxEvents || (exports.ComboboxEvents = ComboboxEvents = {}));
var ComboState;
(function (ComboState) {
    ComboState[ComboState["default"] = 0] = "default";
    ComboState[ComboState["error"] = 1] = "error";
    ComboState[ComboState["success"] = 2] = "success";
})(ComboState || (exports.ComboState = ComboState = {}));


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataView = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var ts_list_1 = __webpack_require__(38);
var editors_1 = __webpack_require__(202);
var DataView = /** @class */ (function (_super) {
    __extends(DataView, _super);
    function DataView(node, config) {
        if (config === void 0) { config = {}; }
        return _super.call(this, node, (0, core_1.extend)({
            itemsInRow: 1,
            gap: "0px",
        }, config)) || this;
    }
    DataView.prototype.scrollTo = function (id) {
        var rootView = this.getRootView();
        if (!rootView || !rootView.node || !rootView.node.el || typeof id === "undefined") {
            return;
        }
        var dataViewEl = this.getRootNode();
        this._scrollTo(id, dataViewEl);
    };
    DataView.prototype._scrollTo = function (id, el) {
        var _a;
        if (!el)
            return;
        var getPage = function (index, rest, total) {
            var count = 0;
            if (!total)
                return count;
            while (index + rest >= total) {
                count++;
                index = index + rest - total;
            }
            return count;
        };
        var index = this.data.getIndex(id);
        if (index === -1)
            return;
        var virtual = this.config.virtual;
        var rest = this.config.itemsInRow - ((_a = el.lastElementChild) === null || _a === void 0 ? void 0 : _a.children.length) || 0;
        var currentPage = getPage(index, rest, el.children.length * this.config.itemsInRow);
        var restTotal = currentPage * rest;
        var currentRow = Math.floor((index + restTotal) / this.config.itemsInRow);
        var itemRow = el.children[currentRow - el.children.length * currentPage];
        if (!virtual && !itemRow)
            return;
        var item = itemRow.children[(index + restTotal) % this.config.itemsInRow];
        var gap = parseInt(this.config.gap.toString().replace("px", ""), null);
        if (item.offsetTop >= el.clientHeight + el.scrollTop - item.clientHeight) {
            el.scrollTop = item.offsetTop - el.clientHeight + item.clientHeight + gap;
        }
        else if (item.offsetTop < el.scrollTop - gap) {
            el.scrollTop = item.offsetTop - gap;
        }
    };
    DataView.prototype._didRedraw = function (vm) {
        var rootEl = vm.node.el;
        var hasScroll = rootEl.scrollHeight > rootEl.offsetHeight;
        var classAttr = vm.node.attrs.class.replace(" dhx_dataview--has-scroll", "");
        var newClassName = hasScroll ? classAttr + " dhx_dataview--has-scroll" : classAttr;
        vm.node.patch({ class: newClassName });
    };
    DataView.prototype._renderItem = function (item, index) {
        var _a = this.config, itemsInRow = _a.itemsInRow, gap = _a.gap, template = _a.template, itemHeight = _a.itemHeight;
        var html = template ? template(item) : item.htmlContent;
        var focus = item.id == this._focus;
        var isLastItemInRow = (index + 1) % this.config.itemsInRow === 0;
        var gapWithPx = function (gapSize) { return parseFloat(gapSize); };
        if (item.id == this._edited) {
            var editor = (0, editors_1.getEditor)(item, this);
            return editor.toHTML(isLastItemInRow);
        }
        var id = item.id.toString();
        var mx = this.data.getMetaMap(item);
        return (0, dom_1.el)("div", __assign(__assign({ class: "dhx_dataview-item" +
                (mx && mx.selected ? " dhx_dataview-item--selected" : "") +
                (focus ? " dhx_dataview-item--focus" : "") +
                (mx && mx.drop && !this._edited ? " dhx_dataview-item--drophere" : "") +
                (mx && mx.drag && !this._edited ? " dhx_dataview-item--dragtarget" : "") +
                (this.config.dragMode && !this._edited ? " dhx_dataview-item--drag" : "") +
                (gapWithPx(gap) ? " dhx_dataview-item--with-gap" : "") +
                (item.css ? " " + item.css : "") +
                (isLastItemInRow ? " dhx_dataview-item--last-item-in-row" : ""), style: {
                width: "calc(".concat(100 / itemsInRow, "% - ").concat(gapWithPx(gap), " * ").concat((itemsInRow - 1) /
                    itemsInRow, "px)"),
                "margin-right": isLastItemInRow ? "" : gap,
                height: template ? null : itemHeight,
            }, _key: id, "data-dhx-id": id, _ref: id }, this.getDataViewItemAriaAttrs(this, item)), { tabindex: focus ? 0 : -1 }), html
            ? [
                (0, dom_1.el)(".dhx_dataview-item__inner-html", {
                    ".innerHTML": html,
                    role: "presentation",
                }),
            ]
            : item.value || item.text || item.value);
    };
    DataView.prototype._renderList = function () {
        var _this = this;
        var data = this.data.getRawData(0, -1);
        var _a = this.config, itemsInRow = _a.itemsInRow, css = _a.css, gap = _a.gap;
        var currentCounter = 0;
        var rows = data.reduce(function (items, obj, index) {
            if (currentCounter === 0) {
                items.push([]);
            }
            items[items.length - 1].push(_this._renderItem(obj, index));
            currentCounter = (currentCounter + 1) % itemsInRow;
            return items;
        }, []);
        return (0, dom_1.el)("", __assign(__assign(__assign(__assign({}, this._handlers), { "data-dhx-widget-id": this._uid, "data-dhx-drop-area": "row", class: (css ? css : "") +
                " dhx_widget dhx_dataview" +
                (this.config.multiselection && this.selection.getItem() ? " dhx_no-select--pointer" : ""), style: {
                height: this.config.height,
            } }), this.getDataViewAriaAttrs(this.config, this.data.getLength(), rows.length, itemsInRow)), { tabindex: 0 }), rows.map(function (row, index) {
            return (0, dom_1.el)(".dhx_dataview-row", {
                style: { margin: gap },
                "aria-label": "Row ".concat(index + 1),
            }, row);
        }));
    };
    DataView.prototype._getHotkeys = function () {
        var _this = this;
        var handlers = _super.prototype._getHotkeys.call(this);
        handlers.arrowUp = function (e) {
            _this.moveFocus(ts_list_1.MOVE_UP, _this.config.itemsInRow);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowDown = function (e) {
            _this.moveFocus(ts_list_1.MOVE_DOWN, _this.config.itemsInRow);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowLeft = function (e) {
            _this.moveFocus(ts_list_1.MOVE_UP);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        handlers.arrowRight = function (e) {
            _this.moveFocus(ts_list_1.MOVE_DOWN);
            if (_this._changed)
                _this._changed = false;
            e.preventDefault();
        };
        return handlers;
    };
    DataView.prototype.getDataViewItemAriaAttrs = function (context, item) {
        var getAriaGrabbed = function (context, item) {
            return context.config.dragMode && !context._edited
                ? { "aria-grabbed": Boolean(item.$dragtarget && !context._edited).toString() }
                : {};
        };
        var getAriaRoleDescription = function (context) {
            return context.config.editable
                ? {
                    "aria-roledescription": "".concat(context._edited ? "Press Enter to stop editing" : "Double click to edit content"),
                }
                : {};
        };
        return __assign(__assign({ role: "option", "aria-selected": item.$selected ? "true" : "false" }, getAriaGrabbed(context, item)), getAriaRoleDescription(context));
    };
    DataView.prototype.getDataViewAriaAttrs = function (config, itemsCount, rowsCount, itemsInRow) {
        return {
            role: "listbox",
            "aria-label": "Dataview, ".concat(itemsCount, " options on ").concat(rowsCount, " rows, ").concat(itemsInRow, " options per row.").concat(config.editable ? " Content is editable." : ""),
            "aria-multiselectable": config.selection && config.multiselection ? "true" : "false",
            "aria-readonly": config.editable ? "false" : "true",
        };
    };
    return DataView;
}(ts_list_1.List));
exports.DataView = DataView;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataViewEvents = void 0;
var DataViewEvents;
(function (DataViewEvents) {
    DataViewEvents["click"] = "click";
    DataViewEvents["doubleClick"] = "doubleclick";
    DataViewEvents["focusChange"] = "focuschange";
    DataViewEvents["beforeEditStart"] = "beforeEditStart";
    DataViewEvents["afterEditStart"] = "afterEditStart";
    DataViewEvents["beforeEditEnd"] = "beforeEditEnd";
    DataViewEvents["afterEditEnd"] = "afterEditEnd";
    DataViewEvents["itemRightClick"] = "itemRightClick";
    DataViewEvents["itemMouseOver"] = "itemMouseOver";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    DataViewEvents["contextmenu"] = "contextmenu";
})(DataViewEvents || (exports.DataViewEvents = DataViewEvents = {}));


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Promise) {
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Form = void 0;
var events_1 = __webpack_require__(3);
var view_1 = __webpack_require__(9);
var ts_layout_1 = __webpack_require__(13);
var core_1 = __webpack_require__(1);
var dateinput_1 = __webpack_require__(206);
var button_1 = __webpack_require__(207);
var checkbox_1 = __webpack_require__(99);
var checkboxGroup_1 = __webpack_require__(208);
var input_1 = __webpack_require__(40);
var radioGroup_1 = __webpack_require__(209);
var select_1 = __webpack_require__(211);
var textarea_1 = __webpack_require__(212);
var textinput_1 = __webpack_require__(213);
var combo_1 = __webpack_require__(214);
var sliderform_1 = __webpack_require__(215);
var helper_1 = __webpack_require__(8);
var simplevault_1 = __webpack_require__(100);
var timeinput_1 = __webpack_require__(216);
var colorpicker_1 = __webpack_require__(217);
var spacer_1 = __webpack_require__(218);
var avatar_1 = __webpack_require__(219);
var fieldset_1 = __webpack_require__(220);
var ToggleButton_1 = __webpack_require__(102);
var ToggleGroup_1 = __webpack_require__(221);
var types_1 = __webpack_require__(6);
var dom_1 = __webpack_require__(0);
var Form = /** @class */ (function (_super) {
    __extends(Form, _super);
    function Form(container, config) {
        var _this = _super.call(this, null, (0, core_1.extend)({
            disabled: false,
            hidden: false,
            css: "",
        }, config)) || this;
        _this._isValid = true;
        _this._state = {};
        _this.events = new events_1.EventSystem(_this);
        _this.container = container;
        _this._initUI(container);
        _this.config.hidden && _this.hide(true);
        _this.config.disabled && _this.disable();
        _this.events.on(types_1.FormEvents.afterShow, function () {
            _this._formContainerShow();
        });
        _this.events.on(types_1.FormEvents.afterHide, function () {
            if (!Object.values(_this._attachments).some(function (item) { return !item.config.hidden; })) {
                _this._formContainerHide();
            }
        });
        (0, dom_1.awaitRedraw)().then(function () {
            var node = _this.layout.getRootNode();
            if (node) {
                node.setAttribute("role", "form");
                _this.config.title && node.setAttribute("aria-label", _this.config.title);
            }
        });
        return _this;
    }
    Form.prototype.paint = function () {
        _super.prototype.paint.call(this);
        this.layout.paint();
    };
    Form.prototype.send = function (url, method, asFormData) {
        var _this = this;
        if (method === void 0) { method = "POST"; }
        if (this.events.fire(types_1.FormEvents.beforeSend)) {
            return new Promise(function (resolve, reject) {
                var xhr = new XMLHttpRequest();
                xhr.onload = function () {
                    if (xhr.status >= 200 && xhr.status < 300) {
                        resolve(xhr.response || xhr.responseText);
                    }
                    else {
                        reject({
                            status: xhr.status,
                            statusText: xhr.statusText,
                        });
                    }
                };
                xhr.onloadend = function () {
                    if (xhr.readyState === XMLHttpRequest.DONE && xhr.status === 200) {
                        _this.events.fire(types_1.FormEvents.afterSend);
                    }
                };
                xhr.onerror = function () {
                    reject({
                        status: xhr.status,
                        statusText: xhr.statusText,
                    });
                };
                if (method === "GET") {
                    url += "?" + encodeURIComponent(JSON.stringify(_this.getValue()));
                }
                xhr.open(method, url);
                if (!asFormData) {
                    xhr.setRequestHeader("Content-Type", "application/json");
                }
                switch (method) {
                    case "POST":
                        _this._send();
                        xhr.send(asFormData ? _this.getValue(true) : JSON.stringify(_this.getValue()));
                        break;
                    case "DELETE":
                    case "PUT":
                        xhr.send(asFormData ? _this.getValue(true) : JSON.stringify(_this.getValue()));
                        break;
                    case "GET":
                        xhr.send();
                        break;
                    default:
                        xhr.send();
                        break;
                }
            });
        }
    };
    Form.prototype.clear = function (method) {
        switch (method) {
            case types_1.ClearMethod.value:
                this._clear();
                break;
            case types_1.ClearMethod.validation:
                this._clearValidate();
                break;
            default:
                this._clear();
                this._clearValidate();
                break;
        }
        this.paint();
    };
    Form.prototype.setValue = function (obj) {
        for (var item in obj) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setValue === "function" &&
                    this._attachments[key].config.name === item) {
                    this._attachments[key].setValue(obj[item]);
                }
            }
        }
    };
    Form.prototype.getValue = function (asFormData) {
        if (asFormData) {
            var formData_1 = new FormData();
            var _loop_1 = function (key) {
                if (Array.isArray(this_1._state[key])) {
                    this_1._state[key].forEach(function (value, i) { return formData_1.append(key + "[".concat(i, "]"), value); });
                }
                else {
                    formData_1.append(key, this_1._state[key]);
                }
            };
            var this_1 = this;
            for (var key in this._state) {
                _loop_1(key);
            }
            return formData_1;
        }
        return __assign({}, this._state);
    };
    Form.prototype.getItem = function (name) {
        for (var item in this._attachments) {
            if (item == name) {
                return this._attachments[item];
            }
        }
    };
    Form.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        this._isValid = true;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].validate === "function") {
                if ((0, helper_1.isVerify)(this._attachments[key].config) && !this._attachments[key].validate(silent)) {
                    this._isValid = false;
                    !silent && this.events.fire(types_1.FormEvents.validationFail, [key, this._attachments[key]]);
                }
            }
        }
        return this._isValid;
    };
    Form.prototype.setProperties = function (arg, props) {
        if (typeof arg === "string" && props && !(0, core_1.isEmptyObj)(props)) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setProperties === "function" && key === arg) {
                    this._attachments[key].setProperties(props);
                }
            }
        }
        if (typeof arg === "object" && !(0, core_1.isEmptyObj)(arg)) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].setProperties === "function" && !(0, core_1.isEmptyObj)(arg[key])) {
                    this._attachments[key].setProperties(arg[key]);
                }
            }
        }
    };
    Form.prototype.getProperties = function (name) {
        if (name) {
            for (var key in this._attachments) {
                if (typeof this._attachments[key].getProperties === "function" && key === name) {
                    return this._attachments[key].getProperties();
                }
            }
        }
        var obj = {};
        for (var key in this._attachments) {
            if (typeof this._attachments[key].getProperties === "function") {
                obj[key] = this._attachments[key].getProperties();
            }
        }
        return obj;
    };
    Form.prototype.show = function () {
        if (!this.config.hidden && !Object.values(this._attachments).some(function (item) { return !item.config.hidden; })) {
            return;
        }
        this._formContainerShow();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].show === "function") {
                this._attachments[key].show();
            }
        }
    };
    Form.prototype.hide = function (init) {
        if (this.config.hidden && !init) {
            return;
        }
        this._formContainerHide();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].hide === "function") {
                this._attachments[key].hide(init);
            }
        }
    };
    Form.prototype.setFocus = function (name) {
        for (var item in this._attachments) {
            var control = this._attachments[item];
            if (control.config.type === "radiogroup" || control.config.type === "checkboxgroup") {
                control.focus(name);
            }
            if (control.config.name === name) {
                control.focus();
            }
        }
    };
    Form.prototype.blur = function (name) {
        if (!name) {
            this.forEach(function (control) {
                if (typeof control.blur === "function") {
                    control.blur();
                }
            });
        }
        for (var item in this._attachments) {
            var control = this._attachments[item];
            if (control.config.type === "radiogroup" || control.config.type === "checkboxgroup") {
                control.blur(name);
            }
            if (control.config.name === name) {
                control.blur();
            }
        }
    };
    Form.prototype.isVisible = function (name) {
        if (!name) {
            return !this.config.hidden;
        }
        for (var key in this._attachments) {
            if (key === name) {
                return !this._attachments[key].config.hidden;
            }
        }
    };
    Form.prototype.disable = function () {
        this.config.disabled = true;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].disable === "function") {
                this._attachments[key].disable();
            }
        }
    };
    Form.prototype.enable = function () {
        this.config.disabled = false;
        for (var key in this._attachments) {
            if (typeof this._attachments[key].enable === "function") {
                this._attachments[key].enable();
            }
        }
    };
    Form.prototype.isDisabled = function (name) {
        if (!name) {
            return this.config.disabled;
        }
        for (var key in this._attachments) {
            if (key === name) {
                return this._attachments[key].config.disabled;
            }
        }
    };
    Form.prototype.forEach = function (callback) {
        var items = Object.values(this._attachments);
        for (var index = 0; index < items.length; index++) {
            callback.call(this, items[index], index, items);
        }
    };
    Form.prototype.destructor = function () {
        this.unmount();
        for (var key in this._attachments) {
            if (typeof this._attachments[key].destructor === "function") {
                this._attachments[key].destructor();
            }
        }
        this.events && this.events.clear();
        this.layout && this.layout.destructor();
        this.config = this._attachments = this._state = this._uid = this.container = this.events = this._isValid = null;
    };
    Form.prototype.getRootView = function () {
        return this.layout.getRootView();
    };
    Form.prototype._addLayoutItem = function (item) {
        var id = (item.id = item.id || (0, core_1.uid)());
        var name = (item.name = item.name || id.toString());
        item.type = item.type && item.type.toLowerCase();
        var padding = item.padding, config = __rest(item, ["padding"]);
        var width = item.width, height = item.height;
        var autoSize = item.type !== "spacer";
        if (autoSize && !height)
            height = "content";
        switch (config.type) {
            case "button":
            case "toggle":
            case "togglegroup":
                width = config.width || (!config.full && "content");
                break;
            case "simplevault":
                config.$vaultHeight = height;
                break;
        }
        this._initItemHandlers(item, name);
        var cell = {
            id: name,
            width: width,
            height: height,
            padding: padding,
            hidden: config.hidden,
            css: this.getCellCSS(config),
        };
        if (item.type === "fieldset") {
            cell.$fieldset = true;
            cell.label = item.label;
            cell.labelAlignment = item.labelAlignment;
            this._createLayoutConfig(item, cell);
        }
        return cell;
    };
    Form.prototype._initItemHandlers = function (item, name) {
        var _this = this;
        switch (item.type) {
            case "avatar":
                {
                    var avatar_2 = (this._attachments[name] = new avatar_1.Avatar(null, item));
                    this._state[name] = avatar_2.getValue();
                    avatar_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                        }
                    });
                    avatar_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                        _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                        _this._changeProps(name, props, avatar_2.config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                        _this.paint();
                    });
                    avatar_2.events.on(types_1.ItemEvent.focus, function (value) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.blur, function (value) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value]);
                    });
                    avatar_2.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "toggle":
                {
                    var toggle_1 = (this._attachments[name] = new ToggleButton_1.ToggleButton(null, item));
                    this._state[name] = toggle_1.getValue();
                    toggle_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                        }
                    });
                    toggle_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (config) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, config]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.afterChangeProperties, function (config) {
                        _this._changeProps(name, config, toggle_1.config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, config]);
                        _this.paint();
                    });
                    toggle_1.events.on(types_1.ItemEvent.focus, function (value) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.blur, function (value) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value]);
                    });
                    toggle_1.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "togglegroup":
                {
                    var toggleGroup_1 = (this._attachments[name] = new ToggleGroup_1.ToggleGroup(null, item));
                    this._state[name] = toggleGroup_1.getValue();
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                        return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.change, function (value) {
                        _this._state[name] = value;
                        _this.events.fire(types_1.FormEvents.change, [name, value]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                        }
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                        !toggleGroup_1.isVisible() && _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (config) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, config]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.afterChangeProperties, function (config) {
                        _this._changeProps(name, config, toggleGroup_1.config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, config]);
                        _this.paint();
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.focus, function (value, id) {
                        _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.blur, function (value, id) {
                        _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                    });
                    toggleGroup_1.events.on(types_1.ItemEvent.keydown, function (event, id) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                    });
                }
                break;
            case "button":
                {
                    var button_2 = (this._attachments[name] = new button_1.Button(null, item));
                    button_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                        return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                        _this._changeProps(name, props, button_2.config);
                        _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                        _this.paint();
                    });
                    button_2.events.on(types_1.ItemEvent.click, function (e) {
                        e.preventDefault();
                        _this.events.fire(types_1.FormEvents.click, [name, e]);
                        _this.events.fire(types_1.FormEvents.buttonClick, [name, e]);
                        if (button_2.config.submit && _this.validate()) {
                            button_2.config.url && _this.send(button_2.config.url);
                        }
                    });
                    button_2.events.on(types_1.ItemEvent.beforeHide, function (text, init) {
                        if (!init) {
                            return _this.events.fire(types_1.FormEvents.beforeHide, [name, text]);
                        }
                    });
                    button_2.events.on(types_1.ItemEvent.beforeShow, function (text) {
                        return _this.events.fire(types_1.FormEvents.beforeShow, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterHide, function (text, init) {
                        _this.layout.getCell(name).hide();
                        !init && _this.events.fire(types_1.FormEvents.afterHide, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.afterShow, function (text) {
                        _this.layout.getCell(name).show();
                        _this.events.fire(types_1.FormEvents.afterShow, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.focus, function (text) {
                        _this.events.fire(types_1.FormEvents.focus, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.blur, function (text) {
                        _this.events.fire(types_1.FormEvents.blur, [name, text]);
                    });
                    button_2.events.on(types_1.ItemEvent.keydown, function (event) {
                        _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                    });
                }
                break;
            case "datepicker": {
                var datePicker_1 = (this._attachments[name] = new dateinput_1.DatePicker(null, item));
                this._state[name] = datePicker_1.getValue(item.valueFormat === "Date");
                datePicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, datePicker_1.config);
                    _this._state[name] = datePicker_1.getValue(item.valueFormat === "Date");
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                datePicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                datePicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "checkbox": {
                var checkbox_2 = (this._attachments[name] = new checkbox_1.Checkbox(null, item));
                this._state[name] = checkbox_2.getValue();
                checkbox_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, checkbox_2.config);
                    _this._state[name] = checkbox_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                checkbox_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                checkbox_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "checkboxgroup": {
                var checkboxGroup_2 = (this._attachments[name] = new checkboxGroup_1.CheckboxGroup(null, item));
                this._state[name] = checkboxGroup_2.getValue();
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, checkboxGroup_2.config);
                    _this._state[name] = checkboxGroup_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                    }
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                    !checkboxGroup_2.isVisible() && _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.focus, function (value, id) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.blur, function (value, id) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                });
                checkboxGroup_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "combo": {
                var combo_2 = (this._attachments[name] = new combo_1.Combo(null, item));
                this._state[name] = combo_2.getValue();
                combo_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                combo_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, combo_2.config);
                    _this._state[name] = combo_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                combo_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                combo_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                combo_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                combo_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "input": {
                var input_2 = (this._attachments[name] = new input_1.Input(null, item));
                this._state[name] = input_2.getValue();
                input_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                input_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, input_2.config);
                    _this._state[name] = input_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                input_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                input_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                input_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                input_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "radiogroup": {
                var radioGroup_2 = (this._attachments[name] = new radioGroup_1.RadioGroup(null, item));
                this._state[name] = radioGroup_2.getValue();
                radioGroup_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, radioGroup_2.config);
                    _this._state[name] = radioGroup_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeHide, function (value, id, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value, id]);
                    }
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeShow, function (value, id) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterHide, function (value, id, init) {
                    !radioGroup_2.isVisible() && _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterShow, function (value, id) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.focus, function (value, id) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.blur, function (value, id) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value, id]);
                });
                radioGroup_2.events.on(types_1.ItemEvent.keydown, function (event, id) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name, id]);
                });
                break;
            }
            case "select": {
                var select_2 = (this._attachments[name] = new select_1.Select(null, item));
                this._state[name] = select_2.getValue();
                select_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                select_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, select_2.config);
                    _this._state[name] = select_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                select_2.events.on(types_1.ItemEvent.changeOptions, function (options) {
                    _this.layout.getCell(name).config.options = __spreadArray([], options, true);
                });
                select_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                select_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                select_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                select_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "simplevault": {
                var simpleVault_1 = (this._attachments[name] = new simplevault_1.SimpleVault(null, item));
                this._state[name] = simpleVault_1.getValue();
                simpleVault_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, simpleVault_1.config);
                    _this._state[name] = simpleVault_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                simpleVault_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                break;
            }
            case "slider": {
                var sliderForm = (this._attachments[name] = new sliderform_1.SliderForm(null, item));
                this._state[name] = sliderForm.getValue();
                sliderForm.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                sliderForm.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                sliderForm.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "textarea": {
                var textarea_2 = (this._attachments[name] = new textarea_1.Textarea(null, item));
                this._state[name] = textarea_2.getValue();
                textarea_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, textarea_2.config);
                    _this._state[name] = textarea_2.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                textarea_2.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                textarea_2.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                textarea_2.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                textarea_2.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "text": {
                var text_1 = (this._attachments[name] = new textinput_1.Text(null, item));
                this._state[name] = text_1.getValue();
                text_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                text_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, text_1.config);
                    _this._state[name] = text_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                text_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                text_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                text_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                break;
            }
            case "timepicker": {
                var timePicker_1 = (this._attachments[name] = new timeinput_1.TimePicker(null, item));
                this._state[name] =
                    (item.value && timePicker_1.getValue(item.valueFormat === "timeObject")) || "";
                timePicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, timePicker_1.config);
                    _this._state[name] = timePicker_1.getValue(item.valueFormat === "timeObject");
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                timePicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                timePicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "colorpicker": {
                var colorPicker_1 = (this._attachments[name] = new colorpicker_1.ColorPicker(null, item));
                this._state[name] = colorPicker_1.getValue();
                colorPicker_1.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, colorPicker_1.config);
                    _this._state[name] = colorPicker_1.getValue();
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeChange, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeChange, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.change, function (value) {
                    _this._state[name] = value;
                    _this.events.fire(types_1.FormEvents.change, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeHide, function (value, init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name, value]);
                    }
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeShow, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterHide, function (value, init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterShow, function (value) {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.beforeValidate, function (value) {
                    return _this.events.fire(types_1.FormEvents.beforeValidate, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.afterValidate, function (value, isValid) {
                    _this.events.fire(types_1.FormEvents.afterValidate, [name, value, isValid]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.focus, function (value) {
                    _this.events.fire(types_1.FormEvents.focus, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.blur, function (value) {
                    _this.events.fire(types_1.FormEvents.blur, [name, value]);
                });
                colorPicker_1.events.on(types_1.ItemEvent.keydown, function (event) {
                    _this.events.fire(types_1.FormEvents.keydown, [event, name]);
                });
                break;
            }
            case "fieldset": {
                var fieldset_2 = (this._attachments[name] = new fieldset_1.Fieldset(item));
                fieldset_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                fieldset_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, fieldset_2.config);
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                break;
            }
            case "spacer":
            default: {
                var spacer_2 = (this._attachments[name] = new spacer_1.Spacer(null, item));
                spacer_2.events.on(types_1.ItemEvent.beforeChangeProperties, function (props) {
                    return _this.events.fire(types_1.FormEvents.beforeChangeProperties, [name, props]);
                });
                spacer_2.events.on(types_1.ItemEvent.afterChangeProperties, function (props) {
                    _this._changeProps(name, props, spacer_2.config);
                    _this.events.fire(types_1.FormEvents.afterChangeProperties, [name, props]);
                    _this.paint();
                });
                spacer_2.events.on(types_1.ItemEvent.beforeHide, function (init) {
                    if (!init) {
                        return _this.events.fire(types_1.FormEvents.beforeHide, [name]);
                    }
                });
                spacer_2.events.on(types_1.ItemEvent.beforeShow, function () {
                    return _this.events.fire(types_1.FormEvents.beforeShow, [name]);
                });
                spacer_2.events.on(types_1.ItemEvent.afterHide, function (init) {
                    _this.layout.getCell(name).hide();
                    !init && _this.events.fire(types_1.FormEvents.afterHide, [name]);
                });
                spacer_2.events.on(types_1.ItemEvent.afterShow, function () {
                    _this.layout.getCell(name).show();
                    _this.events.fire(types_1.FormEvents.afterShow, [name]);
                });
                break;
            }
        }
    };
    Form.prototype._changeProps = function (name, props, config) {
        var properties = ["width", "height", "css", "padding", "label", "labelAlignment", "align"];
        for (var key in props) {
            if (properties.includes(key) && (0, core_1.isDefined)(props[key])) {
                if (key === "css") {
                    this.layout.getCell(name).config[key] = this.getCellCSS(config);
                }
                else if (key === "width") {
                    this.layout.getCell(name).config[key] = (0, helper_1.getCellWidth)(config.type, props[key]);
                }
                else {
                    this.layout.getCell(name).config[key] = props[key];
                }
            }
        }
    };
    Form.prototype.getCellCSS = function (config) {
        var classList = config.css ? config.css + " dhx_form-element" : "dhx_form-element";
        switch (config.type) {
            case "button":
            case "togglegroup":
                if (config.full && !config.width) {
                    classList += " dhx_button--full-gravity";
                }
                break;
            case "text":
                if (config.width === "content")
                    classList += " dhx_form-element--fit-content";
                break;
        }
        return classList;
    };
    Form.prototype._addLayoutItems = function (items) {
        var _this = this;
        return items.map(function (item) {
            if ((0, helper_1.isBlock)(item)) {
                var layoutConfig = { width: "content", height: "content" };
                _this._createLayoutConfig(item, layoutConfig);
                return layoutConfig;
            }
            return _this._addLayoutItem(item);
        });
    };
    Form.prototype._checkLayoutConfig = function (config, layoutConfig) {
        if ((0, core_1.isDefined)(config.css)) {
            layoutConfig.css = config.css;
        }
        if ((0, core_1.isDefined)(config.title)) {
            layoutConfig.header = config.title;
        }
        if ((0, core_1.isDefined)(config.padding)) {
            layoutConfig.padding = config.padding;
        }
        if ((0, core_1.isDefined)(config.width)) {
            layoutConfig.width = config.width;
        }
        if ((0, core_1.isDefined)(config.height)) {
            layoutConfig.height = config.height;
        }
        if ((0, core_1.isDefined)(config.align)) {
            layoutConfig.align = config.align;
        }
        return layoutConfig;
    };
    Form.prototype._createLayoutConfig = function (config, layoutConfig) {
        layoutConfig = this._checkLayoutConfig(config, layoutConfig);
        if ((0, core_1.isDefined)(config.rows)) {
            layoutConfig.rows = this._addLayoutItems(config.rows);
        }
        else if ((0, core_1.isDefined)(config.cols)) {
            layoutConfig.cols = this._addLayoutItems(config.cols);
        }
    };
    Form.prototype._initUI = function (container) {
        this._attachments = {};
        var layoutConfig = {
            padding: "8px",
        };
        this.config.css += " dhx_form";
        this._createLayoutConfig(this.config, layoutConfig);
        this.layout = new ts_layout_1.Layout(container, layoutConfig);
        (0, helper_1.setAttacments)(this._attachments, this.layout);
    };
    Form.prototype._clear = function () {
        this._state = {};
        for (var key in this._attachments) {
            var name_1 = this._attachments[key].config.name;
            if (typeof this._attachments[key].clear === "function") {
                this._attachments[key].clear();
                name_1
                    ? (this._state[name_1] = this._attachments[key].getValue())
                    : (this._state[key] = this._attachments[key].getValue());
            }
        }
    };
    Form.prototype._clearValidate = function () {
        for (var key in this._attachments) {
            if (typeof this._attachments[key].clearValidate === "function") {
                this._attachments[key].clearValidate();
            }
        }
    };
    Form.prototype._formContainerShow = function () {
        this.config.hidden = false;
        if (!this.getRootView().node)
            return;
        var root = this.getRootView().node.el;
        root.style.display = "flex";
    };
    Form.prototype._formContainerHide = function () {
        this.config.hidden = true;
        if (!this.getRootView().node)
            return;
        var root = this.getRootView().node.el;
        root.style.display = "none";
    };
    Form.prototype._send = function () {
        for (var key in this._attachments) {
            if (typeof this._attachments[key].send === "function") {
                this._attachments[key].send();
            }
        }
    };
    return Form;
}(view_1.View));
exports.Form = Form;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(18)))

/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Checkbox = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var helper_1 = __webpack_require__(8);
var ts_popup_1 = __webpack_require__(15);
var types_1 = __webpack_require__(6);
var label_1 = __webpack_require__(12);
var core_1 = __webpack_require__(1);
var Checkbox = /** @class */ (function (_super) {
    __extends(Checkbox, _super);
    function Checkbox(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, container, config) || this;
        _this.events = new events_1.EventSystem();
        _this._propsItem = [
            "required",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
            "text",
        ];
        _this._props = __spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true);
        _this._initView(config);
        _this._initHandlers();
        var render = function () { return _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Checkbox.prototype.setProperties = function (propertyConfig, silent) {
        if (silent === void 0) { silent = false; }
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()])))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
            }
        }
        !silent && this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    Checkbox.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    Checkbox.prototype.show = function () {
        var hidden = this.config.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [this.getValue()])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [this.getValue()]);
    };
    Checkbox.prototype.hide = function (init) {
        var hidden = this.config.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [this.getValue(), init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [this.getValue(), init]);
    };
    Checkbox.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    Checkbox.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    Checkbox.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    Checkbox.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    Checkbox.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        var value = this.getValue();
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var valid = true;
        if (this.config.required || this.config.$required)
            valid = !!this.config.checked;
        if (!silent) {
            this.setValidationStatus(valid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, valid]);
            this.paint();
        }
        return valid;
    };
    Checkbox.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    Checkbox.prototype.setValue = function (checked, silent) {
        if (silent === void 0) { silent = false; }
        if (typeof checked === "undefined" ||
            checked === this.config.checked ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [this._getValue(checked)])))
            return;
        this.config.checked = !!checked;
        if (!silent) {
            this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
            (0, helper_1.isVerify)(this.config) && this.validate();
        }
    };
    Checkbox.prototype.getValue = function () {
        return this._getValue(this.config.checked);
    };
    Checkbox.prototype.clear = function (silent) {
        if (!this.config.checked ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [this._getValue(false)]))) {
            return;
        }
        this.config.checked = false;
        if (!silent) {
            this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        }
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
    };
    Checkbox.prototype.destructor = function () {
        this.events && this.events.clear();
        this._inGroup = this._propsItem = this._props = this._uid = this.events = null;
        _super.prototype._destructor.call(this);
        this.unmount();
    };
    Checkbox.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.focus();
        });
    };
    Checkbox.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.input.el.blur();
        });
    };
    Checkbox.prototype.isChecked = function () {
        return !!this.config.checked;
    };
    Checkbox.prototype._getValue = function (checked) {
        if (typeof this.config.value === "string") {
            return (checked && this.config.value) || "";
        }
        return !!checked;
    };
    Checkbox.prototype._initView = function (config) {
        var _this = this;
        this._inGroup = this.config.$group;
        if (!this._inGroup) {
            this.config = {
                type: config.type,
                id: config.id,
                name: config.name,
                checked: false,
                disabled: false,
                required: false,
                label: "",
                labelWidth: "",
                labelPosition: "top",
                hiddenLabel: false,
                helpMessage: "",
                preMessage: "",
                successMessage: "",
                errorMessage: "",
                width: "content",
                height: "content",
            };
            for (var key in config) {
                if (key !== "id" && key !== "type" && key !== "name") {
                    this.config[key] = config[key];
                }
            }
            if (this.config.helpMessage) {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
            this._handlers = {
                showHelper: function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    _this._helper.show(e.target, {
                        mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                        theme: _this.getRootNode(),
                    });
                },
                hideHelper: function (e) {
                    e.preventDefault();
                    e.stopPropagation();
                    _this._helper.hide();
                },
                onchange: function (e) {
                    var checked = e.target.checked;
                    if (!_this.events.fire(types_1.ItemEvent.beforeChange, [_this._getValue(checked)])) {
                        var element = _this.getRootView().refs.input.el;
                        element.checked = !checked;
                        return;
                    }
                    _this.config.checked = checked;
                    _this.events.fire(types_1.ItemEvent.change, [_this.getValue()]);
                    (0, helper_1.isVerify)(_this.config) && _this.validate();
                },
                onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]); },
                onblur: function () { var _a; return (_a = _this.events) === null || _a === void 0 ? void 0 : _a.fire(types_1.ItemEvent.blur, [_this.getValue()]); },
                onkeydown: function (event) {
                    _this.events.fire(types_1.ItemEvent.keydown, [event]);
                },
            };
        }
        else {
            this.config = {
                type: config.type,
                id: config.id,
                text: "",
                width: "content",
                height: "content",
                padding: 0,
            };
            for (var key in config) {
                if (key !== "id" && key !== "type" && key !== "name") {
                    this.config[key] = config[key];
                }
            }
            this._handlers = {
                onchange: function (e) {
                    var checked = e.target.checked;
                    if (!_this.events.fire(types_1.ItemEvent.beforeChange, [_this._getValue(checked)])) {
                        var element = _this.getRootView().refs.input.el;
                        element.checked = !checked;
                        return;
                    }
                    _this.config.checked = checked;
                    _this.events.fire(types_1.ItemEvent.change, [_this.getValue()]);
                    (0, helper_1.isVerify)(_this.config) && _this.validate();
                },
                onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue(), _this.config.id]); },
                onblur: function () { return _this.events.fire(types_1.ItemEvent.blur, [_this.getValue(), _this.config.id]); },
                onkeydown: function (event) {
                    _this.events.fire(types_1.ItemEvent.keydown, [event, _this.config.id]);
                },
            };
        }
    };
    Checkbox.prototype._initHandlers = function () {
        var _this = this;
        this.events.on(types_1.ItemEvent.change, function () { return _this.paint(); });
    };
    Checkbox.prototype._draw = function () {
        var _a = this.config, id = _a.id, value = _a.value, checked = _a.checked, disabled = _a.disabled, name = _a.name, required = _a.required, $required = _a.$required, text = _a.text, label = _a.label, labelWidth = _a.labelWidth, helpMessage = _a.helpMessage;
        return (0, dom_1.el)("label.dhx_checkbox.dhx_form-group.dhx_form-group--checkbox", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config) || !!$required),
        }, !this._inGroup
            ? [
                label || labelWidth || helpMessage || required ? this._drawLabel() : null,
                (0, dom_1.el)(".dhx_checkbox__container", [
                    (0, dom_1.el)(".dhx_checkbox__holder", [
                        (0, dom_1.el)("input.dhx_checkbox__input", {
                            type: "checkbox",
                            "data-dhx-id": name || id,
                            id: id,
                            _key: id || this._uid,
                            value: value,
                            name: name,
                            disabled: disabled,
                            checked: checked,
                            onchange: this._handlers.onchange,
                            onfocus: this._handlers.onfocus,
                            onblur: this._handlers.onblur,
                            onkeydown: this._handlers.onkeydown,
                            required: required,
                            _ref: "input",
                            "aria-label": label || "checkbox ".concat(text || ""),
                            "aria-describedby": helpMessage
                                ? "dhx_label__help_".concat(id || this._uid)
                                : null,
                        }),
                        (0, dom_1.el)("span.dhx_checkbox__visual-input"),
                        (0, dom_1.el)("span.dhx_text", [text]),
                    ]),
                    required &&
                        (0, helper_1.getValidationMessage)(this.config) &&
                        (0, dom_1.el)("span.dhx_input__caption", (0, helper_1.getValidationMessage)(this.config)),
                ]),
            ]
            : [
                (0, dom_1.el)(".dhx_checkbox__holder", [
                    (0, dom_1.el)("input.dhx_checkbox__input", {
                        type: "checkbox",
                        id: id,
                        value: value || "",
                        name: name || "",
                        disabled: disabled,
                        checked: checked,
                        onchange: this._handlers.onchange,
                        onfocus: this._handlers.onfocus,
                        onblur: this._handlers.onblur,
                        onkeydown: this._handlers.onkeydown,
                        required: required,
                        _ref: "input",
                    }),
                    (0, dom_1.el)("span.dhx_checkbox__visual-input"),
                    (0, dom_1.el)("span.dhx_text", [text]),
                ]),
            ]);
    };
    return Checkbox;
}(label_1.Label));
exports.Checkbox = Checkbox;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleVault = exports.FileStatus = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var html_1 = __webpack_require__(2);
var core_1 = __webpack_require__(1);
var ts_data_1 = __webpack_require__(4);
var ts_vault_1 = __webpack_require__(62);
var ts_popup_1 = __webpack_require__(15);
var helper_1 = __webpack_require__(8);
var en_1 = __webpack_require__(101);
var types_1 = __webpack_require__(6);
var label_1 = __webpack_require__(12);
var FileStatus;
(function (FileStatus) {
    FileStatus["queue"] = "queue";
    FileStatus["uploaded"] = "uploaded";
    FileStatus["failed"] = "failed";
    FileStatus["inprogress"] = "inprogress";
})(FileStatus || (exports.FileStatus = FileStatus = {}));
var SimpleVault = /** @class */ (function (_super) {
    __extends(SimpleVault, _super);
    function SimpleVault(container, config) {
        var _this = _super.call(this, container, config) || this;
        _this._propsItem = [
            "required",
            "label",
            "labelWidth",
            "labelPosition",
            "hiddenLabel",
            "helpMessage",
            "preMessage",
            "successMessage",
            "errorMessage",
        ];
        _this._propsSimpleVault = [
            "params",
            "headerParams",
            "target",
            "fieldName",
            "singleRequest",
            "updateFromResponse",
            "autosend",
            "accept",
            "validation",
        ];
        _this._props = __spreadArray(__spreadArray(__spreadArray([], helper_1.baseProps, true), _this._propsItem, true), _this._propsSimpleVault, true);
        _this.events = new events_1.EventSystem(_this);
        _this.data = new ts_data_1.DataCollection();
        _this._uploader = new ts_vault_1.Uploader(__assign({ target: "", accept: "", fieldName: "file", singleRequest: false, updateFromResponse: true, autosend: false }, config), _this.data, _this.data.events);
        _this._initView(__assign(__assign({}, _this._uploader.config), config));
        _this._initHandlers();
        var render = function () { return _this._draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    SimpleVault.prototype.send = function (params) {
        this._uploader.send(params);
    };
    SimpleVault.prototype.selectFile = function () {
        this._uploader.selectFile();
    };
    SimpleVault.prototype.setValue = function (value) {
        if (!value.length) {
            return;
        }
        this.data.parse(value);
        (0, helper_1.isVerify)(this.config) && this.validate();
    };
    SimpleVault.prototype.getValue = function () {
        return this.data.serialize();
    };
    SimpleVault.prototype.clear = function () {
        if (this.getValue().length === 0 || !this.events.fire(types_1.ItemEvent.beforeChange, [[]])) {
            return;
        }
        this.data.removeAll();
        this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        (0, helper_1.isVerify)(this.config) && this.setValidationStatus(this.validate(true) ? "success" : "error");
        this.paint();
    };
    SimpleVault.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    SimpleVault.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    SimpleVault.prototype.isDisabled = function () {
        return this.config.disabled;
    };
    SimpleVault.prototype.show = function () {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if (!hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [value])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [value]);
    };
    SimpleVault.prototype.hide = function (init) {
        var _a = this.config, value = _a.value, hidden = _a.hidden;
        if ((hidden && !init) || !this.events.fire(types_1.ItemEvent.beforeHide, [value, init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [value, init]);
    };
    SimpleVault.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    SimpleVault.prototype.validate = function (silent) {
        if (silent === void 0) { silent = false; }
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var value = args.length ? args[0] : this.getValue();
        if (!silent && !this.events.fire(types_1.ItemEvent.beforeValidate, [value])) {
            return false;
        }
        var valid = true;
        if (this.config.required)
            valid = !!value.length;
        if (typeof this.config.validation === "function")
            valid = this.config.validation(value);
        if (!silent) {
            this.setValidationStatus(valid ? "success" : "error");
            this.events.fire(types_1.ItemEvent.afterValidate, [value, valid]);
            this.paint();
        }
        return valid;
    };
    SimpleVault.prototype.clearValidate = function () {
        this.setValidationStatus();
        this.paint();
    };
    SimpleVault.prototype.setProperties = function (propertyConfig) {
        if (!propertyConfig ||
            (0, core_1.isEmptyObj)(propertyConfig) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in propertyConfig) {
            if (this._props.includes(key)) {
                this.config[key] = propertyConfig[key];
                if (this._propsSimpleVault.includes(key)) {
                    this._uploader.config[key] = propertyConfig[key];
                }
            }
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
        this.paint();
    };
    SimpleVault.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this._props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    SimpleVault.prototype.focus = function () {
        var _a, _b, _c;
        (_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el.focus();
        this.paint();
    };
    SimpleVault.prototype.blur = function () {
        var _a, _b, _c;
        (_c = (_b = (_a = this.getRootView()) === null || _a === void 0 ? void 0 : _a.refs) === null || _b === void 0 ? void 0 : _b.input) === null || _c === void 0 ? void 0 : _c.el.blur();
        this.paint();
    };
    SimpleVault.prototype.destructor = function () {
        this.events && this.events.clear();
        this._helper && this._helper.destructor();
        this.config = this.events = this._uid = this._helper = this._handlers = this._uploader = this.data = null;
        this._propsItem = this._propsSimpleVault = this._props = this._dragover = this._dragoverTimeout = null;
        this.unmount();
    };
    SimpleVault.prototype._initView = function (config) {
        var _a;
        this.config = __assign({ type: config.type, id: config.id, name: config.name, value: [], disabled: false, hidden: false, css: "", label: "", labelWidth: "", labelPosition: "top", hiddenLabel: false, helpMessage: "", preMessage: "", successMessage: "", errorMessage: "", width: "content", height: "content" }, config);
        if ((_a = config.value) === null || _a === void 0 ? void 0 : _a.length) {
            this.data.parse(config.value);
        }
        this.paint();
    };
    SimpleVault.prototype._initHandlers = function () {
        var _this = this;
        this._handlers = {
            add: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                e.preventDefault();
                _this._uploader.selectFile();
            },
            remove: function (e) {
                if (_this.config.disabled) {
                    return;
                }
                var id = (0, html_1.locate)(e);
                if (!id) {
                    return;
                }
                _this.data.remove(id);
            },
            ondragover: function (e) {
                var types = e.dataTransfer.types;
                for (var _i = 0, types_2 = types; _i < types_2.length; _i++) {
                    var type = types_2[_i];
                    if (type !== "Files" && type !== "application/x-moz-file") {
                        return;
                    }
                }
                if (_this._dragoverTimeout) {
                    clearTimeout(_this._dragoverTimeout);
                }
                else {
                    _this.paint();
                }
                _this._dragover = true;
                _this._dragoverTimeout = setTimeout(function () {
                    _this._dragover = false;
                    _this._dragoverTimeout = null;
                    _this.paint();
                }, 150);
            },
            showHelper: function (e) {
                e.stopPropagation();
                e.preventDefault();
                _this._helper.show(e.target, {
                    mode: _this.config.labelPosition === "left" ? "bottom" : "right",
                    theme: e.target,
                });
            },
            hideHelper: function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this._helper.hide();
            },
        };
        this._uploader.events.on("beforeUploadFile", function (file) {
            if (_this.config.autosend && !_this.validate(true))
                return false;
            return _this.events.fire(types_1.ItemEvent.beforeUploadFile, [file, _this.config.value]);
        });
        this._uploader.events.on("uploadBegin", function (files) {
            _this.events.fire(types_1.ItemEvent.uploadBegin, [files, _this.config.value]);
        });
        this._uploader.events.on("uploadComplete", function (files) {
            _this.events.fire(types_1.ItemEvent.uploadComplete, [files, _this.config.value]);
        });
        this._uploader.events.on("uploadFail", function (file) {
            _this.events.fire(types_1.ItemEvent.uploadFail, [file, _this.config.value]);
        });
        this._uploader.events.on("uploadFile", function (file, extra) {
            _this.events.fire(types_1.ItemEvent.uploadFile, [file, _this.config.value, extra]);
        });
        this._uploader.events.on("uploadProgress", function (progress) {
            _this.events.fire(types_1.ItemEvent.uploadProgress, [progress, _this.config.value]);
        });
        this.data.events.on(ts_data_1.DataEvents.beforeAdd, function (file) {
            return _this.events.fire(types_1.ItemEvent.beforeChange, [__spreadArray(__spreadArray([], _this.config.value, true), [file], false), file]);
        });
        this.data.events.on(ts_data_1.DataEvents.beforeRemove, function (file) {
            var value = _this.config.value.filter(function (i) { return i.id !== file.id; });
            return _this.events.fire(types_1.ItemEvent.beforeChange, [value, file]);
        });
        this.data.events.on(types_1.ItemEvent.change, function (_id, method, file) {
            if (!method) {
                return;
            }
            var value = (_this.config.value = _this.getValue());
            if (!(_this._uploader.isActive && method === "update")) {
                _this.events.fire(types_1.ItemEvent.change, [value, file]);
                (0, helper_1.isVerify)(_this.config) && _this.validate();
            }
            _this.paint();
        });
    };
    SimpleVault.prototype._draw = function () {
        var _this = this;
        if (this.config.helpMessage) {
            if (this._helper) {
                this._helper.attachHTML(this.config.helpMessage);
            }
            else {
                this._helper = new ts_popup_1.Popup({
                    css: "dhx_tooltip dhx_tooltip--forced dhx_tooltip--light",
                });
                this._helper.attachHTML(this.config.helpMessage);
            }
        }
        var files = this.data.getLength()
            ? (0, dom_1.el)("ul.dhx_simplevault__files.dhx_simplevault-files", {
                class: this.config.$vaultHeight ? "" : "dhx_simplevault-files__fixed",
            }, this.data.map(function (file) {
                return (0, dom_1.el)("li.dhx_simplevault-files__item", [
                    (0, dom_1.el)("span.dhx_simplevault-files__item-name", (file.file && file.file.name) || file.name),
                    (0, dom_1.el)(".dhx_button.dhx_simplevault-files__delete.dhx_button--icon.dhx_button--view_link.dhx_button--size_small.dhx_button--color_secondary.dhx_button--circle", {
                        "data-dhx-id": file.id,
                        onclick: _this._handlers.remove,
                    }, [(0, dom_1.el)("span.dxi.dxi-delete-forever")]),
                ]);
            }))
            : null;
        var _a = this.config, id = _a.id, helpMessage = _a.helpMessage, disabled = _a.disabled, required = _a.required, label = _a.label, hidden = _a.hidden, accept = _a.accept;
        var labelStyle = (0, html_1.getLabelStyle)(this.config);
        var visibility = (hidden && " dhx_form-group--hidden") || "";
        return (0, dom_1.el)(".dhx_form-group.dhx_form-group--simplevault", {
            class: (0, helper_1.getFormItemCss)(this.config, (0, helper_1.isVerify)(this.config)) + visibility,
        }, [
            labelStyle &&
                (0, dom_1.el)("legend.dhx_label", {
                    class: helpMessage ? "dhx_label--with-help" : "",
                    style: labelStyle.style,
                    onclick: this._handlers.add,
                    "aria-label": label || "select files",
                }, helpMessage
                    ? [
                        (labelStyle.label || required) &&
                            (0, dom_1.el)("span.dhx_label__holder", labelStyle.label),
                        (0, dom_1.el)("span.dhx_label-help.dxi.dxi-help-circle-outline", {
                            tabindex: "0",
                            role: "button",
                            onclick: this._handlers.showHelper,
                            onfocus: this._handlers.showHelper,
                            onblur: this._handlers.hideHelper,
                        }),
                    ]
                    : labelStyle.label),
            (0, dom_1.el)(".dhx_input__wrapper", { id: this._uid }, [
                (0, dom_1.el)("div", {
                    _hooks: {
                        didInsert: function (node) {
                            _this._uploader.linkDropArea(node.el);
                        },
                    },
                    ondragover: this._handlers.ondragover,
                    class: "dhx_simplevault" + (this._dragover ? " dhx_simplevault--on-drag" : ""),
                }, [
                    (0, dom_1.el)("div.dhx_simplevault-loader", [
                        (0, dom_1.el)("span.dhx_simplevault__icon.dxi.dxi-vault"),
                    ]),
                    (0, dom_1.el)(".dhx_simplevault__drop-area", [
                        (0, dom_1.el)("input.dhx_simplevault__input", {
                            _ref: "input",
                            type: "file",
                            id: id,
                            disabled: disabled,
                            accept: accept,
                        }),
                        (0, dom_1.el)("span.dhx_simplevault__icon.dxi.dxi-vault"),
                        (0, dom_1.el)("span.dhx_simplevault__title", [
                            (0, dom_1.el)("span", en_1.default.simpleVaultText),
                            (0, dom_1.el)("br"),
                            (0, dom_1.el)("label.dhx_simplevault__label", {
                                onclick: this._handlers.add,
                                for: id,
                            }, " " + en_1.default.simpleVaultLabel),
                        ]),
                    ]),
                    files,
                ]),
                (0, helper_1.getValidationMessage)(this.config) &&
                    (0, dom_1.el)("span.dhx_input__caption", {}, (0, helper_1.getValidationMessage)(this.config)),
            ]),
        ]);
    };
    return SimpleVault;
}(label_1.Label));
exports.SimpleVault = SimpleVault;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    simpleVaultText: "Drag & drop files or folders here or",
    simpleVaultLabel: "browse files",
};


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToggleButton = void 0;
var types_1 = __webpack_require__(6);
var view_1 = __webpack_require__(9);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var helper_1 = __webpack_require__(8);
var core_1 = __webpack_require__(1);
var ToggleButton = /** @class */ (function (_super) {
    __extends(ToggleButton, _super);
    function ToggleButton(container, config) {
        var _this = _super.call(this, container, __assign({ full: false, selected: false, disabled: false, hidden: false, width: "content", height: "content", text: "", icon: "", offIcon: "", offText: "", css: "", padding: "" }, config)) || this;
        _this.events = new events_1.EventSystem();
        _this.props = __spreadArray(__spreadArray([], (_this.config.$group ? [] : helper_1.baseProps), true), [
            "value",
            "offIcon",
            "offText",
            "icon",
            "text",
            "full",
        ], false);
        _this.initHandlers();
        var render = function () { return _this.draw(); };
        _this.mount(container, (0, dom_1.create)({ render: render }));
        return _this;
    }
    ToggleButton.prototype.setValue = function (selected, silent) {
        if (selected === void 0) { selected = false; }
        if (silent === void 0) { silent = false; }
        if (typeof selected !== "boolean" ||
            selected === this.config.selected ||
            (!silent && !this.events.fire(types_1.ItemEvent.beforeChange, [selected]))) {
            return;
        }
        this.config.selected = selected;
        !silent && this.events.fire(types_1.ItemEvent.change, [this.getValue()]);
        this.paint();
    };
    ToggleButton.prototype.getValue = function () {
        var _a = this.config, value = _a.value, selected = _a.selected;
        if (typeof value === "string")
            return selected ? value : "";
        if (typeof value === "number")
            return selected ? value : 0;
        return !!selected;
    };
    ToggleButton.prototype.isSelected = function () {
        return !!this.config.selected;
    };
    ToggleButton.prototype.show = function () {
        if (!this.config.hidden || !this.events.fire(types_1.ItemEvent.beforeShow, [this.getValue()])) {
            return;
        }
        this.config.hidden = false;
        this.events.fire(types_1.ItemEvent.afterShow, [this.getValue()]);
    };
    ToggleButton.prototype.hide = function (init) {
        if (init === void 0) { init = false; }
        if ((this.config.hidden && !init) ||
            !this.events.fire(types_1.ItemEvent.beforeHide, [this.getValue(), init])) {
            return;
        }
        this.config.hidden = true;
        this.events.fire(types_1.ItemEvent.afterHide, [this.getValue(), init]);
    };
    ToggleButton.prototype.isVisible = function () {
        return !this.config.hidden;
    };
    ToggleButton.prototype.focus = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.button.el.focus();
            _this.paint();
        });
    };
    ToggleButton.prototype.blur = function () {
        var _this = this;
        (0, dom_1.awaitRedraw)().then(function () {
            _this.getRootView().refs.button.el.blur();
            _this.paint();
        });
    };
    ToggleButton.prototype.disable = function () {
        this.config.disabled = true;
        this.paint();
    };
    ToggleButton.prototype.enable = function () {
        var _a;
        this.config.disabled = false;
        ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isDisabled()) && this.parent.enable();
        this.paint();
    };
    ToggleButton.prototype.isDisabled = function () {
        return !!this.config.disabled;
    };
    ToggleButton.prototype.setProperties = function (config) {
        if (!config ||
            (0, core_1.isEmptyObj)(config) ||
            !this.events.fire(types_1.ItemEvent.beforeChangeProperties, [this.getProperties()]))
            return;
        for (var key in config) {
            if (this.props.includes(key))
                this.config[key] = config[key];
        }
        this.events.fire(types_1.ItemEvent.afterChangeProperties, [this.getProperties()]);
    };
    ToggleButton.prototype.getProperties = function () {
        var obj = {};
        for (var _i = 0, _a = this.props; _i < _a.length; _i++) {
            var prop = _a[_i];
            obj[prop] = this.config[prop];
        }
        return obj;
    };
    ToggleButton.prototype.destructor = function () {
        this.events.clear();
        this.unmount();
    };
    ToggleButton.prototype.draw = function () {
        var _a = this.config, id = _a.id, name = _a.name, selected = _a.selected, disabled = _a.disabled, hidden = _a.hidden, text = _a.text, offText = _a.offText, icon = _a.icon, offIcon = _a.offIcon, full = _a.full, $group = _a.$group, $gap = _a.$gap, $extraCss = _a.$extraCss, css = _a.css;
        return (0, dom_1.el)("button.dhx_toggle", {
            "data-dhx-id": name || id,
            role: "button",
            type: "button",
            "aria-pressed": selected,
            "aria-label": text || name,
            disabled: disabled,
            class: ((!$group && "dhx_form-group dhx_form-group--toggle ") || "") +
                ((selected && "dhx_toggle--selected ") || "") +
                ((disabled && "dhx_toggle--disabled ") || "") +
                ((hidden && "dhx_toggle--hidden ") || "") +
                ((full && "dhx_toggle--full ") || "") +
                (($group && $extraCss) || "") +
                (($group && css) || ""),
            style: {
                marginLeft: $gap,
            },
            onclick: this.handlers.onclick,
            onfocus: this.handlers.onfocus,
            onblur: this.handlers.onblur,
            onkeydown: this.handlers.onkeydown,
            _ref: "button",
        }, [
            icon && (0, dom_1.el)("i.dhx_toggle__icon", { class: selected ? icon : offIcon || icon }),
            text && (0, dom_1.el)("span.dhx_toggle__text", {}, selected ? text : offText || text),
        ]);
    };
    ToggleButton.prototype.initHandlers = function () {
        var _this = this;
        this.handlers = {
            onclick: function () { return _this.setValue(!_this.config.selected); },
            onfocus: function () { return _this.events.fire(types_1.ItemEvent.focus, [_this.getValue()]); },
            onblur: function () { return _this.events.fire(types_1.ItemEvent.blur, [_this.getValue()]); },
            onkeydown: function (event) { return _this.events.fire(types_1.ItemEvent.keydown, [event]); },
        };
    };
    return ToggleButton;
}(view_1.View));
exports.ToggleButton = ToggleButton;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(104), exports);
__exportStar(__webpack_require__(109), exports);
__exportStar(__webpack_require__(246), exports);
__exportStar(__webpack_require__(5), exports);
__exportStar(__webpack_require__(24), exports);
__exportStar(__webpack_require__(11), exports);
__exportStar(__webpack_require__(10), exports);


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grid = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var html_1 = __webpack_require__(2);
var core_1 = __webpack_require__(1);
var KeyManager_1 = __webpack_require__(16);
var view_1 = __webpack_require__(9);
var ts_data_1 = __webpack_require__(4);
var Exporter_1 = __webpack_require__(224);
var data_1 = __webpack_require__(11);
var cells_1 = __webpack_require__(24);
var main_1 = __webpack_require__(10);
var Selection_1 = __webpack_require__(225);
var types_1 = __webpack_require__(5);
var render_1 = __webpack_require__(105);
var common_1 = __webpack_require__(17);
var content_1 = __webpack_require__(236);
var Resizer_1 = __webpack_require__(240);
var keys_1 = __webpack_require__(241);
var cells_2 = __webpack_require__(41);
var date_1 = __webpack_require__(19);
var DropManager_1 = __webpack_require__(108);
var dom_2 = __webpack_require__(242);
var default_1 = __webpack_require__(27);
var Grid = /** @class */ (function (_super) {
    __extends(Grid, _super);
    function Grid(container, config) {
        if (config === void 0) { config = {}; }
        var _this = _super.call(this, container, config) || this;
        _this._touch = {
            duration: 350,
            dblDuration: 300,
            timer: null,
            start: false,
        };
        _this._destructed = false;
        _this._sortingStates = [];
        _this._dropManager = null;
        _this._commonSummary = {};
        _this._colSummary = {};
        _this.version = "9.2.7";
        _this.name = "grid";
        _this.config = (0, core_1.extend)({
            rowHeight: 40,
            headerRowHeight: 40,
            footerRowHeight: 40,
            keyNavigation: true,
            sortable: true,
            columns: [],
            data: [],
            tooltip: true,
            rootParent: (typeof container === "string" && container) || _this._uid,
        }, _this._normalizeConfig(config));
        _this.content = (0, content_1.getContent)();
        _this._scroll = {
            top: 0,
            left: 0,
        };
        _this.config.autoWidth = _this.config.autoWidth || _this.config.fitToContainer;
        _this.config.adjust = _this.config.adjust || _this.config.columnsAutoWidth;
        _this.config.editable = _this.config.editable || _this.config.editing;
        _this.config.leftSplit = _this.config.leftSplit || _this.config.splitAt;
        _this.config.columns.forEach(function (col) {
            if (col.type === "date" && col.format)
                col.dateFormat = col.format;
        });
        _this._setHTMLEventHandlers();
        if (_this.config.eventHandlers) {
            for (var _i = 0, _a = Object.entries(_this.config.eventHandlers); _i < _a.length; _i++) {
                var _b = _a[_i], name_1 = _b[0], events = _b[1];
                _this._htmlEvents[name_1] = (0, html_1.eventHandler)(function (e) {
                    return {
                        col: _this.getColumn((0, html_1.locate)(e, "data-dhx-col-id") || (0, html_1.locate)(e, "data-dhx-id")) ||
                            {},
                        row: _this.data.getItem((0, html_1.locate)(e, "data-dhx-id")) || {},
                    };
                }, events, _this._htmlEvents[name_1]);
            }
        }
        _this._init();
        _this._dragInit();
        if (_this.config.columns) {
            _this._parseColumns(true);
        }
        if (_this._canDataParse()) {
            _this.data.parse(_this.config.data);
        }
        _this.selection = new Selection_1.Selection(_this, {
            type: (typeof _this.config.selection === "string" && _this.config.selection) || "complex",
            disabled: !_this.config.selection,
            multiSelection: _this.config.multiselection,
        }, _this.events, _this._uid);
        _this.mount(container, _this._createView());
        if (config.autoEmptyRow && _this.data.getLength() === 0) {
            _this._addEmptyRow();
            _this.paint();
        }
        return _this;
    }
    Grid.prototype.destructor = function () {
        var _a;
        this._destructed = true;
        this._destroyContent();
        (_a = this.config.$subRowCells) === null || _a === void 0 ? void 0 : _a.forEach(function (view) {
            var _a;
            (_a = view.cell) === null || _a === void 0 ? void 0 : _a.destructor();
        });
        this.keyManager && this.keyManager.destructor();
        this.events && this.events.clear();
        this._events && this._events.clear();
        this.export = this.content = this.selection = null;
        this._activeFilters = this._filterData = this._scroll = this._touch = this._htmlEvents = this._hiddenFilters = this.config.$subRowCells = null;
        this.unmount();
    };
    Grid.prototype.setColumns = function (columns) {
        var _this = this;
        this._destroyContent();
        this.config.columns = columns;
        this._parseColumns(true);
        if ((0, main_1.isAutoWidth)(this.config)) {
            this._applyAutoWidth();
        }
        this._setSummary();
        this._adjustColumns();
        this._checkFilters();
        this._checkMarks();
        this._normalizeSpans();
        this.paint();
        if (this.config.keyNavigation) {
            (0, dom_1.awaitRedraw)().then(function () {
                _this._initHotKey(true);
                _this.paint();
            });
        }
    };
    Grid.prototype.addRowCss = function (rowId, css) {
        var item = this.data.getItem(rowId);
        if (!item) {
            (0, ts_data_1.dhxWarning)("Row with id \"".concat(rowId, "\" not found"));
            return;
        }
        var styles = item.$css || "";
        if (!styles.match(new RegExp(css, "g"))) {
            item.$css = styles + " ".concat(css);
            this.paint();
        }
    };
    Grid.prototype.removeRowCss = function (rowId, css) {
        var item = this.data.getItem(rowId);
        if (!item) {
            (0, ts_data_1.dhxWarning)("Row with id \"".concat(rowId, "\" not found"));
            return;
        }
        var styles = item.$css ? item.$css.replace(css, "") : "";
        item.$css = styles;
        this.paint();
    };
    Grid.prototype.addCellCss = function (rowId, colId, css) {
        var column = this.getColumn(colId);
        if (column) {
            column.$cellCss = column.$cellCss || {};
            var cellStyle = column.$cellCss[rowId];
            if (cellStyle) {
                // eslint-disable-next-line @typescript-eslint/prefer-regexp-exec
                var newClass = cellStyle.match(new RegExp(css, "g")) ? "" : " ".concat(css);
                column.$cellCss[rowId] += newClass;
            }
            else if (this.data.getItem(rowId)) {
                column.$cellCss[rowId] = "".concat(css, " ");
            }
            this.paint();
        }
    };
    Grid.prototype.removeCellCss = function (rowId, colId, css) {
        var column = this.getColumn(colId);
        if (column) {
            if (column.$cellCss[rowId]) {
                column.$cellCss[rowId] = column.$cellCss[rowId].replace(css, "");
                this.paint();
            }
            else if (this.data.getItem(rowId)) {
                column.$cellCss[rowId] = "";
            }
        }
    };
    Grid.prototype.showColumn = function (colId) {
        var column = this.getColumn(colId);
        if (!column || !column.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeColumnShow, [column]))
            return;
        this._showColumn(column);
        this.events.fire(types_1.GridEvents.afterColumnShow, [column]);
    };
    Grid.prototype.hideColumn = function (colId) {
        var column = this.getColumn(colId);
        if (!column || column.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeColumnHide, [column]))
            return;
        this._hideColumn(column);
        this.events.fire(types_1.GridEvents.afterColumnHide, [column]);
    };
    Grid.prototype.isColumnHidden = function (colId) {
        var column = this.getColumn(colId);
        if (column) {
            return !!column.hidden;
        }
    };
    Grid.prototype.showRow = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var id = rowId.toString();
        var row = this.data.getItem(id);
        if (!row || !row.hidden) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeRowShow, [row]))
            return;
        this.data.update(id, { hidden: false });
        this._checkFilters(true);
        this.paint();
        this.events.fire(types_1.GridEvents.afterRowShow, [row]);
    };
    Grid.prototype.hideRow = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var id = rowId.toString();
        var row = this.data.getItem(id);
        if (!row) {
            return;
        }
        if (!this.events.fire(types_1.GridEvents.beforeRowHide, [row]))
            return;
        this.data.update(id, { hidden: true });
        this._checkFilters(true);
        this._checkSelectFilterValue();
        this.paint();
        this.events.fire(types_1.GridEvents.afterRowHide, [row]);
    };
    Grid.prototype.isRowHidden = function (rowId) {
        if (!(0, core_1.isDefined)(rowId)) {
            return;
        }
        var row = this.data.getItem(rowId.toString());
        if (row) {
            return !!row.hidden;
        }
    };
    Grid.prototype.getScrollState = function () {
        return {
            x: this._scroll.left,
            y: this._scroll.top,
        };
    };
    Grid.prototype.scroll = function (x, y) {
        var gridBody = this.getRootView().refs.grid_body.el.querySelector(".scroll-view") ||
            this.getRootView().refs.grid_body.el;
        gridBody.scrollLeft = (x || x === 0) && typeof x === "number" ? x : gridBody.scrollLeft;
        gridBody.scrollTop = (y || y === 0) && typeof y === "number" ? y : gridBody.scrollTop;
        this.paint();
    };
    Grid.prototype.scrollTo = function (rowId, colId) {
        var _a = this.config, topSplit = _a.topSplit, bottomSplit = _a.bottomSplit, columns = _a.columns, $width = _a.$width, $height = _a.$height, $headerHeight = _a.$headerHeight;
        var filteredColumns = columns.filter(function (col) { return !col.hidden; });
        var rows = this.data.getRawData(0, -1, null, 2);
        var colInd = filteredColumns.findIndex(function (col) { return col.id == colId; });
        var rowInd = rows.findIndex(function (row) { return row.id == rowId; });
        if (!(0, core_1.isDefined)(colInd) || !(0, core_1.isDefined)(rowInd))
            return;
        var scrollState = this.getScrollState();
        var selectedCell = this.selection.getCell();
        var prevColInd = selectedCell && columns.findIndex(function (col) { return col.id == selectedCell.column.id; });
        var prevRowInd = selectedCell && rows.findIndex(function (row) { return row.id == selectedCell.row.id; });
        var leftSplit = (0, common_1.getCurrFixedCols)(this.config, types_1.Split.left).length;
        var rightSplit = (0, common_1.getCurrFixedCols)(this.config, types_1.Split.right).length;
        var isFixedLeft = leftSplit && prevColInd < leftSplit;
        var isFixedRight = rightSplit && prevColInd >= columns.length - rightSplit;
        var isFixedTop = topSplit && prevRowInd < topSplit;
        var isFixedBottom = bottomSplit && prevRowInd >= rows.length - bottomSplit;
        var x = (0, main_1.getTotalWidth)(filteredColumns.slice(0, colInd));
        var y = (0, main_1.getTotalHeight)(rows.slice(0, rowInd));
        var rowHeight = (0, data_1.getTotalRowHeight)(rows[rowInd]);
        if (leftSplit) {
            var leftFixedColsWidth = (0, main_1.getTotalWidth)((0, common_1.getCurrFixedCols)(this.config, types_1.Split.left));
            if ((!isFixedLeft && !isFixedRight && colInd < prevColInd) ||
                x - scrollState.x - leftFixedColsWidth < 0) {
                x -= leftFixedColsWidth;
            }
        }
        if (rightSplit) {
            var rightFixedColsWidth = (0, main_1.getTotalWidth)((0, common_1.getCurrFixedCols)(this.config, types_1.Split.right));
            if ((!isFixedLeft && !isFixedRight && colInd > prevColInd) ||
                $width + scrollState.x - x - filteredColumns[colInd].$width - rightFixedColsWidth < 0) {
                x += rightFixedColsWidth;
            }
        }
        if (topSplit) {
            var topFixedRowsHeight = (0, main_1.getTotalHeight)(rows.slice(0, topSplit));
            if ((!isFixedTop && !isFixedBottom && rowInd < prevRowInd) ||
                y - scrollState.y - topFixedRowsHeight < 0) {
                y -= topFixedRowsHeight;
            }
        }
        if (bottomSplit) {
            var bottomFixedRowsHeight = (0, main_1.getTotalHeight)(rows.slice(-bottomSplit));
            if ((!isFixedTop && !isFixedBottom && rowInd > prevRowInd) ||
                $height + scrollState.y - $headerHeight - y - rowHeight - bottomFixedRowsHeight < 0) {
                y += bottomFixedRowsHeight;
            }
        }
        var gridRight = $width + scrollState.x;
        var gridBottom = $height + scrollState.y - $headerHeight;
        var cellTop = y - scrollState.y - rowHeight;
        var cellLeft = x - scrollState.x - columns[colInd].$width;
        var cellBottom = y + rowHeight * 2 + 18 - gridBottom;
        var cellRight = x + columns[colInd].$width * 2 + 18 - gridRight;
        var scrollTop = cellTop > 0 && cellBottom < 0 ? 0 : cellTop < 0 ? cellTop : cellBottom;
        var scrollLeft = cellLeft > 0 && cellRight < 0 ? 0 : cellLeft < 0 ? cellLeft : cellRight;
        this.scroll(scrollLeft + scrollState.x, scrollTop + scrollState.y);
    };
    Grid.prototype.adjustColumnWidth = function (colId, adjust) {
        if (adjust === void 0) { adjust = true; }
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var col = columns.filter(function (col) { return col.id === colId; });
        var totalCols = this._adjustColumnsWidth({
            rows: this.config.data,
            cols: col,
            totalCols: columns,
            adjust: adjust,
        });
        this.config.$totalWidth = columns.reduce(function (totalWidth, column) {
            if (totalCols[column.id]) {
                column.$fixedWidth = true;
                var max = column.maxWidth;
                var min = column.minWidth;
                var width = totalCols[column.id];
                column.$width = width;
                if (max && width > max) {
                    column.$width = max;
                }
                if (min && column.$width < min) {
                    column.$width = min;
                }
            }
            return (totalWidth += column.$width);
        }, 0);
        this.paint();
    };
    Grid.prototype.getCellRect = function (rowId, colId) {
        var _a;
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var rows = this.data.getRawData(0, -1);
        var span = this.getSpan(rowId, colId);
        var colInd = columns.findIndex(function (obj) { return obj.id == (span ? span.column : colId); });
        var rowInd = rows.findIndex(function (obj) { return obj.id == (span ? span.row : rowId); });
        var x = (0, main_1.getTotalWidth)(columns.slice(0, colInd));
        var y = (0, main_1.getTotalHeight)(rows.slice(0, rowInd));
        return {
            x: x,
            y: y,
            height: (span === null || span === void 0 ? void 0 : span.rowspan) > 1 ? (0, cells_1.getSpanHeight)(rows, span) : (0, data_1.getTotalRowHeight)(rows[rowInd]) || 0,
            width: (span === null || span === void 0 ? void 0 : span.colspan) > 1
                ? (0, cells_1.getWidth)(this.config.columns, span.colspan, this.config.columns.findIndex(function (item) { return item.id === span.column; }))
                : ((_a = columns[colInd]) === null || _a === void 0 ? void 0 : _a.$width) || 0,
        };
    };
    Grid.prototype.getColumn = function (colId) {
        var _a;
        for (var _i = 0, _b = (_a = this.config) === null || _a === void 0 ? void 0 : _a.columns; _i < _b.length; _i++) {
            var col = _b[_i];
            if (col.id == colId) {
                return col;
            }
        }
    };
    Grid.prototype.addSpan = function (spanObj) {
        this.config.spans = this.config.spans || [];
        var index = (0, core_1.findIndex)(this.config.spans, function (span) { return "".concat(span.row) === "".concat(spanObj.row) && "".concat(span.column) === "".concat(spanObj.column); });
        if (index >= 0) {
            this.config.spans[index] = spanObj;
            return;
        }
        this.config.spans.push((0, cells_2.normalizeSpan)(spanObj, this.config, this.data));
        this._checkMarks();
        this.paint();
    };
    Grid.prototype.getSpan = function (rowId, colId) {
        var _this = this;
        var _a;
        if (this.config.spans) {
            var rowIndex_1 = this.data.getIndex(rowId.toString());
            var colIndex_1 = this.config.columns.findIndex(function (col) { return col.id === colId; });
            var index = (0, core_1.findIndex)(this.config.spans, function (span) {
                var startRowInd = _this.data.getIndex(span.row.toString());
                var startColInd = _this.config.columns.findIndex(function (col) { return col.id === span.column; });
                var rows = {
                    start: startRowInd,
                    end: span.rowspan ? startRowInd + span.rowspan : startRowInd + 1,
                };
                var cols = {
                    start: startColInd,
                    end: span.colspan ? startColInd + span.colspan : startColInd + 1,
                };
                return (rowIndex_1 >= rows.start &&
                    rowIndex_1 < rows.end &&
                    colIndex_1 >= cols.start &&
                    colIndex_1 < cols.end);
            });
            return (_a = this.config) === null || _a === void 0 ? void 0 : _a.spans[index];
        }
    };
    Grid.prototype.removeSpan = function (rowId, colId) {
        if (this.config.spans) {
            var index = (0, core_1.findIndex)(this.config.spans, function (span) { return "".concat(span.row) == "".concat(rowId) && "".concat(span.column) == "".concat(colId); });
            this.config.spans.splice(index, 1);
            this.paint();
        }
    };
    Grid.prototype.editCell = function (rowId, colId, editorType) {
        var _a;
        var row = this.data.getItem(rowId);
        var col = this.getColumn(colId);
        if (!row || !col) {
            (0, ts_data_1.dhxWarning)("item not found");
            return;
        }
        var colEditorType = col.editorType;
        var span = this.getSpan(row.id, col.id);
        if (span && typeof span.text === "function") {
            return;
        }
        if (!editorType) {
            editorType =
                this.config.autoHeight && col.type !== "number" ? "textarea" : "input";
            if (col.type === "date") {
                editorType = "datePicker";
            }
            if (col.type === "boolean") {
                editorType = "checkbox";
            }
            if (colEditorType) {
                editorType = colEditorType;
            }
            if ((0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text)) {
                editorType = this.config.autoHeight ? "textarea" : "input";
            }
        }
        if (col.type === "number") {
            var isTextSpanEditor = (0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text) && ["input", "textarea"].includes(editorType);
            if (!isTextSpanEditor && !["input", "select", "combobox"].includes(editorType)) {
                return;
            }
        }
        if (!this.events.fire(types_1.GridEvents.beforeEditStart, [row, col, editorType])) {
            return;
        }
        if (((_a = this.config.$editable) === null || _a === void 0 ? void 0 : _a.editor) ||
            (this.config.$editable &&
                this.config.$editable.row === rowId &&
                this.config.$editable.col === colId &&
                this.config.$editable.editorType === editorType)) {
            return;
        }
        this.config.$editable = {
            row: row.id,
            col: col.id,
            isSpan: !!span,
            editorType: editorType,
        };
        if (!this.selection.config.disabled) {
            this.selection.setCell(rowId.toString(), colId.toString());
        }
        this.paint();
        this.events.fire(types_1.GridEvents.afterEditStart, [row, col, editorType]);
    };
    Grid.prototype.editEnd = function (withoutSave) {
        if (this.config.$editable && this.config.$editable.editor) {
            this.config.$editable.editor.endEdit(withoutSave);
        }
    };
    Grid.prototype.getHeaderFilter = function (colId) {
        var _this = this;
        var col = this.getColumn(colId);
        if (!col) {
            return;
        }
        var filter = null;
        col.header.forEach(function (cell) {
            if (cell.content) {
                filter = _this.content[cell.content].element[colId];
            }
        });
        return filter;
    };
    Grid.prototype.getSummary = function (colId) {
        return __assign(__assign({}, this._commonSummary), (colId ? this._colSummary[colId] : {}));
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/suite/migration/ */
    Grid.prototype.getSortingState = function () {
        var _a;
        var state = (_a = this._sortingStates) === null || _a === void 0 ? void 0 : _a[0];
        return { dir: state.dir, by: state.by };
    };
    Grid.prototype._createView = function () {
        var _this = this;
        return (0, dom_1.create)({
            render: function (vm, obj) {
                return _this._destructed
                    ? (0, dom_1.el)("div")
                    : (0, render_1.render)(vm, obj, _this._htmlEvents, _this.selection, _this._uid);
            },
            hooks: this._initHooks(),
        }, this);
    };
    Grid.prototype._dragInit = function () {
        if (this.config.dragMode || this.config.dragItem) {
            ts_data_1.dragManager.setItem(this._uid, this);
            this._dropManager = new DropManager_1.DropManager({ view: this });
            if (!this.config.dragItem) {
                this.config.dragItem = "row";
            }
            if (!this.config.dragMode) {
                this.config.dragMode = "both";
            }
        }
    };
    Grid.prototype._parseColumns = function (configChanged) {
        if (configChanged === void 0) { configChanged = false; }
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        this.normalizeColumns({ config: this.config, columns: columns, configChanged: configChanged });
        (0, data_1.countColumns)(this.config, columns);
    };
    Grid.prototype.normalizeColumns = function (_a) {
        var _this = this;
        var _b, _c, _d;
        var config = _a.config, columns = _a.columns, configChanged = _a.configChanged;
        config.$headerHeightMap = [];
        config.$footerHeightMap = [];
        config.$headerHeight = config.$footerHeight = 0;
        for (var _i = 0, columns_1 = columns; _i < columns_1.length; _i++) {
            var col = columns_1[_i];
            col.htmlEnable = (_b = col.htmlEnable) !== null && _b !== void 0 ? _b : config.htmlEnable;
            col.$cellCss = col.$cellCss || {};
            (0, data_1.normalizeArray)(col, "header");
            (0, data_1.normalizeArray)(col, "footer");
            if (col.minWidth && col.minWidth < 20)
                col.minWidth = 20;
            if (col.maxWidth && col.maxWidth < 20)
                col.maxWidth = 20;
            var width = col.minWidth || 100;
            if (col.width) {
                if (col.maxWidth && col.minWidth) {
                    width =
                        col.width >= col.minWidth && col.width <= col.maxWidth
                            ? col.width
                            : col.width >= col.maxWidth
                                ? col.maxWidth
                                : col.minWidth;
                }
                else if (col.maxWidth) {
                    width = col.width <= col.maxWidth ? col.width : col.maxWidth > 100 ? col.maxWidth : 100;
                }
                else if (col.minWidth) {
                    width = col.width >= col.minWidth ? col.width : col.minWidth;
                }
                else {
                    width = col.width;
                }
                width = width < 20 ? 20 : width;
            }
            col.$width = col.$width && !configChanged ? col.$width : width;
            if (col.$width > col.maxWidth) {
                col.$width = col.maxWidth;
            }
            if (col.$width < col.minWidth) {
                col.$width = col.minWidth;
            }
        }
        var _loop_1 = function (col) {
            if ((_c = col.header) === null || _c === void 0 ? void 0 : _c.length) {
                var currentHeight_1 = 0;
                col.header.forEach(function (header, index) {
                    if (config.headerAutoHeight) {
                        currentHeight_1 = _this.getNormalizeContentHeight(header, col, config);
                    }
                    else {
                        currentHeight_1 = config.headerRowHeight;
                    }
                    if (currentHeight_1 > (config.$headerHeightMap[index] || 0)) {
                        config.$headerHeightMap[index] = Math.max(currentHeight_1, config.headerRowHeight);
                    }
                });
            }
            if ((_d = col.footer) === null || _d === void 0 ? void 0 : _d.length) {
                var currentHeight_2 = 0;
                col.footer.forEach(function (footer, index) {
                    if (config.footerAutoHeight) {
                        currentHeight_2 = _this.getNormalizeContentHeight(footer, col, config);
                    }
                    else {
                        currentHeight_2 = config.footerRowHeight;
                    }
                    if (currentHeight_2 > (config.$footerHeightMap[index] || 0)) {
                        config.$footerHeightMap[index] = Math.max(currentHeight_2, config.footerRowHeight);
                    }
                });
            }
        };
        for (var _e = 0, columns_2 = columns; _e < columns_2.length; _e++) {
            var col = columns_2[_e];
            _loop_1(col);
        }
        config.$headerHeight = config.$headerHeightMap.reduce(function (acc, cur) { return (acc += cur); }, 0);
        config.$footerHeight = config.$footerHeightMap.reduce(function (acc, cur) { return (acc += cur); }, 0);
    };
    Grid.prototype.getNormalizeContentHeight = function (row, col, config) {
        return this.config.footerRowHeight;
    };
    Grid.prototype._parseData = function () {
        this._detectColsTypes();
        this.config.data = this.data.map(function (row) { return row; });
        this.config.data = this._prepareData(this.data);
        this._checkMarks();
        this._applyLocalFilter();
        this._checkFilters();
    };
    Grid.prototype._createCollection = function () {
        this.data = new ts_data_1.DataCollection(null, this.events);
    };
    Grid.prototype._getRowIndex = function (rowId) {
        return this.data.getIndex(rowId);
    };
    Grid.prototype._setHTMLEventHandlers = function () {
        var _this = this;
        var showCellTooltip = function (node) {
            var _a;
            var column = _this.getColumn((0, html_1.locate)(node, "data-dhx-col-id"));
            var row = _this.data.getItem((0, html_1.locate)(node, "data-dhx-id"));
            if (row && column && (0, main_1.isTooltip)(_this.config, column)) {
                var editorOption = void 0;
                if (column.editorType === "combobox" || column.editorType === "select") {
                    var option = (0, data_1.getEditorOptions)(column, row).find(function (item) {
                        var _a;
                        var value = item instanceof Object ? item.id.toString() : item;
                        return value === ((_a = row[column.id]) === null || _a === void 0 ? void 0 : _a.toString());
                    });
                    editorOption = option instanceof Object ? option.value : option;
                }
                else if (column.editorType === "multiselect") {
                    var values_1 = (_a = row[column.id]) === null || _a === void 0 ? void 0 : _a.toString().split(", ");
                    if (values_1 === null || values_1 === void 0 ? void 0 : values_1.length) {
                        var options = (0, data_1.getEditorOptions)(column, row).filter(function (item) {
                            return values_1.includes(item instanceof Object ? item.id.toString() : item);
                        });
                        editorOption = options
                            .map(function (item) {
                            return item instanceof Object ? item.value : item;
                        })
                            .join(", ");
                    }
                }
                var value_1 = (0, data_1.applyPattern)(editorOption || row[column.id], column);
                var checkIsExistValue = function () { return !!value_1 || typeof value_1 === "boolean"; };
                if (column.tooltipTemplate) {
                    value_1 = column.tooltipTemplate(value_1, row, column) || null;
                }
                else if (checkIsExistValue() && column.template) {
                    value_1 = column.template(value_1, row, column);
                }
                if (checkIsExistValue()) {
                    (0, main_1.showTooltip)(value_1, __assign({ node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column) }, (0, main_1.getTooltipConfig)(_this.config, column)));
                }
            }
        };
        var showContentTooltip = function (node, type) {
            var _a;
            if (type === void 0) { type = "header"; }
            var headerId = (0, html_1.locate)(node, "data-dhx-text-id");
            var columnId = (0, html_1.locate)(node, "data-dhx-id");
            var column = _this.getColumn(columnId);
            if (!headerId || !column) {
                return;
            }
            var cell = (_a = column[type]) === null || _a === void 0 ? void 0 : _a.find(function (c) { return c.id === headerId; });
            if (!(0, main_1.isContentTooltip)(_this.config, column, cell, type)) {
                return;
            }
            var value = cell === null || cell === void 0 ? void 0 : cell.text;
            var summary = _this.getSummary(column.id);
            if (typeof value === "function") {
                value = value(summary);
            }
            if (typeof (cell === null || cell === void 0 ? void 0 : cell.tooltipTemplate) === "function") {
                value = cell.tooltipTemplate(__assign({ value: value }, summary), cell, column) || null;
            }
            if (value === null || value === void 0 ? void 0 : value.toString().length) {
                (0, main_1.showTooltip)(value, __assign({ node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column, cell) }, (0, main_1.getTooltipConfig)(_this.config, column, cell, type)));
            }
        };
        var showSpanCellTooltip = function (node) {
            var _a;
            var column = _this.getColumn((0, html_1.locate)(node, "data-dhx-col-id"));
            var row = _this.data.getItem((0, html_1.locate)(node, "data-dhx-id"));
            var span = _this.getSpan(row.id, column.id);
            if (row && span && (0, main_1.isTooltip)(_this.config, span)) {
                var summary = _this.getSummary(column.id);
                var text = typeof span.text === "function" ? span.text(summary) : span.text;
                var value = (_a = (text || (0, data_1.applyPattern)(row[column.id], column))) === null || _a === void 0 ? void 0 : _a.toString();
                if (span.tooltipTemplate) {
                    value = span.tooltipTemplate(__assign({ value: value }, summary), span) || null;
                }
                else if (column.template) {
                    value = column.template(value, row, column);
                }
                if (value) {
                    (0, main_1.showTooltip)(value, __assign({ node: node, htmlEnable: (0, main_1.isHtmlEnable)(_this.config, column) }, (0, main_1.getTooltipConfig)(_this.config, null, span)));
                }
            }
        };
        this._htmlEvents = {
            onclick: (0, html_1.eventHandler)(function (e) { return (0, html_1.locate)(e); }, {
                "dhx_grid-header-cell--sortable": function (e, id) {
                    var isResizable = e.target.getAttribute("dhx_resized");
                    var column = _this.getColumn(id);
                    if (column && (0, main_1.isSortable)(_this.config, column) && !isResizable) {
                        var textId_1 = (0, html_1.locate)(e, "data-dhx-text-id");
                        var cell = column.header.find(function (item) { return item.id === textId_1; });
                        _this._sort(id, cell.sortAs);
                    }
                },
                "dhx_grid-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_grid-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
                "dhx_span-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_span-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
            }),
            onscroll: function (e) {
                _this.events.fire(types_1.GridEvents.scroll, [
                    {
                        y: e.target.scrollTop,
                        x: e.target.scrollLeft,
                    },
                ]);
            },
            onmouseover: function (e) {
                var tooltipMap = [
                    { className: "dhx_grid-header-cell", action: function (node) { return showContentTooltip(node, "header"); } },
                    { className: "dhx_grid-footer-cell", action: function (node) { return showContentTooltip(node, "footer"); } },
                    { className: "dhx_grid-cell", action: showCellTooltip },
                    { className: "dhx_span-cell", action: showSpanCellTooltip },
                ];
                for (var _i = 0, tooltipMap_1 = tooltipMap; _i < tooltipMap_1.length; _i++) {
                    var _a = tooltipMap_1[_i], className = _a.className, action = _a.action;
                    var node = (0, html_1.locateNodeByClassName)(e, className);
                    if (node) {
                        action(node);
                        break;
                    }
                }
            },
        };
    };
    Grid.prototype._setEventHandlers = function () {
        var _this = this;
        this.data.events.on(ts_data_1.DataEvents.load, function () {
            _this._applyLocalFilter(true);
            _this._parseData();
            _this._parseColumns();
            if (_this.config.autoEmptyRow) {
                var emptyRow = _this.data.find({ by: "$emptyRow", match: true });
                if (emptyRow) {
                    _this.data.move(emptyRow.id, _this.data.getLength() - 1);
                }
                else {
                    _this._addEmptyRow();
                }
            }
            if (_this.config.data instanceof ts_data_1.DataCollection) {
                (0, dom_1.awaitRedraw)().then(function () { return _this._normalizeSpans(); });
            }
            else {
                _this._normalizeSpans();
            }
            _this.paint();
        });
        this.data.events.on(ts_data_1.DataEvents.change, function (id, status, obj) {
            if (status === "load" || status === "add" || status === "remove") {
                return;
            }
            if (status === "setPage") {
                (0, dom_1.awaitRedraw)().then(function () {
                    var colVisible = _this.config.columns.find(function (col) { return col.hidden !== true; });
                    _this.scrollTo(_this.data.getId(obj[0]).toString(), colVisible.id.toString());
                    _this._render();
                });
                return;
            }
            if (status === "sort") {
                _this._setSort();
            }
            else if (status === "update") {
                _this.config.data = _this._prepareData(_this.data);
            }
            else {
                if ((0, ts_data_1.isTreeCollection)(_this.data)) {
                    _this.config.data = _this._prepareData(_this.data);
                }
                else {
                    _this._setSummary();
                }
                _this._adjustColumns();
            }
            if ((0, core_1.isId)(id)) {
                _this._checkFilters();
                _this._checkSelectFilterValue();
            }
            _this._detectColsTypes();
            _this._removeMarks();
            _this._checkMarks();
            if (_this.config.autoEmptyRow && (!_this._activeFilters || (0, core_1.isEmptyObj)(_this._activeFilters))) {
                var emptyRow = _this.data.find({ by: "$emptyRow", match: true });
                if (emptyRow) {
                    if (emptyRow.id === id)
                        return;
                    _this.data.move(emptyRow.id, _this.data.getLength() - 1);
                }
                else {
                    _this._addEmptyRow();
                }
            }
            switch (status) {
                case "sort":
                    _this._normalizeSpans();
            }
            _this._render();
        });
        this.data.events.on(ts_data_1.DataEvents.filter, function (filters) {
            if (!filters && !_this.data.getRawFilters({ permanent: true })) {
                _this._applyLocalFilter();
            }
            if (!filters || (0, ts_data_1.isOnlyPermanentFilters)(filters)) {
                _this._filterData = _this.data.map(function (el) { return el; }) || [];
                _this._setUniqueData();
                _this._clearFilterValue();
            }
            else {
                _this._checkFilters();
            }
            _this._setSummary();
            _this._removeMarks();
            _this._checkMarks();
            _this._normalizeSpans();
            _this.paint();
        });
        this.data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._hiddenFilters = {};
            _this.config.columns.map(function (col) {
                col.header.map(function (cell) {
                    if (cell.content && (cell.content === "selectFilter" || cell.content === "comboFilter")) {
                        col.$uniqueData = [];
                    }
                });
            });
            if (!(0, core_1.isEmptyObj)(_this._activeFilters)) {
                _this.data.resetFilter();
            }
            _this._clearFilterValue(true);
        });
        this.data.events.on(ts_data_1.DataEvents.afterAdd, function (obj, batch, index) {
            if (batch.length === ++index)
                _this._handleRow(obj.id, "add");
        });
        this.data.events.on(ts_data_1.DataEvents.afterRemove, function (obj, batch, index) {
            if (batch.length === ++index)
                _this._handleRow(obj.id, "remove");
        });
        this.events.on(ts_data_1.DragEvents.beforeDrag, function (data, events, _ghost, type) {
            switch (type) {
                case "row":
                    if (_this.data.isGrouped()) {
                        return false;
                    }
                    return _this.events.fire(types_1.GridEvents.beforeRowDrag, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.dragStart, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.dragRowStart, [data, events]);
                    _this._autoScroll("vertical");
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.dragIn, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.dragRowIn, [data, events]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.dragOut, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.dragRowOut, [data, events]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.canDrop, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.canRowDrop, [data, events]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.cancelDrop, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.cancelRowDrop, [data, events]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.beforeDrop, function (data, events, type) {
            switch (type) {
                case "row":
                    return _this.events.fire(types_1.GridEvents.beforeRowDrop, [data, events]);
            }
        });
        this.events.on(ts_data_1.DragEvents.afterDrop, function (data, events, type) {
            var _a;
            var source = data.source, target = data.target, start = data.start;
            switch (type) {
                case "row":
                    {
                        var item = _this.data.getItem(data.start);
                        if (!item || source.some(function (id) { return id == target; }))
                            return;
                        for (var _i = 0, _b = _this.config.columns; _i < _b.length; _i++) {
                            var col = _b[_i];
                            if (typeof item[col.id] === "undefined") {
                                _this.data.update(item.id, (_a = {}, _a[col.id] = null, _a), true);
                            }
                        }
                        var initData = _this.data.getInitialData();
                        var startIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == start; });
                        var targetIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == target; });
                        if (startIndex > -1 && targetIndex > -1) {
                            if ((source === null || source === void 0 ? void 0 : source.length) > 1) {
                                var moveData = [];
                                var _loop_2 = function (id) {
                                    var itemIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == id; });
                                    var moveItem = initData === null || initData === void 0 ? void 0 : initData.splice(itemIndex, 1)[0];
                                    moveData.push(moveItem);
                                };
                                for (var _c = 0, source_1 = source; _c < source_1.length; _c++) {
                                    var id = source_1[_c];
                                    _loop_2(id);
                                }
                                targetIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == target; });
                                if (targetIndex > 0)
                                    ++targetIndex;
                                initData === null || initData === void 0 ? void 0 : initData.splice.apply(initData, __spreadArray([targetIndex, 0], moveData, false));
                            }
                            else {
                                initData === null || initData === void 0 ? void 0 : initData.splice(targetIndex, 0, initData === null || initData === void 0 ? void 0 : initData.splice(startIndex, 1)[0]);
                            }
                        }
                        _this._adjustColumns();
                        _this._checkFilters();
                        _this.paint();
                        _this.events.fire(types_1.GridEvents.afterRowDrop, [data, events]);
                    }
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.afterDrag, function (data, events, type) {
            switch (type) {
                case "row":
                    _this.events.fire(types_1.GridEvents.afterRowDrag, [data, events]);
                    _this._normalizeSpans();
                    break;
            }
        });
        this.events.on(types_1.GridEvents.dragPanelItemMouseDown, function (id, event) {
            _this._dragProcess(event, _this.data.getItem(id));
        });
        this.events.on(types_1.GridEvents.cellMouseDown, function (row, column, event) {
            !_this.config.dragPanel && _this._dragProcess(event, row, column);
        });
        this._events.on(types_1.GridSystemEvents.cellTouchMove, function (_row, _col, e) {
            _this._touch.start && e.preventDefault();
            _this._clearTouchTimer();
        });
        this._events.on(types_1.GridSystemEvents.cellTouchEnd, function () {
            _this._touch.start = false;
            _this._clearTouchTimer();
        });
        this.events.on(types_1.GridEvents.filterChange, function (val, colId, filter, silent) {
            var _a, _b, _c;
            if (!_this.events.fire(types_1.GridEvents.beforeFilter, [val, colId])) {
                return;
            }
            if (_this.config.autoEmptyRow) {
                var emptyRow = _this.data.find({ by: "$emptyRow", match: true });
                if (emptyRow) {
                    _this.data.remove(emptyRow.id);
                }
            }
            if (!_this._activeFilters) {
                _this._activeFilters = {};
            }
            var columnConfig = _this.getColumn(colId);
            var conf = columnConfig.header.filter(function (item) { return item.content === filter && item.customFilter !== undefined; })[0];
            if ((filter === "comboFilter" && val !== undefined) || (filter !== "comboFilter" && val !== "")) {
                var options_1 = (0, data_1.getEditorOptions)(columnConfig);
                if ((columnConfig.editorType === "combobox" ||
                    columnConfig.editorType === "select" ||
                    columnConfig.editorType === "multiselect") &&
                    options_1) {
                    if (Array.isArray(val)) {
                        val = val.map(function (item) {
                            var _a;
                            return (((_a = options_1.find(function (option) {
                                return typeof option === "string" ? option === item : option.value === item;
                            })) === null || _a === void 0 ? void 0 : _a.id) || item);
                        });
                    }
                    else {
                        val =
                            (_b = (_a = options_1.find(function (option) {
                                return typeof option === "string" ? option === val : option.value === val;
                            })) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : val;
                    }
                }
                var match = function (colId) {
                    var col = _this.getColumn(colId);
                    return function (val, match, obj, multi) {
                        return _this.content[filter].match({ val: val, match: match, obj: obj, multi: multi, col: col });
                    };
                };
                _this._activeFilters[colId] = {
                    by: colId,
                    match: val,
                    compare: (_c = conf === null || conf === void 0 ? void 0 : conf.customFilter) !== null && _c !== void 0 ? _c : match(colId),
                    multi: (columnConfig === null || columnConfig === void 0 ? void 0 : columnConfig.editorType) === "multiselect",
                };
            }
            else {
                delete _this._activeFilters[colId];
            }
            if (!silent) {
                _this.data.filter(_this._activeFilters);
            }
        });
        this.events.on(types_1.GridEvents.scroll, function (scrollState) {
            _this._scroll = { top: scrollState.y, left: scrollState.x };
            _this.paint();
        });
        this.events.on(types_1.GridEvents.cellDblClick, function (row, col, e) {
            if (!row) {
                return;
            }
            var targetCheckbox = (0, html_1.locateNodeByClassName)(e, "dhx_boolean-cell");
            if (targetCheckbox || row.hasOwnProperty("$group"))
                return;
            if ((col.editable !== false && _this.config.editable) || col.editable) {
                _this.editCell(row.id, col.id, col.editorType);
            }
        });
        this.events.on(types_1.GridEvents.afterEditEnd, function (value, editableRow, editableColumn) {
            _this._afterEditEndProcess(value, editableRow, editableColumn);
        });
        this.events.on(types_1.GridEvents.headerCellMouseDown, function (cell, col, event) {
            var target = event.target;
            var resizedColumn = target.getAttribute("dhx_resized");
            if (resizedColumn && _this.events.fire(types_1.GridEvents.beforeResizeStart, [col, event])) {
                (0, Resizer_1.startResize)(_this, resizedColumn.toString(), event, function () {
                    _this.paint();
                    _this.config.$resizing = null;
                    _this.events.fire(types_1.GridEvents.afterResizeEnd, [col, event]);
                });
            }
            if (event.targetTouches) {
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +event.timeStamp.toFixed();
                }
                else {
                    var doubleTap = _this._touch.dblDuration >= _this._touch.timeStamp - +event.timeStamp.toFixed();
                    if (doubleTap) {
                        event.preventDefault();
                        // to simulate on touch devices
                        _this.events.fire(types_1.GridEvents.headerCellDblClick, [cell, col, event]);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            }
        });
        this.events.on(types_1.GridEvents.footerCellDblClick, function (cell, col, event) {
            if (event.targetTouches) {
                if (!_this._touch.timeStamp) {
                    _this._touch.timeStamp = +event.timeStamp.toFixed();
                }
                else {
                    var doubleTap = _this._touch.dblDuration >= _this._touch.timeStamp - +event.timeStamp.toFixed();
                    if (doubleTap) {
                        event.preventDefault();
                        // to simulate on touch devices
                        _this.events.fire(types_1.GridEvents.footerCellDblClick, [cell, col, event]);
                    }
                    _this._touch.timeStamp = null;
                }
                setTimeout(function () {
                    _this._touch.timeStamp = null;
                }, _this._touch.dblDuration);
            }
        });
        this.events.on(types_1.GridEvents.resize, function () { return _this._parseColumns(); });
        this.events.on(types_1.GridEvents.afterResizeEnd, function (col) {
            var _a;
            _this.config.columns = (_a = _this.config.columns) === null || _a === void 0 ? void 0 : _a.map(function (c) {
                if (c.id == col.id)
                    c.width = col.$width;
                return c;
            });
            _this._parseColumns();
        });
    };
    Grid.prototype._afterEditEndProcess = function (value, editableRow, editableColumn) {
        var _a;
        var _b;
        if (((_b = this.config.$editable) === null || _b === void 0 ? void 0 : _b.editor) &&
            (this.config.$editable.col !== editableColumn.id || this.config.$editable.row !== editableRow.id))
            return;
        var row;
        var col;
        if (!this.config.$editable) {
            row = editableRow.id;
            col = editableColumn.id;
        }
        else {
            row = this.config.$editable.row;
            col = this.config.$editable.col;
        }
        var span = this.getSpan(row, col);
        if ((0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text) && (0, core_1.isDefined)(value)) {
            span.text = value.toString();
        }
        else {
            var item = this.data.getItem(row);
            delete item.$emptyRow;
            if ((0, core_1.isDefined)(value)) {
                this.data.update(row, __assign(__assign({}, item), (_a = {}, _a[col] = value, _a)));
            }
        }
        this.config.$editable = null;
        this.paint();
    };
    Grid.prototype._addEmptyRow = function () {
        var id = this.data.getId(this.data.getLength() - 1);
        var lastRow = this.data.getItem(id);
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var isEmpty = (0, main_1.isRowEmpty)(lastRow);
        if (!isEmpty) {
            this.data.add(columns.reduce(function (total, col) {
                total[col.id] = "";
                return total;
            }, { $emptyRow: true }));
        }
    };
    Grid.prototype._sort = function (by, sortAs, smartSorting) {
        if (smartSorting === void 0) { smartSorting = this.config.multiSort; }
        var column = this.getColumn(by);
        var state = this._sortingStates;
        var current = state.find(function (state) { return state.by == by; });
        if (!this.events.fire(types_1.GridEvents.beforeSort, [column, (current === null || current === void 0 ? void 0 : current.dir) === "asc" ? "desc" : "asc"])) {
            return;
        }
        var dir = "asc";
        if ((current === null || current === void 0 ? void 0 : current.by) === by) {
            dir = current.dir === "asc" ? "desc" : "asc";
        }
        var defaultAs = function (item) {
            if (item && column.type === "date") {
                if (typeof item === "string") {
                    if (!(0, date_1.stringToDate)(item, column.dateFormat, true)) {
                        var date = new Date(item);
                        if (date === null || date === void 0 ? void 0 : date.valueOf())
                            item = date.getTime();
                    }
                    else {
                        item = (0, date_1.stringToDate)(item, column.dateFormat).getTime();
                    }
                }
                else {
                    item = item.getTime();
                }
                return item;
            }
            return item ? "".concat(item) : "";
        };
        this.data.sort({ by: by, dir: dir, as: sortAs !== null && sortAs !== void 0 ? sortAs : defaultAs }, { smartSorting: smartSorting });
        this.events.fire(types_1.GridEvents.afterSort, [column, dir]);
    };
    Grid.prototype._setSort = function () {
        var _a;
        var state = (_a = this.data.getSortingStates()) === null || _a === void 0 ? void 0 : _a[0];
        this._sortingStates = (state && [state]) || [];
    };
    Grid.prototype._clearTouchTimer = function () {
        if (this._touch.timer) {
            clearTimeout(this._touch.timer);
            this._touch.timer = null;
        }
    };
    Grid.prototype._checkFilters = function (reset) {
        if (reset === void 0) { reset = false; }
        if ((0, core_1.isEmptyObj)(this._activeFilters)) {
            if (reset) {
                this.data.resetFilter();
            }
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData();
        }
        else {
            var permFilters = this.data.getRawFilters({ permanent: true });
            this.data.filter(permFilters, { $restore: true }, true);
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData();
            this.data.filter(null, { $restore: true }, true);
            this._filterData = this.data.map(function (el) { return el; }) || [];
            this._setUniqueData(true);
        }
    };
    Grid.prototype._setUniqueData = function (sync) {
        var _this = this;
        if (sync === void 0) { sync = false; }
        if (!this._filterData)
            return;
        this.config.columns.forEach(function (col) {
            col.header.forEach(function (cell) {
                var _a;
                if (!((_a = _this._activeFilters) === null || _a === void 0 ? void 0 : _a[col.id]) &&
                    cell.content &&
                    (cell.content === "selectFilter" || cell.content === "comboFilter")) {
                    var multi = col.header.some(function (i) { var _a; return (_a = i.filterConfig) === null || _a === void 0 ? void 0 : _a.multiselection; });
                    var customFilter = col.header.some(function (i) { var _a; return (_a = i.filterConfig) === null || _a === void 0 ? void 0 : _a.filter; });
                    if (!sync || (sync && !customFilter)) {
                        var unique = (0, data_1.getNormalizeFilterData)(_this._filterData, col.id, multi, col.editorType);
                        var options_2 = (0, data_1.getEditorOptions)(col);
                        if ((col.editorType === "combobox" ||
                            col.editorType === "select" ||
                            col.editorType === "multiselect") &&
                            options_2) {
                            unique = unique.map(function (item) {
                                var foundItem = options_2.find(function (option) {
                                    return typeof option === "string" ? item === option : item === option.id;
                                });
                                return foundItem && typeof foundItem !== "string" ? foundItem.value : item;
                            });
                        }
                        unique =
                            col.type !== "string"
                                ? Array.from(new Set(unique.map(function (val) { return (0, data_1.applyPattern)(val, col); })))
                                : unique;
                        if (!sync) {
                            col.$uniqueData = unique;
                            if (col.$activeFilterData)
                                delete col.$activeFilterData;
                        }
                        else {
                            col.$activeFilterData = unique;
                        }
                    }
                }
            });
        });
    };
    Grid.prototype._checkSelectFilterValue = function () {
        var _a;
        var filter = (_a = this.content) === null || _a === void 0 ? void 0 : _a.selectFilter;
        if (!filter)
            return;
        for (var key in filter.value) {
            var col = this.getColumn(key);
            var val = filter.value[key];
            if (!col.hidden && val && !col.$uniqueData.includes(val)) {
                filter.element[key].clear();
            }
        }
    };
    Grid.prototype._clearFilterValue = function (allCols) {
        var _this = this;
        if (allCols === void 0) { allCols = false; }
        var filters = ["selectFilter", "inputFilter"].map(function (i) { var _a; return (_a = _this.content) === null || _a === void 0 ? void 0 : _a[i]; }).filter(function (i) { return i; });
        filters.forEach(function (filter) {
            for (var key in filter.value) {
                if (filter.value[key] && (allCols || !_this.getColumn(key).hidden)) {
                    filter.element[key].clear(true);
                }
            }
        });
    };
    Grid.prototype._adjustColumns = function () {
        var _this = this;
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        var adjustableCol = [];
        var allAdjustableCol = [];
        var totalColumns = {};
        columns.forEach(function (column) {
            if (!(0, core_1.isDefined)(column.adjust)) {
                allAdjustableCol.push(column);
            }
            else if (column.adjust) {
                adjustableCol.push(column);
            }
        });
        if (adjustableCol.length || allAdjustableCol.length) {
            var data_2 = !this.config.data || !this.config.data.length ? this.data.map(function (row) { return row; }) : this.config.data;
            adjustableCol.forEach(function (column) {
                totalColumns = __assign(__assign({}, totalColumns), _this._adjustColumnsWidth({
                    rows: data_2,
                    cols: [column],
                    totalCols: columns,
                    adjust: column.adjust,
                }));
            });
            if (allAdjustableCol.length) {
                totalColumns = __assign(__assign({}, totalColumns), this._adjustColumnsWidth({
                    rows: data_2,
                    cols: allAdjustableCol,
                    totalCols: columns,
                }));
            }
        }
        this.config.$totalWidth = columns.reduce(function (totalWidth, column) {
            if (totalColumns[column.id]) {
                column.$fixedWidth = true;
                var max = column.maxWidth;
                var min = column.minWidth;
                var width = totalColumns[column.id];
                column.$width = width;
                if (max && width > max) {
                    column.$width = max;
                }
                if (min && column.$width < min) {
                    column.$width = min;
                }
            }
            return (totalWidth += column.$width);
        }, 0);
    };
    Grid.prototype._prepareData = function (data) {
        var _this = this;
        if (this.config.autoHeight ||
            this.config.headerAutoHeight ||
            this.config.footerAutoHeight) {
            this.config.autoHeight = this
                .config.headerAutoHeight = this
                .config.footerAutoHeight = false;
        }
        this._normalizeDataType();
        this._setSummary();
        this._adjustColumns();
        return data.map(function (row) {
            row.$height = Number(row.height) || _this.config.rowHeight;
            return row;
        });
    };
    Grid.prototype._adjustColumnsWidth = function (_a) {
        var _b, _c, _d;
        var _this = this;
        var rows = _a.rows, cols = _a.cols, _e = _a.adjust, adjust = _e === void 0 ? this.config.adjust : _e;
        var HORIZONTAL_OFFSET = 24;
        var iconOffset = function (col) { return ((0, main_1.isSortable)(_this.config, col) ? 16 : 0); };
        var columnsWidth = {};
        if (adjust === "header" || adjust === true) {
            var currentCols = cols.filter(function (col) { return col.header; });
            var data = (0, data_1.getMaxColsWidth)(this._prepareColumnData(currentCols, "header"), currentCols, {
                font: "normal 14.4px Arial",
            }, "header");
            if (data) {
                for (var _i = 0, _f = Object.entries(data); _i < _f.length; _i++) {
                    var _g = _f[_i], key = _g[0], value = _g[1];
                    columnsWidth = Object.assign(columnsWidth, (_b = {},
                        _b[key] = +value + HORIZONTAL_OFFSET + iconOffset(this.getColumn(key)),
                        _b));
                }
            }
        }
        if (adjust === "footer" || adjust === true) {
            var currentCols = cols.filter(function (col) { return col.footer; });
            var data = (0, data_1.getMaxColsWidth)(this._prepareColumnData(currentCols, "footer"), currentCols, {
                font: "normal 14.4px Arial",
            }, "footer");
            if (data) {
                for (var _h = 0, _j = Object.entries(data); _h < _j.length; _h++) {
                    var _k = _j[_h], key = _k[0], value = _k[1];
                    if ((columnsWidth[key] && columnsWidth[key] < +value + HORIZONTAL_OFFSET) ||
                        !columnsWidth[key]) {
                        columnsWidth = Object.assign(columnsWidth, (_c = {},
                            _c[key] = +value + HORIZONTAL_OFFSET,
                            _c));
                    }
                }
            }
        }
        if (adjust === "data" || adjust === true) {
            var data = (0, data_1.getMaxColsWidth)(rows, cols, {
                font: "normal 14.4px Arial",
            }, "data");
            if (data) {
                for (var _l = 0, _m = Object.entries(data); _l < _m.length; _l++) {
                    var _o = _m[_l], key = _o[0], value = _o[1];
                    if ((columnsWidth[key] && columnsWidth[key] < +value + HORIZONTAL_OFFSET) ||
                        !columnsWidth[key]) {
                        columnsWidth = Object.assign(columnsWidth, (_d = {},
                            _d[key] = +value + HORIZONTAL_OFFSET,
                            _d));
                    }
                }
            }
        }
        return columnsWidth;
    };
    Grid.prototype._prepareColumnData = function (data, type) {
        var _a;
        var _b, _c;
        var totalRow = [];
        for (var i = 0; i < data.length; i++) {
            var row = [];
            var column = data[i];
            for (var k = 0; k < (column === null || column === void 0 ? void 0 : column[type].length); k++) {
                var rowData = {};
                var text = (_b = column === null || column === void 0 ? void 0 : column[type][k]) === null || _b === void 0 ? void 0 : _b.text;
                if (text) {
                    if (typeof text === "function") {
                        text = text(this.getSummary(column.id));
                    }
                    var isHTML = (_c = column === null || column === void 0 ? void 0 : column[type][k]) === null || _c === void 0 ? void 0 : _c.htmlEnable;
                    rowData[column.id] = text || "";
                    if (isHTML) {
                        rowData[column.id] = (0, main_1.removeHTMLTags)(rowData[column.id]);
                    }
                }
                else {
                    rowData[column.id] = "";
                }
                row.push(rowData);
            }
            for (var j = 0; j < row.length; j++) {
                for (var _i = 0, _d = Object.entries(row[j]); _i < _d.length; _i++) {
                    var _e = _d[_i], key = _e[0], value = _e[1];
                    totalRow[j] = __assign({}, totalRow[j]) || {};
                    totalRow[j] = Object.assign(totalRow[j], (_a = {}, _a[key] = value, _a));
                }
            }
        }
        return totalRow;
    };
    Grid.prototype._dragStart = function (event) {
        if (this.config.dragMode &&
            (this.config.dragItem === "row" || this.config.dragItem === "both") &&
            !this.config.$editable) {
            var rowId = this.data.getItem((0, html_1.locate)(event, "data-dhx-id")).id;
            if (event.targetTouches) {
                this._touch.start = true;
            }
            ts_data_1.dragManager.onMouseDown({
                event: event,
                source: [rowId],
                itemsForGhost: [this._getRowGhost([rowId])],
                type: "row",
            });
        }
    };
    Grid.prototype._dragProcess = function (event, row, column) {
        var _this = this;
        if (!event.targetTouches) {
            this._dragStart(event);
        }
        else {
            this._touch.timer = setTimeout(function () {
                _this._dragStart(event);
            }, this._touch.duration);
            if (!this._touch.timeStamp) {
                this._touch.timeStamp = +event.timeStamp.toFixed();
            }
            else {
                var doubleTap = this._touch.dblDuration >= this._touch.timeStamp - +event.timeStamp.toFixed();
                if (doubleTap) {
                    if ((column.editable !== false && this.config.editable) || column.editable) {
                        this.editCell(row.id, column.id, column.editorType);
                    }
                    event.preventDefault();
                    // to simulate on touch devices
                    this.events.fire(types_1.GridEvents.cellDblClick, [row, column, event]);
                }
                this._touch.timeStamp = null;
            }
            setTimeout(function () {
                _this._touch.timeStamp = null;
            }, this._touch.dblDuration);
        }
    };
    Grid.prototype._getRowGhost = function (ids) {
        var _a;
        var _b = this.config, $totalWidth = _b.$totalWidth, $width = _b.$width;
        var root = this.getRootNode();
        var leftFixedCols = (0, common_1.getCurrFixedCols)(this.config, types_1.Split.left);
        var rightFixedCols = (0, common_1.getCurrFixedCols)(this.config, types_1.Split.right);
        var scrollbarWidth = (0, common_1.calcScrollBarWidth)(this.config, !!((_a = this.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable));
        var rows = [];
        var _loop_3 = function (index) {
            var id = ids[index];
            var row = (0, dom_2.getRowNode)(id, root);
            if (!row)
                return "continue";
            var rowWidth = $totalWidth > $width - scrollbarWidth.y ? $width - scrollbarWidth.y - common_1.BORDERS : $totalWidth;
            if (leftFixedCols.length || rightFixedCols.length) {
                var complexRow = new Array(3);
                complexRow[1] = row;
                if (leftFixedCols.length) {
                    var el_1 = (0, dom_2.getRowNode)(id, root, "left");
                    rowWidth -= el_1.offsetWidth;
                    complexRow[0] = el_1;
                }
                if (rightFixedCols.length) {
                    var el_2 = (0, dom_2.getRowNode)(id, root, "right");
                    rowWidth -= el_2.offsetWidth;
                    complexRow[2] = el_2;
                }
                var complexRowContainer_1 = document.createElement("div");
                complexRowContainer_1.style.display = "flex";
                complexRow.forEach(function (el) {
                    if (!el)
                        return;
                    var clone = el.cloneNode(true);
                    if (el === row) {
                        var offset = (0, html_1.getNodeOffset)(el, root).left - (0, main_1.getTotalWidth)(leftFixedCols) - common_1.BORDERS / 2;
                        complexRowContainer_1.appendChild((0, dom_2.getVisibleRowNode)(clone, rowWidth, offset));
                    }
                    else {
                        clone.removeAttribute("aria-rowindex");
                        clone.style.width = el.offsetWidth + "px";
                        complexRowContainer_1.appendChild(clone);
                    }
                });
                return { value: complexRowContainer_1 };
            }
            var clone = row.cloneNode(true);
            rows.push((0, dom_2.getVisibleRowNode)(clone, rowWidth, (0, html_1.getNodeOffset)(row, root).left - common_1.BORDERS / 2));
        };
        for (var index = 0; index < ids.length; index++) {
            var state_1 = _loop_3(index);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        var ghostContainer = document.createElement("div");
        ghostContainer.style.setProperty("width", "initial", "important");
        rows.forEach(function (el) { return ghostContainer.appendChild(el); });
        return ghostContainer;
    };
    Grid.prototype._initHooks = function () {
        var _this = this;
        return {
            didMount: function () {
                if (_this._canDataParse(true)) {
                    if (!_this._container) {
                        _this._applyAutoWidth();
                    }
                    _this.data.parse(_this.config.data);
                }
                if (_this.config.autoWidth) {
                    _this._parseColumns();
                }
                if (_this.config.keyNavigation) {
                    if (_this.keyManager)
                        _this.keyManager.destructor();
                    _this.keyManager = new KeyManager_1.KeyManager(function (e, focusId) {
                        if (focusId === _this._uid && _this.events.fire(types_1.GridEvents.beforeKeyDown, [e])) {
                            _this.events.fire(types_1.GridEvents.afterKeyDown, [e]);
                            return true;
                        }
                        return false;
                    });
                    _this._initHotKey();
                }
            },
        };
    };
    Grid.prototype._normalizeDataType = function () {
        var _this = this;
        var numberColumns = this.config.columns.reduce(function (arr, col) {
            if (col.type === "number")
                arr.push(col);
            return arr;
        }, []);
        if (!numberColumns.length)
            return;
        this.data.forEach(function (item) {
            var _a;
            for (var _i = 0, numberColumns_1 = numberColumns; _i < numberColumns_1.length; _i++) {
                var col = numberColumns_1[_i];
                var value = (0, data_1.getValueForNumberColumn)(col, item[col.id]);
                if (Number.isNaN(value) && !item.$group) {
                    throw new Error("Incorrect data in column with type 'number', see docs: https://docs.dhtmlx.com/suite/grid/api/api_gridcolumn_properties/");
                }
                else if (item[col.id] !== value) {
                    _this.data.update(item.id, (_a = {}, _a[col.id] = value, _a), true);
                }
            }
        });
    };
    Grid.prototype._applyLocalFilter = function (beforePrepareData) {
        if (beforePrepareData === void 0) { beforePrepareData = false; }
        var filterConfig = { add: true, permanent: true, $local: true };
        var filters = this.data.getRawFilters();
        var localFilter = Object.keys(filters || {}).find(function (key) { return filters[key].config.$local; });
        if (localFilter) {
            filterConfig.id = localFilter;
        }
        if (beforePrepareData) {
            this.data.filter(function (i) { return i; }, filterConfig, true);
        }
        else {
            this.data.filter(function (i) { return i && !i.hidden; }, filterConfig, true);
        }
    };
    Grid.prototype._normalizeSpans = function () {
        var _this = this;
        var _a;
        this.config.spans = (_a = this.config.spans) === null || _a === void 0 ? void 0 : _a.map(function (span) { return (0, cells_2.normalizeSpan)(span, _this.config, _this.data); });
    };
    Grid.prototype._hideColumn = function (column) {
        column.hidden = true;
        this.config.$totalWidth -= column.$width;
        this._parseColumns();
        this.config.data = this._prepareData(this.data);
        var filter = this._activeFilters && this._activeFilters[column.id];
        if (filter) {
            if (!this._hiddenFilters) {
                this._hiddenFilters = {};
            }
            this._hiddenFilters[column.id] = filter;
            delete this._activeFilters[column.id];
            this._checkFilters();
        }
        this._normalizeSpans();
        this.paint();
    };
    Grid.prototype._showColumn = function (column) {
        column.hidden = false;
        this.config.$totalWidth += column.$width;
        this._parseColumns();
        this.config.data = this._prepareData(this.data);
        var filter = this._hiddenFilters && this._hiddenFilters[column.id];
        if (filter) {
            this._activeFilters[column.id] = filter;
            delete this._hiddenFilters[column.id];
            this._checkFilters();
            this._checkSelectFilterValue();
        }
        this._normalizeSpans();
        this.paint();
    };
    Grid.prototype._setSummary = function () {
        var _this = this;
        var rows = this.data.map(function (row) { return row; }).filter(function (i) { return i != i.$group && i != i.$groupSummary; });
        if (this.config.type === "tree") {
            rows = rows.filter(function (i) { return !_this.data.haveItems(i.id); });
        }
        if (this.config.summary) {
            Object.entries(this.config.summary).forEach(function (_a) {
                var key = _a[0], method = _a[1];
                _this._commonSummary[key] = _this._applyMethod(method, rows);
            });
        }
        this.config.columns.forEach(function (col) {
            var _a;
            if (col.summary) {
                var id_1 = col.id, summary = col.summary;
                if (!_this._colSummary[id_1])
                    _this._colSummary[id_1] = {};
                if (typeof summary === "string") {
                    _this._colSummary[id_1][summary] = (_a = ts_data_1.methods[summary]) === null || _a === void 0 ? void 0 : _a.call(ts_data_1.methods, rows, id_1);
                }
                else {
                    Object.entries(summary).forEach(function (_a) {
                        var key = _a[0], method = _a[1];
                        _this._colSummary[id_1][key] = _this._applyMethod(method, rows, id_1);
                    });
                }
            }
        });
    };
    Grid.prototype._applyMethod = function (method, rows, colId) {
        var _a;
        if (typeof method === "function") {
            return method(rows);
        }
        else if (typeof method === "string" && (ts_data_1.methods === null || ts_data_1.methods === void 0 ? void 0 : ts_data_1.methods[method])) {
            return ts_data_1.methods === null || ts_data_1.methods === void 0 ? void 0 : ts_data_1.methods[method](rows, colId);
        }
        else if (Array.isArray(method) && (ts_data_1.methods === null || ts_data_1.methods === void 0 ? void 0 : ts_data_1.methods[method === null || method === void 0 ? void 0 : method[1]])) {
            return (_a = ts_data_1.methods[method[1]]) === null || _a === void 0 ? void 0 : _a.call(ts_data_1.methods, rows, method[0]);
        }
        return null;
    };
    Grid.prototype._canDataParse = function (afterMount) {
        var _a;
        if (afterMount === void 0) { afterMount = false; }
        if (((_a = this.config.data) === null || _a === void 0 ? void 0 : _a.length) && this.config.data instanceof Array && this.config.columns) {
            return this.config.autoWidth && this.config.autoHeight
                ? afterMount
                : !afterMount;
        }
        return false;
    };
    Grid.prototype._init = function () {
        this.events = new events_1.EventSystem(this);
        this._events = new events_1.EventSystem(this);
        this._attachDataCollection();
        this.export = new Exporter_1.Exporter("grid", this.version, this);
        this._setEventHandlers();
    };
    Grid.prototype._attachDataCollection = function () {
        if (this.config.data instanceof ts_data_1.DataCollection) {
            this.data = this.config.data;
            this.data.config.collapsed = this.config.collapsed;
            this.config.data = this.data.serialize();
            return;
        }
        this._createCollection();
    };
    Grid.prototype._setMarks = function (col, func) {
        var colCellsData = [];
        var colCells = this.data.map(function (row) {
            colCellsData.push(row[col.id]);
            return {
                id: row.id,
                data: row[col.id],
                row: row,
            };
        });
        for (var _i = 0, colCells_1 = colCells; _i < colCells_1.length; _i++) {
            var cell = colCells_1[_i];
            var css = func(cell.data, colCellsData, cell.row, col);
            if (css) {
                col.$cellCss = col.$cellCss || {};
                col.$cellCss[cell.id] += " " + css;
            }
        }
    };
    Grid.prototype._checkMarks = function () {
        var _this = this;
        this.config.columns.map(function (col) {
            var mark = col.mark;
            if (mark) {
                if (typeof mark === "function") {
                    _this._setMarks(col, mark);
                }
                else {
                    _this._setMarks(col, function (el, c) {
                        var data = [];
                        c.forEach(function (item) {
                            if (item !== null && item !== undefined && item !== "") {
                                data.push(parseFloat(item));
                            }
                        });
                        var min = (0, core_1.getMinArrayNumber)(data);
                        var max = (0, core_1.getMaxArrayNumber)(data);
                        if (mark.max && max === parseFloat(el)) {
                            return mark.max;
                        }
                        if (mark.min && min === parseFloat(el)) {
                            return mark.min;
                        }
                        return false;
                    });
                }
            }
        });
    };
    Grid.prototype._removeMarks = function () {
        this.config.columns.forEach(function (col) {
            if (col.mark) {
                col.$cellCss = {};
            }
        });
    };
    // [todo] make more smart type detection
    Grid.prototype._detectColsTypes = function () {
        this.config.columns.forEach(function (col) {
            if (col.type) {
                return col;
            }
            if (col.numberMask) {
                col.type = "number";
                return col;
            }
            if (!col.type) {
                col.type = "string";
            }
        });
    };
    Grid.prototype._destroyContent = function () {
        for (var contentName in this.content) {
            if (contentName === "comboFilter") {
                this.content[contentName].destroy();
            }
        }
    };
    Grid.prototype._render = function () {
        this.paint();
    };
    Grid.prototype._initHotKey = function (secondInit) {
        if (secondInit === void 0) { secondInit = false; }
        var handlers = (0, keys_1.getKeysHandlers)(this);
        for (var key in handlers) {
            if (!this.keyManager.exist(key))
                this.keyManager.addHotKey(key, handlers[key]);
        }
        if (!secondInit) {
            for (var key in this.config.hotkeys) {
                this.keyManager.addHotKey(key, this.config.hotkeys[key]);
            }
        }
    };
    Grid.prototype._normalizeConfig = function (config) {
        Object.keys(config).forEach(function (key) {
            if (key.startsWith("$"))
                delete config[key];
        });
        return config;
    };
    Grid.prototype._autoScroll = function (mode) {
        var _a, _b, _c, _d;
        var elem = ((_a = this.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable)
            ? (_b = this.getRootNode()) === null || _b === void 0 ? void 0 : _b.querySelector(".scroll-view")
            : (_c = this.getRootNode()) === null || _c === void 0 ? void 0 : _c.querySelector(".dhx_grid-body");
        if (!elem)
            return;
        var timer = null;
        var _e = elem.getBoundingClientRect(), elemTop = _e.top, elemBottom = _e.bottom, elemLeft = _e.left, elemRight = _e.right, elemHeight = _e.height, elemWidth = _e.width;
        var STEP = 40;
        var DELAY = 100;
        var FIELD_WIDTH = 30;
        var dragPanelWidth = this.config.dragPanel
            ? ((_d = this.config.dragPanel) === null || _d === void 0 ? void 0 : _d.width) || default_1.defaultDragPanelConfig.width
            : 0;
        var scroll = function (directionX, directionY) {
            if (directionX) {
                elem.scrollBy(directionX === "left" ? -STEP : STEP, 0);
            }
            if (directionY) {
                elem.scrollBy(0, directionY === "up" ? -STEP : STEP);
            }
            if (directionX || directionY) {
                timer = setTimeout(function () {
                    scroll(directionX, directionY);
                }, DELAY);
            }
        };
        var handler = function (e) {
            var xPos = e.clientX;
            var yPos = e.clientY;
            var directionX = null;
            var directionY = null;
            switch (mode) {
                case "horizontal":
                    if (xPos > elemRight - FIELD_WIDTH &&
                        xPos < elemRight &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        directionX = "right";
                    }
                    else if (xPos > elemLeft &&
                        xPos < elemLeft + FIELD_WIDTH &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        directionX = "left";
                    }
                    break;
                case "vertical":
                    if (yPos > elemBottom - FIELD_WIDTH &&
                        yPos < elemBottom &&
                        xPos > elemLeft - dragPanelWidth &&
                        xPos < elemRight) {
                        directionY = "down";
                    }
                    else if (yPos > elemTop &&
                        yPos < elemTop + FIELD_WIDTH &&
                        xPos > elemLeft - dragPanelWidth &&
                        xPos < elemRight) {
                        directionY = "up";
                    }
                    break;
                case "auto":
                    if (xPos > elemRight - FIELD_WIDTH &&
                        xPos < elemRight &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        directionX = "right";
                    }
                    else if (xPos > elemLeft &&
                        xPos < elemLeft + FIELD_WIDTH &&
                        yPos > elemTop &&
                        yPos < elemBottom) {
                        directionX = "left";
                    }
                    if (yPos > elemBottom - FIELD_WIDTH &&
                        yPos < elemBottom &&
                        xPos > elemLeft - dragPanelWidth &&
                        xPos < elemRight) {
                        directionY = "down";
                    }
                    else if (yPos > elemTop &&
                        yPos < elemTop + FIELD_WIDTH &&
                        xPos > elemLeft - dragPanelWidth &&
                        xPos < elemRight) {
                        directionY = "up";
                    }
                    break;
            }
            if (directionX || directionY) {
                timer || scroll(directionX, directionY);
            }
            else if (timer) {
                clearTimeout(timer);
                timer = null;
            }
        };
        if (elemWidth < elem.scrollWidth || elemHeight < elem.scrollHeight) {
            document.addEventListener("pointermove", handler);
            document.addEventListener("pointerup", function () {
                document.removeEventListener("pointermove", handler);
                if (timer)
                    clearTimeout(timer);
            }, { once: true });
        }
    };
    Grid.prototype._applyAutoWidth = function () {
        var _a, _b;
        var parentNode = this._container || ((_a = this.getRootView().node.parent) === null || _a === void 0 ? void 0 : _a.el);
        if (!parentNode)
            return;
        var parentSizes = (0, render_1.getElementSizes)(parentNode);
        var scrollView = (_b = this.scrollView) === null || _b === void 0 ? void 0 : _b.config.enable;
        (0, render_1.applyAutoWidth)(this.config, parentSizes, scrollView);
    };
    Grid.prototype._handleRow = function (id, status) {
        if ((0, core_1.isId)(id) && status === "remove") {
            var removed = this.selection.getCells().find(function (cell) { return cell.row.id === id; });
            removed && this.selection.removeCell(removed.row.id, removed.column.id);
        }
        this.config.data = this._prepareData(this.data);
        if ((0, core_1.isId)(id)) {
            this._checkFilters();
            this._checkSelectFilterValue();
        }
        this._detectColsTypes();
        this._removeMarks();
        this._checkMarks();
        if (this.config.autoEmptyRow && (!this._activeFilters || (0, core_1.isEmptyObj)(this._activeFilters))) {
            var emptyRow = this.data.find({ by: "$emptyRow", match: true });
            if (emptyRow) {
                if (emptyRow.id === id)
                    return;
                this.data.move(emptyRow.id, this.data.getLength() - 1);
            }
            else {
                this._addEmptyRow();
            }
        }
        this._normalizeSpans();
        this._render();
    };
    return Grid;
}(view_1.View));
exports.Grid = Grid;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.proRender = exports.render = exports.applyAutoWidth = exports.getElementSizes = exports.getRenderConfig = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(2);
var data_1 = __webpack_require__(11);
var main_1 = __webpack_require__(10);
var types_1 = __webpack_require__(5);
var cells_1 = __webpack_require__(41);
var FixedCols_1 = __webpack_require__(106);
var FixedRows_1 = __webpack_require__(107);
var core_1 = __webpack_require__(1);
var common_1 = __webpack_require__(17);
var groupPanel_1 = __webpack_require__(233);
var subRow_1 = __webpack_require__(234);
var dragPanel_1 = __webpack_require__(235);
var default_1 = __webpack_require__(27);
function getWrapperAutoHeight(grid, config, wrapperSizes) {
    var _a, _b;
    var container = grid._container;
    var height = config.$headerHeight +
        (config.$footerHeight && config.$footerHeight + 1) +
        config.$totalHeight +
        common_1.BORDERS;
    if (container) {
        var _c = window.getComputedStyle(container), minHeight = _c.minHeight, maxHeight = _c.maxHeight;
        if (height <= parseFloat(minHeight)) {
            return parseFloat(minHeight);
        }
        else if (height >= parseFloat(maxHeight)) {
            return parseFloat(maxHeight);
        }
        else {
            return height + (0, common_1.calcScrollBarWidth)(config, !!((_a = grid.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable), wrapperSizes).x;
        }
    }
    else {
        return (height +
            (wrapperSizes ? (0, common_1.calcScrollBarWidth)(config, !!((_b = grid.scrollView) === null || _b === void 0 ? void 0 : _b.config.enable), wrapperSizes).x : 0));
    }
}
function isSpanVisible(span, visibility, _a, dataLength) {
    var _b = _a === void 0 ? [0, 0] : _a, fixedStart = _b[0], fixedEnd = _b[1];
    var spanStart = span[0], spanEnd = span[1];
    var visStart = visibility[0], visEnd = visibility[1];
    var isRangeVisible = (visStart <= spanStart && spanStart <= visEnd) ||
        (visStart <= spanEnd && spanEnd <= visEnd) ||
        (spanStart <= visStart && visEnd <= spanEnd);
    return isRangeVisible || spanStart < fixedStart || (fixedEnd && spanEnd >= dataLength - fixedEnd);
}
function getRenderConfig(obj, data, wrapperSizes) {
    var config = obj.config;
    var _a = config.spans, spans = _a === void 0 ? [] : _a, columns = config.columns, _b = config.leftSplit, leftSplit = _b === void 0 ? 0 : _b, _c = config.topSplit, topSplit = _c === void 0 ? 0 : _c, _d = config.rightSplit, rightSplit = _d === void 0 ? 0 : _d, _e = config.bottomSplit, bottomSplit = _e === void 0 ? 0 : _e;
    var filteredColumns = columns.filter(function (col) { return !col.hidden; });
    var positions = (0, data_1.calculateVisibleRange)(wrapperSizes, obj._scroll, config, data);
    var currentColumns = filteredColumns.slice(positions.xStart, positions.xEnd);
    var currentRows = data.slice(positions.yStart, positions.yEnd);
    var currentSpans = spans.filter(function (span) {
        var _a;
        if (!((_a = span.$renderFrom) === null || _a === void 0 ? void 0 : _a.length))
            return false;
        var rowInRange = isSpanVisible(span.$rowsVisibility, [positions.yStart, positions.yEnd], [topSplit, bottomSplit], data.length);
        var colInRange = isSpanVisible(span.$colsVisibility, [positions.xStart, positions.xEnd], [leftSplit, rightSplit], columns.length);
        return rowInRange && colInRange;
    });
    var fixedColumns = {
        left: (0, common_1.getCurrFixedCols)(config, types_1.Split.left),
        right: (0, common_1.getCurrFixedCols)(config, types_1.Split.right),
    };
    var fixedRows = {
        top: data.slice(0, config.topSplit || 0),
        bottom: config.bottomSplit ? data.slice(-config.bottomSplit) : [],
    };
    if (obj.config.$subRowCells)
        (0, subRow_1.setSubRowCell)(obj, currentRows);
    return __assign(__assign({}, config), { data: data, columns: config.columns, scroll: obj._scroll, $positions: positions, headerHeight: config.$headerHeight, footerHeight: config.$footerHeight, firstColId: filteredColumns[0] && filteredColumns[0].id, events: obj.events, _events: obj._events, filteredColumns: filteredColumns, currentColumns: currentColumns, currentRows: currentRows, currentSpans: currentSpans, fixedColumns: fixedColumns, fixedRows: fixedRows, sort: obj._sortingStates, content: obj.content, gridId: obj._uid, commonSummary: obj._commonSummary, colSummary: obj._colSummary, dropManager: obj._dropManager, blockSelection: obj.block, $renderFrom: "render" });
}
exports.getRenderConfig = getRenderConfig;
function getElementSizes(element) {
    if (!element)
        return;
    if (!element.tagName)
        element = element._parent._container;
    if (!element)
        return;
    var styles = element.currentStyle || window.getComputedStyle(element);
    var paddingsByWidth = parseFloat(styles.paddingLeft) + parseFloat(styles.paddingRight) || 0;
    var paddingsByHeight = parseFloat(styles.paddingTop) + parseFloat(styles.paddingBottom) || 0;
    return {
        width: element.clientWidth - paddingsByWidth,
        height: element.clientHeight - paddingsByHeight,
    };
}
exports.getElementSizes = getElementSizes;
function getGridData(renderConfig, shifts, scroll) {
    var content = (0, cells_1.getCells)(renderConfig);
    var filteredColumns = renderConfig.filteredColumns, $resizing = renderConfig.$resizing, $totalHeight = renderConfig.$totalHeight, $totalWidth = renderConfig.$totalWidth, leftSplit = renderConfig.leftSplit, data = renderConfig.data, $positions = renderConfig.$positions;
    var contentSpans = (0, cells_1.getSpans)(renderConfig);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var resizedLine;
    if ($resizing) {
        var colIndex = (0, core_1.findIndex)(filteredColumns, function (col) { return col.id === $resizing; });
        var firstCellLeft = (0, main_1.getTotalWidth)(filteredColumns.slice(0, colIndex)) + filteredColumns[colIndex].$width;
        resizedLine = (0, dom_1.el)(".dhx_grid-resize-line", {
            style: {
                top: 0,
                left: firstCellLeft,
                height: $totalHeight,
            },
        });
    }
    var dropLine = renderConfig.dropManager ? renderConfig.dropManager.toHTML() : null;
    var blockSelection = renderConfig.blockSelection ? renderConfig.blockSelection.toHTML() : null;
    var selection = renderConfig.selection ? renderConfig.selection.toHTML() : null;
    selection =
        typeof selection === "string" ? (0, dom_1.el)("div.dhx_selection", { ".innerHTML": selection }) : selection;
    var pos = $positions;
    return (0, dom_1.el)(".dhx_data-wrap", {
        style: {
            height: $totalHeight,
            width: $totalWidth,
            "padding-left": shifts.x,
            "padding-top": shifts.y,
        },
        role: "presentation",
        "data-dhx-drop-area": "row",
    }, [
        (0, dom_1.el)(".dhx_grid_data".concat(leftSplit ? ".dhx_grid_fixed_left" : ""), __assign(__assign({ _flags: dom_1.KEYED_LIST }, (0, cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), getRowAriaAttrs(data.length)), content),
        (0, subRow_1.getSubRowContent)(renderConfig),
        (0, dom_1.el)(".dhx_span-spans", __assign({ role: "presentation" }, (0, cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), contentSpans),
        (0, dom_1.el)(".dhx_grid_selection", { _ref: "selection", "aria-hidden": "true" }, [].concat(selection, resizedLine)),
        dropLine,
        blockSelection,
    ]);
}
function getContentHeight(renderConfig, isSticky, wrapperSizes) {
    var contentHeight = wrapperSizes.height - common_1.BORDERS;
    contentHeight = isSticky ? contentHeight : contentHeight - renderConfig.headerHeight;
    var isFooter = renderConfig.$footer;
    return (contentHeight = isFooter
        ? isSticky
            ? contentHeight
            : contentHeight - renderConfig.footerHeight
        : contentHeight);
}
function applyAutoWidth(config, wrapperSizes, scrollViewConfig) {
    if (scrollViewConfig === void 0) { scrollViewConfig = false; }
    var scrollbarY = !scrollViewConfig &&
        config.$totalHeight >= wrapperSizes.height - (config.$headerHeight || 0)
        ? (0, html_1.getScrollbarWidth)()
        : 0;
    var totalWidth = wrapperSizes.width - common_1.BORDERS - scrollbarY;
    if (totalWidth < 0) {
        return;
    }
    var columns = (config.columns || []).filter(function (col) { return !col.hidden; });
    var fixedColumns = [];
    var flexibleColumns = [];
    var checkLimit = false;
    columns.forEach(function (col) {
        if (!col.width && !col.$fixedWidth && (0, main_1.isAutoWidth)(config, col)) {
            flexibleColumns.push(col);
        }
        else {
            fixedColumns.push(col);
        }
    });
    do {
        checkLimit = false;
        var fullGravity = flexibleColumns.reduce(function (gravity, col) { return gravity + (col.gravity || 1); }, 0);
        var fixedWidth = (0, main_1.getTotalWidth)(fixedColumns);
        var _loop_1 = function (col) {
            var width = totalWidth > fixedWidth ? (totalWidth - fixedWidth) * ((col.gravity || 1) / fullGravity) : 0;
            var minLimit = col.minWidth && width < col.minWidth;
            var maxLimit = col.maxWidth && width > col.maxWidth;
            if (minLimit || maxLimit) {
                checkLimit = true;
                col.$width = minLimit ? col.minWidth : col.maxWidth;
                flexibleColumns = flexibleColumns.filter(function (c) { return c.id != col.id; });
                fixedColumns.push(col);
                return "break";
            }
            col.$width = width;
        };
        for (var _i = 0, flexibleColumns_1 = flexibleColumns; _i < flexibleColumns_1.length; _i++) {
            var col = flexibleColumns_1[_i];
            var state_1 = _loop_1(col);
            if (state_1 === "break")
                break;
        }
    } while (checkLimit);
}
exports.applyAutoWidth = applyAutoWidth;
function render(vm, obj, htmlEvents, selection, uid) {
    var parentSizes = getElementSizes(obj._container);
    // if grid placed inside another component, it will fit to its container
    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
        var parentNode = vm.node.parent.el;
        parentSizes = getElementSizes(parentNode);
    }
    var config = obj.config;
    // when grid is destructing and user try to repaint it
    if (!config) {
        return (0, dom_1.el)("div");
    }
    if (!config.columns.length) {
        return (0, dom_1.el)(".dhx_grid", {
            "data-dhx-widget-id": uid,
            "data-dhx-root-id": config.rootParent,
            "data-dhx-drop-area": "common",
            role: "empty-grid",
        });
    }
    var data = obj.data.getRawData(0, -1, null, 2);
    if (config.columns.reduce(function (check, col) { return (check = !col.hidden ? col.hidden : check); }, true)) {
        config.$totalHeight = 0;
    }
    else {
        config.$totalHeight = data.reduce(function (total, _a) {
            var $height = _a.$height;
            return (total += $height || 0);
        }, 0);
    }
    var width = config.width && typeof config.width === "number" ? config.width : parentSizes === null || parentSizes === void 0 ? void 0 : parentSizes.width;
    var height = config.height && typeof config.height === "number" ? config.height : parentSizes === null || parentSizes === void 0 ? void 0 : parentSizes.height;
    var wrapperSizes = { width: width || 0, height: height || 0 };
    // TODO: Remove scroll
    if ((0, main_1.isAutoWidth)(config)) {
        applyAutoWidth(config, wrapperSizes);
        config.$totalWidth = (0, main_1.getTotalWidth)(config.columns.filter(function (col) { return !col.hidden; }));
    }
    config.$width = wrapperSizes.width;
    config.$height = wrapperSizes.height;
    var renderConfig = getRenderConfig(obj, data, wrapperSizes);
    renderConfig.selection = selection;
    renderConfig.datacollection = obj.data;
    var shifts = (0, cells_1.getShifts)(renderConfig);
    renderConfig.$scrollBarWidth = (0, common_1.calcScrollBarWidth)(renderConfig);
    var isSticky = (0, main_1.isCssSupport)("position", "sticky");
    var gridBodyHeight = getContentHeight(renderConfig, isSticky, wrapperSizes);
    var layoutState = {
        wrapper: wrapperSizes,
        sticky: isSticky,
        shifts: shifts,
        gridBodyHeight: gridBodyHeight,
    };
    var header = (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "header", position: "top" }));
    var footer = renderConfig.$footer
        ? (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "footer", position: "bottom" }))
        : null;
    var lessByWidth = renderConfig.$totalWidth + common_1.BORDERS < wrapperSizes.width ? "dhx_grid-less-width" : "";
    var lessByHeight = renderConfig.$totalHeight + common_1.BORDERS < wrapperSizes.height ? "dhx_grid-less-height" : "";
    var fixedRight = renderConfig.fixedColumns.right.length ? "dhx_grid__contains_cols_right--fixed" : "";
    var fixedBottom = config.bottomSplit ? "dhx_grid__contains_rows_bottom--fixed" : "";
    var getGridAriaAttrs = function (rows, cols, isEditable, isMultiselectable) { return ({
        role: "grid",
        "aria-rowcount": rows.length,
        "aria-colcount": cols.filter(function (col) { return !col.hidden; }).length,
        "aria-readonly": isEditable ? "false" : "true",
        "aria-multiselectable": isMultiselectable ? "true" : "false",
    }); };
    // dirty: but work. Change checking of rendering Grid
    if (!vm.node) {
        var _a = obj.getScrollState(), x_1 = _a.x, y_1 = _a.y;
        (0, dom_1.awaitRedraw)().then(function () {
            obj.scroll(x_1, y_1);
        });
    }
    return (0, dom_1.el)(".dhx_grid.dhx_widget", __assign({ class: (renderConfig.css || "") +
            (!isSticky ? " dhx_grid_border" : "") +
            (config.multiselection ? " dhx_no-select--pointer" : ""), "data-dhx-widget-id": uid, "data-dhx-root-id": config.rootParent, "data-dhx-drop-area": "common" }, getGridAriaAttrs(renderConfig.data, config.columns, renderConfig.editable, renderConfig.multiselection)), [
        (0, dom_1.resizer)(function () { return obj.paint(); }),
        (0, dom_1.el)(".dhx_grid-content", __assign(__assign({ style: __assign({}, wrapperSizes) }, htmlEvents), { class: "".concat(lessByWidth, " ").concat(lessByHeight, " ").concat(fixedRight, " ").concat(fixedBottom).trim(), role: "presentation" }), [
            isSticky ? null : header,
            (0, dom_1.el)(".dhx_grid-body", {
                style: {
                    height: gridBodyHeight,
                    width: wrapperSizes.width - common_1.BORDERS,
                },
                onscroll: htmlEvents.onscroll,
                _ref: "grid_body",
                role: "presentation",
            }, [
                (0, dom_1.el)("div", {}, [
                    isSticky ? header : null,
                    getGridData(renderConfig, shifts),
                    isSticky ? footer : null,
                ]),
            ]),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.top),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.bottom),
            isSticky ? null : footer,
        ]),
    ]);
}
exports.render = render;
function proRender(vm, obj, htmlEvents, selection, uid) {
    var _a;
    var parentSizes = getElementSizes(obj._container);
    // if grid placed inside another component, it will fit to its container
    if (vm && vm.node && vm.node.parent && vm.node.parent.el) {
        var parentNode = vm.node.parent.el;
        parentSizes = getElementSizes(parentNode);
    }
    var config = obj.config;
    // when grid is destructing and user try to repaint it
    if (!config) {
        return (0, dom_1.el)("div");
    }
    if (!config.columns.length) {
        return (0, dom_1.el)(".dhx_grid", {
            "data-dhx-widget-id": uid,
            "data-dhx-root-id": config.rootParent,
            "data-dhx-drop-area": "common",
            role: "empty-grid",
        });
    }
    var data = obj.data.getRawData(0, -1, null, 2);
    var topSplit = config.topSplit || 0;
    var bottomSplit = config.bottomSplit || 0;
    var topFixedCount = 0;
    var bottomFixedCount = 0;
    if (config.columns.reduce(function (check, col) { return (check = !col.hidden ? col.hidden : check); }, true)) {
        config.$totalHeight = 0;
    }
    else {
        config.$totalHeight = data.reduce(function (total, row, index) {
            if (topSplit && index < topSplit + topFixedCount) {
                row.$subRowHeight = 0;
                row.$opened = false;
                if (row.hidden)
                    topFixedCount++;
            }
            if (bottomSplit && index >= data.length - bottomSplit - bottomFixedCount) {
                row.$subRowHeight = 0;
                row.$opened = false;
                if (row.hidden)
                    bottomFixedCount++;
            }
            row.$index = index;
            return (total += (0, data_1.getTotalRowHeight)(row));
        }, 0);
    }
    var wrapperAutoHeight;
    if (obj.config.height === "auto") {
        wrapperAutoHeight = getWrapperAutoHeight(obj, config, parentSizes);
    }
    var width = config.width && typeof config.width === "number" ? config.width : parentSizes === null || parentSizes === void 0 ? void 0 : parentSizes.width;
    var height = config.height && typeof config.height === "number" ? config.height : parentSizes === null || parentSizes === void 0 ? void 0 : parentSizes.height;
    var wrapperSizes = {
        width: width || 0,
        height: (obj.config.height === "auto" ? wrapperAutoHeight : height) || 0,
    };
    var group = config === null || config === void 0 ? void 0 : config.group;
    var dragPanel = config === null || config === void 0 ? void 0 : config.dragPanel;
    var isGroupPanelEnable = group === null || group === void 0 ? void 0 : group.panel;
    var isDropPanelEnable = !!config.dragPanel;
    if (isGroupPanelEnable)
        wrapperSizes.height -= group.panelHeight || 40;
    if (isDropPanelEnable)
        wrapperSizes.width -= (dragPanel === null || dragPanel === void 0 ? void 0 : dragPanel.width) || default_1.defaultDragPanelConfig.width;
    // TODO: Remove scroll
    if ((0, main_1.isAutoWidth)(config)) {
        applyAutoWidth(config, wrapperSizes, obj.scrollView && obj.scrollView.config.enable);
        config.$totalWidth = (0, main_1.getTotalWidth)(config.columns.filter(function (col) { return !col.hidden; }));
    }
    config.$width = wrapperSizes.width;
    config.$height = wrapperSizes.height;
    var renderConfig = getRenderConfig(obj, data, wrapperSizes);
    renderConfig.selection = selection;
    renderConfig.datacollection = obj.data;
    var shifts = (0, cells_1.getShifts)(renderConfig);
    renderConfig.$scrollBarWidth = (0, common_1.calcScrollBarWidth)(renderConfig, !!((_a = obj.scrollView) === null || _a === void 0 ? void 0 : _a.config.enable));
    var isSticky = (0, main_1.isCssSupport)("position", "sticky");
    var gridBodyHeight = getContentHeight(renderConfig, isSticky, wrapperSizes);
    var layoutState = {
        wrapper: wrapperSizes,
        sticky: isSticky,
        shifts: shifts,
        gridBodyHeight: gridBodyHeight,
    };
    var header = (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "header", position: "top" }));
    var footer = renderConfig.$footer
        ? (0, FixedRows_1.getFixedRows)(renderConfig, __assign(__assign({}, layoutState), { name: "footer", position: "bottom" }))
        : null;
    var lessByWidth = renderConfig.$totalWidth + common_1.BORDERS < wrapperSizes.width ? "dhx_grid-less-width" : "";
    var lessByHeight = renderConfig.$totalHeight + common_1.BORDERS <
        wrapperSizes.height - renderConfig.$footerHeight - renderConfig.$headerHeight
        ? "dhx_grid-less-height"
        : "";
    var fixedRight = renderConfig.fixedColumns.right.length ? "dhx_grid__contains_cols_right--fixed" : "";
    var fixedBottom = config.bottomSplit ? "dhx_grid__contains_rows_bottom--fixed" : "";
    // dirty: but work. Change checking of rendering Grid
    if (!vm.node) {
        var _b = obj.getScrollState(), x_2 = _b.x, y_2 = _b.y;
        (0, dom_1.awaitRedraw)().then(function () {
            obj.scroll(x_2, y_2);
        });
    }
    var gridContent = (0, dom_1.el)("div", {}, [
        isSticky ? header : null,
        getGridData(renderConfig, shifts, obj.getScrollState()),
        isSticky ? footer : null,
    ]);
    return (0, dom_1.el)(".dhx_grid.dhx_widget", {
        class: (renderConfig.css || "") +
            (!isSticky ? " dhx_grid_border" : "") +
            (config.multiselection ? " dhx_no-select--pointer" : ""),
        style: {
            height: wrapperAutoHeight !== null && wrapperAutoHeight !== void 0 ? wrapperAutoHeight : null,
        },
        "data-dhx-widget-id": uid,
        "data-dhx-root-id": config.rootParent,
        role: "grid",
        "aria-rowcount": renderConfig.data.length,
        "aria-colcount": renderConfig.filteredColumns.length,
        "data-dhx-drop-area": "common",
    }, [
        (0, dom_1.resizer)(function () { return obj.paint(); }),
        (isGroupPanelEnable && (0, groupPanel_1.getGroupPanel)(config.$grouped, obj)) || null,
        (isDropPanelEnable && (0, dragPanel_1.getDragPanelNode)(obj, renderConfig, layoutState, !!lessByHeight)) || null,
        (0, dom_1.el)(".dhx_grid-content", __assign(__assign({ style: __assign({}, wrapperSizes) }, htmlEvents), { class: "".concat(lessByWidth, " ").concat(lessByHeight, " ").concat(fixedRight, " ").concat(fixedBottom).trim(), role: "presentation" }), [
            isSticky ? null : header,
            (0, dom_1.el)(".dhx_grid-body", {
                style: {
                    height: gridBodyHeight,
                    width: wrapperSizes.width - common_1.BORDERS,
                },
                onscroll: htmlEvents.onscroll,
                _ref: "grid_body",
                role: "presentation",
            }, [
                obj.scrollView && obj.scrollView.config.enable
                    ? obj.scrollView.render([gridContent])
                    : gridContent,
            ]),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedColsHeader)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.left),
            (0, FixedCols_1.getFixedCols)(renderConfig, layoutState, types_1.Split.right),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.top),
            (0, FixedRows_1.getFixedDataRows)(renderConfig, layoutState, types_1.Split.bottom),
            isSticky ? null : footer,
        ]),
    ]);
}
exports.proRender = proRender;


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFixedCols = exports.getFixedColsHeader = void 0;
var dom_1 = __webpack_require__(0);
var types_1 = __webpack_require__(5);
var cells_1 = __webpack_require__(41);
var FixedRows_1 = __webpack_require__(107);
var main_1 = __webpack_require__(10);
var common_1 = __webpack_require__(17);
function getFixedColsHeader(renderConfig, layout, mode) {
    if ((mode === types_1.Split.left &&
        (typeof renderConfig.leftSplit !== "number" || !renderConfig.fixedColumns.left.length)) ||
        (mode === types_1.Split.right &&
            (typeof renderConfig.rightSplit !== "number" || !renderConfig.fixedColumns.right.length))) {
        return;
    }
    var leftSplit = renderConfig.leftSplit, rightSplit = renderConfig.rightSplit, $positions = renderConfig.$positions, $totalWidth = renderConfig.$totalWidth, $scrollBarWidth = renderConfig.$scrollBarWidth;
    var isRightSplit = mode === types_1.Split.right;
    var columns = isRightSplit ? renderConfig.fixedColumns.right : renderConfig.fixedColumns.left;
    var width = (0, main_1.getTotalWidth)(columns);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var frozenHeaderCols = (0, FixedRows_1.getFixedRows)(__assign(__assign({}, renderConfig), { currentColumns: columns, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }), scroll: { top: 0, left: 0 }, filteredColumns: columns }), __assign(__assign({}, layout), { name: "header", position: "top", shifts: { x: 0, y: 0 } }), mode);
    var headerRowsConfig = __assign(__assign({}, layout), { name: "header", position: "top" });
    return (0, dom_1.el)(".dhx_".concat(headerRowsConfig.name, "-fixed-cols"), __assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
            position: "absolute",
            top: 0,
            left: isRightSplit
                ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - common_1.BORDERS
                    ? $totalWidth - width
                    : layout.wrapper.width - width - $scrollBarWidth.y - common_1.BORDERS
                : 0,
            width: width,
            overflow: "hidden",
        } }, getRowAriaAttrs(frozenHeaderCols.length)), frozenHeaderCols.body);
}
exports.getFixedColsHeader = getFixedColsHeader;
function getFixedCols(renderConfig, layout, mode, source) {
    if ((mode === types_1.Split.left &&
        (typeof renderConfig.leftSplit !== "number" || !renderConfig.fixedColumns.left.length)) ||
        (mode === types_1.Split.right &&
            (typeof renderConfig.rightSplit !== "number" || !renderConfig.fixedColumns.right.length))) {
        return;
    }
    var leftSplit = renderConfig.leftSplit, rightSplit = renderConfig.rightSplit, $totalWidth = renderConfig.$totalWidth, $totalHeight = renderConfig.$totalHeight, headerHeight = renderConfig.headerHeight, configFooterHeight = renderConfig.footerHeight, $positions = renderConfig.$positions, scroll = renderConfig.scroll, data = renderConfig.data, $scrollBarWidth = renderConfig.$scrollBarWidth;
    var isRightSplit = mode === types_1.Split.right;
    var fixedContentHeight = $totalHeight + headerHeight + configFooterHeight;
    var fixedColsHeight;
    if (fixedContentHeight > layout.gridBodyHeight) {
        fixedColsHeight = renderConfig.$footer
            ? fixedContentHeight - $scrollBarWidth.x
            : layout.gridBodyHeight;
    }
    else if (fixedContentHeight < layout.gridBodyHeight - $scrollBarWidth.x) {
        fixedColsHeight = fixedContentHeight;
    }
    else {
        fixedColsHeight = renderConfig.$footer
            ? layout.gridBodyHeight
            : layout.gridBodyHeight - $scrollBarWidth.x;
    }
    var columns = isRightSplit ? renderConfig.fixedColumns.right : renderConfig.fixedColumns.left;
    var width = (0, main_1.getTotalWidth)(columns);
    var renderFrom = isRightSplit ? "rightFixedCols" : "leftFixedCols";
    var fixedCols = (0, cells_1.getCells)(__assign(__assign({}, renderConfig), { filteredColumns: columns, $renderFrom: renderFrom, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }) }));
    var isSticky = layout.sticky;
    var footerRowsConfig = __assign(__assign({}, layout), { name: "footer", position: "bottom" });
    var frozenFooterCols = (0, FixedRows_1.getRows)(__assign(__assign({}, renderConfig), { currentColumns: columns, $positions: __assign(__assign({}, $positions), { xStart: 0, xEnd: isRightSplit ? rightSplit : leftSplit }) }), __assign(__assign({}, layout), { name: "footer", position: "bottom" }));
    var footerHeight = 0;
    frozenFooterCols.forEach(function (node) { return (footerHeight += node.attrs.style.height); });
    var frozenFooterSpans = (0, FixedRows_1.getFixedSpans)(__assign(__assign({}, renderConfig), { filteredColumns: columns }), __assign(__assign({}, layout), { name: "footer", position: "bottom" }), mode);
    var getRowAriaAttrs = function (count) { return ({
        role: "rowgroup",
        "aria-rowcount": count,
    }); };
    var frozenFooter = isSticky
        ? (0, dom_1.el)(".dhx_".concat(footerRowsConfig.name, "-fixed-cols"), __assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
                position: "absolute",
                top: fixedColsHeight < layout.gridBodyHeight ? fixedColsHeight - footerHeight : null,
                left: isRightSplit
                    ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - common_1.BORDERS
                        ? $totalWidth - width
                        : layout.wrapper.width - width - $scrollBarWidth.y - common_1.BORDERS
                    : 0,
                bottom: fixedColsHeight >= layout.gridBodyHeight
                    ? "".concat(isSticky ? $scrollBarWidth.x : 0, "px")
                    : null,
                overflow: "hidden",
            } }, getRowAriaAttrs(frozenFooterCols.length)), __spreadArray(__spreadArray([], frozenFooterCols, true), [
            (0, dom_1.el)("span.dhx_span-spans", {
                class: "dhx_footer-spans",
                role: "presentation",
            }, frozenFooterSpans),
        ], false))
        : null;
    var pos = $positions;
    var spans = (0, cells_1.getSpans)(__assign(__assign({}, renderConfig), { $renderFrom: renderFrom }), source || (isRightSplit ? types_1.Split.right : types_1.Split.left));
    var getFixedColAriaAttrs = function () { return ({
        role: "presentation",
        "aria-label": "Fixed column",
    }); };
    return [
        (0, dom_1.el)(".dhx_grid-fixed-cols-wrap", __assign({ style: {
                left: isRightSplit
                    ? $totalWidth < layout.wrapper.width - $scrollBarWidth.y - common_1.BORDERS
                        ? $totalWidth - width
                        : layout.wrapper.width - width - $scrollBarWidth.y - common_1.BORDERS
                    : 0,
                height: fixedColsHeight >= layout.gridBodyHeight
                    ? (isSticky ? layout.gridBodyHeight : layout.gridBodyHeight + headerHeight) -
                        $scrollBarWidth.x
                    : fixedColsHeight,
                paddingTop: headerHeight,
                overflow: "hidden",
                width: width,
            } }, getFixedColAriaAttrs()), [
            (0, dom_1.el)(".dhx_grid-fixed-cols", __assign(__assign({ onwheel: main_1.scrollFixedColsAndRows, class: isRightSplit ? "dhx_grid__cols_right--fixed" : "dhx_grid__cols_left--fixed", style: {
                    top: -scroll.top + headerHeight - 1 + "px",
                    paddingTop: layout.shifts.y,
                    height: $totalHeight,
                    position: "absolute",
                }, _flags: dom_1.KEYED_LIST }, (0, cells_1.getHandlers)(pos.yStart, pos.xStart, renderConfig)), getRowAriaAttrs(data.length)), __spreadArray(__spreadArray([], fixedCols, true), [spans && (0, dom_1.el)("span.dhx_span-spans", { role: "presentation" }, spans)], false)),
            isRightSplit
                ? (0, dom_1.el)(".dhx_grid__cols-border--frozen", { role: "presentation", style: { left: 0 } })
                : (0, dom_1.el)(".dhx_grid__cols-border--frozen", { role: "presentation", style: { right: 0 } }),
        ]),
        renderConfig.$footer ? frozenFooter : null,
    ];
}
exports.getFixedCols = getFixedCols;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFixedDataRows = exports.getFixedRows = exports.getFixedSpans = exports.getRows = void 0;
var dom_1 = __webpack_require__(0);
var cells_1 = __webpack_require__(24);
var main_1 = __webpack_require__(10);
var types_1 = __webpack_require__(5);
var cells_2 = __webpack_require__(41);
var FixedCols_1 = __webpack_require__(106);
var core_1 = __webpack_require__(1);
var common_1 = __webpack_require__(17);
var data_1 = __webpack_require__(11);
function handleMouse(cell, col, config, type, event) {
    if (!type)
        return;
    var systemEvent = type.toLocaleLowerCase().includes("touch");
    if (systemEvent) {
        config._events.fire(type, [cell, col, event]);
    }
    else {
        config.events.fire(type, [cell, col, event]);
    }
}
function getHandlers(column, rowName, config, cell) {
    return {
        onclick: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellClick"]],
        onmouseover: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellMouseOver"]],
        onmousedown: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellMouseDown"]],
        ontouchstart: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellMouseDown"]],
        ondblclick: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellDblClick"]],
        oncontextmenu: [handleMouse, cell, column, config, types_1.GridEvents[rowName + "CellRightClick"]],
        ontouchmove: [handleMouse, cell, column, config, types_1.GridSystemEvents[rowName + "CellTouchMove"]],
        ontouchend: [handleMouse, cell, column, config, types_1.GridSystemEvents[rowName + "CelltouchEnd"]],
    };
}
function buildRows(columns, name) {
    var header = columns.map(function (col) { return col[name] || [{}]; });
    return (0, main_1.transpose)(header);
}
function getCustomContentCell(cell, column, config, rowName, css, rowIndex) {
    if (css === void 0) { css = ""; }
    var type = column.type ? "dhx_".concat(column.type, "-cell") : "dhx_string-cell";
    // TODO: over with index of filter inside of header or footer
    var content = config.content[cell.content] && config.content[cell.content].toHtml(column, config);
    var cellRow = {};
    config.filteredColumns.forEach(function (col) {
        var hasContent = !!config.content[col[rowName][rowIndex].content];
        cellRow[col.id] =
            (hasContent && config.content[col[rowName][rowIndex].content].toHtml(col, config)) ||
                col[rowName][rowIndex].text;
    });
    return (0, dom_1.el)(".".concat(type), {
        style: {
            class: css.trim(),
            padding: 0,
        },
    }, [content]);
}
function getRows(config, rowsConfig) {
    if (!config.data || !config.filteredColumns) {
        return [];
    }
    var getRowAriaAttrs = function (ind) { return ({
        role: "row",
        "aria-rowindex": ind + 1,
    }); };
    var rowName = rowsConfig.name;
    var isAutoHeight = rowName === "header" ? config.headerAutoHeight : config.footerAutoHeight;
    var pos = config.$positions;
    var columns = config.currentColumns;
    var rows = buildRows(columns, rowName);
    var colRange;
    var colsCount = 1;
    return rows.map(function (row, j) {
        var rowHeight = (rowName === "header"
            ? config.$headerHeightMap
            : config.$footerHeightMap)[j];
        return (0, dom_1.el)(".dhx_".concat(rowName, "-row"), __assign({ style: {
                height: rowHeight,
            } }, getRowAriaAttrs(j)), row.map(function (cell, i) {
            var _a;
            var css = cell.css || "";
            var column = columns[i];
            var colIndex = pos.xStart + i + 1;
            var isHTMLEnable = (0, main_1.isHtmlEnable)(config, column, cell);
            var sortIconCss = "dxi dxi-arrow-up dhx_grid-sort-icon";
            var ariaSort = "none";
            var text = cell.text;
            if (typeof cell.text === "function") {
                var summary = __assign(__assign({}, config.commonSummary), config.colSummary[column.id]);
                if (typeof column.summary === "string" && column.summary !== "count") {
                    summary[column.summary] = (0, data_1.applyPattern)(summary[column.summary], column);
                }
                text = cell.text(summary);
            }
            var sortIndex = config.sort.findIndex(function (i) { return i.by == column.id; });
            var sort = config.sort[sortIndex];
            if (sort && !cell.content) {
                sortIconCss += " dhx_grid-sort-icon--".concat(sort.dir);
                css += " dhx_grid-".concat(rowName, "-cell--sorted ");
                ariaSort = sort.dir === "asc" ? "ascending" : "descending";
            }
            var sortIconVisible = (0, main_1.isSortable)(config, column) &&
                cell.text &&
                rowName !== "footer" &&
                cell.headerSort !== false;
            if (sortIconVisible) {
                css += " dhx_grid-header-cell--sortable";
            }
            var isFirstCol = i === 0 ? "dhx_first-column-cell" : "";
            var isLastCol = i === columns.length - 1 ? "dhx_last-column-cell" : "";
            if (!cell.content) {
                if (cell.align) {
                    css += " dhx_grid-header-cell--align_".concat(cell.align, " ");
                }
                else {
                    css += " dhx_grid-header-cell--".concat(column.type === "number" || column.type === "date" ? "align_right" : "align_left", " ");
                }
            }
            css += "".concat(isFirstCol, " ").concat(isLastCol);
            var resizable = column.resizable !== undefined ? column.resizable : config.resizable;
            if (resizable) {
                var isLeftResize = config.rightSplit &&
                    config.$scrollBarWidth.xState &&
                    config.fixedColumns.right.includes(column);
                resizable = (0, dom_1.el)("div", {
                    class: "dhx_resizer_grip_wrap",
                    "aria-hidden": "true",
                }, [
                    (0, dom_1.el)("div", {
                        class: "dhx_resizer_grip" +
                            (isLeftResize
                                ? " dhx_resizer_grip--left"
                                : " dhx_resizer_grip--right"),
                        dhx_resized: column.id,
                        style: {
                            height: "".concat(rows.length * 100, "%"),
                        },
                    }, [(0, dom_1.el)("div", { class: "dhx_resizer_grip_line" })]),
                ]);
                var colSpan = column.header && ((_a = column.header[0]) === null || _a === void 0 ? void 0 : _a.colspan);
                if (colSpan) {
                    colRange = colSpan;
                    colsCount = 1;
                }
                if (colRange && colsCount !== colRange) {
                    if (j === 0)
                        resizable = null;
                    colsCount++;
                }
                if (rowName === "footer") {
                    resizable = null;
                }
            }
            if (cell.align) {
                css += " dhx_align-".concat(cell.align);
            }
            var getCellAriaAttrs = function (rowName, colIndex, ariaSort) {
                var attrs = {
                    "aria-colindex": colIndex,
                };
                if (!sortIconVisible) {
                    // if cell is sortable - set tabindex on button (getInnerCellAriaAttrs),
                    // else - on cell
                    // attrs["tabindex"] = 0;
                    // TODO: after sort AND if first cell is not visible: selection.setCell(first cell) -> scrollTo
                    // TODO: use arrows to navigate, set tabindex for first cell only
                }
                if (rowName === "footer" || cell.content) {
                    attrs["role"] = "gridcell";
                }
                else {
                    attrs["role"] = "columnheader";
                    attrs["aria-sort"] = ariaSort;
                    // attrs["aria-label"] = title;
                }
                return attrs;
            };
            if (cell.content) {
                return (0, dom_1.el)(".dhx_grid-".concat(rowName, "-cell.dhx_grid-custom-content-cell"), __assign(__assign({ class: css.trim(), "data-dhx-id": column.id, "data-dhx-text-id": cell.id, _key: column.id, style: {
                        width: column.$width,
                        height: rowName === "footer" ? rowHeight + common_1.BORDERS / 2 + "px" : rowHeight + "px",
                    } }, getHandlers(column, rowName, config, cell)), getCellAriaAttrs(rowName, colIndex, ariaSort)), [getCustomContentCell(cell, column, config, rowName, "", j), resizable || null]);
            }
            var getInnerCellAriaAttrs = function (rowName, text) {
                return sortIconVisible
                    ? {
                        role: "button",
                        "aria-label": "Sort by ".concat(text),
                        // tabindex: 0,
                        // TODO: after sort AND if first cell is not visible: selection.setCell(first cell) -> scrollTo
                        // TODO: use arrows to navigate, set tabindex for first cell only
                    }
                    : {};
            };
            var cellCss = "dhx_grid-header-cell-text_content";
            if (isAutoHeight)
                cellCss += " dhx_grid-header-cell-text_content-auto-height";
            return (0, dom_1.el)(".dhx_grid-".concat(rowName, "-cell"), __assign(__assign({ class: css.trim(), "data-dhx-id": column.id, "data-dhx-text-id": cell.id, _key: column.id, style: {
                    width: column.$width,
                    height: rowName === "footer" ? rowHeight + common_1.BORDERS / 2 + "px" : rowHeight + "px",
                } }, getHandlers(column, rowName, config, cell)), getCellAriaAttrs(rowName, colIndex, ariaSort)), [
                (0, dom_1.el)("div.dhx_grid-header-cell-text", {
                    role: "presentation",
                }, [
                    (0, dom_1.el)("span", __assign(__assign({ class: cellCss }, getInnerCellAriaAttrs(rowName, text)), { ".innerHTML": isHTMLEnable ? text : null }), isHTMLEnable ? null : text),
                    resizable || null,
                ]),
                sortIconVisible &&
                    (0, dom_1.el)("div.dhx_grid-sort", [
                        (0, dom_1.el)("div", { class: sortIconCss, "aria-hidden": "true" }),
                        (sort &&
                            config.sort.length > 1 &&
                            (0, dom_1.el)("div.dhx_grid-sort-counter", { "aria-hidden": "true" }, [
                                sortIndex + 1,
                            ])) ||
                            null,
                    ]),
            ]);
        }));
    });
}
exports.getRows = getRows;
function getFixedSpans(config, rowsConfig, mode) {
    var columns = config.columns, cols = config.filteredColumns;
    var rows = (0, main_1.transpose)(cols.map(function (col) { return col[rowsConfig.name] || []; }));
    var rowName = rowsConfig.name;
    var isAutoHeight = rowName === "header" ? config.headerAutoHeight : config.footerAutoHeight;
    var heightMap = (rowName === "header" ? config.$headerHeightMap : config.$footerHeightMap);
    var leftShift = 0;
    return rows.map(function (row, i) {
        leftShift = 0;
        var rowHeight = heightMap[i];
        return (0, dom_1.el)(".dhx_span-row", {
            class: "dhx_header-row",
            "aria-hidden": "true",
        }, row
            .map(function (cell, cellIdx) {
            var spanPartByRightSplit;
            var col = cols[cellIdx];
            if (mode === types_1.Split.right && cellIdx === 0 && !(cell.colspan > 1)) {
                var rows_1 = (0, main_1.transpose)(columns.map(function (col) { return col[rowsConfig.name] || []; }));
                outer: for (var j = 0; j < rows_1[i].length; j++) {
                    var currCell = rows_1[i][j];
                    if (currCell.colspan > 1) {
                        var spanCols = columns.slice(j, j + currCell.colspan);
                        for (var k = 0; k < spanCols.length; k++) {
                            if (spanCols[k].id !== col.id)
                                continue;
                            spanPartByRightSplit = {
                                cell: currCell,
                                col: columns[j],
                                widthBefore: (0, cells_1.getWidth)(spanCols, k, 0),
                                isLastCol: j + currCell.colspan >= columns.length,
                            };
                            break outer;
                        }
                    }
                }
            }
            var nCell = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.cell) || cell;
            var nCol = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.col) || col;
            var isHTMLEnable = (0, main_1.isHtmlEnable)(config, col, cell);
            leftShift += nCol.hidden ? 0 : nCol.$width;
            var isFirstCol = cellIdx === 0 ? "dhx_first-column-cell" : "";
            var n = mode ? 1 : config.fixedColumns.right.length + 1;
            var reducedColspan = cell.colspan > 1 && (0, cells_1.getReducedColspan)(columns, col.id, cell.colspan);
            var isLastCol = (spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.isLastCol) ||
                cellIdx === cols.length - n ||
                (reducedColspan || 1) + (cellIdx - 1) >= cols.length - n
                ? "dhx_last-column-cell"
                : "";
            var spanHeight = rowHeight;
            var spanPositionTop = rowHeight * i;
            if (nCell.rowspan > 1) {
                var count = nCell.rowspan - 1;
                while (count > 0) {
                    spanHeight += heightMap[i + count];
                    count--;
                }
                spanHeight -= 1;
            }
            if (nCell.rowspan > 1 || nCell.colspan > 1) {
                spanPositionTop = 0;
                for (var j = i - 1; j >= 0; j--) {
                    spanPositionTop += heightMap[j];
                }
            }
            var sortIconVisible = (0, main_1.isSortable)(config, nCol) &&
                nCell.rowspan > 1 &&
                nCell.text &&
                rowsConfig.name !== "footer" &&
                nCell.headerSort !== false;
            var sortIconCss = "dxi dxi-arrow-up dhx_grid-sort-icon";
            var sortIndex = config.sort.findIndex(function (i) { return i.by == nCol.id; });
            var sort = config.sort[sortIndex];
            if (sort && !nCell.content) {
                sortIconCss += " dhx_grid-sort-icon--".concat(sort.dir);
            }
            var cellAlign = nCol.align
                ? "dhx_align-".concat(nCol.align)
                : (nCol.type === "number" || nCol.type === "percent" || nCol.type === "date") &&
                    !(nCell.colspan > 1)
                    ? "dhx_align-right"
                    : "dhx_align-left";
            var css = "dhx_grid-".concat(rowName, "-cell ").concat(isFirstCol, " ").concat(isLastCol, " ").concat(nCell.rowspan > 1 ? "dhx_span-cell__rowspan" : "", " ").concat(nCell.align ? "dhx_align-".concat(nCell.align) : cellAlign, " ").concat(nCell.css ? nCell.css : "");
            if (!nCol.$target && sortIconVisible) {
                css += " dhx_grid-header-cell--sortable";
            }
            if (!nCell.content) {
                if (nCell.align) {
                    css += " dhx_grid-header-cell--align_".concat(nCell.align, " ");
                }
                else {
                    css += " dhx_grid-header-cell--".concat(nCol.type === "number" || nCol.type === "percent" || nCol.type === "date"
                        ? "align_right"
                        : "align_left", " ");
                }
            }
            if (nCol.$target && rowName === "header") {
                css += " dhx_grid-header-drop-area--".concat(nCol.$target, " ");
            }
            var text = nCell.text;
            if (typeof nCell.text === "function") {
                var summary = __assign(__assign({}, config.commonSummary), config.colSummary[col.id]);
                if (typeof col.summary === "string" && col.summary !== "count") {
                    summary[col.summary] = (0, data_1.applyPattern)(summary[col.summary], col);
                }
                text = nCell.text(summary);
            }
            var content = null;
            if (nCell.content) {
                content = getCustomContentCell(nCell, nCol, config, rowName, css, i);
                content.attrs.style = __assign(__assign({}, content.attrs.style), { width: "100%", borderRight: "0" });
            }
            var borderLeft = "";
            if (leftShift - nCol.$width > 0) {
                borderLeft = "var(--dhx-border)";
            }
            var cellCss = "dhx_grid-header-cell-text_content";
            if (isAutoHeight)
                cellCss += " dhx_grid-header-cell-text_content-auto-height";
            var spanElement = (0, dom_1.el)("span", {
                class: cellCss,
                ".innerHTML": isHTMLEnable ? text : null,
            }, isHTMLEnable ? null : text);
            return nCell.colspan > 1 || nCell.rowspan > 1
                ? (0, dom_1.el)(".dhx_span-cell", __assign({ style: {
                        width: (0, cells_1.getWidth)(columns, nCell.colspan, (0, core_1.findIndex)(columns, function (item) { return item.id === nCol.id; })),
                        height: spanHeight,
                        left: leftShift -
                            nCol.$width -
                            ((spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.widthBefore) || 0),
                        borderLeft: borderLeft,
                        top: spanPositionTop,
                    }, class: css.trim(), "data-dhx-id": nCol.id, "data-dhx-text-id": nCell.id }, getHandlers(nCol, rowName, config, nCell)), [
                    content || nCell.rowspan > 1
                        ? (0, dom_1.el)("div.dhx_grid-header-cell-text", {
                            role: "presentation",
                        }, [spanElement])
                        : spanElement,
                    sortIconVisible &&
                        (0, dom_1.el)("div.dhx_grid-sort", [
                            (0, dom_1.el)("div", { class: sortIconCss, "aria-hidden": "true" }),
                            (sort &&
                                config.sort.length > 1 &&
                                (0, dom_1.el)("div.dhx_grid-sort-counter", { "aria-hidden": "true" }, [
                                    sortIndex + 1,
                                ])) ||
                                null,
                        ]),
                    (mode === types_1.Split.left &&
                        reducedColspan &&
                        cellIdx + reducedColspan > cols.length) ||
                        spanPartByRightSplit
                        ? (0, dom_1.el)(".dhx_grid__cols-border--frozen", {
                            role: "presentation",
                            style: {
                                left: ((spanPartByRightSplit === null || spanPartByRightSplit === void 0 ? void 0 : spanPartByRightSplit.widthBefore) ||
                                    (0, cells_1.getWidth)(cols, cols.length - cellIdx, cellIdx)) -
                                    common_1.BORDERS / 2 -
                                    (cellIdx && mode === types_1.Split.left ? 1 : 0),
                            },
                        })
                        : null,
                ])
                : null;
        })
            .filter(function (cell) { return cell; }));
    });
}
exports.getFixedSpans = getFixedSpans;
function getRowAriaAttrs(rowCount) {
    return { role: "rowgroup", "aria-rowcount": rowCount };
}
function getFixedRows(config, rowsConfig, mode) {
    var _a;
    var leftSplit = config.leftSplit, $totalWidth = config.$totalWidth;
    var rows = getRows(config, rowsConfig);
    var spans = getFixedSpans(config, rowsConfig, mode);
    var fixedCols = null;
    if (rowsConfig.name === "footer" && !rowsConfig.sticky) {
        var rightSplit_1 = config.rightSplit, fixedColumns_1 = config.fixedColumns;
        var getCols = function (isRightSplit) {
            if (isRightSplit === void 0) { isRightSplit = false; }
            var columns = isRightSplit ? fixedColumns_1.right : fixedColumns_1.left;
            return (!isRightSplit && leftSplit >= 0) || (isRightSplit && rightSplit_1 >= 0)
                ? getRows(__assign(__assign({}, config), { currentColumns: columns, $positions: __assign(__assign({}, config.$positions), { xStart: 0, xEnd: isRightSplit ? rightSplit_1 : leftSplit }) }), rowsConfig)
                : [];
        };
        fixedCols = __spreadArray(__spreadArray([], getCols(), true), getCols(true), true);
    }
    var styles = (_a = {
            position: "sticky"
        },
        _a[rowsConfig.position] = 0,
        _a);
    var left;
    if (!rowsConfig.sticky) {
        styles.left = -config.scroll.left;
        left = -config.scroll.left;
        styles.position = "relative";
    }
    var dropLine = null;
    if (rowsConfig.name === "header") {
        dropLine = config.dropManager ? config.dropManager.toHTML({ header: true, mode: mode }) : null;
    }
    return (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-wrapper").concat(config.rightSplit ? ".dhx_grid__rows_right--fixed" : ""), {
        class: rowsConfig.sticky ? "" : "dhx_compatible-".concat(rowsConfig.name),
        style: __assign(__assign({}, styles), { left: rowsConfig.sticky ? left : 0, height: rowsConfig.name === "footer"
                ? config[rowsConfig.name + "Height"] + common_1.BORDERS / 2
                : config[rowsConfig.name + "Height"], width: rowsConfig.sticky ? $totalWidth : rowsConfig.wrapper.width - common_1.BORDERS }),
        role: "presentation",
        "data-dhx-drop-area": rowsConfig.name === "header" ? "column" : null,
    }, [
        (0, dom_1.el)(".dhx_grid-".concat(rowsConfig.name).concat(leftSplit ? ".dhx_grid_fixed_left" : ""), {
            style: {
                height: rowsConfig.name === "footer"
                    ? config[rowsConfig.name + "Height"] + common_1.BORDERS / 2
                    : config[rowsConfig.name + "Height"],
                left: left,
                paddingLeft: rowsConfig.shifts.x,
                width: $totalWidth,
            },
            role: "presentation",
        }, [
            (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-rows"), __assign({}, getRowAriaAttrs(__spreadArray([], rows, true).length)), __spreadArray([], rows, true)),
            (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-spans"), {
                style: {
                    marginLeft: -rowsConfig.shifts.x,
                },
                class: "dhx_".concat(rowsConfig.name, "-rows"),
                role: "presentation",
            }, spans),
            fixedCols &&
                (0, dom_1.el)(".dhx_".concat(rowsConfig.name, "-fixed-cols"), {
                    style: {
                        position: "absolute",
                        top: 0,
                        left: config.scroll.left + "px",
                        height: "100%",
                    },
                }, fixedCols),
        ]),
        dropLine,
        (0, dom_1.el)("div", { style: { width: $totalWidth }, role: "presentation" }),
    ]);
}
exports.getFixedRows = getFixedRows;
function getFixedDataRows(config, layout, mode) {
    if ((mode === types_1.Split.top && typeof config.topSplit !== "number") ||
        (mode === types_1.Split.bottom && typeof config.bottomSplit !== "number")) {
        return;
    }
    var $totalWidth = config.$totalWidth, topSplit = config.topSplit, bottomSplit = config.bottomSplit, $positions = config.$positions, data = config.data, $totalHeight = config.$totalHeight, $width = config.$width, headerHeight = config.headerHeight, footerHeight = config.footerHeight, $scrollBarWidth = config.$scrollBarWidth;
    var isBottomSplit = mode === types_1.Split.bottom;
    var splitedData = isBottomSplit ? config.fixedRows.bottom : config.fixedRows.top;
    var $renderFrom = isBottomSplit ? "bottomFixedRows" : "topFixedRows";
    var fixedRows = (0, cells_2.getCells)(__assign(__assign({}, config), { data: splitedData, $renderFrom: $renderFrom, $positions: __assign(__assign({}, $positions), { yStart: 0, yEnd: isBottomSplit ? bottomSplit : topSplit }) }));
    var fixedRowsHeight = splitedData.reduce(function (acc, row) { return acc + (0, data_1.getTotalRowHeight)(row); }, 0);
    var spans = (0, cells_2.getSpans)(__assign(__assign({}, config), { $renderFrom: $renderFrom, data: data }), isBottomSplit ? types_1.Split.bottom : types_1.Split.top);
    var bottomSplitHeight = (0, main_1.getTotalHeight)(config.fixedRows.bottom);
    var getCols = function (split) {
        return ((0, FixedCols_1.getFixedCols)(__assign(__assign({}, config), { headerHeight: 0, data: splitedData, $renderFrom: $renderFrom, scroll: __assign(__assign({}, config.scroll), { top: -1 }), $positions: __assign(__assign({}, $positions), { yStart: 0, yEnd: isBottomSplit ? bottomSplit : topSplit }), $totalHeight: fixedRowsHeight, $data: data }), __assign(__assign({}, layout), { shifts: __assign(__assign({}, layout.shifts), { y: 0 }) }), split, mode) || []);
    };
    var fixedCols = __spreadArray(__spreadArray([], getCols(types_1.Split.left), true), getCols(types_1.Split.right), true);
    return [
        (0, dom_1.el)(".dhx_grid-fixed-data-rows-wrap", {
            class: isBottomSplit ? "dhx_grid__rows_bottom--fixed" : "",
            style: {
                top: isBottomSplit
                    ? $totalHeight + headerHeight + footerHeight <
                        layout.wrapper.height - $scrollBarWidth.x - common_1.BORDERS
                        ? $totalHeight + headerHeight - bottomSplitHeight + common_1.BORDERS / 2
                        : layout.wrapper.height -
                            bottomSplitHeight -
                            footerHeight -
                            common_1.BORDERS / 2 -
                            $scrollBarWidth.x
                    : headerHeight,
                overflow: "hidden",
                height: fixedRowsHeight > layout.wrapper.height ? layout.wrapper.height : fixedRowsHeight,
                width: $totalWidth + $scrollBarWidth.y + common_1.BORDERS < $width
                    ? $totalWidth
                    : $width - $scrollBarWidth.y - common_1.BORDERS,
            },
        }, __spreadArray(__spreadArray([
            (0, dom_1.el)(".dhx_grid-fixed-cols", __assign(__assign({ onwheel: main_1.scrollFixedColsAndRows, style: {
                    left: -config.scroll.left + "px",
                    paddingLeft: layout.shifts.x,
                    position: "absolute",
                    width: $totalWidth,
                }, _flags: dom_1.KEYED_LIST }, (0, cells_2.getHandlers)(0, $positions.xStart, config)), getRowAriaAttrs(data.length)), [
                (0, dom_1.el)(".dhx_grid-fixed-rows", {
                    class: config.rightSplit ? "dhx_grid__rows_right--fixed" : "",
                }, __spreadArray(__spreadArray([], fixedRows, true), [spans && (0, dom_1.el)(".dhx_span-spans", { role: "presentation" }, spans)], false)),
            ])
        ], fixedCols, true), [
            config.bottomSplit ? (0, dom_1.el)(".dhx_grid__rows-border--frozen", { role: "presentation" }) : null,
        ], false)),
    ];
}
exports.getFixedDataRows = getFixedDataRows;


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DropManager = void 0;
var dom_1 = __webpack_require__(0);
var types_1 = __webpack_require__(5);
var ts_data_1 = __webpack_require__(4);
var common_1 = __webpack_require__(17);
var main_1 = __webpack_require__(10);
var core_1 = __webpack_require__(1);
var data_1 = __webpack_require__(11);
var main_2 = __webpack_require__(10);
var html_1 = __webpack_require__(2);
var DropManager = /** @class */ (function () {
    function DropManager(_a) {
        var view = _a.view;
        this._isTreeMode = false;
        this._grid = null;
        this._dragState = null;
        this._dragType = null;
        this._grid = view;
        this._isTreeMode = this._grid.config.type === "tree";
        this._init();
    }
    DropManager.prototype.toHTML = function (state) {
        var _a, _b;
        var groupingProcess = ((_a = this._grid.config.$grouped) === null || _a === void 0 ? void 0 : _a.length) && this._grid.config.$grouped.some(function (group) { return group.notGrouped; });
        var displayAllowed = (0, core_1.isDefined)((_b = this._dragState) === null || _b === void 0 ? void 0 : _b.target) && !this._grid.config.$resizing && !groupingProcess;
        return (0, dom_1.el)(".dhx_grid-drop", { "aria-hidden": "true" }, [
            displayAllowed && this._getDropLineNode(state),
        ]);
    };
    DropManager.prototype._getDropLineNode = function (state) {
        if (!this._dragType || ((state === null || state === void 0 ? void 0 : state.header) && this._dragType === "horizontal"))
            return null;
        return this._dragType === "horizontal"
            ? this._getHorizontalDropLine()
            : this._getVerticalDropLine(state);
    };
    DropManager.prototype._getVerticalDropLine = function (_a) {
        var _this = this;
        var _b = _a === void 0 ? {} : _a, _c = _b.header, header = _c === void 0 ? false : _c, _d = _b.mode, mode = _d === void 0 ? null : _d;
        var visibleColumns = this._grid.config.columns.filter(function (col) { return !col.hidden; });
        var targetIndex = visibleColumns.findIndex(function (i) { return i.id == _this._dragState.target; });
        var target = visibleColumns[targetIndex];
        if (!(0, core_1.isDefined)(target)) {
            return null;
        }
        var _e = this._grid.config, leftSplit = _e.leftSplit, rightSplit = _e.rightSplit;
        var startIndex = visibleColumns.findIndex(function (i) { return i.id == _this._dragState.start; });
        var scrollState = this._grid.getScrollState();
        var lineHeight = header ? this._grid.config.$headerHeight : this._grid.config.$height;
        var lineWidth = common_1.BORDERS;
        var top = header ? 0 : scrollState.y;
        var isLeftFixed, isRightFixed;
        if (leftSplit)
            isLeftFixed = this._isColumnFixed(target, types_1.Split.left);
        if (rightSplit)
            isRightFixed = this._isColumnFixed(target, types_1.Split.right);
        if ((isLeftFixed && mode === types_1.Split.right) ||
            (isRightFixed && mode === types_1.Split.left) ||
            (mode && !isRightFixed && !isLeftFixed)) {
            return null;
        }
        var left = 0;
        if (startIndex !== targetIndex && targetIndex != -1) {
            left = (0, main_1.getTotalWidth)(visibleColumns.slice(0, targetIndex + 1));
            if (startIndex > targetIndex)
                left -= target.$width;
            if (visibleColumns.length - ((!isRightFixed && rightSplit) || 0) === targetIndex + 1)
                left -= common_1.BORDERS;
        }
        else {
            return null;
        }
        if (isLeftFixed && !mode)
            left += scrollState.x;
        if (isRightFixed) {
            if (mode) {
                var fixedColumns = (0, common_1.getCurrFixedCols)(this._grid.config, types_1.Split.right);
                var targetIndex_1 = fixedColumns.findIndex(function (i) { return i.id == _this._dragState.target; });
                var startIndex_1 = fixedColumns.findIndex(function (i) { return i.id == _this._dragState.start; });
                left = (0, main_1.getTotalWidth)(fixedColumns.slice(0, targetIndex_1 + 1));
                if (startIndex_1 > targetIndex_1)
                    left -= target.$width;
                if (fixedColumns.length === targetIndex_1 + 1)
                    left -= common_1.BORDERS;
            }
            else {
                left -= (0, data_1.getReverseScrollState)(this._grid).x;
            }
        }
        return (0, dom_1.el)(".dhx_grid-drop-line", {
            style: { height: lineHeight, width: lineWidth, top: top, left: left },
        });
    };
    DropManager.prototype._getHorizontalDropLine = function () {
        var target = this._grid.data.getItem(this._dragState.target);
        if (!(0, core_1.isDefined)(target) || this._dragState.source.find(function (draggedId) { return draggedId == target.id; })) {
            return null;
        }
        var _a = this._grid.config, topSplit = _a.topSplit, bottomSplit = _a.bottomSplit;
        var lineWidth = this._grid.config.$width;
        var lineHeight = this._dragState.dropPosition === "in" ? target.$height : common_1.BORDERS;
        var scrollState = this._grid.getScrollState();
        var borderOffset = common_1.BORDERS / 2;
        var isTopFixed, isBottomFixed;
        if (topSplit) {
            var fixed = this._grid.data.getRawData(0, topSplit);
            var fixedIds = fixed.map(function (row) { return row.id; });
            isTopFixed = fixedIds.includes(target.id);
        }
        if (bottomSplit) {
            var dataLength = this._grid.data.getLength();
            var fixed = this._grid.data.getRawData(dataLength - bottomSplit, dataLength);
            var fixedIds = fixed.map(function (row) { return row.id; });
            isBottomFixed = fixedIds.includes(target.id);
        }
        var top = this._getTopPosition(target);
        if (this._dragState.dropPosition === "bottom") {
            top = this._getBottomPosition(target);
            if (target.$index === this._grid.data._order.length - 1) {
                top -= borderOffset;
            }
        }
        if (this._dragState.dropPosition !== "in") {
            top -= borderOffset;
            if (this._dragState.dropPosition === "top" && target.$index === 0) {
                top += borderOffset;
            }
        }
        if (isTopFixed)
            top += scrollState.y;
        if (isBottomFixed)
            top -= (0, data_1.getReverseScrollState)(this._grid).y;
        var levelOffset = target.$level && this._dragState.dropPosition !== "in"
            ? (0, data_1.getTreeCellWidthOffset)(target, target.$items)
            : 0;
        return (0, dom_1.el)(".dhx_grid-drop-line", {
            style: {
                marginLeft: levelOffset,
                height: lineHeight,
                width: lineWidth,
                left: scrollState.x,
                top: top,
            },
        });
    };
    DropManager.prototype._init = function () {
        var _this = this;
        this._grid.events.on(ts_data_1.DragEvents.dragStart, function (data, event, type) {
            if (type === "group")
                return;
            if (type === "row") {
                _this._toggleRowDraggable(data.source, true);
            }
        });
        this._grid.events.on(ts_data_1.DragEvents.dragIn, function (data, event, type) {
            if (type === "group" || _this._isSameComponent(event)) {
                return;
            }
            _this._dragState = data;
            _this._dragType = type === "row" ? "horizontal" : "vertical";
        });
        this._grid.events.on(ts_data_1.DragEvents.cancelDrop, function (data, event, type) {
            if (type === "group") {
                return;
            }
            _this._dragState = _this._dragType = null;
        });
        this._grid.events.on(ts_data_1.DragEvents.afterDrag, function (data, event, type) {
            _this._dragState = _this._dragType = null;
            if (type === "group")
                return;
            if (type === "row") {
                _this._toggleRowDraggable(data.source, false);
            }
        });
    };
    DropManager.prototype._getNextRow = function (targetRow) {
        var nextSiblingRowIndex = this._grid.data.getIndex(targetRow.id) + 1;
        var nextRow = this._grid.data.getItem(this._grid.data.getId(nextSiblingRowIndex));
        if (!nextRow) {
            nextRow = this._grid.data.getItem((0, main_2.getLastChild)(targetRow.id, this._grid.data, true));
        }
        return nextRow;
    };
    DropManager.prototype._isColumnFixed = function (column, dir) {
        var fixed = (0, common_1.getCurrFixedCols)(this._grid.config, dir);
        var fixedIds = fixed === null || fixed === void 0 ? void 0 : fixed.map(function (col) { return col.id; });
        return fixedIds === null || fixedIds === void 0 ? void 0 : fixedIds.includes(column.id);
    };
    DropManager.prototype._getTopPosition = function (row) {
        var rows = this._grid.data.getRawData(0, -1, null, 2);
        var rowInd = rows.findIndex(function (comp) { return comp.id == row.id; });
        return (0, main_1.getTotalHeight)(rows.slice(0, rowInd));
    };
    DropManager.prototype._getBottomPosition = function (targetRow) {
        if (this._isTreeMode && targetRow.$items) {
            var nextRow = this._getNextRow(targetRow);
            if (!(0, core_1.isDefined)(nextRow))
                return 0;
            var top_1 = this._getTopPosition(nextRow);
            if (nextRow.$level) {
                top_1 += nextRow.$height - common_1.BORDERS / 2;
            }
            return top_1;
        }
        else {
            return this._getTopPosition(targetRow) + targetRow.$height;
        }
    };
    DropManager.prototype._toggleRowDraggable = function (sourceIds, isDraggable) {
        var _this = this;
        sourceIds.forEach(function (id) {
            _this._grid.data.update(id, { $draggable: isDraggable }, true);
            if (_this._isTreeMode && _this._grid.data.haveItems(id)) {
                _this._grid.data.eachChild(id, function (child) {
                    _this._grid.data.update(child.id, { $draggable: isDraggable }, true);
                });
            }
        });
    };
    DropManager.prototype._isSameComponent = function (event) {
        return (0, html_1.locate)(event.target, "data-dhx-widget-id") != this._grid._uid;
    };
    return DropManager;
}());
exports.DropManager = DropManager;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtendedGrid = void 0;
var types_1 = __webpack_require__(5);
var ts_data_1 = __webpack_require__(4);
var html_1 = __webpack_require__(2);
var data_1 = __webpack_require__(11);
var render_1 = __webpack_require__(105);
var dom_1 = __webpack_require__(0);
var ScrollView_1 = __webpack_require__(22);
var main_1 = __webpack_require__(10);
var Grid_1 = __webpack_require__(104);
var default_1 = __webpack_require__(27);
var core_1 = __webpack_require__(1);
var Range_1 = __webpack_require__(110);
var BlockSelection_1 = __webpack_require__(243);
var Clipboard_1 = __webpack_require__(244);
var en_1 = __webpack_require__(42);
var DropManager_1 = __webpack_require__(108);
var History_1 = __webpack_require__(245);
var ExtendedGrid = /** @class */ (function (_super) {
    __extends(ExtendedGrid, _super);
    function ExtendedGrid(container, config) {
        var _this = this;
        var _a, _b, _c;
        _this = _super.call(this, container, __assign({ autoHeight: false, closable: true, groupable: false, subRow: null, multiSort: true, rangeSelection: false, blockSelection: false, clipboard: false, dragPanel: false, history: false, headerAutoHeight: (_a = config === null || config === void 0 ? void 0 : config.headerAutoHeight) !== null && _a !== void 0 ? _a : config === null || config === void 0 ? void 0 : config.autoHeight, footerAutoHeight: (_b = config === null || config === void 0 ? void 0 : config.footerAutoHeight) !== null && _b !== void 0 ? _b : config === null || config === void 0 ? void 0 : config.autoHeight }, config)) || this;
        if (_this.config.group) {
            _this.config.$grouped = [];
            _this.config.group = (0, default_1.getGroupDefaultConfig)(_this.config.group);
            var order = _this.config.group.order;
            if (Array.isArray(order) && order.length) {
                _this._group(order);
            }
            ts_data_1.dragManager.setItem(_this._uid, _this);
        }
        if (_this.config.subRow)
            _this.config.$subRowCells = new Map();
        if (_this.config.clipboard) {
            _this.clipboard = new Clipboard_1.Clipboard(_this);
            if (!_this.config.blockSelection || _this.config.blockSelection === true) {
                _this.config.blockSelection = __assign({ mode: "range" }, (_this.config.blockSelection || {}));
            }
        }
        if (_this.config.rangeSelection ||
            ((_c = _this.config.blockSelection) === null || _c === void 0 ? void 0 : _c.mode) !== "manual") {
            _this.range = new Range_1.Range(_this);
        }
        if (_this.config.blockSelection) {
            _this.block = new BlockSelection_1.BlockSelection(_this);
            _this.block.events.on(BlockSelection_1.BlockSelectionEvents.blockSelectionStart, function () {
                _this._autoScroll("auto");
            });
        }
        if (_this.config.history)
            _this.history = new History_1.History(_this);
        _this.scrollView = new ScrollView_1.ScrollView(function () { return _this.getRootView(); }, {
            scrollHandler: function (e) {
                return _this.events.fire(types_1.GridEvents.scroll, [
                    {
                        y: e.target.scrollTop,
                        x: e.target.scrollLeft,
                    },
                ]);
            },
        });
        return _this;
    }
    ExtendedGrid.prototype.expand = function (rowId) {
        var row = this.data.getItem(rowId);
        if (row.$subRowHeight) {
            if (!this._expand(row)) {
                return;
            }
            this._normalizeSpans();
            this.paint();
        }
    };
    ExtendedGrid.prototype.collapse = function (rowId) {
        var row = this.data.getItem(rowId);
        if (row.$subRowHeight) {
            if (!this._collapse(row)) {
                return;
            }
            this._normalizeSpans();
            this.paint();
        }
    };
    ExtendedGrid.prototype.expandAll = function () {
        var _this = this;
        this.data.forEach(function (row) {
            row.$subRowHeight && _this._expand(row);
        });
        this._normalizeSpans();
        this.paint();
    };
    ExtendedGrid.prototype.collapseAll = function () {
        var _this = this;
        this.data.forEach(function (row) {
            row.$subRowHeight && _this._collapse(row);
        });
        this._normalizeSpans();
        this.paint();
    };
    ExtendedGrid.prototype.getSubRow = function (id) {
        var _a, _b, _c, _d;
        if (!((_a = this.config.$subRowCells) === null || _a === void 0 ? void 0 : _a.has(id))) {
            return null;
        }
        var _e = (_b = this.config.$subRowCells) === null || _b === void 0 ? void 0 : _b.get(id), cell = _e.cell, config = __rest(_e, ["cell"]);
        return __assign(__assign({}, config), { view: (cell === null || cell === void 0 ? void 0 : cell.getWidget()) || (cell === null || cell === void 0 ? void 0 : cell.config.html) || null, element: (_d = (_c = cell === null || cell === void 0 ? void 0 : cell.getRootView()) === null || _c === void 0 ? void 0 : _c.node) === null || _d === void 0 ? void 0 : _d.el });
    };
    ExtendedGrid.prototype.destructor = function () {
        if (this.range)
            this.range.destructor();
        if (this.block)
            this.block.destructor();
        if (this.history)
            this.history.destructor();
        _super.prototype.destructor.call(this);
    };
    ExtendedGrid.prototype._createView = function () {
        var _this = this;
        return (0, dom_1.create)({
            render: function (vm, obj) {
                return _this._destructed
                    ? (0, dom_1.el)("div")
                    : (0, render_1.proRender)(vm, obj, _this._htmlEvents, _this.selection, _this._uid);
            },
            hooks: this._initHooks(),
        }, this);
    };
    ExtendedGrid.prototype._dragInit = function () {
        if (this.config.dragMode || this.config.dragItem || this.config.dragPanel) {
            if ((this.config.blockSelection || this.config.clipboard) &&
                !this.config.dragPanel &&
                this.config.dragItem !== "column") {
                this.config.dragPanel = true;
            }
            if (this.config.dragPanel) {
                this.config.dragPanel = __assign(__assign({}, default_1.defaultDragPanelConfig), ((typeof this.config.dragPanel === "object" && this.config.dragPanel) || {}));
            }
            if (!this.config.dragItem) {
                this.config.dragItem = "row";
            }
            if (!this.config.dragMode) {
                this.config.dragMode = "both";
            }
            ts_data_1.dragManager.setItem(this._uid, this);
            this._dropManager = new DropManager_1.DropManager({ view: this });
        }
    };
    ExtendedGrid.prototype._setHTMLEventHandlers = function () {
        var _this = this;
        _super.prototype._setHTMLEventHandlers.call(this);
        this._htmlEvents = __assign(__assign({}, this._htmlEvents), { onclick: (0, html_1.eventHandler)(function (e) { return (0, html_1.locate)(e); }, {
                "dhx_grid-header-cell--sortable": function (e, id) {
                    var isResizable = e.target.getAttribute("dhx_resized");
                    var column = _this.getColumn(id);
                    if (column && (0, main_1.isSortable)(_this.config, column) && !isResizable) {
                        var textId_1 = (0, html_1.locate)(e, "data-dhx-text-id");
                        var cell = column.header.find(function (item) { return item.id === textId_1; });
                        var isCtrlKey = e.ctrlKey || e.metaKey;
                        var isPermanent = _this.config.multiSort &&
                            (!isCtrlKey || (isCtrlKey && !_this._sortingStates.length));
                        _this._sort(id, cell.sortAs, isPermanent);
                    }
                },
                "dhx_grid-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_grid-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
                "dhx_span-expand-cell": function (e, rowId) {
                    if (e.target.classList.contains("dhx_span-expand-cell-icon")) {
                        _this.events.fire(types_1.GridEvents.expand, [rowId]);
                    }
                },
            }) });
    };
    ExtendedGrid.prototype._setEventHandlers = function () {
        var _this = this;
        _super.prototype._setEventHandlers.call(this);
        this.events.on(types_1.GridEvents.expand, function (rowId) {
            var item = _this.data.getItem(rowId);
            if (item) {
                if (item.$opened) {
                    _this.collapse(rowId);
                }
                else {
                    _this.expand(rowId);
                }
            }
        });
        this.events.on(types_1.GridEvents.headerCellMouseDown, function (cell, col, event) {
            var _a;
            var targetRow = (0, html_1.locateNodeByClassName)(event, "dhx_header-row");
            var targetRowIndex = targetRow && targetRow.getAttribute("aria-rowindex");
            if ((_a = col.header[Number(targetRowIndex) - 1]) === null || _a === void 0 ? void 0 : _a.content)
                return;
            if (!event.targetTouches) {
                _this._dragStartColumn(event, col);
            }
            else {
                _this._touch.timer = setTimeout(function () {
                    _this._dragStartColumn(event, col);
                }, _this._touch.duration);
            }
        });
        this._events.on(types_1.GridSystemEvents.headerCellTouchMove, function (cell, col, event) {
            _this._touch.start && event.preventDefault();
            _this._clearTouchTimer();
        });
        this._events.on(types_1.GridSystemEvents.headerCellTouchEnd, function () {
            _this._touch.start = false;
            _this._clearTouchTimer();
        });
        this.events.on(types_1.GridEvents.afterResizeEnd, function () {
            if (_this.config.autoHeight) {
                _this.config.data = _this.data.map(function (row) {
                    var height = (0, data_1.getMaxRowHeight)({
                        row: row,
                        cols: _this.config.columns,
                    });
                    row.$height = (0, data_1.getCalculatedRowHeight)(height, {
                        rowHeight: _this.config.rowHeight,
                    });
                    return row;
                });
            }
        });
        this.events.on(types_1.GridEvents.afterRowResize, function (row, event, currentHeight) {
            var _a = _this.data.getItem(row.id), id = _a.id, height = _a.height, $height = _a.$height;
            if (height && height !== $height) {
                _this.data.update(id, { height: currentHeight });
            }
            _this.data.update(id, { $height: currentHeight }, true);
            _this.config.data = _this.data.map(function (row) { return row; });
            _this.paint();
        });
        this.events.on(types_1.GridEvents.scroll, function () {
            _this._lazyLoad();
        });
        this.events.on(ts_data_1.DataEvents.dataRequest, function (from, to) {
            var proxy = _this.data.dataProxy;
            if (proxy && proxy.config) {
                _this._prepareDataFromTo(_this.data, from, to);
            }
        });
        this.events.on(ts_data_1.DragEvents.beforeDrag, function (data, event, _ghost, type) {
            switch (type) {
                case "column":
                    return _this.events.fire(types_1.GridEvents.beforeColumnDrag, [data, event]);
            }
        });
        this.events.on(ts_data_1.DragEvents.dragStart, function (data, event, type) {
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.dragColumnStart, [data, event]);
                    _this._autoScroll("horizontal");
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.dragIn, function (data, event, type) {
            var _a;
            var _b;
            switch (type) {
                case "column":
                    {
                        _this.events.fire(types_1.GridEvents.dragColumnIn, [data, event]);
                    }
                    break;
                case "group":
                    {
                        var column = _this.getColumn(data.start);
                        if (!_this._isGroupableColumn(column)) {
                            return;
                        }
                        var targetIndex = _this.config.$grouped.findIndex(function (i) { return i.id == data.target; });
                        var startIndex = _this.config.$grouped.findIndex(function (i) { return i.id == data.start; });
                        var included = _this.config.$grouped.find(function (i) { return i.id == data.start; });
                        if (targetIndex === -1 && !included) {
                            var label = (_b = column.header.find(function (i) { return i === null || i === void 0 ? void 0 : i.text; })) === null || _b === void 0 ? void 0 : _b.text;
                            if (typeof label === "function")
                                label = label(_this.getSummary(column.id));
                            if ((0, main_1.isHtmlEnable)(_this.config, column))
                                label = (0, main_1.removeHTMLTags)(label);
                            _this.config.$grouped.push({
                                id: data.start,
                                label: label,
                                mode: "drop",
                                notGrouped: true,
                                closable: _this._isGroupClosable(column),
                            });
                        }
                        if ((startIndex !== targetIndex || targetIndex === -1) && included) {
                            _this.config.$grouped[startIndex].mode = "drop";
                        }
                        if (targetIndex >= 0 && startIndex >= 0) {
                            _a = [
                                _this.config.$grouped[startIndex],
                                _this.config.$grouped[targetIndex],
                            ], _this.config.$grouped[targetIndex] = _a[0], _this.config.$grouped[startIndex] = _a[1];
                        }
                    }
                    break;
            }
            _this.paint();
        });
        this.events.on(ts_data_1.DragEvents.dragOut, function (data, event, type) {
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.dragColumnOut, [data, event]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.canDrop, function (data, event, type) {
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.canColumnDrop, [data, event]);
                    break;
            }
        });
        this.events.on(ts_data_1.DragEvents.cancelDrop, function (data, event, type) {
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.cancelColumnDrop, [data, event]);
                    break;
            }
            var area = (0, html_1.locate)((0, html_1.getElementFromPoint)(event), "data-dhx-drop-area");
            if (_this.config.group && area !== "group") {
                _this.config.$grouped = _this.config.$grouped.filter(function (i) { return !i.notGrouped; });
            }
            _this.paint();
        });
        this.events.on(ts_data_1.DragEvents.beforeDrop, function (data, event, type) {
            switch (type) {
                case "column":
                    return _this.events.fire(types_1.GridEvents.beforeColumnDrop, [data, event]);
            }
        });
        this.events.on(ts_data_1.DragEvents.afterDrop, function (data, event, type) {
            var _a;
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.afterColumnDrop, [data, event]);
                    break;
            }
            var range = (_a = _this.range) === null || _a === void 0 ? void 0 : _a.getRange();
            range && _this.range.setRange(range);
        });
        this.events.on(ts_data_1.DragEvents.afterDrag, function (data, event, type) {
            switch (type) {
                case "column":
                    _this.events.fire(types_1.GridEvents.afterColumnDrag, [data, event]);
                    break;
                case "group":
                    {
                        _this.config.$grouped = _this.config.$grouped.map(function (i) {
                            i.mode = "basic";
                            return i;
                        });
                        var order = _this.config.$grouped.map(function (i) {
                            delete i.notGrouped;
                            return i.id;
                        });
                        _this._group(order);
                    }
                    break;
            }
            _this._normalizeSpans();
            _this.paint();
        });
        this.events.on(types_1.GridEvents.beforeColumnDrop, function (_a) {
            var target = _a.target;
            if (_this.config.group &&
                _this.data.isGrouped() &&
                _this.config.group.column.id == target) {
                return false;
            }
        });
        this.events.on(types_1.GridEvents.groupPanelItemMouseDown, function (id, event) {
            if (event.targetTouches) {
                _this._touch.start = true;
                _this._touch.timer = setTimeout(function () {
                    _this._dragStartGroupItem(event, id);
                }, _this._touch.duration);
                return;
            }
            _this._dragStartGroupItem(event, id);
        });
        this._events.on(types_1.GridSystemEvents.groupPanelItemTouchMove, function (id, event) {
            _this._touch.start && event.preventDefault();
            _this._clearTouchTimer();
        });
        this._events.on(types_1.GridSystemEvents.groupPanelItemItemTouchEnd, function () {
            _this._touch.start = false;
            _this._clearTouchTimer();
        });
        this.events.on(types_1.GridEvents.groupPanelItemClick, function (id, event) {
            if ((0, html_1.locate)(event, "data-dhx-group-item-remove")) {
                _this._group(_this.config.$grouped.filter(function (i) { return i.id != id; }).map(function (i) { return i.id; }));
                return;
            }
            if ((0, html_1.locateNodeByClassName)(event, "dhx_grid-group_item-sort") &&
                (0, main_1.isSortable)(_this.config, _this.getColumn(id))) {
                var isCtrlKey = event.ctrlKey || event.metaKey;
                var isPermanent = _this.config.multiSort && (!isCtrlKey || (isCtrlKey && !_this._sortingStates.length));
                _this._sort(id, undefined, isPermanent);
                _this._changeGroupItemAfterSort();
            }
        });
        this.data.events.on(ts_data_1.DataEvents.afterGroup, function (grouped, config) {
            var _a, _b;
            if (!_this.config.group) {
                return;
            }
            (_a = _this.range) === null || _a === void 0 ? void 0 : _a.resetRange();
            _this.config.$grouped = [];
            var group = _this.config.group;
            var _loop_1 = function (colId) {
                var column = _this.config.columns.find(function (i) { return i.id == colId; });
                if (!column)
                    return "continue";
                var label = (_b = column.header.find(function (i) { return i === null || i === void 0 ? void 0 : i.text; })) === null || _b === void 0 ? void 0 : _b.text;
                if (typeof label === "function")
                    label = label(_this.getSummary(column.id));
                if ((0, main_1.isHtmlEnable)(_this.config, column))
                    label = (0, main_1.removeHTMLTags)(label);
                var sortIndex = _this._sortingStates.findIndex(function (i) { return i.by == colId; });
                var sort = _this._sortingStates[sortIndex];
                if ((group === null || group === void 0 ? void 0 : group.hideableColumns) && (config === null || config === void 0 ? void 0 : config.displayMode) === "column") {
                    if (!_this.isColumnHidden(colId)) {
                        _this._hideColumn(_this.getColumn(colId));
                    }
                }
                _this.config.$grouped.push({
                    id: colId,
                    label: label,
                    sortDir: (sort === null || sort === void 0 ? void 0 : sort.dir) || null,
                    sortOrder: (_this._sortingStates.length > 1 && sortIndex + 1) || null,
                    closable: _this._isGroupClosable(column),
                });
            };
            for (var _i = 0, grouped_1 = grouped; _i < grouped_1.length; _i++) {
                var colId = grouped_1[_i];
                _loop_1(colId);
            }
            if ((config === null || config === void 0 ? void 0 : config.displayMode) === "column") {
                var column = group.column;
                column.id = config.field;
                column.groupable = false;
                column.draggable = false;
                column.editable = false;
                column.htmlEnable = true;
                column.adjust = true;
                column.tooltipTemplate = column.tooltipTemplate
                    ? column.tooltipTemplate
                    : function (value, row, col) {
                        if (row.$groupSummary) {
                            var label = _this.data.getItem(row.parent)[col.id];
                            return "".concat(en_1.default.total, " (").concat(label, ")");
                        }
                        var groupedColumn = _this.config.columns.find(function (i) { return i.id == row.$by; });
                        if (groupedColumn === null || groupedColumn === void 0 ? void 0 : groupedColumn.options) {
                            value = (0, data_1.getOptionValue)(value, groupedColumn);
                        }
                        return ((value && "".concat(value, "  ").concat((0, core_1.isDefined)(row.$count) ? "(".concat(row.$count, ")") : "")) || "");
                    };
                column.template = column.template
                    ? column.template
                    : function (value, row, col) {
                        if (row.$groupSummary) {
                            var label = _this.data.getItem(row.parent)[col.id];
                            return "".concat(en_1.default.total, "<span class=\"dhx_tree-cell_group-counter\">&nbsp;(").concat(label, ")</span>");
                        }
                        var counter = (0, core_1.isDefined)(row.$count)
                            ? "<span class=\"dhx_tree-cell_group-counter\">&nbsp;(".concat(row.$count, ")</span>")
                            : "";
                        var groupedColumn = _this.config.columns.find(function (i) { return i.id == row.$by; });
                        if (groupedColumn === null || groupedColumn === void 0 ? void 0 : groupedColumn.options) {
                            value = (0, data_1.getOptionValue)(value, groupedColumn);
                        }
                        return (0, core_1.isDefined)(value) && "".concat(value, " ").concat(counter, " ");
                    };
                _this.setColumns(__spreadArray([column], _this.config.columns, true));
            }
        });
        this.data.events.on(ts_data_1.DataEvents.afterUnGroup, function (grouped, config) {
            var _a;
            (_a = _this.range) === null || _a === void 0 ? void 0 : _a.resetRange();
            _this.config.$grouped = [];
            if ((config === null || config === void 0 ? void 0 : config.displayMode) === "column") {
                var column_1 = _this.config.group.column;
                _this.config.columns = _this.config.columns.filter(function (i) { return i.id != column_1.id; });
            }
            grouped.forEach(function (colId) {
                if (_this.isColumnHidden(colId)) {
                    _this._showColumn(_this.getColumn(colId));
                }
            });
            _this._parseColumns();
        });
        this.data.events.on(ts_data_1.DataEvents.change, function (id, status, obj) {
            var _a;
            if (status === "sort") {
                if (((_a = _this.config.$grouped) === null || _a === void 0 ? void 0 : _a.length) && (!obj || (0, main_1.isSortable)(_this.config, obj.by))) {
                    _this._changeGroupItemAfterSort();
                }
            }
        });
    };
    ExtendedGrid.prototype._afterEditEndProcess = function (value, editableRow, editableColumn) {
        var _a, _b;
        var _c, _d;
        if (((_c = this.config.$editable) === null || _c === void 0 ? void 0 : _c.editor) &&
            (this.config.$editable.col !== editableColumn.id || this.config.$editable.row !== editableRow.id))
            return;
        var row;
        var col;
        if (!this.config.$editable) {
            row = editableRow.id;
            col = editableColumn.id;
        }
        else {
            row = this.config.$editable.row;
            col = this.config.$editable.col;
        }
        var span = this.getSpan(row, col);
        if ((0, core_1.isDefined)(span === null || span === void 0 ? void 0 : span.text) && (0, core_1.isDefined)(value)) {
            span.text = value.toString();
        }
        else {
            var item = this.data.getItem(row);
            var originalValue = item[col];
            delete item.$emptyRow;
            if ((0, core_1.isDefined)(value) && originalValue !== value) {
                (_d = this.history) === null || _d === void 0 ? void 0 : _d.add({
                    type: "change",
                    batch: [__assign(__assign({}, item), (_a = {}, _a[col] = value, _a))],
                    inverse: {
                        type: "change",
                        batch: [__assign({}, item)],
                    },
                });
                this.data.update(row, __assign(__assign({}, item), (_b = {}, _b[col] = value, _b)));
            }
        }
        this.config.$editable = null;
        this.paint();
    };
    ExtendedGrid.prototype._setSort = function () {
        this._sortingStates = this.data.getSortingStates().map(function (sort) {
            return { by: sort.by, dir: sort.dir, permanent: sort.smartSorting };
        });
    };
    ExtendedGrid.prototype.getNormalizeContentHeight = function (row, col, config) {
        var _a, _b;
        var HORIZONTAL_OFFSET = 24;
        var VERTICAL_OFFSET = 16;
        var htmlEnable = (0, main_1.isHtmlEnable)(config, col, row);
        var width = 0;
        var text = row.text || "";
        if (typeof text === "function")
            text = text(this.getSummary(col.id));
        if (htmlEnable)
            text = (0, main_1.removeHTMLTags)(text);
        if (row.colspan) {
            var startIndex = (_a = config.columns) === null || _a === void 0 ? void 0 : _a.findIndex(function (c) { return c.id === col.id; });
            var endIndex = startIndex + row.colspan;
            var targetColumns = (_b = config.columns) === null || _b === void 0 ? void 0 : _b.slice(startIndex, endIndex);
            targetColumns === null || targetColumns === void 0 ? void 0 : targetColumns.forEach(function (column) {
                width += column.$width;
            });
        }
        else {
            width += col.$width;
        }
        text = (text === null || text === void 0 ? void 0 : text.toString()) || "";
        return ((0, data_1.measureTextHeight)({
            text: text,
            htmlEnable: htmlEnable,
            width: width - HORIZONTAL_OFFSET,
            font: "normal 14.4px Arial",
        }) + VERTICAL_OFFSET);
    };
    ExtendedGrid.prototype._prepareData = function (data) {
        var _this = this;
        this._normalizeDataType();
        this._setSummary();
        this._adjustColumns();
        var columns = this.config.columns.filter(function (col) { return !col.hidden; });
        return data.map(function (row) {
            var _a;
            if (_this.config.autoHeight && typeof row.height === "undefined") {
                var height = (0, data_1.getMaxRowHeight)({ row: row, cols: columns });
                row.$height =
                    (0, data_1.getCalculatedRowHeight)(height, { rowHeight: _this.config.rowHeight }) ||
                        _this.config.rowHeight;
            }
            else {
                row.$height = Number(row.height) || _this.config.rowHeight;
            }
            if (_this.config.subRow) {
                var config = __assign(__assign({}, default_1.defaultSubRowConfig), ((typeof _this.config.subRowConfig === "function"
                    ? _this.config.subRowConfig(row)
                    : _this.config.subRowConfig) || {}));
                row.$opened = (_a = row.$opened) !== null && _a !== void 0 ? _a : config.expanded;
                if (!row.$group)
                    row.$subRowHeight = config.height;
            }
            return row;
        });
    };
    ExtendedGrid.prototype._prepareDataFromTo = function (data, from, to) {
        var _this = this;
        return data.mapRange(from, to, function (row) {
            var height = (0, data_1.getMaxRowHeight)({ row: row, cols: _this.config.columns });
            row.$height =
                (0, data_1.getCalculatedRowHeight)(height, {
                    rowHeight: _this.config.rowHeight,
                }) || _this.config.rowHeight;
            return row;
        });
    };
    ExtendedGrid.prototype._dragStart = function (event) {
        if (this.config.dragMode &&
            (this.config.dragItem === "row" || this.config.dragItem === "both") &&
            !this.config.$editable) {
            var column = this.getColumn((0, html_1.locate)(event.target, "data-dhx-col-id"));
            var rowNode = (0, html_1.locateNode)(event, "data-dhx-id");
            var rowId = rowNode && this.data.getItem((0, html_1.locate)(rowNode, "data-dhx-id")).id;
            if (this.selection &&
                !this.selection.isSelectedCell(rowId, column === null || column === void 0 ? void 0 : column.id) &&
                !(event.ctrlKey || event.metaKey || event.shiftKey)) {
                this.selection.setCell(rowId, column === null || column === void 0 ? void 0 : column.id);
            }
            var movableIds = this.selection.getCells().map(function (i) { return i.row.id; });
            if (this.config.multiselection) {
                if (movableIds.length > 1) {
                    var initData = this.data.getInitialData();
                    var sort = {};
                    var _loop_2 = function (index) {
                        var id = movableIds[index];
                        var itemIndex = initData === null || initData === void 0 ? void 0 : initData.findIndex(function (item) { return item.id == id; });
                        sort[itemIndex] = id;
                    };
                    for (var index = 0; index < movableIds.length; index++) {
                        _loop_2(index);
                    }
                    movableIds = __spreadArray([], Object.values(sort), true);
                }
            }
            ts_data_1.dragManager.onMouseDown({
                event: event,
                source: movableIds,
                itemsForGhost: [this._getRowGhost(movableIds)],
                type: "row",
            });
        }
    };
    ExtendedGrid.prototype._group = function (order) {
        if (!order.length) {
            this.data.ungroup();
            return;
        }
        var group = this.config.group;
        order = order.map(function (i) {
            var _a;
            if (typeof i === "string" && ((_a = group === null || group === void 0 ? void 0 : group.fields) === null || _a === void 0 ? void 0 : _a[i])) {
                var field = group.fields[i];
                return __assign(__assign({}, field), { by: i });
            }
            return i;
        });
        var columnsId = new Set(this.config.columns.map(function (c) { return c.id; }));
        order = order.filter(function (i) { return typeof i !== "string" || columnsId.has(i); });
        if (!order.length)
            return;
        this.data.group(order, {
            displayMode: group.type,
            showMissed: group.showMissed,
            field: group.column.id || "group",
        });
    };
    ExtendedGrid.prototype._expand = function (row) {
        if (row.$opened || !this.events.fire(types_1.GridEvents.beforeExpand, [row.id])) {
            return false;
        }
        this.data.update(row.id, { $opened: true }, true);
        this.events.fire(types_1.GridEvents.afterExpand, [row.id]);
        return true;
    };
    ExtendedGrid.prototype._collapse = function (row) {
        if (!row.$opened || !this.events.fire(types_1.GridEvents.beforeCollapse, [row.id])) {
            return false;
        }
        this.data.update(row.id, { $opened: false }, true);
        this.events.fire(types_1.GridEvents.afterCollapse, [row.id]);
        return true;
    };
    ExtendedGrid.prototype._lazyLoad = function () {
        var _this = this;
        var _a, _b;
        var proxy = this.data.dataProxy;
        if (proxy && proxy.config) {
            var data = this.data.getRawData(0, -1, null, 2);
            if (!data.length)
                return;
            var renderConfig = (0, render_1.getRenderConfig)(this, data, {
                width: this.config.$width,
                height: this.config.$height,
            });
            var from_1;
            var initialLimit = proxy.config.limit;
            var limit = initialLimit;
            var currentRows_1 = renderConfig.currentRows;
            var firstRow = currentRows_1[0];
            var lastRow = currentRows_1[currentRows_1.length - 1];
            var to_1 = this.data.getIndex(lastRow.id);
            var getRowIndex = function (row) {
                for (var i = 1; i < currentRows_1.length; i++) {
                    if ((row === "firstFilledRow" && !currentRows_1[i].$empty && currentRows_1[i - 1].$empty) ||
                        (row === "firstEmptyRow" && currentRows_1[i].$empty && !currentRows_1[i - 1].$empty)) {
                        return _this.data.getIndex(currentRows_1[i].id);
                    }
                }
            };
            if (firstRow.$empty) {
                if (lastRow.$empty) {
                    from_1 = this.data.getIndex(firstRow.id);
                }
                else {
                    var firstFilledRowIndex = getRowIndex("firstFilledRow");
                    var start = firstFilledRowIndex - limit;
                    if (start < 0)
                        start = 0;
                    for (var i = start; i < firstFilledRowIndex; i++) {
                        if (this.data.getItem(this.data.getId(i)).$empty) {
                            from_1 = i;
                            limit = firstFilledRowIndex - i;
                            break;
                        }
                    }
                }
            }
            else if (lastRow.$empty) {
                from_1 = getRowIndex("firstEmptyRow");
            }
            else {
                from_1 = (_a = getRowIndex("firstEmptyRow")) !== null && _a !== void 0 ? _a : this.data.getIndex(firstRow.id);
                limit = ((_b = getRowIndex("firstFilledRow")) !== null && _b !== void 0 ? _b : to_1) - from_1;
            }
            if (!this.data.isDataLoaded(from_1, to_1) && this.data.events.fire(ts_data_1.DataEvents.beforeLazyLoad, [])) {
                proxy.updateUrl(null, { from: from_1, limit: limit });
                proxy.config.limit = initialLimit;
                this.data.load(proxy).then(function () {
                    _this.config.autoHeight && _this._prepareDataFromTo(_this.data, from_1, to_1);
                });
            }
        }
    };
    ExtendedGrid.prototype._getGhostItem = function (text) {
        var node = document.createElement("div");
        node.className = "dhx_grid-draggable-item";
        node.innerHTML = text;
        return node;
    };
    ExtendedGrid.prototype._dragStartColumn = function (event, col) {
        var _a, _b;
        var target = event.target;
        var testCustom = function (el) { return el.classList.contains("dhx_grid-custom-content-cell"); };
        var isCustom = testCustom(target.parentElement) || testCustom(target.parentElement.parentElement);
        var isGroupable = this._isGroupableColumn(col);
        if (!isCustom &&
            (col.draggable ||
                (this.config.dragItem === "column" && col.draggable !== false) ||
                (this.config.dragItem === "both" && col.draggable !== false)) &&
            !(0, html_1.locateNodeByClassName)(event, "dhx_resizer_grip_wrap")) {
            if (event.targetTouches) {
                this._touch.start = true;
            }
            var headerId_1 = (0, html_1.locate)(event, "data-dhx-text-id");
            var label = (_a = col.header.find(function (i) { return (i === null || i === void 0 ? void 0 : i.id) == headerId_1; })) === null || _a === void 0 ? void 0 : _a.text;
            if (typeof label === "function")
                label = label(this.getSummary(col.id));
            if ((0, main_1.isHtmlEnable)(this.config, col))
                label = (0, main_1.removeHTMLTags)(label);
            ts_data_1.dragManager.onMouseDown({
                event: event,
                type: "column",
                source: [col.id],
                ghost: this._getGhostItem(label),
                groupable: isGroupable,
            });
        }
        else if (this.config.group && isGroupable) {
            var headerId_2 = (0, html_1.locate)(event, "data-dhx-text-id");
            var label = (_b = col.header.find(function (i) { return (i === null || i === void 0 ? void 0 : i.id) == headerId_2; })) === null || _b === void 0 ? void 0 : _b.text;
            if (typeof label === "function")
                label = label(this.getSummary(col.id));
            if ((0, main_1.isHtmlEnable)(this.config, col))
                label = (0, main_1.removeHTMLTags)(label);
            ts_data_1.dragManager.onMouseDown({
                event: event,
                type: "column",
                source: [col.id],
                ghost: this._getGhostItem(label),
                groupable: isGroupable,
                groupOnly: true,
            });
        }
    };
    ExtendedGrid.prototype._dragStartGroupItem = function (event, id) {
        if ((0, html_1.locateNodeByClassName)(event, "dhx_grid-group_item-sort")) {
            return;
        }
        var label = this.config.$grouped.find(function (i) { return i.id == id; }).label;
        var column = this.getColumn(id);
        ts_data_1.dragManager.onMouseDown({
            event: event,
            source: [id],
            type: "group",
            groupable: this._isGroupableColumn(column),
            ghost: this._getGhostItem(label),
        });
    };
    ExtendedGrid.prototype._changeGroupItemAfterSort = function () {
        var _this = this;
        this.config.$grouped = this.config.$grouped.map(function (i) {
            var sortIndex = _this._sortingStates.findIndex(function (sort) { return sort.by == i.id; });
            var sort = _this._sortingStates[sortIndex];
            return __assign(__assign({}, i), { sortDir: (sort === null || sort === void 0 ? void 0 : sort.dir) || null, sortOrder: (_this._sortingStates.length > 1 && sortIndex + 1) || null });
        });
    };
    ExtendedGrid.prototype._isGroupableColumn = function (col) {
        var _a;
        return (_a = col.groupable) !== null && _a !== void 0 ? _a : this.config.groupable;
    };
    ExtendedGrid.prototype._isGroupClosable = function (col) {
        var _a;
        return (_a = col.closable) !== null && _a !== void 0 ? _a : this.config.closable;
    };
    return ExtendedGrid;
}(Grid_1.Grid));
exports.ExtendedGrid = ExtendedGrid;


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Range = exports.RangeEvents = void 0;
var events_1 = __webpack_require__(3);
var ts_data_1 = __webpack_require__(4);
var core_1 = __webpack_require__(1);
var main_1 = __webpack_require__(10);
var RangeEvents;
(function (RangeEvents) {
    RangeEvents["beforeSetRange"] = "beforeSetRange";
    RangeEvents["afterSetRange"] = "afterSetRange";
    RangeEvents["beforeResetRange"] = "beforeResetRange";
    RangeEvents["afterResetRange"] = "afterResetRange";
})(RangeEvents || (exports.RangeEvents = RangeEvents = {}));
var Range = /** @class */ (function () {
    function Range(grid) {
        var isCustomConfig = typeof grid.config.rangeSelection === "object";
        this.config = __assign({ disabled: false }, (isCustomConfig ? grid.config.rangeSelection : {}));
        this.events = new events_1.EventSystem(this);
        this._grid = grid;
        this._range = null;
        this._cells = [];
        this._xSet = new Set();
        this._ySet = new Set();
        this._disabled = this.config.disabled;
        this._initHandlers();
    }
    Range.prototype.setRange = function (range, join) {
        var _a, _b;
        if (join === void 0) { join = false; }
        if (this._disabled) {
            return false;
        }
        if (join) {
            range = __assign(__assign({}, (this._range || {})), range);
        }
        if (!range) {
            (0, ts_data_1.dhxWarning)("Range object is required for setting range");
            return false;
        }
        if (!(0, core_1.isDefined)(range.yStart) && !(0, core_1.isDefined)(range.xStart)) {
            (0, ts_data_1.dhxWarning)("Start id is required for setting range");
            return false;
        }
        if (!this._isAllowedRange(range)) {
            (0, ts_data_1.dhxWarning)("There is a non-existent id in the range");
            return false;
        }
        if ((0, core_1.isDefined)(range.xStart) || (0, core_1.isDefined)(range.yStart)) {
            var columns = this._grid.config.columns.filter(function (col) { return !col.hidden; });
            if (!(0, core_1.isDefined)(range.xEnd)) {
                range.xEnd = (_a = columns[columns.length - 1]) === null || _a === void 0 ? void 0 : _a.id;
            }
            if (!(0, core_1.isDefined)(range.yStart)) {
                range.yStart = this._grid.data.getId(0);
            }
            if (!(0, core_1.isDefined)(range.yEnd)) {
                range.yEnd = this._grid.data.getId(this._grid.data.getLength() - 1);
            }
            if (!(0, core_1.isDefined)(range.xStart)) {
                range.xStart = (_b = columns[0]) === null || _b === void 0 ? void 0 : _b.id;
            }
        }
        if (!this.events.fire(RangeEvents.beforeSetRange, [range]) || (!join && !this.resetRange())) {
            return false;
        }
        this._resetRange();
        this._range = __assign({}, range);
        var yRange = this._getRowRange(range.yStart, range.yEnd);
        var xRange = this._getColumnRange(range.xStart, range.xEnd);
        for (var _i = 0, xRange_1 = xRange; _i < xRange_1.length; _i++) {
            var x = xRange_1[_i];
            this._xSet.add(x.id);
            for (var _c = 0, yRange_1 = yRange; _c < yRange_1.length; _c++) {
                var y = yRange_1[_c];
                this._ySet.add(y.id);
                var cell = { column: x, row: y };
                if (cell.row && cell.column) {
                    this._cells.push(cell);
                }
            }
        }
        this.events.fire(RangeEvents.afterSetRange, [this._range]);
        return true;
    };
    Range.prototype.resetRange = function () {
        if (this._disabled) {
            return false;
        }
        var range = this.getRange();
        if (range) {
            if (!this.events.fire(RangeEvents.beforeResetRange, [range])) {
                return false;
            }
            this._resetRange();
            this.events.fire(RangeEvents.afterResetRange, [range]);
        }
        return true;
    };
    Range.prototype.getRange = function () {
        return this._range;
    };
    Range.prototype.getRangedCells = function () {
        return this._cells;
    };
    Range.prototype.isRanged = function (cell) {
        if ((0, core_1.isDefined)(cell.y) && (0, core_1.isDefined)(cell.x)) {
            return this._xSet.has(cell.x) && this._ySet.has(cell.y);
        }
        if ((0, core_1.isDefined)(cell.x))
            return this._xSet.has(cell.x);
        if ((0, core_1.isDefined)(cell.y))
            return this._ySet.has(cell.y);
    };
    Range.prototype.enable = function () {
        this._disabled = false;
    };
    Range.prototype.disable = function () {
        this._resetRange();
        this._disabled = true;
    };
    Range.prototype.isDisabled = function () {
        return this._disabled;
    };
    Range.prototype.destructor = function () {
        this.events.clear();
    };
    Range.prototype._resetRange = function () {
        this._range = null;
        this._cells.length = 0;
        this._xSet.clear();
        this._ySet.clear();
    };
    Range.prototype._getColumnRange = function (start, end) {
        var _a;
        var columns = this._grid.config.columns.filter(function (col) { return !col.hidden; });
        var startIndex = columns.findIndex(function (col) { return col.id === start; });
        var endIndex = columns.findIndex(function (col) { return col.id === end; });
        if (endIndex === -1) {
            endIndex = columns.length - 1;
        }
        if (startIndex > endIndex) {
            _a = [endIndex, startIndex], startIndex = _a[0], endIndex = _a[1];
        }
        return columns.slice(startIndex, endIndex + 1);
    };
    Range.prototype._getRowRange = function (start, end) {
        var _a;
        var rows = this._grid.data.getRawData(0, -1, null, 2);
        var startIndex = rows.findIndex(function (row) { return row.id === start; });
        var endIndex = rows.findIndex(function (row) { return row.id === end; });
        if (startIndex > endIndex) {
            _a = [endIndex, startIndex], startIndex = _a[0], endIndex = _a[1];
        }
        return rows.slice(startIndex, endIndex + 1);
    };
    Range.prototype._isAllowedRange = function (_a) {
        var _this = this;
        var xStart = _a.xStart, xEnd = _a.xEnd, yStart = _a.yStart, yEnd = _a.yEnd;
        var checks = [
            { value: xStart, exists: function (val) { return _this._grid.config.columns.some(function (col) { return col.id === val; }); } },
            { value: xEnd, exists: function (val) { return _this._grid.config.columns.some(function (col) { return col.id === val; }); } },
            { value: yStart, exists: function (val) { return _this._grid.data.exists(val); } },
            { value: yEnd, exists: function (val) { return _this._grid.data.exists(val); } },
        ];
        return checks.every(function (_a) {
            var value = _a.value, exists = _a.exists;
            return !(0, core_1.isDefined)(value) || exists(value);
        });
    };
    Range.prototype._initHandlers = function () {
        var _this = this;
        this._grid.data.events.on(ts_data_1.DataEvents.beforeRemove, function (item) {
            if (_this._ySet.has(item.id)) {
                if (_this._range.yStart === item.id && _this._range.yEnd === item.id) {
                    _this.resetRange();
                }
                else if (_this._range.yStart === item.id) {
                    var target = null;
                    if (_this._grid.config.type === "tree") {
                        target = _this._grid.data.getItem((0, main_1.getClosestBottom)(item.id, _this._grid.data));
                    }
                    else {
                        var index = _this._grid.data.getIndex(item.id);
                        if (index >= 0 && index < _this._grid.data.getLength()) {
                            target = _this._grid.data.getItem(_this._grid.data.getId(index + 1));
                        }
                    }
                    _this.setRange(__assign(__assign({}, _this.getRange()), { yStart: target.id }));
                }
                else if (_this._range.yEnd === item.id) {
                    var target = null;
                    if (_this._grid.config.type === "tree") {
                        target = _this._grid.data.getItem((0, main_1.getClosestTop)(item.id, _this._grid.data));
                    }
                    else {
                        var index = _this._grid.data.getIndex(item.id);
                        if (index >= 0) {
                            target = _this._grid.data.getItem(_this._grid.data.getId(index - 1));
                        }
                    }
                    _this.setRange(__assign(__assign({}, _this.getRange()), { yEnd: target.id }));
                }
            }
        });
        this._grid.data.events.on(ts_data_1.DataEvents.afterRemove, function (item) {
            var range = _this.getRange();
            if (range &&
                _this._ySet.has(item.id) &&
                _this._range.yStart !== item.id &&
                _this._range.yEnd !== item.id) {
                _this.setRange(range);
            }
        });
        this._grid.data.events.on(ts_data_1.DataEvents.removeAll, function () {
            _this._resetRange();
        });
        this._grid.data.events.on(ts_data_1.DataEvents.load, function () {
            _this._resetRange();
        });
    };
    return Range;
}());
exports.Range = Range;


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeGridCollection = void 0;
var core_1 = __webpack_require__(1);
var ts_data_1 = __webpack_require__(4);
var treecollection_1 = __webpack_require__(69);
var TreeGridCollection = /** @class */ (function (_super) {
    __extends(TreeGridCollection, _super);
    function TreeGridCollection(config, events) {
        return _super.call(this, config, events) || this;
    }
    TreeGridCollection.prototype.eachChild = function (id, cb, direct, checkItem) {
        if (direct === void 0) { direct = true; }
        checkItem = checkItem || (function (item) { return item.$opened !== false; });
        _super.prototype.eachChild.call(this, id, cb, direct, checkItem);
    };
    TreeGridCollection.prototype.getMaxLevel = function () {
        var _this = this;
        var maxLevel = 1;
        this.map(function (el) {
            var level = _this.getLevel(el.id);
            maxLevel = Math.max(level, maxLevel);
        });
        return maxLevel;
    };
    TreeGridCollection.prototype.getLevel = function (id) {
        var level = 0;
        this.eachParent(id, function () {
            level++;
        });
        return level;
    };
    TreeGridCollection.prototype.serialize = function (driver) {
        var _this = this;
        if (driver === void 0) { driver = ts_data_1.DataDriver.json; }
        var data = [];
        _super.prototype.eachChild.call(this, this.getRoot(), function (el) {
            if (!el) {
                return;
            }
            var cell = __assign({}, el);
            Object.keys(cell).forEach(function (key) {
                if (key.startsWith("$") && key !== "$level") {
                    delete cell[key];
                }
            });
            if (cell.parent && cell.parent === _this._root) {
                delete cell.parent;
            }
            data.push(cell);
        });
        var dataDriver = (0, ts_data_1.toDataDriver)(driver);
        if (dataDriver) {
            return dataDriver.serialize(data);
        }
    };
    TreeGridCollection.prototype.getPlainIndex = function (id) {
        return Object.keys(this._pull).indexOf("".concat(id));
    };
    TreeGridCollection.prototype.map = function (cb, parent, direct) {
        if (parent === void 0) { parent = this._root; }
        if (direct === void 0) { direct = true; }
        var result = [];
        if (!this.haveItems(parent)) {
            return result;
        }
        for (var i = 0; i < this._children[parent].length; i++) {
            result.push(cb.call(this, this._children[parent][i], i));
            if (direct && this._children[parent][i].hasOwnProperty("$opened")) {
                var childResult = this.map(cb, this._children[parent][i].id, direct);
                result = result.concat(childResult);
            }
        }
        return result;
    };
    TreeGridCollection.prototype.mapVisible = function (cb, parent, direct) {
        if (parent === void 0) { parent = this._root; }
        if (direct === void 0) { direct = true; }
        var result = [];
        if (!this.haveItems(parent)) {
            return result;
        }
        var isRange = this._range && parent === this._root;
        var start = isRange ? this._range[0] : 0;
        var parentLength = this._children[parent].length;
        var end = isRange ? Math.min(this._range[1], parentLength) : parentLength;
        for (var i = start; i < end; i++) {
            if (!this._children[parent][i].hidden) {
                result.push(cb.call(this, this._children[parent][i], i));
                if (direct && this._children[parent][i].$opened) {
                    var childResult = this.mapVisible(cb, this._children[parent][i].id, direct);
                    result = result.concat(childResult);
                }
            }
        }
        return result;
    };
    TreeGridCollection.prototype._parse_data = function (data, parent) {
        var _a, _b, _c;
        if (parent === void 0) { parent = this._root; }
        for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
            var obj = data_1[_i];
            if (this.config.init) {
                obj = this.config.init(obj);
            }
            for (var _d = 0, _e = Object.keys(obj); _d < _e.length; _d++) {
                var key = _e[_d];
                key.includes("$items") && delete obj[key];
            }
            obj.id = (_a = obj.id) !== null && _a !== void 0 ? _a : (0, core_1.uid)();
            obj.parent = obj.parent && !((_c = (_b = obj.parent) === null || _b === void 0 ? void 0 : _b.toString()) === null || _c === void 0 ? void 0 : _c.includes("_ROOT_")) ? obj.parent : parent;
            if (this._pull[obj.id]) {
                (0, ts_data_1.dhxError)("Item ".concat(obj.id, " already exist"));
            }
            this._parseItem(obj);
            if (obj.items && obj.items instanceof Object) {
                obj.$opened = !this.config.collapsed;
                this._parse_data(obj.items, obj.id);
            }
        }
        this._checkItems();
    };
    TreeGridCollection.prototype._copy = function (id, index, target, targetId, key) {
        if (target === void 0) { target = this; }
        if (targetId === void 0) { targetId = this._root; }
        if (!this.exists(id)) {
            return null;
        }
        var currentChildren = this._children[id];
        if (key) {
            index = index === -1 ? -1 : index + key;
        }
        if (target === this && !this.canCopy(id, targetId)) {
            return null;
        }
        var item = __assign({}, this.getItem(id));
        if (target.exists(id)) {
            item.id = (0, core_1.uid)();
        }
        if (this.exists(id)) {
            item.parent = targetId;
            if (target !== this && targetId === this._root) {
                item.parent = target.getRoot();
            }
            target.add(item, index);
            id = item.id;
        }
        if (currentChildren) {
            for (var _i = 0, currentChildren_1 = currentChildren; _i < currentChildren_1.length; _i++) {
                var child = currentChildren_1[_i];
                var childId = child.id;
                var childIndex = this.getIndex(childId);
                this.copy(childId, childIndex, target, id);
            }
        }
        return id;
    };
    TreeGridCollection.prototype._addToOrder = function (_order, obj, index) {
        _super.prototype._addToOrder.call(this, _order, obj, index);
        obj.$level = this.getLevel(obj.id);
        this._checkItems();
    };
    TreeGridCollection.prototype._removeCore = function (id) {
        _super.prototype._removeCore.call(this, id);
        this._checkItems();
    };
    TreeGridCollection.prototype._setParent = function (item, parent) {
        item.parent = item.parent ? item.parent.toString() : parent;
    };
    TreeGridCollection.prototype._checkItems = function () {
        var _this = this;
        this.eachChild(this._root, function (item) {
            var haveItems = _this.haveItems(item.id);
            item.$items = haveItems;
            item.$level = _this.getLevel(item.id);
            if (haveItems) {
                item.$opened = (0, core_1.isDefined)(item.$opened)
                    ? item.$opened
                    : !_this.config.collapsed && haveItems;
            }
        }, true, function () { return true; });
    };
    TreeGridCollection.prototype._moveItem = function (id, targetId, index) {
        var parentId = this.getParent(id);
        [this._children, this._initChildren].forEach(function (store) {
            if (!store || !store[parentId])
                return;
            var i = store[parentId].findIndex(function (item) { return item.id === id; });
            if (i === -1)
                return;
            var item = store[parentId].splice(i, 1)[0];
            item.parent = targetId;
            (0, treecollection_1.addToOrder)(store, item, targetId, index);
            if (!store[parentId].length)
                delete store[parentId];
        });
        this._checkItems();
    };
    return TreeGridCollection;
}(ts_data_1.TreeCollection));
exports.TreeGridCollection = TreeGridCollection;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ribbon = void 0;
var dom_1 = __webpack_require__(0);
var ts_navbar_1 = __webpack_require__(23);
var core_1 = __webpack_require__(1);
var html_1 = __webpack_require__(2);
var ts_message_1 = __webpack_require__(14);
var Ribbon = /** @class */ (function (_super) {
    __extends(Ribbon, _super);
    function Ribbon(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            $name: "ribbon",
        }, config)) || this;
        _this._widgetHeight = [];
        _this._listeners = {
            input: function (e) {
                var id = (0, html_1.locate)(e);
                var item = _this.data.getItem(id);
                if (!item)
                    return;
                var value = e.target.value;
                _this.data.update(id, { value: value });
                if (item.type === "input") {
                    _this.events.fire(ts_navbar_1.NavigationBarEvents.input, [id, value]);
                }
            },
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item.tooltip) {
                    (0, ts_message_1.tooltip)(item.tooltip, {
                        node: elem,
                        position: ts_message_1.Position.bottom,
                    });
                }
            },
        };
        _this._currentRoot = null;
        var render = function () { return _this._draw(); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Ribbon.prototype.getState = function () {
        var state = {};
        this.data.eachChild(this.data.getRoot(), function (item) {
            if (item.twoState && !item.group) {
                state[item.id] = item.active;
            }
            else if (item.type === "input" ||
                item.type === "selectButton" ||
                item.type === "datePicker") {
                state[item.id] = item.value;
            }
        }, true);
        for (var key in this._groups) {
            if (this._groups[key].active) {
                state[key] = this._groups[key].active;
            }
        }
        return state;
    };
    Ribbon.prototype.setState = function (state) {
        for (var key in state) {
            if (this._groups && this._groups[key]) {
                if (this._groups[key].active) {
                    this.data.update(this._groups[key].active, { active: false });
                    this._groups[key].active = state[key];
                    this.data.update(state[key], { active: true });
                }
            }
            else {
                var item = this.data.getItem(key);
                switch (item.type) {
                    case "input":
                    case "selectButton":
                        this.data.update(key, { value: state[key] });
                        break;
                    case "datePicker":
                        if (item.$calendar) {
                            if (state[key]) {
                                item.$calendar.setValue(state[key]);
                            }
                            else {
                                item.$calendar.clear();
                            }
                        }
                        else {
                            this.data.update(key, { value: state[key] });
                        }
                        break;
                    default:
                        this.data.update(key, { active: state[key] });
                }
            }
        }
    };
    Ribbon.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "navItem",
                "button",
                "imageButton",
                "selectButton",
                "customHTML",
                "input",
                "separator",
                "spacer",
                "title",
                "block",
                "datePicker",
                "customHTMLButton",
            ],
            widgetName: "ribbon",
        });
    };
    Ribbon.prototype._getMode = function (item, root) {
        return item.id === root ? "bottom" : "right";
    };
    Ribbon.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Ribbon.prototype._draw = function () {
        var _this = this;
        this._heightCalculate();
        var itemsHeight = Math.max.apply(Math, this._widgetHeight);
        return (0, dom_1.el)("ul.dhx_ribbon.dhx_widget", {
            "data-dhx-widget-id": this._uid,
            class: this.config.css ? this.config.css : "",
            tabindex: 0,
            onclick: this._handlers.onclick,
            onmousedown: this._handlers.onmousedown,
            oninput: this._listeners.input,
            onmouseover: this._listeners.tooltip,
            onkeydown: this._handlers.onkeydown,
            _hooks: {
                didInsert: function (node) {
                    node.el.addEventListener("keyup", function (e) {
                        if (e.which !== 9) {
                            return;
                        }
                        var elem = (0, html_1.locateNode)(document.activeElement);
                        if (!elem) {
                            return;
                        }
                        var id = elem.getAttribute("data-dhx-id");
                        var item = _this.data.getItem(id);
                        if (item.tooltip) {
                            (0, ts_message_1.tooltip)(item.tooltip, {
                                node: elem,
                                position: ts_message_1.Position.bottom,
                                force: true,
                            });
                        }
                    }, true);
                },
            },
        }, [
            (0, dom_1.el)("li", {
                class: "dhx_ribbon-block dhx_ribbon-block--root",
                style: { height: this._haveTitle ? itemsHeight + 24 : itemsHeight },
            }, [
                (0, dom_1.el)("ul.dhx_ribbon-content.dhx_ribbon-content--full-width", {
                    style: { height: itemsHeight },
                }, this.data.map(function (block) {
                    return block.type === "block"
                        ? _this._drawBlock(block, true)
                        : _this._factory(block);
                }, this.data.getRoot(), false)),
            ]),
        ]);
    };
    Ribbon.prototype._setRoot = function (id) {
        var parentId = this.data.getParent(id);
        if (this.data.getItem(parentId).type === "block") {
            this._currentRoot = id;
        }
    };
    Ribbon.prototype._drawBlock = function (block, isFirst) {
        var _this = this;
        if (!block || block.hidden) {
            return null;
        }
        var classNames = "dhx_ribbon-block" +
            (" dhx_ribbon-block" + (block.direction === "col" ? "--col" : "--row")) +
            (block.title ? " dhx_ribbon-block--title" : "") +
            (block.css ? " " + block.css : "") +
            (isFirst ? " dhx_ribbon-block--indented" : "");
        var childs = block.items.map(function (child) {
            if (child.type === "block") {
                return _this._drawBlock(child);
            }
            if (child.type !== "separator" && child.type !== "spacer") {
                return _this._factory(child);
            }
            return null;
        }, block.id, false);
        return (0, dom_1.el)("li", {
            class: classNames,
        }, [
            (0, dom_1.el)("ul.dhx_ribbon-content", childs),
            block.title
                ? (0, dom_1.el)("span.dhx_ribbon-content-label-wrapper", [
                    (0, dom_1.el)("span.dhx_ribbon-content-label", block.title),
                ])
                : null,
        ]);
    };
    Ribbon.prototype._getBlockHeight = function (block) {
        if (block.hidden)
            return 0;
        return block.size === "medium" && block.type !== "button" ? 72 : 36;
    };
    Ribbon.prototype._heightCalculate = function (data) {
        var _this = this;
        if (data === void 0) { data = this.data; }
        data.forEach(function (block) {
            var blockHeight;
            if (block.type === "block" && block.direction === "col") {
                blockHeight = block.items.reduce(function (count, item) { return count + _this._getBlockHeight(item); }, 0);
                _this._heightCalculate(block.items);
            }
            else {
                blockHeight = _this._getBlockHeight(block);
            }
            if (block.title) {
                _this._haveTitle = true;
            }
            _this._widgetHeight.push(blockHeight);
        });
    };
    return Ribbon;
}(ts_navbar_1.Navbar));
exports.Ribbon = Ribbon;


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sidebar = void 0;
var dom_1 = __webpack_require__(0);
var html_1 = __webpack_require__(2);
var types_1 = __webpack_require__(114);
var ts_message_1 = __webpack_require__(14);
var ts_navbar_1 = __webpack_require__(23);
var core_1 = __webpack_require__(1);
var Sidebar = /** @class */ (function (_super) {
    __extends(Sidebar, _super);
    function Sidebar(element, config) {
        var _this = _super.call(this, element, (0, core_1.extend)({
            navigationType: "click",
            width: "200",
            minWidth: "44",
            collapsed: false,
            $name: "sidebar",
        }, config)) || this;
        _this._currentRoot = null;
        var render = function () { return _this._draw(); };
        _this.mount(element, (0, dom_1.create)({ render: render }));
        return _this;
    }
    Sidebar.prototype.toggle = function () {
        if (this.config.collapsed) {
            this.expand();
        }
        else {
            this.collapse();
        }
        this.events.fire(types_1.SidebarEvents.toggle, [this.config.collapsed]); // TODO: remove suite_7.0
        this.paint();
    };
    Sidebar.prototype.collapse = function () {
        if (!this.events.fire(types_1.SidebarEvents.beforeCollapse, [])) {
            return;
        }
        this.config.collapsed = true;
        this.events.fire(types_1.SidebarEvents.afterCollapse, []);
        this.paint();
    };
    Sidebar.prototype.expand = function () {
        if (!this.events.fire(types_1.SidebarEvents.beforeExpand, [])) {
            return;
        }
        this.config.collapsed = false;
        this.events.fire(types_1.SidebarEvents.afterExpand, []);
        this.paint();
    };
    Sidebar.prototype.isCollapsed = function () {
        return this.config.collapsed;
    };
    Sidebar.prototype._getFactory = function () {
        return (0, ts_navbar_1.createFactory)({
            widget: this,
            defaultType: "navItem",
            allowedTypes: [
                "navItem",
                "menuItem",
                "customHTML",
                "separator",
                "spacer",
                "title",
                "customHTMLButton",
            ],
            widgetName: "sidebar",
        });
    };
    Sidebar.prototype._close = function (e) {
        this._activePosition = null;
        this._currentRoot = null;
        _super.prototype._close.call(this, e);
    };
    Sidebar.prototype._setRoot = function (id) {
        if (this.data.getParent(id) === this.data.getRoot()) {
            this._currentRoot = id;
        }
    };
    Sidebar.prototype._customHandlers = function () {
        var _this = this;
        return {
            tooltip: function (e) {
                var elem = (0, html_1.locateNode)(e);
                if (!elem) {
                    return;
                }
                var id = elem.getAttribute("data-dhx-id");
                var item = _this.data.getItem(id);
                if (item.tooltip || (_this.config.collapsed && item.value)) {
                    (0, ts_message_1.tooltip)(item.tooltip || item.value, {
                        node: elem,
                        position: ts_message_1.Position.right,
                    });
                }
            },
        };
    };
    Sidebar.prototype._draw = function () {
        var _this = this;
        var _a = this.config, width = _a.width, minWidth = _a.minWidth;
        var actualWidth = this.config.collapsed ? minWidth : width;
        return (0, dom_1.el)("nav.dhx_widget.dhx_sidebar", {
            class: (this.config.css ? this.config.css : "") +
                (this.config.collapsed ? " dhx_sidebar--minimized" : ""),
            style: { width: actualWidth + "px" },
        }, [
            (0, dom_1.el)("ul.dhx_navbar.dhx_navbar--vertical", {
                "data-dhx-widget-id": this._uid,
                tabindex: 0,
                onclick: this._handlers.onclick,
                onmousedown: this._handlers.onmousedown,
                oninput: this._handlers.input,
                onmouseover: this._handlers.tooltip,
                onkeydown: this._handlers.onkeydown,
                onmousemove: this._handlers.onmousemove,
                onmouseleave: this._handlers.onmouseleave,
                _hooks: {
                    didInsert: function (node) {
                        node.el.addEventListener("keyup", function (e) {
                            if (e.which !== 9) {
                                return;
                            }
                            var elem = (0, html_1.locateNode)(document.activeElement);
                            if (!elem) {
                                return;
                            }
                            var id = elem.getAttribute("data-dhx-id");
                            var item = _this.data.getItem(id);
                            if (item.tooltip || (_this.config.collapsed && item.value)) {
                                (0, ts_message_1.tooltip)(item.tooltip || item.value, {
                                    node: elem,
                                    position: ts_message_1.Position.right,
                                    force: true,
                                });
                            }
                        }, true);
                    },
                },
            }, this.data.map(function (item) { return _this._factory(item, false); }, this.data.getRoot(), false)),
        ]);
    };
    Sidebar.prototype._getMode = function () {
        return "right";
    };
    Sidebar.prototype._customInitEvents = function () {
        var _this = this;
        this.events.on(ts_navbar_1.NavigationBarEvents.inputBlur, function () {
            if (_this._waitRestore) {
                _this.toggle();
                _this._waitRestore = false;
            }
        });
        this.events.on(ts_navbar_1.NavigationBarEvents.inputFocus, function () {
            if (_this.config.collapsed) {
                _this._waitRestore = true;
                _this.toggle();
            }
        });
    };
    return Sidebar;
}(ts_navbar_1.Navbar));
exports.Sidebar = Sidebar;


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SidebarEvents = void 0;
var SidebarEvents;
(function (SidebarEvents) {
    SidebarEvents["beforeCollapse"] = "beforeCollapse";
    SidebarEvents["afterCollapse"] = "afterCollapse";
    SidebarEvents["beforeExpand"] = "beforeExpand";
    SidebarEvents["afterExpand"] = "afterExpand";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    SidebarEvents["toggle"] = "toggle";
})(SidebarEvents || (exports.SidebarEvents = SidebarEvents = {}));


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TabbarEvents = void 0;
var TabbarEvents;
(function (TabbarEvents) {
    TabbarEvents["beforeChange"] = "beforeChange";
    TabbarEvents["change"] = "change";
    TabbarEvents["beforeClose"] = "beforeClose";
    TabbarEvents["afterClose"] = "afterClose";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TabbarEvents["close"] = "close";
})(TabbarEvents || (exports.TabbarEvents = TabbarEvents = {}));


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Editor = exports.EditorEvents = exports.EditorMode = void 0;
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var html_1 = __webpack_require__(2);
var KeyManager_1 = __webpack_require__(16);
var EditorMode;
(function (EditorMode) {
    EditorMode["editText"] = "text";
    EditorMode["selectItem"] = "select";
})(EditorMode || (exports.EditorMode = EditorMode = {}));
var EditorEvents;
(function (EditorEvents) {
    EditorEvents["begin"] = "begin";
    EditorEvents["end"] = "end";
})(EditorEvents || (exports.EditorEvents = EditorEvents = {}));
var Editor = /** @class */ (function () {
    function Editor() {
        var _this = this;
        this.events = new events_1.EventSystem();
        this._keyManager = new KeyManager_1.KeyManager();
        this._documentClick = function (e) {
            var id = (0, html_1.locate)(e, "id");
            if (id !== "input_" + _this._item.id) {
                _this._removeClickListener();
                _this._finishEdit();
            }
        };
        this._handlers = {
            editText: function (e) {
                _this._currentValue = e.target.innerText;
            },
            itemSelected: function (e) {
                _this._currentValue = e.target.value;
                _this._finishEdit();
            },
            didInsert: function (node) {
                var element = node === null || node === void 0 ? void 0 : node.el;
                if (element) {
                    if (element.childNodes.length) {
                        var range = document.createRange();
                        var selection = window.getSelection();
                        range.setStart(element.childNodes[0], element.innerText.length);
                        range.collapse(true);
                        selection.removeAllRanges();
                        selection.addRange(range);
                    }
                    element.focus();
                }
            },
        };
    }
    Editor.prototype.edit = function (targetId, config) {
        if (this._active && this._item !== config.item) {
            this._finishEdit();
        }
        this._active = true;
        this._targetId = targetId;
        this.config = config;
        this._item = config.item;
        this._currentValue = this._item.value;
        this.events.fire(EditorEvents.begin, [targetId]);
        this._initOuterClick();
        this._addHotkeys();
        return this._draw();
    };
    Editor.prototype.isEditable = function () {
        return this._active;
    };
    Editor.prototype._draw = function () {
        var _this = this;
        if (this.config.mode === EditorMode.selectItem) {
            var opts = this.config.options;
            return (0, dom_1.el)("select", {
                id: "input_" + this._item.id,
                "data-dhx-id": this._item.id,
                onchange: this._handlers.itemSelected,
            }, opts.map(function (item) {
                return (0, dom_1.el)("option", {
                    class: "editor-select",
                    value: item,
                    selected: _this._currentValue === item,
                    style: { border: "1px solid" },
                }, item);
            }));
        }
        else {
            return (0, dom_1.el)("div.dhx_tree-editor", {
                _hooks: {
                    didInsert: this._handlers.didInsert,
                },
                id: "input_" + this._item.id,
                oninput: this._handlers.editText,
                contentEditable: true,
            }, this._currentValue);
        }
    };
    Editor.prototype._addHotkeys = function () {
        var _this = this;
        this._keyManager.addHotKey("escape", function () {
            _this._finishEdit();
        });
        this._keyManager.addHotKey("enter", function () {
            _this._finishEdit();
        });
    };
    Editor.prototype._removeHotkeys = function () {
        this._keyManager.removeHotKey();
    };
    Editor.prototype._finishEdit = function () {
        if (!this.events.fire(EditorEvents.end, [this._targetId, this._item.id, this._currentValue]))
            return;
        this._clear();
    };
    Editor.prototype._clear = function () {
        this._active = false;
        this._removeClickListener();
        this._removeHotkeys();
    };
    Editor.prototype._initOuterClick = function () {
        document.addEventListener("click", this._documentClick);
    };
    Editor.prototype._removeClickListener = function () {
        document.removeEventListener("click", this._documentClick);
    };
    return Editor;
}());
exports.Editor = Editor;


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeEvents = exports.SelectStatus = void 0;
var SelectStatus;
(function (SelectStatus) {
    SelectStatus[SelectStatus["unselected"] = 0] = "unselected";
    SelectStatus[SelectStatus["selected"] = 1] = "selected";
    SelectStatus[SelectStatus["indeterminate"] = 2] = "indeterminate";
})(SelectStatus || (exports.SelectStatus = SelectStatus = {}));
var TreeEvents;
(function (TreeEvents) {
    TreeEvents["itemClick"] = "itemclick";
    TreeEvents["itemDblClick"] = "itemdblclick";
    TreeEvents["itemRightClick"] = "itemrightclick";
    TreeEvents["beforeCollapse"] = "beforeCollapse";
    TreeEvents["afterCollapse"] = "afterCollapse";
    TreeEvents["beforeExpand"] = "beforeExpand";
    TreeEvents["afterExpand"] = "afterExpand";
    TreeEvents["beforeEditStart"] = "beforeEditStart";
    TreeEvents["afterEditStart"] = "afterEditStart";
    TreeEvents["beforeEditEnd"] = "beforeEditEnd";
    TreeEvents["afterEditEnd"] = "afterEditEnd";
    TreeEvents["focusChange"] = "focusChange";
    TreeEvents["beforeCheck"] = "beforeCheck";
    TreeEvents["afterCheck"] = "afterCheck";
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    TreeEvents["itemContextMenu"] = "itemcontextmenu";
})(TreeEvents || (exports.TreeEvents = TreeEvents = {}));


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Window = void 0;
var core_1 = __webpack_require__(1);
var dom_1 = __webpack_require__(0);
var events_1 = __webpack_require__(3);
var KeyManager_1 = __webpack_require__(16);
var FocusManager_1 = __webpack_require__(20);
var ts_layout_1 = __webpack_require__(13);
var ts_toolbar_1 = __webpack_require__(35);
var helpers_1 = __webpack_require__(262);
var types_1 = __webpack_require__(119);
var WindowController_1 = __webpack_require__(263);
var ts_navbar_1 = __webpack_require__(23);
var Window = /** @class */ (function () {
    function Window(config) {
        var _this = this;
        this.config = (0, core_1.extend)({
            movable: false,
            resizable: false,
            closable: config.modal,
        }, config);
        if (this.config.node && typeof this.config.node === "string") {
            this.config.node = document.getElementById(this.config.node);
        }
        else if (!this.config.node) {
            this.config.node = document.body;
        }
        this._uid = (0, core_1.uid)();
        this.events = new events_1.EventSystem(this);
        var popup = (this._popup = document.createElement("div"));
        popup.tabIndex = 1;
        popup.setAttribute("role", "dialog");
        popup.setAttribute("aria-modal", "".concat(this.config.modal || false));
        if (!this.config.modal) {
            WindowController_1.default.add(this._uid, this._popup);
        }
        this._fullScreen = false;
        this._isActive = false;
        this._keyManager = new KeyManager_1.KeyManager(function (_, focusId) {
            return focusId === _this._uid || _this.getContainer().contains(document.activeElement);
        });
        this._initHandlers();
        this._initUI();
        if (this.config.html) {
            this.attachHTML(this.config.html);
        }
    }
    Window.prototype.paint = function () {
        this._layout.paint();
    };
    Window.prototype.isFullScreen = function () {
        return this._fullScreen;
    };
    Window.prototype.setFullScreen = function () {
        if (!this._fullScreen) {
            this._fullScreen = true;
            this.setSize(window.innerWidth, window.innerHeight);
            this.setPosition(window.pageXOffset, window.pageYOffset);
        }
    };
    Window.prototype.unsetFullScreen = function () {
        if (this._fullScreen) {
            this._fullScreen = false;
            this.setSize(this._oldSizes.width, this._oldSizes.height);
            this.setPosition(this._oldPosition.left, this._oldPosition.top);
        }
    };
    Window.prototype.setSize = function (width, height) {
        this._oldSizes = {
            width: this._popup.offsetWidth,
            height: this._popup.offsetHeight,
        };
        var size = {
            width: this._oldSizes.width,
            height: this._oldSizes.height,
        };
        if ((0, core_1.isDefined)(width)) {
            this.config.width = size.width = width;
        }
        if ((0, core_1.isDefined)(height)) {
            this.config.height = size.height = height;
        }
        this._popup.style.width = size.width + "px";
        this._popup.style.height = size.height + "px";
        this.events.fire(types_1.WindowEvents.resize, [
            size,
            this._oldSizes,
            { left: true, top: true, bottom: true, right: true },
        ]);
    };
    Window.prototype.getSize = function () {
        return {
            width: this._popup.offsetWidth,
            height: this._popup.offsetHeight,
        };
    };
    Window.prototype.setPosition = function (left, top) {
        this._oldPosition = {
            left: this._popup.offsetLeft,
            top: this._popup.offsetTop,
        };
        var position = {
            left: this._oldPosition.left,
            top: this._oldPosition.top,
        };
        if ((0, core_1.isDefined)(left)) {
            this.config.left = position.left = left;
        }
        if ((0, core_1.isDefined)(top)) {
            this.config.top = position.top = top;
        }
        this._popup.style.left = position.left + "px";
        this._popup.style.top = position.top + "px";
        this.events.fire(types_1.WindowEvents.resize, [
            position,
            this._oldPosition,
            { left: true, top: true, bottom: true, right: true },
        ]);
    };
    Window.prototype.getPosition = function () {
        return {
            left: this._popup.offsetLeft,
            top: this._popup.offsetTop,
        };
    };
    Window.prototype.show = function (left, top) {
        if (left === void 0) { left = this.config.left; }
        if (top === void 0) { top = this.config.top; }
        if (!this.events.fire(types_1.WindowEvents.beforeShow, [{ left: left, top: top }])) {
            return;
        }
        if (this.isVisible()) {
            this.hide();
        }
        WindowController_1.default.setActive(this._uid);
        this._popup.className +=
            " dhx_popup dhx_widget" +
                (this.config.modal ? " dhx_popup--window_modal" : " dhx_popup--window") +
                (this.config.css ? " " + this.config.css : "");
        this._popup.style.position = this.config.modal ? "fixed" : "absolute";
        this._popup.setAttribute("data-dhx-widget-id", this._uid);
        var _a = this._getContainerParams(), containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight, containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset;
        var width = (this.config.width =
            (typeof this.config.width === "number" && this.config.width) ||
                (typeof this.config.minWidth === "number" && this.config.minWidth) ||
                containerInnerWidth / 2);
        var height = (this.config.height =
            (typeof this.config.height === "number" && this.config.height) ||
                (typeof this.config.minHeight === "number" && this.config.minHeight) ||
                containerInnerHeight / 2);
        this.config.left = left = (0, core_1.isDefined)(left)
            ? left
            : (containerInnerWidth - width) / (this.config.modal ? 2 : 2 + containerXOffset);
        this.config.top = top = (0, core_1.isDefined)(top)
            ? top
            : (containerInnerHeight - height) / (this.config.modal ? 2 : 2 + containerYOffset);
        if (this._isActive) {
            this._popup.style.left = left + "px";
            this._popup.style.top = top + "px";
            return;
        }
        if (this.config.viewportOverflow) {
            WindowController_1.default.openFreeWindow(this.config.node);
        }
        if (this.config.modal) {
            this._blockScreen();
        }
        var content = this._layout.getCell("content");
        if (content.isVisible()) {
            content.paint();
        }
        else {
            content.show();
        }
        this._popup.style.width = width + "px";
        this._popup.style.height = height + "px";
        this._popup.style.left = left + "px";
        this._popup.style.top = top + "px";
        this.config.node.appendChild(this._popup);
        this._popup.focus();
        this._isActive = true;
        this.events.fire(types_1.WindowEvents.afterShow, [{ left: left, top: top }]);
        FocusManager_1.focusManager.setFocusId(this._uid);
    };
    Window.prototype.hide = function () {
        this._hide();
    };
    Window.prototype._hide = function (e) {
        if (!this._isActive ||
            !this.events.fire(types_1.WindowEvents.beforeHide, [{ left: this.config.left, top: this.config.top }, e])) {
            return;
        }
        if (this.config.viewportOverflow) {
            WindowController_1.default.closeFreeWindow(this.config.node);
        }
        if (this._blocker) {
            this.config.node.removeChild(this._blocker);
            if (this.config.closable) {
                this._keyManager.removeHotKey(null, this);
            }
            this._blocker = null;
        }
        this.config.node.removeChild(this._popup);
        this._layout.getCell("content").hide();
        this._isActive = false;
        this.events.fire(types_1.WindowEvents.afterHide, [{ left: this.config.left, top: this.config.top }, e]);
    };
    Window.prototype.isVisible = function () {
        return this._isActive;
    };
    Window.prototype.getWidget = function () {
        return this._layout.getCell("content").getWidget();
    };
    Window.prototype.getContainer = function () {
        return this.getRootView().data._container;
    };
    Window.prototype.attach = function (name, config) {
        this._layout.getCell("content").attach(name, config);
    };
    Window.prototype.attachHTML = function (html) {
        this._layout.getCell("content").attachHTML(html);
    };
    Window.prototype.getRootView = function () {
        return this._layout.getRootView();
    };
    Window.prototype.destructor = function () {
        this._isActive && this.hide();
        this.header && this.header.destructor();
        this.footer && this.footer.destructor();
        this.events && this.events.clear();
        this._keyManager && this._keyManager.destructor();
        this._layout && this._layout.destructor();
        this.config = this.header = this.footer = this.events = null;
        this._popup = this._uid = this._handlers = this._isActive = this._keyManager = this._fullScreen = this._oldSizes = this._oldPosition = null;
    };
    /** @deprecated See a documentation: https://docs.dhtmlx.com/ */
    Window.prototype.fullScreen = function () {
        this.setFullScreen();
    };
    Window.prototype._initHandlers = function () {
        var _this = this;
        this._handlers = {
            headerDblClick: function (e) { return _this.events.fire(types_1.WindowEvents.headerDoubleClick, [e]); },
            move: function (e) {
                if (e.which === 3) {
                    return;
                }
                e.preventDefault();
                (0, helpers_1.detectDrag)(e).then(function (pos) {
                    if (pos) {
                        _this._startDrag(pos.x, pos.y);
                    }
                });
            },
            resize: {
                ".dhx_window-resizer": function (e) {
                    if (e.which === 3) {
                        return;
                    }
                    e.preventDefault();
                    WindowController_1.default.setActive(_this._uid);
                    (0, helpers_1.detectDrag)(e).then(function (pos) {
                        if (pos) {
                            var classList = e.target.classList;
                            if (classList.contains("dhx_window-resizer--left")) {
                                _this._startResize({ left: true });
                            }
                            else if (classList.contains("dhx_window-resizer--right")) {
                                _this._startResize({ right: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top")) {
                                _this._startResize({ top: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom")) {
                                _this._startResize({ bottom: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom_left")) {
                                _this._startResize({ left: true, bottom: true });
                            }
                            else if (classList.contains("dhx_window-resizer--bottom_right")) {
                                _this._startResize({ bottom: true, right: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top_left")) {
                                _this._startResize({ top: true, left: true });
                            }
                            else if (classList.contains("dhx_window-resizer--top_right")) {
                                _this._startResize({ top: true, right: true });
                            }
                        }
                    });
                },
            },
            setActive: function () {
                WindowController_1.default.setActive(_this._uid);
            },
        };
    };
    Window.prototype._initUI = function () {
        var _this = this;
        var rows = [];
        var isHeader = (this.config.header || this.config.title || this.config.closable || this.config.movable) &&
            this.config.header !== false;
        if (isHeader) {
            rows.push({
                id: "header",
                height: "content",
                css: "dhx_window-header " + (this.config.movable ? "dhx_window-header--movable" : ""),
                on: {
                    mousedown: this.config.movable && this._handlers.move,
                    dblclick: this._handlers.headerDblClick,
                },
            });
        }
        rows.push({
            id: "content",
            css: isHeader ? "dhx_window-content" : "dhx_window-content-without-header",
        });
        if (this.config.footer) {
            rows.push({ id: "footer", height: "content", css: "dhx_window-footer" });
        }
        if (this.config.resizable) {
            rows.push({ id: "resizers", height: "content", css: "resizers" });
        }
        var layout = (this._layout = new ts_layout_1.Layout(this._popup, {
            css: "dhx_window" + (this.config.modal ? " dhx_window--modal" : ""),
            rows: rows,
            on: {
                mousedown: this._handlers.setActive,
            },
            id: this._uid,
        }));
        if (isHeader) {
            var header = (this.header = new ts_toolbar_1.Toolbar());
            if (this.config.title) {
                this.header.data.add({
                    type: "title",
                    value: this.config.title,
                    id: "title",
                    css: "title_max",
                });
                this._popup.setAttribute("aria-label", this.config.title);
            }
            if (this.config.closable) {
                this.header.data.add({
                    type: "spacer",
                });
                this.header.data.add({
                    id: "close",
                    type: "button",
                    view: "link",
                    size: "medium",
                    color: "secondary",
                    circle: true,
                    icon: "dxi dxi-close",
                });
                header.events.on(ts_navbar_1.NavigationBarEvents.click, function (id, e) {
                    if (id === "close") {
                        _this._hide(e);
                    }
                });
            }
            layout.getCell("header").attach(header);
        }
        if (this.config.footer) {
            var footer = (this.footer = new ts_toolbar_1.Toolbar());
            layout.getCell("footer").attach(footer);
        }
        if (this.config.resizable) {
            layout.getCell("resizers").attach(function () { return _this._drawResizers(); });
        }
    };
    Window.prototype._drawResizers = function () {
        return (0, dom_1.el)(".dhx-resizers", {
            onmousedown: this._handlers.resize,
        }, [
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--left", { _ref: "left" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--right", { _ref: "right" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom", { _ref: "bottom" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top", { _ref: "top" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom_right", { _ref: "bottomRight" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--bottom_left", { _ref: "bottomLeft" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top_right", { _ref: "topRight" }),
            (0, dom_1.el)(".dhx_window-resizer.dhx_window-resizer--top_left", { _ref: "topLeft" }),
        ]);
    };
    Window.prototype._startDrag = function (x, y) {
        var _this = this;
        this.config.node.classList.add("dhx_window--stop_selection");
        var deltaX = x - this._popup.offsetLeft;
        var deltaY = y - this._popup.offsetTop;
        var width = this._popup.offsetWidth;
        var height = this._popup.offsetHeight;
        var mousemove = function (e) {
            var oldposition = {
                left: _this._popup.offsetLeft,
                top: _this._popup.offsetTop,
            };
            var newX = e.pageX - deltaX;
            var newY = e.pageY - deltaY;
            if (!_this.config.viewportOverflow) {
                var _a = _this._getContainerParams(), containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset, containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight;
                if (newX < containerXOffset) {
                    newX = containerXOffset;
                }
                else if (newX > containerXOffset + containerInnerWidth - width) {
                    newX = containerXOffset + containerInnerWidth - width;
                }
                if (newY < containerYOffset) {
                    newY = containerYOffset;
                }
                else if (newY > containerYOffset + containerInnerHeight - height) {
                    newY = containerYOffset + containerInnerHeight - height;
                }
            }
            _this.config.left = newX;
            _this.config.top = newY;
            _this._popup.style.left = newX + "px";
            _this._popup.style.top = newY + "px";
            var position = { left: newX, top: newY };
            _this.events.fire(types_1.WindowEvents.move, [
                position,
                oldposition,
                { left: true, top: true, bottom: true, right: true },
            ]);
        };
        var mouseup = function () {
            document.removeEventListener("mouseup", mouseup);
            document.removeEventListener("mousemove", mousemove);
            _this.config.node.classList.remove("dhx_window--stop_selection");
        };
        document.addEventListener("mouseup", mouseup);
        document.addEventListener("mousemove", mousemove);
    };
    Window.prototype._startResize = function (resizeConfig) {
        var _this = this;
        var minWidth = this.config.minWidth | 100;
        var minHeight = this.config.minHeight | 100;
        var left = this._popup.offsetLeft;
        var top = this._popup.offsetTop;
        var width = this._popup.offsetWidth;
        var height = this._popup.offsetHeight;
        var root = this.getRootView().refs;
        var resizer;
        var resizeClassName;
        switch (true) {
            case resizeConfig.bottom && resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--bottom_left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.bottom && resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--bottom_right";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.top && resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--top_left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.top && resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--top-right";
                resizer = root.right;
                break;
            case resizeConfig.top:
                resizeClassName = "dhx_window-body-pointer--top";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.bottom:
                resizeClassName = "dhx_window-body-pointer--bottom";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.left:
                resizeClassName = "dhx_window-body-pointer--left";
                resizer = root.bottomLeft;
                break;
            case resizeConfig.right:
                resizeClassName = "dhx_window-body-pointer--right";
                resizer = root.right;
                break;
        }
        resizer.el.classList.add("dhx_window-resizer--active");
        this.config.node.classList.add("dhx_window--stop_selection");
        this.config.node.classList.add(resizeClassName);
        var mousemove = function (e) {
            var _a = _this._getContainerParams(), containerInnerWidth = _a.containerInnerWidth, containerInnerHeight = _a.containerInnerHeight, containerXOffset = _a.containerXOffset, containerYOffset = _a.containerYOffset;
            var size = {
                width: _this._notInNode() ? e.pageX - left : e.pageX - _this.config.node.offsetLeft - left,
                height: _this._notInNode() ? e.pageY - top : e.pageY - _this.config.node.offsetTop - top,
                left: _this._notInNode() ? e.pageX : e.pageX - _this.config.node.offsetLeft,
                top: _this._notInNode() ? e.pageY : e.pageY - _this.config.node.offsetTop,
            };
            if (resizeConfig.right) {
                if (size.width < minWidth) {
                    size.width = minWidth;
                }
                else if (size.width > containerXOffset + containerInnerWidth - left) {
                    size.width = containerXOffset + containerInnerWidth - left;
                }
                _this._popup.style.width = size.width + "px";
            }
            if (resizeConfig.bottom) {
                if (size.height < minHeight) {
                    size.height = minHeight;
                }
                else if (size.height > containerYOffset + containerInnerHeight - top) {
                    size.height = containerYOffset + containerInnerHeight - top;
                }
                _this._popup.style.height = size.height + "px";
            }
            if (resizeConfig.left) {
                if (left + width - size.left < minWidth) {
                    size.left = left + width - minWidth;
                }
                size.width = left + width - size.left;
                _this.config.left = size.left;
                _this._popup.style.left = size.left + "px";
                _this._popup.style.width = size.width + "px";
            }
            if (resizeConfig.top) {
                if (size.top < containerYOffset) {
                    size.top = containerYOffset;
                }
                else if (top + height - size.top < minHeight) {
                    size.top = top + height - minHeight;
                }
                size.height = top + height - size.top;
                _this.config.top = size.top;
                _this._popup.style.top = size.top + "px";
                _this._popup.style.height = size.height + "px";
            }
            _this.config.width = _this._popup.offsetWidth;
            _this.config.height = _this._popup.offsetHeight;
            _this.events.fire(types_1.WindowEvents.resize, [size, { left: left, top: top, height: height, width: width }, resizeConfig]);
        };
        var mouseup = function () {
            document.removeEventListener("mouseup", mouseup);
            document.removeEventListener("mousemove", mousemove);
            _this.config.node.classList.remove("dhx_window--stop_selection");
            _this.config.node.classList.remove(resizeClassName);
            resizer.el.classList.remove("dhx_window-resizer--active");
        };
        document.addEventListener("mouseup", mouseup);
        document.addEventListener("mousemove", mousemove);
    };
    Window.prototype._blockScreen = function () {
        var _this = this;
        var blocker = document.createElement("div");
        blocker.className = "dhx_window__overlay";
        this.config.node.appendChild(blocker);
        this._blocker = blocker;
        if (this.config.closable) {
            blocker.addEventListener("click", function (e) { return _this._hide(e); });
            this._keyManager.addHotKey("escape", function (e) {
                var collection1 = Array.prototype.slice.call(document.querySelectorAll(".dhx_popup--window_modal"));
                var collection2 = Array.prototype.slice.call(document.querySelectorAll(".dhx_popup--window"));
                var mainCollection = collection1.concat(collection2);
                if (mainCollection.length === 1) {
                    _this._hide(e);
                    return;
                }
                mainCollection.sort(funct