import { IEventSystem } from "../../ts-common/events";
import { DataCollection } from "./datacollection";
import { DataCallback, DataEvents, IDataCollection, IDataItem, ITreeCollection, IFilterCallback, IFilterMode, IFilterComplexMode, ITreeFilterConfig, DataDriver, ISortMode, IDataDriver, IUpdateObject, ISortConfig } from "./types";
import { Id } from "../../ts-common/types";
export declare function addToOrder(store: any, obj: object, parent: Id, index: number): void;
export declare class TreeCollection<T extends IDataItem = IDataItem> extends DataCollection<T> implements ITreeCollection<T> {
    protected _children: {
        [id: string]: T[];
    };
    protected _root: Id;
    protected _initChildren: {
        [id: string]: T[];
    };
    constructor(config?: any, events?: IEventSystem<DataEvents>);
    add(newItem: IDataItem, index?: number, parent?: Id): Id;
    add(newItem: IDataItem[], index?: number, parent?: Id): Id[];
    getRoot(): Id;
    getParent(id: Id, asObj?: boolean): Id;
    getItems(id: Id): T[];
    getLength(id?: Id): number;
    removeAll(id?: Id): void;
    update(id: Id, newItem: IUpdateObject, silent?: boolean): void;
    getIndex(id: Id): number;
    sort(rule?: ISortMode, config?: ISortConfig, ignore?: boolean): void;
    filter(rule?: IFilterMode | IFilterComplexMode | IFilterCallback, config?: ITreeFilterConfig, silent?: boolean): string;
    restoreOrder(): void;
    copy(id: Id, index: number, target?: IDataCollection | ITreeCollection, targetId?: Id): Id;
    copy(id: Id[], index: number, target?: IDataCollection | ITreeCollection, targetId?: Id): Id[];
    move(id: Id, index: number, target?: ITreeCollection | IDataCollection, targetId?: Id): Id;
    move(id: Id[], index: number, target?: ITreeCollection | IDataCollection, targetId?: Id): Id[];
    forEach(callback: DataCallback<any>, parent?: Id, level?: number): void;
    eachChild(id: Id, callback: DataCallback<T>, direct?: boolean, checkItem?: (item: IDataItem) => boolean): void;
    getNearId(id: Id): Id;
    loadItems(id: Id, driver?: IDataDriver | DataDriver): void;
    refreshItems(id: Id, driver?: IDataDriver | DataDriver): void;
    eachParent(id: Id, callback: DataCallback<T>, self?: boolean): void;
    haveItems(id: Id): boolean;
    canCopy(id: Id, target: Id): boolean;
    serialize(driver?: DataDriver, checkItem?: (item: any) => any): any;
    getId(index: number, parent?: Id): Id;
    map(callback: DataCallback<T>, parent?: Id, direct?: boolean): any[];
    getRawData(from: number, to: number, order?: T[], mode?: number, parent?: Id): T[];
    protected flatten(input: T[]): T[];
    protected _add({ newItem, index, parent, order, batch, }: {
        newItem: IDataItem;
        batch: IDataItem[];
        index: number;
        parent: Id;
        order?: number;
    }): Id;
    protected _setParent(item: IDataItem, parent: Id): void;
    protected _copy(id: Id, index: number, target?: IDataCollection | ITreeCollection, targetId?: Id, key?: number): Id;
    protected _move(id: Id, index: number, target?: ITreeCollection | IDataCollection, targetId?: Id, key?: number): Id;
    protected _moveItem(id: any, targetId: any, index: any): void;
    protected _reset(config: {
        id?: Id;
        grouping: any;
    }): void;
    protected _removeCore(id: Id): void;
    private _removeFromParentList;
    private _removeChildren;
    private _removeFromOrders;
    protected _addToOrder(_order: any, obj: any, index: number): void;
    protected _parse_data(data: any, parent?: Id): void;
    protected _parseItem(item: any): void;
    private _recursiveFilter;
    private _serialize;
    private _applyFilter;
    protected _normalizeFilters(filters: any): any;
    protected _checkFilterRule(rule: IFilterMode | IFilterComplexMode | IFilterCallback): boolean;
    protected _applySorters(): void;
}
