<?php

namespace Drupal\Core\Theme;

use Drupal\Component\Render\MarkupInterface;

/**
 * Defines an interface for a theme engine.
 *
 * A theme engine controls how to render a template.
 */
interface ThemeEngineInterface {

  /**
   * Registers templates that belong to the theme engine.
   *
   * @see hook_theme()
   */
  public function theme(array $existing, string $type, string $theme, string $path): ?array;

  /**
   * Renders a template.
   *
   * @param string $template_file
   *   The name of the template to render, without the file extension.
   * @param array $variables
   *   A keyed array of variables that will appear in the output.
   *
   * @return string|\Drupal\Component\Render\MarkupInterface
   *   The output generated by the template, plus any debug information.
   */
  public function renderTemplate(string $template_file, array $variables): string|MarkupInterface;

}
