<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 11.3-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('actions', [
  'fields' => [
    'aid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'parameters' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('actions')
->fields([
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
])
->values([
  'aid' => '2',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish comment containing keyword(s)',
])
->values([
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'label' => 'Change the author of content',
])
->values([
  'aid' => '4',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'label' => 'Unpublish content containing keyword(s)',
])
->values([
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Display a message to the user',
])
->values([
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'label' => 'Send e-mail',
])
->values([
  'aid' => '7',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'label' => 'Redirect to URL',
])
->values([
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'label' => 'Publish comment',
])
->values([
  'aid' => 'comment_save_action',
  'type' => 'comment',
  'callback' => 'comment_save_action',
  'parameters' => '',
  'label' => 'Save comment',
])
->values([
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish comment',
])
->values([
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
])
->values([
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
])
->values([
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
])
->values([
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
])
->values([
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
])
->values([
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
])
->values([
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
])
->values([
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
])
->values([
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
])
->execute();
$connection->schema()->createTable('authmap', [
  'fields' => [
    'aid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'authname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'indexes' => [
    'uid_module' => [
      'uid',
      'module',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('batch', [
  'fields' => [
    'bid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'token' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'batch' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('block', [
  'fields' => [
    'bid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ],
    'theme' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'region' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'custom' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'visibility' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'pages' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'i18n_mode' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('block')
->fields([
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
  'i18n_mode',
])
->values([
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '2',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '-1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '3',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '4',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
  'i18n_mode' => '1',
])
->values([
  'bid' => '5',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '6',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '10',
  'region' => 'footer',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '7',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '8',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '9',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '10',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '10',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'User login title',
  'cache' => '-1',
  'i18n_mode' => '1',
])
->values([
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '12',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '-10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '13',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '14',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '15',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '16',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '17',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '18',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '19',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '20',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '21',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '22',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '23',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '24',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '25',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '26',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '27',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '28',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '29',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '30',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '33',
  'module' => 'locale',
  'delta' => 'language',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '38',
  'module' => 'locale',
  'delta' => 'language',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '49',
  'module' => 'locale',
  'delta' => 'language_content',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->values([
  'bid' => '50',
  'module' => 'locale',
  'delta' => 'language_content',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
  'i18n_mode' => '0',
])
->execute();
$connection->schema()->createTable('block_custom', [
  'fields' => [
    'bid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'body' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'info' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('block_node_type', [
  'fields' => [
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
  ],
  'primary key' => [
    'module',
    'delta',
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('block_role', [
  'fields' => [
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'module',
    'delta',
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('blocked_ips', [
  'fields' => [
    'iid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'ip' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '40',
      'default' => '',
    ],
  ],
  'primary key' => [
    'iid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('blocked_ips')
->fields([
  'iid',
  'ip',
])
->values([
  'iid' => '1',
  'ip' => '111.111.111.111',
])
->execute();
$connection->schema()->createTable('comment', [
  'fields' => [
    'cid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'pid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'subject' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ],
    'thread' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ],
    'mail' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ],
    'homepage' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'cid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('contact', [
  'fields' => [
    'cid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'category' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'recipients' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'reply' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'selected' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'cid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('contact')
->fields([
  'cid',
  'category',
  'recipients',
  'reply',
  'weight',
  'selected',
])
->values([
  'cid' => '1',
  'category' => 'Website testing',
  'recipients' => 'joseph@flattandsons.com',
  'reply' => '',
  'weight' => '0',
  'selected' => '1',
])
->execute();
$connection->schema()->createTable('date_format_locale', [
  'fields' => [
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ],
  ],
  'primary key' => [
    'type',
    'language',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('date_format_type', [
  'fields' => [
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('date_format_type')
->fields([
  'type',
  'title',
  'locked',
])
->values([
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
])
->values([
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
])
->values([
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
])
->execute();
$connection->schema()->createTable('date_formats', [
  'fields' => [
    'dfid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'dfid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('date_formats')
->fields([
  'dfid',
  'format',
  'type',
  'locked',
])
->values([
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '36',
  'format' => 'r',
  'type' => 'custom',
  'locked' => '0',
])
->execute();
$connection->schema()->createTable('entity_translation', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'source' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'translate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'language',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('entity_translation_revision', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'source' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'translate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'entity_type',
    'revision_id',
    'language',
  ],
  'indexes' => [
    'revision_id' => [
      'revision_id',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('entity_translation_revision')
->fields([
  'entity_type',
  'entity_id',
  'revision_id',
  'language',
  'source',
  'uid',
  'status',
  'translate',
  'created',
  'changed',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1529615790',
  'changed' => '1529615790',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '15',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261523',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261523',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261687',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'en',
  'source' => '',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261523',
  'changed' => '1568261687',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'fr',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261721',
  'changed' => '1568261721',
])
->values([
  'entity_type' => 'node',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'is',
  'source' => 'en',
  'uid' => '1',
  'status' => '1',
  'translate' => '0',
  'created' => '1568261548',
  'changed' => '1568261548',
])
->execute();
$connection->schema()->createTable('field_config', [
  'fields' => [
    'id' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'field_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'active' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'storage_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ],
    'storage_module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'storage_active' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'data' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'cardinality' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'translatable' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'id',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('field_config')
->fields([
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
])
->values([
  'id' => '1',
  'field_name' => 'comment_body',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:7:"comment";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '2',
  'field_name' => 'body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '3',
  'field_name' => 'field_tags',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:8:"settings";a:3:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:4:"tags";s:6:"parent";i:0;}}s:21:"options_list_callback";s:28:"i18n_taxonomy_allowed_values";s:23:"entity_translation_sync";b:0;}s:12:"entity_types";a:0:{}s:12:"translatable";s:1:"0";s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_tags";a:1:{s:3:"tid";s:14:"field_tags_tid";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_tags";a:1:{s:3:"tid";s:14:"field_tags_tid";}}}}}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}s:2:"id";s:1:"3";}',
  'cardinality' => '-1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '4',
  'field_name' => 'field_image',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:8:"settings";a:2:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '6',
  'field_name' => 'field_boolean',
  'type' => 'list_boolean',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:14:"allowed_values";a:2:{i:0;s:3:"Off";i:1;s:1:"1";}s:23:"allowed_values_function";s:0:"";}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:24:"field_data_field_boolean";a:1:{s:5:"value";s:19:"field_boolean_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:28:"field_revision_field_boolean";a:1:{s:5:"value";s:19:"field_boolean_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:1:"6";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '11',
  'field_name' => 'field_file',
  'type' => 'file',
  'module' => 'file',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:13:"display_field";i:0;s:15:"display_default";i:0;s:10:"uri_scheme";s:6:"public";}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_file";a:3:{s:3:"fid";s:14:"field_file_fid";s:7:"display";s:18:"field_file_display";s:11:"description";s:22:"field_file_description";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"11";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '15',
  'field_name' => 'field_link',
  'type' => 'link_field',
  'module' => 'link',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"0";s:12:"entity_types";a:0:{}s:8:"settings";a:7:{s:10:"attributes";a:3:{s:6:"target";s:7:"default";s:5:"class";s:0:"";s:3:"rel";s:0:"";}s:3:"url";i:0;s:5:"title";s:8:"optional";s:11:"title_value";s:0:"";s:15:"title_maxlength";i:128;s:13:"enable_tokens";i:1;s:7:"display";a:1:{s:10:"url_cutoff";i:80;}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:21:"field_data_field_link";a:3:{s:3:"url";s:14:"field_link_url";s:5:"title";s:16:"field_link_title";s:10:"attributes";s:21:"field_link_attributes";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:25:"field_revision_field_link";a:3:{s:3:"url";s:14:"field_link_url";s:5:"title";s:16:"field_link_title";s:10:"attributes";s:21:"field_link_attributes";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:0:{}s:2:"id";s:2:"15";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '41',
  'field_name' => 'subject_field',
  'type' => 'text',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:2:{s:10:"max_length";i:255;s:23:"entity_translation_sync";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
])
->values([
  'id' => '48',
  'field_name' => 'field_color',
  'type' => 'list_text',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:3:{i:0;s:5:"Green";i:1;s:5:"Black";i:2;s:5:"White";}s:23:"allowed_values_function";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:22:"field_data_field_color";a:1:{s:5:"value";s:17:"field_color_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:26:"field_revision_field_color";a:1:{s:5:"value";s:17:"field_color_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:2:"48";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
])
->values([
  'id' => '49',
  'field_name' => 'field_rating',
  'type' => 'list_text',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";b:1;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:3:{i:1;s:4:"High";i:2;s:6:"Medium";i:3;s:3:"Low";}s:23:"allowed_values_function";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:23:"field_data_field_rating";a:1:{s:5:"value";s:18:"field_rating_value";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:27:"field_revision_field_rating";a:1:{s:5:"value";s:18:"field_rating_value";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:2:"id";s:2:"49";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
])
->values([
  'id' => '54',
  'field_name' => 'field_termplain',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"1";s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:4:"tags";s:6:"parent";s:1:"0";}}s:21:"options_list_callback";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:26:"field_data_field_termplain";a:1:{s:3:"tid";s:19:"field_termplain_tid";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:30:"field_revision_field_termplain";a:1:{s:3:"tid";s:19:"field_termplain_tid";}}}}}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}s:2:"id";s:2:"54";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
])
->values([
  'id' => '55',
  'field_name' => 'field_termrss',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";s:1:"1";s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:19:"sujet_de_discussion";s:6:"parent";s:1:"0";}}s:21:"options_list_callback";s:0:"";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:24:"field_data_field_termrss";a:1:{s:3:"tid";s:17:"field_termrss_tid";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:28:"field_revision_field_termrss";a:1:{s:3:"tid";s:17:"field_termrss_tid";}}}}}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}s:2:"id";s:2:"55";}',
  'cardinality' => '1',
  'translatable' => '1',
  'deleted' => '0',
])
->values([
  'id' => '59',
  'field_name' => 'field_file_mfw',
  'type' => 'file',
  'module' => 'file',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:4:{s:13:"display_field";i:0;s:15:"display_default";i:0;s:10:"uri_scheme";s:6:"public";s:23:"entity_translation_sync";a:1:{i:0;s:3:"fid";}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:25:"field_data_field_file_mfw";a:3:{s:3:"fid";s:18:"field_file_mfw_fid";s:7:"display";s:22:"field_file_mfw_display";s:11:"description";s:26:"field_file_mfw_description";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:29:"field_revision_field_file_mfw";a:3:{s:3:"fid";s:18:"field_file_mfw_fid";s:7:"display";s:22:"field_file_mfw_display";s:11:"description";s:26:"field_file_mfw_description";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"56";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '60',
  'field_name' => 'field_image_miw',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:3:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";i:0;s:23:"entity_translation_sync";a:1:{i:0;s:3:"fid";}}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:26:"field_data_field_image_miw";a:5:{s:3:"fid";s:19:"field_image_miw_fid";s:3:"alt";s:19:"field_image_miw_alt";s:5:"title";s:21:"field_image_miw_title";s:5:"width";s:21:"field_image_miw_width";s:6:"height";s:22:"field_image_miw_height";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:30:"field_revision_field_image_miw";a:5:{s:3:"fid";s:19:"field_image_miw_fid";s:3:"alt";s:19:"field_image_miw_alt";s:5:"title";s:21:"field_image_miw_title";s:5:"width";s:21:"field_image_miw_width";s:6:"height";s:22:"field_image_miw_height";}}}}}s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:2:"id";s:2:"57";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->values([
  'id' => '62',
  'field_name' => 'field_event',
  'type' => 'datetime',
  'module' => 'date',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:12:"translatable";i:0;s:12:"entity_types";a:0:{}s:8:"settings";a:7:{s:11:"granularity";a:6:{s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";s:4:"year";s:4:"year";s:6:"second";i:0;}s:11:"tz_handling";s:4:"site";s:11:"timezone_db";s:3:"UTC";s:13:"cache_enabled";i:0;s:11:"cache_count";s:1:"4";s:6:"todate";s:8:"optional";s:23:"entity_translation_sync";b:0;}s:7:"storage";a:5:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";s:1:"1";s:7:"details";a:1:{s:3:"sql";a:2:{s:18:"FIELD_LOAD_CURRENT";a:1:{s:22:"field_data_field_event";a:2:{s:5:"value";s:17:"field_event_value";s:6:"value2";s:18:"field_event_value2";}}s:19:"FIELD_LOAD_REVISION";a:1:{s:26:"field_revision_field_event";a:2:{s:5:"value";s:17:"field_event_value";s:6:"value2";s:18:"field_event_value2";}}}}}s:12:"foreign keys";a:0:{}s:7:"indexes";a:2:{s:5:"value";a:2:{i:0;s:5:"value";i:1;s:6:"value2";}s:6:"value2";a:1:{i:0;s:6:"value2";}}s:2:"id";s:2:"54";}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
])
->execute();
$connection->schema()->createTable('field_config_instance', [
  'fields' => [
    'id' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'field_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'field_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'data' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'id',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('field_config_instance')
->fields([
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
])
->values([
  'id' => '1',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_page',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '2',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '3',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '4',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:3:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"custom";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '5',
  'field_id' => '3',
  'field_name' => 'field_tags',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Tags";s:11:"description";s:63:"Enter a comma-separated list of words to describe your content.";s:6:"widget";a:4:{s:4:"type";s:21:"taxonomy_autocomplete";s:6:"weight";s:2:"-4";s:8:"settings";a:2:{s:4:"size";i:60;s:17:"autocomplete_path";s:21:"taxonomy/autocomplete";}s:6:"module";s:8:"taxonomy";}s:7:"display";a:2:{s:7:"default";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}s:6:"teaser";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:8:"required";b:0;}',
  'deleted' => '0',
])
->values([
  'id' => '6',
  'field_id' => '4',
  'field_name' => 'field_image',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:5:"Image";s:11:"description";s:40:"Upload an image to go with this article.";s:8:"required";b:0;s:8:"settings";a:10:{s:14:"file_directory";s:11:"field/image";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:11:"title_field";s:0:"";s:13:"default_image";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:4:"type";s:11:"image_image";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:6:"weight";s:2:"-1";s:6:"module";s:5:"image";}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}}}',
  'deleted' => '0',
])
->values([
  'id' => '7',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_blog',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '8',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";s:2:"-4";s:6:"module";s:4:"text";}s:8:"settings";a:4:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '12',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_forum',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '13',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:1;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:11;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:11;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '33',
  'field_id' => '11',
  'field_name' => 'field_file',
  'entity_type' => 'user',
  'bundle' => 'user',
  'data' => 'a:6:{s:5:"label";s:4:"File";s:6:"widget";a:5:{s:6:"weight";s:1:"8";s:4:"type";s:12:"file_generic";s:6:"module";s:4:"file";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:5:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:3:"txt";s:12:"max_filesize";s:0:"";s:17:"description_field";i:0;s:18:"user_register_form";i:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:8:"settings";a:0:{}s:6:"module";s:4:"file";s:6:"weight";i:0;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '34',
  'field_id' => '15',
  'field_name' => 'field_link',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:7:{s:5:"label";s:4:"Link";s:6:"widget";a:5:{s:6:"weight";s:2:"10";s:4:"type";s:10:"link_field";s:6:"module";s:4:"link";s:6:"active";i:0;s:8:"settings";a:0:{}}s:8:"settings";a:13:{s:12:"absolute_url";i:1;s:12:"validate_url";i:1;s:3:"url";i:0;s:5:"title";s:8:"disabled";s:11:"title_value";s:19:"Unused Static Title";s:27:"title_label_use_field_label";i:0;s:15:"title_maxlength";s:3:"128";s:7:"display";a:1:{s:10:"url_cutoff";s:2:"81";}s:10:"attributes";a:6:{s:6:"target";s:6:"_blank";s:3:"rel";s:8:"nofollow";s:18:"configurable_class";i:0;s:5:"class";s:7:"classes";s:18:"configurable_title";i:1;s:5:"title";s:0:"";}s:10:"rel_remove";s:19:"rel_remove_external";s:13:"enable_tokens";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"link_default";s:6:"weight";s:1:"9";s:8:"settings";a:0:{}s:6:"module";s:4:"link";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
])
->values([
  'id' => '37',
  'field_id' => '15',
  'field_name' => 'field_link',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:4:"Link";s:6:"widget";a:5:{s:6:"weight";s:2:"10";s:4:"type";s:10:"link_field";s:6:"module";s:4:"link";s:6:"active";i:0;s:8:"settings";a:0:{}}s:8:"settings";a:14:{s:12:"absolute_url";i:1;s:12:"validate_url";i:1;s:3:"url";i:0;s:5:"title";s:8:"required";s:11:"title_value";s:19:"Unused Static Title";s:20:"title_allowed_values";s:0:"";s:27:"title_label_use_field_label";i:0;s:15:"title_maxlength";s:3:"128";s:7:"display";a:1:{s:10:"url_cutoff";s:2:"81";}s:10:"attributes";a:6:{s:6:"target";s:6:"_blank";s:3:"rel";s:8:"nofollow";s:18:"configurable_class";i:0;s:5:"class";s:7:"classes";s:18:"configurable_title";i:1;s:5:"title";s:0:"";}s:10:"rel_remove";s:19:"rel_remove_external";s:13:"enable_tokens";i:1;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"link_default";s:6:"weight";s:1:"9";s:8:"settings";a:0:{}s:6:"module";s:4:"link";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";a:1:{i:0;a:3:{s:5:"title";s:6:"Drupal";s:3:"url";s:23:"https://www.drupal.org/";s:10:"attributes";a:1:{s:5:"title";s:14:"Home - Drupal ";}}}}',
  'deleted' => '0',
])
->values([
  'id' => '68',
  'field_id' => '41',
  'field_name' => 'subject_field',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:8:"required";b:1;s:8:"settings";a:4:{s:15:"text_processing";i:0;s:10:"hide_label";a:2:{s:4:"page";b:0;s:6:"entity";b:0;}s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:6:"widget";a:4:{s:6:"weight";i:-5;s:4:"type";s:14:"text_textfield";s:8:"settings";a:1:{s:4:"size";i:60;}s:6:"module";s:4:"text";}s:7:"display";a:1:{s:7:"default";a:4:{s:4:"type";s:6:"hidden";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"weight";i:1;}}}',
  'deleted' => '0',
])
->values([
  'id' => '76',
  'field_id' => '48',
  'field_name' => 'field_color',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:5:"Color";s:6:"widget";a:5:{s:6:"weight";s:2:"11";s:4:"type";s:14:"options_select";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:10;}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
])
->values([
  'id' => '77',
  'field_id' => '49',
  'field_name' => 'field_rating',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:6:"Rating";s:6:"widget";a:5:{s:6:"weight";s:2:"12";s:4:"type";s:15:"options_buttons";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:11;}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
])
->values([
  'id' => '78',
  'field_id' => '6',
  'field_name' => 'field_boolean',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:7:"Boolean";s:6:"widget";a:4:{s:4:"type";s:13:"options_onoff";s:6:"weight";s:2:"14";s:8:"settings";a:1:{s:13:"display_label";i:0;}s:6:"module";s:7:"options";}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:12;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '83',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_et',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '84',
  'field_id' => '54',
  'field_name' => 'field_termplain',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:9:"termplain";s:6:"widget";a:4:{s:4:"type";s:15:"options_buttons";s:6:"weight";s:2:"15";s:8:"settings";a:0:{}s:6:"module";s:7:"options";}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:29:"taxonomy_term_reference_plain";s:6:"weight";s:2:"13";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '85',
  'field_id' => '55',
  'field_name' => 'field_termrss',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:7:{s:5:"label";s:7:"termrss";s:6:"widget";a:5:{s:6:"weight";s:2:"16";s:4:"type";s:15:"options_buttons";s:6:"module";s:7:"options";s:6:"active";i:1;s:8:"settings";a:0:{}}s:8:"settings";a:2:{s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:36:"taxonomy_term_reference_rss_category";s:6:"weight";s:2:"14";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"required";i:0;s:11:"description";s:0:"";s:13:"default_value";N;}',
  'deleted' => '0',
])
->values([
  'id' => '91',
  'field_id' => '59',
  'field_name' => 'field_file_mfw',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:8:"file_mfw";s:6:"widget";a:5:{s:6:"weight";s:2:"17";s:4:"type";s:8:"file_mfw";s:6:"module";s:28:"multiupload_filefield_widget";s:6:"active";i:1;s:8:"settings";a:1:{s:18:"progress_indicator";s:8:"throbber";}}s:8:"settings";a:6:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:3:"txt";s:12:"max_filesize";s:0:"";s:17:"description_field";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"file_default";s:8:"settings";a:0:{}s:6:"module";s:4:"file";s:6:"weight";i:15;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '92',
  'field_id' => '60',
  'field_name' => 'field_image_miw',
  'entity_type' => 'node',
  'bundle' => 'blog',
  'data' => 'a:6:{s:5:"label";s:9:"image_miw";s:6:"widget";a:5:{s:6:"weight";s:2:"18";s:4:"type";s:9:"image_miw";s:6:"module";s:29:"multiupload_imagefield_widget";s:6:"active";i:1;s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}}s:8:"settings";a:10:{s:14:"file_directory";s:0:"";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";i:0;s:11:"title_field";i:0;s:13:"default_image";i:0;s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:0:"";s:10:"image_link";s:0:"";}s:6:"module";s:5:"image";s:6:"weight";i:16;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->values([
  'id' => '94',
  'field_id' => '62',
  'field_name' => 'field_event',
  'entity_type' => 'node',
  'bundle' => 'forum',
  'data' => 'a:6:{s:5:"label";s:5:"event";s:6:"widget";a:5:{s:6:"weight";s:1:"2";s:4:"type";s:9:"date_text";s:6:"module";s:4:"date";s:6:"active";i:1;s:8:"settings";a:7:{s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:10:"year_range";s:5:"-3:+3";s:9:"increment";i:1;s:14:"label_position";s:5:"above";s:10:"text_parts";a:0:{}s:11:"no_fieldset";i:0;}}s:8:"settings";a:6:{s:13:"default_value";s:3:"now";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:18:"user_register_form";b:0;s:23:"entity_translation_sync";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"date_default";s:8:"settings";a:6:{s:11:"format_type";s:4:"long";s:15:"multiple_number";s:0:"";s:13:"multiple_from";s:0:"";s:11:"multiple_to";s:0:"";s:6:"fromto";s:4:"both";s:19:"show_remaining_days";b:0;}s:6:"module";s:4:"date";s:6:"weight";i:12;}}s:8:"required";i:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
])
->execute();
$connection->schema()->createTable('field_data_body', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'body_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'body_summary' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'body_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('field_data_body')
->fields([
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
])
->values([
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
])
->execute();
$connection->schema()->createTable('field_data_comment_body', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'comment_body_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'comment_body_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_boolean', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_boolean_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_color', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_color_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_color_value' => [
      [
        'field_color_value',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_event', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_event_value' => [
      'type' => 'datetime',
      'not null' => FALSE,
      'mysql_type' => 'datetime',
      'pgsql_type' => 'timestamp without time zone',
      'sqlite_type' => 'varchar',
      'sqlsrv_type' => 'smalldatetime',
    ],
    'field_event_value2' => [
      'type' => 'datetime',
      'not null' => FALSE,
      'mysql_type' => 'datetime',
      'pgsql_type' => 'timestamp without time zone',
      'sqlite_type' => 'varchar',
      'sqlsrv_type' => 'smalldatetime',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_event_value' => [
      'field_event_value',
      'field_event_value2',
    ],
    'field_event_value2' => [
      'field_event_value2',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_file', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_file_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_file_display' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ],
    'field_file_description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_image', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_alt' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ],
    'field_image_title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ],
    'field_image_width' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_height' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_link', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_link_url' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ],
    'field_link_title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'field_link_attributes' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_rating', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_rating_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_rating_value' => [
      [
        'field_rating_value',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_tags', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_tags_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_termplain', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_termplain_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_termplain_tid' => [
      'field_termplain_tid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_field_termrss', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_termrss_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_termrss_tid' => [
      'field_termrss_tid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_data_subject_field', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'subject_field_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'subject_field_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'subject_field_format' => [
      [
        'subject_field_format',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_body', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'body_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'body_summary' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'body_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('field_revision_body')
->fields([
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
])
->values([
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '15',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
])
->values([
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '16',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '1st',
  'body_summary' => '',
  'body_format' => 'filtered_html',
])
->values([
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '17',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
])
->values([
  'entity_type' => 'node',
  'bundle' => 'et',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '18',
  'language' => 'und',
  'delta' => '0',
  'body_value' => '2nd',
  'body_summary' => '',
  'body_format' => 'filtered_html',
])
->execute();
$connection->schema()->createTable('field_revision_comment_body', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'comment_body_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'comment_body_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_boolean', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_boolean_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_color', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_color_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_color_value' => [
      [
        'field_color_value',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_event', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_event_value' => [
      'type' => 'datetime',
      'not null' => FALSE,
      'mysql_type' => 'datetime',
      'pgsql_type' => 'timestamp without time zone',
      'sqlite_type' => 'varchar',
      'sqlsrv_type' => 'smalldatetime',
    ],
    'field_event_value2' => [
      'type' => 'datetime',
      'not null' => FALSE,
      'mysql_type' => 'datetime',
      'pgsql_type' => 'timestamp without time zone',
      'sqlite_type' => 'varchar',
      'sqlsrv_type' => 'smalldatetime',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_event_value' => [
      'field_event_value',
      'field_event_value2',
    ],
    'field_event_value2' => [
      'field_event_value2',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_file', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_file_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_file_display' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ],
    'field_file_description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_image', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_alt' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '512',
    ],
    'field_image_title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '1024',
    ],
    'field_image_width' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_image_height' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_link', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_link_url' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ],
    'field_link_title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'field_link_attributes' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_rating', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_rating_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_rating_value' => [
      [
        'field_rating_value',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_tags', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_tags_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'deleted',
    'entity_id',
    'revision_id',
    'language',
    'delta',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_termplain', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_termplain_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_termplain_tid' => [
      'field_termplain_tid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_field_termrss', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_termrss_tid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'field_termrss_tid' => [
      'field_termrss_tid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('field_revision_subject_field', [
  'fields' => [
    'entity_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'deleted' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'entity_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'revision_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'subject_field_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'subject_field_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ],
  'indexes' => [
    'entity_type' => [
      'entity_type',
    ],
    'bundle' => [
      'bundle',
    ],
    'deleted' => [
      'deleted',
    ],
    'entity_id' => [
      'entity_id',
    ],
    'revision_id' => [
      'revision_id',
    ],
    'language' => [
      'language',
    ],
    'subject_field_format' => [
      [
        'subject_field_format',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('file_managed', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'filename' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'uri' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'filemime' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'filesize' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('file_usage', [
  'fields' => [
    'fid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'count' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'fid',
    'module',
    'type',
    'id',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('filter', [
  'fields' => [
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'settings' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'format',
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('filter')
->fields([
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
])
->values([
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:82:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd> <table>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:1;}',
])
->values([
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'custom_text_format',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";s:2:"72";}',
])
->values([
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:37:"<div> <span> <ul> <li> <ol> <a> <img>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
])
->values([
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";s:3:"128";}',
])
->values([
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
])
->values([
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
])
->values([
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
])
->values([
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'php_code',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '0',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
])
->values([
  'format' => 'php_code',
  'module' => 'php',
  'name' => 'php_code',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
])
->values([
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
])
->values([
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
])
->execute();
$connection->schema()->createTable('filter_format', [
  'fields' => [
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
      'unsigned' => TRUE,
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'format',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('filter_format')
->fields([
  'format',
  'name',
  'cache',
  'status',
  'weight',
])
->values([
  'format' => 'custom_text_format',
  'name' => 'Custom Text format',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
])
->values([
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
])
->values([
  'format' => 'full_html',
  'name' => 'Full HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '1',
])
->values([
  'format' => 'php_code',
  'name' => 'PHP code',
  'cache' => '0',
  'status' => '0',
  'weight' => '11',
])
->values([
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
])
->execute();
$connection->schema()->createTable('flood', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'event' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'identifier' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'expiration' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('history', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'uid',
    'nid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('i18n_block_language', [
  'fields' => [
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'module',
    'delta',
    'language',
  ],
  'indexes' => [
    'language' => [
      'language',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('i18n_string', [
  'fields' => [
    'lid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'textgroup' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => 'default',
    ],
    'context' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'objectid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'property' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'objectindex' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
    ],
    'format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'lid',
  ],
  'indexes' => [
    'group_context' => [
      'textgroup',
      [
        'context',
        '50',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('i18n_string')
->fields([
  'lid',
  'textgroup',
  'context',
  'objectid',
  'type',
  'property',
  'objectindex',
  'format',
])
->values([
  'lid' => '57',
  'textgroup' => 'blocks',
  'context' => 'block:1:title',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '1',
  'format' => '',
])
->values([
  'lid' => '60',
  'textgroup' => 'blocks',
  'context' => 'block:1:body',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '1',
  'format' => 'filtered_html',
])
->values([
  'lid' => '61',
  'textgroup' => 'node',
  'context' => 'type:article:name',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '62',
  'textgroup' => 'node',
  'context' => 'type:article:title_label',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '63',
  'textgroup' => 'node',
  'context' => 'type:article:description',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '64',
  'textgroup' => 'node',
  'context' => 'type:article:help',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '65',
  'textgroup' => 'node',
  'context' => 'type:book:name',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '66',
  'textgroup' => 'node',
  'context' => 'type:book:title_label',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '67',
  'textgroup' => 'node',
  'context' => 'type:book:description',
  'objectid' => 'book',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '68',
  'textgroup' => 'node',
  'context' => 'type:page:name',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '69',
  'textgroup' => 'node',
  'context' => 'type:page:title_label',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '70',
  'textgroup' => 'node',
  'context' => 'type:page:description',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '71',
  'textgroup' => 'node',
  'context' => 'type:page:help',
  'objectid' => 'page',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '72',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:name',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '73',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:title_label',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'title_label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '74',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:description',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '75',
  'textgroup' => 'node',
  'context' => 'type:test_content_type:help',
  'objectid' => 'test_content_type',
  'type' => 'type',
  'property' => 'help',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '76',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_page:label',
  'objectid' => 'comment_node_page',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '81',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:name',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '82',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:description',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '83',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:1:name',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '1',
  'format' => '',
])
->values([
  'lid' => '84',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:1:description',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '1',
  'format' => '',
])
->values([
  'lid' => '102',
  'textgroup' => 'field',
  'context' => 'field_file:user:label',
  'objectid' => 'user',
  'type' => 'field_file',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '112',
  'textgroup' => 'field',
  'context' => 'field_link:article:label',
  'objectid' => 'article',
  'type' => 'field_link',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '113',
  'textgroup' => 'field',
  'context' => 'field_link:article:title_value',
  'objectid' => 'article',
  'type' => 'field_link',
  'property' => 'title_value',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '114',
  'textgroup' => 'field',
  'context' => 'field_link:blog:label',
  'objectid' => 'blog',
  'type' => 'field_link',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '115',
  'textgroup' => 'field',
  'context' => 'field_link:blog:title_value',
  'objectid' => 'blog',
  'type' => 'field_link',
  'property' => 'title_value',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '116',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:Some Text',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'Some Text',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '117',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:Some more text',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'Some more text',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '118',
  'textgroup' => 'field',
  'context' => 'field_text_list:#allowed_values:The key',
  'objectid' => '#allowed_values',
  'type' => 'field_text_list',
  'property' => 'The key',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '120',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '121',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '122',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:3',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '3',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '123',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:6',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '6',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '124',
  'textgroup' => 'field',
  'context' => 'field_integer_list:#allowed_values:7',
  'objectid' => '#allowed_values',
  'type' => 'field_integer_list',
  'property' => '7',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '159',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '160',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '161',
  'textgroup' => 'field',
  'context' => 'name_field:test_vocabulary:label',
  'objectid' => 'test_vocabulary',
  'type' => 'name_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '163',
  'textgroup' => 'blocks',
  'context' => 'user:login:title',
  'objectid' => 'login',
  'type' => 'user',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '272',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:name',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '273',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:description',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '674',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_book:label',
  'objectid' => 'comment_node_book',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '675',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_forum:label',
  'objectid' => 'comment_node_forum',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '676',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '677',
  'textgroup' => 'field',
  'context' => 'body:page:label',
  'objectid' => 'page',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '678',
  'textgroup' => 'field',
  'context' => 'body:article:label',
  'objectid' => 'article',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '679',
  'textgroup' => 'field',
  'context' => 'body:blog:label',
  'objectid' => 'blog',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '680',
  'textgroup' => 'field',
  'context' => 'body:book:label',
  'objectid' => 'book',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '681',
  'textgroup' => 'field',
  'context' => 'body:forum:label',
  'objectid' => 'forum',
  'type' => 'body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '682',
  'textgroup' => 'field',
  'context' => 'field_tags:article:label',
  'objectid' => 'article',
  'type' => 'field_tags',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '683',
  'textgroup' => 'field',
  'context' => 'field_tags:article:description',
  'objectid' => 'article',
  'type' => 'field_tags',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '684',
  'textgroup' => 'field',
  'context' => 'field_image:article:label',
  'objectid' => 'article',
  'type' => 'field_image',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '685',
  'textgroup' => 'field',
  'context' => 'field_image:article:description',
  'objectid' => 'article',
  'type' => 'field_image',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '686',
  'textgroup' => 'field',
  'context' => 'taxonomy_forums:forum:label',
  'objectid' => 'forum',
  'type' => 'taxonomy_forums',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '687',
  'textgroup' => 'field',
  'context' => 'field_boolean:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_boolean',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '688',
  'textgroup' => 'field',
  'context' => 'field_boolean:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_boolean',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '689',
  'textgroup' => 'field',
  'context' => 'field_boolean:test_content_type:label',
  'objectid' => 'test_content_type',
  'type' => 'field_boolean',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '754',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '755',
  'textgroup' => 'field',
  'context' => 'subject_field:comment_node_test_content_type:label',
  'objectid' => 'comment_node_test_content_type',
  'type' => 'subject_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '756',
  'textgroup' => 'field',
  'context' => 'name_field:test_vocabulary:label',
  'objectid' => 'test_vocabulary',
  'type' => 'name_field',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '758',
  'textgroup' => 'field',
  'context' => 'field_vocab_localize:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_localize',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '759',
  'textgroup' => 'field',
  'context' => 'field_vocab_translate:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_translate',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '760',
  'textgroup' => 'field',
  'context' => 'field_vocab_fixed:article:label',
  'objectid' => 'article',
  'type' => 'field_vocab_fixed',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '761',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '762',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '763',
  'textgroup' => 'field',
  'context' => 'field_color:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_color',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '764',
  'textgroup' => 'field',
  'context' => 'field_color:blog:label',
  'objectid' => 'blog',
  'type' => 'field_color',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '765',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '766',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:2',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '2',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '767',
  'textgroup' => 'field',
  'context' => 'field_rating:#allowed_values:3',
  'objectid' => '#allowed_values',
  'type' => 'field_rating',
  'property' => '3',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '768',
  'textgroup' => 'field',
  'context' => 'field_rating:blog:label',
  'objectid' => 'blog',
  'type' => 'field_rating',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '780',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:name',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '781',
  'textgroup' => 'taxonomy',
  'context' => 'vocabulary:2:description',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'description',
  'objectindex' => '2',
  'format' => '',
])
->values([
  'lid' => '794',
  'textgroup' => 'field',
  'context' => 'taxonomy_forums:forum:label',
  'objectid' => 'forum',
  'type' => 'taxonomy_forums',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '795',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_article:label',
  'objectid' => 'comment_node_article',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '796',
  'textgroup' => 'field',
  'context' => 'comment_body:comment_node_blog:label',
  'objectid' => 'comment_node_blog',
  'type' => 'comment_body',
  'property' => 'label',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '797',
  'textgroup' => 'taxonomy',
  'context' => 'term:25:name',
  'objectid' => '25',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '25',
  'format' => '',
])
->values([
  'lid' => '798',
  'textgroup' => 'taxonomy',
  'context' => 'term:25:description',
  'objectid' => '25',
  'type' => 'term',
  'property' => 'description',
  'objectindex' => '25',
  'format' => '',
])
->values([
  'lid' => '800',
  'textgroup' => 'menu',
  'context' => 'menu:main-menu:title',
  'objectid' => 'main-menu',
  'type' => 'menu',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '801',
  'textgroup' => 'menu',
  'context' => 'menu:main-menu:description',
  'objectid' => 'main-menu',
  'type' => 'menu',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '802',
  'textgroup' => 'menu',
  'context' => 'menu:menu-test-menu:description',
  'objectid' => 'menu-test-menu',
  'type' => 'menu',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '803',
  'textgroup' => 'menu',
  'context' => 'item:467:title',
  'objectid' => '467',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '467',
  'format' => '',
])
->values([
  'lid' => '804',
  'textgroup' => 'menu',
  'context' => 'item:467:description',
  'objectid' => '467',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '467',
  'format' => '',
])
->values([
  'lid' => '805',
  'textgroup' => 'field',
  'context' => 'field_checkbox:#allowed_values:0',
  'objectid' => '#allowed_values',
  'type' => 'field_checkbox',
  'property' => '0',
  'objectindex' => '0',
  'format' => '',
])
->values([
  'lid' => '806',
  'textgroup' => 'field',
  'context' => 'field_checkbox:#allowed_values:1',
  'objectid' => '#allowed_values',
  'type' => 'field_checkbox',
  'property' => '1',
  'objectindex' => '0',
  'format' => '',
])
->execute();
$connection->schema()->createTable('i18n_translation_set', [
  'fields' => [
    'tsid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'bundle' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'master_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'tsid',
  ],
  'indexes' => [
    'entity_bundle' => [
      'type',
      'bundle',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('image_effects', [
  'fields' => [
    'ieid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'isid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'data' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'ieid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('image_effects')
->fields([
  'ieid',
  'isid',
  'weight',
  'name',
  'data',
])
->values([
  'ieid' => '3',
  'isid' => '1',
  'weight' => '1',
  'name' => 'image_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:2:"55";}',
])
->values([
  'ieid' => '4',
  'isid' => '1',
  'weight' => '2',
  'name' => 'image_desaturate',
  'data' => 'a:0:{}',
])
->values([
  'ieid' => '5',
  'isid' => '2',
  'weight' => '1',
  'name' => 'image_resize',
  'data' => 'a:2:{s:5:"width";s:2:"55";s:6:"height";s:3:"100";}',
])
->values([
  'ieid' => '6',
  'isid' => '2',
  'weight' => '2',
  'name' => 'image_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"45";s:7:"bgcolor";s:7:"#FFFFFF";s:6:"random";i:0;}',
])
->values([
  'ieid' => '7',
  'isid' => '3',
  'weight' => '1',
  'name' => 'image_scale',
  'data' => 'a:3:{s:5:"width";s:3:"150";s:6:"height";s:0:"";s:7:"upscale";i:0;}',
])
->values([
  'ieid' => '8',
  'isid' => '3',
  'weight' => '2',
  'name' => 'image_crop',
  'data' => 'a:3:{s:5:"width";s:2:"50";s:6:"height";s:2:"50";s:6:"anchor";s:8:"left-top";}',
])
->execute();
$connection->schema()->createTable('image_styles', [
  'fields' => [
    'isid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'isid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('image_styles')
->fields([
  'isid',
  'name',
  'label',
])
->values([
  'isid' => '1',
  'name' => 'custom_image_style_1',
  'label' => 'Custom image style 1',
])
->values([
  'isid' => '2',
  'name' => 'custom_image_style_2',
  'label' => 'Custom image style 2',
])
->values([
  'isid' => '3',
  'name' => 'custom_image_style_3',
  'label' => 'Custom image style 3',
])
->execute();
$connection->schema()->createTable('languages', [
  'fields' => [
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'native' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'direction' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'enabled' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'plurals' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'formula' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'domain' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'prefix' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'javascript' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
  ],
  'primary key' => [
    'language',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('languages')
->fields([
  'language',
  'name',
  'native',
  'direction',
  'enabled',
  'plurals',
  'formula',
  'domain',
  'prefix',
  'weight',
  'javascript',
])
->values([
  'language' => 'en',
  'name' => 'English',
  'native' => 'English',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => '',
  'prefix' => '',
  'weight' => '0',
  'javascript' => '',
])
->values([
  'language' => 'fr',
  'name' => 'French',
  'native' => 'Français',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'fr.drupal.org',
  'prefix' => 'fr',
  'weight' => '0',
  'javascript' => '',
])
->values([
  'language' => 'is',
  'name' => 'Icelandic',
  'native' => 'Íslenska',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'is.drupal.org',
  'prefix' => 'is',
  'weight' => '0',
  'javascript' => '',
])
->execute();
$connection->schema()->createTable('locales_source', [
  'fields' => [
    'lid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'location' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'textgroup' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'default',
    ],
    'source' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'context' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'version' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '20',
      'default' => 'none',
    ],
  ],
  'primary key' => [
    'lid',
  ],
  'indexes' => [
    'textgroup_context' => [
      [
        'textgroup',
        '191',
      ],
      [
        'context',
        '50',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('locales_source')
->fields([
  'lid',
  'location',
  'textgroup',
  'source',
  'context',
  'version',
])
->values([
  'lid' => '1',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An AJAX HTTP error occurred.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '2',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'HTTP Result Code: !status',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '3',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An AJAX HTTP request terminated abnormally.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '4',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Debugging information follows.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '5',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Path: !uri',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '6',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'StatusText: !statusText',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '7',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'ResponseText: !responseText',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '8',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'ReadyState: !readyState',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '9',
  'location' => 'misc/collapse.js',
  'textgroup' => 'default',
  'source' => 'Hide',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '10',
  'location' => 'misc/collapse.js',
  'textgroup' => 'default',
  'source' => 'Show',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '11',
  'location' => 'modules/toolbar/toolbar.js',
  'textgroup' => 'default',
  'source' => 'Show shortcuts',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '12',
  'location' => 'modules/toolbar/toolbar.js',
  'textgroup' => 'default',
  'source' => 'Hide shortcuts',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '13',
  'location' => 'misc/machine-name.js',
  'textgroup' => 'default',
  'source' => 'Edit',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '14',
  'location' => 'modules/comment/comment-node-form.js',
  'textgroup' => 'default',
  'source' => '@number comments per page',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '15',
  'location' => 'misc/vertical-tabs.js',
  'textgroup' => 'default',
  'source' => '(active tab)',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '16',
  'location' => 'modules/node/content_types.js',
  'textgroup' => 'default',
  'source' => 'Requires a title',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '17',
  'location' => 'modules/node/content_types.js; modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'Not published',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '18',
  'location' => 'modules/node/content_types.js',
  'textgroup' => 'default',
  'source' => "Don't display post information",
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '19',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Re-order rows by numerical weight instead of dragging.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '20',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Show row weights',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '21',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Hide row weights',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '22',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Drag to re-order',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '23',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Changes made in this table will not be saved until the form is submitted.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '24',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => 'Other',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '25',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => '@count year from now',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '26',
  'location' => 'sites/all/modules/date/date_api/date_year_range.js',
  'textgroup' => 'default',
  'source' => '@count years from now',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '27',
  'location' => 'modules/file/file.js',
  'textgroup' => 'default',
  'source' => 'The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '28',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'Please wait...',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '29',
  'location' => 'modules/field/modules/text/text.js',
  'textgroup' => 'default',
  'source' => 'Hide summary',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '30',
  'location' => 'modules/field/modules/text/text.js',
  'textgroup' => 'default',
  'source' => 'Edit summary',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '31',
  'location' => 'misc/autocomplete.js',
  'textgroup' => 'default',
  'source' => 'Autocomplete popup',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '32',
  'location' => 'misc/autocomplete.js',
  'textgroup' => 'default',
  'source' => 'Searching for matches...',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '33',
  'location' => 'modules/contextual/contextual.js',
  'textgroup' => 'default',
  'source' => 'Configure',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '34',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Select all rows in this table',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '35',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Deselect all rows in this table',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '36',
  'location' => 'modules/user/user.permissions.js',
  'textgroup' => 'default',
  'source' => 'This permission is inherited from the authenticated user role.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '37',
  'location' => 'modules/filter/filter.admin.js',
  'textgroup' => 'default',
  'source' => 'Enabled',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '38',
  'location' => 'modules/filter/filter.admin.js',
  'textgroup' => 'default',
  'source' => 'Disabled',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '39',
  'location' => 'modules/menu/menu.js',
  'textgroup' => 'default',
  'source' => 'Not in menu',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '40',
  'location' => 'modules/book/book.js',
  'textgroup' => 'default',
  'source' => 'Not in book',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '41',
  'location' => 'modules/book/book.js',
  'textgroup' => 'default',
  'source' => 'New book',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '42',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'New revision',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '43',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'No revision',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '44',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'By @name on @date',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '45',
  'location' => 'modules/node/node.js',
  'textgroup' => 'default',
  'source' => 'By @name',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '46',
  'location' => 'modules/path/path.js',
  'textgroup' => 'default',
  'source' => 'Alias: @alias',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '47',
  'location' => 'modules/path/path.js',
  'textgroup' => 'default',
  'source' => 'No alias',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '48',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'CustomMessage: !customMessage',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '49',
  'location' => 'modules/block/block.js; sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Not restricted',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '50',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'Restricted to certain pages',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '51',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'Not customizable',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '52',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'The changes to these blocks will not be saved until the <em>Save blocks</em> button is clicked.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '53',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'The block cannot be placed in this region.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '54',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Translatable',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '55',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Not translatable',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '56',
  'location' => 'sites/all/modules/i18n/i18n_block/i18n_block.js',
  'textgroup' => 'default',
  'source' => 'Restricted to certain languages',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '57',
  'location' => 'blocks:block:1:title',
  'textgroup' => 'blocks',
  'source' => 'Mildly amusing limerick of the day',
  'context' => 'block:1:title',
  'version' => '1',
])
->values([
  'lid' => '58',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'The response failed verification so will not be processed.',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '59',
  'location' => 'misc/ajax.js',
  'textgroup' => 'default',
  'source' => 'The callback URL is not local and not trusted: !url',
  'context' => '',
  'version' => 'none',
])
->values([
  'lid' => '60',
  'location' => 'blocks:block:1:body',
  'textgroup' => 'blocks',
  'source' => "A fellow jumped off a high wall\r\nAnd had a most terrible fall\r\nHe went back to bed\r\nWith a bump on his head\r\nThat's why you don't jump off a wall",
  'context' => 'block:1:body',
  'version' => '1',
])
->values([
  'lid' => '61',
  'location' => 'node:type:article:name',
  'textgroup' => 'node',
  'source' => 'Article',
  'context' => 'type:article:name',
  'version' => '1',
])
->values([
  'lid' => '62',
  'location' => 'node:type:article:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:article:title_label',
  'version' => '1',
])
->values([
  'lid' => '63',
  'location' => 'node:type:article:description',
  'textgroup' => 'node',
  'source' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'context' => 'type:article:description',
  'version' => '1',
])
->values([
  'lid' => '64',
  'location' => 'node:type:article:help',
  'textgroup' => 'node',
  'source' => 'Help text for articles',
  'context' => 'type:article:help',
  'version' => '1',
])
->values([
  'lid' => '65',
  'location' => 'node:type:book:name',
  'textgroup' => 'node',
  'source' => 'Book page',
  'context' => 'type:book:name',
  'version' => '1',
])
->values([
  'lid' => '66',
  'location' => 'node:type:book:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:book:title_label',
  'version' => '1',
])
->values([
  'lid' => '67',
  'location' => 'node:type:book:description',
  'textgroup' => 'node',
  'source' => '<em>Books</em> have a built-in hierarchical navigation. Use for handbooks or tutorials.',
  'context' => 'type:book:description',
  'version' => '1',
])
->values([
  'lid' => '68',
  'location' => 'node:type:page:name',
  'textgroup' => 'node',
  'source' => 'Basic page',
  'context' => 'type:page:name',
  'version' => '1',
])
->values([
  'lid' => '69',
  'location' => 'node:type:page:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:page:title_label',
  'version' => '1',
])
->values([
  'lid' => '70',
  'location' => 'node:type:page:description',
  'textgroup' => 'node',
  'source' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'context' => 'type:page:description',
  'version' => '1',
])
->values([
  'lid' => '71',
  'location' => 'node:type:page:help',
  'textgroup' => 'node',
  'source' => 'Help text for basic pages',
  'context' => 'type:page:help',
  'version' => '1',
])
->values([
  'lid' => '72',
  'location' => 'node:type:test_content_type:name',
  'textgroup' => 'node',
  'source' => 'Test content type',
  'context' => 'type:test_content_type:name',
  'version' => '1',
])
->values([
  'lid' => '73',
  'location' => 'node:type:test_content_type:title_label',
  'textgroup' => 'node',
  'source' => 'Title',
  'context' => 'type:test_content_type:title_label',
  'version' => '1',
])
->values([
  'lid' => '74',
  'location' => 'node:type:test_content_type:description',
  'textgroup' => 'node',
  'source' => 'This is the description of the test content type.',
  'context' => 'type:test_content_type:description',
  'version' => '1',
])
->values([
  'lid' => '75',
  'location' => 'node:type:test_content_type:help',
  'textgroup' => 'node',
  'source' => 'Help text for test content type',
  'context' => 'type:test_content_type:help',
  'version' => '1',
])
->values([
  'lid' => '76',
  'location' => 'blocks:user:login:title',
  'textgroup' => 'blocks',
  'source' => 'User login title',
  'context' => 'user:login:title',
  'version' => '1',
])
->values([
  'lid' => '81',
  'location' => 'taxonomy:vocabulary:2:name',
  'textgroup' => 'taxonomy',
  'source' => 'Sujet de discussion',
  'context' => 'vocabulary:2:name',
  'version' => '1',
])
->values([
  'lid' => '82',
  'location' => 'taxonomy:vocabulary:2:description',
  'textgroup' => 'taxonomy',
  'source' => 'Forum navigation vocabulary',
  'context' => 'vocabulary:2:description',
  'version' => '1',
])
->values([
  'lid' => '83',
  'location' => 'taxonomy:vocabulary:1:name',
  'textgroup' => 'taxonomy',
  'source' => 'Tags',
  'context' => 'vocabulary:1:name',
  'version' => '1',
])
->values([
  'lid' => '84',
  'location' => 'taxonomy:vocabulary:1:description',
  'textgroup' => 'taxonomy',
  'source' => 'Use tags to group articles on similar topics into categories.',
  'context' => 'vocabulary:1:description',
  'version' => '1',
])
->values([
  'lid' => '102',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Name',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '112',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Menu link',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '113',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy term',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '114',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Translation set',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '115',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '116',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Full content',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '117',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Teaser',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '118',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'RSS',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '120',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Search result highlighting input',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '121',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'File',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '122',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy term page',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '123',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy vocabulary',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '124',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '159',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site name',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '160',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The name of the site, optionally links to the front page.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '161',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Actions',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '163',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Page title',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '164',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the page title as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '165',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site logo',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '166',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the logo trail as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '167',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Feed icons',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '168',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the site feed_icons statement as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '169',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Site slogan',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '170',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => "Add the site's slogan as content.",
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '171',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Status messages',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '172',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the status messages of the current page as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '173',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Breadcrumb',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '174',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the breadcrumb trail as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '175',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Primary navigation links',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '176',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the primary_links (local tasks) as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '177',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Tabs',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '178',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add the tabs (local tasks) as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '179',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User contact form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '180',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The site contact form that allows users to contact other users.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '181',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Contact form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '182',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The site contact form that allows users to send a message to site administrators.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '183',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Vocabulary terms',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '184',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'All the terms in a vocabulary.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '185',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Vocabulary',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '186',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Block',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '187',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form url path settings',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '188',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Publishing options on the Node form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '189',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '190',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form submit buttons',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '191',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Submit buttons for the node form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '192',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form comment settings',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '193',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment settings on the Node form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '197',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book options for the node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '198',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form title field',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '199',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The node title form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '200',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form menu settings',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '201',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Menu settings on the Node form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '202',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form revision log message',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '203',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Revision log message for the node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '204',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form publishing options',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '205',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node form author information',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '206',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Author information on the Node form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '207',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Entity extra field',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '208',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Entity field',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '209',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Custom content',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '210',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'General form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '211',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Everything in the form that is not displayed by other content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '212',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book navigation',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '213',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The navigation menu the book the node belongs to.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '214',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node links',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '215',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node links of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '216',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '217',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A form to add a new comment.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '218',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node last updated date',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '219',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced node was last updated.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '220',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node terms',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '221',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Taxonomy terms of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '222',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Book children',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '223',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The children menu the book the node belongs to.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '224',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node comments',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '225',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The comments of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '226',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Attached files',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '227',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A list of files attached to the node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '228',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comments and comment form.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '229',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The comments and comment form for the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '230',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node content',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '231',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The content of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '232',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node type description',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '233',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node type description.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '234',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node title',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '235',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The title of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '236',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node body',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '237',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The body of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '238',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node author',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '239',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The author of the referenced node.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '240',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Node created date',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '241',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced node was created.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '242',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Existing node',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '243',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Add a node from your site as content.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '244',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Custom',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '245',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User signature',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '246',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The signature of a user.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '247',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User links',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '248',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User links of the referenced user.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '249',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User profile',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '250',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The profile of a user.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '251',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'User picture',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '252',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The picture of a user.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '253',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment Reply Form',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '254',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'A form to add a new comment reply.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '255',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment links',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '256',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment links of the referenced comment.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '257',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Comment created date',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '258',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The date the referenced comment was created.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '259',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term name',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '260',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'The name of this taxonomy term.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '261',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '262',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'List of related terms',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '263',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Terms related to an existing term; may be child, siblings or top level.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '264',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term description',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '265',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Term description.',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '266',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Rendered entity',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '267',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Status message',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '268',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Error message',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '269',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Warning message',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '270',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Skip to main content',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '271',
  'location' => '/is/firefly-is',
  'textgroup' => 'default',
  'source' => 'Home',
  'context' => '',
  'version' => '7.92',
])
->values([
  'lid' => '272',
  'location' => NULL,
  'textgroup' => 'taxonomy',
  'source' => 'Sujet de discussion',
  'context' => 'vocabulary:2:name',
  'version' => '1',
])
->values([
  'lid' => '273',
  'location' => NULL,
  'textgroup' => 'taxonomy',
  'source' => 'Forum navigation vocabulary',
  'context' => 'vocabulary:2:description',
  'version' => '1',
])
->execute();
$connection->schema()->createTable('locales_target', [
  'fields' => [
    'lid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'translation' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'plid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'plural' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'i18n_status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'lid',
    'language',
    'plural',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('locales_target')
->fields([
  'lid',
  'translation',
  'language',
  'plid',
  'plural',
  'i18n_status',
])
->values([
  'lid' => '57',
  'translation' => 'fr - Mildly amusing limerick of the day',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '57',
  'translation' => 'is - Mildly amusing limerick of the day',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '60',
  'translation' => "fr - A fellow jumped off a high wall\r\nAnd had a most terrible fall\r\nHe went back to bed\r\nWith a bump on his head\r\nThat's why you don't jump off a wall",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '76',
  'translation' => 'fr - User login title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '113',
  'translation' => 'fr - Link',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
])
->values([
  'lid' => '163',
  'translation' => 'fr - User login title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '678',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
])
->values([
  'lid' => '684',
  'translation' => 'fr - Image',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
])
->values([
  'lid' => '687',
  'translation' => 'is - Off',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '688',
  'translation' => 'is - 1',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '758',
  'translation' => 'is field - vocab_localize',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '761',
  'translation' => 'Verte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '761',
  'translation' => 'Grænn',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '762',
  'translation' => 'Noire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '762',
  'translation' => 'Svartur',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '763',
  'translation' => 'Blanche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '763',
  'translation' => 'Hvítur',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '764',
  'translation' => 'Color',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '764',
  'translation' => 'Color',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '765',
  'translation' => 'Haute',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '765',
  'translation' => 'Hár',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '766',
  'translation' => 'Moyenne',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '766',
  'translation' => 'Miðlungs',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '767',
  'translation' => 'Faible',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '767',
  'translation' => 'Lágt',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '768',
  'translation' => 'Rating',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '768',
  'translation' => 'Rating',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '797',
  'translation' => 'fr - Emissary',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '798',
  'translation' => 'fr - Pilot episode',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '800',
  'translation' => 'fr - Main menu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '800',
  'translation' => 'is - Main menu',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '801',
  'translation' => 'fr - Main menu description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '801',
  'translation' => 'is - Main menu description',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '802',
  'translation' => 'fr - Test menu description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '803',
  'translation' => 'fr - Google',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '804',
  'translation' => 'fr - Google description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '805',
  'translation' => 'fr - Stop',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '805',
  'translation' => 'is - Stop',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '806',
  'translation' => 'Go',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->values([
  'lid' => '806',
  'translation' => 'is - Go',
  'language' => 'is',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
])
->execute();
$connection->schema()->createTable('menu_custom', [
  'fields' => [
    'menu_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ],
    'i18n_mode' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'menu_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_custom')
->fields([
  'menu_name',
  'title',
  'description',
  'language',
  'i18n_mode',
])
->values([
  'menu_name' => 'main-menu',
  'title' => 'Main menu',
  'description' => 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.',
  'language' => 'und',
  'i18n_mode' => '0',
])
->values([
  'menu_name' => 'management',
  'title' => 'Management',
  'description' => 'The <em>Management</em> menu contains links for administrative tasks.',
  'language' => 'und',
  'i18n_mode' => '0',
])
->values([
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.',
  'language' => 'und',
  'i18n_mode' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'title' => 'User menu',
  'description' => "The <em>User</em> menu contains links related to the user's account, as well as the 'Log out' link.",
  'language' => 'und',
  'i18n_mode' => '0',
])
->execute();
$connection->schema()->createTable('menu_links', [
  'fields' => [
    'menu_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'mlid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'plid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'link_path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'router_path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'link_title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'options' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ],
    'hidden' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'external' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'has_children' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'expanded' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'depth' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'customized' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'p1' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p2' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p3' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p4' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p5' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p6' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p7' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p8' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p9' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'updated' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ],
    'i18n_tsid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'mlid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_links')
->fields([
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
  'language',
  'i18n_tsid',
])
->values([
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'comment/%',
  'router_path' => 'comment/%',
  'link_title' => 'Comment permalink',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '6',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '6',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '9',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Administer content and comments.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'mlid' => '10',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '12',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '12',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'mlid' => '13',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '16',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '16',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '17',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'user-menu',
  'mlid' => '19',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '20',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '21',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '22',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Add new comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '22',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '3',
  'link_path' => 'comment/%/approve',
  'router_path' => 'comment/%/approve',
  'link_title' => 'Approve',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '24',
  'plid' => '3',
  'link_path' => 'comment/%/delete',
  'router_path' => 'comment/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '24',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '25',
  'plid' => '3',
  'link_path' => 'comment/%/edit',
  'router_path' => 'comment/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '26',
  'plid' => '3',
  'link_path' => 'comment/%/view',
  'router_path' => 'comment/%/view',
  'link_title' => 'View comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '26',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '27',
  'plid' => '17',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '27',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '20',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '29',
  'plid' => '16',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '30',
  'plid' => '9',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"List and edit site comments and the comment approval queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '9',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '8',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '20',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '36',
  'plid' => '5',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '36',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '37',
  'plid' => '8',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '38',
  'plid' => '16',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '5',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '40',
  'plid' => '15',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '17',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '7',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '8',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '44',
  'plid' => '20',
  'link_path' => 'admin/structure/menu',
  'router_path' => 'admin/structure/menu',
  'link_title' => 'Menus',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:86:"Add new menus to your site, edit existing menus, and rename and reorganize menu links.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '45',
  'plid' => '8',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '17',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '48',
  'plid' => '8',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '49',
  'plid' => '5',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '8',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '51',
  'plid' => '7',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '18',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '52',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '8',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '15',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '8',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '58',
  'plid' => '5',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '58',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '59',
  'plid' => '16',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '59',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '60',
  'plid' => '8',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '61',
  'plid' => '8',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '61',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '66',
  'plid' => '45',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '53',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '28',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '34',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/add',
  'router_path' => 'admin/structure/menu/add',
  'link_title' => 'Add menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '50',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '53',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '48',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '43',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '80',
  'plid' => '45',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '81',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '40',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '40',
  'p4' => '82',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '34',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/list',
  'router_path' => 'admin/structure/menu/list',
  'link_title' => 'List menus',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '84',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '37',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '37',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '86',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '37',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '37',
  'p4' => '89',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '90',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '30',
  'link_path' => 'admin/content/comment/new',
  'router_path' => 'admin/content/comment/new',
  'link_title' => 'Published comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '93',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '94',
  'plid' => '60',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '94',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '95',
  'plid' => '48',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '95',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '96',
  'plid' => '46',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '97',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/settings',
  'router_path' => 'admin/structure/menu/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '97',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '98',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '53',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '99',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '51',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '51',
  'p4' => '100',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '33',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '30',
  'link_path' => 'admin/content/comment/approval',
  'router_path' => 'admin/content/comment/approval',
  'link_title' => 'Unapproved comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '30',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '103',
  'plid' => '56',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '56',
  'p4' => '103',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '104',
  'plid' => '38',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '104',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '105',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '110',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '111',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '112',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/%',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '34',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '116',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '117',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '118',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '118',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '119',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '119',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '124',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '124',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '125',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '126',
  'plid' => '28',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '127',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '128',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '129',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '129',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '130',
  'plid' => '49',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '49',
  'p3' => '130',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '136',
  'plid' => '117',
  'link_path' => 'admin/structure/block/list/garland/add',
  'router_path' => 'admin/structure/block/list/garland/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '117',
  'p5' => '136',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '141',
  'plid' => '125',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '125',
  'p5' => '141',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '142',
  'plid' => '126',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '126',
  'p5' => '142',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '143',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '144',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/add',
  'router_path' => 'admin/structure/menu/manage/%/add',
  'link_title' => 'Add link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '145',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '28',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '29',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '29',
  'p3' => '147',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '148',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '80',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '80',
  'p5' => '149',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '67',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '53',
  'p4' => '67',
  'p5' => '150',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/delete',
  'router_path' => 'admin/structure/menu/manage/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '151',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/delete',
  'router_path' => 'admin/structure/menu/item/%/delete',
  'link_title' => 'Delete menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '152',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '153',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '154',
  'plid' => '105',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '101',
  'p5' => '105',
  'p6' => '154',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/edit',
  'router_path' => 'admin/structure/menu/manage/%/edit',
  'link_title' => 'Edit menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '156',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/edit',
  'router_path' => 'admin/structure/menu/item/%/edit',
  'link_title' => 'Edit menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '157',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '46',
  'p4' => '96',
  'p5' => '158',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/list',
  'router_path' => 'admin/structure/menu/manage/%/list',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '159',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/reset',
  'router_path' => 'admin/structure/menu/item/%/reset',
  'link_title' => 'Reset menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '160',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/display',
  'router_path' => 'admin/structure/types/manage/%/comment/display',
  'link_title' => 'Comment display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/fields',
  'router_path' => 'admin/structure/types/manage/%/comment/fields',
  'link_title' => 'Comment fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-100',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '163',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '164',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '165',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '166',
  'plid' => '127',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '127',
  'p6' => '166',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '167',
  'plid' => '116',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '116',
  'p6' => '167',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '168',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/main-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Main menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '168',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '169',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/management',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Management',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '169',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '170',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/navigation',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Navigation',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '170',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '171',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/user-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'User menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '171',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'search',
  'router_path' => 'search',
  'link_title' => 'Search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '173',
  'plid' => '172',
  'link_path' => 'search/node',
  'router_path' => 'search/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '173',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '175',
  'plid' => '1',
  'link_path' => 'admin/help',
  'router_path' => 'admin/help',
  'link_title' => 'Help',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Reference for usage, configuration, and modules.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '176',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '173',
  'link_path' => 'search/node/%',
  'router_path' => 'search/node/%',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '172',
  'p2' => '173',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '178',
  'plid' => '18',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '178',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '16',
  'link_path' => 'user/%/shortcuts',
  'router_path' => 'user/%/shortcuts',
  'link_title' => 'Shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '179',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '180',
  'plid' => '20',
  'link_path' => 'admin/structure/taxonomy',
  'router_path' => 'admin/structure/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '183',
  'plid' => '175',
  'link_path' => 'admin/help/block',
  'router_path' => 'admin/help/block',
  'link_title' => 'block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '183',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '185',
  'plid' => '175',
  'link_path' => 'admin/help/comment',
  'router_path' => 'admin/help/comment',
  'link_title' => 'comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '185',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '186',
  'plid' => '175',
  'link_path' => 'admin/help/contextual',
  'router_path' => 'admin/help/contextual',
  'link_title' => 'contextual',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '186',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '189',
  'plid' => '175',
  'link_path' => 'admin/help/field',
  'router_path' => 'admin/help/field',
  'link_title' => 'field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '189',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '190',
  'plid' => '175',
  'link_path' => 'admin/help/field_sql_storage',
  'router_path' => 'admin/help/field_sql_storage',
  'link_title' => 'field_sql_storage',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '191',
  'plid' => '175',
  'link_path' => 'admin/help/field_ui',
  'router_path' => 'admin/help/field_ui',
  'link_title' => 'field_ui',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '191',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '192',
  'plid' => '175',
  'link_path' => 'admin/help/file',
  'router_path' => 'admin/help/file',
  'link_title' => 'file',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '193',
  'plid' => '175',
  'link_path' => 'admin/help/filter',
  'router_path' => 'admin/help/filter',
  'link_title' => 'filter',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '193',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '194',
  'plid' => '175',
  'link_path' => 'admin/help/help',
  'router_path' => 'admin/help/help',
  'link_title' => 'help',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '195',
  'plid' => '175',
  'link_path' => 'admin/help/image',
  'router_path' => 'admin/help/image',
  'link_title' => 'image',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '196',
  'plid' => '175',
  'link_path' => 'admin/help/list',
  'router_path' => 'admin/help/list',
  'link_title' => 'list',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '197',
  'plid' => '175',
  'link_path' => 'admin/help/menu',
  'router_path' => 'admin/help/menu',
  'link_title' => 'menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '198',
  'plid' => '175',
  'link_path' => 'admin/help/node',
  'router_path' => 'admin/help/node',
  'link_title' => 'node',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '198',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '200',
  'plid' => '175',
  'link_path' => 'admin/help/options',
  'router_path' => 'admin/help/options',
  'link_title' => 'options',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '200',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '202',
  'plid' => '175',
  'link_path' => 'admin/help/path',
  'router_path' => 'admin/help/path',
  'link_title' => 'path',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '204',
  'plid' => '175',
  'link_path' => 'admin/help/search',
  'router_path' => 'admin/help/search',
  'link_title' => 'search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '205',
  'plid' => '175',
  'link_path' => 'admin/help/shortcut',
  'router_path' => 'admin/help/shortcut',
  'link_title' => 'shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '206',
  'plid' => '175',
  'link_path' => 'admin/help/system',
  'router_path' => 'admin/help/system',
  'link_title' => 'system',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '206',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '207',
  'plid' => '175',
  'link_path' => 'admin/help/taxonomy',
  'router_path' => 'admin/help/taxonomy',
  'link_title' => 'taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '208',
  'plid' => '175',
  'link_path' => 'admin/help/text',
  'router_path' => 'admin/help/text',
  'link_title' => 'text',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '208',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '209',
  'plid' => '175',
  'link_path' => 'admin/help/user',
  'router_path' => 'admin/help/user',
  'link_title' => 'user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/edit',
  'router_path' => 'taxonomy/term/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/view',
  'router_path' => 'taxonomy/term/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '211',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '212',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/%',
  'router_path' => 'admin/structure/taxonomy/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '213',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/add',
  'router_path' => 'admin/structure/taxonomy/add',
  'link_title' => 'Add vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '213',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '214',
  'plid' => '43',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '215',
  'plid' => '180',
  'link_path' => 'admin/structure/taxonomy/list',
  'router_path' => 'admin/structure/taxonomy/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '215',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '216',
  'plid' => '50',
  'link_path' => 'admin/config/search/settings',
  'router_path' => 'admin/config/search/settings',
  'link_title' => 'Search settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Configure relevance settings for search and other indexing options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '216',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '217',
  'plid' => '57',
  'link_path' => 'admin/config/user-interface/shortcut',
  'router_path' => 'admin/config/user-interface/shortcut',
  'link_title' => 'Shortcuts',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Add and modify shortcut sets.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '218',
  'plid' => '50',
  'link_path' => 'admin/config/search/path',
  'router_path' => 'admin/config/search/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '219',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/add',
  'router_path' => 'admin/config/search/path/add',
  'link_title' => 'Add alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '219',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '220',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/add-set',
  'router_path' => 'admin/config/user-interface/shortcut/add-set',
  'link_title' => 'Add shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '220',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '221',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '221',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '222',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/add',
  'router_path' => 'admin/structure/taxonomy/%/add',
  'link_title' => 'Add term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '222',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '223',
  'plid' => '216',
  'link_path' => 'admin/config/search/settings/reindex',
  'router_path' => 'admin/config/search/settings/reindex',
  'link_title' => 'Clear index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '216',
  'p5' => '223',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '224',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '224',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '225',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/%',
  'router_path' => 'admin/config/user-interface/shortcut/%',
  'link_title' => 'Edit shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '226',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/list',
  'router_path' => 'admin/structure/taxonomy/%/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '227',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/list',
  'router_path' => 'admin/config/search/path/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '227',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '228',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '228',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '229',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'router_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'link_title' => 'Add shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '229',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '230',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/delete/%',
  'router_path' => 'admin/config/search/path/delete/%',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '230',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '231',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/%/delete',
  'link_title' => 'Delete shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '231',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '232',
  'plid' => '218',
  'link_path' => 'admin/config/search/path/edit/%',
  'router_path' => 'admin/config/search/path/edit/%',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '218',
  'p5' => '232',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '233',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/edit',
  'router_path' => 'admin/config/user-interface/shortcut/%/edit',
  'link_title' => 'Edit set name',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '233',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '234',
  'plid' => '217',
  'link_path' => 'admin/config/user-interface/shortcut/link/%',
  'router_path' => 'admin/config/user-interface/shortcut/link/%',
  'link_title' => 'Edit shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '234',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '235',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '236',
  'plid' => '225',
  'link_path' => 'admin/config/user-interface/shortcut/%/links',
  'router_path' => 'admin/config/user-interface/shortcut/%/links',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '225',
  'p6' => '236',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '237',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '237',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '238',
  'plid' => '214',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '238',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '239',
  'plid' => '234',
  'link_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'link_title' => 'Delete shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '57',
  'p4' => '217',
  'p5' => '234',
  'p6' => '239',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '240',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '240',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '241',
  'plid' => '235',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '242',
  'plid' => '241',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '43',
  'p4' => '214',
  'p5' => '235',
  'p6' => '241',
  'p7' => '242',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'shortcut-set-1',
  'mlid' => '243',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '1',
  'customized' => '0',
  'p1' => '243',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'shortcut-set-1',
  'mlid' => '244',
  'plid' => '0',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Find content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-19',
  'depth' => '1',
  'customized' => '0',
  'p1' => '244',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'main-menu',
  'mlid' => '245',
  'plid' => '0',
  'link_path' => '<front>',
  'router_path' => '',
  'link_title' => 'Home',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '245',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '6',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '246',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '6',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '247',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '248',
  'plid' => '175',
  'link_path' => 'admin/help/toolbar',
  'router_path' => 'admin/help/toolbar',
  'link_title' => 'toolbar',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '248',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '287',
  'plid' => '18',
  'link_path' => 'admin/reports/updates',
  'router_path' => 'admin/reports/updates',
  'link_title' => 'Available updates',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Get a status report about available updates for your installed modules and themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '287',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '288',
  'plid' => '15',
  'link_path' => 'admin/modules/install',
  'router_path' => 'admin/modules/install',
  'link_title' => 'Install new module',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '288',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '289',
  'plid' => '7',
  'link_path' => 'admin/appearance/install',
  'router_path' => 'admin/appearance/install',
  'link_title' => 'Install new theme',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '289',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '290',
  'plid' => '15',
  'link_path' => 'admin/modules/update',
  'router_path' => 'admin/modules/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '290',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '291',
  'plid' => '7',
  'link_path' => 'admin/appearance/update',
  'router_path' => 'admin/appearance/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '291',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '292',
  'plid' => '175',
  'link_path' => 'admin/help/update',
  'router_path' => 'admin/help/update',
  'link_title' => 'update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '292',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '293',
  'plid' => '287',
  'link_path' => 'admin/reports/updates/list',
  'router_path' => 'admin/reports/updates/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '287',
  'p4' => '293',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '294',
  'plid' => '287',
  'link_path' => 'admin/reports/updates/settings',
  'router_path' => 'admin/reports/updates/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '50',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '287',
  'p4' => '294',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '295',
  'plid' => '287',
  'link_path' => 'admin/reports/updates/install',
  'router_path' => 'admin/reports/updates/install',
  'link_title' => 'Install new module or theme',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '287',
  'p4' => '295',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '296',
  'plid' => '287',
  'link_path' => 'admin/reports/updates/update',
  'router_path' => 'admin/reports/updates/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '287',
  'p4' => '296',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '337',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '337',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '16',
  'link_path' => 'user/%/contact',
  'router_path' => 'user/%/contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '353',
  'plid' => '20',
  'link_path' => 'admin/structure/contact',
  'router_path' => 'admin/structure/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '354',
  'plid' => '8',
  'link_path' => 'admin/config/date',
  'router_path' => 'admin/config/date',
  'link_title' => 'Date API',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"Settings for modules the use the Date API.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '354',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '365',
  'plid' => '5',
  'link_path' => 'node/%/translate',
  'router_path' => 'node/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '365',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '372',
  'plid' => '175',
  'link_path' => 'admin/help/contact',
  'router_path' => 'admin/help/contact',
  'link_title' => 'contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '372',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '373',
  'plid' => '175',
  'link_path' => 'admin/help/date',
  'router_path' => 'admin/help/date',
  'link_title' => 'date',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '373',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '375',
  'plid' => '175',
  'link_path' => 'admin/help/locale',
  'router_path' => 'admin/help/locale',
  'link_title' => 'locale',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '375',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '381',
  'plid' => '175',
  'link_path' => 'admin/help/translation',
  'router_path' => 'admin/help/translation',
  'link_title' => 'translation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '381',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '389',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/add',
  'router_path' => 'admin/structure/contact/add',
  'link_title' => 'Add category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '389',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '395',
  'plid' => '48',
  'link_path' => 'admin/config/regional/language',
  'router_path' => 'admin/config/regional/language',
  'link_title' => 'Languages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Configure languages for content and the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '413',
  'plid' => '48',
  'link_path' => 'admin/config/regional/translate',
  'router_path' => 'admin/config/regional/translate',
  'link_title' => 'Translate interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"Translate the built in interface and optionally other text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '418',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/add',
  'router_path' => 'admin/config/regional/language/add',
  'link_title' => 'Add language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '418',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '421',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/delete/%',
  'router_path' => 'admin/structure/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '421',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '422',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/configure',
  'router_path' => 'admin/config/regional/language/configure',
  'link_title' => 'Detection and selection',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '423',
  'plid' => '353',
  'link_path' => 'admin/structure/contact/edit/%',
  'router_path' => 'admin/structure/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '353',
  'p4' => '423',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '424',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/export',
  'router_path' => 'admin/config/regional/translate/export',
  'link_title' => 'Export',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '30',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '424',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '425',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/import',
  'router_path' => 'admin/config/regional/translate/import',
  'link_title' => 'Import',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '425',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '427',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/overview',
  'router_path' => 'admin/config/regional/language/overview',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '427',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '429',
  'plid' => '74',
  'link_path' => 'admin/config/regional/date-time/locale',
  'router_path' => 'admin/config/regional/date-time/locale',
  'link_title' => 'Localize',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Configure date formats for each locale";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '430',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/overview',
  'router_path' => 'admin/config/regional/translate/overview',
  'link_title' => 'Overview',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '430',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '433',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/translate',
  'router_path' => 'admin/config/regional/translate/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '433',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '440',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/delete/%',
  'router_path' => 'admin/config/regional/language/delete/%',
  'link_title' => 'Confirm',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '440',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '441',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/delete/%',
  'router_path' => 'admin/config/regional/translate/delete/%',
  'link_title' => 'Delete string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '441',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '444',
  'plid' => '395',
  'link_path' => 'admin/config/regional/language/edit/%',
  'router_path' => 'admin/config/regional/language/edit/%',
  'link_title' => 'Edit language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '444',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '445',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/edit/%',
  'router_path' => 'admin/config/regional/translate/edit/%',
  'link_title' => 'Edit string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '445',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '449',
  'plid' => '422',
  'link_path' => 'admin/config/regional/language/configure/session',
  'router_path' => 'admin/config/regional/language/configure/session',
  'link_title' => 'Session language detection configuration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '449',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '451',
  'plid' => '422',
  'link_path' => 'admin/config/regional/language/configure/url',
  'router_path' => 'admin/config/regional/language/configure/url',
  'link_title' => 'URL language detection configuration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '395',
  'p5' => '422',
  'p6' => '451',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '461',
  'plid' => '429',
  'link_path' => 'admin/config/regional/date-time/locale/%/edit',
  'router_path' => 'admin/config/regional/date-time/locale/%/edit',
  'link_title' => 'Localize date formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Configure date formats for each locale";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '461',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '463',
  'plid' => '429',
  'link_path' => 'admin/config/regional/date-time/locale/%/reset',
  'router_path' => 'admin/config/regional/date-time/locale/%/reset',
  'link_title' => 'Reset date formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Reset localized date formats to global defaults";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '74',
  'p5' => '429',
  'p6' => '463',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'shortcut-set-2',
  'mlid' => '472',
  'plid' => '0',
  'link_path' => 'admin/help',
  'router_path' => 'admin/help',
  'link_title' => 'Help',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-49',
  'depth' => '1',
  'customized' => '0',
  'p1' => '472',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'shortcut-set-2',
  'mlid' => '473',
  'plid' => '0',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '1',
  'customized' => '0',
  'p1' => '473',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '474',
  'plid' => '4',
  'link_path' => 'filter/tips/%',
  'router_path' => 'filter/tips/%',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '4',
  'p2' => '474',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '491',
  'plid' => '48',
  'link_path' => 'admin/config/regional/entity_translation',
  'router_path' => 'admin/config/regional/entity_translation',
  'link_title' => 'Entity translation',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:83:"Configure which entities can be translated and enable or disable language fallback.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '491',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '702',
  'plid' => '6',
  'link_path' => 'node/add/et',
  'router_path' => 'node/add/et',
  'link_title' => 'Entity translation test',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:23:"Entity translation test";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '702',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '704',
  'plid' => '3',
  'link_path' => 'comment/%/translate',
  'router_path' => 'comment/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '704',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '705',
  'plid' => '16',
  'link_path' => 'user/%/translate',
  'router_path' => 'user/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '705',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '706',
  'plid' => '175',
  'link_path' => 'admin/help/i18n',
  'router_path' => 'admin/help/i18n',
  'link_title' => 'i18n',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '706',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '707',
  'plid' => '175',
  'link_path' => 'admin/help/i18n_block',
  'router_path' => 'admin/help/i18n_block',
  'link_title' => 'i18n_block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '707',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '708',
  'plid' => '175',
  'link_path' => 'admin/help/i18n_menu',
  'router_path' => 'admin/help/i18n_menu',
  'link_title' => 'i18n_menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '708',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '709',
  'plid' => '175',
  'link_path' => 'admin/help/i18n_string',
  'router_path' => 'admin/help/i18n_string',
  'link_title' => 'i18n_string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '709',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '710',
  'plid' => '175',
  'link_path' => 'admin/help/i18n_sync',
  'router_path' => 'admin/help/i18n_sync',
  'link_title' => 'i18n_sync',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '710',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '711',
  'plid' => '175',
  'link_path' => 'admin/help/i18n_taxonomy',
  'router_path' => 'admin/help/i18n_taxonomy',
  'link_title' => 'i18n_taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '711',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '712',
  'plid' => '175',
  'link_path' => 'admin/help/link',
  'router_path' => 'admin/help/link',
  'link_title' => 'link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '712',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '714',
  'plid' => '25',
  'link_path' => 'comment/%/edit/%',
  'router_path' => 'comment/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '714',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '715',
  'plid' => '38',
  'link_path' => 'user/%/edit/%',
  'router_path' => 'user/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '715',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '716',
  'plid' => '48',
  'link_path' => 'admin/config/regional/i18n',
  'router_path' => 'admin/config/regional/i18n',
  'link_title' => 'Multilingual settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:69:"Configure extended options for multilingual content and translations.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '718',
  'plid' => '176',
  'link_path' => 'taxonomy/term/%/translate',
  'router_path' => 'taxonomy/term/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '11',
  'depth' => '2',
  'customized' => '0',
  'p1' => '176',
  'p2' => '718',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '719',
  'plid' => '48',
  'link_path' => 'admin/config/regional/i18n_translation',
  'router_path' => 'admin/config/regional/i18n_translation',
  'link_title' => 'Translation sets',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Translation sets overview.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '719',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '720',
  'plid' => '39',
  'link_path' => 'node/%/edit/%',
  'router_path' => 'node/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '720',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '721',
  'plid' => '704',
  'link_path' => 'comment/%/translate/delete/%',
  'router_path' => 'comment/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '704',
  'p3' => '721',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '722',
  'plid' => '365',
  'link_path' => 'node/%/translate/delete/%',
  'router_path' => 'node/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '365',
  'p3' => '722',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '723',
  'plid' => '705',
  'link_path' => 'user/%/translate/delete/%',
  'router_path' => 'user/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '705',
  'p3' => '723',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '724',
  'plid' => '210',
  'link_path' => 'taxonomy/term/%/edit/%',
  'router_path' => 'taxonomy/term/%/edit/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '724',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '725',
  'plid' => '716',
  'link_path' => 'admin/config/regional/i18n/configure',
  'router_path' => 'admin/config/regional/i18n/configure',
  'link_title' => 'Multilingual system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:69:"Configure extended options for multilingual content and translations.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '725',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '726',
  'plid' => '716',
  'link_path' => 'admin/config/regional/i18n/strings',
  'router_path' => 'admin/config/regional/i18n/strings',
  'link_title' => 'Strings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Options for user defined strings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '726',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '727',
  'plid' => '413',
  'link_path' => 'admin/config/regional/translate/i18n_string',
  'router_path' => 'admin/config/regional/translate/i18n_string',
  'link_title' => 'Strings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Refresh user defined strings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '413',
  'p5' => '727',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '728',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/translate',
  'router_path' => 'admin/structure/taxonomy/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '728',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '729',
  'plid' => '719',
  'link_path' => 'admin/config/regional/i18n_translation/configure',
  'router_path' => 'admin/config/regional/i18n_translation/configure',
  'link_title' => 'Translation sets',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Overview of existing translation sets.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '719',
  'p5' => '729',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '730',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/manage/translation',
  'router_path' => 'admin/structure/menu/manage/translation',
  'link_title' => 'Translation sets',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '730',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '731',
  'plid' => '716',
  'link_path' => 'admin/config/regional/i18n/variable',
  'router_path' => 'admin/config/regional/i18n/variable',
  'link_title' => 'Variables',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Configure multilingual variables.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '716',
  'p5' => '731',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '732',
  'plid' => '25',
  'link_path' => 'comment/%/edit/add/%/%',
  'router_path' => 'comment/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '732',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '733',
  'plid' => '38',
  'link_path' => 'user/%/edit/add/%/%',
  'router_path' => 'user/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '38',
  'p3' => '733',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '734',
  'plid' => '730',
  'link_path' => 'admin/structure/menu/manage/translation/add',
  'router_path' => 'admin/structure/menu/manage/translation/add',
  'link_title' => 'Add translation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '730',
  'p5' => '734',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '735',
  'plid' => '491',
  'link_path' => 'admin/config/regional/entity_translation/translatable/%',
  'router_path' => 'admin/config/regional/entity_translation/translatable/%',
  'link_title' => 'Confirm change in translatability.',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Confirmation page for changing field translatability.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '48',
  'p4' => '491',
  'p5' => '735',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '736',
  'plid' => '718',
  'link_path' => 'taxonomy/term/%/translate/delete/%',
  'router_path' => 'taxonomy/term/%/translate/delete/%',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '718',
  'p3' => '736',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '737',
  'plid' => '39',
  'link_path' => 'node/%/edit/add/%/%',
  'router_path' => 'node/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '39',
  'p3' => '737',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '738',
  'plid' => '226',
  'link_path' => 'admin/structure/taxonomy/%/list/list',
  'router_path' => 'admin/structure/taxonomy/%/list/list',
  'link_title' => 'Terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '738',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '739',
  'plid' => '113',
  'link_path' => 'admin/structure/menu/manage/%/translate',
  'router_path' => 'admin/structure/menu/manage/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '113',
  'p5' => '739',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '740',
  'plid' => '44',
  'link_path' => 'admin/structure/menu/item/%/translate',
  'router_path' => 'admin/structure/menu/item/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '44',
  'p4' => '740',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '741',
  'plid' => '226',
  'link_path' => 'admin/structure/taxonomy/%/list/sets',
  'router_path' => 'admin/structure/taxonomy/%/list/sets',
  'link_title' => 'Translation sets',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '741',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '742',
  'plid' => '210',
  'link_path' => 'taxonomy/term/%/edit/add/%/%',
  'router_path' => 'taxonomy/term/%/edit/add/%/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '176',
  'p2' => '210',
  'p3' => '742',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '743',
  'plid' => '741',
  'link_path' => 'admin/structure/taxonomy/%/list/sets/add',
  'router_path' => 'admin/structure/taxonomy/%/list/sets/add',
  'link_title' => 'Create new translation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '226',
  'p6' => '741',
  'p7' => '743',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '744',
  'plid' => '146',
  'link_path' => 'admin/structure/block/manage/%/%/translate',
  'router_path' => 'admin/structure/block/manage/%/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '28',
  'p4' => '146',
  'p5' => '744',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '922',
  'plid' => '33',
  'link_path' => 'admin/config/content/link',
  'router_path' => 'admin/config/content/link',
  'link_title' => 'Link settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Settings for the link module.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '33',
  'p4' => '922',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '923',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/display',
  'router_path' => 'admin/structure/taxonomy/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '924',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '925',
  'plid' => '212',
  'link_path' => 'admin/structure/taxonomy/%/fields',
  'router_path' => 'admin/structure/taxonomy/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '926',
  'plid' => '66',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '927',
  'plid' => '923',
  'link_path' => 'admin/structure/taxonomy/%/display/default',
  'router_path' => 'admin/structure/taxonomy/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '927',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '928',
  'plid' => '924',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '928',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '929',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '930',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '931',
  'plid' => '923',
  'link_path' => 'admin/structure/taxonomy/%/display/full',
  'router_path' => 'admin/structure/taxonomy/%/display/full',
  'link_title' => 'Taxonomy term page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '923',
  'p6' => '931',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '932',
  'plid' => '924',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '924',
  'p6' => '932',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '933',
  'plid' => '925',
  'link_path' => 'admin/structure/taxonomy/%/fields/%',
  'router_path' => 'admin/structure/taxonomy/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '934',
  'plid' => '926',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '935',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '935',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '936',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '936',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '938',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '938',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '939',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/search_index',
  'router_path' => 'admin/structure/types/manage/%/display/search_index',
  'link_title' => 'Search index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '939',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '940',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/search_result',
  'router_path' => 'admin/structure/types/manage/%/display/search_result',
  'link_title' => 'Search result highlighting input',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '940',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '941',
  'plid' => '929',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '929',
  'p6' => '941',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '942',
  'plid' => '930',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '943',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '943',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '944',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '944',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '945',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '945',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '946',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/translate',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '946',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '947',
  'plid' => '933',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '180',
  'p4' => '212',
  'p5' => '925',
  'p6' => '933',
  'p7' => '947',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '948',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '948',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '949',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '949',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '950',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '950',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '951',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/translate',
  'router_path' => 'admin/config/people/accounts/fields/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '951',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '952',
  'plid' => '934',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '66',
  'p5' => '926',
  'p6' => '934',
  'p7' => '952',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '953',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/default',
  'router_path' => 'admin/structure/types/manage/%/comment/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '953',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '954',
  'plid' => '161',
  'link_path' => 'admin/structure/types/manage/%/comment/display/full',
  'router_path' => 'admin/structure/types/manage/%/comment/display/full',
  'link_title' => 'Full comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '161',
  'p6' => '954',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '955',
  'plid' => '162',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '956',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '956',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '957',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '957',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '958',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '958',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '959',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/translate',
  'router_path' => 'admin/structure/types/manage/%/fields/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '959',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '960',
  'plid' => '942',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '930',
  'p6' => '942',
  'p7' => '960',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '961',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '961',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '962',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '962',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '963',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '963',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '964',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/translate',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/translate',
  'link_title' => 'Translate',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '964',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '965',
  'plid' => '955',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '34',
  'p4' => '114',
  'p5' => '162',
  'p6' => '955',
  'p7' => '965',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'menu_name' => 'management',
  'mlid' => '997',
  'plid' => '175',
  'link_path' => 'admin/help/syslog',
  'router_path' => 'admin/help/syslog',
  'link_title' => 'syslog',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '175',
  'p3' => '997',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->execute();
$connection->schema()->createTable('menu_router', [
  'fields' => [
    'path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'load_functions' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'to_arg_functions' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'access_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'access_arguments' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'page_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'page_arguments' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'delivery_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'fit' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'number_parts' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'context' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'tab_parent' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'tab_root' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title_arguments' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'theme_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'theme_arguments' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'position' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'include_file' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'path',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_router')
->fields([
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
])
->values([
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:5:"theme";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Install new theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/appearance/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:5:"theme";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/config/content/link',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"link_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/link',
  'title' => 'Link settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings for the link module.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/link/link.admin.inc',
])
->values([
  'path' => 'admin/config/date',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/date',
  'title' => 'Date API',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings for modules the use the Date API.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
])
->values([
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/translate',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/translate/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}i:7;a:1:{s:18:"i18n_language_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:2:{i:0;i:5;i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%/translate/%',
  'title' => 'Instance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:16:"administer users";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/locale',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'locale_date_format_language_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Localize',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure date formats for each locale',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/locale/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"locale_date_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/locale/%/edit',
  'title' => 'Localize date formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure date formats for each locale',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/locale/%/reset',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"locale_date_format_reset_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/locale/%/reset',
  'title' => 'Reset date formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Reset localized date formats to global defaults',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/entity_translation',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer entity translation";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"entity_translation_admin_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/entity_translation',
  'title' => 'Entity translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure which entities can be translated and enable or disable language fallback.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'admin/config/regional/entity_translation/translatable/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:28:"toggle field translatability";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:36:"entity_translation_translatable_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/entity_translation/translatable/%',
  'title' => 'Confirm change in translatability.',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Confirmation page for changing field translatability.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'admin/config/regional/i18n',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"variable_module_form";i:1;s:4:"i18n";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Multilingual settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '10',
  'include_file' => '',
])
->values([
  'path' => 'admin/config/regional/i18n/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"variable_module_form";i:1;s:4:"i18n";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/i18n',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Multilingual system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'admin/config/regional/i18n/strings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"variable_edit_form";i:1;a:3:{i:0;s:27:"i18n_string_allowed_formats";i:1;s:27:"i18n_string_source_language";i:2;s:39:"i18n_string_textgroup_class_[textgroup]";}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/i18n',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Strings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Options for user defined strings.',
  'position' => '',
  'weight' => '20',
  'include_file' => '',
])
->values([
  'path' => 'admin/config/regional/i18n/variable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:36:"variable_realm_select_variables_form";i:1;s:8:"language";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/i18n',
  'tab_root' => 'admin/config/regional/i18n',
  'title' => 'Variables',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure multilingual variables.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/variable/variable_realm/variable_realm.form.inc',
])
->values([
  'path' => 'admin/config/regional/i18n_translation',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'i18n_translation_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/i18n_translation',
  'title' => 'Translation sets',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Translation sets overview.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'sites/all/modules/i18n/i18n_translation/i18n_translation.admin.inc',
])
->values([
  'path' => 'admin/config/regional/i18n_translation/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'i18n_translation_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/i18n_translation',
  'tab_root' => 'admin/config/regional/i18n_translation',
  'title' => 'Translation sets',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Overview of existing translation sets.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_translation/i18n_translation.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_languages_overview_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Languages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure languages for content and the user interface.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_languages_add_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Add language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"locale_languages_configure_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'Detection and selection',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/configure/session',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:38:"locale_language_providers_session_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/configure/session',
  'title' => 'Session language detection configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/configure/url',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"locale_language_providers_url_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/configure/url',
  'title' => 'URL language detection configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"locale_languages_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/delete/%',
  'title' => 'Confirm',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/edit/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"locale_languages_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/language/edit/%',
  'title' => 'Edit language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/language/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_languages_overview_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/language',
  'tab_root' => 'admin/config/regional/language',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_overview_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Translate interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Translate the built in interface and optionally other text.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_delete_page',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate/delete/%',
  'title' => 'Delete string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/edit/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:38:"i18n_string_locale_translate_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/translate/edit/%',
  'title' => 'Edit string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_string/i18n_string.pages.inc',
])
->values([
  'path' => 'admin/config/regional/translate/export',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_export_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Export',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '30',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/i18n_string',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"i18n_string_admin_refresh_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Strings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Refresh user defined strings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'sites/all/modules/i18n/i18n_string/i18n_string.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"locale_translate_import_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Import',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_translate_overview_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/locale/locale.admin.inc',
])
->values([
  'path' => 'admin/config/regional/translate/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'i18n_string_locale_translate_seek_screen',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/translate',
  'tab_root' => 'admin/config/regional/translate',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'sites/all/modules/i18n/i18n_string/i18n_string.pages.inc',
])
->values([
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/search/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/config/search/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/config/search/path/delete/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"path_admin_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/delete/%',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/config/search/path/edit/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/edit/%',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/config/search/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/config/search/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"search_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings',
  'title' => 'Search settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure relevance settings for search and other indexing options.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.admin.inc',
])
->values([
  'path' => 'admin/config/search/settings/reindex',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"search_reindex_confirm";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings/reindex',
  'title' => 'Clear index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.admin.inc',
])
->values([
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'shortcut_set_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add and modify shortcut sets.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit shortcuts',
  'title_callback' => 'shortcut_set_title_callback',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%/add-link',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"shortcut_link_add";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'shortcut_link_add_inline',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%/delete',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_delete_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"shortcut_set_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/delete',
  'title' => 'Delete shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%/edit',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit set name',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/%/links',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/add-set',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"shortcut_set_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Add shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/link/%',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"shortcut_link_edit";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%',
  'title' => 'Edit shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"shortcut_link_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%/delete',
  'title' => 'Delete shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer content and comments.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '134',
  'description' => 'List and edit site comments and the comment approval queue.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Unapproved comments',
  'title_callback' => 'comment_count_unpublished',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_main',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help',
  'title' => 'Help',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Reference for usage, configuration, and modules.',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/block',
  'title' => 'block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/comment',
  'title' => 'comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/contact',
  'title' => 'contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/contextual',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/contextual',
  'title' => 'contextual',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/date',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/date',
  'title' => 'date',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/field',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field',
  'title' => 'field',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/field_sql_storage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field_sql_storage',
  'title' => 'field_sql_storage',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/field_ui',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field_ui',
  'title' => 'field_ui',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/file',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/file',
  'title' => 'file',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/filter',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/filter',
  'title' => 'filter',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/help',
  'title' => 'help',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n',
  'title' => 'i18n',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n_block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n_block',
  'title' => 'i18n_block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n_menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n_menu',
  'title' => 'i18n_menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n_string',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n_string',
  'title' => 'i18n_string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n_sync',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n_sync',
  'title' => 'i18n_sync',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/i18n_taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/i18n_taxonomy',
  'title' => 'i18n_taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/image',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/image',
  'title' => 'image',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/link',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/link',
  'title' => 'link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/list',
  'title' => 'list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/locale',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/locale',
  'title' => 'locale',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/menu',
  'title' => 'menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/node',
  'title' => 'node',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/options',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/options',
  'title' => 'options',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/path',
  'title' => 'path',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/search',
  'title' => 'search',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/shortcut',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/shortcut',
  'title' => 'shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/syslog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/syslog',
  'title' => 'syslog',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/system',
  'title' => 'system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/taxonomy',
  'title' => 'taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/text',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/text',
  'title' => 'text',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/toolbar',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/toolbar',
  'title' => 'toolbar',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/translation',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/translation',
  'title' => 'translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/update',
  'title' => 'update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/help/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/user',
  'title' => 'user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
])
->values([
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:6:"module";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Install new module',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/modules/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:6:"module";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/updates',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Available updates',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Get a status report about available updates for your installed modules and themes.',
  'position' => '',
  'weight' => '-50',
  'include_file' => 'modules/update/update.report.inc',
])
->values([
  'path' => 'admin/reports/updates/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_manual_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates/check',
  'title' => 'Manual update check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.fetch.inc',
])
->values([
  'path' => 'admin/reports/updates/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:6:"report";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Install new module or theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/reports/updates/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.report.inc',
])
->values([
  'path' => 'admin/reports/updates/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"update_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '50',
  'include_file' => 'modules/update/update.settings.inc',
])
->values([
  'path' => 'admin/reports/updates/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:6:"report";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/garland/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/garland',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:6:"prefix";s:11:"phptemplate";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '3',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-100',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/structure/block/manage/%/%/translate',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_block_translate_tab_access',
  'access_arguments' => 'a:2:{i:0;i:4;i:1;i:5;}',
  'page_callback' => 'i18n_block_translate_tab_page',
  'page_arguments' => 'a:2:{i:0;i:4;i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '3',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/block/manage/%/%/translate/%',
  'load_functions' => 'a:3:{i:4;N;i:5;N;i:7;s:18:"i18n_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_block_translate_tab_access',
  'access_arguments' => 'a:2:{i:0;i:4;i:1;i:5;}',
  'page_callback' => 'i18n_block_translate_tab_page',
  'page_arguments' => 'a:3:{i:0;i:4;i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '242',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%/translate/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'contact_category_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/structure/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"contact_category_edit_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/contact',
  'tab_root' => 'admin/structure/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/structure/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"contact_category_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/structure/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer contact forms";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"contact_category_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/structure/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%',
  'title' => 'Edit menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/delete',
  'title' => 'Delete menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/item/%',
  'tab_root' => 'admin/structure/menu/item/%',
  'title' => 'Edit menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/reset',
  'title' => 'Reset menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%/translate',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:9:"menu_link";i:1;i:4;}',
  'page_callback' => 'i18n_page_translate_tab',
  'page_arguments' => 'a:2:{i:0;s:9:"menu_link";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/item/%',
  'tab_root' => 'admin/structure/menu/item/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/menu/item/%/translate/%',
  'load_functions' => 'a:2:{i:4;s:14:"menu_link_load";i:6;s:18:"i18n_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:9:"menu_link";i:1;i:4;}',
  'page_callback' => 'i18n_page_translate_tab',
  'page_arguments' => 'a:3:{i:0;s:9:"menu_link";i:1;i:4;i:2;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/translate/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Customize menu',
  'title_callback' => 'i18n_menu_menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/add',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Add link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/list',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/translate',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:4:"menu";i:1;i:4;}',
  'page_callback' => 'i18n_page_translate_localize',
  'page_arguments' => 'a:2:{i:0;s:4:"menu";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/%/translate/%',
  'load_functions' => 'a:2:{i:4;s:9:"menu_load";i:6;s:18:"i18n_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:4:"menu";i:1;i:4;}',
  'page_callback' => 'i18n_page_translate_localize',
  'page_arguments' => 'a:3:{i:0;s:4:"menu";i:1;i:4;i:2;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%/translate/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/translation',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'i18n_translation_set_list_manage',
  'page_arguments' => 'a:1:{i:0;s:9:"menu_link";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Translation sets',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/menu/manage/translation/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"i18n_menu_translation_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/translation',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Add translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_menu/i18n_menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/manage/translation/delete/%',
  'load_functions' => 'a:1:{i:6;s:26:"i18n_menu_translation_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"i18n_translation_set_delete_confirm";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '126',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/translation/delete/%',
  'title' => 'Delete translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/menu/manage/translation/edit/%',
  'load_functions' => 'a:1:{i:6;s:26:"i18n_menu_translation_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"i18n_menu_translation_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '126',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/translation/edit/%',
  'title' => 'Edit translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_menu/i18n_menu.admin.inc',
])
->values([
  'path' => 'admin/structure/menu/parents',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_parent_options_js',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/parents',
  'title' => 'Parent menu items',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => '',
  'title_callback' => 'entity_label',
  'title_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/add',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;a:0:{}i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/display',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/display/default',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/display/full',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Taxonomy term page',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/edit',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"taxonomy_form_vocabulary";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '58',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/translate',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/translate/%',
  'load_functions' => 'a:3:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:7;a:1:{s:18:"i18n_language_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:2:{i:0;i:5;i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '234',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%/translate/%',
  'title' => 'Instance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:19:"administer taxonomy";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list/list',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/list',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Terms',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list/sets',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_taxonomy_vocabulary_translation_tab_sets_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'i18n_taxonomy_translation_sets_overview',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/list',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Translation sets',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list/sets/add',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_taxonomy_vocabulary_translation_tab_sets_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"i18n_taxonomy_translation_term_form";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '119',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/list/sets',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Create new translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list/sets/delete/%',
  'load_functions' => 'a:2:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";i:7;s:34:"i18n_taxonomy_translation_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_taxonomy_vocabulary_translation_tab_sets_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"i18n_translation_set_delete_confirm";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '238',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/list/sets/delete/%',
  'title' => 'Delete translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'admin/structure/taxonomy/%/list/sets/edit/%',
  'load_functions' => 'a:2:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";i:7;s:34:"i18n_taxonomy_translation_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_taxonomy_vocabulary_translation_tab_sets_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:35:"i18n_taxonomy_translation_term_form";i:1;i:3;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '238',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/list/sets/edit/%',
  'title' => 'Edit translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/translate',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'page_callback' => 'i18n_page_translate_localize',
  'page_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/%/translate/%',
  'load_functions' => 'a:2:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";i:5;s:18:"i18n_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;}',
  'page_callback' => 'i18n_page_translate_localize',
  'page_arguments' => 'a:3:{i:0;s:19:"taxonomy_vocabulary";i:1;i:3;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '58',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/translate/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/display',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/display/default',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/display/full',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:7:"comment";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '246',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:7;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/translate',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:1:{i:0;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/translate/%i18n_language',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:2:{i:0;i:7;i:1;i:9;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%/translate/%i18n_language',
  'title' => 'Instance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/search_index',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:12:"search_index";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:12:"search_index";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/search_result',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:13:"search_result";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:13:"search_result";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search result highlighting input',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:21:"field_ui_admin_access";i:4;s:11:"user_access";i:5;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/translate',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:1:{i:0;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/translate/%',
  'load_functions' => 'a:3:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:8;a:1:{s:18:"i18n_language_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'i18n_field_page_translate',
  'page_arguments' => 'a:2:{i:0;i:6;i:1;i:8;}',
  'delivery_callback' => '',
  'fit' => '490',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%/translate/%',
  'title' => 'Instance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_field/i18n_field.pages.inc',
])
->values([
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'field_ui_admin_access',
  'access_arguments' => 'a:2:{i:0;s:11:"user_access";i:1;a:1:{i:0;s:24:"administer content types";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
])
->values([
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/update/ready',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"update_manager_update_ready_form";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/update/ready',
  'title' => 'Ready to update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.manager.inc',
])
->values([
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'comment/%',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%',
  'title' => 'Comment permalink',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'comment/%/approve',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_approve',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/approve',
  'title' => 'Approve',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/comment/comment.pages.inc',
])
->values([
  'path' => 'comment/%/delete',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_confirm_delete_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'comment/%/edit',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;s:4:"edit";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'comment/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:12:"comment_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;s:4:"edit";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'comment/%/edit',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'comment/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:12:"comment_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:7:{i:0;s:7:"comment";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:5;s:4:"edit";i:6;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:6:{i:0;s:7:"comment";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:17:"comment_edit_page";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:14:"comment_access";s:16:"access arguments";a:2:{i:0;s:4:"edit";i:1;i:1;}s:4:"type";i:132;s:6:"weight";i:0;s:6:"module";s:7:"comment";}i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'comment/%/edit',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'comment/%/translate',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'comment/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:12:"comment_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:7:"comment";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'comment/%/view',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'View comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
])
->values([
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Add new comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.pages.inc',
])
->values([
  'path' => 'contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"access site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:17:"contact_site_form";}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'contact',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/contact/contact.pages.inc',
])
->values([
  'path' => 'ctools/autocomplete/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_content_autocomplete_entity',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/autocomplete/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/content.menu.inc',
])
->values([
  'path' => 'ctools/context/ajax/access/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
])
->values([
  'path' => 'ctools/context/ajax/access/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
])
->values([
  'path' => 'ctools/context/ajax/access/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_access_ajax_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/access/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-access-admin.inc',
])
->values([
  'path' => 'ctools/context/ajax/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_add',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/add',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
])
->values([
  'path' => 'ctools/context/ajax/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/configure',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
])
->values([
  'path' => 'ctools/context/ajax/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'ctools_context_ajax_item_delete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'ctools/context/ajax/delete',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/ctools/includes/context-admin.inc',
])
->values([
  'path' => 'entity_translation/taxonomy_term/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'entity_translation_taxonomy_term_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'entity_translation/taxonomy_term/autocomplete',
  'title' => 'Entity translation autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
])
->values([
  'path' => 'filter/tips/%',
  'load_functions' => 'a:1:{i:2;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'filter_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips/%',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
])
->values([
  'path' => 'i18n/taxonomy/autocomplete/language/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_taxonomy_autocomplete_language',
  'page_arguments' => 'a:2:{i:0;i:4;i:1;N;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'i18n/taxonomy/autocomplete/language/%',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.pages.inc',
])
->values([
  'path' => 'i18n/taxonomy/autocomplete/vocabulary/%/%',
  'load_functions' => 'a:2:{i:4;s:37:"taxonomy_vocabulary_machine_name_load";i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_taxonomy_autocomplete_language',
  'page_arguments' => 'a:2:{i:0;i:5;i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'i18n/taxonomy/autocomplete/vocabulary/%/%',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.pages.inc',
])
->values([
  'path' => 'i18n_string/save',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"use on-page translation";}',
  'page_callback' => 'i18n_string_l10n_client_save_string',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'i18n_string/save',
  'title' => 'Save string',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_string/i18n_string.pages.inc',
])
->values([
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;b:0;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;s:6:"update";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:1;i:2;b:0;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;i:3;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;s:6:"update";i:5;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:1;i:2;i:3;i:3;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:4;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '3',
  'tab_parent' => 'node/%/edit',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"node_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:7:{i:0;s:4:"node";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:5;s:6:"update";i:6;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:6:{i:0;s:4:"node";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:10:{s:5:"title";s:4:"Edit";s:13:"page callback";s:14:"node_page_edit";s:14:"page arguments";a:1:{i:0;i:1;}s:15:"access callback";s:11:"node_access";s:16:"access arguments";a:2:{i:0;s:6:"update";i:1;i:1;}s:6:"weight";i:0;s:4:"type";i:132;s:7:"context";i:3;s:4:"file";s:14:"node.pages.inc";s:6:"module";s:4:"node";}i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'node/%/edit',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'node/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_node_tab_access',
  'access_arguments' => 'a:3:{i:0;i:1;i:1;s:23:"_translation_tab_access";i:2;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:4:{i:0;s:4:"node";i:1;i:1;i:2;a:3:{s:13:"page callback";s:25:"translation_node_overview";s:4:"file";s:21:"translation.pages.inc";s:6:"module";s:11:"translation";}i:3;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'node/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_node_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:4:"node";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
])
->values([
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:7:"article";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/et',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:2:"et";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:2:"et";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/et',
  'title' => 'Entity translation test',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Entity translation test',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:2:{i:0;b:0;i:1;a:0:{}}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'search_is_active',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'search',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
])
->values([
  'path' => 'search/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;s:0:"";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.pages.inc',
])
->values([
  'path' => 'search/node/%',
  'load_functions' => 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'search/node',
  'tab_root' => 'search/node/%',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
])
->values([
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
])
->values([
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_taxonomy_autocomplete_field',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.pages.inc',
])
->values([
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 'i18n_taxonomy_term_name',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.pages.inc',
])
->values([
  'path' => 'taxonomy/term/%/edit',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;b:0;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;i:2;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:7:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;b:0;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;s:18:"taxonomy_form_term";i:5;i:2;i:6;N;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'taxonomy/term/%/edit/%',
  'load_functions' => 'a:2:{i:2;s:18:"taxonomy_term_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:4;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;i:2;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:7:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:4;i:3;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:4;s:18:"taxonomy_form_term";i:5;i:2;i:6;N;}',
  'delivery_callback' => '',
  'fit' => '26',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%/edit',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'taxonomy/term/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:2;s:18:"taxonomy_term_load";i:5;s:32:"entity_translation_language_load";i:6;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:6:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:5;i:3;i:6;i:4;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:5;i:2;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:8:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:5;i:3;i:6;i:4;a:9:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}s:15:"access callback";s:25:"taxonomy_term_edit_access";s:16:"access arguments";a:1:{i:0;i:2;}s:4:"type";i:132;s:6:"weight";i:10;s:4:"file";s:18:"taxonomy.admin.inc";s:6:"module";s:8:"taxonomy";}i:5;s:18:"taxonomy_form_term";i:6;i:2;i:7;N;}',
  'delivery_callback' => '',
  'fit' => '108',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%/edit',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'taxonomy/term/%/feed',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_feed',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/feed',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
])
->values([
  'path' => 'taxonomy/term/%/translate',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_taxonomy_term_tab_access',
  'access_arguments' => 'a:4:{i:0;i:2;i:1;s:28:"i18n_object_translate_access";i:2;s:13:"taxonomy_term";i:3;i:2;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;a:3:{s:13:"page callback";s:23:"i18n_page_translate_tab";s:4:"file";s:14:"i18n.pages.inc";s:6:"module";s:4:"i18n";}i:3;s:13:"taxonomy_term";i:4;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '3',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '11',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'taxonomy/term/%/translate/%',
  'load_functions' => 'a:2:{i:2;s:18:"taxonomy_term_load";i:4;s:18:"i18n_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'i18n_object_translate_access',
  'access_arguments' => 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:2;}',
  'page_callback' => 'i18n_page_translate_tab',
  'page_arguments' => 'a:3:{i:0;s:13:"taxonomy_term";i:1;i:2;i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '26',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/translate/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'taxonomy/term/%/translate/delete/%',
  'load_functions' => 'a:2:{i:2;s:18:"taxonomy_term_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_taxonomy_term_tab_access',
  'access_arguments' => 'a:4:{i:0;i:2;i:1;s:28:"i18n_object_translate_access";i:2;s:13:"taxonomy_term";i:3;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:13:"taxonomy_term";i:2;i:2;i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '54',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'taxonomy/term/%/view',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.pages.inc',
])
->values([
  'path' => 'toolbar/toggle',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access toolbar";}',
  'page_callback' => 'toolbar_toggle_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'toolbar/toggle',
  'title' => 'Toggle drawer visibility',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/contact',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_contact_personal_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"contact_personal_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/contact/contact.pages.inc',
])
->values([
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/%',
  'load_functions' => 'a:2:{i:1;s:9:"user_load";i:3;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;i:3;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '10',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 'entity_translation_edit_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_edit_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;i:1;}',
  'page_callback' => 'entity_translation_edit_page',
  'page_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;b:0;i:3;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:4;s:17:"user_profile_form";i:5;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/add/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;s:32:"entity_translation_language_load";i:5;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_add_access',
  'access_arguments' => 'a:6:{i:0;s:4:"user";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:5;i:1;}',
  'page_callback' => 'entity_translation_add_page',
  'page_arguments' => 'a:7:{i:0;s:4:"user";i:1;i:1;i:2;i:4;i:3;i:5;i:4;a:8:{s:5:"title";s:4:"Edit";s:13:"page callback";s:15:"drupal_get_form";s:14:"page arguments";a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}s:15:"access callback";s:16:"user_edit_access";s:16:"access arguments";a:1:{i:0;i:1;}s:4:"type";i:132;s:4:"file";s:14:"user.pages.inc";s:6:"module";s:4:"user";}i:5;s:17:"user_profile_form";i:6;i:1;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 'Add translation',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/shortcuts',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_switch_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"shortcut_set_switch";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
])
->values([
  'path' => 'user/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'page_callback' => 'entity_translation_overview',
  'page_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'user/%/translate/delete/%',
  'load_functions' => 'a:2:{i:1;s:9:"user_load";i:4;s:32:"entity_translation_language_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_translation_tab_access',
  'access_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"entity_translation_delete_confirm";i:1;s:4:"user";i:2;i:1;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '22',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/translate/delete/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity_translation/entity_translation.admin.inc',
])
->values([
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
])
->values([
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
])
->values([
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
])
->execute();
$connection->schema()->createTable('node', [
  'fields' => [
    'nid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'comment' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'promote' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'sticky' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'tnid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'translate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_access', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'gid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'realm' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'grant_view' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'grant_update' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'grant_delete' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
    'gid',
    'realm',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node_access')
->fields([
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
])
->values([
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
])
->execute();
$connection->schema()->createTable('node_comment_statistics', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'cid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'last_comment_timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'last_comment_name' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ],
    'last_comment_uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'comment_count' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_revision', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'log' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'comment' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'promote' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'sticky' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_type', [
  'fields' => [
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'base' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'help' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'has_title' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'title_label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'custom' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'modified' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'disabled' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'orig_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node_type')
->fields([
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
])
->values([
  'type' => 'article',
  'name' => 'Article',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'help' => 'Help text for articles',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'article',
])
->values([
  'type' => 'blog',
  'name' => 'Blog entry',
  'base' => 'blog',
  'module' => 'blog',
  'description' => 'Use for multi-user blogs. Every user gets a personal blog.',
  'help' => 'Blog away, good sir!',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '1',
  'orig_type' => 'blog',
])
->values([
  'type' => 'et',
  'name' => 'Entity translation test',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Entity translation test',
  'help' => 'Help text foret pages',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'et',
])
->values([
  'type' => 'forum',
  'name' => 'Forum topic',
  'base' => 'forum',
  'module' => 'forum',
  'description' => 'A <em>forum topic</em> starts a new discussion thread within a forum.',
  'help' => 'No name-calling, no flame wars. Be nice.',
  'has_title' => '1',
  'title_label' => 'Subject',
  'custom' => '0',
  'modified' => '1',
  'locked' => '1',
  'disabled' => '1',
  'orig_type' => 'forum',
])
->values([
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'help' => 'Help text for basic pages',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
])
->execute();
$connection->schema()->createTable('role', [
  'fields' => [
    'rid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('role')
->fields([
  'rid',
  'name',
  'weight',
])
->values([
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
])
->values([
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
])
->values([
  'rid' => '3',
  'name' => 'administrator',
  'weight' => '2',
])
->execute();
$connection->schema()->createTable('role_permission', [
  'fields' => [
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'permission' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'rid',
    'permission',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('role_permission')
->fields([
  'rid',
  'permission',
  'module',
])
->values([
  'rid' => '1',
  'permission' => 'access comments',
  'module' => 'comment',
])
->values([
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
])
->values([
  'rid' => '1',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
])
->values([
  'rid' => '2',
  'permission' => 'access comments',
  'module' => 'comment',
])
->values([
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
])
->values([
  'rid' => '2',
  'permission' => 'post comments',
  'module' => 'comment',
])
->values([
  'rid' => '2',
  'permission' => 'skip comment approval',
  'module' => 'comment',
])
->values([
  'rid' => '2',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
])
->values([
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
])
->values([
  'rid' => '3',
  'permission' => 'access administration pages',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'access all views',
  'module' => 'views',
])
->values([
  'rid' => '3',
  'permission' => 'access comments',
  'module' => 'comment',
])
->values([
  'rid' => '3',
  'permission' => 'access content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'access content overview',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'access contextual links',
  'module' => 'contextual',
])
->values([
  'rid' => '3',
  'permission' => 'access site in maintenance mode',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'access site reports',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'access site-wide contact form',
  'module' => 'contact',
])
->values([
  'rid' => '3',
  'permission' => 'access toolbar',
  'module' => 'toolbar',
])
->values([
  'rid' => '3',
  'permission' => 'access user contact forms',
  'module' => 'contact',
])
->values([
  'rid' => '3',
  'permission' => 'access user profiles',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'administer actions',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'administer blocks',
  'module' => 'block',
])
->values([
  'rid' => '3',
  'permission' => 'administer comments',
  'module' => 'comment',
])
->values([
  'rid' => '3',
  'permission' => 'administer contact forms',
  'module' => 'contact',
])
->values([
  'rid' => '3',
  'permission' => 'administer content types',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'administer fields',
  'module' => 'field',
])
->values([
  'rid' => '3',
  'permission' => 'administer filters',
  'module' => 'filter',
])
->values([
  'rid' => '3',
  'permission' => 'administer image styles',
  'module' => 'image',
])
->values([
  'rid' => '3',
  'permission' => 'administer languages',
  'module' => 'locale',
])
->values([
  'rid' => '3',
  'permission' => 'administer menu',
  'module' => 'menu',
])
->values([
  'rid' => '3',
  'permission' => 'administer modules',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'administer nodes',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'administer permissions',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'administer search',
  'module' => 'search',
])
->values([
  'rid' => '3',
  'permission' => 'administer shortcuts',
  'module' => 'shortcut',
])
->values([
  'rid' => '3',
  'permission' => 'administer site configuration',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'administer software updates',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'administer taxonomy',
  'module' => 'taxonomy',
])
->values([
  'rid' => '3',
  'permission' => 'administer themes',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'administer url aliases',
  'module' => 'path',
])
->values([
  'rid' => '3',
  'permission' => 'administer users',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'administer views',
  'module' => 'views',
])
->values([
  'rid' => '3',
  'permission' => 'block IP addresses',
  'module' => 'system',
])
->values([
  'rid' => '3',
  'permission' => 'bypass node access',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'cancel account',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'change own username',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'create article content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'create page content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'create url aliases',
  'module' => 'path',
])
->values([
  'rid' => '3',
  'permission' => 'customize shortcut links',
  'module' => 'shortcut',
])
->values([
  'rid' => '3',
  'permission' => 'delete any article content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'delete any page content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'delete own article content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'delete own page content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'delete revisions',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'delete terms in 1',
  'module' => 'taxonomy',
])
->values([
  'rid' => '3',
  'permission' => 'edit any article content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'edit any page content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'edit own article content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'edit own comments',
  'module' => 'comment',
])
->values([
  'rid' => '3',
  'permission' => 'edit own page content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'edit terms in 1',
  'module' => 'taxonomy',
])
->values([
  'rid' => '3',
  'permission' => 'post comments',
  'module' => 'comment',
])
->values([
  'rid' => '3',
  'permission' => 'revert revisions',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'search content',
  'module' => 'search',
])
->values([
  'rid' => '3',
  'permission' => 'select account cancellation method',
  'module' => 'user',
])
->values([
  'rid' => '3',
  'permission' => 'skip comment approval',
  'module' => 'comment',
])
->values([
  'rid' => '3',
  'permission' => 'switch shortcut sets',
  'module' => 'shortcut',
])
->values([
  'rid' => '3',
  'permission' => 'translate admin strings',
  'module' => 'i18n_string',
])
->values([
  'rid' => '3',
  'permission' => 'translate blocks',
  'module' => 'i18n_block',
])
->values([
  'rid' => '3',
  'permission' => 'translate content',
  'module' => 'translation',
])
->values([
  'rid' => '3',
  'permission' => 'translate interface',
  'module' => 'locale',
])
->values([
  'rid' => '3',
  'permission' => 'translate user-defined strings',
  'module' => 'i18n_string',
])
->values([
  'rid' => '3',
  'permission' => 'use advanced search',
  'module' => 'search',
])
->values([
  'rid' => '3',
  'permission' => 'use text format custom_text_format',
  'module' => 'filter',
])
->values([
  'rid' => '3',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
])
->values([
  'rid' => '3',
  'permission' => 'use text format full_html',
  'module' => 'filter',
])
->values([
  'rid' => '3',
  'permission' => 'view own unpublished content',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'view revisions',
  'module' => 'node',
])
->values([
  'rid' => '3',
  'permission' => 'view the administration theme',
  'module' => 'system',
])
->execute();
$connection->schema()->createTable('search_dataset', [
  'fields' => [
    'sid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
    ],
    'data' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'reindex' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'sid',
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('search_index', [
  'fields' => [
    'word' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ],
    'sid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
    ],
    'score' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ],
  ],
  'primary key' => [
    'word',
    'sid',
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('search_node_links', [
  'fields' => [
    'sid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'caption' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'sid',
    'type',
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('search_total', [
  'fields' => [
    'word' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ],
    'count' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ],
  ],
  'primary key' => [
    'word',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('semaphore', [
  'fields' => [
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'value' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'expire' => [
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ],
  ],
  'primary key' => [
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('sequences', [
  'fields' => [
    'value' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'value',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('sequences')
->fields([
  'value',
])
->values([
  'value' => '9',
])
->execute();
$connection->schema()->createTable('sessions', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'sid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
    ],
    'ssid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'session' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'sid',
    'ssid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('shortcut_set', [
  'fields' => [
    'set_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'set_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('shortcut_set')
->fields([
  'set_name',
  'title',
])
->values([
  'set_name' => 'shortcut-set-1',
  'title' => 'Default',
])
->values([
  'set_name' => 'shortcut-set-2',
  'title' => 'Alternative shortcut set',
])
->execute();
$connection->schema()->createTable('shortcut_set_users', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'set_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
  ],
  'primary key' => [
    'uid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('shortcut_set_users')
->fields([
  'uid',
  'set_name',
])
->values([
  'uid' => '2',
  'set_name' => 'shortcut-set-2',
])
->execute();
$connection->schema()->createTable('system', [
  'fields' => [
    'filename' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'owner' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'bootstrap' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'schema_version' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'info' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'filename',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('system')
->fields([
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
])
->values([
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '-5',
  'info' => 'a:11:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:20:"field.info.class.inc";i:3;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '1',
  'info' => 'a:12:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7005',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7016',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"7.92";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:9:"configure";s:32:"admin/config/development/logging";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7084',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7011',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:5:"mtime";i:1664863480;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:4:"7.92";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7020',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:5:"mtime";i:1664863480;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'profiles/standard/standard.profile',
  'name' => 'standard',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:13:{s:4:"name";s:8:"Standard";s:11:"description";s:51:"Install with commonly used features pre-configured.";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:12:"dependencies";a:21:{i:0;s:5:"block";i:1;s:5:"color";i:2;s:7:"comment";i:3;s:10:"contextual";i:4;s:9:"dashboard";i:5;s:4:"help";i:6;s:5:"image";i:7;s:4:"list";i:8;s:4:"menu";i:9;s:6:"number";i:10;s:7:"options";i:11;s:4:"path";i:12;s:8:"taxonomy";i:13;s:5:"dblog";i:14;s:6:"search";i:15;s:8:"shortcut";i:16;s:7:"toolbar";i:17;s:7:"overlay";i:18;s:8:"field_ui";i:19;s:4:"file";i:20;s:3:"rdf";}s:5:"mtime";i:1664863480;s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;s:6:"hidden";b:1;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
])
->values([
  'filename' => 'sites/all/modules/ctools/bulk_export/bulk_export.module',
  'name' => 'bulk_export',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Bulk Export";s:11:"description";s:67:"Performs bulk exporting of data objects known about by Chaos tools.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:13:"ctools:ctools";}s:7:"package";s:16:"Chaos tool suite";s:5:"mtime";i:1688027058;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/ctools/ctools.module',
  'name' => 'ctools',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Chaos tools";s:11:"description";s:46:"A library of helpful tools by Merlin of Chaos.";s:4:"core";s:3:"7.x";s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:14:{i:0;s:20:"includes/context.inc";i:1;s:22:"includes/css-cache.inc";i:2;s:22:"includes/math-expr.inc";i:3;s:21:"includes/stylizer.inc";i:4;s:18:"tests/context.test";i:5;s:14:"tests/css.test";i:6;s:20:"tests/css_cache.test";i:7;s:25:"tests/ctools.plugins.test";i:8;s:17:"tests/ctools.test";i:9;s:26:"tests/math_expression.test";i:10;s:32:"tests/math_expression_stack.test";i:11;s:23:"tests/object_cache.test";i:12;s:28:"tests/object_cache_unit.test";i:13;s:22:"tests/page_tokens.test";}s:5:"mtime";i:1688027058;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/ctools/page_manager/page_manager.module',
  'name' => 'page_manager',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Page manager";s:11:"description";s:54:"Provides a UI and API to manage pages within the site.";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:13:"ctools:ctools";}s:7:"package";s:16:"Chaos tool suite";s:5:"files";a:1:{i:0;s:21:"tests/head_links.test";}s:5:"mtime";i:1688027058;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/date/date.module',
  'name' => 'date',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7200',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:4:"Date";s:11:"description";s:33:"Makes date/time fields available.";s:12:"dependencies";a:1:{i:0;s:13:"date:date_api";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:5:"files";a:10:{i:0;s:16:"date.migrate.inc";i:1;s:26:"tests/DateEmwTestCase.test";i:2;s:27:"tests/DateFormTestCase.test";i:3;s:30:"tests/DateMigrateTestCase.test";i:4;s:30:"tests/DateNowUnitTestCase.test";i:5;s:28:"tests/DateFieldTestBase.test";i:6;s:28:"tests/DateFieldTestCase.test";i:7;s:31:"tests/DateTimezoneTestCase.test";i:8;s:25:"tests/DateUiTestCase.test";i:9;s:33:"tests/DateValidationTestCase.test";}s:17:"test_dependencies";a:4:{i:0;s:13:"entity:entity";i:1;s:23:"features:features (2.x)";i:2;s:15:"migrate:migrate";i:3;s:11:"views:views";}s:5:"mtime";i:1688026736;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_all_day/date_all_day.module',
  'name' => 'date_all_day',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:10:{s:4:\"name\";s:12:\"Date All Day\";s:11:\"description\";s:142:\"Adds 'All Day' functionality to date fields, including an 'All Day' theme and 'All Day' checkboxes for the Date select and Date popup widgets.\";s:7:\"package\";s:9:\"Date/Time\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:2:{i:0;s:13:\"date:date_api\";i:1;s:9:\"date:date\";}s:5:\"files\";a:2:{i:0;s:31:\"tests/DateAllDayUiTestCase.test\";i:1;s:32:\"tests/DateAllDayUpdatesTest.test\";}s:5:\"mtime\";i:1688026736;s:7:\"version\";N;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}",
])
->values([
  'filename' => 'sites/all/modules/date/date_api/date_api.module',
  'name' => 'date_api',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Date API";s:11:"description";s:45:"A Date API that can be used by other modules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:15:"date_api.module";i:1;s:16:"date_api_sql.inc";i:2;s:26:"tests/DateApiTestCase.test";i:3;s:30:"tests/DateApiUnitTestCase.test";}s:5:"mtime";i:1688026736;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/entity/entity.module',
  'name' => 'entity',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Entity API";s:11:"description";s:69:"Enables modules to work with any entity type and to provide entities.";s:4:"core";s:3:"7.x";s:5:"files";a:24:{i:0;s:19:"entity.features.inc";i:1;s:15:"entity.i18n.inc";i:2;s:15:"entity.info.inc";i:3;s:16:"entity.rules.inc";i:4;s:11:"entity.test";i:5;s:19:"includes/entity.inc";i:6;s:30:"includes/entity.controller.inc";i:7;s:22:"includes/entity.ui.inc";i:8;s:27:"includes/entity.wrapper.inc";i:9;s:22:"views/entity.views.inc";i:10;s:52:"views/handlers/entity_views_field_handler_helper.inc";i:11;s:51:"views/handlers/entity_views_handler_area_entity.inc";i:12;s:53:"views/handlers/entity_views_handler_field_boolean.inc";i:13;s:50:"views/handlers/entity_views_handler_field_date.inc";i:14;s:54:"views/handlers/entity_views_handler_field_duration.inc";i:15;s:52:"views/handlers/entity_views_handler_field_entity.inc";i:16;s:51:"views/handlers/entity_views_handler_field_field.inc";i:17;s:53:"views/handlers/entity_views_handler_field_numeric.inc";i:18;s:53:"views/handlers/entity_views_handler_field_options.inc";i:19;s:50:"views/handlers/entity_views_handler_field_text.inc";i:20;s:49:"views/handlers/entity_views_handler_field_uri.inc";i:21;s:62:"views/handlers/entity_views_handler_relationship_by_bundle.inc";i:22;s:52:"views/handlers/entity_views_handler_relationship.inc";i:23;s:53:"views/plugins/entity_views_plugin_row_entity_view.inc";}s:5:"mtime";i:1664868240;s:12:"dependencies";a:0:{}s:7:"package";s:5:"Other";s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/entityreference/entityreference.module',
  'name' => 'entityreference',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:16:"Entity Reference";s:11:"description";s:51:"Provides a field that can reference other entities.";s:7:"package";s:6:"Fields";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:6:"entity";i:1;s:6:"ctools";}s:17:"test_dependencies";a:2:{i:0;s:5:"feeds";i:1;s:5:"views";}s:5:"files";a:12:{i:0;s:27:"entityreference.migrate.inc";i:1;s:30:"plugins/selection/abstract.inc";i:2;s:27:"plugins/selection/views.inc";i:3;s:29:"plugins/behavior/abstract.inc";i:4;s:40:"views/entityreference_plugin_display.inc";i:5;s:38:"views/entityreference_plugin_style.inc";i:6;s:43:"views/entityreference_plugin_row_fields.inc";i:7;s:35:"tests/entityreference.handlers.test";i:8;s:35:"tests/entityreference.taxonomy.test";i:9;s:32:"tests/entityreference.admin.test";i:10;s:32:"tests/entityreference.feeds.test";i:11;s:45:"tests/entityreference.entity_translation.test";}s:5:"mtime";i:1664944690;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/entity_translation/entity_translation.module',
  'name' => 'entity_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '11',
  'info' => 'a:12:{s:4:"name";s:18:"Entity Translation";s:11:"description";s:58:"Allows entities to be translated into different languages.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:9:"configure";s:40:"admin/config/regional/entity_translation";s:12:"dependencies";a:1:{i:0;s:14:"locale (>7.14)";}s:17:"test_dependencies";a:2:{i:0;s:17:"pathauto:pathauto";i:1;s:11:"title:title";}s:5:"files";a:15:{i:0;s:40:"includes/translation.handler_factory.inc";i:1;s:32:"includes/translation.handler.inc";i:2;s:40:"includes/translation.handler.comment.inc";i:3;s:37:"includes/translation.handler.node.inc";i:4;s:46:"includes/translation.handler.taxonomy_term.inc";i:5;s:37:"includes/translation.handler.user.inc";i:6;s:32:"includes/translation.migrate.inc";i:7;s:29:"tests/entity_translation.test";i:8;s:49:"views/entity_translation_handler_relationship.inc";i:9;s:57:"views/entity_translation_handler_field_translate_link.inc";i:10;s:48:"views/entity_translation_handler_field_label.inc";i:11;s:55:"views/entity_translation_handler_filter_entity_type.inc";i:12;s:52:"views/entity_translation_handler_filter_language.inc";i:13;s:62:"views/entity_translation_handler_filter_translation_exists.inc";i:14;s:48:"views/entity_translation_handler_field_field.inc";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/entity_translation/entity_translation_i18n_menu/entity_translation_i18n_menu.module',
  'name' => 'entity_translation_i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:23:"Entity Translation Menu";s:11:"description";s:54:"Allows menu items to be translated on the entity form.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:3:{i:0;s:18:"entity_translation";i:1;s:4:"i18n";i:2;s:9:"i18n_menu";}s:5:"files";a:1:{i:0;s:33:"entity_translation_i18n_menu.test";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/entity_translation/entity_translation_upgrade/entity_translation_upgrade.module',
  'name' => 'entity_translation_upgrade',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:26:"Entity Translation Upgrade";s:11:"description";s:80:"Provides an upgrade path from node-based translation to field-based translation.";s:7:"package";s:33:"Multilingual - Entity Translation";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:18:"entity_translation";}s:5:"files";a:1:{i:0;s:31:"entity_translation_upgrade.test";}s:5:"mtime";i:1664867622;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n.module',
  'name' => 'i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7001',
  'weight' => '10',
  'info' => 'a:11:{s:4:"name";s:20:"Internationalization";s:11:"description";s:49:"Extends Drupal support for multilingual features.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:8:"variable";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:15:"i18n_object.inc";i:1;s:9:"i18n.test";}s:9:"configure";s:26:"admin/config/regional/i18n";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_block/i18n_block.module',
  'name' => 'i18n_block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '100',
  'info' => 'a:10:{s:4:"name";s:15:"Block languages";s:11:"description";s:68:"Enables language selector for blocks and optional block translation.";s:12:"dependencies";a:2:{i:0;s:5:"block";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_block.inc";i:1;s:15:"i18n_block.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_contact/i18n_contact.module',
  'name' => 'i18n_contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Contact translation";s:11:"description";s:63:"Makes contact categories and replies available for translation.";s:12:"dependencies";a:2:{i:0;s:7:"contact";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_field/i18n_field.module',
  'name' => 'i18n_field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Field translation";s:11:"description";s:26:"Translate field properties";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:14:"i18n_field.inc";i:1;s:15:"i18n_field.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_forum/i18n_forum.module',
  'name' => 'i18n_forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:18:"Multilingual forum";s:11:"description";s:60:"Enables multilingual forum, translates names and containers.";s:12:"dependencies";a:3:{i:0;s:5:"forum";i:1;s:13:"i18n_taxonomy";i:2;s:9:"i18n_node";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"i18n_forum.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_menu/i18n_menu.module',
  'name' => 'i18n_menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '5',
  'info' => 'a:10:{s:4:"name";s:16:"Menu translation";s:11:"description";s:40:"Supports translatable custom menu items.";s:12:"dependencies";a:4:{i:0;s:4:"i18n";i:1;s:4:"menu";i:2;s:11:"i18n_string";i:3;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_menu.inc";i:1;s:14:"i18n_menu.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_node/i18n_node.module',
  'name' => 'i18n_node',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:20:"Multilingual content";s:11:"description";s:46:"Extended node options for multilingual content";s:12:"dependencies";a:3:{i:0;s:11:"translation";i:1;s:4:"i18n";i:2;s:11:"i18n_string";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:31:"admin/config/regional/i18n/node";s:5:"files";a:2:{i:0;s:14:"i18n_node.test";i:1;s:22:"i18n_node.variable.inc";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_path/i18n_path.module',
  'name' => 'i18n_path',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Path translation";s:11:"description";s:37:"Define translations for generic paths";s:12:"dependencies";a:1:{i:0;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:13:"i18n_path.inc";i:1;s:14:"i18n_path.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_redirect/i18n_redirect.module',
  'name' => 'i18n_redirect',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"Translation redirect";s:11:"description";s:71:"Redirect to translated page when available. SEO for multilingual sites.";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_select/i18n_select.module',
  'name' => 'i18n_select',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:19:"Multilingual select";s:11:"description";s:45:"API module for multilingual content selection";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:33:"admin/config/regional/i18n/select";s:5:"files";a:1:{i:0;s:16:"i18n_select.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_string/i18n_string.module',
  'name' => 'i18n_string',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '10',
  'info' => 'a:11:{s:4:"name";s:18:"String translation";s:11:"description";s:57:"Provides support for translation of user defined strings.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:21:"i18n_string.admin.inc";i:1;s:15:"i18n_string.inc";i:2;s:16:"i18n_string.test";}s:9:"configure";s:34:"admin/config/regional/i18n/strings";s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_sync/i18n_sync.module',
  'name' => 'i18n_sync',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '100',
  'info' => 'a:10:{s:4:"name";s:24:"Synchronize translations";s:11:"description";s:73:"Synchronizes taxonomy and fields across translations of the same content.";s:12:"dependencies";a:2:{i:0;s:4:"i18n";i:1;s:11:"translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:5:{i:0;s:16:"i18n_sync.module";i:1;s:17:"i18n_sync.install";i:2;s:20:"i18n_sync.module.inc";i:3;s:18:"i18n_sync.node.inc";i:4;s:14:"i18n_sync.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_taxonomy/i18n_taxonomy.module',
  'name' => 'i18n_taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '5',
  'info' => 'a:10:{s:4:"name";s:20:"Taxonomy translation";s:11:"description";s:30:"Enables multilingual taxonomy.";s:12:"dependencies";a:3:{i:0;s:8:"taxonomy";i:1;s:11:"i18n_string";i:2;s:16:"i18n_translation";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:4:{i:0;s:17:"i18n_taxonomy.inc";i:1;s:23:"i18n_taxonomy.pages.inc";i:2;s:23:"i18n_taxonomy.admin.inc";i:3;s:18:"i18n_taxonomy.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_translation/i18n_translation.module',
  'name' => 'i18n_translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Translation sets";s:11:"description";s:47:"Simple translation sets API for generic objects";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:20:"i18n_translation.inc";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_user/i18n_user.module',
  'name' => 'i18n_user',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:21:"User mail translation";s:11:"description";s:43:"Translate emails sent from the User module.";s:4:"core";s:3:"7.x";s:7:"package";s:35:"Multilingual - Internationalization";s:12:"dependencies";a:1:{i:0;s:13:"i18n_variable";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n_variable/i18n_variable.module',
  'name' => 'i18n_variable',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7004',
  'weight' => '-900',
  'info' => 'a:11:{s:4:"name";s:20:"Variable translation";s:11:"description";s:71:"Multilingual variables that switch language depending on page language.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:24:"variable_store (7.x-2.x)";i:2;s:24:"variable_realm (7.x-2.x)";}s:7:"package";s:35:"Multilingual - Internationalization";s:4:"core";s:3:"7.x";s:9:"configure";s:35:"admin/config/regional/i18n/variable";s:5:"files";a:2:{i:0;s:23:"i18n_variable.class.inc";i:1;s:18:"i18n_variable.test";}s:5:"mtime";i:1664867462;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/link/link.module',
  'name' => 'link',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7100',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:4:"Link";s:11:"description";s:32:"Defines simple link field types.";s:4:"core";s:3:"7.x";s:7:"package";s:6:"Fields";s:9:"configure";s:25:"admin/config/content/link";s:5:"files";a:15:{i:0;s:16:"link.migrate.inc";i:1;s:44:"views/link_views_handler_argument_target.inc";i:2;s:44:"views/link_views_handler_filter_protocol.inc";i:3;s:28:"tests/LinkBaseTestClass.test";i:4;s:39:"tests/LinkConvertInternalPathsTest.test";i:5;s:34:"tests/LinkDefaultProtocolTest.test";i:6;s:30:"tests/LinkEntityTokenTest.test";i:7;s:34:"tests/LinkFieldAttributesTest.test";i:8;s:28:"tests/LinkFieldCrudTest.test";i:9;s:32:"tests/LinkFieldValidateTest.test";i:10;s:31:"tests/LinkPathPrefixesTest.test";i:11;s:27:"tests/LinkSanitizeTest.test";i:12;s:24:"tests/LinkTokenTest.test";i:13;s:32:"tests/LinkValidationApiTest.test";i:14;s:27:"tests/LinkUnitTestCase.test";}s:17:"test_dependencies";a:2:{i:0;s:13:"entity:entity";i:1;s:11:"token:token";}s:5:"mtime";i:1688026809;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:73:"Field type(s) in use - see <a href="/admin/reports/fields">Field list</a>";}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable.module',
  'name' => 'variable',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Variable";s:11:"description";s:43:"Variable Information and basic variable API";s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:9:{i:0;s:27:"includes/forum.variable.inc";i:1;s:28:"includes/locale.variable.inc";i:2;s:26:"includes/menu.variable.inc";i:3;s:26:"includes/node.variable.inc";i:4;s:28:"includes/system.variable.inc";i:5;s:30:"includes/taxonomy.variable.inc";i:6;s:33:"includes/translation.variable.inc";i:7;s:26:"includes/user.variable.inc";i:8;s:13:"variable.test";}s:5:"mtime";i:1664867493;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable_admin/variable_admin.module',
  'name' => 'variable_admin',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Variable admin";s:11:"description";s:26:"Variable Administration UI";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"mtime";i:1664867493;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable_realm/variable_realm.module',
  'name' => 'variable_realm',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7000',
  'weight' => '-1000',
  'info' => 'a:10:{s:4:"name";s:14:"Variable realm";s:11:"description";s:49:"API to use variable realms from different modules";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.x";s:5:"files";a:2:{i:0;s:24:"variable_realm.class.inc";i:1;s:30:"variable_realm_union.class.inc";}s:5:"mtime";i:1664867493;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable_store/variable_store.module',
  'name' => 'variable_store',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7000',
  'weight' => '-1000',
  'info' => 'a:10:{s:4:"name";s:14:"Variable store";s:11:"description";s:60:"Database storage for variable realms. This is an API module.";s:12:"dependencies";a:1:{i:0;s:8:"variable";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:7:"version";s:7:"7.x-2.x";s:5:"files";a:2:{i:0;s:24:"variable_store.class.inc";i:1;s:19:"variable_store.test";}s:5:"mtime";i:1664867493;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable_views/variable_views.module',
  'name' => 'variable_views',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Variable views";s:11:"description";s:78:"Provides views integration for variable, included a default variable argument.";s:12:"dependencies";a:2:{i:0;s:8:"variable";i:1;s:5:"views";}s:7:"package";s:8:"Variable";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:51:"includes/views_plugin_argument_default_variable.inc";i:1;s:47:"includes/views_handler_field_variable_title.inc";i:2;s:47:"includes/views_handler_field_variable_value.inc";}s:5:"mtime";i:1664867493;s:7:"version";N;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
])
->values([
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:17:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
])
->values([
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:9:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
])
->values([
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:4:"7.92";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:5:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:5:"mtime";i:1664863480;s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
])
->values([
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.92\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:9:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1664863480;s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}",
])
->execute();
$connection->schema()->createTable('taxonomy_index', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'sticky' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'tiny',
      'default' => '0',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'indexes' => [
    'term_node' => [
      'tid',
      'sticky',
      'created',
    ],
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('taxonomy_term_data', [
  'fields' => [
    'tid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ],
    'i18n_tsid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'tid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('taxonomy_term_data')
->fields([
  'tid',
  'vid',
  'name',
  'description',
  'format',
  'weight',
  'language',
  'i18n_tsid',
])
->values([
  'tid' => '1',
  'vid' => '2',
  'name' => 'General discussion',
  'description' => '',
  'format' => NULL,
  'weight' => '2',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->values([
  'tid' => '5',
  'vid' => '2',
  'name' => 'Custom Forum',
  'description' => 'Where the cool kids are.',
  'format' => NULL,
  'weight' => '3',
  'language' => 'und',
  'i18n_tsid' => '0',
])
->execute();
$connection->schema()->createTable('taxonomy_term_hierarchy', [
  'fields' => [
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'parent' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'tid',
    'parent',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('taxonomy_term_hierarchy')
->fields([
  'tid',
  'parent',
])
->values([
  'tid' => '1',
  'parent' => '0',
])
->values([
  'tid' => '5',
  'parent' => '0',
])
->execute();
$connection->schema()->createTable('taxonomy_vocabulary', [
  'fields' => [
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'machine_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'hierarchy' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => 'und',
    ],
    'i18n_mode' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('taxonomy_vocabulary')
->fields([
  'vid',
  'name',
  'machine_name',
  'description',
  'hierarchy',
  'module',
  'weight',
  'language',
  'i18n_mode',
])
->values([
  'vid' => '1',
  'name' => 'Tags',
  'machine_name' => 'tags',
  'description' => 'Use tags to group articles on similar topics into categories.',
  'hierarchy' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
  'language' => 'und',
  'i18n_mode' => '0',
])
->values([
  'vid' => '2',
  'name' => 'Sujet de discussion',
  'machine_name' => 'sujet_de_discussion',
  'description' => 'Forum navigation vocabulary',
  'hierarchy' => '0',
  'module' => 'forum',
  'weight' => '-10',
  'language' => 'und',
  'i18n_mode' => '0',
])
->execute();
$connection->schema()->createTable('url_alias', [
  'fields' => [
    'pid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'source' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'alias' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'pid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('url_alias')
->fields([
  'pid',
  'source',
  'alias',
  'language',
])
->values([
  'pid' => '6',
  'source' => 'admin',
  'alias' => 'source-noslash',
  'language' => 'und',
])
->execute();
$connection->schema()->createTable('users', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ],
    'pass' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'mail' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ],
    'theme' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'signature' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'signature_format' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'access' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'login' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'timezone' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '32',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'picture' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'init' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '254',
      'default' => '',
    ],
    'data' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'uid',
  ],
  'indexes' => [
    'changed' => [
      'changed',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('users')
->fields([
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'changed',
])
->values([
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$D/HVkgCg1Hvi7DN5KVSgNl.2C5g8W6oe/OoIRMUlyjkmPugQRhoB',
  'mail' => 'admin@local.host',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '1760146174',
  'login' => '1760138063',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => 'a:1:{s:7:"contact";i:1;}',
  'changed' => '0',
])
->execute();
$connection->schema()->createTable('users_roles', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'uid',
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('users_roles')
->fields([
  'uid',
  'rid',
])
->values([
  'uid' => '1',
  'rid' => '3',
])
->execute();
$connection->schema()->createTable('variable', [
  'fields' => [
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'value' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('variable')
->fields([
  'name',
  'value',
])
->values([
  'name' => 'actions_max_stack',
  'value' => 'i:28;',
])
->values([
  'name' => 'additional_settings__active_tab_article',
  'value' => 's:15:"edit-submission";',
])
->values([
  'name' => 'additional_settings__active_tab_blog',
  'value' => 's:13:"edit-workflow";',
])
->values([
  'name' => 'additional_settings__active_tab_book',
  'value' => 's:13:"edit-workflow";',
])
->values([
  'name' => 'additional_settings__active_tab_forum',
  'value' => 's:15:"edit-submission";',
])
->values([
  'name' => 'additional_settings__active_tab_page',
  'value' => 's:15:"edit-submission";',
])
->values([
  'name' => 'additional_settings__active_tab_test_content_type',
  'value' => 's:13:"edit-workflow";',
])
->values([
  'name' => 'admin_compact_mode',
  'value' => 'b:1;',
])
->values([
  'name' => 'admin_theme',
  'value' => 's:5:"seven";',
])
->values([
  'name' => 'allow_insecure_derivatives',
  'value' => 'b:1;',
])
->values([
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
])
->values([
  'name' => 'anonymous',
  'value' => 's:9:"Anonymous";',
])
->values([
  'name' => 'authorize_filetransfer_default',
  'value' => 's:3:"ftp";',
])
->values([
  'name' => 'block_cache',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_class_cache_ctools_css',
  'value' => 's:14:"CToolsCssCache";',
])
->values([
  'name' => 'cache_flush_cache',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_block',
  'value' => 'i:1760146296;',
])
->values([
  'name' => 'cache_flush_cache_field',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_filter',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_form',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_image',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_menu',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_page',
  'value' => 'i:1760146296;',
])
->values([
  'name' => 'cache_flush_cache_path',
  'value' => 'i:0;',
])
->values([
  'name' => 'cache_flush_cache_variable',
  'value' => 'i:1760139599;',
])
->values([
  'name' => 'cache_lifetime',
  'value' => 's:3:"300";',
])
->values([
  'name' => 'clean_url',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'color_bartik_files',
  'value' => 'a:2:{i:0;s:39:"public://color/bartik-e0e23ad7/logo.png";i:1;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
])
->values([
  'name' => 'color_bartik_logo',
  'value' => 's:39:"public://color/bartik-e0e23ad7/logo.png";',
])
->values([
  'name' => 'color_bartik_palette',
  'value' => 'a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}',
])
->values([
  'name' => 'color_bartik_screenshot',
  'value' => 's:72:"/var/www/drupal/sites/default/files/color/bartik-b69cfcec/screenshot.png";',
])
->values([
  'name' => 'color_bartik_stylesheets',
  'value' => 'a:1:{i:0;s:41:"public://color/bartik-e0e23ad7/colors.css";}',
])
->values([
  'name' => 'color_garland_files',
  'value' => 'a:19:{i:0;s:50:"public://color/garland-b69cfcec/menu-collapsed.gif";i:1;s:54:"public://color/garland-b69cfcec/menu-collapsed-rtl.gif";i:2;s:49:"public://color/garland-b69cfcec/menu-expanded.gif";i:3;s:45:"public://color/garland-b69cfcec/menu-leaf.gif";i:4;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/body.png";i:5;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar.png";i:6;s:75:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-bar-white.png";i:7;s:69:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-tab.png";i:8;s:76:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation.png";i:9;s:78:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-left.png";i:10;s:79:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content-right.png";i:11;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-content.png";i:12;s:81:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item.png";i:13;s:87:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/bg-navigation-item-hover.png";i:14;s:77:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/gradient-inner.png";i:15;s:67:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/logo.png";i:16;s:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";i:17;s:41:"public://color/garland-b69cfcec/style.css";i:18;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
])
->values([
  'name' => 'color_garland_logo',
  'value' => 's:40:"public://color/garland-b69cfcec/logo.png";',
])
->values([
  'name' => 'color_garland_palette',
  'value' => 'a:5:{s:4:"base";s:7:"#d0cb9a";s:4:"link";s:7:"#917803";s:3:"top";s:7:"#efde01";s:6:"bottom";s:7:"#e6fb2d";s:4:"text";s:7:"#494949";}',
])
->values([
  'name' => 'color_garland_screenshot',
  'value' => 's:73:"/var/www/drupal/sites/default/files/color/garland-b69cfcec/screenshot.png";',
])
->values([
  'name' => 'color_garland_stylesheets',
  'value' => 'a:2:{i:0;s:41:"public://color/garland-b69cfcec/style.css";i:1;s:45:"public://color/garland-b69cfcec/style-rtl.css";}',
])
->values([
  'name' => 'comment_anonymous_article',
  'value' => 'i:0;',
])
->values([
  'name' => 'comment_anonymous_blog',
  'value' => 'i:0;',
])
->values([
  'name' => 'comment_anonymous_forum',
  'value' => 'i:0;',
])
->values([
  'name' => 'comment_anonymous_page',
  'value' => 'i:0;',
])
->values([
  'name' => 'comment_article',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'comment_blog',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'comment_default_mode_article',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_default_mode_blog',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_default_mode_forum',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_default_mode_page',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_default_per_page_article',
  'value' => 's:2:"50";',
])
->values([
  'name' => 'comment_default_per_page_blog',
  'value' => 's:2:"50";',
])
->values([
  'name' => 'comment_default_per_page_forum',
  'value' => 's:2:"50";',
])
->values([
  'name' => 'comment_default_per_page_page',
  'value' => 's:2:"50";',
])
->values([
  'name' => 'comment_form_location_article',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_form_location_blog',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_form_location_forum',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_form_location_page',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_forum',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'comment_page',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'comment_preview_article',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'comment_preview_blog',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'comment_preview_forum',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'comment_preview_page',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'comment_subject_field_article',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_subject_field_blog',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_subject_field_forum',
  'value' => 'i:1;',
])
->values([
  'name' => 'comment_subject_field_page',
  'value' => 'i:1;',
])
->values([
  'name' => 'configurable_timezones',
  'value' => 'b:1;',
])
->values([
  'name' => 'contact_default_status',
  'value' => 'i:1;',
])
->values([
  'name' => 'contact_threshold_limit',
  'value' => 'i:33;',
])
->values([
  'name' => 'contact_threshold_window',
  'value' => 'i:7200;',
])
->values([
  'name' => 'cron_key',
  'value' => 's:43:"_vWFj-dRR2rNoHDwl7N__J9uZNutDcLz3w4tlPJzRAM";',
])
->values([
  'name' => 'cron_last',
  'value' => 'i:1760139599;',
])
->values([
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
])
->values([
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
])
->values([
  'name' => 'css_js_query_string',
  'value' => 's:6:"t3y1ko";',
])
->values([
  'name' => 'ctools_last_cron',
  'value' => 'i:1760138052;',
])
->values([
  'name' => 'date_api_version',
  'value' => 's:3:"7.2";',
])
->values([
  'name' => 'date_default_timezone',
  'value' => 's:15:"America/Chicago";',
])
->values([
  'name' => 'date_first_day',
  'value' => 'i:1;',
])
->values([
  'name' => 'default_nodes_main',
  'value' => 's:2:"10";',
])
->values([
  'name' => 'drupal_css_cache_files',
  'value' => 'a:6:{s:64:"823ba1006db72809515d2221cd02ec1075d7b49b0c07f49307b3a7930bfdd9e4";s:64:"public://css/css_xE-rWrJf-fncB6ztZfd2huxqgxu4WO-qwma6Xer30m4.css";s:64:"592db66916e1dd3416cbe95bcb34a5a68775eb0b7cf95e4c858671de35290cc9";s:64:"public://css/css_LS9OUalDR9-d_lCAvF3yUWjNU6yF8ZBm84jEPRvoyuQ.css";s:64:"8d430bccf24c5d546e444dcd23fc6c61a49de1ed9c1e404d82c78c0f9ac0f1bc";s:64:"public://css/css_Vn_p7xhZmS8yWWx26P0Cc7Tm0GG2K1gLWEoVrhw5xxg.css";s:64:"8366be3a82d83db4ec0cd63fdb2977a1145c38937190ceb866dd8b9322c159a6";s:64:"public://css/css_VpCxfFWfdXFeJdjFc2-c4wa-VjLtlWIkkJd0sr5RF4Q.css";s:64:"f3f74dcad951a1a986b64eeabc10d3141b1f70cd67b02447398b004b5706789c";s:64:"public://css/css_Hex-pwCTDDfQD41aRswi2OFNCxosYgUEBnZsKNQ5BWo.css";s:64:"ebb3f433ad4107b1ac31e9d7de0f9a5d399040e9f82b6364211dcfaadea158c0";s:64:"public://css/css_Nv0ct-zkzztuah_LbaPFF8ZkdSEk-LxBtTWMm9mN_F8.css";}',
])
->values([
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
])
->values([
  'name' => 'drupal_private_key',
  'value' => 's:43:"9eRJWxrMwQ5CufYJjXBZbPGz_t8vPIYRQr18PamdKmM";',
])
->values([
  'name' => 'drupal_weight_select_max',
  'value' => 'i:40;',
])
->values([
  'name' => 'email__active_tab',
  'value' => 's:27:"edit-email-pending-approval";',
])
->values([
  'name' => 'empty_timezone_message',
  'value' => 'b:1;',
])
->values([
  'name' => 'entity_cache_tables_created',
  'value' => 'N;',
])
->values([
  'name' => 'entity_translation_entity_types',
  'value' => 'a:4:{s:7:"comment";s:7:"comment";s:4:"node";s:4:"node";s:13:"taxonomy_term";s:13:"taxonomy_term";s:4:"user";s:4:"user";}',
])
->values([
  'name' => 'entity_translation_settings_comment__comment_node_test_content_type',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-current";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
])
->values([
  'name' => 'entity_translation_settings_node__test_content_type',
  'value' => 'a:5:{s:16:"default_language";s:3:"und";s:22:"hide_language_selector";i:0;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
])
->values([
  'name' => 'entity_translation_settings_taxonomy_term__test_vocabulary',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-default";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
])
->values([
  'name' => 'entity_translation_settings_user__user',
  'value' => 'a:5:{s:16:"default_language";s:13:"xx-et-default";s:22:"hide_language_selector";i:1;s:21:"exclude_language_none";i:0;s:13:"lock_language";i:0;s:27:"shared_fields_original_only";i:0;}',
])
->values([
  'name' => 'entity_translation_taxonomy',
  'value' => 'a:6:{s:15:"test_vocabulary";b:1;s:14:"vocablocalized";b:0;s:14:"vocabtranslate";b:0;s:10:"vocabfixed";b:0;s:15:"vocablocalized2";b:0;s:54:"vocabulary_name_much_longer_than_thirty_two_characters";b:0;}',
])
->values([
  'name' => 'error_level',
  'value' => 'i:1;',
])
->values([
  'name' => 'feed_default_items',
  'value' => 'i:27;',
])
->values([
  'name' => 'feed_item_length',
  'value' => 's:8:"fulltext";',
])
->values([
  'name' => 'field_bundle_settings_node__article',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
])
->values([
  'name' => 'field_bundle_settings_node__blog',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:1:{s:5:"title";a:1:{s:6:"weight";s:2:"-5";}}s:7:"display";a:0:{}}}',
])
->values([
  'name' => 'field_bundle_settings_user__user',
  'value' => 'a:2:{s:10:"view_modes";a:0:{}s:12:"extra_fields";a:2:{s:4:"form";a:2:{s:7:"account";a:1:{s:6:"weight";s:3:"-10";}s:8:"timezone";a:1:{s:6:"weight";s:1:"6";}}s:7:"display";a:0:{}}}',
])
->values([
  'name' => 'file_default_scheme',
  'value' => 's:6:"public";',
])
->values([
  'name' => 'file_description_length',
  'value' => 'i:256;',
])
->values([
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
])
->values([
  'name' => 'file_directory_path',
  'value' => 's:19:"sites/default/files";',
])
->values([
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
])
->values([
  'name' => 'file_private_path',
  'value' => 's:21:"sites/default/private";',
])
->values([
  'name' => 'file_public_path',
  'value' => 's:19:"sites/default/files";',
])
->values([
  'name' => 'file_temporary_path',
  'value' => 's:4:"/tmp";',
])
->values([
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
])
->values([
  'name' => 'forum_nav_vocabulary',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'i18n_node_options_blog',
  'value' => 'a:2:{i:0;s:8:"required";i:1;s:4:"lock";}',
])
->values([
  'name' => 'i18n_string_allowed_formats',
  'value' => 'a:5:{s:13:"filtered_html";s:13:"filtered_html";s:10:"plain_text";s:10:"plain_text";s:18:"custom_text_format";i:0;s:9:"full_html";i:0;s:8:"php_code";i:0;}',
])
->values([
  'name' => 'i18n_string_source_language',
  'value' => 's:2:"en";',
])
->values([
  'name' => 'i18n_string_textgroup_class_blocks',
  'value' => 's:29:"i18n_string_textgroup_default";',
])
->values([
  'name' => 'i18n_string_textgroup_class_taxonomy',
  'value' => 's:29:"i18n_string_textgroup_default";',
])
->values([
  'name' => 'i18n_sync_node_type_article',
  'value' => 'a:1:{i:0;s:16:"field_text_plain";}',
])
->values([
  'name' => 'i18n_sync_source_article',
  'value' => 'i:0;',
])
->values([
  'name' => 'image_jpeg_quality',
  'value' => 'i:80;',
])
->values([
  'name' => 'image_style_preview_image',
  'value' => 's:23:"core/misc/druplicon.png";',
])
->values([
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
])
->values([
  'name' => 'install_profile',
  'value' => 's:8:"standard";',
])
->values([
  'name' => 'install_task',
  'value' => 's:4:"done";',
])
->values([
  'name' => 'install_time',
  'value' => 'i:1421694923;',
])
->values([
  'name' => 'javascript_parsed',
  'value' => 'a:12:{i:0;s:14:"misc/drupal.js";i:1;s:14:"misc/jquery.js";i:2;s:27:"misc/jquery-extend-3.4.0.js";i:3;s:44:"misc/jquery-html-prefilter-3.5.0-backport.js";i:4;s:19:"misc/jquery.once.js";i:5;s:19:"misc/tableheader.js";i:6;s:12:"misc/form.js";i:7;s:16:"misc/collapse.js";i:8;s:21:"misc/jquery.cookie.js";i:9;s:26:"modules/toolbar/toolbar.js";s:10:"refresh:fr";s:7:"waiting";s:10:"refresh:is";s:7:"waiting";}',
])
->values([
  'name' => 'language_content_type_article',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'language_content_type_a_thirty_two_character_type_name',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'language_content_type_blog',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'language_content_type_et',
  'value' => 's:1:"4";',
])
->values([
  'name' => 'language_content_type_forum',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'language_content_type_page',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'language_content_type_test_content_type',
  'value' => 's:1:"4";',
])
->values([
  'name' => 'language_count',
  'value' => 'i:3;',
])
->values([
  'name' => 'language_default',
  'value' => 'O:8:"stdClass":11:{s:8:"language";s:2:"en";s:4:"name";s:7:"English";s:6:"native";s:7:"English";s:9:"direction";s:1:"0";s:7:"enabled";i:1;s:7:"plurals";s:1:"0";s:7:"formula";s:0:"";s:6:"domain";s:0:"";s:6:"prefix";s:0:"";s:6:"weight";s:1:"0";s:10:"javascript";s:0:"";}',
])
->values([
  'name' => 'language_negotiation_language',
  'value' => 'a:3:{s:11:"locale-user";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:25:"locale_language_from_user";}s:4:"file";s:19:"includes/locale.inc";}s:10:"locale-url";a:2:{s:9:"callbacks";a:3:{s:8:"language";s:24:"locale_language_from_url";s:8:"switcher";s:28:"locale_language_switcher_url";s:11:"url_rewrite";s:31:"locale_language_url_rewrite_url";}s:4:"file";s:19:"includes/locale.inc";}s:16:"language-default";a:1:{s:9:"callbacks";a:1:{s:8:"language";s:21:"language_from_default";}}}',
])
->values([
  'name' => 'language_negotiation_language_content',
  'value' => 'a:1:{s:16:"locale-interface";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:30:"locale_language_from_interface";}s:4:"file";s:19:"includes/locale.inc";}}',
])
->values([
  'name' => 'language_negotiation_language_url',
  'value' => 'a:2:{s:10:"locale-url";a:2:{s:9:"callbacks";a:3:{s:8:"language";s:24:"locale_language_from_url";s:8:"switcher";s:28:"locale_language_switcher_url";s:11:"url_rewrite";s:31:"locale_language_url_rewrite_url";}s:4:"file";s:19:"includes/locale.inc";}s:19:"locale-url-fallback";a:2:{s:9:"callbacks";a:1:{s:8:"language";s:28:"locale_language_url_fallback";}s:4:"file";s:19:"includes/locale.inc";}}',
])
->values([
  'name' => 'language_types',
  'value' => 'a:3:{s:8:"language";b:1;s:16:"language_content";b:1;s:12:"language_url";b:0;}',
])
->values([
  'name' => 'locale_language_negotiation_session_param',
  'value' => 's:8:"language";',
])
->values([
  'name' => 'locale_language_negotiation_url_part',
  'value' => 'i:0;',
])
->values([
  'name' => 'locale_language_providers_weight_language',
  'value' => 'a:5:{s:10:"locale-url";s:2:"-9";s:14:"locale-session";s:2:"-8";s:11:"locale-user";s:3:"-10";s:14:"locale-browser";s:2:"-7";s:16:"language-default";s:2:"-6";}',
])
->values([
  'name' => 'mail_system',
  'value' => 'a:1:{s:14:"default-system";s:17:"DefaultMailSystem";}',
])
->values([
  'name' => 'maintenance_mode',
  'value' => 'b:0;',
])
->values([
  'name' => 'maintenance_mode_message',
  'value' => 's:42:"This is a custom maintenance mode message.";',
])
->values([
  'name' => 'menu_default_active_menus',
  'value' => 'a:4:{i:1;s:9:"main-menu";i:2;s:10:"management";i:3;s:10:"navigation";i:5;s:9:"user-menu";}',
])
->values([
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
])
->values([
  'name' => 'menu_masks',
  'value' => 'a:44:{i:0;i:501;i:1;i:493;i:2;i:490;i:3;i:250;i:4;i:247;i:5;i:246;i:6;i:245;i:7;i:242;i:8;i:238;i:9;i:234;i:10;i:126;i:11;i:125;i:12;i:123;i:13;i:122;i:14;i:121;i:15;i:119;i:16;i:117;i:17;i:108;i:18;i:63;i:19;i:62;i:20;i:61;i:21;i:60;i:22;i:59;i:23;i:58;i:24;i:54;i:25;i:44;i:26;i:31;i:27;i:30;i:28;i:29;i:29;i:26;i:30;i:24;i:31;i:22;i:32;i:21;i:33;i:15;i:34;i:14;i:35;i:13;i:36;i:11;i:37;i:10;i:38;i:7;i:39;i:6;i:40;i:5;i:41;i:3;i:42;i:2;i:43;i:1;}',
])
->values([
  'name' => 'menu_options_article',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
])
->values([
  'name' => 'menu_options_blog',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
])
->values([
  'name' => 'menu_options_book',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
])
->values([
  'name' => 'menu_options_forum',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
])
->values([
  'name' => 'menu_options_page',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
])
->values([
  'name' => 'menu_options_test_content_type',
  'value' => 'a:4:{i:0;s:9:"main-menu";i:1;s:10:"management";i:2;s:10:"navigation";i:3;s:9:"user-menu";}',
])
->values([
  'name' => 'menu_override_parent_selector',
  'value' => 'b:1;',
])
->values([
  'name' => 'menu_parent_article',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'menu_parent_blog',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'menu_parent_book',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'menu_parent_forum',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'menu_parent_page',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'menu_parent_test_content_type',
  'value' => 's:11:"main-menu:0";',
])
->values([
  'name' => 'minimum_word_size',
  'value' => 's:1:"4";',
])
->values([
  'name' => 'node_admin_theme',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'node_cron_last',
  'value' => 's:10:"1564543706";',
])
->values([
  'name' => 'node_options_article',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_options_blog',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_options_book',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:8:"revision";}',
])
->values([
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
])
->values([
  'name' => 'node_options_test_content_type',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:8:"revision";}',
])
->values([
  'name' => 'node_preview_article',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'node_preview_blog',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'node_preview_forum',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'node_preview_page',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'node_rank_comments',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'node_rank_sticky',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_rank_views',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_submitted_article',
  'value' => 'i:1;',
])
->values([
  'name' => 'node_submitted_blog',
  'value' => 'i:1;',
])
->values([
  'name' => 'node_submitted_book',
  'value' => 'i:1;',
])
->values([
  'name' => 'node_submitted_forum',
  'value' => 'i:1;',
])
->values([
  'name' => 'node_submitted_page',
  'value' => 'i:0;',
])
->values([
  'name' => 'node_submitted_test_content_type',
  'value' => 'i:0;',
])
->values([
  'name' => 'overlap_cjk',
  'value' => 'i:1;',
])
->values([
  'name' => 'page_cache_maximum_age',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'page_compression',
  'value' => 'i:1;',
])
->values([
  'name' => 'path_alias_whitelist',
  'value' => 'a:3:{s:8:"taxonomy";b:1;s:4:"node";b:1;s:5:"admin";b:1;}',
])
->values([
  'name' => 'preprocess_css',
  'value' => 'i:1;',
])
->values([
  'name' => 'preprocess_js',
  'value' => 'i:0;',
])
->values([
  'name' => 'save_continue_test_content_type',
  'value' => 's:19:"Save and add fields";',
])
->values([
  'name' => 'search_active_modules',
  'value' => 'a:2:{s:4:"node";s:4:"node";s:4:"user";i:0;}',
])
->values([
  'name' => 'search_and_or_limit',
  'value' => 'i:7;',
])
->values([
  'name' => 'search_cron_limit',
  'value' => 's:3:"100";',
])
->values([
  'name' => 'search_default_module',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'search_tag_weights',
  'value' => 'a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:12;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}',
])
->values([
  'name' => 'site_403',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_404',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_default_country',
  'value' => 's:2:"US";',
])
->values([
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_mail',
  'value' => 's:23:"joseph@flattandsons.com";',
])
->values([
  'name' => 'site_name',
  'value' => 's:13:"The Site Name";',
])
->values([
  'name' => 'site_slogan',
  'value' => 's:10:"The Slogan";',
])
->values([
  'name' => 'suppress_itok_output',
  'value' => 'b:1;',
])
->values([
  'name' => 'syslog_facility',
  'value' => 'i:8;',
])
->values([
  'name' => 'syslog_format',
  'value' => 's:72:"!base_url|!timestamp|!type|!ip|!request_uri|!referer|!uid|!link|!message";',
])
->values([
  'name' => 'syslog_identity',
  'value' => 's:6:"drupal";',
])
->values([
  'name' => 'taxonomy_override_selector',
  'value' => 'b:1;',
])
->values([
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:84;',
])
->values([
  'name' => 'teaser_length',
  'value' => 'i:1024;',
])
->values([
  'name' => 'theme_bartik_settings',
  'value' => 'a:18:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:1;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:1;s:12:"default_logo";i:0;s:9:"logo_path";s:16:"public://gnu.png";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:6:"scheme";s:7:"default";s:7:"palette";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}s:5:"theme";s:6:"bartik";s:4:"info";a:12:{s:6:"fields";a:9:{s:3:"top";s:10:"Header top";s:6:"bottom";s:13:"Header bottom";s:2:"bg";s:15:"Main background";s:7:"sidebar";s:18:"Sidebar background";s:14:"sidebarborders";s:15:"Sidebar borders";s:6:"footer";s:17:"Footer background";s:11:"titleslogan";s:16:"Title and slogan";s:4:"text";s:10:"Text color";s:4:"link";s:10:"Link color";}s:7:"schemes";a:6:{s:7:"default";a:2:{s:5:"title";s:21:"Blue Lagoon (default)";s:6:"colors";a:9:{s:3:"top";s:7:"#0779bf";s:6:"bottom";s:7:"#48a9e4";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f6f6f2";s:14:"sidebarborders";s:7:"#f9f9f9";s:6:"footer";s:7:"#292929";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0071B3";}}s:9:"firehouse";a:2:{s:5:"title";s:9:"Firehouse";s:6:"colors";a:9:{s:3:"top";s:7:"#cd2d2d";s:6:"bottom";s:7:"#cf3535";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#f1f4f0";s:14:"sidebarborders";s:7:"#ededed";s:6:"footer";s:7:"#1f1d1c";s:11:"titleslogan";s:7:"#fffeff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#d6121f";}}s:3:"ice";a:2:{s:5:"title";s:3:"Ice";s:6:"colors";a:9:{s:3:"top";s:7:"#d0d0d0";s:6:"bottom";s:7:"#c2c4c5";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#cccccc";s:6:"footer";s:7:"#24272c";s:11:"titleslogan";s:7:"#000000";s:4:"text";s:7:"#4a4a4a";s:4:"link";s:7:"#019dbf";}}s:4:"plum";a:2:{s:5:"title";s:4:"Plum";s:6:"colors";a:9:{s:3:"top";s:7:"#4c1c58";s:6:"bottom";s:7:"#593662";s:2:"bg";s:7:"#fffdf7";s:7:"sidebar";s:7:"#edede7";s:14:"sidebarborders";s:7:"#e7e7e7";s:6:"footer";s:7:"#2c2c28";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#301313";s:4:"link";s:7:"#9d408d";}}s:5:"slate";a:2:{s:5:"title";s:5:"Slate";s:6:"colors";a:9:{s:3:"top";s:7:"#4a4a4a";s:6:"bottom";s:7:"#4e4e4e";s:2:"bg";s:7:"#ffffff";s:7:"sidebar";s:7:"#ffffff";s:14:"sidebarborders";s:7:"#d0d0d0";s:6:"footer";s:7:"#161617";s:11:"titleslogan";s:7:"#ffffff";s:4:"text";s:7:"#3b3b3b";s:4:"link";s:7:"#0073b6";}}s:0:"";a:2:{s:5:"title";s:6:"Custom";s:6:"colors";a:0:{}}}s:3:"css";a:1:{i:0;s:14:"css/colors.css";}s:4:"copy";a:1:{i:0;s:8:"logo.png";}s:9:"gradients";a:1:{i:0;a:3:{s:9:"dimension";a:4:{i:0;i:0;i:1;i:0;i:2;i:0;i:3;i:0;}s:9:"direction";s:8:"vertical";s:6:"colors";a:2:{i:0;s:3:"top";i:1;s:6:"bottom";}}}s:4:"fill";a:0:{}s:6:"slices";a:0:{}s:12:"blend_target";s:7:"#ffffff";s:11:"preview_css";s:17:"color/preview.css";s:10:"preview_js";s:16:"color/preview.js";s:12:"preview_html";s:18:"color/preview.html";s:10:"base_image";s:14:"color/base.png";}}',
])
->values([
  'name' => 'theme_default',
  'value' => 's:6:"bartik";',
])
->values([
  'name' => 'theme_settings',
  'value' => 'a:16:{s:11:"toggle_logo";i:0;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:0;s:14:"toggle_favicon";i:0;s:16:"toggle_main_menu";i:0;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:23:"public://customlogo.png";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:0;s:12:"favicon_path";s:24:"public://somefavicon.png";s:14:"favicon_upload";s:0:"";s:16:"favicon_mimetype";s:9:"image/png";}',
])
->values([
  'name' => 'theme_seven_settings',
  'value' => 'a:15:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:1;s:24:"toggle_node_user_picture";i:1;s:27:"toggle_comment_user_picture";i:0;s:32:"toggle_comment_user_verification";i:1;s:14:"toggle_favicon";i:1;s:16:"toggle_main_menu";i:1;s:21:"toggle_secondary_menu";i:0;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";}',
])
->values([
  'name' => 'update_check_frequency',
  'value' => 'i:1;',
])
->values([
  'name' => 'update_fetch_url',
  'value' => 's:23:"http://127.0.0.1/update";',
])
->values([
  'name' => 'update_last_check',
  'value' => 'i:1760139599;',
])
->values([
  'name' => 'update_max_fetch_attempts',
  'value' => 'i:3;',
])
->values([
  'name' => 'update_notification_threshold',
  'value' => 's:3:"all";',
])
->values([
  'name' => 'update_notify_emails',
  'value' => 'a:1:{i:0;s:19:"webmaster@127.0.0.1";}',
])
->values([
  'name' => 'user_admin_role',
  'value' => 's:1:"3";',
])
->values([
  'name' => 'user_cancel_method',
  'value' => 's:17:"user_cancel_block";',
])
->values([
  'name' => 'user_default_timezone',
  'value' => 'i:2;',
])
->values([
  'name' => 'user_email_verification',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_failed_login_identifier_uid_only',
  'value' => 'b:1;',
])
->values([
  'name' => 'user_failed_login_ip_limit',
  'value' => 'i:30;',
])
->values([
  'name' => 'user_failed_login_ip_window',
  'value' => 'i:7200;',
])
->values([
  'name' => 'user_failed_login_user_limit',
  'value' => 'i:22;',
])
->values([
  'name' => 'user_failed_login_user_window',
  'value' => 'i:86400;',
])
->values([
  'name' => 'user_mail_cancel_confirm_body',
  'value' => 's:55:"A little birdie said you wanted to cancel your account.";',
])
->values([
  'name' => 'user_mail_cancel_confirm_subject',
  'value' => 's:13:"Are you sure?";',
])
->values([
  'name' => 'user_mail_password_reset_body',
  'value' => "s:32:\"Nope! You're locked out forever.\";",
])
->values([
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:17:"Fix your password";',
])
->values([
  'name' => 'user_mail_register_admin_created_body',
  'value' => 's:30:"...and it could be taken away.";',
])
->values([
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:24:"Gawd made you an account";',
])
->values([
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => 's:59:"You can now log in if you can figure out how to use Drupal!";',
])
->values([
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:8:"Welcome!";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_body',
  'value' => 's:32:"You have applied for an account.";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_subject',
  'value' => 's:34:"Account pending for admin approval";',
])
->values([
  'name' => 'user_mail_register_pending_approval_body',
  'value' => 's:61:"...you will join our Circle. Let the Drupal flow through you.";',
])
->values([
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:7:"Soon...";',
])
->values([
  'name' => 'user_mail_status_activated_body',
  'value' => 's:57:"Your account was activated, and there was much rejoicing.";',
])
->values([
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:25:"Your account is approved!";',
])
->values([
  'name' => 'user_mail_status_blocked_body',
  'value' => 's:72:"You no longer please the robot overlords. Go to your room and chill out.";',
])
->values([
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:7:"BEGONE!";',
])
->values([
  'name' => 'user_mail_status_canceled_body',
  'value' => 's:75:"The gates of Drupal are closed to you. Now you will work in the salt mines.";',
])
->values([
  'name' => 'user_mail_status_canceled_notify',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_canceled_subject',
  'value' => 's:12:"So long, bub";',
])
->values([
  'name' => 'user_pictures',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_picture_default',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_dimensions',
  'value' => 's:9:"1024x1024";',
])
->values([
  'name' => 'user_picture_file_size',
  'value' => 's:3:"800";',
])
->values([
  'name' => 'user_picture_guidelines',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_path',
  'value' => 's:8:"pictures";',
])
->values([
  'name' => 'user_picture_style',
  'value' => 's:9:"thumbnail";',
])
->values([
  'name' => 'user_register',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'user_signatures',
  'value' => 'i:0;',
])
->values([
  'name' => 'variable_module_list',
  'value' => 'a:4:{s:6:"locale";a:5:{i:0;s:29:"language_content_type_article";i:1;s:26:"language_content_type_page";i:2;s:26:"language_content_type_book";i:3;s:39:"language_content_type_test_content_type";i:4;s:16:"language_default";}s:4:"i18n";a:1:{i:0;s:18:"i18n_language_list";}s:14:"variable_realm";a:4:{i:0;s:26:"variable_realm_list_global";i:1;s:28:"variable_realm_list_language";i:2;s:28:"variable_realm_weight_global";i:3;s:30:"variable_realm_weight_language";}s:13:"i18n_variable";a:2:{i:0;s:18:"i18n_variable_conf";i:1;s:18:"i18n_variable_list";}}',
])
->values([
  'name' => 'variable_realm_list_language',
  'value' => 'a:3:{i:0;s:9:"site_name";i:1;s:11:"site_slogan";i:2;s:24:"maintenance_mode_message";}',
])
->execute();
$connection->schema()->createTable('variable_store', [
  'fields' => [
    'realm' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ],
    'realm_key' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'value' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ],
    'serialized' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'small',
      'default' => '1',
    ],
  ],
  'primary key' => [
    'realm',
    'realm_key',
    'name',
  ],
  'indexes' => [
    'realm_value' => [
      'realm',
      'realm_key',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('variable_store')
->fields([
  'realm',
  'realm_key',
  'name',
  'value',
  'serialized',
])
->values([
  'realm' => 'language',
  'realm_key' => 'en',
  'name' => 'user_default_timezone',
  'value' => '2',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_403',
  'value' => 'node',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_404',
  'value' => 'node',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_frontpage',
  'value' => 'node',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_name',
  'value' => 'The Site Name',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'site_slogan',
  'value' => 'fr - The Slogan',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'fr',
  'name' => 'user_default_timezone',
  'value' => '0',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'anonymous',
  'value' => 'is - anonymous',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'maintenance_mode_message',
  'value' => 'is - This is a custom maintenance mode message.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_403',
  'value' => 'node/1',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_404',
  'value' => 'node/6',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_frontpage',
  'value' => 'node/4',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_name',
  'value' => 'is - The Site Name',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'site_slogan',
  'value' => 'is - The Slogan',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_cancel_confirm_body',
  'value' => 'is - A little birdie said you wanted to cancel your account.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_cancel_confirm_subject',
  'value' => 'is - Are you sure?',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_password_reset_body',
  'value' => "is - Nope! You're locked out forever.",
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_password_reset_subject',
  'value' => 'is - Fix your password',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_admin_created_body',
  'value' => "is - ...and it could be taken away.\r\n[site:name], [site:url]",
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 'is - Gawd made you an account',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => 'is - You can now log in if you can figure out how to use Drupal!',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 'is - Welcome!',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_admin_body',
  'value' => 'is - You have applied for an account.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_admin_subject',
  'value' => 'is - Account pending for admin approval',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_body',
  'value' => 'is - ...you will join our Circle. Let the Drupal flow through you.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 'is - Soon...',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_activated_body',
  'value' => 'is - Your account was activated, and there was much rejoicing.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_activated_subject',
  'value' => 'is - Your account is approved!',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_blocked_body',
  'value' => 'is - You no longer please the robot overlords. Go to your room and chill out.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_blocked_subject',
  'value' => 'is - BEGONE!',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_canceled_body',
  'value' => 'is - The gates of Drupal are closed to you. Now you will work in the salt mines.',
  'serialized' => '0',
])
->values([
  'realm' => 'language',
  'realm_key' => 'is',
  'name' => 'user_mail_status_canceled_subject',
  'value' => 'is - So long, bub',
  'serialized' => '0',
])
->execute();

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
