# Developing and Contributing

This section covers how you can develop and contribute to the AI Core module and create Third Party Apps around it. Note that the AI module comes with very powerful submodules that might be able to solve your issues through pure site building.

## Core Module

### [Why should I base my work on the AI module?](why_ai.md)

This section showcases why the AI module is a great foundation for your contributed or custom built modules to build a foundation for AI calls.

### [Making AI Calls](base_calls.md)

The first developer documentation page covers how you can use the simplest, most basic way of making calls to different AI providers that are reusable and flexible.

### [Writing an AI Provider](writing_an_ai_provider.md)

AI Providers are services that you can call from Drupal for different AI calls. We have abstracted this away into operation types.

This section covers all the documentation that you need to be able to contribute or write a custom built provider for any third party AI service.

### [Writing a flexible third party module](develop_third_party_module.md)

This section covers what you should think about, when you are writing a third party module using the AI module to give the end user the best possible experience.

### [Working with recipes](recipes.md)

This section covers extra recipe configurations that will be available when installing the Drupal AI module.

### [Contribute to the AI module](../contribute/index.md)

This section covers how you can help out with the AI module and contribute with code, ideas or documentation.

### [Events](events.md)

This section covers the events that gets triggered from the AI module and how you can use them to do powerful things like changing the prompt before sending it or getting metadata after the request is done.
