<?php
/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * MySQLi Utility
 */
class CI_DB_mysqli_utility extends CI_DB_utility
{
    /**
     * List databases
     *
     * @access	private
     * @return	bool
     */
    public function _list_databases()
    {
        return "SHOW DATABASES";
    }

    /**
     * Optimize table query
     *
     * Generates a platform-specific query so that a table can be optimized
     *
     * @access	private
     * @param	string	the table name
     * @return	object
     */
    public function _optimize_table($table)
    {
        return "OPTIMIZE TABLE " . $this->db->escape_identifiers($table);
    }

    /**
     * Repair table query
     *
     * Generates a platform-specific query so that a table can be repaired
     *
     * @access	private
     * @param	string	the table name
     * @return	object
     */
    public function _repair_table($table)
    {
        return "REPAIR TABLE " . $this->db->escape_identifiers($table);
    }

    /**
     * MySQLi Export
     *
     * @access	private
     * @param	array	Preferences
     * @return	mixed
     */
    public function _backup($params = array())
    {
        // Currently unsupported
        return $this->db->display_error('db_unsuported_feature');
    }
}

// EOF
