import '../vendor/bower-asset/jquery/dist/jquery.min.js';

/**
 * EGroupware API: switch jQuery to NOT use $ as early as possible
 *
 * @link http://www.egroupware.org
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package api
 * @subpackage ajax
 * @author Ralf Becker <rb@egroupware.org>
 */

jQuery.noConflict();

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getDefaultExportFromNamespaceIfPresent (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') ? n['default'] : n;
}

function getDefaultExportFromNamespaceIfNotNamed (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') && Object.keys(n).length === 1 ? n['default'] : n;
}

function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
				var args = [null];
				args.push.apply(args, arguments);
				var Ctor = Function.bind.apply(f, args);
				return new Ctor();
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var es_array_includes = {};

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global$g =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();

var objectGetOwnPropertyDescriptor = {};

var fails$h = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$g = fails$h;

// Detect IE8's incomplete defineProperty implementation
var descriptors = !fails$g(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});

var fails$f = fails$h;

var functionBindNative = !fails$f(function () {
  // eslint-disable-next-line es/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});

var NATIVE_BIND$1 = functionBindNative;

var call$8 = Function.prototype.call;

var functionCall = NATIVE_BIND$1 ? call$8.bind(call$8) : function () {
  return call$8.apply(call$8, arguments);
};

var objectPropertyIsEnumerable = {};

'use strict';
var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor$1 && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
var f$5 = objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$1(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var createPropertyDescriptor$2 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var NATIVE_BIND = functionBindNative;

var FunctionPrototype$1 = Function.prototype;
var call$7 = FunctionPrototype$1.call;
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype$1.bind.bind(call$7, call$7);

var functionUncurryThis = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
  return function () {
    return call$7.apply(fn, arguments);
  };
};

var uncurryThis$j = functionUncurryThis;

var toString$b = uncurryThis$j({}.toString);
var stringSlice$5 = uncurryThis$j(''.slice);

var classofRaw$2 = function (it) {
  return stringSlice$5(toString$b(it), 8, -1);
};

var uncurryThis$i = functionUncurryThis;
var fails$e = fails$h;
var classof$4 = classofRaw$2;

var $Object$3 = Object;
var split = uncurryThis$i(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var indexedObject = fails$e(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object$3('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$4(it) == 'String' ? split(it, '') : $Object$3(it);
} : $Object$3;

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
var isNullOrUndefined$3 = function (it) {
  return it === null || it === undefined;
};

var isNullOrUndefined$2 = isNullOrUndefined$3;

var $TypeError$7 = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
var requireObjectCoercible$7 = function (it) {
  if (isNullOrUndefined$2(it)) throw $TypeError$7("Can't call method on " + it);
  return it;
};

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = indexedObject;
var requireObjectCoercible$6 = requireObjectCoercible$7;

var toIndexedObject$4 = function (it) {
  return IndexedObject(requireObjectCoercible$6(it));
};

var documentAll$2 = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
var IS_HTMLDDA = typeof documentAll$2 == 'undefined' && documentAll$2 !== undefined;

var documentAll_1 = {
  all: documentAll$2,
  IS_HTMLDDA: IS_HTMLDDA
};

var $documentAll$1 = documentAll_1;

var documentAll$1 = $documentAll$1.all;

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
var isCallable$d = $documentAll$1.IS_HTMLDDA ? function (argument) {
  return typeof argument == 'function' || argument === documentAll$1;
} : function (argument) {
  return typeof argument == 'function';
};

var isCallable$c = isCallable$d;
var $documentAll = documentAll_1;

var documentAll = $documentAll.all;

var isObject$6 = $documentAll.IS_HTMLDDA ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable$c(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable$c(it);
};

var global$f = global$g;
var isCallable$b = isCallable$d;

var aFunction = function (argument) {
  return isCallable$b(argument) ? argument : undefined;
};

var getBuiltIn$3 = function (namespace, method) {
  return arguments.length < 2 ? aFunction(global$f[namespace]) : global$f[namespace] && global$f[namespace][method];
};

var uncurryThis$h = functionUncurryThis;

var objectIsPrototypeOf = uncurryThis$h({}.isPrototypeOf);

var engineUserAgent = typeof navigator != 'undefined' && String(navigator.userAgent) || '';

var global$e = global$g;
var userAgent = engineUserAgent;

var process = global$e.process;
var Deno = global$e.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

var engineV8Version = version;

/* eslint-disable es/no-symbol -- required for testing */

var V8_VERSION = engineV8Version;
var fails$d = fails$h;

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$d(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});

/* eslint-disable es/no-symbol -- required for testing */

var NATIVE_SYMBOL$2 = symbolConstructorDetection;

var useSymbolAsUid = NATIVE_SYMBOL$2
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

var getBuiltIn$2 = getBuiltIn$3;
var isCallable$a = isCallable$d;
var isPrototypeOf$2 = objectIsPrototypeOf;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

var $Object$2 = Object;

var isSymbol$2 = USE_SYMBOL_AS_UID$1 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$2('Symbol');
  return isCallable$a($Symbol) && isPrototypeOf$2($Symbol.prototype, $Object$2(it));
};

var $String$4 = String;

var tryToString$1 = function (argument) {
  try {
    return $String$4(argument);
  } catch (error) {
    return 'Object';
  }
};

var isCallable$9 = isCallable$d;
var tryToString = tryToString$1;

var $TypeError$6 = TypeError;

// `Assert: IsCallable(argument) is true`
var aCallable$1 = function (argument) {
  if (isCallable$9(argument)) return argument;
  throw $TypeError$6(tryToString(argument) + ' is not a function');
};

var aCallable = aCallable$1;
var isNullOrUndefined$1 = isNullOrUndefined$3;

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
var getMethod$2 = function (V, P) {
  var func = V[P];
  return isNullOrUndefined$1(func) ? undefined : aCallable(func);
};

var call$6 = functionCall;
var isCallable$8 = isCallable$d;
var isObject$5 = isObject$6;

var $TypeError$5 = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable$8(fn = input.toString) && !isObject$5(val = call$6(fn, input))) return val;
  if (isCallable$8(fn = input.valueOf) && !isObject$5(val = call$6(fn, input))) return val;
  if (pref !== 'string' && isCallable$8(fn = input.toString) && !isObject$5(val = call$6(fn, input))) return val;
  throw $TypeError$5("Can't convert object to primitive value");
};

var sharedExports = {};
var shared$4 = {
  get exports(){ return sharedExports; },
  set exports(v){ sharedExports = v; },
};

var isPure = false;

var global$d = global$g;

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty$3 = Object.defineProperty;

var defineGlobalProperty$3 = function (key, value) {
  try {
    defineProperty$3(global$d, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global$d[key] = value;
  } return value;
};

var global$c = global$g;
var defineGlobalProperty$2 = defineGlobalProperty$3;

var SHARED = '__core-js_shared__';
var store$3 = global$c[SHARED] || defineGlobalProperty$2(SHARED, {});

var sharedStore = store$3;

var IS_PURE = isPure;
var store$2 = sharedStore;

(shared$4.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.29.1',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.29.1/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});

var requireObjectCoercible$5 = requireObjectCoercible$7;

var $Object$1 = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
var toObject$1 = function (argument) {
  return $Object$1(requireObjectCoercible$5(argument));
};

var uncurryThis$g = functionUncurryThis;
var toObject = toObject$1;

var hasOwnProperty = uncurryThis$g({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es/no-object-hasown -- safe
var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject(it), key);
};

var uncurryThis$f = functionUncurryThis;

var id = 0;
var postfix = Math.random();
var toString$a = uncurryThis$f(1.0.toString);

var uid$2 = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$a(++id + postfix, 36);
};

var global$b = global$g;
var shared$3 = sharedExports;
var hasOwn$8 = hasOwnProperty_1;
var uid$1 = uid$2;
var NATIVE_SYMBOL$1 = symbolConstructorDetection;
var USE_SYMBOL_AS_UID = useSymbolAsUid;

var Symbol$3 = global$b.Symbol;
var WellKnownSymbolsStore = shared$3('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$3['for'] || Symbol$3 : Symbol$3 && Symbol$3.withoutSetter || uid$1;

var wellKnownSymbol$7 = function (name) {
  if (!hasOwn$8(WellKnownSymbolsStore, name)) {
    WellKnownSymbolsStore[name] = NATIVE_SYMBOL$1 && hasOwn$8(Symbol$3, name)
      ? Symbol$3[name]
      : createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore[name];
};

var call$5 = functionCall;
var isObject$4 = isObject$6;
var isSymbol$1 = isSymbol$2;
var getMethod$1 = getMethod$2;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$6 = wellKnownSymbol$7;

var $TypeError$4 = TypeError;
var TO_PRIMITIVE = wellKnownSymbol$6('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
var toPrimitive$1 = function (input, pref) {
  if (!isObject$4(input) || isSymbol$1(input)) return input;
  var exoticToPrim = getMethod$1(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call$5(exoticToPrim, input, pref);
    if (!isObject$4(result) || isSymbol$1(result)) return result;
    throw $TypeError$4("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive = toPrimitive$1;
var isSymbol = isSymbol$2;

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
var toPropertyKey$2 = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};

var global$a = global$g;
var isObject$3 = isObject$6;

var document$1 = global$a.document;
// typeof document.createElement is 'object' in old IE
var EXISTS$1 = isObject$3(document$1) && isObject$3(document$1.createElement);

var documentCreateElement$1 = function (it) {
  return EXISTS$1 ? document$1.createElement(it) : {};
};

var DESCRIPTORS$8 = descriptors;
var fails$c = fails$h;
var createElement = documentCreateElement$1;

// Thanks to IE8 for its funny defineProperty
var ie8DomDefine = !DESCRIPTORS$8 && !fails$c(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});

var DESCRIPTORS$7 = descriptors;
var call$4 = functionCall;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var createPropertyDescriptor$1 = createPropertyDescriptor$2;
var toIndexedObject$3 = toIndexedObject$4;
var toPropertyKey$1 = toPropertyKey$2;
var hasOwn$7 = hasOwnProperty_1;
var IE8_DOM_DEFINE$1 = ie8DomDefine;

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
var f$4 = objectGetOwnPropertyDescriptor.f = DESCRIPTORS$7 ? $getOwnPropertyDescriptor$1 : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$3(O);
  P = toPropertyKey$1(P);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor$1(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn$7(O, P)) return createPropertyDescriptor$1(!call$4(propertyIsEnumerableModule.f, O, P), O[P]);
};

var objectDefineProperty = {};

var DESCRIPTORS$6 = descriptors;
var fails$b = fails$h;

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
var v8PrototypeDefineBug = DESCRIPTORS$6 && fails$b(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype != 42;
});

var isObject$2 = isObject$6;

var $String$3 = String;
var $TypeError$3 = TypeError;

// `Assert: Type(argument) is Object`
var anObject$8 = function (argument) {
  if (isObject$2(argument)) return argument;
  throw $TypeError$3($String$3(argument) + ' is not an object');
};

var DESCRIPTORS$5 = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
var anObject$7 = anObject$8;
var toPropertyKey = toPropertyKey$2;

var $TypeError$2 = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE$1 = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
var f$3 = objectDefineProperty.f = DESCRIPTORS$5 ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
  anObject$7(O);
  P = toPropertyKey(P);
  anObject$7(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject$7(O);
  P = toPropertyKey(P);
  anObject$7(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw $TypeError$2('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$4 = descriptors;
var definePropertyModule$3 = objectDefineProperty;
var createPropertyDescriptor = createPropertyDescriptor$2;

var createNonEnumerableProperty$3 = DESCRIPTORS$4 ? function (object, key, value) {
  return definePropertyModule$3.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var makeBuiltInExports = {};
var makeBuiltIn$3 = {
  get exports(){ return makeBuiltInExports; },
  set exports(v){ makeBuiltInExports = v; },
};

var DESCRIPTORS$3 = descriptors;
var hasOwn$6 = hasOwnProperty_1;

var FunctionPrototype = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS$3 && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn$6(FunctionPrototype, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS$3 || (DESCRIPTORS$3 && getDescriptor(FunctionPrototype, 'name').configurable));

var functionName = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};

var uncurryThis$e = functionUncurryThis;
var isCallable$7 = isCallable$d;
var store$1 = sharedStore;

var functionToString = uncurryThis$e(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable$7(store$1.inspectSource)) {
  store$1.inspectSource = function (it) {
    return functionToString(it);
  };
}

var inspectSource$1 = store$1.inspectSource;

var global$9 = global$g;
var isCallable$6 = isCallable$d;

var WeakMap$1 = global$9.WeakMap;

var weakMapBasicDetection = isCallable$6(WeakMap$1) && /native code/.test(String(WeakMap$1));

var shared$2 = sharedExports;
var uid = uid$2;

var keys = shared$2('keys');

var sharedKey$2 = function (key) {
  return keys[key] || (keys[key] = uid(key));
};

var hiddenKeys$4 = {};

var NATIVE_WEAK_MAP = weakMapBasicDetection;
var global$8 = global$g;
var isObject$1 = isObject$6;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$3;
var hasOwn$5 = hasOwnProperty_1;
var shared$1 = sharedStore;
var sharedKey$1 = sharedKey$2;
var hiddenKeys$3 = hiddenKeys$4;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError$1 = global$8.TypeError;
var WeakMap = global$8.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject$1(it) || (state = get(it)).type !== TYPE) {
      throw TypeError$1('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared$1.state) {
  var store = shared$1.state || (shared$1.state = new WeakMap());
  /* eslint-disable no-self-assign -- prototype methods protection */
  store.get = store.get;
  store.has = store.has;
  store.set = store.set;
  /* eslint-enable no-self-assign -- prototype methods protection */
  set = function (it, metadata) {
    if (store.has(it)) throw TypeError$1(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    store.set(it, metadata);
    return metadata;
  };
  get = function (it) {
    return store.get(it) || {};
  };
  has = function (it) {
    return store.has(it);
  };
} else {
  var STATE = sharedKey$1('state');
  hiddenKeys$3[STATE] = true;
  set = function (it, metadata) {
    if (hasOwn$5(it, STATE)) throw TypeError$1(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$2(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn$5(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn$5(it, STATE);
  };
}

var internalState = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};

var uncurryThis$d = functionUncurryThis;
var fails$a = fails$h;
var isCallable$5 = isCallable$d;
var hasOwn$4 = hasOwnProperty_1;
var DESCRIPTORS$2 = descriptors;
var CONFIGURABLE_FUNCTION_NAME = functionName.CONFIGURABLE;
var inspectSource = inspectSource$1;
var InternalStateModule = internalState;

var enforceInternalState = InternalStateModule.enforce;
var getInternalState$1 = InternalStateModule.get;
var $String$2 = String;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty$2 = Object.defineProperty;
var stringSlice$4 = uncurryThis$d(''.slice);
var replace$3 = uncurryThis$d(''.replace);
var join = uncurryThis$d([].join);

var CONFIGURABLE_LENGTH = DESCRIPTORS$2 && !fails$a(function () {
  return defineProperty$2(function () { /* empty */ }, 'length', { value: 8 }).length !== 8;
});

var TEMPLATE = String(String).split('String');

var makeBuiltIn$2 = makeBuiltIn$3.exports = function (value, name, options) {
  if (stringSlice$4($String$2(name), 0, 7) === 'Symbol(') {
    name = '[' + replace$3($String$2(name), /^Symbol\(([^)]*)\)/, '$1') + ']';
  }
  if (options && options.getter) name = 'get ' + name;
  if (options && options.setter) name = 'set ' + name;
  if (!hasOwn$4(value, 'name') || (CONFIGURABLE_FUNCTION_NAME && value.name !== name)) {
    if (DESCRIPTORS$2) defineProperty$2(value, 'name', { value: name, configurable: true });
    else value.name = name;
  }
  if (CONFIGURABLE_LENGTH && options && hasOwn$4(options, 'arity') && value.length !== options.arity) {
    defineProperty$2(value, 'length', { value: options.arity });
  }
  try {
    if (options && hasOwn$4(options, 'constructor') && options.constructor) {
      if (DESCRIPTORS$2) defineProperty$2(value, 'prototype', { writable: false });
    // in V8 ~ Chrome 53, prototypes of some methods, like `Array.prototype.values`, are non-writable
    } else if (value.prototype) value.prototype = undefined;
  } catch (error) { /* empty */ }
  var state = enforceInternalState(value);
  if (!hasOwn$4(state, 'source')) {
    state.source = join(TEMPLATE, typeof name == 'string' ? name : '');
  } return value;
};

// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
// eslint-disable-next-line no-extend-native -- required
Function.prototype.toString = makeBuiltIn$2(function toString() {
  return isCallable$5(this) && getInternalState$1(this).source || inspectSource(this);
}, 'toString');

var isCallable$4 = isCallable$d;
var definePropertyModule$2 = objectDefineProperty;
var makeBuiltIn$1 = makeBuiltInExports;
var defineGlobalProperty$1 = defineGlobalProperty$3;

var defineBuiltIn$3 = function (O, key, value, options) {
  if (!options) options = {};
  var simple = options.enumerable;
  var name = options.name !== undefined ? options.name : key;
  if (isCallable$4(value)) makeBuiltIn$1(value, name, options);
  if (options.global) {
    if (simple) O[key] = value;
    else defineGlobalProperty$1(key, value);
  } else {
    try {
      if (!options.unsafe) delete O[key];
      else if (O[key]) simple = true;
    } catch (error) { /* empty */ }
    if (simple) O[key] = value;
    else definePropertyModule$2.f(O, key, {
      value: value,
      enumerable: false,
      configurable: !options.nonConfigurable,
      writable: !options.nonWritable
    });
  } return O;
};

var objectGetOwnPropertyNames = {};

var ceil = Math.ceil;
var floor$1 = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es/no-math-trunc -- safe
var mathTrunc = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor$1 : ceil)(n);
};

var trunc = mathTrunc;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
var toIntegerOrInfinity$5 = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};

var toIntegerOrInfinity$4 = toIntegerOrInfinity$5;

var max = Math.max;
var min$1 = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
var toAbsoluteIndex$1 = function (index, length) {
  var integer = toIntegerOrInfinity$4(index);
  return integer < 0 ? max(integer + length, 0) : min$1(integer, length);
};

var toIntegerOrInfinity$3 = toIntegerOrInfinity$5;

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
var toLength$2 = function (argument) {
  return argument > 0 ? min(toIntegerOrInfinity$3(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toLength$1 = toLength$2;

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
var lengthOfArrayLike$1 = function (obj) {
  return toLength$1(obj.length);
};

var toIndexedObject$2 = toIndexedObject$4;
var toAbsoluteIndex = toAbsoluteIndex$1;
var lengthOfArrayLike = lengthOfArrayLike$1;

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod$2 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$2($this);
    var length = lengthOfArrayLike(O);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$2(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$2(false)
};

var uncurryThis$c = functionUncurryThis;
var hasOwn$3 = hasOwnProperty_1;
var toIndexedObject$1 = toIndexedObject$4;
var indexOf$1 = arrayIncludes.indexOf;
var hiddenKeys$2 = hiddenKeys$4;

var push = uncurryThis$c([].push);

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$1(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn$3(hiddenKeys$2, key) && hasOwn$3(O, key) && push(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn$3(O, key = names[i++])) {
    ~indexOf$1(result, key) || push(result, key);
  }
  return result;
};

// IE8- don't enum bug keys
var enumBugKeys$3 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;

var hiddenKeys$1 = enumBugKeys$2.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
var f$2 = objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys$1(O, hiddenKeys$1);
};

var objectGetOwnPropertySymbols = {};

// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
var f$1 = objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var getBuiltIn$1 = getBuiltIn$3;
var uncurryThis$b = functionUncurryThis;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var anObject$6 = anObject$8;

var concat = uncurryThis$b([].concat);

// all object keys, includes non-enumerable and symbols
var ownKeys$1 = getBuiltIn$1('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject$6(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};

var hasOwn$2 = hasOwnProperty_1;
var ownKeys = ownKeys$1;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var definePropertyModule$1 = objectDefineProperty;

var copyConstructorProperties$2 = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule$1.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn$2(target, key) && !(exceptions && hasOwn$2(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};

var fails$9 = fails$h;
var isCallable$3 = isCallable$d;

var replacement = /#|\.prototype\./;

var isForced$1 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : isCallable$3(detection) ? fails$9(detection)
    : !!detection;
};

var normalize = isForced$1.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$1.data = {};
var NATIVE = isForced$1.NATIVE = 'N';
var POLYFILL = isForced$1.POLYFILL = 'P';

var isForced_1 = isForced$1;

var global$7 = global$g;
var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$3;
var defineBuiltIn$2 = defineBuiltIn$3;
var defineGlobalProperty = defineGlobalProperty$3;
var copyConstructorProperties$1 = copyConstructorProperties$2;
var isForced = isForced_1;

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;
  if (GLOBAL) {
    target = global$7;
  } else if (STATIC) {
    target = global$7[TARGET] || defineGlobalProperty(TARGET, {});
  } else {
    target = (global$7[TARGET] || {}).prototype;
  }
  if (target) for (key in source) {
    sourceProperty = source[key];
    if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contained in target
    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty == typeof targetProperty) continue;
      copyConstructorProperties$1(sourceProperty, targetProperty);
    }
    // add a flag to not completely full polyfills
    if (options.sham || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty$1(sourceProperty, 'sham', true);
    }
    defineBuiltIn$2(target, key, sourceProperty, options);
  }
};

var objectDefineProperties = {};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys$1 = enumBugKeys$3;

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
var objectKeys$1 = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys$1);
};

var DESCRIPTORS$1 = descriptors;
var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
var definePropertyModule = objectDefineProperty;
var anObject$5 = anObject$8;
var toIndexedObject = toIndexedObject$4;
var objectKeys = objectKeys$1;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
var f = objectDefineProperties.f = DESCRIPTORS$1 && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$5(O);
  var props = toIndexedObject(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
  return O;
};

var getBuiltIn = getBuiltIn$3;

var html$1 = getBuiltIn('document', 'documentElement');

/* global ActiveXObject -- old IE, WSH */

var anObject$4 = anObject$8;
var definePropertiesModule = objectDefineProperties;
var enumBugKeys = enumBugKeys$3;
var hiddenKeys = hiddenKeys$4;
var html = html$1;
var documentCreateElement = documentCreateElement$1;
var sharedKey = sharedKey$2;

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es/no-object-create -- safe
var objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject$4(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};

var wellKnownSymbol$5 = wellKnownSymbol$7;
var create$1 = objectCreate;
var defineProperty$1 = objectDefineProperty.f;

var UNSCOPABLES = wellKnownSymbol$5('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] == undefined) {
  defineProperty$1(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create$1(null)
  });
}

// add a key to Array.prototype[@@unscopables]
var addToUnscopables$1 = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};

'use strict';
var $$6 = _export;
var $includes = arrayIncludes.includes;
var fails$8 = fails$h;
var addToUnscopables = addToUnscopables$1;

// FF99+ bug
var BROKEN_ON_SPARSE = fails$8(function () {
  // eslint-disable-next-line es/no-array-prototype-includes -- detection
  return !Array(1).includes();
});

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$$6({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('includes');

var es_string_includes = {};

var isObject = isObject$6;
var classof$3 = classofRaw$2;
var wellKnownSymbol$4 = wellKnownSymbol$7;

var MATCH$1 = wellKnownSymbol$4('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
var isRegexp = function (it) {
  var isRegExp;
  return isObject(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$3(it) == 'RegExp');
};

var isRegExp = isRegexp;

var $TypeError$1 = TypeError;

var notARegexp = function (it) {
  if (isRegExp(it)) {
    throw $TypeError$1("The method doesn't accept regular expressions");
  } return it;
};

var wellKnownSymbol$3 = wellKnownSymbol$7;

var TO_STRING_TAG$1 = wellKnownSymbol$3('toStringTag');
var test = {};

test[TO_STRING_TAG$1] = 'z';

var toStringTagSupport = String(test) === '[object z]';

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var isCallable$2 = isCallable$d;
var classofRaw$1 = classofRaw$2;
var wellKnownSymbol$2 = wellKnownSymbol$7;

var TO_STRING_TAG = wellKnownSymbol$2('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw$1(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
var classof$2 = TO_STRING_TAG_SUPPORT ? classofRaw$1 : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw$1(O)
    // ES3 arguments fallback
    : (result = classofRaw$1(O)) == 'Object' && isCallable$2(O.callee) ? 'Arguments' : result;
};

var classof$1 = classof$2;

var $String$1 = String;

var toString$9 = function (argument) {
  if (classof$1(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
  return $String$1(argument);
};

var wellKnownSymbol$1 = wellKnownSymbol$7;

var MATCH = wellKnownSymbol$1('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};

'use strict';
var $$5 = _export;
var uncurryThis$a = functionUncurryThis;
var notARegExp = notARegexp;
var requireObjectCoercible$4 = requireObjectCoercible$7;
var toString$8 = toString$9;
var correctIsRegExpLogic = correctIsRegexpLogic;

var stringIndexOf = uncurryThis$a(''.indexOf);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$$5({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~stringIndexOf(
      toString$8(requireObjectCoercible$4(this)),
      toString$8(notARegExp(searchString)),
      arguments.length > 1 ? arguments[1] : undefined
    );
  }
});

var es_regexp_exec = {};

'use strict';
var anObject$3 = anObject$8;

// `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags
var regexpFlags$1 = function () {
  var that = anObject$3(this);
  var result = '';
  if (that.hasIndices) result += 'd';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.unicodeSets) result += 'v';
  if (that.sticky) result += 'y';
  return result;
};

var fails$7 = fails$h;
var global$6 = global$g;

// babel-minify and Closure Compiler transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
var $RegExp$2 = global$6.RegExp;

var UNSUPPORTED_Y$1 = fails$7(function () {
  var re = $RegExp$2('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});

// UC Browser bug
// https://github.com/zloirock/core-js/issues/1008
var MISSED_STICKY = UNSUPPORTED_Y$1 || fails$7(function () {
  return !$RegExp$2('a', 'y').sticky;
});

var BROKEN_CARET = UNSUPPORTED_Y$1 || fails$7(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = $RegExp$2('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});

var regexpStickyHelpers = {
  BROKEN_CARET: BROKEN_CARET,
  MISSED_STICKY: MISSED_STICKY,
  UNSUPPORTED_Y: UNSUPPORTED_Y$1
};

var fails$6 = fails$h;
var global$5 = global$g;

// babel-minify and Closure Compiler transpiles RegExp('.', 's') -> /./s and it causes SyntaxError
var $RegExp$1 = global$5.RegExp;

var regexpUnsupportedDotAll = fails$6(function () {
  var re = $RegExp$1('.', 's');
  return !(re.dotAll && re.exec('\n') && re.flags === 's');
});

var fails$5 = fails$h;
var global$4 = global$g;

// babel-minify and Closure Compiler transpiles RegExp('(?<a>b)', 'g') -> /(?<a>b)/g and it causes SyntaxError
var $RegExp = global$4.RegExp;

var regexpUnsupportedNcg = fails$5(function () {
  var re = $RegExp('(?<a>b)', 'g');
  return re.exec('b').groups.a !== 'b' ||
    'b'.replace(re, '$<a>c') !== 'bc';
});

'use strict';
/* eslint-disable regexp/no-empty-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */
/* eslint-disable regexp/no-useless-quantifier -- testing */
var call$3 = functionCall;
var uncurryThis$9 = functionUncurryThis;
var toString$7 = toString$9;
var regexpFlags = regexpFlags$1;
var stickyHelpers = regexpStickyHelpers;
var shared = sharedExports;
var create = objectCreate;
var getInternalState = internalState.get;
var UNSUPPORTED_DOT_ALL = regexpUnsupportedDotAll;
var UNSUPPORTED_NCG = regexpUnsupportedNcg;

var nativeReplace = shared('native-string-replace', String.prototype.replace);
var nativeExec = RegExp.prototype.exec;
var patchedExec = nativeExec;
var charAt$3 = uncurryThis$9(''.charAt);
var indexOf = uncurryThis$9(''.indexOf);
var replace$2 = uncurryThis$9(''.replace);
var stringSlice$3 = uncurryThis$9(''.slice);

var UPDATES_LAST_INDEX_WRONG = (function () {
  var re1 = /a/;
  var re2 = /b*/g;
  call$3(nativeExec, re1, 'a');
  call$3(nativeExec, re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
})();

var UNSUPPORTED_Y = stickyHelpers.BROKEN_CARET;

// nonparticipating capturing group, copied from es5-shim's String#split patch.
var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;

var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y || UNSUPPORTED_DOT_ALL || UNSUPPORTED_NCG;

if (PATCH) {
  patchedExec = function exec(string) {
    var re = this;
    var state = getInternalState(re);
    var str = toString$7(string);
    var raw = state.raw;
    var result, reCopy, lastIndex, match, i, object, group;

    if (raw) {
      raw.lastIndex = re.lastIndex;
      result = call$3(patchedExec, raw, str);
      re.lastIndex = raw.lastIndex;
      return result;
    }

    var groups = state.groups;
    var sticky = UNSUPPORTED_Y && re.sticky;
    var flags = call$3(regexpFlags, re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = replace$2(flags, 'y', '');
      if (indexOf(flags, 'g') === -1) {
        flags += 'g';
      }

      strCopy = stringSlice$3(str, re.lastIndex);
      // Support anchored sticky behavior.
      if (re.lastIndex > 0 && (!re.multiline || re.multiline && charAt$3(str, re.lastIndex - 1) !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      }
      // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.
      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }
    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;

    match = call$3(nativeExec, sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = stringSlice$3(match.input, charsAdded);
        match[0] = stringSlice$3(match[0], charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }
    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn't work for /(.?)?/
      call$3(nativeReplace, match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    if (match && groups) {
      match.groups = object = create(null);
      for (i = 0; i < groups.length; i++) {
        group = groups[i];
        object[group[0]] = match[group[1]];
      }
    }

    return match;
  };
}

var regexpExec$2 = patchedExec;

'use strict';
var $$4 = _export;
var exec$1 = regexpExec$2;

// `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec
$$4({ target: 'RegExp', proto: true, forced: /./.exec !== exec$1 }, {
  exec: exec$1
});

var es_string_match = {};

var classofRaw = classofRaw$2;
var uncurryThis$8 = functionUncurryThis;

var functionUncurryThisClause = function (fn) {
  // Nashorn bug:
  //   https://github.com/zloirock/core-js/issues/1128
  //   https://github.com/zloirock/core-js/issues/1130
  if (classofRaw(fn) === 'Function') return uncurryThis$8(fn);
};

'use strict';
// TODO: Remove from `core-js@4` since it's moved to entry points

var uncurryThis$7 = functionUncurryThisClause;
var defineBuiltIn$1 = defineBuiltIn$3;
var regexpExec$1 = regexpExec$2;
var fails$4 = fails$h;
var wellKnownSymbol = wellKnownSymbol$7;
var createNonEnumerableProperty = createNonEnumerableProperty$3;

var SPECIES = wellKnownSymbol('species');
var RegExpPrototype$2 = RegExp.prototype;

var fixRegexpWellKnownSymbolLogic = function (KEY, exec, FORCED, SHAM) {
  var SYMBOL = wellKnownSymbol(KEY);

  var DELEGATES_TO_SYMBOL = !fails$4(function () {
    // String methods call symbol-named RegEp methods
    var O = {};
    O[SYMBOL] = function () { return 7; };
    return ''[KEY](O) != 7;
  });

  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$4(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {};
      // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.
      re.constructor = {};
      re.constructor[SPECIES] = function () { return re; };
      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () { execCalled = true; return null; };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (
    !DELEGATES_TO_SYMBOL ||
    !DELEGATES_TO_EXEC ||
    FORCED
  ) {
    var uncurriedNativeRegExpMethod = uncurryThis$7(/./[SYMBOL]);
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var uncurriedNativeMethod = uncurryThis$7(nativeMethod);
      var $exec = regexp.exec;
      if ($exec === regexpExec$1 || $exec === RegExpPrototype$2.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return { done: true, value: uncurriedNativeRegExpMethod(regexp, str, arg2) };
        }
        return { done: true, value: uncurriedNativeMethod(str, regexp, arg2) };
      }
      return { done: false };
    });

    defineBuiltIn$1(String.prototype, KEY, methods[0]);
    defineBuiltIn$1(RegExpPrototype$2, SYMBOL, methods[1]);
  }

  if (SHAM) createNonEnumerableProperty(RegExpPrototype$2[SYMBOL], 'sham', true);
};

var uncurryThis$6 = functionUncurryThis;
var toIntegerOrInfinity$2 = toIntegerOrInfinity$5;
var toString$6 = toString$9;
var requireObjectCoercible$3 = requireObjectCoercible$7;

var charAt$2 = uncurryThis$6(''.charAt);
var charCodeAt = uncurryThis$6(''.charCodeAt);
var stringSlice$2 = uncurryThis$6(''.slice);

var createMethod$1 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$6(requireObjectCoercible$3($this));
    var position = toIntegerOrInfinity$2(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt$2(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice$2(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod$1(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod$1(true)
};

'use strict';
var charAt$1 = stringMultibyte.charAt;

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
var advanceStringIndex$1 = function (S, index, unicode) {
  return index + (unicode ? charAt$1(S, index).length : 1);
};

var call$2 = functionCall;
var anObject$2 = anObject$8;
var isCallable$1 = isCallable$d;
var classof = classofRaw$2;
var regexpExec = regexpExec$2;

var $TypeError = TypeError;

// `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec
var regexpExecAbstract = function (R, S) {
  var exec = R.exec;
  if (isCallable$1(exec)) {
    var result = call$2(exec, R, S);
    if (result !== null) anObject$2(result);
    return result;
  }
  if (classof(R) === 'RegExp') return call$2(regexpExec, R, S);
  throw $TypeError('RegExp#exec called on incompatible receiver');
};

'use strict';
var call$1 = functionCall;
var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject$1 = anObject$8;
var isNullOrUndefined = isNullOrUndefined$3;
var toLength = toLength$2;
var toString$5 = toString$9;
var requireObjectCoercible$2 = requireObjectCoercible$7;
var getMethod = getMethod$2;
var advanceStringIndex = advanceStringIndex$1;
var regExpExec = regexpExecAbstract;

// @@match logic
fixRegExpWellKnownSymbolLogic('match', function (MATCH, nativeMatch, maybeCallNative) {
  return [
    // `String.prototype.match` method
    // https://tc39.es/ecma262/#sec-string.prototype.match
    function match(regexp) {
      var O = requireObjectCoercible$2(this);
      var matcher = isNullOrUndefined(regexp) ? undefined : getMethod(regexp, MATCH);
      return matcher ? call$1(matcher, regexp, O) : new RegExp(regexp)[MATCH](toString$5(O));
    },
    // `RegExp.prototype[@@match]` method
    // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
    function (string) {
      var rx = anObject$1(this);
      var S = toString$5(string);
      var res = maybeCallNative(nativeMatch, rx, S);

      if (res.done) return res.value;

      if (!rx.global) return regExpExec(rx, S);

      var fullUnicode = rx.unicode;
      rx.lastIndex = 0;
      var A = [];
      var n = 0;
      var result;
      while ((result = regExpExec(rx, S)) !== null) {
        var matchStr = toString$5(result[0]);
        A[n] = matchStr;
        if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
        n++;
      }
      return n === 0 ? null : A;
    }
  ];
});

var es_regexp_toString = {};

var call = functionCall;
var hasOwn$1 = hasOwnProperty_1;
var isPrototypeOf$1 = objectIsPrototypeOf;
var regExpFlags = regexpFlags$1;

var RegExpPrototype$1 = RegExp.prototype;

var regexpGetFlags = function (R) {
  var flags = R.flags;
  return flags === undefined && !('flags' in RegExpPrototype$1) && !hasOwn$1(R, 'flags') && isPrototypeOf$1(RegExpPrototype$1, R)
    ? call(regExpFlags, R) : flags;
};

'use strict';
var PROPER_FUNCTION_NAME = functionName.PROPER;
var defineBuiltIn = defineBuiltIn$3;
var anObject = anObject$8;
var $toString = toString$9;
var fails$3 = fails$h;
var getRegExpFlags = regexpGetFlags;

var TO_STRING = 'toString';
var RegExpPrototype = RegExp.prototype;
var nativeToString = RegExpPrototype[TO_STRING];

var NOT_GENERIC = fails$3(function () { return nativeToString.call({ source: 'a', flags: 'b' }) != '/a/b'; });
// FF44- RegExp#toString has a wrong name
var INCORRECT_NAME = PROPER_FUNCTION_NAME && nativeToString.name != TO_STRING;

// `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring
if (NOT_GENERIC || INCORRECT_NAME) {
  defineBuiltIn(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject(this);
    var pattern = $toString(R.source);
    var flags = $toString(getRegExpFlags(R));
    return '/' + pattern + '/' + flags;
  }, { unsafe: true });
}

var es_parseInt = {};

// a string of all valid unicode whitespaces
var whitespaces$3 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var uncurryThis$5 = functionUncurryThis;
var requireObjectCoercible$1 = requireObjectCoercible$7;
var toString$4 = toString$9;
var whitespaces$2 = whitespaces$3;

var replace$1 = uncurryThis$5(''.replace);
var ltrim = RegExp('^[' + whitespaces$2 + ']+');
var rtrim = RegExp('(^|[^' + whitespaces$2 + '])[' + whitespaces$2 + ']+$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod = function (TYPE) {
  return function ($this) {
    var string = toString$4(requireObjectCoercible$1($this));
    if (TYPE & 1) string = replace$1(string, ltrim, '');
    if (TYPE & 2) string = replace$1(string, rtrim, '$1');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod(3)
};

var global$3 = global$g;
var fails$2 = fails$h;
var uncurryThis$4 = functionUncurryThis;
var toString$3 = toString$9;
var trim$1 = stringTrim.trim;
var whitespaces$1 = whitespaces$3;

var $parseInt$1 = global$3.parseInt;
var Symbol$2 = global$3.Symbol;
var ITERATOR$1 = Symbol$2 && Symbol$2.iterator;
var hex = /^[+-]?0x/i;
var exec = uncurryThis$4(hex.exec);
var FORCED$2 = $parseInt$1(whitespaces$1 + '08') !== 8 || $parseInt$1(whitespaces$1 + '0x16') !== 22
  // MS Edge 18- broken with boxed symbols
  || (ITERATOR$1 && !fails$2(function () { $parseInt$1(Object(ITERATOR$1)); }));

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
var numberParseInt = FORCED$2 ? function parseInt(string, radix) {
  var S = trim$1(toString$3(string));
  return $parseInt$1(S, (radix >>> 0) || (exec(hex, S) ? 16 : 10));
} : $parseInt$1;

var $$3 = _export;
var $parseInt = numberParseInt;

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
$$3({ global: true, forced: parseInt != $parseInt }, {
  parseInt: $parseInt
});

var es_number_toFixed = {};

var uncurryThis$3 = functionUncurryThis;

// `thisNumberValue` abstract operation
// https://tc39.es/ecma262/#sec-thisnumbervalue
var thisNumberValue$1 = uncurryThis$3(1.0.valueOf);

'use strict';
var toIntegerOrInfinity$1 = toIntegerOrInfinity$5;
var toString$2 = toString$9;
var requireObjectCoercible = requireObjectCoercible$7;

var $RangeError$1 = RangeError;

// `String.prototype.repeat` method implementation
// https://tc39.es/ecma262/#sec-string.prototype.repeat
var stringRepeat = function repeat(count) {
  var str = toString$2(requireObjectCoercible(this));
  var result = '';
  var n = toIntegerOrInfinity$1(count);
  if (n < 0 || n == Infinity) throw $RangeError$1('Wrong number of repetitions');
  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
  return result;
};

'use strict';
var $$2 = _export;
var uncurryThis$2 = functionUncurryThis;
var toIntegerOrInfinity = toIntegerOrInfinity$5;
var thisNumberValue = thisNumberValue$1;
var $repeat = stringRepeat;
var fails$1 = fails$h;

var $RangeError = RangeError;
var $String = String;
var floor = Math.floor;
var repeat = uncurryThis$2($repeat);
var stringSlice$1 = uncurryThis$2(''.slice);
var nativeToFixed = uncurryThis$2(1.0.toFixed);

var pow = function (x, n, acc) {
  return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);
};

var log = function (x) {
  var n = 0;
  var x2 = x;
  while (x2 >= 4096) {
    n += 12;
    x2 /= 4096;
  }
  while (x2 >= 2) {
    n += 1;
    x2 /= 2;
  } return n;
};

var multiply = function (data, n, c) {
  var index = -1;
  var c2 = c;
  while (++index < 6) {
    c2 += n * data[index];
    data[index] = c2 % 1e7;
    c2 = floor(c2 / 1e7);
  }
};

var divide = function (data, n) {
  var index = 6;
  var c = 0;
  while (--index >= 0) {
    c += data[index];
    data[index] = floor(c / n);
    c = (c % n) * 1e7;
  }
};

var dataToString = function (data) {
  var index = 6;
  var s = '';
  while (--index >= 0) {
    if (s !== '' || index === 0 || data[index] !== 0) {
      var t = $String(data[index]);
      s = s === '' ? t : s + repeat('0', 7 - t.length) + t;
    }
  } return s;
};

var FORCED$1 = fails$1(function () {
  return nativeToFixed(0.00008, 3) !== '0.000' ||
    nativeToFixed(0.9, 0) !== '1' ||
    nativeToFixed(1.255, 2) !== '1.25' ||
    nativeToFixed(1000000000000000128.0, 0) !== '1000000000000000128';
}) || !fails$1(function () {
  // V8 ~ Android 4.3-
  nativeToFixed({});
});

// `Number.prototype.toFixed` method
// https://tc39.es/ecma262/#sec-number.prototype.tofixed
$$2({ target: 'Number', proto: true, forced: FORCED$1 }, {
  toFixed: function toFixed(fractionDigits) {
    var number = thisNumberValue(this);
    var fractDigits = toIntegerOrInfinity(fractionDigits);
    var data = [0, 0, 0, 0, 0, 0];
    var sign = '';
    var result = '0';
    var e, z, j, k;

    // TODO: ES2018 increased the maximum number of fraction digits to 100, need to improve the implementation
    if (fractDigits < 0 || fractDigits > 20) throw $RangeError('Incorrect fraction digits');
    // eslint-disable-next-line no-self-compare -- NaN check
    if (number != number) return 'NaN';
    if (number <= -1e21 || number >= 1e21) return $String(number);
    if (number < 0) {
      sign = '-';
      number = -number;
    }
    if (number > 1e-21) {
      e = log(number * pow(2, 69, 1)) - 69;
      z = e < 0 ? number * pow(2, -e, 1) : number / pow(2, e, 1);
      z *= 0x10000000000000;
      e = 52 - e;
      if (e > 0) {
        multiply(data, 0, z);
        j = fractDigits;
        while (j >= 7) {
          multiply(data, 1e7, 0);
          j -= 7;
        }
        multiply(data, pow(10, j, 1), 0);
        j = e - 1;
        while (j >= 23) {
          divide(data, 1 << 23);
          j -= 23;
        }
        divide(data, 1 << j);
        multiply(data, 1, 1);
        divide(data, 2);
        result = dataToString(data);
      } else {
        multiply(data, 0, z);
        multiply(data, 1 << -e, 0);
        result = dataToString(data) + repeat('0', fractDigits);
      }
    }
    if (fractDigits > 0) {
      k = result.length;
      result = sign + (k <= fractDigits
        ? '0.' + repeat('0', fractDigits - k) + result
        : stringSlice$1(result, 0, k - fractDigits) + '.' + stringSlice$1(result, k - fractDigits));
    } else {
      result = sign + result;
    } return result;
  }
});

var es_parseFloat = {};

var global$2 = global$g;
var fails = fails$h;
var uncurryThis$1 = functionUncurryThis;
var toString$1 = toString$9;
var trim = stringTrim.trim;
var whitespaces = whitespaces$3;

var charAt = uncurryThis$1(''.charAt);
var $parseFloat$1 = global$2.parseFloat;
var Symbol$1 = global$2.Symbol;
var ITERATOR = Symbol$1 && Symbol$1.iterator;
var FORCED = 1 / $parseFloat$1(whitespaces + '-0') !== -Infinity
  // MS Edge 18- broken with boxed symbols
  || (ITERATOR && !fails(function () { $parseFloat$1(Object(ITERATOR)); }));

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
var numberParseFloat = FORCED ? function parseFloat(string) {
  var trimmedString = trim(toString$1(string));
  var result = $parseFloat$1(trimmedString);
  return result === 0 && charAt(trimmedString, 0) == '-' ? -0 : result;
} : $parseFloat$1;

var $$1 = _export;
var $parseFloat = numberParseFloat;

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
$$1({ global: true, forced: parseFloat != $parseFloat }, {
  parseFloat: $parseFloat
});

var es_symbol_description = {};

var makeBuiltIn = makeBuiltInExports;
var defineProperty = objectDefineProperty;

var defineBuiltInAccessor$1 = function (target, name, descriptor) {
  if (descriptor.get) makeBuiltIn(descriptor.get, name, { getter: true });
  if (descriptor.set) makeBuiltIn(descriptor.set, name, { setter: true });
  return defineProperty.f(target, name, descriptor);
};

// `Symbol.prototype.description` getter
// https://tc39.es/ecma262/#sec-symbol.prototype.description
'use strict';
var $ = _export;
var DESCRIPTORS = descriptors;
var global$1 = global$g;
var uncurryThis = functionUncurryThis;
var hasOwn = hasOwnProperty_1;
var isCallable = isCallable$d;
var isPrototypeOf = objectIsPrototypeOf;
var toString = toString$9;
var defineBuiltInAccessor = defineBuiltInAccessor$1;
var copyConstructorProperties = copyConstructorProperties$2;

var NativeSymbol = global$1.Symbol;
var SymbolPrototype = NativeSymbol && NativeSymbol.prototype;

if (DESCRIPTORS && isCallable(NativeSymbol) && (!('description' in SymbolPrototype) ||
  // Safari 12 bug
  NativeSymbol().description !== undefined
)) {
  var EmptyStringDescriptionStore = {};
  // wrap Symbol constructor for correct work with undefined description
  var SymbolWrapper = function Symbol() {
    var description = arguments.length < 1 || arguments[0] === undefined ? undefined : toString(arguments[0]);
    var result = isPrototypeOf(SymbolPrototype, this)
      ? new NativeSymbol(description)
      // in Edge 13, String(Symbol(undefined)) === 'Symbol(undefined)'
      : description === undefined ? NativeSymbol() : NativeSymbol(description);
    if (description === '') EmptyStringDescriptionStore[result] = true;
    return result;
  };

  copyConstructorProperties(SymbolWrapper, NativeSymbol);
  SymbolWrapper.prototype = SymbolPrototype;
  SymbolPrototype.constructor = SymbolWrapper;

  var NATIVE_SYMBOL = String(NativeSymbol('test')) == 'Symbol(test)';
  var thisSymbolValue = uncurryThis(SymbolPrototype.valueOf);
  var symbolDescriptiveString = uncurryThis(SymbolPrototype.toString);
  var regexp = /^Symbol\((.*)\)[^)]+$/;
  var replace = uncurryThis(''.replace);
  var stringSlice = uncurryThis(''.slice);

  defineBuiltInAccessor(SymbolPrototype, 'description', {
    configurable: true,
    get: function description() {
      var symbol = thisSymbolValue(this);
      if (hasOwn(EmptyStringDescriptionStore, symbol)) return '';
      var string = symbolDescriptiveString(symbol);
      var desc = NATIVE_SYMBOL ? stringSlice(string, 7, -1) : replace(string, regexp, '$1');
      return desc === '' ? undefined : desc;
    }
  });

  $({ global: true, constructor: true, forced: true }, {
    Symbol: SymbolWrapper
  });
}

// noinspection JSUnusedGlobalSymbols

/**
 * eGroupWare egw_action framework - egw action framework
 *
 * @link http://www.egroupware.org
 * @author Andreas Stöckel <as@stylite.de>
 * @copyright 2011 by Andreas Stöckel
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package egw_action
 */

//State bitmask (only use powers of two for new states!)

var EGW_AO_STATE_NORMAL = 0x00;
var EGW_AO_STATE_SELECTED = 0x01;
var EGW_AO_STATE_FOCUSED = 0x02;
var EGW_AO_STATE_VISIBLE = 0x04; //< Can only be set by the AOI, means that the object is attached to the DOM-Tree and visible
var EGW_AO_STATE_DRAGGING = 0x08;
var EGW_AO_EVENT_DRAG_OVER_ENTER = 0x00;
var EGW_AO_EVENT_DRAG_OVER_LEAVE = 0x01;

// No shift key is pressed
var EGW_AO_SHIFT_STATE_NONE = 0x00;
// A shift key, which allows multi-selection is pressed (usually CTRL on a PC keyboard)
var EGW_AO_SHIFT_STATE_MULTI = 0x01;
// A shift key is pressed, which forces block-wise selection (SHIFT on a PC keyboard)
var EGW_AO_SHIFT_STATE_BLOCK = 0x02;

// If this flag is set, this object will not be returned as "focused". If this
// flag is not applied to container objects, it may lead to some strange behaviour.
var EGW_AO_FLAG_IS_CONTAINER = 0x01;

// If this flag is set, the object will get its focus when no other object is
// selected and e.g. a key is pressed.
var EGW_AO_FLAG_DEFAULT_FOCUS = 0x02;
var EGW_AI_DRAG = 0x0100; // Use the first byte as mask for event types - 01 is for events used with drag stuff
var EGW_AI_DRAG_OUT = EGW_AI_DRAG | 0x01;
var EGW_AI_DRAG_OVER = EGW_AI_DRAG | 0x02;
var EGW_AI_DRAG_ENTER = EGW_AI_DRAG | 0x03;
var EGW_AO_EXEC_SELECTED = 0;
var EGW_AO_EXEC_THIS = 1;

/**
 * Define the key constants (IE doesn't support "const" keyword)
 */

var EGW_KEY_BACKSPACE = 8;
var EGW_KEY_TAB = 9;
var EGW_KEY_ENTER = 13;
var EGW_KEY_ESCAPE = 27;
var EGW_KEY_DELETE = 46;
var EGW_KEY_SPACE = 32;
var EGW_KEY_PAGE_UP = 33;
var EGW_KEY_PAGE_DOWN = 34;
var EGW_KEY_ARROW_LEFT = 37;
var EGW_KEY_ARROW_UP = 38;
var EGW_KEY_ARROW_RIGHT = 39;
var EGW_KEY_ARROW_DOWN = 40;
var EGW_KEY_0 = 48;
var EGW_KEY_1 = 49;
var EGW_KEY_2 = 50;
var EGW_KEY_3 = 51;
var EGW_KEY_4 = 52;
var EGW_KEY_5 = 53;
var EGW_KEY_6 = 54;
var EGW_KEY_7 = 55;
var EGW_KEY_8 = 56;
var EGW_KEY_9 = 57;
var EGW_KEY_A = 65;
var EGW_KEY_B = 66;
var EGW_KEY_C = 67;
var EGW_KEY_D = 68;
var EGW_KEY_E = 69;
var EGW_KEY_F = 70;
var EGW_KEY_G = 71;
var EGW_KEY_H = 72;
var EGW_KEY_I = 73;
var EGW_KEY_J = 74;
var EGW_KEY_K = 75;
var EGW_KEY_L = 76;
var EGW_KEY_M = 77;
var EGW_KEY_N = 78;
var EGW_KEY_O = 79;
var EGW_KEY_P = 80;
var EGW_KEY_Q = 81;
var EGW_KEY_R = 82;
var EGW_KEY_S = 83;
var EGW_KEY_T = 84;
var EGW_KEY_U = 85;
var EGW_KEY_V = 86;
var EGW_KEY_W = 87;
var EGW_KEY_X = 88;
var EGW_KEY_Y = 89;
var EGW_KEY_Z = 90;
var EGW_KEY_MENU = 93;
var EGW_KEY_F1 = 112;
var EGW_KEY_F2 = 113;
var EGW_KEY_F3 = 114;
var EGW_KEY_F4 = 115;
var EGW_KEY_F5 = 116;
var EGW_KEY_F6 = 117;
var EGW_KEY_F7 = 118;
var EGW_KEY_F8 = 119;
var EGW_KEY_F9 = 120;
var EGW_KEY_F10 = 121;
var EGW_KEY_F11 = 122;
var EGW_KEY_F12 = 123;
var EGW_VALID_KEYS = [8, 9, 13, 27, 46, 32, 33, 34, 37, 38, 39, 40, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 93, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123];

function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
// this import breaks shoelace with ("Illegal constructor (custom element class must be registered with global customElements registry to be newable)"); in SlAvatar
//et2 also has this import without problems
//import {egw} from "../jsapi/egw_global.js";
/**
 * Sets properties given in _data in _obj. Checks whether the property keys
 * exists and if corresponding setter functions are available. Properties starting
 * with "_" are ignored.
 *
 * @param  _data may be an object with data that will be stored inside the
 *    given object.
 * @param  _obj is the object where the data will be stored.
 * @param  _setterOnly false: store everything, true: only store when setter function exists, "data" store rest in data property
 */
function egwActionStoreJSON(_data, _obj, _setterOnly) {
  for (var key in _data) {
    if (key.charAt(0) != '_') {
      //Check whether there is a setter function available
      if (typeof _obj['set_' + key] == "function") {
        _obj['set_' + key](_data[key]);
      } else if (typeof _obj[key] != "undefined" && !_setterOnly) {
        _obj[key] = _data[key];
      } else if (_setterOnly === 'data') {
        if (typeof _data.data == 'undefined') _data.data = {};
        _data.data[key] = _data[key];
        _obj.set_data(_data.data);
      }
    }
  }
}

/**
 * Switches the given bit in the set on or off.
 * only iff _bit is exponent of 2; 2^^i means i_th bit from the right will be set
 * might switch all bits of _set, depending on _bit
 *
 * @param _set is the current set
 * @param  _bit is the position of the bit which should be switched on/off
 * @param  _state is whether the bit should be switched on or off
 * @returns the new set
 */
function egwSetBit(_set, _bit, _state) {
  if (_state) return _set | _bit;else return _set & ~_bit;
}

/**
 * Returns whether the given bit is set in the set.
 */
function egwBitIsSet(_set, _bit) {
  return (_set & _bit) > 0;
}
function egwObjectLength(_obj) {
  var len = 0;
  for (var k in _obj) len++;
  return len;
}

/**
 * Isolates the shift state from an event object
 */
function egwGetShiftState(e) {
  var state = EGW_AO_SHIFT_STATE_NONE;
  state = egwSetBit(state, EGW_AO_SHIFT_STATE_MULTI, e.ctrlKey || e.metaKey);
  state = egwSetBit(state, EGW_AO_SHIFT_STATE_BLOCK, e.shiftKey);
  return state;
}
function egwPreventSelect(e) {
  if (egwGetShiftState(e) > EGW_AO_SHIFT_STATE_NONE) {
    this.onselectstart = function () {
      return false;
    };
    return false;
  }
  return true;
}
function egwUnfocus() {
  //TODO
  if (document.activeElement) {
    try {
      document.activeElement.blur();
    } catch (e) {
      //console.log("Can't be unfocused because active element isn't an HTMLElement")
    }
  }
}

// function never used
// export function egwCallAbstract(_obj: any, _fn: { apply: (arg0: any, arg1: any) => any; }, _args: any) {
//     if (_fn) {
//         return _fn.apply(_obj, _args);
//     } else {
//         throw "egw_action Exception: Abstract function call in JS code.";
//     }
// }

//never used
// export function egwArraysEqual(_ar1, _ar2) {
//     var result = _ar1.length == _ar2.length;
//
//     for (var i = 0; i < _ar1.length; i++) {
//         result = result && (_ar1[i] == _ar2[i])
//     }
//
//     return result;
// }

var _egwQueuedCallbacks = {};
function egwQueueCallback(_proc, _args, _context, _id) {
  if (_proc) {
    var cur_id = 0;
    if (typeof _egwQueuedCallbacks[_id] == "undefined") {
      cur_id = _egwQueuedCallbacks[_id] = 1;
    } else {
      cur_id = ++_egwQueuedCallbacks[_id];
    }
    window.setTimeout(function () {
      if (_egwQueuedCallbacks[_id] == cur_id) {
        _proc.apply(_context, _args);
        delete _egwQueuedCallbacks[_id];
      }
    }, 0);
  }
}

/**
 * The eventQueue object is used to have control over certain events such as
 * ajax responses or timeouts. Sometimes it may happen, that a function attached
 * to such an event should no longer be called - with egwEventQueue one has
 * a simple possibility to control that.
 */

//egwEventQueue is never used
//
// /**
//  * Constructor for the egwEventQueue class. Initializes the queue object and the
//  * internal data structures such as the internal key.
//  */
// export function egwEventQueue() {
//     this.events = {};
//     this.key_id = 0;
// }
//
// /**
//  * Flushes all queued events - all events which had been queued in this queue objects
//  * can no longer be ran by calling egwEventQueue.run
//  */
// egwEventQueue.prototype.flush = function () {
//     this.events = {};
// }
//
// /**
//  * Queues the given function. A key is returned which can be passed to the "run"
//  * function which will then run the passed function.
//  *
//  * @param function _proc is the funciton which should be called
//  * @param object _context is the context in which the function should be called
//  * @param array _args is an optional array of parameters which should be passed
//  *    to the function. Defaults to an emtpy array.
//  * @param string _id is an optional id which can be used to identify the event (may
//  *    also be a key returned by this funciton). If the queue function is called multiple
//  *    times for a given _id, the so called "call counter" of the event will be incremented.
//  *    Each time "run" is called for a given event, the "call counter" will be decremented.
//  *    Only if it reaches 0, the function connected to the event will be executed.
//  *
//  * @returns string the key which has to be passed to the "run" function.
//  */
// egwEventQueue.prototype.queue = function (_proc, _context, _args, _id) {
//     // Default _args to an empty array
//     if (typeof _args == "undefined" || !(_args instanceof Array)) {
//         _args = [];
//     }
//
//     // Increment the queue key which is used to store the event objectes with
//     // a unique key
//     this.key_id++;
//
//     var key = "";
//
//     // _id must be a string and evaluate to true - if this is not
//     // generate an unique key.
//     if (typeof _id != "string" || !_id) {
//         key = "ev_" + this.key_id;
//     } else {
//         key = _id;
//     }
//
//     // Check whether an queued event with the given id already exists
//     var cnt = 1;
//     if (typeof this.events[key] != "undefined") {
//         // The specified event already existed - increment the call counter.
//         cnt = this.events[key].cnt + 1;
//     }
//
//     // Generate the event object
//     this.events[key] = {
//         "proc": _proc,
//         "context": _context,
//         "args": _args,
//         "cnt": cnt
//     }
//
//     // Return the key which has to be passed to the "run" function in order to
//     // run the specified function
//     return key;
// }
//
// /**
//  * Runs the event specified by the given key. The key is the string which had been
//  * returned by the queue function.
//  */
// egwEventQueue.prototype.run = function (_key) {
//     // Check whether the given key exists
//     if (typeof this.events[_key] != "undefined") {
//         // Fetch the event object
//         var eventObj = this.events[_key];
//
//         // Decrement the call counter
//         eventObj.cnt--;
//
//         // Only run the event if the call counter has reached zero
//         if (eventObj.cnt == 0) {
//             // Run the event
//             eventObj.proc.apply(eventObj.context, eventObj.args);
//
//             // Delete the given key from the event set
//             delete this.events[_key];
//         }
//     }
// }
//
// /**
//  * Does the same as "queue" but runs the event after the given timeout.
//  */
// egwEventQueue.prototype.queueTimeout = function (_proc, _context, _args, _id, _timeout) {
//     // Create the queue entry
//     var key = this.queue(_proc, _context, _args, _id);
//
//     // Run the event in the setTimeout event.
//     var self = this;
//     window.setTimeout(function () {
//         self.run(key);
//     }, _timeout)
// }

/**
 * @deprecated use class EgwFnct instead
 */
/**
 * Class which is used to be able to handle references to JavaScript functions
 * from strings.
 *
 * @param object _context is the context in which the function will be executed.
 * @param mixed _default is the default value which should be returned when no
 *    function (string) has been set. If it is a function this function will be
 *    called.
 * @param array _acceptedTypes is an array of types which contains the "typeof"
 *    strings of accepted non-functions in setValue
 */
class EgwFnct {
  /**
   * @deprecated please use functionToPerform instead
   */
  get fnct() {
    return this.functionToPerform;
  }
  constructor() {
    var _context = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var _default = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var _acceptedTypes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ["boolean"];
    _defineProperty(this, "context", void 0);
    _defineProperty(this, "acceptedTypes", void 0);
    _defineProperty(this, "functionToPerform", void 0);
    _defineProperty(this, "value", void 0);
    // Flag for if this action is using a default handler
    // I don't think this is ever used @unused
    _defineProperty(this, "isDefault", void 0);
    /**
     * @returns true iff there is a function to perform and is not default
     */
    _defineProperty(this, "hasHandler", () => this.functionToPerform !== null && !this.isDefault);
    this.context = _context;
    this.acceptedTypes = _acceptedTypes;
    this.functionToPerform = null;
    this.value = null;
    this.isDefault = false;
    this.setValue(_default);
  }
  clone() {
    return new EgwFnct(this.context, this.functionToPerform || this.value, this.acceptedTypes);
  }
  /**
   * Sets the function/return value for the exec function
   * egw_action hints that value has to be on of 3:
   * 1. _value may be a string with the word "javaScript:" prefixed. The function
   *       which is specified behind the colon and which has to be in the global scope
   *       will be executed.
   *    2. _value may be a boolean, which specifies whether the external onExecute handler
   *       (passed as "_handler" in the constructor) will be used.
   *    3. _value may be a JS function which will then be called.
   */
  setValue(_value) {
    this.value = null;
    this.functionToPerform = null;

    // Actual function
    if (typeof _value == "function") {
      this.functionToPerform = _value;
    } else if (typeof _value == "string" && _value.substring(0, 11) === 'javaScript:') {
      this.functionToPerform = function () {
        var manager = this.context && this.context.getManager ? this.context.getManager() : null;
        return window.egw.applyFunc(_value.substring(11), arguments, (manager ? manager.data.context : null) || window);
      };
    } else if (this.acceptedTypes.includes(typeof _value)) {
      this.value = _value;
    } // Something, but could not figure it out
    else if (_value) {
      //egw.debug("warn", "Unable to parse Exec function %o for action '%s'", _value, this.context.id);
    }
  }

  /**
   * Executes the function
   */
  exec() {
    if (this.functionToPerform) {
      return this.functionToPerform.apply(this.context, arguments);
    } else {
      return this.value;
    }
  }
}

/**
 * @deprecated use upperCase class instead
 */
class egwFnct extends EgwFnct {}

/**
 * Checks whether this is currently run on a mobile browser
 */
var _egw_mobileBrowser = null;
function egwIsMobile$1() {
  if (_egw_mobileBrowser == null) {
    var ua = navigator.userAgent;
    _egw_mobileBrowser = !!(ua.match(/iPhone/i) || ua.match(/iPad/i) || ua.match(/iPod/) || ua.match(/Android/i) || ua.match(/SymbianOS/i));
  }
  return _egw_mobileBrowser;
}
window.egwIsMobile = egwIsMobile$1;

/**
 sprintf() for JavaScript 0.6

 Copyright (c) Alexandru Marasteanu <alexaholic [at) gmail (dot] com>
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.
 * Neither the name of sprintf() for JavaScript nor the
 names of its contributors may be used to endorse or promote products
 derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Alexandru Marasteanu BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


 Changelog:
 2007.04.03 - 0.1:
 - initial release
 2007.09.11 - 0.2:
 - feature: added argument swapping
 2007.09.17 - 0.3:
 - bug fix: no longer throws exception on empty paramenters (Hans Pufal)
 2007.10.21 - 0.4:
 - unit test and patch (David Baird)
 2010.05.09 - 0.5:
 - bug fix: 0 is now preceeded with a + sign
 - bug fix: the sign was not at the right position on padded results (Kamal Abdali)
 - switched from GPL to BSD license
 2010.05.22 - 0.6:
 - reverted to 0.4 and fixed the bug regarding the sign of the number 0
 Note:
 Thanks to Raphael Pigulla <raph (at] n3rd [dot) org> (http://www.n3rd.org/)
 who warned me about a bug in 0.5, I discovered that the last update was
 a regress. I appologize for that.
 **/
function str_repeat(i, m) {
  for (var o = []; m > 0; o[--m] = i);
  return o.join('');
}
function sprintf() {
  var i = 0,
    a,
    f = arguments[i++],
    o = [],
    m,
    p,
    c,
    x,
    s = '';
  while (f) {
    if (m = /^[^\x25]+/.exec(f)) {
      o.push(m[0]);
    } else if (m = /^\x25{2}/.exec(f)) {
      o.push('%');
    } else if (m = /^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(f)) {
      if ((a = arguments[m[1] || i++]) == null || a == undefined) {
        throw 'Too few arguments.';
      }
      if (/[^s]/.test(m[7]) && typeof a != 'number') {
        throw 'Expecting number but found ' + typeof a;
      }
      switch (m[7]) {
        case 'b':
          a = a.toString(2);
          break;
        case 'c':
          a = String.fromCharCode(a);
          break;
        case 'd':
          a = parseInt(a);
          break;
        case 'e':
          a = m[6] ? a.toExponential(m[6]) : a.toExponential();
          break;
        case 'f':
          a = m[6] ? parseFloat(a).toFixed(m[6]) : parseFloat(a);
          break;
        case 'o':
          a = typeof a == 'number' ? a.toString(8) : JSON.stringify(a);
          break;
        case 's':
          a = (a = String(a)) && m[6] ? a.substring(0, m[6]) : a;
          break;
        case 'u':
          a = Math.abs(a);
          break;
        case 'x':
          a = a.toString(16);
          break;
        case 'X':
          a = a.toString(16).toUpperCase();
          break;
      }
      a = /[def]/.test(m[7]) && m[2] && a >= 0 ? '+' + a : a;
      c = m[3] ? m[3] == '0' ? '0' : m[3].charAt(1) : ' ';
      x = m[5] - String(a).length - s.length;
      p = m[5] ? str_repeat(c, x) : '';
      o.push(s + (m[4] ? a + p : p + a));
    } else {
      throw 'Invalid sprintf format "' + arguments[0] + '"';
    }
    f = f.substring(m[0].length);
  }
  return o.join('');
}

/**
 * EGroupware clientside API object
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link https://www.egroupware.org
 * @author Andreas Stöckel (as AT stylite.de)
 * @author Ralf Becker <RalfBecker@outdoor-training.de>
 */

/*egw:uses
	egw_core;
	egw_debug;
	egw_preferences;
	egw_lang;
	egw_links;
	egw_open;
	egw_user;
	egw_config;
	egw_images;
	egw_jsonq;
	egw_files;
	egw_json;
	egw_store;
	egw_tooltip;
	egw_css;
	egw_calendar;
	egw_ready;
	egw_data;
	egw_tail;
	egw_inheritance;
	egw_message;
	egw_notification;
*/

/**
 * Object to collect instantiated application objects
 *
 * Attributes classes collects loaded application classes,
 * which can get instantiated:
 *
 *	app[appname] = new app.classes[appname]();
 *
 * On destruction only app[appname] gets deleted, app.classes[appname] need to be used again!
 *
 * @type object
 */
window.app = {classes: {}};

(function()
{
	"use strict";

	var debug = false;
	var egw_script = document.getElementById('egw_script_id');
	var start_time = (new Date).getTime();
	if(typeof console != "undefined" && console.time) console.time("egw");

	// set opener as early as possible for framework popups (not real popups)
	if (!window.opener && window.parent !== window)
	{
		try {
			if (window.parent.framework && typeof window.parent.framework.popup_idx == 'function' &&
				window.parent.framework.popup_idx.call(window.parent.framework, window) !== undefined)
			{
				window.opener = window.parent;
			}
		}
		catch(e) {
			// ignore SecurityError exception if opener is different security context / cross-origin
		}
	}
	// Flag for if this is opened in a popup
	var popup = (window.opener != null);

	window.egw_webserverUrl = egw_script.getAttribute('data-url');
	window.egw_appName = egw_script.getAttribute('data-app');

	// split includes in legacy js and modules
	const legacy_js_regexp = /\/dhtmlx|jquery-ui|^etemplate\/|^phpbrain\/|^phpgwapi\//;

	// check if egw object was injected by window open
	if (typeof window.egw == 'undefined')
	{
		try {
			// try finding it in top or opener's top
			if (window.opener && typeof window.opener.top.egw != 'undefined')
			{
				window.egw = window.opener.top.egw;
				if (typeof window.opener.top.framework != 'undefined') window.framework = window.opener.top.framework;
				popup = true;
				if (debug) console.log('found egw object in opener');
			}
		}
		catch(e) {
			// ignore SecurityError exception if opener is different security context / cross-origin
		}
		try {
			// try finding it in top
			if (typeof window.egw == 'undefined' && window.top && typeof window.top.egw != 'undefined')
			{
				window.egw = window.top.egw;
				if (typeof window.top.framework != 'undefined') window.framework = window.top.framework;
				if (debug) console.log('found egw object in top');
			}
		}
		catch(e) {
			// ignore SecurityError exception if top is different security context / cross-origin
		}
		if (typeof window.egw == 'undefined')
		{
			window.egw = {
				prefsOnly: true,
				legacy_js_regexp: legacy_js_regexp,
				webserverUrl: egw_webserverUrl
			};
			if (debug) console.log('creating new egw object');
		}
	}
	else if (debug) console.log('found injected egw object');

	var include = JSON.parse(egw_script.getAttribute('data-include')) || [];

	// check for a framework object
	if (typeof window.framework == 'undefined')
	{
		try {
			// try finding it in top or opener's top
			if (window.opener && typeof window.opener.top.framework != 'undefined')
			{
				window.framework = window.opener.top.framework;
				if (debug) console.log('found framework object in opener top');
			}
		}
		catch(e) {
			// ignore SecurityError exception if opener is different security context / cross-origin
		}
		try {
			if (typeof window.framework == 'undefined' && window.top && typeof window.top.framework != 'undefined')
			{
				window.framework = window.top.framework;
				if (debug) console.log('found framework object in top');
			}
		}
		catch(e) {
			// ignore SecurityError exception if top is different security context / cross-origin
		}
		// if framework not found, but requested to check for it, redirect to cd=yes to create it
		var check_framework = egw_script.getAttribute('data-check-framework');
		if (typeof window.framework == 'undefined' &&
			!window.location.pathname.match(/\/(registration\/|smallpart\/|login.php)/) && // not for login page
			!window.location.search.match(/[&?]cd=/) &&
			// for popups check if required files are not about to be loaded (saved additional redirect and fixes LTI launches)
			(check_framework || include.filter(function(_uri){return _uri.match(/api\/(config|user)\.php/);}).length < 2))
		{
			window.location.search += (window.location.search ? "&" : "?")+(check_framework ? "cd=yes" : "cd=popup");
		}
	}
	try {
		if (typeof egw == 'function') egw(window).message;
	}
	catch (e) {
		console.log('Security exception accessing window specific egw object --> creating new one', e);
		window.egw = {
			prefsOnly: true,
			legacy_js_regexp: legacy_js_regexp,
			webserverUrl: egw_webserverUrl
		};
	}
	// set top window in egw object
	if (typeof window.egw.top === "undefined")
	{
		window.egw.top = window;
	}

	// Register unload listener for cleanup
	if (popup)
	{
		// Uncomment this to debug pagehide events
		// window.onpagehide = (e) => {	debugger;};
		window.addEventListener("pagehide", (e) =>
		{
			window.framework = null;
			window.egw = null;
		});
	}

	// focus window / call window.focus(), if data-window-focus is specified
	var window_focus = egw_script.getAttribute('data-window-focus');
	if (window_focus && JSON.parse(window_focus))
	{
		window.focus();
	}

	/**
	 * Import JavaScript legacy code: global scope, non-strict and executed in order
	 *
	 * @param String|Array _src
	 * @param String|undefined _baseurl
	 * @return {Promise<Promise<unknown>[]>}
	 */
	async function legacy_js_import(_src, _baseurl)
	{
		console.log("Legacy import: ", _src,_baseurl);
		if (!Array.isArray(_src)) _src = [].concat(_src);
		return Promise.all(_src.map(src => {
			return new Promise(function(_resolve, _reject)
			{
				const script = document.createElement('script');
				script.src = (_baseurl ? _baseurl+'/' : '')+src;
				script.async = _src.length === 1;
				script.onload = _resolve;
				script.onerror = _reject;
				document.head.appendChild(script);
			})
				// catch and display, but not stop execution
			.catch((err) => { console.error(src+": "+err.message);});
		}));
	}

	// make our promise global, as legacy code calls egw_LAB.wait which we assign to egw_ready.then
	window.egw_LAB = window.egw_ready =
		legacy_js_import(include.filter((src) => src.match(legacy_js_regexp) !== null), window.egw_webserverUrl)
			.then(() => Promise.all(include.filter((src) => src.match(legacy_js_regexp) === null)	//.reverse()
				.map(rel_src => import(window.egw_webserverUrl+'/'+rel_src)
					.catch((err) => {window.setTimeout(() => {throw err;},0);})
	))).then(() =>
	{
		// We need to override the globalEval to mitigate potential execution of
		// script tag. This issue is relevant to jQuery 1.12.4, we need to check
		// if we still need this after upgrading jQuery.
		jQuery.extend({
			globalEval:function(data){}
		});

		// call egw.link_handler, if attr specified
		var egw_redirect = egw_script.getAttribute('data-egw-redirect');
		if (egw_redirect)
		{
			// set sidebox for tabed templates, we need to set it now, as framework will not resent it!
			var sidebox = egw_script.getAttribute('data-setSidebox');
			if (window.framework && sidebox)
			{
				window.framework.setSidebox.apply(window.framework, JSON.parse(sidebox));
			}
			egw_redirect = JSON.parse(egw_redirect);
			egw.link_handler.apply(egw, egw_redirect);
			return;	// do NOT execute any further code, as IE(11) will give errors because framework already redirects
		}

		// call egw_refresh on opener, if attr specified
		var refresh_opener = egw_script.getAttribute('data-refresh-opener');
		if (refresh_opener && window.opener)
		{
			refresh_opener = JSON.parse(refresh_opener) || {};
			window.opener.egw(window.opener).refresh.apply(egw(window.opener), refresh_opener);
		}

		// close window / call window.close(), if data-window-close is specified
		var window_close = egw_script.getAttribute('data-window-close');
		if (window_close)
		{
			if (typeof window_close == 'string' && window_close !== '1')
			{
				alert(window_close);
			}
			// If there's a message & opener, set it
			if(window.opener && egw_script.getAttribute('data-message'))
			{
				egw(window.opener).message(JSON.parse(egw_script.getAttribute('data-message')));
			}
			egw(window).close();
		}

		// call egw.open_link, if popup attr specified
		var egw_popup = egw_script.getAttribute('data-popup');
		if (egw_popup)
		{
			egw_popup = JSON.parse(egw_popup) || [];
			egw.open_link.apply(egw, egw_popup);
		}

		// set grants if given for push
		var egw_grants = egw_script.getAttribute('data-grants');
		if (egw_grants)
		{
			egw.set_grants(JSON.parse(egw_grants));
		}

		if(typeof console != "undefined" && console.timeEnd) console.timeEnd("egw");
		var end_time = (new Date).getTime();
		var gen_time_div = jQuery('#divGenTime_'+window.egw_appName);
		if (!gen_time_div.length) gen_time_div = jQuery('.pageGenTime');
		var gen_time_async = jQuery('.asyncIncludeTime').length > 0 ? jQuery('.asyncIncludeTime'):
				gen_time_div.append('<span class="asyncIncludeTime"></span>').find('.asyncIncludeTime');
		gen_time_async.text(egw.lang ? egw.lang('async includes took %1s', (end_time - start_time) / 1000) : 'async includes took ' + (end_time - start_time) / 1000);
		gen_time_async = null;

		// Make sure opener knows when we close - start a heartbeat
		try {
			if ((window.opener && window.opener.framework || popup) && window.name != '') {
				// Timeout is 5 seconds, but it iks only applied(egw_utils) when something asks for the window list
				window.setInterval(function () {
					if (window.opener && window.opener.framework && typeof window.opener.framework.popup_idx(window) == 'undefined' && !egwIsMobile()) {
						window.opener.framework.popups.push(window);
					}
					egw().storeWindow(this.egw_appName, this);
				}, 2000);
			}
		}
		catch(e) {
			// ignore SecurityError exception if opener is different security context / cross-origin
		}
		// instantiate app object
		var appname = window.egw_appName;
		if (app && typeof app[appname] != 'object' && typeof app.classes[appname] == 'function')
		{
			app[appname] = new app.classes[appname]();
		}

		// set sidebox for tabed templates
		var sidebox = egw_script.getAttribute('data-setSidebox') || jQuery('#late-sidebox').attr('data-setSidebox');
		if (window.framework && sidebox && sidebox !== 'null')
		{
			window.framework.setSidebox.apply(window.framework, JSON.parse(sidebox));
		}
		sidebox = null;

		var resize_attempt = 0;
		var resize_popup = function()
		{
			var $main_div = jQuery('#popupMainDiv');
			let $et2 = jQuery('.et2_container');
			let $layoutTable = jQuery(".et2_container > * > table", $main_div);
			if ($layoutTable.length && $et2.width() < $layoutTable.width())
			{
				// Still using a layout table, and it's bigger.
				// Use the layout table for width calculation
				$et2 = $layoutTable;
			}
			var w = {
				width: egw_getWindowInnerWidth(),
				height: egw_getWindowInnerHeight()
			};
			// Use et2_container for width since #popupMainDiv is full width, but we still need
			// to take padding/margin into account
			var delta_width = w.width - ($et2.outerWidth(true) + ($main_div.outerWidth(true) - $main_div.width()));
			var delta_height = w.height - ($et2.outerHeight(true) + ($main_div.outerHeight(true) - $main_div.height()));

			// Don't let the window gets horizental scrollbar
			var scrollWidth = document.body.scrollWidth - document.body.clientWidth;
			var scrollHeight = document.body.scrollHeight - w.height;
			if (scrollWidth > 0 && scrollWidth + egw_getWindowOuterWidth() < screen.availWidth) delta_width = -scrollWidth;

			if (delta_height && egw_getWindowOuterHeight() >= egw.availHeight())
			{
				delta_height = 0;
			}
			if((delta_width != 0 || delta_height != 0) &&
				(delta_width > 2 || delta_height > 2 || delta_width < -2 || delta_height < -2))
			{

				if (window.framework && typeof window.framework.resize_popup != 'undefined')
				{
					window.framework.resize_popup($et2.outerWidth(true), $et2.outerHeight(true), window);
				}
				else
				{
					window.resizeTo(egw_getWindowOuterWidth() - delta_width+8, egw_getWindowOuterHeight() - delta_height);
				}
			}
			// trigger a 2. resize, as one is not enough, if window is zoomed
			if (delta_width && ++resize_attempt < 2)
			{
				window.setTimeout(resize_popup, 50);
			}
			else
			{
				resize_attempt = 0;
			}
			$main_div = null;
			$et2 = null;
			$layoutTable = null;
		};

		// rest needs DOM to be ready
		jQuery(function()
		{
			// load etemplate2 template(s)
			document.querySelectorAll('form.et2_container[data-etemplate]').forEach(node =>
			{
				const data = JSON.parse(node.getAttribute('data-etemplate')) || {};
				if (popup || window.opener && !egwIsMobile()) {
					// Resize popup when et2 load is done
					node.addEventListener("load", (event) =>
					{
						// Only the top-level template, not any sub-templates
						if (event.target == node)
						{
							window.setTimeout(resize_popup, 50);
						}
					});
				}
				const et2 = new etemplate2(node, data.data.menuaction);
				et2.load(data.name, data.url, data.data);
				if (typeof data.response !== 'undefined') {
					const json_request = egw(window).json("");
					json_request.handleResponse({response: data.response});
				}
			});

			// Offline/Online checking part
			if (typeof window.Offline != 'undefined')
			{
				Offline.options = {
					// Should we check the connection status immediately on page load.
					checkOnLoad: false,

					// Should we monitor AJAX requests to help decide if we have a connection.
					interceptRequests: true,

					// Should we automatically retest periodically when the connection is down (set to false to disable).
					reconnect: {
					  // How many seconds should we wait before rechecking.
					  initialDelay: 3,

					  // How long should we wait between retries.
					  //delay: (1.5 * last delay, capped at 1 hour)
					},

					// Should we store and attempt to remake requests which fail while the connection is down.
					requests: true,

					checks: {
						xhr: {
							url: egw.webserverUrl+'/api/templates/default/images/favicon.ico?'+Date.now()
						}
					}
				};

				window.Offline.on('down', function(){
					this.loading_prompt('connectionLost', true, '', null);
				}, egw(window));
				window.Offline.on('up', function(){
					jQuery('.close', '#egw_message').click();
					this.loading_prompt('connectionLost', false);
				}, egw(window));
			}

			// set app-header
			if (window.framework && egw_script.getAttribute('data-app-header'))
			{
				egw(window).app_header(egw_script.getAttribute('data-app-header'), appname);
			}
			// display a message
			if (egw_script.getAttribute('data-message'))
			{
				var params = JSON.parse(egw_script.getAttribute('data-message')) || [''];
				egw(window).message.apply(egw(window), params);
			}
			// hide location bar for mobile browsers
			if (egw_script.getAttribute('data-mobile'))
			{
				window.scrollTo(0, 1);
			}
			try {
				// open websocket to push server for our top window
				if (egw === window.top.egw && egw_script.getAttribute('data-websocket-url'))
				{
					egw.json('websocket', {}, undefined, this).openWebSocket(
						egw_script.getAttribute('data-websocket-url'),
						JSON.parse(egw_script.getAttribute('data-websocket-tokens')),
						parseInt(egw_script.getAttribute('data-websocket-account_id'))
					);
				}
			}
			catch(e) {
				// ignore SecurityError exception if top is different security context / cross-origin
			}
		});
	});
	//
	window.egw_LAB.wait = window.egw_ready.then;

	// dispatch egw-is-created event in order to let login.js knows about egw object readiness
	document.dispatchEvent(new Event('egw-is-created'));
	/**
	 *
	 */
	window.callManual = function()
	{
		if (window.framework)
		{
			window.framework.callManual.call(window.framework, window.location.href);
		}
	};
})();

/**
 * Call a function specified by it's name (possibly dot separated, eg. "app.myapp.myfunc")
 *
 * @param {string|Function} _func dot-separated function name
 * @param {mixed} ...args variable number of arguments
 * @returns {Mixed|Promise}
 * @deprecated use egw.callFunc(_func, ...) or egw.applyFunc(_func, args)
 */
window.et2_call = function(_func)
{
	return egw.applyFunc(_func, [].slice.call(arguments, 1), window);
};

/**
 * Main window was reloaded, rejoin
 */
window.egw_rejoin = function ()
{
		window.setTimeout(function ()
	{
		opener.addEventListener("load", () =>
		{
			/* It takes more than just re-setting this.framework to get everything working again, but this helps */
			let reconnecting = egw(this).message("Reconnecting...");
			window.setTimeout(() =>
			{
				opener.console.log("Re-set framework");
				reconnecting.close();
				this.framework = this.opener.framework;
				this.framework.egw_appWindow().console.log("Popup %s rejoined", this.location.href);
			}, 5000);
		});
	}.bind(window), 500);
};
/**
 * Allow egw.json to load JS into popups
 *
 * @param url
 * @returns {Promise<*>}
 */
window.egw_import = function (url)
{
	return import(url);
};

/**
 * EGroupware clientside API object
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link http://www.egroupware.org
 * @author Andreas Stöckel (as AT stylite.de)
 * @author Ralf Becker <RalfBecker@outdoor-training.de>
 * @version $Id$
 */

/**
 * This code setups the egw namespace and adds the "extend" function, which is
 * used by extension modules to inject their content into the egw object.
 */
(function()
{
	"use strict";

	var instanceUid = 0;

	// Some local functions for cloning and merging javascript objects
	function cloneObject(_obj) {
		var result = {};

		for (var key in _obj)
		{
			result[key] = _obj[key];
		}

		return result;
	}

	function mergeObjects(_to, _from) {
		// Extend the egw object
		for (var key in _from)
		{
			_to[key] = _from[key];
		}
	}

	function deleteWhere(_arr, _cond)
	{
		for (var i = _arr.length - 1; i >= 0; i--)
		{
			if (_cond(_arr[i]))
			{
				_arr[i].instance && _arr[i].instance.unregisterAllPlugins();
				_arr.splice(i, 1);
			}
		}
	}

	/**
	 * The getAppModules function returns all application specific api modules
	 * for the given application. If those application specific api instances
	 * were not created yet, the functions creates them.
	 *
	 * @param _egw is a reference to the global _egw instance and is passed as
	 * 	a context to the module instance.
	 * @param _modules is the hash map which contains all module descriptors.
	 * @param _moduleInstances is the the object which contains the application
	 * 	and window specific module instances.
	 * @param _app is the application for which the module instances should get
	 * 	created.
	 */
	function getAppModules(_egw, _modules, _moduleInstances, _app)
	{
		// Check whether the application specific modules for that instance
		// already exists, if not, create it
		if (typeof _moduleInstances.app[_app] === 'undefined')
		{
			var modInsts = {};
			_moduleInstances.app[_app] = modInsts;

			// Otherwise create the application specific instances
			for (var key in _modules)
			{
				var mod = _modules[key];

				// Check whether the module is actually an application local
				// instance. As the module instance may already have been
				// created by another extension (when calling the egw.module
				// function) we're doing the second check.
				if (mod.flags === _egw.MODULE_APP_LOCAL
				    && typeof modInsts[key] === 'undefined')
				{
					modInsts[key] = mod.code.call(_egw, _app, window);
				}
			}
		}

		return _moduleInstances.app[_app];
	}

	function getExistingWndModules(_moduleInstances, _window)
	{
		// Search for the specific window instance
		for (var i = 0; i < _moduleInstances.wnd.length; i++)
		{
			if (_moduleInstances.wnd[i].window === _window)
			{
				return _moduleInstances.wnd[i].modules;
			}
		}

		return null;
	}

	/**
	 * The getWndModules function returns all window specific api modules for
	 * the given window. If those window specific api instances were not created
	 * yet, the functions creates them.
	 *
	 * @param _egw is a reference to the global _egw instance and is passed as
	 * 	a context to the module instance.
	 * @param _modules is the hash map which contains all module descriptors.
	 * @param _moduleInstances is the the object which contains the application
	 * 	and window specific module instances.
	 * @param _instances refers to all api instances.
	 * @param _window is the window for which the module instances should get
	 * 	created.
	 */
	function getWndModules(_egw, _modules, _moduleInstances, _instances, _window)
	{
		var mods = getExistingWndModules(_moduleInstances, _window);
		if (mods) {
			return mods;
		}

		// If none was found, create the slot
		mods = {};
		_moduleInstances.wnd.push({
			'window': _window,
			'modules': mods
		});

		// Add an eventlistener for the "onunload" event -- if "onunload" gets
		// called, we have to delete the module slot created above
		var fnct = function() {
			cleanupEgwInstances(_instances, _moduleInstances, function(_w) {
				return _w.window === _window;
			});
		};
		if (_window.attachEvent)
		{
			_window.attachEvent('onbeforeunload', fnct);
		}
		else
		{
			_window.addEventListener('beforeunload', fnct, false);
		}

		// Otherwise create the window specific instances
		for (var key in _modules)
		{
			var mod = _modules[key];

			// Check whether the module is actually a window local instance. As
			// the module instance may already have been created by another
			// extension (when calling the egw.module function) we're doing the
			// second check.
			if (mod.flags === _egw.MODULE_WND_LOCAL
			    && typeof mods[key] === 'undefined')
			{
				mods[key] = mod.code.call(_egw, null, _window);
			}
		}

		return mods;
	}

	/**
	 * Creates an api instance for the given application and the given window.
	 *
	 * @param {globalEgw} _egw is the global _egw instance which should be used.
	 * @param {object} _modules is the hash map which contains references to all module
	 * 	descriptors.
	 * @param {object} _moduleInstances is the the object which contains the application
	 * 	and window specific module instances.
	 * @param {array} _list is the overall instances list, to which the module should be
	 * 	added.
	 * @param {object} _instances is the overall instances list, to which the module should be
	 * 	added.
	 * @param {string} _app is the application for which the instance should be created.
	 * @param {DOMElement} _window is the window for which the instance should be created.
	 * @return {egw}
	 */
	function createEgwInstance(_egw, _modules, _moduleInstances, _list, _instances, _app, _window)
	{
		// Clone the global object
		var instance = cloneObject(_egw);

		// Let "_window" and "_app" be exactly null, if it evaluates to false
		_window = _window ? _window : null;
		_app = _app ? _app : null;

		// Set the application name and the window the API instance belongs to
		instance.appName = _app;
		instance.window = _window;

		// Push the newly created instance onto the instance list
		_list.push({
			'instance': instance,
			'window': _window,
			'app': _app
		});

		// Merge either the application specific and/or the window specific
		// module instances into the new instance
		if (_app)
		{
			var appModules = getAppModules(_egw, _modules, _moduleInstances,
				_app);

			for (var key in appModules)
			{
				mergeObjects(instance, appModules[key]);
			}
		}

		if (_window)
		{
			var wndModules = getWndModules(_egw, _modules, _moduleInstances,
				_instances, _window);

			for (var key in wndModules)
			{
				mergeObjects(instance, wndModules[key]);
			}
		}

		// Return the new api instance
		return instance;
	}

	/**
	 * Returns a egw instance for the given application and the given window. If
	 * the instance does not exist now, the instance will be created.
	 *
	 * @param {globalEgw} _egw is the global _egw instance which should be used.
	 * @param {object} _modules is the hash map which contains references to all module
	 * 	descriptors.
	 * @param {object} _moduleInstances is the the object which contains the application
	 * 	and window specific module instances.
	 * @param {object} _instances is the overall instances list, to which the module should be
	 * 	added.
	 * @param {string} _app is the application for which the instance should be created.
	 * @param {DOMElement} _window is the window for which the instance should be created.
	 * @return {egw}
	 */
	function getEgwInstance(_egw, _modules, _moduleInstances, _instances, _app, _window)
	{
		// Generate the hash key for the instance descriptor object
		var hash = _app ? _app : '~global~';

		// Let "_window" be exactly null, if it evaluates to false
		_window = _window ? _window : null;

		// Create a new entry if the calculated hash does not exist
		if (typeof _instances[hash] === 'undefined')
		{
			_instances[hash] = [];
			return createEgwInstance(_egw, _modules, _moduleInstances,
				_instances[hash], _instances, _app, _window);
		}
		else
		{
			// Otherwise search for the api instance corresponding to the given
			// window
			for (var i = 0; i < _instances[hash].length; i++)
			{
				if (_instances[hash][i].window === _window)
				{
					return _instances[hash][i].instance;
				}
			}
		}

		// If we're still here, no API instance for the given window has been
		// found -- create a new entry
		return createEgwInstance(_egw, _modules, _moduleInstances,
			_instances[hash], _instances, _app, _window);
	}

	function cleanupEgwInstances(_instances, _moduleInstances, _cond)
	{
		// Iterate over the instances
		for (var key in _instances)
		{
			// Delete all entries corresponding to closed windows
			deleteWhere(_instances[key], _cond);

			// Delete the complete instance key if the array is empty
			if (_instances[key].length === 0)
			{
				delete _instances[key];
			}
		}

		// Delete all entries corresponding to non existing elements in the
		// module instances
		deleteWhere(_moduleInstances.wnd, _cond);
	}

	function mergeGlobalModule(_module, _code, _instances, _moduleInstances)
	{
		// Generate the global extension
		var globalExtension = _code.call(egw, null, window);

		// Store the global extension module
		_moduleInstances.glo[_module] = globalExtension;

		for (var key in _instances)
		{
			for (var i = 0; i < _instances[key].length; i++)
			{
				mergeObjects(_instances[key][i].instance,
						globalExtension);
			}
		}
	}

	function mergeAppLocalModule(_module, _code, _instances, _moduleInstances)
	{
		// Generate the global extension
		var globalExtension = _code.call(egw, null, window);

		// Store the global extension module
		_moduleInstances.glo[_module] = globalExtension;

		// Merge the extension into the global instances
		for (var i = 0; i < _instances['~global~'].length; i++)
		{
			mergeObjects(_instances['~global~'][i].instance, globalExtension);
		}

		for (var key in _moduleInstances.app)
		{
			// Create the application specific instance and
			// store it in the module instances
			var appExtension = _code.call(egw, key, window);
			_moduleInstances.app[key][_module] = appExtension;

			// Merge the extension into all instances for
			// the current application
			for (var i = 0; i < _instances[key].length; i++)
			{
				mergeObjects(_instances[key][i].instance, appExtension);
			}
		}
	}

	function mergeWndLocalModule(_module, _code, _instances, _moduleInstances)
	{
		// Iterate over all existing windows
		for (var i = 0; i < _moduleInstances.wnd.length; i++)
		{
			var wnd = _moduleInstances.wnd[i].window;

			// Create the window specific instance and
			// register it.
			var wndExtension = _code.call(egw, null, wnd);
			_moduleInstances.wnd[i].modules[_module] = wndExtension;

			// Extend all existing instances which are using
			// this window.
			for (var key in _instances)
			{
				for (var j = 0; j < _instances[key].length; j++)
				{
					if (_instances[key][j].window === wnd)
					{
						mergeObjects(_instances[key][j].instance,
								wndExtension);
					}
				}
			}
		}
	}

	/**
	 * Creates the egw object --- if the egw object should be created, some data
	 * has already been set inside the object by the Api\Framework::header
	 * function and the instance has been marked as "prefsOnly".
	 */
	if (typeof window.egw != "undefined" && window.egw.prefsOnly)
	{
		// Rescue the old egw object
		var prefs = window.egw;
		delete prefs['prefsOnly'];

		/**
		 * Modules contains all currently loaded egw extension modules. A module
		 * is stored as an object of the following form:
		 * 	{
		 * 		name: <NAME OF THE OBJECT>,
		 * 		code: <REFERENCE TO THE MODULE FUNCTION>,
		 * 		flags: <MODULE FLAGS (local, global, etc.)
		 * 	}
		 */
		var modules = {};

		var moduleInstances = {
			'app': {},
			'wnd': [],
			'glo': {}
		};

		/**
		 * instances contains references to all created instances.
		 */
		var instances = {};

		/**
		 * Set a interval which is used to cleanup unused API instances all 10
		 * seconds.
		 */
		window.setInterval(function() {
			cleanupEgwInstances(instances, moduleInstances, function(w) {
				try {
					return w.window && w.window.closed;
				}
				catch(e) {
					// IE(11) seems to throw a permission denied error, when accessing closed property
					return true;
				}
			});
		}, 10000);

		/**
		 * The egw function returns an instance of the client side api. If no
		 * parameter is given, an egw istance, which is not bound to a certain
		 * application is returned.
		 * You may pass either an application name (as string) to the egw
		 * function and/or a window object. If you specify both, the app name
		 * has to preceed the window object reference. If no window object is
		 * given, the root window will be used.
		 *
		 * @return {egw}
		 */
		var egw = function() {

			// Get the window/app reference
			var _app = null;
			var _window = window;

			switch (arguments.length)
			{
				case 0:
					// Return the global instance
					return instances['~global~'][0]['instance'];

				case 1:
					if (typeof arguments[0] === 'string')
					{
						_app = arguments[0];
					}
					else if (typeof arguments[0] === 'object')
					{
						_window = arguments[0];
					}
					break;

				case 2:
					_app = arguments[0];
					_window = arguments[1];
					break;

				default:
					throw "Invalid count of parameters";
			}

			// Generate an API instance
			return getEgwInstance(egw, modules, moduleInstances, instances,
					_app, _window);
		};

		var globalEgw = {

			/**
			 * The MODULE_GLOBAL flag describes a module as global. A global
			 * module always works on the same data.
			 */
			MODULE_GLOBAL: 0,

			/**
			 * The MODULE_APP_LOCAL flag is used to describe a module as local
			 * for each application. Each time an api object is requested for
			 * another application, the complete module gets recreated.
			 */
			MODULE_APP_LOCAL: 1,

			/**
			 * The MODULE_WND_LOCAL flag is used to describe a module as local
			 * for each window. Each time an api object is requested for another
			 * window, the complete module gets recreated.
			 */
			MODULE_WND_LOCAL: 2,

			/**
			 * Name of the application the egw object belongs to.
			 */
			appName: null,

			/**
			 * Reference to the window this egw object belongs to.
			 */
			window: window,

			/**
			 * Returns the current application name. The current application
			 * name equals the name, which was given when calling the egw
			 * function. If the getAppName function is called on the global
			 * instance, 'api' is returned.
			 */
			getAppName: function() {
				// Otherwise return the correct application name.
				return this.app_name() || this.appName || 'api';
			},

			/**
			 * The extend function can be used to extend the egw object.
			 *
			 * @param _module should be a string containing the name of the new
			 * 	module.
			 * @param _flags specifies whether the extension should be treated
			 * 	as a local or a global module. May be one of egw.MODULE_GLOBAL,
			 * 	MODULE_APP_LOCAL or MODULE_WND_LOCAL.
			 * @param _code should be a function, which returns an object that
			 * 	should extend the egw object.
			 */
			extend: function(_module, _flags, _code) {

				// Check whether that module is already registered
				if (typeof modules[_module] === 'undefined')
				{
					// Create a new module entry
					modules[_module] = {
						'code': _code,
						'flags': _flags,
						'name': _module
					};

					// Create new app/module specific instances for the new
					// module and merge the new module into all created
					// instances
					switch (_flags)
					{
						// Easiest case -- simply merge the extension into all
						// instances
						case egw.MODULE_GLOBAL:
							mergeGlobalModule(_module, _code, instances,
									moduleInstances);
							break;

						// Create new application specific instances and merge
						// those into all api instances for that application
						case egw.MODULE_APP_LOCAL:
							mergeAppLocalModule(_module, _code, instances,
									moduleInstances);
							break;


						// Create new window specific instances for each window
						// and merge those into all api instances for that
						// window
						case egw.MODULE_WND_LOCAL:
							mergeWndLocalModule(_module, _code, instances,
									moduleInstances);
							break;
					}
				}
			},

			/**
			 * Very similar to the egw function itself, but the module function
			 * returns just the functions exported by a single extension -- in
			 * this way extensions themselve are capable of accessing each
			 * others functions while they are being instanciated. Yet you
			 * should be carefull not to create any cyclic dependencies.
			 *
			 * @param _module is the name of the module
			 * @param _for may either be a string describing an application,
			 * 	an object referencing to a window or evaluate to false, in which
			 * 	case the global instance will be returned.
			 */
			module: function(_module, _for) {
				if (typeof modules[_module] !== 'undefined')
				{
					// Return the global instance of the module if _for
					// evaluates to false
					if (!_for)
					{
						return moduleInstances.glo[_module];
					}

					// Assume _for is an application name if it is a string.
					// Check whether the given application instance actually
					// exists.
					if (typeof _for === 'string'
					    && typeof moduleInstances.app[_for] !== 'undefined')
					{
						var mods = moduleInstances.app[_for];

						// Otherwise just instanciate the module if it has not
						// been created yet.
						if (typeof mods[_module] === 'undefined')
						{
							var mod = modules[_module];
							mods[_module] = mod.code.call(this, _app, window);
						}

						return mods[_module];
					}

					// If _for is an object, assume it is a window.
					if (typeof _for === 'object')
					{
						var mods = getExistingWndModules(moduleInstances, _for);

						// Check whether the module container for that window
						// has been found
						if (mods != null && typeof mods[_module] != 'undefined')
						{
							return mods[_module];
						}
						// If the given module has not been instanciated for
						// this window, instanciate it
						if (mods == null) mods = {};
						if (typeof mods[_module] === 'undefined')
						{
							var mod = modules[_module];
							mods[_module] = mod.code.call(this, null, _for);
						}
						return mods[_module];

					}
				}

				return null;
			},

			/**
			 * The "constant" function can be used to update a constant in all
			 * egw instances.
			 *
			 * @param _module is the module for which the constant should be set
			 * @param _name is the name of the constant
			 * @param _value is the value to which it should be set
			 * @param _window if set, updating the constant is restricted to
			 * 	those api instances which belong to the given window, if _window
			 * 	evaluates to false, all instances will be updated.
			 */
			constant: function(_module, _name, _value, _window) {
				// Update the module instances first
				for (var i = 0; i < moduleInstances.wnd.length; i++)
				{
					if (!_window || _window === moduleInstances.wnd[i].window)
					{
						moduleInstances.wnd[i].modules[_module][_name] = _value;
					}
				}

				// Now update all already instanciated instances
				for (var key in instances)
				{
					for (var i = 0; i < instances[key].length; i++)
					{
						if (!_window || _window === instances[key][i].window)
						{
							instances[key][i].instance[_name] = _value;
						}
					}
				}
			},

			dumpModules: function() {
				return modules;
			},

			dumpInstances: function() {
				return {
					'instances': instances,
					'moduleInstances': moduleInstances
				};
			}
		};

		// Merge the globalEgw functions into the egw object.
		mergeObjects(egw, globalEgw);

		// Merge the preferences into the egw object.
		mergeObjects(egw, prefs);

		// Create the entry for the root window in the module instances
		moduleInstances.wnd.push({
			'window': window,
			'modules': []
		});

		// Create the entry for the global window in the instances and register
		// the global instance there
		instances['~global~'] = [{
			'window': window,
			'instance': egw,
			'app': null
		}];

		// Publish the egw object
		this['egw'] = egw;
	}
}).call(window);

/**
 * EGroupware clientside API object
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link http://www.egroupware.org
 * @author Andreas Stöckel (as AT stylite.de)
 * @author Ralf Becker <RalfBecker@outdoor-training.de>
 */

egw.extend('utils', egw.MODULE_GLOBAL, function()
{
	"use strict";

	function json_escape_string(input)
	{
		var len = input.length;
		var res = "";

		for (var i = 0; i < len; i++)
		{
			switch (input.charAt(i))
			{
				case '"':
					res += '\\"';
					break;

				case '\n':
					res += '\\n';
					break;

				case '\r':
					res += '\\r';
					break;

				case '\\':
					res += '\\\\';
					break;

				case '\/':
					res += '\\/';
					break;

				case '\b':
					res += '\\b';
					break;

				case '\f':
					res += '\\f';
					break;

				case '\t':
					res += '\\t';
					break;

				default:
					res += input.charAt(i);
			}
		}

		return res;
	}

	function json_encode_simple(input)
	{
		switch (input.constructor)
		{
			case String:
				return '"' + json_escape_string(input) + '"';

			case Number:
				return input.toString();

			case Boolean:
				return input ? 'true' : 'false';

			default:
				return null;
		}
	}

	function json_encode(input)
	{
		if (input == null || !input && input.length == 0) return 'null';

		var simple_res = json_encode_simple(input);
		if (simple_res == null)
		{
			switch (input.constructor)
			{
				case Array:
					var buf = [];
					for (var k in input)
					{
						//Filter non numeric entries
						if (!isNaN(k))
							buf.push(json_encode(input[k]));
					}
					return '[' + buf.join(',') + ']';

				case Object:
					var buf = [];
					for (var k in input)
					{
						buf.push(json_encode_simple(k) + ':' + json_encode(input[k]));
					}
					return '{' + buf.join(',') + '}';

				default:
					switch(typeof input)
					{
						case 'array':
							var buf = [];
							for (var k in input)
							{
								//Filter non numeric entries
								if (!isNaN(k))
									buf.push(json_encode(input[k]));
							}
							return '[' + buf.join(',') + ']';

						case 'object':
							var buf = [];
							for (var k in input)
							{
								buf.push(json_encode_simple(k) + ':' + json_encode(input[k]));
							}
							return '{' + buf.join(',') + '}';

					}
					return 'null';
			}
		}
		else
		{
			return simple_res;
		}
	}


	/**
	 * Try some deprecated ways of copying to the OS clipboard
	 *
	 * @param event Optional, but if you have an event we can try some things on it
	 * @param target_element Element whose contents you're trying to copy
	 * @param text Actual text.  Usually target_element.value.
	 * @returns {boolean}
	 */
	function fallbackCopyTextToClipboard(event, target_element, text)
	{
		const win = target_element?.ownerDocument.defaultView ?? target_element.ownerDocument.parentWindow ?? window;

		// Cancel any no-select css
		if (target_element)
		{
			let old_select = target_element.style.userSelect;
			target_element.style.userSelect = 'all';

			let range = document.createRange();
			range.selectNode(target_element);
			win.getSelection().removeAllRanges();
			win.getSelection().addRange(range);

			target_element.style.userSelect = old_select;


			// detect we are in IE via checking setActive, since it's
			// only supported in IE, and make sure there's clipboardData object
			if (event && typeof event.target.setActive != 'undefined' && win.clipboardData)
			{
				win.clipboardData.setData('Text', target_element.textContent.trim());
			}
			if (event && event.clipboardData)
			{
				event.clipboardData.setData('text/plain', target_element.textContent.trim());
				event.clipboardData.setData('text/html', target_element.outerHTML);
			}
		}
		let textArea;
		if (!win.clipboardData)
		{

			textArea = document.createElement("textarea");
			textArea.value = text;

			// Avoid scrolling to bottom
			textArea.style.top = "0";
			textArea.style.left = "0";
			textArea.style.position = "fixed";

			win.document.body.appendChild(textArea);
			textArea.focus();
			textArea.select();
		}

		let successful = false;
		try
		{
			successful = win.document.execCommand('copy');
			const msg = successful ? 'successful' : 'unsuccessful';
			console.log('Fallback: Copying text command was ' + msg);
		}
		catch (err)
		{
			successful = false;
		}

		win.document.body.removeChild(textArea);
		return successful;
	}

	var uid_counter = 0;

	/**
	 * Global cache shared between all EGroupware windows
	 * @type {{}}
	 */
	const cache = {};

	// Create the utils object which contains references to all functions
	// covered by it.
	var utils = {
		/**
		 * Get a cache object shared between all EGroupware windows
		 *
		 * @param {string} _name unique name for the cache-object
		 * @return {*}
		 */
		getCache: function(_name)
		{
			if (typeof cache[_name] === 'undefined') cache[_name] = {};

			return cache[_name];
		},

		/**
		 * Invalidate / delete given part of the cache
		 *
		 * @param {string} _name unique name of cache-object
		 * @param {string|RegExp|undefined} _attr undefined: invalidate/unset whole object or just the given attribute _attr or matching RegExp _attr
		 */
		invalidateCache: function(_name, _attr)
		{
			// string with regular expression like "/^something/i"
			if (typeof _attr === 'string' && (_attr[0] === '/', _attr.indexOf('/', 1) !== -1))
			{
				let parts = _attr.split('/');
				parts.shift();
				const flags = parts.pop();
				_attr = new RegExp(parts.join('/'), flags);
			}
			if (typeof _attr === 'undefined' || typeof cache[_name] === 'undefined')
			{
				delete cache[_name];
			}
			else if (typeof _attr === 'object' && _attr.constructor.name === 'RegExp')
			{
				for(const attr in cache[_name])
				{
					if (attr.match(_attr)) delete cache[_name][attr];
				}
			}
			else
			{
				delete cache[_name][_attr];
			}
		},

		ajaxUrl: function(_menuaction) {
			if(_menuaction.indexOf('menuaction=') >= 0)
			{
				return _menuaction;
			}
			return this.webserverUrl + '/json.php?menuaction=' + _menuaction;
		},

		elemWindow: function(_elem) {
			var res =
				_elem.ownerDocument.parentNode ||
				_elem.ownerDocument.defaultView;
			return res;
		},

		uid: function() {
			return (uid_counter++).toString(16);
		},

		/**
		 * Decode encoded vfs special chars
		 *
		 * @param {string} _path path to decode
		 * @return {string}
		 */
		decodePath: function(_path) {
			try {
				return decodeURIComponent(_path);
			}
			catch(e) {
				// ignore decoding errors, as they usually only mean _path is not encoded
				egw.debug("error", "decodePath('"+_path+"'): "+e.stack);
			}
			return _path;
		},

		/**
		 * Encode vfs special chars excluding /
		 *
		 * @param {string} _path path to decode
		 * @return {string}
		 */
		encodePath: function(_path) {
			var components = _path.split('/');
			for(var n=0; n < components.length; n++)
			{
				components[n] = this.encodePathComponent(components[n]);
			}
			return components.join('/');
		},

		/**
		 * Encode vfs special chars removing /
		 *
		 * '%' => '%25',
		 * '#' => '%23',
		 * '?' => '%3F',
		 * '/' => '',	// better remove it completly
		 *
		 * @param {string} _comp path to decode
		 * @return {string}
		 */
		encodePathComponent: function(_comp) {
			return _comp.replace(/%/g,'%25').replace(/#/g,'%23').replace(/\?/g,'%3F').replace(/\//g,'');
		},

		/**
		 * Hash a string
		 *
		 * @param string
		 */
		async hashString(string)
		{
			const data = (new TextEncoder()).encode(string);
			const hashBuffer = await crypto.subtle.digest('SHA-256', data);
			const hashArray = Array.from(new Uint8Array(hashBuffer));
			const hashHex = hashArray.map(byte => byte.toString(16).padStart(2, '0')).join('');
			return hashHex;
		},

		/**
		 * Escape HTML special chars, just like PHP
		 *
		 * @param {string} s String to encode
		 *
		 * @return {string}
		 */
		htmlspecialchars: function(s) {
			return s.replace(/&/g, '&amp;')
				.replace(/"/g, '&quot;')
				.replace(/</g, '&lt;')
				.replace(/>/g, '&gt;');
		},

		/**
		 * If an element has display: none (or a parent like that), it has no size.
		 * Use this to get its dimensions anyway.
		 *
		 * @param element HTML element
		 * @param boolOuter Pass true to get outerWidth() / outerHeight() instead of width() / height()
		 *
		 * @return Object [w: width, h: height]
		 *
		 * @author Ryan Wheale
		 * @see http://www.foliotek.com/devblog/getting-the-width-of-a-hidden-element-with-jquery-using-width/
		 */
		getHiddenDimensions: function(element, boolOuter) {
			var $item = jQuery(element);
			var props = { position: "absolute", visibility: "hidden", display: "block" };
			var dim = { "w":0, "h":0 , "left":0, "top":0};
			var $hiddenParents = $item.parents().andSelf().not(":visible");

			var oldProps = [];
			$hiddenParents.each(function() {
				var old = {};
				if (this.styles)
				{
					for (var name in props)
					{
						old[name] = this.style[name];
					}
				}
				else if (this.computedStyleMap)
				{
					for (var name in props)
					{
						let s = this.computedStyleMap().get(name);
						if (s)
						{
							old[name] = s.value || "";
						}
					}
				}
				jQuery(this).show();
				oldProps.push(old);
			});

			dim.w = (boolOuter === true) ? $item.outerWidth() : $item.width();
			dim.h = (boolOuter === true) ? $item.outerHeight() : $item.height();
			dim.top = $item.offset().top;
			dim.left = $item.offset().left;

			$hiddenParents.each(function(i) {
				var old = oldProps[i];
				if (this.style)
				{
					for (var name in props)
					{
						this.style[name] = old[name];
					}
				}
			});
			//$.log(”w: ” + dim.w + ”, h:” + dim.h)
			return dim;
		},


		/**
		 * Store a window's name in egw.store so we can have a list of open windows
		 *
		 * @param {string} appname
		 * @param {Window} popup
		 */
		storeWindow: function(appname, popup)
		{
			if (popup.opener && popup.opener.framework) popup.opener.framework.popups_garbage_collector();

			// Don't store if it has no name
			if(!popup.name || ['_blank'].indexOf(popup.name) >= 0)
			{
				return;
			}

			var _target_app = appname || this.appName || egw_appName || 'common';
			var open_windows = JSON.parse(this.getSessionItem(_target_app, 'windows')) || {};
			open_windows[popup.name] = Date.now();
			this.setSessionItem(_target_app, 'windows', JSON.stringify(open_windows));

			// We don't want to start the timer on the popup here, because this is the function that updates the timeout, so it would set a timer each time.  Timer is started in egw.js
		},

		/**
		 * Get a list of the names of open popups
		 *
		 * Using the name, you can get a reference to the popup using:
		 * window.open('', name);
		 * Popups that were not given a name when they were opened are not tracked.
		 *
		 * @param {string} appname Application that owns/opened the popup
		 * @param {string} regex Optionally filter names by the given regular expression
		 *
		 * @returns {string[]} List of window names
		 */
		getOpenWindows: function(appname, regex) {
			var open_windows = JSON.parse(this.getSessionItem(appname, 'windows')) || {};
			if(typeof regex == 'undefined')
			{
				return open_windows;
			}
			var list = [];
			var now = Date.now();
			for(var i in open_windows)
			{
				// Expire old windows (5 seconds since last update)
				if(now - open_windows[i] > 5000)
				{
					egw.windowClosed(appname,i);
					continue;
				}
				if(i.match(regex))
				{
					list.push(i);
				}
			}
			return list;
		},

		/**
		 * Notify egw of closing a named window, which removes it from the list
		 *
		 * @param {String} appname
		 * @param {Window|String} closed Window that was closed, or its name
		 * @returns {undefined}
		 */
		windowClosed: function (appname, closed)
		{
			var closed_name = typeof closed == "string" ? closed : closed.name;
			var closed_window = typeof closed == "string" ? null : closed;
			window.setTimeout(function ()
			{
				if (closed_window != null && !closed_window.closed)
				{
					return;
				}

				var open_windows = JSON.parse(egw().getSessionItem(appname, 'windows')) || {};
				delete open_windows[closed_name];
				egw.setSessionItem(appname, 'windows', JSON.stringify(open_windows));
			}, 100);
		},

		/**
		 * Copy text to the clipboard
		 *
		 * @param text Actual text to copy.  Usually target_element.value
		 * @param target_element Optional, but useful for fallback copy attempts
		 * @param event Optional, but if you have an event we can try some fallback options with it
		 *
		 * @returns {Promise<undefined|boolean>|Promise<void>}
		 */
		copyTextToClipboard: function (text, target_element, event)
		{
			if (!navigator.clipboard)
			{
				let success = fallbackCopyTextToClipboard(event, target_element, text);
				return Promise.resolve(success ? undefined : false);
			}
			// Use Clipboard API
			const win = target_element?.ownerDocument.defaultView ?? target_element.ownerDocument.parentWindow ?? window;
			return win.navigator.clipboard.writeText(text);
		}
	};

	// Check whether the browser already supports encoding JSON -- if yes, use
	// its implementation, otherwise our own
	if (typeof window.JSON !== 'undefined' && typeof window.JSON.stringify !== 'undefined')
	{
		utils["jsonEncode"] = JSON.stringify;
	}
	else
	{
		utils["jsonEncode"] = json_encode;
	}

	// Return the extension
	return utils;

});

/**
 * EGroupware clientside API object
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link https://www.egroupware.org
 * @author Andreas Stöckel (as AT stylite.de)
 * @author Ralf Becker <RalfBecker@outdoor-training.de>
 */

/**
 * Module sending json requests
 *
 * @param {string} _app application name object is instantiated for
 * @param {object} _wnd window object is instantiated for
 */
egw.extend('json', egw.MODULE_WND_LOCAL, function(_app, _wnd)
{
	"use strict";

	/**
	 * Object which contains all registered handlers for JS responses.
	 * The handlers are organized per response type in the top level of the
	 * object, where each response type can have an array of handlers attached
	 * to it.
	 */
	var plugins = {};

	/**
	 * Global json handlers are from global modules, not window level
	 */
	if(typeof egw._global_json_handlers == 'undefined')
	{
		egw._global_json_handlers = {};
	}
	var global_plugins = egw._global_json_handlers;

	/**
	 * Internal implementation of the JSON request object.
	 *
	 * @param {string} _menuaction
	 * @param {array} _parameters
	 * @param {function} _callback
	 * @param {object} _context
	 * @param {boolean|"keepalive"} _async true: asynchronious request, false: synchronious request,
	 * 	"keepalive": async. request with keepalive===true / sendBeacon, to be used in boforeunload event
	 * @param {object} _sender
	 * @param {egw} _egw
	 */
	const json_request = function(_menuaction, _parameters, _callback, _context,
		_async, _sender, _egw)
	{
		// Copy the parameters
		this.url = _egw.ajaxUrl(_menuaction);
		// IE JSON-serializes arrays passed in from different window contextx (eg. popups)
		// as objects (it looses object-type of array), causing them to be JSON serialized
		// as objects and loosing parameters which are undefined
		// JSON.strigify([123,undefined]) --> '{"0":123}' instead of '[123,null]'
		this.parameters = _parameters ? [].concat(_parameters) : [];
		this.async = typeof _async != 'undefined' ? _async : true;
		this.callback = _callback ? _callback : null;
		this.context = _context ? _context : null;
		this.sender = _sender ? _sender : null;
		this.egw = _egw;

		// Some variables needed for notification about a JS files done loading
		this.onLoadFinish = null;
		this.jsFiles = 0;
		this.jsCount = 0;

		// Function which is currently used to display alerts -- may be replaced by
		// some API function.
		this.alertHandler = function(_message, _details) {
			// we need to use the alert function of the window of the request, not just the main window
			(this.egw ? this.egw.window : window).alert(_message);

			if (_details)
			{
				_egw.debug('info', _message, _details);
			}
		};
	};

	const min_reconnect_time = 1000;
	const max_reconnect_time = 300000;
	const check_interval = 30000;	// 30 sec
	const max_ping_response_time = 1000;
	let reconnect_time = min_reconnect_time;
	let websocket = null;

	/**
	 * Open websocket to push server (and keeps it open)
	 *
	 * @param {string} url this.websocket(s)://host:port
	 * @param {array} tokens tokens to subscribe too: sesssion-, user- and instance-token (in that order!)
	 * @param {number} account_id to connect for
	 * @param {function} error option error callback(_msg) used instead our default this.error
	 * @param {int} reconnect timeout in ms (internal)
	 */
	json_request.prototype.openWebSocket = function(url, tokens, account_id, error, reconnect)
	{
		reconnect_time = reconnect || min_reconnect_time;
		let check_timer;
		let check = function()
		{
			this.websocket.send('ping');
			check_timer = window.setTimeout(function()
			{
				console.log("Server did not respond to ping in "+max_ping_response_time+" seconds --> try reconnecting");
				check_timer = null;
				this.websocket.onclose = function()
				{
					this.websocket = null;
					this.openWebSocket(url, tokens, account_id, error, reconnect_time);
				}.bind(this);
				this.websocket.close();	// closing it now, before reopening it, to not end up with multiple connections
			}.bind(this), max_ping_response_time);
		}.bind(this);

		websocket = this.websocket = new WebSocket(url);
		this.websocket.onopen = (e) =>
		{
			check_timer = window.setTimeout(check, check_interval);
			this.websocket.send(JSON.stringify({
				subscribe: tokens,
				account_id: parseInt(account_id)
			}));
		};

		this.websocket.onmessage = (event) =>
		{
			reconnect_time = min_reconnect_time;
			console.log(event);
			if (check_timer) window.clearTimeout(check_timer);
			check_timer = window.setTimeout(check, check_interval);
			if (event.data === 'pong') return;	// just a keepalive message
			let data = JSON.parse(event.data);
			if (data && data.type)
			{
				this.handleResponse({ response: [data]});
			}
		};

		this.websocket.onerror = (error) =>
		{
			reconnect_time *= 2;
			if (reconnect_time > max_reconnect_time) reconnect_time = max_reconnect_time;

			console.log(error);
			(error||this.handleError({}, error));
		};

		this.websocket.onclose = (event) =>
		{
			if (event.wasClean)
			{
				reconnect_time = min_reconnect_time;
				console.log(`[close] Connection closed cleanly, code=${event.code} reason=${event.reason}`);
			}
			else
			{
				reconnect_time *= 2;
				if (reconnect_time > max_reconnect_time) reconnect_time = max_reconnect_time;

				// e.g. server process killed or network down
				// event.code is usually 1006 in this case
				console.log('[close] Connection died --> reconnect in '+reconnect_time+'ms');
				if (check_timer) window.clearTimeout(check_timer);
				check_timer = null;
				window.setTimeout(() => this.openWebSocket(url, tokens, account_id, error, reconnect_time), reconnect_time);
			}
		};
	},

	/**
	 * Sends the assembled request to the server
	 * @param {boolean|"keepalive"} _async Overrides async provided in constructor: true: asynchronious request,
	 * 	false: synchronious request, "keepalive": async. request with keepalive===true / sendBeacon, to be used in beforeunload event
	 * @param {string} method ='POST' allow to eg. use a (cachable) 'GET' request instead of POST
	 * @param {function} error option error callback(_xmlhttp, _err) used instead our default this.error
	 *
	 * @return {Promise|boolean} Promise or for async==="keepalive" boolean is returned
	 * Promise.abort() allows to abort the pending request
	 */
	json_request.prototype.sendRequest = function(async, method, error)
	{
		if(typeof async != "undefined")
		{
			this.async = async;
		}

		if (typeof method === 'undefined') method = 'POST';

		// Assemble the complete request
		const request_obj = JSON.stringify({
			request: {
				parameters: this.parameters
			}
		});

		// send with keepalive===true for sendBeacon to be used in beforeunload event
		if (this.async === "keepalive" && typeof navigator.sendBeacon !== "undefined")
		{
			const data = new FormData();
			data.append('json_data', request_obj);
			//(window.opener||window).console.log("navigator.sendBeacon", this.url, request_obj, data.getAll('json_data'));
			return navigator.sendBeacon(this.url, data);
		}

		let url = this.url;
		let init = {
			method: method
		};
		if (method === 'GET')
		{
			url += (url.indexOf('?') === -1 ? '?' : '&') + new URLSearchParams({ json_data: request_obj });
		}
		else
		{
			init.headers = { 'Content-Type': 'application/json'};
			init.body = request_obj;
		}
		let promise;
		if (this.async)
		{
			const controller = new AbortController();
			const signal = controller.signal;
			let response_ok = false;
			promise = _wnd.fetch(url, {...init, ...signal})
				.then((response) => {
					response_ok = response.ok;
					if (!response.ok) {
						throw response;
					}
					return response.json();
				})
				.then((data) => this.handleResponse(data) || data)
				.catch((_err) => {
					// no response / empty body causing response.json() to throw (a different error per browser!)
					if (response_ok && !_err.message.match(/Unexpected end of/i))
					{
						(error || this.handleError).call(this, _err);
					}
				});

			// offering a simple abort mechanism and compatibility with jQuery.ajax
			promise.abort = () => controller.abort();
		}
		else
		{
			console.trace("Synchronous AJAX request detected", this);
			const request = new XMLHttpRequest();
			request.open(method, url, false);
			if (method !== 'GET') request.setRequestHeader('Content-Type', 'application/json');
			request.send(init.body);
			if (request.status >= 200 && request.status < 300)
			{
				const json = JSON.parse(request.responseText);
				promise = Promise.resolve(this.handleResponse(json) || json);
			}
			else
			{
				(error || this.handleError).call(this, request, 'error');
			}
		}
		// compatibility with jQuery.ajax
		if (promise && typeof promise.then === 'function') promise.done = promise.then;

		return promise;
	};

	/**
	 * Default error callback displaying error via egw.message
	 *
	 * @param {XMLHTTP|Response} response
	 * @param {string} _err
	 */
	json_request.prototype.handleError = function(response, _err) {
		// Don't error about an abort
		if(_err !== 'abort')
		{
			// for fetch Response get json, as it's used below
			if (typeof response.headers === 'object' && response.headers.get('Content-Type') === 'application/json')
			{
				return response.json().then((json) => {
					response.responseJSON = json;
					this.handleError(response, 'error');
				})
			}
			const date = typeof response.headers === 'object' ? 'Date: '+response.headers.get('Date') :
				(typeof response.getAllResponseHeaders === 'function' ? response.getAllResponseHeaders().match(/^Date:.*$/mi)[0] : null) ||
				'Date: '+(new Date).toString();
			this.egw.message.call(this.egw,
				this.egw.lang('A request to the EGroupware server returned with an error')+
				': '+response.statusText+' ('+response.status+")\n\n"+
				this.egw.lang('Please reload the EGroupware desktop (F5 / Cmd+r).')+"\n"+
				this.egw.lang('If the error persists, contact your administrator for help and ask to check the error-log of the webserver.')+
				"\n\nURL: "+this.url+"\n"+date+
				// if EGroupware send JSON payload with error, errno show it here too
				(_err === 'error' && response.status === 400 && typeof response.responseJSON === 'object' && response.responseJSON.error ?
				"\nError: "+response.responseJSON.error+' ('+response.responseJSON.errno+')' : '')
			);

			this.egw.debug('error', 'Ajax request to', this.url, ' failed: ', _err, response.status, response.statusText, response.responseJSON);

			// check of unparsable JSON on server-side, which might be caused by some network problem --> resend max. twice
			if (_err === 'error' && response.status === 400 && typeof response.responseJSON === 'object' &&
				response.responseJSON.errno && response.responseJSON.error.substr(0, 5) === 'JSON ')
			{
				// ToDo: resend request max. twice
			}
		}
	};

	json_request.prototype.handleResponse = function(data) {
		if (data && typeof data.response != 'undefined')
		{
			if (egw.preference('show_generation_time', 'common', false) == "1")
			{
				var gen_time_div = jQuery('#divGenTime').length > 0 ? jQuery('#divGenTime')
				:jQuery('<div id="divGenTime" class="pageGenTime"><span class="pageTime"></span></div>').appendTo('#egw_fw_footer');
			}
			// Load files first
			var js_files = [];
			for (var i = data.response.length - 1; i >= 0; --i)
			{
				var res = data.response[i];
				if(res.type == 'js' && typeof res.data == 'string')
				{
					js_files.unshift(res.data);
					data.response.splice(i,1);
				}
			}
			if(js_files.length > 0)
			{
				var start_time = (new Date).getTime();
				// Need to use this.egw.window.egw_import() to make sure file is loaded in correct window
				Promise.all(js_files.map((file) => this.egw.window.egw_import(file))).then(() =>
				{
					var end_time = (new Date).getTime();
					this.handleResponse(data);
					if (egw.preference('show_generation_time', 'common', false) == "1")
					{
						var gen_time_div = jQuery('#divGenTime');
						if (!gen_time_div.length) gen_time_div = jQuery('.pageGenTime');
						var gen_time_async = jQuery('.asyncIncludeTime').length > 0 ? jQuery('.asyncIncludeTime'):
							gen_time_div.append('<span class="asyncIncludeTime"></span>').find('.asyncIncludeTime');
						gen_time_async.text(egw.lang('async includes took %1s', (end_time-start_time)/1000));
					}
				});
				return;
			}

			// defer apply's for app.* after et2_load is finished
			let apply_app = [];
			if (data.response.filter((res) => res.type === 'et2_load').length)
			{
				apply_app = data.response.filter((res) => res.type === 'apply' && res.data.func.substr(0, 4) === 'app.');
				if (apply_app.length)
				{
					data.response = data.response.filter((res) => !(res.type === 'apply' && res.data.func.substr(0, 4) === 'app.'));
				}
			}

			// Flag for only data response - don't call callback if only data
			var only_data = (data.response.length > 0);

			for (var i = 0; i < data.response.length; i++)
			{
				// Get the response object
				var res = data.response[i];
				if(typeof res.type == 'string' && res.type != 'data') only_data = false;

				// Check whether a plugin for the given type exists
				var handlers = [plugins, global_plugins];
				for(var handler_idx = 0; handler_idx < handlers.length; handler_idx++)
				{
					var handler_level = handlers[handler_idx];
					if (typeof handler_level[res.type] !== 'undefined')
					{
						const handlerCount = handler_level[res.type].length;
						for (let j = handlerCount - 1; j >= 0; j--)
						{
							try {
								// Get a reference to the plugin
								var plugin = handler_level[res.type][j];
								if (res.type === 'et2_load')
								{
									if (egw.preference('show_generation_time', 'common', false) == "1")
									{
										if (gen_time_div.length > 0)
										{
											gen_time_div.find('span.pageTime').text(egw.lang("Page was generated in %1 seconds ", data.page_generation_time));
											if (data.session_restore_time)
											{
												var gen_time_session_span = gen_time_div.find('span.session').length > 0 ? gen_time_div.find('span.session'):
														gen_time_div.append('<span class="session"></span>').find('.session');
												gen_time_session_span.text(egw.lang("session restore time in %1 seconds ", data.page_generation_time));
											}
										}
									}
								}
								// Call the plugin callback
								const promise = plugin.callback.call(
									plugin.context ? plugin.context : this.context,
									res.type, res, this
								);
								// defer apply_app's after et2_load is finished (it returns a promise for that)
								if (res.type === 'et2_load' && apply_app.length && typeof promise.then === 'function')
								{
									promise.then(() => this.handleResponse({response: apply_app}));
								}
							} catch(e) {
								var msg = e.message ? e.message : e + '';
								var stack = e.stack ? "\n-- Stack trace --\n" + e.stack : "";
								this.egw.debug('error', 'Exception "' + msg + '" while handling JSON response from ' +
									this.url + ' [' + JSON.stringify(this.parameters) + '] type "' + res.type +
									'", plugin', plugin, 'response', res, stack);
							}
						}
					}
				}
			}
			// Call request callback, if provided
			if(typeof this.callback === 'function' && !only_data)
			{
				this.callback.call(this.context,res);
			}
		}
	};

	var json =
	{
		/**
		 * Check if there is a *working* connection to a push server
		 *
		 * @return {boolean}
		 */
		pushAvailable: function()
		{
			return websocket !== null && websocket.readyState == websocket.OPEN && reconnect_time === min_reconnect_time;
		},

		/** The constructor of the egw_json_request class.
		 *
		 * @param _menuaction the menuaction function which should be called and
		 * 	which handles the actual request. If the menuaction is a full featured
		 * 	url, this one will be used instead.
		 * @param _parameters which should be passed to the menuaction function.
		 * @param _async specifies whether the request should be asynchronous or
		 * 	not.
		 * @param _callback specifies the callback function which should be
		 * 	called, once the request has been sucessfully executed.
		 * @param _context is the context which will be used for the callback function
		 * @param _sender is a parameter being passed to the _callback function
		 */
		json: function(_menuaction, _parameters, _callback, _context, _async,
			_sender)
		{
			return new json_request(_menuaction, _parameters, _callback,
				_context, _async, _sender, this);
		},

		/**
		 * Do an AJAX call and get a javascript promise, which will be resolved with the returned data.
		 *
		 * egw.request() returns immediately with a Promise.  The promise will be resolved with just the returned data,
		 * any other "piggybacked" responses will be handled by registered handlers.  The data will also be passed to
		 * any registered data handlers (egw.data) before it is passed to your handler.
		 *
		 * To use:
		 * @example
		 * 	egw.request(
		 * 		"EGroupware\\Api\\Etemplate\\Widget\\Select::ajax_get_options",
		 * 		["select-cat"]
	 	 * 	)
		 * 	.then(function(data) {
		 * 		// Deal with the returned data here.  data may be undefined if no data was returned.
		 * 		console.log("Here's the categories:",data);
		 * 	});
		 *
		 *
		 * 	The return is a Promise, so multiple .then() can be chained in the usual ways:
		 * 	@example
		 * 	egw.request(...)
		 * 		.then(function(data) {
		 * 		  if(debug) console.log("Requested data", data);
		 * 		}
		 * 		.then(function(data) {
		 * 			// Change the data for the rest of the chain
		 * 		    if(typeof data === "undefined") return [];
		 * 		}
		 * 		.then(function(data) {
		 * 			// data is never undefined now, if it was before it's an empty array now
		 * 		 	for(let i = 0; i < data.length; i++)
		 * 			{
		 * 		 		...
		 * 			}
		 * 		}
		 *
		 *
		 * 	You can also fire off multiple requests, and wait for them to all be answered:
		 * 	@example
		 * 	let first = egw.request(...);
		 * 	let second = egw.request(...);
		 * 	Promise.all([first, second])
		 * 		.then(function(values) {
		 * 		 	console.log("First:", values[0], "Second:", values[1]);
		 * 		}
		 *
		 *
		 * @param {string} _menuaction
		 * @param {any[]} _parameters
		 *
		 * @return Promise resolving to data part (not full response, which can contain other parts)
		 * Promise.abort() allows to abort the pending request
		 */
		request: function(_menuaction, _parameters)
		{
			const request = new json_request(_menuaction, _parameters, null, this, true, this, this);
			const response = request.sendRequest();
			let promise = response.then(function(response)
			{
				// The ajax request has completed, get just the data & pass it on
				if(response && response.response)
				{
					let data = [];
					for(let value of response.response)
					{
						if(value.type && value.type === "data" && typeof value.data !== "undefined")
						{
							// Data was packed in response
							data.push(value.data);
						}
						else if (value && typeof value.type === "undefined" && typeof value.data === "undefined")
						{
							// Just raw data
							data.push(value);
						}
					}
					// Normally only 1 data, but multiple etemplate.exec calls can give multiple
					return data.length > 1 ? data : data[0];
				}
				return response;
			});
			// pass abort method to returned response
			if (typeof response.abort === 'function')
			{
				promise.abort = response.abort;
			}
			return promise;
		},

		/**
		 * Call a function specified by it's name (possibly dot separated, eg. "app.myapp.myfunc")
		 *
		 * @param {string|Function} _func dot-separated function name or function
		 * @param {mixed} ...args variable number of arguments
		 * @returns {mixed|Promise}
		 */
		callFunc: function(_func)
		{
			return this.applyFunc(_func, [].slice.call(arguments, 1));
		},

		/**
		 * Call a function specified by it's name (possibly dot separated, eg. "app.myapp.myfunc")
		 *
		 * @param {string|Function} _func dot-separated function name or function
		 * @param {array} args arguments
		 * @param {object} _context
		 * @returns {mixed|Promise}
		 */
		applyFunc: function(_func, args, _context)
		{
			let parent = _context || _wnd;
			let func = _func;

			if (typeof _func === 'string')
			{
				let parts = _func.split('.');
				func = parts.pop();
				for(var i=0; i < parts.length; ++i)
				{
					if (typeof parent[parts[i]] !== 'undefined')
					{
						parent = parent[parts[i]];
					}
					// check if we need a not yet included app.js object --> include it now and return a Promise
					else if (i == 1 && parts[0] == 'app' && typeof app.classes[parts[1]] === 'undefined')
					{
						return _wnd.egw_import(this.webserverUrl+'/'+parts[1]+'/js/app.min.js?'+((new Date).valueOf()/86400|0).toString())
							.then(() => this.applyFunc(_func, args, _context || _wnd),
								(err) => {console.error("Failure loading /"+parts[1]+'/js/app.min.js' + " (" + err + ")\nAborting.");});
					}
					// check if we need a not yet instantiated app.js object --> instantiate it now
					else if (i == 1 && parts[0] == 'app' && typeof app.classes[parts[1]] === 'function')
					{
						parent = parent[parts[1]] = new app.classes[parts[1]](parts[1], _wnd);
					}
				}
				if (typeof parent[func] == 'function')
				{
					func = parent[func];
				}
			}
			if (typeof func != 'function')
			{
				throw _func+" is not a function!";
			}
			return func.apply(parent, args);
		},

		/**
		 * Registers a new handler plugin.
		 *
		 * @param _callback is the callback function which should be called
		 * 	whenever a response is comming from the server.
		 * @param _context is the context in which the callback function should
		 * 	be called. If null is given, the plugin is executed in the context
		 * 	of the request object context.
		 * @param _type is an optional parameter defaulting to 'global'.
		 * 	it describes the response type which this plugin should be
		 * 	handling.
		 * @param {boolean} [_global=false] Register the handler globally or
		 *	locally.  Global handlers must stay around, so should be used
		 *	for global modules.
		 */
		registerJSONPlugin: function(_callback, _context, _type, _global)
		{
			// _type defaults to 'global'
			if (typeof _type === 'undefined')
			{
				_type = 'global';
			}
			// _global defaults to false
			if (typeof _global === 'undefined')
			{
				_global = false;
			}
			var scoped = _global ? global_plugins : plugins;

			// Create an array for the given category inside the plugins object
			if (typeof scoped[_type] === 'undefined')
			{
				scoped[_type] = [];
			}

			// Add the entry
			scoped[_type].push({
				'callback': _callback,
				'context': _context
			});
		},

		/**
		 * Removes a previously registered plugin.
		 *
		 * @param _callback is the callback function which should be called
		 * 	whenever a response is comming from the server.
		 * @param _context is the context in which the callback function should
		 * 	be called.
		 * @param _type is an optional parameter defaulting to 'global'.
		 * 	it describes the response type which this plugin should be
		 * 	handling.
		 * @param {boolean} [_global=false] Remove a global or local handler.
		 */
		unregisterJSONPlugin: function(_callback, _context, _type, _global)
		{
			// _type defaults to 'global'
			if (typeof _type === 'undefined')
			{
				_type = 'global';
			}
			// _global defaults to false
			if (typeof _global === 'undefined')
			{
				_global = false;
			}
			var scoped = _global ? global_plugins : plugins;
			if (typeof scoped[_type] !== 'undefined') {
				for (var i = 0; i < scoped[_type].length; i++)
				{
					if (scoped[_type][i].callback == _callback &&
						scoped[_type][i].context == _context)
					{
						scoped[_type].splice(i, 1);
						break;
					}
				}
			}
		},
		unregisterAllPlugins: function ()
		{
			for (const type of Object.getOwnPropertyNames(plugins))
			{
				delete plugins[type];
			}
		}
	};

	// Regisert the "alert" plugin
	json.registerJSONPlugin(function(type, res, req) {
		//Check whether all needed parameters have been passed and call the alertHandler function
		if ((typeof res.data.message != 'undefined') &&
			(typeof res.data.details != 'undefined'))
		{
			req.alertHandler(
				res.data.message,
				res.data.details);
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'alert');

	// Regisert the "message" plugin
	json.registerJSONPlugin(function(type, res, req) {
		//Check whether all needed parameters have been passed and call the alertHandler function
		if ((typeof res.data.message != 'undefined'))
		{
			req.egw.message(res.data.message, res.data.type);
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'message');

	// Register the "assign" plugin
	json.registerJSONPlugin(function(type, res, req) {
		//Check whether all needed parameters have been passed and call the alertHandler function
		if ((typeof res.data.id != 'undefined') &&
			(typeof res.data.key != 'undefined') &&
			(typeof res.data.value != 'undefined'))
		{
			var obj = _wnd.document.getElementById(res.data.id);
			if (obj)
			{
				obj[res.data.key] = res.data.value;

				if (res.data.key == "innerHTML")
				{
					egw_insertJS(res.data.value);
				}

				return true;
			}

			return false;
		}
		throw 'Invalid parameters';
	}, null, 'assign');

	// Register the "data" plugin
	json.registerJSONPlugin(function(type, res, req) {
		//Callback the caller in order to allow him to handle the data
		if (req.callback)
		{
			req.callback.call(req.sender, res.data);
			return true;
		}
	}, null, 'data');

	// Register the "script" plugin
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data == 'string')
		{
			try
			{
				var func = new Function(res.data);
				func.call(req.egw ? req.egw.window : window);
			}
			catch (e)
			{
				req.egw.debug('error', 'Error while executing script: ',
					res.data,e);
			}
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'script');

	// Register the "apply" plugin
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data.func == 'string')
		{
			req.egw.applyFunc(res.data.func, res.data.parms, req.egw.window);
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'apply');

	// Register the "jquery" plugin
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data.select == 'string' &&
			typeof res.data.func == 'string')
		{
			try
			{
				var jQueryObject = jQuery(res.data.select, req.context);
				jQueryObject[res.data.func].apply(jQueryObject,	res.data.parms);
			}
			catch (e)
			{
				req.egw.debug('error', 'Function', res.data.func,
					'Parameters', res.data.parms);
			}
			return true;
		}
		throw 'Invalid parameters';
	}, _wnd, 'jquery');

	// Register the "redirect" plugin
	json.registerJSONPlugin(function(type, res, req) {
		//console.log(res.data.url);
		if (typeof res.data.url == 'string' &&
			typeof res.data.global == 'boolean')
		{
			//Special handling for framework reload
			res.data.global |= (res.data.url.indexOf("?cd=10") > 0);

			if (res.data.global)
			{
				egw_topWindow().location.href = res.data.url;
			}
			// json request was originating from a different popup --> redirect that one
			else if(this && this.DOMContainer && this.DOMContainer.ownerDocument.defaultView != window &&
				egw(this.DOMContainer.ownerDocument.defaultView).is_popup())
			{
				this.DOMContainer.ownerDocument.location.href = res.data.url;
			}
			// main window, open url in respective tab
			else
			{
				egw_appWindowOpen(res.data.app, res.data.url);
			}
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'redirect');

	// Register the 'css' plugin
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data == 'string')
		{
			req.egw.includeCSS(res.data);
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'css');

	// Register the 'js' plugin
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data == 'string')
		{
			return Promise.all(res.data.map((src) => import(src)))
				.then(() => req.onLoadFinish.call(req.sender));
		}
		throw 'Invalid parameters';
	}, null, 'js');

	// Register the 'html' plugin, replacing document content with send html
	json.registerJSONPlugin(function(type, res, req) {
		if (typeof res.data == 'string')
		{
			// Empty the document tree
			while (_wnd.document.childNodes.length > 0)
			{
				_wnd.document.removeChild(_wnd.document.childNodes[0]);
			}

			// Write the given content
			_wnd.document.write(res.data);

			// Close the document
			_wnd.document.close();
			return true;
		}
		throw 'Invalid parameters';
	}, null, 'html');

	// Return the extension
	return json;
});

export { engineV8Version as $, functionName as A, createNonEnumerableProperty$3 as B, toIndexedObject$4 as C, addToUnscopables$1 as D, internalState as E, descriptors as F, documentCreateElement$1 as G, global$g as H, classof$2 as I, getBuiltIn$3 as J, inspectSource$1 as K, tryToString$1 as L, toPropertyKey$2 as M, toAbsoluteIndex$1 as N, lengthOfArrayLike$1 as O, isRegexp as P, regexpExec$2 as Q, regexpStickyHelpers as R, classofRaw$2 as S, defineBuiltInAccessor$1 as T, objectIsPrototypeOf as U, functionUncurryThisClause as V, engineUserAgent as W, html$1 as X, objectGetOwnPropertyDescriptor as Y, isForced_1 as Z, _export as _, functionUncurryThis as a, whitespaces$3 as a0, stringTrim as a1, objectGetOwnPropertyNames as a2, regexpGetFlags as a3, regexpUnsupportedDotAll as a4, regexpUnsupportedNcg as a5, objectKeys$1 as a6, objectGetOwnPropertySymbols as a7, objectPropertyIsEnumerable as a8, indexedObject as a9, EGW_KEY_ENTER as aA, EGW_KEY_MENU as aB, EGW_AI_DRAG_ENTER as aC, EGW_AI_DRAG_OUT as aD, EGW_AI_DRAG_OVER as aE, egwIsMobile$1 as aF, sprintf as aG, egwUnfocus as aH, egwGetShiftState as aI, EGW_VALID_KEYS as aJ, EGW_KEY_F1 as aK, EGW_KEY_F12 as aL, EGW_AO_FLAG_DEFAULT_FOCUS as aM, commonjsGlobal as aN, getDefaultExportFromCjs as aO, stringMultibyte as aP, stringRepeat as aQ, EGW_AI_DRAG as aR, uid$2 as aS, toPrimitive$1 as aT, isSymbol$2 as aU, notARegexp as aa, correctIsRegexpLogic as ab, EgwFnct as ac, egwActionStoreJSON as ad, regexpFlags$1 as ae, egwBitIsSet as af, EGW_AO_FLAG_IS_CONTAINER as ag, EGW_AO_SHIFT_STATE_NONE as ah, EGW_AO_STATE_SELECTED as ai, EGW_AO_STATE_VISIBLE as aj, EGW_AO_STATE_NORMAL as ak, EGW_AO_SHIFT_STATE_MULTI as al, EGW_AO_SHIFT_STATE_BLOCK as am, egwSetBit as an, EGW_AO_STATE_FOCUSED as ao, EGW_KEY_A as ap, EGW_KEY_SPACE as aq, EGW_KEY_PAGE_DOWN as ar, EGW_KEY_ARROW_UP as as, EGW_KEY_ARROW_DOWN as at, EGW_KEY_PAGE_UP as au, egwQueueCallback as av, EGW_AO_EXEC_SELECTED as aw, EGW_AO_EXEC_THIS as ax, egwObjectLength as ay, EGW_AO_STATE_DRAGGING as az, functionCall as b, fixRegexpWellKnownSymbolLogic as c, fails$h as d, anObject$8 as e, functionBindNative as f, isNullOrUndefined$3 as g, toIntegerOrInfinity$5 as h, isCallable$d as i, toLength$2 as j, toString$9 as k, advanceStringIndex$1 as l, getMethod$2 as m, regexpExecAbstract as n, hasOwnProperty_1 as o, isObject$6 as p, objectCreate as q, requireObjectCoercible$7 as r, sharedKey$2 as s, toObject$1 as t, defineBuiltIn$3 as u, isPure as v, wellKnownSymbol$7 as w, objectDefineProperty as x, createPropertyDescriptor$2 as y, aCallable$1 as z };
//# sourceMappingURL=egw_json-39123901.js.map
