/**
 * findTarget will run `querySelectorAll` against the given controller, plus
 * its shadowRoot, returning any the first child that:
 *
 *  - Matches the selector of `[data-target~="tag.name"]` where tag is the
 *  tagName of the given HTMLElement, and `name` is the given `name` argument.
 *
 *  - Closest ascendant of the element, that matches the tagname of the
 *  controller, is the specific instance of the controller itself - in other
 *  words it is not nested in other controllers of the same type.
 *
 */
export declare function findTarget(controller: HTMLElement, name: string): Element | undefined;
export declare function findTargets(controller: HTMLElement, name: string): Element[];
//# sourceMappingURL=findtarget.d.ts.map