"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.a11ySnapshotPlugin = void 0;
function a11ySnapshotPlugin() {
    return {
        name: 'a11y-snapshot-command',
        async executeCommand({ command, payload, session }) {
            if (command === 'a11y-snapshot') {
                // handle specific behavior for playwright
                if (session.browser.type === 'playwright') {
                    const page = session.browser.getPage(session.id);
                    const options = {};
                    if (payload && payload.selector) {
                        const root = await page.$(payload.selector);
                        if (root) {
                            options.root = root;
                        }
                    }
                    const snapshot = await page.accessibility.snapshot(options);
                    return snapshot;
                }
                // handle specific behavior for puppeteer
                if (session.browser.type === 'puppeteer') {
                    const page = session.browser.getPage(session.id);
                    const options = {};
                    if (payload && payload.selector) {
                        // @ts-ignore
                        const root = await page.$(payload.selector);
                        if (root) {
                            options.root = root;
                        }
                    }
                    // @ts-ignore
                    const snapshot = await page.accessibility.snapshot(options);
                    return snapshot;
                }
                // you might not be able to support all browser launchers
                throw new Error(`Acessibility snapshot is not supported for browser type ${session.browser.type}.`);
            }
        },
    };
}
exports.a11ySnapshotPlugin = a11ySnapshotPlugin;
//# sourceMappingURL=a11ySnapshotPlugin.js.map