"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.serveTestFrameworkPlugin = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const util_1 = require("util");
const TEST_FRAMEWORK_IMPORT_ROOT = '/__web-test-runner__/test-framework/';
async function readFile(codePath) {
    if (!fs_1.default.existsSync(codePath)) {
        throw new Error(`The test framework at ${codePath} could not be loaded. ` +
            'Are your dependencies installed correctly? Is there a server plugin or middleware that interferes?');
    }
    return await (0, util_1.promisify)(fs_1.default.readFile)(codePath, 'utf-8');
}
/**
 * Serves test framework without requiring the files to be available within the root dir of the project.
 */
function serveTestFrameworkPlugin(testFramework) {
    const testFrameworkFilePath = path_1.default.resolve(testFramework.path);
    const testFrameworkBrowserPath = testFrameworkFilePath.split(path_1.default.sep).join('/');
    const testFrameworkImport = encodeURI(path_1.default.posix.join(TEST_FRAMEWORK_IMPORT_ROOT, testFrameworkBrowserPath));
    const testFrameworkPlugin = {
        name: 'wtr-serve-test-framework',
        async serve(context) {
            if (context.path.startsWith(TEST_FRAMEWORK_IMPORT_ROOT)) {
                const importPath = decodeURI(context.path.replace(TEST_FRAMEWORK_IMPORT_ROOT, ''));
                let filePath = importPath.split('/').join(path_1.default.sep);
                // for posix the leading / will be stripped by path.join above
                if (path_1.default.sep === '/') {
                    filePath = `/${filePath}`;
                }
                const body = await readFile(filePath);
                return { body, type: 'js', headers: { 'cache-control': 'public, max-age=31536000' } };
            }
        },
    };
    return { testFrameworkImport, testFrameworkPlugin };
}
exports.serveTestFrameworkPlugin = serveTestFrameworkPlugin;
//# sourceMappingURL=serveTestFrameworkPlugin.js.map