"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTestFileImportPath = exports.toFilePath = exports.toBrowserPath = void 0;
const path_1 = __importDefault(require("path"));
const constants_js_1 = require("../utils/constants.js");
const toBrowserPathRegExp = new RegExp(path_1.default.sep === '\\' ? '\\\\' : path_1.default.sep, 'g');
const toFilePathRegeExp = new RegExp('/', 'g');
function toBrowserPath(filePath) {
    return filePath.replace(toBrowserPathRegExp, '/');
}
exports.toBrowserPath = toBrowserPath;
function toFilePath(browserPath) {
    return browserPath.replace(toFilePathRegeExp, path_1.default.sep);
}
exports.toFilePath = toFilePath;
async function createTestFileImportPath(config, context, filePath, sessionId) {
    var _a;
    const fullFilePath = path_1.default.resolve(filePath);
    const relativeToRootDir = path_1.default.relative(config.rootDir, fullFilePath);
    const browserPath = `/${toBrowserPath(relativeToRootDir)}`;
    const params = sessionId ? `?${constants_js_1.PARAM_SESSION_ID}=${sessionId}` : `?${constants_js_1.PARAM_MANUAL_SESSION}=true`;
    let importPath = encodeURI(`${browserPath}${params}`);
    // allow plugins to transform the import path
    for (const p of (_a = config.plugins) !== null && _a !== void 0 ? _a : []) {
        if (p.transformImport) {
            const transformResult = await p.transformImport({ source: importPath, context });
            if (typeof transformResult === 'object' && typeof transformResult.id === 'string') {
                importPath = transformResult.id;
            }
            else if (typeof transformResult === 'string') {
                importPath = transformResult;
            }
        }
    }
    return importPath;
}
exports.createTestFileImportPath = createTestFileImportPath;
//# sourceMappingURL=utils.js.map