import { aG as sprintf, H as global$1, w as wellKnownSymbol$1, o as hasOwnProperty_1, x as objectDefineProperty, aN as commonjsGlobal } from '../../chunks/egw_json-39123901.js';
import { al as Et2Description, M as i, am as et2_video, C as ClassWithAttributes, a as egw$1, B as et2_no_init, r as et2_register_widget, an as et2_implements_registry, ao as implements_methods, ap as Et2Checkbox, aq as et2_baseWidget, h as et2_createWidget, ar as et2_html, as as et2_htmlarea, at as et2_dialog, au as et2_number, av as et2_button, aw as et2_radiobox, l as et2_valueWidget, ax as et2_vfsUpload, c as Et2Dialog, a6 as Et2Widget, ay as s, Q as x, V as A, az as o$1, aA as e, aB as Et2InputWidget, aC as Et2Button, a8 as shoelace, aD as Et2WidgetWithSelectMixin, aE as radio_group_default, T as Et2Select, aF as c, aG as s$1, aH as i$1, aI as T, aJ as t, aK as e$1, aL as t$1, U as o$2, R as Et2StaticSelectMixin, ac as c$1, E as EgwApp, $ as et2_IInput } from '../../chunks/etemplate2-0373054a.js';
import '../../vendor/bower-asset/jquery/dist/jquery.min.js';
import '../../vendor/bower-asset/cropper/dist/cropper.min.js';
import '../../vendor/tinymce/tinymce/tinymce.min.js';

var _templateObject$b;
function ownKeys$b(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$b(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$b(Object(t), !0).forEach(function (r) { _defineProperty$t(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$b(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$t(e, r, t) { return (r = _toPropertyKey$t(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$t(t) { var i = _toPrimitive$t(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$t(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral$b(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
class SmallPartVideoTime extends Et2Description {
  static get styles() {
    return [...super.styles, i(_templateObject$b || (_templateObject$b = _taggedTemplateLiteral$b(["\n\t\t\t:host {\n\t\t\t\tright: 10px;\n\t\t\t\tbottom: 80px;\n\t\t\t\tfont-size: 12pt;\n\t\t\t}"])))];
  }
  static get properties() {
    return _objectSpread$b(_objectSpread$b({}, super.properties), {}, {
      /**
       * Defines the indicator type, time|page. default is video.
       */
      indicator: {
        type: String
      }
    });
  }
  constructor() {
    super();
    this.indicator = 'time';
  }
  set_value(_value) {
    var value = _value;
    switch (this.options.indicator) {
      case 'time':
        var time = new Date(null);
        time.setSeconds(parseInt(_value));
        value = time.toISOString().substr(11, 8);
        break;
      case 'page':
        value = egw.lang('page %1', Math.floor(parseInt(_value)));
        break;
    }
    this.value = value;
  }
}
customElements.define("et2-smallpart-videotime", SmallPartVideoTime);

function _defineProperty$s(e, r, t) { return (r = _toPropertyKey$s(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$s(t) { var i = _toPrimitive$s(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$s(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class et2_smallpart_videobar extends et2_video {
  /**
   *
   * @memberOf et2_DOMWidget
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_videobar._attributes, _child || {}));

    // wrapper DIV container for video tag and marking selector
    _defineProperty$s(this, "container", null);
    _defineProperty$s(this, "wrapper", null);
    _defineProperty$s(this, "slider", null);
    _defineProperty$s(this, "marking", null);
    _defineProperty$s(this, "timer", null);
    _defineProperty$s(this, "watermark", null);
    _defineProperty$s(this, "slider_progressbar", null);
    _defineProperty$s(this, "comments", null);
    _defineProperty$s(this, "mark_ratio", 0);
    _defineProperty$s(this, "marking_color", 'ffffff');
    // should be in sync with radioColorN and @color_markedAreaX in app.less
    _defineProperty$s(this, "marking_colors", ['000000', 'ffffff', 'ff7972', '61ff61', 'ffc909', '4B0082', '4480dc']);
    _defineProperty$s(this, "marks", []);
    _defineProperty$s(this, "marking_readonly", true);
    _defineProperty$s(this, "_scrolled", []);
    _defineProperty$s(this, "_onTimeUpdateEvent", null);
    _defineProperty$s(this, "ontimeupdate_callback", void 0);
    _defineProperty$s(this, "slider_callback", void 0);
    _defineProperty$s(this, "onresize_callback", void 0);
    _defineProperty$s(this, "marking_callback", void 0);
    this.wrapper = jQuery(document.createElement('div')).append(this.video).addClass('videobar_wrapper');

    // widget container
    this.container = jQuery(document.createElement('div')).append(this.wrapper).addClass('et2_smallpart_videobar videobar_container');

    // slider div
    this.slider = jQuery(document.createElement('div')).appendTo(this.container).addClass('videobar_slider bi-chat-left-text');

    // marking div
    this.marking = jQuery(document.createElement('div')).addClass('videobar_marking container');
    this.marking.append(jQuery(document.createElement('div')).addClass('markingMask maskOn'));
    this.marking.append(jQuery(document.createElement('div')).addClass('marksContainer'));

    // slider progressbar span
    this.slider_progressbar = jQuery(document.createElement('span')).addClass('videobar_slider_progressbar').appendTo(this.slider);
    this.wrapper.append(this.marking);
    this._buildHandlers();

    // timer span
    this.timer = document.createElement('et2-smallpart-videotime');
    this.timer.indicator = this.options.src_type.match(/pdf/) ? 'page' : 'time';
    this.timer.id = this.id + "[timer]";
    this._setWatermark();
    this.container.append(this.timer.getDOMNode());
    if (this.options.stop_contextmenu) this.video.on('contextmenu', function () {
      return false;
    });
    this.setDOMNode(this.container[0]);
  }
  _buildHandlers() {
    var self = this;
    if (this.options.seekable) {
      this.getSliderDOMNode().on('click', function (e) {
        self.slider_onclick.call(self, e);
      });
    }
  }
  _setWatermark() {
    var options = this.getArrayMgr('content').getEntry('course_options');
    var self = this;
    var name = '';
    if (options & et2_smallpart_videobar.course_options_video_watermark) {
      egw$1.accountData(egw$1.user('account_id'), 'account_fullname', false, function (_data) {
        name = _data[egw$1.user('account_id')];
        window.setInterval(function () {
          var node = jQuery(document.createElement('span')).attr('style', 'display:block !important;' + 'visibility:visible !important;background:white !important;color:black !important;' + 'width:auto !important;height:auto !important;position:absolute !important;' + 'top:20px !important;left:20px !important;bottom:auto !important;right:auto !important;').text(name).appendTo(self.wrapper);
          window.setTimeout(function () {
            node.remove();
          }, 1000);
        }, 10000);
      }, egw$1);
    }
  }
  slider_onclick(e) {
    if (!this.options.seekable) return;
    this.slider_progressbar.css({
      width: e.offsetX
    });
    this._scrolled = [];
    this.previousTime(this.currentTime());
    this.currentTime(e.offsetX * this.duration() / this.getSliderDOMNode().width());
    this.timer.set_value(this.currentTime());
    if (typeof this.slider_callback == "function") this.slider_callback(this, this);
  }
  set_seekable(_value) {
    this.options.seekable = _value;
  }
  doLoadingFinished() {
    super.doLoadingFinished();
    var self = this;
    this.video[0].addEventListener("et2_video.onReady." + this.id, function () {
      self.videoLoadnigIsFinished();
    });
    return false;
  }
  _vtimeToSliderPosition(_vtime) {
    return this.slider.width() / this.duration() * parseFloat(_vtime);
  }
  set_slider_tags(_comments) {
    this.comments = _comments;
    var cats = this.getArrayMgr('sel_options').getEntry('catsOptions');
    var comment = [];
    // need to wait video is loaded before setting tags
    if (this.video.width() == 0) return;
    this.slider.empty();
    this.slider.append(this.slider_progressbar);
    for (var i in this.comments) {
      comment = this.comments[i];
      if (!comment['comment_id'] || this.comments.length === 0) continue;
      var cat = cats.filter(_cat => {
        var _comment$comment_cat;
        return _cat.value == ((_comment$comment_cat = comment['comment_cat']) === null || _comment$comment_cat === void 0 ? void 0 : _comment$comment_cat.split(":")[0]);
      }) || [];
      this.slider.append(jQuery(document.createElement('span')).offset({
        left: this._vtimeToSliderPosition(comment['comment_starttime'])
      }).css({
        'background-color': cat.length > 0 ? cat[0].color : '#FFFFFF'
      }).attr('data-id', comment['comment_id']).addClass('commentOnSlider ' + comment['class'] + (comment['comment_stoptime'] - comment['comment_starttime'] > 1 ? ' commentHasDuration' : '')));
    }
  }
  set_marking_readonly(_state) {
    this.marking_readonly = _state;
  }
  set_marking_color(_color) {
    this.marking_color = typeof _color === 'number' ? this.marking_colors[_color] : _color;
  }
  set_marking_colors(_colors) {
    this.marking_colors = _colors;
  }
  get_marking_colors() {
    return this.marking_colors;
  }
  set_marking_enabled(_state, _callback) {
    var self = this;
    var isDrawing = false;
    this.getMarkingNode().toggle(_state);
    this.marking_callback = _callback;
    var drawing = function drawing(e) {
      if (e.target.nodeName !== "SPAN" && !self.marking_readonly) {
        var pixelX = Math.floor(e.originalEvent.offsetX / self.mark_ratio) * self.mark_ratio;
        var pixelY = Math.floor(e.originalEvent.offsetY / self.mark_ratio) * self.mark_ratio;
        var mark = {
          x: self._convertMarkedPixelX2Percent(pixelX),
          y: self._convertMarkedPixelY2Percent(pixelY),
          c: self.marking_color
        };
        self._addMark(mark);
      }
    };
    if (_state) {
      this.getMarkingNode().find('.marksContainer').off().on('mousedown', function () {
        console.log('mousedown');
        isDrawing = true;
      }).on('mouseup', function (e) {
        isDrawing = false;
        drawing(e);
      }).on('mousemove', function (e) {
        if (isDrawing === true) {
          drawing(e);
        }
      });
    }
  }
  setMarkingMask(_state) {
    if (_state) {
      this.getMarkingNode().find('.markingMask').addClass('maskOn');
    } else {
      this.getMarkingNode().find('.markingMask').removeClass('maskOn');
    }
  }
  setMarksState(_state) {
    if (_state) {
      this.getMarkingNode().find('.marksContainer').show();
    } else {
      this.getMarkingNode().find('.marksContainer').hide();
    }
  }
  setMarks(_marks) {
    var self = this;
    // clone the array to avoid missing its original content
    var $marksContainer = this.getMarkingNode().find('.marksContainer').empty();
    this.marks = (_marks === null || _marks === void 0 ? void 0 : _marks.slice(0)) || [];
    this.mark_ratio = parseFloat((this.video.width() / 80).toPrecision(4));
    for (var i in _marks) {
      var color = _marks[i].c;
      if (typeof color === 'number') color = this.marking_colors[color];
      $marksContainer.append(jQuery(document.createElement('span')).offset({
        left: this._convertMarkPercentX2Pixel(_marks[i]['x']),
        top: this._convertMarkPercentY2Pixel(_marks[i]['y'])
      }).css({
        "background-color": "#" + color,
        "width": this.mark_ratio,
        "height": this.mark_ratio
      }).attr('data-color', color).click(function () {
        if (!self.marking_readonly) self._removeMark(self._getMark(this), this);
      }).addClass('marks'));
    }
  }
  getMarks(use_color_table) {
    if (this.marks && !use_color_table) return this.marks;
    var $marks = this.getMarkingNode().find('.marksContainer').find('span.marks');
    var marks = [];
    var self = this;
    $marks.each(function () {
      marks.push({
        x: self._convertMarkedPixelX2Percent(parseFloat(this.style.left)),
        y: self._convertMarkedPixelY2Percent(parseFloat(this.style.top)),
        c: use_color_table ? self.marking_colors.indexOf(this.dataset['color'].substr(0, 6)) : this.dataset['color']
      });
    });
    this.marks = marks;
    return marks;
  }
  _getMark(_node) {
    return [{
      x: this._convertMarkedPixelX2Percent(parseFloat(_node.style.left)),
      y: this._convertMarkedPixelY2Percent(parseFloat(_node.style.top)),
      c: _node.dataset['color'].substr(0, 6)
    }];
  }
  _addMark(_mark) {
    // do NOT add already existing mark
    if (this.marks.find(mark => mark.x === _mark.x && mark.y === _mark.y && mark.c === _mark.c)) {
      return;
    }
    this.marks.push(_mark);
    this.setMarks(this.marks);
    this.marking_callback(_mark, true);
  }
  removeMarks() {
    this.marks = [];
    this.getMarkingNode().find('.marksContainer').find('span.marks').remove();
  }
  _removeMark(_mark, _node) {
    for (var i in this.marks) {
      if (this.marks[i]['x'] == _mark[0]['x'] && this.marks[i]['y'] == _mark[0]['y']) this.marks.splice(i, 1);
    }
    if (_node) jQuery(_node).remove();
    this.marking_callback(_mark, false);
  }
  _convertMarkedPixelX2Percent(_x) {
    return parseFloat((_x / this.video.width() / 0.01).toPrecision(4));
  }
  _convertMarkedPixelY2Percent(_y) {
    return parseFloat((_y / this.video.height() / 0.01).toPrecision(4));
  }
  _convertMarkPercentX2Pixel(_x) {
    return _x * this.video.width() * 0.01;
  }
  _convertMarkPercentY2Pixel(_y) {
    return _y * this.video.height() * 0.01;
  }

  /**
   * Seek to a time / position
   *
   * @param _vtime in seconds
   */
  seek_video(_vtime) {
    super.seek_video(_vtime);
    this._scrolled = [];
    this.timer.set_value(this.currentTime());
    this.slider_progressbar.css({
      width: this._vtimeToSliderPosition(_vtime)
    });
  }

  /**
   * Play video
   */
  play_video(_ended_callback, _onTagCallback) {
    var self = this;
    if (this.ended() && this.duration() == this.currentTime() && this.getArrayMgr('content').getEntry('video')['video_test_options'] & et2_smallpart_videobar.video_test_option_not_seekable) {
      return;
    }
    var ended_callback = _ended_callback;
    this._scrolled = [];
    this._onTimeUpdateEvent = function (_event) {
      var currentTime = self.currentTime();
      self.slider_progressbar.css({
        width: Math.round(self._vtimeToSliderPosition(currentTime))
      });
      self.timer.set_value(self.currentTime());
      if (typeof ended_callback == "function" && self.ended()) {
        ended_callback.call();
        self.pause_video();
      }
      if (typeof _onTagCallback == "function") {
        for (var i in self.comments) {
          if (Math.floor(currentTime) == parseInt(String(self.comments[i]['comment_starttime'])) && (self._scrolled.length == 0 || self._scrolled.indexOf(Object(parseInt(String(self.comments[i]['comment_id'])))) == -1)) {
            _onTagCallback.call(this, self.comments[i]['comment_id']);
            self._scrolled.push(Object(parseInt(String(self.comments[i]['comment_id']))));
          }
        }
      }
      if (typeof self.ontimeupdate_callback == "function") {
        self.ontimeupdate_callback.call(this, currentTime);
      }
    };
    return super.play_video().then(function () {
      self.video[0].addEventListener('et2_video.onTimeUpdate.' + self.id, self._onTimeUpdateEvent);
    });
  }

  /**
   * Pause video
   */
  pause_video() {
    super.pause_video();
    this.video[0].removeEventListener('et2_video.onTimeUpdate.' + this.id, this._onTimeUpdateEvent);
  }
  videoLoadnigIsFinished() {
    super.videoLoadnigIsFinished();
    // this will make sure that slider and video are synced
    this.slider.width(this.video.width());
    this.set_slider_tags(this.comments);
    this.getMarkingNode().css({
      width: this.video.width(),
      height: this.video.height()
    });
    if (this.options.src_type.match(/pdf/)) {
      this.slider.on('mousemove', e => {
        var currentTime = Math.floor(e.offsetX * this.duration() / this.getSliderDOMNode().width());
        egw$1.tooltipUnbind(this.slider[0]);
        egw$1.tooltipBind(this.slider[0], "<span>".concat(egw$1.lang('page %1', currentTime), "</span>"), true);
        this.slider.trigger('mouseenter.tooltip');
      });
    }
  }
  resize(_height) {
    this.slider.width('auto');
    this.getMarkingNode().width('auto');
    this.slider.width(this.video.width());
    this.getMarkingNode().css({
      width: this.video.width(),
      height: this.video.height()
    });
    this.slider_progressbar.css({
      width: this._vtimeToSliderPosition(this.currentTime())
    });
    //redraw marks and tags to get the right ratio
    this.setMarks(this.getMarks());
    this.set_slider_tags(this.comments);
    if (typeof this.onresize_callback == 'function') {
      this.onresize_callback.call(this, this.video.width(), this.video.height(), this._vtimeToSliderPosition(this.currentTime()));
    }
  }

  /**
   * return slider dom node as jquery object
   */
  getSliderDOMNode() {
    return this.slider;
  }
  getMarkingNode() {
    return this.marking;
  }
}
_defineProperty$s(et2_smallpart_videobar, "_attributes", {
  "marking_enabled": {
    "name": "Marking",
    "type": "boolean",
    "description": "",
    "default": false
  },
  "marking_readonly": {
    "name": "Marking readonly",
    "type": "boolean",
    "description": "",
    "default": true
  },
  "marking_color": {
    "name": "Marking color",
    "type": "string",
    "description": "",
    "default": "ffffff"
  },
  colors: {
    name: 'color lookup table',
    type: 'any',
    // eT2 has no array :(
    description: 'array of color values (strings without # eg. "ffffff")'
  },
  "marking_callback": {},
  "slider_callback": {
    "name": "Slider on click callback",
    "type": "js",
    "default": et2_no_init,
    "description": "Callback function to get executed after clicking om slider bar"
  },
  "slider_tags": {
    "name": "slider tags",
    "type": "any",
    "description": "comment tags on slider",
    "default": {}
  },
  "stop_contextmenu": {
    "name": "stop contextmenu",
    "type": "boolean",
    "description": "This would prevent the browser native contextmenu on video tag",
    "default": true
  },
  "ontimeupdate_callback": {
    "name": "ontimeupdate callback",
    "type": "js",
    "default": et2_no_init,
    "description": "Callback function to get executed while video is playing"
  },
  "onresize_callback": {
    "name": "onresize callback",
    'type': "js",
    "default": et2_no_init,
    "description": "Callback function called when video gets resized"
  },
  seekable: {
    name: 'seekable',
    type: 'boolean',
    description: 'Make slider active for seeking in timeline',
    default: true
  },
  watermark: {
    "name": "video watermark",
    "type": "any",
    "description": "Set a text watermark on video in a given position.",
    "default": {}
  }
});
_defineProperty$s(et2_smallpart_videobar, "video_test_display_instead_of_comment", 0);
_defineProperty$s(et2_smallpart_videobar, "video_test_display_dialog", 1);
_defineProperty$s(et2_smallpart_videobar, "video_test_display_on_video", 2);
_defineProperty$s(et2_smallpart_videobar, "video_test_display_list", 3);
_defineProperty$s(et2_smallpart_videobar, "video_test_option_pauseable", 1);
_defineProperty$s(et2_smallpart_videobar, "video_test_option_not_seekable", 2);
_defineProperty$s(et2_smallpart_videobar, "video_test_published_readonly", 3);
_defineProperty$s(et2_smallpart_videobar, "video_test_published_published", 1);
_defineProperty$s(et2_smallpart_videobar, "video_test_published_draft", 0);
_defineProperty$s(et2_smallpart_videobar, "video_test_published_unavailabe", 2);
_defineProperty$s(et2_smallpart_videobar, "course_options_video_watermark", 2);
_defineProperty$s(et2_smallpart_videobar, "course_options_cognitive_load_measurement", 5);
et2_register_widget(et2_smallpart_videobar, ["smallpart-videobar"]);

function ownKeys$a(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$a(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$a(Object(t), !0).forEach(function (r) { _defineProperty$r(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$a(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$r(e, r, t) { return (r = _toPropertyKey$r(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$r(t) { var i = _toPrimitive$r(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$r(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Marks type for et2_smallpart_videobar::(get|set)Marks()
 */

/**
 * Area of Marks keeping track of it's bounding box
 */
class MarkArea {
  /**
   * Constructor
   *
   * @param mark optional mark(s) to initialise the area
   */
  constructor(mark) {
    _defineProperty$r(this, "marks", []);
    /**
     * Bounding box of marks
     */
    _defineProperty$r(this, "x_min", void 0);
    _defineProperty$r(this, "x_max", void 0);
    _defineProperty$r(this, "y_min", void 0);
    _defineProperty$r(this, "y_max", void 0);
    if (typeof mark !== 'undefined') {
      this.add(mark);
    }
  }

  /**
   * Add mark(s) and update bounding box
   *
   * @param mark
   */
  add(mark) {
    if (Array.isArray(mark)) {
      mark.forEach(mark => this.add(mark));
      return;
    }
    this.marks.push(mark);
    if (typeof this.x_min === 'undefined' || mark.x < this.x_min) this.x_min = mark.x;
    if (typeof this.x_max === 'undefined' || mark.x > this.x_max) this.x_max = mark.x;
    if (typeof this.y_min === 'undefined' || mark.y < this.y_min) this.y_min = mark.y;
    if (typeof this.y_max === 'undefined' || mark.y > this.y_max) this.y_max = mark.y;
  }

  // cache sqrt

  /**
   * Check if given mark touches the area
   *
   * @param mark
   * @param dist_square 0: contained in area, 1: touches top, bottom, left or right (default), 2: touches on corner too
   * @return boolean
   */
  touches(mark, dist_square) {
    if (typeof dist_square === 'undefined') {
      dist_square = 1;
    }
    if (typeof MarkArea.sqrt[dist_square] === 'undefined') {
      MarkArea.sqrt[dist_square] = Math.sqrt(dist_square);
    }
    var dist = MarkArea.sqrt[dist_square];
    var dist_int = Math.floor(dist);

    // 1. check bounding box -> return if not in
    if (mark.x < this.x_min - dist_int || mark.x > this.x_max + dist_int || mark.y < this.y_min - dist_int || mark.y > this.y_max + dist_int) {
      return false;
    }

    // 2. check exact pixel coordinates
    for (var n = this.marks.length - 1; n >= 0; n--) {
      if (MarkArea.distanceSquare(mark, this.marks[n]) <= dist_square) {
        return true;
      }
    }
    return false;
  }

  /**
   * Square of distance between two marks
   *
   * @param a
   * @param b
   */
  static distanceSquare(a, b) {
    return Math.abs(a.x - b.x) ** 2 + Math.abs(a.y - b.y) ** 2;
  }

  /**
   * Merge area with another
   *
   * @param area
   */
  merge(area) {
    if (!area.marks.length) {
      return;
    }
    if (typeof this.x_min === 'undefined' || this.x_min > area.x_min) this.x_min = area.x_min;
    if (typeof this.x_max === 'undefined' || this.x_max < area.x_max) this.x_max = area.x_max;
    if (typeof this.y_min === 'undefined' || this.y_min > area.y_min) this.y_min = area.y_min;
    if (typeof this.y_max === 'undefined' || this.y_max < area.y_max) this.y_max = area.y_max;
    this.marks = this.marks.concat(area.marks);
  }

  /**
   * Videobar pixels are in percent of video with 80 pixel in width direction
   *
   * To ease calculation disjunctive areas and pixel touching them, we need to convert to square pixel of size 1 * 1
   *
   * @param marks
   * @param aspect_ratio
   */
  static squarePixels(marks, aspect_ratio) {
    var squared = [];
    marks.forEach(mark => {
      mark.x = Math.round(mark.x / 1.25);
      mark.y = Math.round(mark.y / 1.25 / aspect_ratio);
      squared.push(mark);
    });
    return squared;
  }

  /**
   * Videobar pixels are in percent of video with 80 pixel in width direction
   *
   * Videobar uses precision of 4, so we need to that round here too!
   *
   * @param marks
   * @param aspect_ratio
   */
  static percentPixels(marks, aspect_ratio) {
    var percent = [];
    marks.forEach(mark => {
      mark.x = parseFloat((mark.x * 1.25).toPrecision(4));
      mark.y = parseFloat((mark.y * 1.25 * aspect_ratio).toPrecision(4));
      percent.push(mark);
    });
    return percent;
  }

  /**
   * Get disjunctive areas
   *
   * Areas are disjunctive, if they do NOT touch each other: all their pixel have a distance bigger dist_square
   *
   * @param marks
   * @param color
   * @param dist_square see touches
   */
  static disjunctiveAreas(marks, color, dist_square) {
    // filter by color, if specified
    if (typeof color !== 'undefined') {
      marks = marks.filter(mark => {
        return mark.c === color;
      });
    }
    var areas = [];
    marks.forEach(mark => {
      if (!areas.length) {
        areas.push(new MarkArea(mark));
        return;
      }
      var touchedArea = undefined;
      for (var n = 0; n < areas.length; n++) {
        var area = areas[n];
        if (area.touches(mark, dist_square)) {
          // mark touches first (existing) area
          if (typeof touchedArea === 'undefined') {
            area.add(mark);
            touchedArea = area;
          }
          // second area touched the new mark, merge both
          else {
            touchedArea.merge(area);
            areas.splice(n, 1);
            n--;
          }
        }
      }
      if (typeof touchedArea === 'undefined') {
        areas.push(new MarkArea(mark));
      }
    });
    return areas;
  }

  /**
   * Color disjunctive areas with their color and different transparency
   *
   * @param marks
   * @param aspect_ratio width/height of video
   * @param dist_square see touches
   */
  static markDisjunctiveAreas(marks, aspect_ratio, dist_square) {
    // get used colors
    var colors = [];
    marks.forEach(mark => {
      if (colors.indexOf(mark.c) === -1) colors.push(mark.c);
    });
    // convert to square pixels with integer coordinates
    var squared = MarkArea.squarePixels(marks, aspect_ratio);
    var marksWA = [];
    colors.forEach(color => {
      // calculate disjunctive areas by color
      var areas = MarkArea.disjunctiveAreas(squared, color, dist_square);
      // and store area index in marks
      areas.forEach((area, idx) => {
        area.marks.forEach(mark => {
          mark.a = idx;
          marksWA.push(mark);
        });
      });
    });
    // convert pixel back to percentage values used by videobar
    return MarkArea.percentPixels(marksWA, aspect_ratio);
  }

  /**
   * Color disjunctive areas with their color and different transparency
   *
   * @param marks
   * @param marking_colors
   */
  static colorDisjunctiveAreas(marks, marking_colors) {
    // get number of used colors
    var colors = {};
    marks.forEach(mark => {
      if (typeof colors[mark.c] === 'undefined' || colors[mark.c] < mark.a) {
        colors[mark.c] = mark.a || 0;
      }
    });
    var coloredMarks = [];
    // and color marks with different transparency
    marks.forEach(mark => {
      coloredMarks.push(_objectSpread$a(_objectSpread$a({}, mark), {}, {
        c: marking_colors[mark.c] + sprintf('%02X', 255 - Math.round(230 / Math.max(4, colors[mark.c] + 1)) * (mark.a || 0))
      }));
    });
    return coloredMarks;
  }
}
_defineProperty$r(MarkArea, "sqrt", {
  0: 0,
  1: 1
});

function _defineProperty$q(e, r, t) { return (r = _toPropertyKey$q(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$q(t) { var i = _toPrimitive$q(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$q(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Methods used when editing a video
 */
class VideoEdit {
  get overlay() {
    var _ref, _this$app;
    return (_ref = (_this$app = this.app) === null || _this$app === void 0 || (_this$app = _this$app.et2) === null || _this$app === void 0 ? void 0 : _this$app.getDOMWidgetById("videooverlay")) !== null && _ref !== void 0 ? _ref : null;
  }
  constructor(app) {
    _defineProperty$q(this, "app", void 0);
    this.app = app;
  }

  /**
   * Add text to the video
   */
  addText() {
    var _this$overlay;
    (_this$overlay = this.overlay) === null || _this$overlay === void 0 || _this$overlay.addText();
  }
  addQuestion() {
    var _this$overlay2;
    (_this$overlay2 = this.overlay) === null || _this$overlay2 === void 0 || _this$overlay2.addQuestion();
  }
}

/**
 * Data of a overlay element
 */

var PlayerMode;

/**
 * Interface for an overlay elements managed by et2_widget_videooverlay
 */
(function (PlayerMode) {
  PlayerMode[PlayerMode["Unchanged"] = 0] = "Unchanged";
  PlayerMode[PlayerMode["Pause"] = 1] = "Pause";
  PlayerMode[PlayerMode["Disable"] = 2] = "Disable";
})(PlayerMode || (PlayerMode = {}));
var et2_IOverlayElement = "et2_IOverlayElement";
et2_implements_registry.et2_IOverlayElement = function (obj) {
  return implements_methods(obj, ["keepRunning"]);
};

/**
 * Interface for an overlay elements managed by et2_widget_videooverlay
 */

var et2_IOverlayElementEditor = "et2_IOverlayElementEditor";
et2_implements_registry.et2_IOverlayElementEditor = function (obj) {
  return implements_methods(obj, ["onSaveCallback"]);
};

/**
 * EGroupware eTemplate2 - JS Checkbox object
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package etemplate
 * @subpackage api
 * @link https://www.egroupware.org
 * @author Nathan Gray
 * @copyright Nathan Gray 2011
 */

/**
 * @deprecated use Et2Checkbox
 */
class et2_checkbox extends Et2Checkbox {}

function _defineProperty$p(e, r, t) { return (r = _toPropertyKey$p(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$p(t) { var i = _toPrimitive$p(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$p(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * type of position used in sliderbar controller
 */

/**
 * slider-controller creates a sliderbar for demonstrating all elements, consists of marking system
 * and selection.
 */
class et2_smallpart_videooverlay_slider_controller extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_videooverlay_slider_controller._attributes, _child || {}));
    _defineProperty$p(this, "onclick_slider_callback", void 0);
    _defineProperty$p(this, "onclick_callback", void 0);
    _defineProperty$p(this, "disable_callback", false);
    _defineProperty$p(this, "marks_positions", []);
    _defineProperty$p(this, "videobar", void 0);
    _defineProperty$p(this, "elements", void 0);
    _defineProperty$p(this, "marks", []);
    _defineProperty$p(this, "_selected", void 0);
    _defineProperty$p(this, "_interval", null);
    _defineProperty$p(this, "div", null);
    this.div = jQuery(document.createElement("div")).addClass("et2_" + super.getType());
    super.setDOMNode(this.div[0]);
  }

  /**
   * Set videobar to use
   *
   * @param _id_or_widget
   */
  set_videobar(_id_or_widget) {
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (_id_or_widget instanceof et2_smallpart_videobar) {
      this.videobar = _id_or_widget;
      var self = this;
      if (this.options.seekable) {
        this.div.on('click', function (e) {
          self.videobar.slider_onclick.call(self.videobar, e);
          if (typeof self.onclick_slider_callback == 'function') self.onclick_slider_callback.call(self, e);
          self.set_seek_position(Math.round(self.videobar._vtimeToSliderPosition(self.videobar.currentTime())));
        });
      }
      this.videobar.video[0].addEventListener("et2_video.onReady." + this.videobar.id, _ => {
        this.getDOMNode().style.width = "".concat(this.videobar.video.width(), "px");
        this.videobar.video[0].addEventListener('et2_video.onTimeUpdate.' + this.videobar.id, _event => {
          self.onTimeUpdate(this.videobar.currentTime());
        });
      });
    }
  }

  /**
   * set given elements as actual marks on sliderbar
   * @param _elements
   */
  set_value(_elements) {
    this.elements = _elements;
    var self = this;
    this._checkVideoIsLoaded().then(_ => {
      var _this$elements;
      this.marks_positions = [];
      this.marks = [];
      for (var i = this.getChildren().length - 1; i >= 0; i--) {
        this.getChildren()[i].remove();
      }
      (_this$elements = this.elements) === null || _this$elements === void 0 || _this$elements.forEach(function (_element, _idx) {
        self.marks[_element.id] = et2_createWidget('description', {
          id: et2_smallpart_videooverlay_slider_controller.mark_id_prefix + _element.id,
          class: 'et2_label'
        }, self);
        if (self.options.seekable) {
          self.marks[_element.id].onclick = function (_event, _widget) {
            _event.stopImmediatePropagation();
            if (self.disable_callback) return;
            if (typeof self.options.onclick_callback == 'function' && self.onclick_callback(_event, _widget)) {
              self.set_selected(_widget);
            }
          };
        }

        //self.marks[_element.id].doLoadingFinished();
        var pos = self._find_position(self.marks_positions, {
          left: self.videobar._vtimeToSliderPosition(_element.starttime),
          width: self.videobar._vtimeToSliderPosition(_element.duration ? _element.duration : 1),
          row: 0
        }, 0);
        self.marks_positions.push(pos);

        // set its actuall position in DOM
        jQuery(self.marks[_element.id].getDOMNode()).css({
          left: pos.left + 'px',
          width: pos.width + 'px',
          top: pos.row * 5 + 3 + 'px',
          "background-color": "".concat(_element.color ? _element.color : '')
        }).attr('data-id', _element.id).addClass(_element.class);
      });
    });
  }

  /**
   * set currently selected mark
   * @param _widget
   */
  set_selected(_widget) {
    if (!_widget) {
      this._clear_selected();
      return;
    }
    this._selected = _widget;
    _widget.set_class("".concat(_widget.class, " selected"));
    this.marks.forEach(function (_mark) {
      if (_mark.id != _widget.id) {
        jQuery(_mark.getDOMNode()).removeClass('selected');
      }
    });
  }

  /**
   * deselect marked element
   */
  _clear_selected() {
    this.marks.forEach(function (_mark) {
      jQuery(_mark.getDOMNode()).removeClass('selected');
    });
  }

  /**
   * get current selected mark
   */
  get_selected() {
    return {
      widget: this._selected,
      id: this._selected.id.split(et2_smallpart_videooverlay_slider_controller.mark_id_prefix)[1]
    };
  }

  /**
   * disable on tag callback function
   * @param _state
   */
  disableCallback(_state) {
    this.disable_callback = _state;
  }

  /**
   * find a free spot on sliderbar for given mark's position
   * @param _marks_postions all current occupide positions
   * @param _pos mark position
   * @param _row initial row to start with
   *
   * @return OverlaySliderControllerMarkPositionType
   * @private
   */
  _find_position(_marks_postions, _pos, _row) {
    if (_marks_postions.length == 0) return {
      left: _pos.left,
      width: _pos.width,
      row: _row
    };
    var conflict = false;
    for (var i of _marks_postions) {
      if (i.row == _row) {
        if (_pos.left > i.left + i.width || _pos.left + _pos.width < i.left) {
          conflict = false;
        } else {
          conflict = true;
          break;
        }
      }
    }
    if (!conflict) return {
      left: _pos.left,
      width: _pos.width,
      row: _row
    };
    return this._find_position(_marks_postions, _pos, _row + 1);
  }
  set_seek_position(_value) {
    var value = Math.floor(_value);
    this.div.css({
      background: 'linear-gradient(90deg, var(--sl-color-neutral-700) ' + value + 'px, var(--sl-color-neutral-600) ' + value + 'px, var(--sl-color-neutral-600) 100%)'
    });
  }

  /**
   * Promise to check the video is loaded
   * @private
   */
  _checkVideoIsLoaded() {
    clearInterval(this._interval);
    return new Promise((_resolved, _rejected) => {
      var _this$videobar;
      if (((_this$videobar = this.videobar) === null || _this$videobar === void 0 ? void 0 : _this$videobar.duration()) > 0) {
        clearInterval(this._interval);
        return _resolved();
      }
      this._interval = setInterval(_ => {
        var _this$videobar2;
        if (((_this$videobar2 = this.videobar) === null || _this$videobar2 === void 0 ? void 0 : _this$videobar2.duration()) > 0) {
          clearInterval(this._interval);
          _resolved();
          return;
        }
      }, 1000);
    });
  }
  resize(_height) {
    if (this.videobar) {
      this.getDOMNode().style.width = "".concat(this.videobar.video[0].clientWidth, "px");
    }
    this.set_value(this.elements);
  }

  /**
   * Periodically called while video is playing to add new overlay elements
   *
   * @param _time
   */
  onTimeUpdate(_time) {
    this.set_seek_position(Math.round(this.videobar._vtimeToSliderPosition(_time)));
  }
}
_defineProperty$p(et2_smallpart_videooverlay_slider_controller, "_attributes", {
  onclick_callback: {
    name: 'click callback',
    type: 'js',
    description: 'callback function on elements'
  },
  videobar: {
    name: 'videobar',
    type: 'string',
    description: 'videobar this overlay is for'
  },
  onclick_slider_callback: {
    name: 'on slider click callback',
    type: 'js',
    description: 'callback function on slider bar'
  },
  seekable: {
    name: 'seekable',
    type: 'boolean',
    description: 'Make slider active for seeking in timeline',
    default: true
  }
});
_defineProperty$p(et2_smallpart_videooverlay_slider_controller, "mark_id_prefix", "slider-tag-");
et2_register_widget(et2_smallpart_videooverlay_slider_controller, ["smallpart-videooverlay-slider-controller"]);

function _defineProperty$o(e, r, t) { return (r = _toPropertyKey$o(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$o(t) { var i = _toPrimitive$o(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$o(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show some html
 */
class et2_smallpart_overlay_html extends et2_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_overlay_html._attributes, _child || {}));
    this.set_class(this.getType());
    this.set_value(_attrs.data);
    jQuery(this.getDOMNode()).css({
      'font-size': egw$1.preference('rte_font_size', 'common') + egw$1.preference('rte_font_unit', 'common'),
      'font-family': egw$1.preference('rte_font', 'common')
    });
    if (typeof _attrs.offset != 'undefined') this.set_offset(_attrs.offset);
  }
  set_offset(_value) {
    jQuery(this.getDOMNode()).css({
      margin: this.options.offset + 'px'
    });
  }

  /**
   * Callback called by parent if user eg. seeks the video to given time
   *
   * @param _time new position of the video
   * @return boolean true: elements wants to continue, false: element requests to be removed
   */
  keepRunning(_time) {
    if (typeof this.options.overlay_duration !== 'undefined') {
      return this.options.overlay_start <= _time && _time < this.options.overlay_start + this.options.overlay_duration;
    }
    return true;
  }
}
_defineProperty$o(et2_smallpart_overlay_html, "_attributes", {
  overlay_id: {
    name: 'overlay_id',
    type: 'integer',
    description: 'database id of element'
  },
  course_id: {
    name: 'course_id',
    type: 'integer',
    description: 'ID of course'
  },
  video_id: {
    name: 'video_id',
    type: 'integer',
    description: 'ID of video'
  },
  overlay_type: {
    name: 'overlay_type',
    type: 'string',
    description: 'type / class-name of overlay element'
  },
  overlay_start: {
    name: 'overlay_start',
    type: 'integer',
    description: 'start-time of element',
    default: 0
  },
  overlay_player_mode: {
    name: 'overlay_player_mode',
    type: 'integer',
    description: 'bit-field: &1 = pause, &2 = disable controls',
    default: 0
  },
  overlay_duration: {
    name: 'duration',
    type: 'integer',
    description: 'how long to show the element, unset of no specific type, eg. depends on user interaction',
    default: 1
  },
  offset: {
    name: 'offset margin',
    type: 'string',
    description: 'offset margin',
    default: 16
  },
  data: {
    name: 'html content',
    type: 'html',
    description: 'the html to display',
    default: ''
  }
});
et2_register_widget(et2_smallpart_overlay_html, ["smallpart-overlay-html"]);

/**
 * Editor widget
 */
class et2_smallpart_overlay_html_editor extends et2_htmlarea {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_overlay_html_editor._attributes, _child || {}));
    _defineProperty$o(this, "offset", 0);
    if (this.options.offset) this.set_offset(this.options.offset);
  }
  set_offset(_value) {
    this.offset = _value;
    if (this.editor) {
      jQuery(this.editor.iframeElement.contentWindow.document.body).css({
        margin: this.offset + 'px'
      });
    }
  }
  doLoadingFinished() {
    var ret = super.doLoadingFinished();
    var self = this;
    this.tinymce.then(function () {
      self.set_offset(self.offset);
    });
    return ret;
  }

  /**
   * Save callback
   * @param _data
   * @param _onSuccessCallback
   */
  onSaveCallback(_data, _onSuccessCallback) {
    var html = this.getValue();
    var data = jQuery.extend(true, _data, {
      'overlay_type': 'smallpart-overlay-html',
      'data': html
    });
    if (this.options.overlay_id) data.overlay_id = this.options.overlay_id;
    egw$1.json('smallpart.\\EGroupware\\SmallParT\\Overlay.ajax_write', [data], function (_overlay_response) {
      data['overlay_id'] = _overlay_response.overlay_id;
      if (typeof _onSuccessCallback == "function") _onSuccessCallback([data]);
    }).sendRequest();
  }
}
_defineProperty$o(et2_smallpart_overlay_html_editor, "_attributes", {
  overlay_id: {
    name: 'overlay_id',
    type: 'integer',
    description: 'database id of element'
  },
  offset: {
    name: 'offset margin',
    type: 'string',
    description: 'offset margin',
    default: 16
  }
});
et2_register_widget(et2_smallpart_overlay_html_editor, ["smallpart-overlay-html-editor"]);

function _defineProperty$n(e, r, t) { return (r = _toPropertyKey$n(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$n(t) { var i = _toPrimitive$n(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$n(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a multiple-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_multiplechoice extends et2_smallpart_overlay_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_multiplechoice._attributes, _child || {}));
  }
  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
        answers: jQuery.extend(true, _attrs.answers, _value.answers)
      })]);
    }
  }
}
_defineProperty$n(et2_smallpart_question_multiplechoice, "_attributes", {
  answers: {
    name: 'possible answers',
    type: 'any',
    description: 'array of objects with attributes answer, correct, ...'
  }
});
et2_register_widget(et2_smallpart_question_multiplechoice, ["smallpart-question-multiplechoice"]);

/**
 * Editor widget for multiple-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_multiplechoice_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_multiplechoice_editor._attributes, _child || {}));
  }
}
_defineProperty$n(et2_smallpart_question_multiplechoice_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_multiplechoice_editor, ["smallpart-question-multiplechoice-editor"]);

function _defineProperty$m(e, r, t) { return (r = _toPropertyKey$m(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$m(t) { var i = _toPrimitive$m(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$m(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a single-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_singlechoice extends et2_smallpart_overlay_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_singlechoice._attributes, _child || {}));
  }
  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
        answer_data: jQuery.extend(true, {}, _attrs.answer_data, _value.answer_data)
      })]);
    }
  }
}
_defineProperty$m(et2_smallpart_question_singlechoice, "_attributes", {
  answers: {
    name: 'possible answers',
    type: 'any',
    description: 'array of objects with attributes answer, correct, ...'
  }
});
et2_register_widget(et2_smallpart_question_singlechoice, ["smallpart-question-singlechoice"]);

/**
 * Editor widget for single-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_singlechoice_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_singlechoice_editor._attributes, _child || {}));
  }
}
_defineProperty$m(et2_smallpart_question_singlechoice_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_singlechoice_editor, ["smallpart-question-singlechoice-editor"]);

function _defineProperty$l(e, r, t) { return (r = _toPropertyKey$l(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$l(t) { var i = _toPrimitive$l(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$l(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a single-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_rating extends et2_smallpart_overlay_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_rating._attributes, _child || {}));
  }
  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
        answer_data: jQuery.extend(true, {}, _attrs.answer_data, _value.answer_data)
      })]);
    }
  }
}
_defineProperty$l(et2_smallpart_question_rating, "_attributes", {
  answers: {
    name: 'possible answers',
    type: 'any',
    description: 'array of objects with attributes answer, correct, ...'
  }
});
et2_register_widget(et2_smallpart_question_rating, ["smallpart-question-rating"]);

/**
 * Editor widget for single-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_rating_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_rating_editor._attributes, _child || {}));
  }
}
_defineProperty$l(et2_smallpart_question_rating_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_rating_editor, ["smallpart-question-rating-editor"]);

function _defineProperty$k(e, r, t) { return (r = _toPropertyKey$k(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$k(t) { var i = _toPrimitive$k(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$k(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a single-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_favorite extends et2_smallpart_overlay_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_favorite._attributes, _child || {}));
  }
  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
        answer_data: jQuery.extend(true, {}, _attrs.answer_data, _value.answer_data)
      })]);
    }
  }
}
_defineProperty$k(et2_smallpart_question_favorite, "_attributes", {});
et2_register_widget(et2_smallpart_question_favorite, ["smallpart-question-favorite"]);

/**
 * Editor widget for single-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_favorite_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_favorite_editor._attributes, _child || {}));
  }
}
_defineProperty$k(et2_smallpart_question_favorite_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_favorite_editor, ["smallpart-question-favorite-editor"]);

function _defineProperty$j(e, r, t) { return (r = _toPropertyKey$j(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$j(t) { var i = _toPrimitive$j(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$j(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a single-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_markchoice extends et2_smallpart_overlay_html {
  //marks = [];

  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    var _app$smallpart;
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_markchoice._attributes, _child || {}));
    _defineProperty$j(this, "videobar", void 0);
    this.videobar = (_app$smallpart = app.smallpart) === null || _app$smallpart === void 0 || (_app$smallpart = _app$smallpart.et2) === null || _app$smallpart === void 0 ? void 0 : _app$smallpart.getWidgetById('video');
    if (this.videobar) {
      var _attrs$answer_data;
      var mark_values = ((_attrs$answer_data = _attrs.answer_data) === null || _attrs$answer_data === void 0 ? void 0 : _attrs$answer_data.marks) || [];
      this.videobar.setMarks(MarkArea.colorDisjunctiveAreas(MarkArea.markDisjunctiveAreas(mark_values, this.videobar.video.width() / this.videobar.video.height()), this.videobar.get_marking_colors()));
      this.videobar.set_marking_enabled(true, mark => console.log(mark));
      this.videobar.set_marking_readonly(true);
      this.videobar.setMarkingMask(true);
    }
  }

  /* controller directly destroys the widget again, no idea why
  destroy()
  {
  	if (this.videobar)
  	{
  		this.videobar.setMarks([]);
  		this.videobar.set_marking_enabled(false);
  		this.videobar.set_marking_readonly(true);
  		this.videobar.setMarkingMask(false);
  	}
  	super.destroy();
  }*/

  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      var _this$videobar;
      var data = jQuery.extend(_attrs, {
        answer_data: {
          marks: (_this$videobar = this.videobar) === null || _this$videobar === void 0 ? void 0 : _this$videobar.getMarks(true)
        }
      });
      // remove marks and mask as video continues
      this.videobar.setMarks([]);
      this.videobar.set_marking_enabled(false);
      this.videobar.set_marking_readonly(true);
      this.videobar.setMarkingMask(false);
      // send data
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [data]);
    }
  }
}
_defineProperty$j(et2_smallpart_question_markchoice, "_attributes", {
  answers: {
    name: 'possible answers',
    type: 'any',
    description: 'array of objects with attributes answer, correct, ...'
  },
  answer_data: {
    name: 'marking areas for correct answers in attribute "marks"',
    type: 'any',
    description: 'array of markings, see et2_smallpart_videobar.setMarks()'
  }
});
et2_register_widget(et2_smallpart_question_markchoice, ["smallpart-question-markchoice"]);

/**
 * Editor widget for single-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_markchoice_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_markchoice_editor._attributes, _child || {}));
  }
}
_defineProperty$j(et2_smallpart_question_markchoice_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_markchoice_editor, ["smallpart-question-markchoice-editor"]);

function _defineProperty$i(e, r, t) { return (r = _toPropertyKey$i(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$i(t) { var i = _toPrimitive$i(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$i(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a single-choice question
 *
 * @ToDo extending et2_smallpart_question_text gives TypeError
 */
class et2_smallpart_question_millout extends et2_smallpart_question_markchoice {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_millout._attributes, _child || {}));
  }
}
_defineProperty$i(et2_smallpart_question_millout, "_attributes", {});
et2_register_widget(et2_smallpart_question_millout, ["smallpart-question-millout"]);

/**
 * Editor widget for single-choice question
 *
 * @ToDo extending et2_smallpart_question_text_editor gives TypeError
 */
class et2_smallpart_question_millout_editor extends et2_smallpart_question_markchoice_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_millout_editor._attributes, _child || {}));
  }
}
_defineProperty$i(et2_smallpart_question_millout_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_millout_editor, ["smallpart-question-millout-editor"]);

function _defineProperty$h(e, r, t) { return (r = _toPropertyKey$h(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$h(t) { var i = _toPrimitive$h(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$h(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Overlay element to show a text question: question with ability to answer with some free text
 */
class et2_smallpart_question_text extends et2_smallpart_overlay_html {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_text._attributes, _child || {}));
  }
  submit(_value, _attrs) {
    console.log(_value, _attrs);
    if (_attrs) {
      return egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
        answer_data: jQuery.extend(true, {}, _attrs.answer_data, _value.answer_data)
      })]);
    }
  }
}
_defineProperty$h(et2_smallpart_question_text, "_attributes", {});
et2_register_widget(et2_smallpart_question_text, ["smallpart-question-text"]);

/**
 * Editor widget for text question
 */
class et2_smallpart_question_text_editor extends et2_smallpart_overlay_html_editor {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_question_text_editor._attributes, _child || {}));
  }
}
_defineProperty$h(et2_smallpart_question_text_editor, "_attributes", {});
et2_register_widget(et2_smallpart_question_text_editor, ["smallpart-question-text-editor"]);

function _defineProperty$g(e, r, t) { return (r = _toPropertyKey$g(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$g(t) { var i = _toPrimitive$g(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$g(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Videooverlay shows time-synchronous to the video various overlay-elements
 *
 * Overlay-elements have a starttime they get created by this overlay widget as it's children.
 * The overlay widgets informs the elements / it's children if user seeks the video, so they
 * can decide, if they should still be shown or removed by the overlay widget.
 *
 * Overlay-elements have a player_mode attribute telling the overlay widget to eg. stop playing the video
 * and/or disable certain player controls to eg. require the user to answer a question.
 *
 * Overlay-elements can call their parent to get themselfs removed, if they are done eg. user
 * answered a question or the duration of a headline is exceeded.
 *
 * @augments et2_baseWidget
 */
class et2_smallpart_videooverlay extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_videooverlay._attributes, _child || {}));
    /**
     * Loaded overlay elements
     */
    _defineProperty$g(this, "elements", void 0);
    /**
     * Keeps current rendered question dialogs
     * @protected
     */
    _defineProperty$g(this, "questionDialogs", []);
    /**
     * Total number of overlay elements (might not all be loaded)
     */
    _defineProperty$g(this, "total", void 0);
    /**
     * Attributes
     */
    _defineProperty$g(this, "course_id", void 0);
    _defineProperty$g(this, "video_id", void 0);
    _defineProperty$g(this, "get_elements_callback", void 0);
    _defineProperty$g(this, "videobar", void 0);
    _defineProperty$g(this, "toolbar_save", void 0);
    _defineProperty$g(this, "toolbar_delete", void 0);
    _defineProperty$g(this, "toolbar_edit", void 0);
    _defineProperty$g(this, "toolbar_cancel", void 0);
    _defineProperty$g(this, "toolbar_add", void 0);
    _defineProperty$g(this, "toolbar_starttime", void 0);
    _defineProperty$g(this, "toolbar_duration", void 0);
    _defineProperty$g(this, "toolbar_offset", void 0);
    _defineProperty$g(this, "toolbar_add_question", void 0);
    _defineProperty$g(this, "toolbar_play", void 0);
    _defineProperty$g(this, "_elementsContainer", null);
    _defineProperty$g(this, "_slider_progressbar", null);
    _defineProperty$g(this, "_elementSlider", null);
    _defineProperty$g(this, "div", void 0);
    _defineProperty$g(this, "_editor", null);
    this.div = jQuery(document.createElement("div")).addClass("et2_" + this.getType());
    if (this.options.editable) {
      this.div.addClass('editable');
    }
    this._elementsContainer = et2_createWidget('hbox', {
      width: "100%",
      height: "100%",
      class: "elementsContainer",
      id: "elementsContainer"
    }, this);
    if (this.options.stop_contextmenu) this.div.on('contextmenu', function () {
      return false;
    });
    this.setDOMNode(this.div[0]);
  }

  /**
   * Set video ID
   *
   * @param _id
   */
  set_video_id(_id) {
    if (_id === this.video_id) return;
    for (var i = this._elementsContainer.getChildren().length - 1; i >= 0; i--) {
      this._elementsContainer.getChildren()[i].destroy();
    }
    this.elements = [];
    this.video_id = _id;
  }

  /**
   * Setter for course_id
   *
   * @param _id
   */
  set_course_id(_id) {
    this.course_id = _id;
  }

  /**
   * Set videobar to use
   *
   * @param _id_or_widget
   */
  set_videobar(_id_or_widget) {
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (_id_or_widget instanceof et2_smallpart_videobar) {
      this.videobar = _id_or_widget;
      var self = this;
      var content = this.videobar.getArrayMgr('content').data;
      var seekable = !!content.is_staff || content.video && !(content.video.video_test_options & et2_smallpart_videobar.video_test_option_not_seekable);
      this.videobar.set_seekable(seekable);

      // allow user to close "more videos" box from youtube iframe
      if (this.videobar.options.src_type.match('youtube')) {
        jQuery(this.videobar.getDOMNode()).on('mouseleave', function () {
          jQuery(self._elementsContainer.getDOMNode()).removeClass('shiftUp');
        });
        jQuery(this._elementsContainer.getDOMNode()).on('mouseenter', function () {
          jQuery(this).addClass('shiftUp');
        }).on('mouseleave', function (e) {
          var _e$toElement;
          if ((e === null || e === void 0 || (_e$toElement = e.toElement) === null || _e$toElement === void 0 ? void 0 : _e$toElement.localName) != "iframe") jQuery(this).removeClass('shiftUp');
        });
      }
      if (seekable) {
        this.videobar.getSliderDOMNode().on('click', function () {
          self.onSeek(self.videobar.currentTime());
        });
      }
      this.videobar.onresize_callback = jQuery.proxy(this._onresize_videobar, this);
      this.videobar.video[0].addEventListener("et2_video.onReady." + this.videobar.id, jQuery.proxy(function () {
        this._videoIsLoaded();
      }, this));
    }
  }
  doLoadingFinished() {
    var ret = super.doLoadingFinished();
    var self = this;
    var content = this.videobar.getArrayMgr('content').data;
    this.set_disabled(!this.video_id);
    this.videobar.ontimeupdate_callback = function (_time) {
      self.onTimeUpdate(_time);
    };
    this._elementSlider = et2_createWidget('smallpart-videooverlay-slider-controller', {
      id: 'text_slider',
      class: 'bi-exclamation-square',
      width: "100%",
      videobar: 'video',
      seekable: !!content.is_staff || content.video && !(content.video.video_test_options & et2_smallpart_videobar.video_test_option_not_seekable),
      onclick_callback: jQuery.proxy(this._elementSlider_callback, this),
      onclick_slider_callback: jQuery.proxy(function () {
        this.onSeek(this.videobar.currentTime());
      }, this)
    }, this);
    return ret;
  }

  /**
   * Click callback called on elements slidebar
   * @param _node
   * @param _widget
   *
   * @return boolean return false when there's an unanswered question
   * @private
   */
  _elementSlider_callback(_node, _widget) {
    var overlay_id = _widget.id.split('slider-tag-')[1];
    var data = this.elements.filter(function (e) {
      if (e.overlay_id == overlay_id) return e;
    });
    if (data[0] && data[0].overlay_id) {
      var _this$toolbar_edit, _this$toolbar_delete;
      this.videobar.seek_video(data[0].overlay_start);
      this.onSeek(data[0].overlay_start);
      if (this._anyUnansweredRequiredQuestions(data[0].overlay_start)) return false;
      this.renderElements(data[0].overlay_id);
      (_this$toolbar_edit = this.toolbar_edit) === null || _this$toolbar_edit === void 0 || _this$toolbar_edit.set_disabled(false);
      (_this$toolbar_delete = this.toolbar_delete) === null || _this$toolbar_delete === void 0 || _this$toolbar_delete.set_disabled(false);
    }
    return true;
  }

  /**
   *
   * @param _id_or_widget
   */
  set_toolbar_save(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_save = this.getButton(_id_or_widget)) {
      this.toolbar_save.onclick = jQuery.proxy(function () {
        var data = {
          'course_id': this.course_id,
          'video_id': this.video_id,
          'overlay_duration': parseInt(this.toolbar_duration.getValue()),
          'overlay_start': parseInt(this.toolbar_starttime.getValue()),
          'offset': parseInt(this.toolbar_offset.getValue()),
          'width': this.videobar.video.width()
        };
        var self = this;
        this._editor.onSaveCallback(data, function (_data) {
          var exist = false;
          self.elements.forEach(function (_e, _index) {
            if (_e.overlay_id == _data[0].overlay_id) {
              exist = true;
              self.elements[_index] = _data[0];
            }
          });
          if (!exist) self.elements = self.elements.concat(..._data);
          self.renderElements();
          self.renderElements(_data[0].overlay_id);
        });
        this._enable_toolbar_edit_mode(false, false);
        this._editor.destroy();
      }, this);
    }
  }
  set_toolbar_edit(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_edit = this.getButton(_id_or_widget)) {
      this.toolbar_edit.onclick = jQuery.proxy(function () {
        var _this$_elementSlider;
        this._enable_toolbar_edit_mode(true, true);
        var overlay_id = parseInt((_this$_elementSlider = this._elementSlider) === null || _this$_elementSlider === void 0 ? void 0 : _this$_elementSlider.get_selected().id);
        var data = this.elements.filter(function (e) {
          if (e.overlay_id == overlay_id) return e;
        });
        switch (data[0].overlay_type) {
          case "smallpart-overlay-html":
            this._editor = et2_createWidget('smallpart-overlay-html-editor', {
              width: "100%",
              height: "100%",
              class: "smallpart-overlay-element",
              mode: "simple",
              offset: data[0].offset,
              statusbar: false,
              overlay_id: data[0].overlay_id,
              imageUpload: 'html_editor_upload'
            }, this._elementsContainer);
            this._editor.toolbar = "";
            this._editor.set_value(data[0].data);
            this._editor.doLoadingFinished();
            break;
          default:
          case "smallpart-question-text":
          case "smallpart-question-singlechoice":
          case "smallpart-question-multiplechoice":
            this._enable_toolbar_edit_mode(false, false);
            egw$1.open_link(egw$1.link('/index.php', {
              menuaction: 'smallpart.EGroupware\\SmallParT\\Questions.edit',
              overlay_id: data[0].overlay_id,
              video_id: this.video_id
            }), '_blank', '800x600', 'smallpart');
            return;
        }
        this.toolbar_offset.set_value(data[0].offset);
        this.toolbar_duration.set_value(data[0].overlay_duration);
        this.toolbar_starttime.set_value(data[0].overlay_start);
      }, this);
    }
  }

  // noinspection JSUnusedLocalSymbols
  /**
   * Set state for toolbar actions
   * @param _state
   * @param _deleteEnabled
   * @private
   */
  _enable_toolbar_edit_mode(_state, _deleteEnabled) {
    this.toolbar_edit.set_disabled(true);
    this.getDOMNode().querySelector(".overlay_toolbar").hidden = !_state;
    if (_state) {
      var _this$_elementSlider2;
      this.toolbar_starttime.set_value(Math.floor(this.videobar.currentTime()));
      this.toolbar_duration.set_max(Math.floor(this.videobar.duration() - this.toolbar_starttime.getValue()));
      this.videobar.pause_video();
      // slider progressbar span
      this._slider_progressbar = jQuery(document.createElement('span')).addClass('overlay_slider_progressbar').css({
        left: this.videobar._vtimeToSliderPosition(parseInt(this.toolbar_starttime.getValue())),
        width: this.videobar._vtimeToSliderPosition(parseInt(this.toolbar_duration.getValue()))
      }).appendTo(this.videobar.getSliderDOMNode());
      jQuery(this.getDOMNode()).addClass('editmode');
      (_this$_elementSlider2 = this._elementSlider) === null || _this$_elementSlider2 === void 0 || _this$_elementSlider2.set_disabled(true);
      this._elementsContainer.getChildren().forEach(_widget => {
        if (_widget.set_disabled) _widget.set_disabled(true);
      });
    } else {
      var _this$_elementSlider3;
      (_this$_elementSlider3 = this._elementSlider) === null || _this$_elementSlider3 === void 0 || _this$_elementSlider3.set_disabled(false);
      jQuery(this.getDOMNode()).removeClass('editmode');
      if (this.toolbar_duration) this.toolbar_duration.set_value(1);
      if (this._slider_progressbar) this._slider_progressbar.remove();
      this._elementsContainer.getChildren().forEach(_widget => {
        if (_widget.set_disabled) _widget.set_disabled(false);
      });
    }
    this.toolbar_save.set_disabled(!_state);
    this.toolbar_delete.set_disabled(!(_state && _deleteEnabled));
    this.toolbar_duration.set_disabled(!_state);
    this.toolbar_offset.set_disabled(!_state);
    this.toolbar_starttime.set_disabled(!_state);
    this.toolbar_cancel.set_disabled(!_state);
    this.toolbar_starttime.set_readonly(true);
  }
  set_toolbar_cancel(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_cancel = this.getButton(_id_or_widget)) {
      this.toolbar_cancel.onclick = jQuery.proxy(function () {
        this._enable_toolbar_edit_mode(false, false);
        this._editor.destroy();
      }, this);
    }
  }
  set_toolbar_delete(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_delete = this.getButton(_id_or_widget)) {
      this.toolbar_delete.onclick = jQuery.proxy(function () {
        var _this$_elementSlider4;
        var self = this;
        var overlay_id = parseInt((_this$_elementSlider4 = this._elementSlider) === null || _this$_elementSlider4 === void 0 ? void 0 : _this$_elementSlider4.get_selected().id);
        var data = this.elements.filter(_el => {
          if (_el.overlay_id == overlay_id) return _el;
        });
        var message = data[0].overlay_type.match(/smallpart-question-/) ? 'Delete this question incl. possible answers from students?' : 'Are you sure you want to delete this element?';
        et2_dialog.show_dialog(function (_btn) {
          if (_btn == et2_dialog.YES_BUTTON) {
            self._enable_toolbar_edit_mode(false);
            var element = self._get_element(overlay_id);
            egw$1.json('smallpart.\\EGroupware\\SmallParT\\Overlay.ajax_delete', [{
              course_id: self.options.course_id,
              video_id: self.options.video_id,
              overlay_id: overlay_id,
              overlay_type: data[0].overlay_type
            }], function (_overlay_response) {
              if (element) self.deleteElement(element);
              self._delete_element(overlay_id);
              self.renderElements();
            }).sendRequest();
            if (self._is_in_editmode()) self._editor.destroy();
          }
        }, message, data[0].overlay_type.match(/smallpart-question-/) ? "Delete question" : "Delete overlay", null, et2_dialog.BUTTONS_YES_NO);
      }, this);
    }
  }
  set_toolbar_starttime(_id_or_widget) {
    if (!this.options.editable) return;
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (_id_or_widget instanceof et2_number) {
      this.toolbar_starttime = _id_or_widget;
      this.toolbar_starttime.set_min(0);
      this.toolbar_starttime.set_max(this.videobar.duration());
      this.toolbar_starttime.set_value(this.videobar.currentTime());
    }
  }
  set_toolbar_duration(_id_or_widget) {
    if (!this.options.editable) return;
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (_id_or_widget instanceof et2_number) {
      this.toolbar_duration = _id_or_widget;
      this.toolbar_duration.set_min(0);
      this.toolbar_duration.onchange = jQuery.proxy(function (_node, _widget) {
        if (this._slider_progressbar) this._slider_progressbar.css({
          width: this.videobar._vtimeToSliderPosition(parseInt(_widget.getValue()))
        });
      }, this);
    }
  }
  set_toolbar_offset(_id_or_widget) {
    if (!this.options.editable) return;
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (_id_or_widget instanceof et2_number) {
      this.toolbar_offset = _id_or_widget;
      this.toolbar_offset.onchange = jQuery.proxy(function (_node, _widget) {
        if (this._editor && this._editor.set_offset) {
          this._editor.set_offset(_widget.getValue());
        }
      }, this);
    }
  }
  set_toolbar_add(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_add = this.getButton(_id_or_widget)) {
      this.toolbar_add.onclick = jQuery.proxy(function (_node, _widget) {
        this._enable_toolbar_edit_mode(true, false);
        this.toolbar_duration.set_value(1);
        this.toolbar_offset.set_value(16);
        this._editor = et2_createWidget('smallpart-overlay-html-editor', {
          width: "100%",
          height: "100%",
          class: "smallpart-overlay-element",
          mode: "simple",
          offset: this.toolbar_offset.getValue(),
          statusbar: false,
          imageUpload: "html_editor_upload"
        }, this._elementsContainer);
        this._editor.toolbar = "";
        this._editor.doLoadingFinished();
      }, this);
    }
  }

  /**
   * Add text to the video
   */
  addText() {
    this._enable_toolbar_edit_mode(true, false);
    this.toolbar_duration.set_value(1);
    this.toolbar_offset.set_value(16);
    this._editor = et2_createWidget('smallpart-overlay-html-editor', {
      width: "100%",
      height: "100%",
      class: "smallpart-overlay-element",
      mode: "simple",
      offset: this.toolbar_offset.getValue(),
      statusbar: false,
      imageUpload: "html_editor_upload"
    }, this._elementsContainer);
    this._editor.toolbar = "";
    this._editor.doLoadingFinished();
  }
  set_toolbar_add_question(_id_or_widget) {
    if (!this.options.editable) return;
    if (this.toolbar_add_question = this.getButton(_id_or_widget)) {
      this.toolbar_add_question.onclick = jQuery.proxy(function () {
        egw$1.open_link(egw$1.link('/index.php', {
          menuaction: 'smallpart.EGroupware\\SmallParT\\Questions.edit',
          overlay_start: Math.floor(this.videobar.currentTime()),
          overlay_duration: 1,
          overlay_type: "smallpart-question-text",
          video_id: this.video_id
        }), '_blank', '800x600', 'smallpart');
        if (!this.videobar.paused()) app.smallpart.et2.getDOMWidgetById('play').getDOMNode().click();
      }, this);
    }
  }
  addQuestion() {
    egw$1.open_link(egw$1.link('/index.php', {
      menuaction: 'smallpart.EGroupware\\SmallParT\\Questions.edit',
      overlay_start: Math.floor(this.videobar.currentTime()),
      overlay_duration: 1,
      overlay_type: "smallpart-question-text",
      video_id: this.video_id
    }), '_blank', '800x600', 'smallpart');
    if (!this.videobar.paused()) {
      app.smallpart.et2.getDOMWidgetById('play').getDOMNode().click();
    }
  }
  set_toolbar_play(_id_or_widget) {
    this.toolbar_play = this.getButton(_id_or_widget);
  }
  getButton(_id_or_widget) {
    var _id_or_widget2, _id_or_widget3;
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (((_id_or_widget2 = _id_or_widget) === null || _id_or_widget2 === void 0 ? void 0 : _id_or_widget2.tagName) === 'ET2-BUTTON' || ((_id_or_widget3 = _id_or_widget) === null || _id_or_widget3 === void 0 ? void 0 : _id_or_widget3.tagName) === 'ET2-BUTTON-ICON' || _id_or_widget instanceof et2_button) {
      return _id_or_widget;
    }
  }

  // noinspection JSUnusedLocalSymbols
  /**
   * After video is fully loaded
   * @private
   */
  _videoIsLoaded() {
    var _this$toolbar_duratio;
    (_this$toolbar_duratio = this.toolbar_duration) === null || _this$toolbar_duratio === void 0 || _this$toolbar_duratio.set_max(this.videobar.duration() - this.toolbar_starttime.getValue());
    this.fetchElements(0).then(() => {
      this.renderElements();
      this.onSeek(parseFloat(this.videobar.options.starttime));
      if (!this.options.editable && !this.elements.length) {
        var _this$_elementSlider5;
        (_this$_elementSlider5 = this._elementSlider) === null || _this$_elementSlider5 === void 0 || _this$_elementSlider5.set_disabled(true);
      } else {
        var _this$_elementSlider6;
        (_this$_elementSlider6 = this._elementSlider) === null || _this$_elementSlider6 === void 0 || _this$_elementSlider6.set_disabled(false);
      }
    });
  }

  /**
   * Renders all elements
   *
   * @param _overlay_id id of changed overlay element to fetch, otherwise nothing will be fetched
   */
  renderElements(_overlay_id) {
    if (this.options.test_display == 3) return; // nothing to do
    var self = this;
    if (this._elementsContainer.getChildren().length > 0) {
      this._elementsContainer.getChildren().forEach(function (_widget) {
        if (_overlay_id && _overlay_id == _widget.options.overlay_id) {
          _widget.destroy();
          self.fetchElement(_overlay_id).then(function (_attrs) {
            self.createElement(_attrs);
          }, function () {
            // try to fetch elements maybe added from outside
            self.fetchElements(0).then(function () {
              self.renderElements();
            });
          });
        } else {
          _widget.destroy();
        }
      });
    }
    if (this._elementsContainer.getChildren().length == 0 && _overlay_id) {
      this.fetchElement(_overlay_id).then(function (_attrs) {
        self.createElement(_attrs);
      }, function () {
        // try to fetch elements maybe added from outside
        self.fetchElements(0).then(function () {
          self.renderElements();
        });
      });
    }
    if (typeof _overlay_id == 'undefined') {
      var _this$_elementSlider7;
      var sliderData = this.elements.map(_el => {
        return {
          id: _el.overlay_id,
          starttime: _el.overlay_start,
          duration: _el.overlay_duration,
          class: _el.overlay_type.match(/-question-/) ? _el.overlay_question_mode != et2_smallpart_videooverlay.overlay_question_mode_skipable ? 'overlay-question-required' : 'overlay-question' : ''
        };
      });
      (_this$_elementSlider7 = this._elementSlider) === null || _this$_elementSlider7 === void 0 || _this$_elementSlider7.set_value(sliderData);
    }
  }

  /**
   * Load overlay elements from server
   *
   * @param _start
   * @return Promise<Array<OverlayElement>>
   */
  fetchElements(_start) {
    if (!_start) {
      this.elements = [];
      this.total = 0;
    }
    if (!this.options.get_elements_callback || this.options.test_display == 3) {
      return Promise.resolve([]);
    }
    // fetch first chunk of overlay elements
    return this.egw().json(this.options.get_elements_callback, [{
      video_id: this.video_id,
      course_id: this.course_id
    }, _start], function (_data) {
      if (typeof _data === 'object' && Array.isArray(_data.elements)) {
        if (this.elements.length === 0) {
          this.elements = jQuery.extend(true, [], _data.elements);
        } else {
          _data.elements.forEach(function (element) {
            for (var i in this.elements) {
              if (this.elements[i].overlay_id === element.overlay_id) {
                this.elements[i] = jQuery.extend(true, {}, element);
                return;
              }
            }
            this.elements.concat(jQuery.extend(true, {}, element));
          }.bind(this));
        }
        this.total = _data.total;
        return Promise.resolve(this.elements);
      }
    }.bind(this)).sendRequest();
  }

  /**
   * Return given overlay element, load it if necessary from server
   *
   * @param _overlay_id
   * @return Promise<OverlayElement>
   */
  fetchElement(_overlay_id) {
    var element = this.elements.filter(_element => _element.overlay_id === _overlay_id)[0];
    if (typeof element !== "undefined" && element.data !== false) {
      return Promise.resolve(jQuery.extend(true, {}, element));
    }
    if (this.elements.length === this.total) {
      return Promise.reject("No overlay_id {_overlay_id}!");
    }
    this.fetchElements(this.elements.length).then(function () {
      return this.fetchElement(_overlay_id);
    }.bind(this));
  }

  /**
   * check if the editor is active
   * @private
   */
  _is_in_editmode() {
    return this._editor && this._editor.getDOMNode();
  }

  /**
   * Called when video is seeked to a certain position to create and remove elements
   *
   * Every running element / child is asked if it want's to keep running.
   *
   * @param _time
   */
  onSeek(_time) {
    if (this._is_in_editmode())
      // update startime if it's in editmode
      {
        this.toolbar_starttime.set_value(Math.floor(_time));
        this._slider_progressbar.css({
          left: this.videobar._vtimeToSliderPosition(parseInt(this.toolbar_starttime.getValue())),
          width: this.videobar._vtimeToSliderPosition(parseInt(this.toolbar_duration.getValue()))
        });
        return;
      }
    this.onTimeUpdate(_time);
  }

  /**
   *
   * @param time
   * @return OverlayElement|undefined returns overlay object
   * @private
   */
  _anyUnansweredRequiredQuestions(time) {
    var _this$getArrayMgr;
    var overlay = undefined;
    var video = (_this$getArrayMgr = this.getArrayMgr('content')) === null || _this$getArrayMgr === void 0 ? void 0 : _this$getArrayMgr.getEntry('video');
    if (video && (video['video_published'] == et2_smallpart_videobar.video_test_published_readonly || video['video_published'] == et2_smallpart_videobar.video_test_published_draft)) return overlay;
    this.elements.forEach(el => {
      if (el.overlay_start + el.overlay_duration < time && el.overlay_question_mode != et2_smallpart_videooverlay.overlay_question_mode_skipable && !el.answer_created && el.question_n) {
        overlay = el;
        return;
      }
    });
    // makes sure the video stops when there's an overlay found
    if (overlay && !this.videobar.paused()) this.toolbar_play.click(null);
    return overlay;
  }

  /**
   * Periodically called while video is playing to add new overlay elements
   *
   * @param _time
   */
  onTimeUpdate(_time) {
    var ol;
    if (ol = this._anyUnansweredRequiredQuestions(_time)) {
      // duration must be set 0.1 sec before the end time otherwise we can't create the element
      var ol_duration = ol.overlay_start + ol.overlay_duration - 0.1;
      this.videobar.seek_video(ol_duration);
      this.onTimeUpdate(ol_duration);
      _time = ol_duration;
      return false;
    }
    // check if we seeking behind the last loaded element and there are more to fetch
    if (this.total > this.elements.length && _time > this.elements[this.elements.length - 1].overlay_start) {
      this.fetchElements(this.elements.length).then(() => this.onTimeUpdate(_time));
      return;
    }
    var running = [];
    this._elementsContainer.iterateOver(function (_widget) {
      if (!_widget.keepRunning(_time)) {
        this.deleteElement(_widget);
        return;
      }
      running.push(_widget.options.overlay_id);
    }.bind(this), this, et2_IOverlayElement);
    this.elements.forEach(function (_element, _idx) {
      if (running.indexOf(_element.overlay_id) === -1 && _element.overlay_start <= _time && _time < _element.overlay_start + (_element.overlay_duration || 1)) {
        this.createElement(_element);

        // fetch more elements, if we are reaching the end of the loaded ones
        if (this.total > this.elements.length && _idx > this.elements.length - 10) {
          this.fetchElements(this.elements.length);
        }
      }
    }.bind(this));
  }

  /**
   * Called by element to be removed when it's done
   *
   * @param _widget
   */
  deleteElement(_widget) {
    _widget.destroy();
    this._elementsContainer.removeChild(_widget);
  }

  /**
   * Create / show an overlay-element and add it to children
   *
   * @param _attrs
   */
  createElement(_attrs) {
    // do not create overlays when slider is in disabled mode (e.g. a comment being edited)
    if (this.getElementSlider().disable_callback) return;
    var isQuestionOverlay = _attrs.overlay_type.match(/-question-/);
    // prevent creating an element if already exists
    for (var _widget of this._elementsContainer.getChildren()) {
      if (_widget.options.overlay_id == _attrs.overlay_id) {
        return;
      }
    }
    // let other overlays being created as normal
    if (isQuestionOverlay) {
      this._removeExcessiveDialogs();
      var isSorted = true;
      for (var i = 0; i < this.questionDialogs.length; i++) {
        if (i > 1 && this.questionDialogs[i].question_n < this.questionDialogs[i - 1].question_n) {
          isSorted = false;
          break;
        }
      }
      if (!isSorted) {
        var sorted = [];
        Object.assign(sorted, this.questionDialogs);
        this.questionDialogs.sort((a, b) => {
          return a.question_n < b.question_n ? -1 : 1;
        });
        Object.assign(sorted, this.questionDialogs);
        sorted.forEach(_d => {
          this._questionDialogs(_d.id)._remove();
        });
        sorted.forEach(_d => {
          this.createElement(_d.dialog.options.value.content);
        });
      }
      if (this._questionDialogs(_attrs.overlay_id)._get()) {
        return;
      }
    }
    var widget = et2_createWidget(_attrs.overlay_type, jQuery.extend(true, {}, _attrs), this._elementsContainer);
    this._elementsContainer.addChild(widget);
    this._elementsContainer.getChildren().forEach(_w => {
      var zoom = this.videobar.video.width() / _attrs.width;
      jQuery(_w.getDOMNode()).children().css({
        'zoom': zoom
      });
    });
    if (_attrs.overlay_player_mode & PlayerMode.Pause) {
      var _this$videobar;
      (_this$videobar = this.videobar) === null || _this$videobar === void 0 || _this$videobar.pause_video();
    }
    if (_attrs.overlay_player_mode & PlayerMode.Disable) {
      // ToDo: this.videobar?.
    }
    if (isQuestionOverlay) {
      this._questionDialogs(_attrs.overlay_id)._add(this._createQuestionElement(_attrs, widget));
    }
  }

  /**
   * Manages question dialogs objects
   * @param _overlay_id
   *
   * @return returns as object of controllers
   *  _add : add dialog of overlay
   *  _remove : remove the dialg of given overlay
   *  _get : get dialog of givern overlay
   * @private
   */
  _questionDialogs(_overlay_id) {
    var self = this;
    return {
      _add: function _add(_dialog) {
        if (!self._questionDialogs(_overlay_id)._get()) {
          self.questionDialogs.push({
            id: _overlay_id,
            dialog: _dialog,
            question_n: parseInt(_dialog.options.value.content.question_n),
            content: _dialog.options.value.content
          });
        }
      },
      _remove: function _remove() {
        if (self.questionDialogs) {
          self.questionDialogs.forEach((o, i) => {
            if (o.id == _overlay_id) {
              o.dialog.destroy();
              self.questionDialogs.splice(i, 1);
            }
          });
        }
      },
      _get: function _get() {
        var _self$questionDialogs;
        if (((_self$questionDialogs = self.questionDialogs) === null || _self$questionDialogs === void 0 ? void 0 : _self$questionDialogs.length) > 0) {
          var res = self.questionDialogs.filter(o => {
            return o.id == _overlay_id;
          });
          return (res === null || res === void 0 ? void 0 : res.length) > 0 ? res : false;
        } else {
          return false;
        }
      }
    };
  }
  /**
   *
   * @param _attrs
   * @param _widget
   *
   * @return Et2Dialog
   * @private
   */
  _createQuestionElement(_attrs, _widget) {
    _widget.set_disabled(true);
    var video = this.getArrayMgr('content').getEntry('video');
    _attrs.account_id = egw$1.user('account_id');
    var pauseSwitch = false;
    var attrs = _attrs;
    var pause_callback = function pause_callback() {
      if (pauseSwitch && self.videobar.currentTime() >= attrs.overlay_start + attrs.overlay_duration && !attrs.answer_created) {
        // pasue the video at the end of the question
        self.toolbar_play.click(null);
        if (parseInt(attrs.overlay_question_mode) == et2_smallpart_videooverlay.overlay_question_mode_skipable) {
          self.toolbar_play.getDOMNode().addEventListener('click', function () {
            self._questionDialogs(attrs.overlay_id)._remove();
          }, {
            once: true
          });
        }
        self.videobar.video[0].removeEventListener('et2_video.onTimeUpdate.' + self.videobar.id, pause_callback);
      }
    };
    var is_readonly = video.video_published == et2_smallpart_videobar.video_test_published_readonly;
    var modal = false;
    var self = this;
    var buttons = [{
      "text": this.egw().lang('Save'),
      id: 'submit',
      image: 'check',
      "default": true
    }, {
      "text": this.egw().lang('Skip'),
      id: 'skip',
      image: 'cancel'
    }].filter(b => {
      if (is_readonly) {
        return b.id == "skip";
      }
      switch (parseInt(_attrs.overlay_question_mode)) {
        case et2_smallpart_videooverlay.overlay_question_mode_skipable:
          return true;
        case et2_smallpart_videooverlay.overlay_question_mode_reqires:
        case et2_smallpart_videooverlay.overlay_question_mode_required_limitted_time:
          return b.id != "skip";
      }
    });
    switch (parseInt(_attrs.overlay_question_mode)) {
      case et2_smallpart_videooverlay.overlay_question_mode_skipable:
      case et2_smallpart_videooverlay.overlay_question_mode_reqires:
        if (!is_readonly) {
          pauseSwitch = true;
          this.videobar.video[0].addEventListener('et2_video.onTimeUpdate.' + this.videobar.id, pause_callback);
        }
        if (_attrs.overlay_question_mode == et2_smallpart_videooverlay.overlay_question_mode_skipable || _attrs.answer_created) {
          this.videobar.video[0].addEventListener('et2_video.onTimeUpdate.' + this.videobar.id, function (_time) {
            self._removeExcessiveDialogs();
          });
        }
        break;
      case et2_smallpart_videooverlay.overlay_question_mode_required_limitted_time:
        break;
    }
    var error_msg;
    var dialog = et2_createWidget("et2-dialog", {
      callback: function callback(_btn, _value) {
        if (error_msg) {
          error_msg.close();
          error_msg = null;
        }
        // check required minimum number of answers are given
        // ToDo: this should come from the et2_smallpart_question_multiplechoice object or app.ts
        if (_attrs.min_answers && _attrs.overlay_type === 'smallpart-question-multiplechoice') {
          var _this$eTemplate$widge;
          var checked = 0;
          (_this$eTemplate$widge = this.eTemplate.widgetContainer.getWidgetById('answers')) === null || _this$eTemplate$widge === void 0 || _this$eTemplate$widge.iterateOver(function (_checkbox) {
            if (_checkbox.get_value()) checked++;
          }, this, et2_checkbox);
          if (checked < _attrs.min_answers) {
            error_msg = egw$1(parent).message(egw$1(parent).lang('A minimum of %1 answers need to be checked!', _attrs.min_answers), 'error');
            return false;
          }
        }
        if ((_btn == 'skip' || _btn == 'submit') && self.videobar.paused() && !self.videobar.ended()) {
          if (self.questionDialogs.length == 1) {
            self.toolbar_play.click(null);
          } else {
            self._questionDialogs(_attrs.overlay_id)._remove();
          }
        }
        if (_btn == 'submit' && _value && !is_readonly) {
          egw$1.request('smallpart.EGroupware\\SmallParT\\Questions.ajax_answer', [jQuery.extend(_attrs, {
            answer_data: jQuery.extend(true, {}, _attrs.answer_data, _value.answer_data)
          })]).then(_result => {
            if (_result && typeof _result.error === 'undefined') {
              self._update_element(_attrs.overlay_id, _result);
            }
          });
        }
        pauseSwitch = false;
      },
      title: this.egw().lang('Question number %1', _attrs.question_n),
      buttons: buttons,
      value: {
        content: _attrs,
        readonlys: is_readonly ? {
          '__ALL__': true
        } : {}
      },
      draggable: video.video_test_display == et2_smallpart_videobar.video_test_display_dialog,
      resizable: false,
      hideOnEscape: false,
      noCloseButton: true,
      dialogClass: 'questionDisplayBox',
      template: _attrs.template_url || egw$1.webserverUrl + '/smallpart/templates/default/question.' + _attrs.overlay_type.replace('smallpart-question-', '') + '.xet'
    }, et2_dialog._create_parent('smallpart'));
    var dialogParent = video.video_test_display != et2_smallpart_videobar.video_test_display_dialog ? _widget.getWidgetById(video.video_test_display == et2_smallpart_videobar.video_test_display_on_video ? ".et2_smallpart-videooverlay" : ".rightBoxArea") : '';
    (dialogParent || document.body).append(dialog);
    return dialog;
  }
  _removeExcessiveDialogs() {
    if (this.questionDialogs) {
      // go through all dialogs and remove which are not in display time
      this.questionDialogs.forEach(d => {
        var _d$content, _d$content2, _d$content3;
        if (d.content && this.videobar.currentTime() < ((_d$content = d.content) === null || _d$content === void 0 ? void 0 : _d$content.overlay_start) || this.videobar.currentTime() > ((_d$content2 = d.content) === null || _d$content2 === void 0 ? void 0 : _d$content2.overlay_start) + ((_d$content3 = d.content) === null || _d$content3 === void 0 ? void 0 : _d$content3.overlay_duration) + 1) {
          var _d$content4;
          this._questionDialogs((_d$content4 = d.content) === null || _d$content4 === void 0 ? void 0 : _d$content4.overlay_id)._remove();
        }
      });
    }
  }
  _onresize_videobar(_width, _height, _position) {
    var _this$_elementSlider8;
    if (this._elementSlider) jQuery(this._elementSlider.getDOMNode()).css({
      width: _width
    });
    (_this$_elementSlider8 = this._elementSlider) === null || _this$_elementSlider8 === void 0 || _this$_elementSlider8.set_seek_position(_position);
    this.renderElements();
    this.onSeek(this.videobar.currentTime());
  }

  /**
   * get element widget from elements container
   * @param _overlay_id
   *
   * @return et2_IOverlayElement
   */
  _get_element(_overlay_id) {
    var element = null;
    this._elementsContainer.iterateOver(function (_widget) {
      if (_widget.options.overlay_id == _overlay_id) {
        element = _widget;
      }
    }.bind(this), this, et2_IOverlayElement);
    return element;
  }

  /**
   * delete given overlay id from fetched elements object
   * @param _overlay_id
   */
  _delete_element(_overlay_id) {
    for (var i = 0; i < this.elements.length; i++) {
      if (this.elements[i]['overlay_id'] == _overlay_id) {
        this.elements.splice(i, 1);
      }
    }
  }

  /**
   * client-side update update element data
   * @param _overlay_id
   * @param _data
   */
  _update_element(_overlay_id, _data) {
    for (var i = 0; i < this.elements.length; i++) {
      if (this.elements[i]['overlay_id'] == _overlay_id) {
        this.elements[i] = _data;
      }
    }
  }
  getElementSlider() {
    return this._elementSlider;
  }
}
_defineProperty$g(et2_smallpart_videooverlay, "_attributes", {
  course_id: {
    name: 'course_id',
    type: 'integer',
    description: 'ID of course, required for server-side ACL check'
  },
  video_id: {
    name: 'video_id',
    type: 'integer',
    description: 'ID of video to load overlay for'
  },
  get_elements_callback: {
    name: 'get_elements_callback',
    type: 'string',
    description: 'menuaction to request elements of given video_id starting from given overlay_start time'
  },
  videobar: {
    name: 'videobar',
    type: 'string',
    description: 'videobar this overlay is for'
  },
  toolbar_save: {
    name: 'toolbar save',
    type: 'string',
    description: 'Save button in top bar controller'
  },
  toolbar_edit: {
    name: 'toolbar edit',
    type: 'string',
    description: 'edit button in top bar controller'
  },
  toolbar_cancel: {
    name: 'toolbar cancel',
    type: 'string',
    description: 'cancel button in top bar controller'
  },
  toolbar_delete: {
    name: 'toolbar delete',
    type: 'string',
    description: 'delete button in top bar controller'
  },
  toolbar_add: {
    name: 'toolbar add',
    type: 'string',
    description: 'Add button in top bar controller'
  },
  toolbar_add_question: {
    name: 'toolbar add question',
    type: 'string',
    description: 'Add question button in top bar controller'
  },
  toolbar_starttime: {
    name: 'toolbar starttime',
    type: 'string',
    description: 'start-time in top bar controller'
  },
  toolbar_duration: {
    name: 'toolbar duration',
    type: 'string',
    description: 'Duration time button in top bar controller'
  },
  toolbar_offset: {
    name: 'toolbar offset',
    type: 'string',
    description: 'offset margin',
    default: 16
  },
  toolbar_play: {
    name: 'toolbar play',
    type: 'string',
    description: 'play button'
  },
  editable: {
    name: 'Editable',
    type: 'boolean',
    description: 'Make overlay editable'
  },
  stop_contextmenu: {
    name: "stop contextmenu",
    type: "boolean",
    description: "This would prevent the browser native contextmenu on video tag",
    default: true
  },
  test_display: {
    name: "test display",
    type: "integer",
    description: "0: instead comments, 1: dialog, 2: overlay, 3: list (switches controller off!)",
    default: 0
  }
});
_defineProperty$g(et2_smallpart_videooverlay, "overlay_question_mode_skipable", 0);
_defineProperty$g(et2_smallpart_videooverlay, "overlay_question_mode_reqires", 1);
_defineProperty$g(et2_smallpart_videooverlay, "overlay_question_mode_required_limitted_time", 2);
et2_register_widget(et2_smallpart_videooverlay, ["smallpart-videooverlay"]);

function _defineProperty$f(e, r, t) { return (r = _toPropertyKey$f(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$f(t) { var i = _toPrimitive$f(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$f(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Class which implements the "radiobox" XET-Tag
 *
 * A radio button belongs to same group by giving all buttons of a group same id!
 *
 * set_value iterates over all of them and (un)checks them depending on given value.
 *
 * @augments et2_inputWidget
 */
class et2_smallpart_color_radiobox extends et2_radiobox {
  /**
   * Constructor
   *
   * @memberOf et2_radiobox_ro
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_color_radiobox._attributes, _child || {}));
    _defineProperty$f(this, "container", null);
  }

  /**
   * Override the getTooltipElement because the domnode gets manipulated in loading finished
   */
  getTooltipElement() {
    return this.container[0];
  }
  loadingFinished() {
    var self = this;
    this.container = jQuery(document.createElement('span')).addClass('smallpart-color-radiobox');
    this.getSurroundings().prependDOMNode(this.container[0]);
    this.container.empty();
    this.container.click(function (e) {
      self.container.addClass('checked');
      self.input.trigger('click');
      self.getValue();
    }).addClass('smallpart-color-radiobox color' + this.options.set_value);
    this.getSurroundings().update();
    super.loadingFinished();
  }
  set_value(_value) {
    super.set_value(_value);
    this.getRoot().iterateOver(function (radio) {
      if (radio.id == this.id) {
        radio.input.prop('checked', _value == radio.options.set_value).change();
        if (_value == radio.options.set_value) radio.container.addClass('checked');
      }
    }, this, et2_smallpart_color_radiobox);
  }
  getValue() {
    var val = this.options.value; // initial value, when form is loaded
    var values = [];
    this.getRoot().iterateOver(function (radio) {
      values.push(radio.options.set_value);
      if (radio.id == this.id && radio.input) {
        radio.container.removeClass('checked');
        if (radio.input.prop('checked')) radio.container.addClass('checked');
        radio.getSurroundings().update();
        if (radio.input.context.checked) val = radio.options.set_value;
      }
    }, this, et2_smallpart_color_radiobox);
    return val && typeof val == 'string' && val.indexOf(values) ? val : null;
  }

  /**
   * Set radio readonly attribute.
   *
   * @param _readonly Boolean
   */
  set_readonly(_readonly) {
    this.getRoot().iterateOver(function (radio) {
      if (radio.id == this.id && radio.container) {
        if (_readonly) {
          radio.container.addClass('disabled');
        } else {
          radio.container.removeClass('disabled');
        }
      }
    }, this, et2_smallpart_color_radiobox);
    super.set_readonly(_readonly);
  }
}
_defineProperty$f(et2_smallpart_color_radiobox, "_attributes", {});
et2_register_widget(et2_smallpart_color_radiobox, ["smallpart-color-radiobox"]);

function _defineProperty$e(e, r, t) { return (r = _toPropertyKey$e(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$e(t) { var i = _toPrimitive$e(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$e(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Format an array of the following form ["text", account_id1|"nick1", "comment1", ...] like:
 *
 *   text
 * 		--> nick1) comment1
 * 			--> nick2) comment2
 */
class et2_smallpart_comment extends et2_valueWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_comment._attributes, _child || {}));
    _defineProperty$e(this, "value", void 0);
    _defineProperty$e(this, "div", null);
    _defineProperty$e(this, "nicks", {});
    _defineProperty$e(this, "_time", '');
    this.value = [''];
    this.div = jQuery(document.createElement('et2-description')).addClass('et2_smallpart_comment');
    this.div[0].activateLinks = true;
    this.setDOMNode(this.div[0]);
  }
  getValue() {
    return this.value;
  }

  /**
   * Set value
   *
   * @param _value
   */
  set_value(_value) {
    if (!Array.isArray(_value)) _value = [_value];
    this.value = _value;
    var self = this;
    this.div.empty();
    this.div[0].value = this.value[0];
    // et2-description uses lightDOM for its contents (which it adds), so we need to wait for it
    // before we add ours
    this.div[0].updateComplete.then(() => {
      if (this._time !== '') {
        this.div.prepend(jQuery('<span class="et2_smallpart_comment_time"/>').text(this._time));
      }
      var div = this.div;
      for (var n = 1; n < this.value.length; n += 2) {
        var user = this.value[n];
        if (typeof user === "string" && !parseInt(user)) {
          var match = user.match(/\[(\d+)\]$/); // old: "first name [account_id]"
          if (match && match.length > 1) {
            user = this.value[n] = parseInt(match[1]);
          }
        }
        if (!Object.keys(this.nicks).length) {
          var participants = this.getRoot().getArrayMgr('sel_options').getEntry('account_id');
          participants.forEach(participant => {
            this.nicks[participant.value] = participant.label;
          });
        }
        div = jQuery(document.createElement('div')).text(this.value[n + 1]).addClass('et2_smallpart_comment_retweet').prepend(jQuery('<span class="et2_smallpart_comment_retweeter"/>').text(this.nicks[user] || '#' + user)).prepend('<span class="bi-arrow-right"/>').appendTo(div);
      }
    });
  }
  set_starttime(_time) {
    if (!isNaN(_time)) {
      this._time = sprintf('%02d:%02d:%02d', ~~(_time / 3600), ~~(_time / 60), _time % 60);
    } else {
      this._time = '';
    }
  }
  set_stoptime(_time) {
    if (!isNaN(_time)) {
      this._time += '-' + sprintf('%02d:%02d:%02d', ~~(_time / 3600), ~~(_time / 60), _time % 60);
    } else {
      this._time += '';
    }
  }

  /**
   * Code for implementing et2_IDetachedDOM (data grid)
   *
   * @param {array} _attrs array of attribute-names to push further names onto
   */
  getDetachedAttributes(_attrs) {
    _attrs.push('value', 'time');
  }
  getDetachedNodes() {
    return [this.div[0]];
  }
  setDetachedAttributes(_nodes, _values) {
    this.div = jQuery(_nodes[0]);
    if (typeof _values['value'] != 'undefined') {
      this.set_value(_values['value']);
    }
    this.set_label(_values['time']);
  }
}
_defineProperty$e(et2_smallpart_comment, "_attributes", {
  value: {
    name: 'value',
    type: 'any',
    // we have no array type, 'any' means leave it as-is
    description: 'SmallParT comment array incl. retweets: ["text", account_id1|"nick1", "comment1", ...]',
    default: et2_no_init
  },
  starttime: {
    name: 'starttime',
    type: 'integer',
    description: 'optional starttime to display before first comment',
    default: et2_no_init
  },
  stoptime: {
    name: 'stoptime',
    type: 'integer',
    description: 'optional stoptime to display before first comment',
    default: et2_no_init
  }
});
et2_register_widget(et2_smallpart_comment, ["smallpart-comment"]);

function _defineProperty$d(e, r, t) { return (r = _toPropertyKey$d(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$d(t) { var i = _toPrimitive$d(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$d(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class et2_smallpart_attachments_list extends et2_vfsUpload {
  /**
   * Constructor
   *
   * @param _parent
   * @param attrs
   * @memberof et2_vfsUpload
   */
  constructor(_parent, _attrs, _child) {
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_attachments_list._attributes, _child || {}));
    _defineProperty$d(this, "pdf_list", null);
    _defineProperty$d(this, "image_list", null);
    var row = document.createElement('tr');
    // pdf title column
    var c1 = document.createElement('td');
    // pdf files column
    var c2 = document.createElement('td');
    c2.style.width = '50%';

    // image title column
    var c3 = document.createElement('td');
    // image files column
    var c4 = document.createElement('td');
    c4.style.width = '50%';

    // pdf vfs row container
    this.pdf_list = document.createElement('div');
    this.pdf_list.classList.add('pdf-list');
    // image vfs container
    this.image_list = document.createElement('div');
    this.image_list.classList.add('image-list');
    row.append(c1);
    row.append(c2);
    c2.append(this.pdf_list);
    row.append(c3);
    row.append(c4);
    c4.append(this.image_list);
    this.list[0].append(row);
  }

  /**
   * If there is a file / files in the specified location, display them
   * Value is the information for the file[s] in the specified location.
   * overwrites the vfsUpload in order to add pdf and image dom into the list
   *
   * @param {Object{}} _value
   */
  set_value(_value) {
    // Remove previous
    while (this._children.length > 0) {
      var node = this._children[this._children.length - 1];
      this.removeChild(node);
      node.destroy();
    }
    this.progress.empty();
    this.pdf_list.innerHTML = '';
    this.image_list.innerHTML = '';

    // Set new
    if (typeof _value == 'object' && _value && Object.keys(_value).length) {
      for (var i in _value) {
        this._add(_value[i]);
      }
    }
    ['pdf', 'image'].forEach(_index => {
      if (this[_index + '_list'].children.length == 0) {
        this[_index + '_list'].parentElement.previousElementSibling.style.visibility = 'hidden';
      }
    });
    return true;
  }

  /**
   * build a dom consists of vfs icon + title + delete button
   * @param file_data
   * @private
   */
  _buildRow(file_data) {
    var row = document.createElement("div");
    row.style.display = 'flex';
    row.classList.add('file-row');
    row.setAttribute("data-path", file_data.path.replace(/'/g, '&quot'));
    row.setAttribute("draggable", "true");
    var icon = document.createElement("div");
    icon.classList.add('icon');
    var title = document.createElement("div");
    title.classList.add('title');
    var mime = et2_createWidget('vfs-mime', {
      value: file_data
    }, this);

    // Trigger expose on click, if supported
    var vfs_attrs = {
      value: file_data,
      onclick: undefined
    };
    if (file_data && typeof file_data.download_url != 'undefined') {
      var fe_mime = egw.file_editor_prefered_mimes(file_data.mime);
      // Check if the link entry is mime with media type, in order to open it in expose view
      if (typeof file_data.mime === 'string' && (file_data.mime.match(mime.mime_regexp, 'ig') || fe_mime && fe_mime.mime[file_data.mime])) {
        vfs_attrs.onclick = function (ev) {
          ev.stopPropagation();
          // Pass it off to the associated vfsMime widget
          jQuery('img', this.parentNode.parentNode).trigger("click");
          return false;
        };
      } else {
        // if there's no handling simply try to open the file with egw file handler (download happens if can't find any handler)
        vfs_attrs.onclick = function (e, widget) {
          widget.egw().open({
            path: widget.value.path,
            type: widget.value.mime
          }, 'file');
        };
      }
    }
    var vfs = et2_createWidget('vfs', vfs_attrs, this);

    // Add in delete button
    if (!this.options.readonly) {
      var self = this;
      var delete_button = document.createElement("div");
      var delete_container = document.createElement("div");
      delete_container.classList.add("delete", "icon");
      delete_container.addEventListener('click', function () {
        var dialog = et2_createWidget("et2-dialog", {
          callback: function callback(button) {
            if (button == Et2Dialog.YES_BUTTON) {
              egw.json("filemanager_ui::ajax_action", ['delete', [row.getAttribute('data-path').replace(/&quot/g, "'")], ''], function (data) {
                if (data && data.errs == 0) {
                  row.remove();
                }
                if (data && data.msg) {
                  self.egw().message(data.msg, data.errs == 0 ? 'success' : 'error');
                }
              }).sendRequest();
            }
          },
          message: self.egw().lang('Delete file') + '?',
          title: self.egw().lang('Confirmation required'),
          buttons: Et2Dialog.BUTTONS_YES_NO,
          dialog_type: Et2Dialog.QUESTION_MESSAGE,
          width: 250
        }, self);
        document.body.append(dialog);
      });
      delete_button.append(delete_container);
      row.append(delete_button);
    }
    row.prepend(title);
    row.prepend(icon);
    return row;
  }

  /**
   * Adds given file data as DOM into its relative list base on mime type
   * @param file_data
   * @private
   */
  _add(file_data) {
    var _file_data$mime;
    // Set up for expose
    if (file_data && typeof file_data.download_url === "undefined") {
      file_data.download_url = "/webdav.php" + file_data.path;
    }
    file_data.mime = (_file_data$mime = file_data.mime) !== null && _file_data$mime !== void 0 ? _file_data$mime : file_data.type;
    if (file_data.mime.match(/pdf/)) {
      this.pdf_list.append(this._buildRow(file_data));
    } else {
      this.image_list.append(this._buildRow(file_data));
    }
  }
}
_defineProperty$d(et2_smallpart_attachments_list, "_attributes", {
  "listonly": {
    "name": "List Only",
    "description": "Display given file objects only as list (removes span,input and progress from the dom)",
    "type": "boolean",
    "default": true
  }
});
et2_register_widget(et2_smallpart_attachments_list, ["smallpart-attachments-list"]);

function _defineProperty$c(e, r, t) { return (r = _toPropertyKey$c(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$c(t) { var i = _toPrimitive$c(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$c(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class et2_smallpart_cl_measurement_L extends et2_baseWidget {
  /**
   * Constructor
   */
  constructor(_parent, _attrs, _child) {
    var _this$div;
    // Call the inherited constructor
    super(_parent, _attrs, ClassWithAttributes.extendAttributes(et2_smallpart_cl_measurement_L._attributes, _child || {}));
    _defineProperty$c(this, "div", null);
    _defineProperty$c(this, "l_button", null);
    _defineProperty$c(this, "_mode", 'calibration');
    _defineProperty$c(this, "_active", false);
    _defineProperty$c(this, "_active_start", 0);
    _defineProperty$c(this, "_content", void 0);
    _defineProperty$c(this, "_steps", []);
    _defineProperty$c(this, "_stepIndex", 0);
    _defineProperty$c(this, "_activeCalibrationInterval", 0);
    _defineProperty$c(this, "_calibrationIsDone", false);
    _defineProperty$c(this, "__activetimeoutId", 0);
    _defineProperty$c(this, "__runningTimeoutId", 0);
    this._content = this.getInstanceManager().widgetContainer.getArrayMgr('content');

    // Only run this if the course is running in CML mode.
    if ((this._content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) != et2_smallpart_videobar.course_options_cognitive_load_measurement) {
      return;
    }

    // widget div wrapper
    this.div = document.createElement('div');
    (_this$div = this.div) === null || _this$div === void 0 || (_this$div = _this$div.classList) === null || _this$div === void 0 || _this$div.add('smallpart-cl-measurement-L');
    this.l_button = et2_createWidget('buttononly', {
      label: egw.lang('L'),
      onclick: _ => {
        this._keyDownHandler({
          ctrlKey: true
        });
      }
    }, this);

    // bind keydown event handler
    this.bindKeyHandler(document);
    this.getInstanceManager()._DOMContainer.parentElement.addEventListener('scroll', event => {
      if (event.target.scrollTop > 10) {
        this.div.style.position = 'fixed';
      } else {
        this.div.style.position = 'relative';
      }
    });
    this._steps = this.options.steps_className.split(',').map(_class => {
      return {
        class: _class,
        node: null
      };
    });
    this.checkCalibration().then(_ => {
      this._calibrationIsDone = true;
    }, _ => {
      this._calibrationIsDone = false;
    });
    this.setDOMNode(this.div);
  }
  static _randomNumGenerator(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
  }
  set_steps_className(value) {
    this._steps = value.split(',').map(_class => {
      return {
        class: _class,
        node: null
      };
    });
  }
  get_steps_className() {
    return this.options.steps_className;
  }
  set_mode(value) {
    this._mode = value;
  }
  get_mode() {
    return this._mode;
  }
  set_active(value) {
    this._active = value;
    var timeout = (this._mode == et2_smallpart_cl_measurement_L.MODE_CALIBRATION ? this.options.calibration_activation_period ? parseInt(this.options.calibration_activation_period) : 3 : parseInt(this.options.activation_period ? this.options.activation_period : 5)) * 1000;
    window.clearTimeout(this.__activetimeoutId);
    if (this._active) {
      var _this$div2;
      (_this$div2 = this.div) === null || _this$div2 === void 0 || _this$div2.classList.add('active');
      this._active_start = Date.now();
      // we always need the focus on the same window in order to be able to catch Ctrl key action
      window.focus();
      this.__activetimeoutId = window.setTimeout(_ => {
        this.set_active(false);

        // record measurement with no time set if there was no interaction
        this._recordMeasurement();
      }, timeout);
    } else {
      var _this$div3;
      this._active_start = 0;
      (_this$div3 = this.div) === null || _this$div3 === void 0 || _this$div3.classList.remove('active');
    }
  }
  start() {
    return new Promise(_resolve => {
      var activeInervalCounter = 1;
      clearInterval(this._activeCalibrationInterval);
      this._steps.forEach(step => {
        step.node = document.getElementsByClassName(step.class)[0];
      });
      if (this._mode === et2_smallpart_cl_measurement_L.MODE_CALIBRATION && this._calibrationIsDone) {
        this._mode = et2_smallpart_cl_measurement_L.MODE_RUNNING;
      }
      switch (this._mode) {
        case et2_smallpart_cl_measurement_L.MODE_CALIBRATION:
          this._steps.forEach(_step => {
            _step.node.style.visibility = 'hidden';
          });
          this._stepIndex = 0;
          this._activeCalibrationInterval = setInterval(_ => {
            if (activeInervalCounter / 4 % 1 != 0) this.set_active(true);
            if (activeInervalCounter / 4 % 1 == 0 && this._steps[this._stepIndex]) {
              this._steps[this._stepIndex].node.style.visibility = 'visible';
              this._stepIndex++;
            }
            if (activeInervalCounter >= 4 * (this._steps.length + 1)) {
              clearInterval(this._activeCalibrationInterval);
              this._calibrationIsDone = true;
              et2_dialog.show_dialog(_ => {
                _resolve();
              }, this.egw().lang('Calibration procedure is finished. After pressing "Ok" the actual test will start.'), this.egw().lang('Cognitive Measurement Load Learning Calibration'), null, et2_dialog.BUTTONS_OK, et2_dialog.INFORMATION_MESSAGE);
            }
            activeInervalCounter++;
          }, (this.options.calibration_interval ? parseInt(this.options.calibration_interval) : 6) * 1000);
          break;
        case et2_smallpart_cl_measurement_L.MODE_RUNNING:
          this.stop();
          var timeout = (parseInt(this.options.running_interval ? this.options.running_interval : 5) * 60 + (Math.round(Math.random()) * 2 - 1) * et2_smallpart_cl_measurement_L._randomNumGenerator(1, parseInt(this.options.running_interval_range ? this.options.running_interval_range : 30))) * 1000;
          this.__runningTimeoutId = window.setTimeout(_ => {
            this.set_active(true);
            this.start();
          }, timeout);
          _resolve();
          break;
      }
    });
  }
  stop() {
    clearTimeout(this.__runningTimeoutId);
  }

  /**
   * Check if calibration is done
   * @protected
   */
  checkCalibration() {
    return new Promise((_resolve, _reject) => {
      //don't ask server if the calibration is already done or cannot be done
      if (this._calibrationIsDone || !this._content.getEntry("video")["course_id"] || !this._content.getEntry("video")["video_id"]) {
        _resolve();
        return;
      }
      this.egw().json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_readCLMeasurement', [this._content.getEntry('video')['course_id'], this._content.getEntry('video')['video_id'], 'learning', egw.user('account_id'), 'calibration'], _records => {
        var resolved = false;
        if (_records) {
          _records.forEach(_record => {
            var data = JSON.parse(_record.cl_data)[0];
            if (data.mode && data.mode === et2_smallpart_cl_measurement_L.MODE_CALIBRATION && data.step === (this._steps.length + 1).toString() + '/' + (this._steps.length + 1).toString()) resolved = true;
          });
        }
        if (resolved) {
          _resolve();
        } else {
          _reject();
        }
      }).sendRequest();
    });
  }
  _keyDownHandler(_ev) {
    if ((_ev.ctrlKey || _ev.metaKey) && this._active) {
      var end = Date.now() - this._active_start;
      this._recordMeasurement(end);
      this.set_active(false);
    }
  }

  /**
   * Bind keydown handler to (additional) documents eg. Collabora
   *
   * @param document
   */
  bindKeyHandler(document) {
    document.addEventListener('keydown', this._keyDownHandler.bind(this));
  }
  _recordMeasurement(_time) {
    var data = {
      mode: this._mode,
      time: _time ? _time / 1000 : ''
    };
    if (this._mode === et2_smallpart_cl_measurement_L.MODE_CALIBRATION) {
      data['step'] = (this._stepIndex + 1).toString() + '/' + (this._steps.length + 1).toString();
    }
    this.egw().json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_recordCLMeasurement', [this._content.getEntry('video')['course_id'], this._content.getEntry('video')['video_id'], 'learning', [data]]).sendRequest();
  }
}
_defineProperty$c(et2_smallpart_cl_measurement_L, "_attributes", {
  mode: {
    name: 'mode',
    type: 'string',
    description: 'Defines the stage of the process the widget is running in, calibration and running mode.',
    default: 'calibration'
  },
  active: {
    name: 'active',
    type: 'boolean',
    description: 'Activate/deactivate "L" button color mode and functions',
    default: false
  },
  activation_period: {
    name: 'activation period',
    type: 'integer',
    description: 'Defines the duration of active mode, default is 5s.',
    default: 5
  },
  steps_className: {
    name: 'steps classname',
    type: 'string',
    description: 'comma separated css class name for defining (hide/show) steps. (steps are based on orders)',
    default: ''
  },
  running_interval: {
    name: 'running interval',
    type: 'integer',
    description: 'Defines interval time in minutes of active mode display',
    default: 5
  },
  running_interval_range: {
    name: 'running interval range',
    type: 'integer',
    description: 'Defines interval time in seconds of active mode display',
    default: 30
  },
  calibration_interval: {
    name: 'calibration interval',
    type: 'integer',
    description: 'Defines interval time for each step in seconds',
    default: 6
  },
  calibration_activation_period: {
    name: 'calibration activation period',
    type: 'integer',
    description: 'Defines the duration of active mode while calibrating, default is 3s.',
    default: 3
  }
});
_defineProperty$c(et2_smallpart_cl_measurement_L, "MODE_CALIBRATION", 'calibration');
_defineProperty$c(et2_smallpart_cl_measurement_L, "MODE_RUNNING", 'running');
et2_register_widget(et2_smallpart_cl_measurement_L, ["smallpart-cl-measurement-L"]);

var _templateObject$a, _templateObject2$9;
function ownKeys$9(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$9(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$9(Object(t), !0).forEach(function (r) { _defineProperty$b(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$9(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$a(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$b(e, r, t) { return (r = _toPropertyKey$b(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$b(t) { var i = _toPrimitive$b(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$b(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * This widget creates a video controller in order to control vidoebar <video>. It offers control buttons such as
 * Play/Pause, Forward/Backward for the givien videobar widget which contains display part for <video>/youtube/pdf.
 */
class SmallPartVideoControls extends Et2Widget(s) {
  constructor() {
    super(...arguments);
    _defineProperty$b(this, "_playState", 'paused');
  }
  static get styles() {
    return [...super.styles, i(_templateObject$a || (_templateObject$a = _taggedTemplateLiteral$a(["\n\t\t\t\t:host{\n\t\t\t\t  width: 100%;\n\t\t\t\t}\n\t\t\t\tet2-button-icon {font-size: 1.5em}\n\t\t\t"])))];
  }
  static get properties() {
    return _objectSpread$9(_objectSpread$9({}, super.properties), {}, {
      /**
       * videobar this overlay is for
       */
      videobar: {
        type: String
      },
      /**
       * callback function on play button
       */
      onPlayCallback: {
        type: Function
      },
      /**
       * callback function on pause button
       */
      onPauseCallback: {
        type: Function
      },
      /**
       * callback function on forward button
       */
      onForwardCallback: {
        type: Function
      },
      /**
       * callback function on backward button
       */
      onBackwardCallback: {
        type: Function
      }
    });
  }

  /**
   * find/set videobar widget
   * @param _widget
   */
  set videobar(_widget) {
    if (typeof _widget === 'string') {
      _widget = this.getRoot().getWidgetById(_widget);
    }
    if (_widget instanceof et2_smallpart_videobar) {
      this._videobar = _widget;
    }
  }

  /**
   * returns videobar widget
   */
  get videobar() {
    return this._videobar;
  }
  render() {
    var playImage = this._playState === 'played' ? "pause-circle" : "play-circle";
    var playTitle = this._playState === 'played' ? "pause" : "play";
    return x(_templateObject2$9 || (_templateObject2$9 = _taggedTemplateLiteral$a(["\n\t\t\t<et2-hbox class=\"et2_smallpart-video-controls\">\n\t\t\t\t<et2-label value=", " .disabled=", "></et2-label>\n\t\t\t\t<et2-button-icon class=\"backward\" image=\"arrow-counterclockwise\" statustext=", "\n\t\t\t\t\t\t\t\t @click=", "></et2-button-icon>\n\t\t\t\t<et2-button-icon class=\"play\" image=", " statustext=", "\n\t\t\t\t\t\t\t\t @click=", "></et2-button-icon>\n\t\t\t\t<et2-button-icon class=\"forward\" image=\"arrow-clockwise\" statustext=", " \n\t\t\t\t\t\t\t\t @click=", "></et2-button-icon>\n                <slot></slot>\n\t\t\t</et2-hbox>\n\t\t"])), this.label, !this.label, this.egw().lang('Backward 10 sec'), this._onBackwardClickHandler.bind(this), playImage, this.egw().lang(playTitle), this._onPlayClickHandler.bind(this), this.egw().lang('Forward 10 sec'), this._onForwardClickHandler.bind(this));
  }

  /**
   * onPlay click handler
   * @param _event
   * @private
   */
  _onPlayClickHandler(_event) {
    if (this.videobar.paused()) {
      this.videobar.play();
      this._playState = 'played';
    } else {
      this.videobar.pause_video();
      this._playState = 'paused';
    }
    if (typeof this.onPlayCallback === 'function') {
      this.onPlayCallback.call(this, _event, this);
    }
    this.requestUpdate();
  }

  /**
   * onForward click handler
   * @param _event
   * @private
   */
  _onForwardClickHandler(_event) {
    if (typeof this.onForwardCallback === 'function') {
      this.options.onForwardCallback.call(this, _event, this);
    }
    if (this.videobar.currentTime() + 10 <= this.videobar.duration()) {
      this.videobar.seek_video(this.videobar.currentTime() + 10);
    }
  }

  /**
   * onBackward click handler
   * @param _event
   * @private
   */
  _onBackwardClickHandler(_event) {
    if (typeof this.options.onBackwardCallback === 'function') {
      this.options.onBackwardCallback.call(this, _event, this);
    }
    if (this.videobar.currentTime() - 10 >= 0) {
      this.videobar.seek_video(this.videobar.currentTime() - 10);
    }
  }
}
customElements.define("smallpart-video-controls", SmallPartVideoControls);

var _templateObject$9, _templateObject2$8, _templateObject3$8, _templateObject4$4;
function asyncGeneratorStep$1(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator$1(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep$1(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function ownKeys$8(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$8(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$8(Object(t), !0).forEach(function (r) { _defineProperty$a(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$8(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$9(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$a(e, r, t) { return (r = _toPropertyKey$a(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$a(t) { var i = _toPrimitive$a(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$a(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
class SmallPartComment extends Et2Widget(s) {
  /**
   * @todo
   */
  static get styles() {
    return [...super.styles, i(_templateObject$9 || (_templateObject$9 = _taggedTemplateLiteral$9(["\n\t\t\t\t:host {\n\t\t\t\t\tposition: relative;\n\t\t\t\t}\n\n\t\t\t\t.edit-icon {\n\t\t\t\t\tposition: absolute;\n\t\t\t\t\tright: 0;\n\t\t\t\t}\n\n\t\t\t\t.smallpart-comment__reply {\n\t\t\t\t\tposition: relative;\n\t\t\t\t\tmargin-top: var(--sl-spacing-small);\n\t\t\t\t\tpadding-top: var(--sl-spacing-small);\n\t\t\t\t\tpadding-left: var(--sl-spacing-large);\n\t\t\t\t\tborder-top: var(--sl-panel-border-width) solid var(--sl-panel-border-color);\n\t\t\t\t\tmin-height: var(--sl-input-height-medium);\n\t\t\t\t}\n\n\t\t\t\t.smallpart_comment_reply__participant {\n\t\t\t\t\tfont-weight: bold;\n\t\t\t\t\tpadding-right: var(--sl-spacing-medium);\n\t\t\t\t\tflex: 0 0 fit-content;\n\t\t\t\t}\n\n\t\t\t\t.smallpart_comment_reply__participant::after {\n\t\t\t\t\tcontent: \":\";\n\t\t\t\t}\n\t\t\t"])))];
  }
  static get properties() {
    return _objectSpread$8(_objectSpread$8({}, super.properties), {}, {
      /**
       * optional starttime to display before first comment
       */
      startTime: {
        type: Number
      },
      /**
       * optional stoptime to display before first comment
       */
      stopTime: {
        type: Number
      },
      /**
       * Comment can be edited
       */
      editable: {
        type: Boolean
      },
      /**
       * Comment value
       */
      value: {
        type: Object,
        noAccessor: true
      }
    });
  }
  constructor() {
    super(...arguments);
    _defineProperty$a(this, "_value", []);
    _defineProperty$a(this, "_time", '');
    _defineProperty$a(this, "_nicks", {});
    _defineProperty$a(this, "comment", "");
    _defineProperty$a(this, "replies", []);
    this._value = [];
    this.startTime = 0;
    this.stopTime = 0;
  }
  set startTime(_time) {
    if (!isNaN(_time)) {
      this._time = sprintf('%02d:%02d:%02d', ~~(_time / 3600), ~~(_time / 60), _time % 60);
    } else {
      this._time = '';
    }
  }
  set stopTime(_time) {
    if (!isNaN(_time)) {
      this._time += '-' + sprintf('%02d:%02d:%02d', ~~(_time / 3600), ~~(_time / 60), _time % 60);
    } else {
      this._time += '';
    }
  }
  set_value(_value) {
    var _ref;
    this.value = _value;
    this.comment = (_ref = typeof _value.comment != "undefined" ? _value === null || _value === void 0 ? void 0 : _value.comment[0] : "") !== null && _ref !== void 0 ? _ref : "";
    this.replies = [];
    for (var n = 1; n < (_value === null || _value === void 0 || (_value$comment = _value.comment) === null || _value$comment === void 0 ? void 0 : _value$comment.length); n += 2) {
      var _value$comment;
      var user = _value.comment[n];
      if (typeof user === "string" && !parseInt(user)) {
        var match = user.match(/\[(\d+)\]$/); // old: "first name [account_id]"
        if (match && match.length > 1) {
          user = _value.comment[n] = String(parseInt(match[1]));
        }
      }
      if (!Object.keys(this._nicks).length) {
        var participants = this.getRoot().getArrayMgr('sel_options').getEntry('account_id');
        participants.forEach(participant => {
          this._nicks[participant.value] = participant.label;
        });
      }
      this.replies.push({
        user: user,
        reply: _value.comment[n + 1]
      });
    }
    this.requestUpdate("value");
  }
  handleEditClick(event, data, index) {
    var _this = this;
    return _asyncToGenerator$1(function* () {
      var userLabel = _this._nicks[data.user] || '#' + data.user;
      var editDialog = document.createElement('et2-dialog');
      editDialog._setApiInstance(_this.egw());
      editDialog.transformAttributes({
        title: _this.egw().lang("Edit"),
        buttons: Et2Dialog.BUTTONS_OK_CANCEL,
        isModal: true,
        template: "smallpart.student.edit_comment",
        value: {
          content: _objectSpread$8({
            label: userLabel
          }, data)
        }
      });
      // Stop enter from closing dialog
      var stop = e => {
        if (e.key == "Enter") {
          e.stopImmediatePropagation();
        }
      };
      editDialog.updateComplete.then(() => {
        editDialog.querySelector("#_reply").addEventListener("keyup", stop);
      });
      document.body.appendChild(editDialog);
      var [button, edit] = yield editDialog.getComplete();
      editDialog.querySelector("#_reply").removeEventListener("keyup", stop);
      if (button == Et2Dialog.OK_BUTTON) {
        _this.replies[index].reply = edit["reply"];
        _this.egw().json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_saveComment', [_this.getInstanceManager().etemplate_exec_id, {
          course_id: _this.value.course_id,
          video_id: _this.value.video_id,
          comment_id: _this.value.comment_id,
          // send action and text to server-side to be able to do a proper ACL checks
          action: "reply_edit",
          index: 2 + 2 * index,
          reply: edit["reply"]
        }]).sendRequest();
        _this.requestUpdate("value");
      }
    })();
  }
  addCommentTemplate(_data, index) {
    var editable = (this.editable || _data.user == this.egw().user('account_id')) && this.value.course_id && this.value.video_id && this.value.comment_id;
    var userLabel = this._nicks[_data.user] || '#' + _data.user;
    return x(_templateObject2$8 || (_templateObject2$8 = _taggedTemplateLiteral$9(["\n            <et2-hbox class=\"et2_smallpart_comment_retweet smallpart-comment__reply\" data-index=\"", "\">\n                <et2-image class=\"bi-arrow-right\"></et2-image>\n                <span class=\"retweeter smallpart_comment_reply__participant\">", "</span>\n                <span class=\"smallpart-comment-reply__reply\">\n                ", "\n\t\t\t\t</span>\n                ", "\n            </et2-hbox>\n\t\t"])), index, userLabel, _data.reply, editable ? x(_templateObject3$8 || (_templateObject3$8 = _taggedTemplateLiteral$9(["\n                    <et2-button-icon\n                            part=\"edit-icon\"\n                            class=\"edit-icon\"\n                            align=\"right\"\n                            image=\"edit\" label=\"Edit\" noSubmit\n                            @click=", "\n                    >\n                    </et2-button-icon>"])), event => this.handleEditClick(event, _data, index)) : A);
  }
  getDetachedAttributes(attrs) {
    attrs.push("value", "time");
  }
  getDetachedNodes() {
    return [this];
  }
  setDetachedAttributes(_nodes, _values, _data) {
    for (var attr in _values) {
      this[attr] = _values[attr];
    }
  }
  render() {
    return x(_templateObject4$4 || (_templateObject4$4 = _taggedTemplateLiteral$9(["\n            <div class=\"smallpart-comment smallpart-comment__base\">\n                <span class=\"smallpart-comment__time\" part=\"time\">", "</span>\n                ", "\n                <slot></slot>\n                ", "\n            </div>"])), this._time, this.comment, o$1(this.replies, (data, index) => this.addCommentTemplate(data, index)));
  }
}
customElements.define("et2-smallpart-comment", SmallPartComment);

var _dec$1, _dec2$1, _dec3, _dec4, _class$1, _descriptor$1, _descriptor2$1, _descriptor3, _templateObject$8, _templateObject2$7, _templateObject3$7, _templateObject4$3, _templateObject5$2, _templateObject6$1;
function _initializerDefineProperty$1(e, i, r, l) { r && Object.defineProperty(e, i, { enumerable: r.enumerable, configurable: r.configurable, writable: r.writable, value: r.initializer ? r.initializer.call(l) : void 0 }); }
function _taggedTemplateLiteral$8(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$9(e, r, t) { return (r = _toPropertyKey$9(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$9(t) { var i = _toPrimitive$9(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$9(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor$1(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
function _initializerWarningHelper$1(r, e) { throw Error("Decorating class property failed. Please ensure that transform-class-properties is enabled and runs after the decorators transform."); }

/**
 *
 *
 */
var SmallPartCommentTimespan = (_dec$1 = e({
  type: Number
}), _dec2$1 = e({
  type: Number
}), _dec3 = e({
  type: String
}), _dec4 = e({
  type: String
}), _class$1 = class SmallPartCommentTimespan extends Et2InputWidget(s) {
  static get styles() {
    return [...super.styles, i(_templateObject$8 || (_templateObject$8 = _taggedTemplateLiteral$8(["\n\t\t\t\tdiv {\n\t\t\t\t\tposition: relative;\n\t\t\t\t}\n\n\t\t\t\tet2-vbox::part(base) {\n\t\t\t\t\trow-gap: 0;\n\t\t\t\t}\n\n\t\t\t\tet2-hbox::part(base) {\n\t\t\t\t\talign-items: center;\n\t\t\t\t}\n\n\t\t\t\tet2-date-duration, et2-date-duration_ro {\n\t\t\t\t\tflex-grow: 1;\n\t\t\t\t}\n\n\t\t\t\tet2-date-duration_ro {\n\t\t\t\t\tpadding: var(--sl-spacing-x-small);\n\t\t\t\t\ttext-align: right;\n\t\t\t\t}\n\t\t\t"])))];
  }
  constructor() {
    super();
    _initializerDefineProperty$1(this, "starttime", _descriptor$1, this);
    _initializerDefineProperty$1(this, "stoptime", _descriptor2$1, this);
    _initializerDefineProperty$1(this, "_videobar", _descriptor3, this);
    this.handleDropdownClick = this.handleDropdownClick.bind(this);
    this.handleTimepickerClick = this.handleTimepickerClick.bind(this);
  }
  willUpdate(changedProperties) {
    // Check start < stop if times change
    if (this.starttime && this.stoptime && (changedProperties.has('starttime') || changedProperties.has('stoptime'))) {
      this._checkTimeConflicts();
    }
  }
  timePicker() {
    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "starttime";
    var time = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var currentTime = time == null ? Math.round(this._videobar.currentTime()) : time;
    if (typeof this.stoptime === "undefined") {
      this.stoptime = this.getStoptime().value;
    }
    if (type == 'starttime') {
      this.requestUpdate("starttime", this.starttime);
      this.starttime = currentTime;
      if (currentTime > this.stoptime) {
        this.stoptime = currentTime;
        this.getStoptime().closest('sl-animation').play = true;
      }
    } else if (type == 'stoptime' && Math.abs(currentTime - this.starttime) < 1) {
      this.stoptime = this.starttime;
    } else if (type == 'stoptime' && currentTime > this.starttime) {
      this.stoptime = currentTime;
    } else {
      this.getStoptime().closest('sl-animation').play = true;
    }
    this.requestUpdate("stoptime");
  }
  handleChange(event) {
    this._checkTimeConflicts();
  }

  /**
   * Clicked save in dropdown, update value
   * @param event
   */
  handleDropdownClick(event) {
    var _ref, _this$duration$dom_id;
    if (!(event.target instanceof Et2Button)) {
      return;
    }
    event.stopPropagation();
    var dropdown = event.target.closest("et2-dropdown");
    var duration = dropdown.querySelector("et2-date-duration");
    var old_value = this[duration.dom_id];
    if (event.target.id == "save") {
      this[duration.dom_id] = duration.value;
    }
    duration.value = (_ref = (_this$duration$dom_id = this[duration.dom_id]) !== null && _this$duration$dom_id !== void 0 ? _this$duration$dom_id : this.starttime) !== null && _ref !== void 0 ? _ref : 0;
    this.requestUpdate(duration.dom_id, old_value);
    dropdown.hide();
  }

  /**
   * time picker button click handler
   * @param _type
   * @param _event
   * @private
   */
  handleTimepickerClick(_event) {
    var _type = _event.target.getAttribute("name");
    this.timePicker(_type);
  }

  /**
   * Show one picker, start or stop
   *
   * Handles associated edit dropdown
   *
   * @param name
   * @param value
   * @param {string} icon
   * @param {any} max
   * @return {TemplateResult<1>}
   * @protected
   */
  _pickerTemplate(name, value) {
    var icon = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "clock-history";
    var max = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : undefined;
    var clock = this.disabled || this.readonly ? x(_templateObject2$7 || (_templateObject2$7 = _taggedTemplateLiteral$8(["\n                          <et2-image part=\"button\" src=\"", "\" class=\"", "\"></et2-image>"])), icon, name) : x(_templateObject3$7 || (_templateObject3$7 = _taggedTemplateLiteral$8(["\n                        <et2-button-icon\n                                  part=\"button\"\n                                  statustext=\"", " picker\"\n                                  class=\"", "\"\n                                  name=\"", "\"\n                                .noSubmit=", "\n                                  image=\"", "\"\n                                  @click=", "\n                          >\n                          </et2-button-icon>"])), name, name, name, true, icon, this.handleTimepickerClick);
    return x(_templateObject4$3 || (_templateObject4$3 = _taggedTemplateLiteral$8(["\n            ", "\n            <et2-date-duration_ro\n                    part=\"duration\"\n                    class=", "\n                    displayFormat=\"hms\" dataFormat=\"s\" emptyNot0\n                    .value=", "\n            >\n                ", "\n            </et2-date-duration_ro>"])), clock, name, parseInt(value), this.disabled || this.readonly ? A : x(_templateObject5$2 || (_templateObject5$2 = _taggedTemplateLiteral$8(["\n                    <et2-dropdown slot=\"suffix\">\n                        <et2-image slot=\"trigger\" src=\"edit\"></et2-image>\n                            <et2-date-duration\n                                part=\"duration\"\n                                id=\"", "\"\n                                    displayFormat=\"hms\"\n                                    dataFormat=\"s\"\n                                class=\"", "\"\n                                ?max=", "\n                                    .selectUnit=", "\n                                .value=", "\n                                @change=", "\n                            ></et2-date-duration>\n                        <et2-hbox>\n                            <et2-button id=\"save\" label=", " image=\"save\" noSubmit\n                                        @click=", "></et2-button>\n                            <et2-button id=\"cancel\" label=", " image=\"cancel\" noSubmit\n                                        @click=\"", "\"></et2-button>\n                        </et2-hbox>\n                    </et2-dropdown>"])), name, name, max, false, parseInt(value) || 0, name == "stoptime" ? this.handleStopChange : A, this.egw().lang("save"), this.handleDropdownClick, this.egw().lang("cancel"), this.handleDropdownClick));
  }
  render() {
    var _this$_videobar, _this$stoptime, _this$_videobar2;
    // This shows loading template until loadingPromise resolves, then shows _listTemplate
    return x(_templateObject6$1 || (_templateObject6$1 = _taggedTemplateLiteral$8(["\n            <et2-vbox\n                    @change=", "\n            >\n                <et2-description label=\"Start\"></et2-description>\n                <et2-hbox>\n                    ", "\n                </et2-hbox>\n                <et2-description label=\"End\"></et2-description>\n                <et2-hbox>\n                    <sl-animation name=\"flash\" iterations=\"1\">\n                        ", "\n                    </sl-animation>\n                </et2-hbox>\n                <div>\n                    <slot name=\"feedback\"></slot>\n                </div>\n            </et2-vbox>\n\t\t"])), this.handleChange, this._pickerTemplate("starttime", this.starttime, "clock", (_this$_videobar = this._videobar) === null || _this$_videobar === void 0 ? void 0 : _this$_videobar.duration()), this._pickerTemplate("stoptime", (_this$stoptime = this.stoptime) !== null && _this$stoptime !== void 0 ? _this$stoptime : this.starttime, "clock-history", (_this$_videobar2 = this._videobar) === null || _this$_videobar2 === void 0 ? void 0 : _this$_videobar2.duration()));
  }

  /**
   * @return Et2DateDuration
   */
  getStarttime() {
    var _ref2;
    return (_ref2 = this.shadowRoot.querySelector('et2-date-duration.starttime')) !== null && _ref2 !== void 0 ? _ref2 : this.shadowRoot.querySelector('et2-date-duration_ro.starttime');
  }

  /**
   * @return Et2DateDuration
   */
  getStoptime() {
    var _ref3;
    return (_ref3 = this.shadowRoot.querySelector('et2-date-duration.stoptime')) !== null && _ref3 !== void 0 ? _ref3 : this.shadowRoot.querySelector('et2-date-duration_ro.stoptime');
  }

  /**
   * @return @Et2Button
   */
  getStarttimePicker() {
    return this.shadowRoot.querySelector('et2-button.starttime');
  }

  /**
   * @return Et2Button
   */
  getStoptimePicker() {
    return this.shadowRoot.querySelector('et2-button.stoptime');
  }

  /**
   * Set videobar to use
   *
   * @param _id_or_widget
   */
  set videobar(_id_or_widget) {
    if (typeof _id_or_widget === 'string') {
      _id_or_widget = this.getRoot().getWidgetById(_id_or_widget);
    }
    if (typeof _id_or_widget !== 'string' && _id_or_widget) {
      this._videobar = _id_or_widget;
    }
  }
  get videobar() {
    return this._videobar;
  }

  /**
   * Re-evaluate starttime/stoptime values, show error startime > stoptime
   *
   * @param _node
   * @param _widget
   */
  _checkTimeConflicts() {
    if (this.readonly || this.disabled) {
      return;
    }

    // Start has to be less than stop
    this.set_validation_error(false);
    this._messagesHeldWhileFocused = [];
    this.updateComplete.then(() => {
      if (this.starttime > this.stoptime) {
        this.getStoptime().closest('sl-animation').play = true;
        this.set_validation_error(this.egw().lang("starttime has to be before endtime !!!"));
        this.validate();
      }
    });
  }
}, _descriptor$1 = _applyDecoratedDescriptor$1(_class$1.prototype, "starttime", [_dec$1], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _descriptor2$1 = _applyDecoratedDescriptor$1(_class$1.prototype, "stoptime", [_dec2$1], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _descriptor3 = _applyDecoratedDescriptor$1(_class$1.prototype, "_videobar", [_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _applyDecoratedDescriptor$1(_class$1.prototype, "videobar", [_dec4], Object.getOwnPropertyDescriptor(_class$1.prototype, "videobar"), _class$1.prototype), _class$1);
customElements.define("smallpart-comment-timespan", SmallPartCommentTimespan);

var _templateObject$7;
function ownKeys$7(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$7(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$7(Object(t), !0).forEach(function (r) { _defineProperty$8(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$7(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$8(e, r, t) { return (r = _toPropertyKey$8(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$8(t) { var i = _toPrimitive$8(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$8(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral$7(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 *
 */
class SmallPartLiveFeedbackButton extends Et2Button {
  static get styles() {
    return [super.styles, shoelace, i(_templateObject$7 || (_templateObject$7 = _taggedTemplateLiteral$7(["\n\t\t\t:host {\n\t\t\t  width: 100%;\n\t\t\t  display: inherit;\n\t\t\t}\n\t\t\t:host::part(base) {\n\t\t\t  border: 1px solid var(--smallpart-cat-color);\n\t\t\t}\n\n\t\t\t\t.button__label {\n\t\t\t\t\toverflow: hidden;\n\t\t\t\t}\n\t\t"])))];
  }
  static get properties() {
    return _objectSpread$7(_objectSpread$7({}, super.properties), {}, {
      color: {
        type: String
      }
    });
  }
  constructor() {
    super(...arguments);

    // Property default values
    this.color = '';
    this.noSubmit = true;
  }
  set color(_color) {
    this.updateComplete.then(_ => {
      this.shadowRoot.querySelector('.button').style.setProperty('--smallpart-cat-color', _color);
    });
  }
}
customElements.define("smallpart-lf-button", SmallPartLiveFeedbackButton);

var _templateObject$6, _templateObject2$6, _templateObject3$6;
function ownKeys$6(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$6(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$6(Object(t), !0).forEach(function (r) { _defineProperty$7(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$6(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$7(e, r, t) { return (r = _toPropertyKey$7(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$7(t) { var i = _toPrimitive$7(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$7(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral$6(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }

/**
 *
 */
class SmallPartLiveFeedbackRadioButton extends Et2WidgetWithSelectMixin(radio_group_default) {
  static get styles() {
    return [super.styles, shoelace, i(_templateObject$6 || (_templateObject$6 = _taggedTemplateLiteral$6(["\n\t\t\t:host {\n\t\t\t  width: 100%;\n\t\t\t\tmax-width: 10em;\n\t\t\t  display: inherit;\n\t\t\t}\n\n\t\t\t\t::part(button-group) {\n\t\t\t\t\twidth: 100%;\n\t\t\t\t\tmax-width: 10em;\n\t\t\t}\n\n\t\t\t\t::part(button-group__base) {\n\t\t\t\t\tflex-wrap: wrap;\n\t\t\t\t\tflex-direction: column;\n\t\t\t\t}\n\n\t\t\t\tsl-radio-button {\n\t\t\t\t\tflex: 1 1 auto;\n\t\t\t\t}\n\n\t\t\t\t/* It's way easier to target the icons here due to the shadowRoot nesting */\n\n\t\t\t\t::part(button) {\n\t\t\t\t\tborder-color: transparent;\n\t\t\t\t\tfont-size: inherit;\n\t\t\t\t}\n\n\t\t\t\t::part(svg) {\n\t\t\t\t\tfilter: drop-shadow(1px 1px 8px var(--sl-color-neutral-400));\n\t\t\t\t}\n\t\t\t"])))];
  }
  static get properties() {
    return _objectSpread$6(_objectSpread$6({}, super.properties), {}, {
      parentId: {
        type: String
      },
      onlyLiveFeedback: {
        type: Boolean
      }
    });
  }
  constructor() {
    super(...arguments);
    this.size = egwIsMobile() ? 'large' : 'medium';
  }
  connectedCallback() {
    super.connectedCallback();
    this.select_options = this.select_options.length > 0 ? this.select_options : this._getOptions();
  }
  _getOptions() {
    var options = this.getInstanceManager().widgetContainer.getArrayMgr('sel_options').getEntry('catsOptions');
    return options.filter(_item => {
      if (this.onlyLiveFeedback) {
        var _item$data;
        return _item.parent_id == this.parentId && (_item === null || _item === void 0 || (_item$data = _item.data) === null || _item$data === void 0 ? void 0 : _item$data.type) == 'lf';
      }
      return _item.parent_id == this.parentId;
    })
    // Design requirement: max 3 options shown, only the first 3
    .slice(0, 3);
  }
  render() {
    return x(_templateObject2$6 || (_templateObject2$6 = _taggedTemplateLiteral$6(["\n            <sl-radio-group\n                    exportparts=\"radio__icon:icon, button-group, button-group__base\"\n                    label=", " @sl-change=", " value=", "\n            >\n                ", "\n\t\t\t</sl-radio-group>\n\t\t"])), this.label, this._handleChange, this.value, (this.select_options || []).map(option => this._optionTemplate(option)));
  }
  _optionTemplate(_option) {
    var icon = _option.icon;
    if (!icon) {
      var _option$data;
      switch (_option === null || _option === void 0 || (_option$data = _option.data) === null || _option$data === void 0 ? void 0 : _option$data.value) {
        case 'p':
          icon = 'hand-thumbs-up';
          break;
        case 'n':
          icon = 'hand-thumbs-down';
          break;
        default:
          icon = 'hand-index-thumb';
          break;
      }
    }
    return x(_templateObject3$6 || (_templateObject3$6 = _taggedTemplateLiteral$6(["\n            <sl-radio-button\n                    exportparts=\"label:radio__label, prefix:radio__icon\"\n                    value=", " size=", " title=", ">\n                <sl-icon slot=\"prefix\" part=\"icon\" exportparts=\"svg\" name=\"", "\" label=", "\n                         style=\"color: ", "\"></sl-icon>\n                ", "\n            </sl-radio-button>\n\t\t"])), _option.value, this.size, _option.title || _option.label, icon, _option.label, _option.color, _option.label);
  }
  get value() {
    return this._value;
  }
  set value(new_value) {
    var oldValue = this.value;
    this._value = new_value;
    this.requestUpdate("value", oldValue);
  }
  _handleChange(ev) {
    this._value = ev.currentTarget.value;
    // Trigger a change event
    this.dispatchEvent(new Event("change"));
  }
}
customElements.define("smallpart-lf-radiobutton", SmallPartLiveFeedbackRadioButton);

var _templateObject$5, _templateObject2$5, _templateObject3$5, _templateObject4$2, _templateObject5$1, _templateObject6;
function ownKeys$5(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$5(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$5(Object(t), !0).forEach(function (r) { _defineProperty$6(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$5(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty$6(e, r, t) { return (r = _toPropertyKey$6(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$6(t) { var i = _toPrimitive$6(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$6(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _taggedTemplateLiteral$5(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
/**
 *
 *
 */
class SmallPartFilterParticipants extends Et2Select {
  static get styles() {
    return [...super.styles, i(_templateObject$5 || (_templateObject$5 = _taggedTemplateLiteral$5(["\n\t\t\t/* Larger maximum height before scroll*/\n\t\t\t.select__tags {\n\t\t\t\tmax-height: 10em;\n\t\t\t}\n\n\t\t\t\t::part(listbox) {\n\t\t\t\t--icon-width: 40px;\n\t\t\t}\n\t\t\t"])))];
  }
  constructor() {
    super(...arguments);
    this.multiple = true;
    this.allowFreeEntries = false;
  }
  static get properties() {
    return _objectSpread$5(_objectSpread$5({}, super.properties), {}, {
      /**
       * Enables extra admin features
       */
      is_staff: {
        type: String
      },
      /**
       * Shows only label and name if it is switched on
       */
      no_comments: {
        type: Boolean
      }
    });
  }
  _optionTemplate(option) {
    var icon = option.icon ? x(_templateObject2$5 || (_templateObject2$5 = _taggedTemplateLiteral$5(["\n            <et2-image slot=\"prefix\" part=\"icon\" style=\"width: var(--icon-width)\"\n                       src=\"", "\"></et2-image>"])), option.icon) : "";
    return x(_templateObject3$5 || (_templateObject3$5 = _taggedTemplateLiteral$5(["\n            <sl-option value=\"", "\" title=\"", "\" class=\"", "\" .option=", ">\n                ", "\n\t\t\t\t", "\n            </sl-option>"])), option.value, option.title, option.class, option, icon, this._createStaffOptionTemplate(option));
  }

  /**
   * Create more option template used for staff mode
   * @param _item
   * @protected
   */
  _createStaffOptionTemplate(_item) {
    var comments, retweets, name, label;
    if (this.is_staff != '') {
      if (!this.options.no_comments && (typeof _item.comments != 'undefined' || typeof _item.retweets != 'undefined')) {
        comments = x(_templateObject4$2 || (_templateObject4$2 = _taggedTemplateLiteral$5(["\n\t\t\t\t\t<et2-hbox>\n                        <et2-label value=\"", ":\"></et2-label>\n                        <et2-label value=\"", "\"></et2-label>\n\t\t\t\t\t</et2-hbox>\n\t\t\t\t\t\n\t\t\t\t"])), egw.lang('Comments'), _item.comments);
        retweets = x(_templateObject5$1 || (_templateObject5$1 = _taggedTemplateLiteral$5(["\n\t\t\t\t\t<et2-hbox>\n                        <et2-label value=\"", ":\"></et2-label>\n                        <et2-label value=\"", "\"></et2-label>\n\t\t\t\t\t</et2-hbox>\n\t\t\t\t"])), egw.lang('Retweets'), _item.retweets);
      }
      if (_item.name != '') {
        name = _item.name;
      }
    }
    label = _item.label;
    return x(_templateObject6 || (_templateObject6 = _taggedTemplateLiteral$5(["\n\t\t\t", "<br />\n\t\t\t", "\n\t\t\t<et2-vbox slot=\"suffix\">\n                ", "\n                ", "\n\t\t\t</et2-vbox>\n\t\t"])), label, name, comments, retweets);
  }

  /**
   * Generate Participants tag
   *
   * @param item
   * @protected
   * @todo build the same staff options for tag
   */
  _createTagNode(item) {
    var tag = super._createTagNode(item);
    // return simple tag if it's not a staff member
    if (this.is_staff == '') return tag;

    //@TODO: build the same staff options for tag
    return tag;
  }
}
customElements.define("smallpart-filter-participants", SmallPartFilterParticipants);

var es_symbol_asyncIterator = {};

var global = global$1;

var path$1 = global;

var wellKnownSymbolWrapped = {};

var wellKnownSymbol = wellKnownSymbol$1;

var f = wellKnownSymbolWrapped.f = wellKnownSymbol;

var path = path$1;
var hasOwn = hasOwnProperty_1;
var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
var defineProperty = objectDefineProperty.f;

var wellKnownSymbolDefine = function (NAME) {
  var Symbol = path.Symbol || (path.Symbol = {});
  if (!hasOwn(Symbol, NAME)) defineProperty(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule.f(NAME)
  });
};

var defineWellKnownSymbol = wellKnownSymbolDefine;

// `Symbol.asyncIterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.asynciterator
defineWellKnownSymbol('asyncIterator');

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */class o extends c{constructor(){super(...arguments),this._$Cq=new s$1(this),this._$CK=new i$1;}render(i,s){return T}update(i,[s,r]){if(this.isConnected||this.disconnected(),s===this._$CX)return;this._$CX=s;let n=0;const{_$Cq:o,_$CK:h}=this;return t(s,(async t=>{for(;h.get();)await h.get();const i=o.deref();if(void 0!==i){if(i._$CX!==s)return !1;void 0!==r&&(t=r(t,n)),i.commitValue(t,n),n++;}return !0})),T}commitValue(t,i){this.setValue(t);}disconnected(){this._$Cq.disconnect(),this._$CK.pause();}reconnected(){this._$Cq.reconnect(this),this._$CK.resume();}}const h=e$1(o);

var _dec, _dec2, _class, _descriptor, _descriptor2, _templateObject$4, _templateObject2$4, _templateObject3$4;
function _taggedTemplateLiteral$4(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _initializerDefineProperty(e, i, r, l) { r && Object.defineProperty(e, i, { enumerable: r.enumerable, configurable: r.configurable, writable: r.writable, value: r.initializer ? r.initializer.call(l) : void 0 }); }
function _defineProperty$5(e, r, t) { return (r = _toPropertyKey$5(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$5(t) { var i = _toPrimitive$5(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$5(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor(i, e, r, n, l) { var a = {}; return Object.keys(n).forEach(function (i) { a[i] = n[i]; }), a.enumerable = !!a.enumerable, a.configurable = !!a.configurable, ("value" in a || a.initializer) && (a.writable = !0), a = r.slice().reverse().reduce(function (r, n) { return n(i, e, r) || r; }, a), l && void 0 !== a.initializer && (a.value = a.initializer ? a.initializer.call(l) : void 0, a.initializer = void 0), void 0 === a.initializer ? (Object.defineProperty(i, e, a), null) : a; }
function _initializerWarningHelper(r, e) { throw Error("Decorating class property failed. Please ensure that transform-class-properties is enabled and runs after the decorators transform."); }
function _awaitAsyncGenerator(e) { return new _OverloadYield(e, 0); }
function _wrapAsyncGenerator(e) { return function () { return new AsyncGenerator(e.apply(this, arguments)); }; }
function AsyncGenerator(e) { var r, t; function resume(r, t) { try { var n = e[r](t), o = n.value, u = o instanceof _OverloadYield; Promise.resolve(u ? o.v : o).then(function (t) { if (u) { var i = "return" === r ? "return" : "next"; if (!o.k || t.done) return resume(i, t); t = e[i](t).value; } settle(n.done ? "return" : "normal", t); }, function (e) { resume("throw", e); }); } catch (e) { settle("throw", e); } } function settle(e, n) { switch (e) { case "return": r.resolve({ value: n, done: !0 }); break; case "throw": r.reject(n); break; default: r.resolve({ value: n, done: !1 }); } (r = r.next) ? resume(r.key, r.arg) : t = null; } this._invoke = function (e, n) { return new Promise(function (o, u) { var i = { key: e, arg: n, resolve: o, reject: u, next: null }; t ? t = t.next = i : (r = t = i, resume(e, n)); }); }, "function" != typeof e.return && (this.return = void 0); }
AsyncGenerator.prototype["function" == typeof Symbol && Symbol.asyncIterator || "@@asyncIterator"] = function () { return this; }, AsyncGenerator.prototype.next = function (e) { return this._invoke("next", e); }, AsyncGenerator.prototype.throw = function (e) { return this._invoke("throw", e); }, AsyncGenerator.prototype.return = function (e) { return this._invoke("return", e); };
function _OverloadYield(e, d) { this.v = e, this.k = d; }

/**
 * Time flag widget marks a time, and provides controls for clearing the marked time
 *
 */
var SmallPartFlagTime = (_dec = t$1(), _dec2 = t$1(), _class = class SmallPartFlagTime extends Et2Widget(s) {
  constructor() {
    super(...arguments);
    _initializerDefineProperty(this, "markedTime", _descriptor, this);
    _initializerDefineProperty(this, "timer", _descriptor2, this);
    // setTimeout
    _defineProperty$5(this, "_clearTimer", null);
    _defineProperty$5(this, "clearDelay", void 0);
  }
  static get styles() {
    return [shoelace, super.styles, i(_templateObject$4 || (_templateObject$4 = _taggedTemplateLiteral$4(["\n\t\t\t\t:host {\n\t\t\t\t\tmax-width: fit-content;\n\t\t\t\t}\n\n\t\t\t\tet2-button {\n\t\t\t\t\tmax-width: fit-content;\n\t\t\t\t}\n\n\t\t\t\tet2-button::part(label), et2-date-duration_ro {\n\t\t\t\t}\n\n\t\t\t\tet2-button::part(label) {\n\t\t\t\t\tdisplay: flex;\n\t\t\t\t\tflex-direction: row;\n\t\t\t\t\tflex-wrap: nowrap;\n\t\t\t\t\talign-items: center;\n\t\t\t\t}\n\n\t\t\t\tet2-button-icon::part(base) {\n\t\t\t\t\tpadding: var(--sl-spacing-small);\n\t\t\t\t\tpadding-top: 0px;\n\t\t\t\t}\n\n\t\t\t\t.hasValue et2-button-icon[slot=\"prefix\"] {\n\t\t\t\t\tcolor: var(--sl-color-primary-500);\n\t\t\t\t}\n\n\t\t\t"])))];
  }
  get value() {
    return this.markedTime;
  }
  handleClearClick(e) {
    e.preventDefault();
    e.stopImmediatePropagation();
    this.clearMark(0);
  }
  markTime(seconds) {
    var clearTimer = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    this.clearDelay = clearTimer;
    this.cancelClear();
    this.markedTime = seconds;
    this.requestUpdate();
  }
  clearMark() {
    var delay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.clearDelay;
    this.timer = countDown(delay);
    if (this._clearTimer) {
      clearTimeout(this._clearTimer);
    }
    this._clearTimer = setTimeout(() => {
      this.markedTime = null;
      this.timer = null;
      this.requestUpdate();
      this.updateComplete.then(() => {
        this.dispatchEvent(new Event("clear", {
          bubbles: true
        }));
      });
    }, delay * 1000);
    this.requestUpdate("timer");
  }
  cancelClear() {
    if (this._clearTimer) {
      clearTimeout(this._clearTimer);
    }
    this.timer = null;
  }
  render() {
    var hasValue = this.markedTime != null;
    return x(_templateObject2$4 || (_templateObject2$4 = _taggedTemplateLiteral$4(["\n            <et2-button id=\"flag\"\n                        noSubmit=\"true\"\n                        exportparts=\"label\"\n                        class=", "\n                        title=", "\n            >\n                <et2-button-icon name=\"stopwatch\" noSubmit=\"true\" slot=\"prefix\"></et2-button-icon>\n                ", "\n            </et2-button>\n\t\t"])), o$2({
      "smallpart-time-flag": true,
      "hasValue": hasValue
    }), this.egw().lang(hasValue ? "Shows the reserved time, click on it to end the reservation" : "Reserves the time and allows reflection time"), hasValue ? x(_templateObject3$4 || (_templateObject3$4 = _taggedTemplateLiteral$4(["\n                    <et2-date-duration_ro dataFormat=\"s\" displayFormat=\"hms\"\n                                          .value=", "></et2-date-duration_ro>\n                    <et2-button-icon id=\"clear_flag\"\n                                     image=", "\n                                     @click=", "\n                    >\n                    </et2-button-icon>\n                "])), this.markedTime, this.timer ? h(this.timer) : "x", this.handleClearClick) : this.egw().lang("Flag"));
  }
}, _descriptor = _applyDecoratedDescriptor(_class.prototype, "markedTime", [_dec], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return null;
  }
}), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "timer", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _class);
function countDown(_x) {
  return _countDown.apply(this, arguments);
}
function _countDown() {
  _countDown = _wrapAsyncGenerator(function* (count) {
    while (count > 0) {
      yield count < 10 ? "".concat(count, "-circle") : "x-circle";
      count--;
      yield _awaitAsyncGenerator(new Promise(r => setTimeout(r, 1000)));
    }
    // Should be stopped by now
    yield "x";
  });
  return _countDown.apply(this, arguments);
}
customElements.define("smallpart-flag-time", SmallPartFlagTime);

var _templateObject$3, _templateObject2$3, _templateObject3$3, _templateObject4$1, _templateObject5;
function ownKeys$4(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$4(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$4(Object(t), !0).forEach(function (r) { _defineProperty$4(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$4(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$3(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$4(e, r, t) { return (r = _toPropertyKey$4(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$4(t) { var i = _toPrimitive$4(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$4(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 *
 *
 */
class SmallPartCatsSelect extends Et2StaticSelectMixin(Et2Select) {
  static get styles() {
    return [...super.styles, i(_templateObject$3 || (_templateObject$3 = _taggedTemplateLiteral$3(["\n\t\t\t/* Larger maximum height before scroll*/\n\t\t\t.select__tags {\n\t\t\t\tmax-height: 10em;\n\t\t\t}\n\n\t\t\t\t:host([readonly]) {\n\t\t\t\t\t.select__combobox, .select__combobox:hover {\n\t\t\t\t\t\tbackground: transparent;\n\t\t\t\t\t\tborder: none;\n\t\t\t\t\t}\n\n\t\t\t\t\t::part(form-control-input) {\n\t\t\t\t\t\tpadding-inline-start: var(--sl-spacing-medium);\n\t\t\t\t\t}\n\n\t\t\t\t\t/* Remove radius to avoid curved color bar */\n\n\t\t\t\t\t::part(combobox), ::part(tag__base) {\n\t\t\t\t\t\tborder-radius: 0;\n\t\t\t\t\t\tbackground-color: transparent;\n\t\t\t\t\t}\n\n\t\t\t\t\t::part(chevron) {\n\t\t\t\t\t\tvertical-align: middle;\n\t\t\t\t\t\tpadding-top: var(--sl-spacing-medium);\n\t\t\t\t\t\tfont-size: var(--sl-font-size-large);\n\t\t\t\t\t}\n\t\t\t}\n\t\t\t/* never show scroll-bar */\n\t\t\t:host(:not([rows])) ::part(tags) {\n\t\t\t\toverflow-y: hidden;\n\t\t\t}\n\n\t\t\t\t*::part(tag__base), .tag {\n\t\t\t\t\tborder-color: transparent;\n\t\t\t\t}\n\t\t\t"])))];
  }
  constructor() {
    super(...arguments);
    _defineProperty$4(this, "__onlysubs", void 0);
    this.allowFreeEntries = false;
  }
  static get properties() {
    return _objectSpread$4(_objectSpread$4({}, super.properties), {}, {
      noSubs: {
        type: Boolean
      },
      onlySubs: {
        type: String
      },
      asColorTag: {
        type: Boolean
      }
    });
  }
  loadFromXML(node) {
    super.loadFromXML(node);
    this._static_options = this.getInstanceManager().widgetContainer.getArrayMgr('sel_options').getEntry('catsOptions');
  }
  get select_options() {
    // TODO: This filter needs to be used all the time select_options is read.  Maybe make it static select?
    var options = super.select_options;
    if (this.noSubs) {
      options = options.filter(_item => {
        return !_item.parent_id;
      });
    }
    if (this.onlySubs) {
      options = options.filter(_item => {
        return _item.parent_id == this.options.onlySubs;
      });
    }
    return options;
  }
  set select_options(new_options) {
    // @ts-ignore IDE doesn't recognise property
    super.select_options = new_options;
  }
  set onlySubs(_parent_id) {
    var _parent_id$toString;
    this.__onlysubs = _parent_id === null || _parent_id === void 0 || (_parent_id$toString = _parent_id.toString()) === null || _parent_id$toString === void 0 ? void 0 : _parent_id$toString.split(":")[0];
    this.requestUpdate();
  }
  get onlySubs() {
    return this.__onlysubs;
  }
  set_value(_val) {
    var values = [];
    if (typeof _val == "string" && _val.toString().split(":").length > 1) {
      values = _val.toString().split(':');
      if (values.indexOf('lf') > 0) values.splice(2, 1);
      if (this.noSubs) values.splice(1, values.length);
      if (this.onlySubs) values.splice(0, 1);
    } else {
      values = _val;
    }
    super.set_value(values);
  }

  /**
   * Builds option template
   * @param option
   */
  _optionTemplate(option) {
    // Tag used must match this.optionTag, but you can't use the variable directly.
    // Pass option along so SearchMixin can grab it if needed
    var value = option.value.replaceAll(" ", "___");
    return x(_templateObject2$3 || (_templateObject2$3 = _taggedTemplateLiteral$3(["\n            <sl-option value=\"", "\"\n\t\t\t\t\t   part=\"option\"\n\t\t\t\t\t   title=\"", "\"\n\t\t\t\t\t   class=\"", "\" .option=", "\n\t\t\t\t\t   ?disabled=", "\n                       .selected=", "\n\t\t\t\t\t   style=\"border-left:6px solid ", "\">\n                ", "\n\t\t\t</sl-option>"])), value, !option.title || this.noLang ? option.title : this.egw().lang(option.title), option.class, option, option.disabled, this.getValueAsArray().some(v => v == value), option.color, this.noLang ? option.label : this.egw().lang(option.label));
  }

  /**
   * build tag template
   * @param option
   * @param index
   * @protected
   */
  _tagTemplate(option, index) {
    var _option$option;
    var readonly = this.readonly || option && typeof option.disabled != "undefined" && option.disabled;
    var image = this._iconTemplate(option.option);
    if (this.asColorTag && option !== null && option !== void 0 && (_option$option = option.option) !== null && _option$option !== void 0 && _option$option.color) {
      var _option$option2;
      return x(_templateObject3$3 || (_templateObject3$3 = _taggedTemplateLiteral$3(["\n\t\t\t\t<sl-icon name=\"bookmark\" style=\"color:", "\"></sl-icon>\n\t\t\t"])), option === null || option === void 0 || (_option$option2 = option.option) === null || _option$option2 === void 0 ? void 0 : _option$option2.color);
    } else {
      var _option$option3, _option$option4;
      return x(_templateObject4$1 || (_templateObject4$1 = _taggedTemplateLiteral$3(["\n            <et2-tag\n                    part=\"tag\"\n                    exportparts=\"\n                      base:tag__base,\n                      content:tag__content,\n                      remove-button:tag__remove-button,\n                      remove-button__base:tag__remove-button__base,\n                      icon:icon\n                    \"\n\t\t\t\t\tstyle=\"border-left:6px solid ", "\"\n                    ?readonly=", "\n                    .value=", "\n            >\n                ", "\n                ", "\n            </et2-tag>\n            ", "\n\t\t"])), option === null || option === void 0 || (_option$option3 = option.option) === null || _option$option3 === void 0 ? void 0 : _option$option3.color, readonly, option === null || option === void 0 || (_option$option4 = option.option) === null || _option$option4 === void 0 ? void 0 : _option$option4.value, image !== null && image !== void 0 ? image : A, option.getTextLabel().trim(), index >= this.value.length - 1 ? A : x(_templateObject5 || (_templateObject5 = _taggedTemplateLiteral$3(["\n                <sl-icon name=\"chevron-right\" part=\"chevron\"></sl-icon>"]))));
    }
  }
}
_defineProperty$4(SmallPartCatsSelect, "keepTag", void 0);
customElements.define("smallpart-cats-select", SmallPartCatsSelect);

var dexieExports = {};
var dexie = {
  get exports(){ return dexieExports; },
  set exports(v){ dexieExports = v; },
};

/*
 * Dexie.js - a minimalistic wrapper for IndexedDB
 * ===============================================
 *
 * By David Fahlander, david.fahlander@gmail.com
 *
 * Version 3.2.4, Tue May 30 2023
 *
 * https://dexie.org
 *
 * Apache License Version 2.0, January 2004, http://www.apache.org/licenses/
 */

(function (module, exports) {
	(function (global, factory) {
	    'object' === 'object' && 'object' !== 'undefined' ? module.exports = factory() :
	    typeof undefined === 'function' && undefined.amd ? undefined(factory) :
	    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.Dexie = factory());
	})(commonjsGlobal, (function () { 'use strict';

	    /*! *****************************************************************************
	    Copyright (c) Microsoft Corporation.
	    Permission to use, copy, modify, and/or distribute this software for any
	    purpose with or without fee is hereby granted.
	    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
	    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
	    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
	    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
	    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
	    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
	    PERFORMANCE OF THIS SOFTWARE.
	    ***************************************************************************** */
	    var __assign = function() {
	        __assign = Object.assign || function __assign(t) {
	            for (var s, i = 1, n = arguments.length; i < n; i++) {
	                s = arguments[i];
	                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
	            }
	            return t;
	        };
	        return __assign.apply(this, arguments);
	    };
	    function __spreadArray(to, from, pack) {
	        if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	            if (ar || !(i in from)) {
	                if (!ar) ar = Array.prototype.slice.call(from, 0, i);
	                ar[i] = from[i];
	            }
	        }
	        return to.concat(ar || Array.prototype.slice.call(from));
	    }

	    var _global = typeof globalThis !== 'undefined' ? globalThis :
	        typeof self !== 'undefined' ? self :
	            typeof window !== 'undefined' ? window :
	                commonjsGlobal;

	    var keys = Object.keys;
	    var isArray = Array.isArray;
	    if (typeof Promise !== 'undefined' && !_global.Promise) {
	        _global.Promise = Promise;
	    }
	    function extend(obj, extension) {
	        if (typeof extension !== 'object')
	            return obj;
	        keys(extension).forEach(function (key) {
	            obj[key] = extension[key];
	        });
	        return obj;
	    }
	    var getProto = Object.getPrototypeOf;
	    var _hasOwn = {}.hasOwnProperty;
	    function hasOwn(obj, prop) {
	        return _hasOwn.call(obj, prop);
	    }
	    function props(proto, extension) {
	        if (typeof extension === 'function')
	            extension = extension(getProto(proto));
	        (typeof Reflect === "undefined" ? keys : Reflect.ownKeys)(extension).forEach(function (key) {
	            setProp(proto, key, extension[key]);
	        });
	    }
	    var defineProperty = Object.defineProperty;
	    function setProp(obj, prop, functionOrGetSet, options) {
	        defineProperty(obj, prop, extend(functionOrGetSet && hasOwn(functionOrGetSet, "get") && typeof functionOrGetSet.get === 'function' ?
	            { get: functionOrGetSet.get, set: functionOrGetSet.set, configurable: true } :
	            { value: functionOrGetSet, configurable: true, writable: true }, options));
	    }
	    function derive(Child) {
	        return {
	            from: function (Parent) {
	                Child.prototype = Object.create(Parent.prototype);
	                setProp(Child.prototype, "constructor", Child);
	                return {
	                    extend: props.bind(null, Child.prototype)
	                };
	            }
	        };
	    }
	    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	    function getPropertyDescriptor(obj, prop) {
	        var pd = getOwnPropertyDescriptor(obj, prop);
	        var proto;
	        return pd || (proto = getProto(obj)) && getPropertyDescriptor(proto, prop);
	    }
	    var _slice = [].slice;
	    function slice(args, start, end) {
	        return _slice.call(args, start, end);
	    }
	    function override(origFunc, overridedFactory) {
	        return overridedFactory(origFunc);
	    }
	    function assert(b) {
	        if (!b)
	            throw new Error("Assertion Failed");
	    }
	    function asap$1(fn) {
	        if (_global.setImmediate)
	            setImmediate(fn);
	        else
	            setTimeout(fn, 0);
	    }
	    function arrayToObject(array, extractor) {
	        return array.reduce(function (result, item, i) {
	            var nameAndValue = extractor(item, i);
	            if (nameAndValue)
	                result[nameAndValue[0]] = nameAndValue[1];
	            return result;
	        }, {});
	    }
	    function tryCatch(fn, onerror, args) {
	        try {
	            fn.apply(null, args);
	        }
	        catch (ex) {
	            onerror && onerror(ex);
	        }
	    }
	    function getByKeyPath(obj, keyPath) {
	        if (hasOwn(obj, keyPath))
	            return obj[keyPath];
	        if (!keyPath)
	            return obj;
	        if (typeof keyPath !== 'string') {
	            var rv = [];
	            for (var i = 0, l = keyPath.length; i < l; ++i) {
	                var val = getByKeyPath(obj, keyPath[i]);
	                rv.push(val);
	            }
	            return rv;
	        }
	        var period = keyPath.indexOf('.');
	        if (period !== -1) {
	            var innerObj = obj[keyPath.substr(0, period)];
	            return innerObj === undefined ? undefined : getByKeyPath(innerObj, keyPath.substr(period + 1));
	        }
	        return undefined;
	    }
	    function setByKeyPath(obj, keyPath, value) {
	        if (!obj || keyPath === undefined)
	            return;
	        if ('isFrozen' in Object && Object.isFrozen(obj))
	            return;
	        if (typeof keyPath !== 'string' && 'length' in keyPath) {
	            assert(typeof value !== 'string' && 'length' in value);
	            for (var i = 0, l = keyPath.length; i < l; ++i) {
	                setByKeyPath(obj, keyPath[i], value[i]);
	            }
	        }
	        else {
	            var period = keyPath.indexOf('.');
	            if (period !== -1) {
	                var currentKeyPath = keyPath.substr(0, period);
	                var remainingKeyPath = keyPath.substr(period + 1);
	                if (remainingKeyPath === "")
	                    if (value === undefined) {
	                        if (isArray(obj) && !isNaN(parseInt(currentKeyPath)))
	                            obj.splice(currentKeyPath, 1);
	                        else
	                            delete obj[currentKeyPath];
	                    }
	                    else
	                        obj[currentKeyPath] = value;
	                else {
	                    var innerObj = obj[currentKeyPath];
	                    if (!innerObj || !hasOwn(obj, currentKeyPath))
	                        innerObj = (obj[currentKeyPath] = {});
	                    setByKeyPath(innerObj, remainingKeyPath, value);
	                }
	            }
	            else {
	                if (value === undefined) {
	                    if (isArray(obj) && !isNaN(parseInt(keyPath)))
	                        obj.splice(keyPath, 1);
	                    else
	                        delete obj[keyPath];
	                }
	                else
	                    obj[keyPath] = value;
	            }
	        }
	    }
	    function delByKeyPath(obj, keyPath) {
	        if (typeof keyPath === 'string')
	            setByKeyPath(obj, keyPath, undefined);
	        else if ('length' in keyPath)
	            [].map.call(keyPath, function (kp) {
	                setByKeyPath(obj, kp, undefined);
	            });
	    }
	    function shallowClone(obj) {
	        var rv = {};
	        for (var m in obj) {
	            if (hasOwn(obj, m))
	                rv[m] = obj[m];
	        }
	        return rv;
	    }
	    var concat = [].concat;
	    function flatten(a) {
	        return concat.apply([], a);
	    }
	    var intrinsicTypeNames = "Boolean,String,Date,RegExp,Blob,File,FileList,FileSystemFileHandle,ArrayBuffer,DataView,Uint8ClampedArray,ImageBitmap,ImageData,Map,Set,CryptoKey"
	        .split(',').concat(flatten([8, 16, 32, 64].map(function (num) { return ["Int", "Uint", "Float"].map(function (t) { return t + num + "Array"; }); }))).filter(function (t) { return _global[t]; });
	    var intrinsicTypes = intrinsicTypeNames.map(function (t) { return _global[t]; });
	    arrayToObject(intrinsicTypeNames, function (x) { return [x, true]; });
	    var circularRefs = null;
	    function deepClone(any) {
	        circularRefs = typeof WeakMap !== 'undefined' && new WeakMap();
	        var rv = innerDeepClone(any);
	        circularRefs = null;
	        return rv;
	    }
	    function innerDeepClone(any) {
	        if (!any || typeof any !== 'object')
	            return any;
	        var rv = circularRefs && circularRefs.get(any);
	        if (rv)
	            return rv;
	        if (isArray(any)) {
	            rv = [];
	            circularRefs && circularRefs.set(any, rv);
	            for (var i = 0, l = any.length; i < l; ++i) {
	                rv.push(innerDeepClone(any[i]));
	            }
	        }
	        else if (intrinsicTypes.indexOf(any.constructor) >= 0) {
	            rv = any;
	        }
	        else {
	            var proto = getProto(any);
	            rv = proto === Object.prototype ? {} : Object.create(proto);
	            circularRefs && circularRefs.set(any, rv);
	            for (var prop in any) {
	                if (hasOwn(any, prop)) {
	                    rv[prop] = innerDeepClone(any[prop]);
	                }
	            }
	        }
	        return rv;
	    }
	    var toString = {}.toString;
	    function toStringTag(o) {
	        return toString.call(o).slice(8, -1);
	    }
	    var iteratorSymbol = typeof Symbol !== 'undefined' ?
	        Symbol.iterator :
	        '@@iterator';
	    var getIteratorOf = typeof iteratorSymbol === "symbol" ? function (x) {
	        var i;
	        return x != null && (i = x[iteratorSymbol]) && i.apply(x);
	    } : function () { return null; };
	    var NO_CHAR_ARRAY = {};
	    function getArrayOf(arrayLike) {
	        var i, a, x, it;
	        if (arguments.length === 1) {
	            if (isArray(arrayLike))
	                return arrayLike.slice();
	            if (this === NO_CHAR_ARRAY && typeof arrayLike === 'string')
	                return [arrayLike];
	            if ((it = getIteratorOf(arrayLike))) {
	                a = [];
	                while ((x = it.next()), !x.done)
	                    a.push(x.value);
	                return a;
	            }
	            if (arrayLike == null)
	                return [arrayLike];
	            i = arrayLike.length;
	            if (typeof i === 'number') {
	                a = new Array(i);
	                while (i--)
	                    a[i] = arrayLike[i];
	                return a;
	            }
	            return [arrayLike];
	        }
	        i = arguments.length;
	        a = new Array(i);
	        while (i--)
	            a[i] = arguments[i];
	        return a;
	    }
	    var isAsyncFunction = typeof Symbol !== 'undefined'
	        ? function (fn) { return fn[Symbol.toStringTag] === 'AsyncFunction'; }
	        : function () { return false; };

	    var debug = typeof location !== 'undefined' &&
	        /^(http|https):\/\/(localhost|127\.0\.0\.1)/.test(location.href);
	    function setDebug(value, filter) {
	        debug = value;
	        libraryFilter = filter;
	    }
	    var libraryFilter = function () { return true; };
	    var NEEDS_THROW_FOR_STACK = !new Error("").stack;
	    function getErrorWithStack() {
	        if (NEEDS_THROW_FOR_STACK)
	            try {
	                getErrorWithStack.arguments;
	                throw new Error();
	            }
	            catch (e) {
	                return e;
	            }
	        return new Error();
	    }
	    function prettyStack(exception, numIgnoredFrames) {
	        var stack = exception.stack;
	        if (!stack)
	            return "";
	        numIgnoredFrames = (numIgnoredFrames || 0);
	        if (stack.indexOf(exception.name) === 0)
	            numIgnoredFrames += (exception.name + exception.message).split('\n').length;
	        return stack.split('\n')
	            .slice(numIgnoredFrames)
	            .filter(libraryFilter)
	            .map(function (frame) { return "\n" + frame; })
	            .join('');
	    }

	    var dexieErrorNames = [
	        'Modify',
	        'Bulk',
	        'OpenFailed',
	        'VersionChange',
	        'Schema',
	        'Upgrade',
	        'InvalidTable',
	        'MissingAPI',
	        'NoSuchDatabase',
	        'InvalidArgument',
	        'SubTransaction',
	        'Unsupported',
	        'Internal',
	        'DatabaseClosed',
	        'PrematureCommit',
	        'ForeignAwait'
	    ];
	    var idbDomErrorNames = [
	        'Unknown',
	        'Constraint',
	        'Data',
	        'TransactionInactive',
	        'ReadOnly',
	        'Version',
	        'NotFound',
	        'InvalidState',
	        'InvalidAccess',
	        'Abort',
	        'Timeout',
	        'QuotaExceeded',
	        'Syntax',
	        'DataClone'
	    ];
	    var errorList = dexieErrorNames.concat(idbDomErrorNames);
	    var defaultTexts = {
	        VersionChanged: "Database version changed by other database connection",
	        DatabaseClosed: "Database has been closed",
	        Abort: "Transaction aborted",
	        TransactionInactive: "Transaction has already completed or failed",
	        MissingAPI: "IndexedDB API missing. Please visit https://tinyurl.com/y2uuvskb"
	    };
	    function DexieError(name, msg) {
	        this._e = getErrorWithStack();
	        this.name = name;
	        this.message = msg;
	    }
	    derive(DexieError).from(Error).extend({
	        stack: {
	            get: function () {
	                return this._stack ||
	                    (this._stack = this.name + ": " + this.message + prettyStack(this._e, 2));
	            }
	        },
	        toString: function () { return this.name + ": " + this.message; }
	    });
	    function getMultiErrorMessage(msg, failures) {
	        return msg + ". Errors: " + Object.keys(failures)
	            .map(function (key) { return failures[key].toString(); })
	            .filter(function (v, i, s) { return s.indexOf(v) === i; })
	            .join('\n');
	    }
	    function ModifyError(msg, failures, successCount, failedKeys) {
	        this._e = getErrorWithStack();
	        this.failures = failures;
	        this.failedKeys = failedKeys;
	        this.successCount = successCount;
	        this.message = getMultiErrorMessage(msg, failures);
	    }
	    derive(ModifyError).from(DexieError);
	    function BulkError(msg, failures) {
	        this._e = getErrorWithStack();
	        this.name = "BulkError";
	        this.failures = Object.keys(failures).map(function (pos) { return failures[pos]; });
	        this.failuresByPos = failures;
	        this.message = getMultiErrorMessage(msg, failures);
	    }
	    derive(BulkError).from(DexieError);
	    var errnames = errorList.reduce(function (obj, name) { return (obj[name] = name + "Error", obj); }, {});
	    var BaseException = DexieError;
	    var exceptions = errorList.reduce(function (obj, name) {
	        var fullName = name + "Error";
	        function DexieError(msgOrInner, inner) {
	            this._e = getErrorWithStack();
	            this.name = fullName;
	            if (!msgOrInner) {
	                this.message = defaultTexts[name] || fullName;
	                this.inner = null;
	            }
	            else if (typeof msgOrInner === 'string') {
	                this.message = "" + msgOrInner + (!inner ? '' : '\n ' + inner);
	                this.inner = inner || null;
	            }
	            else if (typeof msgOrInner === 'object') {
	                this.message = msgOrInner.name + " " + msgOrInner.message;
	                this.inner = msgOrInner;
	            }
	        }
	        derive(DexieError).from(BaseException);
	        obj[name] = DexieError;
	        return obj;
	    }, {});
	    exceptions.Syntax = SyntaxError;
	    exceptions.Type = TypeError;
	    exceptions.Range = RangeError;
	    var exceptionMap = idbDomErrorNames.reduce(function (obj, name) {
	        obj[name + "Error"] = exceptions[name];
	        return obj;
	    }, {});
	    function mapError(domError, message) {
	        if (!domError || domError instanceof DexieError || domError instanceof TypeError || domError instanceof SyntaxError || !domError.name || !exceptionMap[domError.name])
	            return domError;
	        var rv = new exceptionMap[domError.name](message || domError.message, domError);
	        if ("stack" in domError) {
	            setProp(rv, "stack", { get: function () {
	                    return this.inner.stack;
	                } });
	        }
	        return rv;
	    }
	    var fullNameExceptions = errorList.reduce(function (obj, name) {
	        if (["Syntax", "Type", "Range"].indexOf(name) === -1)
	            obj[name + "Error"] = exceptions[name];
	        return obj;
	    }, {});
	    fullNameExceptions.ModifyError = ModifyError;
	    fullNameExceptions.DexieError = DexieError;
	    fullNameExceptions.BulkError = BulkError;

	    function nop() { }
	    function mirror(val) { return val; }
	    function pureFunctionChain(f1, f2) {
	        if (f1 == null || f1 === mirror)
	            return f2;
	        return function (val) {
	            return f2(f1(val));
	        };
	    }
	    function callBoth(on1, on2) {
	        return function () {
	            on1.apply(this, arguments);
	            on2.apply(this, arguments);
	        };
	    }
	    function hookCreatingChain(f1, f2) {
	        if (f1 === nop)
	            return f2;
	        return function () {
	            var res = f1.apply(this, arguments);
	            if (res !== undefined)
	                arguments[0] = res;
	            var onsuccess = this.onsuccess,
	            onerror = this.onerror;
	            this.onsuccess = null;
	            this.onerror = null;
	            var res2 = f2.apply(this, arguments);
	            if (onsuccess)
	                this.onsuccess = this.onsuccess ? callBoth(onsuccess, this.onsuccess) : onsuccess;
	            if (onerror)
	                this.onerror = this.onerror ? callBoth(onerror, this.onerror) : onerror;
	            return res2 !== undefined ? res2 : res;
	        };
	    }
	    function hookDeletingChain(f1, f2) {
	        if (f1 === nop)
	            return f2;
	        return function () {
	            f1.apply(this, arguments);
	            var onsuccess = this.onsuccess,
	            onerror = this.onerror;
	            this.onsuccess = this.onerror = null;
	            f2.apply(this, arguments);
	            if (onsuccess)
	                this.onsuccess = this.onsuccess ? callBoth(onsuccess, this.onsuccess) : onsuccess;
	            if (onerror)
	                this.onerror = this.onerror ? callBoth(onerror, this.onerror) : onerror;
	        };
	    }
	    function hookUpdatingChain(f1, f2) {
	        if (f1 === nop)
	            return f2;
	        return function (modifications) {
	            var res = f1.apply(this, arguments);
	            extend(modifications, res);
	            var onsuccess = this.onsuccess,
	            onerror = this.onerror;
	            this.onsuccess = null;
	            this.onerror = null;
	            var res2 = f2.apply(this, arguments);
	            if (onsuccess)
	                this.onsuccess = this.onsuccess ? callBoth(onsuccess, this.onsuccess) : onsuccess;
	            if (onerror)
	                this.onerror = this.onerror ? callBoth(onerror, this.onerror) : onerror;
	            return res === undefined ?
	                (res2 === undefined ? undefined : res2) :
	                (extend(res, res2));
	        };
	    }
	    function reverseStoppableEventChain(f1, f2) {
	        if (f1 === nop)
	            return f2;
	        return function () {
	            if (f2.apply(this, arguments) === false)
	                return false;
	            return f1.apply(this, arguments);
	        };
	    }
	    function promisableChain(f1, f2) {
	        if (f1 === nop)
	            return f2;
	        return function () {
	            var res = f1.apply(this, arguments);
	            if (res && typeof res.then === 'function') {
	                var thiz = this, i = arguments.length, args = new Array(i);
	                while (i--)
	                    args[i] = arguments[i];
	                return res.then(function () {
	                    return f2.apply(thiz, args);
	                });
	            }
	            return f2.apply(this, arguments);
	        };
	    }

	    var INTERNAL = {};
	    var LONG_STACKS_CLIP_LIMIT = 100,
	    MAX_LONG_STACKS = 20, ZONE_ECHO_LIMIT = 100, _a$1 = typeof Promise === 'undefined' ?
	        [] :
	        (function () {
	            var globalP = Promise.resolve();
	            if (typeof crypto === 'undefined' || !crypto.subtle)
	                return [globalP, getProto(globalP), globalP];
	            var nativeP = crypto.subtle.digest("SHA-512", new Uint8Array([0]));
	            return [
	                nativeP,
	                getProto(nativeP),
	                globalP
	            ];
	        })(), resolvedNativePromise = _a$1[0], nativePromiseProto = _a$1[1], resolvedGlobalPromise = _a$1[2], nativePromiseThen = nativePromiseProto && nativePromiseProto.then;
	    var NativePromise = resolvedNativePromise && resolvedNativePromise.constructor;
	    var patchGlobalPromise = !!resolvedGlobalPromise;
	    var stack_being_generated = false;
	    var schedulePhysicalTick = resolvedGlobalPromise ?
	        function () { resolvedGlobalPromise.then(physicalTick); }
	        :
	            _global.setImmediate ?
	                setImmediate.bind(null, physicalTick) :
	                _global.MutationObserver ?
	                    function () {
	                        var hiddenDiv = document.createElement("div");
	                        (new MutationObserver(function () {
	                            physicalTick();
	                            hiddenDiv = null;
	                        })).observe(hiddenDiv, { attributes: true });
	                        hiddenDiv.setAttribute('i', '1');
	                    } :
	                    function () { setTimeout(physicalTick, 0); };
	    var asap = function (callback, args) {
	        microtickQueue.push([callback, args]);
	        if (needsNewPhysicalTick) {
	            schedulePhysicalTick();
	            needsNewPhysicalTick = false;
	        }
	    };
	    var isOutsideMicroTick = true,
	    needsNewPhysicalTick = true,
	    unhandledErrors = [],
	    rejectingErrors = [],
	    currentFulfiller = null, rejectionMapper = mirror;
	    var globalPSD = {
	        id: 'global',
	        global: true,
	        ref: 0,
	        unhandleds: [],
	        onunhandled: globalError,
	        pgp: false,
	        env: {},
	        finalize: function () {
	            this.unhandleds.forEach(function (uh) {
	                try {
	                    globalError(uh[0], uh[1]);
	                }
	                catch (e) { }
	            });
	        }
	    };
	    var PSD = globalPSD;
	    var microtickQueue = [];
	    var numScheduledCalls = 0;
	    var tickFinalizers = [];
	    function DexiePromise(fn) {
	        if (typeof this !== 'object')
	            throw new TypeError('Promises must be constructed via new');
	        this._listeners = [];
	        this.onuncatched = nop;
	        this._lib = false;
	        var psd = (this._PSD = PSD);
	        if (debug) {
	            this._stackHolder = getErrorWithStack();
	            this._prev = null;
	            this._numPrev = 0;
	        }
	        if (typeof fn !== 'function') {
	            if (fn !== INTERNAL)
	                throw new TypeError('Not a function');
	            this._state = arguments[1];
	            this._value = arguments[2];
	            if (this._state === false)
	                handleRejection(this, this._value);
	            return;
	        }
	        this._state = null;
	        this._value = null;
	        ++psd.ref;
	        executePromiseTask(this, fn);
	    }
	    var thenProp = {
	        get: function () {
	            var psd = PSD, microTaskId = totalEchoes;
	            function then(onFulfilled, onRejected) {
	                var _this = this;
	                var possibleAwait = !psd.global && (psd !== PSD || microTaskId !== totalEchoes);
	                var cleanup = possibleAwait && !decrementExpectedAwaits();
	                var rv = new DexiePromise(function (resolve, reject) {
	                    propagateToListener(_this, new Listener(nativeAwaitCompatibleWrap(onFulfilled, psd, possibleAwait, cleanup), nativeAwaitCompatibleWrap(onRejected, psd, possibleAwait, cleanup), resolve, reject, psd));
	                });
	                debug && linkToPreviousPromise(rv, this);
	                return rv;
	            }
	            then.prototype = INTERNAL;
	            return then;
	        },
	        set: function (value) {
	            setProp(this, 'then', value && value.prototype === INTERNAL ?
	                thenProp :
	                {
	                    get: function () {
	                        return value;
	                    },
	                    set: thenProp.set
	                });
	        }
	    };
	    props(DexiePromise.prototype, {
	        then: thenProp,
	        _then: function (onFulfilled, onRejected) {
	            propagateToListener(this, new Listener(null, null, onFulfilled, onRejected, PSD));
	        },
	        catch: function (onRejected) {
	            if (arguments.length === 1)
	                return this.then(null, onRejected);
	            var type = arguments[0], handler = arguments[1];
	            return typeof type === 'function' ? this.then(null, function (err) {
	                return err instanceof type ? handler(err) : PromiseReject(err);
	            })
	                : this.then(null, function (err) {
	                    return err && err.name === type ? handler(err) : PromiseReject(err);
	                });
	        },
	        finally: function (onFinally) {
	            return this.then(function (value) {
	                onFinally();
	                return value;
	            }, function (err) {
	                onFinally();
	                return PromiseReject(err);
	            });
	        },
	        stack: {
	            get: function () {
	                if (this._stack)
	                    return this._stack;
	                try {
	                    stack_being_generated = true;
	                    var stacks = getStack(this, [], MAX_LONG_STACKS);
	                    var stack = stacks.join("\nFrom previous: ");
	                    if (this._state !== null)
	                        this._stack = stack;
	                    return stack;
	                }
	                finally {
	                    stack_being_generated = false;
	                }
	            }
	        },
	        timeout: function (ms, msg) {
	            var _this = this;
	            return ms < Infinity ?
	                new DexiePromise(function (resolve, reject) {
	                    var handle = setTimeout(function () { return reject(new exceptions.Timeout(msg)); }, ms);
	                    _this.then(resolve, reject).finally(clearTimeout.bind(null, handle));
	                }) : this;
	        }
	    });
	    if (typeof Symbol !== 'undefined' && Symbol.toStringTag)
	        setProp(DexiePromise.prototype, Symbol.toStringTag, 'Dexie.Promise');
	    globalPSD.env = snapShot();
	    function Listener(onFulfilled, onRejected, resolve, reject, zone) {
	        this.onFulfilled = typeof onFulfilled === 'function' ? onFulfilled : null;
	        this.onRejected = typeof onRejected === 'function' ? onRejected : null;
	        this.resolve = resolve;
	        this.reject = reject;
	        this.psd = zone;
	    }
	    props(DexiePromise, {
	        all: function () {
	            var values = getArrayOf.apply(null, arguments)
	                .map(onPossibleParallellAsync);
	            return new DexiePromise(function (resolve, reject) {
	                if (values.length === 0)
	                    resolve([]);
	                var remaining = values.length;
	                values.forEach(function (a, i) { return DexiePromise.resolve(a).then(function (x) {
	                    values[i] = x;
	                    if (!--remaining)
	                        resolve(values);
	                }, reject); });
	            });
	        },
	        resolve: function (value) {
	            if (value instanceof DexiePromise)
	                return value;
	            if (value && typeof value.then === 'function')
	                return new DexiePromise(function (resolve, reject) {
	                    value.then(resolve, reject);
	                });
	            var rv = new DexiePromise(INTERNAL, true, value);
	            linkToPreviousPromise(rv, currentFulfiller);
	            return rv;
	        },
	        reject: PromiseReject,
	        race: function () {
	            var values = getArrayOf.apply(null, arguments).map(onPossibleParallellAsync);
	            return new DexiePromise(function (resolve, reject) {
	                values.map(function (value) { return DexiePromise.resolve(value).then(resolve, reject); });
	            });
	        },
	        PSD: {
	            get: function () { return PSD; },
	            set: function (value) { return PSD = value; }
	        },
	        totalEchoes: { get: function () { return totalEchoes; } },
	        newPSD: newScope,
	        usePSD: usePSD,
	        scheduler: {
	            get: function () { return asap; },
	            set: function (value) { asap = value; }
	        },
	        rejectionMapper: {
	            get: function () { return rejectionMapper; },
	            set: function (value) { rejectionMapper = value; }
	        },
	        follow: function (fn, zoneProps) {
	            return new DexiePromise(function (resolve, reject) {
	                return newScope(function (resolve, reject) {
	                    var psd = PSD;
	                    psd.unhandleds = [];
	                    psd.onunhandled = reject;
	                    psd.finalize = callBoth(function () {
	                        var _this = this;
	                        run_at_end_of_this_or_next_physical_tick(function () {
	                            _this.unhandleds.length === 0 ? resolve() : reject(_this.unhandleds[0]);
	                        });
	                    }, psd.finalize);
	                    fn();
	                }, zoneProps, resolve, reject);
	            });
	        }
	    });
	    if (NativePromise) {
	        if (NativePromise.allSettled)
	            setProp(DexiePromise, "allSettled", function () {
	                var possiblePromises = getArrayOf.apply(null, arguments).map(onPossibleParallellAsync);
	                return new DexiePromise(function (resolve) {
	                    if (possiblePromises.length === 0)
	                        resolve([]);
	                    var remaining = possiblePromises.length;
	                    var results = new Array(remaining);
	                    possiblePromises.forEach(function (p, i) { return DexiePromise.resolve(p).then(function (value) { return results[i] = { status: "fulfilled", value: value }; }, function (reason) { return results[i] = { status: "rejected", reason: reason }; })
	                        .then(function () { return --remaining || resolve(results); }); });
	                });
	            });
	        if (NativePromise.any && typeof AggregateError !== 'undefined')
	            setProp(DexiePromise, "any", function () {
	                var possiblePromises = getArrayOf.apply(null, arguments).map(onPossibleParallellAsync);
	                return new DexiePromise(function (resolve, reject) {
	                    if (possiblePromises.length === 0)
	                        reject(new AggregateError([]));
	                    var remaining = possiblePromises.length;
	                    var failures = new Array(remaining);
	                    possiblePromises.forEach(function (p, i) { return DexiePromise.resolve(p).then(function (value) { return resolve(value); }, function (failure) {
	                        failures[i] = failure;
	                        if (!--remaining)
	                            reject(new AggregateError(failures));
	                    }); });
	                });
	            });
	    }
	    function executePromiseTask(promise, fn) {
	        try {
	            fn(function (value) {
	                if (promise._state !== null)
	                    return;
	                if (value === promise)
	                    throw new TypeError('A promise cannot be resolved with itself.');
	                var shouldExecuteTick = promise._lib && beginMicroTickScope();
	                if (value && typeof value.then === 'function') {
	                    executePromiseTask(promise, function (resolve, reject) {
	                        value instanceof DexiePromise ?
	                            value._then(resolve, reject) :
	                            value.then(resolve, reject);
	                    });
	                }
	                else {
	                    promise._state = true;
	                    promise._value = value;
	                    propagateAllListeners(promise);
	                }
	                if (shouldExecuteTick)
	                    endMicroTickScope();
	            }, handleRejection.bind(null, promise));
	        }
	        catch (ex) {
	            handleRejection(promise, ex);
	        }
	    }
	    function handleRejection(promise, reason) {
	        rejectingErrors.push(reason);
	        if (promise._state !== null)
	            return;
	        var shouldExecuteTick = promise._lib && beginMicroTickScope();
	        reason = rejectionMapper(reason);
	        promise._state = false;
	        promise._value = reason;
	        debug && reason !== null && typeof reason === 'object' && !reason._promise && tryCatch(function () {
	            var origProp = getPropertyDescriptor(reason, "stack");
	            reason._promise = promise;
	            setProp(reason, "stack", {
	                get: function () {
	                    return stack_being_generated ?
	                        origProp && (origProp.get ?
	                            origProp.get.apply(reason) :
	                            origProp.value) :
	                        promise.stack;
	                }
	            });
	        });
	        addPossiblyUnhandledError(promise);
	        propagateAllListeners(promise);
	        if (shouldExecuteTick)
	            endMicroTickScope();
	    }
	    function propagateAllListeners(promise) {
	        var listeners = promise._listeners;
	        promise._listeners = [];
	        for (var i = 0, len = listeners.length; i < len; ++i) {
	            propagateToListener(promise, listeners[i]);
	        }
	        var psd = promise._PSD;
	        --psd.ref || psd.finalize();
	        if (numScheduledCalls === 0) {
	            ++numScheduledCalls;
	            asap(function () {
	                if (--numScheduledCalls === 0)
	                    finalizePhysicalTick();
	            }, []);
	        }
	    }
	    function propagateToListener(promise, listener) {
	        if (promise._state === null) {
	            promise._listeners.push(listener);
	            return;
	        }
	        var cb = promise._state ? listener.onFulfilled : listener.onRejected;
	        if (cb === null) {
	            return (promise._state ? listener.resolve : listener.reject)(promise._value);
	        }
	        ++listener.psd.ref;
	        ++numScheduledCalls;
	        asap(callListener, [cb, promise, listener]);
	    }
	    function callListener(cb, promise, listener) {
	        try {
	            currentFulfiller = promise;
	            var ret, value = promise._value;
	            if (promise._state) {
	                ret = cb(value);
	            }
	            else {
	                if (rejectingErrors.length)
	                    rejectingErrors = [];
	                ret = cb(value);
	                if (rejectingErrors.indexOf(value) === -1)
	                    markErrorAsHandled(promise);
	            }
	            listener.resolve(ret);
	        }
	        catch (e) {
	            listener.reject(e);
	        }
	        finally {
	            currentFulfiller = null;
	            if (--numScheduledCalls === 0)
	                finalizePhysicalTick();
	            --listener.psd.ref || listener.psd.finalize();
	        }
	    }
	    function getStack(promise, stacks, limit) {
	        if (stacks.length === limit)
	            return stacks;
	        var stack = "";
	        if (promise._state === false) {
	            var failure = promise._value, errorName, message;
	            if (failure != null) {
	                errorName = failure.name || "Error";
	                message = failure.message || failure;
	                stack = prettyStack(failure, 0);
	            }
	            else {
	                errorName = failure;
	                message = "";
	            }
	            stacks.push(errorName + (message ? ": " + message : "") + stack);
	        }
	        if (debug) {
	            stack = prettyStack(promise._stackHolder, 2);
	            if (stack && stacks.indexOf(stack) === -1)
	                stacks.push(stack);
	            if (promise._prev)
	                getStack(promise._prev, stacks, limit);
	        }
	        return stacks;
	    }
	    function linkToPreviousPromise(promise, prev) {
	        var numPrev = prev ? prev._numPrev + 1 : 0;
	        if (numPrev < LONG_STACKS_CLIP_LIMIT) {
	            promise._prev = prev;
	            promise._numPrev = numPrev;
	        }
	    }
	    function physicalTick() {
	        beginMicroTickScope() && endMicroTickScope();
	    }
	    function beginMicroTickScope() {
	        var wasRootExec = isOutsideMicroTick;
	        isOutsideMicroTick = false;
	        needsNewPhysicalTick = false;
	        return wasRootExec;
	    }
	    function endMicroTickScope() {
	        var callbacks, i, l;
	        do {
	            while (microtickQueue.length > 0) {
	                callbacks = microtickQueue;
	                microtickQueue = [];
	                l = callbacks.length;
	                for (i = 0; i < l; ++i) {
	                    var item = callbacks[i];
	                    item[0].apply(null, item[1]);
	                }
	            }
	        } while (microtickQueue.length > 0);
	        isOutsideMicroTick = true;
	        needsNewPhysicalTick = true;
	    }
	    function finalizePhysicalTick() {
	        var unhandledErrs = unhandledErrors;
	        unhandledErrors = [];
	        unhandledErrs.forEach(function (p) {
	            p._PSD.onunhandled.call(null, p._value, p);
	        });
	        var finalizers = tickFinalizers.slice(0);
	        var i = finalizers.length;
	        while (i)
	            finalizers[--i]();
	    }
	    function run_at_end_of_this_or_next_physical_tick(fn) {
	        function finalizer() {
	            fn();
	            tickFinalizers.splice(tickFinalizers.indexOf(finalizer), 1);
	        }
	        tickFinalizers.push(finalizer);
	        ++numScheduledCalls;
	        asap(function () {
	            if (--numScheduledCalls === 0)
	                finalizePhysicalTick();
	        }, []);
	    }
	    function addPossiblyUnhandledError(promise) {
	        if (!unhandledErrors.some(function (p) { return p._value === promise._value; }))
	            unhandledErrors.push(promise);
	    }
	    function markErrorAsHandled(promise) {
	        var i = unhandledErrors.length;
	        while (i)
	            if (unhandledErrors[--i]._value === promise._value) {
	                unhandledErrors.splice(i, 1);
	                return;
	            }
	    }
	    function PromiseReject(reason) {
	        return new DexiePromise(INTERNAL, false, reason);
	    }
	    function wrap(fn, errorCatcher) {
	        var psd = PSD;
	        return function () {
	            var wasRootExec = beginMicroTickScope(), outerScope = PSD;
	            try {
	                switchToZone(psd, true);
	                return fn.apply(this, arguments);
	            }
	            catch (e) {
	                errorCatcher && errorCatcher(e);
	            }
	            finally {
	                switchToZone(outerScope, false);
	                if (wasRootExec)
	                    endMicroTickScope();
	            }
	        };
	    }
	    var task = { awaits: 0, echoes: 0, id: 0 };
	    var taskCounter = 0;
	    var zoneStack = [];
	    var zoneEchoes = 0;
	    var totalEchoes = 0;
	    var zone_id_counter = 0;
	    function newScope(fn, props, a1, a2) {
	        var parent = PSD, psd = Object.create(parent);
	        psd.parent = parent;
	        psd.ref = 0;
	        psd.global = false;
	        psd.id = ++zone_id_counter;
	        var globalEnv = globalPSD.env;
	        psd.env = patchGlobalPromise ? {
	            Promise: DexiePromise,
	            PromiseProp: { value: DexiePromise, configurable: true, writable: true },
	            all: DexiePromise.all,
	            race: DexiePromise.race,
	            allSettled: DexiePromise.allSettled,
	            any: DexiePromise.any,
	            resolve: DexiePromise.resolve,
	            reject: DexiePromise.reject,
	            nthen: getPatchedPromiseThen(globalEnv.nthen, psd),
	            gthen: getPatchedPromiseThen(globalEnv.gthen, psd)
	        } : {};
	        if (props)
	            extend(psd, props);
	        ++parent.ref;
	        psd.finalize = function () {
	            --this.parent.ref || this.parent.finalize();
	        };
	        var rv = usePSD(psd, fn, a1, a2);
	        if (psd.ref === 0)
	            psd.finalize();
	        return rv;
	    }
	    function incrementExpectedAwaits() {
	        if (!task.id)
	            task.id = ++taskCounter;
	        ++task.awaits;
	        task.echoes += ZONE_ECHO_LIMIT;
	        return task.id;
	    }
	    function decrementExpectedAwaits() {
	        if (!task.awaits)
	            return false;
	        if (--task.awaits === 0)
	            task.id = 0;
	        task.echoes = task.awaits * ZONE_ECHO_LIMIT;
	        return true;
	    }
	    if (('' + nativePromiseThen).indexOf('[native code]') === -1) {
	        incrementExpectedAwaits = decrementExpectedAwaits = nop;
	    }
	    function onPossibleParallellAsync(possiblePromise) {
	        if (task.echoes && possiblePromise && possiblePromise.constructor === NativePromise) {
	            incrementExpectedAwaits();
	            return possiblePromise.then(function (x) {
	                decrementExpectedAwaits();
	                return x;
	            }, function (e) {
	                decrementExpectedAwaits();
	                return rejection(e);
	            });
	        }
	        return possiblePromise;
	    }
	    function zoneEnterEcho(targetZone) {
	        ++totalEchoes;
	        if (!task.echoes || --task.echoes === 0) {
	            task.echoes = task.id = 0;
	        }
	        zoneStack.push(PSD);
	        switchToZone(targetZone, true);
	    }
	    function zoneLeaveEcho() {
	        var zone = zoneStack[zoneStack.length - 1];
	        zoneStack.pop();
	        switchToZone(zone, false);
	    }
	    function switchToZone(targetZone, bEnteringZone) {
	        var currentZone = PSD;
	        if (bEnteringZone ? task.echoes && (!zoneEchoes++ || targetZone !== PSD) : zoneEchoes && (!--zoneEchoes || targetZone !== PSD)) {
	            enqueueNativeMicroTask(bEnteringZone ? zoneEnterEcho.bind(null, targetZone) : zoneLeaveEcho);
	        }
	        if (targetZone === PSD)
	            return;
	        PSD = targetZone;
	        if (currentZone === globalPSD)
	            globalPSD.env = snapShot();
	        if (patchGlobalPromise) {
	            var GlobalPromise_1 = globalPSD.env.Promise;
	            var targetEnv = targetZone.env;
	            nativePromiseProto.then = targetEnv.nthen;
	            GlobalPromise_1.prototype.then = targetEnv.gthen;
	            if (currentZone.global || targetZone.global) {
	                Object.defineProperty(_global, 'Promise', targetEnv.PromiseProp);
	                GlobalPromise_1.all = targetEnv.all;
	                GlobalPromise_1.race = targetEnv.race;
	                GlobalPromise_1.resolve = targetEnv.resolve;
	                GlobalPromise_1.reject = targetEnv.reject;
	                if (targetEnv.allSettled)
	                    GlobalPromise_1.allSettled = targetEnv.allSettled;
	                if (targetEnv.any)
	                    GlobalPromise_1.any = targetEnv.any;
	            }
	        }
	    }
	    function snapShot() {
	        var GlobalPromise = _global.Promise;
	        return patchGlobalPromise ? {
	            Promise: GlobalPromise,
	            PromiseProp: Object.getOwnPropertyDescriptor(_global, "Promise"),
	            all: GlobalPromise.all,
	            race: GlobalPromise.race,
	            allSettled: GlobalPromise.allSettled,
	            any: GlobalPromise.any,
	            resolve: GlobalPromise.resolve,
	            reject: GlobalPromise.reject,
	            nthen: nativePromiseProto.then,
	            gthen: GlobalPromise.prototype.then
	        } : {};
	    }
	    function usePSD(psd, fn, a1, a2, a3) {
	        var outerScope = PSD;
	        try {
	            switchToZone(psd, true);
	            return fn(a1, a2, a3);
	        }
	        finally {
	            switchToZone(outerScope, false);
	        }
	    }
	    function enqueueNativeMicroTask(job) {
	        nativePromiseThen.call(resolvedNativePromise, job);
	    }
	    function nativeAwaitCompatibleWrap(fn, zone, possibleAwait, cleanup) {
	        return typeof fn !== 'function' ? fn : function () {
	            var outerZone = PSD;
	            if (possibleAwait)
	                incrementExpectedAwaits();
	            switchToZone(zone, true);
	            try {
	                return fn.apply(this, arguments);
	            }
	            finally {
	                switchToZone(outerZone, false);
	                if (cleanup)
	                    enqueueNativeMicroTask(decrementExpectedAwaits);
	            }
	        };
	    }
	    function getPatchedPromiseThen(origThen, zone) {
	        return function (onResolved, onRejected) {
	            return origThen.call(this, nativeAwaitCompatibleWrap(onResolved, zone), nativeAwaitCompatibleWrap(onRejected, zone));
	        };
	    }
	    var UNHANDLEDREJECTION = "unhandledrejection";
	    function globalError(err, promise) {
	        var rv;
	        try {
	            rv = promise.onuncatched(err);
	        }
	        catch (e) { }
	        if (rv !== false)
	            try {
	                var event, eventData = { promise: promise, reason: err };
	                if (_global.document && document.createEvent) {
	                    event = document.createEvent('Event');
	                    event.initEvent(UNHANDLEDREJECTION, true, true);
	                    extend(event, eventData);
	                }
	                else if (_global.CustomEvent) {
	                    event = new CustomEvent(UNHANDLEDREJECTION, { detail: eventData });
	                    extend(event, eventData);
	                }
	                if (event && _global.dispatchEvent) {
	                    dispatchEvent(event);
	                    if (!_global.PromiseRejectionEvent && _global.onunhandledrejection)
	                        try {
	                            _global.onunhandledrejection(event);
	                        }
	                        catch (_) { }
	                }
	                if (debug && event && !event.defaultPrevented) {
	                    console.warn("Unhandled rejection: " + (err.stack || err));
	                }
	            }
	            catch (e) { }
	    }
	    var rejection = DexiePromise.reject;

	    function tempTransaction(db, mode, storeNames, fn) {
	        if (!db.idbdb || (!db._state.openComplete && (!PSD.letThrough && !db._vip))) {
	            if (db._state.openComplete) {
	                return rejection(new exceptions.DatabaseClosed(db._state.dbOpenError));
	            }
	            if (!db._state.isBeingOpened) {
	                if (!db._options.autoOpen)
	                    return rejection(new exceptions.DatabaseClosed());
	                db.open().catch(nop);
	            }
	            return db._state.dbReadyPromise.then(function () { return tempTransaction(db, mode, storeNames, fn); });
	        }
	        else {
	            var trans = db._createTransaction(mode, storeNames, db._dbSchema);
	            try {
	                trans.create();
	                db._state.PR1398_maxLoop = 3;
	            }
	            catch (ex) {
	                if (ex.name === errnames.InvalidState && db.isOpen() && --db._state.PR1398_maxLoop > 0) {
	                    console.warn('Dexie: Need to reopen db');
	                    db._close();
	                    return db.open().then(function () { return tempTransaction(db, mode, storeNames, fn); });
	                }
	                return rejection(ex);
	            }
	            return trans._promise(mode, function (resolve, reject) {
	                return newScope(function () {
	                    PSD.trans = trans;
	                    return fn(resolve, reject, trans);
	                });
	            }).then(function (result) {
	                return trans._completion.then(function () { return result; });
	            });
	        }
	    }

	    var DEXIE_VERSION = '3.2.4';
	    var maxString = String.fromCharCode(65535);
	    var minKey = -Infinity;
	    var INVALID_KEY_ARGUMENT = "Invalid key provided. Keys must be of type string, number, Date or Array<string | number | Date>.";
	    var STRING_EXPECTED = "String expected.";
	    var connections = [];
	    var isIEOrEdge = typeof navigator !== 'undefined' && /(MSIE|Trident|Edge)/.test(navigator.userAgent);
	    var hasIEDeleteObjectStoreBug = isIEOrEdge;
	    var hangsOnDeleteLargeKeyRange = isIEOrEdge;
	    var dexieStackFrameFilter = function (frame) { return !/(dexie\.js|dexie\.min\.js)/.test(frame); };
	    var DBNAMES_DB = '__dbnames';
	    var READONLY = 'readonly';
	    var READWRITE = 'readwrite';

	    function combine(filter1, filter2) {
	        return filter1 ?
	            filter2 ?
	                function () { return filter1.apply(this, arguments) && filter2.apply(this, arguments); } :
	                filter1 :
	            filter2;
	    }

	    var AnyRange = {
	        type: 3 ,
	        lower: -Infinity,
	        lowerOpen: false,
	        upper: [[]],
	        upperOpen: false
	    };

	    function workaroundForUndefinedPrimKey(keyPath) {
	        return typeof keyPath === "string" && !/\./.test(keyPath)
	            ? function (obj) {
	                if (obj[keyPath] === undefined && (keyPath in obj)) {
	                    obj = deepClone(obj);
	                    delete obj[keyPath];
	                }
	                return obj;
	            }
	            : function (obj) { return obj; };
	    }

	    var Table =  (function () {
	        function Table() {
	        }
	        Table.prototype._trans = function (mode, fn, writeLocked) {
	            var trans = this._tx || PSD.trans;
	            var tableName = this.name;
	            function checkTableInTransaction(resolve, reject, trans) {
	                if (!trans.schema[tableName])
	                    throw new exceptions.NotFound("Table " + tableName + " not part of transaction");
	                return fn(trans.idbtrans, trans);
	            }
	            var wasRootExec = beginMicroTickScope();
	            try {
	                return trans && trans.db === this.db ?
	                    trans === PSD.trans ?
	                        trans._promise(mode, checkTableInTransaction, writeLocked) :
	                        newScope(function () { return trans._promise(mode, checkTableInTransaction, writeLocked); }, { trans: trans, transless: PSD.transless || PSD }) :
	                    tempTransaction(this.db, mode, [this.name], checkTableInTransaction);
	            }
	            finally {
	                if (wasRootExec)
	                    endMicroTickScope();
	            }
	        };
	        Table.prototype.get = function (keyOrCrit, cb) {
	            var _this = this;
	            if (keyOrCrit && keyOrCrit.constructor === Object)
	                return this.where(keyOrCrit).first(cb);
	            return this._trans('readonly', function (trans) {
	                return _this.core.get({ trans: trans, key: keyOrCrit })
	                    .then(function (res) { return _this.hook.reading.fire(res); });
	            }).then(cb);
	        };
	        Table.prototype.where = function (indexOrCrit) {
	            if (typeof indexOrCrit === 'string')
	                return new this.db.WhereClause(this, indexOrCrit);
	            if (isArray(indexOrCrit))
	                return new this.db.WhereClause(this, "[" + indexOrCrit.join('+') + "]");
	            var keyPaths = keys(indexOrCrit);
	            if (keyPaths.length === 1)
	                return this
	                    .where(keyPaths[0])
	                    .equals(indexOrCrit[keyPaths[0]]);
	            var compoundIndex = this.schema.indexes.concat(this.schema.primKey).filter(function (ix) {
	                return ix.compound &&
	                    keyPaths.every(function (keyPath) { return ix.keyPath.indexOf(keyPath) >= 0; }) &&
	                    ix.keyPath.every(function (keyPath) { return keyPaths.indexOf(keyPath) >= 0; });
	            })[0];
	            if (compoundIndex && this.db._maxKey !== maxString)
	                return this
	                    .where(compoundIndex.name)
	                    .equals(compoundIndex.keyPath.map(function (kp) { return indexOrCrit[kp]; }));
	            if (!compoundIndex && debug)
	                console.warn("The query " + JSON.stringify(indexOrCrit) + " on " + this.name + " would benefit of a " +
	                    ("compound index [" + keyPaths.join('+') + "]"));
	            var idxByName = this.schema.idxByName;
	            var idb = this.db._deps.indexedDB;
	            function equals(a, b) {
	                try {
	                    return idb.cmp(a, b) === 0;
	                }
	                catch (e) {
	                    return false;
	                }
	            }
	            var _a = keyPaths.reduce(function (_a, keyPath) {
	                var prevIndex = _a[0], prevFilterFn = _a[1];
	                var index = idxByName[keyPath];
	                var value = indexOrCrit[keyPath];
	                return [
	                    prevIndex || index,
	                    prevIndex || !index ?
	                        combine(prevFilterFn, index && index.multi ?
	                            function (x) {
	                                var prop = getByKeyPath(x, keyPath);
	                                return isArray(prop) && prop.some(function (item) { return equals(value, item); });
	                            } : function (x) { return equals(value, getByKeyPath(x, keyPath)); })
	                        : prevFilterFn
	                ];
	            }, [null, null]), idx = _a[0], filterFunction = _a[1];
	            return idx ?
	                this.where(idx.name).equals(indexOrCrit[idx.keyPath])
	                    .filter(filterFunction) :
	                compoundIndex ?
	                    this.filter(filterFunction) :
	                    this.where(keyPaths).equals('');
	        };
	        Table.prototype.filter = function (filterFunction) {
	            return this.toCollection().and(filterFunction);
	        };
	        Table.prototype.count = function (thenShortcut) {
	            return this.toCollection().count(thenShortcut);
	        };
	        Table.prototype.offset = function (offset) {
	            return this.toCollection().offset(offset);
	        };
	        Table.prototype.limit = function (numRows) {
	            return this.toCollection().limit(numRows);
	        };
	        Table.prototype.each = function (callback) {
	            return this.toCollection().each(callback);
	        };
	        Table.prototype.toArray = function (thenShortcut) {
	            return this.toCollection().toArray(thenShortcut);
	        };
	        Table.prototype.toCollection = function () {
	            return new this.db.Collection(new this.db.WhereClause(this));
	        };
	        Table.prototype.orderBy = function (index) {
	            return new this.db.Collection(new this.db.WhereClause(this, isArray(index) ?
	                "[" + index.join('+') + "]" :
	                index));
	        };
	        Table.prototype.reverse = function () {
	            return this.toCollection().reverse();
	        };
	        Table.prototype.mapToClass = function (constructor) {
	            this.schema.mappedClass = constructor;
	            var readHook = function (obj) {
	                if (!obj)
	                    return obj;
	                var res = Object.create(constructor.prototype);
	                for (var m in obj)
	                    if (hasOwn(obj, m))
	                        try {
	                            res[m] = obj[m];
	                        }
	                        catch (_) { }
	                return res;
	            };
	            if (this.schema.readHook) {
	                this.hook.reading.unsubscribe(this.schema.readHook);
	            }
	            this.schema.readHook = readHook;
	            this.hook("reading", readHook);
	            return constructor;
	        };
	        Table.prototype.defineClass = function () {
	            function Class(content) {
	                extend(this, content);
	            }
	            return this.mapToClass(Class);
	        };
	        Table.prototype.add = function (obj, key) {
	            var _this = this;
	            var _a = this.schema.primKey, auto = _a.auto, keyPath = _a.keyPath;
	            var objToAdd = obj;
	            if (keyPath && auto) {
	                objToAdd = workaroundForUndefinedPrimKey(keyPath)(obj);
	            }
	            return this._trans('readwrite', function (trans) {
	                return _this.core.mutate({ trans: trans, type: 'add', keys: key != null ? [key] : null, values: [objToAdd] });
	            }).then(function (res) { return res.numFailures ? DexiePromise.reject(res.failures[0]) : res.lastResult; })
	                .then(function (lastResult) {
	                if (keyPath) {
	                    try {
	                        setByKeyPath(obj, keyPath, lastResult);
	                    }
	                    catch (_) { }
	                }
	                return lastResult;
	            });
	        };
	        Table.prototype.update = function (keyOrObject, modifications) {
	            if (typeof keyOrObject === 'object' && !isArray(keyOrObject)) {
	                var key = getByKeyPath(keyOrObject, this.schema.primKey.keyPath);
	                if (key === undefined)
	                    return rejection(new exceptions.InvalidArgument("Given object does not contain its primary key"));
	                try {
	                    if (typeof modifications !== "function") {
	                        keys(modifications).forEach(function (keyPath) {
	                            setByKeyPath(keyOrObject, keyPath, modifications[keyPath]);
	                        });
	                    }
	                    else {
	                        modifications(keyOrObject, { value: keyOrObject, primKey: key });
	                    }
	                }
	                catch (_a) {
	                }
	                return this.where(":id").equals(key).modify(modifications);
	            }
	            else {
	                return this.where(":id").equals(keyOrObject).modify(modifications);
	            }
	        };
	        Table.prototype.put = function (obj, key) {
	            var _this = this;
	            var _a = this.schema.primKey, auto = _a.auto, keyPath = _a.keyPath;
	            var objToAdd = obj;
	            if (keyPath && auto) {
	                objToAdd = workaroundForUndefinedPrimKey(keyPath)(obj);
	            }
	            return this._trans('readwrite', function (trans) { return _this.core.mutate({ trans: trans, type: 'put', values: [objToAdd], keys: key != null ? [key] : null }); })
	                .then(function (res) { return res.numFailures ? DexiePromise.reject(res.failures[0]) : res.lastResult; })
	                .then(function (lastResult) {
	                if (keyPath) {
	                    try {
	                        setByKeyPath(obj, keyPath, lastResult);
	                    }
	                    catch (_) { }
	                }
	                return lastResult;
	            });
	        };
	        Table.prototype.delete = function (key) {
	            var _this = this;
	            return this._trans('readwrite', function (trans) { return _this.core.mutate({ trans: trans, type: 'delete', keys: [key] }); })
	                .then(function (res) { return res.numFailures ? DexiePromise.reject(res.failures[0]) : undefined; });
	        };
	        Table.prototype.clear = function () {
	            var _this = this;
	            return this._trans('readwrite', function (trans) { return _this.core.mutate({ trans: trans, type: 'deleteRange', range: AnyRange }); })
	                .then(function (res) { return res.numFailures ? DexiePromise.reject(res.failures[0]) : undefined; });
	        };
	        Table.prototype.bulkGet = function (keys) {
	            var _this = this;
	            return this._trans('readonly', function (trans) {
	                return _this.core.getMany({
	                    keys: keys,
	                    trans: trans
	                }).then(function (result) { return result.map(function (res) { return _this.hook.reading.fire(res); }); });
	            });
	        };
	        Table.prototype.bulkAdd = function (objects, keysOrOptions, options) {
	            var _this = this;
	            var keys = Array.isArray(keysOrOptions) ? keysOrOptions : undefined;
	            options = options || (keys ? undefined : keysOrOptions);
	            var wantResults = options ? options.allKeys : undefined;
	            return this._trans('readwrite', function (trans) {
	                var _a = _this.schema.primKey, auto = _a.auto, keyPath = _a.keyPath;
	                if (keyPath && keys)
	                    throw new exceptions.InvalidArgument("bulkAdd(): keys argument invalid on tables with inbound keys");
	                if (keys && keys.length !== objects.length)
	                    throw new exceptions.InvalidArgument("Arguments objects and keys must have the same length");
	                var numObjects = objects.length;
	                var objectsToAdd = keyPath && auto ?
	                    objects.map(workaroundForUndefinedPrimKey(keyPath)) :
	                    objects;
	                return _this.core.mutate({ trans: trans, type: 'add', keys: keys, values: objectsToAdd, wantResults: wantResults })
	                    .then(function (_a) {
	                    var numFailures = _a.numFailures, results = _a.results, lastResult = _a.lastResult, failures = _a.failures;
	                    var result = wantResults ? results : lastResult;
	                    if (numFailures === 0)
	                        return result;
	                    throw new BulkError(_this.name + ".bulkAdd(): " + numFailures + " of " + numObjects + " operations failed", failures);
	                });
	            });
	        };
	        Table.prototype.bulkPut = function (objects, keysOrOptions, options) {
	            var _this = this;
	            var keys = Array.isArray(keysOrOptions) ? keysOrOptions : undefined;
	            options = options || (keys ? undefined : keysOrOptions);
	            var wantResults = options ? options.allKeys : undefined;
	            return this._trans('readwrite', function (trans) {
	                var _a = _this.schema.primKey, auto = _a.auto, keyPath = _a.keyPath;
	                if (keyPath && keys)
	                    throw new exceptions.InvalidArgument("bulkPut(): keys argument invalid on tables with inbound keys");
	                if (keys && keys.length !== objects.length)
	                    throw new exceptions.InvalidArgument("Arguments objects and keys must have the same length");
	                var numObjects = objects.length;
	                var objectsToPut = keyPath && auto ?
	                    objects.map(workaroundForUndefinedPrimKey(keyPath)) :
	                    objects;
	                return _this.core.mutate({ trans: trans, type: 'put', keys: keys, values: objectsToPut, wantResults: wantResults })
	                    .then(function (_a) {
	                    var numFailures = _a.numFailures, results = _a.results, lastResult = _a.lastResult, failures = _a.failures;
	                    var result = wantResults ? results : lastResult;
	                    if (numFailures === 0)
	                        return result;
	                    throw new BulkError(_this.name + ".bulkPut(): " + numFailures + " of " + numObjects + " operations failed", failures);
	                });
	            });
	        };
	        Table.prototype.bulkDelete = function (keys) {
	            var _this = this;
	            var numKeys = keys.length;
	            return this._trans('readwrite', function (trans) {
	                return _this.core.mutate({ trans: trans, type: 'delete', keys: keys });
	            }).then(function (_a) {
	                var numFailures = _a.numFailures, lastResult = _a.lastResult, failures = _a.failures;
	                if (numFailures === 0)
	                    return lastResult;
	                throw new BulkError(_this.name + ".bulkDelete(): " + numFailures + " of " + numKeys + " operations failed", failures);
	            });
	        };
	        return Table;
	    }());

	    function Events(ctx) {
	        var evs = {};
	        var rv = function (eventName, subscriber) {
	            if (subscriber) {
	                var i = arguments.length, args = new Array(i - 1);
	                while (--i)
	                    args[i - 1] = arguments[i];
	                evs[eventName].subscribe.apply(null, args);
	                return ctx;
	            }
	            else if (typeof (eventName) === 'string') {
	                return evs[eventName];
	            }
	        };
	        rv.addEventType = add;
	        for (var i = 1, l = arguments.length; i < l; ++i) {
	            add(arguments[i]);
	        }
	        return rv;
	        function add(eventName, chainFunction, defaultFunction) {
	            if (typeof eventName === 'object')
	                return addConfiguredEvents(eventName);
	            if (!chainFunction)
	                chainFunction = reverseStoppableEventChain;
	            if (!defaultFunction)
	                defaultFunction = nop;
	            var context = {
	                subscribers: [],
	                fire: defaultFunction,
	                subscribe: function (cb) {
	                    if (context.subscribers.indexOf(cb) === -1) {
	                        context.subscribers.push(cb);
	                        context.fire = chainFunction(context.fire, cb);
	                    }
	                },
	                unsubscribe: function (cb) {
	                    context.subscribers = context.subscribers.filter(function (fn) { return fn !== cb; });
	                    context.fire = context.subscribers.reduce(chainFunction, defaultFunction);
	                }
	            };
	            evs[eventName] = rv[eventName] = context;
	            return context;
	        }
	        function addConfiguredEvents(cfg) {
	            keys(cfg).forEach(function (eventName) {
	                var args = cfg[eventName];
	                if (isArray(args)) {
	                    add(eventName, cfg[eventName][0], cfg[eventName][1]);
	                }
	                else if (args === 'asap') {
	                    var context = add(eventName, mirror, function fire() {
	                        var i = arguments.length, args = new Array(i);
	                        while (i--)
	                            args[i] = arguments[i];
	                        context.subscribers.forEach(function (fn) {
	                            asap$1(function fireEvent() {
	                                fn.apply(null, args);
	                            });
	                        });
	                    });
	                }
	                else
	                    throw new exceptions.InvalidArgument("Invalid event config");
	            });
	        }
	    }

	    function makeClassConstructor(prototype, constructor) {
	        derive(constructor).from({ prototype: prototype });
	        return constructor;
	    }

	    function createTableConstructor(db) {
	        return makeClassConstructor(Table.prototype, function Table(name, tableSchema, trans) {
	            this.db = db;
	            this._tx = trans;
	            this.name = name;
	            this.schema = tableSchema;
	            this.hook = db._allTables[name] ? db._allTables[name].hook : Events(null, {
	                "creating": [hookCreatingChain, nop],
	                "reading": [pureFunctionChain, mirror],
	                "updating": [hookUpdatingChain, nop],
	                "deleting": [hookDeletingChain, nop]
	            });
	        });
	    }

	    function isPlainKeyRange(ctx, ignoreLimitFilter) {
	        return !(ctx.filter || ctx.algorithm || ctx.or) &&
	            (ignoreLimitFilter ? ctx.justLimit : !ctx.replayFilter);
	    }
	    function addFilter(ctx, fn) {
	        ctx.filter = combine(ctx.filter, fn);
	    }
	    function addReplayFilter(ctx, factory, isLimitFilter) {
	        var curr = ctx.replayFilter;
	        ctx.replayFilter = curr ? function () { return combine(curr(), factory()); } : factory;
	        ctx.justLimit = isLimitFilter && !curr;
	    }
	    function addMatchFilter(ctx, fn) {
	        ctx.isMatch = combine(ctx.isMatch, fn);
	    }
	    function getIndexOrStore(ctx, coreSchema) {
	        if (ctx.isPrimKey)
	            return coreSchema.primaryKey;
	        var index = coreSchema.getIndexByKeyPath(ctx.index);
	        if (!index)
	            throw new exceptions.Schema("KeyPath " + ctx.index + " on object store " + coreSchema.name + " is not indexed");
	        return index;
	    }
	    function openCursor(ctx, coreTable, trans) {
	        var index = getIndexOrStore(ctx, coreTable.schema);
	        return coreTable.openCursor({
	            trans: trans,
	            values: !ctx.keysOnly,
	            reverse: ctx.dir === 'prev',
	            unique: !!ctx.unique,
	            query: {
	                index: index,
	                range: ctx.range
	            }
	        });
	    }
	    function iter(ctx, fn, coreTrans, coreTable) {
	        var filter = ctx.replayFilter ? combine(ctx.filter, ctx.replayFilter()) : ctx.filter;
	        if (!ctx.or) {
	            return iterate(openCursor(ctx, coreTable, coreTrans), combine(ctx.algorithm, filter), fn, !ctx.keysOnly && ctx.valueMapper);
	        }
	        else {
	            var set_1 = {};
	            var union = function (item, cursor, advance) {
	                if (!filter || filter(cursor, advance, function (result) { return cursor.stop(result); }, function (err) { return cursor.fail(err); })) {
	                    var primaryKey = cursor.primaryKey;
	                    var key = '' + primaryKey;
	                    if (key === '[object ArrayBuffer]')
	                        key = '' + new Uint8Array(primaryKey);
	                    if (!hasOwn(set_1, key)) {
	                        set_1[key] = true;
	                        fn(item, cursor, advance);
	                    }
	                }
	            };
	            return Promise.all([
	                ctx.or._iterate(union, coreTrans),
	                iterate(openCursor(ctx, coreTable, coreTrans), ctx.algorithm, union, !ctx.keysOnly && ctx.valueMapper)
	            ]);
	        }
	    }
	    function iterate(cursorPromise, filter, fn, valueMapper) {
	        var mappedFn = valueMapper ? function (x, c, a) { return fn(valueMapper(x), c, a); } : fn;
	        var wrappedFn = wrap(mappedFn);
	        return cursorPromise.then(function (cursor) {
	            if (cursor) {
	                return cursor.start(function () {
	                    var c = function () { return cursor.continue(); };
	                    if (!filter || filter(cursor, function (advancer) { return c = advancer; }, function (val) { cursor.stop(val); c = nop; }, function (e) { cursor.fail(e); c = nop; }))
	                        wrappedFn(cursor.value, cursor, function (advancer) { return c = advancer; });
	                    c();
	                });
	            }
	        });
	    }

	    function cmp(a, b) {
	        try {
	            var ta = type(a);
	            var tb = type(b);
	            if (ta !== tb) {
	                if (ta === 'Array')
	                    return 1;
	                if (tb === 'Array')
	                    return -1;
	                if (ta === 'binary')
	                    return 1;
	                if (tb === 'binary')
	                    return -1;
	                if (ta === 'string')
	                    return 1;
	                if (tb === 'string')
	                    return -1;
	                if (ta === 'Date')
	                    return 1;
	                if (tb !== 'Date')
	                    return NaN;
	                return -1;
	            }
	            switch (ta) {
	                case 'number':
	                case 'Date':
	                case 'string':
	                    return a > b ? 1 : a < b ? -1 : 0;
	                case 'binary': {
	                    return compareUint8Arrays(getUint8Array(a), getUint8Array(b));
	                }
	                case 'Array':
	                    return compareArrays(a, b);
	            }
	        }
	        catch (_a) { }
	        return NaN;
	    }
	    function compareArrays(a, b) {
	        var al = a.length;
	        var bl = b.length;
	        var l = al < bl ? al : bl;
	        for (var i = 0; i < l; ++i) {
	            var res = cmp(a[i], b[i]);
	            if (res !== 0)
	                return res;
	        }
	        return al === bl ? 0 : al < bl ? -1 : 1;
	    }
	    function compareUint8Arrays(a, b) {
	        var al = a.length;
	        var bl = b.length;
	        var l = al < bl ? al : bl;
	        for (var i = 0; i < l; ++i) {
	            if (a[i] !== b[i])
	                return a[i] < b[i] ? -1 : 1;
	        }
	        return al === bl ? 0 : al < bl ? -1 : 1;
	    }
	    function type(x) {
	        var t = typeof x;
	        if (t !== 'object')
	            return t;
	        if (ArrayBuffer.isView(x))
	            return 'binary';
	        var tsTag = toStringTag(x);
	        return tsTag === 'ArrayBuffer' ? 'binary' : tsTag;
	    }
	    function getUint8Array(a) {
	        if (a instanceof Uint8Array)
	            return a;
	        if (ArrayBuffer.isView(a))
	            return new Uint8Array(a.buffer, a.byteOffset, a.byteLength);
	        return new Uint8Array(a);
	    }

	    var Collection =  (function () {
	        function Collection() {
	        }
	        Collection.prototype._read = function (fn, cb) {
	            var ctx = this._ctx;
	            return ctx.error ?
	                ctx.table._trans(null, rejection.bind(null, ctx.error)) :
	                ctx.table._trans('readonly', fn).then(cb);
	        };
	        Collection.prototype._write = function (fn) {
	            var ctx = this._ctx;
	            return ctx.error ?
	                ctx.table._trans(null, rejection.bind(null, ctx.error)) :
	                ctx.table._trans('readwrite', fn, "locked");
	        };
	        Collection.prototype._addAlgorithm = function (fn) {
	            var ctx = this._ctx;
	            ctx.algorithm = combine(ctx.algorithm, fn);
	        };
	        Collection.prototype._iterate = function (fn, coreTrans) {
	            return iter(this._ctx, fn, coreTrans, this._ctx.table.core);
	        };
	        Collection.prototype.clone = function (props) {
	            var rv = Object.create(this.constructor.prototype), ctx = Object.create(this._ctx);
	            if (props)
	                extend(ctx, props);
	            rv._ctx = ctx;
	            return rv;
	        };
	        Collection.prototype.raw = function () {
	            this._ctx.valueMapper = null;
	            return this;
	        };
	        Collection.prototype.each = function (fn) {
	            var ctx = this._ctx;
	            return this._read(function (trans) { return iter(ctx, fn, trans, ctx.table.core); });
	        };
	        Collection.prototype.count = function (cb) {
	            var _this = this;
	            return this._read(function (trans) {
	                var ctx = _this._ctx;
	                var coreTable = ctx.table.core;
	                if (isPlainKeyRange(ctx, true)) {
	                    return coreTable.count({
	                        trans: trans,
	                        query: {
	                            index: getIndexOrStore(ctx, coreTable.schema),
	                            range: ctx.range
	                        }
	                    }).then(function (count) { return Math.min(count, ctx.limit); });
	                }
	                else {
	                    var count = 0;
	                    return iter(ctx, function () { ++count; return false; }, trans, coreTable)
	                        .then(function () { return count; });
	                }
	            }).then(cb);
	        };
	        Collection.prototype.sortBy = function (keyPath, cb) {
	            var parts = keyPath.split('.').reverse(), lastPart = parts[0], lastIndex = parts.length - 1;
	            function getval(obj, i) {
	                if (i)
	                    return getval(obj[parts[i]], i - 1);
	                return obj[lastPart];
	            }
	            var order = this._ctx.dir === "next" ? 1 : -1;
	            function sorter(a, b) {
	                var aVal = getval(a, lastIndex), bVal = getval(b, lastIndex);
	                return aVal < bVal ? -order : aVal > bVal ? order : 0;
	            }
	            return this.toArray(function (a) {
	                return a.sort(sorter);
	            }).then(cb);
	        };
	        Collection.prototype.toArray = function (cb) {
	            var _this = this;
	            return this._read(function (trans) {
	                var ctx = _this._ctx;
	                if (ctx.dir === 'next' && isPlainKeyRange(ctx, true) && ctx.limit > 0) {
	                    var valueMapper_1 = ctx.valueMapper;
	                    var index = getIndexOrStore(ctx, ctx.table.core.schema);
	                    return ctx.table.core.query({
	                        trans: trans,
	                        limit: ctx.limit,
	                        values: true,
	                        query: {
	                            index: index,
	                            range: ctx.range
	                        }
	                    }).then(function (_a) {
	                        var result = _a.result;
	                        return valueMapper_1 ? result.map(valueMapper_1) : result;
	                    });
	                }
	                else {
	                    var a_1 = [];
	                    return iter(ctx, function (item) { return a_1.push(item); }, trans, ctx.table.core).then(function () { return a_1; });
	                }
	            }, cb);
	        };
	        Collection.prototype.offset = function (offset) {
	            var ctx = this._ctx;
	            if (offset <= 0)
	                return this;
	            ctx.offset += offset;
	            if (isPlainKeyRange(ctx)) {
	                addReplayFilter(ctx, function () {
	                    var offsetLeft = offset;
	                    return function (cursor, advance) {
	                        if (offsetLeft === 0)
	                            return true;
	                        if (offsetLeft === 1) {
	                            --offsetLeft;
	                            return false;
	                        }
	                        advance(function () {
	                            cursor.advance(offsetLeft);
	                            offsetLeft = 0;
	                        });
	                        return false;
	                    };
	                });
	            }
	            else {
	                addReplayFilter(ctx, function () {
	                    var offsetLeft = offset;
	                    return function () { return (--offsetLeft < 0); };
	                });
	            }
	            return this;
	        };
	        Collection.prototype.limit = function (numRows) {
	            this._ctx.limit = Math.min(this._ctx.limit, numRows);
	            addReplayFilter(this._ctx, function () {
	                var rowsLeft = numRows;
	                return function (cursor, advance, resolve) {
	                    if (--rowsLeft <= 0)
	                        advance(resolve);
	                    return rowsLeft >= 0;
	                };
	            }, true);
	            return this;
	        };
	        Collection.prototype.until = function (filterFunction, bIncludeStopEntry) {
	            addFilter(this._ctx, function (cursor, advance, resolve) {
	                if (filterFunction(cursor.value)) {
	                    advance(resolve);
	                    return bIncludeStopEntry;
	                }
	                else {
	                    return true;
	                }
	            });
	            return this;
	        };
	        Collection.prototype.first = function (cb) {
	            return this.limit(1).toArray(function (a) { return a[0]; }).then(cb);
	        };
	        Collection.prototype.last = function (cb) {
	            return this.reverse().first(cb);
	        };
	        Collection.prototype.filter = function (filterFunction) {
	            addFilter(this._ctx, function (cursor) {
	                return filterFunction(cursor.value);
	            });
	            addMatchFilter(this._ctx, filterFunction);
	            return this;
	        };
	        Collection.prototype.and = function (filter) {
	            return this.filter(filter);
	        };
	        Collection.prototype.or = function (indexName) {
	            return new this.db.WhereClause(this._ctx.table, indexName, this);
	        };
	        Collection.prototype.reverse = function () {
	            this._ctx.dir = (this._ctx.dir === "prev" ? "next" : "prev");
	            if (this._ondirectionchange)
	                this._ondirectionchange(this._ctx.dir);
	            return this;
	        };
	        Collection.prototype.desc = function () {
	            return this.reverse();
	        };
	        Collection.prototype.eachKey = function (cb) {
	            var ctx = this._ctx;
	            ctx.keysOnly = !ctx.isMatch;
	            return this.each(function (val, cursor) { cb(cursor.key, cursor); });
	        };
	        Collection.prototype.eachUniqueKey = function (cb) {
	            this._ctx.unique = "unique";
	            return this.eachKey(cb);
	        };
	        Collection.prototype.eachPrimaryKey = function (cb) {
	            var ctx = this._ctx;
	            ctx.keysOnly = !ctx.isMatch;
	            return this.each(function (val, cursor) { cb(cursor.primaryKey, cursor); });
	        };
	        Collection.prototype.keys = function (cb) {
	            var ctx = this._ctx;
	            ctx.keysOnly = !ctx.isMatch;
	            var a = [];
	            return this.each(function (item, cursor) {
	                a.push(cursor.key);
	            }).then(function () {
	                return a;
	            }).then(cb);
	        };
	        Collection.prototype.primaryKeys = function (cb) {
	            var ctx = this._ctx;
	            if (ctx.dir === 'next' && isPlainKeyRange(ctx, true) && ctx.limit > 0) {
	                return this._read(function (trans) {
	                    var index = getIndexOrStore(ctx, ctx.table.core.schema);
	                    return ctx.table.core.query({
	                        trans: trans,
	                        values: false,
	                        limit: ctx.limit,
	                        query: {
	                            index: index,
	                            range: ctx.range
	                        }
	                    });
	                }).then(function (_a) {
	                    var result = _a.result;
	                    return result;
	                }).then(cb);
	            }
	            ctx.keysOnly = !ctx.isMatch;
	            var a = [];
	            return this.each(function (item, cursor) {
	                a.push(cursor.primaryKey);
	            }).then(function () {
	                return a;
	            }).then(cb);
	        };
	        Collection.prototype.uniqueKeys = function (cb) {
	            this._ctx.unique = "unique";
	            return this.keys(cb);
	        };
	        Collection.prototype.firstKey = function (cb) {
	            return this.limit(1).keys(function (a) { return a[0]; }).then(cb);
	        };
	        Collection.prototype.lastKey = function (cb) {
	            return this.reverse().firstKey(cb);
	        };
	        Collection.prototype.distinct = function () {
	            var ctx = this._ctx, idx = ctx.index && ctx.table.schema.idxByName[ctx.index];
	            if (!idx || !idx.multi)
	                return this;
	            var set = {};
	            addFilter(this._ctx, function (cursor) {
	                var strKey = cursor.primaryKey.toString();
	                var found = hasOwn(set, strKey);
	                set[strKey] = true;
	                return !found;
	            });
	            return this;
	        };
	        Collection.prototype.modify = function (changes) {
	            var _this = this;
	            var ctx = this._ctx;
	            return this._write(function (trans) {
	                var modifyer;
	                if (typeof changes === 'function') {
	                    modifyer = changes;
	                }
	                else {
	                    var keyPaths = keys(changes);
	                    var numKeys = keyPaths.length;
	                    modifyer = function (item) {
	                        var anythingModified = false;
	                        for (var i = 0; i < numKeys; ++i) {
	                            var keyPath = keyPaths[i], val = changes[keyPath];
	                            if (getByKeyPath(item, keyPath) !== val) {
	                                setByKeyPath(item, keyPath, val);
	                                anythingModified = true;
	                            }
	                        }
	                        return anythingModified;
	                    };
	                }
	                var coreTable = ctx.table.core;
	                var _a = coreTable.schema.primaryKey, outbound = _a.outbound, extractKey = _a.extractKey;
	                var limit = _this.db._options.modifyChunkSize || 200;
	                var totalFailures = [];
	                var successCount = 0;
	                var failedKeys = [];
	                var applyMutateResult = function (expectedCount, res) {
	                    var failures = res.failures, numFailures = res.numFailures;
	                    successCount += expectedCount - numFailures;
	                    for (var _i = 0, _a = keys(failures); _i < _a.length; _i++) {
	                        var pos = _a[_i];
	                        totalFailures.push(failures[pos]);
	                    }
	                };
	                return _this.clone().primaryKeys().then(function (keys) {
	                    var nextChunk = function (offset) {
	                        var count = Math.min(limit, keys.length - offset);
	                        return coreTable.getMany({
	                            trans: trans,
	                            keys: keys.slice(offset, offset + count),
	                            cache: "immutable"
	                        }).then(function (values) {
	                            var addValues = [];
	                            var putValues = [];
	                            var putKeys = outbound ? [] : null;
	                            var deleteKeys = [];
	                            for (var i = 0; i < count; ++i) {
	                                var origValue = values[i];
	                                var ctx_1 = {
	                                    value: deepClone(origValue),
	                                    primKey: keys[offset + i]
	                                };
	                                if (modifyer.call(ctx_1, ctx_1.value, ctx_1) !== false) {
	                                    if (ctx_1.value == null) {
	                                        deleteKeys.push(keys[offset + i]);
	                                    }
	                                    else if (!outbound && cmp(extractKey(origValue), extractKey(ctx_1.value)) !== 0) {
	                                        deleteKeys.push(keys[offset + i]);
	                                        addValues.push(ctx_1.value);
	                                    }
	                                    else {
	                                        putValues.push(ctx_1.value);
	                                        if (outbound)
	                                            putKeys.push(keys[offset + i]);
	                                    }
	                                }
	                            }
	                            var criteria = isPlainKeyRange(ctx) &&
	                                ctx.limit === Infinity &&
	                                (typeof changes !== 'function' || changes === deleteCallback) && {
	                                index: ctx.index,
	                                range: ctx.range
	                            };
	                            return Promise.resolve(addValues.length > 0 &&
	                                coreTable.mutate({ trans: trans, type: 'add', values: addValues })
	                                    .then(function (res) {
	                                    for (var pos in res.failures) {
	                                        deleteKeys.splice(parseInt(pos), 1);
	                                    }
	                                    applyMutateResult(addValues.length, res);
	                                })).then(function () { return (putValues.length > 0 || (criteria && typeof changes === 'object')) &&
	                                coreTable.mutate({
	                                    trans: trans,
	                                    type: 'put',
	                                    keys: putKeys,
	                                    values: putValues,
	                                    criteria: criteria,
	                                    changeSpec: typeof changes !== 'function'
	                                        && changes
	                                }).then(function (res) { return applyMutateResult(putValues.length, res); }); }).then(function () { return (deleteKeys.length > 0 || (criteria && changes === deleteCallback)) &&
	                                coreTable.mutate({
	                                    trans: trans,
	                                    type: 'delete',
	                                    keys: deleteKeys,
	                                    criteria: criteria
	                                }).then(function (res) { return applyMutateResult(deleteKeys.length, res); }); }).then(function () {
	                                return keys.length > offset + count && nextChunk(offset + limit);
	                            });
	                        });
	                    };
	                    return nextChunk(0).then(function () {
	                        if (totalFailures.length > 0)
	                            throw new ModifyError("Error modifying one or more objects", totalFailures, successCount, failedKeys);
	                        return keys.length;
	                    });
	                });
	            });
	        };
	        Collection.prototype.delete = function () {
	            var ctx = this._ctx, range = ctx.range;
	            if (isPlainKeyRange(ctx) &&
	                ((ctx.isPrimKey && !hangsOnDeleteLargeKeyRange) || range.type === 3 ))
	             {
	                return this._write(function (trans) {
	                    var primaryKey = ctx.table.core.schema.primaryKey;
	                    var coreRange = range;
	                    return ctx.table.core.count({ trans: trans, query: { index: primaryKey, range: coreRange } }).then(function (count) {
	                        return ctx.table.core.mutate({ trans: trans, type: 'deleteRange', range: coreRange })
	                            .then(function (_a) {
	                            var failures = _a.failures; _a.lastResult; _a.results; var numFailures = _a.numFailures;
	                            if (numFailures)
	                                throw new ModifyError("Could not delete some values", Object.keys(failures).map(function (pos) { return failures[pos]; }), count - numFailures);
	                            return count - numFailures;
	                        });
	                    });
	                });
	            }
	            return this.modify(deleteCallback);
	        };
	        return Collection;
	    }());
	    var deleteCallback = function (value, ctx) { return ctx.value = null; };

	    function createCollectionConstructor(db) {
	        return makeClassConstructor(Collection.prototype, function Collection(whereClause, keyRangeGenerator) {
	            this.db = db;
	            var keyRange = AnyRange, error = null;
	            if (keyRangeGenerator)
	                try {
	                    keyRange = keyRangeGenerator();
	                }
	                catch (ex) {
	                    error = ex;
	                }
	            var whereCtx = whereClause._ctx;
	            var table = whereCtx.table;
	            var readingHook = table.hook.reading.fire;
	            this._ctx = {
	                table: table,
	                index: whereCtx.index,
	                isPrimKey: (!whereCtx.index || (table.schema.primKey.keyPath && whereCtx.index === table.schema.primKey.name)),
	                range: keyRange,
	                keysOnly: false,
	                dir: "next",
	                unique: "",
	                algorithm: null,
	                filter: null,
	                replayFilter: null,
	                justLimit: true,
	                isMatch: null,
	                offset: 0,
	                limit: Infinity,
	                error: error,
	                or: whereCtx.or,
	                valueMapper: readingHook !== mirror ? readingHook : null
	            };
	        });
	    }

	    function simpleCompare(a, b) {
	        return a < b ? -1 : a === b ? 0 : 1;
	    }
	    function simpleCompareReverse(a, b) {
	        return a > b ? -1 : a === b ? 0 : 1;
	    }

	    function fail(collectionOrWhereClause, err, T) {
	        var collection = collectionOrWhereClause instanceof WhereClause ?
	            new collectionOrWhereClause.Collection(collectionOrWhereClause) :
	            collectionOrWhereClause;
	        collection._ctx.error = T ? new T(err) : new TypeError(err);
	        return collection;
	    }
	    function emptyCollection(whereClause) {
	        return new whereClause.Collection(whereClause, function () { return rangeEqual(""); }).limit(0);
	    }
	    function upperFactory(dir) {
	        return dir === "next" ?
	            function (s) { return s.toUpperCase(); } :
	            function (s) { return s.toLowerCase(); };
	    }
	    function lowerFactory(dir) {
	        return dir === "next" ?
	            function (s) { return s.toLowerCase(); } :
	            function (s) { return s.toUpperCase(); };
	    }
	    function nextCasing(key, lowerKey, upperNeedle, lowerNeedle, cmp, dir) {
	        var length = Math.min(key.length, lowerNeedle.length);
	        var llp = -1;
	        for (var i = 0; i < length; ++i) {
	            var lwrKeyChar = lowerKey[i];
	            if (lwrKeyChar !== lowerNeedle[i]) {
	                if (cmp(key[i], upperNeedle[i]) < 0)
	                    return key.substr(0, i) + upperNeedle[i] + upperNeedle.substr(i + 1);
	                if (cmp(key[i], lowerNeedle[i]) < 0)
	                    return key.substr(0, i) + lowerNeedle[i] + upperNeedle.substr(i + 1);
	                if (llp >= 0)
	                    return key.substr(0, llp) + lowerKey[llp] + upperNeedle.substr(llp + 1);
	                return null;
	            }
	            if (cmp(key[i], lwrKeyChar) < 0)
	                llp = i;
	        }
	        if (length < lowerNeedle.length && dir === "next")
	            return key + upperNeedle.substr(key.length);
	        if (length < key.length && dir === "prev")
	            return key.substr(0, upperNeedle.length);
	        return (llp < 0 ? null : key.substr(0, llp) + lowerNeedle[llp] + upperNeedle.substr(llp + 1));
	    }
	    function addIgnoreCaseAlgorithm(whereClause, match, needles, suffix) {
	        var upper, lower, compare, upperNeedles, lowerNeedles, direction, nextKeySuffix, needlesLen = needles.length;
	        if (!needles.every(function (s) { return typeof s === 'string'; })) {
	            return fail(whereClause, STRING_EXPECTED);
	        }
	        function initDirection(dir) {
	            upper = upperFactory(dir);
	            lower = lowerFactory(dir);
	            compare = (dir === "next" ? simpleCompare : simpleCompareReverse);
	            var needleBounds = needles.map(function (needle) {
	                return { lower: lower(needle), upper: upper(needle) };
	            }).sort(function (a, b) {
	                return compare(a.lower, b.lower);
	            });
	            upperNeedles = needleBounds.map(function (nb) { return nb.upper; });
	            lowerNeedles = needleBounds.map(function (nb) { return nb.lower; });
	            direction = dir;
	            nextKeySuffix = (dir === "next" ? "" : suffix);
	        }
	        initDirection("next");
	        var c = new whereClause.Collection(whereClause, function () { return createRange(upperNeedles[0], lowerNeedles[needlesLen - 1] + suffix); });
	        c._ondirectionchange = function (direction) {
	            initDirection(direction);
	        };
	        var firstPossibleNeedle = 0;
	        c._addAlgorithm(function (cursor, advance, resolve) {
	            var key = cursor.key;
	            if (typeof key !== 'string')
	                return false;
	            var lowerKey = lower(key);
	            if (match(lowerKey, lowerNeedles, firstPossibleNeedle)) {
	                return true;
	            }
	            else {
	                var lowestPossibleCasing = null;
	                for (var i = firstPossibleNeedle; i < needlesLen; ++i) {
	                    var casing = nextCasing(key, lowerKey, upperNeedles[i], lowerNeedles[i], compare, direction);
	                    if (casing === null && lowestPossibleCasing === null)
	                        firstPossibleNeedle = i + 1;
	                    else if (lowestPossibleCasing === null || compare(lowestPossibleCasing, casing) > 0) {
	                        lowestPossibleCasing = casing;
	                    }
	                }
	                if (lowestPossibleCasing !== null) {
	                    advance(function () { cursor.continue(lowestPossibleCasing + nextKeySuffix); });
	                }
	                else {
	                    advance(resolve);
	                }
	                return false;
	            }
	        });
	        return c;
	    }
	    function createRange(lower, upper, lowerOpen, upperOpen) {
	        return {
	            type: 2 ,
	            lower: lower,
	            upper: upper,
	            lowerOpen: lowerOpen,
	            upperOpen: upperOpen
	        };
	    }
	    function rangeEqual(value) {
	        return {
	            type: 1 ,
	            lower: value,
	            upper: value
	        };
	    }

	    var WhereClause =  (function () {
	        function WhereClause() {
	        }
	        Object.defineProperty(WhereClause.prototype, "Collection", {
	            get: function () {
	                return this._ctx.table.db.Collection;
	            },
	            enumerable: false,
	            configurable: true
	        });
	        WhereClause.prototype.between = function (lower, upper, includeLower, includeUpper) {
	            includeLower = includeLower !== false;
	            includeUpper = includeUpper === true;
	            try {
	                if ((this._cmp(lower, upper) > 0) ||
	                    (this._cmp(lower, upper) === 0 && (includeLower || includeUpper) && !(includeLower && includeUpper)))
	                    return emptyCollection(this);
	                return new this.Collection(this, function () { return createRange(lower, upper, !includeLower, !includeUpper); });
	            }
	            catch (e) {
	                return fail(this, INVALID_KEY_ARGUMENT);
	            }
	        };
	        WhereClause.prototype.equals = function (value) {
	            if (value == null)
	                return fail(this, INVALID_KEY_ARGUMENT);
	            return new this.Collection(this, function () { return rangeEqual(value); });
	        };
	        WhereClause.prototype.above = function (value) {
	            if (value == null)
	                return fail(this, INVALID_KEY_ARGUMENT);
	            return new this.Collection(this, function () { return createRange(value, undefined, true); });
	        };
	        WhereClause.prototype.aboveOrEqual = function (value) {
	            if (value == null)
	                return fail(this, INVALID_KEY_ARGUMENT);
	            return new this.Collection(this, function () { return createRange(value, undefined, false); });
	        };
	        WhereClause.prototype.below = function (value) {
	            if (value == null)
	                return fail(this, INVALID_KEY_ARGUMENT);
	            return new this.Collection(this, function () { return createRange(undefined, value, false, true); });
	        };
	        WhereClause.prototype.belowOrEqual = function (value) {
	            if (value == null)
	                return fail(this, INVALID_KEY_ARGUMENT);
	            return new this.Collection(this, function () { return createRange(undefined, value); });
	        };
	        WhereClause.prototype.startsWith = function (str) {
	            if (typeof str !== 'string')
	                return fail(this, STRING_EXPECTED);
	            return this.between(str, str + maxString, true, true);
	        };
	        WhereClause.prototype.startsWithIgnoreCase = function (str) {
	            if (str === "")
	                return this.startsWith(str);
	            return addIgnoreCaseAlgorithm(this, function (x, a) { return x.indexOf(a[0]) === 0; }, [str], maxString);
	        };
	        WhereClause.prototype.equalsIgnoreCase = function (str) {
	            return addIgnoreCaseAlgorithm(this, function (x, a) { return x === a[0]; }, [str], "");
	        };
	        WhereClause.prototype.anyOfIgnoreCase = function () {
	            var set = getArrayOf.apply(NO_CHAR_ARRAY, arguments);
	            if (set.length === 0)
	                return emptyCollection(this);
	            return addIgnoreCaseAlgorithm(this, function (x, a) { return a.indexOf(x) !== -1; }, set, "");
	        };
	        WhereClause.prototype.startsWithAnyOfIgnoreCase = function () {
	            var set = getArrayOf.apply(NO_CHAR_ARRAY, arguments);
	            if (set.length === 0)
	                return emptyCollection(this);
	            return addIgnoreCaseAlgorithm(this, function (x, a) { return a.some(function (n) { return x.indexOf(n) === 0; }); }, set, maxString);
	        };
	        WhereClause.prototype.anyOf = function () {
	            var _this = this;
	            var set = getArrayOf.apply(NO_CHAR_ARRAY, arguments);
	            var compare = this._cmp;
	            try {
	                set.sort(compare);
	            }
	            catch (e) {
	                return fail(this, INVALID_KEY_ARGUMENT);
	            }
	            if (set.length === 0)
	                return emptyCollection(this);
	            var c = new this.Collection(this, function () { return createRange(set[0], set[set.length - 1]); });
	            c._ondirectionchange = function (direction) {
	                compare = (direction === "next" ?
	                    _this._ascending :
	                    _this._descending);
	                set.sort(compare);
	            };
	            var i = 0;
	            c._addAlgorithm(function (cursor, advance, resolve) {
	                var key = cursor.key;
	                while (compare(key, set[i]) > 0) {
	                    ++i;
	                    if (i === set.length) {
	                        advance(resolve);
	                        return false;
	                    }
	                }
	                if (compare(key, set[i]) === 0) {
	                    return true;
	                }
	                else {
	                    advance(function () { cursor.continue(set[i]); });
	                    return false;
	                }
	            });
	            return c;
	        };
	        WhereClause.prototype.notEqual = function (value) {
	            return this.inAnyRange([[minKey, value], [value, this.db._maxKey]], { includeLowers: false, includeUppers: false });
	        };
	        WhereClause.prototype.noneOf = function () {
	            var set = getArrayOf.apply(NO_CHAR_ARRAY, arguments);
	            if (set.length === 0)
	                return new this.Collection(this);
	            try {
	                set.sort(this._ascending);
	            }
	            catch (e) {
	                return fail(this, INVALID_KEY_ARGUMENT);
	            }
	            var ranges = set.reduce(function (res, val) { return res ?
	                res.concat([[res[res.length - 1][1], val]]) :
	                [[minKey, val]]; }, null);
	            ranges.push([set[set.length - 1], this.db._maxKey]);
	            return this.inAnyRange(ranges, { includeLowers: false, includeUppers: false });
	        };
	        WhereClause.prototype.inAnyRange = function (ranges, options) {
	            var _this = this;
	            var cmp = this._cmp, ascending = this._ascending, descending = this._descending, min = this._min, max = this._max;
	            if (ranges.length === 0)
	                return emptyCollection(this);
	            if (!ranges.every(function (range) {
	                return range[0] !== undefined &&
	                    range[1] !== undefined &&
	                    ascending(range[0], range[1]) <= 0;
	            })) {
	                return fail(this, "First argument to inAnyRange() must be an Array of two-value Arrays [lower,upper] where upper must not be lower than lower", exceptions.InvalidArgument);
	            }
	            var includeLowers = !options || options.includeLowers !== false;
	            var includeUppers = options && options.includeUppers === true;
	            function addRange(ranges, newRange) {
	                var i = 0, l = ranges.length;
	                for (; i < l; ++i) {
	                    var range = ranges[i];
	                    if (cmp(newRange[0], range[1]) < 0 && cmp(newRange[1], range[0]) > 0) {
	                        range[0] = min(range[0], newRange[0]);
	                        range[1] = max(range[1], newRange[1]);
	                        break;
	                    }
	                }
	                if (i === l)
	                    ranges.push(newRange);
	                return ranges;
	            }
	            var sortDirection = ascending;
	            function rangeSorter(a, b) { return sortDirection(a[0], b[0]); }
	            var set;
	            try {
	                set = ranges.reduce(addRange, []);
	                set.sort(rangeSorter);
	            }
	            catch (ex) {
	                return fail(this, INVALID_KEY_ARGUMENT);
	            }
	            var rangePos = 0;
	            var keyIsBeyondCurrentEntry = includeUppers ?
	                function (key) { return ascending(key, set[rangePos][1]) > 0; } :
	                function (key) { return ascending(key, set[rangePos][1]) >= 0; };
	            var keyIsBeforeCurrentEntry = includeLowers ?
	                function (key) { return descending(key, set[rangePos][0]) > 0; } :
	                function (key) { return descending(key, set[rangePos][0]) >= 0; };
	            function keyWithinCurrentRange(key) {
	                return !keyIsBeyondCurrentEntry(key) && !keyIsBeforeCurrentEntry(key);
	            }
	            var checkKey = keyIsBeyondCurrentEntry;
	            var c = new this.Collection(this, function () { return createRange(set[0][0], set[set.length - 1][1], !includeLowers, !includeUppers); });
	            c._ondirectionchange = function (direction) {
	                if (direction === "next") {
	                    checkKey = keyIsBeyondCurrentEntry;
	                    sortDirection = ascending;
	                }
	                else {
	                    checkKey = keyIsBeforeCurrentEntry;
	                    sortDirection = descending;
	                }
	                set.sort(rangeSorter);
	            };
	            c._addAlgorithm(function (cursor, advance, resolve) {
	                var key = cursor.key;
	                while (checkKey(key)) {
	                    ++rangePos;
	                    if (rangePos === set.length) {
	                        advance(resolve);
	                        return false;
	                    }
	                }
	                if (keyWithinCurrentRange(key)) {
	                    return true;
	                }
	                else if (_this._cmp(key, set[rangePos][1]) === 0 || _this._cmp(key, set[rangePos][0]) === 0) {
	                    return false;
	                }
	                else {
	                    advance(function () {
	                        if (sortDirection === ascending)
	                            cursor.continue(set[rangePos][0]);
	                        else
	                            cursor.continue(set[rangePos][1]);
	                    });
	                    return false;
	                }
	            });
	            return c;
	        };
	        WhereClause.prototype.startsWithAnyOf = function () {
	            var set = getArrayOf.apply(NO_CHAR_ARRAY, arguments);
	            if (!set.every(function (s) { return typeof s === 'string'; })) {
	                return fail(this, "startsWithAnyOf() only works with strings");
	            }
	            if (set.length === 0)
	                return emptyCollection(this);
	            return this.inAnyRange(set.map(function (str) { return [str, str + maxString]; }));
	        };
	        return WhereClause;
	    }());

	    function createWhereClauseConstructor(db) {
	        return makeClassConstructor(WhereClause.prototype, function WhereClause(table, index, orCollection) {
	            this.db = db;
	            this._ctx = {
	                table: table,
	                index: index === ":id" ? null : index,
	                or: orCollection
	            };
	            var indexedDB = db._deps.indexedDB;
	            if (!indexedDB)
	                throw new exceptions.MissingAPI();
	            this._cmp = this._ascending = indexedDB.cmp.bind(indexedDB);
	            this._descending = function (a, b) { return indexedDB.cmp(b, a); };
	            this._max = function (a, b) { return indexedDB.cmp(a, b) > 0 ? a : b; };
	            this._min = function (a, b) { return indexedDB.cmp(a, b) < 0 ? a : b; };
	            this._IDBKeyRange = db._deps.IDBKeyRange;
	        });
	    }

	    function eventRejectHandler(reject) {
	        return wrap(function (event) {
	            preventDefault(event);
	            reject(event.target.error);
	            return false;
	        });
	    }
	    function preventDefault(event) {
	        if (event.stopPropagation)
	            event.stopPropagation();
	        if (event.preventDefault)
	            event.preventDefault();
	    }

	    var DEXIE_STORAGE_MUTATED_EVENT_NAME = 'storagemutated';
	    var STORAGE_MUTATED_DOM_EVENT_NAME = 'x-storagemutated-1';
	    var globalEvents = Events(null, DEXIE_STORAGE_MUTATED_EVENT_NAME);

	    var Transaction =  (function () {
	        function Transaction() {
	        }
	        Transaction.prototype._lock = function () {
	            assert(!PSD.global);
	            ++this._reculock;
	            if (this._reculock === 1 && !PSD.global)
	                PSD.lockOwnerFor = this;
	            return this;
	        };
	        Transaction.prototype._unlock = function () {
	            assert(!PSD.global);
	            if (--this._reculock === 0) {
	                if (!PSD.global)
	                    PSD.lockOwnerFor = null;
	                while (this._blockedFuncs.length > 0 && !this._locked()) {
	                    var fnAndPSD = this._blockedFuncs.shift();
	                    try {
	                        usePSD(fnAndPSD[1], fnAndPSD[0]);
	                    }
	                    catch (e) { }
	                }
	            }
	            return this;
	        };
	        Transaction.prototype._locked = function () {
	            return this._reculock && PSD.lockOwnerFor !== this;
	        };
	        Transaction.prototype.create = function (idbtrans) {
	            var _this = this;
	            if (!this.mode)
	                return this;
	            var idbdb = this.db.idbdb;
	            var dbOpenError = this.db._state.dbOpenError;
	            assert(!this.idbtrans);
	            if (!idbtrans && !idbdb) {
	                switch (dbOpenError && dbOpenError.name) {
	                    case "DatabaseClosedError":
	                        throw new exceptions.DatabaseClosed(dbOpenError);
	                    case "MissingAPIError":
	                        throw new exceptions.MissingAPI(dbOpenError.message, dbOpenError);
	                    default:
	                        throw new exceptions.OpenFailed(dbOpenError);
	                }
	            }
	            if (!this.active)
	                throw new exceptions.TransactionInactive();
	            assert(this._completion._state === null);
	            idbtrans = this.idbtrans = idbtrans ||
	                (this.db.core
	                    ? this.db.core.transaction(this.storeNames, this.mode, { durability: this.chromeTransactionDurability })
	                    : idbdb.transaction(this.storeNames, this.mode, { durability: this.chromeTransactionDurability }));
	            idbtrans.onerror = wrap(function (ev) {
	                preventDefault(ev);
	                _this._reject(idbtrans.error);
	            });
	            idbtrans.onabort = wrap(function (ev) {
	                preventDefault(ev);
	                _this.active && _this._reject(new exceptions.Abort(idbtrans.error));
	                _this.active = false;
	                _this.on("abort").fire(ev);
	            });
	            idbtrans.oncomplete = wrap(function () {
	                _this.active = false;
	                _this._resolve();
	                if ('mutatedParts' in idbtrans) {
	                    globalEvents.storagemutated.fire(idbtrans["mutatedParts"]);
	                }
	            });
	            return this;
	        };
	        Transaction.prototype._promise = function (mode, fn, bWriteLock) {
	            var _this = this;
	            if (mode === 'readwrite' && this.mode !== 'readwrite')
	                return rejection(new exceptions.ReadOnly("Transaction is readonly"));
	            if (!this.active)
	                return rejection(new exceptions.TransactionInactive());
	            if (this._locked()) {
	                return new DexiePromise(function (resolve, reject) {
	                    _this._blockedFuncs.push([function () {
	                            _this._promise(mode, fn, bWriteLock).then(resolve, reject);
	                        }, PSD]);
	                });
	            }
	            else if (bWriteLock) {
	                return newScope(function () {
	                    var p = new DexiePromise(function (resolve, reject) {
	                        _this._lock();
	                        var rv = fn(resolve, reject, _this);
	                        if (rv && rv.then)
	                            rv.then(resolve, reject);
	                    });
	                    p.finally(function () { return _this._unlock(); });
	                    p._lib = true;
	                    return p;
	                });
	            }
	            else {
	                var p = new DexiePromise(function (resolve, reject) {
	                    var rv = fn(resolve, reject, _this);
	                    if (rv && rv.then)
	                        rv.then(resolve, reject);
	                });
	                p._lib = true;
	                return p;
	            }
	        };
	        Transaction.prototype._root = function () {
	            return this.parent ? this.parent._root() : this;
	        };
	        Transaction.prototype.waitFor = function (promiseLike) {
	            var root = this._root();
	            var promise = DexiePromise.resolve(promiseLike);
	            if (root._waitingFor) {
	                root._waitingFor = root._waitingFor.then(function () { return promise; });
	            }
	            else {
	                root._waitingFor = promise;
	                root._waitingQueue = [];
	                var store = root.idbtrans.objectStore(root.storeNames[0]);
	                (function spin() {
	                    ++root._spinCount;
	                    while (root._waitingQueue.length)
	                        (root._waitingQueue.shift())();
	                    if (root._waitingFor)
	                        store.get(-Infinity).onsuccess = spin;
	                }());
	            }
	            var currentWaitPromise = root._waitingFor;
	            return new DexiePromise(function (resolve, reject) {
	                promise.then(function (res) { return root._waitingQueue.push(wrap(resolve.bind(null, res))); }, function (err) { return root._waitingQueue.push(wrap(reject.bind(null, err))); }).finally(function () {
	                    if (root._waitingFor === currentWaitPromise) {
	                        root._waitingFor = null;
	                    }
	                });
	            });
	        };
	        Transaction.prototype.abort = function () {
	            if (this.active) {
	                this.active = false;
	                if (this.idbtrans)
	                    this.idbtrans.abort();
	                this._reject(new exceptions.Abort());
	            }
	        };
	        Transaction.prototype.table = function (tableName) {
	            var memoizedTables = (this._memoizedTables || (this._memoizedTables = {}));
	            if (hasOwn(memoizedTables, tableName))
	                return memoizedTables[tableName];
	            var tableSchema = this.schema[tableName];
	            if (!tableSchema) {
	                throw new exceptions.NotFound("Table " + tableName + " not part of transaction");
	            }
	            var transactionBoundTable = new this.db.Table(tableName, tableSchema, this);
	            transactionBoundTable.core = this.db.core.table(tableName);
	            memoizedTables[tableName] = transactionBoundTable;
	            return transactionBoundTable;
	        };
	        return Transaction;
	    }());

	    function createTransactionConstructor(db) {
	        return makeClassConstructor(Transaction.prototype, function Transaction(mode, storeNames, dbschema, chromeTransactionDurability, parent) {
	            var _this = this;
	            this.db = db;
	            this.mode = mode;
	            this.storeNames = storeNames;
	            this.schema = dbschema;
	            this.chromeTransactionDurability = chromeTransactionDurability;
	            this.idbtrans = null;
	            this.on = Events(this, "complete", "error", "abort");
	            this.parent = parent || null;
	            this.active = true;
	            this._reculock = 0;
	            this._blockedFuncs = [];
	            this._resolve = null;
	            this._reject = null;
	            this._waitingFor = null;
	            this._waitingQueue = null;
	            this._spinCount = 0;
	            this._completion = new DexiePromise(function (resolve, reject) {
	                _this._resolve = resolve;
	                _this._reject = reject;
	            });
	            this._completion.then(function () {
	                _this.active = false;
	                _this.on.complete.fire();
	            }, function (e) {
	                var wasActive = _this.active;
	                _this.active = false;
	                _this.on.error.fire(e);
	                _this.parent ?
	                    _this.parent._reject(e) :
	                    wasActive && _this.idbtrans && _this.idbtrans.abort();
	                return rejection(e);
	            });
	        });
	    }

	    function createIndexSpec(name, keyPath, unique, multi, auto, compound, isPrimKey) {
	        return {
	            name: name,
	            keyPath: keyPath,
	            unique: unique,
	            multi: multi,
	            auto: auto,
	            compound: compound,
	            src: (unique && !isPrimKey ? '&' : '') + (multi ? '*' : '') + (auto ? "++" : "") + nameFromKeyPath(keyPath)
	        };
	    }
	    function nameFromKeyPath(keyPath) {
	        return typeof keyPath === 'string' ?
	            keyPath :
	            keyPath ? ('[' + [].join.call(keyPath, '+') + ']') : "";
	    }

	    function createTableSchema(name, primKey, indexes) {
	        return {
	            name: name,
	            primKey: primKey,
	            indexes: indexes,
	            mappedClass: null,
	            idxByName: arrayToObject(indexes, function (index) { return [index.name, index]; })
	        };
	    }

	    function safariMultiStoreFix(storeNames) {
	        return storeNames.length === 1 ? storeNames[0] : storeNames;
	    }
	    var getMaxKey = function (IdbKeyRange) {
	        try {
	            IdbKeyRange.only([[]]);
	            getMaxKey = function () { return [[]]; };
	            return [[]];
	        }
	        catch (e) {
	            getMaxKey = function () { return maxString; };
	            return maxString;
	        }
	    };

	    function getKeyExtractor(keyPath) {
	        if (keyPath == null) {
	            return function () { return undefined; };
	        }
	        else if (typeof keyPath === 'string') {
	            return getSinglePathKeyExtractor(keyPath);
	        }
	        else {
	            return function (obj) { return getByKeyPath(obj, keyPath); };
	        }
	    }
	    function getSinglePathKeyExtractor(keyPath) {
	        var split = keyPath.split('.');
	        if (split.length === 1) {
	            return function (obj) { return obj[keyPath]; };
	        }
	        else {
	            return function (obj) { return getByKeyPath(obj, keyPath); };
	        }
	    }

	    function arrayify(arrayLike) {
	        return [].slice.call(arrayLike);
	    }
	    var _id_counter = 0;
	    function getKeyPathAlias(keyPath) {
	        return keyPath == null ?
	            ":id" :
	            typeof keyPath === 'string' ?
	                keyPath :
	                "[" + keyPath.join('+') + "]";
	    }
	    function createDBCore(db, IdbKeyRange, tmpTrans) {
	        function extractSchema(db, trans) {
	            var tables = arrayify(db.objectStoreNames);
	            return {
	                schema: {
	                    name: db.name,
	                    tables: tables.map(function (table) { return trans.objectStore(table); }).map(function (store) {
	                        var keyPath = store.keyPath, autoIncrement = store.autoIncrement;
	                        var compound = isArray(keyPath);
	                        var outbound = keyPath == null;
	                        var indexByKeyPath = {};
	                        var result = {
	                            name: store.name,
	                            primaryKey: {
	                                name: null,
	                                isPrimaryKey: true,
	                                outbound: outbound,
	                                compound: compound,
	                                keyPath: keyPath,
	                                autoIncrement: autoIncrement,
	                                unique: true,
	                                extractKey: getKeyExtractor(keyPath)
	                            },
	                            indexes: arrayify(store.indexNames).map(function (indexName) { return store.index(indexName); })
	                                .map(function (index) {
	                                var name = index.name, unique = index.unique, multiEntry = index.multiEntry, keyPath = index.keyPath;
	                                var compound = isArray(keyPath);
	                                var result = {
	                                    name: name,
	                                    compound: compound,
	                                    keyPath: keyPath,
	                                    unique: unique,
	                                    multiEntry: multiEntry,
	                                    extractKey: getKeyExtractor(keyPath)
	                                };
	                                indexByKeyPath[getKeyPathAlias(keyPath)] = result;
	                                return result;
	                            }),
	                            getIndexByKeyPath: function (keyPath) { return indexByKeyPath[getKeyPathAlias(keyPath)]; }
	                        };
	                        indexByKeyPath[":id"] = result.primaryKey;
	                        if (keyPath != null) {
	                            indexByKeyPath[getKeyPathAlias(keyPath)] = result.primaryKey;
	                        }
	                        return result;
	                    })
	                },
	                hasGetAll: tables.length > 0 && ('getAll' in trans.objectStore(tables[0])) &&
	                    !(typeof navigator !== 'undefined' && /Safari/.test(navigator.userAgent) &&
	                        !/(Chrome\/|Edge\/)/.test(navigator.userAgent) &&
	                        [].concat(navigator.userAgent.match(/Safari\/(\d*)/))[1] < 604)
	            };
	        }
	        function makeIDBKeyRange(range) {
	            if (range.type === 3 )
	                return null;
	            if (range.type === 4 )
	                throw new Error("Cannot convert never type to IDBKeyRange");
	            var lower = range.lower, upper = range.upper, lowerOpen = range.lowerOpen, upperOpen = range.upperOpen;
	            var idbRange = lower === undefined ?
	                upper === undefined ?
	                    null :
	                    IdbKeyRange.upperBound(upper, !!upperOpen) :
	                upper === undefined ?
	                    IdbKeyRange.lowerBound(lower, !!lowerOpen) :
	                    IdbKeyRange.bound(lower, upper, !!lowerOpen, !!upperOpen);
	            return idbRange;
	        }
	        function createDbCoreTable(tableSchema) {
	            var tableName = tableSchema.name;
	            function mutate(_a) {
	                var trans = _a.trans, type = _a.type, keys = _a.keys, values = _a.values, range = _a.range;
	                return new Promise(function (resolve, reject) {
	                    resolve = wrap(resolve);
	                    var store = trans.objectStore(tableName);
	                    var outbound = store.keyPath == null;
	                    var isAddOrPut = type === "put" || type === "add";
	                    if (!isAddOrPut && type !== 'delete' && type !== 'deleteRange')
	                        throw new Error("Invalid operation type: " + type);
	                    var length = (keys || values || { length: 1 }).length;
	                    if (keys && values && keys.length !== values.length) {
	                        throw new Error("Given keys array must have same length as given values array.");
	                    }
	                    if (length === 0)
	                        return resolve({ numFailures: 0, failures: {}, results: [], lastResult: undefined });
	                    var req;
	                    var reqs = [];
	                    var failures = [];
	                    var numFailures = 0;
	                    var errorHandler = function (event) {
	                        ++numFailures;
	                        preventDefault(event);
	                    };
	                    if (type === 'deleteRange') {
	                        if (range.type === 4 )
	                            return resolve({ numFailures: numFailures, failures: failures, results: [], lastResult: undefined });
	                        if (range.type === 3 )
	                            reqs.push(req = store.clear());
	                        else
	                            reqs.push(req = store.delete(makeIDBKeyRange(range)));
	                    }
	                    else {
	                        var _a = isAddOrPut ?
	                            outbound ?
	                                [values, keys] :
	                                [values, null] :
	                            [keys, null], args1 = _a[0], args2 = _a[1];
	                        if (isAddOrPut) {
	                            for (var i = 0; i < length; ++i) {
	                                reqs.push(req = (args2 && args2[i] !== undefined ?
	                                    store[type](args1[i], args2[i]) :
	                                    store[type](args1[i])));
	                                req.onerror = errorHandler;
	                            }
	                        }
	                        else {
	                            for (var i = 0; i < length; ++i) {
	                                reqs.push(req = store[type](args1[i]));
	                                req.onerror = errorHandler;
	                            }
	                        }
	                    }
	                    var done = function (event) {
	                        var lastResult = event.target.result;
	                        reqs.forEach(function (req, i) { return req.error != null && (failures[i] = req.error); });
	                        resolve({
	                            numFailures: numFailures,
	                            failures: failures,
	                            results: type === "delete" ? keys : reqs.map(function (req) { return req.result; }),
	                            lastResult: lastResult
	                        });
	                    };
	                    req.onerror = function (event) {
	                        errorHandler(event);
	                        done(event);
	                    };
	                    req.onsuccess = done;
	                });
	            }
	            function openCursor(_a) {
	                var trans = _a.trans, values = _a.values, query = _a.query, reverse = _a.reverse, unique = _a.unique;
	                return new Promise(function (resolve, reject) {
	                    resolve = wrap(resolve);
	                    var index = query.index, range = query.range;
	                    var store = trans.objectStore(tableName);
	                    var source = index.isPrimaryKey ?
	                        store :
	                        store.index(index.name);
	                    var direction = reverse ?
	                        unique ?
	                            "prevunique" :
	                            "prev" :
	                        unique ?
	                            "nextunique" :
	                            "next";
	                    var req = values || !('openKeyCursor' in source) ?
	                        source.openCursor(makeIDBKeyRange(range), direction) :
	                        source.openKeyCursor(makeIDBKeyRange(range), direction);
	                    req.onerror = eventRejectHandler(reject);
	                    req.onsuccess = wrap(function (ev) {
	                        var cursor = req.result;
	                        if (!cursor) {
	                            resolve(null);
	                            return;
	                        }
	                        cursor.___id = ++_id_counter;
	                        cursor.done = false;
	                        var _cursorContinue = cursor.continue.bind(cursor);
	                        var _cursorContinuePrimaryKey = cursor.continuePrimaryKey;
	                        if (_cursorContinuePrimaryKey)
	                            _cursorContinuePrimaryKey = _cursorContinuePrimaryKey.bind(cursor);
	                        var _cursorAdvance = cursor.advance.bind(cursor);
	                        var doThrowCursorIsNotStarted = function () { throw new Error("Cursor not started"); };
	                        var doThrowCursorIsStopped = function () { throw new Error("Cursor not stopped"); };
	                        cursor.trans = trans;
	                        cursor.stop = cursor.continue = cursor.continuePrimaryKey = cursor.advance = doThrowCursorIsNotStarted;
	                        cursor.fail = wrap(reject);
	                        cursor.next = function () {
	                            var _this = this;
	                            var gotOne = 1;
	                            return this.start(function () { return gotOne-- ? _this.continue() : _this.stop(); }).then(function () { return _this; });
	                        };
	                        cursor.start = function (callback) {
	                            var iterationPromise = new Promise(function (resolveIteration, rejectIteration) {
	                                resolveIteration = wrap(resolveIteration);
	                                req.onerror = eventRejectHandler(rejectIteration);
	                                cursor.fail = rejectIteration;
	                                cursor.stop = function (value) {
	                                    cursor.stop = cursor.continue = cursor.continuePrimaryKey = cursor.advance = doThrowCursorIsStopped;
	                                    resolveIteration(value);
	                                };
	                            });
	                            var guardedCallback = function () {
	                                if (req.result) {
	                                    try {
	                                        callback();
	                                    }
	                                    catch (err) {
	                                        cursor.fail(err);
	                                    }
	                                }
	                                else {
	                                    cursor.done = true;
	                                    cursor.start = function () { throw new Error("Cursor behind last entry"); };
	                                    cursor.stop();
	                                }
	                            };
	                            req.onsuccess = wrap(function (ev) {
	                                req.onsuccess = guardedCallback;
	                                guardedCallback();
	                            });
	                            cursor.continue = _cursorContinue;
	                            cursor.continuePrimaryKey = _cursorContinuePrimaryKey;
	                            cursor.advance = _cursorAdvance;
	                            guardedCallback();
	                            return iterationPromise;
	                        };
	                        resolve(cursor);
	                    }, reject);
	                });
	            }
	            function query(hasGetAll) {
	                return function (request) {
	                    return new Promise(function (resolve, reject) {
	                        resolve = wrap(resolve);
	                        var trans = request.trans, values = request.values, limit = request.limit, query = request.query;
	                        var nonInfinitLimit = limit === Infinity ? undefined : limit;
	                        var index = query.index, range = query.range;
	                        var store = trans.objectStore(tableName);
	                        var source = index.isPrimaryKey ? store : store.index(index.name);
	                        var idbKeyRange = makeIDBKeyRange(range);
	                        if (limit === 0)
	                            return resolve({ result: [] });
	                        if (hasGetAll) {
	                            var req = values ?
	                                source.getAll(idbKeyRange, nonInfinitLimit) :
	                                source.getAllKeys(idbKeyRange, nonInfinitLimit);
	                            req.onsuccess = function (event) { return resolve({ result: event.target.result }); };
	                            req.onerror = eventRejectHandler(reject);
	                        }
	                        else {
	                            var count_1 = 0;
	                            var req_1 = values || !('openKeyCursor' in source) ?
	                                source.openCursor(idbKeyRange) :
	                                source.openKeyCursor(idbKeyRange);
	                            var result_1 = [];
	                            req_1.onsuccess = function (event) {
	                                var cursor = req_1.result;
	                                if (!cursor)
	                                    return resolve({ result: result_1 });
	                                result_1.push(values ? cursor.value : cursor.primaryKey);
	                                if (++count_1 === limit)
	                                    return resolve({ result: result_1 });
	                                cursor.continue();
	                            };
	                            req_1.onerror = eventRejectHandler(reject);
	                        }
	                    });
	                };
	            }
	            return {
	                name: tableName,
	                schema: tableSchema,
	                mutate: mutate,
	                getMany: function (_a) {
	                    var trans = _a.trans, keys = _a.keys;
	                    return new Promise(function (resolve, reject) {
	                        resolve = wrap(resolve);
	                        var store = trans.objectStore(tableName);
	                        var length = keys.length;
	                        var result = new Array(length);
	                        var keyCount = 0;
	                        var callbackCount = 0;
	                        var req;
	                        var successHandler = function (event) {
	                            var req = event.target;
	                            if ((result[req._pos] = req.result) != null)
	                                ;
	                            if (++callbackCount === keyCount)
	                                resolve(result);
	                        };
	                        var errorHandler = eventRejectHandler(reject);
	                        for (var i = 0; i < length; ++i) {
	                            var key = keys[i];
	                            if (key != null) {
	                                req = store.get(keys[i]);
	                                req._pos = i;
	                                req.onsuccess = successHandler;
	                                req.onerror = errorHandler;
	                                ++keyCount;
	                            }
	                        }
	                        if (keyCount === 0)
	                            resolve(result);
	                    });
	                },
	                get: function (_a) {
	                    var trans = _a.trans, key = _a.key;
	                    return new Promise(function (resolve, reject) {
	                        resolve = wrap(resolve);
	                        var store = trans.objectStore(tableName);
	                        var req = store.get(key);
	                        req.onsuccess = function (event) { return resolve(event.target.result); };
	                        req.onerror = eventRejectHandler(reject);
	                    });
	                },
	                query: query(hasGetAll),
	                openCursor: openCursor,
	                count: function (_a) {
	                    var query = _a.query, trans = _a.trans;
	                    var index = query.index, range = query.range;
	                    return new Promise(function (resolve, reject) {
	                        var store = trans.objectStore(tableName);
	                        var source = index.isPrimaryKey ? store : store.index(index.name);
	                        var idbKeyRange = makeIDBKeyRange(range);
	                        var req = idbKeyRange ? source.count(idbKeyRange) : source.count();
	                        req.onsuccess = wrap(function (ev) { return resolve(ev.target.result); });
	                        req.onerror = eventRejectHandler(reject);
	                    });
	                }
	            };
	        }
	        var _a = extractSchema(db, tmpTrans), schema = _a.schema, hasGetAll = _a.hasGetAll;
	        var tables = schema.tables.map(function (tableSchema) { return createDbCoreTable(tableSchema); });
	        var tableMap = {};
	        tables.forEach(function (table) { return tableMap[table.name] = table; });
	        return {
	            stack: "dbcore",
	            transaction: db.transaction.bind(db),
	            table: function (name) {
	                var result = tableMap[name];
	                if (!result)
	                    throw new Error("Table '" + name + "' not found");
	                return tableMap[name];
	            },
	            MIN_KEY: -Infinity,
	            MAX_KEY: getMaxKey(IdbKeyRange),
	            schema: schema
	        };
	    }

	    function createMiddlewareStack(stackImpl, middlewares) {
	        return middlewares.reduce(function (down, _a) {
	            var create = _a.create;
	            return (__assign(__assign({}, down), create(down)));
	        }, stackImpl);
	    }
	    function createMiddlewareStacks(middlewares, idbdb, _a, tmpTrans) {
	        var IDBKeyRange = _a.IDBKeyRange; _a.indexedDB;
	        var dbcore = createMiddlewareStack(createDBCore(idbdb, IDBKeyRange, tmpTrans), middlewares.dbcore);
	        return {
	            dbcore: dbcore
	        };
	    }
	    function generateMiddlewareStacks(_a, tmpTrans) {
	        var db = _a._novip;
	        var idbdb = tmpTrans.db;
	        var stacks = createMiddlewareStacks(db._middlewares, idbdb, db._deps, tmpTrans);
	        db.core = stacks.dbcore;
	        db.tables.forEach(function (table) {
	            var tableName = table.name;
	            if (db.core.schema.tables.some(function (tbl) { return tbl.name === tableName; })) {
	                table.core = db.core.table(tableName);
	                if (db[tableName] instanceof db.Table) {
	                    db[tableName].core = table.core;
	                }
	            }
	        });
	    }

	    function setApiOnPlace(_a, objs, tableNames, dbschema) {
	        var db = _a._novip;
	        tableNames.forEach(function (tableName) {
	            var schema = dbschema[tableName];
	            objs.forEach(function (obj) {
	                var propDesc = getPropertyDescriptor(obj, tableName);
	                if (!propDesc || ("value" in propDesc && propDesc.value === undefined)) {
	                    if (obj === db.Transaction.prototype || obj instanceof db.Transaction) {
	                        setProp(obj, tableName, {
	                            get: function () { return this.table(tableName); },
	                            set: function (value) {
	                                defineProperty(this, tableName, { value: value, writable: true, configurable: true, enumerable: true });
	                            }
	                        });
	                    }
	                    else {
	                        obj[tableName] = new db.Table(tableName, schema);
	                    }
	                }
	            });
	        });
	    }
	    function removeTablesApi(_a, objs) {
	        var db = _a._novip;
	        objs.forEach(function (obj) {
	            for (var key in obj) {
	                if (obj[key] instanceof db.Table)
	                    delete obj[key];
	            }
	        });
	    }
	    function lowerVersionFirst(a, b) {
	        return a._cfg.version - b._cfg.version;
	    }
	    function runUpgraders(db, oldVersion, idbUpgradeTrans, reject) {
	        var globalSchema = db._dbSchema;
	        var trans = db._createTransaction('readwrite', db._storeNames, globalSchema);
	        trans.create(idbUpgradeTrans);
	        trans._completion.catch(reject);
	        var rejectTransaction = trans._reject.bind(trans);
	        var transless = PSD.transless || PSD;
	        newScope(function () {
	            PSD.trans = trans;
	            PSD.transless = transless;
	            if (oldVersion === 0) {
	                keys(globalSchema).forEach(function (tableName) {
	                    createTable(idbUpgradeTrans, tableName, globalSchema[tableName].primKey, globalSchema[tableName].indexes);
	                });
	                generateMiddlewareStacks(db, idbUpgradeTrans);
	                DexiePromise.follow(function () { return db.on.populate.fire(trans); }).catch(rejectTransaction);
	            }
	            else
	                updateTablesAndIndexes(db, oldVersion, trans, idbUpgradeTrans).catch(rejectTransaction);
	        });
	    }
	    function updateTablesAndIndexes(_a, oldVersion, trans, idbUpgradeTrans) {
	        var db = _a._novip;
	        var queue = [];
	        var versions = db._versions;
	        var globalSchema = db._dbSchema = buildGlobalSchema(db, db.idbdb, idbUpgradeTrans);
	        var anyContentUpgraderHasRun = false;
	        var versToRun = versions.filter(function (v) { return v._cfg.version >= oldVersion; });
	        versToRun.forEach(function (version) {
	            queue.push(function () {
	                var oldSchema = globalSchema;
	                var newSchema = version._cfg.dbschema;
	                adjustToExistingIndexNames(db, oldSchema, idbUpgradeTrans);
	                adjustToExistingIndexNames(db, newSchema, idbUpgradeTrans);
	                globalSchema = db._dbSchema = newSchema;
	                var diff = getSchemaDiff(oldSchema, newSchema);
	                diff.add.forEach(function (tuple) {
	                    createTable(idbUpgradeTrans, tuple[0], tuple[1].primKey, tuple[1].indexes);
	                });
	                diff.change.forEach(function (change) {
	                    if (change.recreate) {
	                        throw new exceptions.Upgrade("Not yet support for changing primary key");
	                    }
	                    else {
	                        var store_1 = idbUpgradeTrans.objectStore(change.name);
	                        change.add.forEach(function (idx) { return addIndex(store_1, idx); });
	                        change.change.forEach(function (idx) {
	                            store_1.deleteIndex(idx.name);
	                            addIndex(store_1, idx);
	                        });
	                        change.del.forEach(function (idxName) { return store_1.deleteIndex(idxName); });
	                    }
	                });
	                var contentUpgrade = version._cfg.contentUpgrade;
	                if (contentUpgrade && version._cfg.version > oldVersion) {
	                    generateMiddlewareStacks(db, idbUpgradeTrans);
	                    trans._memoizedTables = {};
	                    anyContentUpgraderHasRun = true;
	                    var upgradeSchema_1 = shallowClone(newSchema);
	                    diff.del.forEach(function (table) {
	                        upgradeSchema_1[table] = oldSchema[table];
	                    });
	                    removeTablesApi(db, [db.Transaction.prototype]);
	                    setApiOnPlace(db, [db.Transaction.prototype], keys(upgradeSchema_1), upgradeSchema_1);
	                    trans.schema = upgradeSchema_1;
	                    var contentUpgradeIsAsync_1 = isAsyncFunction(contentUpgrade);
	                    if (contentUpgradeIsAsync_1) {
	                        incrementExpectedAwaits();
	                    }
	                    var returnValue_1;
	                    var promiseFollowed = DexiePromise.follow(function () {
	                        returnValue_1 = contentUpgrade(trans);
	                        if (returnValue_1) {
	                            if (contentUpgradeIsAsync_1) {
	                                var decrementor = decrementExpectedAwaits.bind(null, null);
	                                returnValue_1.then(decrementor, decrementor);
	                            }
	                        }
	                    });
	                    return (returnValue_1 && typeof returnValue_1.then === 'function' ?
	                        DexiePromise.resolve(returnValue_1) : promiseFollowed.then(function () { return returnValue_1; }));
	                }
	            });
	            queue.push(function (idbtrans) {
	                if (!anyContentUpgraderHasRun || !hasIEDeleteObjectStoreBug) {
	                    var newSchema = version._cfg.dbschema;
	                    deleteRemovedTables(newSchema, idbtrans);
	                }
	                removeTablesApi(db, [db.Transaction.prototype]);
	                setApiOnPlace(db, [db.Transaction.prototype], db._storeNames, db._dbSchema);
	                trans.schema = db._dbSchema;
	            });
	        });
	        function runQueue() {
	            return queue.length ? DexiePromise.resolve(queue.shift()(trans.idbtrans)).then(runQueue) :
	                DexiePromise.resolve();
	        }
	        return runQueue().then(function () {
	            createMissingTables(globalSchema, idbUpgradeTrans);
	        });
	    }
	    function getSchemaDiff(oldSchema, newSchema) {
	        var diff = {
	            del: [],
	            add: [],
	            change: []
	        };
	        var table;
	        for (table in oldSchema) {
	            if (!newSchema[table])
	                diff.del.push(table);
	        }
	        for (table in newSchema) {
	            var oldDef = oldSchema[table], newDef = newSchema[table];
	            if (!oldDef) {
	                diff.add.push([table, newDef]);
	            }
	            else {
	                var change = {
	                    name: table,
	                    def: newDef,
	                    recreate: false,
	                    del: [],
	                    add: [],
	                    change: []
	                };
	                if ((
	                '' + (oldDef.primKey.keyPath || '')) !== ('' + (newDef.primKey.keyPath || '')) ||
	                    (oldDef.primKey.auto !== newDef.primKey.auto && !isIEOrEdge))
	                 {
	                    change.recreate = true;
	                    diff.change.push(change);
	                }
	                else {
	                    var oldIndexes = oldDef.idxByName;
	                    var newIndexes = newDef.idxByName;
	                    var idxName = void 0;
	                    for (idxName in oldIndexes) {
	                        if (!newIndexes[idxName])
	                            change.del.push(idxName);
	                    }
	                    for (idxName in newIndexes) {
	                        var oldIdx = oldIndexes[idxName], newIdx = newIndexes[idxName];
	                        if (!oldIdx)
	                            change.add.push(newIdx);
	                        else if (oldIdx.src !== newIdx.src)
	                            change.change.push(newIdx);
	                    }
	                    if (change.del.length > 0 || change.add.length > 0 || change.change.length > 0) {
	                        diff.change.push(change);
	                    }
	                }
	            }
	        }
	        return diff;
	    }
	    function createTable(idbtrans, tableName, primKey, indexes) {
	        var store = idbtrans.db.createObjectStore(tableName, primKey.keyPath ?
	            { keyPath: primKey.keyPath, autoIncrement: primKey.auto } :
	            { autoIncrement: primKey.auto });
	        indexes.forEach(function (idx) { return addIndex(store, idx); });
	        return store;
	    }
	    function createMissingTables(newSchema, idbtrans) {
	        keys(newSchema).forEach(function (tableName) {
	            if (!idbtrans.db.objectStoreNames.contains(tableName)) {
	                createTable(idbtrans, tableName, newSchema[tableName].primKey, newSchema[tableName].indexes);
	            }
	        });
	    }
	    function deleteRemovedTables(newSchema, idbtrans) {
	        [].slice.call(idbtrans.db.objectStoreNames).forEach(function (storeName) {
	            return newSchema[storeName] == null && idbtrans.db.deleteObjectStore(storeName);
	        });
	    }
	    function addIndex(store, idx) {
	        store.createIndex(idx.name, idx.keyPath, { unique: idx.unique, multiEntry: idx.multi });
	    }
	    function buildGlobalSchema(db, idbdb, tmpTrans) {
	        var globalSchema = {};
	        var dbStoreNames = slice(idbdb.objectStoreNames, 0);
	        dbStoreNames.forEach(function (storeName) {
	            var store = tmpTrans.objectStore(storeName);
	            var keyPath = store.keyPath;
	            var primKey = createIndexSpec(nameFromKeyPath(keyPath), keyPath || "", false, false, !!store.autoIncrement, keyPath && typeof keyPath !== "string", true);
	            var indexes = [];
	            for (var j = 0; j < store.indexNames.length; ++j) {
	                var idbindex = store.index(store.indexNames[j]);
	                keyPath = idbindex.keyPath;
	                var index = createIndexSpec(idbindex.name, keyPath, !!idbindex.unique, !!idbindex.multiEntry, false, keyPath && typeof keyPath !== "string", false);
	                indexes.push(index);
	            }
	            globalSchema[storeName] = createTableSchema(storeName, primKey, indexes);
	        });
	        return globalSchema;
	    }
	    function readGlobalSchema(_a, idbdb, tmpTrans) {
	        var db = _a._novip;
	        db.verno = idbdb.version / 10;
	        var globalSchema = db._dbSchema = buildGlobalSchema(db, idbdb, tmpTrans);
	        db._storeNames = slice(idbdb.objectStoreNames, 0);
	        setApiOnPlace(db, [db._allTables], keys(globalSchema), globalSchema);
	    }
	    function verifyInstalledSchema(db, tmpTrans) {
	        var installedSchema = buildGlobalSchema(db, db.idbdb, tmpTrans);
	        var diff = getSchemaDiff(installedSchema, db._dbSchema);
	        return !(diff.add.length || diff.change.some(function (ch) { return ch.add.length || ch.change.length; }));
	    }
	    function adjustToExistingIndexNames(_a, schema, idbtrans) {
	        var db = _a._novip;
	        var storeNames = idbtrans.db.objectStoreNames;
	        for (var i = 0; i < storeNames.length; ++i) {
	            var storeName = storeNames[i];
	            var store = idbtrans.objectStore(storeName);
	            db._hasGetAll = 'getAll' in store;
	            for (var j = 0; j < store.indexNames.length; ++j) {
	                var indexName = store.indexNames[j];
	                var keyPath = store.index(indexName).keyPath;
	                var dexieName = typeof keyPath === 'string' ? keyPath : "[" + slice(keyPath).join('+') + "]";
	                if (schema[storeName]) {
	                    var indexSpec = schema[storeName].idxByName[dexieName];
	                    if (indexSpec) {
	                        indexSpec.name = indexName;
	                        delete schema[storeName].idxByName[dexieName];
	                        schema[storeName].idxByName[indexName] = indexSpec;
	                    }
	                }
	            }
	        }
	        if (typeof navigator !== 'undefined' && /Safari/.test(navigator.userAgent) &&
	            !/(Chrome\/|Edge\/)/.test(navigator.userAgent) &&
	            _global.WorkerGlobalScope && _global instanceof _global.WorkerGlobalScope &&
	            [].concat(navigator.userAgent.match(/Safari\/(\d*)/))[1] < 604) {
	            db._hasGetAll = false;
	        }
	    }
	    function parseIndexSyntax(primKeyAndIndexes) {
	        return primKeyAndIndexes.split(',').map(function (index, indexNum) {
	            index = index.trim();
	            var name = index.replace(/([&*]|\+\+)/g, "");
	            var keyPath = /^\[/.test(name) ? name.match(/^\[(.*)\]$/)[1].split('+') : name;
	            return createIndexSpec(name, keyPath || null, /\&/.test(index), /\*/.test(index), /\+\+/.test(index), isArray(keyPath), indexNum === 0);
	        });
	    }

	    var Version =  (function () {
	        function Version() {
	        }
	        Version.prototype._parseStoresSpec = function (stores, outSchema) {
	            keys(stores).forEach(function (tableName) {
	                if (stores[tableName] !== null) {
	                    var indexes = parseIndexSyntax(stores[tableName]);
	                    var primKey = indexes.shift();
	                    if (primKey.multi)
	                        throw new exceptions.Schema("Primary key cannot be multi-valued");
	                    indexes.forEach(function (idx) {
	                        if (idx.auto)
	                            throw new exceptions.Schema("Only primary key can be marked as autoIncrement (++)");
	                        if (!idx.keyPath)
	                            throw new exceptions.Schema("Index must have a name and cannot be an empty string");
	                    });
	                    outSchema[tableName] = createTableSchema(tableName, primKey, indexes);
	                }
	            });
	        };
	        Version.prototype.stores = function (stores) {
	            var db = this.db;
	            this._cfg.storesSource = this._cfg.storesSource ?
	                extend(this._cfg.storesSource, stores) :
	                stores;
	            var versions = db._versions;
	            var storesSpec = {};
	            var dbschema = {};
	            versions.forEach(function (version) {
	                extend(storesSpec, version._cfg.storesSource);
	                dbschema = (version._cfg.dbschema = {});
	                version._parseStoresSpec(storesSpec, dbschema);
	            });
	            db._dbSchema = dbschema;
	            removeTablesApi(db, [db._allTables, db, db.Transaction.prototype]);
	            setApiOnPlace(db, [db._allTables, db, db.Transaction.prototype, this._cfg.tables], keys(dbschema), dbschema);
	            db._storeNames = keys(dbschema);
	            return this;
	        };
	        Version.prototype.upgrade = function (upgradeFunction) {
	            this._cfg.contentUpgrade = promisableChain(this._cfg.contentUpgrade || nop, upgradeFunction);
	            return this;
	        };
	        return Version;
	    }());

	    function createVersionConstructor(db) {
	        return makeClassConstructor(Version.prototype, function Version(versionNumber) {
	            this.db = db;
	            this._cfg = {
	                version: versionNumber,
	                storesSource: null,
	                dbschema: {},
	                tables: {},
	                contentUpgrade: null
	            };
	        });
	    }

	    function getDbNamesTable(indexedDB, IDBKeyRange) {
	        var dbNamesDB = indexedDB["_dbNamesDB"];
	        if (!dbNamesDB) {
	            dbNamesDB = indexedDB["_dbNamesDB"] = new Dexie$1(DBNAMES_DB, {
	                addons: [],
	                indexedDB: indexedDB,
	                IDBKeyRange: IDBKeyRange,
	            });
	            dbNamesDB.version(1).stores({ dbnames: "name" });
	        }
	        return dbNamesDB.table("dbnames");
	    }
	    function hasDatabasesNative(indexedDB) {
	        return indexedDB && typeof indexedDB.databases === "function";
	    }
	    function getDatabaseNames(_a) {
	        var indexedDB = _a.indexedDB, IDBKeyRange = _a.IDBKeyRange;
	        return hasDatabasesNative(indexedDB)
	            ? Promise.resolve(indexedDB.databases()).then(function (infos) {
	                return infos
	                    .map(function (info) { return info.name; })
	                    .filter(function (name) { return name !== DBNAMES_DB; });
	            })
	            : getDbNamesTable(indexedDB, IDBKeyRange).toCollection().primaryKeys();
	    }
	    function _onDatabaseCreated(_a, name) {
	        var indexedDB = _a.indexedDB, IDBKeyRange = _a.IDBKeyRange;
	        !hasDatabasesNative(indexedDB) &&
	            name !== DBNAMES_DB &&
	            getDbNamesTable(indexedDB, IDBKeyRange).put({ name: name }).catch(nop);
	    }
	    function _onDatabaseDeleted(_a, name) {
	        var indexedDB = _a.indexedDB, IDBKeyRange = _a.IDBKeyRange;
	        !hasDatabasesNative(indexedDB) &&
	            name !== DBNAMES_DB &&
	            getDbNamesTable(indexedDB, IDBKeyRange).delete(name).catch(nop);
	    }

	    function vip(fn) {
	        return newScope(function () {
	            PSD.letThrough = true;
	            return fn();
	        });
	    }

	    function idbReady() {
	        var isSafari = !navigator.userAgentData &&
	            /Safari\//.test(navigator.userAgent) &&
	            !/Chrom(e|ium)\//.test(navigator.userAgent);
	        if (!isSafari || !indexedDB.databases)
	            return Promise.resolve();
	        var intervalId;
	        return new Promise(function (resolve) {
	            var tryIdb = function () { return indexedDB.databases().finally(resolve); };
	            intervalId = setInterval(tryIdb, 100);
	            tryIdb();
	        }).finally(function () { return clearInterval(intervalId); });
	    }

	    function dexieOpen(db) {
	        var state = db._state;
	        var indexedDB = db._deps.indexedDB;
	        if (state.isBeingOpened || db.idbdb)
	            return state.dbReadyPromise.then(function () { return state.dbOpenError ?
	                rejection(state.dbOpenError) :
	                db; });
	        debug && (state.openCanceller._stackHolder = getErrorWithStack());
	        state.isBeingOpened = true;
	        state.dbOpenError = null;
	        state.openComplete = false;
	        var openCanceller = state.openCanceller;
	        function throwIfCancelled() {
	            if (state.openCanceller !== openCanceller)
	                throw new exceptions.DatabaseClosed('db.open() was cancelled');
	        }
	        var resolveDbReady = state.dbReadyResolve,
	        upgradeTransaction = null, wasCreated = false;
	        return DexiePromise.race([openCanceller, (typeof navigator === 'undefined' ? DexiePromise.resolve() : idbReady()).then(function () { return new DexiePromise(function (resolve, reject) {
	                throwIfCancelled();
	                if (!indexedDB)
	                    throw new exceptions.MissingAPI();
	                var dbName = db.name;
	                var req = state.autoSchema ?
	                    indexedDB.open(dbName) :
	                    indexedDB.open(dbName, Math.round(db.verno * 10));
	                if (!req)
	                    throw new exceptions.MissingAPI();
	                req.onerror = eventRejectHandler(reject);
	                req.onblocked = wrap(db._fireOnBlocked);
	                req.onupgradeneeded = wrap(function (e) {
	                    upgradeTransaction = req.transaction;
	                    if (state.autoSchema && !db._options.allowEmptyDB) {
	                        req.onerror = preventDefault;
	                        upgradeTransaction.abort();
	                        req.result.close();
	                        var delreq = indexedDB.deleteDatabase(dbName);
	                        delreq.onsuccess = delreq.onerror = wrap(function () {
	                            reject(new exceptions.NoSuchDatabase("Database " + dbName + " doesnt exist"));
	                        });
	                    }
	                    else {
	                        upgradeTransaction.onerror = eventRejectHandler(reject);
	                        var oldVer = e.oldVersion > Math.pow(2, 62) ? 0 : e.oldVersion;
	                        wasCreated = oldVer < 1;
	                        db._novip.idbdb = req.result;
	                        runUpgraders(db, oldVer / 10, upgradeTransaction, reject);
	                    }
	                }, reject);
	                req.onsuccess = wrap(function () {
	                    upgradeTransaction = null;
	                    var idbdb = db._novip.idbdb = req.result;
	                    var objectStoreNames = slice(idbdb.objectStoreNames);
	                    if (objectStoreNames.length > 0)
	                        try {
	                            var tmpTrans = idbdb.transaction(safariMultiStoreFix(objectStoreNames), 'readonly');
	                            if (state.autoSchema)
	                                readGlobalSchema(db, idbdb, tmpTrans);
	                            else {
	                                adjustToExistingIndexNames(db, db._dbSchema, tmpTrans);
	                                if (!verifyInstalledSchema(db, tmpTrans)) {
	                                    console.warn("Dexie SchemaDiff: Schema was extended without increasing the number passed to db.version(). Some queries may fail.");
	                                }
	                            }
	                            generateMiddlewareStacks(db, tmpTrans);
	                        }
	                        catch (e) {
	                        }
	                    connections.push(db);
	                    idbdb.onversionchange = wrap(function (ev) {
	                        state.vcFired = true;
	                        db.on("versionchange").fire(ev);
	                    });
	                    idbdb.onclose = wrap(function (ev) {
	                        db.on("close").fire(ev);
	                    });
	                    if (wasCreated)
	                        _onDatabaseCreated(db._deps, dbName);
	                    resolve();
	                }, reject);
	            }); })]).then(function () {
	            throwIfCancelled();
	            state.onReadyBeingFired = [];
	            return DexiePromise.resolve(vip(function () { return db.on.ready.fire(db.vip); })).then(function fireRemainders() {
	                if (state.onReadyBeingFired.length > 0) {
	                    var remainders_1 = state.onReadyBeingFired.reduce(promisableChain, nop);
	                    state.onReadyBeingFired = [];
	                    return DexiePromise.resolve(vip(function () { return remainders_1(db.vip); })).then(fireRemainders);
	                }
	            });
	        }).finally(function () {
	            state.onReadyBeingFired = null;
	            state.isBeingOpened = false;
	        }).then(function () {
	            return db;
	        }).catch(function (err) {
	            state.dbOpenError = err;
	            try {
	                upgradeTransaction && upgradeTransaction.abort();
	            }
	            catch (_a) { }
	            if (openCanceller === state.openCanceller) {
	                db._close();
	            }
	            return rejection(err);
	        }).finally(function () {
	            state.openComplete = true;
	            resolveDbReady();
	        });
	    }

	    function awaitIterator(iterator) {
	        var callNext = function (result) { return iterator.next(result); }, doThrow = function (error) { return iterator.throw(error); }, onSuccess = step(callNext), onError = step(doThrow);
	        function step(getNext) {
	            return function (val) {
	                var next = getNext(val), value = next.value;
	                return next.done ? value :
	                    (!value || typeof value.then !== 'function' ?
	                        isArray(value) ? Promise.all(value).then(onSuccess, onError) : onSuccess(value) :
	                        value.then(onSuccess, onError));
	            };
	        }
	        return step(callNext)();
	    }

	    function extractTransactionArgs(mode, _tableArgs_, scopeFunc) {
	        var i = arguments.length;
	        if (i < 2)
	            throw new exceptions.InvalidArgument("Too few arguments");
	        var args = new Array(i - 1);
	        while (--i)
	            args[i - 1] = arguments[i];
	        scopeFunc = args.pop();
	        var tables = flatten(args);
	        return [mode, tables, scopeFunc];
	    }
	    function enterTransactionScope(db, mode, storeNames, parentTransaction, scopeFunc) {
	        return DexiePromise.resolve().then(function () {
	            var transless = PSD.transless || PSD;
	            var trans = db._createTransaction(mode, storeNames, db._dbSchema, parentTransaction);
	            var zoneProps = {
	                trans: trans,
	                transless: transless
	            };
	            if (parentTransaction) {
	                trans.idbtrans = parentTransaction.idbtrans;
	            }
	            else {
	                try {
	                    trans.create();
	                    db._state.PR1398_maxLoop = 3;
	                }
	                catch (ex) {
	                    if (ex.name === errnames.InvalidState && db.isOpen() && --db._state.PR1398_maxLoop > 0) {
	                        console.warn('Dexie: Need to reopen db');
	                        db._close();
	                        return db.open().then(function () { return enterTransactionScope(db, mode, storeNames, null, scopeFunc); });
	                    }
	                    return rejection(ex);
	                }
	            }
	            var scopeFuncIsAsync = isAsyncFunction(scopeFunc);
	            if (scopeFuncIsAsync) {
	                incrementExpectedAwaits();
	            }
	            var returnValue;
	            var promiseFollowed = DexiePromise.follow(function () {
	                returnValue = scopeFunc.call(trans, trans);
	                if (returnValue) {
	                    if (scopeFuncIsAsync) {
	                        var decrementor = decrementExpectedAwaits.bind(null, null);
	                        returnValue.then(decrementor, decrementor);
	                    }
	                    else if (typeof returnValue.next === 'function' && typeof returnValue.throw === 'function') {
	                        returnValue = awaitIterator(returnValue);
	                    }
	                }
	            }, zoneProps);
	            return (returnValue && typeof returnValue.then === 'function' ?
	                DexiePromise.resolve(returnValue).then(function (x) { return trans.active ?
	                    x
	                    : rejection(new exceptions.PrematureCommit("Transaction committed too early. See http://bit.ly/2kdckMn")); })
	                : promiseFollowed.then(function () { return returnValue; })).then(function (x) {
	                if (parentTransaction)
	                    trans._resolve();
	                return trans._completion.then(function () { return x; });
	            }).catch(function (e) {
	                trans._reject(e);
	                return rejection(e);
	            });
	        });
	    }

	    function pad(a, value, count) {
	        var result = isArray(a) ? a.slice() : [a];
	        for (var i = 0; i < count; ++i)
	            result.push(value);
	        return result;
	    }
	    function createVirtualIndexMiddleware(down) {
	        return __assign(__assign({}, down), { table: function (tableName) {
	                var table = down.table(tableName);
	                var schema = table.schema;
	                var indexLookup = {};
	                var allVirtualIndexes = [];
	                function addVirtualIndexes(keyPath, keyTail, lowLevelIndex) {
	                    var keyPathAlias = getKeyPathAlias(keyPath);
	                    var indexList = (indexLookup[keyPathAlias] = indexLookup[keyPathAlias] || []);
	                    var keyLength = keyPath == null ? 0 : typeof keyPath === 'string' ? 1 : keyPath.length;
	                    var isVirtual = keyTail > 0;
	                    var virtualIndex = __assign(__assign({}, lowLevelIndex), { isVirtual: isVirtual, keyTail: keyTail, keyLength: keyLength, extractKey: getKeyExtractor(keyPath), unique: !isVirtual && lowLevelIndex.unique });
	                    indexList.push(virtualIndex);
	                    if (!virtualIndex.isPrimaryKey) {
	                        allVirtualIndexes.push(virtualIndex);
	                    }
	                    if (keyLength > 1) {
	                        var virtualKeyPath = keyLength === 2 ?
	                            keyPath[0] :
	                            keyPath.slice(0, keyLength - 1);
	                        addVirtualIndexes(virtualKeyPath, keyTail + 1, lowLevelIndex);
	                    }
	                    indexList.sort(function (a, b) { return a.keyTail - b.keyTail; });
	                    return virtualIndex;
	                }
	                var primaryKey = addVirtualIndexes(schema.primaryKey.keyPath, 0, schema.primaryKey);
	                indexLookup[":id"] = [primaryKey];
	                for (var _i = 0, _a = schema.indexes; _i < _a.length; _i++) {
	                    var index = _a[_i];
	                    addVirtualIndexes(index.keyPath, 0, index);
	                }
	                function findBestIndex(keyPath) {
	                    var result = indexLookup[getKeyPathAlias(keyPath)];
	                    return result && result[0];
	                }
	                function translateRange(range, keyTail) {
	                    return {
	                        type: range.type === 1  ?
	                            2  :
	                            range.type,
	                        lower: pad(range.lower, range.lowerOpen ? down.MAX_KEY : down.MIN_KEY, keyTail),
	                        lowerOpen: true,
	                        upper: pad(range.upper, range.upperOpen ? down.MIN_KEY : down.MAX_KEY, keyTail),
	                        upperOpen: true
	                    };
	                }
	                function translateRequest(req) {
	                    var index = req.query.index;
	                    return index.isVirtual ? __assign(__assign({}, req), { query: {
	                            index: index,
	                            range: translateRange(req.query.range, index.keyTail)
	                        } }) : req;
	                }
	                var result = __assign(__assign({}, table), { schema: __assign(__assign({}, schema), { primaryKey: primaryKey, indexes: allVirtualIndexes, getIndexByKeyPath: findBestIndex }), count: function (req) {
	                        return table.count(translateRequest(req));
	                    }, query: function (req) {
	                        return table.query(translateRequest(req));
	                    }, openCursor: function (req) {
	                        var _a = req.query.index, keyTail = _a.keyTail, isVirtual = _a.isVirtual, keyLength = _a.keyLength;
	                        if (!isVirtual)
	                            return table.openCursor(req);
	                        function createVirtualCursor(cursor) {
	                            function _continue(key) {
	                                key != null ?
	                                    cursor.continue(pad(key, req.reverse ? down.MAX_KEY : down.MIN_KEY, keyTail)) :
	                                    req.unique ?
	                                        cursor.continue(cursor.key.slice(0, keyLength)
	                                            .concat(req.reverse
	                                            ? down.MIN_KEY
	                                            : down.MAX_KEY, keyTail)) :
	                                        cursor.continue();
	                            }
	                            var virtualCursor = Object.create(cursor, {
	                                continue: { value: _continue },
	                                continuePrimaryKey: {
	                                    value: function (key, primaryKey) {
	                                        cursor.continuePrimaryKey(pad(key, down.MAX_KEY, keyTail), primaryKey);
	                                    }
	                                },
	                                primaryKey: {
	                                    get: function () {
	                                        return cursor.primaryKey;
	                                    }
	                                },
	                                key: {
	                                    get: function () {
	                                        var key = cursor.key;
	                                        return keyLength === 1 ?
	                                            key[0] :
	                                            key.slice(0, keyLength);
	                                    }
	                                },
	                                value: {
	                                    get: function () {
	                                        return cursor.value;
	                                    }
	                                }
	                            });
	                            return virtualCursor;
	                        }
	                        return table.openCursor(translateRequest(req))
	                            .then(function (cursor) { return cursor && createVirtualCursor(cursor); });
	                    } });
	                return result;
	            } });
	    }
	    var virtualIndexMiddleware = {
	        stack: "dbcore",
	        name: "VirtualIndexMiddleware",
	        level: 1,
	        create: createVirtualIndexMiddleware
	    };

	    function getObjectDiff(a, b, rv, prfx) {
	        rv = rv || {};
	        prfx = prfx || '';
	        keys(a).forEach(function (prop) {
	            if (!hasOwn(b, prop)) {
	                rv[prfx + prop] = undefined;
	            }
	            else {
	                var ap = a[prop], bp = b[prop];
	                if (typeof ap === 'object' && typeof bp === 'object' && ap && bp) {
	                    var apTypeName = toStringTag(ap);
	                    var bpTypeName = toStringTag(bp);
	                    if (apTypeName !== bpTypeName) {
	                        rv[prfx + prop] = b[prop];
	                    }
	                    else if (apTypeName === 'Object') {
	                        getObjectDiff(ap, bp, rv, prfx + prop + '.');
	                    }
	                    else if (ap !== bp) {
	                        rv[prfx + prop] = b[prop];
	                    }
	                }
	                else if (ap !== bp)
	                    rv[prfx + prop] = b[prop];
	            }
	        });
	        keys(b).forEach(function (prop) {
	            if (!hasOwn(a, prop)) {
	                rv[prfx + prop] = b[prop];
	            }
	        });
	        return rv;
	    }

	    function getEffectiveKeys(primaryKey, req) {
	        if (req.type === 'delete')
	            return req.keys;
	        return req.keys || req.values.map(primaryKey.extractKey);
	    }

	    var hooksMiddleware = {
	        stack: "dbcore",
	        name: "HooksMiddleware",
	        level: 2,
	        create: function (downCore) { return (__assign(__assign({}, downCore), { table: function (tableName) {
	                var downTable = downCore.table(tableName);
	                var primaryKey = downTable.schema.primaryKey;
	                var tableMiddleware = __assign(__assign({}, downTable), { mutate: function (req) {
	                        var dxTrans = PSD.trans;
	                        var _a = dxTrans.table(tableName).hook, deleting = _a.deleting, creating = _a.creating, updating = _a.updating;
	                        switch (req.type) {
	                            case 'add':
	                                if (creating.fire === nop)
	                                    break;
	                                return dxTrans._promise('readwrite', function () { return addPutOrDelete(req); }, true);
	                            case 'put':
	                                if (creating.fire === nop && updating.fire === nop)
	                                    break;
	                                return dxTrans._promise('readwrite', function () { return addPutOrDelete(req); }, true);
	                            case 'delete':
	                                if (deleting.fire === nop)
	                                    break;
	                                return dxTrans._promise('readwrite', function () { return addPutOrDelete(req); }, true);
	                            case 'deleteRange':
	                                if (deleting.fire === nop)
	                                    break;
	                                return dxTrans._promise('readwrite', function () { return deleteRange(req); }, true);
	                        }
	                        return downTable.mutate(req);
	                        function addPutOrDelete(req) {
	                            var dxTrans = PSD.trans;
	                            var keys = req.keys || getEffectiveKeys(primaryKey, req);
	                            if (!keys)
	                                throw new Error("Keys missing");
	                            req = req.type === 'add' || req.type === 'put' ? __assign(__assign({}, req), { keys: keys }) : __assign({}, req);
	                            if (req.type !== 'delete')
	                                req.values = __spreadArray([], req.values, true);
	                            if (req.keys)
	                                req.keys = __spreadArray([], req.keys, true);
	                            return getExistingValues(downTable, req, keys).then(function (existingValues) {
	                                var contexts = keys.map(function (key, i) {
	                                    var existingValue = existingValues[i];
	                                    var ctx = { onerror: null, onsuccess: null };
	                                    if (req.type === 'delete') {
	                                        deleting.fire.call(ctx, key, existingValue, dxTrans);
	                                    }
	                                    else if (req.type === 'add' || existingValue === undefined) {
	                                        var generatedPrimaryKey = creating.fire.call(ctx, key, req.values[i], dxTrans);
	                                        if (key == null && generatedPrimaryKey != null) {
	                                            key = generatedPrimaryKey;
	                                            req.keys[i] = key;
	                                            if (!primaryKey.outbound) {
	                                                setByKeyPath(req.values[i], primaryKey.keyPath, key);
	                                            }
	                                        }
	                                    }
	                                    else {
	                                        var objectDiff = getObjectDiff(existingValue, req.values[i]);
	                                        var additionalChanges_1 = updating.fire.call(ctx, objectDiff, key, existingValue, dxTrans);
	                                        if (additionalChanges_1) {
	                                            var requestedValue_1 = req.values[i];
	                                            Object.keys(additionalChanges_1).forEach(function (keyPath) {
	                                                if (hasOwn(requestedValue_1, keyPath)) {
	                                                    requestedValue_1[keyPath] = additionalChanges_1[keyPath];
	                                                }
	                                                else {
	                                                    setByKeyPath(requestedValue_1, keyPath, additionalChanges_1[keyPath]);
	                                                }
	                                            });
	                                        }
	                                    }
	                                    return ctx;
	                                });
	                                return downTable.mutate(req).then(function (_a) {
	                                    var failures = _a.failures, results = _a.results, numFailures = _a.numFailures, lastResult = _a.lastResult;
	                                    for (var i = 0; i < keys.length; ++i) {
	                                        var primKey = results ? results[i] : keys[i];
	                                        var ctx = contexts[i];
	                                        if (primKey == null) {
	                                            ctx.onerror && ctx.onerror(failures[i]);
	                                        }
	                                        else {
	                                            ctx.onsuccess && ctx.onsuccess(req.type === 'put' && existingValues[i] ?
	                                                req.values[i] :
	                                                primKey
	                                            );
	                                        }
	                                    }
	                                    return { failures: failures, results: results, numFailures: numFailures, lastResult: lastResult };
	                                }).catch(function (error) {
	                                    contexts.forEach(function (ctx) { return ctx.onerror && ctx.onerror(error); });
	                                    return Promise.reject(error);
	                                });
	                            });
	                        }
	                        function deleteRange(req) {
	                            return deleteNextChunk(req.trans, req.range, 10000);
	                        }
	                        function deleteNextChunk(trans, range, limit) {
	                            return downTable.query({ trans: trans, values: false, query: { index: primaryKey, range: range }, limit: limit })
	                                .then(function (_a) {
	                                var result = _a.result;
	                                return addPutOrDelete({ type: 'delete', keys: result, trans: trans }).then(function (res) {
	                                    if (res.numFailures > 0)
	                                        return Promise.reject(res.failures[0]);
	                                    if (result.length < limit) {
	                                        return { failures: [], numFailures: 0, lastResult: undefined };
	                                    }
	                                    else {
	                                        return deleteNextChunk(trans, __assign(__assign({}, range), { lower: result[result.length - 1], lowerOpen: true }), limit);
	                                    }
	                                });
	                            });
	                        }
	                    } });
	                return tableMiddleware;
	            } })); }
	    };
	    function getExistingValues(table, req, effectiveKeys) {
	        return req.type === "add"
	            ? Promise.resolve([])
	            : table.getMany({ trans: req.trans, keys: effectiveKeys, cache: "immutable" });
	    }

	    function getFromTransactionCache(keys, cache, clone) {
	        try {
	            if (!cache)
	                return null;
	            if (cache.keys.length < keys.length)
	                return null;
	            var result = [];
	            for (var i = 0, j = 0; i < cache.keys.length && j < keys.length; ++i) {
	                if (cmp(cache.keys[i], keys[j]) !== 0)
	                    continue;
	                result.push(clone ? deepClone(cache.values[i]) : cache.values[i]);
	                ++j;
	            }
	            return result.length === keys.length ? result : null;
	        }
	        catch (_a) {
	            return null;
	        }
	    }
	    var cacheExistingValuesMiddleware = {
	        stack: "dbcore",
	        level: -1,
	        create: function (core) {
	            return {
	                table: function (tableName) {
	                    var table = core.table(tableName);
	                    return __assign(__assign({}, table), { getMany: function (req) {
	                            if (!req.cache) {
	                                return table.getMany(req);
	                            }
	                            var cachedResult = getFromTransactionCache(req.keys, req.trans["_cache"], req.cache === "clone");
	                            if (cachedResult) {
	                                return DexiePromise.resolve(cachedResult);
	                            }
	                            return table.getMany(req).then(function (res) {
	                                req.trans["_cache"] = {
	                                    keys: req.keys,
	                                    values: req.cache === "clone" ? deepClone(res) : res,
	                                };
	                                return res;
	                            });
	                        }, mutate: function (req) {
	                            if (req.type !== "add")
	                                req.trans["_cache"] = null;
	                            return table.mutate(req);
	                        } });
	                },
	            };
	        },
	    };

	    var _a;
	    function isEmptyRange(node) {
	        return !("from" in node);
	    }
	    var RangeSet = function (fromOrTree, to) {
	        if (this) {
	            extend(this, arguments.length ? { d: 1, from: fromOrTree, to: arguments.length > 1 ? to : fromOrTree } : { d: 0 });
	        }
	        else {
	            var rv = new RangeSet();
	            if (fromOrTree && ("d" in fromOrTree)) {
	                extend(rv, fromOrTree);
	            }
	            return rv;
	        }
	    };
	    props(RangeSet.prototype, (_a = {
	            add: function (rangeSet) {
	                mergeRanges(this, rangeSet);
	                return this;
	            },
	            addKey: function (key) {
	                addRange(this, key, key);
	                return this;
	            },
	            addKeys: function (keys) {
	                var _this = this;
	                keys.forEach(function (key) { return addRange(_this, key, key); });
	                return this;
	            }
	        },
	        _a[iteratorSymbol] = function () {
	            return getRangeSetIterator(this);
	        },
	        _a));
	    function addRange(target, from, to) {
	        var diff = cmp(from, to);
	        if (isNaN(diff))
	            return;
	        if (diff > 0)
	            throw RangeError();
	        if (isEmptyRange(target))
	            return extend(target, { from: from, to: to, d: 1 });
	        var left = target.l;
	        var right = target.r;
	        if (cmp(to, target.from) < 0) {
	            left
	                ? addRange(left, from, to)
	                : (target.l = { from: from, to: to, d: 1, l: null, r: null });
	            return rebalance(target);
	        }
	        if (cmp(from, target.to) > 0) {
	            right
	                ? addRange(right, from, to)
	                : (target.r = { from: from, to: to, d: 1, l: null, r: null });
	            return rebalance(target);
	        }
	        if (cmp(from, target.from) < 0) {
	            target.from = from;
	            target.l = null;
	            target.d = right ? right.d + 1 : 1;
	        }
	        if (cmp(to, target.to) > 0) {
	            target.to = to;
	            target.r = null;
	            target.d = target.l ? target.l.d + 1 : 1;
	        }
	        var rightWasCutOff = !target.r;
	        if (left && !target.l) {
	            mergeRanges(target, left);
	        }
	        if (right && rightWasCutOff) {
	            mergeRanges(target, right);
	        }
	    }
	    function mergeRanges(target, newSet) {
	        function _addRangeSet(target, _a) {
	            var from = _a.from, to = _a.to, l = _a.l, r = _a.r;
	            addRange(target, from, to);
	            if (l)
	                _addRangeSet(target, l);
	            if (r)
	                _addRangeSet(target, r);
	        }
	        if (!isEmptyRange(newSet))
	            _addRangeSet(target, newSet);
	    }
	    function rangesOverlap(rangeSet1, rangeSet2) {
	        var i1 = getRangeSetIterator(rangeSet2);
	        var nextResult1 = i1.next();
	        if (nextResult1.done)
	            return false;
	        var a = nextResult1.value;
	        var i2 = getRangeSetIterator(rangeSet1);
	        var nextResult2 = i2.next(a.from);
	        var b = nextResult2.value;
	        while (!nextResult1.done && !nextResult2.done) {
	            if (cmp(b.from, a.to) <= 0 && cmp(b.to, a.from) >= 0)
	                return true;
	            cmp(a.from, b.from) < 0
	                ? (a = (nextResult1 = i1.next(b.from)).value)
	                : (b = (nextResult2 = i2.next(a.from)).value);
	        }
	        return false;
	    }
	    function getRangeSetIterator(node) {
	        var state = isEmptyRange(node) ? null : { s: 0, n: node };
	        return {
	            next: function (key) {
	                var keyProvided = arguments.length > 0;
	                while (state) {
	                    switch (state.s) {
	                        case 0:
	                            state.s = 1;
	                            if (keyProvided) {
	                                while (state.n.l && cmp(key, state.n.from) < 0)
	                                    state = { up: state, n: state.n.l, s: 1 };
	                            }
	                            else {
	                                while (state.n.l)
	                                    state = { up: state, n: state.n.l, s: 1 };
	                            }
	                        case 1:
	                            state.s = 2;
	                            if (!keyProvided || cmp(key, state.n.to) <= 0)
	                                return { value: state.n, done: false };
	                        case 2:
	                            if (state.n.r) {
	                                state.s = 3;
	                                state = { up: state, n: state.n.r, s: 0 };
	                                continue;
	                            }
	                        case 3:
	                            state = state.up;
	                    }
	                }
	                return { done: true };
	            },
	        };
	    }
	    function rebalance(target) {
	        var _a, _b;
	        var diff = (((_a = target.r) === null || _a === void 0 ? void 0 : _a.d) || 0) - (((_b = target.l) === null || _b === void 0 ? void 0 : _b.d) || 0);
	        var r = diff > 1 ? "r" : diff < -1 ? "l" : "";
	        if (r) {
	            var l = r === "r" ? "l" : "r";
	            var rootClone = __assign({}, target);
	            var oldRootRight = target[r];
	            target.from = oldRootRight.from;
	            target.to = oldRootRight.to;
	            target[r] = oldRootRight[r];
	            rootClone[r] = oldRootRight[l];
	            target[l] = rootClone;
	            rootClone.d = computeDepth(rootClone);
	        }
	        target.d = computeDepth(target);
	    }
	    function computeDepth(_a) {
	        var r = _a.r, l = _a.l;
	        return (r ? (l ? Math.max(r.d, l.d) : r.d) : l ? l.d : 0) + 1;
	    }

	    var observabilityMiddleware = {
	        stack: "dbcore",
	        level: 0,
	        create: function (core) {
	            var dbName = core.schema.name;
	            var FULL_RANGE = new RangeSet(core.MIN_KEY, core.MAX_KEY);
	            return __assign(__assign({}, core), { table: function (tableName) {
	                    var table = core.table(tableName);
	                    var schema = table.schema;
	                    var primaryKey = schema.primaryKey;
	                    var extractKey = primaryKey.extractKey, outbound = primaryKey.outbound;
	                    var tableClone = __assign(__assign({}, table), { mutate: function (req) {
	                            var trans = req.trans;
	                            var mutatedParts = trans.mutatedParts || (trans.mutatedParts = {});
	                            var getRangeSet = function (indexName) {
	                                var part = "idb://" + dbName + "/" + tableName + "/" + indexName;
	                                return (mutatedParts[part] ||
	                                    (mutatedParts[part] = new RangeSet()));
	                            };
	                            var pkRangeSet = getRangeSet("");
	                            var delsRangeSet = getRangeSet(":dels");
	                            var type = req.type;
	                            var _a = req.type === "deleteRange"
	                                ? [req.range]
	                                : req.type === "delete"
	                                    ? [req.keys]
	                                    : req.values.length < 50
	                                        ? [[], req.values]
	                                        : [], keys = _a[0], newObjs = _a[1];
	                            var oldCache = req.trans["_cache"];
	                            return table.mutate(req).then(function (res) {
	                                if (isArray(keys)) {
	                                    if (type !== "delete")
	                                        keys = res.results;
	                                    pkRangeSet.addKeys(keys);
	                                    var oldObjs = getFromTransactionCache(keys, oldCache);
	                                    if (!oldObjs && type !== "add") {
	                                        delsRangeSet.addKeys(keys);
	                                    }
	                                    if (oldObjs || newObjs) {
	                                        trackAffectedIndexes(getRangeSet, schema, oldObjs, newObjs);
	                                    }
	                                }
	                                else if (keys) {
	                                    var range = { from: keys.lower, to: keys.upper };
	                                    delsRangeSet.add(range);
	                                    pkRangeSet.add(range);
	                                }
	                                else {
	                                    pkRangeSet.add(FULL_RANGE);
	                                    delsRangeSet.add(FULL_RANGE);
	                                    schema.indexes.forEach(function (idx) { return getRangeSet(idx.name).add(FULL_RANGE); });
	                                }
	                                return res;
	                            });
	                        } });
	                    var getRange = function (_a) {
	                        var _b, _c;
	                        var _d = _a.query, index = _d.index, range = _d.range;
	                        return [
	                            index,
	                            new RangeSet((_b = range.lower) !== null && _b !== void 0 ? _b : core.MIN_KEY, (_c = range.upper) !== null && _c !== void 0 ? _c : core.MAX_KEY),
	                        ];
	                    };
	                    var readSubscribers = {
	                        get: function (req) { return [primaryKey, new RangeSet(req.key)]; },
	                        getMany: function (req) { return [primaryKey, new RangeSet().addKeys(req.keys)]; },
	                        count: getRange,
	                        query: getRange,
	                        openCursor: getRange,
	                    };
	                    keys(readSubscribers).forEach(function (method) {
	                        tableClone[method] = function (req) {
	                            var subscr = PSD.subscr;
	                            if (subscr) {
	                                var getRangeSet = function (indexName) {
	                                    var part = "idb://" + dbName + "/" + tableName + "/" + indexName;
	                                    return (subscr[part] ||
	                                        (subscr[part] = new RangeSet()));
	                                };
	                                var pkRangeSet_1 = getRangeSet("");
	                                var delsRangeSet_1 = getRangeSet(":dels");
	                                var _a = readSubscribers[method](req), queriedIndex = _a[0], queriedRanges = _a[1];
	                                getRangeSet(queriedIndex.name || "").add(queriedRanges);
	                                if (!queriedIndex.isPrimaryKey) {
	                                    if (method === "count") {
	                                        delsRangeSet_1.add(FULL_RANGE);
	                                    }
	                                    else {
	                                        var keysPromise_1 = method === "query" &&
	                                            outbound &&
	                                            req.values &&
	                                            table.query(__assign(__assign({}, req), { values: false }));
	                                        return table[method].apply(this, arguments).then(function (res) {
	                                            if (method === "query") {
	                                                if (outbound && req.values) {
	                                                    return keysPromise_1.then(function (_a) {
	                                                        var resultingKeys = _a.result;
	                                                        pkRangeSet_1.addKeys(resultingKeys);
	                                                        return res;
	                                                    });
	                                                }
	                                                var pKeys = req.values
	                                                    ? res.result.map(extractKey)
	                                                    : res.result;
	                                                if (req.values) {
	                                                    pkRangeSet_1.addKeys(pKeys);
	                                                }
	                                                else {
	                                                    delsRangeSet_1.addKeys(pKeys);
	                                                }
	                                            }
	                                            else if (method === "openCursor") {
	                                                var cursor_1 = res;
	                                                var wantValues_1 = req.values;
	                                                return (cursor_1 &&
	                                                    Object.create(cursor_1, {
	                                                        key: {
	                                                            get: function () {
	                                                                delsRangeSet_1.addKey(cursor_1.primaryKey);
	                                                                return cursor_1.key;
	                                                            },
	                                                        },
	                                                        primaryKey: {
	                                                            get: function () {
	                                                                var pkey = cursor_1.primaryKey;
	                                                                delsRangeSet_1.addKey(pkey);
	                                                                return pkey;
	                                                            },
	                                                        },
	                                                        value: {
	                                                            get: function () {
	                                                                wantValues_1 && pkRangeSet_1.addKey(cursor_1.primaryKey);
	                                                                return cursor_1.value;
	                                                            },
	                                                        },
	                                                    }));
	                                            }
	                                            return res;
	                                        });
	                                    }
	                                }
	                            }
	                            return table[method].apply(this, arguments);
	                        };
	                    });
	                    return tableClone;
	                } });
	        },
	    };
	    function trackAffectedIndexes(getRangeSet, schema, oldObjs, newObjs) {
	        function addAffectedIndex(ix) {
	            var rangeSet = getRangeSet(ix.name || "");
	            function extractKey(obj) {
	                return obj != null ? ix.extractKey(obj) : null;
	            }
	            var addKeyOrKeys = function (key) { return ix.multiEntry && isArray(key)
	                ? key.forEach(function (key) { return rangeSet.addKey(key); })
	                : rangeSet.addKey(key); };
	            (oldObjs || newObjs).forEach(function (_, i) {
	                var oldKey = oldObjs && extractKey(oldObjs[i]);
	                var newKey = newObjs && extractKey(newObjs[i]);
	                if (cmp(oldKey, newKey) !== 0) {
	                    if (oldKey != null)
	                        addKeyOrKeys(oldKey);
	                    if (newKey != null)
	                        addKeyOrKeys(newKey);
	                }
	            });
	        }
	        schema.indexes.forEach(addAffectedIndex);
	    }

	    var Dexie$1 =  (function () {
	        function Dexie(name, options) {
	            var _this = this;
	            this._middlewares = {};
	            this.verno = 0;
	            var deps = Dexie.dependencies;
	            this._options = options = __assign({
	                addons: Dexie.addons, autoOpen: true,
	                indexedDB: deps.indexedDB, IDBKeyRange: deps.IDBKeyRange }, options);
	            this._deps = {
	                indexedDB: options.indexedDB,
	                IDBKeyRange: options.IDBKeyRange
	            };
	            var addons = options.addons;
	            this._dbSchema = {};
	            this._versions = [];
	            this._storeNames = [];
	            this._allTables = {};
	            this.idbdb = null;
	            this._novip = this;
	            var state = {
	                dbOpenError: null,
	                isBeingOpened: false,
	                onReadyBeingFired: null,
	                openComplete: false,
	                dbReadyResolve: nop,
	                dbReadyPromise: null,
	                cancelOpen: nop,
	                openCanceller: null,
	                autoSchema: true,
	                PR1398_maxLoop: 3
	            };
	            state.dbReadyPromise = new DexiePromise(function (resolve) {
	                state.dbReadyResolve = resolve;
	            });
	            state.openCanceller = new DexiePromise(function (_, reject) {
	                state.cancelOpen = reject;
	            });
	            this._state = state;
	            this.name = name;
	            this.on = Events(this, "populate", "blocked", "versionchange", "close", { ready: [promisableChain, nop] });
	            this.on.ready.subscribe = override(this.on.ready.subscribe, function (subscribe) {
	                return function (subscriber, bSticky) {
	                    Dexie.vip(function () {
	                        var state = _this._state;
	                        if (state.openComplete) {
	                            if (!state.dbOpenError)
	                                DexiePromise.resolve().then(subscriber);
	                            if (bSticky)
	                                subscribe(subscriber);
	                        }
	                        else if (state.onReadyBeingFired) {
	                            state.onReadyBeingFired.push(subscriber);
	                            if (bSticky)
	                                subscribe(subscriber);
	                        }
	                        else {
	                            subscribe(subscriber);
	                            var db_1 = _this;
	                            if (!bSticky)
	                                subscribe(function unsubscribe() {
	                                    db_1.on.ready.unsubscribe(subscriber);
	                                    db_1.on.ready.unsubscribe(unsubscribe);
	                                });
	                        }
	                    });
	                };
	            });
	            this.Collection = createCollectionConstructor(this);
	            this.Table = createTableConstructor(this);
	            this.Transaction = createTransactionConstructor(this);
	            this.Version = createVersionConstructor(this);
	            this.WhereClause = createWhereClauseConstructor(this);
	            this.on("versionchange", function (ev) {
	                if (ev.newVersion > 0)
	                    console.warn("Another connection wants to upgrade database '" + _this.name + "'. Closing db now to resume the upgrade.");
	                else
	                    console.warn("Another connection wants to delete database '" + _this.name + "'. Closing db now to resume the delete request.");
	                _this.close();
	            });
	            this.on("blocked", function (ev) {
	                if (!ev.newVersion || ev.newVersion < ev.oldVersion)
	                    console.warn("Dexie.delete('" + _this.name + "') was blocked");
	                else
	                    console.warn("Upgrade '" + _this.name + "' blocked by other connection holding version " + ev.oldVersion / 10);
	            });
	            this._maxKey = getMaxKey(options.IDBKeyRange);
	            this._createTransaction = function (mode, storeNames, dbschema, parentTransaction) { return new _this.Transaction(mode, storeNames, dbschema, _this._options.chromeTransactionDurability, parentTransaction); };
	            this._fireOnBlocked = function (ev) {
	                _this.on("blocked").fire(ev);
	                connections
	                    .filter(function (c) { return c.name === _this.name && c !== _this && !c._state.vcFired; })
	                    .map(function (c) { return c.on("versionchange").fire(ev); });
	            };
	            this.use(virtualIndexMiddleware);
	            this.use(hooksMiddleware);
	            this.use(observabilityMiddleware);
	            this.use(cacheExistingValuesMiddleware);
	            this.vip = Object.create(this, { _vip: { value: true } });
	            addons.forEach(function (addon) { return addon(_this); });
	        }
	        Dexie.prototype.version = function (versionNumber) {
	            if (isNaN(versionNumber) || versionNumber < 0.1)
	                throw new exceptions.Type("Given version is not a positive number");
	            versionNumber = Math.round(versionNumber * 10) / 10;
	            if (this.idbdb || this._state.isBeingOpened)
	                throw new exceptions.Schema("Cannot add version when database is open");
	            this.verno = Math.max(this.verno, versionNumber);
	            var versions = this._versions;
	            var versionInstance = versions.filter(function (v) { return v._cfg.version === versionNumber; })[0];
	            if (versionInstance)
	                return versionInstance;
	            versionInstance = new this.Version(versionNumber);
	            versions.push(versionInstance);
	            versions.sort(lowerVersionFirst);
	            versionInstance.stores({});
	            this._state.autoSchema = false;
	            return versionInstance;
	        };
	        Dexie.prototype._whenReady = function (fn) {
	            var _this = this;
	            return (this.idbdb && (this._state.openComplete || PSD.letThrough || this._vip)) ? fn() : new DexiePromise(function (resolve, reject) {
	                if (_this._state.openComplete) {
	                    return reject(new exceptions.DatabaseClosed(_this._state.dbOpenError));
	                }
	                if (!_this._state.isBeingOpened) {
	                    if (!_this._options.autoOpen) {
	                        reject(new exceptions.DatabaseClosed());
	                        return;
	                    }
	                    _this.open().catch(nop);
	                }
	                _this._state.dbReadyPromise.then(resolve, reject);
	            }).then(fn);
	        };
	        Dexie.prototype.use = function (_a) {
	            var stack = _a.stack, create = _a.create, level = _a.level, name = _a.name;
	            if (name)
	                this.unuse({ stack: stack, name: name });
	            var middlewares = this._middlewares[stack] || (this._middlewares[stack] = []);
	            middlewares.push({ stack: stack, create: create, level: level == null ? 10 : level, name: name });
	            middlewares.sort(function (a, b) { return a.level - b.level; });
	            return this;
	        };
	        Dexie.prototype.unuse = function (_a) {
	            var stack = _a.stack, name = _a.name, create = _a.create;
	            if (stack && this._middlewares[stack]) {
	                this._middlewares[stack] = this._middlewares[stack].filter(function (mw) {
	                    return create ? mw.create !== create :
	                        name ? mw.name !== name :
	                            false;
	                });
	            }
	            return this;
	        };
	        Dexie.prototype.open = function () {
	            return dexieOpen(this);
	        };
	        Dexie.prototype._close = function () {
	            var state = this._state;
	            var idx = connections.indexOf(this);
	            if (idx >= 0)
	                connections.splice(idx, 1);
	            if (this.idbdb) {
	                try {
	                    this.idbdb.close();
	                }
	                catch (e) { }
	                this._novip.idbdb = null;
	            }
	            state.dbReadyPromise = new DexiePromise(function (resolve) {
	                state.dbReadyResolve = resolve;
	            });
	            state.openCanceller = new DexiePromise(function (_, reject) {
	                state.cancelOpen = reject;
	            });
	        };
	        Dexie.prototype.close = function () {
	            this._close();
	            var state = this._state;
	            this._options.autoOpen = false;
	            state.dbOpenError = new exceptions.DatabaseClosed();
	            if (state.isBeingOpened)
	                state.cancelOpen(state.dbOpenError);
	        };
	        Dexie.prototype.delete = function () {
	            var _this = this;
	            var hasArguments = arguments.length > 0;
	            var state = this._state;
	            return new DexiePromise(function (resolve, reject) {
	                var doDelete = function () {
	                    _this.close();
	                    var req = _this._deps.indexedDB.deleteDatabase(_this.name);
	                    req.onsuccess = wrap(function () {
	                        _onDatabaseDeleted(_this._deps, _this.name);
	                        resolve();
	                    });
	                    req.onerror = eventRejectHandler(reject);
	                    req.onblocked = _this._fireOnBlocked;
	                };
	                if (hasArguments)
	                    throw new exceptions.InvalidArgument("Arguments not allowed in db.delete()");
	                if (state.isBeingOpened) {
	                    state.dbReadyPromise.then(doDelete);
	                }
	                else {
	                    doDelete();
	                }
	            });
	        };
	        Dexie.prototype.backendDB = function () {
	            return this.idbdb;
	        };
	        Dexie.prototype.isOpen = function () {
	            return this.idbdb !== null;
	        };
	        Dexie.prototype.hasBeenClosed = function () {
	            var dbOpenError = this._state.dbOpenError;
	            return dbOpenError && (dbOpenError.name === 'DatabaseClosed');
	        };
	        Dexie.prototype.hasFailed = function () {
	            return this._state.dbOpenError !== null;
	        };
	        Dexie.prototype.dynamicallyOpened = function () {
	            return this._state.autoSchema;
	        };
	        Object.defineProperty(Dexie.prototype, "tables", {
	            get: function () {
	                var _this = this;
	                return keys(this._allTables).map(function (name) { return _this._allTables[name]; });
	            },
	            enumerable: false,
	            configurable: true
	        });
	        Dexie.prototype.transaction = function () {
	            var args = extractTransactionArgs.apply(this, arguments);
	            return this._transaction.apply(this, args);
	        };
	        Dexie.prototype._transaction = function (mode, tables, scopeFunc) {
	            var _this = this;
	            var parentTransaction = PSD.trans;
	            if (!parentTransaction || parentTransaction.db !== this || mode.indexOf('!') !== -1)
	                parentTransaction = null;
	            var onlyIfCompatible = mode.indexOf('?') !== -1;
	            mode = mode.replace('!', '').replace('?', '');
	            var idbMode, storeNames;
	            try {
	                storeNames = tables.map(function (table) {
	                    var storeName = table instanceof _this.Table ? table.name : table;
	                    if (typeof storeName !== 'string')
	                        throw new TypeError("Invalid table argument to Dexie.transaction(). Only Table or String are allowed");
	                    return storeName;
	                });
	                if (mode == "r" || mode === READONLY)
	                    idbMode = READONLY;
	                else if (mode == "rw" || mode == READWRITE)
	                    idbMode = READWRITE;
	                else
	                    throw new exceptions.InvalidArgument("Invalid transaction mode: " + mode);
	                if (parentTransaction) {
	                    if (parentTransaction.mode === READONLY && idbMode === READWRITE) {
	                        if (onlyIfCompatible) {
	                            parentTransaction = null;
	                        }
	                        else
	                            throw new exceptions.SubTransaction("Cannot enter a sub-transaction with READWRITE mode when parent transaction is READONLY");
	                    }
	                    if (parentTransaction) {
	                        storeNames.forEach(function (storeName) {
	                            if (parentTransaction && parentTransaction.storeNames.indexOf(storeName) === -1) {
	                                if (onlyIfCompatible) {
	                                    parentTransaction = null;
	                                }
	                                else
	                                    throw new exceptions.SubTransaction("Table " + storeName +
	                                        " not included in parent transaction.");
	                            }
	                        });
	                    }
	                    if (onlyIfCompatible && parentTransaction && !parentTransaction.active) {
	                        parentTransaction = null;
	                    }
	                }
	            }
	            catch (e) {
	                return parentTransaction ?
	                    parentTransaction._promise(null, function (_, reject) { reject(e); }) :
	                    rejection(e);
	            }
	            var enterTransaction = enterTransactionScope.bind(null, this, idbMode, storeNames, parentTransaction, scopeFunc);
	            return (parentTransaction ?
	                parentTransaction._promise(idbMode, enterTransaction, "lock") :
	                PSD.trans ?
	                    usePSD(PSD.transless, function () { return _this._whenReady(enterTransaction); }) :
	                    this._whenReady(enterTransaction));
	        };
	        Dexie.prototype.table = function (tableName) {
	            if (!hasOwn(this._allTables, tableName)) {
	                throw new exceptions.InvalidTable("Table " + tableName + " does not exist");
	            }
	            return this._allTables[tableName];
	        };
	        return Dexie;
	    }());

	    var symbolObservable = typeof Symbol !== "undefined" && "observable" in Symbol
	        ? Symbol.observable
	        : "@@observable";
	    var Observable =  (function () {
	        function Observable(subscribe) {
	            this._subscribe = subscribe;
	        }
	        Observable.prototype.subscribe = function (x, error, complete) {
	            return this._subscribe(!x || typeof x === "function" ? { next: x, error: error, complete: complete } : x);
	        };
	        Observable.prototype[symbolObservable] = function () {
	            return this;
	        };
	        return Observable;
	    }());

	    function extendObservabilitySet(target, newSet) {
	        keys(newSet).forEach(function (part) {
	            var rangeSet = target[part] || (target[part] = new RangeSet());
	            mergeRanges(rangeSet, newSet[part]);
	        });
	        return target;
	    }

	    function liveQuery(querier) {
	        var hasValue = false;
	        var currentValue = undefined;
	        var observable = new Observable(function (observer) {
	            var scopeFuncIsAsync = isAsyncFunction(querier);
	            function execute(subscr) {
	                if (scopeFuncIsAsync) {
	                    incrementExpectedAwaits();
	                }
	                var exec = function () { return newScope(querier, { subscr: subscr, trans: null }); };
	                var rv = PSD.trans
	                    ?
	                        usePSD(PSD.transless, exec)
	                    : exec();
	                if (scopeFuncIsAsync) {
	                    rv.then(decrementExpectedAwaits, decrementExpectedAwaits);
	                }
	                return rv;
	            }
	            var closed = false;
	            var accumMuts = {};
	            var currentObs = {};
	            var subscription = {
	                get closed() {
	                    return closed;
	                },
	                unsubscribe: function () {
	                    closed = true;
	                    globalEvents.storagemutated.unsubscribe(mutationListener);
	                },
	            };
	            observer.start && observer.start(subscription);
	            var querying = false, startedListening = false;
	            function shouldNotify() {
	                return keys(currentObs).some(function (key) {
	                    return accumMuts[key] && rangesOverlap(accumMuts[key], currentObs[key]);
	                });
	            }
	            var mutationListener = function (parts) {
	                extendObservabilitySet(accumMuts, parts);
	                if (shouldNotify()) {
	                    doQuery();
	                }
	            };
	            var doQuery = function () {
	                if (querying || closed)
	                    return;
	                accumMuts = {};
	                var subscr = {};
	                var ret = execute(subscr);
	                if (!startedListening) {
	                    globalEvents(DEXIE_STORAGE_MUTATED_EVENT_NAME, mutationListener);
	                    startedListening = true;
	                }
	                querying = true;
	                Promise.resolve(ret).then(function (result) {
	                    hasValue = true;
	                    currentValue = result;
	                    querying = false;
	                    if (closed)
	                        return;
	                    if (shouldNotify()) {
	                        doQuery();
	                    }
	                    else {
	                        accumMuts = {};
	                        currentObs = subscr;
	                        observer.next && observer.next(result);
	                    }
	                }, function (err) {
	                    querying = false;
	                    hasValue = false;
	                    observer.error && observer.error(err);
	                    subscription.unsubscribe();
	                });
	            };
	            doQuery();
	            return subscription;
	        });
	        observable.hasValue = function () { return hasValue; };
	        observable.getValue = function () { return currentValue; };
	        return observable;
	    }

	    var domDeps;
	    try {
	        domDeps = {
	            indexedDB: _global.indexedDB || _global.mozIndexedDB || _global.webkitIndexedDB || _global.msIndexedDB,
	            IDBKeyRange: _global.IDBKeyRange || _global.webkitIDBKeyRange
	        };
	    }
	    catch (e) {
	        domDeps = { indexedDB: null, IDBKeyRange: null };
	    }

	    var Dexie = Dexie$1;
	    props(Dexie, __assign(__assign({}, fullNameExceptions), {
	        delete: function (databaseName) {
	            var db = new Dexie(databaseName, { addons: [] });
	            return db.delete();
	        },
	        exists: function (name) {
	            return new Dexie(name, { addons: [] }).open().then(function (db) {
	                db.close();
	                return true;
	            }).catch('NoSuchDatabaseError', function () { return false; });
	        },
	        getDatabaseNames: function (cb) {
	            try {
	                return getDatabaseNames(Dexie.dependencies).then(cb);
	            }
	            catch (_a) {
	                return rejection(new exceptions.MissingAPI());
	            }
	        },
	        defineClass: function () {
	            function Class(content) {
	                extend(this, content);
	            }
	            return Class;
	        }, ignoreTransaction: function (scopeFunc) {
	            return PSD.trans ?
	                usePSD(PSD.transless, scopeFunc) :
	                scopeFunc();
	        }, vip: vip, async: function (generatorFn) {
	            return function () {
	                try {
	                    var rv = awaitIterator(generatorFn.apply(this, arguments));
	                    if (!rv || typeof rv.then !== 'function')
	                        return DexiePromise.resolve(rv);
	                    return rv;
	                }
	                catch (e) {
	                    return rejection(e);
	                }
	            };
	        }, spawn: function (generatorFn, args, thiz) {
	            try {
	                var rv = awaitIterator(generatorFn.apply(thiz, args || []));
	                if (!rv || typeof rv.then !== 'function')
	                    return DexiePromise.resolve(rv);
	                return rv;
	            }
	            catch (e) {
	                return rejection(e);
	            }
	        },
	        currentTransaction: {
	            get: function () { return PSD.trans || null; }
	        }, waitFor: function (promiseOrFunction, optionalTimeout) {
	            var promise = DexiePromise.resolve(typeof promiseOrFunction === 'function' ?
	                Dexie.ignoreTransaction(promiseOrFunction) :
	                promiseOrFunction)
	                .timeout(optionalTimeout || 60000);
	            return PSD.trans ?
	                PSD.trans.waitFor(promise) :
	                promise;
	        },
	        Promise: DexiePromise,
	        debug: {
	            get: function () { return debug; },
	            set: function (value) {
	                setDebug(value, value === 'dexie' ? function () { return true; } : dexieStackFrameFilter);
	            }
	        },
	        derive: derive, extend: extend, props: props, override: override,
	        Events: Events, on: globalEvents, liveQuery: liveQuery, extendObservabilitySet: extendObservabilitySet,
	        getByKeyPath: getByKeyPath, setByKeyPath: setByKeyPath, delByKeyPath: delByKeyPath, shallowClone: shallowClone, deepClone: deepClone, getObjectDiff: getObjectDiff, cmp: cmp, asap: asap$1,
	        minKey: minKey,
	        addons: [],
	        connections: connections,
	        errnames: errnames,
	        dependencies: domDeps,
	        semVer: DEXIE_VERSION, version: DEXIE_VERSION.split('.')
	            .map(function (n) { return parseInt(n); })
	            .reduce(function (p, c, i) { return p + (c / Math.pow(10, i * 2)); }) }));
	    Dexie.maxKey = getMaxKey(Dexie.dependencies.IDBKeyRange);

	    if (typeof dispatchEvent !== 'undefined' && typeof addEventListener !== 'undefined') {
	        globalEvents(DEXIE_STORAGE_MUTATED_EVENT_NAME, function (updatedParts) {
	            if (!propagatingLocally) {
	                var event_1;
	                if (isIEOrEdge) {
	                    event_1 = document.createEvent('CustomEvent');
	                    event_1.initCustomEvent(STORAGE_MUTATED_DOM_EVENT_NAME, true, true, updatedParts);
	                }
	                else {
	                    event_1 = new CustomEvent(STORAGE_MUTATED_DOM_EVENT_NAME, {
	                        detail: updatedParts
	                    });
	                }
	                propagatingLocally = true;
	                dispatchEvent(event_1);
	                propagatingLocally = false;
	            }
	        });
	        addEventListener(STORAGE_MUTATED_DOM_EVENT_NAME, function (_a) {
	            var detail = _a.detail;
	            if (!propagatingLocally) {
	                propagateLocally(detail);
	            }
	        });
	    }
	    function propagateLocally(updateParts) {
	        var wasMe = propagatingLocally;
	        try {
	            propagatingLocally = true;
	            globalEvents.storagemutated.fire(updateParts);
	        }
	        finally {
	            propagatingLocally = wasMe;
	        }
	    }
	    var propagatingLocally = false;

	    if (typeof BroadcastChannel !== 'undefined') {
	        var bc_1 = new BroadcastChannel(STORAGE_MUTATED_DOM_EVENT_NAME);
	        if (typeof bc_1.unref === 'function') {
	            bc_1.unref();
	        }
	        globalEvents(DEXIE_STORAGE_MUTATED_EVENT_NAME, function (changedParts) {
	            if (!propagatingLocally) {
	                bc_1.postMessage(changedParts);
	            }
	        });
	        bc_1.onmessage = function (ev) {
	            if (ev.data)
	                propagateLocally(ev.data);
	        };
	    }
	    else if (typeof self !== 'undefined' && typeof navigator !== 'undefined') {
	        globalEvents(DEXIE_STORAGE_MUTATED_EVENT_NAME, function (changedParts) {
	            try {
	                if (!propagatingLocally) {
	                    if (typeof localStorage !== 'undefined') {
	                        localStorage.setItem(STORAGE_MUTATED_DOM_EVENT_NAME, JSON.stringify({
	                            trig: Math.random(),
	                            changedParts: changedParts,
	                        }));
	                    }
	                    if (typeof self['clients'] === 'object') {
	                        __spreadArray([], self['clients'].matchAll({ includeUncontrolled: true }), true).forEach(function (client) {
	                            return client.postMessage({
	                                type: STORAGE_MUTATED_DOM_EVENT_NAME,
	                                changedParts: changedParts,
	                            });
	                        });
	                    }
	                }
	            }
	            catch (_a) { }
	        });
	        if (typeof addEventListener !== 'undefined') {
	            addEventListener('storage', function (ev) {
	                if (ev.key === STORAGE_MUTATED_DOM_EVENT_NAME) {
	                    var data = JSON.parse(ev.newValue);
	                    if (data)
	                        propagateLocally(data.changedParts);
	                }
	            });
	        }
	        var swContainer = self.document && navigator.serviceWorker;
	        if (swContainer) {
	            swContainer.addEventListener('message', propagateMessageLocally);
	        }
	    }
	    function propagateMessageLocally(_a) {
	        var data = _a.data;
	        if (data && data.type === STORAGE_MUTATED_DOM_EVENT_NAME) {
	            propagateLocally(data.changedParts);
	        }
	    }

	    DexiePromise.rejectionMapper = mapError;
	    setDebug(debug, dexieStackFrameFilter);

	    var namedExports = /*#__PURE__*/Object.freeze({
	        __proto__: null,
	        Dexie: Dexie$1,
	        liveQuery: liveQuery,
	        'default': Dexie$1,
	        RangeSet: RangeSet,
	        mergeRanges: mergeRanges,
	        rangesOverlap: rangesOverlap
	    });

	    __assign(Dexie$1, namedExports, { default: Dexie$1 });

	    return Dexie$1;

	}));
	
} (dexie, dexieExports));

var Dexie = dexieExports;

var _templateObject$2, _templateObject2$2, _templateObject3$2;
function ownKeys$3(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$3(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$3(Object(t), !0).forEach(function (r) { _defineProperty$3(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$3(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$2(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$3(e, r, t) { return (r = _toPropertyKey$3(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$3(t) { var i = _toPrimitive$3(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$3(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Media options type
 */

/**
 *
 */
class SmallPartMediaRecorder extends Et2Widget(s) {
  /**
   * video encoded mime type
   */
  static MimeType() {
    if (navigator.userAgent.match(/firefox/i) && !navigator.userAgent.match(/chrome/i)) {
      return "video/webm";
    }
    return "video/webm;codecs=vp9,opus";
  }

  /**
   * video db structure
   * id: auto increamental
   * data: blob of recorded video
   * offset: offset position of the blob (chunk) in bytes, offset 0 blob contains the header of the video
   * uploaded: flag to keep track of the chunk that being uploaded successfuly to the server
   */

  static get styles() {
    return [super.styles, shoelace, i(_templateObject$2 || (_templateObject$2 = _taggedTemplateLiteral$2(["\n\t\t\t:host {\n\t\t\t  width: 100%;\n\t\t\t  display: inherit;\n\t\t\t}\n\t\t"])))];
  }
  static get properties() {
    return _objectSpread$3(_objectSpread$3({}, super.properties), {}, {
      /**
       * video name
       */
      videoName: {
        type: String
      },
      /**
       * custom constrains to be set for MediaRecorder
       * @default it's set by user via select media
       */
      constrains: {
        type: Object
      },
      /**
       * automatic upload to the server while recording the video
       * @default false
       */
      autoUpload: {
        type: Boolean
      },
      /**
       * disable/enable media selectors selectboxes (video & audio)
       * @default false
       */
      disableMediaSelectors: {
        type: Boolean
      },
      /**
       * hide/show media selectors selectboxes (video & audio)
       * @default false
       */
      hideMediaSelectors: {
        type: Boolean
      }
    });
  }
  constructor() {
    super(...arguments);
    /**
     * MediaRecorder recorder
     * @protected
     */
    _defineProperty$3(this, "_recorder", null);
    /**
     * Media options
     * @protected
     */
    _defineProperty$3(this, "_mediaOptions", {
      video: [],
      audio: []
    });
    /**
     * contians video source MediaStream
     * @protected
     */
    _defineProperty$3(this, "_stream", null);
    /**
     * interval period to call ondataavailable event
     * @protected
     */
    _defineProperty$3(this, "_recordInterval", 10000);
    /**
     * interval to send the recorded chuncks to server
     * @protected
     */
    _defineProperty$3(this, "_uploadInterval", null);
    /**
     * interval period to send the recorded chuncks to server
     * @protected
     */
    _defineProperty$3(this, "_uploadIntervalTimeout", 5000);
    /**
     * keeps the last recorded chunk offset
     * @protected
     */
    _defineProperty$3(this, "_lastChunkOffset", 0);
    /**
     * keeps number of recorded chunks in db
     * @protected
     */
    _defineProperty$3(this, "_recordedChunks", 0);
    /**
     * keeps number of upload chunks (reads them from db.uploaded)
     * @protected
     */
    _defineProperty$3(this, "_uploadedChunks", 0);
    /**
     * keeps number of waiting for being uploaded chunks (max in queue is 10 chunks)
     * @protected
     */
    _defineProperty$3(this, "_queuedChunks", []);
    /**
     * db instance
     * @protected
     */
    _defineProperty$3(this, "_db", null);
    this.constraints = null;
    this.videoName = '';
    this.autoUpload = false;
    this.disableMediaSelectors = false;
  }
  firstUpdated() {
    super.firstUpdated();

    // we don't want user being prompted for device permissions while the widget is not visible (either hidden or disabled)
    if (!this.disabled && !this.hidden) {
      this._db = new Dexie(this.id);
      this._db.version(1).stores(SmallPartMediaRecorder.DbTable);
      this._db.video.clear();
      navigator.mediaDevices.getUserMedia({
        video: true,
        audio: true
      }).then(() => {
        this._fetchOptions().then(_options => {
          this._mediaOptions = _options;
          this.constraints = null;
          this.requestUpdate();
        });
      }).catch(this._errorHandler.bind(this));
    }
  }
  connectedCallback() {
    super.connectedCallback();
    window.addEventListener('beforeunload', e => {
      var _this$_recorder;
      if (((_this$_recorder = this._recorder) === null || _this$_recorder === void 0 ? void 0 : _this$_recorder.state) != 'recording') {
        return;
      }
      this.egw().message(this.egw().lang("There is an active recording session running! Leaving this page would potentially cause data loss, are you sure that you want to leave?"), "warning");

      // Cancel the event
      e.preventDefault();
      e.returnValue = '';
      return "";
    });
  }
  set constraints(_constraints) {
    var constraints = _constraints !== null && _constraints !== void 0 ? _constraints : {
      video: true,
      audio: true
    };
    if (this._mediaOptions.audio.length || this._mediaOptions.video.length) {
      navigator.mediaDevices.getUserMedia(constraints).then(_stream => {
        this._stream = _stream;
        this.requestUpdate();
      });
    }
  }
  render() {
    var _this$_videoNode, _this$_videoNode2, _this$_recorder2, _this$_mediaOptions$v, _this$_mediaOptions$a, _this$_stream;
    var captureStream = ((_this$_videoNode = this._videoNode) === null || _this$_videoNode === void 0 ? void 0 : _this$_videoNode.captureStream) || ((_this$_videoNode2 = this._videoNode) === null || _this$_videoNode2 === void 0 ? void 0 : _this$_videoNode2.mozCaptureStream) || null;
    var showRecording = ((_this$_recorder2 = this._recorder) === null || _this$_recorder2 === void 0 ? void 0 : _this$_recorder2.state) == 'recording';
    var mediaSelectors = !this.hideMediaSelectors ? x(_templateObject2$2 || (_templateObject2$2 = _taggedTemplateLiteral$2(["\n            <et2-hbox>\n                <et2-select\n                        label=\"", "\"\n                        class=\"select-video-source\"\n                        @change=", "\n                        .disabled=", "\n                        .hidden=", "\n                        .select_options=", ">\n                </et2-select>\n                <et2-select\n                        label=\"", "\"\n                        class=\"select-audio-source\"\n                        @change=", "\n                        .disabled=", "\n                        .hidden=", "\n                        .select_options=", ">\n                </et2-select>\n            </et2-hbox>"])), this.egw().lang("Video Source"), this._streamChanged, this.disableMediaSelectors, this.hideMediaSelectors, (_this$_mediaOptions$v = this._mediaOptions.video) !== null && _this$_mediaOptions$v !== void 0 ? _this$_mediaOptions$v : [], this.egw().lang("Audio Source"), this._streamChanged, this.disableMediaSelectors, this.hideMediaSelectors, (_this$_mediaOptions$a = this._mediaOptions.audio) !== null && _this$_mediaOptions$a !== void 0 ? _this$_mediaOptions$a : []) : A;
    return x(_templateObject3$2 || (_templateObject3$2 = _taggedTemplateLiteral$2(["\n            <div part=\"base\" .constraints=", ">\n                <et2-vbox>\n                    ", "\n                    <video part=\"video\"\n\t\t\t\t\t\t\t.srcObject=", "\n\t\t\t\t\t\t\tclass=\"video-media\"\n\t\t\t\t\t\t\tautoplay=\"true\"\n\t\t\t\t\t\t\t.captureStream=", "\n\t\t\t\t\t\t\tmuted=\"true\">\n\t\t\t\t\t</video>\n\t\t\t\t\t<et2-hbox>\n\t\t\t\t\t\t<et2-hbox .disabled=", ">\n\t\t\t\t\t\t\t<sl-animation easing=\"linear\" playbackRate=\"0.5\" duration=\"2000\" name=\"flash\" play><sl-icon name=\"record-circle\" class=\"recorderIcon\" style=\"height: auto;color:red;\"></sl-icon></sl-animation>\n                            <et2-description value=\"Recording ...\"></et2-description>\n                            <et2-hbox>\n\t\t\t\t\t\t\t\t<et2-label value=\"Recorded Chunks\" label=\"%s:\"></et2-label>\n\t\t\t\t\t\t\t\t<et2-label class=\"recorded\" value=\"0\"></et2-label>\n                                <et2-button-icon\n                                        title=", "\n                                        image=\"box-arrow-down\"\n                                        @click=", "\n                                        class=\"button-download\"\n                                        .disabled=", "\n                                        noSubmit=\"true\"></et2-button-icon>\n                                <et2-label value=\"Uploaded Chunks\" label=\"%s:\"></et2-label>\n                                <et2-label class=\"uploaded\" value=\"0/0\"></et2-label>\n\t\t\t\t\t\t\t</et2-hbox>\n\t\t\t\t\t\t</et2-hbox>\n\t\t\t\t\t</et2-hbox>\n\t\t\t\t</et2-vbox>\n            </div> "])), this.constraints, mediaSelectors, (_this$_stream = this._stream) !== null && _this$_stream !== void 0 ? _this$_stream : null, captureStream, !showRecording, this.egw().lang('download'), this._downloadHandler, !this._recorder);
  }
  destroy() {
    clearInterval(this._uploadInterval);
    this.stopMedia();
  }

  /**
   * stop media stream
   */
  stopMedia() {
    if (this._videoNode.srcObject) {
      this._videoNode.srcObject.getTracks().forEach(track => track.stop());
      this._videoNode.srcObject = null;
    }
  }

  /**
   * start recording
   * @return returns a promise to make sure the media is established then recording gets started
   */
  record() {
    return new Promise(_resolve => {
      if (this._stream) {
        this._recorder = new MediaRecorder(this._stream, {
          mimeType: SmallPartMediaRecorder.MimeType()
        });
        this.requestUpdate();
        this._recorder.start(this._recordInterval);
        if (this.autoUpload) this._initUploadStream();
        this._recorder.ondataavailable = event => {
          if (event.data.size > 1) {
            console.log(' Recorded chunk of size ' + event.data.size + "B");
            this._db.video.add({
              data: event.data,
              offset: this._lastChunkOffset,
              uploaded: 0
            }).catch(this._dbErrorHandler);
            this._db.video.count().then(_count => {
              this._recordedChunks = _count;
              this.__updateUploadIndication();
            }).catch(this._dbErrorHandler);
            this._lastChunkOffset += event.data.size;
          }
        };
        this._videoNode.addEventListener('loadedmetadata', () => {
          _resolve();
        });
      }
    });
  }

  /**
   * Check if the uploading is done
   * @private
   * @return return a promise
   */
  uploadingIsfinished() {
    return new Promise(_resolve => {
      if (!this.autoUpload) {
        _resolve();
        return;
      }
      var interval = setInterval(() => {
        var _this$_recorder3;
        if (((_this$_recorder3 = this._recorder) === null || _this$_recorder3 === void 0 ? void 0 : _this$_recorder3.state) == 'inactive' && this._recordedChunks == this._uploadedChunks) {
          clearInterval(interval);
          _resolve();
        }
      }, 100);
    });
  }

  /**
   * offer download if there was a recording
   */
  download() {
    if (this._recorder) {
      this.uploadingIsfinished().then(this._downloadHandler.bind(this));
    }
  }

  /**
   * stop recording
   * @return returns a promise, to make sure the recording has stopped
   */
  stop() {
    return new Promise(_resolved => {
      if (this._videoNode && this._recorder) {
        this._recorder.onstop = () => {
          if (this.autoUpload) {
            _resolved();
          } else {
            _resolved();
            // always offer a download for none auto upload mode
            this._downloadHandler();
          }
        };
        if (this._recorder.state === 'recording') {
          this._recorder.stop();
          this.requestUpdate();
        }
      }
    });
  }

  /**
   * @return <promise>
   * @protected
   */
  _fetchOptions() {
    return new Promise(resolve => {
      this._getDevices().then(_devices => {
        var _options = {
          video: [],
          audio: []
        };
        _devices.forEach(_device => {
          switch (_device.kind) {
            case 'audioinput':
              _options.audio.push({
                value: _device.deviceId,
                label: _device.label
              });
              break;
            case 'videoinput':
              _options.video.push({
                value: _device.deviceId,
                label: _device.label
              });
              break;
          }
        });
        resolve(_options);
      });
    });
  }

  /**
   * Media recorder error handler
   * @param _err MediaDevices Exceptions
   * @protected
   */
  _errorHandler(_err) {
    var msg = '';
    switch (_err.code) {
      case 8:
        msg = this.egw().lang('Can not find any connected device to the browser. Please make sure your camera is properly connected to the browser.');
        break;
    }
    this.egw().message(msg, 'error');
  }

  /**
   * Register indexed Db (Dexie) errors into console logs
   * @param _error DixieError
   * @protected
   */
  _dbErrorHandler(_error) {
    var msg = '';
    switch (_error.name) {
      case Dexie.errnames.Schema:
        msg = "Schemad error";
        console.error(msg);
        break;
      default:
        msg = _error.message;
        console.error("error: " + msg);
    }
    this.egw().message("Something went wrong with Recording! ".concat(msg), "error");
  }

  /**
   * hendle download given video blob
   * @param _data
   * @private
   */
  _downloadHandler() {
    var _this$_recorder4;
    if (((_this$_recorder4 = this._recorder) === null || _this$_recorder4 === void 0 ? void 0 : _this$_recorder4.state) == 'recording') this._recorder.requestData();
    this._db.video.orderBy('offset').toArray().then(_data => {
      var _this$videoName;
      var blobs = [];
      _data.forEach(_item => {
        blobs.push(_item.data);
      });
      var blob = new Blob(blobs, {
        type: SmallPartMediaRecorder.MimeType()
      });
      var a = document.createElement('a');
      a.download = (_this$videoName = this.videoName) !== null && _this$videoName !== void 0 ? _this$videoName : ['livefeedback_', (new Date() + '').slice(4, 33), '.webm'].join('');
      a.href = URL.createObjectURL(blob);
      a.click();
    }).catch(this._dbErrorHandler);
  }

  /**
   * get video
   * @private
   */
  _getDevices() {
    return navigator.mediaDevices.enumerateDevices();
  }

  /**
   * get video selectbox dom node
   * @return HTMLSelectElement | null
   */
  get _videoSourceNode() {
    return this.shadowRoot ? this.shadowRoot.querySelector('.select-video-source') : null;
  }

  /**
   * get audio selectbox dom node
   * @return HTMLSelectElement | null
   */
  get _audioSourceNode() {
    return this.shadowRoot ? this.shadowRoot.querySelector('.select-audio-source') : null;
  }

  /**
   * get <video> dom node
   * @return HTMLVideoElement|null
   */
  get _videoNode() {
    return this.shadowRoot ? this.shadowRoot.querySelector('.video-media') : null;
  }
  _streamChanged() {
    this.constraints = {
      audio: {
        deviceId: this._audioSourceNode.value ? {
          exact: this._audioSourceNode.value
        } : false
      },
      video: {
        deviceId: this._videoSourceNode.value ? {
          exact: this._videoSourceNode.value
        } : false
      }
    };
  }

  /**
   * initialize interval for uploading
   * @private
   */
  _initUploadStream() {
    // make sure not triggering it if we are not in autoUpload mode
    if (!this.autoUpload) return;
    this._uploadInterval = setInterval(_ => {
      if (this._queuedChunks.length == 0) {
        this._db.video.where({
          uploaded: 0
        }).limit(10).toArray().then(_values => {
          this._queuedChunks = _values;
        }).catch(this._dbErrorHandler);
      }
      if (this._queuedChunks.length > 0) {
        var chunk = this._queuedChunks.shift();
        this._buildRequest(chunk).then(this.__resolvedRequest.bind(this)).catch(this._dbErrorHandler);
      }
      this.__updateUploadIndication();
    }, this._uploadIntervalTimeout);
  }
  __updateUploadIndication() {
    var uploaded = this.autoUpload ? this._uploadedChunks : this.egw().lang('auto upload is deactive');
    this.shadowRoot.querySelector('.uploaded').value = "".concat(uploaded, "/ ").concat(this._recordedChunks);
    this.shadowRoot.querySelector('.recorded').value = "".concat(this._recordedChunks);
  }

  /**
   * resolver of request's promise
   * @param _offset
   * @private
   */
  __resolvedRequest(_offset) {
    this._db.video.where({
      offset: _offset
    }).modify({
      uploaded: 1
    }).catch(this._dbErrorHandler);
    this._db.video.where({
      uploaded: 1
    }).count(_count => {
      this._uploadedChunks = _count;
    }).catch(this._dbErrorHandler);
  }
  _buildRequest(_data) {
    return new Promise(_resolve => {
      var content = app.smallpart.et2.getArrayMgr('content').data;
      var xhr = new XMLHttpRequest();
      var file = new FormData();
      file.append('file', _data.data);
      file.append('data', JSON.stringify({
        video: content.video,
        offset: _data.offset
      }));
      xhr.onerror = () => {
        var _this$_queuedChunks$l;
        // retry to send the request again
        window.setTimeout(() => {
          this._db.video.where({
            offset: _data.offset
          }).toArray().then(_value => {
            // check first the status then retry
            if (!(_value !== null && _value !== void 0 && _value.uploaded)) {
              this._buildRequest(_data).then(this.__resolvedRequest.bind(this));
            }
          }).catch(this._dbErrorHandler);
        }, 1000 * ((_this$_queuedChunks$l = this._queuedChunks.length) !== null && _this$_queuedChunks$l !== void 0 ? _this$_queuedChunks$l : 1)); // decrease the retry ratio base on queued chunks
      };
      xhr.onreadystatechange = () => {
        if (xhr.readyState == 4 && xhr.status == 200) {
          _resolve(_data.offset);
        }
      };
      xhr.open('POST', egw.ajaxUrl('EGroupware\\smallpart\\Widgets\\SmallPartMediaRecorder::ajax_upload'), true);
      xhr.send(file);
    });
  }
}
_defineProperty$3(SmallPartMediaRecorder, "DbTable", {
  video: "++id,data,offset,uploaded"
});
customElements.define("smallpart-media-recorder", SmallPartMediaRecorder);

var chart_minExports = {};
var chart_min$1 = {
  get exports(){ return chart_minExports; },
  set exports(v){ chart_minExports = v; },
};

/*!
 * Chart.js v3.9.1
 * https://www.chartjs.org
 * (c) 2022 Chart.js Contributors
 * Released under the MIT License
 */

(function (module, exports) {
	!function(t,e){"object"=='object'&&"undefined"!='object'?module.exports=e():"function"==typeof undefined&&undefined.amd?undefined(e):(t="undefined"!=typeof globalThis?globalThis:t||self).Chart=e();}(commonjsGlobal,(function(){"use strict";function t(){}const e=function(){let t=0;return function(){return t++}}();function i(t){return null==t}function s(t){if(Array.isArray&&Array.isArray(t))return !0;const e=Object.prototype.toString.call(t);return "[object"===e.slice(0,7)&&"Array]"===e.slice(-6)}function n(t){return null!==t&&"[object Object]"===Object.prototype.toString.call(t)}const o=t=>("number"==typeof t||t instanceof Number)&&isFinite(+t);function a(t,e){return o(t)?t:e}function r(t,e){return void 0===t?e:t}const l=(t,e)=>"string"==typeof t&&t.endsWith("%")?parseFloat(t)/100:t/e,h=(t,e)=>"string"==typeof t&&t.endsWith("%")?parseFloat(t)/100*e:+t;function c(t,e,i){if(t&&"function"==typeof t.call)return t.apply(i,e)}function d(t,e,i,o){let a,r,l;if(s(t))if(r=t.length,o)for(a=r-1;a>=0;a--)e.call(i,t[a],a);else for(a=0;a<r;a++)e.call(i,t[a],a);else if(n(t))for(l=Object.keys(t),r=l.length,a=0;a<r;a++)e.call(i,t[l[a]],l[a]);}function u(t,e){let i,s,n,o;if(!t||!e||t.length!==e.length)return !1;for(i=0,s=t.length;i<s;++i)if(n=t[i],o=e[i],n.datasetIndex!==o.datasetIndex||n.index!==o.index)return !1;return !0}function f(t){if(s(t))return t.map(f);if(n(t)){const e=Object.create(null),i=Object.keys(t),s=i.length;let n=0;for(;n<s;++n)e[i[n]]=f(t[i[n]]);return e}return t}function g(t){return -1===["__proto__","prototype","constructor"].indexOf(t)}function p(t,e,i,s){if(!g(t))return;const o=e[t],a=i[t];n(o)&&n(a)?m(o,a,s):e[t]=f(a);}function m(t,e,i){const o=s(e)?e:[e],a=o.length;if(!n(t))return t;const r=(i=i||{}).merger||p;for(let s=0;s<a;++s){if(!n(e=o[s]))continue;const a=Object.keys(e);for(let s=0,n=a.length;s<n;++s)r(a[s],t,e,i);}return t}function b(t,e){return m(t,e,{merger:x})}function x(t,e,i){if(!g(t))return;const s=e[t],o=i[t];n(s)&&n(o)?b(s,o):Object.prototype.hasOwnProperty.call(e,t)||(e[t]=f(o));}const _={"":t=>t,x:t=>t.x,y:t=>t.y};function y(t,e){const i=_[e]||(_[e]=function(t){const e=v(t);return t=>{for(const i of e){if(""===i)break;t=t&&t[i];}return t}}(e));return i(t)}function v(t){const e=t.split("."),i=[];let s="";for(const t of e)s+=t,s.endsWith("\\")?s=s.slice(0,-1)+".":(i.push(s),s="");return i}function w(t){return t.charAt(0).toUpperCase()+t.slice(1)}const M=t=>void 0!==t,k=t=>"function"==typeof t,S=(t,e)=>{if(t.size!==e.size)return !1;for(const i of t)if(!e.has(i))return !1;return !0};function P(t){return "mouseup"===t.type||"click"===t.type||"contextmenu"===t.type}const D=Math.PI,O=2*D,C=O+D,A=Number.POSITIVE_INFINITY,T=D/180,L=D/2,E=D/4,R=2*D/3,I=Math.log10,z=Math.sign;function F(t){const e=Math.round(t);t=N(t,e,t/1e3)?e:t;const i=Math.pow(10,Math.floor(I(t))),s=t/i;return (s<=1?1:s<=2?2:s<=5?5:10)*i}function V(t){const e=[],i=Math.sqrt(t);let s;for(s=1;s<i;s++)t%s==0&&(e.push(s),e.push(t/s));return i===(0|i)&&e.push(i),e.sort(((t,e)=>t-e)).pop(),e}function B(t){return !isNaN(parseFloat(t))&&isFinite(t)}function N(t,e,i){return Math.abs(t-e)<i}function W(t,e){const i=Math.round(t);return i-e<=t&&i+e>=t}function j(t,e,i){let s,n,o;for(s=0,n=t.length;s<n;s++)o=t[s][i],isNaN(o)||(e.min=Math.min(e.min,o),e.max=Math.max(e.max,o));}function H(t){return t*(D/180)}function $(t){return t*(180/D)}function Y(t){if(!o(t))return;let e=1,i=0;for(;Math.round(t*e)/e!==t;)e*=10,i++;return i}function U(t,e){const i=e.x-t.x,s=e.y-t.y,n=Math.sqrt(i*i+s*s);let o=Math.atan2(s,i);return o<-.5*D&&(o+=O),{angle:o,distance:n}}function X(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function q(t,e){return (t-e+C)%O-D}function K(t){return (t%O+O)%O}function G(t,e,i,s){const n=K(t),o=K(e),a=K(i),r=K(o-n),l=K(a-n),h=K(n-o),c=K(n-a);return n===o||n===a||s&&o===a||r>l&&h<c}function Z(t,e,i){return Math.max(e,Math.min(i,t))}function J(t){return Z(t,-32768,32767)}function Q(t,e,i,s=1e-6){return t>=Math.min(e,i)-s&&t<=Math.max(e,i)+s}function tt(t,e,i){i=i||(i=>t[i]<e);let s,n=t.length-1,o=0;for(;n-o>1;)s=o+n>>1,i(s)?o=s:n=s;return {lo:o,hi:n}}const et=(t,e,i,s)=>tt(t,i,s?s=>t[s][e]<=i:s=>t[s][e]<i),it=(t,e,i)=>tt(t,i,(s=>t[s][e]>=i));function st(t,e,i){let s=0,n=t.length;for(;s<n&&t[s]<e;)s++;for(;n>s&&t[n-1]>i;)n--;return s>0||n<t.length?t.slice(s,n):t}const nt=["push","pop","shift","splice","unshift"];function ot(t,e){t._chartjs?t._chartjs.listeners.push(e):(Object.defineProperty(t,"_chartjs",{configurable:!0,enumerable:!1,value:{listeners:[e]}}),nt.forEach((e=>{const i="_onData"+w(e),s=t[e];Object.defineProperty(t,e,{configurable:!0,enumerable:!1,value(...e){const n=s.apply(this,e);return t._chartjs.listeners.forEach((t=>{"function"==typeof t[i]&&t[i](...e);})),n}});})));}function at(t,e){const i=t._chartjs;if(!i)return;const s=i.listeners,n=s.indexOf(e);-1!==n&&s.splice(n,1),s.length>0||(nt.forEach((e=>{delete t[e];})),delete t._chartjs);}function rt(t){const e=new Set;let i,s;for(i=0,s=t.length;i<s;++i)e.add(t[i]);return e.size===s?t:Array.from(e)}const lt="undefined"==typeof window?function(t){return t()}:window.requestAnimationFrame;function ht(t,e,i){const s=i||(t=>Array.prototype.slice.call(t));let n=!1,o=[];return function(...i){o=s(i),n||(n=!0,lt.call(window,(()=>{n=!1,t.apply(e,o);})));}}function ct(t,e){let i;return function(...s){return e?(clearTimeout(i),i=setTimeout(t,e,s)):t.apply(this,s),e}}const dt=t=>"start"===t?"left":"end"===t?"right":"center",ut=(t,e,i)=>"start"===t?e:"end"===t?i:(e+i)/2,ft=(t,e,i,s)=>t===(s?"left":"right")?i:"center"===t?(e+i)/2:e;function gt(t,e,i){const s=e.length;let n=0,o=s;if(t._sorted){const{iScale:a,_parsed:r}=t,l=a.axis,{min:h,max:c,minDefined:d,maxDefined:u}=a.getUserBounds();d&&(n=Z(Math.min(et(r,a.axis,h).lo,i?s:et(e,l,a.getPixelForValue(h)).lo),0,s-1)),o=u?Z(Math.max(et(r,a.axis,c,!0).hi+1,i?0:et(e,l,a.getPixelForValue(c),!0).hi+1),n,s)-n:s-n;}return {start:n,count:o}}function pt(t){const{xScale:e,yScale:i,_scaleRanges:s}=t,n={xmin:e.min,xmax:e.max,ymin:i.min,ymax:i.max};if(!s)return t._scaleRanges=n,!0;const o=s.xmin!==e.min||s.xmax!==e.max||s.ymin!==i.min||s.ymax!==i.max;return Object.assign(s,n),o}var mt=new class{constructor(){this._request=null,this._charts=new Map,this._running=!1,this._lastDate=void 0;}_notify(t,e,i,s){const n=e.listeners[s],o=e.duration;n.forEach((s=>s({chart:t,initial:e.initial,numSteps:o,currentStep:Math.min(i-e.start,o)})));}_refresh(){this._request||(this._running=!0,this._request=lt.call(window,(()=>{this._update(),this._request=null,this._running&&this._refresh();})));}_update(t=Date.now()){let e=0;this._charts.forEach(((i,s)=>{if(!i.running||!i.items.length)return;const n=i.items;let o,a=n.length-1,r=!1;for(;a>=0;--a)o=n[a],o._active?(o._total>i.duration&&(i.duration=o._total),o.tick(t),r=!0):(n[a]=n[n.length-1],n.pop());r&&(s.draw(),this._notify(s,i,t,"progress")),n.length||(i.running=!1,this._notify(s,i,t,"complete"),i.initial=!1),e+=n.length;})),this._lastDate=t,0===e&&(this._running=!1);}_getAnims(t){const e=this._charts;let i=e.get(t);return i||(i={running:!1,initial:!0,items:[],listeners:{complete:[],progress:[]}},e.set(t,i)),i}listen(t,e,i){this._getAnims(t).listeners[e].push(i);}add(t,e){e&&e.length&&this._getAnims(t).items.push(...e);}has(t){return this._getAnims(t).items.length>0}start(t){const e=this._charts.get(t);e&&(e.running=!0,e.start=Date.now(),e.duration=e.items.reduce(((t,e)=>Math.max(t,e._duration)),0),this._refresh());}running(t){if(!this._running)return !1;const e=this._charts.get(t);return !!(e&&e.running&&e.items.length)}stop(t){const e=this._charts.get(t);if(!e||!e.items.length)return;const i=e.items;let s=i.length-1;for(;s>=0;--s)i[s].cancel();e.items=[],this._notify(t,e,Date.now(),"complete");}remove(t){return this._charts.delete(t)}};
	    /*!
	     * @kurkle/color v0.2.1
	     * https://github.com/kurkle/color#readme
	     * (c) 2022 Jukka Kurkela
	     * Released under the MIT License
	     */function bt(t){return t+.5|0}const xt=(t,e,i)=>Math.max(Math.min(t,i),e);function _t(t){return xt(bt(2.55*t),0,255)}function yt(t){return xt(bt(255*t),0,255)}function vt(t){return xt(bt(t/2.55)/100,0,1)}function wt(t){return xt(bt(100*t),0,100)}const Mt={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15},kt=[..."0123456789ABCDEF"],St=t=>kt[15&t],Pt=t=>kt[(240&t)>>4]+kt[15&t],Dt=t=>(240&t)>>4==(15&t);function Ot(t){var e=(t=>Dt(t.r)&&Dt(t.g)&&Dt(t.b)&&Dt(t.a))(t)?St:Pt;return t?"#"+e(t.r)+e(t.g)+e(t.b)+((t,e)=>t<255?e(t):"")(t.a,e):void 0}const Ct=/^(hsla?|hwb|hsv)\(\s*([-+.e\d]+)(?:deg)?[\s,]+([-+.e\d]+)%[\s,]+([-+.e\d]+)%(?:[\s,]+([-+.e\d]+)(%)?)?\s*\)$/;function At(t,e,i){const s=e*Math.min(i,1-i),n=(e,n=(e+t/30)%12)=>i-s*Math.max(Math.min(n-3,9-n,1),-1);return [n(0),n(8),n(4)]}function Tt(t,e,i){const s=(s,n=(s+t/60)%6)=>i-i*e*Math.max(Math.min(n,4-n,1),0);return [s(5),s(3),s(1)]}function Lt(t,e,i){const s=At(t,1,.5);let n;for(e+i>1&&(n=1/(e+i),e*=n,i*=n),n=0;n<3;n++)s[n]*=1-e-i,s[n]+=e;return s}function Et(t){const e=t.r/255,i=t.g/255,s=t.b/255,n=Math.max(e,i,s),o=Math.min(e,i,s),a=(n+o)/2;let r,l,h;return n!==o&&(h=n-o,l=a>.5?h/(2-n-o):h/(n+o),r=function(t,e,i,s,n){return t===n?(e-i)/s+(e<i?6:0):e===n?(i-t)/s+2:(t-e)/s+4}(e,i,s,h,n),r=60*r+.5),[0|r,l||0,a]}function Rt(t,e,i,s){return (Array.isArray(e)?t(e[0],e[1],e[2]):t(e,i,s)).map(yt)}function It(t,e,i){return Rt(At,t,e,i)}function zt(t){return (t%360+360)%360}function Ft(t){const e=Ct.exec(t);let i,s=255;if(!e)return;e[5]!==i&&(s=e[6]?_t(+e[5]):yt(+e[5]));const n=zt(+e[2]),o=+e[3]/100,a=+e[4]/100;return i="hwb"===e[1]?function(t,e,i){return Rt(Lt,t,e,i)}(n,o,a):"hsv"===e[1]?function(t,e,i){return Rt(Tt,t,e,i)}(n,o,a):It(n,o,a),{r:i[0],g:i[1],b:i[2],a:s}}const Vt={x:"dark",Z:"light",Y:"re",X:"blu",W:"gr",V:"medium",U:"slate",A:"ee",T:"ol",S:"or",B:"ra",C:"lateg",D:"ights",R:"in",Q:"turquois",E:"hi",P:"ro",O:"al",N:"le",M:"de",L:"yello",F:"en",K:"ch",G:"arks",H:"ea",I:"ightg",J:"wh"},Bt={OiceXe:"f0f8ff",antiquewEte:"faebd7",aqua:"ffff",aquamarRe:"7fffd4",azuY:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"0",blanKedOmond:"ffebcd",Xe:"ff",XeviTet:"8a2be2",bPwn:"a52a2a",burlywood:"deb887",caMtXe:"5f9ea0",KartYuse:"7fff00",KocTate:"d2691e",cSO:"ff7f50",cSnflowerXe:"6495ed",cSnsilk:"fff8dc",crimson:"dc143c",cyan:"ffff",xXe:"8b",xcyan:"8b8b",xgTMnPd:"b8860b",xWay:"a9a9a9",xgYF:"6400",xgYy:"a9a9a9",xkhaki:"bdb76b",xmagFta:"8b008b",xTivegYF:"556b2f",xSange:"ff8c00",xScEd:"9932cc",xYd:"8b0000",xsOmon:"e9967a",xsHgYF:"8fbc8f",xUXe:"483d8b",xUWay:"2f4f4f",xUgYy:"2f4f4f",xQe:"ced1",xviTet:"9400d3",dAppRk:"ff1493",dApskyXe:"bfff",dimWay:"696969",dimgYy:"696969",dodgerXe:"1e90ff",fiYbrick:"b22222",flSOwEte:"fffaf0",foYstWAn:"228b22",fuKsia:"ff00ff",gaRsbSo:"dcdcdc",ghostwEte:"f8f8ff",gTd:"ffd700",gTMnPd:"daa520",Way:"808080",gYF:"8000",gYFLw:"adff2f",gYy:"808080",honeyMw:"f0fff0",hotpRk:"ff69b4",RdianYd:"cd5c5c",Rdigo:"4b0082",ivSy:"fffff0",khaki:"f0e68c",lavFMr:"e6e6fa",lavFMrXsh:"fff0f5",lawngYF:"7cfc00",NmoncEffon:"fffacd",ZXe:"add8e6",ZcSO:"f08080",Zcyan:"e0ffff",ZgTMnPdLw:"fafad2",ZWay:"d3d3d3",ZgYF:"90ee90",ZgYy:"d3d3d3",ZpRk:"ffb6c1",ZsOmon:"ffa07a",ZsHgYF:"20b2aa",ZskyXe:"87cefa",ZUWay:"778899",ZUgYy:"778899",ZstAlXe:"b0c4de",ZLw:"ffffe0",lime:"ff00",limegYF:"32cd32",lRF:"faf0e6",magFta:"ff00ff",maPon:"800000",VaquamarRe:"66cdaa",VXe:"cd",VScEd:"ba55d3",VpurpN:"9370db",VsHgYF:"3cb371",VUXe:"7b68ee",VsprRggYF:"fa9a",VQe:"48d1cc",VviTetYd:"c71585",midnightXe:"191970",mRtcYam:"f5fffa",mistyPse:"ffe4e1",moccasR:"ffe4b5",navajowEte:"ffdead",navy:"80",Tdlace:"fdf5e6",Tive:"808000",TivedBb:"6b8e23",Sange:"ffa500",SangeYd:"ff4500",ScEd:"da70d6",pOegTMnPd:"eee8aa",pOegYF:"98fb98",pOeQe:"afeeee",pOeviTetYd:"db7093",papayawEp:"ffefd5",pHKpuff:"ffdab9",peru:"cd853f",pRk:"ffc0cb",plum:"dda0dd",powMrXe:"b0e0e6",purpN:"800080",YbeccapurpN:"663399",Yd:"ff0000",Psybrown:"bc8f8f",PyOXe:"4169e1",saddNbPwn:"8b4513",sOmon:"fa8072",sandybPwn:"f4a460",sHgYF:"2e8b57",sHshell:"fff5ee",siFna:"a0522d",silver:"c0c0c0",skyXe:"87ceeb",UXe:"6a5acd",UWay:"708090",UgYy:"708090",snow:"fffafa",sprRggYF:"ff7f",stAlXe:"4682b4",tan:"d2b48c",teO:"8080",tEstN:"d8bfd8",tomato:"ff6347",Qe:"40e0d0",viTet:"ee82ee",JHt:"f5deb3",wEte:"ffffff",wEtesmoke:"f5f5f5",Lw:"ffff00",LwgYF:"9acd32"};let Nt;function Wt(t){Nt||(Nt=function(){const t={},e=Object.keys(Bt),i=Object.keys(Vt);let s,n,o,a,r;for(s=0;s<e.length;s++){for(a=r=e[s],n=0;n<i.length;n++)o=i[n],r=r.replace(o,Vt[o]);o=parseInt(Bt[a],16),t[r]=[o>>16&255,o>>8&255,255&o];}return t}(),Nt.transparent=[0,0,0,0]);const e=Nt[t.toLowerCase()];return e&&{r:e[0],g:e[1],b:e[2],a:4===e.length?e[3]:255}}const jt=/^rgba?\(\s*([-+.\d]+)(%)?[\s,]+([-+.e\d]+)(%)?[\s,]+([-+.e\d]+)(%)?(?:[\s,/]+([-+.e\d]+)(%)?)?\s*\)$/;const Ht=t=>t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055,$t=t=>t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4);function Yt(t,e,i){if(t){let s=Et(t);s[e]=Math.max(0,Math.min(s[e]+s[e]*i,0===e?360:1)),s=It(s),t.r=s[0],t.g=s[1],t.b=s[2];}}function Ut(t,e){return t?Object.assign(e||{},t):t}function Xt(t){var e={r:0,g:0,b:0,a:255};return Array.isArray(t)?t.length>=3&&(e={r:t[0],g:t[1],b:t[2],a:255},t.length>3&&(e.a=yt(t[3]))):(e=Ut(t,{r:0,g:0,b:0,a:1})).a=yt(e.a),e}function qt(t){return "r"===t.charAt(0)?function(t){const e=jt.exec(t);let i,s,n,o=255;if(e){if(e[7]!==i){const t=+e[7];o=e[8]?_t(t):xt(255*t,0,255);}return i=+e[1],s=+e[3],n=+e[5],i=255&(e[2]?_t(i):xt(i,0,255)),s=255&(e[4]?_t(s):xt(s,0,255)),n=255&(e[6]?_t(n):xt(n,0,255)),{r:i,g:s,b:n,a:o}}}(t):Ft(t)}class Kt{constructor(t){if(t instanceof Kt)return t;const e=typeof t;let i;var s,n,o;"object"===e?i=Xt(t):"string"===e&&(o=(s=t).length,"#"===s[0]&&(4===o||5===o?n={r:255&17*Mt[s[1]],g:255&17*Mt[s[2]],b:255&17*Mt[s[3]],a:5===o?17*Mt[s[4]]:255}:7!==o&&9!==o||(n={r:Mt[s[1]]<<4|Mt[s[2]],g:Mt[s[3]]<<4|Mt[s[4]],b:Mt[s[5]]<<4|Mt[s[6]],a:9===o?Mt[s[7]]<<4|Mt[s[8]]:255})),i=n||Wt(t)||qt(t)),this._rgb=i,this._valid=!!i;}get valid(){return this._valid}get rgb(){var t=Ut(this._rgb);return t&&(t.a=vt(t.a)),t}set rgb(t){this._rgb=Xt(t);}rgbString(){return this._valid?(t=this._rgb)&&(t.a<255?`rgba(${t.r}, ${t.g}, ${t.b}, ${vt(t.a)})`:`rgb(${t.r}, ${t.g}, ${t.b})`):void 0;var t;}hexString(){return this._valid?Ot(this._rgb):void 0}hslString(){return this._valid?function(t){if(!t)return;const e=Et(t),i=e[0],s=wt(e[1]),n=wt(e[2]);return t.a<255?`hsla(${i}, ${s}%, ${n}%, ${vt(t.a)})`:`hsl(${i}, ${s}%, ${n}%)`}(this._rgb):void 0}mix(t,e){if(t){const i=this.rgb,s=t.rgb;let n;const o=e===n?.5:e,a=2*o-1,r=i.a-s.a,l=((a*r==-1?a:(a+r)/(1+a*r))+1)/2;n=1-l,i.r=255&l*i.r+n*s.r+.5,i.g=255&l*i.g+n*s.g+.5,i.b=255&l*i.b+n*s.b+.5,i.a=o*i.a+(1-o)*s.a,this.rgb=i;}return this}interpolate(t,e){return t&&(this._rgb=function(t,e,i){const s=$t(vt(t.r)),n=$t(vt(t.g)),o=$t(vt(t.b));return {r:yt(Ht(s+i*($t(vt(e.r))-s))),g:yt(Ht(n+i*($t(vt(e.g))-n))),b:yt(Ht(o+i*($t(vt(e.b))-o))),a:t.a+i*(e.a-t.a)}}(this._rgb,t._rgb,e)),this}clone(){return new Kt(this.rgb)}alpha(t){return this._rgb.a=yt(t),this}clearer(t){return this._rgb.a*=1-t,this}greyscale(){const t=this._rgb,e=bt(.3*t.r+.59*t.g+.11*t.b);return t.r=t.g=t.b=e,this}opaquer(t){return this._rgb.a*=1+t,this}negate(){const t=this._rgb;return t.r=255-t.r,t.g=255-t.g,t.b=255-t.b,this}lighten(t){return Yt(this._rgb,2,t),this}darken(t){return Yt(this._rgb,2,-t),this}saturate(t){return Yt(this._rgb,1,t),this}desaturate(t){return Yt(this._rgb,1,-t),this}rotate(t){return function(t,e){var i=Et(t);i[0]=zt(i[0]+e),i=It(i),t.r=i[0],t.g=i[1],t.b=i[2];}(this._rgb,t),this}}function Gt(t){return new Kt(t)}function Zt(t){if(t&&"object"==typeof t){const e=t.toString();return "[object CanvasPattern]"===e||"[object CanvasGradient]"===e}return !1}function Jt(t){return Zt(t)?t:Gt(t)}function Qt(t){return Zt(t)?t:Gt(t).saturate(.5).darken(.1).hexString()}const te=Object.create(null),ee=Object.create(null);function ie(t,e){if(!e)return t;const i=e.split(".");for(let e=0,s=i.length;e<s;++e){const s=i[e];t=t[s]||(t[s]=Object.create(null));}return t}function se(t,e,i){return "string"==typeof e?m(ie(t,e),i):m(ie(t,""),e)}var ne=new class{constructor(t){this.animation=void 0,this.backgroundColor="rgba(0,0,0,0.1)",this.borderColor="rgba(0,0,0,0.1)",this.color="#666",this.datasets={},this.devicePixelRatio=t=>t.chart.platform.getDevicePixelRatio(),this.elements={},this.events=["mousemove","mouseout","click","touchstart","touchmove"],this.font={family:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",size:12,style:"normal",lineHeight:1.2,weight:null},this.hover={},this.hoverBackgroundColor=(t,e)=>Qt(e.backgroundColor),this.hoverBorderColor=(t,e)=>Qt(e.borderColor),this.hoverColor=(t,e)=>Qt(e.color),this.indexAxis="x",this.interaction={mode:"nearest",intersect:!0,includeInvisible:!1},this.maintainAspectRatio=!0,this.onHover=null,this.onClick=null,this.parsing=!0,this.plugins={},this.responsive=!0,this.scale=void 0,this.scales={},this.showLine=!0,this.drawActiveElementsOnTop=!0,this.describe(t);}set(t,e){return se(this,t,e)}get(t){return ie(this,t)}describe(t,e){return se(ee,t,e)}override(t,e){return se(te,t,e)}route(t,e,i,s){const o=ie(this,t),a=ie(this,i),l="_"+e;Object.defineProperties(o,{[l]:{value:o[e],writable:!0},[e]:{enumerable:!0,get(){const t=this[l],e=a[s];return n(t)?Object.assign({},e,t):r(t,e)},set(t){this[l]=t;}}});}}({_scriptable:t=>!t.startsWith("on"),_indexable:t=>"events"!==t,hover:{_fallback:"interaction"},interaction:{_scriptable:!1,_indexable:!1}});function oe(){return "undefined"!=typeof window&&"undefined"!=typeof document}function ae(t){let e=t.parentNode;return e&&"[object ShadowRoot]"===e.toString()&&(e=e.host),e}function re(t,e,i){let s;return "string"==typeof t?(s=parseInt(t,10),-1!==t.indexOf("%")&&(s=s/100*e.parentNode[i])):s=t,s}const le=t=>window.getComputedStyle(t,null);function he(t,e){return le(t).getPropertyValue(e)}const ce=["top","right","bottom","left"];function de(t,e,i){const s={};i=i?"-"+i:"";for(let n=0;n<4;n++){const o=ce[n];s[o]=parseFloat(t[e+"-"+o+i])||0;}return s.width=s.left+s.right,s.height=s.top+s.bottom,s}function ue(t,e){if("native"in t)return t;const{canvas:i,currentDevicePixelRatio:s}=e,n=le(i),o="border-box"===n.boxSizing,a=de(n,"padding"),r=de(n,"border","width"),{x:l,y:h,box:c}=function(t,e){const i=t.touches,s=i&&i.length?i[0]:t,{offsetX:n,offsetY:o}=s;let a,r,l=!1;if(((t,e,i)=>(t>0||e>0)&&(!i||!i.shadowRoot))(n,o,t.target))a=n,r=o;else {const t=e.getBoundingClientRect();a=s.clientX-t.left,r=s.clientY-t.top,l=!0;}return {x:a,y:r,box:l}}(t,i),d=a.left+(c&&r.left),u=a.top+(c&&r.top);let{width:f,height:g}=e;return o&&(f-=a.width+r.width,g-=a.height+r.height),{x:Math.round((l-d)/f*i.width/s),y:Math.round((h-u)/g*i.height/s)}}const fe=t=>Math.round(10*t)/10;function ge(t,e,i,s){const n=le(t),o=de(n,"margin"),a=re(n.maxWidth,t,"clientWidth")||A,r=re(n.maxHeight,t,"clientHeight")||A,l=function(t,e,i){let s,n;if(void 0===e||void 0===i){const o=ae(t);if(o){const t=o.getBoundingClientRect(),a=le(o),r=de(a,"border","width"),l=de(a,"padding");e=t.width-l.width-r.width,i=t.height-l.height-r.height,s=re(a.maxWidth,o,"clientWidth"),n=re(a.maxHeight,o,"clientHeight");}else e=t.clientWidth,i=t.clientHeight;}return {width:e,height:i,maxWidth:s||A,maxHeight:n||A}}(t,e,i);let{width:h,height:c}=l;if("content-box"===n.boxSizing){const t=de(n,"border","width"),e=de(n,"padding");h-=e.width+t.width,c-=e.height+t.height;}return h=Math.max(0,h-o.width),c=Math.max(0,s?Math.floor(h/s):c-o.height),h=fe(Math.min(h,a,l.maxWidth)),c=fe(Math.min(c,r,l.maxHeight)),h&&!c&&(c=fe(h/2)),{width:h,height:c}}function pe(t,e,i){const s=e||1,n=Math.floor(t.height*s),o=Math.floor(t.width*s);t.height=n/s,t.width=o/s;const a=t.canvas;return a.style&&(i||!a.style.height&&!a.style.width)&&(a.style.height=`${t.height}px`,a.style.width=`${t.width}px`),(t.currentDevicePixelRatio!==s||a.height!==n||a.width!==o)&&(t.currentDevicePixelRatio=s,a.height=n,a.width=o,t.ctx.setTransform(s,0,0,s,0,0),!0)}const me=function(){let t=!1;try{const e={get passive(){return t=!0,!1}};window.addEventListener("test",null,e),window.removeEventListener("test",null,e);}catch(t){}return t}();function be(t,e){const i=he(t,e),s=i&&i.match(/^(\d+)(\.\d+)?px$/);return s?+s[1]:void 0}function xe(t){return !t||i(t.size)||i(t.family)?null:(t.style?t.style+" ":"")+(t.weight?t.weight+" ":"")+t.size+"px "+t.family}function _e(t,e,i,s,n){let o=e[n];return o||(o=e[n]=t.measureText(n).width,i.push(n)),o>s&&(s=o),s}function ye(t,e,i,n){let o=(n=n||{}).data=n.data||{},a=n.garbageCollect=n.garbageCollect||[];n.font!==e&&(o=n.data={},a=n.garbageCollect=[],n.font=e),t.save(),t.font=e;let r=0;const l=i.length;let h,c,d,u,f;for(h=0;h<l;h++)if(u=i[h],null!=u&&!0!==s(u))r=_e(t,o,a,r,u);else if(s(u))for(c=0,d=u.length;c<d;c++)f=u[c],null==f||s(f)||(r=_e(t,o,a,r,f));t.restore();const g=a.length/2;if(g>i.length){for(h=0;h<g;h++)delete o[a[h]];a.splice(0,g);}return r}function ve(t,e,i){const s=t.currentDevicePixelRatio,n=0!==i?Math.max(i/2,.5):0;return Math.round((e-n)*s)/s+n}function we(t,e){(e=e||t.getContext("2d")).save(),e.resetTransform(),e.clearRect(0,0,t.width,t.height),e.restore();}function Me(t,e,i,s){ke(t,e,i,s,null);}function ke(t,e,i,s,n){let o,a,r,l,h,c;const d=e.pointStyle,u=e.rotation,f=e.radius;let g=(u||0)*T;if(d&&"object"==typeof d&&(o=d.toString(),"[object HTMLImageElement]"===o||"[object HTMLCanvasElement]"===o))return t.save(),t.translate(i,s),t.rotate(g),t.drawImage(d,-d.width/2,-d.height/2,d.width,d.height),void t.restore();if(!(isNaN(f)||f<=0)){switch(t.beginPath(),d){default:n?t.ellipse(i,s,n/2,f,0,0,O):t.arc(i,s,f,0,O),t.closePath();break;case"triangle":t.moveTo(i+Math.sin(g)*f,s-Math.cos(g)*f),g+=R,t.lineTo(i+Math.sin(g)*f,s-Math.cos(g)*f),g+=R,t.lineTo(i+Math.sin(g)*f,s-Math.cos(g)*f),t.closePath();break;case"rectRounded":h=.516*f,l=f-h,a=Math.cos(g+E)*l,r=Math.sin(g+E)*l,t.arc(i-a,s-r,h,g-D,g-L),t.arc(i+r,s-a,h,g-L,g),t.arc(i+a,s+r,h,g,g+L),t.arc(i-r,s+a,h,g+L,g+D),t.closePath();break;case"rect":if(!u){l=Math.SQRT1_2*f,c=n?n/2:l,t.rect(i-c,s-l,2*c,2*l);break}g+=E;case"rectRot":a=Math.cos(g)*f,r=Math.sin(g)*f,t.moveTo(i-a,s-r),t.lineTo(i+r,s-a),t.lineTo(i+a,s+r),t.lineTo(i-r,s+a),t.closePath();break;case"crossRot":g+=E;case"cross":a=Math.cos(g)*f,r=Math.sin(g)*f,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r),t.moveTo(i+r,s-a),t.lineTo(i-r,s+a);break;case"star":a=Math.cos(g)*f,r=Math.sin(g)*f,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r),t.moveTo(i+r,s-a),t.lineTo(i-r,s+a),g+=E,a=Math.cos(g)*f,r=Math.sin(g)*f,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r),t.moveTo(i+r,s-a),t.lineTo(i-r,s+a);break;case"line":a=n?n/2:Math.cos(g)*f,r=Math.sin(g)*f,t.moveTo(i-a,s-r),t.lineTo(i+a,s+r);break;case"dash":t.moveTo(i,s),t.lineTo(i+Math.cos(g)*f,s+Math.sin(g)*f);}t.fill(),e.borderWidth>0&&t.stroke();}}function Se(t,e,i){return i=i||.5,!e||t&&t.x>e.left-i&&t.x<e.right+i&&t.y>e.top-i&&t.y<e.bottom+i}function Pe(t,e){t.save(),t.beginPath(),t.rect(e.left,e.top,e.right-e.left,e.bottom-e.top),t.clip();}function De(t){t.restore();}function Oe(t,e,i,s,n){if(!e)return t.lineTo(i.x,i.y);if("middle"===n){const s=(e.x+i.x)/2;t.lineTo(s,e.y),t.lineTo(s,i.y);}else "after"===n!=!!s?t.lineTo(e.x,i.y):t.lineTo(i.x,e.y);t.lineTo(i.x,i.y);}function Ce(t,e,i,s){if(!e)return t.lineTo(i.x,i.y);t.bezierCurveTo(s?e.cp1x:e.cp2x,s?e.cp1y:e.cp2y,s?i.cp2x:i.cp1x,s?i.cp2y:i.cp1y,i.x,i.y);}function Ae(t,e,n,o,a,r={}){const l=s(e)?e:[e],h=r.strokeWidth>0&&""!==r.strokeColor;let c,d;for(t.save(),t.font=a.string,function(t,e){e.translation&&t.translate(e.translation[0],e.translation[1]);i(e.rotation)||t.rotate(e.rotation);e.color&&(t.fillStyle=e.color);e.textAlign&&(t.textAlign=e.textAlign);e.textBaseline&&(t.textBaseline=e.textBaseline);}(t,r),c=0;c<l.length;++c)d=l[c],h&&(r.strokeColor&&(t.strokeStyle=r.strokeColor),i(r.strokeWidth)||(t.lineWidth=r.strokeWidth),t.strokeText(d,n,o,r.maxWidth)),t.fillText(d,n,o,r.maxWidth),Te(t,n,o,d,r),o+=a.lineHeight;t.restore();}function Te(t,e,i,s,n){if(n.strikethrough||n.underline){const o=t.measureText(s),a=e-o.actualBoundingBoxLeft,r=e+o.actualBoundingBoxRight,l=i-o.actualBoundingBoxAscent,h=i+o.actualBoundingBoxDescent,c=n.strikethrough?(l+h)/2:h;t.strokeStyle=t.fillStyle,t.beginPath(),t.lineWidth=n.decorationWidth||2,t.moveTo(a,c),t.lineTo(r,c),t.stroke();}}function Le(t,e){const{x:i,y:s,w:n,h:o,radius:a}=e;t.arc(i+a.topLeft,s+a.topLeft,a.topLeft,-L,D,!0),t.lineTo(i,s+o-a.bottomLeft),t.arc(i+a.bottomLeft,s+o-a.bottomLeft,a.bottomLeft,D,L,!0),t.lineTo(i+n-a.bottomRight,s+o),t.arc(i+n-a.bottomRight,s+o-a.bottomRight,a.bottomRight,L,0,!0),t.lineTo(i+n,s+a.topRight),t.arc(i+n-a.topRight,s+a.topRight,a.topRight,0,-L,!0),t.lineTo(i+a.topLeft,s);}function Ee(t,e=[""],i=t,s,n=(()=>t[0])){M(s)||(s=$e("_fallback",t));const o={[Symbol.toStringTag]:"Object",_cacheable:!0,_scopes:t,_rootScopes:i,_fallback:s,_getTarget:n,override:n=>Ee([n,...t],e,i,s)};return new Proxy(o,{deleteProperty:(e,i)=>(delete e[i],delete e._keys,delete t[0][i],!0),get:(i,s)=>Ve(i,s,(()=>function(t,e,i,s){let n;for(const o of e)if(n=$e(ze(o,t),i),M(n))return Fe(t,n)?je(i,s,t,n):n}(s,e,t,i))),getOwnPropertyDescriptor:(t,e)=>Reflect.getOwnPropertyDescriptor(t._scopes[0],e),getPrototypeOf:()=>Reflect.getPrototypeOf(t[0]),has:(t,e)=>Ye(t).includes(e),ownKeys:t=>Ye(t),set(t,e,i){const s=t._storage||(t._storage=n());return t[e]=s[e]=i,delete t._keys,!0}})}function Re(t,e,i,o){const a={_cacheable:!1,_proxy:t,_context:e,_subProxy:i,_stack:new Set,_descriptors:Ie(t,o),setContext:e=>Re(t,e,i,o),override:s=>Re(t.override(s),e,i,o)};return new Proxy(a,{deleteProperty:(e,i)=>(delete e[i],delete t[i],!0),get:(t,e,i)=>Ve(t,e,(()=>function(t,e,i){const{_proxy:o,_context:a,_subProxy:r,_descriptors:l}=t;let h=o[e];k(h)&&l.isScriptable(e)&&(h=function(t,e,i,s){const{_proxy:n,_context:o,_subProxy:a,_stack:r}=i;if(r.has(t))throw new Error("Recursion detected: "+Array.from(r).join("->")+"->"+t);r.add(t),e=e(o,a||s),r.delete(t),Fe(t,e)&&(e=je(n._scopes,n,t,e));return e}(e,h,t,i));s(h)&&h.length&&(h=function(t,e,i,s){const{_proxy:o,_context:a,_subProxy:r,_descriptors:l}=i;if(M(a.index)&&s(t))e=e[a.index%e.length];else if(n(e[0])){const i=e,s=o._scopes.filter((t=>t!==i));e=[];for(const n of i){const i=je(s,o,t,n);e.push(Re(i,a,r&&r[t],l));}}return e}(e,h,t,l.isIndexable));Fe(e,h)&&(h=Re(h,a,r&&r[e],l));return h}(t,e,i))),getOwnPropertyDescriptor:(e,i)=>e._descriptors.allKeys?Reflect.has(t,i)?{enumerable:!0,configurable:!0}:void 0:Reflect.getOwnPropertyDescriptor(t,i),getPrototypeOf:()=>Reflect.getPrototypeOf(t),has:(e,i)=>Reflect.has(t,i),ownKeys:()=>Reflect.ownKeys(t),set:(e,i,s)=>(t[i]=s,delete e[i],!0)})}function Ie(t,e={scriptable:!0,indexable:!0}){const{_scriptable:i=e.scriptable,_indexable:s=e.indexable,_allKeys:n=e.allKeys}=t;return {allKeys:n,scriptable:i,indexable:s,isScriptable:k(i)?i:()=>i,isIndexable:k(s)?s:()=>s}}const ze=(t,e)=>t?t+w(e):e,Fe=(t,e)=>n(e)&&"adapters"!==t&&(null===Object.getPrototypeOf(e)||e.constructor===Object);function Ve(t,e,i){if(Object.prototype.hasOwnProperty.call(t,e))return t[e];const s=i();return t[e]=s,s}function Be(t,e,i){return k(t)?t(e,i):t}const Ne=(t,e)=>!0===t?e:"string"==typeof t?y(e,t):void 0;function We(t,e,i,s,n){for(const o of e){const e=Ne(i,o);if(e){t.add(e);const o=Be(e._fallback,i,n);if(M(o)&&o!==i&&o!==s)return o}else if(!1===e&&M(s)&&i!==s)return null}return !1}function je(t,e,i,o){const a=e._rootScopes,r=Be(e._fallback,i,o),l=[...t,...a],h=new Set;h.add(o);let c=He(h,l,i,r||i,o);return null!==c&&((!M(r)||r===i||(c=He(h,l,r,c,o),null!==c))&&Ee(Array.from(h),[""],a,r,(()=>function(t,e,i){const o=t._getTarget();e in o||(o[e]={});const a=o[e];if(s(a)&&n(i))return i;return a}(e,i,o))))}function He(t,e,i,s,n){for(;i;)i=We(t,e,i,s,n);return i}function $e(t,e){for(const i of e){if(!i)continue;const e=i[t];if(M(e))return e}}function Ye(t){let e=t._keys;return e||(e=t._keys=function(t){const e=new Set;for(const i of t)for(const t of Object.keys(i).filter((t=>!t.startsWith("_"))))e.add(t);return Array.from(e)}(t._scopes)),e}function Ue(t,e,i,s){const{iScale:n}=t,{key:o="r"}=this._parsing,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={r:n.parse(y(c,o),h)};return a}const Xe=Number.EPSILON||1e-14,qe=(t,e)=>e<t.length&&!t[e].skip&&t[e],Ke=t=>"x"===t?"y":"x";function Ge(t,e,i,s){const n=t.skip?e:t,o=e,a=i.skip?e:i,r=X(o,n),l=X(a,o);let h=r/(r+l),c=l/(r+l);h=isNaN(h)?0:h,c=isNaN(c)?0:c;const d=s*h,u=s*c;return {previous:{x:o.x-d*(a.x-n.x),y:o.y-d*(a.y-n.y)},next:{x:o.x+u*(a.x-n.x),y:o.y+u*(a.y-n.y)}}}function Ze(t,e="x"){const i=Ke(e),s=t.length,n=Array(s).fill(0),o=Array(s);let a,r,l,h=qe(t,0);for(a=0;a<s;++a)if(r=l,l=h,h=qe(t,a+1),l){if(h){const t=h[e]-l[e];n[a]=0!==t?(h[i]-l[i])/t:0;}o[a]=r?h?z(n[a-1])!==z(n[a])?0:(n[a-1]+n[a])/2:n[a-1]:n[a];}!function(t,e,i){const s=t.length;let n,o,a,r,l,h=qe(t,0);for(let c=0;c<s-1;++c)l=h,h=qe(t,c+1),l&&h&&(N(e[c],0,Xe)?i[c]=i[c+1]=0:(n=i[c]/e[c],o=i[c+1]/e[c],r=Math.pow(n,2)+Math.pow(o,2),r<=9||(a=3/Math.sqrt(r),i[c]=n*a*e[c],i[c+1]=o*a*e[c])));}(t,n,o),function(t,e,i="x"){const s=Ke(i),n=t.length;let o,a,r,l=qe(t,0);for(let h=0;h<n;++h){if(a=r,r=l,l=qe(t,h+1),!r)continue;const n=r[i],c=r[s];a&&(o=(n-a[i])/3,r[`cp1${i}`]=n-o,r[`cp1${s}`]=c-o*e[h]),l&&(o=(l[i]-n)/3,r[`cp2${i}`]=n+o,r[`cp2${s}`]=c+o*e[h]);}}(t,o,e);}function Je(t,e,i){return Math.max(Math.min(t,i),e)}function Qe(t,e,i,s,n){let o,a,r,l;if(e.spanGaps&&(t=t.filter((t=>!t.skip))),"monotone"===e.cubicInterpolationMode)Ze(t,n);else {let i=s?t[t.length-1]:t[0];for(o=0,a=t.length;o<a;++o)r=t[o],l=Ge(i,r,t[Math.min(o+1,a-(s?0:1))%a],e.tension),r.cp1x=l.previous.x,r.cp1y=l.previous.y,r.cp2x=l.next.x,r.cp2y=l.next.y,i=r;}e.capBezierPoints&&function(t,e){let i,s,n,o,a,r=Se(t[0],e);for(i=0,s=t.length;i<s;++i)a=o,o=r,r=i<s-1&&Se(t[i+1],e),o&&(n=t[i],a&&(n.cp1x=Je(n.cp1x,e.left,e.right),n.cp1y=Je(n.cp1y,e.top,e.bottom)),r&&(n.cp2x=Je(n.cp2x,e.left,e.right),n.cp2y=Je(n.cp2y,e.top,e.bottom)));}(t,i);}const ti=t=>0===t||1===t,ei=(t,e,i)=>-Math.pow(2,10*(t-=1))*Math.sin((t-e)*O/i),ii=(t,e,i)=>Math.pow(2,-10*t)*Math.sin((t-e)*O/i)+1,si={linear:t=>t,easeInQuad:t=>t*t,easeOutQuad:t=>-t*(t-2),easeInOutQuad:t=>(t/=.5)<1?.5*t*t:-.5*(--t*(t-2)-1),easeInCubic:t=>t*t*t,easeOutCubic:t=>(t-=1)*t*t+1,easeInOutCubic:t=>(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2),easeInQuart:t=>t*t*t*t,easeOutQuart:t=>-((t-=1)*t*t*t-1),easeInOutQuart:t=>(t/=.5)<1?.5*t*t*t*t:-.5*((t-=2)*t*t*t-2),easeInQuint:t=>t*t*t*t*t,easeOutQuint:t=>(t-=1)*t*t*t*t+1,easeInOutQuint:t=>(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2),easeInSine:t=>1-Math.cos(t*L),easeOutSine:t=>Math.sin(t*L),easeInOutSine:t=>-.5*(Math.cos(D*t)-1),easeInExpo:t=>0===t?0:Math.pow(2,10*(t-1)),easeOutExpo:t=>1===t?1:1-Math.pow(2,-10*t),easeInOutExpo:t=>ti(t)?t:t<.5?.5*Math.pow(2,10*(2*t-1)):.5*(2-Math.pow(2,-10*(2*t-1))),easeInCirc:t=>t>=1?t:-(Math.sqrt(1-t*t)-1),easeOutCirc:t=>Math.sqrt(1-(t-=1)*t),easeInOutCirc:t=>(t/=.5)<1?-.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1),easeInElastic:t=>ti(t)?t:ei(t,.075,.3),easeOutElastic:t=>ti(t)?t:ii(t,.075,.3),easeInOutElastic(t){const e=.1125;return ti(t)?t:t<.5?.5*ei(2*t,e,.45):.5+.5*ii(2*t-1,e,.45)},easeInBack(t){const e=1.70158;return t*t*((e+1)*t-e)},easeOutBack(t){const e=1.70158;return (t-=1)*t*((e+1)*t+e)+1},easeInOutBack(t){let e=1.70158;return (t/=.5)<1?t*t*((1+(e*=1.525))*t-e)*.5:.5*((t-=2)*t*((1+(e*=1.525))*t+e)+2)},easeInBounce:t=>1-si.easeOutBounce(1-t),easeOutBounce(t){const e=7.5625,i=2.75;return t<1/i?e*t*t:t<2/i?e*(t-=1.5/i)*t+.75:t<2.5/i?e*(t-=2.25/i)*t+.9375:e*(t-=2.625/i)*t+.984375},easeInOutBounce:t=>t<.5?.5*si.easeInBounce(2*t):.5*si.easeOutBounce(2*t-1)+.5};function ni(t,e,i,s){return {x:t.x+i*(e.x-t.x),y:t.y+i*(e.y-t.y)}}function oi(t,e,i,s){return {x:t.x+i*(e.x-t.x),y:"middle"===s?i<.5?t.y:e.y:"after"===s?i<1?t.y:e.y:i>0?e.y:t.y}}function ai(t,e,i,s){const n={x:t.cp2x,y:t.cp2y},o={x:e.cp1x,y:e.cp1y},a=ni(t,n,i),r=ni(n,o,i),l=ni(o,e,i),h=ni(a,r,i),c=ni(r,l,i);return ni(h,c,i)}const ri=new Map;function li(t,e,i){return function(t,e){e=e||{};const i=t+JSON.stringify(e);let s=ri.get(i);return s||(s=new Intl.NumberFormat(t,e),ri.set(i,s)),s}(e,i).format(t)}const hi=new RegExp(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/),ci=new RegExp(/^(normal|italic|initial|inherit|unset|(oblique( -?[0-9]?[0-9]deg)?))$/);function di(t,e){const i=(""+t).match(hi);if(!i||"normal"===i[1])return 1.2*e;switch(t=+i[2],i[3]){case"px":return t;case"%":t/=100;}return e*t}function ui(t,e){const i={},s=n(e),o=s?Object.keys(e):e,a=n(t)?s?i=>r(t[i],t[e[i]]):e=>t[e]:()=>t;for(const t of o)i[t]=+a(t)||0;return i}function fi(t){return ui(t,{top:"y",right:"x",bottom:"y",left:"x"})}function gi(t){return ui(t,["topLeft","topRight","bottomLeft","bottomRight"])}function pi(t){const e=fi(t);return e.width=e.left+e.right,e.height=e.top+e.bottom,e}function mi(t,e){t=t||{},e=e||ne.font;let i=r(t.size,e.size);"string"==typeof i&&(i=parseInt(i,10));let s=r(t.style,e.style);s&&!(""+s).match(ci)&&(console.warn('Invalid font style specified: "'+s+'"'),s="");const n={family:r(t.family,e.family),lineHeight:di(r(t.lineHeight,e.lineHeight),i),size:i,style:s,weight:r(t.weight,e.weight),string:""};return n.string=xe(n),n}function bi(t,e,i,n){let o,a,r,l=!0;for(o=0,a=t.length;o<a;++o)if(r=t[o],void 0!==r&&(void 0!==e&&"function"==typeof r&&(r=r(e),l=!1),void 0!==i&&s(r)&&(r=r[i%r.length],l=!1),void 0!==r))return n&&!l&&(n.cacheable=!1),r}function xi(t,e,i){const{min:s,max:n}=t,o=h(e,(n-s)/2),a=(t,e)=>i&&0===t?0:t+e;return {min:a(s,-Math.abs(o)),max:a(n,o)}}function _i(t,e){return Object.assign(Object.create(t),e)}function yi(t,e,i){return t?function(t,e){return {x:i=>t+t+e-i,setWidth(t){e=t;},textAlign:t=>"center"===t?t:"right"===t?"left":"right",xPlus:(t,e)=>t-e,leftForLtr:(t,e)=>t-e}}(e,i):{x:t=>t,setWidth(t){},textAlign:t=>t,xPlus:(t,e)=>t+e,leftForLtr:(t,e)=>t}}function vi(t,e){let i,s;"ltr"!==e&&"rtl"!==e||(i=t.canvas.style,s=[i.getPropertyValue("direction"),i.getPropertyPriority("direction")],i.setProperty("direction",e,"important"),t.prevTextDirection=s);}function wi(t,e){void 0!==e&&(delete t.prevTextDirection,t.canvas.style.setProperty("direction",e[0],e[1]));}function Mi(t){return "angle"===t?{between:G,compare:q,normalize:K}:{between:Q,compare:(t,e)=>t-e,normalize:t=>t}}function ki({start:t,end:e,count:i,loop:s,style:n}){return {start:t%i,end:e%i,loop:s&&(e-t+1)%i==0,style:n}}function Si(t,e,i){if(!i)return [t];const{property:s,start:n,end:o}=i,a=e.length,{compare:r,between:l,normalize:h}=Mi(s),{start:c,end:d,loop:u,style:f}=function(t,e,i){const{property:s,start:n,end:o}=i,{between:a,normalize:r}=Mi(s),l=e.length;let h,c,{start:d,end:u,loop:f}=t;if(f){for(d+=l,u+=l,h=0,c=l;h<c&&a(r(e[d%l][s]),n,o);++h)d--,u--;d%=l,u%=l;}return u<d&&(u+=l),{start:d,end:u,loop:f,style:t.style}}(t,e,i),g=[];let p,m,b,x=!1,_=null;const y=()=>x||l(n,b,p)&&0!==r(n,b),v=()=>!x||0===r(o,p)||l(o,b,p);for(let t=c,i=c;t<=d;++t)m=e[t%a],m.skip||(p=h(m[s]),p!==b&&(x=l(p,n,o),null===_&&y()&&(_=0===r(p,n)?t:i),null!==_&&v()&&(g.push(ki({start:_,end:t,loop:u,count:a,style:f})),_=null),i=t,b=p));return null!==_&&g.push(ki({start:_,end:d,loop:u,count:a,style:f})),g}function Pi(t,e){const i=[],s=t.segments;for(let n=0;n<s.length;n++){const o=Si(s[n],t.points,e);o.length&&i.push(...o);}return i}function Di(t,e){const i=t.points,s=t.options.spanGaps,n=i.length;if(!n)return [];const o=!!t._loop,{start:a,end:r}=function(t,e,i,s){let n=0,o=e-1;if(i&&!s)for(;n<e&&!t[n].skip;)n++;for(;n<e&&t[n].skip;)n++;for(n%=e,i&&(o+=n);o>n&&t[o%e].skip;)o--;return o%=e,{start:n,end:o}}(i,n,o,s);if(!0===s)return Oi(t,[{start:a,end:r,loop:o}],i,e);return Oi(t,function(t,e,i,s){const n=t.length,o=[];let a,r=e,l=t[e];for(a=e+1;a<=i;++a){const i=t[a%n];i.skip||i.stop?l.skip||(s=!1,o.push({start:e%n,end:(a-1)%n,loop:s}),e=r=i.stop?a:null):(r=a,l.skip&&(e=a)),l=i;}return null!==r&&o.push({start:e%n,end:r%n,loop:s}),o}(i,a,r<a?r+n:r,!!t._fullLoop&&0===a&&r===n-1),i,e)}function Oi(t,e,i,s){return s&&s.setContext&&i?function(t,e,i,s){const n=t._chart.getContext(),o=Ci(t.options),{_datasetIndex:a,options:{spanGaps:r}}=t,l=i.length,h=[];let c=o,d=e[0].start,u=d;function f(t,e,s,n){const o=r?-1:1;if(t!==e){for(t+=l;i[t%l].skip;)t-=o;for(;i[e%l].skip;)e+=o;t%l!=e%l&&(h.push({start:t%l,end:e%l,loop:s,style:n}),c=n,d=e%l);}}for(const t of e){d=r?d:t.start;let e,o=i[d%l];for(u=d+1;u<=t.end;u++){const r=i[u%l];e=Ci(s.setContext(_i(n,{type:"segment",p0:o,p1:r,p0DataIndex:(u-1)%l,p1DataIndex:u%l,datasetIndex:a}))),Ai(e,c)&&f(d,u-1,t.loop,c),o=r,c=e;}d<u-1&&f(d,u-1,t.loop,c);}return h}(t,e,i,s):e}function Ci(t){return {backgroundColor:t.backgroundColor,borderCapStyle:t.borderCapStyle,borderDash:t.borderDash,borderDashOffset:t.borderDashOffset,borderJoinStyle:t.borderJoinStyle,borderWidth:t.borderWidth,borderColor:t.borderColor}}function Ai(t,e){return e&&JSON.stringify(t)!==JSON.stringify(e)}var Ti=Object.freeze({__proto__:null,easingEffects:si,isPatternOrGradient:Zt,color:Jt,getHoverColor:Qt,noop:t,uid:e,isNullOrUndef:i,isArray:s,isObject:n,isFinite:o,finiteOrDefault:a,valueOrDefault:r,toPercentage:l,toDimension:h,callback:c,each:d,_elementsEqual:u,clone:f,_merger:p,merge:m,mergeIf:b,_mergerIf:x,_deprecated:function(t,e,i,s){void 0!==e&&console.warn(t+': "'+i+'" is deprecated. Please use "'+s+'" instead');},resolveObjectKey:y,_splitKey:v,_capitalize:w,defined:M,isFunction:k,setsEqual:S,_isClickEvent:P,toFontString:xe,_measureText:_e,_longestText:ye,_alignPixel:ve,clearCanvas:we,drawPoint:Me,drawPointLegend:ke,_isPointInArea:Se,clipArea:Pe,unclipArea:De,_steppedLineTo:Oe,_bezierCurveTo:Ce,renderText:Ae,addRoundedRectPath:Le,_lookup:tt,_lookupByKey:et,_rlookupByKey:it,_filterBetween:st,listenArrayEvents:ot,unlistenArrayEvents:at,_arrayUnique:rt,_createResolver:Ee,_attachContext:Re,_descriptors:Ie,_parseObjectDataRadialScale:Ue,splineCurve:Ge,splineCurveMonotone:Ze,_updateBezierControlPoints:Qe,_isDomSupported:oe,_getParentNode:ae,getStyle:he,getRelativePosition:ue,getMaximumSize:ge,retinaScale:pe,supportsEventListenerOptions:me,readUsedSize:be,fontString:function(t,e,i){return e+" "+t+"px "+i},requestAnimFrame:lt,throttled:ht,debounce:ct,_toLeftRightCenter:dt,_alignStartEnd:ut,_textX:ft,_getStartAndCountOfVisiblePoints:gt,_scaleRangesChanged:pt,_pointInLine:ni,_steppedInterpolation:oi,_bezierInterpolation:ai,formatNumber:li,toLineHeight:di,_readValueToProps:ui,toTRBL:fi,toTRBLCorners:gi,toPadding:pi,toFont:mi,resolve:bi,_addGrace:xi,createContext:_i,PI:D,TAU:O,PITAU:C,INFINITY:A,RAD_PER_DEG:T,HALF_PI:L,QUARTER_PI:E,TWO_THIRDS_PI:R,log10:I,sign:z,niceNum:F,_factorize:V,isNumber:B,almostEquals:N,almostWhole:W,_setMinAndMaxByKey:j,toRadians:H,toDegrees:$,_decimalPlaces:Y,getAngleFromPoint:U,distanceBetweenPoints:X,_angleDiff:q,_normalizeAngle:K,_angleBetween:G,_limitValue:Z,_int16Range:J,_isBetween:Q,getRtlAdapter:yi,overrideTextDirection:vi,restoreTextDirection:wi,_boundSegment:Si,_boundSegments:Pi,_computeSegments:Di});function Li(t,e,i,s){const{controller:n,data:o,_sorted:a}=t,r=n._cachedMeta.iScale;if(r&&e===r.axis&&"r"!==e&&a&&o.length){const t=r._reversePixels?it:et;if(!s)return t(o,e,i);if(n._sharedOptions){const s=o[0],n="function"==typeof s.getRange&&s.getRange(e);if(n){const s=t(o,e,i-n),a=t(o,e,i+n);return {lo:s.lo,hi:a.hi}}}}return {lo:0,hi:o.length-1}}function Ei(t,e,i,s,n){const o=t.getSortedVisibleDatasetMetas(),a=i[e];for(let t=0,i=o.length;t<i;++t){const{index:i,data:r}=o[t],{lo:l,hi:h}=Li(o[t],e,a,n);for(let t=l;t<=h;++t){const e=r[t];e.skip||s(e,i,t);}}}function Ri(t,e,i,s,n){const o=[];if(!n&&!t.isPointInArea(e))return o;return Ei(t,i,e,(function(i,a,r){(n||Se(i,t.chartArea,0))&&i.inRange(e.x,e.y,s)&&o.push({element:i,datasetIndex:a,index:r});}),!0),o}function Ii(t,e,i,s,n,o){let a=[];const r=function(t){const e=-1!==t.indexOf("x"),i=-1!==t.indexOf("y");return function(t,s){const n=e?Math.abs(t.x-s.x):0,o=i?Math.abs(t.y-s.y):0;return Math.sqrt(Math.pow(n,2)+Math.pow(o,2))}}(i);let l=Number.POSITIVE_INFINITY;return Ei(t,i,e,(function(i,h,c){const d=i.inRange(e.x,e.y,n);if(s&&!d)return;const u=i.getCenterPoint(n);if(!(!!o||t.isPointInArea(u))&&!d)return;const f=r(e,u);f<l?(a=[{element:i,datasetIndex:h,index:c}],l=f):f===l&&a.push({element:i,datasetIndex:h,index:c});})),a}function zi(t,e,i,s,n,o){return o||t.isPointInArea(e)?"r"!==i||s?Ii(t,e,i,s,n,o):function(t,e,i,s){let n=[];return Ei(t,i,e,(function(t,i,o){const{startAngle:a,endAngle:r}=t.getProps(["startAngle","endAngle"],s),{angle:l}=U(t,{x:e.x,y:e.y});G(l,a,r)&&n.push({element:t,datasetIndex:i,index:o});})),n}(t,e,i,n):[]}function Fi(t,e,i,s,n){const o=[],a="x"===i?"inXRange":"inYRange";let r=!1;return Ei(t,i,e,((t,s,l)=>{t[a](e[i],n)&&(o.push({element:t,datasetIndex:s,index:l}),r=r||t.inRange(e.x,e.y,n));})),s&&!r?[]:o}var Vi={evaluateInteractionItems:Ei,modes:{index(t,e,i,s){const n=ue(e,t),o=i.axis||"x",a=i.includeInvisible||!1,r=i.intersect?Ri(t,n,o,s,a):zi(t,n,o,!1,s,a),l=[];return r.length?(t.getSortedVisibleDatasetMetas().forEach((t=>{const e=r[0].index,i=t.data[e];i&&!i.skip&&l.push({element:i,datasetIndex:t.index,index:e});})),l):[]},dataset(t,e,i,s){const n=ue(e,t),o=i.axis||"xy",a=i.includeInvisible||!1;let r=i.intersect?Ri(t,n,o,s,a):zi(t,n,o,!1,s,a);if(r.length>0){const e=r[0].datasetIndex,i=t.getDatasetMeta(e).data;r=[];for(let t=0;t<i.length;++t)r.push({element:i[t],datasetIndex:e,index:t});}return r},point:(t,e,i,s)=>Ri(t,ue(e,t),i.axis||"xy",s,i.includeInvisible||!1),nearest(t,e,i,s){const n=ue(e,t),o=i.axis||"xy",a=i.includeInvisible||!1;return zi(t,n,o,i.intersect,s,a)},x:(t,e,i,s)=>Fi(t,ue(e,t),"x",i.intersect,s),y:(t,e,i,s)=>Fi(t,ue(e,t),"y",i.intersect,s)}};const Bi=["left","top","right","bottom"];function Ni(t,e){return t.filter((t=>t.pos===e))}function Wi(t,e){return t.filter((t=>-1===Bi.indexOf(t.pos)&&t.box.axis===e))}function ji(t,e){return t.sort(((t,i)=>{const s=e?i:t,n=e?t:i;return s.weight===n.weight?s.index-n.index:s.weight-n.weight}))}function Hi(t,e){const i=function(t){const e={};for(const i of t){const{stack:t,pos:s,stackWeight:n}=i;if(!t||!Bi.includes(s))continue;const o=e[t]||(e[t]={count:0,placed:0,weight:0,size:0});o.count++,o.weight+=n;}return e}(t),{vBoxMaxWidth:s,hBoxMaxHeight:n}=e;let o,a,r;for(o=0,a=t.length;o<a;++o){r=t[o];const{fullSize:a}=r.box,l=i[r.stack],h=l&&r.stackWeight/l.weight;r.horizontal?(r.width=h?h*s:a&&e.availableWidth,r.height=n):(r.width=s,r.height=h?h*n:a&&e.availableHeight);}return i}function $i(t,e,i,s){return Math.max(t[i],e[i])+Math.max(t[s],e[s])}function Yi(t,e){t.top=Math.max(t.top,e.top),t.left=Math.max(t.left,e.left),t.bottom=Math.max(t.bottom,e.bottom),t.right=Math.max(t.right,e.right);}function Ui(t,e,i,s){const{pos:o,box:a}=i,r=t.maxPadding;if(!n(o)){i.size&&(t[o]-=i.size);const e=s[i.stack]||{size:0,count:1};e.size=Math.max(e.size,i.horizontal?a.height:a.width),i.size=e.size/e.count,t[o]+=i.size;}a.getPadding&&Yi(r,a.getPadding());const l=Math.max(0,e.outerWidth-$i(r,t,"left","right")),h=Math.max(0,e.outerHeight-$i(r,t,"top","bottom")),c=l!==t.w,d=h!==t.h;return t.w=l,t.h=h,i.horizontal?{same:c,other:d}:{same:d,other:c}}function Xi(t,e){const i=e.maxPadding;function s(t){const s={left:0,top:0,right:0,bottom:0};return t.forEach((t=>{s[t]=Math.max(e[t],i[t]);})),s}return s(t?["left","right"]:["top","bottom"])}function qi(t,e,i,s){const n=[];let o,a,r,l,h,c;for(o=0,a=t.length,h=0;o<a;++o){r=t[o],l=r.box,l.update(r.width||e.w,r.height||e.h,Xi(r.horizontal,e));const{same:a,other:d}=Ui(e,i,r,s);h|=a&&n.length,c=c||d,l.fullSize||n.push(r);}return h&&qi(n,e,i,s)||c}function Ki(t,e,i,s,n){t.top=i,t.left=e,t.right=e+s,t.bottom=i+n,t.width=s,t.height=n;}function Gi(t,e,i,s){const n=i.padding;let{x:o,y:a}=e;for(const r of t){const t=r.box,l=s[r.stack]||{count:1,placed:0,weight:1},h=r.stackWeight/l.weight||1;if(r.horizontal){const s=e.w*h,o=l.size||t.height;M(l.start)&&(a=l.start),t.fullSize?Ki(t,n.left,a,i.outerWidth-n.right-n.left,o):Ki(t,e.left+l.placed,a,s,o),l.start=a,l.placed+=s,a=t.bottom;}else {const s=e.h*h,a=l.size||t.width;M(l.start)&&(o=l.start),t.fullSize?Ki(t,o,n.top,a,i.outerHeight-n.bottom-n.top):Ki(t,o,e.top+l.placed,a,s),l.start=o,l.placed+=s,o=t.right;}}e.x=o,e.y=a;}ne.set("layout",{autoPadding:!0,padding:{top:0,right:0,bottom:0,left:0}});var Zi={addBox(t,e){t.boxes||(t.boxes=[]),e.fullSize=e.fullSize||!1,e.position=e.position||"top",e.weight=e.weight||0,e._layers=e._layers||function(){return [{z:0,draw(t){e.draw(t);}}]},t.boxes.push(e);},removeBox(t,e){const i=t.boxes?t.boxes.indexOf(e):-1;-1!==i&&t.boxes.splice(i,1);},configure(t,e,i){e.fullSize=i.fullSize,e.position=i.position,e.weight=i.weight;},update(t,e,i,s){if(!t)return;const n=pi(t.options.layout.padding),o=Math.max(e-n.width,0),a=Math.max(i-n.height,0),r=function(t){const e=function(t){const e=[];let i,s,n,o,a,r;for(i=0,s=(t||[]).length;i<s;++i)n=t[i],({position:o,options:{stack:a,stackWeight:r=1}}=n),e.push({index:i,box:n,pos:o,horizontal:n.isHorizontal(),weight:n.weight,stack:a&&o+a,stackWeight:r});return e}(t),i=ji(e.filter((t=>t.box.fullSize)),!0),s=ji(Ni(e,"left"),!0),n=ji(Ni(e,"right")),o=ji(Ni(e,"top"),!0),a=ji(Ni(e,"bottom")),r=Wi(e,"x"),l=Wi(e,"y");return {fullSize:i,leftAndTop:s.concat(o),rightAndBottom:n.concat(l).concat(a).concat(r),chartArea:Ni(e,"chartArea"),vertical:s.concat(n).concat(l),horizontal:o.concat(a).concat(r)}}(t.boxes),l=r.vertical,h=r.horizontal;d(t.boxes,(t=>{"function"==typeof t.beforeLayout&&t.beforeLayout();}));const c=l.reduce(((t,e)=>e.box.options&&!1===e.box.options.display?t:t+1),0)||1,u=Object.freeze({outerWidth:e,outerHeight:i,padding:n,availableWidth:o,availableHeight:a,vBoxMaxWidth:o/2/c,hBoxMaxHeight:a/2}),f=Object.assign({},n);Yi(f,pi(s));const g=Object.assign({maxPadding:f,w:o,h:a,x:n.left,y:n.top},n),p=Hi(l.concat(h),u);qi(r.fullSize,g,u,p),qi(l,g,u,p),qi(h,g,u,p)&&qi(l,g,u,p),function(t){const e=t.maxPadding;function i(i){const s=Math.max(e[i]-t[i],0);return t[i]+=s,s}t.y+=i("top"),t.x+=i("left"),i("right"),i("bottom");}(g),Gi(r.leftAndTop,g,u,p),g.x+=g.w,g.y+=g.h,Gi(r.rightAndBottom,g,u,p),t.chartArea={left:g.left,top:g.top,right:g.left+g.w,bottom:g.top+g.h,height:g.h,width:g.w},d(r.chartArea,(e=>{const i=e.box;Object.assign(i,t.chartArea),i.update(g.w,g.h,{left:0,top:0,right:0,bottom:0});}));}};class Ji{acquireContext(t,e){}releaseContext(t){return !1}addEventListener(t,e,i){}removeEventListener(t,e,i){}getDevicePixelRatio(){return 1}getMaximumSize(t,e,i,s){return e=Math.max(0,e||t.width),i=i||t.height,{width:e,height:Math.max(0,s?Math.floor(e/s):i)}}isAttached(t){return !0}updateConfig(t){}}class Qi extends Ji{acquireContext(t){return t&&t.getContext&&t.getContext("2d")||null}updateConfig(t){t.options.animation=!1;}}const ts={touchstart:"mousedown",touchmove:"mousemove",touchend:"mouseup",pointerenter:"mouseenter",pointerdown:"mousedown",pointermove:"mousemove",pointerup:"mouseup",pointerleave:"mouseout",pointerout:"mouseout"},es=t=>null===t||""===t;const is=!!me&&{passive:!0};function ss(t,e,i){t.canvas.removeEventListener(e,i,is);}function ns(t,e){for(const i of t)if(i===e||i.contains(e))return !0}function os(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||ns(i.addedNodes,s),e=e&&!ns(i.removedNodes,s);e&&i();}));return n.observe(document,{childList:!0,subtree:!0}),n}function as(t,e,i){const s=t.canvas,n=new MutationObserver((t=>{let e=!1;for(const i of t)e=e||ns(i.removedNodes,s),e=e&&!ns(i.addedNodes,s);e&&i();}));return n.observe(document,{childList:!0,subtree:!0}),n}const rs=new Map;let ls=0;function hs(){const t=window.devicePixelRatio;t!==ls&&(ls=t,rs.forEach(((e,i)=>{i.currentDevicePixelRatio!==t&&e();})));}function cs(t,e,i){const s=t.canvas,n=s&&ae(s);if(!n)return;const o=ht(((t,e)=>{const s=n.clientWidth;i(t,e),s<n.clientWidth&&i();}),window),a=new ResizeObserver((t=>{const e=t[0],i=e.contentRect.width,s=e.contentRect.height;0===i&&0===s||o(i,s);}));return a.observe(n),function(t,e){rs.size||window.addEventListener("resize",hs),rs.set(t,e);}(t,o),a}function ds(t,e,i){i&&i.disconnect(),"resize"===e&&function(t){rs.delete(t),rs.size||window.removeEventListener("resize",hs);}(t);}function us(t,e,i){const s=t.canvas,n=ht((e=>{null!==t.ctx&&i(function(t,e){const i=ts[t.type]||t.type,{x:s,y:n}=ue(t,e);return {type:i,chart:e,native:t,x:void 0!==s?s:null,y:void 0!==n?n:null}}(e,t));}),t,(t=>{const e=t[0];return [e,e.offsetX,e.offsetY]}));return function(t,e,i){t.addEventListener(e,i,is);}(s,e,n),n}class fs extends Ji{acquireContext(t,e){const i=t&&t.getContext&&t.getContext("2d");return i&&i.canvas===t?(function(t,e){const i=t.style,s=t.getAttribute("height"),n=t.getAttribute("width");if(t.$chartjs={initial:{height:s,width:n,style:{display:i.display,height:i.height,width:i.width}}},i.display=i.display||"block",i.boxSizing=i.boxSizing||"border-box",es(n)){const e=be(t,"width");void 0!==e&&(t.width=e);}if(es(s))if(""===t.style.height)t.height=t.width/(e||2);else {const e=be(t,"height");void 0!==e&&(t.height=e);}}(t,e),i):null}releaseContext(t){const e=t.canvas;if(!e.$chartjs)return !1;const s=e.$chartjs.initial;["height","width"].forEach((t=>{const n=s[t];i(n)?e.removeAttribute(t):e.setAttribute(t,n);}));const n=s.style||{};return Object.keys(n).forEach((t=>{e.style[t]=n[t];})),e.width=e.width,delete e.$chartjs,!0}addEventListener(t,e,i){this.removeEventListener(t,e);const s=t.$proxies||(t.$proxies={}),n={attach:os,detach:as,resize:cs}[e]||us;s[e]=n(t,e,i);}removeEventListener(t,e){const i=t.$proxies||(t.$proxies={}),s=i[e];if(!s)return;(({attach:ds,detach:ds,resize:ds})[e]||ss)(t,e,s),i[e]=void 0;}getDevicePixelRatio(){return window.devicePixelRatio}getMaximumSize(t,e,i,s){return ge(t,e,i,s)}isAttached(t){const e=ae(t);return !(!e||!e.isConnected)}}function gs(t){return !oe()||"undefined"!=typeof OffscreenCanvas&&t instanceof OffscreenCanvas?Qi:fs}var ps=Object.freeze({__proto__:null,_detectPlatform:gs,BasePlatform:Ji,BasicPlatform:Qi,DomPlatform:fs});const ms="transparent",bs={boolean:(t,e,i)=>i>.5?e:t,color(t,e,i){const s=Jt(t||ms),n=s.valid&&Jt(e||ms);return n&&n.valid?n.mix(s,i).hexString():e},number:(t,e,i)=>t+(e-t)*i};class xs{constructor(t,e,i,s){const n=e[i];s=bi([t.to,s,n,t.from]);const o=bi([t.from,n,s]);this._active=!0,this._fn=t.fn||bs[t.type||typeof o],this._easing=si[t.easing]||si.linear,this._start=Math.floor(Date.now()+(t.delay||0)),this._duration=this._total=Math.floor(t.duration),this._loop=!!t.loop,this._target=e,this._prop=i,this._from=o,this._to=s,this._promises=void 0;}active(){return this._active}update(t,e,i){if(this._active){this._notify(!1);const s=this._target[this._prop],n=i-this._start,o=this._duration-n;this._start=i,this._duration=Math.floor(Math.max(o,t.duration)),this._total+=n,this._loop=!!t.loop,this._to=bi([t.to,e,s,t.from]),this._from=bi([t.from,s,e]);}}cancel(){this._active&&(this.tick(Date.now()),this._active=!1,this._notify(!1));}tick(t){const e=t-this._start,i=this._duration,s=this._prop,n=this._from,o=this._loop,a=this._to;let r;if(this._active=n!==a&&(o||e<i),!this._active)return this._target[s]=a,void this._notify(!0);e<0?this._target[s]=n:(r=e/i%2,r=o&&r>1?2-r:r,r=this._easing(Math.min(1,Math.max(0,r))),this._target[s]=this._fn(n,a,r));}wait(){const t=this._promises||(this._promises=[]);return new Promise(((e,i)=>{t.push({res:e,rej:i});}))}_notify(t){const e=t?"res":"rej",i=this._promises||[];for(let t=0;t<i.length;t++)i[t][e]();}}ne.set("animation",{delay:void 0,duration:1e3,easing:"easeOutQuart",fn:void 0,from:void 0,loop:void 0,to:void 0,type:void 0});const _s=Object.keys(ne.animation);ne.describe("animation",{_fallback:!1,_indexable:!1,_scriptable:t=>"onProgress"!==t&&"onComplete"!==t&&"fn"!==t}),ne.set("animations",{colors:{type:"color",properties:["color","borderColor","backgroundColor"]},numbers:{type:"number",properties:["x","y","borderWidth","radius","tension"]}}),ne.describe("animations",{_fallback:"animation"}),ne.set("transitions",{active:{animation:{duration:400}},resize:{animation:{duration:0}},show:{animations:{colors:{from:"transparent"},visible:{type:"boolean",duration:0}}},hide:{animations:{colors:{to:"transparent"},visible:{type:"boolean",easing:"linear",fn:t=>0|t}}}});class ys{constructor(t,e){this._chart=t,this._properties=new Map,this.configure(e);}configure(t){if(!n(t))return;const e=this._properties;Object.getOwnPropertyNames(t).forEach((i=>{const o=t[i];if(!n(o))return;const a={};for(const t of _s)a[t]=o[t];(s(o.properties)&&o.properties||[i]).forEach((t=>{t!==i&&e.has(t)||e.set(t,a);}));}));}_animateOptions(t,e){const i=e.options,s=function(t,e){if(!e)return;let i=t.options;if(!i)return void(t.options=e);i.$shared&&(t.options=i=Object.assign({},i,{$shared:!1,$animations:{}}));return i}(t,i);if(!s)return [];const n=this._createAnimations(s,i);return i.$shared&&function(t,e){const i=[],s=Object.keys(e);for(let e=0;e<s.length;e++){const n=t[s[e]];n&&n.active()&&i.push(n.wait());}return Promise.all(i)}(t.options.$animations,i).then((()=>{t.options=i;}),(()=>{})),n}_createAnimations(t,e){const i=this._properties,s=[],n=t.$animations||(t.$animations={}),o=Object.keys(e),a=Date.now();let r;for(r=o.length-1;r>=0;--r){const l=o[r];if("$"===l.charAt(0))continue;if("options"===l){s.push(...this._animateOptions(t,e));continue}const h=e[l];let c=n[l];const d=i.get(l);if(c){if(d&&c.active()){c.update(d,h,a);continue}c.cancel();}d&&d.duration?(n[l]=c=new xs(d,t,l,h),s.push(c)):t[l]=h;}return s}update(t,e){if(0===this._properties.size)return void Object.assign(t,e);const i=this._createAnimations(t,e);return i.length?(mt.add(this._chart,i),!0):void 0}}function vs(t,e){const i=t&&t.options||{},s=i.reverse,n=void 0===i.min?e:0,o=void 0===i.max?e:0;return {start:s?o:n,end:s?n:o}}function ws(t,e){const i=[],s=t._getSortedDatasetMetas(e);let n,o;for(n=0,o=s.length;n<o;++n)i.push(s[n].index);return i}function Ms(t,e,i,s={}){const n=t.keys,a="single"===s.mode;let r,l,h,c;if(null!==e){for(r=0,l=n.length;r<l;++r){if(h=+n[r],h===i){if(s.all)continue;break}c=t.values[h],o(c)&&(a||0===e||z(e)===z(c))&&(e+=c);}return e}}function ks(t,e){const i=t&&t.options.stacked;return i||void 0===i&&void 0!==e.stack}function Ss(t,e,i){const s=t[e]||(t[e]={});return s[i]||(s[i]={})}function Ps(t,e,i,s){for(const n of e.getMatchingVisibleMetas(s).reverse()){const e=t[n.index];if(i&&e>0||!i&&e<0)return n.index}return null}function Ds(t,e){const{chart:i,_cachedMeta:s}=t,n=i._stacks||(i._stacks={}),{iScale:o,vScale:a,index:r}=s,l=o.axis,h=a.axis,c=function(t,e,i){return `${t.id}.${e.id}.${i.stack||i.type}`}(o,a,s),d=e.length;let u;for(let t=0;t<d;++t){const i=e[t],{[l]:o,[h]:d}=i;u=(i._stacks||(i._stacks={}))[h]=Ss(n,c,o),u[r]=d,u._top=Ps(u,a,!0,s.type),u._bottom=Ps(u,a,!1,s.type);}}function Os(t,e){const i=t.scales;return Object.keys(i).filter((t=>i[t].axis===e)).shift()}function Cs(t,e){const i=t.controller.index,s=t.vScale&&t.vScale.axis;if(s){e=e||t._parsed;for(const t of e){const e=t._stacks;if(!e||void 0===e[s]||void 0===e[s][i])return;delete e[s][i];}}}const As=t=>"reset"===t||"none"===t,Ts=(t,e)=>e?t:Object.assign({},t);class Ls{constructor(t,e){this.chart=t,this._ctx=t.ctx,this.index=e,this._cachedDataOpts={},this._cachedMeta=this.getMeta(),this._type=this._cachedMeta.type,this.options=void 0,this._parsing=!1,this._data=void 0,this._objectData=void 0,this._sharedOptions=void 0,this._drawStart=void 0,this._drawCount=void 0,this.enableOptionSharing=!1,this.supportsDecimation=!1,this.$context=void 0,this._syncList=[],this.initialize();}initialize(){const t=this._cachedMeta;this.configure(),this.linkScales(),t._stacked=ks(t.vScale,t),this.addElements();}updateIndex(t){this.index!==t&&Cs(this._cachedMeta),this.index=t;}linkScales(){const t=this.chart,e=this._cachedMeta,i=this.getDataset(),s=(t,e,i,s)=>"x"===t?e:"r"===t?s:i,n=e.xAxisID=r(i.xAxisID,Os(t,"x")),o=e.yAxisID=r(i.yAxisID,Os(t,"y")),a=e.rAxisID=r(i.rAxisID,Os(t,"r")),l=e.indexAxis,h=e.iAxisID=s(l,n,o,a),c=e.vAxisID=s(l,o,n,a);e.xScale=this.getScaleForId(n),e.yScale=this.getScaleForId(o),e.rScale=this.getScaleForId(a),e.iScale=this.getScaleForId(h),e.vScale=this.getScaleForId(c);}getDataset(){return this.chart.data.datasets[this.index]}getMeta(){return this.chart.getDatasetMeta(this.index)}getScaleForId(t){return this.chart.scales[t]}_getOtherScale(t){const e=this._cachedMeta;return t===e.iScale?e.vScale:e.iScale}reset(){this._update("reset");}_destroy(){const t=this._cachedMeta;this._data&&at(this._data,this),t._stacked&&Cs(t);}_dataCheck(){const t=this.getDataset(),e=t.data||(t.data=[]),i=this._data;if(n(e))this._data=function(t){const e=Object.keys(t),i=new Array(e.length);let s,n,o;for(s=0,n=e.length;s<n;++s)o=e[s],i[s]={x:o,y:t[o]};return i}(e);else if(i!==e){if(i){at(i,this);const t=this._cachedMeta;Cs(t),t._parsed=[];}e&&Object.isExtensible(e)&&ot(e,this),this._syncList=[],this._data=e;}}addElements(){const t=this._cachedMeta;this._dataCheck(),this.datasetElementType&&(t.dataset=new this.datasetElementType);}buildOrUpdateElements(t){const e=this._cachedMeta,i=this.getDataset();let s=!1;this._dataCheck();const n=e._stacked;e._stacked=ks(e.vScale,e),e.stack!==i.stack&&(s=!0,Cs(e),e.stack=i.stack),this._resyncElements(t),(s||n!==e._stacked)&&Ds(this,e._parsed);}configure(){const t=this.chart.config,e=t.datasetScopeKeys(this._type),i=t.getOptionScopes(this.getDataset(),e,!0);this.options=t.createResolver(i,this.getContext()),this._parsing=this.options.parsing,this._cachedDataOpts={};}parse(t,e){const{_cachedMeta:i,_data:o}=this,{iScale:a,_stacked:r}=i,l=a.axis;let h,c,d,u=0===t&&e===o.length||i._sorted,f=t>0&&i._parsed[t-1];if(!1===this._parsing)i._parsed=o,i._sorted=!0,d=o;else {d=s(o[t])?this.parseArrayData(i,o,t,e):n(o[t])?this.parseObjectData(i,o,t,e):this.parsePrimitiveData(i,o,t,e);const a=()=>null===c[l]||f&&c[l]<f[l];for(h=0;h<e;++h)i._parsed[h+t]=c=d[h],u&&(a()&&(u=!1),f=c);i._sorted=u;}r&&Ds(this,d);}parsePrimitiveData(t,e,i,s){const{iScale:n,vScale:o}=t,a=n.axis,r=o.axis,l=n.getLabels(),h=n===o,c=new Array(s);let d,u,f;for(d=0,u=s;d<u;++d)f=d+i,c[d]={[a]:h||n.parse(l[f],f),[r]:o.parse(e[f],f)};return c}parseArrayData(t,e,i,s){const{xScale:n,yScale:o}=t,a=new Array(s);let r,l,h,c;for(r=0,l=s;r<l;++r)h=r+i,c=e[h],a[r]={x:n.parse(c[0],h),y:o.parse(c[1],h)};return a}parseObjectData(t,e,i,s){const{xScale:n,yScale:o}=t,{xAxisKey:a="x",yAxisKey:r="y"}=this._parsing,l=new Array(s);let h,c,d,u;for(h=0,c=s;h<c;++h)d=h+i,u=e[d],l[h]={x:n.parse(y(u,a),d),y:o.parse(y(u,r),d)};return l}getParsed(t){return this._cachedMeta._parsed[t]}getDataElement(t){return this._cachedMeta.data[t]}applyStack(t,e,i){const s=this.chart,n=this._cachedMeta,o=e[t.axis];return Ms({keys:ws(s,!0),values:e._stacks[t.axis]},o,n.index,{mode:i})}updateRangeFromParsed(t,e,i,s){const n=i[e.axis];let o=null===n?NaN:n;const a=s&&i._stacks[e.axis];s&&a&&(s.values=a,o=Ms(s,n,this._cachedMeta.index)),t.min=Math.min(t.min,o),t.max=Math.max(t.max,o);}getMinMax(t,e){const i=this._cachedMeta,s=i._parsed,n=i._sorted&&t===i.iScale,a=s.length,r=this._getOtherScale(t),l=((t,e,i)=>t&&!e.hidden&&e._stacked&&{keys:ws(i,!0),values:null})(e,i,this.chart),h={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY},{min:c,max:d}=function(t){const{min:e,max:i,minDefined:s,maxDefined:n}=t.getUserBounds();return {min:s?e:Number.NEGATIVE_INFINITY,max:n?i:Number.POSITIVE_INFINITY}}(r);let u,f;function g(){f=s[u];const e=f[r.axis];return !o(f[t.axis])||c>e||d<e}for(u=0;u<a&&(g()||(this.updateRangeFromParsed(h,t,f,l),!n));++u);if(n)for(u=a-1;u>=0;--u)if(!g()){this.updateRangeFromParsed(h,t,f,l);break}return h}getAllParsedValues(t){const e=this._cachedMeta._parsed,i=[];let s,n,a;for(s=0,n=e.length;s<n;++s)a=e[s][t.axis],o(a)&&i.push(a);return i}getMaxOverflow(){return !1}getLabelAndValue(t){const e=this._cachedMeta,i=e.iScale,s=e.vScale,n=this.getParsed(t);return {label:i?""+i.getLabelForValue(n[i.axis]):"",value:s?""+s.getLabelForValue(n[s.axis]):""}}_update(t){const e=this._cachedMeta;this.update(t||"default"),e._clip=function(t){let e,i,s,o;return n(t)?(e=t.top,i=t.right,s=t.bottom,o=t.left):e=i=s=o=t,{top:e,right:i,bottom:s,left:o,disabled:!1===t}}(r(this.options.clip,function(t,e,i){if(!1===i)return !1;const s=vs(t,i),n=vs(e,i);return {top:n.end,right:s.end,bottom:n.start,left:s.start}}(e.xScale,e.yScale,this.getMaxOverflow())));}update(t){}draw(){const t=this._ctx,e=this.chart,i=this._cachedMeta,s=i.data||[],n=e.chartArea,o=[],a=this._drawStart||0,r=this._drawCount||s.length-a,l=this.options.drawActiveElementsOnTop;let h;for(i.dataset&&i.dataset.draw(t,n,a,r),h=a;h<a+r;++h){const e=s[h];e.hidden||(e.active&&l?o.push(e):e.draw(t,n));}for(h=0;h<o.length;++h)o[h].draw(t,n);}getStyle(t,e){const i=e?"active":"default";return void 0===t&&this._cachedMeta.dataset?this.resolveDatasetElementOptions(i):this.resolveDataElementOptions(t||0,i)}getContext(t,e,i){const s=this.getDataset();let n;if(t>=0&&t<this._cachedMeta.data.length){const e=this._cachedMeta.data[t];n=e.$context||(e.$context=function(t,e,i){return _i(t,{active:!1,dataIndex:e,parsed:void 0,raw:void 0,element:i,index:e,mode:"default",type:"data"})}(this.getContext(),t,e)),n.parsed=this.getParsed(t),n.raw=s.data[t],n.index=n.dataIndex=t;}else n=this.$context||(this.$context=function(t,e){return _i(t,{active:!1,dataset:void 0,datasetIndex:e,index:e,mode:"default",type:"dataset"})}(this.chart.getContext(),this.index)),n.dataset=s,n.index=n.datasetIndex=this.index;return n.active=!!e,n.mode=i,n}resolveDatasetElementOptions(t){return this._resolveElementOptions(this.datasetElementType.id,t)}resolveDataElementOptions(t,e){return this._resolveElementOptions(this.dataElementType.id,e,t)}_resolveElementOptions(t,e="default",i){const s="active"===e,n=this._cachedDataOpts,o=t+"-"+e,a=n[o],r=this.enableOptionSharing&&M(i);if(a)return Ts(a,r);const l=this.chart.config,h=l.datasetElementScopeKeys(this._type,t),c=s?[`${t}Hover`,"hover",t,""]:[t,""],d=l.getOptionScopes(this.getDataset(),h),u=Object.keys(ne.elements[t]),f=l.resolveNamedOptions(d,u,(()=>this.getContext(i,s)),c);return f.$shared&&(f.$shared=r,n[o]=Object.freeze(Ts(f,r))),f}_resolveAnimations(t,e,i){const s=this.chart,n=this._cachedDataOpts,o=`animation-${e}`,a=n[o];if(a)return a;let r;if(!1!==s.options.animation){const s=this.chart.config,n=s.datasetAnimationScopeKeys(this._type,e),o=s.getOptionScopes(this.getDataset(),n);r=s.createResolver(o,this.getContext(t,i,e));}const l=new ys(s,r&&r.animations);return r&&r._cacheable&&(n[o]=Object.freeze(l)),l}getSharedOptions(t){if(t.$shared)return this._sharedOptions||(this._sharedOptions=Object.assign({},t))}includeOptions(t,e){return !e||As(t)||this.chart._animationsDisabled}_getSharedOptions(t,e){const i=this.resolveDataElementOptions(t,e),s=this._sharedOptions,n=this.getSharedOptions(i),o=this.includeOptions(e,n)||n!==s;return this.updateSharedOptions(n,e,i),{sharedOptions:n,includeOptions:o}}updateElement(t,e,i,s){As(s)?Object.assign(t,i):this._resolveAnimations(e,s).update(t,i);}updateSharedOptions(t,e,i){t&&!As(e)&&this._resolveAnimations(void 0,e).update(t,i);}_setStyle(t,e,i,s){t.active=s;const n=this.getStyle(e,s);this._resolveAnimations(e,i,s).update(t,{options:!s&&this.getSharedOptions(n)||n});}removeHoverStyle(t,e,i){this._setStyle(t,i,"active",!1);}setHoverStyle(t,e,i){this._setStyle(t,i,"active",!0);}_removeDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!1);}_setDatasetHoverStyle(){const t=this._cachedMeta.dataset;t&&this._setStyle(t,void 0,"active",!0);}_resyncElements(t){const e=this._data,i=this._cachedMeta.data;for(const[t,e,i]of this._syncList)this[t](e,i);this._syncList=[];const s=i.length,n=e.length,o=Math.min(n,s);o&&this.parse(0,o),n>s?this._insertElements(s,n-s,t):n<s&&this._removeElements(n,s-n);}_insertElements(t,e,i=!0){const s=this._cachedMeta,n=s.data,o=t+e;let a;const r=t=>{for(t.length+=e,a=t.length-1;a>=o;a--)t[a]=t[a-e];};for(r(n),a=t;a<o;++a)n[a]=new this.dataElementType;this._parsing&&r(s._parsed),this.parse(t,e),i&&this.updateElements(n,t,e,"reset");}updateElements(t,e,i,s){}_removeElements(t,e){const i=this._cachedMeta;if(this._parsing){const s=i._parsed.splice(t,e);i._stacked&&Cs(i,s);}i.data.splice(t,e);}_sync(t){if(this._parsing)this._syncList.push(t);else {const[e,i,s]=t;this[e](i,s);}this.chart._dataChanges.push([this.index,...t]);}_onDataPush(){const t=arguments.length;this._sync(["_insertElements",this.getDataset().data.length-t,t]);}_onDataPop(){this._sync(["_removeElements",this._cachedMeta.data.length-1,1]);}_onDataShift(){this._sync(["_removeElements",0,1]);}_onDataSplice(t,e){e&&this._sync(["_removeElements",t,e]);const i=arguments.length-2;i&&this._sync(["_insertElements",t,i]);}_onDataUnshift(){this._sync(["_insertElements",0,arguments.length]);}}Ls.defaults={},Ls.prototype.datasetElementType=null,Ls.prototype.dataElementType=null;class Es{constructor(){this.x=void 0,this.y=void 0,this.active=!1,this.options=void 0,this.$animations=void 0;}tooltipPosition(t){const{x:e,y:i}=this.getProps(["x","y"],t);return {x:e,y:i}}hasValue(){return B(this.x)&&B(this.y)}getProps(t,e){const i=this.$animations;if(!e||!i)return this;const s={};return t.forEach((t=>{s[t]=i[t]&&i[t].active()?i[t]._to:this[t];})),s}}Es.defaults={},Es.defaultRoutes=void 0;const Rs={values:t=>s(t)?t:""+t,numeric(t,e,i){if(0===t)return "0";const s=this.chart.options.locale;let n,o=t;if(i.length>1){const e=Math.max(Math.abs(i[0].value),Math.abs(i[i.length-1].value));(e<1e-4||e>1e15)&&(n="scientific"),o=function(t,e){let i=e.length>3?e[2].value-e[1].value:e[1].value-e[0].value;Math.abs(i)>=1&&t!==Math.floor(t)&&(i=t-Math.floor(t));return i}(t,i);}const a=I(Math.abs(o)),r=Math.max(Math.min(-1*Math.floor(a),20),0),l={notation:n,minimumFractionDigits:r,maximumFractionDigits:r};return Object.assign(l,this.options.ticks.format),li(t,s,l)},logarithmic(t,e,i){if(0===t)return "0";const s=t/Math.pow(10,Math.floor(I(t)));return 1===s||2===s||5===s?Rs.numeric.call(this,t,e,i):""}};var Is={formatters:Rs};function zs(t,e){const s=t.options.ticks,n=s.maxTicksLimit||function(t){const e=t.options.offset,i=t._tickSize(),s=t._length/i+(e?0:1),n=t._maxLength/i;return Math.floor(Math.min(s,n))}(t),o=s.major.enabled?function(t){const e=[];let i,s;for(i=0,s=t.length;i<s;i++)t[i].major&&e.push(i);return e}(e):[],a=o.length,r=o[0],l=o[a-1],h=[];if(a>n)return function(t,e,i,s){let n,o=0,a=i[0];for(s=Math.ceil(s),n=0;n<t.length;n++)n===a&&(e.push(t[n]),o++,a=i[o*s]);}(e,h,o,a/n),h;const c=function(t,e,i){const s=function(t){const e=t.length;let i,s;if(e<2)return !1;for(s=t[0],i=1;i<e;++i)if(t[i]-t[i-1]!==s)return !1;return s}(t),n=e.length/i;if(!s)return Math.max(n,1);const o=V(s);for(let t=0,e=o.length-1;t<e;t++){const e=o[t];if(e>n)return e}return Math.max(n,1)}(o,e,n);if(a>0){let t,s;const n=a>1?Math.round((l-r)/(a-1)):null;for(Fs(e,h,c,i(n)?0:r-n,r),t=0,s=a-1;t<s;t++)Fs(e,h,c,o[t],o[t+1]);return Fs(e,h,c,l,i(n)?e.length:l+n),h}return Fs(e,h,c),h}function Fs(t,e,i,s,n){const o=r(s,0),a=Math.min(r(n,t.length),t.length);let l,h,c,d=0;for(i=Math.ceil(i),n&&(l=n-s,i=l/Math.floor(l/i)),c=o;c<0;)d++,c=Math.round(o+d*i);for(h=Math.max(o,0);h<a;h++)h===c&&(e.push(t[h]),d++,c=Math.round(o+d*i));}ne.set("scale",{display:!0,offset:!1,reverse:!1,beginAtZero:!1,bounds:"ticks",grace:0,grid:{display:!0,lineWidth:1,drawBorder:!0,drawOnChartArea:!0,drawTicks:!0,tickLength:8,tickWidth:(t,e)=>e.lineWidth,tickColor:(t,e)=>e.color,offset:!1,borderDash:[],borderDashOffset:0,borderWidth:1},title:{display:!1,text:"",padding:{top:4,bottom:4}},ticks:{minRotation:0,maxRotation:50,mirror:!1,textStrokeWidth:0,textStrokeColor:"",padding:3,display:!0,autoSkip:!0,autoSkipPadding:3,labelOffset:0,callback:Is.formatters.values,minor:{},major:{},align:"center",crossAlign:"near",showLabelBackdrop:!1,backdropColor:"rgba(255, 255, 255, 0.75)",backdropPadding:2}}),ne.route("scale.ticks","color","","color"),ne.route("scale.grid","color","","borderColor"),ne.route("scale.grid","borderColor","","borderColor"),ne.route("scale.title","color","","color"),ne.describe("scale",{_fallback:!1,_scriptable:t=>!t.startsWith("before")&&!t.startsWith("after")&&"callback"!==t&&"parser"!==t,_indexable:t=>"borderDash"!==t&&"tickBorderDash"!==t}),ne.describe("scales",{_fallback:"scale"}),ne.describe("scale.ticks",{_scriptable:t=>"backdropPadding"!==t&&"callback"!==t,_indexable:t=>"backdropPadding"!==t});const Vs=(t,e,i)=>"top"===e||"left"===e?t[e]+i:t[e]-i;function Bs(t,e){const i=[],s=t.length/e,n=t.length;let o=0;for(;o<n;o+=s)i.push(t[Math.floor(o)]);return i}function Ns(t,e,i){const s=t.ticks.length,n=Math.min(e,s-1),o=t._startPixel,a=t._endPixel,r=1e-6;let l,h=t.getPixelForTick(n);if(!(i&&(l=1===s?Math.max(h-o,a-h):0===e?(t.getPixelForTick(1)-h)/2:(h-t.getPixelForTick(n-1))/2,h+=n<e?l:-l,h<o-r||h>a+r)))return h}function Ws(t){return t.drawTicks?t.tickLength:0}function js(t,e){if(!t.display)return 0;const i=mi(t.font,e),n=pi(t.padding);return (s(t.text)?t.text.length:1)*i.lineHeight+n.height}function Hs(t,e,i){let s=dt(t);return (i&&"right"!==e||!i&&"right"===e)&&(s=(t=>"left"===t?"right":"right"===t?"left":t)(s)),s}class $s extends Es{constructor(t){super(),this.id=t.id,this.type=t.type,this.options=void 0,this.ctx=t.ctx,this.chart=t.chart,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this._margins={left:0,right:0,top:0,bottom:0},this.maxWidth=void 0,this.maxHeight=void 0,this.paddingTop=void 0,this.paddingBottom=void 0,this.paddingLeft=void 0,this.paddingRight=void 0,this.axis=void 0,this.labelRotation=void 0,this.min=void 0,this.max=void 0,this._range=void 0,this.ticks=[],this._gridLineItems=null,this._labelItems=null,this._labelSizes=null,this._length=0,this._maxLength=0,this._longestTextCache={},this._startPixel=void 0,this._endPixel=void 0,this._reversePixels=!1,this._userMax=void 0,this._userMin=void 0,this._suggestedMax=void 0,this._suggestedMin=void 0,this._ticksLength=0,this._borderValue=0,this._cache={},this._dataLimitsCached=!1,this.$context=void 0;}init(t){this.options=t.setContext(this.getContext()),this.axis=t.axis,this._userMin=this.parse(t.min),this._userMax=this.parse(t.max),this._suggestedMin=this.parse(t.suggestedMin),this._suggestedMax=this.parse(t.suggestedMax);}parse(t,e){return t}getUserBounds(){let{_userMin:t,_userMax:e,_suggestedMin:i,_suggestedMax:s}=this;return t=a(t,Number.POSITIVE_INFINITY),e=a(e,Number.NEGATIVE_INFINITY),i=a(i,Number.POSITIVE_INFINITY),s=a(s,Number.NEGATIVE_INFINITY),{min:a(t,i),max:a(e,s),minDefined:o(t),maxDefined:o(e)}}getMinMax(t){let e,{min:i,max:s,minDefined:n,maxDefined:o}=this.getUserBounds();if(n&&o)return {min:i,max:s};const r=this.getMatchingVisibleMetas();for(let a=0,l=r.length;a<l;++a)e=r[a].controller.getMinMax(this,t),n||(i=Math.min(i,e.min)),o||(s=Math.max(s,e.max));return i=o&&i>s?s:i,s=n&&i>s?i:s,{min:a(i,a(s,i)),max:a(s,a(i,s))}}getPadding(){return {left:this.paddingLeft||0,top:this.paddingTop||0,right:this.paddingRight||0,bottom:this.paddingBottom||0}}getTicks(){return this.ticks}getLabels(){const t=this.chart.data;return this.options.labels||(this.isHorizontal()?t.xLabels:t.yLabels)||t.labels||[]}beforeLayout(){this._cache={},this._dataLimitsCached=!1;}beforeUpdate(){c(this.options.beforeUpdate,[this]);}update(t,e,i){const{beginAtZero:s,grace:n,ticks:o}=this.options,a=o.sampleSize;this.beforeUpdate(),this.maxWidth=t,this.maxHeight=e,this._margins=i=Object.assign({left:0,right:0,top:0,bottom:0},i),this.ticks=null,this._labelSizes=null,this._gridLineItems=null,this._labelItems=null,this.beforeSetDimensions(),this.setDimensions(),this.afterSetDimensions(),this._maxLength=this.isHorizontal()?this.width+i.left+i.right:this.height+i.top+i.bottom,this._dataLimitsCached||(this.beforeDataLimits(),this.determineDataLimits(),this.afterDataLimits(),this._range=xi(this,n,s),this._dataLimitsCached=!0),this.beforeBuildTicks(),this.ticks=this.buildTicks()||[],this.afterBuildTicks();const r=a<this.ticks.length;this._convertTicksToLabels(r?Bs(this.ticks,a):this.ticks),this.configure(),this.beforeCalculateLabelRotation(),this.calculateLabelRotation(),this.afterCalculateLabelRotation(),o.display&&(o.autoSkip||"auto"===o.source)&&(this.ticks=zs(this,this.ticks),this._labelSizes=null,this.afterAutoSkip()),r&&this._convertTicksToLabels(this.ticks),this.beforeFit(),this.fit(),this.afterFit(),this.afterUpdate();}configure(){let t,e,i=this.options.reverse;this.isHorizontal()?(t=this.left,e=this.right):(t=this.top,e=this.bottom,i=!i),this._startPixel=t,this._endPixel=e,this._reversePixels=i,this._length=e-t,this._alignToPixels=this.options.alignToPixels;}afterUpdate(){c(this.options.afterUpdate,[this]);}beforeSetDimensions(){c(this.options.beforeSetDimensions,[this]);}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=0,this.right=this.width):(this.height=this.maxHeight,this.top=0,this.bottom=this.height),this.paddingLeft=0,this.paddingTop=0,this.paddingRight=0,this.paddingBottom=0;}afterSetDimensions(){c(this.options.afterSetDimensions,[this]);}_callHooks(t){this.chart.notifyPlugins(t,this.getContext()),c(this.options[t],[this]);}beforeDataLimits(){this._callHooks("beforeDataLimits");}determineDataLimits(){}afterDataLimits(){this._callHooks("afterDataLimits");}beforeBuildTicks(){this._callHooks("beforeBuildTicks");}buildTicks(){return []}afterBuildTicks(){this._callHooks("afterBuildTicks");}beforeTickToLabelConversion(){c(this.options.beforeTickToLabelConversion,[this]);}generateTickLabels(t){const e=this.options.ticks;let i,s,n;for(i=0,s=t.length;i<s;i++)n=t[i],n.label=c(e.callback,[n.value,i,t],this);}afterTickToLabelConversion(){c(this.options.afterTickToLabelConversion,[this]);}beforeCalculateLabelRotation(){c(this.options.beforeCalculateLabelRotation,[this]);}calculateLabelRotation(){const t=this.options,e=t.ticks,i=this.ticks.length,s=e.minRotation||0,n=e.maxRotation;let o,a,r,l=s;if(!this._isVisible()||!e.display||s>=n||i<=1||!this.isHorizontal())return void(this.labelRotation=s);const h=this._getLabelSizes(),c=h.widest.width,d=h.highest.height,u=Z(this.chart.width-c,0,this.maxWidth);o=t.offset?this.maxWidth/i:u/(i-1),c+6>o&&(o=u/(i-(t.offset?.5:1)),a=this.maxHeight-Ws(t.grid)-e.padding-js(t.title,this.chart.options.font),r=Math.sqrt(c*c+d*d),l=$(Math.min(Math.asin(Z((h.highest.height+6)/o,-1,1)),Math.asin(Z(a/r,-1,1))-Math.asin(Z(d/r,-1,1)))),l=Math.max(s,Math.min(n,l))),this.labelRotation=l;}afterCalculateLabelRotation(){c(this.options.afterCalculateLabelRotation,[this]);}afterAutoSkip(){}beforeFit(){c(this.options.beforeFit,[this]);}fit(){const t={width:0,height:0},{chart:e,options:{ticks:i,title:s,grid:n}}=this,o=this._isVisible(),a=this.isHorizontal();if(o){const o=js(s,e.options.font);if(a?(t.width=this.maxWidth,t.height=Ws(n)+o):(t.height=this.maxHeight,t.width=Ws(n)+o),i.display&&this.ticks.length){const{first:e,last:s,widest:n,highest:o}=this._getLabelSizes(),r=2*i.padding,l=H(this.labelRotation),h=Math.cos(l),c=Math.sin(l);if(a){const e=i.mirror?0:c*n.width+h*o.height;t.height=Math.min(this.maxHeight,t.height+e+r);}else {const e=i.mirror?0:h*n.width+c*o.height;t.width=Math.min(this.maxWidth,t.width+e+r);}this._calculatePadding(e,s,c,h);}}this._handleMargins(),a?(this.width=this._length=e.width-this._margins.left-this._margins.right,this.height=t.height):(this.width=t.width,this.height=this._length=e.height-this._margins.top-this._margins.bottom);}_calculatePadding(t,e,i,s){const{ticks:{align:n,padding:o},position:a}=this.options,r=0!==this.labelRotation,l="top"!==a&&"x"===this.axis;if(this.isHorizontal()){const a=this.getPixelForTick(0)-this.left,h=this.right-this.getPixelForTick(this.ticks.length-1);let c=0,d=0;r?l?(c=s*t.width,d=i*e.height):(c=i*t.height,d=s*e.width):"start"===n?d=e.width:"end"===n?c=t.width:"inner"!==n&&(c=t.width/2,d=e.width/2),this.paddingLeft=Math.max((c-a+o)*this.width/(this.width-a),0),this.paddingRight=Math.max((d-h+o)*this.width/(this.width-h),0);}else {let i=e.height/2,s=t.height/2;"start"===n?(i=0,s=t.height):"end"===n&&(i=e.height,s=0),this.paddingTop=i+o,this.paddingBottom=s+o;}}_handleMargins(){this._margins&&(this._margins.left=Math.max(this.paddingLeft,this._margins.left),this._margins.top=Math.max(this.paddingTop,this._margins.top),this._margins.right=Math.max(this.paddingRight,this._margins.right),this._margins.bottom=Math.max(this.paddingBottom,this._margins.bottom));}afterFit(){c(this.options.afterFit,[this]);}isHorizontal(){const{axis:t,position:e}=this.options;return "top"===e||"bottom"===e||"x"===t}isFullSize(){return this.options.fullSize}_convertTicksToLabels(t){let e,s;for(this.beforeTickToLabelConversion(),this.generateTickLabels(t),e=0,s=t.length;e<s;e++)i(t[e].label)&&(t.splice(e,1),s--,e--);this.afterTickToLabelConversion();}_getLabelSizes(){let t=this._labelSizes;if(!t){const e=this.options.ticks.sampleSize;let i=this.ticks;e<i.length&&(i=Bs(i,e)),this._labelSizes=t=this._computeLabelSizes(i,i.length);}return t}_computeLabelSizes(t,e){const{ctx:n,_longestTextCache:o}=this,a=[],r=[];let l,h,c,u,f,g,p,m,b,x,_,y=0,v=0;for(l=0;l<e;++l){if(u=t[l].label,f=this._resolveTickFontOptions(l),n.font=g=f.string,p=o[g]=o[g]||{data:{},gc:[]},m=f.lineHeight,b=x=0,i(u)||s(u)){if(s(u))for(h=0,c=u.length;h<c;++h)_=u[h],i(_)||s(_)||(b=_e(n,p.data,p.gc,b,_),x+=m);}else b=_e(n,p.data,p.gc,b,u),x=m;a.push(b),r.push(x),y=Math.max(b,y),v=Math.max(x,v);}!function(t,e){d(t,(t=>{const i=t.gc,s=i.length/2;let n;if(s>e){for(n=0;n<s;++n)delete t.data[i[n]];i.splice(0,s);}}));}(o,e);const w=a.indexOf(y),M=r.indexOf(v),k=t=>({width:a[t]||0,height:r[t]||0});return {first:k(0),last:k(e-1),widest:k(w),highest:k(M),widths:a,heights:r}}getLabelForValue(t){return t}getPixelForValue(t,e){return NaN}getValueForPixel(t){}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getPixelForDecimal(t){this._reversePixels&&(t=1-t);const e=this._startPixel+t*this._length;return J(this._alignToPixels?ve(this.chart,e,0):e)}getDecimalForPixel(t){const e=(t-this._startPixel)/this._length;return this._reversePixels?1-e:e}getBasePixel(){return this.getPixelForValue(this.getBaseValue())}getBaseValue(){const{min:t,max:e}=this;return t<0&&e<0?e:t>0&&e>0?t:0}getContext(t){const e=this.ticks||[];if(t>=0&&t<e.length){const i=e[t];return i.$context||(i.$context=function(t,e,i){return _i(t,{tick:i,index:e,type:"tick"})}(this.getContext(),t,i))}return this.$context||(this.$context=_i(this.chart.getContext(),{scale:this,type:"scale"}))}_tickSize(){const t=this.options.ticks,e=H(this.labelRotation),i=Math.abs(Math.cos(e)),s=Math.abs(Math.sin(e)),n=this._getLabelSizes(),o=t.autoSkipPadding||0,a=n?n.widest.width+o:0,r=n?n.highest.height+o:0;return this.isHorizontal()?r*i>a*s?a/i:r/s:r*s<a*i?r/i:a/s}_isVisible(){const t=this.options.display;return "auto"!==t?!!t:this.getMatchingVisibleMetas().length>0}_computeGridLineItems(t){const e=this.axis,i=this.chart,s=this.options,{grid:o,position:a}=s,l=o.offset,h=this.isHorizontal(),c=this.ticks.length+(l?1:0),d=Ws(o),u=[],f=o.setContext(this.getContext()),g=f.drawBorder?f.borderWidth:0,p=g/2,m=function(t){return ve(i,t,g)};let b,x,_,y,v,w,M,k,S,P,D,O;if("top"===a)b=m(this.bottom),w=this.bottom-d,k=b-p,P=m(t.top)+p,O=t.bottom;else if("bottom"===a)b=m(this.top),P=t.top,O=m(t.bottom)-p,w=b+p,k=this.top+d;else if("left"===a)b=m(this.right),v=this.right-d,M=b-p,S=m(t.left)+p,D=t.right;else if("right"===a)b=m(this.left),S=t.left,D=m(t.right)-p,v=b+p,M=this.left+d;else if("x"===e){if("center"===a)b=m((t.top+t.bottom)/2+.5);else if(n(a)){const t=Object.keys(a)[0],e=a[t];b=m(this.chart.scales[t].getPixelForValue(e));}P=t.top,O=t.bottom,w=b+p,k=w+d;}else if("y"===e){if("center"===a)b=m((t.left+t.right)/2);else if(n(a)){const t=Object.keys(a)[0],e=a[t];b=m(this.chart.scales[t].getPixelForValue(e));}v=b-p,M=v-d,S=t.left,D=t.right;}const C=r(s.ticks.maxTicksLimit,c),A=Math.max(1,Math.ceil(c/C));for(x=0;x<c;x+=A){const t=o.setContext(this.getContext(x)),e=t.lineWidth,s=t.color,n=t.borderDash||[],a=t.borderDashOffset,r=t.tickWidth,c=t.tickColor,d=t.tickBorderDash||[],f=t.tickBorderDashOffset;_=Ns(this,x,l),void 0!==_&&(y=ve(i,_,e),h?v=M=S=D=y:w=k=P=O=y,u.push({tx1:v,ty1:w,tx2:M,ty2:k,x1:S,y1:P,x2:D,y2:O,width:e,color:s,borderDash:n,borderDashOffset:a,tickWidth:r,tickColor:c,tickBorderDash:d,tickBorderDashOffset:f}));}return this._ticksLength=c,this._borderValue=b,u}_computeLabelItems(t){const e=this.axis,i=this.options,{position:o,ticks:a}=i,r=this.isHorizontal(),l=this.ticks,{align:h,crossAlign:c,padding:d,mirror:u}=a,f=Ws(i.grid),g=f+d,p=u?-d:g,m=-H(this.labelRotation),b=[];let x,_,y,v,w,M,k,S,P,D,O,C,A="middle";if("top"===o)M=this.bottom-p,k=this._getXAxisLabelAlignment();else if("bottom"===o)M=this.top+p,k=this._getXAxisLabelAlignment();else if("left"===o){const t=this._getYAxisLabelAlignment(f);k=t.textAlign,w=t.x;}else if("right"===o){const t=this._getYAxisLabelAlignment(f);k=t.textAlign,w=t.x;}else if("x"===e){if("center"===o)M=(t.top+t.bottom)/2+g;else if(n(o)){const t=Object.keys(o)[0],e=o[t];M=this.chart.scales[t].getPixelForValue(e)+g;}k=this._getXAxisLabelAlignment();}else if("y"===e){if("center"===o)w=(t.left+t.right)/2-g;else if(n(o)){const t=Object.keys(o)[0],e=o[t];w=this.chart.scales[t].getPixelForValue(e);}k=this._getYAxisLabelAlignment(f).textAlign;}"y"===e&&("start"===h?A="top":"end"===h&&(A="bottom"));const T=this._getLabelSizes();for(x=0,_=l.length;x<_;++x){y=l[x],v=y.label;const t=a.setContext(this.getContext(x));S=this.getPixelForTick(x)+a.labelOffset,P=this._resolveTickFontOptions(x),D=P.lineHeight,O=s(v)?v.length:1;const e=O/2,i=t.color,n=t.textStrokeColor,h=t.textStrokeWidth;let d,f=k;if(r?(w=S,"inner"===k&&(f=x===_-1?this.options.reverse?"left":"right":0===x?this.options.reverse?"right":"left":"center"),C="top"===o?"near"===c||0!==m?-O*D+D/2:"center"===c?-T.highest.height/2-e*D+D:-T.highest.height+D/2:"near"===c||0!==m?D/2:"center"===c?T.highest.height/2-e*D:T.highest.height-O*D,u&&(C*=-1)):(M=S,C=(1-O)*D/2),t.showLabelBackdrop){const e=pi(t.backdropPadding),i=T.heights[x],s=T.widths[x];let n=M+C-e.top,o=w-e.left;switch(A){case"middle":n-=i/2;break;case"bottom":n-=i;}switch(k){case"center":o-=s/2;break;case"right":o-=s;}d={left:o,top:n,width:s+e.width,height:i+e.height,color:t.backdropColor};}b.push({rotation:m,label:v,font:P,color:i,strokeColor:n,strokeWidth:h,textOffset:C,textAlign:f,textBaseline:A,translation:[w,M],backdrop:d});}return b}_getXAxisLabelAlignment(){const{position:t,ticks:e}=this.options;if(-H(this.labelRotation))return "top"===t?"left":"right";let i="center";return "start"===e.align?i="left":"end"===e.align?i="right":"inner"===e.align&&(i="inner"),i}_getYAxisLabelAlignment(t){const{position:e,ticks:{crossAlign:i,mirror:s,padding:n}}=this.options,o=t+n,a=this._getLabelSizes().widest.width;let r,l;return "left"===e?s?(l=this.right+n,"near"===i?r="left":"center"===i?(r="center",l+=a/2):(r="right",l+=a)):(l=this.right-o,"near"===i?r="right":"center"===i?(r="center",l-=a/2):(r="left",l=this.left)):"right"===e?s?(l=this.left+n,"near"===i?r="right":"center"===i?(r="center",l-=a/2):(r="left",l-=a)):(l=this.left+o,"near"===i?r="left":"center"===i?(r="center",l+=a/2):(r="right",l=this.right)):r="right",{textAlign:r,x:l}}_computeLabelArea(){if(this.options.ticks.mirror)return;const t=this.chart,e=this.options.position;return "left"===e||"right"===e?{top:0,left:this.left,bottom:t.height,right:this.right}:"top"===e||"bottom"===e?{top:this.top,left:0,bottom:this.bottom,right:t.width}:void 0}drawBackground(){const{ctx:t,options:{backgroundColor:e},left:i,top:s,width:n,height:o}=this;e&&(t.save(),t.fillStyle=e,t.fillRect(i,s,n,o),t.restore());}getLineWidthForValue(t){const e=this.options.grid;if(!this._isVisible()||!e.display)return 0;const i=this.ticks.findIndex((e=>e.value===t));if(i>=0){return e.setContext(this.getContext(i)).lineWidth}return 0}drawGrid(t){const e=this.options.grid,i=this.ctx,s=this._gridLineItems||(this._gridLineItems=this._computeGridLineItems(t));let n,o;const a=(t,e,s)=>{s.width&&s.color&&(i.save(),i.lineWidth=s.width,i.strokeStyle=s.color,i.setLineDash(s.borderDash||[]),i.lineDashOffset=s.borderDashOffset,i.beginPath(),i.moveTo(t.x,t.y),i.lineTo(e.x,e.y),i.stroke(),i.restore());};if(e.display)for(n=0,o=s.length;n<o;++n){const t=s[n];e.drawOnChartArea&&a({x:t.x1,y:t.y1},{x:t.x2,y:t.y2},t),e.drawTicks&&a({x:t.tx1,y:t.ty1},{x:t.tx2,y:t.ty2},{color:t.tickColor,width:t.tickWidth,borderDash:t.tickBorderDash,borderDashOffset:t.tickBorderDashOffset});}}drawBorder(){const{chart:t,ctx:e,options:{grid:i}}=this,s=i.setContext(this.getContext()),n=i.drawBorder?s.borderWidth:0;if(!n)return;const o=i.setContext(this.getContext(0)).lineWidth,a=this._borderValue;let r,l,h,c;this.isHorizontal()?(r=ve(t,this.left,n)-n/2,l=ve(t,this.right,o)+o/2,h=c=a):(h=ve(t,this.top,n)-n/2,c=ve(t,this.bottom,o)+o/2,r=l=a),e.save(),e.lineWidth=s.borderWidth,e.strokeStyle=s.borderColor,e.beginPath(),e.moveTo(r,h),e.lineTo(l,c),e.stroke(),e.restore();}drawLabels(t){if(!this.options.ticks.display)return;const e=this.ctx,i=this._computeLabelArea();i&&Pe(e,i);const s=this._labelItems||(this._labelItems=this._computeLabelItems(t));let n,o;for(n=0,o=s.length;n<o;++n){const t=s[n],i=t.font,o=t.label;t.backdrop&&(e.fillStyle=t.backdrop.color,e.fillRect(t.backdrop.left,t.backdrop.top,t.backdrop.width,t.backdrop.height)),Ae(e,o,0,t.textOffset,i,t);}i&&De(e);}drawTitle(){const{ctx:t,options:{position:e,title:i,reverse:o}}=this;if(!i.display)return;const a=mi(i.font),r=pi(i.padding),l=i.align;let h=a.lineHeight/2;"bottom"===e||"center"===e||n(e)?(h+=r.bottom,s(i.text)&&(h+=a.lineHeight*(i.text.length-1))):h+=r.top;const{titleX:c,titleY:d,maxWidth:u,rotation:f}=function(t,e,i,s){const{top:o,left:a,bottom:r,right:l,chart:h}=t,{chartArea:c,scales:d}=h;let u,f,g,p=0;const m=r-o,b=l-a;if(t.isHorizontal()){if(f=ut(s,a,l),n(i)){const t=Object.keys(i)[0],s=i[t];g=d[t].getPixelForValue(s)+m-e;}else g="center"===i?(c.bottom+c.top)/2+m-e:Vs(t,i,e);u=l-a;}else {if(n(i)){const t=Object.keys(i)[0],s=i[t];f=d[t].getPixelForValue(s)-b+e;}else f="center"===i?(c.left+c.right)/2-b+e:Vs(t,i,e);g=ut(s,r,o),p="left"===i?-L:L;}return {titleX:f,titleY:g,maxWidth:u,rotation:p}}(this,h,e,l);Ae(t,i.text,0,0,a,{color:i.color,maxWidth:u,rotation:f,textAlign:Hs(l,e,o),textBaseline:"middle",translation:[c,d]});}draw(t){this._isVisible()&&(this.drawBackground(),this.drawGrid(t),this.drawBorder(),this.drawTitle(),this.drawLabels(t));}_layers(){const t=this.options,e=t.ticks&&t.ticks.z||0,i=r(t.grid&&t.grid.z,-1);return this._isVisible()&&this.draw===$s.prototype.draw?[{z:i,draw:t=>{this.drawBackground(),this.drawGrid(t),this.drawTitle();}},{z:i+1,draw:()=>{this.drawBorder();}},{z:e,draw:t=>{this.drawLabels(t);}}]:[{z:e,draw:t=>{this.draw(t);}}]}getMatchingVisibleMetas(t){const e=this.chart.getSortedVisibleDatasetMetas(),i=this.axis+"AxisID",s=[];let n,o;for(n=0,o=e.length;n<o;++n){const o=e[n];o[i]!==this.id||t&&o.type!==t||s.push(o);}return s}_resolveTickFontOptions(t){return mi(this.options.ticks.setContext(this.getContext(t)).font)}_maxDigits(){const t=this._resolveTickFontOptions(0).lineHeight;return (this.isHorizontal()?this.width:this.height)/t}}class Ys{constructor(t,e,i){this.type=t,this.scope=e,this.override=i,this.items=Object.create(null);}isForType(t){return Object.prototype.isPrototypeOf.call(this.type.prototype,t.prototype)}register(t){const e=Object.getPrototypeOf(t);let i;(function(t){return "id"in t&&"defaults"in t})(e)&&(i=this.register(e));const s=this.items,n=t.id,o=this.scope+"."+n;if(!n)throw new Error("class does not have id: "+t);return n in s||(s[n]=t,function(t,e,i){const s=m(Object.create(null),[i?ne.get(i):{},ne.get(e),t.defaults]);ne.set(e,s),t.defaultRoutes&&function(t,e){Object.keys(e).forEach((i=>{const s=i.split("."),n=s.pop(),o=[t].concat(s).join("."),a=e[i].split("."),r=a.pop(),l=a.join(".");ne.route(o,n,l,r);}));}(e,t.defaultRoutes);t.descriptors&&ne.describe(e,t.descriptors);}(t,o,i),this.override&&ne.override(t.id,t.overrides)),o}get(t){return this.items[t]}unregister(t){const e=this.items,i=t.id,s=this.scope;i in e&&delete e[i],s&&i in ne[s]&&(delete ne[s][i],this.override&&delete te[i]);}}var Us=new class{constructor(){this.controllers=new Ys(Ls,"datasets",!0),this.elements=new Ys(Es,"elements"),this.plugins=new Ys(Object,"plugins"),this.scales=new Ys($s,"scales"),this._typedRegistries=[this.controllers,this.scales,this.elements];}add(...t){this._each("register",t);}remove(...t){this._each("unregister",t);}addControllers(...t){this._each("register",t,this.controllers);}addElements(...t){this._each("register",t,this.elements);}addPlugins(...t){this._each("register",t,this.plugins);}addScales(...t){this._each("register",t,this.scales);}getController(t){return this._get(t,this.controllers,"controller")}getElement(t){return this._get(t,this.elements,"element")}getPlugin(t){return this._get(t,this.plugins,"plugin")}getScale(t){return this._get(t,this.scales,"scale")}removeControllers(...t){this._each("unregister",t,this.controllers);}removeElements(...t){this._each("unregister",t,this.elements);}removePlugins(...t){this._each("unregister",t,this.plugins);}removeScales(...t){this._each("unregister",t,this.scales);}_each(t,e,i){[...e].forEach((e=>{const s=i||this._getRegistryForType(e);i||s.isForType(e)||s===this.plugins&&e.id?this._exec(t,s,e):d(e,(e=>{const s=i||this._getRegistryForType(e);this._exec(t,s,e);}));}));}_exec(t,e,i){const s=w(t);c(i["before"+s],[],i),e[t](i),c(i["after"+s],[],i);}_getRegistryForType(t){for(let e=0;e<this._typedRegistries.length;e++){const i=this._typedRegistries[e];if(i.isForType(t))return i}return this.plugins}_get(t,e,i){const s=e.get(t);if(void 0===s)throw new Error('"'+t+'" is not a registered '+i+".");return s}};class Xs{constructor(){this._init=[];}notify(t,e,i,s){"beforeInit"===e&&(this._init=this._createDescriptors(t,!0),this._notify(this._init,t,"install"));const n=s?this._descriptors(t).filter(s):this._descriptors(t),o=this._notify(n,t,e,i);return "afterDestroy"===e&&(this._notify(n,t,"stop"),this._notify(this._init,t,"uninstall")),o}_notify(t,e,i,s){s=s||{};for(const n of t){const t=n.plugin;if(!1===c(t[i],[e,s,n.options],t)&&s.cancelable)return !1}return !0}invalidate(){i(this._cache)||(this._oldCache=this._cache,this._cache=void 0);}_descriptors(t){if(this._cache)return this._cache;const e=this._cache=this._createDescriptors(t);return this._notifyStateChanges(t),e}_createDescriptors(t,e){const i=t&&t.config,s=r(i.options&&i.options.plugins,{}),n=function(t){const e={},i=[],s=Object.keys(Us.plugins.items);for(let t=0;t<s.length;t++)i.push(Us.getPlugin(s[t]));const n=t.plugins||[];for(let t=0;t<n.length;t++){const s=n[t];-1===i.indexOf(s)&&(i.push(s),e[s.id]=!0);}return {plugins:i,localIds:e}}(i);return !1!==s||e?function(t,{plugins:e,localIds:i},s,n){const o=[],a=t.getContext();for(const r of e){const e=r.id,l=qs(s[e],n);null!==l&&o.push({plugin:r,options:Ks(t.config,{plugin:r,local:i[e]},l,a)});}return o}(t,n,s,e):[]}_notifyStateChanges(t){const e=this._oldCache||[],i=this._cache,s=(t,e)=>t.filter((t=>!e.some((e=>t.plugin.id===e.plugin.id))));this._notify(s(e,i),t,"stop"),this._notify(s(i,e),t,"start");}}function qs(t,e){return e||!1!==t?!0===t?{}:t:null}function Ks(t,{plugin:e,local:i},s,n){const o=t.pluginScopeKeys(e),a=t.getOptionScopes(s,o);return i&&e.defaults&&a.push(e.defaults),t.createResolver(a,n,[""],{scriptable:!1,indexable:!1,allKeys:!0})}function Gs(t,e){const i=ne.datasets[t]||{};return ((e.datasets||{})[t]||{}).indexAxis||e.indexAxis||i.indexAxis||"x"}function Zs(t,e){return "x"===t||"y"===t?t:e.axis||("top"===(i=e.position)||"bottom"===i?"x":"left"===i||"right"===i?"y":void 0)||t.charAt(0).toLowerCase();var i;}function Js(t){const e=t.options||(t.options={});e.plugins=r(e.plugins,{}),e.scales=function(t,e){const i=te[t.type]||{scales:{}},s=e.scales||{},o=Gs(t.type,e),a=Object.create(null),r=Object.create(null);return Object.keys(s).forEach((t=>{const e=s[t];if(!n(e))return console.error(`Invalid scale configuration for scale: ${t}`);if(e._proxy)return console.warn(`Ignoring resolver passed as options for scale: ${t}`);const l=Zs(t,e),h=function(t,e){return t===e?"_index_":"_value_"}(l,o),c=i.scales||{};a[l]=a[l]||t,r[t]=b(Object.create(null),[{axis:l},e,c[l],c[h]]);})),t.data.datasets.forEach((i=>{const n=i.type||t.type,o=i.indexAxis||Gs(n,e),l=(te[n]||{}).scales||{};Object.keys(l).forEach((t=>{const e=function(t,e){let i=t;return "_index_"===t?i=e:"_value_"===t&&(i="x"===e?"y":"x"),i}(t,o),n=i[e+"AxisID"]||a[e]||e;r[n]=r[n]||Object.create(null),b(r[n],[{axis:e},s[n],l[t]]);}));})),Object.keys(r).forEach((t=>{const e=r[t];b(e,[ne.scales[e.type],ne.scale]);})),r}(t,e);}function Qs(t){return (t=t||{}).datasets=t.datasets||[],t.labels=t.labels||[],t}const tn=new Map,en=new Set;function sn(t,e){let i=tn.get(t);return i||(i=e(),tn.set(t,i),en.add(i)),i}const nn=(t,e,i)=>{const s=y(e,i);void 0!==s&&t.add(s);};class on{constructor(t){this._config=function(t){return (t=t||{}).data=Qs(t.data),Js(t),t}(t),this._scopeCache=new Map,this._resolverCache=new Map;}get platform(){return this._config.platform}get type(){return this._config.type}set type(t){this._config.type=t;}get data(){return this._config.data}set data(t){this._config.data=Qs(t);}get options(){return this._config.options}set options(t){this._config.options=t;}get plugins(){return this._config.plugins}update(){const t=this._config;this.clearCache(),Js(t);}clearCache(){this._scopeCache.clear(),this._resolverCache.clear();}datasetScopeKeys(t){return sn(t,(()=>[[`datasets.${t}`,""]]))}datasetAnimationScopeKeys(t,e){return sn(`${t}.transition.${e}`,(()=>[[`datasets.${t}.transitions.${e}`,`transitions.${e}`],[`datasets.${t}`,""]]))}datasetElementScopeKeys(t,e){return sn(`${t}-${e}`,(()=>[[`datasets.${t}.elements.${e}`,`datasets.${t}`,`elements.${e}`,""]]))}pluginScopeKeys(t){const e=t.id;return sn(`${this.type}-plugin-${e}`,(()=>[[`plugins.${e}`,...t.additionalOptionScopes||[]]]))}_cachedScopes(t,e){const i=this._scopeCache;let s=i.get(t);return s&&!e||(s=new Map,i.set(t,s)),s}getOptionScopes(t,e,i){const{options:s,type:n}=this,o=this._cachedScopes(t,i),a=o.get(e);if(a)return a;const r=new Set;e.forEach((e=>{t&&(r.add(t),e.forEach((e=>nn(r,t,e)))),e.forEach((t=>nn(r,s,t))),e.forEach((t=>nn(r,te[n]||{},t))),e.forEach((t=>nn(r,ne,t))),e.forEach((t=>nn(r,ee,t)));}));const l=Array.from(r);return 0===l.length&&l.push(Object.create(null)),en.has(e)&&o.set(e,l),l}chartOptionScopes(){const{options:t,type:e}=this;return [t,te[e]||{},ne.datasets[e]||{},{type:e},ne,ee]}resolveNamedOptions(t,e,i,n=[""]){const o={$shared:!0},{resolver:a,subPrefixes:r}=an(this._resolverCache,t,n);let l=a;if(function(t,e){const{isScriptable:i,isIndexable:n}=Ie(t);for(const o of e){const e=i(o),a=n(o),r=(a||e)&&t[o];if(e&&(k(r)||rn(r))||a&&s(r))return !0}return !1}(a,e)){o.$shared=!1;l=Re(a,i=k(i)?i():i,this.createResolver(t,i,r));}for(const t of e)o[t]=l[t];return o}createResolver(t,e,i=[""],s){const{resolver:o}=an(this._resolverCache,t,i);return n(e)?Re(o,e,void 0,s):o}}function an(t,e,i){let s=t.get(e);s||(s=new Map,t.set(e,s));const n=i.join();let o=s.get(n);if(!o){o={resolver:Ee(e,i),subPrefixes:i.filter((t=>!t.toLowerCase().includes("hover")))},s.set(n,o);}return o}const rn=t=>n(t)&&Object.getOwnPropertyNames(t).reduce(((e,i)=>e||k(t[i])),!1);const ln=["top","bottom","left","right","chartArea"];function hn(t,e){return "top"===t||"bottom"===t||-1===ln.indexOf(t)&&"x"===e}function cn(t,e){return function(i,s){return i[t]===s[t]?i[e]-s[e]:i[t]-s[t]}}function dn(t){const e=t.chart,i=e.options.animation;e.notifyPlugins("afterRender"),c(i&&i.onComplete,[t],e);}function un(t){const e=t.chart,i=e.options.animation;c(i&&i.onProgress,[t],e);}function fn(t){return oe()&&"string"==typeof t?t=document.getElementById(t):t&&t.length&&(t=t[0]),t&&t.canvas&&(t=t.canvas),t}const gn={},pn=t=>{const e=fn(t);return Object.values(gn).filter((t=>t.canvas===e)).pop()};function mn(t,e,i){const s=Object.keys(t);for(const n of s){const s=+n;if(s>=e){const o=t[n];delete t[n],(i>0||s>e)&&(t[s+i]=o);}}}class bn{constructor(t,i){const s=this.config=new on(i),n=fn(t),o=pn(n);if(o)throw new Error("Canvas is already in use. Chart with ID '"+o.id+"' must be destroyed before the canvas with ID '"+o.canvas.id+"' can be reused.");const a=s.createResolver(s.chartOptionScopes(),this.getContext());this.platform=new(s.platform||gs(n)),this.platform.updateConfig(s);const r=this.platform.acquireContext(n,a.aspectRatio),l=r&&r.canvas,h=l&&l.height,c=l&&l.width;this.id=e(),this.ctx=r,this.canvas=l,this.width=c,this.height=h,this._options=a,this._aspectRatio=this.aspectRatio,this._layers=[],this._metasets=[],this._stacks=void 0,this.boxes=[],this.currentDevicePixelRatio=void 0,this.chartArea=void 0,this._active=[],this._lastEvent=void 0,this._listeners={},this._responsiveListeners=void 0,this._sortedMetasets=[],this.scales={},this._plugins=new Xs,this.$proxies={},this._hiddenIndices={},this.attached=!1,this._animationsDisabled=void 0,this.$context=void 0,this._doResize=ct((t=>this.update(t)),a.resizeDelay||0),this._dataChanges=[],gn[this.id]=this,r&&l?(mt.listen(this,"complete",dn),mt.listen(this,"progress",un),this._initialize(),this.attached&&this.update()):console.error("Failed to create chart: can't acquire context from the given item");}get aspectRatio(){const{options:{aspectRatio:t,maintainAspectRatio:e},width:s,height:n,_aspectRatio:o}=this;return i(t)?e&&o?o:n?s/n:null:t}get data(){return this.config.data}set data(t){this.config.data=t;}get options(){return this._options}set options(t){this.config.options=t;}_initialize(){return this.notifyPlugins("beforeInit"),this.options.responsive?this.resize():pe(this,this.options.devicePixelRatio),this.bindEvents(),this.notifyPlugins("afterInit"),this}clear(){return we(this.canvas,this.ctx),this}stop(){return mt.stop(this),this}resize(t,e){mt.running(this)?this._resizeBeforeDraw={width:t,height:e}:this._resize(t,e);}_resize(t,e){const i=this.options,s=this.canvas,n=i.maintainAspectRatio&&this.aspectRatio,o=this.platform.getMaximumSize(s,t,e,n),a=i.devicePixelRatio||this.platform.getDevicePixelRatio(),r=this.width?"resize":"attach";this.width=o.width,this.height=o.height,this._aspectRatio=this.aspectRatio,pe(this,a,!0)&&(this.notifyPlugins("resize",{size:o}),c(i.onResize,[this,o],this),this.attached&&this._doResize(r)&&this.render());}ensureScalesHaveIDs(){d(this.options.scales||{},((t,e)=>{t.id=e;}));}buildOrUpdateScales(){const t=this.options,e=t.scales,i=this.scales,s=Object.keys(i).reduce(((t,e)=>(t[e]=!1,t)),{});let n=[];e&&(n=n.concat(Object.keys(e).map((t=>{const i=e[t],s=Zs(t,i),n="r"===s,o="x"===s;return {options:i,dposition:n?"chartArea":o?"bottom":"left",dtype:n?"radialLinear":o?"category":"linear"}})))),d(n,(e=>{const n=e.options,o=n.id,a=Zs(o,n),l=r(n.type,e.dtype);void 0!==n.position&&hn(n.position,a)===hn(e.dposition)||(n.position=e.dposition),s[o]=!0;let h=null;if(o in i&&i[o].type===l)h=i[o];else {h=new(Us.getScale(l))({id:o,type:l,ctx:this.ctx,chart:this}),i[h.id]=h;}h.init(n,t);})),d(s,((t,e)=>{t||delete i[e];})),d(i,(t=>{Zi.configure(this,t,t.options),Zi.addBox(this,t);}));}_updateMetasets(){const t=this._metasets,e=this.data.datasets.length,i=t.length;if(t.sort(((t,e)=>t.index-e.index)),i>e){for(let t=e;t<i;++t)this._destroyDatasetMeta(t);t.splice(e,i-e);}this._sortedMetasets=t.slice(0).sort(cn("order","index"));}_removeUnreferencedMetasets(){const{_metasets:t,data:{datasets:e}}=this;t.length>e.length&&delete this._stacks,t.forEach(((t,i)=>{0===e.filter((e=>e===t._dataset)).length&&this._destroyDatasetMeta(i);}));}buildOrUpdateControllers(){const t=[],e=this.data.datasets;let i,s;for(this._removeUnreferencedMetasets(),i=0,s=e.length;i<s;i++){const s=e[i];let n=this.getDatasetMeta(i);const o=s.type||this.config.type;if(n.type&&n.type!==o&&(this._destroyDatasetMeta(i),n=this.getDatasetMeta(i)),n.type=o,n.indexAxis=s.indexAxis||Gs(o,this.options),n.order=s.order||0,n.index=i,n.label=""+s.label,n.visible=this.isDatasetVisible(i),n.controller)n.controller.updateIndex(i),n.controller.linkScales();else {const e=Us.getController(o),{datasetElementType:s,dataElementType:a}=ne.datasets[o];Object.assign(e.prototype,{dataElementType:Us.getElement(a),datasetElementType:s&&Us.getElement(s)}),n.controller=new e(this,i),t.push(n.controller);}}return this._updateMetasets(),t}_resetElements(){d(this.data.datasets,((t,e)=>{this.getDatasetMeta(e).controller.reset();}),this);}reset(){this._resetElements(),this.notifyPlugins("reset");}update(t){const e=this.config;e.update();const i=this._options=e.createResolver(e.chartOptionScopes(),this.getContext()),s=this._animationsDisabled=!i.animation;if(this._updateScales(),this._checkEventBindings(),this._updateHiddenIndices(),this._plugins.invalidate(),!1===this.notifyPlugins("beforeUpdate",{mode:t,cancelable:!0}))return;const n=this.buildOrUpdateControllers();this.notifyPlugins("beforeElementsUpdate");let o=0;for(let t=0,e=this.data.datasets.length;t<e;t++){const{controller:e}=this.getDatasetMeta(t),i=!s&&-1===n.indexOf(e);e.buildOrUpdateElements(i),o=Math.max(+e.getMaxOverflow(),o);}o=this._minPadding=i.layout.autoPadding?o:0,this._updateLayout(o),s||d(n,(t=>{t.reset();})),this._updateDatasets(t),this.notifyPlugins("afterUpdate",{mode:t}),this._layers.sort(cn("z","_idx"));const{_active:a,_lastEvent:r}=this;r?this._eventHandler(r,!0):a.length&&this._updateHoverStyles(a,a,!0),this.render();}_updateScales(){d(this.scales,(t=>{Zi.removeBox(this,t);})),this.ensureScalesHaveIDs(),this.buildOrUpdateScales();}_checkEventBindings(){const t=this.options,e=new Set(Object.keys(this._listeners)),i=new Set(t.events);S(e,i)&&!!this._responsiveListeners===t.responsive||(this.unbindEvents(),this.bindEvents());}_updateHiddenIndices(){const{_hiddenIndices:t}=this,e=this._getUniformDataChanges()||[];for(const{method:i,start:s,count:n}of e){mn(t,s,"_removeElements"===i?-n:n);}}_getUniformDataChanges(){const t=this._dataChanges;if(!t||!t.length)return;this._dataChanges=[];const e=this.data.datasets.length,i=e=>new Set(t.filter((t=>t[0]===e)).map(((t,e)=>e+","+t.splice(1).join(",")))),s=i(0);for(let t=1;t<e;t++)if(!S(s,i(t)))return;return Array.from(s).map((t=>t.split(","))).map((t=>({method:t[1],start:+t[2],count:+t[3]})))}_updateLayout(t){if(!1===this.notifyPlugins("beforeLayout",{cancelable:!0}))return;Zi.update(this,this.width,this.height,t);const e=this.chartArea,i=e.width<=0||e.height<=0;this._layers=[],d(this.boxes,(t=>{i&&"chartArea"===t.position||(t.configure&&t.configure(),this._layers.push(...t._layers()));}),this),this._layers.forEach(((t,e)=>{t._idx=e;})),this.notifyPlugins("afterLayout");}_updateDatasets(t){if(!1!==this.notifyPlugins("beforeDatasetsUpdate",{mode:t,cancelable:!0})){for(let t=0,e=this.data.datasets.length;t<e;++t)this.getDatasetMeta(t).controller.configure();for(let e=0,i=this.data.datasets.length;e<i;++e)this._updateDataset(e,k(t)?t({datasetIndex:e}):t);this.notifyPlugins("afterDatasetsUpdate",{mode:t});}}_updateDataset(t,e){const i=this.getDatasetMeta(t),s={meta:i,index:t,mode:e,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetUpdate",s)&&(i.controller._update(e),s.cancelable=!1,this.notifyPlugins("afterDatasetUpdate",s));}render(){!1!==this.notifyPlugins("beforeRender",{cancelable:!0})&&(mt.has(this)?this.attached&&!mt.running(this)&&mt.start(this):(this.draw(),dn({chart:this})));}draw(){let t;if(this._resizeBeforeDraw){const{width:t,height:e}=this._resizeBeforeDraw;this._resize(t,e),this._resizeBeforeDraw=null;}if(this.clear(),this.width<=0||this.height<=0)return;if(!1===this.notifyPlugins("beforeDraw",{cancelable:!0}))return;const e=this._layers;for(t=0;t<e.length&&e[t].z<=0;++t)e[t].draw(this.chartArea);for(this._drawDatasets();t<e.length;++t)e[t].draw(this.chartArea);this.notifyPlugins("afterDraw");}_getSortedDatasetMetas(t){const e=this._sortedMetasets,i=[];let s,n;for(s=0,n=e.length;s<n;++s){const n=e[s];t&&!n.visible||i.push(n);}return i}getSortedVisibleDatasetMetas(){return this._getSortedDatasetMetas(!0)}_drawDatasets(){if(!1===this.notifyPlugins("beforeDatasetsDraw",{cancelable:!0}))return;const t=this.getSortedVisibleDatasetMetas();for(let e=t.length-1;e>=0;--e)this._drawDataset(t[e]);this.notifyPlugins("afterDatasetsDraw");}_drawDataset(t){const e=this.ctx,i=t._clip,s=!i.disabled,n=this.chartArea,o={meta:t,index:t.index,cancelable:!0};!1!==this.notifyPlugins("beforeDatasetDraw",o)&&(s&&Pe(e,{left:!1===i.left?0:n.left-i.left,right:!1===i.right?this.width:n.right+i.right,top:!1===i.top?0:n.top-i.top,bottom:!1===i.bottom?this.height:n.bottom+i.bottom}),t.controller.draw(),s&&De(e),o.cancelable=!1,this.notifyPlugins("afterDatasetDraw",o));}isPointInArea(t){return Se(t,this.chartArea,this._minPadding)}getElementsAtEventForMode(t,e,i,s){const n=Vi.modes[e];return "function"==typeof n?n(this,t,i,s):[]}getDatasetMeta(t){const e=this.data.datasets[t],i=this._metasets;let s=i.filter((t=>t&&t._dataset===e)).pop();return s||(s={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:e&&e.order||0,index:t,_dataset:e,_parsed:[],_sorted:!1},i.push(s)),s}getContext(){return this.$context||(this.$context=_i(null,{chart:this,type:"chart"}))}getVisibleDatasetCount(){return this.getSortedVisibleDatasetMetas().length}isDatasetVisible(t){const e=this.data.datasets[t];if(!e)return !1;const i=this.getDatasetMeta(t);return "boolean"==typeof i.hidden?!i.hidden:!e.hidden}setDatasetVisibility(t,e){this.getDatasetMeta(t).hidden=!e;}toggleDataVisibility(t){this._hiddenIndices[t]=!this._hiddenIndices[t];}getDataVisibility(t){return !this._hiddenIndices[t]}_updateVisibility(t,e,i){const s=i?"show":"hide",n=this.getDatasetMeta(t),o=n.controller._resolveAnimations(void 0,s);M(e)?(n.data[e].hidden=!i,this.update()):(this.setDatasetVisibility(t,i),o.update(n,{visible:i}),this.update((e=>e.datasetIndex===t?s:void 0)));}hide(t,e){this._updateVisibility(t,e,!1);}show(t,e){this._updateVisibility(t,e,!0);}_destroyDatasetMeta(t){const e=this._metasets[t];e&&e.controller&&e.controller._destroy(),delete this._metasets[t];}_stop(){let t,e;for(this.stop(),mt.remove(this),t=0,e=this.data.datasets.length;t<e;++t)this._destroyDatasetMeta(t);}destroy(){this.notifyPlugins("beforeDestroy");const{canvas:t,ctx:e}=this;this._stop(),this.config.clearCache(),t&&(this.unbindEvents(),we(t,e),this.platform.releaseContext(e),this.canvas=null,this.ctx=null),this.notifyPlugins("destroy"),delete gn[this.id],this.notifyPlugins("afterDestroy");}toBase64Image(...t){return this.canvas.toDataURL(...t)}bindEvents(){this.bindUserEvents(),this.options.responsive?this.bindResponsiveEvents():this.attached=!0;}bindUserEvents(){const t=this._listeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s;},s=(t,e,i)=>{t.offsetX=e,t.offsetY=i,this._eventHandler(t);};d(this.options.events,(t=>i(t,s)));}bindResponsiveEvents(){this._responsiveListeners||(this._responsiveListeners={});const t=this._responsiveListeners,e=this.platform,i=(i,s)=>{e.addEventListener(this,i,s),t[i]=s;},s=(i,s)=>{t[i]&&(e.removeEventListener(this,i,s),delete t[i]);},n=(t,e)=>{this.canvas&&this.resize(t,e);};let o;const a=()=>{s("attach",a),this.attached=!0,this.resize(),i("resize",n),i("detach",o);};o=()=>{this.attached=!1,s("resize",n),this._stop(),this._resize(0,0),i("attach",a);},e.isAttached(this.canvas)?a():o();}unbindEvents(){d(this._listeners,((t,e)=>{this.platform.removeEventListener(this,e,t);})),this._listeners={},d(this._responsiveListeners,((t,e)=>{this.platform.removeEventListener(this,e,t);})),this._responsiveListeners=void 0;}updateHoverStyle(t,e,i){const s=i?"set":"remove";let n,o,a,r;for("dataset"===e&&(n=this.getDatasetMeta(t[0].datasetIndex),n.controller["_"+s+"DatasetHoverStyle"]()),a=0,r=t.length;a<r;++a){o=t[a];const e=o&&this.getDatasetMeta(o.datasetIndex).controller;e&&e[s+"HoverStyle"](o.element,o.datasetIndex,o.index);}}getActiveElements(){return this._active||[]}setActiveElements(t){const e=this._active||[],i=t.map((({datasetIndex:t,index:e})=>{const i=this.getDatasetMeta(t);if(!i)throw new Error("No dataset found at index "+t);return {datasetIndex:t,element:i.data[e],index:e}}));!u(i,e)&&(this._active=i,this._lastEvent=null,this._updateHoverStyles(i,e));}notifyPlugins(t,e,i){return this._plugins.notify(this,t,e,i)}_updateHoverStyles(t,e,i){const s=this.options.hover,n=(t,e)=>t.filter((t=>!e.some((e=>t.datasetIndex===e.datasetIndex&&t.index===e.index)))),o=n(e,t),a=i?t:n(t,e);o.length&&this.updateHoverStyle(o,s.mode,!1),a.length&&s.mode&&this.updateHoverStyle(a,s.mode,!0);}_eventHandler(t,e){const i={event:t,replay:e,cancelable:!0,inChartArea:this.isPointInArea(t)},s=e=>(e.options.events||this.options.events).includes(t.native.type);if(!1===this.notifyPlugins("beforeEvent",i,s))return;const n=this._handleEvent(t,e,i.inChartArea);return i.cancelable=!1,this.notifyPlugins("afterEvent",i,s),(n||i.changed)&&this.render(),this}_handleEvent(t,e,i){const{_active:s=[],options:n}=this,o=e,a=this._getActiveElements(t,s,i,o),r=P(t),l=function(t,e,i,s){return i&&"mouseout"!==t.type?s?e:t:null}(t,this._lastEvent,i,r);i&&(this._lastEvent=null,c(n.onHover,[t,a,this],this),r&&c(n.onClick,[t,a,this],this));const h=!u(a,s);return (h||e)&&(this._active=a,this._updateHoverStyles(a,s,e)),this._lastEvent=l,h}_getActiveElements(t,e,i,s){if("mouseout"===t.type)return [];if(!i)return e;const n=this.options.hover;return this.getElementsAtEventForMode(t,n.mode,n,s)}}const xn=()=>d(bn.instances,(t=>t._plugins.invalidate())),_n=!0;function yn(){throw new Error("This method is not implemented: Check that a complete date adapter is provided.")}Object.defineProperties(bn,{defaults:{enumerable:_n,value:ne},instances:{enumerable:_n,value:gn},overrides:{enumerable:_n,value:te},registry:{enumerable:_n,value:Us},version:{enumerable:_n,value:"3.9.1"},getChart:{enumerable:_n,value:pn},register:{enumerable:_n,value:(...t)=>{Us.add(...t),xn();}},unregister:{enumerable:_n,value:(...t)=>{Us.remove(...t),xn();}}});class vn{constructor(t){this.options=t||{};}init(t){}formats(){return yn()}parse(t,e){return yn()}format(t,e){return yn()}add(t,e,i){return yn()}diff(t,e,i){return yn()}startOf(t,e,i){return yn()}endOf(t,e){return yn()}}vn.override=function(t){Object.assign(vn.prototype,t);};var wn={_date:vn};function Mn(t){const e=t.iScale,i=function(t,e){if(!t._cache.$bar){const i=t.getMatchingVisibleMetas(e);let s=[];for(let e=0,n=i.length;e<n;e++)s=s.concat(i[e].controller.getAllParsedValues(t));t._cache.$bar=rt(s.sort(((t,e)=>t-e)));}return t._cache.$bar}(e,t.type);let s,n,o,a,r=e._length;const l=()=>{32767!==o&&-32768!==o&&(M(a)&&(r=Math.min(r,Math.abs(o-a)||r)),a=o);};for(s=0,n=i.length;s<n;++s)o=e.getPixelForValue(i[s]),l();for(a=void 0,s=0,n=e.ticks.length;s<n;++s)o=e.getPixelForTick(s),l();return r}function kn(t,e,i,n){return s(t)?function(t,e,i,s){const n=i.parse(t[0],s),o=i.parse(t[1],s),a=Math.min(n,o),r=Math.max(n,o);let l=a,h=r;Math.abs(a)>Math.abs(r)&&(l=r,h=a),e[i.axis]=h,e._custom={barStart:l,barEnd:h,start:n,end:o,min:a,max:r};}(t,e,i,n):e[i.axis]=i.parse(t,n),e}function Sn(t,e,i,s){const n=t.iScale,o=t.vScale,a=n.getLabels(),r=n===o,l=[];let h,c,d,u;for(h=i,c=i+s;h<c;++h)u=e[h],d={},d[n.axis]=r||n.parse(a[h],h),l.push(kn(u,d,o,h));return l}function Pn(t){return t&&void 0!==t.barStart&&void 0!==t.barEnd}function Dn(t,e,i,s){let n=e.borderSkipped;const o={};if(!n)return void(t.borderSkipped=o);if(!0===n)return void(t.borderSkipped={top:!0,right:!0,bottom:!0,left:!0});const{start:a,end:r,reverse:l,top:h,bottom:c}=function(t){let e,i,s,n,o;return t.horizontal?(e=t.base>t.x,i="left",s="right"):(e=t.base<t.y,i="bottom",s="top"),e?(n="end",o="start"):(n="start",o="end"),{start:i,end:s,reverse:e,top:n,bottom:o}}(t);"middle"===n&&i&&(t.enableBorderRadius=!0,(i._top||0)===s?n=h:(i._bottom||0)===s?n=c:(o[On(c,a,r,l)]=!0,n=h)),o[On(n,a,r,l)]=!0,t.borderSkipped=o;}function On(t,e,i,s){var n,o,a;return s?(a=i,t=Cn(t=(n=t)===(o=e)?a:n===a?o:n,i,e)):t=Cn(t,e,i),t}function Cn(t,e,i){return "start"===t?e:"end"===t?i:t}function An(t,{inflateAmount:e},i){t.inflateAmount="auto"===e?1===i?.33:0:e;}class Tn extends Ls{parsePrimitiveData(t,e,i,s){return Sn(t,e,i,s)}parseArrayData(t,e,i,s){return Sn(t,e,i,s)}parseObjectData(t,e,i,s){const{iScale:n,vScale:o}=t,{xAxisKey:a="x",yAxisKey:r="y"}=this._parsing,l="x"===n.axis?a:r,h="x"===o.axis?a:r,c=[];let d,u,f,g;for(d=i,u=i+s;d<u;++d)g=e[d],f={},f[n.axis]=n.parse(y(g,l),d),c.push(kn(y(g,h),f,o,d));return c}updateRangeFromParsed(t,e,i,s){super.updateRangeFromParsed(t,e,i,s);const n=i._custom;n&&e===this._cachedMeta.vScale&&(t.min=Math.min(t.min,n.min),t.max=Math.max(t.max,n.max));}getMaxOverflow(){return 0}getLabelAndValue(t){const e=this._cachedMeta,{iScale:i,vScale:s}=e,n=this.getParsed(t),o=n._custom,a=Pn(o)?"["+o.start+", "+o.end+"]":""+s.getLabelForValue(n[s.axis]);return {label:""+i.getLabelForValue(n[i.axis]),value:a}}initialize(){this.enableOptionSharing=!0,super.initialize();this._cachedMeta.stack=this.getDataset().stack;}update(t){const e=this._cachedMeta;this.updateElements(e.data,0,e.data.length,t);}updateElements(t,e,s,n){const o="reset"===n,{index:a,_cachedMeta:{vScale:r}}=this,l=r.getBasePixel(),h=r.isHorizontal(),c=this._getRuler(),{sharedOptions:d,includeOptions:u}=this._getSharedOptions(e,n);for(let f=e;f<e+s;f++){const e=this.getParsed(f),s=o||i(e[r.axis])?{base:l,head:l}:this._calculateBarValuePixels(f),g=this._calculateBarIndexPixels(f,c),p=(e._stacks||{})[r.axis],m={horizontal:h,base:s.base,enableBorderRadius:!p||Pn(e._custom)||a===p._top||a===p._bottom,x:h?s.head:g.center,y:h?g.center:s.head,height:h?g.size:Math.abs(s.size),width:h?Math.abs(s.size):g.size};u&&(m.options=d||this.resolveDataElementOptions(f,t[f].active?"active":n));const b=m.options||t[f].options;Dn(m,b,p,a),An(m,b,c.ratio),this.updateElement(t[f],f,m,n);}}_getStacks(t,e){const{iScale:s}=this._cachedMeta,n=s.getMatchingVisibleMetas(this._type).filter((t=>t.controller.options.grouped)),o=s.options.stacked,a=[],r=t=>{const s=t.controller.getParsed(e),n=s&&s[t.vScale.axis];if(i(n)||isNaN(n))return !0};for(const i of n)if((void 0===e||!r(i))&&((!1===o||-1===a.indexOf(i.stack)||void 0===o&&void 0===i.stack)&&a.push(i.stack),i.index===t))break;return a.length||a.push(void 0),a}_getStackCount(t){return this._getStacks(void 0,t).length}_getStackIndex(t,e,i){const s=this._getStacks(t,i),n=void 0!==e?s.indexOf(e):-1;return -1===n?s.length-1:n}_getRuler(){const t=this.options,e=this._cachedMeta,i=e.iScale,s=[];let n,o;for(n=0,o=e.data.length;n<o;++n)s.push(i.getPixelForValue(this.getParsed(n)[i.axis],n));const a=t.barThickness;return {min:a||Mn(e),pixels:s,start:i._startPixel,end:i._endPixel,stackCount:this._getStackCount(),scale:i,grouped:t.grouped,ratio:a?1:t.categoryPercentage*t.barPercentage}}_calculateBarValuePixels(t){const{_cachedMeta:{vScale:e,_stacked:s},options:{base:n,minBarLength:o}}=this,a=n||0,r=this.getParsed(t),l=r._custom,h=Pn(l);let c,d,u=r[e.axis],f=0,g=s?this.applyStack(e,r,s):u;g!==u&&(f=g-u,g=u),h&&(u=l.barStart,g=l.barEnd-l.barStart,0!==u&&z(u)!==z(l.barEnd)&&(f=0),f+=u);const p=i(n)||h?f:n;let m=e.getPixelForValue(p);if(c=this.chart.getDataVisibility(t)?e.getPixelForValue(f+g):m,d=c-m,Math.abs(d)<o){d=function(t,e,i){return 0!==t?z(t):(e.isHorizontal()?1:-1)*(e.min>=i?1:-1)}(d,e,a)*o,u===a&&(m-=d/2);const t=e.getPixelForDecimal(0),i=e.getPixelForDecimal(1),s=Math.min(t,i),n=Math.max(t,i);m=Math.max(Math.min(m,n),s),c=m+d;}if(m===e.getPixelForValue(a)){const t=z(d)*e.getLineWidthForValue(a)/2;m+=t,d-=t;}return {size:d,base:m,head:c,center:c+d/2}}_calculateBarIndexPixels(t,e){const s=e.scale,n=this.options,o=n.skipNull,a=r(n.maxBarThickness,1/0);let l,h;if(e.grouped){const s=o?this._getStackCount(t):e.stackCount,r="flex"===n.barThickness?function(t,e,i,s){const n=e.pixels,o=n[t];let a=t>0?n[t-1]:null,r=t<n.length-1?n[t+1]:null;const l=i.categoryPercentage;null===a&&(a=o-(null===r?e.end-e.start:r-o)),null===r&&(r=o+o-a);const h=o-(o-Math.min(a,r))/2*l;return {chunk:Math.abs(r-a)/2*l/s,ratio:i.barPercentage,start:h}}(t,e,n,s):function(t,e,s,n){const o=s.barThickness;let a,r;return i(o)?(a=e.min*s.categoryPercentage,r=s.barPercentage):(a=o*n,r=1),{chunk:a/n,ratio:r,start:e.pixels[t]-a/2}}(t,e,n,s),c=this._getStackIndex(this.index,this._cachedMeta.stack,o?t:void 0);l=r.start+r.chunk*c+r.chunk/2,h=Math.min(a,r.chunk*r.ratio);}else l=s.getPixelForValue(this.getParsed(t)[s.axis],t),h=Math.min(a,e.min*e.ratio);return {base:l-h/2,head:l+h/2,center:l,size:h}}draw(){const t=this._cachedMeta,e=t.vScale,i=t.data,s=i.length;let n=0;for(;n<s;++n)null!==this.getParsed(n)[e.axis]&&i[n].draw(this._ctx);}}Tn.id="bar",Tn.defaults={datasetElementType:!1,dataElementType:"bar",categoryPercentage:.8,barPercentage:.9,grouped:!0,animations:{numbers:{type:"number",properties:["x","y","base","width","height"]}}},Tn.overrides={scales:{_index_:{type:"category",offset:!0,grid:{offset:!0}},_value_:{type:"linear",beginAtZero:!0}}};class Ln extends Ls{initialize(){this.enableOptionSharing=!0,super.initialize();}parsePrimitiveData(t,e,i,s){const n=super.parsePrimitiveData(t,e,i,s);for(let t=0;t<n.length;t++)n[t]._custom=this.resolveDataElementOptions(t+i).radius;return n}parseArrayData(t,e,i,s){const n=super.parseArrayData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=r(s[2],this.resolveDataElementOptions(t+i).radius);}return n}parseObjectData(t,e,i,s){const n=super.parseObjectData(t,e,i,s);for(let t=0;t<n.length;t++){const s=e[i+t];n[t]._custom=r(s&&s.r&&+s.r,this.resolveDataElementOptions(t+i).radius);}return n}getMaxOverflow(){const t=this._cachedMeta.data;let e=0;for(let i=t.length-1;i>=0;--i)e=Math.max(e,t[i].size(this.resolveDataElementOptions(i))/2);return e>0&&e}getLabelAndValue(t){const e=this._cachedMeta,{xScale:i,yScale:s}=e,n=this.getParsed(t),o=i.getLabelForValue(n.x),a=s.getLabelForValue(n.y),r=n._custom;return {label:e.label,value:"("+o+", "+a+(r?", "+r:"")+")"}}update(t){const e=this._cachedMeta.data;this.updateElements(e,0,e.length,t);}updateElements(t,e,i,s){const n="reset"===s,{iScale:o,vScale:a}=this._cachedMeta,{sharedOptions:r,includeOptions:l}=this._getSharedOptions(e,s),h=o.axis,c=a.axis;for(let d=e;d<e+i;d++){const e=t[d],i=!n&&this.getParsed(d),u={},f=u[h]=n?o.getPixelForDecimal(.5):o.getPixelForValue(i[h]),g=u[c]=n?a.getBasePixel():a.getPixelForValue(i[c]);u.skip=isNaN(f)||isNaN(g),l&&(u.options=r||this.resolveDataElementOptions(d,e.active?"active":s),n&&(u.options.radius=0)),this.updateElement(e,d,u,s);}}resolveDataElementOptions(t,e){const i=this.getParsed(t);let s=super.resolveDataElementOptions(t,e);s.$shared&&(s=Object.assign({},s,{$shared:!1}));const n=s.radius;return "active"!==e&&(s.radius=0),s.radius+=r(i&&i._custom,n),s}}Ln.id="bubble",Ln.defaults={datasetElementType:!1,dataElementType:"point",animations:{numbers:{type:"number",properties:["x","y","borderWidth","radius"]}}},Ln.overrides={scales:{x:{type:"linear"},y:{type:"linear"}},plugins:{tooltip:{callbacks:{title:()=>""}}}};class En extends Ls{constructor(t,e){super(t,e),this.enableOptionSharing=!0,this.innerRadius=void 0,this.outerRadius=void 0,this.offsetX=void 0,this.offsetY=void 0;}linkScales(){}parse(t,e){const i=this.getDataset().data,s=this._cachedMeta;if(!1===this._parsing)s._parsed=i;else {let o,a,r=t=>+i[t];if(n(i[t])){const{key:t="value"}=this._parsing;r=e=>+y(i[e],t);}for(o=t,a=t+e;o<a;++o)s._parsed[o]=r(o);}}_getRotation(){return H(this.options.rotation-90)}_getCircumference(){return H(this.options.circumference)}_getRotationExtents(){let t=O,e=-O;for(let i=0;i<this.chart.data.datasets.length;++i)if(this.chart.isDatasetVisible(i)){const s=this.chart.getDatasetMeta(i).controller,n=s._getRotation(),o=s._getCircumference();t=Math.min(t,n),e=Math.max(e,n+o);}return {rotation:t,circumference:e-t}}update(t){const e=this.chart,{chartArea:i}=e,s=this._cachedMeta,n=s.data,o=this.getMaxBorderWidth()+this.getMaxOffset(n)+this.options.spacing,a=Math.max((Math.min(i.width,i.height)-o)/2,0),r=Math.min(l(this.options.cutout,a),1),c=this._getRingWeight(this.index),{circumference:d,rotation:u}=this._getRotationExtents(),{ratioX:f,ratioY:g,offsetX:p,offsetY:m}=function(t,e,i){let s=1,n=1,o=0,a=0;if(e<O){const r=t,l=r+e,h=Math.cos(r),c=Math.sin(r),d=Math.cos(l),u=Math.sin(l),f=(t,e,s)=>G(t,r,l,!0)?1:Math.max(e,e*i,s,s*i),g=(t,e,s)=>G(t,r,l,!0)?-1:Math.min(e,e*i,s,s*i),p=f(0,h,d),m=f(L,c,u),b=g(D,h,d),x=g(D+L,c,u);s=(p-b)/2,n=(m-x)/2,o=-(p+b)/2,a=-(m+x)/2;}return {ratioX:s,ratioY:n,offsetX:o,offsetY:a}}(u,d,r),b=(i.width-o)/f,x=(i.height-o)/g,_=Math.max(Math.min(b,x)/2,0),y=h(this.options.radius,_),v=(y-Math.max(y*r,0))/this._getVisibleDatasetWeightTotal();this.offsetX=p*y,this.offsetY=m*y,s.total=this.calculateTotal(),this.outerRadius=y-v*this._getRingWeightOffset(this.index),this.innerRadius=Math.max(this.outerRadius-v*c,0),this.updateElements(n,0,n.length,t);}_circumference(t,e){const i=this.options,s=this._cachedMeta,n=this._getCircumference();return e&&i.animation.animateRotate||!this.chart.getDataVisibility(t)||null===s._parsed[t]||s.data[t].hidden?0:this.calculateCircumference(s._parsed[t]*n/O)}updateElements(t,e,i,s){const n="reset"===s,o=this.chart,a=o.chartArea,r=o.options.animation,l=(a.left+a.right)/2,h=(a.top+a.bottom)/2,c=n&&r.animateScale,d=c?0:this.innerRadius,u=c?0:this.outerRadius,{sharedOptions:f,includeOptions:g}=this._getSharedOptions(e,s);let p,m=this._getRotation();for(p=0;p<e;++p)m+=this._circumference(p,n);for(p=e;p<e+i;++p){const e=this._circumference(p,n),i=t[p],o={x:l+this.offsetX,y:h+this.offsetY,startAngle:m,endAngle:m+e,circumference:e,outerRadius:u,innerRadius:d};g&&(o.options=f||this.resolveDataElementOptions(p,i.active?"active":s)),m+=e,this.updateElement(i,p,o,s);}}calculateTotal(){const t=this._cachedMeta,e=t.data;let i,s=0;for(i=0;i<e.length;i++){const n=t._parsed[i];null===n||isNaN(n)||!this.chart.getDataVisibility(i)||e[i].hidden||(s+=Math.abs(n));}return s}calculateCircumference(t){const e=this._cachedMeta.total;return e>0&&!isNaN(t)?O*(Math.abs(t)/e):0}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=li(e._parsed[t],i.options.locale);return {label:s[t]||"",value:n}}getMaxBorderWidth(t){let e=0;const i=this.chart;let s,n,o,a,r;if(!t)for(s=0,n=i.data.datasets.length;s<n;++s)if(i.isDatasetVisible(s)){o=i.getDatasetMeta(s),t=o.data,a=o.controller;break}if(!t)return 0;for(s=0,n=t.length;s<n;++s)r=a.resolveDataElementOptions(s),"inner"!==r.borderAlign&&(e=Math.max(e,r.borderWidth||0,r.hoverBorderWidth||0));return e}getMaxOffset(t){let e=0;for(let i=0,s=t.length;i<s;++i){const t=this.resolveDataElementOptions(i);e=Math.max(e,t.offset||0,t.hoverOffset||0);}return e}_getRingWeightOffset(t){let e=0;for(let i=0;i<t;++i)this.chart.isDatasetVisible(i)&&(e+=this._getRingWeight(i));return e}_getRingWeight(t){return Math.max(r(this.chart.data.datasets[t].weight,1),0)}_getVisibleDatasetWeightTotal(){return this._getRingWeightOffset(this.chart.data.datasets.length)||1}}En.id="doughnut",En.defaults={datasetElementType:!1,dataElementType:"arc",animation:{animateRotate:!0,animateScale:!1},animations:{numbers:{type:"number",properties:["circumference","endAngle","innerRadius","outerRadius","startAngle","x","y","offset","borderWidth","spacing"]}},cutout:"50%",rotation:0,circumference:360,radius:"100%",spacing:0,indexAxis:"r"},En.descriptors={_scriptable:t=>"spacing"!==t,_indexable:t=>"spacing"!==t},En.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i}}=t.legend.options;return e.labels.map(((e,s)=>{const n=t.getDatasetMeta(0).controller.getStyle(s);return {text:e,fillStyle:n.backgroundColor,strokeStyle:n.borderColor,lineWidth:n.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(s),index:s}}))}return []}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update();}},tooltip:{callbacks:{title:()=>"",label(t){let e=t.label;const i=": "+t.formattedValue;return s(e)?(e=e.slice(),e[0]+=i):e+=i,e}}}}};class Rn extends Ls{initialize(){this.enableOptionSharing=!0,this.supportsDecimation=!0,super.initialize();}update(t){const e=this._cachedMeta,{dataset:i,data:s=[],_dataset:n}=e,o=this.chart._animationsDisabled;let{start:a,count:r}=gt(e,s,o);this._drawStart=a,this._drawCount=r,pt(e)&&(a=0,r=s.length),i._chart=this.chart,i._datasetIndex=this.index,i._decimated=!!n._decimated,i.points=s;const l=this.resolveDatasetElementOptions(t);this.options.showLine||(l.borderWidth=0),l.segment=this.options.segment,this.updateElement(i,void 0,{animated:!o,options:l},t),this.updateElements(s,a,r,t);}updateElements(t,e,s,n){const o="reset"===n,{iScale:a,vScale:r,_stacked:l,_dataset:h}=this._cachedMeta,{sharedOptions:c,includeOptions:d}=this._getSharedOptions(e,n),u=a.axis,f=r.axis,{spanGaps:g,segment:p}=this.options,m=B(g)?g:Number.POSITIVE_INFINITY,b=this.chart._animationsDisabled||o||"none"===n;let x=e>0&&this.getParsed(e-1);for(let g=e;g<e+s;++g){const e=t[g],s=this.getParsed(g),_=b?e:{},y=i(s[f]),v=_[u]=a.getPixelForValue(s[u],g),w=_[f]=o||y?r.getBasePixel():r.getPixelForValue(l?this.applyStack(r,s,l):s[f],g);_.skip=isNaN(v)||isNaN(w)||y,_.stop=g>0&&Math.abs(s[u]-x[u])>m,p&&(_.parsed=s,_.raw=h.data[g]),d&&(_.options=c||this.resolveDataElementOptions(g,e.active?"active":n)),b||this.updateElement(e,g,_,n),x=s;}}getMaxOverflow(){const t=this._cachedMeta,e=t.dataset,i=e.options&&e.options.borderWidth||0,s=t.data||[];if(!s.length)return i;const n=s[0].size(this.resolveDataElementOptions(0)),o=s[s.length-1].size(this.resolveDataElementOptions(s.length-1));return Math.max(i,n,o)/2}draw(){const t=this._cachedMeta;t.dataset.updateControlPoints(this.chart.chartArea,t.iScale.axis),super.draw();}}Rn.id="line",Rn.defaults={datasetElementType:"line",dataElementType:"point",showLine:!0,spanGaps:!1},Rn.overrides={scales:{_index_:{type:"category"},_value_:{type:"linear"}}};class In extends Ls{constructor(t,e){super(t,e),this.innerRadius=void 0,this.outerRadius=void 0;}getLabelAndValue(t){const e=this._cachedMeta,i=this.chart,s=i.data.labels||[],n=li(e._parsed[t].r,i.options.locale);return {label:s[t]||"",value:n}}parseObjectData(t,e,i,s){return Ue.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta.data;this._updateRadius(),this.updateElements(e,0,e.length,t);}getMinMax(){const t=this._cachedMeta,e={min:Number.POSITIVE_INFINITY,max:Number.NEGATIVE_INFINITY};return t.data.forEach(((t,i)=>{const s=this.getParsed(i).r;!isNaN(s)&&this.chart.getDataVisibility(i)&&(s<e.min&&(e.min=s),s>e.max&&(e.max=s));})),e}_updateRadius(){const t=this.chart,e=t.chartArea,i=t.options,s=Math.min(e.right-e.left,e.bottom-e.top),n=Math.max(s/2,0),o=(n-Math.max(i.cutoutPercentage?n/100*i.cutoutPercentage:1,0))/t.getVisibleDatasetCount();this.outerRadius=n-o*this.index,this.innerRadius=this.outerRadius-o;}updateElements(t,e,i,s){const n="reset"===s,o=this.chart,a=o.options.animation,r=this._cachedMeta.rScale,l=r.xCenter,h=r.yCenter,c=r.getIndexAngle(0)-.5*D;let d,u=c;const f=360/this.countVisibleElements();for(d=0;d<e;++d)u+=this._computeAngle(d,s,f);for(d=e;d<e+i;d++){const e=t[d];let i=u,g=u+this._computeAngle(d,s,f),p=o.getDataVisibility(d)?r.getDistanceFromCenterForValue(this.getParsed(d).r):0;u=g,n&&(a.animateScale&&(p=0),a.animateRotate&&(i=g=c));const m={x:l,y:h,innerRadius:0,outerRadius:p,startAngle:i,endAngle:g,options:this.resolveDataElementOptions(d,e.active?"active":s)};this.updateElement(e,d,m,s);}}countVisibleElements(){const t=this._cachedMeta;let e=0;return t.data.forEach(((t,i)=>{!isNaN(this.getParsed(i).r)&&this.chart.getDataVisibility(i)&&e++;})),e}_computeAngle(t,e,i){return this.chart.getDataVisibility(t)?H(this.resolveDataElementOptions(t,e).angle||i):0}}In.id="polarArea",In.defaults={dataElementType:"arc",animation:{animateRotate:!0,animateScale:!0},animations:{numbers:{type:"number",properties:["x","y","startAngle","endAngle","innerRadius","outerRadius"]}},indexAxis:"r",startAngle:0},In.overrides={aspectRatio:1,plugins:{legend:{labels:{generateLabels(t){const e=t.data;if(e.labels.length&&e.datasets.length){const{labels:{pointStyle:i}}=t.legend.options;return e.labels.map(((e,s)=>{const n=t.getDatasetMeta(0).controller.getStyle(s);return {text:e,fillStyle:n.backgroundColor,strokeStyle:n.borderColor,lineWidth:n.borderWidth,pointStyle:i,hidden:!t.getDataVisibility(s),index:s}}))}return []}},onClick(t,e,i){i.chart.toggleDataVisibility(e.index),i.chart.update();}},tooltip:{callbacks:{title:()=>"",label:t=>t.chart.data.labels[t.dataIndex]+": "+t.formattedValue}}},scales:{r:{type:"radialLinear",angleLines:{display:!1},beginAtZero:!0,grid:{circular:!0},pointLabels:{display:!1},startAngle:0}}};class zn extends En{}zn.id="pie",zn.defaults={cutout:0,rotation:0,circumference:360,radius:"100%"};class Fn extends Ls{getLabelAndValue(t){const e=this._cachedMeta.vScale,i=this.getParsed(t);return {label:e.getLabels()[t],value:""+e.getLabelForValue(i[e.axis])}}parseObjectData(t,e,i,s){return Ue.bind(this)(t,e,i,s)}update(t){const e=this._cachedMeta,i=e.dataset,s=e.data||[],n=e.iScale.getLabels();if(i.points=s,"resize"!==t){const e=this.resolveDatasetElementOptions(t);this.options.showLine||(e.borderWidth=0);const o={_loop:!0,_fullLoop:n.length===s.length,options:e};this.updateElement(i,void 0,o,t);}this.updateElements(s,0,s.length,t);}updateElements(t,e,i,s){const n=this._cachedMeta.rScale,o="reset"===s;for(let a=e;a<e+i;a++){const e=t[a],i=this.resolveDataElementOptions(a,e.active?"active":s),r=n.getPointPositionForValue(a,this.getParsed(a).r),l=o?n.xCenter:r.x,h=o?n.yCenter:r.y,c={x:l,y:h,angle:r.angle,skip:isNaN(l)||isNaN(h),options:i};this.updateElement(e,a,c,s);}}}Fn.id="radar",Fn.defaults={datasetElementType:"line",dataElementType:"point",indexAxis:"r",showLine:!0,elements:{line:{fill:"start"}}},Fn.overrides={aspectRatio:1,scales:{r:{type:"radialLinear"}}};class Vn extends Ls{update(t){const e=this._cachedMeta,{data:i=[]}=e,s=this.chart._animationsDisabled;let{start:n,count:o}=gt(e,i,s);if(this._drawStart=n,this._drawCount=o,pt(e)&&(n=0,o=i.length),this.options.showLine){const{dataset:n,_dataset:o}=e;n._chart=this.chart,n._datasetIndex=this.index,n._decimated=!!o._decimated,n.points=i;const a=this.resolveDatasetElementOptions(t);a.segment=this.options.segment,this.updateElement(n,void 0,{animated:!s,options:a},t);}this.updateElements(i,n,o,t);}addElements(){const{showLine:t}=this.options;!this.datasetElementType&&t&&(this.datasetElementType=Us.getElement("line")),super.addElements();}updateElements(t,e,s,n){const o="reset"===n,{iScale:a,vScale:r,_stacked:l,_dataset:h}=this._cachedMeta,c=this.resolveDataElementOptions(e,n),d=this.getSharedOptions(c),u=this.includeOptions(n,d),f=a.axis,g=r.axis,{spanGaps:p,segment:m}=this.options,b=B(p)?p:Number.POSITIVE_INFINITY,x=this.chart._animationsDisabled||o||"none"===n;let _=e>0&&this.getParsed(e-1);for(let c=e;c<e+s;++c){const e=t[c],s=this.getParsed(c),p=x?e:{},y=i(s[g]),v=p[f]=a.getPixelForValue(s[f],c),w=p[g]=o||y?r.getBasePixel():r.getPixelForValue(l?this.applyStack(r,s,l):s[g],c);p.skip=isNaN(v)||isNaN(w)||y,p.stop=c>0&&Math.abs(s[f]-_[f])>b,m&&(p.parsed=s,p.raw=h.data[c]),u&&(p.options=d||this.resolveDataElementOptions(c,e.active?"active":n)),x||this.updateElement(e,c,p,n),_=s;}this.updateSharedOptions(d,n,c);}getMaxOverflow(){const t=this._cachedMeta,e=t.data||[];if(!this.options.showLine){let t=0;for(let i=e.length-1;i>=0;--i)t=Math.max(t,e[i].size(this.resolveDataElementOptions(i))/2);return t>0&&t}const i=t.dataset,s=i.options&&i.options.borderWidth||0;if(!e.length)return s;const n=e[0].size(this.resolveDataElementOptions(0)),o=e[e.length-1].size(this.resolveDataElementOptions(e.length-1));return Math.max(s,n,o)/2}}Vn.id="scatter",Vn.defaults={datasetElementType:!1,dataElementType:"point",showLine:!1,fill:!1},Vn.overrides={interaction:{mode:"point"},plugins:{tooltip:{callbacks:{title:()=>"",label:t=>"("+t.label+", "+t.formattedValue+")"}}},scales:{x:{type:"linear"},y:{type:"linear"}}};var Bn=Object.freeze({__proto__:null,BarController:Tn,BubbleController:Ln,DoughnutController:En,LineController:Rn,PolarAreaController:In,PieController:zn,RadarController:Fn,ScatterController:Vn});function Nn(t,e,i){const{startAngle:s,pixelMargin:n,x:o,y:a,outerRadius:r,innerRadius:l}=e;let h=n/r;t.beginPath(),t.arc(o,a,r,s-h,i+h),l>n?(h=n/l,t.arc(o,a,l,i+h,s-h,!0)):t.arc(o,a,n,i+L,s-L),t.closePath(),t.clip();}function Wn(t,e,i,s){const n=ui(t.options.borderRadius,["outerStart","outerEnd","innerStart","innerEnd"]);const o=(i-e)/2,a=Math.min(o,s*e/2),r=t=>{const e=(i-Math.min(o,t))*s/2;return Z(t,0,Math.min(o,e))};return {outerStart:r(n.outerStart),outerEnd:r(n.outerEnd),innerStart:Z(n.innerStart,0,a),innerEnd:Z(n.innerEnd,0,a)}}function jn(t,e,i,s){return {x:i+t*Math.cos(e),y:s+t*Math.sin(e)}}function Hn(t,e,i,s,n,o){const{x:a,y:r,startAngle:l,pixelMargin:h,innerRadius:c}=e,d=Math.max(e.outerRadius+s+i-h,0),u=c>0?c+s+i+h:0;let f=0;const g=n-l;if(s){const t=((c>0?c-s:0)+(d>0?d-s:0))/2;f=(g-(0!==t?g*t/(t+s):g))/2;}const p=(g-Math.max(.001,g*d-i/D)/d)/2,m=l+p+f,b=n-p-f,{outerStart:x,outerEnd:_,innerStart:y,innerEnd:v}=Wn(e,u,d,b-m),w=d-x,M=d-_,k=m+x/w,S=b-_/M,P=u+y,O=u+v,C=m+y/P,A=b-v/O;if(t.beginPath(),o){if(t.arc(a,r,d,k,S),_>0){const e=jn(M,S,a,r);t.arc(e.x,e.y,_,S,b+L);}const e=jn(O,b,a,r);if(t.lineTo(e.x,e.y),v>0){const e=jn(O,A,a,r);t.arc(e.x,e.y,v,b+L,A+Math.PI);}if(t.arc(a,r,u,b-v/u,m+y/u,!0),y>0){const e=jn(P,C,a,r);t.arc(e.x,e.y,y,C+Math.PI,m-L);}const i=jn(w,m,a,r);if(t.lineTo(i.x,i.y),x>0){const e=jn(w,k,a,r);t.arc(e.x,e.y,x,m-L,k);}}else {t.moveTo(a,r);const e=Math.cos(k)*d+a,i=Math.sin(k)*d+r;t.lineTo(e,i);const s=Math.cos(S)*d+a,n=Math.sin(S)*d+r;t.lineTo(s,n);}t.closePath();}function $n(t,e,i,s,n,o){const{options:a}=e,{borderWidth:r,borderJoinStyle:l}=a,h="inner"===a.borderAlign;r&&(h?(t.lineWidth=2*r,t.lineJoin=l||"round"):(t.lineWidth=r,t.lineJoin=l||"bevel"),e.fullCircles&&function(t,e,i){const{x:s,y:n,startAngle:o,pixelMargin:a,fullCircles:r}=e,l=Math.max(e.outerRadius-a,0),h=e.innerRadius+a;let c;for(i&&Nn(t,e,o+O),t.beginPath(),t.arc(s,n,h,o+O,o,!0),c=0;c<r;++c)t.stroke();for(t.beginPath(),t.arc(s,n,l,o,o+O),c=0;c<r;++c)t.stroke();}(t,e,h),h&&Nn(t,e,n),Hn(t,e,i,s,n,o),t.stroke());}class Yn extends Es{constructor(t){super(),this.options=void 0,this.circumference=void 0,this.startAngle=void 0,this.endAngle=void 0,this.innerRadius=void 0,this.outerRadius=void 0,this.pixelMargin=0,this.fullCircles=0,t&&Object.assign(this,t);}inRange(t,e,i){const s=this.getProps(["x","y"],i),{angle:n,distance:o}=U(s,{x:t,y:e}),{startAngle:a,endAngle:l,innerRadius:h,outerRadius:c,circumference:d}=this.getProps(["startAngle","endAngle","innerRadius","outerRadius","circumference"],i),u=this.options.spacing/2,f=r(d,l-a)>=O||G(n,a,l),g=Q(o,h+u,c+u);return f&&g}getCenterPoint(t){const{x:e,y:i,startAngle:s,endAngle:n,innerRadius:o,outerRadius:a}=this.getProps(["x","y","startAngle","endAngle","innerRadius","outerRadius","circumference"],t),{offset:r,spacing:l}=this.options,h=(s+n)/2,c=(o+a+l+r)/2;return {x:e+Math.cos(h)*c,y:i+Math.sin(h)*c}}tooltipPosition(t){return this.getCenterPoint(t)}draw(t){const{options:e,circumference:i}=this,s=(e.offset||0)/2,n=(e.spacing||0)/2,o=e.circular;if(this.pixelMargin="inner"===e.borderAlign?.33:0,this.fullCircles=i>O?Math.floor(i/O):0,0===i||this.innerRadius<0||this.outerRadius<0)return;t.save();let a=0;if(s){a=s/2;const e=(this.startAngle+this.endAngle)/2;t.translate(Math.cos(e)*a,Math.sin(e)*a),this.circumference>=D&&(a=s);}t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor;const r=function(t,e,i,s,n){const{fullCircles:o,startAngle:a,circumference:r}=e;let l=e.endAngle;if(o){Hn(t,e,i,s,a+O,n);for(let e=0;e<o;++e)t.fill();isNaN(r)||(l=a+r%O,r%O==0&&(l+=O));}return Hn(t,e,i,s,l,n),t.fill(),l}(t,this,a,n,o);$n(t,this,a,n,r,o),t.restore();}}function Un(t,e,i=e){t.lineCap=r(i.borderCapStyle,e.borderCapStyle),t.setLineDash(r(i.borderDash,e.borderDash)),t.lineDashOffset=r(i.borderDashOffset,e.borderDashOffset),t.lineJoin=r(i.borderJoinStyle,e.borderJoinStyle),t.lineWidth=r(i.borderWidth,e.borderWidth),t.strokeStyle=r(i.borderColor,e.borderColor);}function Xn(t,e,i){t.lineTo(i.x,i.y);}function qn(t,e,i={}){const s=t.length,{start:n=0,end:o=s-1}=i,{start:a,end:r}=e,l=Math.max(n,a),h=Math.min(o,r),c=n<a&&o<a||n>r&&o>r;return {count:s,start:l,loop:e.loop,ilen:h<l&&!c?s+h-l:h-l}}function Kn(t,e,i,s){const{points:n,options:o}=e,{count:a,start:r,loop:l,ilen:h}=qn(n,i,s),c=function(t){return t.stepped?Oe:t.tension||"monotone"===t.cubicInterpolationMode?Ce:Xn}(o);let d,u,f,{move:g=!0,reverse:p}=s||{};for(d=0;d<=h;++d)u=n[(r+(p?h-d:d))%a],u.skip||(g?(t.moveTo(u.x,u.y),g=!1):c(t,f,u,p,o.stepped),f=u);return l&&(u=n[(r+(p?h:0))%a],c(t,f,u,p,o.stepped)),!!l}function Gn(t,e,i,s){const n=e.points,{count:o,start:a,ilen:r}=qn(n,i,s),{move:l=!0,reverse:h}=s||{};let c,d,u,f,g,p,m=0,b=0;const x=t=>(a+(h?r-t:t))%o,_=()=>{f!==g&&(t.lineTo(m,g),t.lineTo(m,f),t.lineTo(m,p));};for(l&&(d=n[x(0)],t.moveTo(d.x,d.y)),c=0;c<=r;++c){if(d=n[x(c)],d.skip)continue;const e=d.x,i=d.y,s=0|e;s===u?(i<f?f=i:i>g&&(g=i),m=(b*m+e)/++b):(_(),t.lineTo(e,i),u=s,b=0,f=g=i),p=i;}_();}function Zn(t){const e=t.options,i=e.borderDash&&e.borderDash.length;return !(t._decimated||t._loop||e.tension||"monotone"===e.cubicInterpolationMode||e.stepped||i)?Gn:Kn}Yn.id="arc",Yn.defaults={borderAlign:"center",borderColor:"#fff",borderJoinStyle:void 0,borderRadius:0,borderWidth:2,offset:0,spacing:0,angle:void 0,circular:!0},Yn.defaultRoutes={backgroundColor:"backgroundColor"};const Jn="function"==typeof Path2D;function Qn(t,e,i,s){Jn&&!e.options.segment?function(t,e,i,s){let n=e._path;n||(n=e._path=new Path2D,e.path(n,i,s)&&n.closePath()),Un(t,e.options),t.stroke(n);}(t,e,i,s):function(t,e,i,s){const{segments:n,options:o}=e,a=Zn(e);for(const r of n)Un(t,o,r.style),t.beginPath(),a(t,e,r,{start:i,end:i+s-1})&&t.closePath(),t.stroke();}(t,e,i,s);}class to extends Es{constructor(t){super(),this.animated=!0,this.options=void 0,this._chart=void 0,this._loop=void 0,this._fullLoop=void 0,this._path=void 0,this._points=void 0,this._segments=void 0,this._decimated=!1,this._pointsUpdated=!1,this._datasetIndex=void 0,t&&Object.assign(this,t);}updateControlPoints(t,e){const i=this.options;if((i.tension||"monotone"===i.cubicInterpolationMode)&&!i.stepped&&!this._pointsUpdated){const s=i.spanGaps?this._loop:this._fullLoop;Qe(this._points,i,t,s,e),this._pointsUpdated=!0;}}set points(t){this._points=t,delete this._segments,delete this._path,this._pointsUpdated=!1;}get points(){return this._points}get segments(){return this._segments||(this._segments=Di(this,this.options.segment))}first(){const t=this.segments,e=this.points;return t.length&&e[t[0].start]}last(){const t=this.segments,e=this.points,i=t.length;return i&&e[t[i-1].end]}interpolate(t,e){const i=this.options,s=t[e],n=this.points,o=Pi(this,{property:e,start:s,end:s});if(!o.length)return;const a=[],r=function(t){return t.stepped?oi:t.tension||"monotone"===t.cubicInterpolationMode?ai:ni}(i);let l,h;for(l=0,h=o.length;l<h;++l){const{start:h,end:c}=o[l],d=n[h],u=n[c];if(d===u){a.push(d);continue}const f=r(d,u,Math.abs((s-d[e])/(u[e]-d[e])),i.stepped);f[e]=t[e],a.push(f);}return 1===a.length?a[0]:a}pathSegment(t,e,i){return Zn(this)(t,this,e,i)}path(t,e,i){const s=this.segments,n=Zn(this);let o=this._loop;e=e||0,i=i||this.points.length-e;for(const a of s)o&=n(t,this,a,{start:e,end:e+i-1});return !!o}draw(t,e,i,s){const n=this.options||{};(this.points||[]).length&&n.borderWidth&&(t.save(),Qn(t,this,i,s),t.restore()),this.animated&&(this._pointsUpdated=!1,this._path=void 0);}}function eo(t,e,i,s){const n=t.options,{[i]:o}=t.getProps([i],s);return Math.abs(e-o)<n.radius+n.hitRadius}to.id="line",to.defaults={borderCapStyle:"butt",borderDash:[],borderDashOffset:0,borderJoinStyle:"miter",borderWidth:3,capBezierPoints:!0,cubicInterpolationMode:"default",fill:!1,spanGaps:!1,stepped:!1,tension:0},to.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"},to.descriptors={_scriptable:!0,_indexable:t=>"borderDash"!==t&&"fill"!==t};class io extends Es{constructor(t){super(),this.options=void 0,this.parsed=void 0,this.skip=void 0,this.stop=void 0,t&&Object.assign(this,t);}inRange(t,e,i){const s=this.options,{x:n,y:o}=this.getProps(["x","y"],i);return Math.pow(t-n,2)+Math.pow(e-o,2)<Math.pow(s.hitRadius+s.radius,2)}inXRange(t,e){return eo(this,t,"x",e)}inYRange(t,e){return eo(this,t,"y",e)}getCenterPoint(t){const{x:e,y:i}=this.getProps(["x","y"],t);return {x:e,y:i}}size(t){let e=(t=t||this.options||{}).radius||0;e=Math.max(e,e&&t.hoverRadius||0);return 2*(e+(e&&t.borderWidth||0))}draw(t,e){const i=this.options;this.skip||i.radius<.1||!Se(this,e,this.size(i)/2)||(t.strokeStyle=i.borderColor,t.lineWidth=i.borderWidth,t.fillStyle=i.backgroundColor,Me(t,i,this.x,this.y));}getRange(){const t=this.options||{};return t.radius+t.hitRadius}}function so(t,e){const{x:i,y:s,base:n,width:o,height:a}=t.getProps(["x","y","base","width","height"],e);let r,l,h,c,d;return t.horizontal?(d=a/2,r=Math.min(i,n),l=Math.max(i,n),h=s-d,c=s+d):(d=o/2,r=i-d,l=i+d,h=Math.min(s,n),c=Math.max(s,n)),{left:r,top:h,right:l,bottom:c}}function no(t,e,i,s){return t?0:Z(e,i,s)}function oo(t){const e=so(t),i=e.right-e.left,s=e.bottom-e.top,o=function(t,e,i){const s=t.options.borderWidth,n=t.borderSkipped,o=fi(s);return {t:no(n.top,o.top,0,i),r:no(n.right,o.right,0,e),b:no(n.bottom,o.bottom,0,i),l:no(n.left,o.left,0,e)}}(t,i/2,s/2),a=function(t,e,i){const{enableBorderRadius:s}=t.getProps(["enableBorderRadius"]),o=t.options.borderRadius,a=gi(o),r=Math.min(e,i),l=t.borderSkipped,h=s||n(o);return {topLeft:no(!h||l.top||l.left,a.topLeft,0,r),topRight:no(!h||l.top||l.right,a.topRight,0,r),bottomLeft:no(!h||l.bottom||l.left,a.bottomLeft,0,r),bottomRight:no(!h||l.bottom||l.right,a.bottomRight,0,r)}}(t,i/2,s/2);return {outer:{x:e.left,y:e.top,w:i,h:s,radius:a},inner:{x:e.left+o.l,y:e.top+o.t,w:i-o.l-o.r,h:s-o.t-o.b,radius:{topLeft:Math.max(0,a.topLeft-Math.max(o.t,o.l)),topRight:Math.max(0,a.topRight-Math.max(o.t,o.r)),bottomLeft:Math.max(0,a.bottomLeft-Math.max(o.b,o.l)),bottomRight:Math.max(0,a.bottomRight-Math.max(o.b,o.r))}}}}function ao(t,e,i,s){const n=null===e,o=null===i,a=t&&!(n&&o)&&so(t,s);return a&&(n||Q(e,a.left,a.right))&&(o||Q(i,a.top,a.bottom))}function ro(t,e){t.rect(e.x,e.y,e.w,e.h);}function lo(t,e,i={}){const s=t.x!==i.x?-e:0,n=t.y!==i.y?-e:0,o=(t.x+t.w!==i.x+i.w?e:0)-s,a=(t.y+t.h!==i.y+i.h?e:0)-n;return {x:t.x+s,y:t.y+n,w:t.w+o,h:t.h+a,radius:t.radius}}io.id="point",io.defaults={borderWidth:1,hitRadius:1,hoverBorderWidth:1,hoverRadius:4,pointStyle:"circle",radius:3,rotation:0},io.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};class ho extends Es{constructor(t){super(),this.options=void 0,this.horizontal=void 0,this.base=void 0,this.width=void 0,this.height=void 0,this.inflateAmount=void 0,t&&Object.assign(this,t);}draw(t){const{inflateAmount:e,options:{borderColor:i,backgroundColor:s}}=this,{inner:n,outer:o}=oo(this),a=(r=o.radius).topLeft||r.topRight||r.bottomLeft||r.bottomRight?Le:ro;var r;t.save(),o.w===n.w&&o.h===n.h||(t.beginPath(),a(t,lo(o,e,n)),t.clip(),a(t,lo(n,-e,o)),t.fillStyle=i,t.fill("evenodd")),t.beginPath(),a(t,lo(n,e)),t.fillStyle=s,t.fill(),t.restore();}inRange(t,e,i){return ao(this,t,e,i)}inXRange(t,e){return ao(this,t,null,e)}inYRange(t,e){return ao(this,null,t,e)}getCenterPoint(t){const{x:e,y:i,base:s,horizontal:n}=this.getProps(["x","y","base","horizontal"],t);return {x:n?(e+s)/2:e,y:n?i:(i+s)/2}}getRange(t){return "x"===t?this.width/2:this.height/2}}ho.id="bar",ho.defaults={borderSkipped:"start",borderWidth:0,borderRadius:0,inflateAmount:"auto",pointStyle:void 0},ho.defaultRoutes={backgroundColor:"backgroundColor",borderColor:"borderColor"};var co=Object.freeze({__proto__:null,ArcElement:Yn,LineElement:to,PointElement:io,BarElement:ho});function uo(t){if(t._decimated){const e=t._data;delete t._decimated,delete t._data,Object.defineProperty(t,"data",{value:e});}}function fo(t){t.data.datasets.forEach((t=>{uo(t);}));}var go={id:"decimation",defaults:{algorithm:"min-max",enabled:!1},beforeElementsUpdate:(t,e,s)=>{if(!s.enabled)return void fo(t);const n=t.width;t.data.datasets.forEach(((e,o)=>{const{_data:a,indexAxis:r}=e,l=t.getDatasetMeta(o),h=a||e.data;if("y"===bi([r,t.options.indexAxis]))return;if(!l.controller.supportsDecimation)return;const c=t.scales[l.xAxisID];if("linear"!==c.type&&"time"!==c.type)return;if(t.options.parsing)return;let{start:d,count:u}=function(t,e){const i=e.length;let s,n=0;const{iScale:o}=t,{min:a,max:r,minDefined:l,maxDefined:h}=o.getUserBounds();return l&&(n=Z(et(e,o.axis,a).lo,0,i-1)),s=h?Z(et(e,o.axis,r).hi+1,n,i)-n:i-n,{start:n,count:s}}(l,h);if(u<=(s.threshold||4*n))return void uo(e);let f;switch(i(a)&&(e._data=h,delete e.data,Object.defineProperty(e,"data",{configurable:!0,enumerable:!0,get:function(){return this._decimated},set:function(t){this._data=t;}})),s.algorithm){case"lttb":f=function(t,e,i,s,n){const o=n.samples||s;if(o>=i)return t.slice(e,e+i);const a=[],r=(i-2)/(o-2);let l=0;const h=e+i-1;let c,d,u,f,g,p=e;for(a[l++]=t[p],c=0;c<o-2;c++){let s,n=0,o=0;const h=Math.floor((c+1)*r)+1+e,m=Math.min(Math.floor((c+2)*r)+1,i)+e,b=m-h;for(s=h;s<m;s++)n+=t[s].x,o+=t[s].y;n/=b,o/=b;const x=Math.floor(c*r)+1+e,_=Math.min(Math.floor((c+1)*r)+1,i)+e,{x:y,y:v}=t[p];for(u=f=-1,s=x;s<_;s++)f=.5*Math.abs((y-n)*(t[s].y-v)-(y-t[s].x)*(o-v)),f>u&&(u=f,d=t[s],g=s);a[l++]=d,p=g;}return a[l++]=t[h],a}(h,d,u,n,s);break;case"min-max":f=function(t,e,s,n){let o,a,r,l,h,c,d,u,f,g,p=0,m=0;const b=[],x=e+s-1,_=t[e].x,y=t[x].x-_;for(o=e;o<e+s;++o){a=t[o],r=(a.x-_)/y*n,l=a.y;const e=0|r;if(e===h)l<f?(f=l,c=o):l>g&&(g=l,d=o),p=(m*p+a.x)/++m;else {const s=o-1;if(!i(c)&&!i(d)){const e=Math.min(c,d),i=Math.max(c,d);e!==u&&e!==s&&b.push({...t[e],x:p}),i!==u&&i!==s&&b.push({...t[i],x:p});}o>0&&s!==u&&b.push(t[s]),b.push(a),h=e,m=0,f=g=l,c=d=u=o;}}return b}(h,d,u,n);break;default:throw new Error(`Unsupported decimation algorithm '${s.algorithm}'`)}e._decimated=f;}));},destroy(t){fo(t);}};function po(t,e,i,s){if(s)return;let n=e[t],o=i[t];return "angle"===t&&(n=K(n),o=K(o)),{property:t,start:n,end:o}}function mo(t,e,i){for(;e>t;e--){const t=i[e];if(!isNaN(t.x)&&!isNaN(t.y))break}return e}function bo(t,e,i,s){return t&&e?s(t[i],e[i]):t?t[i]:e?e[i]:0}function xo(t,e){let i=[],n=!1;return s(t)?(n=!0,i=t):i=function(t,e){const{x:i=null,y:s=null}=t||{},n=e.points,o=[];return e.segments.forEach((({start:t,end:e})=>{e=mo(t,e,n);const a=n[t],r=n[e];null!==s?(o.push({x:a.x,y:s}),o.push({x:r.x,y:s})):null!==i&&(o.push({x:i,y:a.y}),o.push({x:i,y:r.y}));})),o}(t,e),i.length?new to({points:i,options:{tension:0},_loop:n,_fullLoop:n}):null}function _o(t){return t&&!1!==t.fill}function yo(t,e,i){let s=t[e].fill;const n=[e];let a;if(!i)return s;for(;!1!==s&&-1===n.indexOf(s);){if(!o(s))return s;if(a=t[s],!a)return !1;if(a.visible)return s;n.push(s),s=a.fill;}return !1}function vo(t,e,i){const s=function(t){const e=t.options,i=e.fill;let s=r(i&&i.target,i);void 0===s&&(s=!!e.backgroundColor);if(!1===s||null===s)return !1;if(!0===s)return "origin";return s}(t);if(n(s))return !isNaN(s.value)&&s;let a=parseFloat(s);return o(a)&&Math.floor(a)===a?function(t,e,i,s){"-"!==t&&"+"!==t||(i=e+i);if(i===e||i<0||i>=s)return !1;return i}(s[0],e,a,i):["origin","start","end","stack","shape"].indexOf(s)>=0&&s}function wo(t,e,i){const s=[];for(let n=0;n<i.length;n++){const o=i[n],{first:a,last:r,point:l}=Mo(o,e,"x");if(!(!l||a&&r))if(a)s.unshift(l);else if(t.push(l),!r)break}t.push(...s);}function Mo(t,e,i){const s=t.interpolate(e,i);if(!s)return {};const n=s[i],o=t.segments,a=t.points;let r=!1,l=!1;for(let t=0;t<o.length;t++){const e=o[t],s=a[e.start][i],h=a[e.end][i];if(Q(n,s,h)){r=n===s,l=n===h;break}}return {first:r,last:l,point:s}}class ko{constructor(t){this.x=t.x,this.y=t.y,this.radius=t.radius;}pathSegment(t,e,i){const{x:s,y:n,radius:o}=this;return e=e||{start:0,end:O},t.arc(s,n,o,e.end,e.start,!0),!i.bounds}interpolate(t){const{x:e,y:i,radius:s}=this,n=t.angle;return {x:e+Math.cos(n)*s,y:i+Math.sin(n)*s,angle:n}}}function So(t){const{chart:e,fill:i,line:s}=t;if(o(i))return function(t,e){const i=t.getDatasetMeta(e);return i&&t.isDatasetVisible(e)?i.dataset:null}(e,i);if("stack"===i)return function(t){const{scale:e,index:i,line:s}=t,n=[],o=s.segments,a=s.points,r=function(t,e){const i=[],s=t.getMatchingVisibleMetas("line");for(let t=0;t<s.length;t++){const n=s[t];if(n.index===e)break;n.hidden||i.unshift(n.dataset);}return i}(e,i);r.push(xo({x:null,y:e.bottom},s));for(let t=0;t<o.length;t++){const e=o[t];for(let t=e.start;t<=e.end;t++)wo(n,a[t],r);}return new to({points:n,options:{}})}(t);if("shape"===i)return !0;const a=function(t){if((t.scale||{}).getPointPositionForValue)return function(t){const{scale:e,fill:i}=t,s=e.options,o=e.getLabels().length,a=s.reverse?e.max:e.min,r=function(t,e,i){let s;return s="start"===t?i:"end"===t?e.options.reverse?e.min:e.max:n(t)?t.value:e.getBaseValue(),s}(i,e,a),l=[];if(s.grid.circular){const t=e.getPointPositionForValue(0,a);return new ko({x:t.x,y:t.y,radius:e.getDistanceFromCenterForValue(r)})}for(let t=0;t<o;++t)l.push(e.getPointPositionForValue(t,r));return l}(t);return function(t){const{scale:e={},fill:i}=t,s=function(t,e){let i=null;return "start"===t?i=e.bottom:"end"===t?i=e.top:n(t)?i=e.getPixelForValue(t.value):e.getBasePixel&&(i=e.getBasePixel()),i}(i,e);if(o(s)){const t=e.isHorizontal();return {x:t?s:null,y:t?null:s}}return null}(t)}(t);return a instanceof ko?a:xo(a,s)}function Po(t,e,i){const s=So(e),{line:n,scale:o,axis:a}=e,r=n.options,l=r.fill,h=r.backgroundColor,{above:c=h,below:d=h}=l||{};s&&n.points.length&&(Pe(t,i),function(t,e){const{line:i,target:s,above:n,below:o,area:a,scale:r}=e,l=i._loop?"angle":e.axis;t.save(),"x"===l&&o!==n&&(Do(t,s,a.top),Oo(t,{line:i,target:s,color:n,scale:r,property:l}),t.restore(),t.save(),Do(t,s,a.bottom));Oo(t,{line:i,target:s,color:o,scale:r,property:l}),t.restore();}(t,{line:n,target:s,above:c,below:d,area:i,scale:o,axis:a}),De(t));}function Do(t,e,i){const{segments:s,points:n}=e;let o=!0,a=!1;t.beginPath();for(const r of s){const{start:s,end:l}=r,h=n[s],c=n[mo(s,l,n)];o?(t.moveTo(h.x,h.y),o=!1):(t.lineTo(h.x,i),t.lineTo(h.x,h.y)),a=!!e.pathSegment(t,r,{move:a}),a?t.closePath():t.lineTo(c.x,i);}t.lineTo(e.first().x,i),t.closePath(),t.clip();}function Oo(t,e){const{line:i,target:s,property:n,color:o,scale:a}=e,r=function(t,e,i){const s=t.segments,n=t.points,o=e.points,a=[];for(const t of s){let{start:s,end:r}=t;r=mo(s,r,n);const l=po(i,n[s],n[r],t.loop);if(!e.segments){a.push({source:t,target:l,start:n[s],end:n[r]});continue}const h=Pi(e,l);for(const e of h){const s=po(i,o[e.start],o[e.end],e.loop),r=Si(t,n,s);for(const t of r)a.push({source:t,target:e,start:{[i]:bo(l,s,"start",Math.max)},end:{[i]:bo(l,s,"end",Math.min)}});}}return a}(i,s,n);for(const{source:e,target:l,start:h,end:c}of r){const{style:{backgroundColor:r=o}={}}=e,d=!0!==s;t.save(),t.fillStyle=r,Co(t,a,d&&po(n,h,c)),t.beginPath();const u=!!i.pathSegment(t,e);let f;if(d){u?t.closePath():Ao(t,s,c,n);const e=!!s.pathSegment(t,l,{move:u,reverse:!0});f=u&&e,f||Ao(t,s,h,n);}t.closePath(),t.fill(f?"evenodd":"nonzero"),t.restore();}}function Co(t,e,i){const{top:s,bottom:n}=e.chart.chartArea,{property:o,start:a,end:r}=i||{};"x"===o&&(t.beginPath(),t.rect(a,s,r-a,n-s),t.clip());}function Ao(t,e,i,s){const n=e.interpolate(i,s);n&&t.lineTo(n.x,n.y);}var To={id:"filler",afterDatasetsUpdate(t,e,i){const s=(t.data.datasets||[]).length,n=[];let o,a,r,l;for(a=0;a<s;++a)o=t.getDatasetMeta(a),r=o.dataset,l=null,r&&r.options&&r instanceof to&&(l={visible:t.isDatasetVisible(a),index:a,fill:vo(r,a,s),chart:t,axis:o.controller.options.indexAxis,scale:o.vScale,line:r}),o.$filler=l,n.push(l);for(a=0;a<s;++a)l=n[a],l&&!1!==l.fill&&(l.fill=yo(n,a,i.propagate));},beforeDraw(t,e,i){const s="beforeDraw"===i.drawTime,n=t.getSortedVisibleDatasetMetas(),o=t.chartArea;for(let e=n.length-1;e>=0;--e){const i=n[e].$filler;i&&(i.line.updateControlPoints(o,i.axis),s&&i.fill&&Po(t.ctx,i,o));}},beforeDatasetsDraw(t,e,i){if("beforeDatasetsDraw"!==i.drawTime)return;const s=t.getSortedVisibleDatasetMetas();for(let e=s.length-1;e>=0;--e){const i=s[e].$filler;_o(i)&&Po(t.ctx,i,t.chartArea);}},beforeDatasetDraw(t,e,i){const s=e.meta.$filler;_o(s)&&"beforeDatasetDraw"===i.drawTime&&Po(t.ctx,s,t.chartArea);},defaults:{propagate:!0,drawTime:"beforeDatasetDraw"}};const Lo=(t,e)=>{let{boxHeight:i=e,boxWidth:s=e}=t;return t.usePointStyle&&(i=Math.min(i,e),s=t.pointStyleWidth||Math.min(s,e)),{boxWidth:s,boxHeight:i,itemHeight:Math.max(e,i)}};class Eo extends Es{constructor(t){super(),this._added=!1,this.legendHitBoxes=[],this._hoveredItem=null,this.doughnutMode=!1,this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this.legendItems=void 0,this.columnSizes=void 0,this.lineWidths=void 0,this.maxHeight=void 0,this.maxWidth=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.height=void 0,this.width=void 0,this._margins=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0;}update(t,e,i){this.maxWidth=t,this.maxHeight=e,this._margins=i,this.setDimensions(),this.buildLabels(),this.fit();}setDimensions(){this.isHorizontal()?(this.width=this.maxWidth,this.left=this._margins.left,this.right=this.width):(this.height=this.maxHeight,this.top=this._margins.top,this.bottom=this.height);}buildLabels(){const t=this.options.labels||{};let e=c(t.generateLabels,[this.chart],this)||[];t.filter&&(e=e.filter((e=>t.filter(e,this.chart.data)))),t.sort&&(e=e.sort(((e,i)=>t.sort(e,i,this.chart.data)))),this.options.reverse&&e.reverse(),this.legendItems=e;}fit(){const{options:t,ctx:e}=this;if(!t.display)return void(this.width=this.height=0);const i=t.labels,s=mi(i.font),n=s.size,o=this._computeTitleHeight(),{boxWidth:a,itemHeight:r}=Lo(i,n);let l,h;e.font=s.string,this.isHorizontal()?(l=this.maxWidth,h=this._fitRows(o,n,a,r)+10):(h=this.maxHeight,l=this._fitCols(o,n,a,r)+10),this.width=Math.min(l,t.maxWidth||this.maxWidth),this.height=Math.min(h,t.maxHeight||this.maxHeight);}_fitRows(t,e,i,s){const{ctx:n,maxWidth:o,options:{labels:{padding:a}}}=this,r=this.legendHitBoxes=[],l=this.lineWidths=[0],h=s+a;let c=t;n.textAlign="left",n.textBaseline="middle";let d=-1,u=-h;return this.legendItems.forEach(((t,f)=>{const g=i+e/2+n.measureText(t.text).width;(0===f||l[l.length-1]+g+2*a>o)&&(c+=h,l[l.length-(f>0?0:1)]=0,u+=h,d++),r[f]={left:0,top:u,row:d,width:g,height:s},l[l.length-1]+=g+a;})),c}_fitCols(t,e,i,s){const{ctx:n,maxHeight:o,options:{labels:{padding:a}}}=this,r=this.legendHitBoxes=[],l=this.columnSizes=[],h=o-t;let c=a,d=0,u=0,f=0,g=0;return this.legendItems.forEach(((t,o)=>{const p=i+e/2+n.measureText(t.text).width;o>0&&u+s+2*a>h&&(c+=d+a,l.push({width:d,height:u}),f+=d+a,g++,d=u=0),r[o]={left:f,top:u,col:g,width:p,height:s},d=Math.max(d,p),u+=s+a;})),c+=d,l.push({width:d,height:u}),c}adjustHitBoxes(){if(!this.options.display)return;const t=this._computeTitleHeight(),{legendHitBoxes:e,options:{align:i,labels:{padding:s},rtl:n}}=this,o=yi(n,this.left,this.width);if(this.isHorizontal()){let n=0,a=ut(i,this.left+s,this.right-this.lineWidths[n]);for(const r of e)n!==r.row&&(n=r.row,a=ut(i,this.left+s,this.right-this.lineWidths[n])),r.top+=this.top+t+s,r.left=o.leftForLtr(o.x(a),r.width),a+=r.width+s;}else {let n=0,a=ut(i,this.top+t+s,this.bottom-this.columnSizes[n].height);for(const r of e)r.col!==n&&(n=r.col,a=ut(i,this.top+t+s,this.bottom-this.columnSizes[n].height)),r.top=a,r.left+=this.left+s,r.left=o.leftForLtr(o.x(r.left),r.width),a+=r.height+s;}}isHorizontal(){return "top"===this.options.position||"bottom"===this.options.position}draw(){if(this.options.display){const t=this.ctx;Pe(t,this),this._draw(),De(t);}}_draw(){const{options:t,columnSizes:e,lineWidths:i,ctx:s}=this,{align:n,labels:o}=t,a=ne.color,l=yi(t.rtl,this.left,this.width),h=mi(o.font),{color:c,padding:d}=o,u=h.size,f=u/2;let g;this.drawTitle(),s.textAlign=l.textAlign("left"),s.textBaseline="middle",s.lineWidth=.5,s.font=h.string;const{boxWidth:p,boxHeight:m,itemHeight:b}=Lo(o,u),x=this.isHorizontal(),_=this._computeTitleHeight();g=x?{x:ut(n,this.left+d,this.right-i[0]),y:this.top+d+_,line:0}:{x:this.left+d,y:ut(n,this.top+_+d,this.bottom-e[0].height),line:0},vi(this.ctx,t.textDirection);const y=b+d;this.legendItems.forEach(((v,w)=>{s.strokeStyle=v.fontColor||c,s.fillStyle=v.fontColor||c;const M=s.measureText(v.text).width,k=l.textAlign(v.textAlign||(v.textAlign=o.textAlign)),S=p+f+M;let P=g.x,D=g.y;l.setWidth(this.width),x?w>0&&P+S+d>this.right&&(D=g.y+=y,g.line++,P=g.x=ut(n,this.left+d,this.right-i[g.line])):w>0&&D+y>this.bottom&&(P=g.x=P+e[g.line].width+d,g.line++,D=g.y=ut(n,this.top+_+d,this.bottom-e[g.line].height));!function(t,e,i){if(isNaN(p)||p<=0||isNaN(m)||m<0)return;s.save();const n=r(i.lineWidth,1);if(s.fillStyle=r(i.fillStyle,a),s.lineCap=r(i.lineCap,"butt"),s.lineDashOffset=r(i.lineDashOffset,0),s.lineJoin=r(i.lineJoin,"miter"),s.lineWidth=n,s.strokeStyle=r(i.strokeStyle,a),s.setLineDash(r(i.lineDash,[])),o.usePointStyle){const a={radius:m*Math.SQRT2/2,pointStyle:i.pointStyle,rotation:i.rotation,borderWidth:n},r=l.xPlus(t,p/2);ke(s,a,r,e+f,o.pointStyleWidth&&p);}else {const o=e+Math.max((u-m)/2,0),a=l.leftForLtr(t,p),r=gi(i.borderRadius);s.beginPath(),Object.values(r).some((t=>0!==t))?Le(s,{x:a,y:o,w:p,h:m,radius:r}):s.rect(a,o,p,m),s.fill(),0!==n&&s.stroke();}s.restore();}(l.x(P),D,v),P=ft(k,P+p+f,x?P+S:this.right,t.rtl),function(t,e,i){Ae(s,i.text,t,e+b/2,h,{strikethrough:i.hidden,textAlign:l.textAlign(i.textAlign)});}(l.x(P),D,v),x?g.x+=S+d:g.y+=y;})),wi(this.ctx,t.textDirection);}drawTitle(){const t=this.options,e=t.title,i=mi(e.font),s=pi(e.padding);if(!e.display)return;const n=yi(t.rtl,this.left,this.width),o=this.ctx,a=e.position,r=i.size/2,l=s.top+r;let h,c=this.left,d=this.width;if(this.isHorizontal())d=Math.max(...this.lineWidths),h=this.top+l,c=ut(t.align,c,this.right-d);else {const e=this.columnSizes.reduce(((t,e)=>Math.max(t,e.height)),0);h=l+ut(t.align,this.top,this.bottom-e-t.labels.padding-this._computeTitleHeight());}const u=ut(a,c,c+d);o.textAlign=n.textAlign(dt(a)),o.textBaseline="middle",o.strokeStyle=e.color,o.fillStyle=e.color,o.font=i.string,Ae(o,e.text,u,h,i);}_computeTitleHeight(){const t=this.options.title,e=mi(t.font),i=pi(t.padding);return t.display?e.lineHeight+i.height:0}_getLegendItemAt(t,e){let i,s,n;if(Q(t,this.left,this.right)&&Q(e,this.top,this.bottom))for(n=this.legendHitBoxes,i=0;i<n.length;++i)if(s=n[i],Q(t,s.left,s.left+s.width)&&Q(e,s.top,s.top+s.height))return this.legendItems[i];return null}handleEvent(t){const e=this.options;if(!function(t,e){if(("mousemove"===t||"mouseout"===t)&&(e.onHover||e.onLeave))return !0;if(e.onClick&&("click"===t||"mouseup"===t))return !0;return !1}(t.type,e))return;const i=this._getLegendItemAt(t.x,t.y);if("mousemove"===t.type||"mouseout"===t.type){const o=this._hoveredItem,a=(n=i,null!==(s=o)&&null!==n&&s.datasetIndex===n.datasetIndex&&s.index===n.index);o&&!a&&c(e.onLeave,[t,o,this],this),this._hoveredItem=i,i&&!a&&c(e.onHover,[t,i,this],this);}else i&&c(e.onClick,[t,i,this],this);var s,n;}}var Ro={id:"legend",_element:Eo,start(t,e,i){const s=t.legend=new Eo({ctx:t.ctx,options:i,chart:t});Zi.configure(t,s,i),Zi.addBox(t,s);},stop(t){Zi.removeBox(t,t.legend),delete t.legend;},beforeUpdate(t,e,i){const s=t.legend;Zi.configure(t,s,i),s.options=i;},afterUpdate(t){const e=t.legend;e.buildLabels(),e.adjustHitBoxes();},afterEvent(t,e){e.replay||t.legend.handleEvent(e.event);},defaults:{display:!0,position:"top",align:"center",fullSize:!0,reverse:!1,weight:1e3,onClick(t,e,i){const s=e.datasetIndex,n=i.chart;n.isDatasetVisible(s)?(n.hide(s),e.hidden=!0):(n.show(s),e.hidden=!1);},onHover:null,onLeave:null,labels:{color:t=>t.chart.options.color,boxWidth:40,padding:10,generateLabels(t){const e=t.data.datasets,{labels:{usePointStyle:i,pointStyle:s,textAlign:n,color:o}}=t.legend.options;return t._getSortedDatasetMetas().map((t=>{const a=t.controller.getStyle(i?0:void 0),r=pi(a.borderWidth);return {text:e[t.index].label,fillStyle:a.backgroundColor,fontColor:o,hidden:!t.visible,lineCap:a.borderCapStyle,lineDash:a.borderDash,lineDashOffset:a.borderDashOffset,lineJoin:a.borderJoinStyle,lineWidth:(r.width+r.height)/4,strokeStyle:a.borderColor,pointStyle:s||a.pointStyle,rotation:a.rotation,textAlign:n||a.textAlign,borderRadius:0,datasetIndex:t.index}}),this)}},title:{color:t=>t.chart.options.color,display:!1,position:"center",text:""}},descriptors:{_scriptable:t=>!t.startsWith("on"),labels:{_scriptable:t=>!["generateLabels","filter","sort"].includes(t)}}};class Io extends Es{constructor(t){super(),this.chart=t.chart,this.options=t.options,this.ctx=t.ctx,this._padding=void 0,this.top=void 0,this.bottom=void 0,this.left=void 0,this.right=void 0,this.width=void 0,this.height=void 0,this.position=void 0,this.weight=void 0,this.fullSize=void 0;}update(t,e){const i=this.options;if(this.left=0,this.top=0,!i.display)return void(this.width=this.height=this.right=this.bottom=0);this.width=this.right=t,this.height=this.bottom=e;const n=s(i.text)?i.text.length:1;this._padding=pi(i.padding);const o=n*mi(i.font).lineHeight+this._padding.height;this.isHorizontal()?this.height=o:this.width=o;}isHorizontal(){const t=this.options.position;return "top"===t||"bottom"===t}_drawArgs(t){const{top:e,left:i,bottom:s,right:n,options:o}=this,a=o.align;let r,l,h,c=0;return this.isHorizontal()?(l=ut(a,i,n),h=e+t,r=n-i):("left"===o.position?(l=i+t,h=ut(a,s,e),c=-.5*D):(l=n-t,h=ut(a,e,s),c=.5*D),r=s-e),{titleX:l,titleY:h,maxWidth:r,rotation:c}}draw(){const t=this.ctx,e=this.options;if(!e.display)return;const i=mi(e.font),s=i.lineHeight/2+this._padding.top,{titleX:n,titleY:o,maxWidth:a,rotation:r}=this._drawArgs(s);Ae(t,e.text,0,0,i,{color:e.color,maxWidth:a,rotation:r,textAlign:dt(e.align),textBaseline:"middle",translation:[n,o]});}}var zo={id:"title",_element:Io,start(t,e,i){!function(t,e){const i=new Io({ctx:t.ctx,options:e,chart:t});Zi.configure(t,i,e),Zi.addBox(t,i),t.titleBlock=i;}(t,i);},stop(t){const e=t.titleBlock;Zi.removeBox(t,e),delete t.titleBlock;},beforeUpdate(t,e,i){const s=t.titleBlock;Zi.configure(t,s,i),s.options=i;},defaults:{align:"center",display:!1,font:{weight:"bold"},fullSize:!0,padding:10,position:"top",text:"",weight:2e3},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const Fo=new WeakMap;var Vo={id:"subtitle",start(t,e,i){const s=new Io({ctx:t.ctx,options:i,chart:t});Zi.configure(t,s,i),Zi.addBox(t,s),Fo.set(t,s);},stop(t){Zi.removeBox(t,Fo.get(t)),Fo.delete(t);},beforeUpdate(t,e,i){const s=Fo.get(t);Zi.configure(t,s,i),s.options=i;},defaults:{align:"center",display:!1,font:{weight:"normal"},fullSize:!0,padding:0,position:"top",text:"",weight:1500},defaultRoutes:{color:"color"},descriptors:{_scriptable:!0,_indexable:!1}};const Bo={average(t){if(!t.length)return !1;let e,i,s=0,n=0,o=0;for(e=0,i=t.length;e<i;++e){const i=t[e].element;if(i&&i.hasValue()){const t=i.tooltipPosition();s+=t.x,n+=t.y,++o;}}return {x:s/o,y:n/o}},nearest(t,e){if(!t.length)return !1;let i,s,n,o=e.x,a=e.y,r=Number.POSITIVE_INFINITY;for(i=0,s=t.length;i<s;++i){const s=t[i].element;if(s&&s.hasValue()){const t=X(e,s.getCenterPoint());t<r&&(r=t,n=s);}}if(n){const t=n.tooltipPosition();o=t.x,a=t.y;}return {x:o,y:a}}};function No(t,e){return e&&(s(e)?Array.prototype.push.apply(t,e):t.push(e)),t}function Wo(t){return ("string"==typeof t||t instanceof String)&&t.indexOf("\n")>-1?t.split("\n"):t}function jo(t,e){const{element:i,datasetIndex:s,index:n}=e,o=t.getDatasetMeta(s).controller,{label:a,value:r}=o.getLabelAndValue(n);return {chart:t,label:a,parsed:o.getParsed(n),raw:t.data.datasets[s].data[n],formattedValue:r,dataset:o.getDataset(),dataIndex:n,datasetIndex:s,element:i}}function Ho(t,e){const i=t.chart.ctx,{body:s,footer:n,title:o}=t,{boxWidth:a,boxHeight:r}=e,l=mi(e.bodyFont),h=mi(e.titleFont),c=mi(e.footerFont),u=o.length,f=n.length,g=s.length,p=pi(e.padding);let m=p.height,b=0,x=s.reduce(((t,e)=>t+e.before.length+e.lines.length+e.after.length),0);if(x+=t.beforeBody.length+t.afterBody.length,u&&(m+=u*h.lineHeight+(u-1)*e.titleSpacing+e.titleMarginBottom),x){m+=g*(e.displayColors?Math.max(r,l.lineHeight):l.lineHeight)+(x-g)*l.lineHeight+(x-1)*e.bodySpacing;}f&&(m+=e.footerMarginTop+f*c.lineHeight+(f-1)*e.footerSpacing);let _=0;const y=function(t){b=Math.max(b,i.measureText(t).width+_);};return i.save(),i.font=h.string,d(t.title,y),i.font=l.string,d(t.beforeBody.concat(t.afterBody),y),_=e.displayColors?a+2+e.boxPadding:0,d(s,(t=>{d(t.before,y),d(t.lines,y),d(t.after,y);})),_=0,i.font=c.string,d(t.footer,y),i.restore(),b+=p.width,{width:b,height:m}}function $o(t,e,i,s){const{x:n,width:o}=i,{width:a,chartArea:{left:r,right:l}}=t;let h="center";return "center"===s?h=n<=(r+l)/2?"left":"right":n<=o/2?h="left":n>=a-o/2&&(h="right"),function(t,e,i,s){const{x:n,width:o}=s,a=i.caretSize+i.caretPadding;return "left"===t&&n+o+a>e.width||"right"===t&&n-o-a<0||void 0}(h,t,e,i)&&(h="center"),h}function Yo(t,e,i){const s=i.yAlign||e.yAlign||function(t,e){const{y:i,height:s}=e;return i<s/2?"top":i>t.height-s/2?"bottom":"center"}(t,i);return {xAlign:i.xAlign||e.xAlign||$o(t,e,i,s),yAlign:s}}function Uo(t,e,i,s){const{caretSize:n,caretPadding:o,cornerRadius:a}=t,{xAlign:r,yAlign:l}=i,h=n+o,{topLeft:c,topRight:d,bottomLeft:u,bottomRight:f}=gi(a);let g=function(t,e){let{x:i,width:s}=t;return "right"===e?i-=s:"center"===e&&(i-=s/2),i}(e,r);const p=function(t,e,i){let{y:s,height:n}=t;return "top"===e?s+=i:s-="bottom"===e?n+i:n/2,s}(e,l,h);return "center"===l?"left"===r?g+=h:"right"===r&&(g-=h):"left"===r?g-=Math.max(c,u)+n:"right"===r&&(g+=Math.max(d,f)+n),{x:Z(g,0,s.width-e.width),y:Z(p,0,s.height-e.height)}}function Xo(t,e,i){const s=pi(i.padding);return "center"===e?t.x+t.width/2:"right"===e?t.x+t.width-s.right:t.x+s.left}function qo(t){return No([],Wo(t))}function Ko(t,e){const i=e&&e.dataset&&e.dataset.tooltip&&e.dataset.tooltip.callbacks;return i?t.override(i):t}class Go extends Es{constructor(t){super(),this.opacity=0,this._active=[],this._eventPosition=void 0,this._size=void 0,this._cachedAnimations=void 0,this._tooltipItems=[],this.$animations=void 0,this.$context=void 0,this.chart=t.chart||t._chart,this._chart=this.chart,this.options=t.options,this.dataPoints=void 0,this.title=void 0,this.beforeBody=void 0,this.body=void 0,this.afterBody=void 0,this.footer=void 0,this.xAlign=void 0,this.yAlign=void 0,this.x=void 0,this.y=void 0,this.height=void 0,this.width=void 0,this.caretX=void 0,this.caretY=void 0,this.labelColors=void 0,this.labelPointStyles=void 0,this.labelTextColors=void 0;}initialize(t){this.options=t,this._cachedAnimations=void 0,this.$context=void 0;}_resolveAnimations(){const t=this._cachedAnimations;if(t)return t;const e=this.chart,i=this.options.setContext(this.getContext()),s=i.enabled&&e.options.animation&&i.animations,n=new ys(this.chart,s);return s._cacheable&&(this._cachedAnimations=Object.freeze(n)),n}getContext(){return this.$context||(this.$context=(t=this.chart.getContext(),e=this,i=this._tooltipItems,_i(t,{tooltip:e,tooltipItems:i,type:"tooltip"})));var t,e,i;}getTitle(t,e){const{callbacks:i}=e,s=i.beforeTitle.apply(this,[t]),n=i.title.apply(this,[t]),o=i.afterTitle.apply(this,[t]);let a=[];return a=No(a,Wo(s)),a=No(a,Wo(n)),a=No(a,Wo(o)),a}getBeforeBody(t,e){return qo(e.callbacks.beforeBody.apply(this,[t]))}getBody(t,e){const{callbacks:i}=e,s=[];return d(t,(t=>{const e={before:[],lines:[],after:[]},n=Ko(i,t);No(e.before,Wo(n.beforeLabel.call(this,t))),No(e.lines,n.label.call(this,t)),No(e.after,Wo(n.afterLabel.call(this,t))),s.push(e);})),s}getAfterBody(t,e){return qo(e.callbacks.afterBody.apply(this,[t]))}getFooter(t,e){const{callbacks:i}=e,s=i.beforeFooter.apply(this,[t]),n=i.footer.apply(this,[t]),o=i.afterFooter.apply(this,[t]);let a=[];return a=No(a,Wo(s)),a=No(a,Wo(n)),a=No(a,Wo(o)),a}_createItems(t){const e=this._active,i=this.chart.data,s=[],n=[],o=[];let a,r,l=[];for(a=0,r=e.length;a<r;++a)l.push(jo(this.chart,e[a]));return t.filter&&(l=l.filter(((e,s,n)=>t.filter(e,s,n,i)))),t.itemSort&&(l=l.sort(((e,s)=>t.itemSort(e,s,i)))),d(l,(e=>{const i=Ko(t.callbacks,e);s.push(i.labelColor.call(this,e)),n.push(i.labelPointStyle.call(this,e)),o.push(i.labelTextColor.call(this,e));})),this.labelColors=s,this.labelPointStyles=n,this.labelTextColors=o,this.dataPoints=l,l}update(t,e){const i=this.options.setContext(this.getContext()),s=this._active;let n,o=[];if(s.length){const t=Bo[i.position].call(this,s,this._eventPosition);o=this._createItems(i),this.title=this.getTitle(o,i),this.beforeBody=this.getBeforeBody(o,i),this.body=this.getBody(o,i),this.afterBody=this.getAfterBody(o,i),this.footer=this.getFooter(o,i);const e=this._size=Ho(this,i),a=Object.assign({},t,e),r=Yo(this.chart,i,a),l=Uo(i,a,r,this.chart);this.xAlign=r.xAlign,this.yAlign=r.yAlign,n={opacity:1,x:l.x,y:l.y,width:e.width,height:e.height,caretX:t.x,caretY:t.y};}else 0!==this.opacity&&(n={opacity:0});this._tooltipItems=o,this.$context=void 0,n&&this._resolveAnimations().update(this,n),t&&i.external&&i.external.call(this,{chart:this.chart,tooltip:this,replay:e});}drawCaret(t,e,i,s){const n=this.getCaretPosition(t,i,s);e.lineTo(n.x1,n.y1),e.lineTo(n.x2,n.y2),e.lineTo(n.x3,n.y3);}getCaretPosition(t,e,i){const{xAlign:s,yAlign:n}=this,{caretSize:o,cornerRadius:a}=i,{topLeft:r,topRight:l,bottomLeft:h,bottomRight:c}=gi(a),{x:d,y:u}=t,{width:f,height:g}=e;let p,m,b,x,_,y;return "center"===n?(_=u+g/2,"left"===s?(p=d,m=p-o,x=_+o,y=_-o):(p=d+f,m=p+o,x=_-o,y=_+o),b=p):(m="left"===s?d+Math.max(r,h)+o:"right"===s?d+f-Math.max(l,c)-o:this.caretX,"top"===n?(x=u,_=x-o,p=m-o,b=m+o):(x=u+g,_=x+o,p=m+o,b=m-o),y=x),{x1:p,x2:m,x3:b,y1:x,y2:_,y3:y}}drawTitle(t,e,i){const s=this.title,n=s.length;let o,a,r;if(n){const l=yi(i.rtl,this.x,this.width);for(t.x=Xo(this,i.titleAlign,i),e.textAlign=l.textAlign(i.titleAlign),e.textBaseline="middle",o=mi(i.titleFont),a=i.titleSpacing,e.fillStyle=i.titleColor,e.font=o.string,r=0;r<n;++r)e.fillText(s[r],l.x(t.x),t.y+o.lineHeight/2),t.y+=o.lineHeight+a,r+1===n&&(t.y+=i.titleMarginBottom-a);}}_drawColorBox(t,e,i,s,o){const a=this.labelColors[i],r=this.labelPointStyles[i],{boxHeight:l,boxWidth:h,boxPadding:c}=o,d=mi(o.bodyFont),u=Xo(this,"left",o),f=s.x(u),g=l<d.lineHeight?(d.lineHeight-l)/2:0,p=e.y+g;if(o.usePointStyle){const e={radius:Math.min(h,l)/2,pointStyle:r.pointStyle,rotation:r.rotation,borderWidth:1},i=s.leftForLtr(f,h)+h/2,n=p+l/2;t.strokeStyle=o.multiKeyBackground,t.fillStyle=o.multiKeyBackground,Me(t,e,i,n),t.strokeStyle=a.borderColor,t.fillStyle=a.backgroundColor,Me(t,e,i,n);}else {t.lineWidth=n(a.borderWidth)?Math.max(...Object.values(a.borderWidth)):a.borderWidth||1,t.strokeStyle=a.borderColor,t.setLineDash(a.borderDash||[]),t.lineDashOffset=a.borderDashOffset||0;const e=s.leftForLtr(f,h-c),i=s.leftForLtr(s.xPlus(f,1),h-c-2),r=gi(a.borderRadius);Object.values(r).some((t=>0!==t))?(t.beginPath(),t.fillStyle=o.multiKeyBackground,Le(t,{x:e,y:p,w:h,h:l,radius:r}),t.fill(),t.stroke(),t.fillStyle=a.backgroundColor,t.beginPath(),Le(t,{x:i,y:p+1,w:h-2,h:l-2,radius:r}),t.fill()):(t.fillStyle=o.multiKeyBackground,t.fillRect(e,p,h,l),t.strokeRect(e,p,h,l),t.fillStyle=a.backgroundColor,t.fillRect(i,p+1,h-2,l-2));}t.fillStyle=this.labelTextColors[i];}drawBody(t,e,i){const{body:s}=this,{bodySpacing:n,bodyAlign:o,displayColors:a,boxHeight:r,boxWidth:l,boxPadding:h}=i,c=mi(i.bodyFont);let u=c.lineHeight,f=0;const g=yi(i.rtl,this.x,this.width),p=function(i){e.fillText(i,g.x(t.x+f),t.y+u/2),t.y+=u+n;},m=g.textAlign(o);let b,x,_,y,v,w,M;for(e.textAlign=o,e.textBaseline="middle",e.font=c.string,t.x=Xo(this,m,i),e.fillStyle=i.bodyColor,d(this.beforeBody,p),f=a&&"right"!==m?"center"===o?l/2+h:l+2+h:0,y=0,w=s.length;y<w;++y){for(b=s[y],x=this.labelTextColors[y],e.fillStyle=x,d(b.before,p),_=b.lines,a&&_.length&&(this._drawColorBox(e,t,y,g,i),u=Math.max(c.lineHeight,r)),v=0,M=_.length;v<M;++v)p(_[v]),u=c.lineHeight;d(b.after,p);}f=0,u=c.lineHeight,d(this.afterBody,p),t.y-=n;}drawFooter(t,e,i){const s=this.footer,n=s.length;let o,a;if(n){const r=yi(i.rtl,this.x,this.width);for(t.x=Xo(this,i.footerAlign,i),t.y+=i.footerMarginTop,e.textAlign=r.textAlign(i.footerAlign),e.textBaseline="middle",o=mi(i.footerFont),e.fillStyle=i.footerColor,e.font=o.string,a=0;a<n;++a)e.fillText(s[a],r.x(t.x),t.y+o.lineHeight/2),t.y+=o.lineHeight+i.footerSpacing;}}drawBackground(t,e,i,s){const{xAlign:n,yAlign:o}=this,{x:a,y:r}=t,{width:l,height:h}=i,{topLeft:c,topRight:d,bottomLeft:u,bottomRight:f}=gi(s.cornerRadius);e.fillStyle=s.backgroundColor,e.strokeStyle=s.borderColor,e.lineWidth=s.borderWidth,e.beginPath(),e.moveTo(a+c,r),"top"===o&&this.drawCaret(t,e,i,s),e.lineTo(a+l-d,r),e.quadraticCurveTo(a+l,r,a+l,r+d),"center"===o&&"right"===n&&this.drawCaret(t,e,i,s),e.lineTo(a+l,r+h-f),e.quadraticCurveTo(a+l,r+h,a+l-f,r+h),"bottom"===o&&this.drawCaret(t,e,i,s),e.lineTo(a+u,r+h),e.quadraticCurveTo(a,r+h,a,r+h-u),"center"===o&&"left"===n&&this.drawCaret(t,e,i,s),e.lineTo(a,r+c),e.quadraticCurveTo(a,r,a+c,r),e.closePath(),e.fill(),s.borderWidth>0&&e.stroke();}_updateAnimationTarget(t){const e=this.chart,i=this.$animations,s=i&&i.x,n=i&&i.y;if(s||n){const i=Bo[t.position].call(this,this._active,this._eventPosition);if(!i)return;const o=this._size=Ho(this,t),a=Object.assign({},i,this._size),r=Yo(e,t,a),l=Uo(t,a,r,e);s._to===l.x&&n._to===l.y||(this.xAlign=r.xAlign,this.yAlign=r.yAlign,this.width=o.width,this.height=o.height,this.caretX=i.x,this.caretY=i.y,this._resolveAnimations().update(this,l));}}_willRender(){return !!this.opacity}draw(t){const e=this.options.setContext(this.getContext());let i=this.opacity;if(!i)return;this._updateAnimationTarget(e);const s={width:this.width,height:this.height},n={x:this.x,y:this.y};i=Math.abs(i)<.001?0:i;const o=pi(e.padding),a=this.title.length||this.beforeBody.length||this.body.length||this.afterBody.length||this.footer.length;e.enabled&&a&&(t.save(),t.globalAlpha=i,this.drawBackground(n,t,s,e),vi(t,e.textDirection),n.y+=o.top,this.drawTitle(n,t,e),this.drawBody(n,t,e),this.drawFooter(n,t,e),wi(t,e.textDirection),t.restore());}getActiveElements(){return this._active||[]}setActiveElements(t,e){const i=this._active,s=t.map((({datasetIndex:t,index:e})=>{const i=this.chart.getDatasetMeta(t);if(!i)throw new Error("Cannot find a dataset at index "+t);return {datasetIndex:t,element:i.data[e],index:e}})),n=!u(i,s),o=this._positionChanged(s,e);(n||o)&&(this._active=s,this._eventPosition=e,this._ignoreReplayEvents=!0,this.update(!0));}handleEvent(t,e,i=!0){if(e&&this._ignoreReplayEvents)return !1;this._ignoreReplayEvents=!1;const s=this.options,n=this._active||[],o=this._getActiveElements(t,n,e,i),a=this._positionChanged(o,t),r=e||!u(o,n)||a;return r&&(this._active=o,(s.enabled||s.external)&&(this._eventPosition={x:t.x,y:t.y},this.update(!0,e))),r}_getActiveElements(t,e,i,s){const n=this.options;if("mouseout"===t.type)return [];if(!s)return e;const o=this.chart.getElementsAtEventForMode(t,n.mode,n,i);return n.reverse&&o.reverse(),o}_positionChanged(t,e){const{caretX:i,caretY:s,options:n}=this,o=Bo[n.position].call(this,t,e);return !1!==o&&(i!==o.x||s!==o.y)}}Go.positioners=Bo;var Zo={id:"tooltip",_element:Go,positioners:Bo,afterInit(t,e,i){i&&(t.tooltip=new Go({chart:t,options:i}));},beforeUpdate(t,e,i){t.tooltip&&t.tooltip.initialize(i);},reset(t,e,i){t.tooltip&&t.tooltip.initialize(i);},afterDraw(t){const e=t.tooltip;if(e&&e._willRender()){const i={tooltip:e};if(!1===t.notifyPlugins("beforeTooltipDraw",i))return;e.draw(t.ctx),t.notifyPlugins("afterTooltipDraw",i);}},afterEvent(t,e){if(t.tooltip){const i=e.replay;t.tooltip.handleEvent(e.event,i,e.inChartArea)&&(e.changed=!0);}},defaults:{enabled:!0,external:null,position:"average",backgroundColor:"rgba(0,0,0,0.8)",titleColor:"#fff",titleFont:{weight:"bold"},titleSpacing:2,titleMarginBottom:6,titleAlign:"left",bodyColor:"#fff",bodySpacing:2,bodyFont:{},bodyAlign:"left",footerColor:"#fff",footerSpacing:2,footerMarginTop:6,footerFont:{weight:"bold"},footerAlign:"left",padding:6,caretPadding:2,caretSize:5,cornerRadius:6,boxHeight:(t,e)=>e.bodyFont.size,boxWidth:(t,e)=>e.bodyFont.size,multiKeyBackground:"#fff",displayColors:!0,boxPadding:0,borderColor:"rgba(0,0,0,0)",borderWidth:0,animation:{duration:400,easing:"easeOutQuart"},animations:{numbers:{type:"number",properties:["x","y","width","height","caretX","caretY"]},opacity:{easing:"linear",duration:200}},callbacks:{beforeTitle:t,title(t){if(t.length>0){const e=t[0],i=e.chart.data.labels,s=i?i.length:0;if(this&&this.options&&"dataset"===this.options.mode)return e.dataset.label||"";if(e.label)return e.label;if(s>0&&e.dataIndex<s)return i[e.dataIndex]}return ""},afterTitle:t,beforeBody:t,beforeLabel:t,label(t){if(this&&this.options&&"dataset"===this.options.mode)return t.label+": "+t.formattedValue||t.formattedValue;let e=t.dataset.label||"";e&&(e+=": ");const s=t.formattedValue;return i(s)||(e+=s),e},labelColor(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return {borderColor:e.borderColor,backgroundColor:e.backgroundColor,borderWidth:e.borderWidth,borderDash:e.borderDash,borderDashOffset:e.borderDashOffset,borderRadius:0}},labelTextColor(){return this.options.bodyColor},labelPointStyle(t){const e=t.chart.getDatasetMeta(t.datasetIndex).controller.getStyle(t.dataIndex);return {pointStyle:e.pointStyle,rotation:e.rotation}},afterLabel:t,afterBody:t,beforeFooter:t,footer:t,afterFooter:t}},defaultRoutes:{bodyFont:"font",footerFont:"font",titleFont:"font"},descriptors:{_scriptable:t=>"filter"!==t&&"itemSort"!==t&&"external"!==t,_indexable:!1,callbacks:{_scriptable:!1,_indexable:!1},animation:{_fallback:!1},animations:{_fallback:"animation"}},additionalOptionScopes:["interaction"]},Jo=Object.freeze({__proto__:null,Decimation:go,Filler:To,Legend:Ro,SubTitle:Vo,Title:zo,Tooltip:Zo});function Qo(t,e,i,s){const n=t.indexOf(e);if(-1===n)return ((t,e,i,s)=>("string"==typeof e?(i=t.push(e)-1,s.unshift({index:i,label:e})):isNaN(e)&&(i=null),i))(t,e,i,s);return n!==t.lastIndexOf(e)?i:n}class ta extends $s{constructor(t){super(t),this._startValue=void 0,this._valueRange=0,this._addedLabels=[];}init(t){const e=this._addedLabels;if(e.length){const t=this.getLabels();for(const{index:i,label:s}of e)t[i]===s&&t.splice(i,1);this._addedLabels=[];}super.init(t);}parse(t,e){if(i(t))return null;const s=this.getLabels();return ((t,e)=>null===t?null:Z(Math.round(t),0,e))(e=isFinite(e)&&s[e]===t?e:Qo(s,t,r(e,t),this._addedLabels),s.length-1)}determineDataLimits(){const{minDefined:t,maxDefined:e}=this.getUserBounds();let{min:i,max:s}=this.getMinMax(!0);"ticks"===this.options.bounds&&(t||(i=0),e||(s=this.getLabels().length-1)),this.min=i,this.max=s;}buildTicks(){const t=this.min,e=this.max,i=this.options.offset,s=[];let n=this.getLabels();n=0===t&&e===n.length-1?n:n.slice(t,e+1),this._valueRange=Math.max(n.length-(i?0:1),1),this._startValue=this.min-(i?.5:0);for(let i=t;i<=e;i++)s.push({value:i});return s}getLabelForValue(t){const e=this.getLabels();return t>=0&&t<e.length?e[t]:t}configure(){super.configure(),this.isHorizontal()||(this._reversePixels=!this._reversePixels);}getPixelForValue(t){return "number"!=typeof t&&(t=this.parse(t)),null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getPixelForTick(t){const e=this.ticks;return t<0||t>e.length-1?null:this.getPixelForValue(e[t].value)}getValueForPixel(t){return Math.round(this._startValue+this.getDecimalForPixel(t)*this._valueRange)}getBasePixel(){return this.bottom}}function ea(t,e,{horizontal:i,minRotation:s}){const n=H(s),o=(i?Math.sin(n):Math.cos(n))||.001,a=.75*e*(""+t).length;return Math.min(e/o,a)}ta.id="category",ta.defaults={ticks:{callback:ta.prototype.getLabelForValue}};class ia extends $s{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._endValue=void 0,this._valueRange=0;}parse(t,e){return i(t)||("number"==typeof t||t instanceof Number)&&!isFinite(+t)?null:+t}handleTickRangeOptions(){const{beginAtZero:t}=this.options,{minDefined:e,maxDefined:i}=this.getUserBounds();let{min:s,max:n}=this;const o=t=>s=e?s:t,a=t=>n=i?n:t;if(t){const t=z(s),e=z(n);t<0&&e<0?a(0):t>0&&e>0&&o(0);}if(s===n){let e=1;(n>=Number.MAX_SAFE_INTEGER||s<=Number.MIN_SAFE_INTEGER)&&(e=Math.abs(.05*n)),a(n+e),t||o(s-e);}this.min=s,this.max=n;}getTickLimit(){const t=this.options.ticks;let e,{maxTicksLimit:i,stepSize:s}=t;return s?(e=Math.ceil(this.max/s)-Math.floor(this.min/s)+1,e>1e3&&(console.warn(`scales.${this.id}.ticks.stepSize: ${s} would result generating up to ${e} ticks. Limiting to 1000.`),e=1e3)):(e=this.computeTickLimit(),i=i||11),i&&(e=Math.min(i,e)),e}computeTickLimit(){return Number.POSITIVE_INFINITY}buildTicks(){const t=this.options,e=t.ticks;let s=this.getTickLimit();s=Math.max(2,s);const n=function(t,e){const s=[],{bounds:n,step:o,min:a,max:r,precision:l,count:h,maxTicks:c,maxDigits:d,includeBounds:u}=t,f=o||1,g=c-1,{min:p,max:m}=e,b=!i(a),x=!i(r),_=!i(h),y=(m-p)/(d+1);let v,w,M,k,S=F((m-p)/g/f)*f;if(S<1e-14&&!b&&!x)return [{value:p},{value:m}];k=Math.ceil(m/S)-Math.floor(p/S),k>g&&(S=F(k*S/g/f)*f),i(l)||(v=Math.pow(10,l),S=Math.ceil(S*v)/v),"ticks"===n?(w=Math.floor(p/S)*S,M=Math.ceil(m/S)*S):(w=p,M=m),b&&x&&o&&W((r-a)/o,S/1e3)?(k=Math.round(Math.min((r-a)/S,c)),S=(r-a)/k,w=a,M=r):_?(w=b?a:w,M=x?r:M,k=h-1,S=(M-w)/k):(k=(M-w)/S,k=N(k,Math.round(k),S/1e3)?Math.round(k):Math.ceil(k));const P=Math.max(Y(S),Y(w));v=Math.pow(10,i(l)?P:l),w=Math.round(w*v)/v,M=Math.round(M*v)/v;let D=0;for(b&&(u&&w!==a?(s.push({value:a}),w<a&&D++,N(Math.round((w+D*S)*v)/v,a,ea(a,y,t))&&D++):w<a&&D++);D<k;++D)s.push({value:Math.round((w+D*S)*v)/v});return x&&u&&M!==r?s.length&&N(s[s.length-1].value,r,ea(r,y,t))?s[s.length-1].value=r:s.push({value:r}):x&&M!==r||s.push({value:M}),s}({maxTicks:s,bounds:t.bounds,min:t.min,max:t.max,precision:e.precision,step:e.stepSize,count:e.count,maxDigits:this._maxDigits(),horizontal:this.isHorizontal(),minRotation:e.minRotation||0,includeBounds:!1!==e.includeBounds},this._range||this);return "ticks"===t.bounds&&j(n,this,"value"),t.reverse?(n.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),n}configure(){const t=this.ticks;let e=this.min,i=this.max;if(super.configure(),this.options.offset&&t.length){const s=(i-e)/Math.max(t.length-1,1)/2;e-=s,i+=s;}this._startValue=e,this._endValue=i,this._valueRange=i-e;}getLabelForValue(t){return li(t,this.chart.options.locale,this.options.ticks.format)}}class sa extends ia{determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=o(t)?t:0,this.max=o(e)?e:1,this.handleTickRangeOptions();}computeTickLimit(){const t=this.isHorizontal(),e=t?this.width:this.height,i=H(this.options.ticks.minRotation),s=(t?Math.sin(i):Math.cos(i))||.001,n=this._resolveTickFontOptions(0);return Math.ceil(e/Math.min(40,n.lineHeight/s))}getPixelForValue(t){return null===t?NaN:this.getPixelForDecimal((t-this._startValue)/this._valueRange)}getValueForPixel(t){return this._startValue+this.getDecimalForPixel(t)*this._valueRange}}function na(t){return 1===t/Math.pow(10,Math.floor(I(t)))}sa.id="linear",sa.defaults={ticks:{callback:Is.formatters.numeric}};class oa extends $s{constructor(t){super(t),this.start=void 0,this.end=void 0,this._startValue=void 0,this._valueRange=0;}parse(t,e){const i=ia.prototype.parse.apply(this,[t,e]);if(0!==i)return o(i)&&i>0?i:null;this._zero=!0;}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!0);this.min=o(t)?Math.max(0,t):null,this.max=o(e)?Math.max(0,e):null,this.options.beginAtZero&&(this._zero=!0),this.handleTickRangeOptions();}handleTickRangeOptions(){const{minDefined:t,maxDefined:e}=this.getUserBounds();let i=this.min,s=this.max;const n=e=>i=t?i:e,o=t=>s=e?s:t,a=(t,e)=>Math.pow(10,Math.floor(I(t))+e);i===s&&(i<=0?(n(1),o(10)):(n(a(i,-1)),o(a(s,1)))),i<=0&&n(a(s,-1)),s<=0&&o(a(i,1)),this._zero&&this.min!==this._suggestedMin&&i===a(this.min,0)&&n(a(i,-1)),this.min=i,this.max=s;}buildTicks(){const t=this.options,e=function(t,e){const i=Math.floor(I(e.max)),s=Math.ceil(e.max/Math.pow(10,i)),n=[];let o=a(t.min,Math.pow(10,Math.floor(I(e.min)))),r=Math.floor(I(o)),l=Math.floor(o/Math.pow(10,r)),h=r<0?Math.pow(10,Math.abs(r)):1;do{n.push({value:o,major:na(o)}),++l,10===l&&(l=1,++r,h=r>=0?1:h),o=Math.round(l*Math.pow(10,r)*h)/h;}while(r<i||r===i&&l<s);const c=a(t.max,o);return n.push({value:c,major:na(o)}),n}({min:this._userMin,max:this._userMax},this);return "ticks"===t.bounds&&j(e,this,"value"),t.reverse?(e.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max),e}getLabelForValue(t){return void 0===t?"0":li(t,this.chart.options.locale,this.options.ticks.format)}configure(){const t=this.min;super.configure(),this._startValue=I(t),this._valueRange=I(this.max)-I(t);}getPixelForValue(t){return void 0!==t&&0!==t||(t=this.min),null===t||isNaN(t)?NaN:this.getPixelForDecimal(t===this.min?0:(I(t)-this._startValue)/this._valueRange)}getValueForPixel(t){const e=this.getDecimalForPixel(t);return Math.pow(10,this._startValue+e*this._valueRange)}}function aa(t){const e=t.ticks;if(e.display&&t.display){const t=pi(e.backdropPadding);return r(e.font&&e.font.size,ne.font.size)+t.height}return 0}function ra(t,e,i,s,n){return t===s||t===n?{start:e-i/2,end:e+i/2}:t<s||t>n?{start:e-i,end:e}:{start:e,end:e+i}}function la(t){const e={l:t.left+t._padding.left,r:t.right-t._padding.right,t:t.top+t._padding.top,b:t.bottom-t._padding.bottom},i=Object.assign({},e),n=[],o=[],a=t._pointLabels.length,r=t.options.pointLabels,l=r.centerPointLabels?D/a:0;for(let u=0;u<a;u++){const a=r.setContext(t.getPointLabelContext(u));o[u]=a.padding;const f=t.getPointPosition(u,t.drawingArea+o[u],l),g=mi(a.font),p=(h=t.ctx,c=g,d=s(d=t._pointLabels[u])?d:[d],{w:ye(h,c.string,d),h:d.length*c.lineHeight});n[u]=p;const m=K(t.getIndexAngle(u)+l),b=Math.round($(m));ha(i,e,m,ra(b,f.x,p.w,0,180),ra(b,f.y,p.h,90,270));}var h,c,d;t.setCenterPoint(e.l-i.l,i.r-e.r,e.t-i.t,i.b-e.b),t._pointLabelItems=function(t,e,i){const s=[],n=t._pointLabels.length,o=t.options,a=aa(o)/2,r=t.drawingArea,l=o.pointLabels.centerPointLabels?D/n:0;for(let o=0;o<n;o++){const n=t.getPointPosition(o,r+a+i[o],l),h=Math.round($(K(n.angle+L))),c=e[o],d=ua(n.y,c.h,h),u=ca(h),f=da(n.x,c.w,u);s.push({x:n.x,y:d,textAlign:u,left:f,top:d,right:f+c.w,bottom:d+c.h});}return s}(t,n,o);}function ha(t,e,i,s,n){const o=Math.abs(Math.sin(i)),a=Math.abs(Math.cos(i));let r=0,l=0;s.start<e.l?(r=(e.l-s.start)/o,t.l=Math.min(t.l,e.l-r)):s.end>e.r&&(r=(s.end-e.r)/o,t.r=Math.max(t.r,e.r+r)),n.start<e.t?(l=(e.t-n.start)/a,t.t=Math.min(t.t,e.t-l)):n.end>e.b&&(l=(n.end-e.b)/a,t.b=Math.max(t.b,e.b+l));}function ca(t){return 0===t||180===t?"center":t<180?"left":"right"}function da(t,e,i){return "right"===i?t-=e:"center"===i&&(t-=e/2),t}function ua(t,e,i){return 90===i||270===i?t-=e/2:(i>270||i<90)&&(t-=e),t}function fa(t,e,i,s){const{ctx:n}=t;if(i)n.arc(t.xCenter,t.yCenter,e,0,O);else {let i=t.getPointPosition(0,e);n.moveTo(i.x,i.y);for(let o=1;o<s;o++)i=t.getPointPosition(o,e),n.lineTo(i.x,i.y);}}oa.id="logarithmic",oa.defaults={ticks:{callback:Is.formatters.logarithmic,major:{enabled:!0}}};class ga extends ia{constructor(t){super(t),this.xCenter=void 0,this.yCenter=void 0,this.drawingArea=void 0,this._pointLabels=[],this._pointLabelItems=[];}setDimensions(){const t=this._padding=pi(aa(this.options)/2),e=this.width=this.maxWidth-t.width,i=this.height=this.maxHeight-t.height;this.xCenter=Math.floor(this.left+e/2+t.left),this.yCenter=Math.floor(this.top+i/2+t.top),this.drawingArea=Math.floor(Math.min(e,i)/2);}determineDataLimits(){const{min:t,max:e}=this.getMinMax(!1);this.min=o(t)&&!isNaN(t)?t:0,this.max=o(e)&&!isNaN(e)?e:0,this.handleTickRangeOptions();}computeTickLimit(){return Math.ceil(this.drawingArea/aa(this.options))}generateTickLabels(t){ia.prototype.generateTickLabels.call(this,t),this._pointLabels=this.getLabels().map(((t,e)=>{const i=c(this.options.pointLabels.callback,[t,e],this);return i||0===i?i:""})).filter(((t,e)=>this.chart.getDataVisibility(e)));}fit(){const t=this.options;t.display&&t.pointLabels.display?la(this):this.setCenterPoint(0,0,0,0);}setCenterPoint(t,e,i,s){this.xCenter+=Math.floor((t-e)/2),this.yCenter+=Math.floor((i-s)/2),this.drawingArea-=Math.min(this.drawingArea/2,Math.max(t,e,i,s));}getIndexAngle(t){return K(t*(O/(this._pointLabels.length||1))+H(this.options.startAngle||0))}getDistanceFromCenterForValue(t){if(i(t))return NaN;const e=this.drawingArea/(this.max-this.min);return this.options.reverse?(this.max-t)*e:(t-this.min)*e}getValueForDistanceFromCenter(t){if(i(t))return NaN;const e=t/(this.drawingArea/(this.max-this.min));return this.options.reverse?this.max-e:this.min+e}getPointLabelContext(t){const e=this._pointLabels||[];if(t>=0&&t<e.length){const i=e[t];return function(t,e,i){return _i(t,{label:i,index:e,type:"pointLabel"})}(this.getContext(),t,i)}}getPointPosition(t,e,i=0){const s=this.getIndexAngle(t)-L+i;return {x:Math.cos(s)*e+this.xCenter,y:Math.sin(s)*e+this.yCenter,angle:s}}getPointPositionForValue(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))}getBasePosition(t){return this.getPointPositionForValue(t||0,this.getBaseValue())}getPointLabelPosition(t){const{left:e,top:i,right:s,bottom:n}=this._pointLabelItems[t];return {left:e,top:i,right:s,bottom:n}}drawBackground(){const{backgroundColor:t,grid:{circular:e}}=this.options;if(t){const i=this.ctx;i.save(),i.beginPath(),fa(this,this.getDistanceFromCenterForValue(this._endValue),e,this._pointLabels.length),i.closePath(),i.fillStyle=t,i.fill(),i.restore();}}drawGrid(){const t=this.ctx,e=this.options,{angleLines:s,grid:n}=e,o=this._pointLabels.length;let a,r,l;if(e.pointLabels.display&&function(t,e){const{ctx:s,options:{pointLabels:n}}=t;for(let o=e-1;o>=0;o--){const e=n.setContext(t.getPointLabelContext(o)),a=mi(e.font),{x:r,y:l,textAlign:h,left:c,top:d,right:u,bottom:f}=t._pointLabelItems[o],{backdropColor:g}=e;if(!i(g)){const t=gi(e.borderRadius),i=pi(e.backdropPadding);s.fillStyle=g;const n=c-i.left,o=d-i.top,a=u-c+i.width,r=f-d+i.height;Object.values(t).some((t=>0!==t))?(s.beginPath(),Le(s,{x:n,y:o,w:a,h:r,radius:t}),s.fill()):s.fillRect(n,o,a,r);}Ae(s,t._pointLabels[o],r,l+a.lineHeight/2,a,{color:e.color,textAlign:h,textBaseline:"middle"});}}(this,o),n.display&&this.ticks.forEach(((t,e)=>{if(0!==e){r=this.getDistanceFromCenterForValue(t.value);!function(t,e,i,s){const n=t.ctx,o=e.circular,{color:a,lineWidth:r}=e;!o&&!s||!a||!r||i<0||(n.save(),n.strokeStyle=a,n.lineWidth=r,n.setLineDash(e.borderDash),n.lineDashOffset=e.borderDashOffset,n.beginPath(),fa(t,i,o,s),n.closePath(),n.stroke(),n.restore());}(this,n.setContext(this.getContext(e-1)),r,o);}})),s.display){for(t.save(),a=o-1;a>=0;a--){const i=s.setContext(this.getPointLabelContext(a)),{color:n,lineWidth:o}=i;o&&n&&(t.lineWidth=o,t.strokeStyle=n,t.setLineDash(i.borderDash),t.lineDashOffset=i.borderDashOffset,r=this.getDistanceFromCenterForValue(e.ticks.reverse?this.min:this.max),l=this.getPointPosition(a,r),t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(l.x,l.y),t.stroke());}t.restore();}}drawBorder(){}drawLabels(){const t=this.ctx,e=this.options,i=e.ticks;if(!i.display)return;const s=this.getIndexAngle(0);let n,o;t.save(),t.translate(this.xCenter,this.yCenter),t.rotate(s),t.textAlign="center",t.textBaseline="middle",this.ticks.forEach(((s,a)=>{if(0===a&&!e.reverse)return;const r=i.setContext(this.getContext(a)),l=mi(r.font);if(n=this.getDistanceFromCenterForValue(this.ticks[a].value),r.showLabelBackdrop){t.font=l.string,o=t.measureText(s.label).width,t.fillStyle=r.backdropColor;const e=pi(r.backdropPadding);t.fillRect(-o/2-e.left,-n-l.size/2-e.top,o+e.width,l.size+e.height);}Ae(t,s.label,0,-n,l,{color:r.color});})),t.restore();}drawTitle(){}}ga.id="radialLinear",ga.defaults={display:!0,animate:!0,position:"chartArea",angleLines:{display:!0,lineWidth:1,borderDash:[],borderDashOffset:0},grid:{circular:!1},startAngle:0,ticks:{showLabelBackdrop:!0,callback:Is.formatters.numeric},pointLabels:{backdropColor:void 0,backdropPadding:2,display:!0,font:{size:10},callback:t=>t,padding:5,centerPointLabels:!1}},ga.defaultRoutes={"angleLines.color":"borderColor","pointLabels.color":"color","ticks.color":"color"},ga.descriptors={angleLines:{_fallback:"grid"}};const pa={millisecond:{common:!0,size:1,steps:1e3},second:{common:!0,size:1e3,steps:60},minute:{common:!0,size:6e4,steps:60},hour:{common:!0,size:36e5,steps:24},day:{common:!0,size:864e5,steps:30},week:{common:!1,size:6048e5,steps:4},month:{common:!0,size:2628e6,steps:12},quarter:{common:!1,size:7884e6,steps:4},year:{common:!0,size:3154e7}},ma=Object.keys(pa);function ba(t,e){return t-e}function xa(t,e){if(i(e))return null;const s=t._adapter,{parser:n,round:a,isoWeekday:r}=t._parseOpts;let l=e;return "function"==typeof n&&(l=n(l)),o(l)||(l="string"==typeof n?s.parse(l,n):s.parse(l)),null===l?null:(a&&(l="week"!==a||!B(r)&&!0!==r?s.startOf(l,a):s.startOf(l,"isoWeek",r)),+l)}function _a(t,e,i,s){const n=ma.length;for(let o=ma.indexOf(t);o<n-1;++o){const t=pa[ma[o]],n=t.steps?t.steps:Number.MAX_SAFE_INTEGER;if(t.common&&Math.ceil((i-e)/(n*t.size))<=s)return ma[o]}return ma[n-1]}function ya(t,e,i){if(i){if(i.length){const{lo:s,hi:n}=tt(i,e);t[i[s]>=e?i[s]:i[n]]=!0;}}else t[e]=!0;}function va(t,e,i){const s=[],n={},o=e.length;let a,r;for(a=0;a<o;++a)r=e[a],n[r]=a,s.push({value:r,major:!1});return 0!==o&&i?function(t,e,i,s){const n=t._adapter,o=+n.startOf(e[0].value,s),a=e[e.length-1].value;let r,l;for(r=o;r<=a;r=+n.add(r,1,s))l=i[r],l>=0&&(e[l].major=!0);return e}(t,s,n,i):s}class wa extends $s{constructor(t){super(t),this._cache={data:[],labels:[],all:[]},this._unit="day",this._majorUnit=void 0,this._offsets={},this._normalized=!1,this._parseOpts=void 0;}init(t,e){const i=t.time||(t.time={}),s=this._adapter=new wn._date(t.adapters.date);s.init(e),b(i.displayFormats,s.formats()),this._parseOpts={parser:i.parser,round:i.round,isoWeekday:i.isoWeekday},super.init(t),this._normalized=e.normalized;}parse(t,e){return void 0===t?null:xa(this,t)}beforeLayout(){super.beforeLayout(),this._cache={data:[],labels:[],all:[]};}determineDataLimits(){const t=this.options,e=this._adapter,i=t.time.unit||"day";let{min:s,max:n,minDefined:a,maxDefined:r}=this.getUserBounds();function l(t){a||isNaN(t.min)||(s=Math.min(s,t.min)),r||isNaN(t.max)||(n=Math.max(n,t.max));}a&&r||(l(this._getLabelBounds()),"ticks"===t.bounds&&"labels"===t.ticks.source||l(this.getMinMax(!1))),s=o(s)&&!isNaN(s)?s:+e.startOf(Date.now(),i),n=o(n)&&!isNaN(n)?n:+e.endOf(Date.now(),i)+1,this.min=Math.min(s,n-1),this.max=Math.max(s+1,n);}_getLabelBounds(){const t=this.getLabelTimestamps();let e=Number.POSITIVE_INFINITY,i=Number.NEGATIVE_INFINITY;return t.length&&(e=t[0],i=t[t.length-1]),{min:e,max:i}}buildTicks(){const t=this.options,e=t.time,i=t.ticks,s="labels"===i.source?this.getLabelTimestamps():this._generate();"ticks"===t.bounds&&s.length&&(this.min=this._userMin||s[0],this.max=this._userMax||s[s.length-1]);const n=this.min,o=st(s,n,this.max);return this._unit=e.unit||(i.autoSkip?_a(e.minUnit,this.min,this.max,this._getLabelCapacity(n)):function(t,e,i,s,n){for(let o=ma.length-1;o>=ma.indexOf(i);o--){const i=ma[o];if(pa[i].common&&t._adapter.diff(n,s,i)>=e-1)return i}return ma[i?ma.indexOf(i):0]}(this,o.length,e.minUnit,this.min,this.max)),this._majorUnit=i.major.enabled&&"year"!==this._unit?function(t){for(let e=ma.indexOf(t)+1,i=ma.length;e<i;++e)if(pa[ma[e]].common)return ma[e]}(this._unit):void 0,this.initOffsets(s),t.reverse&&o.reverse(),va(this,o,this._majorUnit)}afterAutoSkip(){this.options.offsetAfterAutoskip&&this.initOffsets(this.ticks.map((t=>+t.value)));}initOffsets(t){let e,i,s=0,n=0;this.options.offset&&t.length&&(e=this.getDecimalForValue(t[0]),s=1===t.length?1-e:(this.getDecimalForValue(t[1])-e)/2,i=this.getDecimalForValue(t[t.length-1]),n=1===t.length?i:(i-this.getDecimalForValue(t[t.length-2]))/2);const o=t.length<3?.5:.25;s=Z(s,0,o),n=Z(n,0,o),this._offsets={start:s,end:n,factor:1/(s+1+n)};}_generate(){const t=this._adapter,e=this.min,i=this.max,s=this.options,n=s.time,o=n.unit||_a(n.minUnit,e,i,this._getLabelCapacity(e)),a=r(n.stepSize,1),l="week"===o&&n.isoWeekday,h=B(l)||!0===l,c={};let d,u,f=e;if(h&&(f=+t.startOf(f,"isoWeek",l)),f=+t.startOf(f,h?"day":o),t.diff(i,e,o)>1e5*a)throw new Error(e+" and "+i+" are too far apart with stepSize of "+a+" "+o);const g="data"===s.ticks.source&&this.getDataTimestamps();for(d=f,u=0;d<i;d=+t.add(d,a,o),u++)ya(c,d,g);return d!==i&&"ticks"!==s.bounds&&1!==u||ya(c,d,g),Object.keys(c).sort(((t,e)=>t-e)).map((t=>+t))}getLabelForValue(t){const e=this._adapter,i=this.options.time;return i.tooltipFormat?e.format(t,i.tooltipFormat):e.format(t,i.displayFormats.datetime)}_tickFormatFunction(t,e,i,s){const n=this.options,o=n.time.displayFormats,a=this._unit,r=this._majorUnit,l=a&&o[a],h=r&&o[r],d=i[e],u=r&&h&&d&&d.major,f=this._adapter.format(t,s||(u?h:l)),g=n.ticks.callback;return g?c(g,[f,e,i],this):f}generateTickLabels(t){let e,i,s;for(e=0,i=t.length;e<i;++e)s=t[e],s.label=this._tickFormatFunction(s.value,e,t);}getDecimalForValue(t){return null===t?NaN:(t-this.min)/(this.max-this.min)}getPixelForValue(t){const e=this._offsets,i=this.getDecimalForValue(t);return this.getPixelForDecimal((e.start+i)*e.factor)}getValueForPixel(t){const e=this._offsets,i=this.getDecimalForPixel(t)/e.factor-e.end;return this.min+i*(this.max-this.min)}_getLabelSize(t){const e=this.options.ticks,i=this.ctx.measureText(t).width,s=H(this.isHorizontal()?e.maxRotation:e.minRotation),n=Math.cos(s),o=Math.sin(s),a=this._resolveTickFontOptions(0).size;return {w:i*n+a*o,h:i*o+a*n}}_getLabelCapacity(t){const e=this.options.time,i=e.displayFormats,s=i[e.unit]||i.millisecond,n=this._tickFormatFunction(t,0,va(this,[t],this._majorUnit),s),o=this._getLabelSize(n),a=Math.floor(this.isHorizontal()?this.width/o.w:this.height/o.h)-1;return a>0?a:1}getDataTimestamps(){let t,e,i=this._cache.data||[];if(i.length)return i;const s=this.getMatchingVisibleMetas();if(this._normalized&&s.length)return this._cache.data=s[0].controller.getAllParsedValues(this);for(t=0,e=s.length;t<e;++t)i=i.concat(s[t].controller.getAllParsedValues(this));return this._cache.data=this.normalize(i)}getLabelTimestamps(){const t=this._cache.labels||[];let e,i;if(t.length)return t;const s=this.getLabels();for(e=0,i=s.length;e<i;++e)t.push(xa(this,s[e]));return this._cache.labels=this._normalized?t:this.normalize(t)}normalize(t){return rt(t.sort(ba))}}function Ma(t,e,i){let s,n,o,a,r=0,l=t.length-1;i?(e>=t[r].pos&&e<=t[l].pos&&({lo:r,hi:l}=et(t,"pos",e)),({pos:s,time:o}=t[r]),({pos:n,time:a}=t[l])):(e>=t[r].time&&e<=t[l].time&&({lo:r,hi:l}=et(t,"time",e)),({time:s,pos:o}=t[r]),({time:n,pos:a}=t[l]));const h=n-s;return h?o+(a-o)*(e-s)/h:o}wa.id="time",wa.defaults={bounds:"data",adapters:{},time:{parser:!1,unit:!1,round:!1,isoWeekday:!1,minUnit:"millisecond",displayFormats:{}},ticks:{source:"auto",major:{enabled:!1}}};class ka extends wa{constructor(t){super(t),this._table=[],this._minPos=void 0,this._tableRange=void 0;}initOffsets(){const t=this._getTimestampsForTable(),e=this._table=this.buildLookupTable(t);this._minPos=Ma(e,this.min),this._tableRange=Ma(e,this.max)-this._minPos,super.initOffsets(t);}buildLookupTable(t){const{min:e,max:i}=this,s=[],n=[];let o,a,r,l,h;for(o=0,a=t.length;o<a;++o)l=t[o],l>=e&&l<=i&&s.push(l);if(s.length<2)return [{time:e,pos:0},{time:i,pos:1}];for(o=0,a=s.length;o<a;++o)h=s[o+1],r=s[o-1],l=s[o],Math.round((h+r)/2)!==l&&n.push({time:l,pos:o/(a-1)});return n}_getTimestampsForTable(){let t=this._cache.all||[];if(t.length)return t;const e=this.getDataTimestamps(),i=this.getLabelTimestamps();return t=e.length&&i.length?this.normalize(e.concat(i)):e.length?e:i,t=this._cache.all=t,t}getDecimalForValue(t){return (Ma(this._table,t)-this._minPos)/this._tableRange}getValueForPixel(t){const e=this._offsets,i=this.getDecimalForPixel(t)/e.factor-e.end;return Ma(this._table,i*this._tableRange+this._minPos,!0)}}ka.id="timeseries",ka.defaults=wa.defaults;var Sa=Object.freeze({__proto__:null,CategoryScale:ta,LinearScale:sa,LogarithmicScale:oa,RadialLinearScale:ga,TimeScale:wa,TimeSeriesScale:ka});return bn.register(Bn,Sa,co,Jo),bn.helpers={...Ti},bn._adapters=wn,bn.Animation=xs,bn.Animations=ys,bn.animator=mt,bn.controllers=Us.controllers.items,bn.DatasetController=Ls,bn.Element=Es,bn.elements=co,bn.Interaction=Vi,bn.layouts=Zi,bn.platforms=ps,bn.Scale=$s,bn.Ticks=Is,Object.assign(bn,Bn,Sa,co,Jo,ps),bn.Chart=bn,"undefined"!=typeof window&&(window.Chart=bn),bn}));
} (chart_min$1, chart_minExports));

var chart_min = chart_minExports;

var _templateObject$1, _templateObject2$1, _templateObject3$1;
function ownKeys$2(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$2(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$2(Object(t), !0).forEach(function (r) { _defineProperty$2(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$2(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral$1(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$2(e, r, t) { return (r = _toPropertyKey$2(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$2(t) { var i = _toPrimitive$2(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$2(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 *
 *
 */
class SmallPartLiveFeedbackReport extends Et2Widget(s) {
  static get styles() {
    return [...super.styles, i(_templateObject$1 || (_templateObject$1 = _taggedTemplateLiteral$1(["\n\t\t\t\t:host {\n\t\t\t\t\tdisplay: contents;\n\t\t\t\t\t--width: 35%;\n\t\t\t\t\t--label-width: 12em;\n\t\t\t\t}\n\n\t\t\t\t/* Larger maximum height before scroll*/\n\n              .select__tags {\n                max-height: 10em;\n              }\n\n              :host([readonly]) .select__control,\n              :host([readonly]) .select__control:hover {\n                background: transparent;\n                border: none;\n              }\n\n\t\t\t\t.form-control {\n\t\t\t\t\theight: 100%;\n\t\t\t\t\twidth: 100%;\n\t\t\t\t\tdisplay: flex;\n\t\t\t\t\tflex-direction: column;\n\t\t\t\t\talign-items: center;\n\t\t\t\t\tflex-wrap: nowrap;\n\t\t\t\t}\n\n\t\t\t\tsl-range {\n\t\t\t\t\tmin-width: 10em;\n\t\t\t\t\tmax-width: 80%;\n\t\t\t\t}\n\n\t\t\t\tsl-range::part(form-control-label) {\n\t\t\t\t\twidth: initial;\n\t\t\t\t\twidth: var(--label-width, 8em);\n\t\t\t\t}\n\n\t\t\t\tsl-range::part(form-control-input) {\n\t\t\t\t\twidth: 20em\n\t\t\t\t}\n\n\t\t\t\t.et2_smallpart-livefeedback-report {\n\t\t\t\t\tflex: 1 1 auto;\n\t\t\t\t\theight: 0px;\n\t\t\t\t\twidth: 100%;\n\t\t\t\t\tdisplay: flex;\n\t\t\t\t\tflex-direction: column;\n\t\t\t\t\talign-items: center;\n\t\t\t\t\tgap: 1em;\n\t\t\t\t\tmargin-top: var(--sl-spacing-2x-large);\n\t\t\t\t\toverflow-y: auto;\n\t\t\t\t}\n\n\t\t\t\t.chart {\n\t\t\t\t\tposition: relative;\n\t\t\t\t\tmin-width: 12em;\n\t\t\t\t\twidth: var(--width);\n\t\t\t\t\tdisplay: flex;\n\t\t\t\t\tflex-direction: column;\n\t\t\t\t\talign-items: center;\n\t\t\t\t}\n\n\t\t\t\t.chart {\n\t\t\t\t\tborder-top: 2px solid var(--sl-color-gray-400);\n\t\t\t\t\tpadding-top: 1em;\n\t\t\t\t}\n\n\t\t\t\t.title {\n\t\t\t\t\tborder: 3px solid var(--cat_color, transparent);\n\t\t\t\t\tpadding: var(--sl-spacing-small);\n\t\t\t\t\tmin-width: 12em;\n\t\t\t\t\ttext-align: center;\n\t\t\t\t}\n\n\t\t\t\tcanvas {\n\t\t\t\t}\n\t\t\t"])))];
  }
  static get properties() {
    return _objectSpread$2(_objectSpread$2({}, super.properties), {}, {
      /**
       *
       */
      comments: {
        type: Array
      },
      /**
       * videobar this overlay is for
       */
      videobar: {
        type: String
      },
      /**
       * Make slider active for seeking in timeline
       */
      seekable: {
        type: Boolean
      },
      /**
       * A time slot to divide labels. Default is 60 seconds.
       */
      timeSlot: {
        type: Number
      },
      /**
       * Show all divided time labels in the x axis even the ones with no data. default is true.
       */
      showEmptyLabels: {
        type: Boolean
      },
      /**
       *
       */
      sessionStartTime: {
        type: Number
      },
      /**
       *
       */
      sessionEndTime: {
        type: Number
      }
    });
  }
  constructor() {
    super(...arguments);
    _defineProperty$2(this, "_configs", {});
    _defineProperty$2(this, "_videobar", null);
    _defineProperty$2(this, "_cats", []);
    _defineProperty$2(this, "_video", []);
    _defineProperty$2(this, "_interval", null);
    _defineProperty$2(this, "_comments", []);
    _defineProperty$2(this, "elements", []);
    _defineProperty$2(this, "charts", []);
    _defineProperty$2(this, "__timeSlot", 0);
    /**
     * contains created charts
     */
    _defineProperty$2(this, "_charts", []);
    /**
     * contians charts canvas elements
     */
    _defineProperty$2(this, "_canvases", []);
    this._configs = {
      type: 'bar',
      options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
          x: {
            stacked: true
          },
          y: {
            stacked: true,
            ticks: {
              // forces step size to be 1 units
              stepSize: 10
            }
          }
        },
        interaction: {
          mode: 'dataset'
        }
      }
    };
    this.timeSlot = 60;
    this.showEmptyLabels = true;
    this.handleZoom = this.handleZoom.bind(this);
    this.handleIntervalChange = this.handleIntervalChange.bind(this);
  }
  connectedCallback() {
    super.connectedCallback();
    this._cats = this.getInstanceManager().widgetContainer.getArrayMgr('sel_options').getEntry('catsOptions');
    this._video = this.getInstanceManager().widgetContainer.getArrayMgr('content').getEntry('video');
    this._checkVideoIsLoaded().then(_ => {
      for (var i = this._charts.length - 1; i >= 0; i--) {
        this._charts[i].destroy();
      }
      this.requestUpdate();
    });
  }

  /**
   * Handle changes that have to happen based on changes to properties
   *
   */
  updated(changedProperties) {
    super.updated(changedProperties);
    if (changedProperties.has("elements") || changedProperties.has("timeSlot")) {
      var self = this;
      var chartConfigs = [];
      this.elements.forEach((_element, _idx) => {
        if (_element && _element.comments) {
          var _this$_findNegativeSu;
          var configs = _objectSpread$2(_objectSpread$2({}, this._configs), {
            data: {
              labels: [],
              datasets: this.getDatasets(_element.id)
            },
            options: _objectSpread$2(_objectSpread$2(_objectSpread$2({}, this._configs.options), {
              plugins: {
                animation: false,
                title: {
                  display: false,
                  text: _element.title
                }
              }
            }), {}, {
              onClick: (e, value) => {
                if (!this.seekable || !value.length) return;
                var canvasPosition = Chart.helpers.getRelativePosition(e, self.charts[_idx]);
                var labelIndex = self.charts[_idx].scales.x.getValueForPixel(canvasPosition.x);
                // convert minute label to second in order to seek right time in video
                self.videobar.seek_video(configs.data.labels[labelIndex] * 60);
              }
            })
          });
          var data = {};
          _element.comments.forEach((_c, _i) => {
            var cat_id = _c['comment_cat'].split(":").pop();
            if (typeof data[cat_id] === 'undefined') data[cat_id] = [];
            data[cat_id].push(_c.comment_starttime - _c.comment_starttime % this.timeSlot);
          });
          var negativeCatId = (_this$_findNegativeSu = this._findNegativeSubCat(_element.id)) === null || _this$_findNegativeSu === void 0 ? void 0 : _this$_findNegativeSu.value;
          Object.keys(data).forEach(_cat_id => {
            var _configs$data$dataset;
            var cat = this._fetchCatInfo(_cat_id);
            var d = [];
            data[_cat_id].forEach(_d => {
              var timeVal = _d / this.timeSlot;
              var index = this._findIndexofDataItem(d, timeVal);
              if (index >= 0) {
                d[index]['y'] = d[index]['y'] + (_cat_id == negativeCatId ? -1 : 1);
              } else {
                d.push({
                  x: timeVal,
                  y: _cat_id == negativeCatId ? -1 : 1
                });
                configs.data.labels.push(timeVal); // label the time in minute
              }
            });
            ((_configs$data$dataset = configs.data.datasets.find(c => c.value == cat.value)) !== null && _configs$data$dataset !== void 0 ? _configs$data$dataset : {}).data = d === null || d === void 0 ? void 0 : d.sort((a, b) => a.x > b.x ? 1 : -1);
          });
          if (this.showEmptyLabels) {
            configs.data.labels = Array.from({
              length: self._getSessionDuration() / self.timeSlot + 1
            }, (_, i) => i * self.timeSlot / 60);
          } else {
            // labels need to be unique otherwise the charts get messed up
            configs.data.labels = configs.data.labels.filter((v, i, a) => a.indexOf(v) === i).sort((a, b) => a > b ? 1 : -1);
          }
          if (this.charts[_idx]) this.charts[_idx].destroy();
          chartConfigs[_idx] = configs;
        }
      });

      // Common y-axis scale to max value
      var max = 0;
      chartConfigs.forEach(configs => {
        configs.data.datasets.forEach(dataset => {
          dataset.data.forEach(datapoint => {
            if (Math.abs(datapoint.y) > max) {
              max = Math.abs(datapoint.y);
            }
          });
        });
      });
      // To next 5
      max = Math.ceil(max / 5) * 5;
      chartConfigs.forEach((configs, _idx) => {
        configs.options.scales.y.max = max;
        configs.options.scales.y.min = -max;
        this.charts[_idx] = new Chart(this._getCanvasNode(_idx), configs);
        this.charts[_idx].resize();
      });
    }
  }
  getDatasets(parent_cat_id) {
    var cat = this._fetchCatInfo(parent_cat_id);
    var dataset = [this._findPositiveSubCat(parent_cat_id), this._findNegativeSubCat(parent_cat_id)].filter(id => id).map(cat => {
      return cat ? {
        value: cat.value,
        label: cat === null || cat === void 0 ? void 0 : cat.label,
        data: [],
        backgroundColor: cat === null || cat === void 0 ? void 0 : cat.color,
        parsing: {
          yAxisKey: 'y',
          xAxisKey: 'x'
        }
      } : null;
    });
    return dataset;
  }
  handleIntervalChange(event) {
    this.timeSlot = parseInt(event.target.value || 60);
  }
  handleZoom(event) {
    var _event$target$value, _event$target;
    var width = (_event$target$value = (_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.value) !== null && _event$target$value !== void 0 ? _event$target$value : 35;
    this.style.setProperty("--width", width + "%");

    // Tell charts to resize
    this.charts.forEach(c => c.resize());
  }
  render() {
    return x(_templateObject2$1 || (_templateObject2$1 = _taggedTemplateLiteral$1(["\n            <div part=\"base\" class=\"form-control\">\n                <sl-range min=\"35\" max=\"95\" step=\"15\"\n                          label=", "\n                          tooltip=\"none\"\n                          @sl-change=", "\n                ></sl-range>\n                <sl-range min=\"30\" max=\"900\" step=\"30\"\n                          label=", "\n                          tooltip=\"bottom\"\n                          .tooltipFormatter=", "\n                          .value=", "\n                          @sl-change=", "\n                ></sl-range>\n                <slot></slot>\n                <div part=\"report-list\" class=\"et2_smallpart-livefeedback-report\">\n\t\t\t\t", "\n\t\t\t</div>\n            </div>\n\t\t"])), this.egw().lang("zoom"), this.handleZoom, this.egw().lang("sum interval"), seconds => {
      // Round to nearest 0.5
      var minutes = Math.round(parseInt(seconds) / 60 * 2) / 2;
      return this.egw().lang("%1 min", minutes);
    }, this.timeSlot, this.handleIntervalChange, c$1(this.elements, (item, _idx) => {
      return x(_templateObject3$1 || (_templateObject3$1 = _taggedTemplateLiteral$1(["\n                        <div class=\"chart chart_", "\">\n                            <style>.chart_", " {\n                                --cat_color: ", "\n                            }</style>\n                            <span class=\"title\">", "</span>\n                            <canvas id=", "/>\n                        </div>\n                    "])), _idx, _idx, item.color, item.title, this.id + '-canvas-' + _idx);
    }));
  }
  _getCanvasNode(_idx) {
    return this.shadowRoot ? this.shadowRoot.querySelector('#' + this.id + '-canvas-' + _idx) : null;
  }
  set comments(_comments) {
    var values = _comments.map(obj => _objectSpread$2({}, obj));
    var comments = {};
    var elements = [];
    var max = 0;
    values.forEach(_c => {
      var _c$comment_cat;
      var split = _c === null || _c === void 0 || (_c$comment_cat = _c.comment_cat) === null || _c$comment_cat === void 0 ? void 0 : _c$comment_cat.split(":");
      if (_c && _c.comment_cat && split[2] == 'lf') {
        _c.comment_cat = _c.comment_cat.replace(':lf', '');
        if (!comments[split[0]]) comments[split[0]] = [];
        comments[split[0]].push(_c);
      }
    });
    this._cats.filter(c => c.parent_id == null).forEach(cat => {
      var _comments$cat$value;
      elements.push({
        title: cat === null || cat === void 0 ? void 0 : cat.label,
        comments: (_comments$cat$value = comments[cat.value]) !== null && _comments$cat$value !== void 0 ? _comments$cat$value : [],
        color: cat === null || cat === void 0 ? void 0 : cat.color,
        id: cat.value
      });
    });
    this.elements = elements;
    this.requestUpdate('elements');
  }
  set timeSlot(_time) {
    this.__timeSlot = _time;
    this.requestUpdate('timeSlot');
  }
  get timeSlot() {
    if (!this.__timeSlot) {
      return this._video && this._video['livefeedback'] && this._video['livefeedback']['session_interval'] ? parseInt(this._video['livefeedback']['session_interval']) * 60 : 60;
    }
    return this.__timeSlot;
  }
  set videobar(_widget) {
    if (typeof _widget === 'string') {
      _widget = this.getRoot().getWidgetById(_widget);
    }
    if (_widget instanceof et2_smallpart_videobar) {
      this._videobar = _widget;
    }
  }
  get videobar() {
    return this._videobar;
  }

  /**
   * Calculate session duration
   */
  _getSessionDuration() {
    var d = (Date.parse(this._video.livefeedback.session_endtime) - Date.parse(this._video.livefeedback.session_starttime)) / 1000;
    if (this.sessionEndTime) d = this.sessionEndTime;
    return d > 10 ? d : this.videobar.duration();
  }

  /**
   * Find the index number for the given value in data array
   * @param _data array of data
   * @param _value value to look for
   * @return returns index number
   * @private
   */
  _findIndexofDataItem(_data, _value) {
    var index = 0;
    return _data.findIndex(_d => {
      return _d.x == _value;
    });
  }
  _findNegativeSubCat(_parent_id) {
    var cat = this._cats.filter(_cat => {
      var _cat$data, _cat$data2;
      return _cat.parent_id == _parent_id && (_cat === null || _cat === void 0 || (_cat$data = _cat.data) === null || _cat$data === void 0 ? void 0 : _cat$data.type) == 'lf' && (_cat === null || _cat === void 0 || (_cat$data2 = _cat.data) === null || _cat$data2 === void 0 ? void 0 : _cat$data2.value) == 'n';
    });
    return cat ? cat[0] : [];
  }
  _findPositiveSubCat(_parent_id) {
    var cat = this._cats.filter(_cat => {
      var _cat$data3, _cat$data4;
      return _cat.parent_id == _parent_id && (_cat === null || _cat === void 0 || (_cat$data3 = _cat.data) === null || _cat$data3 === void 0 ? void 0 : _cat$data3.type) == 'lf' && (_cat === null || _cat === void 0 || (_cat$data4 = _cat.data) === null || _cat$data4 === void 0 ? void 0 : _cat$data4.value) == 'p';
    });
    return cat ? cat[0] : [];
  }

  /**
   * Fetch category info for the given cat_id
   * @param _cat_id
   * @return returns array of cat data
   * @private
   */
  _fetchCatInfo(_cat_id) {
    return this._cats.filter(_cat => {
      return _cat.value == _cat_id;
    })[0];
  }

  /**
   * Promise to check the video is loaded
   * @private
   */
  _checkVideoIsLoaded() {
    clearInterval(this._interval);
    return new Promise((_resolved, _rejected) => {
      var _this$videobar;
      if (((_this$videobar = this.videobar) === null || _this$videobar === void 0 ? void 0 : _this$videobar.duration()) > 0) {
        clearInterval(this._interval);
        return _resolved();
      }
      this._interval = setInterval(_ => {
        var _this$videobar2;
        if (((_this$videobar2 = this.videobar) === null || _this$videobar2 === void 0 ? void 0 : _this$videobar2.duration()) > 0) {
          clearInterval(this._interval);
          _resolved();
          return;
        }
      }, 1000);
    });
  }
}
customElements.define("smallpart-livefeedback-report", SmallPartLiveFeedbackReport);

var _templateObject, _templateObject2, _templateObject3, _templateObject4;
function ownKeys$1(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys$1(Object(t), !0).forEach(function (r) { _defineProperty$1(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys$1(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
function _defineProperty$1(e, r, t) { return (r = _toPropertyKey$1(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey$1(t) { var i = _toPrimitive$1(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive$1(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 *
 */
class SmallPartTimer extends Et2Widget(s) {
  static get styles() {
    return [super.styles, shoelace, i(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n            :host {\n              width: 100%;\n              align-items: center;\n\t\t\t\tdisplay: flex;\n              justify-content: center;\n            }\n\t\t\t:host::part(buttons) {\n              width: 60px;\n              height: 60px;\n              font-size: 40px;\n              border-radius: 50%;\n\t\t\t}\n\t\t\t.btn_resume {\n              background: #71b78d;\n              color: white;\n\t\t\t}\n\t\t\t.btn_pause {\n              background: #e56565;\n              color: white;\n\t\t\t}\n\t\t\t:host::part(labels) {\n\t\t\t  font-size: 4em;\n              max-width: min-content;\n              max-height: fit-content;\n\t\t\t}\n\t\t\t\n\t\t"])))];
  }
  static get properties() {
    return _objectSpread$1(_objectSpread$1({}, super.properties), {}, {
      /**
       * Set a unique id for timer session item incase we have many timers of in a same app
       */
      uniqueId: {
        type: String
      },
      /**
       * Defines display format; s (Initial letter) or l (Complete word) display, default is s.
       */
      format: {
        type: String
      },
      /**
       * Only displays none empty values.
       */
      hideEmpties: {
        type: Boolean
      },
      /**
       * Defines an alarm set when timer is reached to the alarm time, it should be in seconds
       */
      alarm: {
        type: Number
      },
      /**
       * Defines a callback to gets called at alarm - timer. This only will work if there's an alarm set.
       */
      onAlarm: {
        type: Function
      },
      /**
       * Callback function to call when the timer is resumed.
       */
      onResume: {
        type: Function
      },
      /**
       * Callback function to call when the timer is paused.
       */
      onPause: {
        type: Function
      },
      /**
       * Callback function to call when the timer is reset.
       */
      onReset: {
        type: Function
      },
      /**
       * callback function to be called for each pulse (the interval depends on onPulseInterval)
       */
      onPulse: {
        type: Function
      },
      /**
       * set interval for calling onPulse callback. default is 1 sec
       */
      onPulseInterval: {
        type: Number
      },
      /**
       * Starts the time immediately.
       */
      autoStart: {
        type: Boolean
      },
      /**
       * Hide reset button.
       */
      hideReset: {
        type: Boolean
      }
    });
  }
  constructor() {
    super(...arguments);
    _defineProperty$1(this, "timerInterval", null);
    _defineProperty$1(this, "_timer", null);
    _defineProperty$1(this, "_state", {
      id: undefined,
      paused: undefined,
      timer: undefined
    });
    _defineProperty$1(this, "_appname", 'smallpart');
    _defineProperty$1(this, "_stateUniqueId", '');
    this.format = 's';
    this.hideEmpties = true;
    this.autoStart = false;
    this.hideReset = false;
    this.uniqueId = "";
    this.onPulseInterval = 1;
  }
  connectedCallback() {
    super.connectedCallback();
  }

  /**
   * Clean up interval
   */
  destroy() {
    clearInterval(this.timerInterval);
  }
  firstUpdated(_changedProperties) {
    super.firstUpdated(_changedProperties);
    if (this.disabled) return;
    this._stateUniqueId = this.id + (this.uniqueId ? '-' + this.uniqueId : '');
    this._appname = this.getInstanceManager().app;
    var state = JSON.parse(this.egw().getSessionItem(this._appname, this._stateUniqueId));
    if (state) {
      this.value = state.timer;
      this.__displayTimer(state.timer);
    }
    this.state = state !== null && state !== void 0 ? state : {
      id: this._stateUniqueId,
      paused: !this.autoStart
    };
    // need to update the rendering state after the state is set
    this.requestUpdate();
    this.timerInterval = setInterval(_ => {
      this._updateTimer();
    }, 1000);
  }
  render() {
    var _this$state, _this$state2, _this$state3, _this$state4;
    if (this.disabled) return x(_templateObject2 || (_templateObject2 = _taggedTemplateLiteral([""])));
    return x(_templateObject3 || (_templateObject3 = _taggedTemplateLiteral(["\n\t\t\t<div ", " class=\"et2_timer\">\n\t\t\t\t<et2-hbox part=\"labels\">\n\t\t\t\t\t<et2-description class=\"days\" ?disabled=", ">\n\t\t\t\t\t\t", "\n\t\t\t\t\t</et2-description>\n\t\t\t\t\t<et2-description class=\"hours\" ?disabled=", ">\n\t\t\t\t\t\t", "\n\t\t\t\t\t</et2-description>\n\t\t\t\t\t<et2-description class=\"minutes\" ?disabled=", ">\n\t\t\t\t\t\t", "\n\t\t\t\t\t</et2-description>\n\t\t\t\t\t<et2-description class=\"seconds\" ?disabled=", ">\n\t\t\t\t\t\t", "\n\t\t\t\t\t</et2-description>\n\t\t\t\t</et2-hbox>\n\t\t\t\t<et2-label value=", "></et2-label>\n\t\t\t\t<et2-hbox part=\"buttons\">\n\t\t\t\t\t<et2-button-icon image=\"play-circle\" class=\"btn_resume\" ?disabled=", "\n\t\t\t\t\t\t\t\t @click=", " statustext=", "\n\t\t\t\t\t\t\t\t\t style=", "></et2-button-icon>\n\t\t\t\t\t<et2-button-icon image=", " class=\"btn_pause\" ?disabled=", "\n                                     style=", "\n\t\t\t\t\t\t\t\t\t @click=", " statustext=", "></et2-button-icon>\n\t\t\t\t\t<et2-button-icon image=\"x-circle\" class=\"btn_reset\" style=", " \n\t\t\t\t\t\t\t\t\t @click=", " statustext=", "></et2-button-icon>\n\t\t\t\t</et2-hbox>\n            </div>\n\t\t"])), this.id ? x(_templateObject4 || (_templateObject4 = _taggedTemplateLiteral(["id=\"", "\""])), this.id) : '', this.hideEmpties ? this.days == 0 || !this.days : false, this.days + this._getIndicator("days"), this.hideEmpties ? this.hours == 0 || !this.hours : false, this.hours + this._getIndicator("hours"), this.hideEmpties ? this.minutes == 0 || !this.minutes : false, this.minutes + this._getIndicator("minutes"), this.seconds == 0 || !this.seconds, this.seconds + this._getIndicator("seconds"), this.label, !((_this$state = this.state) !== null && _this$state !== void 0 && _this$state.paused), this._resumeClick, this.egw().lang('Start'), this.hideReset && !((_this$state2 = this.state) !== null && _this$state2 !== void 0 && _this$state2.paused) ? "display:none" : "", this.hideReset ? "stop-circle" : "pause-circle", (_this$state3 = this.state) === null || _this$state3 === void 0 ? void 0 : _this$state3.paused, this.hideReset && (_this$state4 = this.state) !== null && _this$state4 !== void 0 && _this$state4.paused ? "display:none" : "", this._pauseClick, this.egw().lang('Stop'), this.hideReset ? "display:none" : "", this._resetClick, this.egw().lang('Reset'));
  }
  get value() {
    return this.timer;
  }
  set value(_time) {
    if (isNaN(_time)) return;
    this.timer = _time;
    this._state.timer = _time;
    this.state = this._state;
  }
  get timer() {
    return this._timer || 0;
  }
  set timer(_time) {
    this._timer = _time;
    this.__displayTimer(_time);
  }
  _updateTimer() {
    var _this$state5;
    if ((_this$state5 = this.state) !== null && _this$state5 !== void 0 && _this$state5.paused) return;
    this.timer++;
    if (typeof this.onPulse == 'function' && this.timer % this.onPulseInterval == 0) {
      this.onPulse.call(this, this);
    }
    this._state.timer = this.timer;
    this.state = this._state;
  }

  /**
   *
   * @param timer
   * @private
   */
  __displayTimer(timer) {
    if (timer < 0) return 0;
    if (this.alarm > 0 && this.alarm == timer && typeof this.onAlarm == 'function') {
      this.onAlarm();
    }
    this.days = Math.floor(timer / (60 * 60 * 24));
    this.hours = Math.floor(timer % (60 * 60 * 24) / (60 * 60));
    this.minutes = Math.floor(timer % (60 * 60) / 60);
    this.seconds = Math.floor(timer % 60);
    this.requestUpdate();
  }

  /**
   *
   * @param _v
   * @private
   */
  _getIndicator(_v) {
    return this.format == 's' ? this.egw().lang(_v).substr(0, 1) : this.egw().lang(_v);
  }

  /**
   * get state
   *
   * @param key providing key would return the state value of the given key
   * @private
   * @return return whole state object or particular state key value
   */
  get state() {
    return this._state;
  }

  /**
   * set state
   *
   * @param state set the whole state object or null if desire to set/modify only a key value
   */
  set state(_state) {
    this._state = _state;
    this.egw().setSessionItem(this._appname, this._state.id, JSON.stringify(this._state));
  }

  /**
   *
   * @private
   */
  _resetClick() {
    var _this$state6;
    this.state.id = this._stateUniqueId;
    this.egw().removeSessionItem(this._appname, (_this$state6 = this.state) === null || _this$state6 === void 0 ? void 0 : _this$state6.id);
    this.value = 0;
    if (typeof this.onReset === 'function') this.onReset();
  }

  /**
   *
   * @private
   */
  _resumeClick() {
    var _this$state7, _this$state8;
    // don't go further if the timer is not paused
    if (!((_this$state7 = this.state) !== null && _this$state7 !== void 0 && _this$state7.paused)) return;
    var sessionState = JSON.parse(this.egw().getSessionItem(this._appname, this.state.id));
    this.value = (_this$state8 = this.state) === null || _this$state8 === void 0 ? void 0 : _this$state8.timer;

    // unpause the timer state
    this._state.paused = false;
    this.state = this._state;
    if (typeof this.onResume === 'function') this.onResume(this, this.state);
    this.requestUpdate();
  }

  /**
   *
   * @private
   */
  _pauseClick() {
    var _this$state9;
    // don't go further if the timer is already paused
    if ((_this$state9 = this.state) !== null && _this$state9 !== void 0 && _this$state9.paused) return;
    this._state.paused = true;
    this.state = this._state;
    this.egw().setSessionItem(this._appname, this.state.id, JSON.stringify(this.state));
    if (typeof this.onPause === 'function') this.onPause(this, this.state);
    this.requestUpdate();
  }
}
customElements.define("smallpart-timer", SmallPartTimer);

function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

/**
 * Comment type and it's attributes
 */

/**
 * Recording of watched videos
 */

/**
 * PHP DateTime JSON serialized
 */

/**
 * Pushed course
 */

class smallpartApp extends EgwApp {
  /**
   * Constructor
   *
   * @memberOf app.status
   */
  constructor() {
    // call parent
    super('smallpart');
    _defineProperty(this, "VideoEdit", void 0);
    /**
     * Undisplayed properties of edited comment: comment_id, etc
     */
    _defineProperty(this, "edited", void 0);
    /**
     * Currently displayed comments
     */
    _defineProperty(this, "comments", void 0);
    _defineProperty(this, "filter", void 0);
    /**
     * Active filter classes
     */
    _defineProperty(this, "filters", {});
    /**
     * Set if student is watching a video
     */
    _defineProperty(this, "watching", void 0);
    /**
     * Course options: &1 = record watched videos
     */
    _defineProperty(this, "course_options", 0);
    /**
     * Current user belongs to the course staff
     */
    _defineProperty(this, "is_staff", void 0);
    /**
     * Current user is allowed to comment
     */
    _defineProperty(this, "isCommentAllowed", false);
    /**
     * account_id of current user
     */
    _defineProperty(this, "user", void 0);
    /**
     * keep livefeedback running Interval ID
     * @protected
     */
    _defineProperty(this, "livefeedbackInterval", 0);
    _defineProperty(this, "checkMinAnswer_error", void 0);
    this.VideoEdit = new VideoEdit(this);
    this.user = parseInt(this.egw.user('account_id'));
  }

  /**
   * Destructor
   */
  destroy(_app) {
    // Update video time, if possible, before et2 is gone
    if (this.et2 && this.et2.getInstanceManager().name == 'smallpart.student.index') {
      this.set_video_position();
    }
    // call parent
    super.destroy(_app);
  }

  /**
   * This function is called when the etemplate2 object is loaded
   * and ready.  If you must store a reference to the et2 object,
   * make sure to clean it up in destroy().
   *
   * @param {etemplate2} _et2 newly ready object
   * @param {string} _name template name
   */
  et2_ready(_et2, _name) {
    var _content$getEntry, _content$getEntry2, _content$getEntry3, _this$et2$getWidgetBy, _content$getEntry7;
    // call parent
    super.et2_ready(_et2, _name);
    var content = this.et2.getArrayMgr('content');
    switch (true) {
      case _name === 'smallpart.start':
        this.is_staff = content.getEntry('is_staff');
        this.filter = {
          course_id: content.getEntry('course_id')
        };
        break;
      case _name.match(/smallpart.student.index/) !== null:
        this.is_staff = content.getEntry('is_staff');
        this.comments = content.getEntry('comments');
        this._student_setCommentArea(false);

        // don't go further if the test locked screen is on or no video's selected yet, otherwise we would get
        // js errors on widget selections as they're not there yet.
        if (content.getEntry('locked') || !content.getEntry('videos') || !content.getEntry('video')) break;
        var inTestMode = parseInt((_content$getEntry = content.getEntry('video')) === null || _content$getEntry === void 0 ? void 0 : _content$getEntry.video_test_duration) > 0 && content.getEntry('timer') > 0;
        var forbidTocomment = !this.is_staff && ((_content$getEntry2 = content.getEntry('video')) === null || _content$getEntry2 === void 0 ? void 0 : _content$getEntry2.video_options) == smallpartApp.COMMENTS_FORBIDDEN_BY_STUDENTS || ((_content$getEntry3 = content.getEntry('video')) === null || _content$getEntry3 === void 0 ? void 0 : _content$getEntry3.video_options) == smallpartApp.COMMENTS_DISABLED;

        // Is the current user allowed to comment on this video
        this.isCommentAllowed = !forbidTocomment;
        if ((content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) == et2_smallpart_videobar.course_options_cognitive_load_measurement && inTestMode) {
          if (content.getEntry('clm')['dual']['active']) {
            if (forbidTocomment) {
              this.student_addNote();
            }
            this._student_clm_l_start();
          } else if (content.getEntry('clm')['process']['active']) {
            this._student_setProcessCLQuestions();
          }
        } else {
          var clml = this.et2.getDOMWidgetById('clm-l');
          //disable "L" if we are not in CLM mode/test mode
          if (clml) clml.set_disabled(true);
        }
        // set process CL Questionnaire when the test is running
        if (inTestMode) {
          this._student_noneTestAreaMasking(true);
        }
        // HIDE add comment buttons if user is not allowed to comment
        ['add_comment'].forEach(_w => {
          this.et2.getWidgetById(smallpartApp.playControlBar).getWidgetById(_w).hidden = !this.isCommentAllowed;
        });
        this.et2.getWidgetById('smallpart.student.comments_list').getWidgetById('add_comment').hidden = !this.isCommentAllowed;
        this.filter = {
          course_id: parseInt(content.getEntry('courses')) || null,
          video_id: parseInt(content.getEntry('videos')) || null
        };
        if (this.egw.preference('comments_column_state', 'smallpart') == 0 || !this.egw.preference('comments_column_state', 'smallpart')) {
          var _this$et2$getDOMWidge, _this$et2$getDOMWidge2;
          this.egw.set_preference('smallpart', 'comments_column_state', 0);
          (_this$et2$getDOMWidge = this.et2.getDOMWidgetById('comments_column')) === null || _this$et2$getDOMWidge === void 0 || _this$et2$getDOMWidge.set_value(false);
          (_this$et2$getDOMWidge2 = this.et2.getDOMWidgetById('comments')) === null || _this$et2$getDOMWidge2 === void 0 || _this$et2$getDOMWidge2.set_class('hide_column');
        } else {
          var _this$et2$getDOMWidge3, _this$et2$getDOMWidge4;
          (_this$et2$getDOMWidge3 = this.et2.getDOMWidgetById('comments_column')) === null || _this$et2$getDOMWidge3 === void 0 || _this$et2$getDOMWidge3.set_value(true);
          (_this$et2$getDOMWidge4 = this.et2.getDOMWidgetById('comments')) === null || _this$et2$getDOMWidge4 === void 0 || _this$et2$getDOMWidge4.getDOMNode().classList.remove('hide_column');
        }
        this.course_options = parseInt(content.getEntry('course_options')) || 0;
        this._student_setFilterParticipantsOptions();
        var _self = this;
        jQuery(window).on('resize', function () {
          _self._student_resize();
        });
        // record, in case of F5 or window closed
        window.addEventListener("beforeunload", function () {
          var _content$getEntry4;
          _self.set_video_position();
          _self.record_watched();
          // record unload time, if a CL measurement test is running, in case user did not stop it properly
          if (parseInt((_content$getEntry4 = content.getEntry('video')) === null || _content$getEntry4 === void 0 ? void 0 : _content$getEntry4.video_test_duration) > 0 && content.getEntry('timer') > 0 && (content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) == et2_smallpart_videobar.course_options_cognitive_load_measurement) {
            var _content$getEntry5, _content$getEntry6;
            _self.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_recordCLMeasurement', [(_content$getEntry5 = content.getEntry('video')) === null || _content$getEntry5 === void 0 ? void 0 : _content$getEntry5.course_id, (_content$getEntry6 = content.getEntry('video')) === null || _content$getEntry6 === void 0 ? void 0 : _content$getEntry6.video_id, smallpartApp.CLM_TYPE_UNLOAD, []]).sendRequest('keepalive');
          }
        });
        // video might not be loaded due to test having to be started first
        var voloff = this.et2.getWidgetById('voloff');
        if (voloff) voloff.getDOMNode().style.opacity = '0.5';
        var videobar = this.et2.getWidgetById('video');
        if (videobar) {
          var _videobar$getArrayMgr;
          // Video may already be initialized, maybe not
          var initVolume = () => {
            this.et2.getWidgetById('volume').set_value('50');
            videobar.set_volume(50);
          };
          if (videobar.isReady) {
            initVolume();
          } else {
            videobar.video[0].addEventListener('et2_video.onReady.' + videobar.id, initVolume);
          }
          var notSeekable = ((_videobar$getArrayMgr = videobar.getArrayMgr('content').getEntry('video')) === null || _videobar$getArrayMgr === void 0 ? void 0 : _videobar$getArrayMgr.video_test_options) & et2_smallpart_videobar.video_test_option_not_seekable;
          ['forward', 'backward', 'playback', 'playback_slow', 'playback_fast'].forEach(_item => {
            this.et2.getDOMWidgetById(_item).set_disabled(notSeekable);
          });
        }
        this.et2.getDOMWidgetById(smallpartApp.playControlBar).iterateOver(_w => {
          var _content$data$video;
          if ((_content$data$video = content.data.video) !== null && _content$data$video !== void 0 && _content$data$video.video_type.match(/pdf/) && _w && _w.id != '') {
            switch (_w.id) {
              case 'add_comment':
                _w.hidden = !this.isCommentAllowed;
                break;
              case 'play_control_bar':
              case 'fullwidth':
              case 'pgnxt':
              case 'pgprv':
                _w.hidden = false;
                break;
              default:
                _w.hidden = true;
            }
          } else if (_w.id) {
            switch (_w.id) {
              case 'add_comment':
              case 'add_note':
                // Don't change
                break;
              case 'pgnxt':
              case 'pgprv':
                _w.hidden = true;
                break;
              default:
                _w.hidden = false;
            }
          }
        }, this);

        // Enable / disable according to preferences
        ['pauseaftersubmit', 'mouseover', 'comment_on_top', 'hide_question_bar', 'hide_text_bar'].forEach(item => {
          this.student_filter_tools_actions(this.et2.getWidgetById(item), null);
        });
        this.setCommentsSlider(this.comments);
        if (content.data.video.livefeedback) {
          if (content.data.video.livefeedback_session != 'ended') {
            this.student_livefeedbackSession();
          } else {
            this.student_livefeedbackReport();
          }
        }
        (_this$et2$getWidgetBy = this.et2.getWidgetById('comment_color_filter')) === null || _this$et2$getWidgetBy === void 0 || _this$et2$getWidgetBy.set_value("all");
        this.student_filterComments();
        // install save-on-change for video_test_display=3 (list)
        if (((_content$getEntry7 = content.getEntry('video')) === null || _content$getEntry7 === void 0 ? void 0 : _content$getEntry7.video_test_display) == 3) {
          this.installSaveAnswerOnChange();
        }
        break;
      case _name === 'smallpart.question':
        if (content.getEntry('max_answers')) {
          this.et2.getWidgetById('answers').iterateOver(function (_widget) {
            if (_widget.id === '1[checked]' || _widget.id === '1[correct]') {
              this.checkMaxAnswers(undefined, _widget, undefined);
            }
          }, this, et2_checkbox);
        }
        this.defaultPoints();
        var vdh = this.et2.getWidgetById("video_data_helper");
        vdh.video[0].addEventListener("et2_video.onReady." + vdh.id, _ => {
          this.questionTime();
        });
        // set markings for mark or mill-out questions
        this.setMarkings();
        break;
      case _name === 'smallpart.course':
        // disable import button until a file is selected
        var import_button = this.et2.getWidgetById('button[import]');
        import_button === null || import_button === void 0 || import_button.set_readonly(true);
        var import_file = this.et2.getWidgetById("import");
        import_file.addEventListener("change", () => {
          import_button.set_readonly(Object.values(import_file.value).length == 0);
        });
        // seem because set_value of the grid, we need to defer after, to work for updates/apply too
        window.setTimeout(() => this.disableGroupByRole(), 0);

        // Only allow 1 details in course info to open at a time
        var container = this.et2.querySelector(".details-group");
        container.addEventListener("sl-show", event => {
          if (event.target.localName === 'et2-details') {
            [...container.querySelectorAll('et2-details')].map(details => details.open = event.target === details);
          }
        });

        // Scroll to current video
        var tabs = this.et2.getWidgetById("tabs");
        if (tabs && tabs.value == "videos") {
          var _tabs$querySelector;
          (_tabs$querySelector = tabs.querySelector("#smallpart-course_videos")) === null || _tabs$querySelector === void 0 || (_tabs$querySelector = _tabs$querySelector.querySelector("et2-details[open]")) === null || _tabs$querySelector === void 0 || _tabs$querySelector.scrollIntoView();
        }
        break;
      case _name === 'smallpart.lti-content-selection':
        var video_id = this.et2.getWidgetById('video_id');
        if (video_id.getValue()) {
          this.ltiVideoSelection(undefined, video_id);
        }
        break;
      case _name === 'smallpart.material.edit':
        _et2.widgetContainer.getWidgetById("video_name").disabled = true;
        _et2.widgetContainer.getWidgetById("video_name").requestUpdate("disabled", false);
        break;
    }
  }

  /**
   * Observer method receives update notifications from all applications
   *
   * App is responsible for only reacting to "messages" it is interested in!
   *
   * @param {string} _msg message (already translated) to show, eg. 'Entry deleted'
   * @param {string} _app application name
   * @param {(string|number)} _id id of entry to refresh or null
   * @param {string} _type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {string} _msg_type 'error', 'warning' or 'success' (default)
   * @param {object|null} _links app => array of ids of linked entries
   * or null, if not triggered on server-side, which adds that info
   * @return {boolean|*} false to stop regular refresh, thought all observers are run
   */
  observer(_msg, _app, _id, _type, _msg_type, _links) {
    if (_app === 'smallpart-overlay') {
      var overlay = this.et2.getWidgetById('videooverlay');
      if (overlay) {
        overlay.renderElements(_id);
        return false;
      }
    }
  }

  /**
   * Handle a push notification about entry changes from the websocket
   *
   * Get's called for data of all apps, but should only handle data of apps it displays,
   * which is by default only it's own, but can be for multiple apps eg. for calendar.
   *
   * @param  pushData
   * @param {string} pushData.app application name
   * @param {(string|number)} pushData.id id of entry to refresh or null
   * @param {string} pushData.type either 'update', 'edit', 'delete', 'add' or null
   * - update: request just modified data from given rows.  Sorting is not considered,
   *		so if the sort field is changed, the row will not be moved.
   * - edit: rows changed, but sorting may be affected.  Requires full reload.
   * - delete: just delete the given rows clientside (no server interaction neccessary)
   * - add: requires full reload for proper sorting
   * @param {object|null} pushData.acl Extra data for determining relevance.  eg: owner or responsible to decide if update is necessary
   * @param {number} pushData.account_id User that caused the notification
   */
  push(pushData) {
    // don't care about other apps data, reimplement if your app does care eg. calendar
    if (pushData.app !== this.appname) return;

    // check if a comment is pushed
    if (typeof pushData.id === 'string' && pushData.id.match(/^\d+:\d+:\d+$/)) {
      this.pushComment(pushData.id, pushData.type, pushData.acl, pushData.account_id);
    }
    // check if a participant-update is pushed
    else if (typeof pushData.id === 'string' && pushData.id.match(/^\d+:P$/)) {
      this.pushParticipants(pushData.id, pushData.type, pushData.acl);
    }
    // check if course-update is pushed
    else if (typeof pushData.id === 'number') {
      // update watched video / student UI
      if (pushData.id == this.student_getFilter().course_id && (Object.keys(pushData.acl).length || pushData.type === 'delete')) {
        this.pushCourse(pushData.id, pushData.type, pushData.acl);
      }
      // call parent to handle course-list
      return super.push(pushData);
    } else if (typeof pushData.id === 'string' && pushData.acl['data']['lf_id'] && pushData.acl['moderator'] != egw$1.user('account_id')) {
      this.pushLivefeedback(pushData);
    }
  }

  /**
   * Add or update pushed participants (we're currently not pushing deletes)
   *
   * @param course_id
   * @param type currently only "update"
   * @param course undefined for type==="delete"
   */
  pushCourse(course_id, type, course) {
    var filter = this.student_getFilter();

    // if course got closed (for students) --> go to course-list
    if (course.course_closed == 1 || type === 'delete' || !Object.keys(course).length) {
      egw$1.open(null, 'smallpart', 'list');
      console.log('unselecting no longer accessible or deleted course');
      return;
    }
    var sel_options = this.et2.getArrayMgr('sel_options');

    // update course-name, if changed
    if (this.et2.getWidgetById('course_name')) {
      this.et2.getWidgetById('course_name').value = course.course_name;
    }
    var courses = sel_options.getEntry('courses');
    for (var n in courses) {
      if (courses[n].value == course_id) {
        courses[n].label = course.course_name;
        var course_selection = this.et2.getWidgetById('courses');
        if (course_selection) course_selection.select_options = courses;
        break;
      }
    }

    // update video-names
    var video_selection = this.et2.getWidgetById('videos');
    if (video_selection instanceof Et2Select) video_selection.select_options = course.video_labels;

    // currently watched video no longer exist / accessible --> go to course start-page
    if (video_selection instanceof Et2Select && filter.video_id && typeof course.videos[filter.video_id] === 'undefined') {
      egw$1.open(filter.course_id, 'smallpart', 'view');
      console.log('unselecting no longer accessible or deleted video');
      return;
    }

    // update currently watched video
    var video = course.videos[filter.video_id];
    var task = this.et2.getWidgetById('video[video_question]');
    if (video != null && task != null) {
      task.set_value(video.video_question);
      task.getParent().set_statustext(video.video_question);
    }

    // video.video_options or _published* changed --> reload
    var content = this.et2.getArrayMgr('content');
    var old_video = content.getEntry('video');
    if (video && old_video) {
      var _video$video_publishe, _old_video$video_publ, _video$video_publishe2, _old_video$video_publ2;
      if (video.video_options != old_video.video_options || video.video_published != old_video.video_published || ((_video$video_publishe = video.video_published_start) === null || _video$video_publishe === void 0 ? void 0 : _video$video_publishe.date) != (old_video === null || old_video === void 0 || (_old_video$video_publ = old_video.video_published_start) === null || _old_video$video_publ === void 0 ? void 0 : _old_video$video_publ.date) || ((_video$video_publishe2 = video.video_published_end) === null || _video$video_publishe2 === void 0 ? void 0 : _video$video_publishe2.date) != (old_video === null || old_video === void 0 || (_old_video$video_publ2 = old_video.video_published_end) === null || _old_video$video_publ2 === void 0 ? void 0 : _old_video$video_publ2.date)) {
        video_selection.value = '';
        this.courseSelection(null, video_selection);
        console.log('reloading as video_options/_published changed', old_video, video);
        return;
      }
    }

    // add video_test_* (and all other video attributes) to content, so we use them from there
    if (video) {
      Object.assign(content.data.video, video);
    }

    // course-options: &1 = record watched, &2 = display watermark
    this.course_options = course.course_options;

    // update groups
    var group = this.et2.getWidgetById('group');
    if (group && typeof group.set_select_options === "function") {
      var group_options = Object.values(this.et2.getArrayMgr('sel_options').getEntry('group') || {}).slice(-2);
      for (var g = 1; g <= course.course_groups; ++g) {
        group_options.splice(g - 1, 0, {
          value: g,
          label: this.egw.lang('Group %1', g)
        });
      }
      group.set_select_options(group_options);
    }

    // update start-page
    if (!filter.video_id) {
      // do NOT overwrite help-text for teachers with empty course_info/disclaimer
      if (course.course_info) {
        this.et2.setValueById('course_info', course.course_info);
      }
      if (course.course_disclaimer) {
        this.et2.setValueById('course_disclaimer', course.course_disclaimer);
      }
      // only update list of material, if user is already subscribed
      if (this.et2.getArrayMgr('content').getEntry('subscribed')) {
        var _this$et2$getWidgetBy2;
        // get videos grid, sharing id with selectbox, but requiring it as namespace :(
        var material = (_this$et2$getWidgetBy2 = this.et2.getWidgetById('material')) === null || _this$et2$getWidgetBy2 === void 0 ? void 0 : _this$et2$getWidgetBy2.getWidgetById('videos');
        var old_videos = this.et2.getArrayMgr('content').getEntry('videos');
        var videos = course.video_labels.map(option => {
          var old_video = old_videos.find(video => video.video_id == option.value) || {};
          return _objectSpread(_objectSpread({}, old_video), {}, {
            course_id: course.course_id,
            video_id: option.value,
            label: option.label
          }, course.videos[option.value]);
        });
        material === null || material === void 0 || material.set_value({
          content: videos
        });
      }
    }
  }

  /**
   * Add or update pushed participants (we're currently not pushing deletes)
   *
   * @param id "course_id:P"
   * @param type "add" or "update"
   * @param participants
   */
  pushParticipants(id, type, participants) {
    var course_id = id.split(':').shift();
    var sel_options = this.et2.getArrayMgr('sel_options');
    if (this.student_getFilter().course_id != course_id || typeof sel_options === 'undefined') {
      return;
    }
    // check if current user is no longer subscribed / has been kicked from the course
    if (type === 'unsubscribe') {
      participants.forEach(participant => {
        if (participant.account_id == this.user) {
          var course_selection = this.et2.getWidgetById('courses');
          course_selection.change(course_selection.getDOMNode(), course_selection, 'manage');
          console.log('unselecting no longer accessible course');
          return;
        }
      });
      return;
    }
    var account_ids = sel_options.getEntry('account_id');
    var group = account_ids.filter(account => account.value == this.user)[0].group;
    var video = this.et2.getArrayMgr('content').getEntry('video');
    var need_comment_update = false;
    participants.forEach(participant => {
      for (var key in account_ids) {
        if (account_ids[key].value == participant.value) {
          // current user is a student AND group of an other student changed AND
          if (!need_comment_update && !this.is_staff && participant.group !== account_ids[key].group && (
          // groups matter for this video AND
          video.video_options == smallpartApp.COMMENTS_GROUP || video.video_options == smallpartApp.COMMENTS_GROUP_HIDE_TEACHERS) && (
          // AND own student-group is affected (student added or removed from current group, other groups wont matter)
          group == account_ids[key].group || group == participant.group)) {
            // --> update comments
            need_comment_update = true;
          }
          account_ids[key] = participant;
          return;
        }
      }
      account_ids.push(participant);
    });
    // ArrayMgr seems to have no update method
    sel_options.data.account_id = account_ids;

    // check if we are in the student UI, if not we're done
    if (this.et2.getInstanceManager().name.match(/smallpart.start/)) {
      this.changeNicknameStartpage(participants);
      return;
    }

    // do we need to update the comments (because student changed group)
    if (need_comment_update) {
      this.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_listComments', [this.student_getFilter()]).sendRequest();
    }
    // or just refresh them to show modified names (no need for new participants without comments yet)
    else if (type !== 'add') {
      this.student_updateComments({
        content: this.comments
      });
      this._student_setFilterParticipantsOptions();
    }
  }

  /**
   * Add or update pushed comment
   *
   * @param id "course_id:video_id:comment_id"
   * @param type "add", "update" or "delete"
   * @param comment undefined for type==='delete'
   */
  pushComment(id, type, comment, account_id) {
    var course_id, video_id, comment_id;
    [course_id, video_id, comment_id] = id.split(':');

    // show message only for re-tweets / edits on own comments
    if (account_id != this.user && comment.account_id == this.user) {
      switch (type) {
        case 'add':
          this.egw.link_title('api-accounts', account_id, _nick => {
            this.egw.message(this.egw.lang('%1 commented on %2: %3 at %4', _nick, comment.course_name, comment.video_name, this.timeFormat(comment.comment_starttime)) + "\n\n" + comment.comment_added[0]);
          });
          break;
        case 'edit':
          this.egw.link_title('api-accounts', account_id, _nick => {
            this.egw.message(this.egw.lang('%1 edited on %2: %3 at %4', _nick, comment.course_name, comment.video_name, this.timeFormat(comment.comment_starttime)) + "\n\n" + comment.comment_added[0]);
          });
          break;
        case 'retweet':
          this.egw.link_title('api-accounts', account_id, _nick => {
            this.egw.message(this.egw.lang('%1 retweeted on %2: %3 at %4 to', _nick, comment.course_name, comment.video_name, this.timeFormat(comment.comment_starttime)) + "\n\n" + comment.comment_added[0] + "\n\n" + comment.comment_added[comment.comment_added.length - 1]);
          });
          break;
      }
    }

    // if we show student UI the comment belongs to, update comments with it
    if (this.et2.getInstanceManager().name.match(/smallpart.student.index/) !== null && this.student_getFilter().course_id == course_id && this.student_getFilter().video_id == video_id) {
      this.addCommentClass(comment);

      // If pushed comment is currently in the list, get its index
      var commentIndex;
      if (['delete', 'update', 'edit', 'retweet'].includes(type)) {
        commentIndex = this.comments.findIndex(c => c.comment_id == comment.comment_id);
      }

      // integrate pushed comment in own data and add/update it there
      switch (type) {
        case 'add':
          this.comments.push(comment);
          break;
        case 'delete':
          this.comments.splice(commentIndex, 1);
          break;
        case 'update':
        case 'edit':
        case 'retweet':
          this.comments[commentIndex] = comment;
          break;
      }
      if (['add', 'update', 'edit'].includes(type)) {
        // Sort to properly place updated times & new comments
        // Sort is by start time, then end time, then comment ID
        this.comments.sort((a, b) => {
          return a.comment_starttime - b.comment_starttime || a.comment_stoptime - b.comment_stoptime || a.comment_id - b.comment_id;
        });
      }
    }
    this.student_updateComments({
      content: this.comments
    });
  }

  /**
   * Client-side equivalent of Student\Ui::_fixComments()
   *
   * @param comment
   * @protected
   */
  addCommentClass(comment) {
    // add class(es) regular added on server-side
    if (this.is_staff || comment.account_id == this.user) {
      comment.class = 'commentOwner';
    } else {
      comment.class = '';
    }
    if (comment.comment_marked && comment.comment_marked.length) {
      comment.class += ' commentMarked';
    }
    if (comment.comment_cat) {
      comment.comment_cat.split(":").forEach(_cat => {
        comment.class += ' cat-' + _cat;
      });
    }
  }

  /**
   * Format time in seconds as 0:00 or 0:00:00
   *
   * @param secs
   * @return string
   */
  timeFormat(secs) {
    if (secs < 3600) {
      return sprintf('%d:%02d', secs / 60, secs % 60);
    }
    return sprintf('%d:%02d:%02d', secs / 3600, secs % 3600 / 60, secs % 60);
  }

  /**
   * Get the correct comment viewing grid, depending on preference
   *
   * @return {et2_grid}
   */
  get commentGrid() {
    var _this$et2$getWidgetBy3;
    var comments = this.et2.querySelectorAll("et2-template[id$='smallpart-student-comment']");
    comments.forEach(comment => {
      comment.hidden = true;
    });
    var comment_on_top = (_this$et2$getWidgetBy3 = this.et2.getWidgetById('comment_on_top')) === null || _this$et2$getWidgetBy3 === void 0 ? void 0 : _this$et2$getWidgetBy3.checked;
    var comment_template = comments[comment_on_top ? 1 : 0];
    if (comment_template) {
      comment_template.hidden = false;
    }
    return comment_template === null || comment_template === void 0 ? void 0 : comment_template.getWidgetById('comment');
  }
  _student_resize() {
    var _this$et;
    var comments = (_this$et = this.et2) === null || _this$et === void 0 || (_this$et = _this$et.getWidgetById('comments')) === null || _this$et === void 0 ? void 0 : _this$et.getDOMNode();
  }
  student_saveAndCloseCollabora() {
    var _content$getEntry8;
    var content = this.et2.getArrayMgr('content');
    var clml = this.et2.getDOMWidgetById('clm-l');
    var inTestMode = parseInt((_content$getEntry8 = content.getEntry('video')) === null || _content$getEntry8 === void 0 ? void 0 : _content$getEntry8.video_test_duration) > 0 && content.getEntry('timer') > 0;
    if ((content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) == et2_smallpart_videobar.course_options_cognitive_load_measurement && inTestMode && (clml === null || clml === void 0 ? void 0 : clml.get_mode()) === et2_smallpart_cl_measurement_L.MODE_CALIBRATION) {
      return;
    }
    document.getElementsByClassName('note_container')[0].style.display = 'none';
    document.querySelector('iframe[id$="_note"]').contentWindow.app.collabora.WOPIPostMessage('Action_Save');
  }

  /**
   * Click callback called on comments slidebar
   * @param _node
   * @param _widget
   *
   * @return boolean return false when there's an unanswered question
   * @private
   */
  student_commentsSlider_callback(_node, _widget) {
    var id = _widget.id.split('slider-tag-')[1];
    var data = this.comments.filter(function (e) {
      if (e.comment_id == id) return e;
    });
    if (data[0] && data[0].comment_id) {
      this.student_openComment({
        id: 'open'
      }, [{
        data: data[0]
      }], true);
    }
    return true;
  }

  /**
   * Comment edit button handler
   * @param _action
   * @param _comment_id
   */
  student_editCommentBtn(_action, _comment_id) {
    var selected = this.comments.filter(_item => {
      return _item.comment_id == _comment_id;
    });
    this.student_openComment(_action, [{
      data: selected[0]
    }]);
  }

  /**
   * Opend a comment for editing
   *
   * @param _action
   * @param _selected
   * @param _noHighlight
   */
  student_openComment(_action, _selected, _noHighlight) {
    var _this$edited, _this$edited$comment_, _this$et2$getArrayMgr, _this$edited2, _this$et2$getArrayMgr2, _this$et2$getArrayMgr3, _this$edited$comment_2, _comment$getWidgetByI;
    if (!isNaN(_selected)) _selected = [{
      data: this.comments[_selected]
    }];
    this.edited = jQuery.extend({}, _selected[0].data);
    this.edited.action = _action.id;
    this.edited.comment_cat_sub = (_this$edited = this.edited) === null || _this$edited === void 0 || (_this$edited = _this$edited.comment_cat) === null || _this$edited === void 0 ? void 0 : _this$edited.split(':')[1];
    var videobar = this.et2.getWidgetById('video');
    var comments_slider = this.et2.getDOMWidgetById('comments_slider');
    var videooverlay = this.et2.getDOMWidgetById('videooverlay');
    var comment = this.commentGrid;
    var self = this;
    var content = videobar.getArrayMgr('content').data;

    // Do not seek for comments when we are in not seekable
    if (_action.id == 'open' && !content.is_staff && content.video.video_test_options & et2_smallpart_videobar.video_test_option_not_seekable) return;

    // record in case we're playing
    this.record_watched();
    videobar.seek_video(this.edited.comment_starttime);
    // start recording again, in case we're playing
    if (!videobar.paused()) this.start_watching();
    videobar.set_marking_enabled(true, function () {
      self._student_controlCommentAreaButtons(false);
    });
    videobar.set_marking_readonly(true);
    videobar.setMarks(this.edited.comment_marked);
    videobar.setMarksState(true);
    videobar.setMarkingMask(true);
    this.student_playVideo(true);
    this._student_setCommentArea(true);
    if (comment) {
      var _comment$getArrayMgr$, _this$edited$attachme;
      var action = _action.id;
      this.edited.save_label = this.egw.lang('Save');
      // readonly --> disable edit and retweet
      if (this.et2.getArrayMgr('content').getEntry('video').accessible === 'readonly') {
        action = 'open';
      }
      // Open as open, not edit if there are replies
      if (action == "edit" && _action.parent && this.edited["comment_added"].length > 1) {
        action = 'open';
      }
      // Give SmallPartComment widget what it needs
      this.edited["comment_added"] = {
        // @ts-ignore
        course_id: this.edited.course_id,
        video_id: this.edited.video_id,
        comment_id: this.edited.comment_id,
        comment: this.edited.comment_added
      };
      switch (action) {
        case 'retweet':
          this.edited.save_label = this.egw.lang('Retweet');
          // Hide videobar timepicker buttons
          ['start-time-picker', 'stop-time-picker'].forEach(_w => {
            this.et2.getWidgetById(smallpartApp.playControlBar).getWidgetById(_w).hidden = true;
          });

        // fall through
        case 'edit':
          if (_action.id == 'edit') videobar.set_marking_readonly(false);
          var content_cats = this.et2.getArrayMgr('content').getEntry('cats');
          this.edited = _objectSpread(_objectSpread({}, this.edited), {
            text: this.edited.comment_added['comment'][0],
            video_duration: videobar.duration(),
            attachments_list: this.edited['/apps/smallpart/' + this.edited.course_id + '/' + this.edited.video_id + '/' + this.edited.account_lid + '/comments/' + this.edited.comment_id + '/'],
            comment_cat: (_this$edited$comment_ = this.edited.comment_cat) !== null && _this$edited$comment_ !== void 0 ? _this$edited$comment_ : content_cats ? content_cats[0]['cat_id'] : null,
            free_comment_only: (_this$et2$getArrayMgr = this.et2.getArrayMgr('content').getEntry('comment')) === null || _this$et2$getArrayMgr === void 0 ? void 0 : _this$et2$getArrayMgr.free_comment_only
          });
          if (_action.id == 'edit') {
            this.edited["comment_added"] = undefined;
            this.student_commentCatChanged(null, comment.getWidgetById("comment_cat"));
          }
          comment.set_value({
            content: this.edited
          });
          comments_slider === null || comments_slider === void 0 || comments_slider.disableCallback(true);
          videooverlay.getElementSlider().disableCallback(true);
          break;
        case 'open':
          var hideMaskPlayArea = this.et2.getWidgetById('hideMaskPlayArea');
          hideMaskPlayArea.set_disabled(false);
          hideMaskPlayArea.value = '';
          document.getElementsByClassName('markingMask')[0].classList.remove('maskOn');
          var cats = ((_this$edited2 = this.edited) === null || _this$edited2 === void 0 || (_this$edited2 = _this$edited2.comment_cat) === null || _this$edited2 === void 0 || (_this$edited2 = _this$edited2.toString()) === null || _this$edited2 === void 0 ? void 0 : _this$edited2.split(":")) || [];
          var free_comment_only = (_this$et2$getArrayMgr2 = this.et2.getArrayMgr('content').getEntry('comment')) === null || _this$et2$getArrayMgr2 === void 0 ? void 0 : _this$et2$getArrayMgr2.free_comment_only;
          var accessible = (_this$et2$getArrayMgr3 = this.et2.getArrayMgr('content').getEntry('video')) === null || _this$et2$getArrayMgr3 === void 0 ? void 0 : _this$et2$getArrayMgr3.accessible;
          comment.set_value({
            content: {
              comment_id: this.edited.comment_id,
              comment_added: this.edited.comment_added,
              comment_starttime: this.edited.comment_starttime,
              comment_stoptime: this.edited.comment_stoptime,
              comment_marked_message: !free_comment_only,
              free_comment_only: free_comment_only,
              comment_cat: (_this$edited$comment_2 = this.edited.comment_cat) !== null && _this$edited$comment_2 !== void 0 ? _this$edited$comment_2 : content_cats ? content_cats[0]['cat_id'] : null,
              comment_cat_sub: this.edited.comment_cat_sub,
              accessible: accessible,
              action: action,
              video_duration: videobar.duration()
            }
          });
          (_comment$getWidgetByI = comment.getWidgetById('comment_editBtn')) === null || _comment$getWidgetByI === void 0 || _comment$getWidgetByI.set_disabled(!(this.is_staff || this.edited.account_id == egw$1.user('account_id')) || accessible === 'readonly');
          comment.getWidgetById("comment_added").editable = this.is_staff || this.edited.account_id == egw$1.user('account_id');
          if (comments_slider) {
            comments_slider.disableCallback(false);
            videooverlay.getElementSlider().disableCallback(false);
            var tag = comments_slider._children.filter(_item => {
              return _item.id === 'slider-tag-' + self.edited.comment_id;
            });
            comments_slider.set_selected(tag.length > 0 ? tag[0] : null);
            // Hide videobar timepicker buttons
            ['start-time-picker', 'stop-time-picker'].forEach(_w => {
              this.et2.getWidgetById(smallpartApp.playControlBar).getWidgetById(_w).hidden = true;
            });
          }
      }
      if (!_noHighlight) {
        this._student_highlightSelectedComment(this.edited.comment_id);
      } else {
        this.et2.getWidgetById('comments').getDOMNode().querySelectorAll(smallpartApp.commentRowsQuery).forEach(_item => {
          _item.classList.remove('highlight');
        });
      }

      // Show / hide attachment dropdown if there's already a file uploaded
      var attachment_key = Object.keys(this.edited).find(k => k.startsWith("/apps/smallpart/"));
      comment.getWidgetById("attachment_list").querySelector("[slot='trigger']").hidden = Object.values((_comment$getArrayMgr$ = comment.getArrayMgr("content").getEntry("attachments")) !== null && _comment$getArrayMgr$ !== void 0 ? _comment$getArrayMgr$ : []).length == 0 && !((_this$edited$attachme = this.edited[attachment_key]) !== null && _this$edited$attachme !== void 0 && _this$edited$attachme.length);
    }
    this._student_controlCommentAreaButtons(true);
  }

  /**
   * Re-evaluate starttime/stoptime max&min values
   * @param _node
   * @param _widget
   */
  student_checkCommentStarttime(_node, _widget) {
    var stoptime = _widget.getInstanceManager()._widgetContainer.getWidgetById('comment_stoptime');
    var starttime = _widget.getInstanceManager()._widgetContainer.getWidgetById('comment_starttime');
    if (_widget.id == starttime.id) {
      starttime.set_max(stoptime.get_value());
      if (starttime.get_value() < stoptime.get_value()) stoptime.set_min(starttime.get_value());
    } else {
      stoptime.set_min(starttime.get_value());
      starttime.set_max(_widget.get_value());
    }
  }

  /**
   * Get a label for the used colors: Neutral (white), Positiv (green), Negative (red)
   *
   * @param _color
   * @return string
   */
  color2Label(_color) {
    switch (_color) {
      case 'ffffff':
        return this.egw.lang('White');
      case '00ff00':
        return this.egw.lang('Green');
      case 'ff0000':
        return this.egw.lang('Red');
      case 'ffff00':
        return this.egw.lang('Yellow');
    }
  }
  /**
   * set up post_cl_questions dialog
   * @private
   */
  _student_setPostCLQuestions(_callback) {
    var content = this.et2.getArrayMgr('content');

    // only run this if we are in CLM mode and Post is active
    if ((content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) != et2_smallpart_videobar.course_options_cognitive_load_measurement || !content.getEntry('clm')['post']['active']) {
      return;
    }
    var post = content.getEntry('clm')['post'];

    // Fix wrong data types / overlap between disabled & value
    post.qa1_disabled = !post.qa1;
    delete post.qa1;
    post.qa2_disabled = !post.qa2;
    delete post.qa2;
    if (typeof post.questions === 'object') {
      post.questions = Object.values(post.questions);
      // first index is reserved for grid and question index starts from 1
      if (post.questions[0]['q']) {
        post.questions.unshift({});
      }
    }
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: _callback,
      title: '',
      buttons: [{
        label: this.egw.lang("Continue"),
        id: "continue"
      }],
      width: 500,
      value: {
        content: post
      },
      class: 'questionnaire',
      hideOnEscape: false,
      noCloseButton: true,
      template: this.egw.webserverUrl + '/smallpart/templates/default/post_cl_questions.xet'
    });
    document.body.appendChild(dialog);
  }
  student_CLM_L(mode) {
    //disable CLML feature for now.
    var clml = this.et2.getDOMWidgetById('clm-l');
    clml.set_mode(mode);
    return clml.start();
  }
  student_testFinished(_widget) {
    var content = this.et2.getArrayMgr('content');
    var widget = _widget;
    var self = this;
    var callback = _w => {
      self.et2.getDOMWidgetById('clm-l').stop();
      self._student_noneTestAreaMasking(false);
      if ((content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) == et2_smallpart_videobar.course_options_cognitive_load_measurement && content.getEntry('clm')['post']['active']) {
        var _content$getEntry9, _content$getEntry0;
        // record a stop time once before post questions and after user decided to finish the test
        self.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_recordCLMeasurement', [(_content$getEntry9 = content.getEntry('video')) === null || _content$getEntry9 === void 0 ? void 0 : _content$getEntry9.course_id, (_content$getEntry0 = content.getEntry('video')) === null || _content$getEntry0 === void 0 ? void 0 : _content$getEntry0.video_id, smallpartApp.CLM_TYPE_STOP, []]).sendRequest();
        var timer = self.et2.getDOMWidgetById('timer');
        // reset the alarms after the test is finished
        timer.options.alarm = [];
        this._student_setPostCLQuestions(function (_button, _value) {
          if (_button === "continue" && Object.keys(_value).length > 0) {
            var _content$getEntry1, _content$getEntry10;
            self.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_recordCLMeasurement', [(_content$getEntry1 = content.getEntry('video')) === null || _content$getEntry1 === void 0 ? void 0 : _content$getEntry1.course_id, (_content$getEntry10 = content.getEntry('video')) === null || _content$getEntry10 === void 0 ? void 0 : _content$getEntry10.video_id, smallpartApp.CLM_TYPE_POST, _value]).sendRequest();
          }
          _w.getRoot().getInstanceManager().submit(_w.id);
        });
      } else {
        _w.getRoot().getInstanceManager().submit(_w.id);
      }
    };
    switch (_widget.id) {
      case 'stop':
        Et2Dialog.show_dialog(_button => {
          if (_button == Et2Dialog.YES_BUTTON) {
            callback(_widget);
          }
        }, this.egw.lang('If you finish the test, you will not be able to enter it again!'), this.egw.lang('Finish test?'));
        break;
      case 'timer':
        callback(_widget);
        break;
    }
  }

  /**
   * set up process_cl_questions dialog
   * @private
   */
  _student_setProcessCLQuestions() {
    var _content$getEntry11;
    var content = this.et2.getArrayMgr('content');
    var alarms = [];

    // only run this if we are in CLM mode and process is active
    if ((content.getEntry('course_options') & et2_smallpart_videobar.course_options_cognitive_load_measurement) != et2_smallpart_videobar.course_options_cognitive_load_measurement || !content.getEntry('clm')['process']['active']) return;
    var self = this;
    var video_test_duration = parseInt((_content$getEntry11 = content.getEntry('video')) === null || _content$getEntry11 === void 0 ? void 0 : _content$getEntry11.video_test_duration) * 60;
    var repeat = content.data['clm']['process']['interval'] ? video_test_duration / (content.data['clm']['process']['interval'] * 60) : video_test_duration / 600;

    // keeps the reply timeout id
    var replyTimeout = null;
    for (var i = 1; i < repeat; i++) {
      var value = i * Math.floor(video_test_duration / repeat);
      alarms[value] = value;
    }
    var timer = this.et2.getDOMWidgetById('timer');

    // make sure timer is there before accessing it. the widget might not be present in some cases, eg. before test
    // get started.
    if (timer) {
      timer.options.alarm = alarms;
      // callback to be called for alarm
      timer.onAlarm = () => {
        var d = dialog();
        replyTimeout = setTimeout(function () {
          this.querySelector("et2-button").click();
        }.bind(d), (content.data['clm']['process']['duration'] ? content.data['clm']['process']['duration'] : 60) * 1000);
      };
    }
    var dialog = () => {
      // do not trigger a pause action when the comment editor is open
      if (!this.edited) this.student_playVideo(true);
      var questions = content.getEntry('clm')['process']['questions'];
      if (typeof questions === 'object') {
        questions = Object.values(questions);
        // first index is reserved for grid and question index starts from 1
        if (questions[0]['q']) questions.unshift({});
      }
      var dialog = new Et2Dialog(this.egw);
      dialog.transformAttributes({
        callback: function callback(_button, _value) {
          if (_button === "continue" && Object.keys(_value).length > 0) {
            var _content$getEntry12, _content$getEntry13;
            self.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_recordCLMeasurement', [(_content$getEntry12 = content.getEntry('video')) === null || _content$getEntry12 === void 0 ? void 0 : _content$getEntry12.course_id, (_content$getEntry13 = content.getEntry('video')) === null || _content$getEntry13 === void 0 ? void 0 : _content$getEntry13.video_id, smallpartApp.CLM_TYPE_PROCESS, _value]).sendRequest();
            clearTimeout(replyTimeout);
          }
        },
        buttons: [{
          label: this.egw.lang("Continue"),
          id: "continue"
        }],
        width: 400,
        value: {
          content: {
            questions: questions
          }
        },
        template: egw$1.webserverUrl + '/smallpart/templates/default/process_cl_questions.xet',
        class: 'questionnaire clm-process',
        isModal: true,
        hideOnEscape: false,
        noCloseButton: true
      });
      document.body.appendChild(dialog);
      return dialog;
    };
  }
  _student_clm_l_start() {
    var _content$getEntry14;
    var clml = this.et2.getDOMWidgetById('clm-l');
    var timer = this.et2.getDOMWidgetById('timer');
    var content = this.et2.getArrayMgr('content');
    var self = this;
    if (((_content$getEntry14 = content.getEntry('video')) === null || _content$getEntry14 === void 0 ? void 0 : _content$getEntry14.video_options) == smallpartApp.COMMENTS_FORBIDDEN_BY_STUDENTS) {
      clml.set_steps_className(clml.get_steps_className() + ',note_container');
    }
    clml.checkCalibration().then(_ =>
    // calibration is already done once
    {
      this._student_setProcessCLQuestions();
      // run the CLM "L" in running mode
      this.student_CLM_L('running');
    }, _ =>
    //calibration process
    {
      // reset the timer
      clearInterval(timer.timer);
      document.getElementsByClassName('timerBox')[0].style.display = 'none';
      document.querySelector('form[id^="smallpart-student-"]').style.visibility = 'hidden';
      document.getElementsByClassName('commentBoxArea')[0].style.display = 'block';
      var dialog = new Et2Dialog(this.egw);
      dialog.transformAttributes({
        callback: function callback() {
          document.querySelector('form[id^="smallpart-student-"]').style.visibility = '';
          // start the CLM "L" calibration process
          self.student_CLM_L(et2_smallpart_cl_measurement_L.MODE_CALIBRATION).then(_ => {
            // set the timer again
            timer.set_value(content.getEntry('timer'));
            if (!content.getEntry('comments') || content.getEntry('comments').length <= 1) {
              document.getElementsByClassName('commentBoxArea')[0].style.display = 'none';
            }
            document.getElementsByClassName('timerBox')[0].style.display = 'block';
            self._student_setProcessCLQuestions();
            // run the CLM "L" in running mode
            self.student_CLM_L('running');
          });
        },
        buttons: Et2Dialog.BUTTONS_OK,
        title: this.egw.lang('Measurement by dual task (Calibration and measurement of cognitive load)'),
        closeOnEscape: false,
        noCloseButton: true,
        width: 400,
        template: egw$1.webserverUrl + '/smallpart/templates/default/clm_L_calibration_message.xet?'
      });
      document.body.appendChild(dialog);
    });
  }
  _student_noneTestAreaMasking(state) {
    // don't do the masking area if the user has rights
    if (this.is_staff) return;
    ['#egw_fw_header', '#egw_fw_sidebar', '.egw_fw_ui_tabs_header', '#egw_fw_sidebar_r', '.video_list'].forEach(_query => {
      var node = document.querySelector(_query);
      if (node) {
        node.style.filter = state ? 'blur(2px)' : '';
        node.style.pointerEvents = state ? 'none' : '';
      }
    });
  }
  _student_setCommentArea(_state) {
    var _content$getEntry15, _content$getEntry16;
    var content = this.et2.getArrayMgr('content');
    var forbidTocomment = this.is_staff && ((_content$getEntry15 = content.getEntry('video')) === null || _content$getEntry15 === void 0 ? void 0 : _content$getEntry15.video_options) == smallpartApp.COMMENTS_FORBIDDEN_BY_STUDENTS || ((_content$getEntry16 = content.getEntry('video')) === null || _content$getEntry16 === void 0 ? void 0 : _content$getEntry16.video_options) == smallpartApp.COMMENTS_DISABLED;
    try {
      // Show / Hide videobar timepicker buttons
      ['start-time-picker', 'stop-time-picker'].forEach(_w => {
        var button = this.et2.getWidgetById(smallpartApp.playControlBar).getWidgetById(_w);
        button.disabled = !_state;
        button.hidden = false;
      });

      // Enable / Disable add note/comments buttons
      ['add_comment', 'add_note'].forEach(_w => {
        this.et2.getWidgetById(smallpartApp.playControlBar).getWidgetById(_w).disabled = _state;
      });
      this.et2.getWidgetById('smallpart.student.comments_list').getWidgetById('add_comment').disabled = _state;
      var comments = this.et2.querySelectorAll("et2-template[id$='smallpart-student-comment']").forEach(comment => {
        comment.disabled = !_state;
      });
      this.et2.setDisabledById('hideMaskPlayArea', true);
      this._student_resize();
    } catch (e) {}
  }
  student_playControl(_status) {
    var videobar = this.et2.getWidgetById('video');
    var volume = this.et2.getWidgetById('volume');
    var playback = this.et2.getWidgetById('playback');
    var videooverlay = this.et2.getWidgetById('videooverlay');
    var selectedIndex = playback.select_options.findIndex(a => a.value == playback.value);
    if (_status && _status.nodeName === 'ET2-SELECT') {
      videobar.set_playBackRate(parseFloat(_status.value));
      return;
    }
    switch (_status) {
      case "playback_fast":
        if (selectedIndex < playback.select_options.length - 1) {
          playback.set_value(playback.select_options[selectedIndex + 1].value);
        }
        break;
      case "playback_slow":
        if (selectedIndex > 0) {
          playback.set_value(playback.select_options[selectedIndex - 1].value);
        }
        break;
      case "start-time-picker":
      case "stop-time-picker":
        this.commentGrid.getWidgetById("comment_timespan").timePicker(_status == "start-time-picker" ? "starttime" : "stoptime");
        break;
      case "forward":
        if (videobar.currentTime() + 10 <= videobar.duration()) {
          videobar.seek_video(videobar.currentTime() + 10);
          videooverlay._elementSlider.set_seek_position(Math.round(videobar._vtimeToSliderPosition(videobar.currentTime())));
        }
        break;
      case "backward":
        if (videobar.currentTime() - 10 >= 0) {
          videobar.seek_video(videobar.currentTime() - 10);
          videooverlay._elementSlider.set_seek_position(Math.round(videobar._vtimeToSliderPosition(videobar.currentTime())));
        }
        break;
      case "volup":
        videobar.set_volume(videobar.get_volume() + 10);
        setTimeout(_ => {
          volume.set_value(videobar.get_volume());
        }, 100);
        break;
      case "voldown":
        videobar.set_volume(videobar.get_volume() - 10);
        setTimeout(_ => {
          volume.set_value(videobar.get_volume());
        }, 100);
        break;
      case "voloff":
        videobar.set_mute(!videobar.get_mute());
        setTimeout(_ => {
          if (videobar.get_mute()) {
            ['voldown', 'volup', 'voloff'].forEach(_w => {
              var node = this.et2.getWidgetById(_w).getDOMNode();
              node.style.opacity = _w === 'voloff' ? '1' : '0.5';
              node.style.pointerEvents = _w === 'voloff' ? 'auto' : 'none';
            });
          } else {
            ['voldown', 'volup', 'voloff'].forEach(_w => {
              var node = this.et2.getWidgetById(_w).getDOMNode();
              node.style.opacity = _w == 'voloff' ? '0.5' : '1';
              node.style.pointerEvents = 'auto';
            });
          }
        }, 100);
        break;
      case "fullwidth":
        var fullwidth = this.et2.getDOMWidgetById('fullwidth');
        var clml = this.et2.getWidgetById('clm-l');
        document.querySelector("#smallpart-student-index > div > et2-box").classList.toggle('fullscreen-video');
        if (fullwidth.image == 'fullscreen') {
          fullwidth.image = 'fullscreen-exit';
          fullwidth.requestUpdate("image");
          if (clml && clml.getDOMNode()) {
            clml.getDOMNode().classList.add('fixed-l');
          }
        } else {
          fullwidth.image = 'fullscreen';
          fullwidth.requestUpdate("image");
          if (clml && clml.getDOMNode()) {
            clml.getDOMNode().classList.remove('fixed-l');
          }
        }
        // resize resizable widgets
        [videobar, 'comments_slider'].forEach(_w => {
          var w = typeof _w === 'string' ? this.et2.getDOMWidgetById(_w) : _w;
          w === null || w === void 0 || w.resize(0);
        });
        break;
      // pdf page controllers
      case "pgnxt":
        if (videobar.duration() > videobar.currentTime()) {
          videobar.seek_video(videobar.currentTime() + 1);
          videooverlay._elementSlider.set_seek_position(Math.round(videobar._vtimeToSliderPosition(videobar.currentTime())));
        }
        break;
      case "pgprv":
        if (videobar.currentTime() > 1) {
          videobar.seek_video(videobar.currentTime() - 1);
          videooverlay._elementSlider.set_seek_position(Math.round(videobar._vtimeToSliderPosition(videobar.currentTime())));
        }
        break;
    }
  }
  student_attachmentFinish() {
    this.et2.getDOMWidgetById('saveAndContinue').set_disabled(false);
  }
  student_attachmentStart(event) {
    this.et2.getDOMWidgetById('saveAndContinue').set_disabled(true);

    // Open attachment list
    event.target.getParent().getWidgetById("attachment_list").show();

    // Show attachment dropdown trigger
    event.target.getParent().getWidgetById("attachment_list").querySelector("[slot='trigger']").hidden = false;
    return true;
  }

  /**
   * Highlights comment row based for the given comment id
   * @param _comment_id
   * @private
   */
  _student_highlightSelectedComment(_comment_id) {
    var commentsGrid = jQuery(this.et2.getWidgetById('comments').getDOMNode());
    var scrolledComment = commentsGrid.find('tr.commentID' + _comment_id);
    if (scrolledComment[0].className.indexOf('hideme') < 0) {
      commentsGrid.find(smallpartApp.commentRowsQuery).removeClass('highlight');
      scrolledComment.addClass('highlight');
      commentsGrid[0].scrollTop = scrolledComment[0].offsetTop;
    }
  }
  student_playVideo(_pause) {
    var videobar = this.et2.getWidgetById('video');
    var play = this.et2.getWidgetById('play');
    var self = this;
    var content = this.et2.getArrayMgr('content');
    if (play.image == 'pause-fill' || _pause) {
      videobar.pause_video();
      play.image = "play-circle";
    } else {
      this.start_watching();
      videobar.set_marking_enabled(false);
      if (!content.data.video.video_src.match(/pdf/)) {
        videobar.play_video(function () {
          play.image = "play-fill";
          if (!(videobar.getArrayMgr('content').getEntry('video')['video_test_options'] & et2_smallpart_videobar.video_test_option_not_seekable)) {
            play.image = 'arrow-clockwise';
          } else {
            play.image = "play-fill";
          }
          // record video watched
          self.record_watched();
        }, function (_id) {
          self._student_highlightSelectedComment(_id);
          var comments_slider = self.et2.getWidgetById('comments_slider');
          if (comments_slider) {
            comments_slider.set_selected(false);
          }
        });
      }
      play.image = "pause-fill";
    }
  }
  student_dateFilter(changeEvent, _widget) {
    this._student_dateFilterSearch();
  }
  _student_dateFilterSearch() {
    var rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode());
    var ids = [];
    var comments = this.et2.getArrayMgr('content').getEntry('comments');
    var date = this.et2.getDOMWidgetById('comment_date_filter').getValue();
    var from = date !== null && date !== void 0 && date.from ? new Date(date.from) : 0;
    var to = Number.MAX_SAFE_INTEGER;
    if (date !== null && date !== void 0 && date.to) {
      to = new Date(date.to);
      to.setUTCHours(23, 59, 59);
    }
    rows.each(function () {
      var _this$classList$value;
      var id = ((_this$classList$value = this.classList.value.match(/commentID.*[0-9]/)) !== null && _this$classList$value !== void 0 ? _this$classList$value : " ")[0].replace('commentID', '');
      var comment = comments.filter(_item => {
        return _item.comment_id == id;
      });
      if (comment && comment.length > 0) {
        var date_updated = new Date(comment[0].comment_updated.date);
        if (from <= date_updated && to >= date_updated) {
          ids.push(id);
        }
      }
    });
    this._student_commentsFiltering('date', ids.length == 0 && (date.to || date.from) ? ['ALL'] : ids);
  }
  student_filter_tools_actions(_action, _selected) {
    var _action$value, _this$et2$getDOMWidge5;
    switch (_action.id) {
      case 'mouseover':
        this.student_onmouseoverFilter(_action.checked);
        break;
      case 'download':
        this.et2.getInstanceManager().postSubmit('download');
        break;
      case 'pauseaftersubmit':
        break;
      case 'searchall':
        if (_action.checked) {
          this.et2.getDOMWidgetById('comment_search_filter').getDOMNode().classList.add('searchall');
        } else {
          this.et2.getDOMWidgetById('comment_search_filter').getDOMNode().classList.remove('searchall');
        }
        break;
      case 'date':
        var date = this.et2.getDOMWidgetById('comment_date_filter');
        if (!_action.checked) {
          date.set_value({
            from: null,
            to: null
          });
        }
        this._student_dateFilterSearch();
        break;
      case 'attachments':
        this._student_filterAttachments(_action.checked);
        break;
      case 'marked':
        this._student_filterMarked(_action.checked);
        break;
      case 'hide_question_bar':
      case 'hide_text_bar':
        var widgetName = (_action$value = _action.value) !== null && _action$value !== void 0 ? _action$value : "";
        (_this$et2$getDOMWidge5 = this.et2.getDOMWidgetById(widgetName)) === null || _this$et2$getDOMWidge5 === void 0 || (_this$et2$getDOMWidge5 = _this$et2$getDOMWidge5.getDOMNode()) === null || _this$et2$getDOMWidge5 === void 0 || (_this$et2$getDOMWidge5 = _this$et2$getDOMWidge5.classList) === null || _this$et2$getDOMWidge5 === void 0 || _this$et2$getDOMWidge5.toggle("hideme", _action.checked);
        break;
    }
  }
  student_top_tools_actions(_action, _selected) {
    var video_id = this.et2.getValueById('videos');
    var content = this.et2.getArrayMgr('content');
    switch (_action.id) {
      case 'question':
        if (video_id) egw$1.open_link(egw$1.link('/index.php', 'menuaction=smallpart.EGroupware\\SmallParT\\Questions.index&video_id=' + video_id + '&ajax=true&cd=popup'));
        break;
      case 'score':
        if (video_id) egw$1.open_link(egw$1.link('/index.php', 'menuaction=smallpart.EGroupware\\SmallParT\\Questions.scores&video_id=' + video_id + '&ajax=true&cd=popup'));
        break;
      case 'note':
        if (video_id) {
          var iframe = this.et2.getDOMWidgetById('note');
          egw$1.request('EGroupware\\smallpart\\Student\\Ui::ajax_createNote', [content.getEntry('courses'), video_id]).then(_data => {
            if (_data.path) {
              var clm_l = this.et2.getDOMWidgetById('clm-l');
              if (clm_l) {
                iframe.getDOMNode().onload = () => {
                  // we need to wait until Collabora messages it's ready, before binding our keydown handler
                  iframe.getDOMNode().contentWindow.addEventListener('message', e => {
                    var message = JSON.parse(e.data);
                    if (message.MessageId === 'App_LoadingStatus' && message.Values.Status === 'Document_Loaded') {
                      try {
                        var egw_co_document = iframe.getDOMNode().contentDocument;
                        clm_l.bindKeyHandler(egw_co_document.querySelector('iframe#loleafletframe').contentDocument);
                      } catch (e) {
                        console.error('Can NOT bind keydown handler on Colloabora: ' + e.message);
                      }
                    }
                  });
                };
              }
              iframe.set_value(egw$1.link('/index.php', {
                'menuaction': 'collabora.EGroupware\\collabora\\Ui.editor',
                'path': _data.path,
                'cd': 'no' // needed to not reload framework in sharing
              }));
              document.getElementsByClassName('note_container')[0].style.display = 'block';
            }
            egw$1.message(_data.message);
          });
        }
    }
  }
  student_addNote() {
    this.student_top_tools_actions({
      id: 'note'
    }, null);
  }

  /**
   * Add new comment / edit button callback
   */
  student_addComment() {
    var comment = this.commentGrid;
    var videobar = this.et2.getWidgetById('video');
    var comments_slider = this.et2.getDOMWidgetById('comments_slider');
    var videooverlay = this.et2.getDOMWidgetById('videooverlay');
    var self = this;
    this.student_playVideo(true);
    this._student_setCommentArea(true);
    videobar.set_marking_enabled(true, function () {
      self._student_controlCommentAreaButtons(false);
    });
    videobar.set_marking_readonly(false);
    videobar.setMarks(null);
    var content_cats = this.et2.getArrayMgr('content').getEntry('cats');
    this.edited = jQuery.extend(this.student_getFilter(), {
      account_lid: this.egw.user('account_lid'),
      comment_added: [''],
      text: "",
      comment_color: smallpartApp.default_color,
      action: 'edit',
      save_label: this.egw.lang('Save'),
      video_duration: videobar.duration(),
      comment_cat: this.et2.getArrayMgr("content").getEntry('config[no_free_comment]') ? '' : 'free'
    });
    comment.set_value({
      content: _objectSpread(_objectSpread(_objectSpread({}, comment.getArrayMgr("content").data), this.edited), {}, {
        comment_id: "",
        comment_starttime: Math.round(videobar.currentTime()),
        comment_stoptime: Math.round(videobar.currentTime()),
        attachments: []
      })
    });
    comment.getWidgetById('deleteComment').set_disabled(true);
    comment.getWidgetById("comment_cat").updateComplete.then(() => {
      this.student_commentCatChanged(null, comment.getWidgetById("comment_cat"));
    });
    this._student_controlCommentAreaButtons(true);
    comments_slider === null || comments_slider === void 0 || comments_slider.disableCallback(true);
    videooverlay.getElementSlider().disableCallback(true);

    // Hide attachment dropdown until there's a file uploaded
    comment.getWidgetById("attachment_list").querySelector("[slot='trigger']").hidden = true;
  }

  /**
   * Cancel edit and continue button callback
   */
  student_cancelAndContinue() {
    var videobar = this.et2.getWidgetById('video');
    var filter_toolbar = this.et2.getDOMWidgetById('filter-toolbar');
    var comments_slider = this.et2.getDOMWidgetById('comments_slider');
    var videooverlay = this.et2.getDOMWidgetById('videooverlay');
    videobar.removeMarks();
    this.student_playVideo(this.et2.getDOMWidgetById('pauseaftersubmit').checked);
    delete this.edited;
    this._student_setCommentArea(false);

    // Update attachments in content, if they've added / removed a temp file
    var data = this.commentGrid.getArrayMgr("content");
    var attachments = data.getEntry("attachments", true);
    data.data.attachments = this.commentGrid.getWidgetById("attachments").value;
    this.et2.getWidgetById('smallpart.student.comment').set_disabled(true);
    comments_slider === null || comments_slider === void 0 || comments_slider.disableCallback(false);
    videooverlay.getElementSlider().disableCallback(false);
  }

  /**
   * Save comment/retweet and continue button callback
   */
  student_saveAndContinue() {
    var _comment$getWidgetByI2, _comment$getWidgetByI3, _comment$getWidgetByI4, _comment$getWidgetByI5, _comment$getWidgetByI6;
    var comment = this.commentGrid;
    var videobar = this.et2.getWidgetById('video');
    var mainCat = (_comment$getWidgetByI2 = comment.getWidgetById("comment_cat")) === null || _comment$getWidgetByI2 === void 0 ? void 0 : _comment$getWidgetByI2.value;
    var attachments = (_comment$getWidgetByI3 = (_comment$getWidgetByI4 = comment.getWidgetById("attachments")) === null || _comment$getWidgetByI4 === void 0 ? void 0 : _comment$getWidgetByI4.getValue()) !== null && _comment$getWidgetByI3 !== void 0 ? _comment$getWidgetByI3 : {};
    var text = this.edited.action === 'retweet' ? (_comment$getWidgetByI5 = comment.getWidgetById('retweet')) === null || _comment$getWidgetByI5 === void 0 ? void 0 : _comment$getWidgetByI5.get_value() : (_comment$getWidgetByI6 = comment.getWidgetById('text')) === null || _comment$getWidgetByI6 === void 0 ? void 0 : _comment$getWidgetByI6.get_value();
    if (mainCat || Object.values(attachments).length > 0)
      // ignore comments with neither an attachment nor main category
      {
        var _comment$getWidgetByI7, _comment$getWidgetByI8, _comment$getWidgetByI9, _comment$getWidgetByI0, _comment$getWidgetByI1, _comment$getWidgetByI10;
        this.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_saveComment', [this.et2.getInstanceManager().etemplate_exec_id, jQuery.extend(this.edited, {
          // send action and text to server-side to be able to do a proper ACL checks
          action: this.edited.action,
          text: text,
          comment_color: ((_comment$getWidgetByI7 = comment.getWidgetById('comment_color')) === null || _comment$getWidgetByI7 === void 0 ? void 0 : _comment$getWidgetByI7.get_value()) || this.edited.comment_color,
          comment_cat: ((_comment$getWidgetByI8 = comment.getWidgetById('comment_cat')) === null || _comment$getWidgetByI8 === void 0 ? void 0 : _comment$getWidgetByI8.value) + ((_comment$getWidgetByI9 = comment.getWidgetById('comment_cat_sub')) !== null && _comment$getWidgetByI9 !== void 0 && _comment$getWidgetByI9.value ? ':' + ((_comment$getWidgetByI0 = comment.getWidgetById('comment_cat_sub')) === null || _comment$getWidgetByI0 === void 0 ? void 0 : _comment$getWidgetByI0.value) : '') || null,
          comment_starttime: ((_comment$getWidgetByI1 = comment.getWidgetById('comment_timespan')) === null || _comment$getWidgetByI1 === void 0 ? void 0 : _comment$getWidgetByI1.starttime) || videobar.currentTime(),
          comment_stoptime: ((_comment$getWidgetByI10 = comment.getWidgetById('comment_timespan')) === null || _comment$getWidgetByI10 === void 0 ? void 0 : _comment$getWidgetByI10.stoptime) || 1,
          comment_marked: videobar.getMarks(),
          attachments: Object.values(attachments).map(f => f.name)
        }), this.student_getFilter()]).sendRequest();
      }
    this.student_cancelAndContinue();
  }

  /**
   * Delete comment (either as action from list or by button for currently edited comment)
   *
   * @param _action
   * @param _selected
   */
  student_deleteComment(_action, _selected) {
    var self = this;
    var comment_id = _action.id === 'delete' ? _selected[0].data.comment_id : self.edited.comment_id;
    Et2Dialog.show_dialog(function (_button) {
      if (_button === Et2Dialog.YES_BUTTON) {
        var _self$edited;
        self.egw.json('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_deleteComment', [self.et2.getInstanceManager().etemplate_exec_id, comment_id, self.student_getFilter()]).sendRequest();

        // do we need to clean up the edit-area
        if (comment_id == ((_self$edited = self.edited) === null || _self$edited === void 0 ? void 0 : _self$edited.comment_id)) self.student_cancelAndContinue();
      }
    }, this.egw.lang('Delete this comment?'), this.egw.lang('Delete'), null, Et2Dialog.BUTTONS_YES_NO);
  }

  /**
   * Get current active filter
   */
  student_getFilter() {
    var _this$et2, _this$et3, _this$filter, _this$filter2;
    var courses = (_this$et2 = this.et2) === null || _this$et2 === void 0 ? void 0 : _this$et2.getWidgetById('courses');
    var videos = (_this$et3 = this.et2) === null || _this$et3 === void 0 ? void 0 : _this$et3.getWidgetById('videos');
    return {
      course_id: (courses === null || courses === void 0 ? void 0 : courses.get_value()) || ((_this$filter = this.filter) === null || _this$filter === void 0 ? void 0 : _this$filter.course_id),
      video_id: videos !== null && videos !== void 0 && videos.get_value ? videos.get_value() : (_this$filter2 = this.filter) === null || _this$filter2 === void 0 ? void 0 : _this$filter2.video_id
    };
  }

  /**
   * apply group filter
   * @param _node
   * @param _widget
   */
  student_filterGroup(_node, _widget) {
    var rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode());
    var ids = [];
    var accounts = this.et2.getArrayMgr('sel_options').getEntry('account_id');
    var comments = this.et2.getArrayMgr('content').getEntry('comments');
    var group = _widget.get_value();
    rows.each(function () {
      var _found;
      var id = this.classList.value.match(/commentID.*[0-9]/)[0].replace('commentID', '');
      var found = [];
      var comment = comments.filter(_item => {
        return _item.comment_id == id;
      });
      if (comment && comment.length > 0) {
        var account_id = comment[0]['account_id'];
        found = accounts.filter(_item => {
          if (_item.value == account_id) {
            switch (group) {
              case 'unsub':
                return !_item.active;
              case 'sub':
                return _item.active;
              default:
                return _item.group == group || _item.group == null || typeof _item.group == 'undefined';
            }
          }
          return false;
        });
      }
      if (((_found = found) === null || _found === void 0 ? void 0 : _found.length) > 0 || group == '') ids.push(id);
    });
    if ((group == 'unsub' || group == 'sub') && ids.length == 0) ids = ['ALL'];
    this._student_commentsFiltering('group', ids);
  }

  /**
   * Apply (changed) comment filter by marking
   *
   * Filter is applied by hiding filtered rows client-side
   */
  _student_filterMarked(_state) {
    var rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode()).filter('.commentMarked');
    var ids = [];
    rows.each((i, item) => {
      var _item$classList$value;
      ids.push((_item$classList$value = item.classList.value.match(/commentID.*[0-9]/)) === null || _item$classList$value === void 0 ? void 0 : _item$classList$value[0].replace('commentID', ''));
    });
    this._student_commentsFiltering('marked', _state ? ids : []);
  }

  /**
   * Apply (changed) comment filter by attachments
   *
   * Filter is applied by hiding filtered rows client-side
   */
  _student_filterAttachments(_state) {
    var rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode()).filter('.commentAttachments');
    var ids = [];
    rows.each((i, item) => {
      var _item$classList$value2;
      ids.push((_item$classList$value2 = item.classList.value.match(/commentID.*[0-9]/)) === null || _item$classList$value2 === void 0 ? void 0 : _item$classList$value2[0].replace('commentID', ''));
    });
    if (ids.length == 0 && _state) {
      ids = ['ALL'];
    }
    this._student_commentsFiltering('attachments', _state ? ids : []);
  }

  /**
   * Apply cats filter
   * @param _event
   * @param _widget
   */
  student_catsFilter(_event, _widget) {
    var rows = [];
    var ids = [];
    _widget.value.forEach(_v => {
      rows = rows.concat([...this.et2.getWidgetById('comments').getDOMNode().getElementsByClassName('cat-' + _v)]);
    });
    rows.forEach(item => {
      var _item$classList$value3;
      ids.push((_item$classList$value3 = item.classList.value.match(/commentID.*[0-9]/)) === null || _item$classList$value3 === void 0 ? void 0 : _item$classList$value3[0].replace('commentID', ''));
    });
    this._student_commentsFiltering('cats', ids.length || !_widget.value.length ? ids : ['ALL']);
  }

  /**
   * Apply (changed) comment filter
   *
   * Filter is applied by hiding filtered rows client-side
   */
  student_filterComments() {
    var _this$et2$getWidgetBy4;
    var value = (_this$et2$getWidgetBy4 = this.et2.getWidgetById('comment_color_filter')) === null || _this$et2$getWidgetBy4 === void 0 ? void 0 : _this$et2$getWidgetBy4.get_value();
    var rows = {};
    if (!value) return;
    switch (value) {
      case 'ac':
        rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode()).filter(':not(.cat-lf, .cat-lfc)');
        break;
      case 'lf':
        rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode()).filter('.cat-lf, .cat-lfc');
        break;
      case 'all':
        rows = jQuery('');
        break;
      case 'new':
        debugger;
        var lastUpdated = new Date(this.et2.getArrayMgr("content").getEntry("video[last_updated][date]"));
        rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode()).filter(function () {
          var _this$classList$value2, _app$smallpart$commen;
          var commentID = (_this$classList$value2 = this.classList.value.match(/commentID.*[0-9]/)) === null || _this$classList$value2 === void 0 ? void 0 : _this$classList$value2[0].replace('commentID', '');
          var comment = (_app$smallpart$commen = app.smallpart.comments.find(_item => _item.comment_id == commentID)) !== null && _app$smallpart$commen !== void 0 ? _app$smallpart$commen : null;
          if (!commentID || !comment) {
            return false;
          }
          return new Date(comment.comment_updated.date) > lastUpdated;
        });
        break;
    }
    var ids = [];
    rows.each((i, item) => {
      var _item$classList$value4;
      ids.push((_item$classList$value4 = item.classList.value.match(/commentID.*[0-9]/)) === null || _item$classList$value4 === void 0 ? void 0 : _item$classList$value4[0].replace('commentID', ''));
    });
    this._student_commentsFiltering('color', ids.length ? ids : value !== "all" ? ['ALL'] : []);
  }
  student_clearFilter() {
    this.et2.getWidgetById('comment_color_filter').set_value("all");
    this.et2.getWidgetById('comment_search_filter').set_value("");
    this.et2.getWidgetById('activeParticipantsFilter').set_value("");
    this.et2.getWidgetById('group').set_value("");
    this.et2.getDOMWidgetById('comment_date_filter').set_value({
      from: null,
      to: null
    });
    this.et2.getDOMWidgetById('comment_cats_filter').value = [];
    for (var f in this.filters) {
      this._student_commentsFiltering(f, []);
    }
  }
  student_searchFilter(_event, _widget) {
    var query = _widget.get_value();
    var rows = jQuery(smallpartApp.commentRowsQuery, this.et2.getWidgetById('comments').getDOMNode());
    var ids = [];
    var filter_toolbar = this.et2.getDOMWidgetById('filter-toolbar');
    rows.each(function () {
      jQuery.extend(jQuery.expr[':'].containsCaseInsensitive = function (a, i, m) {
        var t = a.textContent || a.innerText || "";
        var reg = new RegExp(m[3], 'i');
        return reg.test(t) && (!filter_toolbar._actionManager.getActionById('searchall').checked ? a.classList.contains('et2_smallpart_comment') : true);
      });
      if (query != '' && jQuery(this).find('*:containsCaseInsensitive("' + query + '")').length >= 1) {
        ids.push(this.classList.value.match(/commentID.*[0-9]/)[0].replace('commentID', ''));
      }
    });
    this._student_commentsFiltering('search', ids.length == 0 && query != '' ? ['ALL'] : ids);
  }
  student_onmouseoverFilter(_state) {
    var self = this;
    var videobar = this.et2.getWidgetById('video');
    var comments = jQuery(this.et2.getDOMNode().querySelector(".rightBoxArea"));
    if (_state) {
      comments.on('mouseenter', function () {
        var _self$edited2;
        if (self.et2.getWidgetById('play').image == "pause-fill" && (!self.edited || ((_self$edited2 = self.edited) === null || _self$edited2 === void 0 ? void 0 : _self$edited2.action) != 'edit')) videobar.pause_video();
      }).on('mouseleave', function () {
        var _self$edited3;
        if (self.et2.getWidgetById('play').image == "pause-fill" && (!self.edited || ((_self$edited3 = self.edited) === null || _self$edited3 === void 0 ? void 0 : _self$edited3.action) != 'edit')) videobar.play();
      });
    } else {
      comments.off('mouseenter mouseleave');
    }
  }

  /**
   *
   *
   * @param _comments
   */
  setCommentsSlider(_comments) {
    var comments_slider = this.et2.getDOMWidgetById('comments_slider');
    var account_ids = this.et2.getArrayMgr('sel_options').data.account_id;
    var cats = this.et2.getArrayMgr('sel_options').getEntry('catsOptions');
    comments_slider.set_value(_comments === null || _comments === void 0 ? void 0 : _comments.map(_item => {
      var cat = cats.filter(_cat => {
        var _item$comment_cat;
        return _cat.value == (_item === null || _item === void 0 || (_item$comment_cat = _item.comment_cat) === null || _item$comment_cat === void 0 ? void 0 : _item$comment_cat.split(":")[0]);
      }) || [];
      return {
        id: _item.comment_id,
        starttime: _item.comment_starttime,
        duration: _item.comment_stoptime - _item.comment_starttime,
        color: cat.length > 0 ? cat[0].color : '#FFFFFF',
        account_id: _item.account_id
      };
    }).filter(_item => {
      return _item.id && account_ids.find(_id => {
        return _item.account_id == _id.value && _id.role > 0;
      });
    }));
  }

  /**
   * Update comments
   *
   * @param _data see et2_grid.set_value
   */
  student_updateComments(_data) {
    var _this$et2$getWidgetBy5, _this$comments;
    // update our internal data
    this.comments = _data.content;

    // the first index (an empty array) in comments is reserved for action grid therefore ignore it.
    (_this$et2$getWidgetBy5 = this.et2.getWidgetById('smallpart.student.comments_list')) === null || _this$et2$getWidgetBy5 === void 0 || (_this$et2$getWidgetBy5 = _this$et2$getWidgetBy5.getParent()) === null || _this$et2$getWidgetBy5 === void 0 || _this$et2$getWidgetBy5.set_disabled(((_this$comments = this.comments) === null || _this$comments === void 0 ? void 0 : _this$comments.length) <= 1);

    // update grid
    var comments = this.et2.getWidgetById('comments');
    comments === null || comments === void 0 || comments.set_value(_data);

    // Turn on tab
    if (comments) {
      comments.getDOMNode().closest("et2-tabbox").querySelector("[panel='comment']").disabled = false;
      comments.getDOMNode().closest("et2-tab-panel").disabled = false;
    }

    // update slider-tags
    var videobar = this.et2.getWidgetById('video');
    videobar === null || videobar === void 0 || videobar.set_slider_tags(this.comments);

    // update comments slider
    this.setCommentsSlider(this.comments);

    // re-apply the filter, if not "all"
    var applyFilter = false;
    ['comment_color_filter', 'comment_search_filter', 'group', 'comment_date_filter'].forEach(_id => {
      var _this$et2$getWidgetBy6;
      if ((_this$et2$getWidgetBy6 = this.et2.getWidgetById(_id)) !== null && _this$et2$getWidgetBy6 !== void 0 && _this$et2$getWidgetBy6.get_value()) applyFilter = true;
    });
    if (applyFilter) this.student_filterComments();
    this._student_setFilterParticipantsOptions();
  }
  student_revertMarks(_event, _widget) {
    var videobar = this.et2.getWidgetById('video');
    videobar.setMarks(this.edited.comment_marked);
    this._student_controlCommentAreaButtons(true);
  }
  student_hideBackground(_node, _widget) {
    var videobar = this.et2.getWidgetById('video');
    videobar.setMarkingMask(_widget.getValue() != "");
  }
  student_hideMarkedArea(_node, _widget) {
    var videobar = this.et2.getWidgetById('video');
    var is_readonly = !_widget.getValue();
    videobar.setMarksState(!is_readonly);
    var ids = ['markedColorRadio', 'revertMarks', 'deleteMarks', 'backgroundColorTransparency'];
    for (var i in ids) {
      var widget = this.commentGrid.getWidgetById(ids[i]);
      var state = is_readonly;
      if (widget && typeof widget.set_readonly == "function") {
        switch (ids[i]) {
          case 'revertMarks':
            state = is_readonly ? is_readonly : !(!this.edited.comment_marked && videobar.getMarks().length > 0 || this.edited.comment_marked && videobar.getMarks().length > 0 && this.edited.comment_marked.length != videobar.getMarks().length);
            break;
          case 'deleteMarks':
            state = is_readonly ? is_readonly : !(this.edited.comment_marked || videobar.getMarks().length > 0);
            break;
          case 'backgroundColorTransparency':
            widget.disabled = state;
            widget.value = !state;
            videobar.setMarkingMask(!state);
        }
        widget.set_readonly(state);
      }
    }
  }
  student_deleteMarks() {
    var videobar = this.et2.getWidgetById('video');
    videobar.removeMarks();
    this._student_controlCommentAreaButtons(true);
  }
  student_setMarkingColor(_input, _widget) {
    var videobar = this.et2.getWidgetById('video');
    videobar.set_marking_color(_widget.get_value());
  }
  student_sliderOnClick(_video) {
    // record, in case we're playing
    this.record_watched(_video.previousTime());
    if (!_video.paused()) this.start_watching();
    this.et2.getWidgetById('play').getDOMNode().classList.remove('bi-arrow-clockwise');
  }
  student_comments_column_switch(_node, _widget) {
    var comments = this.et2.getDOMWidgetById('comments');
    if (!_widget.getValue()) {
      comments.set_class('hide_column');
      this.egw.set_preference('smallpart', 'comments_column_state', 0);
    } else {
      this.egw.set_preference('smallpart', 'comments_column_state', 1);
      comments.set_class('');
      comments.getDOMNode().classList.remove('hide_column');
    }
  }
  _student_controlCommentAreaButtons(_state) {
    var readonlys = ['revertMarks', 'deleteMarks'];
    for (var i in readonlys) {
      var widget = this.commentGrid.getWidgetById(readonlys[i]);
      if (readonlys[i] == 'deleteMarks') {
        var _this$et2$getWidgetBy7;
        _state = _state ? (_this$et2$getWidgetBy7 = !this.et2.getWidgetById('video').getMarks().length) !== null && _this$et2$getWidgetBy7 !== void 0 ? _this$et2$getWidgetBy7 : false : _state;
      } else if (this.edited.comment_marked) {
        //
      }
      if (widget !== null && widget !== void 0 && widget.set_readonly) widget.set_readonly(_state);
    }
  }

  /**
   * filters comments
   *
   * @param _filter filter name
   * @param _value array comment ids to be filtered, given array of['ALL']
   * makes all rows hiden and empty array reset the filter.
   */
  _student_commentsFiltering(_filter, _value) {
    var _this = this;
    var rows = this.et2.getWidgetById('comments').getDOMNode().querySelectorAll(smallpartApp.commentRowsQuery);
    var tags = Array.from(document.querySelectorAll('.videobar_slider span.commentOnSlider')).concat(Array.from(document.querySelectorAll('.et2_smallpart-videooverlay-slider-controller et2-description')));
    var self = this;
    if (_filter && _value) {
      this.filters[_filter] = _value;
    } else {
      delete this.filters[_filter];
    }
    for (var f in this.filters) {
      for (var c in this.comments) {
        var _this$filters$f;
        if (!this.comments[c] || this.comments[c].length == 0) continue;
        if (typeof this.comments[c].filtered == 'undefined') this.comments[c].filtered = [];
        if (((_this$filters$f = this.filters[f]) === null || _this$filters$f === void 0 ? void 0 : _this$filters$f.length) > 0) {
          if (this.comments[c].filtered.indexOf(f) != -1) this.comments[c].filtered.splice(this.comments[c].filtered.indexOf(f), 1);
          if (this.filters[f].indexOf(this.comments[c].comment_id) == -1 || this.filters[f][0] === "ALL") {
            this.comments[c].filtered.push(f);
          }
        } else {
          if (this.comments[c].filtered.indexOf(f) != -1) this.comments[c].filtered.splice(this.comments[c].filtered.indexOf(f), 1);
        }
      }
    }
    var _loop = function _loop(i) {
      if (!_this.comments[i] || _this.comments[i].length == 0) return 1; // continue
      if (_this.comments[i].filtered.length > 0) {
        rows.forEach(_row => {
          if (_row.classList.contains("commentID".concat(self.comments[i].comment_id))) {
            _row.classList.add('hideme');
          }
        });
        tags.forEach(_tag => {
          var _self$comments$i;
          if (_tag.dataset.id == ((_self$comments$i = self.comments[i]) === null || _self$comments$i === void 0 || (_self$comments$i = _self$comments$i.comment_id) === null || _self$comments$i === void 0 ? void 0 : _self$comments$i.toString())) {
            _tag.classList.add('hideme');
          }
        });
      } else {
        rows.forEach(_row => {
          if (_row.classList.contains("commentID".concat(self.comments[i].comment_id))) {
            _row.classList.remove('hideme');
          }
        });
        tags.forEach(_tag => {
          var _self$comments$i2;
          if (_tag.dataset.id == ((_self$comments$i2 = self.comments[i]) === null || _self$comments$i2 === void 0 || (_self$comments$i2 = _self$comments$i2.comment_id) === null || _self$comments$i2 === void 0 ? void 0 : _self$comments$i2.toString())) {
            _tag.classList.remove('hideme');
          }
        });
      }
    };
    for (var i in this.comments) {
      if (_loop(i)) continue;
    }
  }
  student_filterParticipants(_e, _widget) {
    var values = _widget.getValue();
    var data = [],
      value = [];
    for (var i in values) {
      value = values[i].split(',');
      if (value) data = data.concat(value.filter(x => data.every(y => y !== x)));
    }
    this._student_commentsFiltering('participants', data);
  }
  _student_fetchAccountData(_id, _stack, _options, _resolved) {
    var self = this;
    egw$1.accountData(parseInt(_id), 'account_fullname', null, function (_d) {
      if (Object.keys(_d).length > 0) {
        var id = parseInt(Object.keys(_d)[0]);
        _options[id].label = _d[id];
      }
      egw$1.accountData(_id, 'account_firstname', null, function (_n) {
        if (Object.keys(_n).length > 0) {
          var _id2 = parseInt(Object.keys(_n)[0]);
          _options[_id2].name = _n[_id2] + '[' + _id2 + ']';
          var newId = _stack.pop();
          if (newId) {
            self._student_fetchAccountData(newId, _stack, _options, _resolved);
          } else {
            _resolved(_options);
          }
        }
      }, egw$1(window));
    }, egw$1(window));
  }
  _student_setFilterParticipantsOptions() {
    var activeParticipants = this.et2.getWidgetById('activeParticipantsFilter');
    var passiveParticipantsList = this.et2.getWidgetById('passiveParticipantsList');
    var options = {};
    var participants = this.et2.getArrayMgr('sel_options').getEntry('account_id');
    var staff = this.et2.getArrayMgr('sel_options').getEntry('staff');
    var roles = {};
    staff.forEach(staff => roles[staff.value] = staff.label);
    var _foundInComments = _id => {
      for (var k in this.comments) {
        if (this.comments[k]['account_id'] == _id) return true;
      }
    };
    var _countComments = _id => {
      var c = 0;
      for (var i in this.comments) {
        if (this.comments[i]['account_id'] == _id) c++;
      }
      return c;
    };
    var _getNames = _account_id => {
      for (var p in participants) {
        if (participants[p].value == _account_id) {
          return {
            label: participants[p].label,
            name: roles[participants[p].role] || participants[p].title,
            icon: egw$1.link('/api/avatar.php', {
              account_id: _account_id
            })
          };
        }
      }
      return {
        name: '',
        label: '#' + _account_id,
        icon: egw$1.link('/api/avatar.php', {
          account_id: _account_id
        })
      };
    };
    if (activeParticipants) {
      for (var i in this.comments) {
        if (!this.comments[i] || this.comments[i].length == 0) continue;
        var comment = this.comments[i];
        if (typeof options[comment.account_id] === 'undefined') {
          options[comment.account_id] = _getNames(comment.account_id);
        }
        options[comment.account_id] = jQuery.extend(options[comment.account_id], {
          value: options[comment.account_id] && typeof options[comment.account_id]['value'] != 'undefined' ? options[comment.account_id]['value'].indexOf(comment.comment_id) ? options[comment.account_id]['value'].concat(comment.comment_id) : options[comment.account_id]['value'] : [comment.comment_id],
          comments: _countComments(comment.account_id)
        });
        if (comment.comment_added) {
          for (var j in comment.comment_added) {
            var comment_added = comment.comment_added[j];
            if (Number.isInteger(comment_added)) {
              if (typeof options[comment_added] == 'undefined' && !_foundInComments(comment_added)) {
                options[comment_added] = _getNames(comment_added);
                options[comment_added].value = [comment.comment_id];
              } else if (typeof options[comment_added] == 'undefined') {
                options[comment_added] = _getNames(comment_added);
                options[comment_added].value = [];
              }
              options[comment_added]['retweets'] = options[comment_added]['retweets'] ? options[comment_added]['retweets'] + 1 : 1;
              options[comment_added]['value'] = options[comment_added]['value'].indexOf(comment.comment_id) == -1 ? options[comment_added]['value'].concat(comment.comment_id) : options[comment_added]['value'];
            }
          }
        }
      }
      for (var _i2 in options) {
        var _options$_i;
        if (((_options$_i = options[_i2]) === null || _options$_i === void 0 || (_options$_i = _options$_i.value) === null || _options$_i === void 0 ? void 0 : _options$_i.length) > 0) {
          options[_i2].value = options[_i2].value.join(',');
        }
      }
      // set options after all accounts info are fetched
      activeParticipants.set_select_options(options);
      var passiveParticipants = [{}];
      for (var _i3 in participants) {
        if (!options[participants[_i3].value]) passiveParticipants.push({
          account_id: participants[_i3].value
        });
      }
      passiveParticipantsList.set_value({
        content: passiveParticipants
      });
    }
  }

  /**
   * course- or video-selection changed
   *
   * @param _node
   * @param _widget
   */
  courseSelection(_node, _widget) {
    var _this$et2$getDOMWidge6;
    this.record_watched();

    // remove excessive dialogs left over from previous video selection
    (_this$et2$getDOMWidge6 = this.et2.getDOMWidgetById('videooverlay')) === null || _this$et2$getDOMWidge6 === void 0 || _this$et2$getDOMWidge6.questionDialogs.forEach(_o => {
      _o.dialog.destroy();
    });
    if (_widget.id === 'courses' && _widget.getValue() === 'manage') {
      this.egw.open(null, 'smallpart', 'list', '', '_self');
    } else {
      // sent video_id via hidden text field, in case new video was added on client-side via push (will be ignored by eT2 validation)
      if (_widget.id === 'videos') {
        _widget.getRoot().setValueById('video2', _widget.getValue());
      }
      // submit to server-side
      _widget.getInstanceManager().submit(null, false, true);
    }
    return false;
  }

  /**
   * Execute a server-side action on a course
   *
   * @param _action
   * @param _senders
   * @param _password
   */
  courseAction(_action, _senders, _password) {
    var ids = [];
    _senders.forEach(function (_sender) {
      ids.push(_sender.id.replace('smallpart::', ''));
    });
    switch (_action.id) {
      case 'subscribe':
      case 'open':
        this.egw.open(ids[0], 'smallpart', 'view', {
          cd: "no"
        }, '_self');
        break;
      default:
        this.egw.json('smallpart.\\EGroupware\\SmallParT\\Courses.ajax_action', [_action.id, ids, false, _password]).sendRequest();
        break;
    }
  }

  /**
   * Distribute course-groups
   *
   * @param _node
   * @param _widget
   */
  changeCourseGroups(_node, _widget) {
    var _widget$getParent$get, _widget$getParent$get2, _widget$getRoot$getWi;
    var groups = (_widget$getParent$get = _widget.getParent().getWidgetById('course_groups')) === null || _widget$getParent$get === void 0 ? void 0 : _widget$getParent$get.get_value();
    var mode = (_widget$getParent$get2 = _widget.getParent().getWidgetById('groups_mode')) === null || _widget$getParent$get2 === void 0 ? void 0 : _widget$getParent$get2.get_value();
    if (mode && !groups) {
      Et2Dialog.alert(this.egw.lang('You need to set a number or size first!'));
    }
    (_widget$getRoot$getWi = _widget.getRoot().getWidgetById('tabs')) === null || _widget$getRoot$getWi === void 0 || _widget$getRoot$getWi.setActiveTab(1);
    // unfortunately we can not getWidgetById widgets in an auto-repeated grid
    var content = _widget.getArrayMgr('content').getEntry('participants');
    var values = _widget.getInstanceManager().getValues(_widget.getRoot().getWidgetById('participants')).participants;
    for (var row = 1, student = 0; typeof content[row] === 'object' && content[row] !== null; ++row) {
      content[row] = Object.assign(content[row], values[row] || {});
      var participant = content[row];
      if (participant && participant.participant_unsubscribed !== null) {
        // do not modify unsubscribed participants
      } else if (participant && !parseInt(participant.participant_role) && mode) {
        if (mode.substr(0, 6) === 'number') {
          content[row].participant_group = 1 + student % groups;
        } else {
          content[row].participant_group = 1 + (student / groups | 0);
        }
        ++student;
      } else {
        content[row].participant_group = '';
      }
    }
    _widget.getRoot().getWidgetById('participants').set_value({
      content: content
    });
    // need to run it again, after above set_value, recreating all the widgets
    this.disableGroupByRole();
  }

  /**
   * Disable group selection if a staff-role is selected
   *
   * @param _node
   * @param _widget
   */
  changeRole(_node, _widget) {
    var grid = _widget.getParent();
    var group = grid.getWidgetById(_widget.id.replace('role', 'group'));
    var role = _widget.get_value();
    if (group) {
      if (role !== '0') group.set_value('');
      group.set_disabled(role !== '0');
    }
  }

  /**
   * Disable all group inputs, if a role is set
   */
  disableGroupByRole() {
    var grid = this.et2.getWidgetById('participants');
    for (var role, row = 1; role = grid.getWidgetById('' + row + '[participant_role]'); ++row) {
      if (role.get_value() !== '0') {
        this.changeRole(undefined, role);
      }
    }
  }

  /**
   * Set nickname for user
   */
  changeNickname() {
    var course_id = this.student_getFilter().course_id;
    if (!course_id) return;
    var participants = this.et2.getArrayMgr('sel_options').getEntry('account_id');
    var user = participants.filter(participant => participant.value == this.user).pop();
    Et2Dialog.show_prompt(function (button, nickname) {
      if (button === Et2Dialog.OK_BUTTON && (nickname = nickname.trim()) && nickname !== user.label) {
        var nickname_lc = nickname.toLowerCase();
        if (nickname.match(/\[\d+\]$]/) || participants.filter(participant => participant.label.toLowerCase() === nickname_lc && participant.value != this.user).length) {
          this.egw.message(this.egw.lang('Nickname is already been taken, choose an other one'));
          return this.changeNickname();
        }
        this.egw.request('EGroupware\\SmallPART\\Student\\Ui::ajax_changeNickname', [course_id, nickname]);
      }
    }.bind(this), this.egw.lang('How do you want to be called?'), this.egw.lang('Change nickname'), user.label, Et2Dialog.BUTTONS_OK_CANCEL);
  }

  /**
   * Change nickname in startpage
   *
   * @param nickname
   */
  changeNicknameStartpage(nicknames) {
    if (!this.et2.getInstanceManager().name.match(/smallpart.start/)) return;
    var account_id = this.et2.getWidgetById('account_id');
    this.et2.getArrayMgr('sel_options').data.account_id = nicknames;
    account_id === null || account_id === void 0 || account_id.set_select_options(nicknames);
    account_id === null || account_id === void 0 || account_id.set_value(this.user);
  }

  /**
   * Subscribe or open a course (depending on already subscribed)
   *
   * @param _id
   * @param _subscribed
   */
  openCourse(_id, _subscribed) {
    this.egw.open(_id, 'smallpart', 'view', '', '_self');
  }

  /**
   * Clickhandler to copy given text or widget content to clipboard
   * @param _widget
   * @param _text default widget content
   */
  copyClipboard(_widget, _text, _event) {
    var value = _text || (typeof _widget.get_value === 'function' ? _widget.get_value() : _widget.options.value);
    var node = _widget.getDOMNode() !== _widget ? _widget.getDOMNode() : _widget;
    this.egw.copyTextToClipboard(value, node, _event).then(success => {
      if (success !== false) {
        this.egw.message(this.egw.lang("Copied '%1' to clipboard", value), 'success');
      }
    });
  }

  /**
   * add/remove questions into post/process edit dialog
   *
   * @param _type
   * @param _delete
   * @param _id
   *
   * @todo: fix client-side content update base on actual current grid data
   */
  course_clmTab_addQ(_type, _delete, _id) {
    var clmQuestions = this.et2.getDOMWidgetById('clm[' + _type + '][questions]');
    var data = [];
    clmQuestions.cells.forEach((cell, index) => {
      data.push(index == 0 || !cell[1]['widget']['get_value'] ? [] : {
        id: index,
        q: cell[1]['widget'].get_value(),
        al: cell[2]['widget'].get_value(),
        ar: cell[3]['widget'].get_value()
      });
    });
    if (_delete && _id) {
      data.splice(_id, 1);
    } else {
      data.push({
        id: data.length,
        q: '',
        al: '',
        ar: ''
      });
    }
    clmQuestions.set_value({
      content: jQuery.extend([], data)
    });
  }
  course_enableLiveFeedBack(_node, _widget) {
    var checked = _widget.get_value() == 'true' ? true : false;
    this.et2.getDOMWidgetById('lfbUploadSection').set_disabled(!checked);
  }

  /**
   * onclick callback used in course.xet
   * @param _event
   * @param _widget
   */
  course_addVideo_btn(_event, _widget) {
    var url = this.et2.getWidgetById('video_url');
    var file = this.et2.getWidgetById('upload');
    var name = '';
    var videos = this.et2.getArrayMgr('content').getEntry('videos');
    var warning = false;
    file.getParent().getParent().hidden = true;
    if (url.getValue() != '') {
      var parts = url.getValue().split('/');
      name = parts[parts.length - 1];
    } else if (file.getValue() && Object.values(file.getValue()).length > 0) {
      name = Object.values(file.getValue())[0]['name'];
    }
    for (var i in videos) {
      if (videos[i] && videos[i]['video_name'] == name) {
        warning = true;
      }
    }
    if (warning) {
      Et2Dialog.confirm(_widget, "There's already a video with the same name, would you still like to upload it?", "Duplicate name", false);
    } else {
      _widget.getInstanceManager().submit();
    }
  }
  course_addLivefeedback_btn(_event, _widget) {
    _widget.getRoot().getWidgetById('tabs').value = 'videos';
    var url = this.et2.getWidgetById('video_url');
    var basePath = egw$1.webserverUrl.match(/http/) ? egw$1.webserverUrl : window.location.protocol + '//' + window.location.host + egw$1.webserverUrl;
    url.set_value(basePath + '/smallpart/setup/livefeedback.webm');
    _widget.getInstanceManager().submit();
  }
  course_uploadFinished(event) {
    this.et2.getWidgetById("video").disabled = false;
  }

  /**
   * User has selected a URL or file to replace an existing material
   *
   * @param event
   */
  course_replacementSelected(event) {
    var _getParent$getParent, _event$data;
    debugger;
    // Figure out where this came from
    var source = (_getParent$getParent = ((_event$data = event.data) !== null && _event$data !== void 0 ? _event$data : event.target).getParent().getParent()) !== null && _getParent$getParent !== void 0 ? _getParent$getParent : this.et2;
    // Enable apply button
    var apply = source.getWidgetById("apply_replacement");
    apply.disabled = false;
  }

  /**
   * Applies given action to cats grid
   *
   * @param _id
   * @param _action
   *
   */
  course_catsAction(_id, _action) {
    var cats = this.et2.getDOMWidgetById('cats');
    var arrayMgrs = this.et2.getArrayMgrs();
    var data = cats.getArrayMgr('content').data || [];
    switch (_action) {
      case 'delete':
        var ids = [_id];
        if (!data[_id].parent_id) {
          ids = ids.concat(smallpartApp.course_findSubCatsIndexes(data, data[_id]['cat_id']));
        }
        ids.reverse().forEach(_item => {
          data.splice(_item, 1);
        });
        break;
      case 'sub':
      case 'add':
        var addCat = (_id, _action, _extraData) => {
          var pos;
          if (_action === 'sub') {
            for (pos = _id + 1; pos < data.length && data[pos].parent_id == data[_id].cat_id; ++pos) {}
          } else {
            pos = data.length + 1;
          }
          var add = _objectSpread(_objectSpread({}, {
            cat_id: 'new-' + new Date().valueOf(),
            parent_id: _action == 'sub' ? data[_id]['cat_id'] : null
          }), _extraData);
          add.data = JSON.stringify(add);
          data.splice(pos, 0, add);
          return pos;
        };
        var pos = addCat(_id, _action);
        if (_action === 'add') {
          for (var i = 0; i <= 1; i++) {
            // add fixed predefined lf type cats
            addCat(pos - 1, 'sub', {
              cat_id: 'new-' + new Date().valueOf() + i,
              cat_name: i == 0 ? 'like' : 'dislike',
              value: i == 0 ? 'p' : 'n',
              type: 'lf',
              cat_color: i ? '#FF0000' : '#00FF00'
            });
          }
        }
        break;
    }
    cats.set_value({
      content: jQuery.extend([], data)
    });
    arrayMgrs.content.data['cats'] = data;
    this.et2.setArrayMgrs(arrayMgrs);
  }

  /**
   * helper function to find index of given cat id
   * @param _data
   * @param _cat_id
   */
  static course_findCatIndex(_data) {
    var _cat_id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return _data.findIndex(_item => {
      return _item.cat_id == _cat_id;
    });
  }

  /**
   * helper function to find out indexes of all sub cats of given parent cat id
   * @param _data
   * @param _cat_parent_id
   */
  static course_findSubCatsIndexes(_data) {
    var _cat_parent_id = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    if (!_data || !_cat_parent_id) return [];
    var indexes = [];
    _data.forEach((_item, _i) => {
      if (_item.parent_id == _cat_parent_id) indexes.push(_i);
    });
    return indexes;
  }

  /**
   * User changed one of the available per-course preferences
   *
   * @param ev
   */
  handleCoursePreferenceChange(ev, widget) {
    var _this$et2$getArrayMgr4, _this$et2$getArrayMgr5;
    var course_id = (_this$et2$getArrayMgr4 = (_this$et2$getArrayMgr5 = this.et2.getArrayMgr("content")) === null || _this$et2$getArrayMgr5 === void 0 ? void 0 : _this$et2$getArrayMgr5.getEntry("course_id")) !== null && _this$et2$getArrayMgr4 !== void 0 ? _this$et2$getArrayMgr4 : "";
    if (course_id) {
      widget.select_options.forEach(item => {
        this.egw.set_preference('smallpart', 'course_' + course_id + "_" + item.value, widget.value.includes(item.value) ? true : 0);
      });
    }
  }

  /**
   * Called when student started watching a video
   */
  start_watching() {
    if (!(this.course_options & 1)) return; // not recording watched videos for this course

    var videobar = this.et2.getWidgetById('video');
    if (typeof this.watching === 'undefined' && videobar) {
      this.watching = this.student_getFilter();
      this.watching.starttime = new Date();
      this.watching.position = videobar.currentTime();
      this.watching.paused = 0;
    } else {
      this.watching.paused++;
    }
  }

  /**
   * Called when student finished watching a video
   *
   * @param _time optional video-time, default videobar.currentTime()
   */
  record_watched(_time) {
    var _this$et4;
    if (!(this.course_options & 1)) return; // not recording watched videos for this course

    var videobar = (_this$et4 = this.et2) === null || _this$et4 === void 0 ? void 0 : _this$et4.getWidgetById('video');
    if (typeof this.watching === 'undefined')
      // video not playing, nothing to record
      {
        return;
      }
    this.watching.endtime = new Date();
    this.watching.duration = (_time || (videobar === null || videobar === void 0 ? void 0 : videobar.currentTime())) - this.watching.position;

    //console.log(this.watching);
    this.egw.json('smallpart.EGroupware\\SmallParT\\Student\\Ui.ajax_recordWatched', [this.watching]).sendRequest('keepalive');

    // reset recording
    delete this.watching;
  }

  /**
   * Record video & position to restore it
   */
  set_video_position() {
    var _this$et5;
    var videobar = (_this$et5 = this.et2) === null || _this$et5 === void 0 ? void 0 : _this$et5.getWidgetById('video');
    var data = this.student_getFilter();
    if (videobar && typeof (videobar === null || videobar === void 0 ? void 0 : videobar.currentTime()) == "number") {
      data.position = videobar === null || videobar === void 0 ? void 0 : videobar.currentTime();
    }
    if (data.video_id) {
      //console.log('set_video_position', data);
      this.egw.json('smallpart.EGroupware\\SmallParT\\Student\\Ui.ajax_setLastVideo', [data]).sendRequest('keepalive');
    }
  }

  /**
   * Confirm import should overwrite whole course or just add videos
   */
  confirmOverwrite(_ev, _widget, _node) {
    var widget = _widget;
    // if we have no course_id / add used, no need to confirm overwrite
    if (!widget.getArrayMgr('content').getEntry('course_id')) {
      widget.getInstanceManager().submit(widget, true, true);
      return;
    }
    var dialog = new Et2Dialog(this.egw);
    dialog.transformAttributes({
      callback: function callback(_button) {
        if (_button !== "cancel") {
          widget.getRoot().setValueById('import_overwrite', _button === "overwrite");
          widget.getInstanceManager().submit(widget, true, true); // last true = no validation
        }
      },
      buttons: [{
        label: this.egw.lang("Add videos"),
        id: "add",
        class: "ui-priority-primary",
        default: true
      }, {
        label: this.egw.lang("Overwrite course"),
        id: "overwrite",
        image: "delete"
      }, {
        label: this.egw.lang("Cancel"),
        id: "cancel",
        class: "ui-state-error"
      }],
      title: this.egw.lang('Overwrite exiting course?'),
      message: this.egw.lang('Just add videos, or overwrite whole course?'),
      icon: Et2Dialog.QUESTION_MESSAGE
    });
    document.body.appendChild(dialog);
  }

  /**
   * Number of checked siblings
   */
  childrenChecked(_widget) {
    var answered = 0;
    _widget.iterateOver(function (_checkbox) {
      if (_checkbox.get_value()) ++answered;
    }, this, et2_checkbox);
    return answered;
  }

  /**
   * OnChange for multiple choice checkboxes to implement max_answers / max. number of checked answers
   */
  checkMaxAnswers(_ev, _widget, _node) {
    var max_answers = _widget.getRoot().getArrayMgr('content').getEntry('max_answers');
    try {
      max_answers = _widget.getRoot().getValueById('max_answers');
    } catch (e) {}
    if (max_answers) {
      var checked = this.childrenChecked(_widget.getParent());
      // for dialog method is not called on load, therefore it can happen that already max_answers are checked
      if (checked > max_answers) {
        _widget.set_value(false);
        checked--;
      }
      _widget.getParent().iterateOver(function (_checkbox) {
        if (!_checkbox.get_value()) {
          _checkbox.set_readonly(checked >= max_answers);
        }
      }, this, et2_checkbox);
    }
  }
  /**
   * Check min. number of multiplechoice answers are given, before allowing to submit
   */
  checkMinAnswers(_ev, _widget, _node) {
    var contentMgr = _widget.getRoot().getArrayMgr('content');
    var min_answers = contentMgr.getEntry('min_answers');
    if (this.checkMinAnswer_error) {
      this.checkMinAnswer_error.close();
      this.checkMinAnswer_error = null;
    }
    if (min_answers && contentMgr.getEntry('overlay_type') === 'smallpart-question-multiplechoice') {
      var checked = this.childrenChecked(this.et2.getWidgetById('answers'));
      if (checked < min_answers) {
        this.checkMinAnswer_error = this.egw.message(this.egw.lang('A minimum of %1 answers need to be checked!', min_answers), 'error');
        return false;
      }
    }
    _widget.getInstanceManager().submit(_widget);
  }

  /**
   * Calculate blur-text for answer specific points of multiple choice questions
   *
   * For assessment-method score per answer, and no explicit points given, the max_points are equally divided on the answers.
   *
   * @param _ev
   * @param _widget
   * @param _node
   */
  defaultPoints(_ev, _widget, _node) {
    var method;
    try {
      method = this.et2.getValueById('assessment_method');
    } catch (e) {
      return; // eg. text question
    }
    var max_score = parseFloat(this.et2.getValueById('max_score'));
    var question_type = this.et2.getValueById('overlay_type');
    if (method === 'all_correct' || question_type !== 'smallpart-question-multiplechoice') {
      jQuery('.scoreCol').hide();
    } else {
      var explicit_points = 0,
        explicit_set = 0,
        num_answers = 0;
      for (var i = 1, w = null; w = this.et2.getWidgetById('' + i + '[score]'); ++i) {
        // ignore empty questions
        if (!this.et2.getValueById('' + i + '[answer]')) continue;
        var val = parseFloat(w.getValue());
        if (!isNaN(val)) {
          ++explicit_set;
          if (val > 0) explicit_points += val;
        }
        ++num_answers;
      }
      var default_points = ((max_score - explicit_points) / (num_answers - explicit_set)).toFixed(2);
      for (var _i4 = 1, _w2 = null; _w2 = this.et2.getWidgetById('' + _i4 + '[score]'); ++_i4) {
        // ignore empty questions
        if (!this.et2.getValueById('' + _i4 + '[answer]')) continue;
        _w2.set_blur(default_points);
      }
      jQuery('.scoreCol').show();
    }
  }

  /**
   * Pause test by submitting it to server incl. current video position
   *
   * @param _ev
   * @param _widget
   * @param _node
   */
  pauseTest(_ev, _widget, _node) {
    var videobar = this.et2.getWidgetById('video');
    var videotime = this.et2.getInputWidgetById('video_time');
    if (videotime) videotime.set_value(videobar.currentTime());

    //disable the masking
    this._student_noneTestAreaMasking(false);
    var timer = this.et2.getDOMWidgetById('timer');
    // reset the alarms while the test is paused
    timer.options.alarm = [];
    var clml = this.et2.getDOMWidgetById('clm-l');
    if (clml) clml.stop();
    _widget.getInstanceManager().submit(_widget);
  }

  /**
   * Link question start-time, duration and end-time
   *
   * @param _ev
   * @param _widget
   * @param _node
   */
  questionTime(_ev, _widget, _node) {
    var start = this.et2.getInputWidgetById('overlay_start');
    var duration = this.et2.getInputWidgetById('overlay_duration');
    var end = this.et2.getInputWidgetById('overlay_end');
    var apply = this.et2.getDOMWidgetById('button[apply]');
    var save = this.et2.getDOMWidgetById('button[save]');
    if (!start || !duration || !end) return; // eg. not editable
    if (_widget === end) {
      duration.set_value(parseInt(end.get_value()) - parseInt(start.get_value()));
    } else {
      var video = this.et2.getWidgetById("video_data_helper");
      if (video && video.duration() < parseInt(start.get_value()) + parseInt(duration.get_value())) {
        end.set_value(Math.floor(video.duration()));
        end.set_validation_error(egw$1.lang('Lenght of question cannot exceed the lenght of video %1', end._convert_to_display(end.get_value()).value));
        save === null || save === void 0 || save.set_readonly(true);
        apply === null || apply === void 0 || apply.set_readonly(true);
      } else {
        end.set_validation_error(false);
        save === null || save === void 0 || save.set_readonly(false);
        apply === null || apply === void 0 || apply.set_readonly(false);
      }
      end.set_value(parseInt(start.get_value()) + parseInt(duration.get_value()));
    }
  }

  /**
   * Show individual questions and answers of an account_id eg. to assess them
   */
  showQuestions(_action, _senders) {
    this.egw.open('', 'smallpart-overlay', 'list', {
      course_id: this.et2.getArrayMgr('content').getEntry('nm[col_filter][course_id]'),
      video_id: this.et2.getValueById('filter'),
      account_id: _senders[0].id.split('::')[1]
    }, '_self');
  }

  /**
   * Check if we edit a mark or mill-out questions and load the existing markings
   */
  setMarkings() {
    var _window$opener;
    var videobar = (_window$opener = window.opener) === null || _window$opener === void 0 || (_window$opener = _window$opener.app) === null || _window$opener === void 0 || (_window$opener = _window$opener.smallpart) === null || _window$opener === void 0 || (_window$opener = _window$opener.et2) === null || _window$opener === void 0 ? void 0 : _window$opener.getWidgetById('video');
    var marks = this.et2.getWidgetById('marks');
    if (!videobar || !marks) return; // eg. called from the list or no mark or mill-out question

    var mark_values = JSON.parse(marks.getValue() || '[]');
    videobar.setMarks(MarkArea.colorDisjunctiveAreas(mark_values, videobar.get_marking_colors()));
    videobar.set_marking_enabled(true, mark => console.log(mark));
    videobar.set_marking_readonly(true);
    videobar.setMarkingMask(mark_values.length > 0);

    // store marks before saving in hidden var again
    ['button[save]', 'button[apply]'].forEach(name => {
      var button = this.et2.getWidgetById(name);
      if (button) {
        button.onclick = e => {
          marks.set_value(JSON.stringify(MarkArea.markDisjunctiveAreas(videobar.getMarks(true), videobar.video.width() / videobar.video.height())));
          return true;
        };
      }
    });

    // clear marks before unloading
    window.addEventListener("beforeunload", () => {
      videobar.setMarks([]);
      videobar.set_marking_readonly(true);
      videobar.setMarkingMask(false);
    });
  }

  /**
   * Mark the answer area of a question
   *
   * @param _ev
   * @param _widget
   * @param _node
   */
  markAnswer(_ev, _widget, _node) {
    var _window$opener2;
    var videobar = ((_window$opener2 = window.opener) === null || _window$opener2 === void 0 || (_window$opener2 = _window$opener2.app) === null || _window$opener2 === void 0 || (_window$opener2 = _window$opener2.smallpart) === null || _window$opener2 === void 0 || (_window$opener2 = _window$opener2.et2) === null || _window$opener2 === void 0 ? void 0 : _window$opener2.getWidgetById('video')) || this.et2.getWidgetById('video');
    if (!videobar) {
      this.egw.message(this.egw.lang('You have to open the question from the video, to be able to mark answers!', 'error'));
      return;
    }
    videobar.set_marking_color(parseInt(_widget.options.set_value));
    videobar.set_marking_readonly(false);
    videobar.set_marking_enabled(true, mark => {
      var mark_values = MarkArea.markDisjunctiveAreas(videobar.getMarks(true), videobar.video.width() / videobar.video.height());
      videobar.setMarks(MarkArea.colorDisjunctiveAreas(mark_values, videobar.get_marking_colors()));
    });
    videobar.setMarksState(true);
    videobar.setMarkingMask(true);

    // mark current row as active and unmark all others
    var tr = jQuery(_widget.parentNode).closest('tr');
    tr.siblings().removeClass('markActiveRow');
    tr.addClass('markActiveRow');
  }

  /**
   * Close LTI platform iframe
   */
  ltiClose() {
    (window.opener || window.parent).postMessage({
      subject: 'org.imsglobal.lti.close'
    }, '*');
    return true;
  }

  /**
   * Show video in LTI content selection
   *
   * @param _node
   * @param _widget
   */
  ltiVideoSelection(_node, _widget) {
    var video = this.et2.getWidgetById('video');
    var video_id = _widget.getValue();
    if (video_id) {
      var videos = this.et2.getArrayMgr('content').getEntry('videos');
      if (typeof videos[video_id] !== 'undefined') {
        video.set_src_type('video/' + videos[video_id].video_type);
        video.set_src(videos[video_id].video_src);
        video.set_disabled(false);
      }
    } else {
      video.set_disabled(true);
    }
  }
  livefeedback_timerStart(_widget, _state) {
    var content = this.et2.getArrayMgr('content');
    var lf_recorder = this.et2.getWidgetById('lf_recorder');
    var lf_report = this.et2.getWidgetById('lf_report');
    var autoUpload = this.et2.getDOMWidgetById('autoUpload');
    autoUpload.disabled = true;
    _widget.label = '';
    document.getElementsByClassName('commentEditArea')[1].hidden = false;
    lf_recorder.record().then(() => {
      var _content$getEntry17, _content$getEntry18;
      this.egw.request('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_livefeedbackSession', [true, {
        'course_id': (_content$getEntry17 = content.getEntry('video')) === null || _content$getEntry17 === void 0 ? void 0 : _content$getEntry17.course_id,
        'video_id': (_content$getEntry18 = content.getEntry('video')) === null || _content$getEntry18 === void 0 ? void 0 : _content$getEntry18.video_id
      }]).then(_data => {
        if ((_data === null || _data === void 0 ? void 0 : _data.session) == "started") {
          lf_report.sessionStartTime = 0;
          lf_recorder.disableMediaSelectors = true;
          document.querySelector('.video_list').classList.add('disabled');
        }
      });
    });
  }
  livefeedback_timerOnPulse(_widget) {
    var lf_report = this.et2.getWidgetById('lf_report');
    lf_report.sessionEndTime = _widget.timer;
    if (this.comments.length > 1) {
      window.setTimeout(() => {
        lf_report.comments = this.comments;
      }, 10000);
    }
  }
  livefeedback_timerStop(_widget, _state) {
    var content = this.et2.getArrayMgr('content');
    var self = this;
    _widget._resetClick();
    var lf_recorder = this.et2.getWidgetById('lf_recorder');
    lf_recorder.stop().then(() => {
      var _content$getEntry19, _content$getEntry20;
      this.egw.request('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_livefeedbackSession', [false, {
        'course_id': (_content$getEntry19 = content.getEntry('video')) === null || _content$getEntry19 === void 0 ? void 0 : _content$getEntry19.course_id,
        'video_id': (_content$getEntry20 = content.getEntry('video')) === null || _content$getEntry20 === void 0 ? void 0 : _content$getEntry20.video_id
      }]).then(_data => {
        self.egw.message(_data === null || _data === void 0 ? void 0 : _data.msg);
        if ((_data === null || _data === void 0 ? void 0 : _data.session) === 'ended') {
          var warning = self.egw.lang('PLEASE DO NOT RELOAD THE PAGE WHILE VIDEO CHUNKS ARE BEING UPLOADED ...');
          self.egw.loading_prompt(lf_recorder.id, true, warning, null);
          lf_recorder.uploadingIsfinished().then(() => {
            self.egw.message(self.egw.lang("Video is successfully uploaded."));
            self.egw.loading_prompt(lf_recorder.id, false);
            var dialog = new Et2Dialog(self.egw);
            dialog.transformAttributes({
              callback: function callback(_button) {
                if (_button == "submit") {
                  // re-initiate the recorded video
                  self.et2.getWidgetById('video').video.load();
                  self.et2.getInstanceManager().submit();
                  return true;
                }
                lf_recorder.download();
                return false;
              },
              buttons: [{
                label: this.egw.lang("Close"),
                id: "submit",
                image: "check",
                class: "ui-priority-primary",
                default: true
              }, {
                label: this.egw.lang("Download before closing"),
                id: "download",
                image: "download"
              }],
              title: this.egw.lang('Session Status'),
              message: this.egw.lang('Session has been successfully recorded.'),
              noCloseButton: true,
              hideOnEscape: false,
              isModal: true
            });
            document.body.appendChild(dialog);
            document.querySelector('.video_list').classList.remove('disabled');
            lf_recorder.disableMediaSelectors = false;
          });
        }
      });
    });
  }
  livefeedback_autoUpload(_ev, _widget) {
    var recorder = this.et2.getWidgetById('lf_recorder');
    recorder.autoUpload = _widget.value;
  }
  livefeedback_sessionRefreshed(_data) {
    self.egw.message(_data.msg);
    if (_data.session === 'ended') {
      self.et2.getInstanceManager().submit();
    }
  }

  /**
   * Teachers take longer to submit feedback, so we store the start time
   *
   * @param _event
   * @param _widget
   */
  teacher_livefeedbackSubCatClick(_event, _widget) {
    var _this$et2$getDOMWidge7, _this$et2$getDOMWidge8;
    var content = this.et2.getArrayMgr('content');
    var parentCatId = _widget.id.split(':')[0];
    var description = this.et2.getDOMWidgetById(parentCatId + ':comment');
    var timer = (_this$et2$getDOMWidge7 = (_this$et2$getDOMWidge8 = this.et2.getDOMWidgetById('lf_timer')) === null || _this$et2$getDOMWidge8 === void 0 ? void 0 : _this$et2$getDOMWidge8.value) !== null && _this$et2$getDOMWidge7 !== void 0 ? _this$et2$getDOMWidge7 : "";
    var mark = this.et2.getDOMWidgetById("mark_time");
    if (description && mark && !mark.dataset.time) {
      this.livefeedbackMarkTime(true);
    }
  }
  livefeedbackMarkTime(force, clearTimer) {
    var _this$et2$getDOMWidge9, _this$et2$getDOMWidge0;
    var content = this.et2.getArrayMgr('content');
    var time = (_this$et2$getDOMWidge9 = (_this$et2$getDOMWidge0 = this.et2.getDOMWidgetById("lf_timer")) === null || _this$et2$getDOMWidge0 === void 0 ? void 0 : _this$et2$getDOMWidge0.value) !== null && _this$et2$getDOMWidge9 !== void 0 ? _this$et2$getDOMWidge9 : "";
    var mark = this.et2.getDOMWidgetById("flag");
    if (force || typeof force == "undefined" && mark && !mark.value && time) {
      var _content$getEntry$liv;
      mark.markTime(parseInt(time) || 0, clearTimer ? (_content$getEntry$liv = content.getEntry('video')['livefeedback']['session_interval']) !== null && _content$getEntry$liv !== void 0 ? _content$getEntry$liv : 2 : 0);
    }
  }
  teacher_livefeedbackCommentClick(_event, _widget) {
    var _this2 = this;
    return _asyncToGenerator(function* () {
      // Set timestamp if not yet set
      var mark = _this2.et2.getDOMWidgetById("flag");
      var dialog = _widget.parentNode.querySelector('et2-dialog');
      var clearTimer = !!mark.value;

      // If timer is counting down to clear, stop
      mark.cancelClear();
      _this2.livefeedbackMarkTime(undefined, clearTimer);
      if (dialog) {
        yield dialog.show();
        var [button, value] = yield dialog.getComplete();

        // This is only used for the meta-comment, category comments don't set button but
        // use their own callback
        if (button) {
          _this2.livefeedbackCommentSubmit(dialog, dialog.querySelector("[id*=':comment']"), "free");
        } else if (!clearTimer) {
          // If time was flagged automatically (no timer) clear it immediately
          mark.clearMark();
        }
      }
    })();
  }
  livefeedbackCatDialogHandler(event) {
    var _dialog$parentElement, _dialog$parentElement2, _cat_widget$_getOptio, _cat$data;
    var dialog = event.composedPath().find(t => t.tagName == "ET2-DIALOG");
    var originalCatButton = (_dialog$parentElement = dialog === null || dialog === void 0 || (_dialog$parentElement2 = dialog.parentElement) === null || _dialog$parentElement2 === void 0 ? void 0 : _dialog$parentElement2.getWidgetById(event.target.id.replace("dialog_", ""))) !== null && _dialog$parentElement !== void 0 ? _dialog$parentElement : null;
    var cat_widget = typeof event.target._getOptions == "function" ? event.target : originalCatButton;
    var cat = cat_widget && cat_widget._getOptions ? (_cat_widget$_getOptio = cat_widget === null || cat_widget === void 0 ? void 0 : cat_widget._getOptions().find(o => o.value == cat_widget.value)) !== null && _cat_widget$_getOptio !== void 0 ? _cat_widget$_getOptio : {} : {};
    var cat_string = [originalCatButton.id.split(":").shift()];
    var timer = this.et2.getDOMWidgetById(cat_string[0] + ':timer');
    if ((cat === null || cat === void 0 ? void 0 : cat.parent_id) != (cat === null || cat === void 0 ? void 0 : cat.value)) {
      cat_string.push(cat.value);
    }
    if ((cat === null || cat === void 0 || (_cat$data = cat.data) === null || _cat$data === void 0 ? void 0 : _cat$data.type) == "lf") {
      cat_string.push("lf");
    }
    this.livefeedbackCommentSubmit(originalCatButton.parentElement, dialog.querySelector("[id*=':comment']"), cat_string.join(":"), null, timer).finally(() => {
      // Reset
      event.target.value = "";
    });
    if (dialog) {
      dialog.hide();
    }
  }
  student_livefeedbackSubCatClick(_event, _widget) {
    var _subs$_getOptions$fin, _this$et2$getDOMWidge1;
    var content = this.et2.getArrayMgr('content');
    var parentCatId = _widget.id.split(':')[0];
    var self = this;
    var subs = this.et2.getDOMWidgetById(parentCatId + ':subs');
    var ids = subs !== null && subs !== void 0 && subs.value ? [parentCatId, subs.value] : [parentCatId];
    var cat = (_subs$_getOptions$fin = subs === null || subs === void 0 ? void 0 : subs._getOptions().find(o => o.value == subs.value)) !== null && _subs$_getOptions$fin !== void 0 ? _subs$_getOptions$fin : {};
    var mark = this.et2.getDOMWidgetById("flag");
    var main = this.et2.getDOMWidgetById(ids[0]);
    var description = (_this$et2$getDOMWidge1 = this.et2.getDOMWidgetById(ids[0] + ':comment')) !== null && _this$et2$getDOMWidge1 !== void 0 ? _this$et2$getDOMWidge1 : this.et2.getDOMWidgetById("flag:comment");
    if (ids) {
      var _cat$data2, _mark$value, _main$value;
      var timer = this.et2.getDOMWidgetById(ids[0] + ':timer');
      this.livefeedbackCommentSubmit(main.parentElement, description, ids.join(":") + ((cat === null || cat === void 0 || (_cat$data2 = cat.data) === null || _cat$data2 === void 0 ? void 0 : _cat$data2.type) == "lf" ? ":lf" : ""), (_mark$value = mark === null || mark === void 0 ? void 0 : mark.value) !== null && _mark$value !== void 0 ? _mark$value : null, timer, main === null || main === void 0 || (_main$value = main.value) === null || _main$value === void 0 || (_main$value = _main$value.cat_color) === null || _main$value === void 0 ? void 0 : _main$value.replace('#', '')).finally(() => {
        subs.value = '';
      });
    }
  }

  /**
   * Add a livefeedback comment
   * @param cat_string <category ID > [: <sub-category ID>] [ : lf ] | 'free'
   * @param time of the comment in seconds
   * @param timer_widget Label for category that counts down cooldown
   */
  livefeedbackCommentSubmit(main_cat_widget, comment_widget, cat_string, time, timer_widget, color) {
    var _comment_widget$value, _ref, _ref2, _this$et2$getDOMWidge10;
    var mark = this.et2.getDOMWidgetById("flag");
    var content = this.et2.getArrayMgr('content');

    // Livefeedback comments are distinguished from other comments by the ":lf" or ":lfc" suffix, it's required
    if (!cat_string.endsWith(":lf") && !cat_string.endsWith(":lfc")) {
      cat_string += ":lfc";
    }
    return this.egw.request('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_livefeedbackSaveComment', [this.et2.getInstanceManager().etemplate_exec_id, {
      // send action and text to server-side to be able to do a proper ACL checks
      action: 'add',
      course_id: content.data.video.livefeedback.course_id,
      video_id: content.data.video.livefeedback.video_id,
      text: (_comment_widget$value = comment_widget === null || comment_widget === void 0 ? void 0 : comment_widget.value) !== null && _comment_widget$value !== void 0 ? _comment_widget$value : " ",
      comment_color: color,
      comment_starttime: (_ref = (_ref2 = time !== null && time !== void 0 ? time : mark === null || mark === void 0 ? void 0 : mark.value) !== null && _ref2 !== void 0 ? _ref2 : (_this$et2$getDOMWidge10 = this.et2.getDOMWidgetById("lf_timer")) === null || _this$et2$getDOMWidge10 === void 0 ? void 0 : _this$et2$getDOMWidge10.value) !== null && _ref !== void 0 ? _ref : "",
      comment_stoptime: null,
      comment_marked: '',
      comment_cat: cat_string
    }]).then(_data => {
      if ((_data === null || _data === void 0 ? void 0 : _data.session) === 'ended') {
        return self.et2.getInstanceManager().submit();
      }

      // Disable for a certain interval
      var interval = content.getEntry('video')['livefeedback']['session_interval'] ? parseInt(content.getEntry('video')['livefeedback']['session_interval']) * 1000 : 2000;

      // Clear the comment widget
      if (comment_widget) {
        comment_widget.value = '';
        delete comment_widget.dataset.starttime;
      }

      // Clear all blocked categories when marked time is cleared
      if (mark !== null && mark !== void 0 && mark.value) {
        mark === null || mark === void 0 || mark.addEventListener("clear", e => {
          // Clear blocked categories
          this.et2.getDOMNode().querySelectorAll('.commentRadioBoxArea et2-vbox').forEach(vbox => {
            vbox.classList.remove("disabled");
          });
        }, {
          once: true
        });
      }

      // Clear the marked time (with default timer, set when we marked the time)
      mark === null || mark === void 0 || mark.clearMark();
      if (timer_widget) {
        main_cat_widget.classList.add('disabled');
        timer_widget.set_disabled(false);
        var c = interval / 1000;
        timer_widget.value = c;
        var counter = setInterval(_ => {
          c--;
          timer_widget.value = "".concat(c);
        }, 1000);
        setTimeout(_ => {
          // Wait a bit to clear categories if time is marked
          if (!(mark !== null && mark !== void 0 && mark.value)) {
            main_cat_widget.classList.remove('disabled');
          }
          clearInterval(counter);
          timer_widget.set_disabled(true);
        }, interval);
      }
    });
  }
  student_livefeedbackSession() {
    var recorder = this.et2.getDOMWidgetById('lf_recorder');
    var publish = this.et2.getWidgetById('publish_box');
    var isPublished = this.et2.getArrayMgr('content').getEntry('video').video_published == 1 ? true : false;
    publish.hidden = !this.is_staff || isPublished;
    recorder.disabled = !this.is_staff || egwIsMobile() || !isPublished;
  }
  student_livefeedbackReport() {
    var lf_comments_slider = this.et2.getDOMWidgetById('lf_comments_slider');
    lf_comments_slider.comments = this.comments;
  }
  pushLivefeedback(_data) {
    var videos = this.et2.getWidgetById('video2');
    if (_data && _data.acl.data) {
      if (_data.acl.data['session_starttime']) {
        videos.value = _data.acl.data['video_id'];
        this.et2.getInstanceManager().submit();
      } else if (videos.value != _data.acl.data['video_id']) {
        egw$1.open(_data.acl.data['video_id'], 'smallpart-video', 'view', {}, '_self', 'smallpart');
      }
    }
  }
  student_livefeedbackReportfullSize(event, button) {
    var details = document.getElementsByClassName('livefeedbackReport');
    details[0].addEventListener('sl-hide', _ => {
      details[0].classList.remove('fullscreen');
    });
    if (details[0].classList.contains('fullscreen')) {
      details[0].classList.remove('fullscreen');
      button.image = "fullscreen";
    } else {
      details[0].addEventListener('sl-hide', _ => {
        details[0].classList.remove('fullscreen');
      });
      details[0].classList.add('fullscreen');
      button.image = "fullscreen-exit";
    }
  }
  student_commentCatChanged(_ev, _widget) {
    var commentCatSub = _widget.getParent().getWidgetById('comment_cat_sub');
    if (commentCatSub) {
      commentCatSub.disabled = !_widget.value || _widget.value.trim() == "free";
      commentCatSub.onlySubs = _widget.value;
      commentCatSub.requestUpdate('disabled');
    }

    // Block saving of comments as long as no main category is selected
    var saveButton = this.commentGrid.getWidgetById("saveAndContinue");
    if (saveButton) {
      saveButton.disabled = !_widget.value;
      _widget.set_validation_error(saveButton.disabled ? this.egw.lang("Select category") : false);
    }
  }
  livefeedback_publishBtn(_event, _widget) {
    var video = this.et2.getArrayMgr('content').getEntry('video');
    var counter = this.et2.getWidgetById('counter');
    var lf_timer = this.et2.getWidgetById('lf_timer');
    counter.value = 15;
    _widget.disabled = true;
    this.egw.request('smallpart.\\EGroupware\\SmallParT\\Student\\Ui.ajax_livefeedbackPublishVideo', video['video_id']).then(_ => {});
    var timer = setInterval(_ => {
      counter.value = counter.value - 1;
      if (counter.value <= 0) {
        lf_timer.disabled = false;
        clearInterval(timer);
        _widget.getInstanceManager().submit(null, false, true);
      }
    }, 1000);
  }

  /**
   * Install an onchange handler to save answers directly, when the user gives/changes them
   */
  installSaveAnswerOnChange() {
    var grid = this.et2.getWidgetById('questions');
    if (!grid) return;
    grid.iterateOver(widget => {
      widget.onchange = this.saveAnswerOnChange;
    }, null, et2_IInput);
  }

  /**
   * Save answers directly, when the user gives/changes them
   *
   * @param ev
   * @param widget
   */
  saveAnswerOnChange(ev, widget) {
    var tr = widget.getDOMNode();
    var overlay_id_match = /^smallpart:overlay:(\d+)$/;
    while (tr.nodeName !== 'TR' || !tr.id || !overlay_id_match.exec(tr.id)) {
      if (!(tr = tr.parentNode)) return;
    }
    var template = widget;
    while (template.getType() !== 'ET2-TEMPLATE') {
      if (!(template = template.getParent())) return;
    }
    var data = Object.values(widget.getInstanceManager().getValues(template)['questions']).shift();
    data.overlay_id = overlay_id_match.exec(tr.id)[1];
    data.video_id = widget.getRoot().getValueById('videos');
    egw$1.request('smallpart.\\EGroupware\\SmallParT\\Questions.ajax_answer', [data]).then(response => {
      var _response$answer_data;
      if (response.error && widget.nodeName === 'ET2-CHECKBOX') {
        widget.value = !widget.value;
        return;
      }
      if (response.summary) {
        var _widget$getRoot$getWi2;
        (_widget$getRoot$getWi2 = widget.getRoot().getWidgetById('question_summary')) === null || _widget$getRoot$getWi2 === void 0 || _widget$getRoot$getWi2.set_value(response.summary);
      }
      if (typeof ((_response$answer_data = response.answer_data) === null || _response$answer_data === void 0 ? void 0 : _response$answer_data.answer_label) !== 'undefined') {
        var description = widget.getParent().getParent().getWidgetById('answer_data[answer_label]');
        if (description) {
          description.value = response.answer_data.answer_label;
          description.style.backgroundColor = response.answer_data.color || '';
        }
      }
    });
  }

  /**
   * Change handler to filter videos/material on start-page
   */
  filterVideos(ev, widget) {
    var _this$et6;
    var reg_exp = new RegExp(widget.value, 'i');
    (_this$et6 = this.et2) === null || _this$et6 === void 0 || _this$et6.getWidgetById('videos').getDOMNode().querySelectorAll('tr').forEach(tr => {
      var match = true;
      if (widget.value === '' || widget.value.startsWith('videoStatus')) {
        match = widget.value === '' || tr.classList.contains(widget.value);
      } else {
        match = Array.from(tr.querySelectorAll('et2-description')).some(description => description.innerText.match(reg_exp));
      }
      tr.style.display = match ? '' : 'none';
    });
  }

  /**
   * Call document merge for given id or current video
   *
   * @param string _id "smallpart::$course_id:$video_id", default current video
   */
  mergeVideo(_id) {
    return _asyncToGenerator(function* () {
      var that = app.smallpart; // not sure why this is not defined/the window, binding it in the constructor also did not help :(
      if (!_id || typeof _id !== 'string' || !_id.startsWith('smallpart::')) {
        _id = 'smallpart::' + that.filter.course_id + ':' + that.filter.video_id;
      }
      return that.mergeAction({
        data: {
          merge_data: {
            menuaction: 'smallpart.EGroupware\\Vidopro\\Merge.merge_entries',
            merge: 'EGroupware\\Vidopro\\Merge',
            directory: '/templates/smallpart'
          }
        }
      }, [{
        id: _id
      }]);
    })();
  }

  /**
   * Edit video in new video-edit dialog
   */
  editVideo() {
    egw$1.open(this.filter.video_id, 'smallpart-video', 'edit', '', 'smallpart');
  }
}
_defineProperty(smallpartApp, "appname", 'smallpart');
_defineProperty(smallpartApp, "default_color", 'ffffff');
// white = neutral
_defineProperty(smallpartApp, "commentRowsQuery", 'tr.row.commentBox');
_defineProperty(smallpartApp, "playControlBar", 'play_control_bar');
/**
 * Forbid students to comment
 */
_defineProperty(smallpartApp, "COMMENTS_FORBIDDEN_BY_STUDENTS", 4);
/**
 * Disable comments, eg. for tests
 */
_defineProperty(smallpartApp, "COMMENTS_DISABLED", 5);
/**
 * Show everything withing the group plus staff
 */
_defineProperty(smallpartApp, "COMMENTS_GROUP", 6);
/**
 * Show comments within the group, but hide teachers
 */
_defineProperty(smallpartApp, "COMMENTS_GROUP_HIDE_TEACHERS", 7);
/**
 * Post Cognitive Load Measurement Type
 */
_defineProperty(smallpartApp, "CLM_TYPE_POST", 'post');
/**
 * Process Cognitive Load Measurement Type
 */
_defineProperty(smallpartApp, "CLM_TYPE_PROCESS", 'process');
/**
 * stop time type for Cognitive Load Measurement
 */
_defineProperty(smallpartApp, "CLM_TYPE_STOP", 'stop');
/**
 * stop time type for Cognitive Load Measurement
 */
_defineProperty(smallpartApp, "CLM_TYPE_UNLOAD", 'unload');
/**
 * Learning ("L") response time type for Cognitive Load Measurement
 */
_defineProperty(smallpartApp, "CLM_TYPE_LEARNING", 'learning');
app.classes.smallpart = smallpartApp;

export { smallpartApp };
//# sourceMappingURL=app.min.js.map
